/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.ts;

import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.Trap;
import com.googlecode.dex2jar.ir.Value;
import com.googlecode.dex2jar.ir.ValueBox;
import com.googlecode.dex2jar.ir.expr.Exprs;
import com.googlecode.dex2jar.ir.stmt.JumpStmt;
import com.googlecode.dex2jar.ir.stmt.LabelStmt;
import com.googlecode.dex2jar.ir.stmt.LookupSwitchStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.stmt.StmtList;
import com.googlecode.dex2jar.ir.stmt.Stmts;
import com.googlecode.dex2jar.ir.stmt.TableSwitchStmt;
import com.googlecode.dex2jar.ir.ts.Transformer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;

public class TopologicalSort
implements Transformer {
    @Override
    public void transform(IrMethod irMethod) {
        if (irMethod.traps.size() > 0) {
            return;
        }
        StmtList stmts = irMethod.stmts;
        this.init(stmts, irMethod.traps);
        this.removeLoop(stmts);
        List<Stmt> out = this.topologicalSort(stmts);
        stmts.clear();
        this.rebuild(stmts, out);
    }

    private void rebuild(StmtList stmts, List<Stmt> out) {
        ArrayList gotos = new ArrayList();
        for (int i = 0; i < out.size(); ++i) {
            Stmt stmt = out.get(i);
            stmts.add(stmt);
            Stmt orgNext = stmt._ts_default_next;
            if (orgNext == null || orgNext.st != Stmt.ST.LABEL) continue;
            if (i + 1 < out.size()) {
                Stmt next = out.get(i + 1);
                if (next == orgNext) continue;
                if (stmt.st == Stmt.ST.IF) {
                    JumpStmt jumpStmt = (JumpStmt)stmt;
                    if (jumpStmt.target == next) {
                        this.reverseIF(jumpStmt.op);
                        jumpStmt.target = (LabelStmt)orgNext;
                        continue;
                    }
                    JumpStmt gotoStmt = Stmts.nGoto((LabelStmt)orgNext);
                    stmts.add(gotoStmt);
                    continue;
                }
                JumpStmt gotoStmt = Stmts.nGoto((LabelStmt)orgNext);
                stmts.add(gotoStmt);
                continue;
            }
            JumpStmt gotoStmt = Stmts.nGoto((LabelStmt)orgNext);
            stmts.add(gotoStmt);
        }
        block1: for (JumpStmt gotoStmt : gotos) {
            Stmt t = gotoStmt.getNext();
            while (t.st == Stmt.ST.LABEL) {
                if (t == gotoStmt.target) {
                    stmts.remove(gotoStmt);
                    continue block1;
                }
                t = t.getNext();
            }
        }
    }

    private List<Stmt> topologicalSort(StmtList stmts) {
        ArrayList<Stmt> out = new ArrayList<Stmt>(stmts.getSize());
        Stack<Stmt> stack = new Stack<Stmt>();
        stack.push(stmts.getFirst());
        boolean visitedFlag = false;
        while (!stack.empty()) {
            Stmt stmt = (Stmt)stack.pop();
            if (stmt._cfg_visited == visitedFlag || stmt._cfg_froms.size() != 0 && stack.size() != 0) continue;
            stmt._cfg_visited = visitedFlag;
            out.add(stmt);
            for (Stmt t : stmt._ts_tos) {
                t._cfg_froms.remove(stmt);
                if (t._cfg_visited == visitedFlag) continue;
                stack.push(t);
            }
        }
        return out;
    }

    private void removeLoop(StmtList stmts) {
        this.dfsRemove(stmts.getFirst(), new HashSet<Stmt>());
    }

    private void dfsRemove(Stmt stmt, Set<Stmt> visited) {
        visited.add(stmt);
        for (Stmt to : new ArrayList<Stmt>(stmt._ts_tos)) {
            if (visited.contains(to)) {
                to._cfg_froms.remove(stmt);
                while (stmt._ts_tos.remove(to)) {
                }
                continue;
            }
            if (to._cfg_visited) continue;
            this.dfsRemove(to, visited);
        }
        visited.remove(stmt);
        stmt._cfg_visited = true;
    }

    private static void link(Stmt from, Stmt to) {
        if (to == null) {
            return;
        }
        from._ts_tos.add(to);
        to._cfg_froms.add(from);
    }

    private void init(StmtList stmts, List<Trap> traps) {
        Stmt stmt;
        block14: for (stmt = stmts.getFirst(); stmt != null; stmt = stmt.getNext()) {
            switch (stmt.st) {
                case IF: {
                    Stmt n = stmt.getNext();
                    if (n != null && n.st != Stmt.ST.LABEL) {
                        LabelStmt ls = Stmts.nLabel();
                        stmts.insertAftre(stmt, ls);
                    }
                    stmt._ts_default_next = stmt.getNext();
                    continue block14;
                }
                case GOTO: 
                case RETURN: 
                case RETURN_VOID: 
                case TABLE_SWITCH: 
                case LOOKUP_SWITCH: 
                case THROW: {
                    stmt._ts_default_next = null;
                    continue block14;
                }
                default: {
                    stmt._ts_default_next = stmt.getNext();
                }
            }
        }
        for (stmt = stmts.getFirst(); stmt != null; stmt = stmt.getNext()) {
            if (stmt._cfg_froms == null) {
                stmt._cfg_froms = new TreeSet<Stmt>(stmts);
            } else {
                stmt._cfg_froms.clear();
            }
            if (stmt._ts_tos == null) {
                stmt._ts_tos = new ArrayList<Stmt>(2);
                continue;
            }
            stmt._ts_tos.clear();
        }
        for (Trap t : traps) {
            for (Stmt s = t.start; s != t.end; s = s.getNext()) {
                TopologicalSort.link(s, t.handler);
            }
        }
        block18: for (stmt = stmts.getFirst(); stmt != null; stmt = stmt.getNext()) {
            switch (stmt.st) {
                case GOTO: {
                    TopologicalSort.link(stmt, ((JumpStmt)stmt).target);
                    continue block18;
                }
                case IF: {
                    TopologicalSort.link(stmt, ((JumpStmt)stmt).target);
                    TopologicalSort.link(stmt, stmt.getNext());
                    continue block18;
                }
                case LOOKUP_SWITCH: {
                    LookupSwitchStmt lss = (LookupSwitchStmt)stmt;
                    TopologicalSort.link(stmt, lss.defaultTarget);
                    for (LabelStmt ls : lss.targets) {
                        TopologicalSort.link(stmt, ls);
                    }
                    continue block18;
                }
                case TABLE_SWITCH: {
                    TableSwitchStmt tss = (TableSwitchStmt)stmt;
                    TopologicalSort.link(stmt, tss.defaultTarget);
                    for (LabelStmt ls : tss.targets) {
                        TopologicalSort.link(stmt, ls);
                    }
                    continue block18;
                }
                case RETURN: 
                case RETURN_VOID: 
                case THROW: {
                    continue block18;
                }
                default: {
                    TopologicalSort.link(stmt, stmt.getNext());
                }
            }
        }
        for (stmt = stmts.getFirst(); stmt != null; stmt = stmt.getNext()) {
            stmt._cfg_visited = false;
            switch (stmt.st) {
                case GOTO: {
                    JumpStmt js = (JumpStmt)stmt;
                    for (Stmt f : stmt._cfg_froms) {
                        f._ts_tos.remove(stmt);
                        f._ts_tos.addAll(stmt._ts_tos);
                        f._ts_default_next = js.target;
                    }
                    for (Stmt t : stmt._ts_tos) {
                        t._cfg_froms.remove(stmt);
                        t._cfg_froms.addAll(stmt._cfg_froms);
                    }
                    break;
                }
            }
            Collections.reverse(stmt._ts_tos);
        }
    }

    private void reverseIF(ValueBox op) {
        Value.E2Expr e2 = (Value.E2Expr)op.value;
        switch (e2.vt) {
            case GE: {
                op.value = Exprs.nLt(e2.op1.value, e2.op2.value);
                break;
            }
            case GT: {
                op.value = Exprs.nLe(e2.op1.value, e2.op2.value);
                break;
            }
            case LT: {
                op.value = Exprs.nGe(e2.op1.value, e2.op2.value);
                break;
            }
            case LE: {
                op.value = Exprs.nGt(e2.op1.value, e2.op2.value);
                break;
            }
            case EQ: {
                op.value = Exprs.nNe(e2.op1.value, e2.op2.value);
                break;
            }
            case NE: {
                op.value = Exprs.nEq(e2.op1.value, e2.op2.value);
            }
        }
    }
}

