local parent, ns = ...
local oUF = WSUF.oUF
local utils = ns.utils
local L = WSUF.L
local Tags = WSUF.Tags
local db = WSUF.db.profile
local style = ns.style
----
local position = ns:RegisterUnitPosition("party",{
	selfPoint = "TOPLEFT", 
	anchorTo = "UIParent", 
	relativePoint = "TOPLEFT", 
	x = "20", 
	y = "-150"
})
--
local unitdb = ns:RegisterUnitDB("party",{
			enabled = true, 
			showPartyPet = true, 
			showInRaid = true, 
			combatfeedback = true,
			showPartyPet = true,
			castbar = false, 
			sidebar = true, 
			Auras = false, 
			auracooldown = true, 
			castbyme = true, 
			parent = {
				width = 128,
				height = 53,
				scale = 1,
				attribPoint = "TOP",
				attribAnchorPoint = "LEFT",
				unitsPerColumn = 5,
				columnSpacing = 40,
				offset = 10,
				spacing = 2,

			},
			tags = {
				lvl = { tag = "[levelcolor]" },
				name = { tag = "[colorname]" },
				hp = { tag = "[hp:color][smart:curmaxhp][close]"},
				mp = { tag = "[smart:curmaxpp]"},
				pcthp = { tag = "[hp:color][perhp][close]"},
				pctmp = { tag = ""},
			},
			
})

for i = 1, 4, 1 do
	local pt = _G["PartyMemberFrame"..i]
	if i == 1 then
		pt:SetPoint(position.selfPoint, _G[position.anchorTo], position.relativePoint, position.x, position.y)
	end
	local tagHP = pt:CreateFontString("PartyMemberFrame"..i.."TagHP","OVERLAY")
	tagHP:SetFontObject(ChatFontNormal)
	local font,size,flag = tagHP:GetFont()
	tagHP:SetFont(font,9,"OUTLINE")
	tagHP:SetPoint("TOPLEFT",pt,"TOPRIGHT",0,-10)
	tagHP:SetText(string.format("%s/%s",UnitHealth("party"..i),UnitHealthMax("party"..i)))
	tagHP:SetTextColor(0,1,0)
	local hpBar = _G["PartyMemberFrame"..i.."HealthBar"]
	hpBar:SetScript("OnEnter",function() end)
	local perhp = hpBar:CreateFontString("PartyMemberFrame"..i.."PerHP","OVERLAY")
	perhp:SetFontObject(ChatFontNormal)
	local font,size,flag = perhp:GetFont()
	perhp:SetFont(font,9,"OUTLINE")
	perhp:SetPoint("CENTER",hpBar)
	perhp:SetTextColor(0,1,0)
	perhp:SetText(string.format("%s%%",math.floor(UnitHealth("party"..i)/UnitHealthMax("party"..i)*100+.5)))
	local mpBar = _G["PartyMemberFrame"..i.."ManaBar"] 
	mpBar:SetScript("OnEnter",function() end)
	local tagMP = mpBar:CreateFontString("PartyMemberFrame"..i.."TagMP","OVERLAY")
	tagMP:SetFontObject(ChatFontNormal)
	local font,size,flag = tagMP:GetFont()
	tagMP:SetFont(font,9,"OUTLINE")
	tagMP:SetPoint("TOPLEFT",pt,"TOPRIGHT",0,-22)
	tagMP:SetText(string.format("%s/%s",UnitPower("party"..i),UnitPowerMax("party"..i)))

	local ptName = _G["PartyMemberFrame"..i.."Name"]
	if ptName then
		local font,size,flag = ptName:GetFont()
		ptName:SetFont(font,11,"OUTLINE")
		local class = select(2,UnitClass("party"..i))
		if class then
			local r,g,b = RAID_CLASS_COLORS[class].r,RAID_CLASS_COLORS[class].g,RAID_CLASS_COLORS[class].b
			ptName:SetTextColor(r,g,b)
		end

	end
	local partyTargetFrame = CreateFrame("Button","PartyMemberFrame"..i.."Target",pt,"SecureUnitButtonTemplate")
	partyTargetFrame:RegisterForClicks("AnyUp")
	SecureUnitButton_OnLoad(partyTargetFrame,"party"..i.."target")
	RegisterUnitWatch(partyTargetFrame)

	partyTargetFrame:SetSize(60,16)
	partyTargetFrame:SetPoint("TOPLEFT", pt, "TOPRIGHT",10,10)
	local ptfHP = CreateFrame("StatusBar","PartyMemberFrame"..i.."TargetHealthBar",partyTargetFrame)
	ptfHP:SetStatusBarTexture[[Interface\AddOns\Wowshell_UnitFrames\media\textures\smooth]]
	ptfHP:SetSize(60,16)
	ptfHP:SetPoint("TOPLEFT",partyTargetFrame)
	local min, max = UnitHealth("party"..i.."target"),UnitHealthMax("party"..i.."target")
	ptfHP:SetMinMaxValues(0,max)
	ptfHP:SetValue(min)
	ptfHP:SetStatusBarColor(0,1,0)
	ptfHP.__self = ptfHP
	local bg = ptfHP:CreateTexture(nil, 'OVERLAY')
	bg:SetTexture[[Interface\Tooltips\UI-StatusBar-Border]]
	bg:SetPoint('TOPLEFT', -2, 2)
	bg:SetPoint('BOTTOMRIGHT', 2, -2)
	ptfHP.framebg = bg
	local ptfHPName = ptfHP:CreateFontString("PartyMemberFrame"..i.."TargetName","OVERLAY")
	ptfHPName:SetFontObject(ChatFontNormal)
	local font,size,flag = ptfHPName:GetFont()
	ptfHPName:SetFont(font,10,"OUTLINE")
	ptfHPName:SetPoint("BOTTOM",ptfHP,"TOP",0,5)
	ptfHPName:SetText(UnitName("party"..i.."target"))
	local ptfPerHp = ptfHP:CreateFontString("PartyMemberFrame"..i.."TargetPerHP","OVERLAY")	
	ptfPerHp:SetFont(font,11,"OUTLINE")
	ptfPerHp:SetPoint("CENTER",ptfHP)
	ptfPerHp:SetText(string.format("%s%%",math.floor(UnitHealth("party"..i.."target")/UnitHealthMax("party"..i.."target")*100+.5)))
	partyTargetFrame:Show()
	partyTargetFrame:SetAlpha(0)
end

hooksecurefunc("PartyMemberFrame_UpdateMember",function(self)
	local color = RAID_CLASS_COLORS[select(2, UnitClass(self.unit))]
	if not color then 
		color = NORMAL_FONT_COLOR 
	end
	self.name:SetTextColor(color.r, color.g, color.b)
end)

local handler = CreateFrame("Frame")
handler.nextUpdate = 0
handler:RegisterEvent("PLAYER_LOGIN")
handler:RegisterEvent("PLAYER_ENTERING_WORLD")
handler:RegisterEvent("ZONE_CHANGED_NEW_AREA")
handler:RegisterEvent("VARIABLES_LOADED")
handler:RegisterEvent("UNIT_HEALTH")
handler:RegisterEvent("UNIT_MAXHEALTH")
handler:RegisterEvent("GROUP_ROSTER_UPDATE")
handler:RegisterEvent("UNIT_TARGET")
handler:SetScript("OnUpdate", function(self, elapsed)
	self.nextUpdate = self.nextUpdate + elapsed
	if(self.nextUpdate >=0.5) then
		if UnitInParty("player") then
			for i = 1, GetNumSubgroupMembers() do
				local isInRange = UnitInRange("party"..i)
				local isConnected = UnitIsConnected("party"..i)
				local partyFrame = _G["PartyMemberFrame"..i]
				if(isInRange and isConnected) then
					partyFrame:SetAlpha(1.0)
				else
					partyFrame:SetAlpha(0.5)
				end
			end
		end
	end
end)

handler:SetScript("OnEvent",function(self,event,...)
	if UnitInParty("player") then
		for i = 1, 4, 1 do
			if _G["PartyMemberFrame"..i] then
			local tagHP = _G["PartyMemberFrame"..i.."TagHP"]
			if tagHP then
				tagHP:SetText(string.format("%s/%s",UnitHealth("party"..i),UnitHealthMax("party"..i)))
			end
			local perhp = _G["PartyMemberFrame"..i.."PerHP"]
			if perhp then
				perhp:SetText(string.format("%s%%",math.floor(UnitHealth("party"..i)/UnitHealthMax("party"..i)*100+.5)))
			end
			local tagMP = _G["PartyMemberFrame"..i.."TagMP"]
			if tagMP then
				tagMP:SetText(string.format("%s/%s",UnitPower("party"..i),UnitPowerMax("party"..i)))
			end
			local ptfHP = _G["PartyMemberFrame"..i.."TargetHealthBar"]
			if ptfHP then
				local min,max = UnitHealth("party"..i.."target"),UnitHealthMax("party"..i.."target") 
				ptfHP:SetMinMaxValues(0,max)
				ptfHP:SetValue(min)
				if(UnitIsEnemy('player', "party"..i.."target")) then
					ptfHP:SetStatusBarColor(1, .55, .72)
					ptfHP.__self.framebg:SetVertexColor(1, .2, .2)
					ptfHP:SetStatusBarColor(1, 0, 0)
					ptfHP.__self.framebg:SetVertexColor(1, .2, .2)
				elseif(UnitIsFriend('player', "party"..i.."target")) then
					ptfHP:SetStatusBarColor(1, 1, 1)
					ptfHP.__self.framebg:SetVertexColor(1, 1, 1)
					ptfHP:SetStatusBarColor(0, 1, 0)
					ptfHP.__self.framebg:SetVertexColor(0, 1, 0)
				else
					ptfHP:SetStatusBarColor(.65, .9, .85)
					ptfHP.__self.framebg:SetVertexColor(.9, .82, 0)
					ptfHP:SetStatusBarColor(1, 1, 0)
					ptfHP.__self.framebg:SetVertexColor(.9, .82, 0)
				end
			end

			local ptfHPName = _G["PartyMemberFrame"..i.."TargetName"]	

			if ptfHPName then
				ptfHPName:SetText(UnitName("party"..i.."target"))
			end

			local ptfPerHp = _G["PartyMemberFrame"..i.."TargetPerHP"]
			if ptfPerHp then
				ptfPerHp:SetText(string.format("%s%%",math.floor(UnitHealth("party"..i.."target")/UnitHealthMax("party"..i.."target")*100+.5)))
			end
		end
		end
	end
end)
hooksecurefunc("PartyMemberFrame_OnUpdate", function(self,elapsed)
	local i = self:GetID()
	self.timer = (self.timer or 0) + elapsed
	if self.timer >= 0.2 then
		local unit = "party"..i.."target"
		local partyTargetFrame = _G["PartyMemberFrame"..i.."Target"]
		if UnitExists(unit) then
			partyTargetFrame:SetAlpha(1)
		else
			partyTargetFrame:SetAlpha(0)	
		end
		self.timer = 0
	end
end)
--

----
----local CreateObjects = function(self,unit)
----	self.nextUpdate = 0
----	self.bg = CreateFrame("Frame",nil,self) 
----	self.bg:SetFrameStrata("BACKGROUND")	
----	self.Health = CreateFrame("StatusBar",nil,self)
----	self.Power = CreateFrame("StatusBar",nil,self)
----	self.frametexture = self.Health:CreateTexture(nil,"OVERLAY")
----	self.frametexture_sidebar = self.Health:CreateTexture(nil,"OVERLAY")
----	self.Portrait = self:CreateTexture(nil,"ARTWORK")
----	self.portrait_3d = CreateFrame("PlayerModel",nil,self)
----	self.overlay = CreateFrame("Frame",nil,self.Health)
----	self.PvP = self.overlay:CreateTexture(nil,"OVERLAY")
----	self.Leader = self.overlay:CreateTexture(nil,"OVERLAY")
----	self.MasterLooter = self.overlay:CreateTexture(nil,"OVERLAY")
----	self.VehicleTexture = self.Health:CreateTexture(nil,"BORDER")
----	self.RaidIcon = self.Health:CreateTexture(nil,"OVERLAY")
----	self.CombatFeedbackText = self:CreateFontString(nil,"OVERLAY")
----	self.Threat = self.Health:CreateTexture(nil,"BACKGROUND")
----	self.LFDRole = self.Health:CreateTexture(nil,"OVERLAY")
----	self.Auras = CreateFrame("Frame",nil,self)
----	self.Castbar = CreateFrame("StatusBar",nil,self)
----end
----
----local dropdown = CreateFrame("Frame", "MyAddOnUnitDropDownMenu",UIParent,"UIDropDownMenuTemplate")
----UIDropDownMenu_Initialize(dropdown, function(self)
----	local unit = self:GetParent().unit
----	if not unit then return end
----
----	local menu, name, id
----	if UnitIsUnit(unit, "player") then
----		menu = "SELF"
----	elseif UnitIsUnit(unit, "vehicle") then
----		menu = "VEHICLE"
----	elseif UnitIsUnit(unit, "pet") then
----		menu = "PET"
----	elseif UnitIsPlayer(unit) then
----		id = UnitInRaid(unit)
----		if id then
----			menu = "RAID_PLAYER"
----			name = GetRaidRosterInfo(id)
----		elseif UnitInParty(unit) then
----			menu = "PARTY"
----		else
----			menu = "PLAYER"
----		end
----	else
----		menu = "TARGET"
----		name = RAID_TARGET_ICON
----	end
----	if menu then
----		UnitPopup_ShowMenu(self, menu, unit, name, id)
----	end
----end, "MENU")
----
----local menu = function(self)
----	dropdown:SetParent(self)
----	ToggleDropDownMenu(1, nil, dropdown, "cursor", 0, 0)
----end
----
----
----local function Parent(self,unit,dropdown)
----	self.menu = menu 
----	self:SetAttribute("*type2", "menu")
----	self:RegisterForClicks"AnyUp"
----	local ModKey = 'shift'
----	local MouseButton = 1
----	local key = ModKey .. '-type' .. (MouseButton or '')
----	if(self.unit == 'focus') then
----		self:SetAttribute(key,'macro')
----		self:SetAttribute('macrotext', '/clearfocus')
----	else
----		self:SetAttribute(key, 'focus')
----	end
----	if self:GetAttribute("unitsuffix") == "pet" then
----		self:SetSize(60,17)
----		self:SetScale(0.6)
----	elseif self:GetAttribute("unitsuffix") == "target" then
----		self:SetSize(60,16)
----		self:SetScale(1)
----	else
----		self:SetSize(unitdb.parent.width, unitdb.parent.height)
----		self:SetScale(1)
----	end
----end
----
----local function post2D(self,unit)
----	if(UnitIsConnected(unit)) then
----		self.discon:Hide()
----		self:Show()
----	else
----		self:Hide()
----		self.discon:Show()
----	end
----end
----
----local function Portrait(self,unit)
----	local p  = self.Portrait
----	p:SetSize(37,37)
----	p:SetPoint("TOPLEFT",self, "TOPLEFT", 7, -6)
----	local discon = self:CreateTexture(nil,"ARTWORK")
----	p.discon = discon
----	discon:SetTexture[[Interface\CharacterFrame\Disconnect-Icon]]
----	discon:SetAllPoints(p)
----
----	p.PostUpdate = post2D
----	self.portrait_2d = p
----end
----
----local function Portrait_3D(self,unit)
----	local p = self.portrait_3d 
----	p:SetSize(28,28)
----	p:SetPoint("CENTER",self.portrait_2d, -2,0)
----end
----
----local function postUpdate(bar, unit, min, max)
----    --if(unitdb.colorbyreaction) then
----	if true then
----        if(UnitIsEnemy('player', unit)) then
----            bar:SetStatusBarColor(1, .55, .72)
----            bar.__self.framebg:SetVertexColor(1, .2, .2)
----			bar:SetStatusBarColor(1, 0, 0)
----            bar.__self.framebg:SetVertexColor(1, .2, .2)
----        elseif(UnitIsFriend('player', unit)) then
----            bar:SetStatusBarColor(1, 1, 1)
----            bar.__self.framebg:SetVertexColor(1, 1, 1)
----			bar:SetStatusBarColor(0, 1, 0)
----            bar.__self.framebg:SetVertexColor(0, 1, 0)
----			
----        else
----            bar:SetStatusBarColor(.65, .9, .85)
----            bar.__self.framebg:SetVertexColor(.9, .82, 0)
----			bar:SetStatusBarColor(1, 1, 0)
----            bar.__self.framebg:SetVertexColor(.9, .82, 0)
----        end
----    else
----        bar:SetStatusBarColor(unpack(bar.__self.colors.health))
----    end
----end
----
----
----local function Health(self,unit)
----	if self:GetAttribute("unitsuffix") == "pet" then
----		local hp = self.Health
----
----		local BG = hp:CreateTexture(nil, "OVERLAY")
----		BG:SetTexture[[Interface\Tooltips\UI-StatusBar-Border]]
----		BG:SetPoint("TOPLEFT", -2, 2)
----		BG:SetPoint("BOTTOMRIGHT", 2, -2)
----		self.Health.BG = BG
----		hp:SetSize(70,8)
----		hp:SetPoint("TOPLEFT",self, 0,0)
----		hp.colorHealth = true
----	elseif self:GetAttribute("unitsuffix") == "target" then
----		local hp = self.Health
----		hp:SetPoint('TOPLEFT',self,'TOPLEFT',2,4)
----		hp:SetPoint('BOTTOMRIGHT',self,'BOTTOMRIGHT',-2,4)
----		hp:SetStatusBarTexture[[Interface\TargetingFrame\UI-StatusBar]]
----
----		local bg = self.Health:CreateTexture(nil, 'OVERLAY')
----		bg:SetTexture[[Interface\Tooltips\UI-StatusBar-Border]]
----		bg:SetPoint('TOPLEFT', -2, 2)
----		bg:SetPoint('BOTTOMRIGHT', 2, -2)
----		self.framebg = bg
----		hp.__self = self
----		hp.PostUpdate = postUpdate
----	else
----		local hp = self.Health
----		hp:SetSize(70,8)
----		hp:SetPoint("TOPLEFT",self,47,-12)
----		hp.colorHealth = true
----		hp.frequentUpdates = true
----	end
----end
----
----local function Power(self,unit)
----	if self:GetAttribute("unitsuffix") == "pet" then
----		local mp = self.Power
----		local BG = mp:CreateTexture(nil, "OVERLAY")
----		BG:SetTexture[[Interface\Tooltips\UI-StatusBar-Border]]
----		BG:SetPoint("TOPLEFT", -2, 2)
----		BG:SetPoint("BOTTOMRIGHT", 2, -2)
----		self.Power.BG = BG
----
----		mp:SetSize(70,8)
----		mp:SetPoint("TOPLEFT", self ,0, -10)
----		mp.colorPower = true
----
----	elseif self:GetAttribute("unitsuffix") == "target" then
----
----	else
----		local mp = self.Power
----		mp:SetSize(70,8)
----		mp:SetPoint("TOPLEFT",self,47,-21)
----		mp.colorPower = true
----		mp.frequentUpdates = true
----	end
----end
----
----local function FrameTextrue(self,unit)
----	local tex = self.frametexture
----	tex:SetSize(128,64)
----	tex:SetPoint("TOPLEFT",self,0,-2)
----	tex:SetTexture[[Interface\TargetingFrame\UI-PartyFrame]]
----end
----
----local function FrameTextrue_Sider(self,unit)
----	local side = self.frametexture_sidebar
----	if(unitdb.sidebar) then
----		side:SetWidth(80)
----		side:SetHeight(64)
----	else
----		side:SetWidth(0)
----		side:SetHeight(0)
----	end
----	side:SetPoint("LEFT",self,"RIGHT", -10, -7)
----end
----
----local function SpecialIcon(self,unit)
----	local pvp = self.PvP
----	pvp:SetSize(32,32)
----	pvp:SetPoint("TOPLEFT",self, -9, -15)
----
----	local leader = self.Leader
----	leader:SetSize(16,16)
----	leader:SetPoint("TOPLEFT",self,0,0)
----
----	local looter = self.MasterLooter
----	looter:SetSize(16,16)
----	looter:SetPoint("TOPLEFT",self,32,0)
----
----	local vehicle = self.VehicleTexture
----	vehicle:SetSize(128,64)
----	vehicle:SetPoint("TOPLEFT",self, -4, 6)
----	self.VehicleTextureNormal = self.frametexture
----
----	vehicle.__self = self
----	vehicle.PostUpdate = function(vehicle,event,toggle)
----		local u = vehicle.__self.realUnit
----        if(toggle and u) then
----            if(UnitVehicleSkin(u) == "Natural") then
----                vehicle:SetTexture[[Interface\Vehicles\UI-Vehicles-PartyFrame-Organic]]
----            else
----                vehicle:SetTexture[[Interface\Vehicles\UI-Vehicles-PartyFrame]]
----            end
----        end
----	end
----	local ricon = self.RaidIcon
----	ricon:SetSize(14,14)
----	ricon:SetPoint("CENTER",self,"TOPLEFT",25, -8)
----
----	local cbt = self.CombatFeedbackText
----	cbt:SetPoint("CENTER",self.Portrait)
----	cbt:SetFontObject(NumberFontNormalHuge)
----	do
----		local font, size, flag = cbt:GetFont()
----		cbt:SetFont(font, size-4, flag)
----	end
----	
----	cbt.maxAlpha = .8
----end
----
----local function Threat(self,unit)
----	local threat = self.Threat
----	threat:SetTexture[[Interface\TargetingFrame\UI-PartyFrame-Flash]]
----	threat:SetSize(128,64)
----	threat:SetPoint("TOPLEFT",self, -3,2)
----end
----
----
----local function ClassIcon(self,unit)
----	local button = CreateFrame("Button", nil, self.Health) 
----	button:SetScale(.6)
----	local icon = button:CreateTexture(nil, "ARTWORK")
----	icon.button = button
----	self.ClassIcon = icon
----	icon:SetSize(16,16)
----	icon:SetPoint("CENTER", self, -77, -28)
----
----	local border = button:CreateTexture(nil,"OVERLAY")
----	icon.border = border
----	border:SetSize(45,45)
----	border:SetPoint("TOPLEFT", icon, "TOPLEFT", -5, 6)
----	border:SetTexture[[Interface\MiniMap\MiniMap-TrackingBorder]]
----end
----
----local function LFDRole(self,unit)
----	local icon = self.LFDRole
----	icon:SetSize(16,16)
----	icon:SetPoint("TOPLEFT",self,32,-10)
----end
----
----local function TagFunction(self,unit)
----	WSUF.Module:CreateUnit(self, unit)
----	self.unit = unit
----	local t = self.tags
----    local lvl = self.Health:CreateFontString(nil, "OVERLAY")
----    t.lvl = lvl
----    lvl:SetFontObject(NumberFontNormal)
----    lvl:SetPoint("CENTER",self, -28, -16)
----    lvl:SetTextColor(1, .82, 0)
----	Tags:Register(self, lvl ,unitdb.tags.lvl.tag)
----	lvl:UpdateTags()
----
----	if self:GetAttribute("unitsuffix") == "target" then
----		local name = self.Health:CreateFontString(nil, "OVERLAY")
----		t.name = name
----		name:SetFontObject(ChatFontNormal)
----		name:SetPoint("BOTTOM",self, "TOP", 2, 6)
----		Tags:Register(self, name, '[colorname]')
----		name:UpdateTags()
----
----		local hp = self.Health:CreateFontString(nil, "OVERLAY")
----		t.hp = hp
----		hp:SetFontObject("TextStatusBarText")
----		do
----			local font, size, flag = hp:GetFont()
----			hp:SetFont(font, size-3, flag)
----		end
----		hp:SetPoint("CENTER")
----		Tags:Register(self, hp, '[perhp]')
----		hp:UpdateTags()
----	elseif self:GetAttribute("unitsuffix") == "pet" then
----		--heres do nothing
----	else
----		local name = self.Health:CreateFontString(nil, "OVERLAY")
----		t.name = name
----		name:SetFontObject(ChatFontNormal)
----		name:SetPoint("CENTER",self, 17, 22)
----		Tags:Register(self, name, unitdb.tags.name.tag)
----		name:UpdateTags()
----
----		local hp = self.Health:CreateFontString(nil, "OVERLAY")
----		t.hp = hp
----		hp:SetFontObject("TextStatusBarText")
----		do
----			local font, size, flag = hp:GetFont()
----			hp:SetFont(font, size-3, flag)
----		end
----		hp:SetPoint("CENTER" ,self, 93, 12)
----		Tags:Register(self, hp, unitdb.tags.hp.tag)
----		hp:UpdateTags()
----
----	end
----
----    local mp = self.Power:CreateFontString(nil, "OVERLAY")
----    t.mp = mp
----    mp:SetFontObject("TextStatusBarText")
----    do
----        local font, size, flag = mp:GetFont()
----        mp:SetFont(font, size-3, flag)
----    end
----    mp:SetPoint("CENTER",self, 93, 2)
----		Tags:Register(self, mp, unitdb.tags.mp.tag)
----		mp:UpdateTags()
----
----    local pcthp = self.Health:CreateFontString(nil, "OVERLAY")
----    t.pcthp = pcthp
----    pcthp:SetFontObject("TextStatusBarText")
----    do
----        local font, size, flag = pcthp:GetFont()
----        pcthp:SetFont(font, size-3, flag)
----    end
----    pcthp:SetPoint("CENTER", self.Health)
----		Tags:Register(self, pcthp , unitdb.tags.pcthp.tag)
----		pcthp:UpdateTags()
----
----    local pctmp = self.Power:CreateFontString(nil, "OVERLAY")
----    t.pctmp = pctmp
----    pctmp:SetFontObject("TextStatusBarText")
----    do
----        local font, size, flag = pctmp:GetFont()
----        pctmp:SetFont(font, size-3, flag)
----    end
----    pctmp:SetPoint("CENTER", self.Power)
----		Tags:Register(self, pctmp , unitdb.tags.pctmp.tag)
----		pctmp:UpdateTags()
----
----	end
----
----local function post(icons, button)
----    local font, size, flag = button.count:GetFont()
----    button.count:SetFont(STANDARD_TEXT_FONT, 8, flag)
----    button.oufaura = true
----
----    button.cd:SetDrawEdge(true)
----    button.cd:SetReverse(true)
----end
----
----local function postUpdateIcon(icons, unit, icon, index, offset)
----    utils.postAuraUpdateCooldown(icons, unit, icon, index, offset, unitdb.auracooldown, unitdb.castbyme)
----end
----
----local function Auras(self, unit)
----  local Auras = self.Auras 
----	Auras.showDebuffType = true
----	Auras.postCreateIcon = post
----	Auras.size = 19
----	Auras.num = 18
----	Auras.spacing = 2
----	Auras.numBuffs = 9
----	Auras.gap = true
----	Auras.initialAnchor = "TOPLEFT"
----	Auras["growth-x"] = "RIGHT"
----	Auras["growth-y"] = "DOWN"
----	Auras:SetWidth(180)
----	Auras:SetHeight(40)
----	Auras:SetPoint("TOPLEFT", self, "BOTTOMLEFT", 0, 5)
----	Auras.PostUpdateIcon = postUpdateIcon
----	Auras.__own = self
----	
----	if not unitdb.Auras then
----		self.Auras:Hide()
----	end
----end
----
----local function CastBar(self,unit)
----	local bar = self.Castbar
----	bar:SetScale(0.8)
----		if unitdb.showPartyPet then 
----			bar:SetPoint("TOPLEFT", self, "BOTTOMLEFT", 150, 25)
----		else	
----			bar:SetPoint("TOPLEFT", self, "BOTTOMLEFT", 80, 25)
----		end
----    bar.__own = self
----
----    utils.setSize(bar, 150, 10)
----    bar:SetStatusBarTexture[[Interface\TargetingFrame\UI-StatusBar]]
----    bar:SetStatusBarColor(1, .7, 0)
----
----    local icon = bar:CreateTexture(nil, "ARTWORK")
----    bar.Icon = icon
----    utils.setSize(icon, 16)
----    icon:SetTexture[[Interface\Icons\Spell_Shaman_Hex]]
----    icon:SetPoint("RIGHT", bar, "LEFT", -4, 0)
----
----    local border = bar:CreateTexture(nil, "ARTWORK")
----    bar.Border = border
----    utils.setSize(border, 200, 52)
----    border:SetTexture[[Interface\CastingBar\UI-CastingBar-Border-Small]]
----    border:SetPoint("CENTER", bar)
----
----    local shield = bar:CreateTexture(nil, "OVERLAY")
----    bar.Shield = shield
----    utils.setSize(shield, 200, 54)
----    shield:SetPoint("CENTER", bar, -3, 0)
----    shield:SetTexture[[Interface\CastingBar\UI-CastingBar-Small-Shield]]
----
----    local spark = bar:CreateTexture(nil, "OVERLAY")
----    bar.Spark = spark
----    utils.setSize(spark, 26)
----    spark:SetBlendMode"ADD"
----
----    local text = bar:CreateFontString(nil, "OVERLAY")
----    bar.Text = text
----	--text:SetFontObject(SystemFont_Shadow_Small)
----    text:SetFontObject(ChatFontNormal)
----		do
----        local f, s, flag = text:GetFont()
----        text:SetFont(f, s-2, 'OUTLINE')
----    end
----    text:SetPoint("TOP", bar, "TOP", 0, 0)
----
----    local time = bar:CreateFontString(nil, "OVERLAY")
----    bar.Time = time
----    time:SetFontObject(SystemFont_Shadow_Small)
----    do
----        local f, s, flag = time:GetFont()
----        time:SetFont(f, s-2, flag)
----    end
----    time:SetPoint("RIGHT", bar, "RIGHT", -1, 0)
----
----    do
----        -- 3.2.2 don"t have this
----        local tex = bar:GetStatusBarTexture()
----        if(tex.SetHorizTile) then
----            tex:SetHorizTile(true)
----        end
----    end
----
----end
----local function Range(self,unit)
----	self.nextUpdate = 0
----	self:SetScript("OnUpdate", function(self, elapsed)
----		self.nextUpdate = self.nextUpdate + elapsed
----		if(self.nextUpdate >=0.5) then
----			--if(self.is_party_frame) then
----				for i=1, GetNumSubgroupMembers() do
----					local isInRange = UnitInRange("party"..i)
----					local isConnected = UnitIsConnected("party"..i)
----					--local partyFrame = WSUFHeader_Party[i]
----					if(isInRange and isConnected) then
----						self:SetAlpha(1.0)
----					else
----						self:SetAlpha(0.5)
----					end
----				end
----			self.nextUpdate = 0
----		end
----	end)
----end
----
--local UnitSpec = {
--	party = function(self,unit)
--		if self:GetAttribute("unitsuffix") == "target" then
--		--	Parent(self,unit)
--		--	CreateObjects(self,unit)
--		--	Health(self,unit)
--		elseif self:GetAttribute("unitsuffix") == "pet" then
--		--	Parent(self,unit)
--		--	CreateObjects(self,unit)
--		--	Health(self,unit)
--		--	Power(self,unit)
--		else
--		--	Parent(self,unit)
--		--	CreateObjects(self,unit)
--		--	Portrait(self,unit)
--		--	Portrait_3D(self,unit)
--		--	Health(self,unit)
--		--	Power(self,unit)
--		--	FrameTextrue(self,unit)
--		--	FrameTextrue_Sider(self,unit)
--		--	SpecialIcon(self,unit)
--		--	Threat(self,unit)
--		--	ClassIcon(self,unit)
--		--	LFDRole(self,unit)
--		--	TagFunction(self,unit)
--		--	Auras(self,unit)
--		--	CastBar(self,unit)
--		--	Range(self,unit)
--		end
--	end,
--}
----
----
----	
----
--for unit,layout in next, UnitSpec do
--	oUF:RegisterStyle('WSUF - ' .. unit:gsub("^%l", string.upper),layout)
--end
--oUF:Factory(function(self)
--	self:SetActiveStyle'WSUF - Party'
--	local party = self:SpawnHeader('WSUFHeader_Party',nil,'custom [group:party,nogroup:raid][@raid6,noexists,group:raid] show;hide',
--	'showParty', false,
--	'point', 'TOP',
--	'template', 'WowshellUnitFramePartyTemplate',
--	'oUF-initialConfigFunction',([[
--		self:SetWidth(%d)
--		self:SetHeight(%d)
--	]]):format(unitdb.parent.width, unitdb.parent.height))
--	if unitdb.enabled then
--		party:SetPoint(position.selfPoint,position.anchorTo, position.relativePoint, position.x, position.y)
--	else
--		party:ClearAllPoints()
--	end
--end)
------
	local flag = 0
	_G["PartyMemberFrame1"]:SetMovable(true)
	if UnitInParty("player") and _G["PartyMemberFrame1"]:IsShown() then 
		_G["PartyMemberFrame1"]:SetScript("OnDoubleClick",function(self,button)
			if UnitAffectingCombat("player") then
				print("|cffe1a500精灵头像|r:|cffff2020战斗中无法设置位置!|r")	
			else
				if button == "RightButton" and flag%2 == 0 then
					_G["PartyMemberFrame1"]:StartMoving()
					flag = flag +1
					print("|cffe1a500精灵头像|r:|cff69ccf0解锁位置|r")
				elseif button == "RightButton" and flag%2 ~=0 then
					_G["PartyMemberFrame1"]:StopMovingOrSizing()
					local selfPoint,anchorTo,relativePoint,x,y = _G["PartyMemberFrame1"]:GetPoint()
					position.selfPoint = selfPoint
					position.anchorTo = "UIParent"
					position.relativePoint = relativePoint
					position.x = x*UIParent:GetEffectiveScale()
					position.y = y*UIParent:GetEffectiveScale()
					flag = 0
					print("|cffe1a500精灵头像|r:|cff69ccf0锁定位置|r")
				end
			end	
		end)
	end

ns:RegisterUnitOptions("party", {
    type = "group", 
    name = L["party"], 
    order = ns.order(), 
    args = {
        enabled = {
            type = "toggle", 
            name = L["Enabled"], 
            desc = L["Enable party frame"], 
            order = ns.order(), 
            get = function() return unitdb.enabled end, 
            set = function(_, v)
                unitdb.enabled = v
				if v then
					for i = 1, GetNumSubgroupMembers() do
						if UnitExists("party"..i) then
							_G["PartyMemberFrame"..i]:Show()
						end
					end
				else
					for i = 1, GetNumSubgroupMembers() do
						if UnitExists("party"..i) then
							_G["PartyMemberFrame"..i]:Hide()
						end
					end
				end
            end, 
        }, 
				showPartyPet = {
					type = "toggle", 
					name = L["Enable party pet frame"], 
					desc = L["Enable party pet frame, need reload UI"], 
					order = ns.order(), 
					get = function() return unitdb.showPartyPet end, 
					set = function(_, v)
						unitdb.showPartyPet = v
						local cvar = "0"
						if v then cvar = "1" else cvar = "0" end
						SetCVar("showPartyPets",cvar)
						if v then
						for i = 1, GetNumSubgroupMembers() do 
							if UnitExists("party"..i.."pet") then
								_G["PartyMemberFrame"..i.."PetFrame"]:Show()
								_G["PartyMemberFrame"..i.."PetFrame"]:SetPoint("TOPLEFT",_G["PartyMemberFrame"..i],23,-43)
							end
						end
						else
						
						for i = 1, GetNumSubgroupMembers() do 
							if UnitExists("party"..i.."pet") then
								_G["PartyMemberFrame"..i.."PetFrame"]:Hide()
							end
						end
						end
					end, 
				}, 
       -- showinraid = {
       --     type = "toggle", 
       --     name = L["Show party in raid"], 
       --     desc = L["Show party frame in raid"], 
       --     order = ns.order(), 
       --     get = function() return unitdb.showinraid end, 
       --     set = function(_, v)
       --         unitdb.showinraid = v
       --         --UpdateConditions()
       --     end, 
       -- }, 
--				yOffset = {
--					type = "range",
--					name = L["Party members's yOffset"],
--					desc = L["yOffset,need to reloadui"],
--					min = 0 , max = 100, step = 1,
--					get = function() return unitdb.parent.offset end,
--					set = function(_,v) 
--						unitdb.parent.offset = v
--						ns:LoadZoneHeader("party")
--					end,
--				},
--        combatfeedback = {
--            type = "toggle", 
--            name = L["Combat feedback text"], 
--            desc = L["Enable combat feedback test"], 
--            order = ns.order(), 
--            width = "full", 
--            get = function() return unitdb.combatfeedback end, 
--            set = function(_, v)
--                unitdb.combatfeedback = v
--                for k, v in iteratePartyFrame() do
--                    updateCombatFeedback(v)
--                end
--            end, 
--        }, 
--        castbar = {
--            type = "toggle", 
--            name = L["Castbar"], 
--            desc = L["Enable castbar"], 
--            order = ns.order(), 
--            get = function() return unitdb.castbar end, 
--            set = function(_, v)
--                unitdb.castbar = v
--                toggleCastbar()
--            end, 
--        }, 
--        sidebar = {
--            type = "toggle", 
--            name = L["Side info bar"], 
--            desc = L["Toggle side info bar"], 
--            order = ns.order(), 
--            get = function() return unitdb.sidebar end, 
--            set = function(_, v)
--                unitdb.sidebar = v
--                for k, v in iteratePartyFrame() do
--                    toggleSidebar(v)
--                end
--            end, 
--        }, 
--        Auras = {
--            type = "toggle", 
--            name = L["Enable auras"],
--						desc = L['Enable auras desc'],
--            order = ns.order(), 
--            width = "full", 
--            get = function() return unitdb.Auras end, 
--            set = function(_, v)
--                unitdb.Auras= v
--								toggleAuras()
--               -- for _, obj in iteratePartyFrame() do
--               --     if(v) then
--							 -- 			StaticPopup_Show 'WOWSHELL_UTIL_CONFIGCHANGED_RELOAD' 
--							 -- 			--obj.Auras:Show()
--               --     else
--							 -- 			StaticPopup_Show 'WOWSHELL_UTIL_CONFIGCHANGED_RELOAD'
--							 -- 			--obj.Auras:Hide()
--               --     end
--               -- end
--            end
--        },
--        auracooldown = {
--            type = "toggle", 
--            name = L["Aura cooldown"], 
--            desc = L["Show aura cooldown"], 
--            order = ns.order(), 
--            width = "full", 
--            get = function() return unitdb.auracooldown end, 
--            set = function(_, v)
--                unitdb.auracooldown = v
--                for _, frame in iteratePartyFrame() do
--                    if(frame:IsVisible()) then
--                        utils.updateAuraElement(frame)
--                        --frame:UpdateElement"Aura"
--                    end
--                end
--            end, 
--        }, 
--        castbyme = {
--            type = "toggle", 
--            name = L["Cast by me only"], 
--            desc = L["Only show cooldown on those that cast by me"], 
--            order = ns.order(), 
--            disabled = function() return not unitdb.auracooldown end, 
--            get = function() return unitdb.castbyme end, 
--            set = function(_, v )
--                unitdb.castbyme = v
--                for _, frame in iteratePartyFrame() do
--                    if(frame:IsVisible()) then
--                        utils.UpdateAuraElement(frame)
--                        --frame:UpdateElement"Aura"
--                    end
--                end
--            end, 
--        }, 
--       -- taggroup = {
--       --     type = "group", 
--       --     name = L["Tag texts"], 
--       --     order = ns.order(), 
--       --     inline = true, 
--       --     args = {
--       --        -- taghp = {
--       --        --     type = "select", 
--       --        --     name = L["Text on health bar"], 
--       --        --     desc = L["The text show on health bar"], 
--       --        --     order = ns.order(), 
--       --        --     values = utils.tag_select_values, 
--       --        --     get = function() return unitdb.tagonhealthbar or "NONE" end, 
--       --        --     set = function(_, v)
--       --        --         unitdb.tagonhealthbar = v
--       --        --         for _, f in iteratePartyFrame() do
--       --        --             utils.updateTag(f, "pcthp", v)
--       --        --         end
--       --        --     end, 
--       --        -- }, 
--       --        -- tagmp = {
--       --        --     type = "select", 
--       --        --     name = L["Text on power bar"], 
--       --        --     desc = L["The text show on power bar"], 
--       --        --     order = ns.order(), 
--       --        --     values = utils.tag_select_values, 
--       --        --     get = function() return unitdb.tagonpowerbar or "NONE" end, 
--       --        --     set = function(_, v)
--       --        --         unitdb.tagonpowerbar = v
--       --        --         for _, f in iteratePartyFrame() do
--       --        --             utils.updateTag(f, "pctmp", v, 1)
--       --        --         end
--       --        --     end, 
--       --        -- }, 
--       --        -- taghpr = {
--       --        --     type = "select", 
--       --        --     name = L["Text beside health bar"], 
--       --        --     desc = L["The text besides the health bar"], 
--       --        --     order = ns.order(), 
--       --        --     values = utils.tag_select_values, 
--       --        --     get = function() return unitdb.tagonhealthbarright or "NONE" end, 
--       --        --     set = function(_, v)
--       --        --         unitdb.tagonhealthbarright = v
--       --        --         for _, f in iteratePartyFrame() do
--       --        --             utils.updateTag(f, "hp", v)
--       --        --         end
--       --        --     end, 
--       --        -- }, 
--       --        -- tagmpr = {
--       --        --     type = "select", 
--       --        --     name = L["Text besides power bar"], 
--       --        --     desc = L["The text besides the power bar"], 
--       --        --     order = ns.order(), 
--       --        --     values = utils.tag_select_values, 
--       --        --     get = function() return unitdb.tagonpowerbarright or "NONE" end, 
--       --        --     set = function(_, v)
--       --        --         unitdb.tagonpowerbarright = v
--       --        --         for _, f in iteratePartyFrame() do
--       --        --             utils.updateTag(f, "mp", v, 1)
--			 -- 			 -- 					end
--       --        --     end, 
--       --        -- }, 
--       --      },
--			 -- 		 
--
--       -- }, 
--				 partycast = IsAddOnLoaded"Wowshell_PartyCast" and {
--                    type = "toggle", 
--                    name = L["Party cast"], 
--                    desc = L["Toggle party cast"], 
--                    order = ns.order(), 
--                    get = function() return PartyCast and PartyCast.db.profile.enable end, 
--                    set = function(_, v)
--                        if(PartyCast) then
--                            PartyCast.db.profile.enable = v
--                            PartyCast:ToggleShowCastFrame()
--                        end
--                    end, 
--                }, 
    }, 
})
