local strfind = string.find
local L = wsLocale:GetLocale("WoWShell");

UIParent:UnregisterEvent("ADDON_ACTION_BLOCKED");

--[=[
if GetLocale() == "zhCN" or GetLocale() == "zhTW" then
	SetTextStatusBarTextPrefix(PlayerFrameHealthBar, "");
	SetTextStatusBarTextPrefix(PlayerFrameManaBar, "");
	SetTextStatusBarTextPrefix(MainMenuExpBar, "");
	SetTextStatusBarTextPrefix(PartyMemberFrame1HealthBar, "");
	SetTextStatusBarTextPrefix(PartyMemberFrame2HealthBar, "");
	SetTextStatusBarTextPrefix(PartyMemberFrame3HealthBar, "");
	SetTextStatusBarTextPrefix(PartyMemberFrame4HealthBar, "");
	
	hooksecurefunc("UnitFrameManaBar_UpdateType", function(manaBar)
		if not manaBar then return end

		if manaBar then
			SetTextStatusBarTextPrefix(manaBar, "");
			TextStatusBar_UpdateTextString(manaBar);
		end
	end);

	TextStatusBarText:SetFont(STANDARD_TEXT_FONT, 14, "OUTLINE");
end
]=]

function cwdg_WatchRaidGroupButtons()
	local i;
	local button;
	for i=1, 40 do
		button = getglobal("RaidGroupButton"..i);
		button:SetAttribute("type", "target");
		button:SetAttribute("unit", button.unit);
	end
end

function cwdg_WatchPetActionBar()
	PetActionBarFrame:SetAttribute("unit", "pet");
	RegisterUnitWatch(PetActionBarFrame);
end

do
	local cwdg_button = CreateFrame("Frame");
	cwdg_button:RegisterEvent("VARIABLES_LOADED");
	cwdg_button:RegisterEvent("ADDON_LOADED");
	cwdg_button:RegisterEvent("PLAYER_TARGET_CHANGED");
	cwdg_button:SetScript("OnEvent", function(self, event, modname)	
		if (event == "ADDON_LOADED" and modname == "Blizzard_RaidUI") then
			if (InCombatLockdown()) then
				--调用
			else
				cwdg_WatchRaidGroupButtons();
			end
		elseif (event == "VARIABLES_LOADED") then
			if (InCombatLockdown()) then
				--
			else
				cwdg_WatchPetActionBar();
			end
		end
	end);
end
StaticPopupDialogs["ADDON_ACTION_FORBIDDEN"].OnAccept = function() end
StaticPopupDialogs["ADDON_ACTION_FORBIDDEN"].timeout = 0.0000001

--[=[
do
	local InspectFix = CreateFrame("Button", "InspectFixHiddenFrame", UIParent);
	local BlizzardNotifyInspect = _G.NotifyInspect
	local InspectPaperDollFrame_SetLevel = nil
	local InspectPaperDollFrame_OnShow = nil
	local InspectGuildFrame_Update = nil
	local loaded = false

	local lastunit
	local function unitchange(self)
		local unit = self.unit
		if loaded and unit and unit ~= lastunit then
			lastunit = unit
			BlizzardNotifyInspect(unit)
			InspectFrame_UnitChanged(InspectFrame)
		end
	end

	local function inspectfilter(self, event, ...) 
		if loaded then
			if (event == "PLAYER_TARGET_CHANGED" or event == nil) and
				self.unit == "target" and
				(not UnitExists("target") or not UnitIsPlayer("target")) then
				return false
			end
		end
		return true
	end

	local function inspectonevent(self, event, ...)
		if inspectfilter(self, event, ...) then
			InspectFrame_OnEvent(self, event, ...)
		end
	end
	local function inspectonupdate(self)
		if inspectfilter(self, nil) then
			InspectFrame_OnUpdate(self)
		end
	end

	local scantt = CreateFrame("GameTooltip", "InspectFix_Tooltip", UIParent, "GameTooltipTemplate")
	scantt:SetOwner(UIParent, "ANCHOR_NONE");
	local inspect_item = {}
	local inspect_unit = nil
	local function pdfupdate(self)
		if loaded then
			local id = self:GetID()
			local unit = InspectFrame.unit
			if unit and id then
				local link = GetInventoryItemLink(unit, id)
				inspect_unit = unit
				inspect_item[id] = link

				scantt:SetOwner(UIParent, "ANCHOR_NONE");
				scantt:SetInventoryItem(unit, id)
				local _, scanlink = scantt:GetItem()
				if scanlink and scanlink ~= link then
					inspect_item[id] = scanlink
				end
			end
		end
	end

	local function pdfonenter(self)
		if loaded then
			local id = self:GetID()
			if id and inspect_item[id] and inspect_unit == InspectFrame.unit and
				GameTooltip:IsVisible() then
				if GameTooltip:NumLines() == 1 then -- fill in a bogus inspect result
					GameTooltip:SetOwner(self, "ANCHOR_RIGHT");
					GameTooltip:SetHyperlink(inspect_item[id])
				else
					local name,link = GameTooltip:GetItem()
					if link and link ~= inspect_item[id] then
						inspect_item[id] = link
					end
				end
			end
		end
	end

	local blockmsg = {}

	-- prevent NotifyInspect interference from other addons
	local function NIhook(unit)
		InspectFix:tryhook()
		if loaded and (not unit or not CanInspect(unit)) then
			return
		end
		local ifvis = InspectFrame and InspectFrame:IsVisible()
		local exvis = Examiner and Examiner:IsVisible()
		if loaded and (ifvis or exvis) then
			local str = debugstack(2)
			local addon = string.match(str,'[%s%c]+([^:%s%c]*)\\[^\\:%s%c]+:')
			addon = string.gsub(addon or "unknown",'I?n?t?e?r?f?a?c?e\\AddOns\\',"")
			if not string.find(str,ifvis and "Blizzard_InspectUI" or "Examiner") then
				blockmsg[addon] = blockmsg[addon] or {}
				local count = (blockmsg[addon].count or 0) + 1
				blockmsg[addon].count = count
				local now = GetTime()
				if not blockmsg[addon].lastwarn or (now - blockmsg[addon].lastwarn > 30) then -- throttle warnings
					--print("InspectFix blocked a conflicting inspect request from "..addon.." ("..count.." occurences)")
					blockmsg[addon].lastwarn = now
				end
				return
			end
		end
		BlizzardNotifyInspect(unit)
	end

	local function pdffilter(context)
		if not loaded then
			return true
		elseif InspectFrame and InspectFrame.unit and CanInspect(InspectFrame.unit) then
			return true
		else
			return false
		end
	end
	local function setlevel_hook()
		if pdffilter("setlevel") then
			return InspectPaperDollFrame_SetLevel()
		end
	end

	local function pdfshow_hook()
		if pdffilter("pdfshow") then
			return InspectPaperDollFrame_OnShow()
		end
	end

	local function guildframe_hook()
		if pdffilter("guildframe") then
			return InspectGuildFrame_Update()
		end
	end

	local hookcnt = 0
	local hooked = {}
	function InspectFix:tryhook()
		if false and not hooked[unitchange] and InspectFrame_UnitChanged then
			hooksecurefunc("InspectFrame_UnitChanged", unitchange)
			hooked[unitchange] = true
		end

		if _G.NotifyInspect and _G.NotifyInspect ~= NIhook then
			_G.NotifyInspect = NIhook
			if not hooked["notifyinspect"] then
				hookcnt = hookcnt + 1
				hooked["notifyinspect"] = true
			else
			end
		end

		if _G.InspectFrame_OnEvent and InspectFrame:GetScript("OnEvent") ~= inspectonevent then
			InspectFrame:SetScript("OnEvent", inspectonevent)
			if not hooked[inspectonevent] then
				hookcnt = hookcnt + 1
				hooked[inspectonevent] = true
			else
			end
		end

		if _G.InspectGuildFrame_Update and _G.InspectGuildFrame_Update ~= guildframe_hook then
			InspectGuildFrame_Update = _G.InspectGuildFrame_Update
			_G.InspectGuildFrame_Update = guildframe_hook
				if not hooked[guildframe_hook] then
				hooked[guildframe_hook] = true
				hookcnt = hookcnt + 1
			else
			end
		end

		if _G.InspectFrame_OnUpdate and InspectFrame:GetScript("OnUpdate") ~= inspectonupdate then
			InspectFrame:SetScript("OnUpdate", inspectonupdate)
			if not hooked[inspectonupdate] then
				hookcnt = hookcnt + 1
				hooked[inspectonupdate] = true
			else
			end
		end

		if _G.InspectPaperDollFrame_SetLevel and _G.InspectPaperDollFrame_SetLevel ~= setlevel_hook then
			InspectPaperDollFrame_SetLevel = _G.InspectPaperDollFrame_SetLevel
			_G.InspectPaperDollFrame_SetLevel = setlevel_hook
			if not hooked[setlevel_hook] then
				hooked[setlevel_hook] = true
				hookcnt = hookcnt + 1
			else
			end
		end


		if _G.InspectPaperDollFrame_OnShow and _G.InspectPaperDollFrame_OnShow ~= pdfshow_hook then
			InspectPaperDollFrame_OnShow = _G.InspectPaperDollFrame_OnShow
			_G.InspectPaperDollFrame_OnShow = pdfshow_hook
			InspectPaperDollFrame:SetScript("OnShow", pdfshow_hook)
			if not hooked[pdfshow_hook] then
				hooked[pdfshow_hook] = true
				hookcnt = hookcnt + 1
			else
			end
		end

		if not hooked[pdfupdate] and InspectPaperDollItemSlotButton_Update and InspectPaperDollItemSlotButton_OnEnter then
			hooksecurefunc("InspectPaperDollItemSlotButton_Update", pdfupdate)
			hooksecurefunc("InspectPaperDollItemSlotButton_OnEnter", pdfonenter)
			hookcnt = hookcnt + 1
			hooked[pdfupdate] = true
		end

		if hookcnt == 7 then
			hookcnt = hookcnt + 1
		end
	end
	function InspectFix_OnEvent(self, event)
		if event == "ADDON_LOADED" then
			InspectFix:tryhook()
		end
	end
	InspectFix:SetScript("OnEvent", InspectFix_OnEvent)
	InspectFix:RegisterEvent("ADDON_LOADED")

	function InspectFix:Load()
		InspectFix:tryhook()
		loaded = true
	end

	InspectFix:Load()
end
]=]

--do
--	local f = CreateFrame("Frame");
--	f:RegisterEvent("ADDON_LOADED");
--
--	f:SetScript("OnEvent", function(self, event, ...)
--		if event == "ADDON_LOADED" then
--			local addonName = ...;
--			if addonName == "Blizzard_InspectUI" then
--				if InspectGuildFrame_Update then
--					function InspectGuildFrame_Update() 
--						if InspectFrame and InspectFrame.unit and CanInspect(InspectFrame.unit) then
--							local ifvis = InspectFrame and InspectFrame:IsVisible()
--							local exvis = Examiner and Examiner:IsVisible()
--
--							if (ifvis and InspectFrame.unit) or exvis then
--								local guildName, _, _ = GetGuildInfo(InspectFrame.unit);
--								InspectGuildFrame.guildName:SetText(guildName);
--								local _, guildLevel, guildXP, guildNumMembers = GetInspectGuildInfo(InspectFrame.unit);
--								local _, guildFactionName = UnitFactionGroup(InspectFrame.unit);
--								if ( GetGuildLevelEnabled() ) then
--									InspectGuildFrame.guildLevel:SetFormattedText(INSPECT_GUILD_LEVEL, guildLevel, guildFactionName);
--								else
--									InspectGuildFrame.guildLevel:SetFormattedText(INSPECT_GUILD_FACTION, guildFactionName);
--								end
--								InspectGuildFrame.guildNumMembers:SetFormattedText(INSPECT_GUILD_NUM_MEMBERS, guildNumMembers);
--								SetDoubleGuildTabardTextures(InspectFrame.unit, InspectGuildFrameTabardLeftIcon, InspectGuildFrameTabardRightIcon, InspectGuildFrameBanner, InspectGuildFrameBannerBorder);
--							end
--						end
--					end
--				end
--			end
--		end
--	end);
--end
