local L, locale = OVERACHIEVER_STRINGS, GetLocale()

L.SEARCH_TAB = "Search";
L.SEARCH_HELP = "Use this tab to search for achievements. You can also search for achievements by name or ID using slash commands. See Overachiever's readme.txt file for details.";
L.SEARCH_NAME = "Name:";
L.SEARCH_DESC = "Description:";
L.SEARCH_CRITERIA = "Criteria:";
L.SEARCH_REWARD = "Reward:";
L.SEARCH_ANY = "Any of the above:";
L.SEARCH_FULLLIST = "Include hidden|nachievements";
L.SEARCH_FULLLIST_TIP = "Include in the search achievements that aren't normally listed in the default UI, such as those exclusive to the opposing faction, unacquired Feats of Strength, etc.";
L.SEARCH_TYPE = "Type:";
L.SEARCH_TYPE_INDIV = "Personal";
L.SEARCH_TYPE_GUILD = "Guild";
L.SEARCH_TYPE_ALL = "All";
L.SEARCH_SUBMIT = "Search";
L.SEARCH_RESET = "Reset";
L.SEARCH_RESULTS = "Found %s |4achievement:achievements;.";

L.SUGGESTIONS_TAB = "Suggestions";
L.SUGGESTIONS_HELP = "Suggested achievements are listed here based on your current location. Also listed are any achievements you were reminded about through a tooltip within the last 2 minutes or that have a timer which started recently.";
L.SUGGESTIONS_REFRESH = "Refresh";
L.SUGGESTIONS_EMPTY = "Overachiever has no suggestions for you at this time.";
L.SUGGESTIONS_RESULTS = "%d |4suggestion:suggestions; found.";
L.SUGGESTIONS_RESULTS_TRADESKILL = "%s: %d |4suggestion:suggestions; found.";
L.SUGGESTIONS_EMPTY_TRADESKILL = "%s: Overachiever has no suggestions for you at this time.";
L.SUGGESTIONS_LOCATION = "Location:"
L.SUGGESTIONS_LOCATION_TIP = "Override Zone/Instance Location"
L.SUGGESTIONS_LOCATION_TIP2 = "Leave blank to get suggestions for your current location or start typing to get a matching valid zone or instance name to use instead. Press |cffffffffTab|r to cycle between locations that match the text to the left of the cursor. |cffffffffShift+Tab|r cycles in reverse order. If the cursor is at the leftmost position, it cycles between all valid locations."
L.SUGGESTIONS_LOCATION_SUBZONE = "Subzone:"
L.SUGGESTIONS_LOCATION_NOSUBZONE = "(unspecified)"

L.WATCH_TAB = "Watch";
L.WATCH_HELP = "Create your watch list by |cffffffffalt+clicking|r on achievements in the other tabs or achievement chat links. |cffffffffAlt+click|r on one displayed here to stop watching it.";
L.WATCH_EMPTY = "Your watch list is empty. Alt+click on an achievement in another tab or an achievement's chat link to watch it.";
L.WATCH_EMPTY_SHORT = "Empty List";
L.WATCH_DISPLAYEDLIST = "Displayed List:";
L.WATCH_DEFAULTLIST = "Default List:";
L.WATCH_DEFAULTLIST_TIP = "The specified list will be the Displayed List at the beginning of each session.";
L.WATCH_COPY = "Copy to List:";
L.WATCH_COPY_TIP = "When enabled, if you |cffffffffshift+alt+click|r on an achievement on this tab, it will be added to the specified watch list.";
L.WATCH_LIST_GLOBAL = "Global";
L.WATCH_LIST_PERCHAR = "Character-specific";
L.WATCH_NEW = "New";
L.WATCH_DELETE = "Delete";
L.WATCH_CLEAR = "Clear";
L.WATCH_COPY = "Copy To:";
L.WATCH_POPUP_NEWLIST = "Enter the name of your new achievement watch list:";
L.WATCH_POPUP_DELETELIST = "Are you sure you want to permanently delete the current achievement watch list?";
L.WATCH_POPUP_CLEARLIST = "Are you sure you want to clear the contents of the current achievement watch list?";
L.WATCH_ERR_INVALIDID = 'Removed "%s" from Watch List: An achievement with that ID could not be found.';

L.TAB_SORT = "Sort by:";
L.TAB_SORT_NAME = "Name";
L.TAB_SORT_ID = "ID";
L.TAB_SORT_POINTS = "Point value";
L.TAB_SORT_COMPLETE = "Date completed";
L.TAB_HELP = "|cffffffffCtrl-click|r on an achievement to jump to its place in the standard UI.|n|nA |cffffffffblue background|r means it is part of a series for which you haven't completed an earlier step.|n|nA |cffffffffred background|r means it cannot be found in the standard UI for this character because it is exclusive to the opposing faction or is an unacquired Feat of Strength.|n|nA |cffffffffgreen background|r means a reminder about this achievement was displayed in a tooltip recently or it has a timer which started recently.";

if (locale == "deDE") then  -- German
L["SEARCH_ANY"] = "In allen suchen"
L["SEARCH_CRITERIA"] = "Kriterium:"
L["SEARCH_DESC"] = "Beschreibung:"
L["SEARCH_FULLLIST"] = "Alle Erfolge durchsuchen"
L["SEARCH_FULLLIST_TIP"] = "Auch Erfolge durchsuchen, die normalerweise nicht aufgelistet werden. (z. B. Erfolge der gegnerischen Fraktion oder unerreichte Heldentaten, usw.)"
L["SEARCH_HELP"] = "Nutze diese Seite um nach Achievements zu suchen. Per Slash-Command kannst du auch nach Achievement-Name oder ID suchen. Lies die readme.txt für weitere Details."
L["SEARCH_NAME"] = "Name:"
L["SEARCH_RESET"] = "Zurücksetzen"
L["SEARCH_RESULTS"] = "%s |4Achievement:Achievements; gefunden."
L["SEARCH_REWARD"] = "Belohnung:"
L["SEARCH_SUBMIT"] = "Suchen"
L["SEARCH_TAB"] = "Suche"
L["SEARCH_TYPE"] = "Typ:"
L["SEARCH_TYPE_ALL"] = "Alle"
L["SEARCH_TYPE_GUILD"] = "Gilde"
L["SEARCH_TYPE_INDIV"] = "Persönlich"
L["SUGGESTIONS_EMPTY"] = "Overachiever hat zur Zeit keine Vorschläge für dich."
L["SUGGESTIONS_EMPTY_TRADESKILL"] = "%s: Overachiever hat zur Zeit keine Vorschläge für dich."
L["SUGGESTIONS_HELP"] = "Hier werden Erfolge aufgelistet, die Du in deiner aktuellen Zone abschließen kannst. Weiters werden auch alle Erfolge aufgelistet, an die Du in den letzen 2 Minuten per Tooltip erinnert wurdest und auch jene, durch die kürzlich einen Timer gestartet wurde."
L["SUGGESTIONS_LOCATION"] = "Standort:"
L["SUGGESTIONS_LOCATION_NOSUBZONE"] = "(nicht spezifiziert)"
L["SUGGESTIONS_LOCATION_SUBZONE"] = "Subzone:"
L["SUGGESTIONS_LOCATION_TIP"] = "Gebiete-/Instanzen-Standorte übergehen"
L["SUGGESTIONS_LOCATION_TIP2"] = [=[Leer lassen, um Vorschläge für Deinen aktuellen Standort zu erhalten. Oder beginne zu Tippen, um einen passenden, gültigen Gebiets- oder Instanzennamen angezeigt zu bekommen, der stattdessen verwendet werden kann. Drücke |cffffffffTab|r , um zwischen den Standorten zu wechseln, die zum Text links vom Cursor passen. Drücke |cffffffffSHIFT+Tab|r , um in entgegengesetzter Reihenfolge zu wechseln. Wenn der Cursor sich ganz links befindet, wird zwischen allen gültigen Standorten gewechselt.

Tabs]=]
L["SUGGESTIONS_REFRESH"] = "Aktualisieren"
L["SUGGESTIONS_RESULTS"] = "%d |4Vorschlag:Vorschläge; gefunden."
L["SUGGESTIONS_RESULTS_TRADESKILL"] = "%s: %d |4Vorschlag:Vorschläge; gefunden."
L["SUGGESTIONS_TAB"] = "Vorschläge"
L["TAB_HELP"] = "|cffffffffCtrl-klick|r auf ein Achievement um es in der Standard UI anzuzeigen.|n|nEin |cffffffffblauer Hintergrund|r bedeutet das Achievement ist Teil einer Serie, bei welcher dir noch ein vorheriger Schritt fehlt.|n|nEin |cffffffffroter Hintergrund|r bedeutet das Achievement kann nicht im Standard UI gefunden werden, weil es nur von der Gegnerischen Fraktion erlangt werden kann oder eine unerreichtes Heldtentat ist.|n|nEin |cffffffffgüner Hintergrund|r zeigt an, daß du kürzlich im Tooltip an dieses Achievement erinnert wurdest."
L["TAB_SORT"] = "Sortieren nach:"
L["TAB_SORT_COMPLETE"] = "Abgeschlossen am"
L["TAB_SORT_ID"] = "ID"
L["TAB_SORT_NAME"] = "Name"
L["TAB_SORT_POINTS"] = "Erfolgspunkte"
L["WATCH_CLEAR"] = "Löschen"
L["WATCH_COPY"] = "Kopiere nach:"
L["WATCH_COPY_TIP"] = "Wenn aktiviert, wird mittels |cffffffffshift+alt+click|r auf einen Erfolg in diesem Tab, der Erfolg auf der spezifischen Beobachtungsliste hinzugefügt."
L["WATCH_DEFAULTLIST"] = "Standardliste:"
L["WATCH_DEFAULTLIST_TIP"] = "Die spezifische Liste wird, die angezeigte Liste zu Beginn einer jeden Sitzung sein."
L["WATCH_DELETE"] = "Löschen"
L["WATCH_DISPLAYEDLIST"] = "Angezeigte Liste:"
L["WATCH_EMPTY"] = "Deine Beobachtungsliste ist leer. Alt+Klick auf ein Achievement in einem anderen Tab oder einem Chat-Link um es zu beobachten."
L["WATCH_EMPTY_SHORT"] = "Liste leeren"
L["WATCH_ERR_INVALIDID"] = " \"%s\" wurde aus der Beobachtungsliste entfernt. Ein Erfolg mit solch einer ID ist nicht bekannt."
L["WATCH_HELP"] = "Erstelle deine Beobachtungsliste mittels |cffffffffAlt+Klick|r auf Achievements in den anderen Tabs. |cffffffffAlt+Klick|r auf ein hier angezeigtes um es von der Liste zu nehmen."
L["WATCH_LIST_GLOBAL"] = "Global"
L["WATCH_LIST_PERCHAR"] = "Charakterspezifisch"
L["WATCH_NEW"] = "Neu"
L["WATCH_POPUP_CLEARLIST"] = "Bist Du sicher, daß Du den Inhalt der aktuellen Erfolgsbeobachtungsliste löschen möchtest?"
L["WATCH_POPUP_DELETELIST"] = "Bist Du sicher, daß Du die aktuelle Erfolgsbeobachtungsliste endgültig löschen möchtest?"
L["WATCH_POPUP_NEWLIST"] = "Benenne Deine neue Erfolgsbeobachtungsliste"
L["WATCH_TAB"] = "Beobachten"
L.SUBZONES = {
	["Argent Pavilion"] = "Argentum Pavillon",
	["Argent Tournament Grounds"] = "Argentumturnierplatz",
	["Formation Grounds"] = "Gestaltungsgelände",
	["Razorscale's Aerie"] = "Klingenschuppes Kanzel",
	["Silver Covenant Pavilion"] = "Silberbund Pavillon",
	["Sunreaver Pavilion"] = "Sonnenhäscherpavillon",
	["The Alliance Valiants' Ring"] = "Der Reckenring der Allianz",
	["The Argent Valiants' Ring"] = "Der Argentum Reckenring",
	["The Aspirants' Ring"] = "Der Ring des Streiters",
	["The Assembly of Iron"] = "Die Versammlung des Eisens",
	["The Celestial Planetarium"] = "Das himmlische Planetarium",
	["The Clash of Thunder"] = "Der Donnerschlag",
	["The Colossal Forge"] = "Kolossale Schmiede",
	["The Conservatory of Life"] = "Das Konservatorium des Lebens",
	["The Descent into Madness"] = "Der Abstieg in den Wahnsinn",
	["The Halls of Winter"] = "Hallen des Winters",
	["The Horde Valiants' Ring"] = "Der Reckenring der Horde",
	["The Observation Ring"] = "Der Beobachtungsring",
	["The Prison of Yogg-Saron"] = "Das Gefängnis von Yogg-Saron",
	["The Ring of Champions"] = "Der Ring der Champions",
	["The Scrapyard"] = "Der Schrottplatz",
	["The Shattered Walkway"] = "Der zerschmetterte Gang",
	["The Spark of Imagination"] = "Der Funke der Imagination",
}


elseif (locale == "frFR") then  -- French
L["SEARCH_ANY"] = "Tout ce qui précède :"
L["SEARCH_CRITERIA"] = "Critère :"
L["SEARCH_DESC"] = "Description :"
L["SEARCH_FULLLIST"] = "Inclure tous les hauts faits" -- Needs review
L["SEARCH_FULLLIST_TIP"] = "Inclut dans la recherche les hauts faits qui ne sont pas normalement affichés dans l'IU par défaut, comme ceux de la faction adverse, les Tours de force non accomplis, etc."
L["SEARCH_HELP"] = "Utilisez cet onglet pour chercher des hauts faits. Vous pouvez également rechercher des hauts faits par nom ou par ID en utilisant les commandes \"slash\". Référez-vous au fichier readme.txt d'Overachiever pour les détails."
L["SEARCH_NAME"] = "Nom :"
L["SEARCH_RESET"] = "Réinitialiser"
L["SEARCH_RESULTS"] = "%s |4haut fait trouvé:hauts faits trouvés;."
L["SEARCH_REWARD"] = "Récompense :"
L["SEARCH_SUBMIT"] = "Chercher"
L["SEARCH_TAB"] = "Recherches"
L["SEARCH_TYPE"] = "Type :"
L["SEARCH_TYPE_ALL"] = "Tout"
L["SEARCH_TYPE_GUILD"] = "Guilde"
L["SEARCH_TYPE_INDIV"] = "Personnel"
L["SUGGESTIONS_EMPTY"] = "Overachiever n'a aucune suggestion pour le moment"
L["SUGGESTIONS_EMPTY_TRADESKILL"] = " %s: Overachiever n'a aucune suggestion à faire pour le moment."
L["SUGGESTIONS_HELP"] = "Les hauts faits suggérés sont affichés ici en fonction de votre localisation. Sont également listés tous les hauts faits qui vous ont été rappelés par une infobulle dans les 2 dernières minutes ou qui ont une alarme qui s'est déclenchée récemment."
L["SUGGESTIONS_LOCATION"] = "Emplacement :"
L["SUGGESTIONS_LOCATION_NOSUBZONE"] = "(indéterminé)"
L["SUGGESTIONS_LOCATION_SUBZONE"] = "Sous-zone :"
L["SUGGESTIONS_LOCATION_TIP"] = "Ne pas tenir compte de l'emplacement de la zone/instance"
L["SUGGESTIONS_LOCATION_TIP2"] = "Laissez vierge pour obtenir les suggestions relatives à votre position actuelle ou entrez les premiers caractères pour obtenir un nom de zone ou d'instance valide. Appuez sur |cffffffffTab|r pour faire défiler les noms de lieux correspondants au texte entré à gauche du curseur. |cffffffffShift+Tab|r fait défiler les noms dans l'ordre inverse. Si le curseur est à l'extrême gauche, tous les lieux possibles défilent."
L["SUGGESTIONS_REFRESH"] = "Rafraîchir"
L["SUGGESTIONS_RESULTS"] = "%d |4suggestion trouvée:suggestions trouvées;."
L["SUGGESTIONS_RESULTS_TRADESKILL"] = " %s: %d |4suggestion trouvée:suggestions trouvées;."
L["SUGGESTIONS_TAB"] = "Suggestions"
L["TAB_HELP"] = "|cffffffffCtrl-click|r sur un haut fait pour l'afficher dans l'IU standard.|n|nUn |cfffffffffond bleu|r signifie qu'il fait partie d'une série dont vous n'avez pas encore effectué une étape précédente.|n|nUn |cfffffffffond rouge|r signifie qu'il ne peut pas être trouvé dans l'IU standard de ce personnage car il est propre à la faction adverse ou bien il s'agit d'un Tour de force non accompli.|n|nA |cfffffffffond vert|r signifie qu'un rappel pour ce haut fait a été affiché récemment dans une infobulle ou qu'il possède une alarme qui s'est déclenchée il y a peu."
L["TAB_SORT"] = "Trier par :"
L["TAB_SORT_COMPLETE"] = "Date d'accomplissement"
L["TAB_SORT_ID"] = "ID"
L["TAB_SORT_NAME"] = "Nom"
L["TAB_SORT_POINTS"] = "Valeur en point"
L["WATCH_CLEAR"] = "Vider"
L["WATCH_COPY"] = "Copier vers :"
L["WATCH_COPY_TIP"] = "Quand activé, si vous |cffffffffmajuscule+alt+clicquez|r sur un haut-fait sur cet onglet, il sera ajouté à la liste de suivi spécifiée."
L["WATCH_DEFAULTLIST"] = "Liste par défaut :"
L["WATCH_DEFAULTLIST_TIP"] = "La liste spécifiée sera la Liste Affichée au début de chaque session."
L["WATCH_DELETE"] = "Supprimer"
L["WATCH_DISPLAYEDLIST"] = "Liste Affichée :"
L["WATCH_EMPTY"] = "Votre liste de suivi est vide. Vous pouvez faire Alt+click sur un haut fait dans un autre onglet ou sur un lien de haut fait dans la fenêtre de discussion pour l'afficher."
L["WATCH_EMPTY_SHORT"] = "Vider la Liste"
L["WATCH_ERR_INVALIDID"] = "\"%s\" supprimé de la liste: Le haut-fait avec cet ID est introuvable."
L["WATCH_HELP"] = "Vous pouvez créer votre liste de suivi avec un |cffffffffalt+click|r sur un haut fait dans un autre onglet ou sur un lien de haut fait dans la fenêtre de discussion. Avec un |cffffffffAlt+click|r sur un haut fait affiché ici, vous arrêtez le suivi."
L["WATCH_LIST_GLOBAL"] = "Global"
L["WATCH_LIST_PERCHAR"] = "Spécifique-Personnage"
L["WATCH_NEW"] = "Nouveau"
L["WATCH_POPUP_CLEARLIST"] = "Êtes-vous certain de vouloir effacer le contenu de la liste de suivi courante ?"
L["WATCH_POPUP_DELETELIST"] = "Êtes-vous certain de vouloir supprimer définitivement la liste de suivi courante ?"
L["WATCH_POPUP_NEWLIST"] = "Entrez le nom de votre nouvelle liste de suivi :"
L["WATCH_TAB"] = "Suivi"
L.SUBZONES = {
	["Argent Pavilion"] = "Pavillon d'Argent",
	["Argent Tournament Grounds"] = "Enceinte du tournoi d'Argent",
	["Formation Grounds"] = "Champs d'entraînement",
	["Razorscale's Aerie"] = "Aire de Tranchécaille",
	["Silver Covenant Pavilion"] = "Pavillon du Concordat argenté",
	["Sunreaver Pavilion"] = "Pavillon de Saccage-soleil",
	["The Alliance Valiants' Ring"] = "Lice des vaillants de l'Alliance",
	["The Argent Valiants' Ring"] = "Lice des vaillants d'Argent",
	["The Aspirants' Ring"] = "Lice des aspirants",
	["The Assembly of Iron"] = "L'assemblée du Fer",
	["The Celestial Planetarium"] = "Le planétarium céleste",
	["The Clash of Thunder"] = "Le fracas du tonnerre",
	["The Colossal Forge"] = "La forge colossale",
	["The Conservatory of Life"] = "Le jardin de  la vie",
	["The Descent into Madness"] = "La descente dans la folie",
	["The Halls of Winter"] = "Les salles de l'hiver",
	["The Horde Valiants' Ring"] = "Lice des vaillants de la Horde",
	["The Observation Ring"] = "Le cercle d'observation",
	["The Prison of Yogg-Saron"] = "Prison de Yogg-Saron",
	["The Ring of Champions"] = "Lice des champions",
	["The Scrapyard"] = "La ferraillerie",
	["The Shattered Walkway"] = "Le passage brisé",
	["The Spark of Imagination"] = "L'étincelle d'imagination",
}


elseif (locale == "zhTW") then  -- Traditional Chinese
L["SEARCH_ANY"] = "以上皆可："
L["SEARCH_CRITERIA"] = "條件："
L["SEARCH_DESC"] = "描述："
L["SEARCH_FULLLIST"] = "搜索所有成就"
L["SEARCH_FULLLIST_TIP"] = "包括所有成就、已完成的、未完成的、無法完成的，等等。"
L["SEARCH_HELP"] = "使用此標籤來搜索成就。您也可以使用命令搜索成就的名稱或編號。見 Overachiever 的 Readme.txt 文件的相關內容。"
L["SEARCH_NAME"] = "名稱："
L["SEARCH_RESET"] = "重置"
L["SEARCH_RESULTS"] = "搜索到 %s 個成就。"
L["SEARCH_REWARD"] = "獎勵："
L["SEARCH_SUBMIT"] = "搜索"
L["SEARCH_TAB"] = "搜索"
L["SEARCH_TYPE"] = "類型:"
L["SEARCH_TYPE_ALL"] = "全部"
L["SEARCH_TYPE_GUILD"] = "公會"
L["SEARCH_TYPE_INDIV"] = "個人"
L["SUGGESTIONS_EMPTY"] = "Overachiever現在沒有任何建議。"
L["SUGGESTIONS_EMPTY_TRADESKILL"] = "%s: Overachiever 此時無法提供建議."
L["SUGGESTIONS_HELP"] = "根據你目前的位置建議追蹤成就。"
L["SUGGESTIONS_LOCATION"] = "區域："
L["SUGGESTIONS_LOCATION_NOSUBZONE"] = "(未指定)"
L["SUGGESTIONS_LOCATION_SUBZONE"] = "次區域："
L["SUGGESTIONS_LOCATION_TIP"] = "無視區域/副本位置"
L["SUGGESTIONS_LOCATION_TIP2"] = "在欄位中輸入一個完整的有效區域或副本名稱，以取得提示。若欄位保持空白，則會根據你目前的所在位置。當游標在欄位中時，按下|cffffffffTab|r鍵可根據已輸入的內容依序產生有效的完整位置名稱。按下|cffffffffShift+Tab|r則產生前一個名稱。如果游標在欄位的最左側，它將依序產生所有有效位置名稱。"
L["SUGGESTIONS_REFRESH"] = "刷新"
L["SUGGESTIONS_RESULTS"] = "找到 %d 個建議。"
L["SUGGESTIONS_RESULTS_TRADESKILL"] = "%s: 找到 %d 個建議."
L["SUGGESTIONS_TAB"] = "建議"
L["TAB_HELP"] = "|cffffffffCtrl + 點選|r 所選成就會跳轉到該成就的頁面.|n|n |cffffffff藍色背景|r表示此成就是你還沒有完成前續內容的系列成就部分.|n|n |cffffffff紅色背景|r表示此成就無法在你當前人物的標準成就界面中找到,因為這是陣營專屬成就,或者是你尚未取得的『光輝事跡』成就."
L["TAB_SORT"] = "類型:"
L["TAB_SORT_COMPLETE"] = "完成時間"
L["TAB_SORT_ID"] = "成就ID"
L["TAB_SORT_NAME"] = "名稱"
L["TAB_SORT_POINTS"] = "成就點數"
L["WATCH_CLEAR"] = "清除"
L["WATCH_COPY"] = "複製到:"
L["WATCH_COPY_TIP"] = "當啟用時，假如你 |cffffffffshift+alt+點擊|r 在一個標籤上的成就，將會新增至指定的觀察列表中。"
L["WATCH_DEFAULTLIST"] = "預設列表:"
L["WATCH_DEFAULTLIST_TIP"] = "指定列表會顯示列表在任何場景的開始時候。"
L["WATCH_DELETE"] = "刪除"
L["WATCH_DISPLAYEDLIST"] = "顯示列表:"
L["WATCH_EMPTY"] = "你的觀察列表是空的。Alt+點擊在其它成就標籤上或是成就連結來觀察。"
L["WATCH_EMPTY_SHORT"] = "空的列表"
L["WATCH_ERR_INVALIDID"] = "已從觀察列表移除\"%s\": 此成就ID並未被發現。"
L["WATCH_HELP"] = "在其它成就標籤上或是成就連結使用 |cffffffffalt+點擊|r新建你的觀察列表。 |cffffffffAlt+點擊|r 停止觀察。"
L["WATCH_LIST_GLOBAL"] = "全局"
L["WATCH_LIST_PERCHAR"] = "字符特殊"
L["WATCH_NEW"] = "新的"
L["WATCH_POPUP_CLEARLIST"] = "要將這個成就觀察列表的內容清除?"
L["WATCH_POPUP_DELETELIST"] = "要將這個成就觀察列表刪除?"
L["WATCH_POPUP_NEWLIST"] = "輸入新建成就列表的名稱:"
L["WATCH_TAB"] = "觀察"
L.SUBZONES = {
	["Argent Pavilion"] = "銀白亭閣",
	["Argent Tournament Grounds"] = "銀白聯賽場地",
	["Formation Grounds"] = "構築之地",
	["Razorscale's Aerie"] = "銳鱗之巢",
	["Silver Covenant Pavilion"] = "白銀誓盟亭閣",
	["Sunreaver Pavilion"] = "奪日者亭閣",
	["The Alliance Valiants' Ring"] = "聯盟驍士競技場",
	["The Argent Valiants' Ring"] = "銀白驍士競技場",
	["The Aspirants' Ring"] = "志士競技場",
	["The Assembly of Iron"] = "鐵之集會所",
	["The Celestial Planetarium"] = "星穹渾天儀",
	["The Clash of Thunder"] = "雷鳴之廳",
	["The Colossal Forge"] = "巨熔爐",
	["The Conservatory of Life"] = "生命溫室",
	["The Descent into Madness"] = "驟狂斜廊",
	["The Halls of Winter"] = "凜冬之廳",
	["The Horde Valiants' Ring"] = "部落驍士競技場",
	["The Observation Ring"] = "觀察之環",
	["The Prison of Yogg-Saron"] = "尤格薩倫之獄",
	["The Ring of Champions"] = "勇士競技場",
	["The Scrapyard"] = "廢料場",
	["The Shattered Walkway"] = "破碎走道",
	["The Spark of Imagination"] = "創思之廳",
}


elseif (locale == "zhCN") then  -- Simplified Chinese
L["SEARCH_ANY"] = "以上所有："
L["SEARCH_CRITERIA"] = "条件："
L["SEARCH_DESC"] = "描述："
L["SEARCH_FULLLIST"] = "包含隐藏成就"
L["SEARCH_FULLLIST_TIP"] = "包括没有在默认列表中显示的成就，例如阵营专属成就、‘光辉事迹’成就等。"
L["SEARCH_HELP"] = "使用这个标签来搜索成就。你也可以通过斜杠命令用名字或ID来搜索成就。详细请参见Overachiever的readme.txt文件。"
L["SEARCH_NAME"] = "名称："
L["SEARCH_RESET"] = "重置"
L["SEARCH_RESULTS"] = "找到 %s 个成就。"
L["SEARCH_REWARD"] = "奖励："
L["SEARCH_SUBMIT"] = "搜索"
L["SEARCH_TAB"] = "搜索"
L["SEARCH_TYPE"] = "类型："
L["SEARCH_TYPE_ALL"] = "全部"
L["SEARCH_TYPE_GUILD"] = "公会"
L["SEARCH_TYPE_INDIV"] = "个人"
L["SUGGESTIONS_EMPTY"] = "Overachiever当前没有建议。"
L["SUGGESTIONS_EMPTY_TRADESKILL"] = "%s：Overachiever当前没有建议。"
L["SUGGESTIONS_HELP"] = "根据你的当前区域建议追踪成就。"
L["SUGGESTIONS_LOCATION"] = "区域："
L["SUGGESTIONS_LOCATION_NOSUBZONE"] = "（未指定）"
L["SUGGESTIONS_LOCATION_SUBZONE"] = "子区域："
L["SUGGESTIONS_LOCATION_TIP"] = "无视区域/副本位置"
L["SUGGESTIONS_LOCATION_TIP2"] = "在字段中输入一个完整的有效区域或副本名称，以取得提示。若字段保持空白，则会根据你目前的所在位置。当光标在字段中时，按下|cffffffffTab|r键可根据已输入的内容依序产生有效的完整位置名称。按下|cffffffffShift+Tab|r则产生前一个名称。如果光标在字段的最左侧，它将依序产生所有有效位置名称。"
L["SUGGESTIONS_REFRESH"] = "刷新"
L["SUGGESTIONS_RESULTS"] = "找到 %d 个建议。"
L["SUGGESTIONS_RESULTS_TRADESKILL"] = "%s：找到 %d 个建议。"
L["SUGGESTIONS_TAB"] = "建议"
L["TAB_HELP"] = "|cffffffffCtrl-点击|r一个成就跳转到它在标准成就界面的位置。|n|n |cffffffff蓝色背景|r表示此成就是你还没有完成前续内容的系列成就。|n|n |cffffffff红色背景|r表示此成就无法在当前人物的标准成就界面中找到，因为这是阵营专属成就，或是无法取得的‘光辉事迹’成就。|n|n  |cffffffff绿色背景|r 是提醒此成就最近在鼠标提示中显示过。"
L["TAB_SORT"] = "排序："
L["TAB_SORT_COMPLETE"] = "完成时间"
L["TAB_SORT_ID"] = "成就ID"
L["TAB_SORT_NAME"] = "名称"
L["TAB_SORT_POINTS"] = "成就点数"
L["WATCH_CLEAR"] = "清除"
L["WATCH_COPY"] = "复制"
L["WATCH_COPY_TIP"] = "当启用时，假如你 |cffffffffshift+alt+点击|r 一个标签上的成就，将会新增至指定的监视列表中。"
L["WATCH_DEFAULTLIST"] = "默认列表："
L["WATCH_DEFAULTLIST_TIP"] = "The specified list will be the Displayed List at the beginning of each session."
L["WATCH_DELETE"] = "删除"
L["WATCH_DISPLAYEDLIST"] = "已显示列表："
L["WATCH_EMPTY"] = "你的监视列表是空的。在成就标签上或是成就链接上 Alt+点击 来监视。"
L["WATCH_EMPTY_SHORT"] = "清空列表"
L["WATCH_ERR_INVALIDID"] = "已将\"%s\"从监视列表中移除：找不到这个成就。"
L["WATCH_HELP"] = "在其他成就标签上或是成就链接使用 |cffffffffalt+点击|r来新建你的监视列表. |cffffffffAlt+点击|r 将停止监视. "
L["WATCH_LIST_GLOBAL"] = "全局"
L["WATCH_LIST_PERCHAR"] = "字符特殊"
L["WATCH_NEW"] = "新增"
L["WATCH_POPUP_CLEARLIST"] = "确定要清除这个成就监视列表的内容么？"
L["WATCH_POPUP_DELETELIST"] = "确定要删除这个成就监视列表么？"
L["WATCH_POPUP_NEWLIST"] = "输入一个新的成就监视列表名称："
L["WATCH_TAB"] = "监视"
L.SUBZONES = {
	["Argent Pavilion"] = "银色大帐",
	["Argent Tournament Grounds"] = "银色比武场",
	["Formation Grounds"] = "练兵场",
	["Razorscale's Aerie"] = "锋鳞之巢",
	["Silver Covenant Pavilion"] = "银色盟约大帐",
	["Sunreaver Pavilion"] = "夺日者大帐",
	["The Alliance Valiants' Ring"] = "联盟勇士赛场",
	["The Argent Valiants' Ring"] = "银色勇士赛场",
	["The Aspirants' Ring"] = "候选者赛场",
	["The Assembly of Iron"] = "钢铁议会",
	["The Celestial Planetarium"] = "天文台",
	["The Clash of Thunder"] = "雷霆角斗场",
	["The Colossal Forge"] = "巨人熔炉",
	["The Conservatory of Life"] = "生命温室",
	["The Descent into Madness"] = "疯狂阶梯",
	["The Halls of Winter"] = "寒冬大厅",
	["The Horde Valiants' Ring"] = "部落勇士赛场",
	["The Observation Ring"] = "观测场",
	["The Prison of Yogg-Saron"] = "尤格-萨隆的监狱",
	["The Ring of Champions"] = "冠军赛场",
	["The Scrapyard"] = "废料场",
	["The Shattered Walkway"] = "破碎通道",
	["The Spark of Imagination"] = "思想火花",
}


elseif (locale == "ruRU") then  -- Russian
L["SEARCH_ANY"] = "Всё перечисленное:"
L["SEARCH_CRITERIA"] = "Критерий:"
L["SEARCH_DESC"] = "Описание:"
L["SEARCH_FULLLIST"] = "Искать по всем достижениям" -- Needs review
L["SEARCH_FULLLIST_TIP"] = "В поиск будут включаться все достижения, включая не представленные в стандартном интерфейсе (например, достижения для противоположной фракции или невыполнимые)."
L["SEARCH_HELP"] = "Воспользуйтесь этой вкладкой для поиска достижений. Вы также можете искать достижения по имени или номеру, используя команды часа. Более подробную информацию вы найдёте в файле readme.txt в папке аддона."
L["SEARCH_NAME"] = "Название:"
L["SEARCH_RESET"] = "Сбросить"
L["SEARCH_RESULTS"] = "Найдено достижений: %s."
L["SEARCH_REWARD"] = "Награда:"
L["SEARCH_SUBMIT"] = "Поиск"
L["SEARCH_TAB"] = "Поиск"
L["SEARCH_TYPE"] = "Тип:"
L["SEARCH_TYPE_ALL"] = "Все"
L["SEARCH_TYPE_GUILD"] = "Гильдия"
L["SEARCH_TYPE_INDIV"] = "Лично"
L["SUGGESTIONS_EMPTY"] = "В данный момент подходящих достижений не обнаружено."
L["SUGGESTIONS_EMPTY_TRADESKILL"] = "%s: Overachiever для вас в данный момент не имеет предложений."
L["SUGGESTIONS_HELP"] = "Предпологаемые достижения, указанные здесь, основаны на вашем текущем местоположении. Также здесь могут находиться достижения, объекты к которым вы повстречали за последние 2 минуты."
L["SUGGESTIONS_LOCATION"] = "Локация:"
L["SUGGESTIONS_LOCATION_NOSUBZONE"] = "(неопределёно)"
L["SUGGESTIONS_LOCATION_SUBZONE"] = "Подзона:"
L["SUGGESTIONS_LOCATION_TIP"] = "Пересечение Зоны/Подземелья в локации"
L["SUGGESTIONS_LOCATION_TIP2"] = "Оставьте бланк чтобы получить варианты вашей текущей локации или начните набирать совпадающие правильные названия Зоны или Подземелья. Нажмите |cffffffffTab|r чтобы переключатся циклически между локациями с текстом слева от курсора. |cffffffffShift+Tab|r показывает это в обратном порядке. Если курсор на левой крайней позиции, значит этот цикл между всеми правильными локациями."
L["SUGGESTIONS_REFRESH"] = "Обновить"
L["SUGGESTIONS_RESULTS"] = "Найдено предполагаемых\\nдостижений: %d."
L["SUGGESTIONS_RESULTS_TRADESKILL"] = "%s: %d |4предложение:предложений; найденно."
L["SUGGESTIONS_TAB"] = "Предположения"
L["TAB_HELP"] = "|cffffffffCtrl+левый клик|r на достижении перенаправит вас к его местоположению в стандартном интерфейсе.|n|n|cffffffffСиний фон|r означает, что это часть серии достижений, для которой вы ещё не выполнили предыдущий шаг.|n|n|cffffffffКрасный фон|r означает, что это достижение не может быть найдено в стандартном интерфейсе, так оно эксклюзивно для противоположной фракции или невыполнимо по какой-либо причине.|n|n|cffffffffЗелёный фон|r означает, что совсем недавно вы встречали объект, необходимый для этого достижения."
L["TAB_SORT"] = "Сортировать по:"
L["TAB_SORT_COMPLETE"] = "дате завершения"
L["TAB_SORT_ID"] = "номеру"
L["TAB_SORT_NAME"] = "названию"
L["TAB_SORT_POINTS"] = "очкам"
L["WATCH_CLEAR"] = "Чисто"
L["WATCH_COPY"] = "Скопировать в:"
L["WATCH_COPY_TIP"] = "Когда включено, если вы |cffffffffshift+alt+click|r на достижении в этой вкладке, оно будет добавлено в специальный отслеживаемый лист."
L["WATCH_DEFAULTLIST"] = "Стандартный лист:"
L["WATCH_DEFAULTLIST_TIP"] = "Специальный лист будет показан Отображаемым Листом в начале каждой сессии."
L["WATCH_DELETE"] = "Удалить"
L["WATCH_DISPLAYEDLIST"] = "Отображаемый лист:"
L["WATCH_EMPTY"] = "Ваш список наблюдений пуст. Нажмите на достижение Alt+Клик для наблюдения за ним."
L["WATCH_EMPTY_SHORT"] = "Пустой лист"
L["WATCH_ERR_INVALIDID"] = "Удален \"%s\" из списка: достижение с ID не может быть найдено."
L["WATCH_HELP"] = "Создайте ваш список наблюдений нажав  |cffffffffalt+клик|r по достижению в других закладках или по ссылке в чате. Нажав |cffffffffAlt+клик|r по одному из присутствующих достижений вы удалите его из списка."
L["WATCH_LIST_GLOBAL"] = "Общее"
L["WATCH_LIST_PERCHAR"] = "По персонажу"
L["WATCH_NEW"] = "Новая"
L["WATCH_POPUP_CLEARLIST"] = "Вкладки"
L["WATCH_POPUP_DELETELIST"] = "Вы точно уверены что хотите удалить текущий список слежения за достижениями?"
L["WATCH_POPUP_NEWLIST"] = "Ведите имя нового списка слежения за достижениями:"
L["WATCH_TAB"] = "Наблюдение"
L.SUBZONES = {
	["Argent Pavilion"] = "Серебряный павильон",
	["Argent Tournament Grounds"] = "Ристалище Серебряного турнира",
	["Formation Grounds"] = "Плац",
	["Razorscale's Aerie"] = "Гнездо Острокрылой",
	["Silver Covenant Pavilion"] = "Павильон Серебряного Союза",
	["Sunreaver Pavilion"] = "Павильон Похитителей Солнца",
	["The Alliance Valiants' Ring"] = "Арена искателей славы из Альянса",
	["The Argent Valiants' Ring"] = "Арена искателей славы Серебряного Авангарда",
	["The Aspirants' Ring"] = "Арена претендентов",
	["The Assembly of Iron"] = "Железное Собрание",
	["The Celestial Planetarium"] = "Священный Планетарий",
	["The Clash of Thunder"] = "Раскаты Грома",
	["The Colossal Forge"] = "Гигантская кузня",
	["The Conservatory of Life"] = "Оранжерея Жизни",
	["The Descent into Madness"] = "Провал Безумия",
	["The Halls of Winter"] = "Залы Зимы",
	["The Horde Valiants' Ring"] = "Арена искателей славы из Орды",
	["The Observation Ring"] = "Круг Наблюдения",
	["The Prison of Yogg-Saron"] = "Темница Йогг-Сарона",
	["The Ring of Champions"] = "Арена чемпионов",
	["The Scrapyard"] = "Мусорная свалка",
	["The Shattered Walkway"] = "Обвалившаяся галерея",
	["The Spark of Imagination"] = "Искра Воображения",
}


elseif (locale == "koKR") then  -- Korean
L["SEARCH_ANY"] = "다음 중 적어도 하나 포함:"
L["SEARCH_CRITERIA"] = "기준:"
L["SEARCH_DESC"] = "내용:"
L["SEARCH_FULLLIST"] = "모든 업적(숨겨진 업적 포함) 검색"
L["SEARCH_FULLLIST_TIP"] = "달성하지 않은 위업이나 반대 평판때문에 기본 UI에서는 표시되지 않는 업적들도 모두 표시합니다."
L["SEARCH_HELP"] = "업적을 검색하려면 이 탭을 이용하십시오. 또한 /명령어를 이용해서 이름이나 ID로 검색할 수도 있습니다. (자세한 내용은 readme.txt 참고하세요.)"
L["SEARCH_NAME"] = "이름:"
L["SEARCH_RESET"] = "초기화"
L["SEARCH_RESULTS"] = "%s개의 업적을 찾음."
L["SEARCH_REWARD"] = "보상:"
L["SEARCH_SUBMIT"] = "검색"
L["SEARCH_TAB"] = "검색"
L["SEARCH_TYPE"] = "유형:"
L["SEARCH_TYPE_ALL"] = "모두"
L["SEARCH_TYPE_GUILD"] = "길드"
L["SEARCH_TYPE_INDIV"] = "개인"
L["SUGGESTIONS_EMPTY"] = "지금은 Overachiever가 추천하는 업적이 없습니다."
L["SUGGESTIONS_EMPTY_TRADESKILL"] = "%s: 지금은 Overachiever가 추천하는 업적이 없습니다."
L["SUGGESTIONS_HELP"] = "추천된 업적은 플레이어의 현재 위치를 기준하여 표시됩니다. 또한 2분전까지 툴팁으로 알려주었던 업적도 포함됩니다."
L["SUGGESTIONS_LOCATION"] = "위치:"
L["SUGGESTIONS_LOCATION_NOSUBZONE"] = "(미지정)"
L["SUGGESTIONS_LOCATION_SUBZONE"] = "세부지역:"
L["SUGGESTIONS_LOCATION_TIP"] = "지역/던전 추천"
L["SUGGESTIONS_LOCATION_TIP2"] = "현재 지역의 추천 업적이나 지역에 맞는 추천을 위해 남깁니다. |cffffffffTab|r키를 누르면 커서의 왼쪽에 해당되는 내용이 표시됩니다. |cffffffffShift+Tab|r누르면 역순으로 표시됩니다. 커서가 왼쪽에 근접하면 모든 해당지역이 표시됩니다."
L["SUGGESTIONS_REFRESH"] = "새로 고침"
L["SUGGESTIONS_RESULTS"] = "추천하는 업적 %d개."
L["SUGGESTIONS_RESULTS_TRADESKILL"] = "%s: 추천하는 업적 %d개."
L["SUGGESTIONS_TAB"] = "추천"
L["TAB_HELP"] = "|cffffffff컨트롤+좌클릭|r으로 기본 UI의 해당 업적으로 이동할 수 있습니다.|n|n|cffffffff푸른 바탕|r은 완료되지 않은 업적 세트의 일부를 의미합니다.|n|n|cffffffff붉은 바탕|r은 반대 평판 등의 이유로 이 캐릭터의 기본 UI에는 존재하지 않는 업적을 의미합니다.|n|n|cffffffff녹색 바탕|r은 이 업적과 관련된 알림 정보가 최근 툴팁에 표시되었음을 의미합니다."
L["TAB_SORT"] = "정렬 기준:"
L["TAB_SORT_COMPLETE"] = "완료된 날짜 순"
L["TAB_SORT_ID"] = "ID 순"
L["TAB_SORT_NAME"] = "이름 순"
L["TAB_SORT_POINTS"] = "업적 점수 순"
L["WATCH_CLEAR"] = "지우기"
L["WATCH_COPY"] = "복사"
L["WATCH_COPY_TIP"] = "현재 탭의 업적에 |cffffffffshift+alt+click|r하면, 추적 목록에 표시됩니다."
L["WATCH_DEFAULTLIST"] = "기본 목록:"
L["WATCH_DEFAULTLIST_TIP"] = "지정된 목록이 각 세션의 처음에 표시된 목록입니다."
L["WATCH_DELETE"] = "삭제"
L["WATCH_DISPLAYEDLIST"] = "표시된 목록:"
L["WATCH_EMPTY"] = "추적 목록이 비었습니다. 다른 탭의 업적을 <알트+클릭>하여 해당 업적을 추적할 수 있습니다."
L["WATCH_EMPTY_SHORT"] = "빈 목록"
L["WATCH_ERR_INVALIDID"] = "추적 목록에서 '%s' 삭제: 업적 ID를 찾을 수 없습니다."
L["WATCH_HELP"] = "다른 탭이나 업적 링크에서 |cffffffffAlt+좌클릭|r하여 추적 항목을 추가할 수 있습니다. 현재 창에서 |cffffffffAlt+좌클릭|r하면 추적 목록에서 제거합니다."
L["WATCH_LIST_GLOBAL"] = "전체"
L["WATCH_LIST_PERCHAR"] = "현재 캐릭터 한정"
L["WATCH_NEW"] = "신규"
L["WATCH_POPUP_CLEARLIST"] = "현재 추천 업적 목록을 초기화 하시겠습니까?"
L["WATCH_POPUP_DELETELIST"] = "현재 추천 업적 목록을 삭제 하시겠습니까?"
L["WATCH_POPUP_NEWLIST"] = "새로운 추천 업적 목록의 이름을 입력하세요."
L["WATCH_TAB"] = "추적"
L.SUBZONES = {
	["Argent Pavilion"] = "은빛십자군 막사",
	["Argent Tournament Grounds"] = "은빛십자군 마상시합 광장",
	["Formation Grounds"] = "전투대형 훈련장",
	["Razorscale's Aerie"] = "칼날비늘의 둥지",
	["Silver Covenant Pavilion"] = "은빛 서약단 막사",
	["Sunreaver Pavilion"] = "선리버 막사",
	["The Alliance Valiants' Ring"] = "얼라이언스 용맹전사의 투기장",
	["The Argent Valiants' Ring"] = "은빛십자군 용맹전사의 투기장",
	["The Aspirants' Ring"] = "지원자의 투기장",
	["The Assembly of Iron"] = "무쇠 회합실",
	["The Celestial Planetarium"] = "별자리 투영관",
	["The Clash of Thunder"] = "천둥의 울림",
	["The Colossal Forge"] = "거대 제련실",
	["The Conservatory of Life"] = "생명의 정원",
	["The Descent into Madness"] = "광기의 내리막길",
	["The Halls of Winter"] = "겨울의 전당",
	["The Horde Valiants' Ring"] = "호드 용맹전사의 투기장",
	["The Observation Ring"] = "관찰 지구",
	["The Prison of Yogg-Saron"] = "요그사론의 감옥",
	["The Ring of Champions"] = "용사의 투기장",
	["The Scrapyard"] = "고철 야적장",
	["The Shattered Walkway"] = "부서진 산책로",
	["The Spark of Imagination"] = "상상의 흔적",
}


elseif (locale == "esES" or locale == "esMX") then  -- Spanish
L["SEARCH_ANY"] = "Cualquiera de los anteriores:"
L["SEARCH_CRITERIA"] = "Requisitos:"
L["SEARCH_DESC"] = "Descripción:"
L["SEARCH_FULLLIST"] = "Incluir logros ocultos"
L["SEARCH_FULLLIST_TIP"] = "Incluye en la búsqueda de logros aquellos que normalmente no aparecen en el interface por defecto, como aquellos exclusivos de la facción contraria, Logros de fuerza sin conseguir, etc."
L["SEARCH_HELP"] = "Usa esta pestaña para buscar logros. También puedes usar los comandos de chat para buscar logros por nombre o ID. Lee el archivo readme.txt de Overachiever para más detalles."
L["SEARCH_NAME"] = "Nombre:"
L["SEARCH_RESET"] = "Limpiar"
L["SEARCH_RESULTS"] = "|4Encontrado:Encontrados; %s |4logro:logros;."
L["SEARCH_REWARD"] = "Recompensa:"
L["SEARCH_SUBMIT"] = "Buscar"
L["SEARCH_TAB"] = "Búsqueda"
L["SEARCH_TYPE"] = "Tipo:"
L["SEARCH_TYPE_ALL"] = "Todo"
L["SEARCH_TYPE_GUILD"] = "Hermandad"
L["SEARCH_TYPE_INDIV"] = "Personal"
L["SUGGESTIONS_EMPTY"] = "Overachiever no tiene sugerencias para ti en este momento."
L["SUGGESTIONS_EMPTY_TRADESKILL"] = "%s: Overachiever no tiene sugerencias para tí en este momento."
L["SUGGESTIONS_HELP"] = "Las sugerencias de logros aquí listados se basan en tu ubicación actual. También se lista cualquier logro del cual se te ha mostrado un tooltip recordatorio en los últimos dos minutos."
L["SUGGESTIONS_LOCATION"] = "Ubicación:"
L["SUGGESTIONS_LOCATION_NOSUBZONE"] = "(sin especificar)"
L["SUGGESTIONS_LOCATION_SUBZONE"] = "Subzona:"
L["SUGGESTIONS_LOCATION_TIP"] = "Ignorar la ubicación actual"
L["SUGGESTIONS_LOCATION_TIP2"] = "Déjalo en blanco para obtener sugerencias sobre tu ubicación actual o empieza a teclear para obtener una zona o instancia coincidente válida para usar en vez de la actual. Pulsa |cffffffffTabulador|r para alternar entre las ubicaciones que coinciden con el texto a la izquierda del cursor. |cffffffffSfit+Tabulador|r alterna invirtiendo el orden. Si el cursor está en la izquierda del todo, alternará entre todas las ubicaciones válidas."
L["SUGGESTIONS_REFRESH"] = "Actualizar"
L["SUGGESTIONS_RESULTS"] = "%d |4sugerencia:sugerencias; |4encontrada:encontradas;"
L["SUGGESTIONS_RESULTS_TRADESKILL"] = "%s: %d |4sugerencia:sugerencias; |4encontrada:encontradas;"
L["SUGGESTIONS_TAB"] = "Sugerencias"
L["TAB_HELP"] = "|cffffffffCtrl-click|r sobre un logro para saltar a su posición en el interface estándar.|n|nUn |cfffffffffondo azul|r indica que es parte de una serie para la que aún no has completado un paso anterior.|n|nUn |cfffffffffondo rojo|r indica que no se encuentra en el interface estándar para este personaje porque es exclusivo de la facción contraria o es una Proeza de fuerza que aún no has logrado.|n|nUn |cfffffffffondo verde|r indica que se ha mostrado un tooltip recordatorio sobre este logro recientemente."
L["TAB_SORT"] = "Ordenado por:"
L["TAB_SORT_COMPLETE"] = "Fecha de finalización"
L["TAB_SORT_ID"] = "ID"
L["TAB_SORT_NAME"] = "Nombre"
L["TAB_SORT_POINTS"] = "Puntuación"
L["WATCH_CLEAR"] = "Limpiar"
L["WATCH_COPY"] = "Copiar a:"
L["WATCH_COPY_TIP"] = "Al activarlo, si haces |cffffffffshift+alt+click|r sobre un logro en esta pestaña, éste será añadido a la lista de seguimiento especificada."
L["WATCH_DEFAULTLIST"] = "Lista por Defecto:"
L["WATCH_DEFAULTLIST_TIP"] = "La lista especificada será la Lista Mostrada al inicio de cada sesión."
L["WATCH_DELETE"] = "Borrar"
L["WATCH_DISPLAYEDLIST"] = "Lista Mostrada:"
L["WATCH_EMPTY"] = "Tu lista de vigilancia está vacía. Alt+click sobre un logro en otra pestaña o sobre el enlace de un logro en el chat para vigilarlo."
L["WATCH_EMPTY_SHORT"] = "Lista Vacía"
L["WATCH_ERR_INVALIDID"] = "Quitado \"%s\" de la lista de vigilancia: no se ha podido encontrar ningún logro con esa ID."
L["WATCH_HELP"] = "Crea tu lista de vigilancia haciendo |cffffffffalt+click|r sobre logros en las otras pestañas o sobre enlaces de logros el el chat. |cffffffffAlt+click|r sobre uno mostrado aquí para dejar de vigilarlo."
L["WATCH_LIST_GLOBAL"] = "Global"
L["WATCH_LIST_PERCHAR"] = "Específica de cada personaje"
L["WATCH_NEW"] = "Nueva"
L["WATCH_POPUP_CLEARLIST"] = "¿ Estás seguro de que deseas limpiar el contenido de la lista de seguimiento de logros actual ?"
L["WATCH_POPUP_DELETELIST"] = "¿ Estás seguro de que deseas borrar permanentemente la lista de seguimiento de logros actual ?"
L["WATCH_POPUP_NEWLIST"] = "Introduce el nombre de tu nueva lista de seguimiento de logros:"
L["WATCH_TAB"] = "Seguimiento"
L.SUBZONES = {
	["Argent Pavilion"] = "Pabellón Argenta",
	["Argent Tournament Grounds"] = "Campos del Torneo Argenta",
	["Formation Grounds"] = "Campo de Formación",
	["Razorscale's Aerie"] = "Nidal de Tajoescama",
	["Silver Covenant Pavilion"] = "Pabellón de El Pacto de Plata",
	["Sunreaver Pavilion"] = "Pabellón Atracasol",
	["The Alliance Valiants' Ring"] = "La Liza de los Valerosos de la Alianza",
	["The Argent Valiants' Ring"] = "La Liza de los Valerosos Argenta",
	["The Aspirants' Ring"] = "La Liza de los Aspirantes",
	["The Assembly of Iron"] = "La Asamblea de Hierro",
	["The Celestial Planetarium"] = "El Planetario Celestial",
	["The Clash of Thunder"] = "El Fragor del Trueno",
	["The Colossal Forge"] = "La Forja Colosal",
	["The Conservatory of Life"] = "El Invernadero de Vida",
	["The Descent into Madness"] = "El Descenso a la Locura",
	["The Halls of Winter"] = "Las Cámaras del Invierno",
	["The Horde Valiants' Ring"] = "La Liza de los Valerosos de la Horda",
	["The Observation Ring"] = "El Circulo de Observación",
	["The Prison of Yogg-Saron"] = "La Prisión de Yogg-Saron",
	["The Ring of Champions"] = "La Liza de los Campeones",
	["The Scrapyard"] = "La Chatarrería",
	["The Shattered Walkway"] = "La Pasarela Devastada",
	["The Spark of Imagination"] = "Chispa de Imaginación",
}


	if (locale == "esMX") then  -- Spanish (Mexican)
-- L["SEARCH_ANY"] = ""
-- L["SEARCH_CRITERIA"] = ""
-- L["SEARCH_DESC"] = ""
-- L["SEARCH_FULLLIST"] = ""
-- L["SEARCH_FULLLIST_TIP"] = ""
-- L["SEARCH_HELP"] = ""
-- L["SEARCH_NAME"] = ""
-- L["SEARCH_RESET"] = ""
-- L["SEARCH_RESULTS"] = ""
-- L["SEARCH_REWARD"] = ""
-- L["SEARCH_SUBMIT"] = ""
-- L["SEARCH_TAB"] = ""
-- L["SEARCH_TYPE"] = ""
-- L["SEARCH_TYPE_ALL"] = ""
-- L["SEARCH_TYPE_GUILD"] = ""
-- L["SEARCH_TYPE_INDIV"] = ""
-- L["SUGGESTIONS_EMPTY"] = ""
-- L["SUGGESTIONS_EMPTY_TRADESKILL"] = ""
-- L["SUGGESTIONS_HELP"] = ""
-- L["SUGGESTIONS_LOCATION"] = ""
-- L["SUGGESTIONS_LOCATION_NOSUBZONE"] = ""
-- L["SUGGESTIONS_LOCATION_SUBZONE"] = ""
-- L["SUGGESTIONS_LOCATION_TIP"] = ""
-- L["SUGGESTIONS_LOCATION_TIP2"] = ""
-- L["SUGGESTIONS_REFRESH"] = ""
-- L["SUGGESTIONS_RESULTS"] = ""
-- L["SUGGESTIONS_RESULTS_TRADESKILL"] = ""
-- L["SUGGESTIONS_TAB"] = ""
-- L["TAB_HELP"] = ""
-- L["TAB_SORT"] = ""
-- L["TAB_SORT_COMPLETE"] = ""
-- L["TAB_SORT_ID"] = ""
-- L["TAB_SORT_NAME"] = ""
-- L["TAB_SORT_POINTS"] = ""
-- L["WATCH_CLEAR"] = ""
-- L["WATCH_COPY"] = ""
-- L["WATCH_COPY_TIP"] = ""
-- L["WATCH_DEFAULTLIST"] = ""
-- L["WATCH_DEFAULTLIST_TIP"] = ""
-- L["WATCH_DELETE"] = ""
-- L["WATCH_DISPLAYEDLIST"] = ""
-- L["WATCH_EMPTY"] = ""
-- L["WATCH_EMPTY_SHORT"] = ""
-- L["WATCH_ERR_INVALIDID"] = ""
-- L["WATCH_HELP"] = ""
-- L["WATCH_LIST_GLOBAL"] = ""
-- L["WATCH_LIST_PERCHAR"] = ""
-- L["WATCH_NEW"] = ""
-- L["WATCH_POPUP_CLEARLIST"] = ""
-- L["WATCH_POPUP_DELETELIST"] = ""
-- L["WATCH_POPUP_NEWLIST"] = ""
-- L["WATCH_TAB"] = ""
-- L["SUBZONES/Argent Pavilion"] = ""
-- L["SUBZONES/Argent Tournament Grounds"] = ""
-- L["SUBZONES/Formation Grounds"] = ""
-- L["SUBZONES/Razorscale's Aerie"] = ""
-- L["SUBZONES/Silver Covenant Pavilion"] = ""
-- L["SUBZONES/Sunreaver Pavilion"] = ""
-- L["SUBZONES/The Alliance Valiants' Ring"] = ""
-- L["SUBZONES/The Argent Valiants' Ring"] = ""
-- L["SUBZONES/The Aspirants' Ring"] = ""
-- L["SUBZONES/The Assembly of Iron"] = ""
-- L["SUBZONES/The Celestial Planetarium"] = ""
-- L["SUBZONES/The Clash of Thunder"] = ""
-- L["SUBZONES/The Colossal Forge"] = ""
-- L["SUBZONES/The Conservatory of Life"] = ""
-- L["SUBZONES/The Descent into Madness"] = ""
-- L["SUBZONES/The Halls of Winter"] = ""
-- L["SUBZONES/The Horde Valiants' Ring"] = ""
-- L["SUBZONES/The Observation Ring"] = ""
-- L["SUBZONES/The Prison of Yogg-Saron"] = ""
-- L["SUBZONES/The Ring of Champions"] = ""
-- L["SUBZONES/The Scrapyard"] = ""
-- L["SUBZONES/The Shattered Walkway"] = ""
-- L["SUBZONES/The Spark of Imagination"] = ""


	-- We had to use "concat" instead of "subtable" for Curse's handle-subnamespaces substitution scheme so
	-- esMX's L.SUBZONES doesn't entirely overwrite esES's. This puts them in the format "SUBZONES/<key>";
	-- we'll iterate over the table to find those and put the values in the proper place:
		local tab = L.SUBZONES
		for k,v in pairs(L) do
			if (strsub(k, 1, 9) == "SUBZONES/") then
				tab[strsub(k, 10)] = v
				L[k] = nil
			end
		end
	end

elseif (locale == "ptBR") then  -- Brazilian Portuguese
L["SEARCH_ANY"] = "Qualquer acima:" -- Needs review
L["SEARCH_CRITERIA"] = "Critérios" -- Needs review
L["SEARCH_DESC"] = "Descrição:"
L["SEARCH_FULLLIST"] = "Incluir conquistas|nocultas" -- Needs review
L["SEARCH_FULLLIST_TIP"] = "Inclui na busca conquistas que não estão normalmente listadas na interface padrão do usuário, como aqueles exclusivos à facção oposta, conquistas indisponíveis, etc." -- Needs review
L["SEARCH_HELP"] = "Use essa aba para pesquisar conquistas. Voce pode também pesquisa-los por nome ou ID usando a barra de comandos. Veja o arquivo readme.txt do Overachiever para mais detalhes."
L["SEARCH_NAME"] = "Nome:" -- Needs review
L["SEARCH_RESET"] = "Reiniciar" -- Needs review
L["SEARCH_RESULTS"] = "%s |4conquista encontrada:conquistas encontradas;." -- Needs review
L["SEARCH_REWARD"] = "Recompensa:"
L["SEARCH_SUBMIT"] = "Pesquisar"
L["SEARCH_TAB"] = "Pesquisar"
L["SEARCH_TYPE"] = "Tipo:"
L["SEARCH_TYPE_ALL"] = "Todas"
L["SEARCH_TYPE_GUILD"] = "De Guilda" -- Needs review
L["SEARCH_TYPE_INDIV"] = "Pessoais" -- Needs review
L["SUGGESTIONS_EMPTY"] = "O Overachiever não tem sugestões para você neste momento."
L["SUGGESTIONS_EMPTY_TRADESKILL"] = "%s: O Overachiever não tem sugestões para você neste momento."
L["SUGGESTIONS_HELP"] = "As conquistas sugeridas estão listadas aqui de acordo com a sua localização. Também estão listadas as conquistas das quais você foi lembrado com uma dica de tela nos últimos 2 minutos ou cujo cronômetro começou recentemente."
L["SUGGESTIONS_LOCATION"] = "Local:" -- Needs review
L["SUGGESTIONS_LOCATION_NOSUBZONE"] = "(não especificado)"
L["SUGGESTIONS_LOCATION_SUBZONE"] = "Subzona:" -- Needs review
L["SUGGESTIONS_LOCATION_TIP"] = "Substituir Zona/Instância Atual" -- Needs review
L["SUGGESTIONS_LOCATION_TIP2"] = "Deixe em branco para mostrar sugestões para seu local atual ou comece a digitar para mostrar sugestões com base no nome de uma zona ou instância. Pressione |cffffffffTab|r para alternar entre locais que correspondem ao texto à esquerda do cursor. |cffffffffShift+Tab|r alterna na ordem inversa. Se o cursor estiver na posição mais à esquerda possível, alterna entre todos os locais válidos." -- Needs review
L["SUGGESTIONS_REFRESH"] = "Atualizar"
L["SUGGESTIONS_RESULTS"] = "%d |4sugestão encontrada:sugestões encontradas;."
L["SUGGESTIONS_RESULTS_TRADESKILL"] = "%s: %d |4sugestão encontrada:sugestões encontradas;."
L["SUGGESTIONS_TAB"] = "Sugestões"
L["TAB_HELP"] = "|cffffffffCtrl-clique|r em uma conquista para ir ao seu devido lugar na IU padrão.|n|nUm |cfffffffffundo azul|r significa que a conquista faz parte de uma série da qual você não completou um passo anterior.|n|nUm |cfffffffffundo vermelho|r significa que a conquista não pode ser encontrada na IU padrão para este personagem por ser exclusiva à facção oposta ou por ser uma Proeza Memorável.|n|nUm |cfffffffffundo verde|r significa que um lembrete desta conquista foi exibido recentemente em uma dica de tela ou tem um cronômetro que começou recentemente."
L["TAB_SORT"] = "Classificar por:"
L["TAB_SORT_COMPLETE"] = "Data completada" -- Needs review
L["TAB_SORT_ID"] = "ID"
L["TAB_SORT_NAME"] = "Nome"
L["TAB_SORT_POINTS"] = "Valor de pontos"
L["WATCH_CLEAR"] = "Limpar" -- Needs review
L["WATCH_COPY"] = "Copiar Para:"
L["WATCH_COPY_TIP"] = "Quando ativado, se você der um |cffffffffshift+alt+clique|r em uma conquista nesta aba, ela será adicionada à lista especificada. " -- Needs review
L["WATCH_DEFAULTLIST"] = "Lista Padrão:"
L["WATCH_DEFAULTLIST_TIP"] = "A lista especificada será a Lista Exibida no início de cada sessão." -- Needs review
L["WATCH_DELETE"] = "Excluir" -- Needs review
L["WATCH_DISPLAYEDLIST"] = "Lista Exibida:" -- Needs review
L["WATCH_EMPTY"] = "Sua lista de conquistas vigiadas está vazia. Alt+clique em uma conquista em outra aba ou em um link para uma conquista em uma conversa para vigiá-la."
L["WATCH_EMPTY_SHORT"] = "Lista Vazia"
L["WATCH_ERR_INVALIDID"] = "\"%s\" foi removida da Lista de Conquistas Vigiadas: Uma conquista com este ID não pôde ser encontrada." -- Needs review
L["WATCH_HELP"] = "Crie sua lista de conquistas vigiadas dando um |cffffffffalt+clique|r em conquistas nas outras abas ou em links de conquistas em uma conversa."
L["WATCH_LIST_GLOBAL"] = "Global"
L["WATCH_LIST_PERCHAR"] = "Este personagem"
L["WATCH_NEW"] = "Nova" -- Needs review
L["WATCH_POPUP_CLEARLIST"] = "Tem certeza de que deseja limpar o conteúdo da lista de conquistas vigiadas atual?"
L["WATCH_POPUP_DELETELIST"] = "Tem certeza de que deseja excluir permanentemente a lista de observação de conquistas atuais?"
L["WATCH_POPUP_NEWLIST"] = "Digite o nome da sua nova lista de conquistas vigiadas:"
L["WATCH_TAB"] = "Vigiar"
L.SUBZONES = {
	["Argent Pavilion"] = "Abas → SUBZONAS",
	["Argent Tournament Grounds"] = "Abas → SUBZONAS",
	["Formation Grounds"] = "Campos de Formação", -- Needs review
	["Razorscale's Aerie"] = "Abas → SUBZONAS",
	["Silver Covenant Pavilion"] = "Abas → SUBZONAS",
	["Sunreaver Pavilion"] = "Abas → SUBZONAS",
	["The Alliance Valiants' Ring"] = "Abas → SUBZONAS",
	["The Argent Valiants' Ring"] = "Abas → SUBZONAS",
	["The Aspirants' Ring"] = "Abas → SUBZONAS",
	["The Assembly of Iron"] = "A Assembleia de Ferro", -- Needs review
	["The Celestial Planetarium"] = "O Planetário Celestial", -- Needs review
	["The Clash of Thunder"] = "Abas → SUBZONAS", -- Needs review
	["The Colossal Forge"] = "Abas → SUBZONAS", -- Needs review
	["The Conservatory of Life"] = "Abas → SUBZONAS", -- Needs review
	["The Descent into Madness"] = "Abas → SUBZONAS", -- Needs review
	["The Halls of Winter"] = "Abas → SUBZONAS", -- Needs review
	["The Horde Valiants' Ring"] = "Abas → SUBZONAS",
	["The Observation Ring"] = "Abas → SUBZONAS", -- Needs review
	["The Prison of Yogg-Saron"] = "Abas → SUBZONAS", -- Needs review
	["The Ring of Champions"] = "Abas→SUBZONAS",
	["The Scrapyard"] = "Abas → SUBZONAS", -- Needs review
	["The Shattered Walkway"] = "Abas → SUBZONAS",
	["The Spark of Imagination"] = "Abas → SUBZONAS",
}


end
if (not L.SUBZONES) then
	L.SUBZONES = {
	-- Ulduar:
		["Formation Grounds"] = "Formation Grounds",
		["Razorscale's Aerie"] = "Razorscale's Aerie",
		["The Assembly of Iron"] = "The Assembly of Iron",
		["The Celestial Planetarium"] = "The Celestial Planetarium",
		["The Clash of Thunder"] = "The Clash of Thunder",
		["The Colossal Forge"] = "The Colossal Forge",
		["The Conservatory of Life"] = "The Conservatory of Life",
		["The Descent into Madness"] = "The Descent into Madness",
		["The Halls of Winter"] = "The Halls of Winter",
		["The Observation Ring"] = "The Observation Ring",
		["The Prison of Yogg-Saron"] = "The Prison of Yogg-Saron",
		["The Scrapyard"] = "The Scrapyard",
		["The Shattered Walkway"] = "The Shattered Walkway",
		["The Spark of Imagination"] = "The Spark of Imagination",
	-- Icecrown:
		["Argent Tournament Grounds"] = "Argent Tournament Grounds",
		["The Ring of Champions"] = "The Ring of Champions",
		["Argent Pavilion"] = "Argent Pavilion",
		["The Argent Valiants' Ring"] = "The Argent Valiants' Ring",
		["The Aspirants' Ring"] = "The Aspirants' Ring",
		["The Alliance Valiants' Ring"] = "The Alliance Valiants' Ring",
		["Silver Covenant Pavilion"] = "Silver Covenant Pavilion",
		["Sunreaver Pavilion"] = "Sunreaver Pavilion",
		["The Horde Valiants' Ring"] = "The Horde Valiants' Ring",
	}
end
