﻿--susnow
local addon,ns = ...
local cfg = ns.cfg

local Locale = {
	zhCN = {
		ignore = "|cffffff00AutoLFG:自动离开队列(%s:已击杀%d/%d个首领)|r",
	},
	zhTW = {},
	enUS = {
		ignore = "|cffffff00AutoLFG:Auto leave the queue(%s:%d/%d Bosses defeated)|r"
	},
}
local L = Locale[GetLocale()]

local ALFG = CreateFrame("Frame",nil,LFGDungeonReadyDialog)
ALFG.durationBar = CreateFrame("StatusBar",nil,ALFG)
ALFG.durationBar.Border = CreateFrame("Frame",nil,ALFG.durationBar)
ALFG.durationTime	= ALFG.durationBar:CreateFontString(nil,"OVERLAY")
LFGDungeonReadyDialog.nextUpdate = 0

local leaveLFG = function(name,curKilled,maxKilled)
	LFGDungeonReadyDialogLeaveQueueButton:Click()
	print(string.format(L.ignore,name,curKilled,maxKilled))
end

local DurationWidget = function()
	ALFG:SetSize(LFGDungeonReadyDialog:GetWidth()*0.75,4)
	ALFG:SetPoint("BOTTOM",LFGDungeonReadyDialog,0,16)
	ALFG.durationBar:SetStatusBarTexture(cfg.tex)
	ALFG.durationBar:SetPoint("TOPLEFT",ALFG)
	ALFG.durationBar:SetPoint("BOTTOMRIGHT",ALFG)
	ALFG.durationBar:SetFrameLevel(LFGDungeonReadyDialog:GetFrameLevel()+1)
	ALFG.durationBar:SetStatusBarColor(1,.7,0,1)
	ALFG.durationBar.Border:SetBackdrop(cfg.backdrop)
	ALFG.durationBar.Border:SetBackdropColor(0,0,0,0)
	ALFG.durationBar.Border:SetBackdropBorderColor(0,0,0,1)
	ALFG.durationBar.Border:SetPoint("TOPLEFT",ALFG,-1,1)
	ALFG.durationBar.Border:SetPoint("BOTTOMRIGHT",ALFG,1,-1)
	ALFG.durationTime:SetFontObject(GameFontNormalLarge)
	do local f,s,g =  ALFG.durationTime:GetFont()
		ALFG.durationTime:SetFont(f,12,g)
		ALFG.durationTime:SetText("")
		ALFG.durationTime:SetPoint("RIGHT",LFGDungeonReadyDialogLeaveQueueButton,-8,0)
	end
end

local PostUpdateDurationBar = function()
	local obj =	LFGDungeonReadyDialog	
	local oldTime = GetTime()
	local flag = 0
	local duration = 40 
	local interval = 0.1 
	obj:SetScript("OnUpdate",function(self,elapsed)
		obj.nextUpdate = obj.nextUpdate + elapsed
		if obj.nextUpdate > interval then
			local newTime = GetTime()
			if (newTime - oldTime) < duration then
				local width = ALFG:GetWidth() * (newTime - oldTime)/duration
				ALFG.durationBar:SetPoint("BOTTOMRIGHT",ALFG,0-width,0)
				ALFG.durationTime:SetText(string.format("%d",(duration - (newTime - oldTime))))		
				flag = flag + 1
				if flag >= 10 then
					PlaySoundFile(cfg.countSound2,"Master")
					flag = 0
				end
			else
				obj:SetScript("OnUpdate",nil)
			end
			obj.nextUpdate = 0
		end
	end)
end

local IgnoreOldDungeon = function()
	local killedInfo = LFGDungeonReadyDialogInstanceInfoFrame.statusText:GetText()
		local nameInfo = LFGDungeonReadyDialogInstanceInfoFrame.name:GetText()	
		local curKilled = 0
		local maxKilled = 0
		if killedInfo then 
			local i,j = string.find(killedInfo,"%/")
			curKilled = string.sub(killedInfo,i-1,j-1)
			maxKilled = string.sub(killedInfo,i+1,i+1)
			if tonumber(curKilled) > 0 and cfg.igonoreOld then
				leaveLFG(nameInfo,curKilled,maxKilled)
			end
		end
end

--init
do DurationWidget() end
ALFG:RegisterEvent("LFG_PROPOSAL_SHOW")
ALFG:SetScript("OnEvent",function(self,e)
	if LFGDungeonReadyDialog:IsShown() then
		PostUpdateDurationBar()
		IgnoreOldDungeon()	
	end
end)

