--[[
AdiBags - Adirelle's bag addon.
Copyright 2010-2012 Adirelle (adirelle@gmail.com)
All rights reserved.
--]]

local addonName, addon = ...

--<GLOBALS
local _G = _G
local GetLocale = _G.GetLocale
local pairs = _G.pairs
local rawset = _G.rawset
local setmetatable = _G.setmetatable
local tostring = _G.tostring
--GLOBALS>

local L = setmetatable({}, {
	__index = function(self, key)
		if key ~= nil then
			--[===[@debug@
			addon:Debug('Missing locale', tostring(key))
			--@end-debug@]===]
			rawset(self, key, tostring(key))
		end
		return tostring(key)
	end,
})
addon.L = L

L["QUIVER_TAG"] = "Qu"
L["AMMO_TAG"] = "Am"
L["SOUL_BAG_TAG"] = "So"
L["LEATHERWORKING_BAG_TAG"] = "Le"
L["INSCRIPTION_BAG_TAG"] = "In"
L["HERB_BAG_TAG"] = "He"
L["ENCHANTING_BAG_TAG"] = "En"
L["ENGINEERING_BAG_TAG"] = "Eg"
L["KEYRING_TAG"] = "Ke"
L["GEM_BAG_TAG"] = "Ge"
L["MINING_BAG_TAG"] = "Mi"
L["TACKLE_BOX_TAG"] = "Fi"
L["COOKING_BAR_TAG"] = "Co"

-- Get LibBabble-Inventory-3.0
addon.BI = LibStub('LibBabble-Inventory-3.0'):GetLookupTable()

--------------------------------------------------------------------------------
-- Locales from localization system
--------------------------------------------------------------------------------

-- %Localization: adibags
-- THE END OF THE FILE IS UPDATED BY https://github.com/Adirelle/wowaceTools/#updatelocalizationphp.
-- ANY CHANGE BELOW THESES LINES WILL BE LOST.
-- UPDATE THE TRANSLATIONS AT http://www.wowace.com/addons/adibags/localization/
-- AND ASK THE AUTHOR TO UPDATE THIS FILE.

-- @noloc[[

------------------------ enUS ------------------------


-- config/Config-ItemList.lua
L["Click or drag this item to remove it."] = true
L["Drop an item there to add it to the list."] = true

-- config/Options.lua
L["... including incomplete stacks"] = true
L["Adjust the maximum height of the bags, relative to screen size."] = true
L["Adjust the maximum number of items per row."] = true
L["Anchored"] = true
L["As soon as possible"] = true
L["At mechants', bank, auction house, ..."] = true
L["Automatic layout update"] = true
L["Backpack color"] = true
L["Backpack"] = true
L["Bag background"] = true
L["Bag title"] = true
L["Bag type"] = true
L["Bags"] = true
L["Bank color"] = true
L["Bank"] = true
L["Border width"] = true
L["Border"] = true
L["By category, subcategory, quality and item level (default)"] = true
L["By name"] = true
L["By quality and item level"] = true
L["Change stacking at merchants', auction house, bank, mailboxes or when trading."] = true
L["Check this to display a bag type tag in the top left corner of items."] = true
L["Check this to display a colored border around items, based on item quality."] = true
L["Check this to display an indicator on quest items."] = true
L["Check this to have poor quality items dimmed."] = true
L["Check to enable this module."] = true
L["Click there to reset the bag positions and sizes."] = true
L["Click to toggle the bag anchor."] = true
L["Configure"] = true
L["Dim junk"] = true
L["Enabled bags"] = true
L["Enabled"] = true
L["Fill lines at most"] = true
L["Filters are used to dispatch items in bag sections. One item can only appear in one section. If the same item is selected by several filters, the one with the highest priority wins."] = true
L["Filters"] = true
L["Group sections of same category"] = true
L["Insets"] = true
L["Items"] = true
L["Keep all stacks together."] = true
L["Layout priority"] = true
L["Lock anchor"] = true
L["Manual"] = true
L["Maximum bag height"] = true
L["Maximum row width"] = true
L["Merge free space"] = true
L["Merge incomplete stacks with complete ones."] = true
L["Merge stackable items"] = true
L["Merge unstackable items"] = true
L["Not at merchants', bank, ..."] = true
L["Only when required"] = true
L["Opacity"] = true
L["Plugins"] = true
L["Position mode"] = true
L["Priority"] = true
L["Quality highlight"] = true
L["Quest indicator"] = true
L["Reset position"] = true
L["Right-click to open options"] = true
L["Scale"] = true
L["Section header"] = true
L["Select how items should be sorted within each section."] = true
L["Select how the bags are positionned."] = true
L["Select the top objective of the layout algorithm."] = true
L["Select which bags AdiBags should display."] = true
L["Separate incomplete stacks."] = true
L["Separate unstackable items."] = true
L["Show every distinct item stacks."] = true
L["Show only one free slot for each kind of bags."] = true
L["Show only one slot of items that can be stacked."] = true
L["Show only one slot of items that cannot be stacked."] = true
L["Skin"] = true
L["Sorting order"] = true
L["Strictly keep ordering"] = true
L["Texture"] = true
L["This setting allows to tone down what some people calls \"section dancing\" when moving/selling/milling items."] = true
L["Toggle and configure item filters."] = true
L["Toggle and configure plugins."] = true
L["Uncheck this to disable AdiBags."] = true
L["Unlock anchor"] = true
L["Use this to adjust the bag scale."] = true
L["Use this to adjust the quality-based border opacity. 100% means fully opaque."] = true
L["Virtual stacks display in one place items that actually spread over several bag slots."] = true
L["Virtual stacks"] = true
L["When checked, right-clicking on an empty space of a bag opens the configuration panel."] = true

-- core/Core.lua
L["Warning: you are using an alpha or beta version of AdiBags without displaying Lua errors. If anything goes wrong, AdiBags (or any other addon causing some error) will simply stop working for apparently no reason. Please either enable the display of Lua errors or install an error handler addon like BugSack or Swatter."] = true

-- core/DefaultFilters.lua
L["Ammunition"] = true
L["Check sets that should be merged into a unique \"Sets\" section. This is obviously a per-character setting."] = true
L["Check this so armors are dispatched in four sections by type."] = true
L["Check this to display one individual section per set. If this is disabled, there will be one big \"Sets\" section."] = true
L["Consider gems as a subcategory of trade goods"] = true
L["Consider glyphs as a subcategory of trade goods"] = true
L["Equipment"] = true
L["Four general sections."] = true
L["Gear manager item sets"] = true
L["Gems are trade goods"] = true
L["Glyphs are trade goods"] = true
L["Item category"] = true
L["Jewelry"] = true
L["Merged sets"] = true
L["One section per item slot."] = true
L["One section per set"] = true
L["Only one section."] = true
L["Please note this filter matchs every item. Any filter with lower priority than this one will have no effect."] = true
L["Put any item that can be equipped (including bags) into the \"Equipment\" section."] = true
L["Put items belonging to one or more sets of the built-in gear manager in specific sections."] = true
L["Put items in sections depending on their first-level category at the Auction House."] = true
L["Put quest-related items in their own section."] = true
L["Quest Items"] = true
L["Section setup"] = true
L["Select the sections in which the items should be dispatched."] = true
L["Select which first-level categories should be split by sub-categories."] = true
L["Set: %s"] = true
L["Sets"] = true
L["Split armors by types"] = true
L["Split by subcategories"] = true

-- core/Fonts.lua
L["Color"] = true
L["Font"] = true
L["Reset"] = true
L["Size"] = true
L["Text"] = true

-- core/Layout.lua
L["AdiBags Anchor"] = true

-- modules/BankSwitcher.lua
L["Bank Switcher"] = true
L["Move items from and to the bank by right-clicking on section headers."] = true
L["Right-click to move these items."] = true

-- modules/CurrencyFrame.lua
L["Currencies to show"] = true
L["Currency"] = true
L["Display character currency at bottom left of the backpack."] = true
L["Hide zeroes"] = true
L["Ignore currencies with null amounts."] = true
L["Right-click to configure."] = true

-- modules/DataSource.lua
L["Bag usage format"] = true
L["Check this to display an icon after usage of each type of bags."] = true
L["Check this to display an textual tag before usage of each type of bags."] = true
L["Check this to display only one value counting all equipped bags, ignoring their type."] = true
L["Check this to show space at your bank in the plugin."] = true
L["Free space / total space"] = true
L["Free space"] = true
L["LDB Plugin"] = true
L["Merge bag types"] = true
L["Provides a LDB data source to be displayed by LDB display addons."] = true
L["Select how bag usage should be formatted in the plugin."] = true
L["Show bag type icons"] = true
L["Show bag type tags"] = true
L["Show bank usage"] = true
L["Space in use / total space"] = true
L["Space in use"] = true

-- modules/FilterOverride.lua
L["Add association"] = true
L["Allow you manually redefine the section in which an item should be put. Simply drag an item on the section title."] = true
L["Alt-right-click to configure manual filtering."] = true
L["Are you sure you want to remove this section ?"] = true
L["Category"] = true
L["Click on a item to remove it from the list. You can drop an item on the empty slot to add it to the list."] = true
L["Click on this button to create the new association."] = true
L["Drop your item there to add it to this section."] = true
L["Enter the name of the section to associate with the item."] = true
L["Enter the name, link or itemid of the item to associate with the section. You can also drop an item into this box."] = true
L["Item"] = true
L["Manual filtering"] = true
L["New Override"] = true
L["Press Alt while doing so to open the configuration panel instead."] = true
L["Remove"] = true
L["Section category"] = true
L["Section"] = true
L["Select the category of the section to associate. This is used to group sections together."] = true
L["Use this section to define any item-section association."] = true

-- modules/Junk.lua
L["Alt-right-click to configure the Junk module."] = true
L["Exclude list"] = true
L["Include list"] = true
L["Included categories"] = true
L["Items in this list are always considered as junk. Click an item to remove it from the list."] = true
L["Items in this list are never considered as junk. Click an item to remove it from the list."] = true
L["Junk category"] = true
L["Low quality items"] = true
L["Nothing to sell."] = true
L["Put items of poor quality or labeled as junk in the \"Junk\" section."] = true
L["Right-click to sell these items."] = true

-- modules/MoneyFrame.lua
L["Display character money at bottom right of the backpack."] = true
L["Money"] = true

-- modules/NewItemTracking.lua
L["Click to reset item status."] = true
L["Highlight color"] = true
L["Highlight scale"] = true
L["Ignore low quality items"] = true
L["New item highlight"] = true
L["New"] = true
L["Reset new items"] = true
L["Track new items in each bag, displaying a glowing aura over them and putting them in a special section. \"New\" status can be reset by clicking on the small \"N\" button at top left of bags."] = true
L["Track new items"] = true

-- modules/SectionVisibilityDropdown.lua
L["Add a dropdown menu to bags that allow to hide the sections."] = true
L["Check this to show this section. Uncheck to hide it."] = true
L["Click to select which sections should be shown or hidden. Section visibility is common to all bags."] = true
L["Section visibility button"] = true
L["Section visibility"] = true
L["Show %s"] = true

-- modules/TidyBags.lua
L["Check this so tidying is performed when you close the loot windows or you leave merchants, mailboxes, etc."] = true
L["Click to tidy bags."] = true
L["Semi-automated tidy"] = true
L["Tidy bags"] = true
L["Tidy your bags by clicking on the small \"T\" button at the top left of bags. Special bags with free slots will be filled with macthing items and stackable items will be stacked to save space."] = true

-- modules/TooltipInfo.lua
L["AH category"] = true
L["AH subcategory"] = true
L["Add more information in tooltips related to items in your bags."] = true
L["Always"] = true
L["Bag number"] = true
L["Container information"] = true
L["Filter"] = true
L["Filtering information"] = true
L["Item information"] = true
L["Maximum stack size"] = true
L["Never"] = true
L["Show container information..."] = true
L["Show filtering information..."] = true
L["Show item information..."] = true
L["Slot number"] = true
L["Tooltip information"] = true
L["Virtual stack slots"] = true
L["When alt is held down"] = true
L["When any modifier key is held down"] = true
L["When ctrl is held down"] = true
L["When shift is held down"] = true

-- widgets/AnchorWidget.lua
L["Alt-right-click to switch to anchored placement."] = true
L["Alt-right-click to switch to manual placement."] = true
L["Drag to move this bag."] = true
L["Right-click to (un)lock the bag anchor."] = true

-- widgets/BagSlots.lua
L["Click to purchase"] = true
L["Equipped bags"] = true
L["Right-click to try to empty this bag."] = true

-- widgets/ContainerFrame.lua
L["Bag #%d"] = true
L["Bank bag #%d"] = true
L["Click to toggle the equipped bag panel, so you can change them."] = true
L["Close"] = true


------------------------ frFR ------------------------
local locale = GetLocale()
if locale == 'frFR' then
L["Add a dropdown menu to bags that allow to hide the sections."] = "Ajoute un menu déroulant aux sacs pour cacher les sections."
L["Add association"] = "Ajouter l'association"
L["Add more information in tooltips related to items in your bags."] = "Ajoute des informations additionnelles dans les bulles d'aides des objets de vos sacs."
L["AdiBags Anchor"] = "Ancre d'AdiBags"
L["Adjust the maximum height of the bags, relative to screen size."] = "Ajustez la taille maximale des sacs, par rapport à la taille de l'écran."
L["Adjust the maximum number of items per row."] = "Ajustez le nombre maximal d'objets par ligne."
L["AH category"] = "Catégorie HV"
L["AH subcategory"] = "Sous-catégorie HV"
L["Allow you manually redefine the section in which an item should be put. Simply drag an item on the section title."] = "Vous permet de redéfinir manuellement la section dans laquelle un objet doit être mis. Tirez simplement un objet sur le titre de section."
L["Alt-right-click to configure manual filtering."] = "Alt-clic-droit pour configurer les filtres manuels." -- Needs review
L["Alt-right-click to configure the Junk module."] = "Alt-clic-droit pour configurer le module \"Camelote\"." -- Needs review
L["Alt-right-click to switch to anchored placement."] = "Alt+clic-droit pour activer le placement ancré."
L["Alt-right-click to switch to manual placement."] = "Alt+clic-droit pour activer le placement manuel."
L["Always"] = "Toujours"
L["AMMO_TAG"] = "Ba"
L["Ammunition"] = "Munitions"
L["Anchored"] = "Ancrée"
L["Are you sure you want to remove this section ?"] = "Etes-vous sûr de vouloir effacer cette section ?"
L["As soon as possible"] = "Dès que possible"
L["At mechants', bank, auction house, ..."] = "Chez les marchands, à la banque, à l'hôtel des ventes, ..."
L["Automatic layout update"] = "Mise-à-jour automatique de la disposition"
L["Backpack"] = "Sac à dos"
L["Backpack color"] = "Couleur du sac à dos"
L["Bag background"] = "Arrière-plan des sacs"
L["Bag #%d"] = "Sac n°%d"
L["Bag number"] = "Numéro du sac"
L["Bags"] = "Sacs"
L["Bag title"] = "Titres des sacs" -- Needs review
L["Bag type"] = "Type de sac"
L["Bag usage format"] = "Format de l'usage des sacs"
L["Bank"] = "Banque"
L["Bank bag #%d"] = "Sac de banque n°%d"
L["Bank color"] = "Couleur de la banque"
L["Bank Switcher"] = "Banque rapide"
L["Border"] = "Bord"
L["Border width"] = "Largeur du bord"
L["By category, subcategory, quality and item level (default)"] = "Par catégorie, sous-catégorie, qualité et niveau d'objet (par défaut)"
L["By name"] = "Par nom"
L["By quality and item level"] = "Par qualité et niveau d'objet"
L["Category"] = "Catégorie"
L["Change stacking at merchants', auction house, bank, mailboxes or when trading."] = "Modifie l'empilement chez les marchands, à l'autel des ventes, à la banque, aux boîtes aux lettres et lors des échanges."
L["Check sets that should be merged into a unique \"Sets\" section. This is obviously a per-character setting."] = "Cochez les ensembles qui doivent être fusionnés en une section \"Ensembles\" unique. C'est évidemment un réglage spécifique à ce personnage."
L["Check this so armors are dispatched in four sections by type."] = "Cochez ceci pour que les armures sont distribuées dans quatre sections selon leur type."
L["Check this so tidying is performed when you close the loot windows or you leave merchants, mailboxes, etc."] = "Cochez ceci afin que les sacs soient rangés automatiquement quand vous fermez la fenêtre de butin ou de boîte aux lettres ou que vous quittez les marchands,"
L["Check this to display a bag type tag in the top left corner of items."] = "Cochez ceci pour afficher le type des sacs dans le coin supérieur gauche des objets."
L["Check this to display a colored border around items, based on item quality."] = "Cochez ceci pour afficher un bord coloré autour des objets basé sur leur qualité."
L["Check this to display an icon after usage of each type of bags."] = "Cochez ceci pour afficher une icône de type de sac après l'usage."
L["Check this to display an indicator on quest items."] = "Cochez ceci pour afficher un indicateur sur les objets de quête."
L["Check this to display an textual tag before usage of each type of bags."] = "Cochez ceci pour afficher le type de sac avant l'usage."
L["Check this to display one individual section per set. If this is disabled, there will be one big \"Sets\" section."] = "Cochez ceci pour afficher une section individuelle par ensemble d'équipement. Sinon, il n'y aura qu'une seule section \"Ensembles\"."
L["Check this to display only one value counting all equipped bags, ignoring their type."] = "Cochez ceci pour n'afficher qu'une seule valeur pour tous les sacs, quelque soit leur type."
L["Check this to have poor quality items dimmed."] = "Cochez ceci pour assombrir les objets de mauvaise qualité."
L["Check this to show space at your bank in the plugin."] = "Cochez ceci pour afficher l'espace libre de votre banque."
L["Check this to show this section. Uncheck to hide it."] = "Cochez ceci pour afficher cette section. Décochez-le pour la cacher."
L["Check to enable this module."] = "Cochez cette case pour activer ce module."
L["Click on a item to remove it from the list. You can drop an item on the empty slot to add it to the list."] = "Cliquer sur un objet pour le retirer de la liste. Vous pouvez mettre un objet dans l'emplacement vide pour l'ajouter à la liste."
L["Click on this button to create the new association."] = "Cliquez sur ce bouton pour créer la nouvelle association."
L["Click or drag this item to remove it."] = "Cliquez sur l'objet ou glissez-le pour le retirer."
L["Click there to reset the bag positions and sizes."] = "Cliquez ici pour remettre à zéro la position et la taille de sacs."
L["Click to purchase"] = "Cliquez pour acheter."
L["Click to reset item status."] = "Cliquez pour remettre à zéro les nouveaux objets."
L["Click to select which sections should be shown or hidden. Section visibility is common to all bags."] = "Cliquez pour sélectionner les sections à afficher ou à cacher. Ceci est commun à tous les sacs."
L["Click to tidy bags."] = "Cliquez pour ranger les sacs."
L["Click to toggle the bag anchor."] = "Cliquez pour afficher/cacher l'ancre des sacs."
L["Click to toggle the equipped bag panel, so you can change them."] = "Cliquez pour afficher/cacher le panneau des sacs équipés. Vous pourrez ainsi les manipuler."
L["Close"] = "Fermer"
L["Color"] = "Couleur" -- Needs review
L["Configure"] = "Configurer"
L["Consider gems as a subcategory of trade goods"] = "Considère les gemmes comme une sous-catégorie d'artisanat."
L["Consider glyphs as a subcategory of trade goods"] = "Considère les glyphes comme une sous-catégorie d'artisanat."
L["Container information"] = [=[Information sur le contenant
]=]
L["Currencies to show"] = "Monnaies à afficher"
L["Currency"] = "Insignes"
L["Dim junk"] = "Assombrir la camelote"
L["Display character currency at bottom left of the backpack."] = "Affiche les insignes du personnage en bas à gauche du sac à dos."
L["Display character money at bottom right of the backpack."] = "Affiche l'or du personnage en bas à droite du sac à dos."
L["Drag to move this bag."] = "Tirer pour déplacer ce sac."
L["Drop an item there to add it to the list."] = "Glissez un objet ici pour l'ajouter à la liste."
L["Drop your item there to add it to this section."] = "Déposez votre objet ici pour l'ajouter à cette section."
L["Enabled"] = "Activé"
L["ENCHANTING_BAG_TAG"] = "En"
L["ENGINEERING_BAG_TAG"] = "In"
L["Enter the name, link or itemid of the item to associate with the section. You can also drop an item into this box."] = "Entrez le nom, le lien ou l'identifiant de l'objet à associer à la section. Vous pouvez aussi déposer un objet dans cette boîte."
L["Enter the name of the section to associate with the item."] = "Entrez le nom de la section à associer à l'objet."
L["Equipment"] = "Equipement"
L["Equipped bags"] = "Sacs équipés"
L["Exclude list"] = "Liste \"exclus\""
L["Fill lines at most"] = "Remplir les lignes au maximum"
L["Filter"] = "Filtre"
L["Filtering information"] = "Information de filtrage"
L["Filters"] = "Filtres"
L["Filters are used to dispatch items in bag sections. One item can only appear in one section. If the same item is selected by several filters, the one with the highest priority wins."] = "Les filtres sont utilisés pour répartir les objets en section de sac. Un objet ne peut apparaître que dans une seule section. Si un objet correspond à plusieurs filtres, celui avec la meilleur priorité l'emporte."
L["Font"] = "Police"
L["Four general sections."] = "Quatre sections générales."
L["Free space"] = "Espace libre"
L["Free space / total space"] = "Espace libre / espace total"
L["Gear manager item sets"] = "Ensembles d'objets du gestionnaire d'équipement"
L["GEM_BAG_TAG"] = "Jo"
L["Gems are trade goods"] = "Gemmes dans artisanat"
L["Glyphs are trade goods"] = "Glyphes dans artisanat"
L["Group sections of same category"] = "Grouper les sections de la même catégorie"
L["HERB_BAG_TAG"] = "He"
L["Hide zeroes"] = "Cacher les zéros"
L["Highlight color"] = "Couleur du surlignage"
L["Highlight scale"] = "Echelle du surlignage"
L["Ignore currencies with null amounts."] = "Ignore les insignes en quantité nulle."
L["Ignore low quality items"] = "Ignorer les objets de mauvaise qualité"
L["Included categories"] = "Catégories incluses"
L["Include list"] = "Liste \"inclus\""
L["... including incomplete stacks"] = "... y compris les piles incomplètes"
L["INSCRIPTION_BAG_TAG"] = "Ca"
L["Insets"] = "Taille de l'insert"
L["Item"] = "Objet"
L["Item category"] = "Catégories d'objets"
L["Item information"] = "Informations sur l'objet"
L["Items"] = "Objets"
L["Items in this list are always considered as junk. Click an item to remove it from the list."] = "Les objets de cette liste sont considérés comme de la camelote. Cliquez sur un objet pour le retirer de la liste."
L["Items in this list are never considered as junk. Click an item to remove it from the list."] = "Les objets de cette liste ne sont jamais considérés comme de la camelote. Cliquez sur un objet pour le retirer de la liste."
L["Jewelry"] = "Joaillerie"
L["Junk category"] = "Catégorie camelote"
L["Keep all stacks together."] = "Conserver les piles ensembles."
L["KEYRING_TAG"] = "Cl"
L["Layout priority"] = "Priorité de disposition"
L["LDB Plugin"] = "Plugin LDB"
L["LEATHERWORKING_BAG_TAG"] = "Cu"
L["Lock anchor"] = "Verrouiller l'ancre"
L["Low quality items"] = "Objets de qualité médiocre."
L["Manual"] = "Manuelle"
L["Manual filtering"] = "Filtrage manuel"
L["Maximum bag height"] = "Hauteur maximale des sacs"
L["Maximum row width"] = "Largeur maximale des lignes"
L["Maximum stack size"] = "Taille maximale des piles"
L["Merge bag types"] = "Fusionner les types de sacs"
L["Merged sets"] = "Ensembles fusionnés"
L["Merge free space"] = "Fusionner l'espace libre"
L["Merge incomplete stacks with complete ones."] = "Fusionne les piles incomplètes avec celles qui sont complètes."
L["Merge stackable items"] = "Fusionne les objets empilables"
L["Merge unstackable items"] = "Fusionner les objets non-empilables"
L["MINING_BAG_TAG"] = "Mi"
L["Money"] = "Monnaie"
L["Move items from and to the bank by right-clicking on section headers."] = "Déplacer des objets de ou vers la banque en cliquant-droit sur les en-tête de section."
L["Never"] = "Jamais"
L["New"] = "Nouveau"
L["New item highlight"] = "Surlignage des nouveaux objets"
L["New Override"] = "Nouvelle association"
L["Not at merchants', bank, ..."] = "Pas chez les marchands, à la banque, ..."
L["Nothing to sell."] = "Rien à vendre."
L["One section per item slot."] = "Une section par emplacement d'équipement"
L["One section per set"] = "Une section par ensemble"
L["Only one section."] = "Seulement une section"
L["Only when required"] = "Seulement si nécessaire"
L["Opacity"] = "Opacité"
L["Please note this filter matchs every item. Any filter with lower priority than this one will have no effect."] = "Veuillez notez que ce filtre correspond à tous les objets. Tout filtre avec une priorité plus faible que celle de ce filtre n'aura aucun effet."
L["Plugins"] = "Plugins"
L["Position mode"] = "Disposition"
L["Press Alt while doing so to open the configuration panel instead."] = "Appuyer sur Alt en le faisant pour ouvrir le panneau de configuratio à la place." -- Needs review
L["Priority"] = "Priorité"
L["Provides a LDB data source to be displayed by LDB display addons."] = "Fournit une source LDB qui peut être affichée dans un addon d'affichage de LDB."
L["Put any item that can be equipped (including bags) into the \"Equipment\" section."] = "Place les objets qui peuvent être équipés (y compris les sacs) dans la section \"Equipement\"."
L["Put items belonging to one or more sets of the built-in gear manager in specific sections."] = "Place les objets appartenant à un ou plusieurs ensembles d'objet du gestionnaire d'objets dans des sections spécifiques."
L["Put items in sections depending on their first-level category at the Auction House."] = "Répartit les objets en fonction de leur catégorie principale (premier niveau de l'Hôtel des Ventes). "
L["Put items of poor quality or labeled as junk in the \"Junk\" section."] = "Place les objets de mauvaise qualité ou considéré comme camelote dans la section \"Camelote\"."
L["Put quest-related items in their own section."] = "Place les objets en rapport avec les quêtes dans une section spécifique."
L["Quality highlight"] = "Surlignage de la qualité"
L["Quest indicator"] = "Indicateur de quête"
L["Quest Items"] = "Objets de quête"
L["QUIVER_TAG"] = "Fl"
L["Remove"] = "Effacer"
L["Reset"] = "Réinit." -- Needs review
L["Reset new items"] = "Remet à zéro les nouveaux objets."
L["Reset position"] = "R.à.z. position"
L["Right-click to configure."] = "Clic-droit pour configurer."
L["Right-click to move these items."] = "Clic-droit pour déplacer ces objets."
L["Right-click to sell these items."] = "Clic-droit pour vendre ces objets."
L["Right-click to try to empty this bag."] = "Clic droit pour essayer de vider ce sac."
L["Right-click to (un)lock the bag anchor."] = "Clic-droit pour (dé)verrouiller l'ancre des sacs."
L["Scale"] = "Echelle"
L["Section"] = "Section"
L["Section category"] = "Catégorie de section"
L["Section header"] = "En-têtes des sections" -- Needs review
L["Section setup"] = "Configuration de section"
L["Section visibility"] = "Visibilité des sections"
L["Section visibility button"] = "Bouton de visibilité des sections."
L["Select how bag usage should be formatted in the plugin."] = "Choisissez comment l'occupation d'un sac doit être formaté."
L["Select how items should be sorted within each section."] = "Choisissez comment les objets doivent être triés à l'intérieur de chaque section."
L["Select the category of the section to associate. This is used to group sections together."] = "Sélectionnez la catégorie de la section à associer. Ceci est utilisé pour regrouper les sections."
L["Select the sections in which the items should be dispatched."] = "Sélectionnez les sections parmi lesquelles l'objet devra être affiché"
L["Select the top objective of the layout algorithm."] = "Choisissez l'objectif prioritaire de l'algorithme de disposition."
L["Select which first-level categories should be split by sub-categories."] = "Sélectionnez quelles catégories doivent être séparées en sous-catégories."
L["Semi-automated tidy"] = "Rangement semi-automatique"
L["Separate incomplete stacks."] = "Séparer les piles incomplètes."
L["Separate unstackable items."] = "Séparer les objets non-empilables."
L["Sets"] = "Ensembles"
L["Set: %s"] = "Ens.: %s"
L["Show bag type icons"] = "Affiche les icônes de type de sacs"
L["Show bag type tags"] = "Affiche les tags de type de sac"
L["Show bank usage"] = "Afficher la banque"
L["Show container information..."] = "Afficher les informations du contenant..."
L["Show every distinct item stacks."] = "Afficher chaque pile distincte."
L["Show filtering information..."] = "Afficher les informations de filtrage..."
L["Show item information..."] = "Afficher les informations sur l'objet..."
L["Show only one free slot for each kind of bags."] = "N'affiche qu'un seul emplacement vide pour chaque type de sac."
L["Show only one slot of items that can be stacked."] = "N'affiche qu'un seul emplacement pour les objets pouvant être empilés."
L["Show only one slot of items that cannot be stacked."] = "N'affiche qu'un seul emplacement pour les objets ne pouvant normalement pas être empilés."
L["Show %s"] = "Afficher %s"
L["Size"] = "Taille"
L["Skin"] = "Apparence"
L["Slot number"] = "Numéro d'emplacement"
L["Sorting order"] = "Ordre de tri"
L["SOUL_BAG_TAG"] = "Âm"
L["Space in use"] = "Espace utilisé"
L["Space in use / total space"] = "Espace utilisé / espace total"
L["Split armors by types"] = "Séparer les types d'armures"
L["Split by subcategories"] = "Répartir par sous-catégorie"
L["Strictly keep ordering"] = "Conserver strictement l'ordre"
L["TACKLE_BOX_TAG"] = "Pê"
L["Text"] = "Texte" -- Needs review
L["Texture"] = "Texture"
L["This setting allows to tone down what some people calls \"section dancing\" when moving/selling/milling items."] = "Ce réglage permet de réduire ce que certains appellent la \"danse des sections\", quand vous déplacez/vendez des objets."
L["Tidy bags"] = "Ranger les sacs"
L["Tidy your bags by clicking on the small \"T\" button at the top left of bags. Special bags with free slots will be filled with macthing items and stackable items will be stacked to save space."] = "Range vos sacs lorsque vous cliquez sur le bouton \"T\" en haut à droite des sacs. Dans la mesure du possible, les sacs spéciaux seront remplis avec les objets correspondant, et les objets seront empilés pour libérer de la place."
L["Toggle and configure item filters."] = "Activer et configurer les filtres."
L["Toggle and configure plugins."] = "Activer et configurer les plugins."
L["Tooltip information"] = "Informations dans les bulles d'aides"
L["Track new items"] = "Détection des nouveaux objets"
L["Track new items in each bag, displaying a glowing aura over them and putting them in a special section. \"New\" status can be reset by clicking on the small \"N\" button at top left of bags."] = "Détecte les nouveaux objets dans chaque sac, affiche une lueur colorée auteur d'eux et les place dans une section spéciale. Les nouveaux objets peuvent être remis à zéro en cliquant sur le bouton \"N\" en haut à droite des sacs."
L["Uncheck this to disable AdiBags."] = "Décochez ceci pour désactiver AdiBags."
L["Unlock anchor"] = "Déverrouiller l'ancre"
L["Use this section to define any item-section association."] = "Utilisez cette section pour définir de nouvelles associations objet-section."
L["Use this to adjust the bag scale."] = "Ajustez la taille des sacs."
L["Use this to adjust the quality-based border opacity. 100% means fully opaque."] = "Ajustez l'opacité de la bordure de qualité. 100% signifie complétement opaque."
L["Virtual stacks"] = "Piles virtuelles"
L["Virtual stacks display in one place items that actually spread over several bag slots."] = "Les piles virtuelles affichent en un seul endroit plusieurs piles d'objets."
L["Virtual stack slots"] = "Emplacements de pile virtuelle"
L["Warning: you are using an alpha or beta version of AdiBags without displaying Lua errors. If anything goes wrong, AdiBags (or any other addon causing some error) will simply stop working for apparently no reason. Please either enable the display of Lua errors or install an error handler addon like BugSack or Swatter."] = "Attention : vous utilisez une version alpha ou beta d'AdiBags sans afficher les erreurs Lua. Si quelque chose se passe mal, AdiBags (ou n'importe quel autre addon causant une erreur) va simplement arrêter de fonctionner sans raison apparente. Veuillez soit activer l'affichage des erreurs Lua ou installer un addon de gestion d'erreurs comme BugSack ou Swatter."
L["When alt is held down"] = "Quand ALT est enfoncé"
L["When any modifier key is held down"] = "Quand n'importe quelle touche de modification est enfoncée"
L["When ctrl is held down"] = "Quand CONTROL est enfoncé"
L["When shift is held down"] = "Quand MAJ est enfoncé"

------------------------ deDE ------------------------
elseif locale == 'deDE' then
L["Add a dropdown menu to bags that allow to hide the sections."] = "Fügt den Taschen ein Dropdown-Menü hinzu, welches es erlaubt die Abteilung zu verstecken."
L["Add association"] = "Füge Zuweisung hinzu"
L["Add more information in tooltips related to items in your bags."] = "Füge mehr Informationen bezüglich der Items in deinen Taschen zum Tooltip hinzu"
L["AdiBags Anchor"] = "AdiBags Anker"
L["Adjust the maximum height of the bags, relative to screen size."] = "Passt die maximale Höhe der Taschen in Relation zur Monitorauflösung an."
L["Adjust the maximum number of items per row."] = "Passt die maximale Anzahl von Gegenständen pro Reihe an"
L["AH category"] = "AH Kategorie"
L["AH subcategory"] = "AH Unterkategorie"
L["Allow you manually redefine the section in which an item should be put. Simply drag an item on the section title."] = "Erlaubt eine manuelle Neudefinierung eines Bereiches, in dem ein Gegenstand abegelegt werden soll. Ziehe den Gegenstand einfach auf die Sektionsleiste."
L["Always"] = "Immer"
L["AMMO_TAG"] = "Mu"
L["Ammunition"] = "Munition"
L["Anchored"] = "Verankert"
L["Are you sure you want to remove this section ?"] = "Bist Du sicher, dass Du diesen Bereich entfernen möchtest?" -- Needs review
L["Backpack"] = "Rucksack"
L["Bag #%d"] = "Tasche #%d" -- Needs review
L["Bag number"] = "Taschennummer"
L["Bags"] = "Taschen"
L["Bag type"] = "Taschenart"
L["Bag usage format"] = "Format der Taschennutzung"
L["Bank"] = "Bank"
L["By category, subcategory, quality and item level (default)"] = "Nach Kategorie, Unterkategorie, Qualität und iLvl. (Standard)"
L["By name"] = "Nach Name"
L["By quality and item level"] = "Nach Qualität und Gegenstandsstufe"
L["Category"] = "Kategorie"
L["Check sets that should be merged into a unique \"Sets\" section. This is obviously a per-character setting."] = "Aktiviere Sets die in einem einzigartigen Set-Bereich zusammengeführt werden sollen. Das ist offensichtlich eine Einstellung für jeden Charakter."
L["Check this so armors are dispatched in four sections by type."] = "Markieren damit die Rüstungen in vier Typen eingeteilt wird."
L["Check this so tidying is performed when you close the loot windows or you leave merchants, mailboxes, etc."] = "Anhaken, um die Taschen aufzuräumen, sobald Beute-Fenster geschlossen werden oder Händler, Briefkästen, usw. verlassen werden."
L["Check this to display a bag type tag in the top left corner of items."] = "Aktivieren um die Taschenart in der oberen linken Ecke eines Gegenstandes anzuzeigen"
L["Check this to display a colored border around items, based on item quality."] = "Aktivieren um den Rahmen um den Gegenstand in der Farbe seiner Qualität anzuzeigen."
L["Check this to display an icon after usage of each type of bags."] = "Aktivieren um ein icon nach der Benutzung jeglicher Art von Taschen anzuzeigen"
L["Check this to display an indicator on quest items."] = "Aktivieren um Questgegenstände mit einem farblichen Rahmen hervorzuheben."
L["Check this to display an textual tag before usage of each type of bags."] = "Aktivieren um einen Bezeichnung vor der Benutzung eines jeden Taschentyps anzeigen zu lassen"
L["Check this to display one individual section per set. If this is disabled, there will be one big \"Sets\" section."] = "Aktivieren um einen individuellen Bereich pro Set anzuzeigen. Wenn das hier nicht aktiviert ist wird nur ein großer \"Set\" Bereich angezeigt."
L["Check this to display only one value counting all equipped bags, ignoring their type."] = "Aktivieren um nur einen Wert anzuzeigen der alle belegten Taschenplätze zählt. Die Art der Tasche wird ignoriert."
L["Check this to have poor quality items dimmed."] = "Aktivieren um Gegenstände mit geringer Qualität dunkler darzustellen"
L["Check this to show space at your bank in the plugin."] = "Aktivieren um den freien Platz der Bank im Plugin anzuzeigen."
L["Check this to show this section. Uncheck to hide it."] = "Auswählen, um diese Untergliederung anzuzeigen - abwählen, um sie zu verbergen"
L["Check to enable this module."] = "Aktivieren um dieses Modul zu nutzen."
L["Click on this button to create the new association."] = "Klicke auf diesen Knopf um eine neue Zuweisung zu erstellen"
L["Click there to reset the bag positions and sizes."] = "Hier klicken zum Zurücksetzen der Taschenposition und Größe."
L["Click to purchase"] = "Anklicken zum kaufen"
L["Click to reset item status."] = "Klicken um den Gegenstandsstatus zurückzusetzen."
L["Click to select which sections should be shown or hidden. Section visibility is common to all bags."] = "Anklicken, um zu festzulegen welche Untergliederungen gezeigt werden sollen und welche nicht. Die Sichtbarkeit der Untergliederungen gilt für alle Taschen."
L["Click to tidy bags."] = "Klicken um die Taschen aufzuräumen"
L["Click to toggle the bag anchor."] = "Klicken um den Taschenanker anzuzeigen"
L["Click to toggle the equipped bag panel, so you can change them."] = "Klicken um die Taschenleiste anzuzeigen. Die Taschen können somit getauscht/belegt werden."
L["Close"] = "Schließen"
L["Configure"] = "Konfigurieren"
L["Consider gems as a subcategory of trade goods"] = "Edelsteine als Unterkategorie von handelbaren Gegenständen betrachten"
L["Consider glyphs as a subcategory of trade goods"] = "Glyphen als Unterkategorie von handelbaren Gegenständen betrachten"
L["Container information"] = "Behälterinformation"
L["Currency"] = "Embleme"
L["Dim junk"] = "Graue Gegenstände verblassen."
L["Display character currency at bottom left of the backpack."] = "Zeigt die Embleme des Charakters rechts unten beim Rucksack an"
L["Display character money at bottom right of the backpack."] = "Zeigt das Gold des Charakters rechts unten beim Rucksack an"
L["Drop your item there to add it to this section."] = "Gegenstand hier ablegen, um es diesem Bereich zuzufügen"
L["Enabled"] = "aktiviert"
L["ENCHANTING_BAG_TAG"] = "Vz"
L["ENGINEERING_BAG_TAG"] = "Ing"
L["Enter the name, link or itemid of the item to associate with the section. You can also drop an item into this box."] = "Gib den Namen, den Link oder die ItemId des Gegenstandes ein, der dem Bereich zugewiesen werden soll. Du kannst auch einen Gegenstand in dieses Feld ziehen."
L["Enter the name of the section to associate with the item."] = "Gib den Namen des Bereiches ein, der dem Gegenstand zugewiesen werden soll"
L["Equipment"] = "Ausrüstung"
L["Equipped bags"] = "Angelegte Taschen"
L["Fill lines at most"] = "Fülle die Reihen bis Maximum"
L["Filter"] = "Filter"
L["Filtering information"] = "Filterinformationen"
L["Filters"] = "Filter"
L["Filters are used to dispatch items in bag sections. One item can only appear in one section. If the same item is selected by several filters, the one with the highest priority wins."] = "Filter werden benutzt um Gegenstände in Taschenabteilungen zu befördern. Ein Gegenstand kann immer nur in einer Abteilung auftauchen. Wenn für den Gegenstand mehrere Filter zutreffen dann wird der Filter mit der höchsten Priorität genommen."
L["Four general sections."] = "Vier Hauptbereiche"
L["Free space"] = "freier Platz"
L["Free space / total space"] = "freier Platz / gesamter Platz"
L["Gear manager item sets"] = "Sets vom Ausrüstungsmanager"
L["GEM_BAG_TAG"] = "Ju"
L["Gems are trade goods"] = "Edelsteine sind handelbare Gegenstände"
L["Glyphs are trade goods"] = "Glyphen sind handelbare Gegenstände"
L["Group sections of same category"] = "Gruppenabteilungen der selben Kategorie"
L["HERB_BAG_TAG"] = "Kr"
L["Highlight color"] = "Farbe hervorheben"
L["Highlight scale"] = "Skalierung für die Hervorhebung"
L["Ignore low quality items"] = "Ignoriere Gegestände von schlechter Qualität."
L["... including incomplete stacks"] = "...einschliesslich unvollständiger Stapel"
L["INSCRIPTION_BAG_TAG"] = "In"
L["Item"] = "Gegenstand"
L["Item category"] = "Kategorie für Gegenstände"
L["Item information"] = "Gegenstandsinformation"
L["Items"] = "Gegenstände"
L["Jewelry"] = "Juwelier"
L["KEYRING_TAG"] = "Schl"
L["Layout priority"] = "Darstellung Vorrang"
L["LDB Plugin"] = "LBD Plugin"
L["LEATHERWORKING_BAG_TAG"] = "Le"
L["Lock anchor"] = "Anker abschließen"
L["Manual"] = "Manuell"
L["Manual filtering"] = "Selbst einstellbare Filter"
L["Maximum bag height"] = "maximale Taschenhöhe"
L["Maximum row width"] = "maximale Breite für die Reihe"
L["Maximum stack size"] = "Maximale Stapelgröße"
L["Merge bag types"] = "Taschenarten mischen"
L["Merged sets"] = "Sets mischen"
L["Merge incomplete stacks with complete ones."] = "Füge unvollstädige Stapel mit vollständigen zusammen"
L["Merge stackable items"] = "Füge stapelbare Gegenstände zusammen"
L["MINING_BAG_TAG"] = "Bb"
L["Money"] = "Gold"
L["Never"] = "Niemals"
L["New"] = "Neu"
L["New item highlight"] = "Neue Gegenstände hervorheben"
L["New Override"] = "Neue Aufhebung"
L["One section per item slot."] = "Eine Bereich pro Gegenstandsplatz"
L["One section per set"] = "Eine Abteilung pro Set"
L["Only one section."] = "Nur ein Bereich"
L["Opacity"] = "Durchsichtigkeit"
L["Please note this filter matchs every item. Any filter with lower priority than this one will have no effect."] = "Bitte beachten: dieser Filter bezieht sich auf jeden Gegenstand. Alle Filter mit niedriger Priorität als dieser wird keinen Effekt haben."
L["Plugins"] = "Plugins"
L["Position mode"] = "Positions Modus"
L["Priority"] = "Priorität"
L["Provides a LDB data source to be displayed by LDB display addons."] = "Sieht vor, dass eine LDB Datenquelle von DataBroker Addons angezeigt wird"
L["Put any item that can be equipped (including bags) into the \"Equipment\" section."] = "Zeigt jeden verwendbaren Gegenstand (inklusive Taschen) im \"Equipment\" Bereich."
L["Put items belonging to one or more sets of the built-in gear manager in specific sections."] = "Zeigt Gegenstände die zu einem oder mehreren Sets des Ausrüstungsmanagers gehören in eigenen Bereichen an."
L["Put items in sections depending on their first-level category at the Auction House."] = "Zeigt Gegenstände basierend auf der ersten Kategorie des Auktoinshauses in den Bereichen an"
L["Put items of poor quality or labeled as junk in the \"Junk\" section."] = "Zeigt Gegenstände geringer Qualität oder als Müll gekennzeichnete Gegenstände im \"Junk\" Bereich an."
L["Put quest-related items in their own section."] = "Zeigt questbezogene Gegenstände in einem eigenen Bereich an"
L["Quality highlight"] = "Qualität hervorheben"
L["Quest indicator"] = "Quest Kennzeichen"
L["Quest Items"] = "Questgegenstände"
L["QUIVER_TAG"] = "Kö"
L["Remove"] = "Entfernen" -- Needs review
L["Reset new items"] = "Neue Gegenstände zurücksetzen"
L["Reset position"] = "Position zurücksetzen"
L["Right-click to try to empty this bag."] = "Rechte Maustaste nutzen um diese Tasche zu leeren."
L["Scale"] = "Skalierung"
L["Section"] = "Bereich"
L["Section category"] = "Bereichskategorie"
L["Section setup"] = "Bereichssetup"
L["Section visibility"] = "Sichtbarkeit der Untergliederung"
L["Select how bag usage should be formatted in the plugin."] = "Wähle aus, wie die Taschennutzung im Plugin formatiert werden soll"
L["Select how items should be sorted within each section."] = "Wähle aus, wie die Gegenstände in jedem Bereich einsortiert werden sollen"
L["Select the category of the section to associate. This is used to group sections together."] = "Wähle die Kategorie aus, die dem Bereich zugewiesen werden soll. Damit werden Bereiche zusammen angeordnet "
L["Select the sections in which the items should be dispatched."] = "Wähle den Bereich aus, in welchem die Gegenstände abgelegt werden sollen"
L["Select which first-level categories should be split by sub-categories."] = "Wähle aus, welche Oberkategorien von Unterkategorien aufgeteilt werden sollen"
L["Semi-automated tidy"] = "halb-automatische Sortierung"
L["Sets"] = "Sets"
L["Set: %s"] = "Set: %s"
L["Show bag type icons"] = "Zeige die Art der Taschen als Icon an"
L["Show bag type tags"] = "Zeige die Art der Taschen als Text an"
L["Show bank usage"] = "Zeige die Bank Nutzung an"
L["Show container information..."] = "Zeige Behälterinformation"
L["Show filtering information..."] = "Zeige Filterinformationen"
L["Show item information..."] = "Zeige Gegenstandsinformation"
L["Show %s"] = "Zeige %s"
L["Slot number"] = "Platznummer"
L["Sorting order"] = "Sortierreihenfolge"
L["SOUL_BAG_TAG"] = "Se"
L["Space in use"] = "Belegte Plätze"
L["Space in use / total space"] = "Belegte Plätze / alle Plätze"
L["Split armors by types"] = "Rüstung nach Typ"
L["Split by subcategories"] = "Aufteilen nach Unterkategorien"
L["Strictly keep ordering"] = "Genaue Reihenfolge einhalten"
L["Tidy bags"] = "Taschen aufräumen"
L["Tidy your bags by clicking on the small \"T\" button at the top left of bags. Special bags with free slots will be filled with macthing items and stackable items will be stacked to save space."] = "Um deine Taschen aufzuräumen klicke auf den kleinen \"T\" Knopf oben links. Spezielle Taschen mit freien Plätzen werden dann mit passenden Gegenständen gefüllt und stapelbare Gegenstände werden gestapelt um Platz zu sparen."
L["Toggle and configure item filters."] = "Gegenstandsfilter aktivieren und konfigurieren"
L["Toggle and configure plugins."] = "Plugins aktivieren und konfigurieren"
L["Tooltip information"] = "Tooltipinformation"
L["Track new items"] = "Neue Gegenstände beobachten"
L["Track new items in each bag, displaying a glowing aura over them and putting them in a special section. \"New\" status can be reset by clicking on the small \"N\" button at top left of bags."] = "Beobachtete Gegenstände in jeder Tasche mit einer glühenden Aura versehen und in eine spezielle Abteilung verschieben. Der \"New\" Status kann durch klicken auf den kleinen \"N\" Knopf oben links bei den Tachen zurückgesetzt werden."
L["Uncheck this to disable AdiBags."] = "Abwählen, um Adibags zu deaktivieren."
L["Unlock anchor"] = "Anker aufschliessen"
L["Use this section to define any item-section association."] = "Benutze diesen Bereich, um eine beliebige Gegenstand-Sektionen-Zuweisung zu definieren"
L["Use this to adjust the bag scale."] = "Skalierung der Taschen anpassen"
L["Use this to adjust the quality-based border opacity. 100% means fully opaque."] = "Deckkraft der Umrandung für die Qualität der Gegenstände anpassen. 100% bedeutet volle Deckkraft"
L["Virtual stacks"] = "virtuelle Stapel"
L["Virtual stacks display in one place items that actually spread over several bag slots."] = "Virtuelle Stapelanzeige von Gegenstäden, die in verschiedenen Taschen verteilt sind, an einer Stelle"
L["When alt is held down"] = "Wenn Alt gedrückt ist"
L["When any modifier key is held down"] = "Wenn irgendeine Modifizierungstase gedrückt ist"
L["When ctrl is held down"] = "Wenn Strg gedrückt ist"
L["When shift is held down"] = "Wenn Umschalt gedrückt ist"

------------------------ esMX ------------------------
-- no translation

------------------------ ruRU ------------------------
elseif locale == 'ruRU' then
L["Add a dropdown menu to bags that allow to hide the sections."] = "Добавить выпадающее меню для сумок, в котором можно настроить отображение секций."
L["Add association"] = "Добавить объединение"
L["Add more information in tooltips related to items in your bags."] = "Добавить Дополнительную информацию во всплывающих подсказках, касающихся предметов, в вашей сумке"
L["AdiBags Anchor"] = "AdiBags Якорь"
L["Adjust the maximum height of the bags, relative to screen size."] = "Регулировка максимальной высоты сумок, относительно размеру экрана."
L["Adjust the maximum number of items per row."] = "регулировка максимально количества предметов в ряду."
L["AH category"] = "Категория аукциона"
L["AH subcategory"] = "Подкатегория аукциона"
L["Allow you manually redefine the section in which an item should be put. Simply drag an item on the section title."] = "Позволяет вручную изменять секцию в которую следует помещать предмет. Просто перетащите элемент на название раздела."
L["Always"] = "Всегда"
L["AMMO_TAG"] = "Бп"
L["Ammunition"] = "Боеприпасы"
L["Anchored"] = "Закрепленные"
L["Backpack"] = "Рюкзак"
L["Bag #%d"] = "Сумка #%d"
L["Bag number"] = "Номер сумки"
L["Bags"] = "Сумки"
L["Bag type"] = "Тип сумки"
L["Bag usage format"] = "Формат использования сумки"
L["Bank"] = "Банк"
L["Bank bag #%d"] = "Сумка банка #%d"
L["By category, subcategory, quality and item level (default)"] = "По категории, под-категории, качеству и уровню предмета (по умолчанию)"
L["By name"] = "По имени"
L["By quality and item level"] = "По качеству и уровню"
L["Category"] = "Категория"
L["Check sets that should be merged into a unique \"Sets\" section. This is obviously a per-character setting."] = "Отметьте какие наборы должны быть объединены в особую секцию \"Наборы\". Конечно же это настройка, для каждого персонажа отдельно."
L["Check this so armors are dispatched in four sections by type."] = "Отметьте это, и броня будет разделяться на четыре секции в зависимости от ее типа."
L["Check this so tidying is performed when you close the loot windows or you leave merchants, mailboxes, etc."] = "Отметьте это, если хотите что бы уборка в сумках происходила при каждом закрытии окна сбора добычи, торговли, почтового ящика и т.п."
L["Check this to display a bag type tag in the top left corner of items."] = "Поставте галочку, чтобы отображать тег сумки в левом верхнем углу иконки предмета."
L["Check this to display a colored border around items, based on item quality."] = "Отметьте это, чтобы подкрашивать края предметов исходя из их качества."
L["Check this to display an icon after usage of each type of bags."] = "Поставьте тут галочку для отображения иконки каждого типа сумок." -- Needs review
L["Check this to display an indicator on quest items."] = "Поставьте тут галочку чтобы отображать индикатор на предметах, необходимых для задания."
L["Check this to display an textual tag before usage of each type of bags."] = "Отметьте это, если хотите что бы отображалась текстовая пометка перед использованием каждого из типов сумок."
L["Check this to display one individual section per set. If this is disabled, there will be one big \"Sets\" section."] = "Отметьте это, если хотите что бы для каждого набора вещей была отдельная секция. Если этот пункт отключен, используется одна большая секция \"Наборы\"."
L["Check this to display only one value counting all equipped bags, ignoring their type."] = "Отметьте это, если хотите что бы отображалась только количество пустых слотов во всех сумках, несмотря на тип сумок."
L["Check this to have poor quality items dimmed."] = "Поставьте галочку, для отабражения низкова уровня вешей затемнёным цветом."
L["Check this to show space at your bank in the plugin."] = "Отметьте это, если хотите чтобы отображались промежутки в окне банка вашего плагина." -- Needs review
L["Check this to show this section. Uncheck to hide it."] = "Отметьте это что бы показывать эту секцию, или снимите отметку что бы ее скрыть."
L["Check to enable this module."] = "Поставьте галочку для включения данного модуля."
L["Click on this button to create the new association."] = "Кликните на кнопку, что бы создать новую ассоциацию."
L["Click there to reset the bag positions and sizes."] = "Кликните тут чтобы сбросить расположение сумок и их размер."
L["Click to purchase"] = "Кликните чтобы купить"
L["Click to reset item status."] = "Кликните чтобы сбросить статус предметов."
L["Click to select which sections should be shown or hidden. Section visibility is common to all bags."] = "Кликните что бы выбрать какие секции должны показываться, а какие скрываться. Настройки видимости секций общие для свех сумок."
L["Click to tidy bags."] = "Кликните, что бы прибраться в сумках."
L["Click to toggle the bag anchor."] = "Кликните чтобы переключить якорь сумки."
L["Click to toggle the equipped bag panel, so you can change them."] = "Кликните для переключения панели надетых сумок, так что вы можете их изменить."
L["Close"] = "Закрыть"
L["Configure"] = "Настройка"
L["Consider gems as a subcategory of trade goods"] = "Рассматривать самоцветы как подкатегорию хозяйственных товаров"
L["Consider glyphs as a subcategory of trade goods"] = "Рассматривать символы как подкатегорию хозяйственных товаров"
L["Container information"] = "Информация о контейнере"
L["Currency"] = "Золото"
L["Dim junk"] = "Затемнять хлам"
L["Display character currency at bottom left of the backpack."] = "Показывать количество золота у персонажа в нижней левой стороне окна сумок."
L["Display character money at bottom right of the backpack."] = "Отображать деньги персонажа в нижнем правом углу рюкзака."
L["Drop your item there to add it to this section."] = "Чтобы добавить предмет в этот раздел, переместите его туда. "
L["Enabled"] = "Включен"
L["ENCHANTING_BAG_TAG"] = "Чры"
L["ENGINEERING_BAG_TAG"] = "Эн"
L["Enter the name, link or itemid of the item to associate with the section. You can also drop an item into this box."] = "Введите название, ссылку или ID предмета, что бы связать ее с секцией. Так же вы можете просто перетащить предмет в окошко."
L["Enter the name of the section to associate with the item."] = "Введите название секции, с которой вы хотите связать вещь."
L["Equipment"] = "Экипировка"
L["Equipped bags"] = "Сумки персонажа"
L["Fill lines at most"] = "Заполнять линии полностью"
L["Filter"] = "Фильтр"
L["Filtering information"] = "Фильтрование информации"
L["Filters"] = "Фильтры"
L["Filters are used to dispatch items in bag sections. One item can only appear in one section. If the same item is selected by several filters, the one with the highest priority wins."] = "Фильтры используются для группировки ваших вещей. Одна вещь может находиться только в одной из секций. Если одна вещь входит в несколько фильтров, используется тот фильтр, чей приоритет выше."
L["Four general sections."] = "Четыре общих секции."
L["Free space"] = "Свободно"
L["Free space / total space"] = "Свободно / всего места"
L["Gear manager item sets"] = "Предметы наборов управления экипировкой"
L["GEM_BAG_TAG"] = "См"
L["Gems are trade goods"] = "Самоцветы это Хозяйственные товары"
L["Glyphs are trade goods"] = "Символы это Хозяйственные товары"
L["Group sections of same category"] = "Группировать секции одной категории"
L["HERB_BAG_TAG"] = "Тр"
L["Highlight color"] = "Цвет подсвечивания"
L["Highlight scale"] = "Масштаб подсвечивания"
L["Ignore low quality items"] = "Игнорировать вещи низкого качества."
L["... including incomplete stacks"] = "... включая не полные стопки"
L["INSCRIPTION_BAG_TAG"] = "Нч"
L["Item"] = "Предмет"
L["Item category"] = "Категория предмета"
L["Item information"] = "Информация о предмете"
L["Items"] = "Предметы"
L["Jewelry"] = "Драгоценности"
L["KEYRING_TAG"] = "Клч"
L["Layout priority"] = "Приоритет слоя"
L["LDB Plugin"] = "Плагин LDB"
L["LEATHERWORKING_BAG_TAG"] = "Кж"
L["Lock anchor"] = "Блокировать якорь"
L["Manual"] = "В ручную"
L["Manual filtering"] = "Ручная фильтрация"
L["Maximum bag height"] = "Максимальная высота сумки"
L["Maximum row width"] = "Максимальная ширина ряда"
L["Maximum stack size"] = "Максимальный размер стопки"
L["Merge bag types"] = "Объединить типы сумок"
L["Merged sets"] = "Объединенные наборы"
L["Merge incomplete stacks with complete ones."] = "Объединять не полные стопки, с полными."
L["Merge stackable items"] = "Складывать в стопки вещи, которые могут быть сложены."
L["MINING_BAG_TAG"] = "Гд"
L["Money"] = "Валюта"
L["Never"] = "Никогда"
L["New"] = "Новое"
L["New item highlight"] = "Подсвечивать новые предметы"
L["New Override"] = "Новое перераспределение"
L["One section per item slot."] = "Для каждого слота доспехов, своя секция."
L["One section per set"] = "Одна секция на набор"
L["Only one section."] = "Только одна секция"
L["Opacity"] = "Непрозрачность"
L["Please note this filter matchs every item. Any filter with lower priority than this one will have no effect."] = "Имейте ввиду, что этот фильтр будет использоваться для всех вещей. Любой фильтр с меньшим приоритетом чем этот, не будет применяться."
L["Plugins"] = "Плагины"
L["Position mode"] = "Режим позиционирования"
L["Priority"] = "Приоритет"
L["Provides a LDB data source to be displayed by LDB display addons."] = "Позволяет отображать источник LDB данных другими аддонами для отображения LDB." -- Needs review
L["Put any item that can be equipped (including bags) into the \"Equipment\" section."] = "Поместить все предметы которые могут быть одеты на персонажа (включая сумки) в секцию \"Экипировка\""
L["Put items belonging to one or more sets of the built-in gear manager in specific sections."] = "Помещает вещи, являющиеся частью одного из наборов, созданных с помощью управления экипировкой, в отдельные секции."
L["Put items in sections depending on their first-level category at the Auction House."] = "Раскладывать вещи в сумках, используя общие категории аукциона."
L["Put items of poor quality or labeled as junk in the \"Junk\" section."] = "Поместить предметы низкого качества или помеченных как хлам с секцию \"Хлам\"."
L["Put quest-related items in their own section."] = "Поместить предметы связанные с заданием в свою секцию."
L["Quality highlight"] = "Подсвечивать в зависимости от качества"
L["Quest indicator"] = "Индикатор задания"
L["Quest Items"] = "Предметы, необходимые для задания"
L["QUIVER_TAG"] = "Клчн"
L["Reset new items"] = "Сброс новых предметов"
L["Reset position"] = "Сброс расположения"
L["Right-click to try to empty this bag."] = "Кликните правой кнопкой, что бы попытаться опустошить эту сумку."
L["Scale"] = "Масштаб"
L["Section"] = "Секция"
L["Section category"] = "Категория секции"
L["Section setup"] = "Настройки секции"
L["Section visibility"] = "Видимость секции"
L["Section visibility button"] = "Кнопка отображения секций"
L["Select how bag usage should be formatted in the plugin."] = "Выберите способ, которым следует упорядочивать использование сумок плагином." -- Needs review
L["Select how items should be sorted within each section."] = "Выберите как предметы должны сортироваться в пределах каждой секции."
L["Select the category of the section to associate. This is used to group sections together."] = "Выберите категорию секции для того, что бы ее связать. Это необходимо для того, чтобы сгруппировать секции вместе."
L["Select the sections in which the items should be dispatched."] = "Укажите секцию, в которой вещи необходимо разделить" -- Needs review
L["Select which first-level categories should be split by sub-categories."] = "Укажите, какие общие категории должны быть разделены на субкатегории."
L["Semi-automated tidy"] = "Полуавтоматическая уборка"
L["Sets"] = "Наборы"
L["Set: %s"] = "Набор: %s"
L["Show bag type icons"] = "Показать иконку типа сумки"
L["Show bag type tags"] = "Показать тег типа сумки"
L["Show bank usage"] = "Показать использование банка"
L["Show container information..."] = "Показать данные контейнера..."
L["Show filtering information..."] = "Показать данные фильтрации..."
L["Show item information..."] = "Показать данные о вещи..."
L["Show only one free slot for each kind of bags."] = "Показывать только один свободный слот для каждого типа сумок"
L["Show only one slot of items that can be stacked."] = "Показывать только один слот для вещей, которые можно сложить в стопки"
L["Show only one slot of items that cannot be stacked."] = "Показывать только один слот вещей, которые не могут быть сложены в стопки"
L["Show %s"] = "Показать %s"
L["Slot number"] = "Номер слота"
L["Sorting order"] = "Порядок сортировки"
L["SOUL_BAG_TAG"] = "Кд"
L["Space in use"] = "Исп. места"
L["Space in use / total space"] = "Использовано / всего места"
L["Split armors by types"] = "Разделять доспехи по типам"
L["Split by subcategories"] = "Разделить по субкатегориям"
L["Strictly keep ordering"] = "Строго соблюдать порядок"
L["Tidy bags"] = "Чистые сумки" -- Needs review
L["Tidy your bags by clicking on the small \"T\" button at the top left of bags. Special bags with free slots will be filled with macthing items and stackable items will be stacked to save space."] = "Убраться в ваших сумках можно нажав небольшую кнопку \"Т\", которая находится верхней левой стороне окна сумок. Специальные сумки будут заполнены подходящими для них предметами, и вещи которые можно сложить, будут сложены в стопки для экономии места."
L["Toggle and configure item filters."] = "Переключение и настройка фильтров предмета."
L["Toggle and configure plugins."] = "Переключение и настройка плагина."
L["Tooltip information"] = "Информация подсказки"
L["Track new items"] = "Следить за новыми предметами"
L["Track new items in each bag, displaying a glowing aura over them and putting them in a special section. \"New\" status can be reset by clicking on the small \"N\" button at top left of bags."] = "Отслеживать новые предметы в каждой сумке, подсвечивать их и помещать в отдельную секцию. Статус \"Новое\" может быть сброшен кликом по небольшой кнопке \"N\" находящейся, в верхней левой стороне окна сумок."
L["Uncheck this to disable AdiBags."] = "Снимите галочку штобы выключить AdiBags."
L["Unlock anchor"] = "Разблок. якорь"
L["Use this section to define any item-section association."] = "Использовать эту секцию, для определения любой связной с ней секцией" -- Needs review
L["Use this to adjust the bag scale."] = "Регулировка масштаба сумок."
L["Use this to adjust the quality-based border opacity. 100% means fully opaque."] = "Используете ето для настройки, на основе качества, границ прозрачности. 100% означает полностью непрозрачный"
L["Virtual stacks"] = "Виртуальные стопки"
L["Virtual stacks display in one place items that actually spread over several bag slots."] = "Виртуальные стопки отображают в одном месте предметы, которые фактически находятся в нескольких местах сумки." -- Needs review
L["Virtual stack slots"] = "Виртуальное сложение слотов"
L["When alt is held down"] = "Когда кнопка Alt нажата"
L["When any modifier key is held down"] = "Когда какая-либо клавиша модификатора нажата"
L["When ctrl is held down"] = "Когда кнопка Ctrl нажата"
L["When shift is held down"] = "Когда кнопка Shift нажата"

------------------------ esES ------------------------
elseif locale == 'esES' then
L["Adjust the maximum height of the bags, relative to screen size."] = "Ajustar al maximo la altura de las bolsas, en relación a el tamaño de la pantalla."
L["Allow you manually redefine the section in which an item should be put. Simply drag an item on the section title."] = "Permite redefinir manualmente la sección en la que un objeto debe situarse. Solo arrastra un objeto dentro del título de la sección"
L["Always"] = "Siempre"
L["Ammunition"] = "Municion (not for 4.0)"
L["Bag #%d"] = "Bolsa #%d"
L["Bag number"] = "Número de bolsa"
L["Bags"] = "Bolsas"
L["Bag usage format"] = "Formato mal usado."
L["Bank bag #%d"] = "Bolsa de banco #%d"
L["By category, subcategory, quality and item level (default)"] = "Por categoria, subcategoria, calidad y nivel del objeto (por defecto)"
L["By name"] = "Por Nombre"
L["By quality and item level"] = "Por calidad y nivel del objeto"
L["Category"] = "Categoria"
L["Check this to display a colored border around items, based on item quality."] = "Señala esto para mostrar un borde coloreado alrededor de los objetos, basado solo en la calidad del objeto."
L["Check this to display an icon after usage of each type of bags."] = "Marque esto para mostrar un icono después de las bolsas según su uso."
L["Check this to display an indicator on quest items."] = "Marca esto para mostrar un indicador en los objetos de misión"
L["Check this to display an textual tag before usage of each type of bags."] = "Marca esto para mostrar una frase de texto antes de las bolsas según su uso."
L["Check this to display one individual section per set. If this is disabled, there will be one big \"Sets\" section."] = "Marca esto para mostrar una sección por cada grupo. Si está desactivado, habra una gran sección de \"Grupos\""
L["Check this to display only one value counting all equipped bags, ignoring their type."] = "Marca esto para mostrar un valor contando todas las bolsas equipadas, ignorando su tipo de uso."
L["Check this to show space at your bank in the plugin."] = "Marca esto para mostrar eel espacio en el banco en el Accesorio."
L["Check to enable this module."] = "Señala para habilitar este modulo."
L["Click on this button to create the new association."] = "Aprieta en este boton para crear una nueva asociación"
L["Click there to reset the bag positions and sizes."] = "Apretar aqui para borrar la posicion y tamaño de la bolsa."
L["Click to purchase"] = "Aprieta para comprar"
L["Click to reset item status."] = "Aprieta para borrar el estado de los objetos."
L["Click to tidy bags."] = "Apretar para limpiar las bolsas"
L["Click to toggle the bag anchor."] = "Aprieta para intercambiar el anclaje de la bolsa"
L["Click to toggle the equipped bag panel, so you can change them."] = "Aprieta para intercambiar el panel de la bolsa equipada, para poder cambiarlas."
L["Close"] = "Cerrar."
L["Configure"] = "Configurar"
L["Consider gems as a subcategory of trade goods"] = "Considerar gemas como subcategoria de objetos comerciables."
L["Consider glyphs as a subcategory of trade goods"] = "Considerar Glifos  como subcategoria de objetos comerciables."
L["Container information"] = "Informacion del contenerdor"
L["Display character money at bottom right of the backpack."] = "Muestra el dinero en el personaje abajo a la derecha de la mochila."
L["Drop your item there to add it to this section."] = "Suelta tu objeto aqui para añadirlo a esta sección."
L["Enabled"] = "Habilitado."
L["Enter the name of the section to associate with the item."] = "Escribe un nombre de sección para asociar con este objeto."
L["Equipment"] = "Equipado, Equipo."
L["Equipped bags"] = "Bolsas equipadas"
L["Filter"] = "filtro"
L["Filtering information"] = "Información filtrada"
L["Filters"] = "Filtros"
L["Filters are used to dispatch items in bag sections. One item can only appear in one section. If the same item is selected by several filters, the one with the highest priority wins."] = "Los filtros se usan para disponer artículos en las secciones bolsa."
L["Free space"] = "Espacio vacio"
L["Free space / total space"] = "Espacio vacio / espacio total"
L["Gear manager item sets"] = "Gestor de equipamiento conjuntos de objetos"
L["Gems are trade goods"] = "Las gemas son objetos comerciables."
L["Glyphs are trade goods"] = "Los Glifos  son objetos comerciables"
L["Highlight color"] = "Resaltar color"
L["Highlight scale"] = "resaltar la escala"
L["Item category"] = "Categoria del objeto"
L["Items"] = "Objetos"
L["LDB Plugin"] = "Load Data Base plugin   - Carga base datos accesorio"
L["Lock anchor"] = "Bloquear anclaje"
L["Manual filtering"] = "Filtro manual"
L["Merge bag types"] = "Combinar tipos de bolsas"
L["Merge incomplete stacks with complete ones."] = "Combinar montones incompletos con completos."
L["Merge stackable items"] = "Unir objetos apilables"
L["Money"] = "Dinero"
L["New"] = "Nuevo"
L["New item highlight"] = "Resaltar Objetos nuevos (acction to do)  -  Nuevos objetos resaltados ( action done)"
L["One section per set"] = "Una seccion por grupo"
L["Please note this filter matchs every item. Any filter with lower priority than this one will have no effect."] = "Por favor fijese que este filtro encuentra cada uno de los objetos, Cualquier filtro con menor prioridad que este no tendra efecto."
L["Plugins"] = "Accesorio, complemento."
L["Priority"] = "Prioridad"
L["Provides a LDB data source to be displayed by LDB display addons."] = "Proporciona una fuente de datos de Carga que se muestran en el panel del ayudante LDB.(loaddatabase)"
L["Put any item that can be equipped (including bags) into the \"Equipment\" section."] = "Ponga cualquier elemento que puede ser equipado (incluyendo las bolsas) en la sección \"equipo\" ."
L["Put items belonging to one or more sets of the built-in gear manager in specific sections."] = "Coloca los artículos pertenecientes a uno o más conjuntos del gestor de equipamiento en secciones específicas."
L["Put items in sections depending on their first-level category at the Auction House."] = "Coloca los artículos en las secciones en función de su primer nivel de categoría de la casa de subastas."
L["Put items of poor quality or labeled as junk in the \"Junk\" section."] = "Coloca los artículos de mala calidad o etiquetados como basura en la sección \"basura\" ."
L["Put quest-related items in their own section."] = [=[Poner los objetos relacionados con misiones en su correspondiente seccion. 
( not quest section?)]=]
L["Quality highlight"] = "Resaltar calidad"
L["Quest indicator"] = "Señalador de misión"
L["Quest Items"] = "Objetos de misión"
L["Reset new items"] = "Recargar Obejtos nuevos"
L["Reset position"] = "Restablecer posición"
L["Right-click to try to empty this bag."] = "Boton derecho para intentar vaciar esta bolsa"
L["Scale"] = "escala."
L["Section visibility button"] = "Seccion de visibilidad del boton"
L["Select how bag usage should be formatted in the plugin."] = "Selecciona como el uso de la bolsa sera conformado en el accesorio."
L["Select how items should be sorted within each section."] = "Selecciona como se deben ordenar los objetos en cada sección."
L["Select which first-level categories should be split by sub-categories."] = "Selecciona que Categorias de primer nivel (encantameinto de objeto) deben separarse en subcategorias ( Encantamiento de objeto - permanente)"
L["Show only one free slot for each kind of bags."] = "Mostrar solo 1 hueco libre para cada tipo de bolsa"
L["Show only one slot of items that can be stacked."] = "Mostrar solo un ranura de objetos apilables."
L["Show only one slot of items that cannot be stacked."] = "Mostrar solo 1 ranura de objetos que no pueden apilarse"
L["Split by subcategories"] = "Dividir en subcategorias"
L["Tidy bags"] = "Bolsas ordenadas, limpias."
L["Tidy your bags by clicking on the small \"T\" button at the top left of bags. Special bags with free slots will be filled with macthing items and stackable items will be stacked to save space."] = "Ordena tus bolsas apretando el pequeño botón \"T\" en la parte superior izquierda de bolsas. las bolsas especiales (profesiones) con ranuras libres se rellenara de los objetos correspondientes apilables, se apilaran para ahorrar espacio."
L["Toggle and configure item filters."] = "Intercambia y configura los filtros de objetos."
L["Toggle and configure plugins."] = "Intercambia y configura los accesorios."
L["Track new items"] = "Rastrea objetos nuevos"
L["Track new items in each bag, displaying a glowing aura over them and putting them in a special section. \"New\" status can be reset by clicking on the small \"N\" button at top left of bags."] = "Rastrea objetos nuevos en cada bolsa, mostrando un aura brillante sobre ellos, y poniendolos en una sección especial.El estado  \"nuevos\" puede ser borrado en el pequeño boton \"N\" en el borde superior izquierdo de las bolsas."
L["Unlock anchor"] = "desbloquear anclaje - desanclar."
L["Use this to adjust the bag scale."] = "Usa esto para ajustar la escala de la bolsa."
L["Use this to adjust the quality-based border opacity. 100% means fully opaque."] = [=[Usa esto para ajustar la opacidad del borde basado en la calidad. 100% significa opaco.
]=]

------------------------ zhTW ------------------------
elseif locale == 'zhTW' then
L["Add a dropdown menu to bags that allow to hide the sections."] = "增加下拉式選單來隱藏分類" -- Needs review
L["Add association"] = "新增關聯"
L["Add more information in tooltips related to items in your bags."] = "顯示物品的額外資訊提示"
L["AdiBags Anchor"] = "AdiBags 錨點"
L["Adjust the maximum height of the bags, relative to screen size."] = "調整背包最大高度，相對於螢幕尺寸"
L["Adjust the maximum number of items per row."] = "設定每行最多物品數目"
L["AH category"] = "拍賣場類別"
L["AH subcategory"] = "拍賣場子類別"
L["Allow you manually redefine the section in which an item should be put. Simply drag an item on the section title."] = "允許以手動方式，將物品拖曳至區塊標題來分類物品"
L["Alt-right-click to configure manual filtering."] = "按住Alt鍵單擊鼠標右鍵 配置手動篩選。" -- Needs review
L["Alt-right-click to configure the Junk module."] = "按住Alt鍵單擊鼠標右鍵配置垃圾模塊。" -- Needs review
L["Alt-right-click to switch to anchored placement."] = "按住Alt鍵單擊鼠標右鍵切換到錨定位置。" -- Needs review
L["Alt-right-click to switch to manual placement."] = "按住Alt鍵單擊鼠標右鍵切換到手動放置。" -- Needs review
L["Always"] = "總是"
L["AMMO_TAG"] = "Am"
L["Ammunition"] = "彈藥"
L["Anchored"] = "錨點"
L["Are you sure you want to remove this section ?"] = "你確定要刪除本分類嗎？"
L["As soon as possible"] = "及早" -- Needs review
L["At mechants', bank, auction house, ..."] = "在商人,銀行,拍賣場等..." -- Needs review
L["Automatic layout update"] = "自動佈局更新" -- Needs review
L["Backpack"] = "背包"
L["Backpack color"] = "背包顏色" -- Needs review
L["Bag background"] = "背包背景" -- Needs review
L["Bag #%d"] = "背包 #%d"
L["Bag number"] = "背包數量"
L["Bags"] = "背包"
L["Bag title"] = "背包標題" -- Needs review
L["Bag type"] = "背包類型"
L["Bag usage format"] = "背包運用格式"
L["Bank"] = "銀行"
L["Bank bag #%d"] = "銀行背包 #%d"
L["Bank color"] = "銀行顏色" -- Needs review
L["Bank Switcher"] = "銀行切換" -- Needs review
L["Border"] = "邊框"
L["Border width"] = "邊框寬度" -- Needs review
L["By category, subcategory, quality and item level (default)"] = "按類別, 子類別, 品質和物品等級(預設)"
L["By name"] = "按物品名稱"
L["By quality and item level"] = "按品質和物品等級"
L["Category"] = "種類"
L["Change stacking at merchants', auction house, bank, mailboxes or when trading."] = "商人，拍賣行，銀行，郵箱或交易時更改堆疊。"
L["Check sets that should be merged into a unique \"Sets\" section. This is obviously a per-character setting."] = "檢查\"裝備組合\"應合併成一個獨特的“組合”分類。此項根據每個角色設置有所不同。" -- Needs review
L["Check this so armors are dispatched in four sections by type."] = "護甲將按四大類型分組（布甲/皮甲/鎖甲/鎧甲）。" -- Needs review
L["Check this so tidying is performed when you close the loot windows or you leave merchants, mailboxes, etc."] = "當關閉拾取窗口，離開交易，郵箱等動作時整理背包。"
L["Check this to display a bag type tag in the top left corner of items."] = "在物品左上角顯示背包標籤"
L["Check this to display a colored border around items, based on item quality."] = "依物品品質著色邊框"
L["Check this to display an icon after usage of each type of bags."] = "在每個背包運用類型後顯示圖示。"
L["Check this to display an indicator on quest items."] = "在任務物品上顯示指示。"
L["Check this to display an textual tag before usage of each type of bags."] = "在每個背包運用類型前顯示文字標記。"
L["Check this to display one individual section per set. If this is disabled, there will be one big \"Sets\" section."] = "依各個套裝獨立分組。若停用此選項，將會合併成一個大「套裝」分組。"
L["Check this to display only one value counting all equipped bags, ignoring their type."] = "讓所有裝備背包顯示一個值，忽略其類型。"
L["Check this to have poor quality items dimmed."] = "黯淡品質為粗糙的物品"
L["Check this to show space at your bank in the plugin."] = "在銀行中顯示背包空間。"
L["Check this to show this section. Uncheck to hide it."] = "設定要顯示的分類" -- Needs review
L["Check to enable this module."] = "檢查以啟用模組。"
L["Click on a item to remove it from the list. You can drop an item on the empty slot to add it to the list."] = "點擊一個項目從列表中刪除它。也可拖放物品至空格以添加至列表。" -- Needs review
L["Click on this button to create the new association."] = "建立新的關聯"
L["Click or drag this item to remove it."] = "單擊或拖動要刪除的物品。" -- Needs review
L["Click there to reset the bag positions and sizes."] = "點擊重置背包位置和尺寸。"
L["Click to purchase"] = "點擊購買"
L["Click to reset item status."] = "點擊重置物品狀態。"
L["Click to select which sections should be shown or hidden. Section visibility is common to all bags."] = "設定要顯示或隱藏的分類" -- Needs review
L["Click to tidy bags."] = "點擊整理背包。"
L["Click to toggle the bag anchor."] = "點擊開啟或關閉背包錨點。"
L["Click to toggle the equipped bag panel, so you can change them."] = "點擊開啟或關閉已裝備背包面板, 用來修改他們。"
L["Close"] = "關閉"
L["Color"] = "顏色" -- Needs review
L["Configure"] = "配置"
L["Consider gems as a subcategory of trade goods"] = "將寶石設定為商品的子類別"
L["Consider glyphs as a subcategory of trade goods"] = "將雕紋設定為商品的子類別"
L["Container information"] = "容器資訊"
L["COOKING_BAR_TAG"] = "合作" -- Needs review
L["Currencies to show"] = "通貨至顯示"
L["Currency"] = "貨幣"
L["Dim junk"] = "暗淡的垃圾"
L["Display character currency at bottom left of the backpack."] = "與背爆左下角顯示角色通貨"
L["Display character money at bottom right of the backpack."] = "在背包右下方顯示玩家金錢。"
L["Drag to move this bag."] = "拖動以移動這個袋子。" -- Needs review
L["Drop an item there to add it to the list."] = "拖放物品至此可添加至列表。" -- Needs review
L["Drop your item there to add it to this section."] = "拖放物品加入到類別。"
L["Enabled"] = "啟用"
L["Enabled bags"] = "(啟用/關閉)袋UI介面" -- Needs review
L["ENCHANTING_BAG_TAG"] = "En"
L["ENGINEERING_BAG_TAG"] = "Eg"
L["Enter the name, link or itemid of the item to associate with the section. You can also drop an item into this box."] = "輸入名稱、連結或物品ID，也可以直接將物品拖曳至此處。"
L["Enter the name of the section to associate with the item."] = "輸入區塊名稱以建立相關"
L["Equipment"] = "裝備"
L["Equipped bags"] = "裝備背包"
L["Exclude list"] = "排除列表"
L["Fill lines at most"] = "填充線至多"
L["Filter"] = "過濾"
L["Filtering information"] = "過濾資訊"
L["Filters"] = "篩檢程式"
L["Filters are used to dispatch items in bag sections. One item can only appear in one section. If the same item is selected by several filters, the one with the highest priority wins."] = "篩檢程式是用來在背包分類中調度物品。一件物品只能在一個分類中顯示。如果在多個篩檢程式中選中相同的物品, 最高優先順序的一個將勝出。"
L["Font"] = "字型"
L["Four general sections."] = "裝備分為四大類(武器/護甲/飾品/其他)" -- Needs review
L["Free space"] = "可用空間"
L["Free space / total space"] = "空間/總空間"
L["Gear manager item sets"] = "裝備管理物品設定"
L["GEM_BAG_TAG"] = "Ge"
L["Gems are trade goods"] = "寶石是貿易商品"
L["Glyphs are trade goods"] = "雕紋是貿易商品"
L["Group sections of same category"] = "同種類的組群部份"
L["HERB_BAG_TAG"] = "He"
L["Hide zeroes"] = "隱藏零" -- Needs review
L["Highlight color"] = "高亮顏色"
L["Highlight scale"] = "高亮縮放"
L["Ignore currencies with null amounts."] = "忽略貨幣的無效量。" -- Needs review
L["Ignore low quality items"] = "忽略低品質的物品"
L["Included categories"] = "包含分類" -- Needs review
L["Include list"] = "包含列表"
L["... including incomplete stacks"] = "... 包括不完整的堆疊"
L["INSCRIPTION_BAG_TAG"] = "In"
L["Insets"] = "插圖" -- Needs review
L["Item"] = "物品"
L["Item category"] = "物品類別"
L["Item information"] = "物品資訊"
L["Items"] = "物品"
L["Items in this list are always considered as junk. Click an item to remove it from the list."] = "在此列表中的物品一直被視為垃圾。可從列表中點擊要剔除的物品。" -- Needs review
L["Items in this list are never considered as junk. Click an item to remove it from the list."] = "在此列表中的物品永遠不會被視為垃圾。可從列表中點擊要剔除的物品。" -- Needs review
L["Jewelry"] = "飾品"
L["Junk category"] = "垃圾" -- Needs review
L["Keep all stacks together."] = "保持全部堆疊合起來。"
L["KEYRING_TAG"] = "Ke"
L["Layout priority"] = "優先佈局"
L["LDB Plugin"] = "LDB 插件"
L["LEATHERWORKING_BAG_TAG"] = "Le"
L["Lock anchor"] = "鎖定錨點"
L["Low quality items"] = "劣質物品" -- Needs review
L["Manual"] = "手動"
L["Manual filtering"] = "手動過濾"
L["Maximum bag height"] = "最大高度的背包"
L["Maximum row width"] = "最大行寬度"
L["Maximum stack size"] = "最大的堆疊多少"
L["Merge bag types"] = "合併背包類型"
L["Merged sets"] = "合併設定"
L["Merge free space"] = "合併空間"
L["Merge incomplete stacks with complete ones."] = "合併顯示完整與不完整推疊"
L["Merge stackable items"] = "合併可堆疊的物品"
L["Merge unstackable items"] = "合併未可堆疊的物品"
L["MINING_BAG_TAG"] = "Mi"
L["Money"] = "金錢"
L["Move items from and to the bank by right-clicking on section headers."] = "移動項目物品及銀行通過右鍵單擊進行分類。" -- Needs review
L["Never"] = "從不"
L["New"] = "新物品"
L["New item highlight"] = "高亮新的物品"
L["New Override"] = "新覆蓋"
L["Not at merchants', bank, ..."] = "不是商人，銀行，..." -- Needs review
L["Nothing to sell."] = "不賣。" -- Needs review
L["One section per item slot."] = "依物品各自分區"
L["One section per set"] = "依套裝分組"
L["Only one section."] = "只分為一個區塊"
L["Only when required"] = "僅在需要時。" -- Needs review
L["Opacity"] = "透明度"
L["Please note this filter matchs every item. Any filter with lower priority than this one will have no effect."] = "請注意，此項篩選功能將適用全部物品，其他優先性較低的篩選設定將被覆蓋而無法生效。"
L["Plugins"] = "插件"
L["Position mode"] = "位置模式"
L["Press Alt while doing so to open the configuration panel instead."] = "按住Alt鍵，而這樣做，而不是打開配置面板。" -- Needs review
L["Priority"] = "優先順序"
L["Provides a LDB data source to be displayed by LDB display addons."] = "提供LDB顯示插件的資料來源"
L["Put any item that can be equipped (including bags) into the \"Equipment\" section."] = "放置可裝備物品至「裝備」分組。"
L["Put items belonging to one or more sets of the built-in gear manager in specific sections."] = "按裝備管理設置的套裝分組放置物品。"
L["Put items in sections depending on their first-level category at the Auction House."] = "按拍賣場主類型規則分組放置物品。" -- Needs review
L["Put items of poor quality or labeled as junk in the \"Junk\" section."] = "將不良品質或垃圾裝備放置於垃圾區塊。" -- Needs review
L["Put quest-related items in their own section."] = "將任務相關物品置入相關區塊"
L["Quality highlight"] = "品質高亮"
L["Quest indicator"] = "任務指示物"
L["Quest Items"] = "任務物品"
L["QUIVER_TAG"] = "Qu"
L["Remove"] = "移除"
L["Reset"] = "重設" -- Needs review
L["Reset new items"] = "重設新物品"
L["Reset position"] = "重設位置"
L["Right-click to configure."] = "右鍵單擊配置" -- Needs review
L["Right-click to move these items."] = "右鍵單擊以移動這些物品。" -- Needs review
L["Right-click to open options"] = "右鍵點擊開啟選項" -- Needs review
L["Right-click to sell these items."] = "右鍵單擊出售這些物品。" -- Needs review
L["Right-click to try to empty this bag."] = "右鍵點擊嘗試空白的背包。"
L["Right-click to (un)lock the bag anchor."] = "右鍵單擊(不鎖定/鎖定)袋錨點。" -- Needs review
L["Scale"] = "縮放"
L["Section"] = "部分"
L["Section category"] = "分類"
L["Section header"] = "分類" -- Needs review
L["Section setup"] = "部分設定"
L["Section visibility"] = "分類可見度" -- Needs review
L["Section visibility button"] = "部分可見按鈕"
L["Select how bag usage should be formatted in the plugin."] = "選擇背包使用狀況格式"
L["Select how items should be sorted within each section."] = "設定各區塊物品的分類方式"
L["Select how the bags are positionned."] = "選擇袋的位置" -- Needs review
L["Select the category of the section to associate. This is used to group sections together."] = "選擇分類相關聯的分組。這是用來組合分組。" -- Needs review
L["Select the sections in which the items should be dispatched."] = "選擇物品分配的分組"
L["Select the top objective of the layout algorithm."] = "選擇頂部的佈局演算的目標。" -- Needs review
L["Select which bags AdiBags should display."] = "選擇那個袋作為AdiBags顯示" -- Needs review
L["Select which first-level categories should be split by sub-categories."] = "選擇使用子類型分拆的物品主類型" -- Needs review
L["Semi-automated tidy"] = "半自動整理"
L["Separate incomplete stacks."] = "分開不完整的堆疊。"
L["Separate unstackable items."] = "分開未可堆疊的物品。"
L["Sets"] = "裝備設定"
L["Set: %s"] = "換裝設定: %s"
L["Show bag type icons"] = "顯示背包類型圖示"
L["Show bag type tags"] = "顯示背包類型標籤"
L["Show bank usage"] = "顯示銀行使用"
L["Show container information..."] = "顯示容器資訊"
L["Show every distinct item stacks."] = "顯示每個不同的物品堆疊。"
L["Show filtering information..."] = "顯示過濾資訊..."
L["Show item information..."] = "顯示物品資訊"
L["Show only one free slot for each kind of bags."] = "每種類型背包空間格合拼後數量。" -- Needs review
L["Show only one slot of items that can be stacked."] = "可堆疊物品合併顯示於一格"
L["Show only one slot of items that cannot be stacked."] = "將不可堆疊物品也集中顯示"
L["Show %s"] = "顯示 %s"
L["Size"] = "大小" -- Needs review
L["Skin"] = "皮膚" -- Needs review
L["Slot number"] = "槽數"
L["Sorting order"] = "排序"
L["SOUL_BAG_TAG"] = "So"
L["Space in use"] = "空間使用"
L["Space in use / total space"] = "空間使用/總空間"
L["Split armors by types"] = "根據武器種類進行分類"
L["Split by subcategories"] = "子類別的分離"
L["Strictly keep ordering"] = "嚴格地保持次序"
L["TACKLE_BOX_TAG"] = "網絡連接(Fi)" -- Needs review
L["Text"] = "文本" -- Needs review
L["Texture"] = "材質" -- Needs review
L["This setting allows to tone down what some people calls \"section dancing\" when moving/selling/milling items."] = "此設置可以淡化一些人所謂的“一節舞(section dancing)”時，移動/銷售/milling 項目。" -- Needs review
L["Tidy bags"] = "整理背包"
L["Tidy your bags by clicking on the small \"T\" button at the top left of bags. Special bags with free slots will be filled with macthing items and stackable items will be stacked to save space."] = "左上方的小“T”按鈕上點擊後整潔的你的行李袋。特殊袋的空間格，將充滿匹配和可堆疊的物品，將會堆疊以節省空間。" -- Needs review
L["Toggle and configure item filters."] = "切換和配置物品過濾。"
L["Toggle and configure plugins."] = "切換和配置插件。"
L["Tooltip information"] = "提示資訊"
L["Track new items"] = "追蹤新物品"
L["Track new items in each bag, displaying a glowing aura over them and putting them in a special section. \"New\" status can be reset by clicking on the small \"N\" button at top left of bags."] = "在每個袋追踪新的物品，顯示一個發光的光環在\"新的物品\"上，並把\"新的物品\"歸類為一個特殊分類-新物品。可以通過點擊左上角的小“N”按鈕，還原分類。" -- Needs review
L["Uncheck this to disable AdiBags."] = "不選此停用AdiBags。"
L["Unlock anchor"] = "解鎖錨點"
L["Use this section to define any item-section association."] = "使用此分類定義任意物品分組過濾" -- Needs review
L["Use this to adjust the bag scale."] = "調整包包大小"
L["Use this to adjust the quality-based border opacity. 100% means fully opaque."] = "調整品質邊框透明度 100%=完全不透明"
L["Virtual stacks"] = "虛擬堆疊"
L["Virtual stacks display in one place items that actually spread over several bag slots."] = "將散落於各背包內的同一物品以虛擬堆疊顯示"
L["Virtual stack slots"] = "虛擬堆疊插槽"
L["Warning: you are using an alpha or beta version of AdiBags without displaying Lua errors. If anything goes wrong, AdiBags (or any other addon causing some error) will simply stop working for apparently no reason. Please either enable the display of Lua errors or install an error handler addon like BugSack or Swatter."] = "警告：您使用的是α或β版本的AdiBags不顯示的Lua錯誤。如果出現任何錯誤，AdiBags（或任何其他插件，導致一些錯誤的），只是停止工作，顯然沒有理由。請使顯示的Lua錯誤或安裝錯誤處理程序插件(UI)如BugSack 或 Swatter。" -- Needs review
L["When alt is held down"] = "當 alt 按住"
L["When any modifier key is held down"] = "當任何修改鍵按住"
L["When checked, right-clicking on an empty space of a bag opens the configuration panel."] = "檢閱時，在包的空白處點擊右鍵，打開配置面板。" -- Needs review
L["When ctrl is held down"] = "當 ctrl 按住"
L["When shift is held down"] = "當 shift 按住"

------------------------ zhCN ------------------------
elseif locale == 'zhCN' then
L["Add a dropdown menu to bags that allow to hide the sections."] = "给背包添加下拉菜单, 允许隐藏分组."
L["Add association"] = "添加过滤"
L["Add more information in tooltips related to items in your bags."] = "显示物品的额外提示信息"
L["AdiBags Anchor"] = "AdiBags 锚点"
L["Adjust the maximum height of the bags, relative to screen size."] = "调整背包最大高度 (相对于屏幕)"
L["Adjust the maximum number of items per row."] = "调整每行物品显示最大数量."
L["AH category"] = "拍卖类"
L["AH subcategory"] = "拍卖子类"
L["Allow you manually redefine the section in which an item should be put. Simply drag an item on the section title."] = "允许手动更改物品放置位置, 将物体拽到区域标题处."
L["Always"] = "总是"
L["AMMO_TAG"] = "弹"
L["Ammunition"] = "弹药"
L["Anchored"] = "锚点"
L["Are you sure you want to remove this section ?"] = "确定移除此过滤 ?"
L["Backpack"] = "背包"
L["Bag #%d"] = "背包 #%d"
L["Bag number"] = "背包号"
L["Bags"] = "背包"
L["Bag type"] = "背包类型"
L["Bag usage format"] = "背包使用格式"
L["Bank"] = "银行"
L["Bank bag #%d"] = "银行包 #%d"
L["By category, subcategory, quality and item level (default)"] = "按类别, 子类别, 品质和物品等级(默认)"
L["By name"] = "按名称"
L["By quality and item level"] = "按品质和物品等级"
L["Category"] = "分类"
L["Change stacking at merchants', auction house, bank, mailboxes or when trading."] = "在交易, 拍卖, 银行, 邮局以及实施商业技能时更改堆叠效果."
L["Check sets that should be merged into a unique \"Sets\" section. This is obviously a per-character setting."] = "根据套装分组物品, 此项根据每个角色设置有所不同."
L["Check this so armors are dispatched in four sections by type."] = "护甲将按四大类型分组 (布甲/皮甲/锁甲/板甲)."
L["Check this so tidying is performed when you close the loot windows or you leave merchants, mailboxes, etc."] = "当关闭拾取窗口, 离开交易, 邮箱等动作时整理背包."
L["Check this to display a bag type tag in the top left corner of items."] = "在物品左上角显示标签, 标示其放置的特殊背包类型."
L["Check this to display a colored border around items, based on item quality."] = "按物品品质着色边框."
L["Check this to display an icon after usage of each type of bags."] = "在每个类型背包使用后显示一个图标."
L["Check this to display an indicator on quest items."] = "标示任务物品."
L["Check this to display an textual tag before usage of each type of bags."] = "在每个类型背包前显示文本标记."
L["Check this to display one individual section per set. If this is disabled, there will be one big \"Sets\" section."] = "每个套装独立分组, 禁用此选项, 将会合并成一个大[套装]分组"
L["Check this to display only one value counting all equipped bags, ignoring their type."] = "选中来让所有装备包显示一个值，忽略类型。"
L["Check this to have poor quality items dimmed."] = "将低品质物品变暗"
L["Check this to show space at your bank in the plugin."] = "在银行中显示背包空间"
L["Check this to show this section. Uncheck to hide it."] = "勾选则显示此分组, 不勾选则隐藏."
L["Check to enable this module."] = "启用此模块"
L["Click on a item to remove it from the list. You can drop an item on the empty slot to add it to the list."] = "点击物品可从列表中移除. 也可拖放物品至空栏以添加至列表."
L["Click on this button to create the new association."] = "创建一个新过滤"
L["Click or drag this item to remove it."] = "点击或拖出物品可移除."
L["Click there to reset the bag positions and sizes."] = "重置背包位置和尺寸"
L["Click to purchase"] = "购买"
L["Click to reset item status."] = "重置物品状态."
L["Click to select which sections should be shown or hidden. Section visibility is common to all bags."] = "设置显示/隐藏物品分组, 默认全部显示."
L["Click to tidy bags."] = "点击整理背包."
L["Click to toggle the bag anchor."] = "切换背包锚点"
L["Click to toggle the equipped bag panel, so you can change them."] = "点击切换背包面板, 用于更换背包."
L["Close"] = "关闭"
L["Configure"] = "配置"
L["Consider gems as a subcategory of trade goods"] = "将珠宝设定为商品子类"
L["Consider glyphs as a subcategory of trade goods"] = "将雕文设定为商品子类"
L["Container information"] = "容器信息"
L["Currencies to show"] = "货币显示"
L["Currency"] = "货币"
L["Dim junk"] = "灰色垃圾"
L["Display character currency at bottom left of the backpack."] = "在背包底部左侧显示角色拥有的货币."
L["Display character money at bottom right of the backpack."] = "在背包底部右侧显示金钱"
L["Drop an item there to add it to the list."] = "拖放物品至此可添加至列表."
L["Drop your item there to add it to this section."] = "拖曳物品到此分组."
L["Enabled"] = "启用"
L["ENCHANTING_BAG_TAG"] = "魔"
L["ENGINEERING_BAG_TAG"] = "工"
L["Enter the name, link or itemid of the item to associate with the section. You can also drop an item into this box."] = "输入物品名称, 链接或物品 ID 到此分组, 也可以拖曳物品至此."
L["Enter the name of the section to associate with the item."] = "输入分组名称以建立过滤"
L["Equipment"] = "装备"
L["Equipped bags"] = "已装备背包"
L["Exclude list"] = "排除列表"
L["Fill lines at most"] = "填充线最多"
L["Filter"] = "过滤"
L["Filtering information"] = "过滤信息"
L["Filters"] = "过滤器"
L["Filters are used to dispatch items in bag sections. One item can only appear in one section. If the same item is selected by several filters, the one with the highest priority wins."] = "过滤器将用于背包分类中调度物品, 一件物品仅可在一个分类中显示. 如果在多个过滤器中选中相同的物品, 将使用最高优先级."
L["Four general sections."] = "按护甲类型分组"
L["Free space"] = "空闲空间"
L["Free space / total space"] = "空闲 / 总空间"
L["Gear manager item sets"] = "套装管理"
L["GEM_BAG_TAG"] = "宝"
L["Gems are trade goods"] = "宝石是商品"
L["Glyphs are trade goods"] = "铭文是商品"
L["Group sections of same category"] = "同类的分类部分"
L["HERB_BAG_TAG"] = "草"
L["Highlight color"] = "高亮颜色"
L["Highlight scale"] = "高亮缩放"
L["Ignore low quality items"] = "忽略低品质物品"
L["Included categories"] = "包含过滤"
L["Include list"] = "包含列表"
L["... including incomplete stacks"] = "包含不完整堆叠"
L["INSCRIPTION_BAG_TAG"] = "铭"
L["Item"] = "物品"
L["Item category"] = "物品类别"
L["Item information"] = "物品信息"
L["Items"] = "物品"
L["Items in this list are always considered as junk. Click an item to remove it from the list."] = "此列表物品将不被归类为垃圾. 点击可移除."
L["Items in this list are never considered as junk. Click an item to remove it from the list."] = "此列表物品将不被归类为垃圾. 点击可移除."
L["Jewelry"] = "饰品"
L["Junk category"] = "垃圾"
L["Keep all stacks together."] = "将所有堆叠合并"
L["KEYRING_TAG"] = "钥"
L["Layout priority"] = "优先布局"
L["LDB Plugin"] = "LDB 组件"
L["LEATHERWORKING_BAG_TAG"] = "皮"
L["Lock anchor"] = "锁定锚点"
L["Low quality items"] = "劣质物品"
L["Manual"] = "手动"
L["Manual filtering"] = "手动过滤"
L["Maximum bag height"] = "最大背包高度"
L["Maximum row width"] = "最大行宽"
L["Maximum stack size"] = "最大堆叠"
L["Merge bag types"] = "合并背包类型"
L["Merged sets"] = "合并套装"
L["Merge free space"] = "合并空间"
L["Merge incomplete stacks with complete ones."] = "合并不完整堆叠"
L["Merge stackable items"] = "合并可堆叠物品"
L["Merge unstackable items"] = "合并不可堆叠的物品"
L["MINING_BAG_TAG"] = "矿"
L["Money"] = "金钱"
L["Never"] = "从不"
L["New"] = "新物品"
L["New item highlight"] = "高亮新物品"
L["New Override"] = "新建覆盖"
L["One section per item slot."] = "按物品位置分组"
L["One section per set"] = "按套装分组"
L["Only one section."] = "仅一个分组"
L["Opacity"] = "透明度"
L["Please note this filter matchs every item. Any filter with lower priority than this one will have no effect."] = "注意, 此筛选功能应用于全部物品, 其他优先级较低的筛选设置将被覆盖而无法生效."
L["Plugins"] = "组件"
L["Position mode"] = "定位模式"
L["Priority"] = "优先级"
L["Provides a LDB data source to be displayed by LDB display addons."] = "给 LDB 提供数据资料, 以便符合 LDB 规范的插件使用."
L["Put any item that can be equipped (including bags) into the \"Equipment\" section."] = "放置可装备物品至[装备]分组"
L["Put items belonging to one or more sets of the built-in gear manager in specific sections."] = "按装备管理设置的套装分组放置物品"
L["Put items in sections depending on their first-level category at the Auction House."] = "按拍卖行主类型规则分组放置物品."
L["Put items of poor quality or labeled as junk in the \"Junk\" section."] = "将低品质或者垃圾物品放入[垃圾]分组"
L["Put quest-related items in their own section."] = "将任务物品放入相关分组"
L["Quality highlight"] = "品质高亮"
L["Quest indicator"] = "任务指示器"
L["Quest Items"] = "任务物品"
L["QUIVER_TAG"] = "箭"
L["Remove"] = "移除"
L["Reset new items"] = "整理新物品"
L["Reset position"] = "重置位置"
L["Right-click to try to empty this bag."] = "右键点击尝试清空此背包."
L["Scale"] = "缩放"
L["Section"] = "分组"
L["Section category"] = "分组类型"
L["Section setup"] = "分组设定"
L["Section visibility"] = "分组可见"
L["Section visibility button"] = "分组可见按钮"
L["Select how bag usage should be formatted in the plugin."] = "选择背包使用状况格式"
L["Select how items should be sorted within each section."] = "物品在每个分组内排序方式"
L["Select the category of the section to associate. This is used to group sections together."] = "选择分组过滤类型. 用于聚合分组."
L["Select the sections in which the items should be dispatched."] = "选择物品分配的分组"
L["Select which first-level categories should be split by sub-categories."] = "选择使用子类型拆分的物品主类型"
L["Semi-automated tidy"] = "半自动整理"
L["Separate incomplete stacks."] = "分开不完整的堆叠"
L["Separate unstackable items."] = "分开不可堆叠的物品"
L["Sets"] = "套装"
L["Set: %s"] = "套装: %s"
L["Show bag type icons"] = "显示背包类型图标"
L["Show bag type tags"] = "显示背包类型标签"
L["Show bank usage"] = "显示银行占用"
L["Show container information..."] = "显示容器信息"
L["Show every distinct item stacks."] = "显示每个不同的物品堆叠"
L["Show filtering information..."] = "显示过滤信息"
L["Show item information..."] = "显示物品信息"
L["Show only one free slot for each kind of bags."] = "每种类型背包空余空间分别合并显示为一格"
L["Show only one slot of items that can be stacked."] = "将可堆叠物品合并显示为一格"
L["Show only one slot of items that cannot be stacked."] = "将不可堆叠物品合并显示为一格"
L["Show %s"] = "显示 %s"
L["Slot number"] = "槽号"
L["Sorting order"] = "分类顺序"
L["SOUL_BAG_TAG"] = "魂"
L["Space in use"] = "已使用空间"
L["Space in use / total space"] = "已使用空间 / 总空间"
L["Split armors by types"] = "按类型拆分护甲"
L["Split by subcategories"] = "按子类拆分"
L["Strictly keep ordering"] = "保持次序"
L["Tidy bags"] = "整理背包"
L["Tidy your bags by clicking on the small \"T\" button at the top left of bags. Special bags with free slots will be filled with macthing items and stackable items will be stacked to save space."] = "点击背包右上的小\"T\"整理背包.\\n物品将优先放入可容纳它的特殊背包, 并且可堆叠的物品将自动堆叠以便释放背包空间."
L["Toggle and configure item filters."] = "配置物品过滤"
L["Toggle and configure plugins."] = "配置组件"
L["Tooltip information"] = "提示信息"
L["Track new items"] = "追踪新物品"
L["Track new items in each bag, displaying a glowing aura over them and putting them in a special section. \"New\" status can be reset by clicking on the small \"N\" button at top left of bags."] = "追踪背包中的新物品, 新物品在[新物品]区将高亮显示, 可以点击右上[N]按钮将其重置."
L["Uncheck this to disable AdiBags."] = "反选禁用 AdiBags"
L["Unlock anchor"] = "解锁锚点"
L["Use this section to define any item-section association."] = "使用此分组定义任意物品分组过滤"
L["Use this to adjust the bag scale."] = "背包缩放"
L["Use this to adjust the quality-based border opacity. 100% means fully opaque."] = "调整品质背景透明度, 100% 为不透明"
L["Virtual stacks"] = "虚拟堆叠"
L["Virtual stacks display in one place items that actually spread over several bag slots."] = "虚拟堆叠将同一物品用一个单位显示, 实际在背包中仍占用多个位置."
L["Virtual stack slots"] = "虚拟堆叠"
L["When alt is held down"] = "按下 ALT"
L["When any modifier key is held down"] = "按下任意键"
L["When ctrl is held down"] = "按下 CTRL"
L["When shift is held down"] = "按下 SHIFT"

------------------------ koKR ------------------------
elseif locale == 'koKR' then
L["Add a dropdown menu to bags that allow to hide the sections."] = "항목을 숨길 수 있도록 허용하는 가방에 드롭다운 메뉴를 추가합니다. "
L["Add association"] = "연계체 추가"
L["Add more information in tooltips related to items in your bags."] = "가방안의 아이템과 관련된 툴팁에 더 많은 정보를 추가합니다."
L["AdiBags Anchor"] = "AdiBags 앵커"
L["Adjust the maximum height of the bags, relative to screen size."] = "화면 크기를 고려해, 가방의 최대 높이를 조절합니다."
L["Adjust the maximum number of items per row."] = "열당 아이템의 최대 갯수를 조절합니다."
L["AH category"] = "경매장 분류"
L["AH subcategory"] = "경매장 하위 분류"
L["Allow you manually redefine the section in which an item should be put. Simply drag an item on the section title."] = "수동으로 아이템을 넣을 항목을 재정의할 수 있도록 합니다. 단순히 아이템을 잡아 끌어다 해당 항목 제목에 놓으세요."
L["Alt-right-click to switch to anchored placement."] = "'Alt 키' + '오른쪽클릭' 고정위치으로 전환" -- Needs review
L["Alt-right-click to switch to manual placement."] = "'Alt 키' + '오른쪽클릭' 수동위치로 전환" -- Needs review
L["Always"] = "항상"
L["AMMO_TAG"] = "탄"
L["Ammunition"] = "탄약"
L["Anchored"] = "앵커 지정"
L["Are you sure you want to remove this section ?"] = "정말로 이 항목을 제거하시겠습니까?"
L["As soon as possible"] = "가능한 빨리" -- Needs review
L["At mechants', bank, auction house, ..."] = "상인, 은행,경매장에서" -- Needs review
L["Automatic layout update"] = "자동으로 레이아웃 최신화" -- Needs review
L["Backpack"] = "가방"
L["Backpack color"] = "가방 색" -- Needs review
L["Bag background"] = "가방 배경" -- Needs review
L["Bag #%d"] = "가방 #%d"
L["Bag number"] = "가방 갯수"
L["Bags"] = "가방"
L["Bag type"] = "가방 유형"
L["Bag usage format"] = "가방 사용 칸수 형식"
L["Bank"] = "은행"
L["Bank bag #%d"] = "은행 가방 #%d"
L["Bank color"] = "은행 색" -- Needs review
L["Bank Switcher"] = "은행 전환기" -- Needs review
L["Border"] = "테두리" -- Needs review
L["Border width"] = "테두리 두께" -- Needs review
L["By category, subcategory, quality and item level (default)"] = "분류, 하위 분류, 품질과 아이템 레벨별(기본)"
L["By name"] = "이름별"
L["By quality and item level"] = "품질과 아이템 레벨별"
L["Category"] = "분류"
L["Change stacking at merchants', auction house, bank, mailboxes or when trading."] = "상점, 경매장, 은행, 우편함에서 혹은 거래 중인 경우에 겹치기를 변경합니다. "
L["Check sets that should be merged into a unique \"Sets\" section. This is obviously a per-character setting."] = "고유의 \"세트\" 항목안에 병합되어질 세트를 체크하세요. 이것은 명백한 캐릭터별 설정입니다."
L["Check this so armors are dispatched in four sections by type."] = "방어구를 유형별로 4개의 항목안에 처리할 것 같으면 이것에 체크하십시요."
L["Check this so tidying is performed when you close the loot windows or you leave merchants, mailboxes, etc."] = "전리품 획득창을 닫거나 상점. 우편함등을 벗어 난 경우에 정리를 수행할 것 같으면 이것에 체크하십시요."
L["Check this to display a bag type tag in the top left corner of items."] = "아이템의 상단 좌측 모서리에 가방 유형 태그를 표시하려면 이것에 체크하세요."
L["Check this to display a colored border around items, based on item quality."] = "아이템 품질에 기반해, 아이템 주위에 색이 입혀진 테두리를 표시하려면 이것에 체크하세요."
L["Check this to display an icon after usage of each type of bags."] = "각 유형의 가방 사용 칸수 뒤에 아이콘을 표시하려면 이것에 체크하세요."
L["Check this to display an indicator on quest items."] = "퀘스트 아이템에 지시기를 표시하려면 이것에 체크하세요."
L["Check this to display an textual tag before usage of each type of bags."] = "각 유형의 가방 사용 칸수 앞에 문자 태그를 표시하려면 이것에 체크하세요."
L["Check this to display one individual section per set. If this is disabled, there will be one big \"Sets\" section."] = "세트당 개별적인 하나의 항목을 표시하려면 이것에 체크하세요. 비활성화 한다면, 커다란 하나의 \"세트\" 항목이 될 것입니다."
L["Check this to display only one value counting all equipped bags, ignoring their type."] = "착용된 모든 가방을 그것의 유형을 무시한 체로, 단지 하나의 값으로 셈해 표시하려면 이것에 체크하세요. "
L["Check this to have poor quality items dimmed."] = "하급 아이템을 흐릿하게 하려면 이것에 체크하세요."
L["Check this to show space at your bank in the plugin."] = "플러그인 안에 은행에서의 칸수를 보여주려면 이것에 체크하세요."
L["Check this to show this section. Uncheck to hide it."] = "이 항목을 보려면 이것에 체크하십시요. 그것을 숨기려면 체크를 해제하십시요."
L["Check to enable this module."] = "이 모듈을 사용하려면 체크하세요."
L["Click on a item to remove it from the list. You can drop an item on the empty slot to add it to the list."] = "목록에서 아이템을 제거하려면 해당 아이템에 클릭하세요. 목록으로 아이템을 추가하려면 해당 아이템을 빈칸에 떨굴 수도 있습니다."
L["Click on this button to create the new association."] = "새로운 연결체를 생성하기 위해서 이 버튼을 클릭합니다."
L["Click or drag this item to remove it."] = "이 아이템을 제거하려면 클릭하거나 잡아 끌으세요."
L["Click there to reset the bag positions and sizes."] = "가방의 위치와 크기를 초기화하려면 거기를 클릭하세요."
L["Click to purchase"] = "구매하려면 클릭하세요."
L["Click to reset item status."] = "아이템 현황을 초기화하려면 클릭하세요."
L["Click to select which sections should be shown or hidden. Section visibility is common to all bags."] = "보여주거나 숨겨야 할 항목을 선택하려면 클릭하십시요. 항목 표시는 모든 가방에 공통적입니다."
L["Click to tidy bags."] = "가방을 정돈하려면 클릭하세요."
L["Click to toggle the bag anchor."] = "가방 앵커를 전환하려면 클릭하세요."
L["Click to toggle the equipped bag panel, so you can change them."] = "착용된 가방 패널을 전환하기 위해 클릭함으로써, 그것을 변경할 수 있습니다. "
L["Close"] = "닫기"
L["Configure"] = "설정"
L["Consider gems as a subcategory of trade goods"] = "직업용품의 하위분류로 보석을 고려"
L["Consider glyphs as a subcategory of trade goods"] = "직업용품의 하위분류로 문양을 고려"
L["Container information"] = "보관함 정보"
L["Currencies to show"] = "보여 줄 화폐"
L["Currency"] = "화폐"
L["Dim junk"] = "잡동사니 흐릿하게 하기"
L["Display character currency at bottom left of the backpack."] = "가방의 하단 좌측에 캐릭터의 화폐를 표시합니다."
L["Display character money at bottom right of the backpack."] = "가방의 오른쪽 아래에 캐릭터의 소지금을 표시합니다."
L["Drag to move this bag."] = "가방을 움직이려면 드래그" -- Needs review
L["Drop an item there to add it to the list."] = "목록으로 아이템을 추가하려면 해당 아이템을 거기에 떨구세요. "
L["Drop your item there to add it to this section."] = "이 항목으로 아이템을 추가하려면 거기에 아이템을 떨구세요."
L["Enabled"] = "사용"
L["ENCHANTING_BAG_TAG"] = "마부"
L["ENGINEERING_BAG_TAG"] = "기공"
L["Enter the name, link or itemid of the item to associate with the section. You can also drop an item into this box."] = "항목과 연계하기 위한 아이템의 이름, 링크, 아이템 id를 입력합니다. 또한 이 박스안에 아이템을 떨굴 수 있습니다."
L["Enter the name of the section to associate with the item."] = "아이템과 연계하기 위한 항목의 이름을 입력합니다."
L["Equipment"] = "착용 장비"
L["Equipped bags"] = "착용된 가방"
L["Exclude list"] = "제외 목록"
L["Fill lines at most"] = "대부분 줄 채우기"
L["Filter"] = "선별"
L["Filtering information"] = "선별하기 정보"
L["Filters"] = "선별기"
L["Filters are used to dispatch items in bag sections. One item can only appear in one section. If the same item is selected by several filters, the one with the highest priority wins."] = "선별기는 아이템을 각각의 가방 항목안에 처리하기 위해 사용됩니다. 하나의 항목에는 오로지 하나의 아이템만 표시될 수 있습니다.  만일 동일한 아이템이 몇가지 선별기에 의해 선택되었다면, 가장 높은 우선순위를 지닌 하나가 선택될 것입니다.    "
L["Font"] = "글꼴" -- Needs review
L["Four general sections."] = "네가지 공통 항목"
L["Free space"] = "빈 칸"
L["Free space / total space"] = "빈 칸 / 전체 칸"
L["Gear manager item sets"] = "장비 관리창 아이템 세트"
L["GEM_BAG_TAG"] = "보"
L["Gems are trade goods"] = "보석은 직업용품"
L["Glyphs are trade goods"] = "문양은 직업용품"
L["Group sections of same category"] = "같은 분류의 항목 그룹화"
L["HERB_BAG_TAG"] = "약"
L["Highlight color"] = "색상 강조"
L["Highlight scale"] = "비율 강조"
L["Ignore low quality items"] = "낮은 품질의 아이템 무시"
L["Included categories"] = "포함된 분류"
L["Include list"] = "포함 목록"
L["... including incomplete stacks"] = "겹침이 완료되지 않은 아이템을 포함"
L["INSCRIPTION_BAG_TAG"] = "주각"
L["Item"] = "아이템"
L["Item category"] = "아이템 분류"
L["Item information"] = "아이템 정보"
L["Items"] = "아이템"
L["Items in this list are always considered as junk. Click an item to remove it from the list."] = "이 목록에 있는 아이템은 항상 잡동사니로 간주됩니다. 목록에서 아이템을 제거하려면 해당 아이템에 클릭하세요."
L["Items in this list are never considered as junk. Click an item to remove it from the list."] = "이 목록에 있는 아이템은 결코 잡동사니로 간주되지 않습니다. 목록에서 아이템을 제거하려면 해당 아이템에 클릭하세요. "
L["Jewelry"] = "보석류"
L["Junk category"] = "잡동사니 분류"
L["Keep all stacks together."] = "모든 겹치기를 동시에 유지합니다."
L["KEYRING_TAG"] = "열"
L["Layout priority"] = "레이아웃 우선순위"
L["LDB Plugin"] = "LDB 플러그인"
L["LEATHERWORKING_BAG_TAG"] = "가세"
L["Lock anchor"] = "앵커 잠그기"
L["Low quality items"] = "낮은 품질의 아이템"
L["Manual"] = "수동"
L["Manual filtering"] = "수동으로 선별하기"
L["Maximum bag height"] = "최대 가방 높이"
L["Maximum row width"] = "최대 열 너비"
L["Maximum stack size"] = "최대 중첩 크기"
L["Merge bag types"] = "가방 유형 병합"
L["Merged sets"] = "세트 병합"
L["Merge free space"] = "빈 칸 합치기"
L["Merge incomplete stacks with complete ones."] = "겹침이 완료되지 않은 아이템을 겹침이 완료된 아이템과 함께 합칩니다."
L["Merge stackable items"] = "겹침이 가능한 아이템 합치기"
L["Merge unstackable items"] = "겹칠 수 없는 아이템 합치기"
L["MINING_BAG_TAG"] = "채광"
L["Money"] = "소지금"
L["Never"] = "안함"
L["New"] = "새 아이템"
L["New item highlight"] = "새 아이템 강조"
L["New Override"] = "새것으로 덮어 쓰기"
L["One section per item slot."] = "아이템 칸당 한개의 항목"
L["One section per set"] = "세트당 한개의 항목"
L["Only one section."] = "오직 한개의 항목"
L["Only when required"] = "필요할때만" -- Needs review
L["Opacity"] = "불투명도"
L["Please note this filter matchs every item. Any filter with lower priority than this one will have no effect."] = "이 선별기에 일치하는 모든 아이템에 주의하기 바랍니다. 이것보다 더 낮은 우선순위를 지닌 어떠한 선별기도 영향을 주지 못할 것입니다."
L["Plugins"] = "플러그인"
L["Position mode"] = "위치 모드"
L["Priority"] = "우선순위"
L["Provides a LDB data source to be displayed by LDB display addons."] = "LDB 표시 애드온에 의해 표시될 수 있도록 LDB 자료 출처를 제공합니다. "
L["Put any item that can be equipped (including bags) into the \"Equipment\" section."] = "착용할 수 있는 모든 아이템(가방을 포함한)을 \"착용 장비\" 항목에 집어 넣습니다."
L["Put items belonging to one or more sets of the built-in gear manager in specific sections."] = "내장된 장비 관리창의 하나 혹은 그 이상의 세트에 속해 있는 아이템을 해당 항목에 집어 넣습니다."
L["Put items in sections depending on their first-level category at the Auction House."] = "경매장에서 그것의 첫번째 레벨 분류에 의존하는 항목안에 아이템을 집어 넣습니다."
L["Put items of poor quality or labeled as junk in the \"Junk\" section."] = "하위 품질 혹은 잡동사니로 이름 붙여진 아이템을 \"잡동사니\" 항목에 집어 넣습니다."
L["Put quest-related items in their own section."] = "퀘스트와 관련된 아이템을 그 자신의 항목에 집어 넣습니다."
L["Quality highlight"] = "품질 강조"
L["Quest indicator"] = "퀘스트 지시기"
L["Quest Items"] = "퀘스트 아이템"
L["QUIVER_TAG"] = "화"
L["Remove"] = "제거"
L["Reset new items"] = "새 아이템 초기화"
L["Reset position"] = "위치 초기화"
L["Right-click to configure."] = "'오른쪽 클릭' 으로 설정 열기" -- Needs review
L["Right-click to try to empty this bag."] = "이 가방을 비우려면 오른쪽 클릭 하십시요."
L["Scale"] = "비율"
L["Section"] = "항목"
L["Section category"] = "항목 분류"
L["Section setup"] = "항목 설정"
L["Section visibility"] = "항목 표시"
L["Section visibility button"] = "항목 표시 버튼"
L["Select how bag usage should be formatted in the plugin."] = "플러그인에 가방 사용 칸수를 어떻게 형식화할 것인지를 선택합니다."
L["Select how items should be sorted within each section."] = "각 항목내에서 아이템을 어떻게 정리할 것인지를 선택합니다."
L["Select the category of the section to associate. This is used to group sections together."] = "연계하기 위한 항목의 분류를 선택합니다."
L["Select the sections in which the items should be dispatched."] = "아이템을 처리하게 될 항목을 선택합니다."
L["Select which first-level categories should be split by sub-categories."] = "하위 분류에 의해 나눠져야 할 첫번째 레벨 분류를 선택합니다."
L["Semi-automated tidy"] = "반자동 정리"
L["Separate incomplete stacks."] = "겹침이 완료되지 않은 아이템은 분리합니다."
L["Separate unstackable items."] = "겹칠 수 없는 아이템은 분리합니다."
L["Sets"] = "세트"
L["Set: %s"] = "세트 : %s"
L["Show bag type icons"] = "가방 유형 아이콘 보이기"
L["Show bag type tags"] = "가방 유형 태그 보이기"
L["Show bank usage"] = "은행 사용 칸수 보이기"
L["Show container information..."] = "보관함의 정보를 보입니다."
L["Show every distinct item stacks."] = "모든 확실하게 겹친 아이템을 보여줍니다."
L["Show filtering information..."] = "선별하기 정보를 보입니다."
L["Show item information..."] = "아이템 정보를 보입니다."
L["Show only one free slot for each kind of bags."] = "가방의 각 종류에 대해 비워 있는 한 칸으로만 보여줍니다."
L["Show only one slot of items that can be stacked."] = "겹칠 수 있는 아이템을 한 칸으로만 보여줍니다."
L["Show only one slot of items that cannot be stacked."] = "겹칠 수 없는 아이템을 한 칸으로만 보여줍니다."
L["Show %s"] = "%s 보이기"
L["Size"] = "크기" -- Needs review
L["Skin"] = "스킨" -- Needs review
L["Slot number"] = "칸수"
L["Sorting order"] = "정리 순서"
L["SOUL_BAG_TAG"] = "조각"
L["Space in use"] = "사용된 칸수"
L["Space in use / total space"] = "사용된 칸수/전체 칸수"
L["Split armors by types"] = "유형별로 방어구 분리"
L["Split by subcategories"] = "하위 분류에 따라 분리"
L["Strictly keep ordering"] = "엄격히 순서 유지"
L["Tidy bags"] = "가방 정리"
L["Tidy your bags by clicking on the small \"T\" button at the top left of bags. Special bags with free slots will be filled with macthing items and stackable items will be stacked to save space."] = "가방 상단 우측에 작은 \"T\" 버튼을 클릭함으로써 가방을 정리합니다. 빈 칸의 전문 가방은 합당한 아이템으로 채워질 것이며 칸을 절약하기 위해 중첩이 가능한 아이템은 겹쳐질 것입니다."
L["Toggle and configure item filters."] = "아이템 선별 전환 및 설정"
L["Toggle and configure plugins."] = "플러그인 전환 및 설정"
L["Tooltip information"] = "툴팁 정보"
L["Track new items"] = "새 아이템 추적"
L["Track new items in each bag, displaying a glowing aura over them and putting them in a special section. \"New\" status can be reset by clicking on the small \"N\" button at top left of bags."] = "각 가방에 있는 새 아이템을 추적해, 그 위에 광이 나는 오라로 표시하고 별도의 항목에 집어 넣을 것입니다. \"새 아이템\" 상태는 가방 상단 우측의 작은 \"N\" 버튼을 클릭하는 것으로 초기화할 수 있습니다, "
L["Uncheck this to disable AdiBags."] = "AdiBags를 비활성화하려면 이것을 체크 해제 하십시요."
L["Unlock anchor"] = "앵커의 잠금 해제"
L["Use this section to define any item-section association."] = "특정 아이템 항목의 연계성을 재정의하기 위해서 이 항목을 사용합니다."
L["Use this to adjust the bag scale."] = "가방 비율을 조절하려면 이것을 사용하세요."
L["Use this to adjust the quality-based border opacity. 100% means fully opaque."] = "등급에 기반한 테두리 불투명도를 조절하려면 이것을 사용하세요. 100%는 꽉찬 투명도를 의미합니다. "
L["Virtual stacks"] = "가상 겹치기"
L["Virtual stacks display in one place items that actually spread over several bag slots."] = "가상 겹치기는 실제로 여러개의 가방 칸을 차지하는 아이템을 한칸으로 표시합니다."
L["Virtual stack slots"] = "가상의 겹침 칸"
L["When alt is held down"] = "alt 키를 누르고 있는 경우"
L["When any modifier key is held down"] = "특정 변경키를 누르고 있는 경우"
L["When ctrl is held down"] = "ctrl 키를 누르고 있는 경우"
L["When shift is held down"] = "shift 키를 누르고 있는 경우"

------------------------ ptBR ------------------------
elseif locale == 'ptBR' then
L["Add a dropdown menu to bags that allow to hide the sections."] = "Adicione um menu retrátil nas bolsas que permitem esconder as seções"
L["Add association"] = "Adicionar associação"
L["Add more information in tooltips related to items in your bags."] = "Adicionar mais informação nas janelas de saque relacionadas aos itens em suas bolsas"
L["AdiBags Anchor"] = "Âncora do AdiBags"
L["Adjust the maximum height of the bags, relative to screen size."] = "Ajusta a altura máxima das bolsas, relativo a altura da tela"
L["Adjust the maximum number of items per row."] = "Ajusta o número máximo de itens por linha"
L["AH category"] = "Categoria da casa de leilões"
L["AH subcategory"] = "Subcategoria da casa de leilões"
L["Allow you manually redefine the section in which an item should be put. Simply drag an item on the section title."] = "Permite-lhe redefinir manualmente a seção na qual um item deve ser colocado. Basta arrastar o item no título de seleção."
L["Alt-right-click to configure manual filtering."] = "Alt-clique-direito para configurar a filtragem de manuais." -- Needs review
L["Alt-right-click to configure the Junk module."] = "Alt direito do mouse para configurar o módulo de Lixo" -- Needs review
L["Always"] = "Sempre"
L["AMMO_TAG"] = "Am"
L["Ammunition"] = "Munição"
L["Anchored"] = "Ancorado"
L["Are you sure you want to remove this section ?"] = "Tem certeza de que deseja remover esta seção?"
L["Backpack"] = "Mochila"
L["Bag #%d"] = "Bolsa #%d"
L["Bag number"] = "Número da bolsa"
L["Bags"] = "Bolsas"
L["Bag type"] = "Tipo de bolsa"
L["Bag usage format"] = "Formato de uso de bolsas"
L["Bank"] = "Banco"
L["Bank bag #%d"] = "Bolsa do banco #%d"
L["By category, subcategory, quality and item level (default)"] = "Por categoria, subcategoria, qualidade e nível do item (padrão)" -- Needs review
L["By name"] = "Por nome"
L["By quality and item level"] = "Por qualidade e nível do item" -- Needs review
L["Category"] = "Categoria"
L["Change stacking at merchants', auction house, bank, mailboxes or when trading."] = "Mude empilhando nos vendedores, casa de leilões, banco, caixa de correio ou quando negociando"
L["Check sets that should be merged into a unique \"Sets\" section. This is obviously a per-character setting."] = "Verifica equipamentos que deveriam ser fundidos numa única seção \"sets\". Isso é obviamente uma configuração por personagem"
L["Check this so armors are dispatched in four sections by type."] = "Marque para que armaduras sejam colocadas em quatro seções por tipo"
L["Check this so tidying is performed when you close the loot windows or you leave merchants, mailboxes, etc."] = "Marque para que arrumação seja feita quando você fecha a janela de saque, vendedores, caixas dos correios, etc"
L["Check this to display a bag type tag in the top left corner of items."] = "Marque para mostrar o tipo de bolsa no topo esquerdo dos itens"
L["Check this to display a colored border around items, based on item quality."] = "Marque para mostrar uma borda colorida em volta dos itens, baseados em sua qualidade"
L["Check this to display an icon after usage of each type of bags."] = "Marque para mostrar um ícone após o uso de cada tipo de bolsas"
L["Check this to display an indicator on quest items."] = "Marque para mostrar um indicador de itens de missões"
L["Check this to display an textual tag before usage of each type of bags."] = "Marque para mostrar uma aba de texto antes do uso de cada tipo de bolsas"
L["Check this to display one individual section per set. If this is disabled, there will be one big \"Sets\" section."] = "Marque para mostrar uma seção individual por conjunto de equipamentos. Se desabilitado mostrará uma enorme seção de \"sets\"."
L["Check this to display only one value counting all equipped bags, ignoring their type."] = "Marque para mostrar somente um valor contando todas as bolsas equipadas, ignorando seu tipo"
L["Check this to have poor quality items dimmed."] = "Marque para ter itens de qualidade inferior apagados"
L["Check this to show space at your bank in the plugin."] = "Marque para mostrar o espaço no seu banco no plugin"
L["Check this to show this section. Uncheck to hide it."] = "Marque para mostrar essa seção. Desmarque para escondê-la"
L["Check to enable this module."] = "Marque para habilitar esse módulo"
L["Click on a item to remove it from the list. You can drop an item on the empty slot to add it to the list."] = "Clique em um item para removê-lo da lista. Você pode soltar um item num espaço vazio para adicioná-lo a lista"
L["Click on this button to create the new association."] = "Clique botão para criar uma nova associação"
L["Click or drag this item to remove it."] = "Clique e arraste este item para removê-lo"
L["Click there to reset the bag positions and sizes."] = "Clique para resetar os tamanhos e posições das bolsas"
L["Click to purchase"] = "Clique para comprar"
L["Click to reset item status."] = "Clique para resetar os status dos itens"
L["Click to select which sections should be shown or hidden. Section visibility is common to all bags."] = "Clique para selecionar quais seções deverão ser mostradas ou escondidas. Seleção de visibilidade é comum para todas as bolsas."
L["Click to tidy bags."] = "Clique para arrumar as bolsas"
L["Click to toggle the bag anchor."] = "Clique para alternar a âncora da bolsa"
L["Click to toggle the equipped bag panel, so you can change them."] = "Clique para alternar o painel da bolsa equipada, assim você pode alterá-las"
L["Close"] = "Fechar"
L["Configure"] = "Configurar"
L["Consider gems as a subcategory of trade goods"] = "Considera gemas como uma subcategoria de bens de troca"
L["Consider glyphs as a subcategory of trade goods"] = "Considera glifos como uma subcategoria de bens de troca"
L["Container information"] = "Informação do conteiner"
L["Currencies to show"] = "Moedas a mostrar"
L["Currency"] = "Moeda"
L["Dim junk"] = "Apagar sucata"
L["Display character currency at bottom left of the backpack."] = "Mostrar moedas do personagem na parte inferior esquerda da mochila"
L["Display character money at bottom right of the backpack."] = "Mostra o dinheiro do personagem na parte de baixo direita da mochila"
L["Drop an item there to add it to the list."] = "Solte um item aqui para adicioná-lo a lista"
L["Drop your item there to add it to this section."] = "Solte seu item aqui para adicionar a esta seção"
L["Enabled"] = "Ligado"
L["ENCHANTING_BAG_TAG"] = "Enc" -- Needs review
L["ENGINEERING_BAG_TAG"] = "Eng" -- Needs review
L["Enter the name, link or itemid of the item to associate with the section. You can also drop an item into this box."] = "Entre com o nome, link ou ID do item para associá-lo com a seção. Você também pode arrastar e soltar o item nesta caixa"
L["Enter the name of the section to associate with the item."] = "Entre o nome da seção para associar com o item"
L["Equipment"] = "Equipamento"
L["Equipped bags"] = "Bolsas equipadas"
L["Exclude list"] = "Excluir a lista"
L["Fill lines at most"] = "Encher linhas até o máximo"
L["Filter"] = "Filtro"
L["Filtering information"] = "Informação de filtragem"
L["Filters"] = "Filtros"
L["Filters are used to dispatch items in bag sections. One item can only appear in one section. If the same item is selected by several filters, the one with the highest priority wins."] = "Filtros são usados para enviar itens para as seções das bolsas. Um item pode aparecer somente em uma seção. Se o mesmo item está selecionado para vários filtros, o com maior prioridade definida vence."
L["Four general sections."] = "Quatro seções gerais"
L["Free space"] = "Espaço livre"
L["Free space / total space"] = "Espaço livre / espaço total"
L["Gear manager item sets"] = "Gerenciador de equipamento"
L["GEM_BAG_TAG"] = "Ge" -- Needs review
L["Gems are trade goods"] = "Gemas são bens de troca"
L["Glyphs are trade goods"] = "Glifos são bens de troca"
L["Group sections of same category"] = "Agrupar seções de mesma categoria"
L["HERB_BAG_TAG"] = "Er" -- Needs review
L["Highlight color"] = "Cor de destaque"
L["Highlight scale"] = "Escala de destaque"
L["Ignore low quality items"] = "Ignora itens de qualidade inferior"
L["Included categories"] = "Categorias inclusas"
L["Include list"] = "Incluir lista"
L["... including incomplete stacks"] = "... incluindo pilhas incompletas"
L["INSCRIPTION_BAG_TAG"] = "Esc" -- Needs review
L["Item"] = "Item"
L["Item category"] = "Categoria do item"
L["Item information"] = "Informação do item"
L["Items"] = "Itens"
L["Items in this list are always considered as junk. Click an item to remove it from the list."] = "Itens nessa lista são sempre considerados sucata. Click em um item para removê-lo da lista"
L["Items in this list are never considered as junk. Click an item to remove it from the list."] = "Itens nessa lista nunca serão considerados sucata. Clique em um item para removê-lo da lista."
L["Jewelry"] = "Jóias"
L["Junk category"] = "Categoria de sucata"
L["Keep all stacks together."] = "Manter todas as pilhas juntas"
L["KEYRING_TAG"] = "Ch" -- Needs review
L["Layout priority"] = "Prioridade do layout"
L["LDB Plugin"] = "Plugin LDB"
L["LEATHERWORKING_BAG_TAG"] = "Co" -- Needs review
L["Lock anchor"] = "Travar âncora"
L["Low quality items"] = "Item inferior"
L["Manual"] = "Manual"
L["Manual filtering"] = "Filtragem manual"
L["Maximum bag height"] = "Altura máxima da bolsa"
L["Maximum row width"] = "Largura máxima da coluna"
L["Maximum stack size"] = "Tamanho máximo do empilhamento"
L["Merge bag types"] = "Fundir tipos de bolsas"
L["Merged sets"] = "Sets fundidos"
L["Merge free space"] = "Fundir espaço livre"
L["Merge incomplete stacks with complete ones."] = "Funde pilhas incompletas com completas"
L["Merge stackable items"] = "Funde itens empilháveis"
L["Merge unstackable items"] = "Fundir itens não empilháveis"
L["MINING_BAG_TAG"] = "Mi" -- Needs review
L["Money"] = "Dinheiro"
L["Never"] = "Nunca"
L["New"] = "Novo"
L["New item highlight"] = "Destaque de itens novos"
L["New Override"] = "Nova Importancia"
L["One section per item slot."] = "Uma seção por espaço"
L["One section per set"] = "Uma seção por set"
L["Only one section."] = "Somente uma seção"
L["Opacity"] = "Opacidade"
L["Please note this filter matchs every item. Any filter with lower priority than this one will have no effect."] = "Por favor note que este filtro engloba todos os itens. qualquer filtro com menor prioridade não terá efeito algum."
L["Plugins"] = "Plugins"
L["Position mode"] = "Modo de posicionamento"
L["Priority"] = "Prioridade"
L["Provides a LDB data source to be displayed by LDB display addons."] = "Fornece uma fonte LDB para ser exibida por LDB addons"
L["Put any item that can be equipped (including bags) into the \"Equipment\" section."] = "Põe qualquer item que pode ser equipado (incluindo bolsas) na categoria \"equipamento\""
L["Put items belonging to one or more sets of the built-in gear manager in specific sections."] = "Põe itens pertencentes a um ou mais sets do gerenciador de equipamentos padrão em seções específicas"
L["Put items in sections depending on their first-level category at the Auction House."] = "Põe itens em seções dependendo da categoria inicial na Casa de Leilões"
L["Put items of poor quality or labeled as junk in the \"Junk\" section."] = "Põe itens de qualidade inferior ou rotulados como sucata na seção \"Sucata\" "
L["Put quest-related items in their own section."] = "Põe itens relativos a missões em suas respectivas seções"
L["Quality highlight"] = "Destaca qualidade"
L["Quest indicator"] = "Indicador de missões"
L["Quest Items"] = "Itens de missões"
L["QUIVER_TAG"] = "Qu"
L["Remove"] = "Remover"
L["Reset new items"] = "Reseta itens novos"
L["Reset position"] = "Reseta posição"
L["Right-click to configure."] = "Botão direito do mouse para configurar." -- Needs review
L["Right-click to move these items."] = "Botão direito do mouse para mover esses itens." -- Needs review
L["Right-click to sell these items."] = "Clique-direito de vender esses itens." -- Needs review
L["Right-click to try to empty this bag."] = "Clique com o botão direito para esvaziar esta bolsa"
L["Scale"] = "Escala"
L["Section"] = "Seção"
L["Section category"] = "Categoria da seção"
L["Section setup"] = "Configurações de seção"
L["Section visibility"] = "Visibilidade da seção"
L["Section visibility button"] = "Seção do botão de visibilidade"
L["Select how bag usage should be formatted in the plugin."] = "Seleciona como o uso de bolsas deve ser formatado no plugin"
L["Select how items should be sorted within each section."] = "Seleciona quantos itens devem ser arrumados em cada seção"
L["Select the category of the section to associate. This is used to group sections together."] = "Selecione a categoria da seção para unir. Isto é usado para agrupar seções"
L["Select the sections in which the items should be dispatched."] = "Selecione as seções para as quais os itens serão encaminhados"
L["Select which first-level categories should be split by sub-categories."] = "Seleciona qual categoria primária deve ser dividida em subcategorias"
L["Semi-automated tidy"] = "Arrumação semi-automatizada"
L["Separate incomplete stacks."] = "Separar pilhas incompletas"
L["Separate unstackable items."] = "Separar itens não empilháveis"
L["Sets"] = "Sets"
L["Set: %s"] = "Set: %s"
L["Show bag type icons"] = "Mostrar o ícone dos tipos de bolsas"
L["Show bag type tags"] = "Mostrar a aba dos tipos de bolsas"
L["Show bank usage"] = "Mostrar ocupação do banco"
L["Show container information..."] = "Mostrar informação da janela de saque"
L["Show every distinct item stacks."] = "Mostrar cada pilha diferente de itens"
L["Show filtering information..."] = "Mostrar informação de filtragem"
L["Show item information..."] = "Mostrar informação do item"
L["Show only one free slot for each kind of bags."] = "Mostre somente um espaço livre para cada tipo de bolsa"
L["Show only one slot of items that can be stacked."] = "Mostre somente um espaço com itens que podem ser empilhados"
L["Show only one slot of items that cannot be stacked."] = "Mostre somente um espaço de itens que não podem ser empilhados"
L["Show %s"] = "Mostra %s"
L["Slot number"] = "Número do slot"
L["Sorting order"] = "Ordem de arrumação"
L["SOUL_BAG_TAG"] = "So"
L["Space in use"] = "Espaço em uso"
L["Space in use / total space"] = "Espaço em uso / espaço total"
L["Split armors by types"] = "Separar armaduras por tipo"
L["Split by subcategories"] = "Divide em subcategorias"
L["Strictly keep ordering"] = "Manter estritamente ordenado"
L["TACKLE_BOX_TAG"] = "Fi"
L["This setting allows to tone down what some people calls \"section dancing\" when moving/selling/milling items."] = "Essa configuração permite que o tom baixo que algumas pessoas chama de \"dança seção\" quando se deslocam / venda / moagem itens." -- Needs review
L["Tidy bags"] = "Arruma bolsas"
L["Tidy your bags by clicking on the small \"T\" button at the top left of bags. Special bags with free slots will be filled with macthing items and stackable items will be stacked to save space."] = "Arrume suas bolsas clicando no pequeno botão \"T\" no topo esquerdo de suas bolsas. Bolsas especiais com espaços livres serão preenchidas com respectivos itens e itens empilháveis serão empilhados para liberar espaço"
L["Toggle and configure item filters."] = "Alterna e configura filtros de itens"
L["Toggle and configure plugins."] = "Alterna e configura plugins"
L["Tooltip information"] = "Dicas Informações"
L["Track new items"] = "Rastreia itens novos"
L["Track new items in each bag, displaying a glowing aura over them and putting them in a special section. \"New\" status can be reset by clicking on the small \"N\" button at top left of bags."] = "Rastreia itens novos em cada bolsa, mostrando uma aura brilhante sobre eles e colocando-os em uma seção especial. Status \"Novo\" pode ser apagado clicando no pequeno botão \"N\" no topo esquerdo de suas bolsas"
L["Uncheck this to disable AdiBags."] = "Desmarque para desabilitar AdiBags"
L["Unlock anchor"] = "Destrava âncora"
L["Use this section to define any item-section association."] = "Use esta seção para definir qualquer associação seção-item"
L["Use this to adjust the bag scale."] = "Use para ajustar a escala da bolsa"
L["Use this to adjust the quality-based border opacity. 100% means fully opaque."] = "Use para ajustar a opacidade da borda baseada na qualidade. 100% significa totalmente opaco"
L["Virtual stacks"] = "Emplilhamento virtual"
L["Virtual stacks display in one place items that actually spread over several bag slots."] = "Emplilhamentos virtuais mostram em um espaço itens que na verdade se espalhariam por vários espaços das bolsas"
L["Virtual stack slots"] = "Espaços de pilhas virtuais"
L["Warning: you are using an alpha or beta version of AdiBags without displaying Lua errors. If anything goes wrong, AdiBags (or any other addon causing some error) will simply stop working for apparently no reason. Please either enable the display of Lua errors or install an error handler addon like BugSack or Swatter."] = "Atenção: você está usando um alfa ou beta de AdiBags sem exibir erros de Lua. Se alguma coisa der errado, AdiBags (ou qualquer outro addon causando algum erro) vai simplesmente parar de trabalhar para aparentemente nenhuma razão. Por favor, habilite a exibição dos erros de Lua ou instalar um addon manipulador de erro como BugSack ou Swatter." -- Needs review
L["When alt is held down"] = "Quando ALT é pressionado"
L["When any modifier key is held down"] = "Quando qualquer tecla modificadora é Pressionada"
L["When ctrl is held down"] = "Quando CTRL é pressionado"
L["When shift is held down"] = "Quando SHIFT é pressionado"
end

-- @noloc]]

-- Replace remaining true values by their key
for k,v in pairs(L) do if v == true then L[k] = k end end
