class Looting_Config
{
	public var allow_stealing : bool;
	public var disable_guards_reaction : bool;
	public var scan_range : float;
	public var max_results : int;
	
	
	/*When this is enabled, depending on your scan range setting, items from owned containers will show up in the looting GUI. If there are guards around that container you will receive the standard theft warning even though you might be physically away from that container and guards might not be looking at you. If disabled, only items from containers from which is safe to take will appear in your looting GUI. Note that items from the container you directly activate will always show in your GUI regardless of this setting*/
	default allow_stealing = true;
	
	/*If this is enabled you are free to steal items everywhere without repercussions*/
	default disable_guards_reaction = false;
	
	/*Range in which to search for items*/
	default scan_range = 7.0f;
	
	/*Maximum number of containers that will be displayed. Note that each container can have many items. Don't raise too much*/
	default max_results = 10;
	
}