/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.relauncher;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.ObjectArrays;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.launcher.FMLTweaker;
import cpw.mods.fml.common.toposort.TopologicalSort;
import cpw.mods.fml.relauncher.FMLInjectionData;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import cpw.mods.fml.relauncher.IFMLCallHook;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.logging.Level;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class CoreModManager {
    private static final Attributes.Name COREMODCONTAINSFMLMOD = new Attributes.Name("FMLCorePluginContainsFMLMod");
    private static String[] rootPlugins = new String[]{"cpw.mods.fml.relauncher.FMLCorePlugin", "net.minecraftforge.classloading.FMLForgePlugin"};
    private static List<String> loadedCoremods = Lists.newArrayList();
    private static List<FMLPluginWrapper> loadPlugins;
    private static boolean deobfuscatedEnvironment;
    private static FMLTweaker tweaker;
    private static File mcDir;
    private static List<String> reparsedCoremods;
    private static Method ADDURL;

    public static void handleLaunch(File mcDir, LaunchClassLoader classLoader, FMLTweaker tweaker) {
        CoreModManager.mcDir = mcDir;
        CoreModManager.tweaker = tweaker;
        try {
            byte[] bs = classLoader.getClassBytes("net.minecraft.world.World");
            if (bs != null) {
                FMLRelaunchLog.info("Managed to load a deobfuscated Minecraft name- we are in a deobfuscated environment. Skipping runtime deobfuscation", new Object[0]);
                deobfuscatedEnvironment = true;
            }
        }
        catch (IOException e1) {
            // empty catch block
        }
        if (!deobfuscatedEnvironment) {
            FMLRelaunchLog.fine("Enabling runtime deobfuscation", new Object[0]);
        }
        try {
            classLoader.registerTransformer("cpw.mods.fml.common.asm.transformers.PatchingTransformer");
        }
        catch (Exception e) {
            FMLRelaunchLog.log(Level.SEVERE, e, "The patch transformer failed to load! This is critical, loading cannot continue!", new Object[0]);
            throw Throwables.propagate((Throwable)e);
        }
        loadPlugins = new ArrayList<FMLPluginWrapper>();
        for (String rootPluginName : rootPlugins) {
            CoreModManager.loadCoreMod(classLoader, rootPluginName, new File(FMLTweaker.getJarLocation()));
        }
        if (loadPlugins.isEmpty()) {
            throw new RuntimeException("A fatal error has occured - no valid fml load plugin was found - this is a completely corrupt FML installation.");
        }
        FMLRelaunchLog.fine("All fundamental core mods are successfully located", new Object[0]);
        String commandLineCoremods = System.getProperty("fml.coreMods.load", "");
        for (String coreModClassName : commandLineCoremods.split(",")) {
            if (coreModClassName.isEmpty()) continue;
            FMLRelaunchLog.info("Found a command line coremod : %s", coreModClassName);
            CoreModManager.loadCoreMod(classLoader, coreModClassName, null);
        }
        CoreModManager.discoverCoreMods(mcDir, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void discoverCoreMods(File mcDir, LaunchClassLoader classLoader) {
        FMLRelaunchLog.fine("Discovering coremods", new Object[0]);
        File coreMods = CoreModManager.setupCoreModDir(mcDir);
        FilenameFilter ff = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        };
        Object[] coreModList = coreMods.listFiles(ff);
        File versionedModDir = new File(coreMods, FMLInjectionData.mccversion);
        if (versionedModDir.isDirectory()) {
            Object[] versionedCoreMods = versionedModDir.listFiles(ff);
            coreModList = (File[])ObjectArrays.concat((Object[])coreModList, (Object[])versionedCoreMods, File.class);
        }
        Arrays.sort(coreModList);
        for (Object coreMod : coreModList) {
            Attributes mfAttributes;
            FMLRelaunchLog.fine("Examining for coremod candidacy %s", ((File)coreMod).getName());
            JarFile jar = null;
            try {
                jar = new JarFile((File)coreMod);
                if (jar.getManifest() == null) continue;
                mfAttributes = jar.getManifest().getMainAttributes();
            }
            catch (IOException ioe) {
                FMLRelaunchLog.log(Level.SEVERE, ioe, "Unable to read the jar file %s - ignoring", ((File)coreMod).getName());
                continue;
            }
            finally {
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException e) {}
                }
            }
            String cascadedTweaker = mfAttributes.getValue("TweakClass");
            if (cascadedTweaker != null) {
                FMLRelaunchLog.info("Loading tweaker %s from %s", cascadedTweaker, ((File)coreMod).getName());
                CoreModManager.handleCascadingTweak((File)coreMod, jar, cascadedTweaker, classLoader);
                loadedCoremods.add(((File)coreMod).getName());
                continue;
            }
            String fmlCorePlugin = mfAttributes.getValue("FMLCorePlugin");
            if (fmlCorePlugin == null) {
                FMLRelaunchLog.fine("Not found coremod data in %s", ((File)coreMod).getName());
                continue;
            }
            try {
                classLoader.addURL(((File)coreMod).toURI().toURL());
                if (!mfAttributes.containsKey(COREMODCONTAINSFMLMOD)) {
                    FMLRelaunchLog.finest("Adding %s to the list of known coremods, it will not be examined again", ((File)coreMod).getName());
                    loadedCoremods.add(((File)coreMod).getName());
                } else {
                    FMLRelaunchLog.finest("Found FMLCorePluginContainsFMLMod marker in %s, it will be examined later for regular @Mod instances", ((File)coreMod).getName());
                    reparsedCoremods.add(((File)coreMod).getName());
                }
            }
            catch (MalformedURLException e) {
                FMLRelaunchLog.log(Level.SEVERE, e, "Unable to convert file into a URL. weird", new Object[0]);
                continue;
            }
            CoreModManager.loadCoreMod(classLoader, fmlCorePlugin, (File)coreMod);
        }
    }

    private static void handleCascadingTweak(File coreMod, JarFile jar, String cascadedTweaker, LaunchClassLoader classLoader) {
        try {
            if (ADDURL == null) {
                ADDURL = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                ADDURL.setAccessible(true);
            }
            ADDURL.invoke((Object)classLoader.getClass().getClassLoader(), coreMod.toURI().toURL());
            classLoader.addURL(coreMod.toURI().toURL());
            tweaker.injectCascadingTweak(cascadedTweaker);
        }
        catch (Exception e) {
            FMLRelaunchLog.log(Level.INFO, e, "There was a problem trying to load the mod dir tweaker %s", coreMod.getAbsolutePath());
        }
    }

    private static File setupCoreModDir(File mcDir) {
        File coreModDir = new File(mcDir, "mods");
        try {
            coreModDir = coreModDir.getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unable to canonicalize the coremod dir at %s", mcDir.getName()), e);
        }
        if (!coreModDir.exists()) {
            coreModDir.mkdir();
        } else if (coreModDir.exists() && !coreModDir.isDirectory()) {
            throw new RuntimeException(String.format("Found a coremod file in %s that's not a directory", mcDir.getName()));
        }
        return coreModDir;
    }

    public static List<String> getLoadedCoremods() {
        return loadedCoremods;
    }

    public static List<String> getReparseableCoremods() {
        return reparsedCoremods;
    }

    private static FMLPluginWrapper loadCoreMod(LaunchClassLoader classLoader, String coreModClass, File location) {
        String coreModName = coreModClass.substring(coreModClass.lastIndexOf(46) + 1);
        try {
            FMLRelaunchLog.fine("Instantiating coremod class %s", coreModName);
            classLoader.addTransformerExclusion(coreModClass);
            Class<?> coreModClazz = Class.forName(coreModClass, true, (ClassLoader)classLoader);
            IFMLLoadingPlugin.Name coreModNameAnn = coreModClazz.getAnnotation(IFMLLoadingPlugin.Name.class);
            if (coreModNameAnn != null && !Strings.isNullOrEmpty((String)coreModNameAnn.value())) {
                coreModName = coreModNameAnn.value();
                FMLRelaunchLog.finest("coremod named %s is loading", coreModName);
            }
            IFMLLoadingPlugin.MCVersion requiredMCVersion = coreModClazz.getAnnotation(IFMLLoadingPlugin.MCVersion.class);
            if (!Arrays.asList(rootPlugins).contains(coreModClass) && (requiredMCVersion == null || Strings.isNullOrEmpty((String)requiredMCVersion.value()))) {
                FMLRelaunchLog.log(Level.WARNING, "The coremod %s does not have a MCVersion annotation, it may cause issues with this version of Minecraft", coreModClass);
            } else {
                if (requiredMCVersion != null && !FMLInjectionData.mccversion.equals(requiredMCVersion.value())) {
                    FMLRelaunchLog.log(Level.SEVERE, "The coremod %s is requesting minecraft version %s and minecraft is %s. It will be ignored.", coreModClass, requiredMCVersion.value(), FMLInjectionData.mccversion);
                    return null;
                }
                if (requiredMCVersion != null) {
                    FMLRelaunchLog.log(Level.FINE, "The coremod %s requested minecraft version %s and minecraft is %s. It will be loaded.", coreModClass, requiredMCVersion.value(), FMLInjectionData.mccversion);
                }
            }
            IFMLLoadingPlugin.TransformerExclusions trExclusions = coreModClazz.getAnnotation(IFMLLoadingPlugin.TransformerExclusions.class);
            if (trExclusions != null) {
                for (String st2 : trExclusions.value()) {
                    classLoader.addTransformerExclusion(st2);
                }
            }
            IFMLLoadingPlugin.DependsOn deplist = coreModClazz.getAnnotation(IFMLLoadingPlugin.DependsOn.class);
            String[] dependencies = new String[]{};
            if (deplist != null) {
                dependencies = deplist.value();
            }
            IFMLLoadingPlugin plugin = (IFMLLoadingPlugin)coreModClazz.newInstance();
            FMLPluginWrapper wrap = new FMLPluginWrapper(coreModName, plugin, location, dependencies);
            loadPlugins.add(wrap);
            FMLRelaunchLog.fine("Loaded coremod %s", coreModName);
            return wrap;
        }
        catch (ClassNotFoundException cnfe) {
            if (!Lists.newArrayList((Object[])rootPlugins).contains(coreModClass)) {
                FMLRelaunchLog.log(Level.SEVERE, cnfe, "Coremod %s: Unable to class load the plugin %s", coreModName, coreModClass);
            } else {
                FMLRelaunchLog.fine("Skipping root plugin %s", coreModClass);
            }
        }
        catch (ClassCastException cce) {
            FMLRelaunchLog.log(Level.SEVERE, cce, "Coremod %s: The plugin %s is not an implementor of IFMLLoadingPlugin", coreModName, coreModClass);
        }
        catch (InstantiationException ie) {
            FMLRelaunchLog.log(Level.SEVERE, ie, "Coremod %s: The plugin class %s was not instantiable", coreModName, coreModClass);
        }
        catch (IllegalAccessException iae) {
            FMLRelaunchLog.log(Level.SEVERE, iae, "Coremod %s: The plugin class %s was not accessible", coreModName, coreModClass);
        }
        return null;
    }

    private static void sortCoreMods() {
        TopologicalSort.DirectedGraph<FMLPluginWrapper> sortGraph = new TopologicalSort.DirectedGraph<FMLPluginWrapper>();
        HashMap pluginMap = Maps.newHashMap();
        for (FMLPluginWrapper plug : loadPlugins) {
            sortGraph.addNode(plug);
            pluginMap.put(plug.name, plug);
        }
        for (FMLPluginWrapper plug : loadPlugins) {
            for (String dep : plug.predepends) {
                if (!pluginMap.containsKey(dep)) {
                    FMLRelaunchLog.log(Level.SEVERE, "Missing coremod dependency - the coremod %s depends on coremod %s which isn't present.", plug.name, dep);
                    throw new RuntimeException();
                }
                sortGraph.addEdge(plug, (FMLPluginWrapper)pluginMap.get(dep));
            }
        }
        try {
            loadPlugins = TopologicalSort.topologicalSort(sortGraph);
            FMLRelaunchLog.fine("Sorted coremod list %s", loadPlugins);
        }
        catch (Exception e) {
            FMLLog.log(Level.SEVERE, e, "There was a problem performing the coremod sort", new Object[0]);
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static void injectTransformers(LaunchClassLoader classLoader) {
        for (FMLPluginWrapper wrap : loadPlugins) {
            IFMLLoadingPlugin plug = wrap.coreModInstance;
            if (plug.getASMTransformerClass() == null) continue;
            for (String xformClass : plug.getASMTransformerClass()) {
                FMLRelaunchLog.finest("Registering transformer %s", xformClass);
                classLoader.registerTransformer(xformClass);
            }
        }
        FMLRelaunchLog.fine("Running coremod plugins", new Object[0]);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("mcLocation", mcDir);
        data.put("coremodList", loadPlugins);
        data.put("runtimeDeobfuscationEnabled", !deobfuscatedEnvironment);
        for (FMLPluginWrapper pluginWrapper : loadPlugins) {
            IFMLLoadingPlugin plugin = pluginWrapper.coreModInstance;
            FMLRelaunchLog.fine("Running coremod plugin %s", pluginWrapper.name);
            data.put("coremodLocation", pluginWrapper.location);
            plugin.injectData(data);
            String setupClass = plugin.getSetupClass();
            if (setupClass != null) {
                try {
                    IFMLCallHook call = (IFMLCallHook)Class.forName(setupClass, true, (ClassLoader)classLoader).newInstance();
                    HashMap<String, Object> callData = new HashMap<String, Object>();
                    callData.put("mcLocation", mcDir);
                    callData.put("classLoader", classLoader);
                    callData.put("coremodLocation", pluginWrapper.location);
                    callData.put("deobfuscationFileName", FMLInjectionData.debfuscationDataName());
                    call.injectData(callData);
                    call.call();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            FMLRelaunchLog.fine("Coremod plugin %s run successfully", plugin.getClass().getSimpleName());
            String modContainer = plugin.getModContainerClass();
            if (modContainer == null) continue;
            FMLInjectionData.containers.add(modContainer);
        }
        Launch.blackboard.put("fml.deobfuscatedEnvironment", deobfuscatedEnvironment);
        tweaker.injectCascadingTweak("cpw.mods.fml.common.launcher.FMLDeobfTweaker");
    }

    static {
        reparsedCoremods = Lists.newArrayList();
    }

    private static class FMLPluginWrapper {
        public final String name;
        public final IFMLLoadingPlugin coreModInstance;
        public final List<String> predepends;
        public final File location;

        public FMLPluginWrapper(String name, IFMLLoadingPlugin coreModInstance, File location, String ... predepends) {
            this.name = name;
            this.coreModInstance = coreModInstance;
            this.location = location;
            this.predepends = Lists.newArrayList((Object[])predepends);
        }

        public String toString() {
            return String.format("%s {%s}", this.name, this.predepends);
        }
    }
}

