/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.discovery;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.MetadataCollection;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModContainerFactory;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.discovery.ITypeDiscoverer;
import cpw.mods.fml.common.discovery.ModCandidate;
import cpw.mods.fml.common.discovery.asm.ASMModParser;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;

public class DirectoryDiscoverer
implements ITypeDiscoverer {
    private ASMDataTable table;

    @Override
    public List<ModContainer> discover(ModCandidate candidate, ASMDataTable table) {
        this.table = table;
        ArrayList found = Lists.newArrayList();
        FMLLog.fine("Examining directory %s for potential mods", candidate.getModContainer().getName());
        this.exploreFileSystem("", candidate.getModContainer(), found, candidate, null);
        for (ModContainer mc : found) {
            table.addContainer(mc);
        }
        return found;
    }

    public void exploreFileSystem(String path, File modDir, List<ModContainer> harvestedMods, ModCandidate candidate, MetadataCollection mc) {
        if (path.length() == 0) {
            File metadata = new File(modDir, "mcmod.info");
            try {
                FileInputStream fis = new FileInputStream(metadata);
                mc = MetadataCollection.from(fis, modDir.getName());
                fis.close();
                FMLLog.fine("Found an mcmod.info file in directory %s", modDir.getName());
            }
            catch (Exception e) {
                mc = MetadataCollection.from(null, "");
                FMLLog.fine("No mcmod.info file found in directory %s", modDir.getName());
            }
        }
        Object[] content = modDir.listFiles(new ClassFilter());
        Arrays.sort(content);
        for (Object file : content) {
            if (((File)file).isDirectory()) {
                FMLLog.finest("Recursing into package %s", path + ((File)file).getName());
                this.exploreFileSystem(path + ((File)file).getName() + ".", (File)file, harvestedMods, candidate, mc);
                continue;
            }
            Matcher match = classFile.matcher(((File)file).getName());
            if (!match.matches()) continue;
            ASMModParser modParser = null;
            try {
                FileInputStream fis = new FileInputStream((File)file);
                modParser = new ASMModParser(fis);
                fis.close();
                candidate.addClassEntry(path + ((File)file).getName());
            }
            catch (LoaderException e) {
                FMLLog.log(Level.SEVERE, e, "There was a problem reading the file %s - probably this is a corrupt file", ((File)file).getPath());
                throw e;
            }
            catch (Exception e) {
                Throwables.propagate((Throwable)e);
            }
            modParser.validate();
            modParser.sendToTable(this.table, candidate);
            ModContainer container = ModContainerFactory.instance().build(modParser, candidate.getModContainer(), candidate);
            if (container == null) continue;
            harvestedMods.add(container);
            container.bindMetadata(mc);
        }
    }

    private class ClassFilter
    implements FileFilter {
        private ClassFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isFile() && ITypeDiscoverer.classFile.matcher(file.getName()).find() || file.isDirectory();
        }
    }
}

