/* SS_PrefsController */


@interface SS_PrefsController : NSObject <NSToolbarDelegate>
{
    NSWindow *prefsWindow;
    NSMutableDictionary *preferencePanes;
    NSMutableArray *panesOrder;

    NSString *bundleExtension;
    NSString *searchPath;
    
    NSToolbar *prefsToolbar;
    NSMutableDictionary *prefsToolbarItems;

    NSToolbarDisplayMode toolbarDisplayMode;
    NSToolbarSizeMode toolbarSizeMode;
    BOOL usesTexturedWindow;
    BOOL alwaysShowsToolbar;
    BOOL alwaysOpensCentered;
    
    BOOL debug;
}

@property (assign) BOOL alwaysOpensCentered;
@property (assign) BOOL alwaysShowsToolbar;
@property (assign) BOOL usesTexturedWindow;


// Shared instance
+ (id)sharedPreferences;

// Convenience constructors
+ (id)preferencesWithPanesSearchPath:(NSString*)path bundleExtension:(NSString *)ext;
+ (id)preferencesWithBundleExtension:(NSString *)ext;
+ (id)preferencesWithPanesSearchPath:(NSString*)path;
+ (id)preferences;

// Designated initializer
- (id)initWithPanesSearchPath:(NSString*)path bundleExtension:(NSString *)ext;

- (id)initWithBundleExtension:(NSString *)ext;
- (id)initWithPanesSearchPath:(NSString*)path;

- (void)showPreferencesWindow;
- (void)createPreferencesWindowAndDisplay:(BOOL)shouldDisplay;
- (void)createPreferencesWindow;
- (void)destroyPreferencesWindow;
- (BOOL)loadPrefsPaneWithID:(NSString *)paneID display:(BOOL)disp;
- (BOOL)loadPreferencePaneWithID:(NSString *)paneID;
- (void)activatePane:(NSString*)path;
- (void)setNewPanesOrder:(NSArray *)newPanesOrder;

- (void)debugLog:(NSString*)msg;

float ToolbarHeightForWindow(NSWindow *window);
- (void)createPrefsToolbar;
- (void)prefsToolbarItemClicked:(NSToolbarItem*)item;
- (BOOL)isVisible;
// Accessors
- (NSWindow *)preferencesWindow;
- (NSString *)bundleExtension;
- (NSString *)searchPath;

- (NSArray *)loadedPanes;

- (void)addPreferencePanes:(NSArray *)panes;

@end
