#import <Foundation/Foundation.h>

#import "BXWebsnippetFeedItem.h"


extern NSString * const BXWebsnippetFeedDidChangeNotification;


@interface BXWebsnippetFeed : NSObject
#if !__has_feature(objc_arc)
{
	NSURL *_feedURL;
	NSURL *_webURL;
	NSArray *_allItems;
	NSArray *_unreadItems;
	NSString *_returnURL;
	NSString *_returnButtonTitle;
}
#endif

- (instancetype)initWithIdentifier:(NSString *)identifier;

- (instancetype)initWithFeedURL:(NSURL *)feedURL webURL:(NSURL *)webURL;

@property (nonatomic, copy, readonly) NSURL *feedURL;
@property (nonatomic, copy, readonly) NSURL *webURL;

@property (nonatomic, copy, readonly) NSArray *allItems;
@property (nonatomic, copy, readonly) NSArray *unreadItems;

@property (nonatomic, copy) NSString *returnURL;
@property (nonatomic, copy) NSString *returnButtonTitle;

- (void)loadWithCompletionHandler:(void(^)(NSArray *unreadItems, NSError *error))completionHandler;

/**
 * Marks all feed items as read
 * Also clears unread items
 * Send BXWebsnippetFeedDidChangeNotification at the end
 */
- (void)markAsRead;

- (void)markAsUnread;

/**
 * Returns an URL usefull for opening in e. g. Safari
 * Contains return URL information if set
 * If there are unread news, the latest one is opened instead of the complete feed
 */
- (NSURL *)urlToOpenInBrowser;

@end
