/*

 Owner: Michael Ehrmann <michael@boinx.com>
 Company: Boinx Software Ltd., Germany
 Projects: BXNetworking

 Abstract: handles access to application specific default files on our webserver.

 */


// README:
//
// If the application bundle name differs from the name of the XML file for the online defaults,
// then the app delegate must implement the following method and return the filename of the XML
// file: - (NSString *)onlineDefaultsFilename;

NS_ASSUME_NONNULL_BEGIN

// Keys in Info.plist
extern NSString *const BXInternalVersionKey;

// Keys in OnlineDefaults XML files
extern NSString *const BXModificationDate;

// Keys for locale support
extern NSString *const BXAllLocalesKey;
extern NSString *const BXLocaleNameKey;

// Keys for URLs
extern NSString *const BXConnectURLKey;
extern NSString *const BXCrashLogURLKey;
extern NSString *const BXFaqURLKey;
extern NSString *const BXVersionHistoryKey;
extern NSString *const BXFeedbackURLKey;
extern NSString *const BXProductURLKey;
extern NSString *const BXDownloadURLKey;
extern NSString *const BXBoinxURLKey;
extern NSString *const BXBoinxBackstageURLKey;
extern NSString *const BXFTPServerKey;
extern NSString *const BXHelpPageURLKey;
extern NSString *const BXCoachingURLKey;
extern NSString *const BXChroniclesWebURLKey;
extern NSString *const BXChroniclesFeedURLKey;
extern NSString *const BXFacebookURLKey;
extern NSString *const BXTwitterURLKey;
extern NSString *const BXAppStoreXMLURLKey;
extern NSString *const BXBoinxForumURLKey;
extern NSString *const BXBetaDownloadURLKey;

extern NSString *const BXFastSpringURLKey;

// keys for Sparkle URLs
extern NSString * const SUAppcastFeedURLKey;
extern NSString * const SUAppcastBetaFeedURLKey;
extern NSString * const SUAppcastNightlyFeedURLKey;
extern NSString * const SUPlusAppcastFeedULRKey;

// License generation form urls
extern NSString *const BXGetDemoLicenseFormURLKey;
extern NSString *const BXGetFreeLicenseFormURLKey;
extern NSString *const BXRegisterLicenseFormURLKey;

// keys for Sales Assistant Data
extern NSString * const BXSalesDataServerURLKey;
extern NSString * const BXSalesDataFileNameKey;
extern NSString * const BXSalesDataFileExtensionKey;

// Keys for licensing URLs (toplevel - OLD!)
extern NSString *const BXDemoLicenseURLKey;
extern NSString *const BXBuyLicenseURLKey;
extern NSString *const BXUpgradeLicenseURLKey;

// Feedback Assistant
extern NSString * const BXFeedbackAssistantFormURL;

// Keys for licensting URL (locale specific)
extern NSString *const BXSalesConfigurationsKey;
// Subkeys
extern NSString *const BXSalesConfigLocalesKey;

extern NSString *const BXSalesConfigPartnerLogoURLKey;

// Keys for FastSpring sales (also with landing page at boinx.com)
extern NSString *const BXUpsale1to1RemoteCoaching;

// E-mail Addresses
extern NSString *const BXRegistrationFailureMail;
extern NSString * const BXFeedbackFailureMail;

// Keys for extended demo assistant
extern NSString * const BXExtendedDemoLongPeriodeKey;

// Keys for AppStore migration
extern NSString * const BXMigrateFromAppStore;

// URLs for wiki and connect
extern NSString *const BXWikiBaseURLKey;
extern NSString *const BXOnlineHelpBaseURLKey;
extern NSString *const BXConnectBaseURLKey;

@interface BXOnlineDefaults : NSObject {
    NSDictionary *_defaults;
	NSDictionary *_applicationDefaults;
	NSArray *_localeDefaults;	// holds NSDictonaries with localized versions of some keys
	NSURL *_connectionURL;
	NSOperationQueue *_downloadQueue;
	
	@private
		BOOL _online;
		BOOL _loaded;
		BOOL _inLibrary;
}

@property (retain, readonly) NSDictionary *defaults;

@property (assign, readonly, getter = isOnline) BOOL online;
@property (assign, readonly, getter = isLoaded) BOOL loaded;


#pragma mark -
#pragma mark class methods

@property (class, readonly) BXOnlineDefaults *sharedOnlineDefaults;

#pragma mark -
#pragma mark - handling locale

@property (readonly) NSString *currentUserLocale;

#pragma mark -
#pragma mark handling connection data

@property (readonly, nullable) NSString *connectedHost;

#pragma mark -
#pragma mark opening urls

- (void)openURLForKey:(NSString *)inKey;

#pragma mark -
#pragma mark accessing values

- (nullable id)objectForKey:(NSString *)inKey;
- (BOOL)boolForKey:(NSString *)inKey;
- (nullable NSURL *)URLForKey:(NSString *)inKey;

#pragma mark -
#pragma mark Menu Item

- (nullable NSMenuItem *)menuItemForURLKey:(NSString *)inKey;
- (nullable NSMenuItem *)menuItemForKey:(NSString *)inKey action:(SEL)inSelector;
- (IBAction)openURLForMenuItem:(id)inSender;

#pragma mark -
#pragma mark accessing locale values

// what is this for? Old sales data?
- (nullable NSURL *)localeURLForKey:(id)inKey;
- (nullable NSDictionary *)defaultsForLocale:(NSString *)inLocale;

// new locale support
- (nullable id)objectForKey:(NSString *)inKey ofLocale:(NSString *)inLocaleName;
- (nullable id)objectForKeyOfCurrentLocale:(NSString *)inKey;

- (BOOL)boolForKey:(NSString *)inKey ofLocale:(NSString *)inLocaleName;
- (BOOL)boolForKeyOfCurrentLocale:(NSString *)inKey;

- (nullable NSURL *)URLForKey:(NSString *)inKey ofLocale:(NSString *)inLocaleName;
- (nullable NSURL *)URLForKeyOfCurrentLocale:(NSString *)inKey;

@end

NS_ASSUME_NONNULL_END
