//**********************************************************************************************************************
//
//  BXFileLock.h
//
//  Author:		Peter Baumgartner, peter@baumgartner.com
//  Copyright:	©2015 by IMAGINE GbR. All rights reserved.
//	Abstract:	NSLock for access to a file
//
//**********************************************************************************************************************


@interface BXFileLock : NSObject

+ (instancetype) fileLockWithURL:(NSURL*)inURL;
+ (instancetype) fileLockWithPath:(NSString*)inPath;

- (instancetype) initWithURL:(NSURL*)inURL;
- (instancetype) initWithPath:(NSString*)inPath;

- (void) lock;
- (void) unlock;
- (BOOL) tryLock;

@end


//----------------------------------------------------------------------------------------------------------------------
