//
//  NSApplication_Relaunch.h
//  BXAppKit
//
//  Created by Florian Albrecht on 31.07.06.
//  Copyright 2006 Boinx Software. All rights reserved.
//

#import <Cocoa/Cocoa.h>

extern NSString * const BXWipePreferences;

@interface NSApplication (BXRelaunch)

/*!
    @method     relaunch
    @abstract	will restart the current application via shell after terminating it 
    @discussion watches for the PID to go away before starting the app given the path 
*/
- (void) relaunch;


/*!
    @method     relaunchUsingLocalization:
    @abstract	will restart the current application via shell after terminating it 
    @discussion watches for the PID to go away before starting the app given the path 
    @argument	sender	call this from a menu item that contains the Language name as title
 */
- (void) relaunchUsingLocalization:(id)sender;
- (void) removeLocalizationPreference:(id)sender;


/*!
	@method     relaunchUsingLocalization:
	@abstract	will restart the current application via shell after terminating it 
	@discussion watches for the PID to go away before starting the app given the path 
	@argument	sender	call this from a menu item that contains the Locale (eg. de_DE) name as title
*/
- (void) relaunchUsingLocale:(id)inSender;
- (void) removeLocalePreference:(id)inSender;

/*!
	@method     prepareWipingPreferencesAndRelaunch:
	@abstract	will set a key in the preferences and restart the current application via shell after terminating it
	@discussion the purpose of this method is to store a flag in the user default preferences which will be tested in the wipePreferencesIfNecesarry. This method should be called in applicationWillTerminate notification so that this is the last thing that will work with the user defaults.
	@argument	sender
 */
- (void) prepareWipingPreferencesAndRelaunch:(id)inSender;
/*!
	@method     wipePreferencesIfNecessaryAndPerformBlock
	@abstract	checks a local bool and wipe the preferences
	@discussion the purpose of this method is to wipe the user defaults. Call this method in applicationWillTerminate.
	@argument	sender
 */
- (void)wipePreferencesIfNecessaryAndPerformBlock:(void(^)(void))block;

@end
