//**********************************************************************************************************************
//
//  BXDisclosureView.h
//
//  Author:		Peter Baumgartner, peter@baumgartner.com
//  Copyright:	©2004-2011 by IMAGINE GbR. All rights reserved.
//	Abstract:	View class that can be collapsed and expanded
//
//**********************************************************************************************************************


@interface BXDisclosureView : NSView
{
    // Outlets...
    
    IBOutlet BXDisclosureView* _parentView;
    IBOutlet BXDisclosureView* _firstChildView;
    IBOutlet BXDisclosureView* _lastChildView;
    IBOutlet BXDisclosureView* _nextSiblingView;
    IBOutlet NSButton* _button;
    IBOutlet NSView* _contentView;
    IBOutlet id _delegate;
    
    // Data fields...
    
    CGFloat _minHeight;
    CGFloat _maxHeight;
    CGFloat _header;
    CGFloat _footer;
    BOOL _animatesView;
    BOOL _animatesWindow;
    BOOL _expanded;
    
    BOOL _flipped;
    BOOL _setFrameAnimated;
    
    // Bindings...
    
    NSMutableDictionary* _bindingInfo;
}

// Config...

- (void) addChildView:(BXDisclosureView*)inView;
- (void) removeAllChildViews;

- (BXDisclosureView*) firstChildView;
- (BXDisclosureView*) lastChildView;

@property (assign) BXDisclosureView* parentView;
@property (assign) BXDisclosureView* nextSiblingView;
@property (readonly) BXDisclosureView* rootView;
@property (assign) NSButton* button;
@property (assign) NSView* contentView;
@property (assign,getter=isFlipped) BOOL flipped;

@property (assign) id delegate;

// Accessors...

@property CGFloat minHeight;
@property CGFloat maxHeight;
@property CGFloat header;
@property CGFloat footer;
@property BOOL animatesView;
@property BOOL animatesWindow;
@property BOOL expanded;

- (BOOL) isRootView;
- (CGFloat) width;
- (CGFloat) height;
- (CGFloat) heightOfChildren;

// Deprecated Accessors...

//@property BOOL resizesWindow; 

#pragma mark 

// Update layout...

- (void) setNeedsUpdate:(BOOL)inNeedsUpdate animate:(BOOL)inAnimate;
- (void) update;

#pragma mark 

// Actions...

- (IBAction) setState:(id)inSender;
- (IBAction) collapse:(id)inSender;
- (IBAction) expand:(id)inSender;
- (IBAction) toggle:(id)inSender;

@end


//----------------------------------------------------------------------------------------------------------------------


#pragma mark 

@interface BXDisclosureContainerView : BXDisclosureView

@end


//----------------------------------------------------------------------------------------------------------------------


#pragma mark 

@protocol BXDisclosureViewDelegate
@optional
- (void) disclosureViewStateWillChange:(BXDisclosureView*)inView;
- (void) disclosureViewStateDidChange:(BXDisclosureView*)inView;
- (void) disclosureViewFrameDidChange:(BXDisclosureView*)inView;
- (void) disclosureViewFinishedAnimation:(BXDisclosureView*)inView;
@end


//----------------------------------------------------------------------------------------------------------------------
