//**********************************************************************************************************************
//
//  BXCachedDrawing.h
//
//  Author:		Peter Baumgartner, peter@baumgartner.com
//  Copyright:	©2008-2011 by IMAGINE GbR. All rights reserved.
//	Abstract:	Common helper functions for cached drawing
//
//**********************************************************************************************************************


#if defined(__cplusplus)	
extern "C" {
#endif


//----------------------------------------------------------------------------------------------------------------------


// These methods help to optimize complex drawRect methods. Simply provide a uninitialized CGLayerRef 
// (set to NULL) and bracket the drawing code with the following lines:
//
//		if (BXBeginCachedDrawing(&layer,rect)
//		{
//			// Do some expensive drawing here...
//
//			BXEndCachedDrawing();
//		}
//
//		BXBlitCachedDrawing(layer,rect);
//
// The drawing code will only be performed once, and at BXEndCachedDrawing we have a fully built CGLayerRef. 
// The second time through, BXBeginCachedDrawing will just NO, thus skipping the drawing code, and then
// BXBlitCachedDrawing copies the layer contents to the specified rect...


BOOL BXBeginCachedDrawing(CGLayerRef *ioLayer,NSRect inRect);
void BXEndCachedDrawing(void);
void BXBlitCachedDrawing(CGLayerRef ioLayer,NSRect inRect);

// The following method releases the layer, and thus causes everything to be drawn from scratch...

void BXInvalidateCachedDrawing(CGLayerRef *ioLayer);


// This helper method forces the supplied rect to the closest full pixels (regardless of user scale factor), 
// always extending outwards...

NSRect BXIntegralRect(NSView *inView,NSRect inRect);


//----------------------------------------------------------------------------------------------------------------------


#if defined(__cplusplus)
}
#endif

	
//----------------------------------------------------------------------------------------------------------------------
