/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.JFrame;
import net.minecraft.client.Minecraft;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.ARBVertexProgram;
import org.lwjgl.opengl.ARBVertexShader;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.glu.GLU;

public class Shaders {
    public static boolean isInitialized = false;
    private static int renderWidth = 0;
    private static int renderHeight = 0;
    private static Minecraft mc = null;
    private static float[] sunPosition = new float[3];
    private static float[] moonPosition = new float[3];
    private static float[] clearColor = new float[3];
    private static long lastWorldTime = 0L;
    private static long diffWorldTime = 0L;
    private static float rainStrength = 0.0f;
    private static float wetness = 0.0f;
    public static float wetnessHalfLife = 1200.0f;
    public static float drynessHalfLife = 400.0f;
    private static boolean usewetness = false;
    private static boolean lightmapEnabled = false;
    private static boolean fogEnabled = true;
    public static int entityAttrib = -1;
    private static FloatBuffer previousProjection = BufferUtils.createFloatBuffer((int)16);
    private static FloatBuffer projection = BufferUtils.createFloatBuffer((int)16);
    private static FloatBuffer projectionInverse = null;
    private static FloatBuffer previousModelView = null;
    private static FloatBuffer modelView = null;
    private static FloatBuffer modelViewInverse = null;
    private static double[] previousCameraPosition = new double[3];
    private static double[] cameraPosition = new double[3];
    private static int shadowPassInterval = 0;
    private static int shadowMapWidth = 1024;
    private static int shadowMapHeight = 1024;
    private static float shadowMapFOV = 25.0f;
    private static float shadowMapHalfPlane = 30.0f;
    private static boolean shadowMapIsOrtho = true;
    private static int shadowPassCounter = 0;
    private static int preShadowPassThirdPersonView;
    public static boolean isShadowPass;
    private static int sfb;
    private static int sfbColorTexture;
    private static int sfbDepthTexture;
    private static int sfbRenderBuffer;
    private static int sfbDepthBuffer;
    private static FloatBuffer shadowProjection;
    private static FloatBuffer shadowProjectionInverse;
    private static FloatBuffer shadowModelView;
    private static FloatBuffer shadowModelViewInverse;
    private static int colorAttachments;
    private static IntBuffer dfbDrawBuffers;
    private static IntBuffer dfbTextures;
    private static IntBuffer dfbRenderBuffers;
    private static int dfb;
    private static int dfbDepthBuffer;
    public static int activeProgram;
    public static final int ProgramNone = 0;
    public static final int ProgramBasic = 1;
    public static final int ProgramTextured = 2;
    public static final int ProgramTexturedLit = 3;
    public static final int ProgramTerrain = 4;
    public static final int ProgramEntities = 5;
    public static final int ProgramWater = 6;
    public static final int ProgramHand = 7;
    public static final int ProgramWeather = 8;
    public static final int ProgramComposite = 9;
    public static final int ProgramFinal = 10;
    public static final int ProgramCount = 11;
    private static String[] programNames;
    private static int[] programBackups;
    private static int[] programs;
    public static bba renderEngine;
    public static HashMap textureIdMap;
    public static HashMap textureIdByNameMap;
    public static HashMap defaultTextureImageMap;
    public static BufferedImage defaultTextureImage_d;
    public static BufferedImage defaultTextureImage_n;
    public static BufferedImage defaultTextureImage_s;
    public static int[] defaultTextureIdArray;
    public static boolean normalMapEnabled;
    public static final int version = 1010104;
    static final String ofVersion = "OptiFine_1.4.6_HD_U_A2";
    public static boolean dtweak;
    static String currentshadername;
    static File shadersdir;
    static int lastversion;
    static int updateinterval;
    public static final String siteurl = "http://glslshadersof.no-ip.org";
    public static final String updatecheckurl = "http:....../lastversion145.html";
    static JFrame frame;

    private Shaders() {
    }

    public static void init() {
        if (!isInitialized) {
            int i2;
            ContextCapabilities capabilities = GLContext.getCapabilities();
            System.out.println("[Shaders] OpenGL 2.0 = " + capabilities.OpenGL20 + "    OpenGL 2.1 = " + capabilities.OpenGL21);
            if (!capabilities.OpenGL20) {
                System.out.println("[Shaders] Your GPU is not compatible with the Shaders mod.");
                System.exit(-1);
            }
            int maxDrawBuffers = GL11.glGetInteger((int)34852);
            System.out.println("[Shaders] GL_MAX_DRAW_BUFFERS = " + maxDrawBuffers + "    GL_MAX_TEXTURE_IMAGE_UNITS = " + GL11.glGetInteger((int)34930));
            colorAttachments = 4;
            for (i2 = 0; i2 < 11; ++i2) {
                Shaders.programs[i2] = programNames[i2] == "" ? 0 : Shaders.setupProgram("shaders/" + programNames[i2] + ".vsh", "shaders/" + programNames[i2] + ".fsh");
            }
            if (colorAttachments > maxDrawBuffers) {
                System.out.println("[Shaders] Require " + colorAttachments + " draw buffers.");
                System.out.println("[Shaders] Not enough draw buffers!");
            }
            for (i2 = 0; i2 < 11; ++i2) {
                int n2 = i2;
                while (programs[i2] == 0 && n2 != programBackups[n2]) {
                    Shaders.programs[i2] = programs[programBackups[n2]];
                    n2 = programBackups[n2];
                }
            }
            dfbDrawBuffers = BufferUtils.createIntBuffer((int)colorAttachments);
            for (i2 = 0; i2 < colorAttachments; ++i2) {
                dfbDrawBuffers.put(i2, 36064 + i2);
            }
            dfbTextures = BufferUtils.createIntBuffer((int)colorAttachments);
            dfbRenderBuffers = BufferUtils.createIntBuffer((int)colorAttachments);
            Shaders.resize();
            Shaders.setupShadowMap();
            isInitialized = true;
        }
    }

    public static void destroy() {
        for (int i2 = 0; i2 < 11; ++i2) {
            if (programs[i2] == 0) continue;
            ARBShaderObjects.glDeleteObjectARB((int)programs[i2]);
            Shaders.programs[i2] = 0;
        }
    }

    public static void setRenderEngine(bba var1) {
        if (renderEngine != null) {
            System.out.println("Shaders: Multiple RenderEngine!");
        }
        renderEngine = var1;
        defaultTextureImage_d = new BufferedImage(1, 1, 2);
        defaultTextureImage_d.setRGB(0, 0, -8355712);
        defaultTextureImage_n = new BufferedImage(1, 1, 2);
        defaultTextureImage_n.setRGB(0, 0, -8421378);
        defaultTextureImage_s = new BufferedImage(1, 1, 2);
        defaultTextureImage_s.setRGB(0, 0, -16777216);
        defaultTextureIdArray = new int[3];
        Shaders.defaultTextureIdArray[0] = renderEngine.a(defaultTextureImage_d);
        Shaders.defaultTextureIdArray[1] = renderEngine.a(defaultTextureImage_n);
        Shaders.defaultTextureIdArray[2] = renderEngine.a(defaultTextureImage_s);
        textureIdMap.put(-1, defaultTextureIdArray);
        textureIdMap.put(0, textureIdMap.get(renderEngine.b("/terrain.png")));
        Shaders.checkOptifine();
    }

    public static void bindTextures(int textureId) {
        int[] idArray = (int[])textureIdMap.get(textureId);
        if (idArray != null) {
            GL13.glActiveTexture((int)33986);
            GL11.glBindTexture((int)3553, (int)idArray[1]);
            GL13.glActiveTexture((int)33987);
            GL11.glBindTexture((int)3553, (int)idArray[2]);
            GL13.glActiveTexture((int)33984);
            GL11.glBindTexture((int)3553, (int)idArray[0]);
        } else {
            GL13.glActiveTexture((int)33986);
            GL11.glBindTexture((int)3553, (int)defaultTextureIdArray[1]);
            GL13.glActiveTexture((int)33987);
            GL11.glBindTexture((int)3553, (int)defaultTextureIdArray[2]);
            GL13.glActiveTexture((int)33984);
            GL11.glBindTexture((int)3553, (int)textureId);
        }
    }

    public static void glEnableWrapper(int cap) {
        GL11.glEnable((int)cap);
        if (cap == 3553) {
            if (activeProgram == 1) {
                Shaders.useProgram(lightmapEnabled ? 3 : 2);
            }
        } else if (cap == 2912) {
            fogEnabled = true;
            Shaders.setProgramUniform1i("fogMode", GL11.glGetInteger((int)2917));
        }
    }

    public static void glDisableWrapper(int cap) {
        GL11.glDisable((int)cap);
        if (cap == 3553) {
            if (activeProgram == 2 || activeProgram == 3) {
                Shaders.useProgram(1);
            }
        } else if (cap == 2912) {
            fogEnabled = false;
            Shaders.setProgramUniform1i("fogMode", 0);
        }
    }

    public static void sglEnableT2D(int cap) {
        GL11.glEnable((int)cap);
        if (activeProgram == 1) {
            Shaders.useProgram(lightmapEnabled ? 3 : 2);
        }
    }

    public static void sglDisableT2D(int cap) {
        GL11.glDisable((int)cap);
        if (activeProgram == 2 || activeProgram == 3) {
            Shaders.useProgram(1);
        }
    }

    public static void sglEnableFog(int cap) {
        GL11.glEnable((int)cap);
        fogEnabled = true;
        Shaders.setProgramUniform1i("fogMode", GL11.glGetInteger((int)2917));
    }

    public static void sglDisableFog(int cap) {
        GL11.glDisable((int)cap);
        fogEnabled = false;
        Shaders.setProgramUniform1i("fogMode", 0);
    }

    public static void enableLightmap() {
        lightmapEnabled = true;
        if (activeProgram == 2) {
            Shaders.useProgram(3);
        }
    }

    public static void disableLightmap() {
        lightmapEnabled = false;
        if (activeProgram == 3) {
            Shaders.useProgram(2);
        }
    }

    public static void setClearColor(float red, float green, float blue) {
        Shaders.clearColor[0] = red;
        Shaders.clearColor[1] = green;
        Shaders.clearColor[2] = blue;
        if (isShadowPass) {
            GL11.glClearColor((float)clearColor[0], (float)clearColor[1], (float)clearColor[2], (float)1.0f);
            GL11.glClear((int)16640);
            return;
        }
        GL20.glDrawBuffers((IntBuffer)dfbDrawBuffers);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClear((int)16640);
        GL20.glDrawBuffers((int)36064);
        GL11.glClearColor((float)clearColor[0], (float)clearColor[1], (float)clearColor[2], (float)1.0f);
        GL11.glClear((int)16640);
        GL20.glDrawBuffers((int)36065);
        GL11.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glClear((int)16640);
        GL20.glDrawBuffers((IntBuffer)dfbDrawBuffers);
    }

    public static void setCamera(float f2) {
        md viewEntity = Shaders.mc.h;
        double x2 = viewEntity.T + (viewEntity.t - viewEntity.T) * (double)f2;
        double y2 = viewEntity.U + (viewEntity.u - viewEntity.U) * (double)f2;
        double z2 = viewEntity.V + (viewEntity.v - viewEntity.V) * (double)f2;
        if (isShadowPass) {
            GL11.glViewport((int)0, (int)0, (int)shadowMapWidth, (int)shadowMapHeight);
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            if (shadowMapIsOrtho) {
                GL11.glOrtho((double)(-shadowMapHalfPlane), (double)shadowMapHalfPlane, (double)(-shadowMapHalfPlane), (double)shadowMapHalfPlane, (double)0.05f, (double)256.0);
            } else {
                GLU.gluPerspective((float)shadowMapFOV, (float)((float)shadowMapWidth / (float)shadowMapHeight), (float)0.05f, (float)256.0f);
            }
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-100.0f);
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            float angle = -Shaders.mc.e.c(f2) * 360.0f;
            if ((double)angle < -90.0 && (double)angle > -270.0) {
                GL11.glRotatef((float)(angle + 180.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            } else {
                GL11.glRotatef((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (shadowMapIsOrtho) {
                GL11.glTranslatef((float)((float)x2 % 10.0f - 5.0f), (float)((float)y2 % 10.0f - 5.0f), (float)((float)z2 % 10.0f - 5.0f));
            }
            shadowProjection = BufferUtils.createFloatBuffer((int)16);
            GL11.glGetFloat((int)2983, (FloatBuffer)shadowProjection);
            shadowProjectionInverse = Shaders.invertMat4x(shadowProjection);
            shadowModelView = BufferUtils.createFloatBuffer((int)16);
            GL11.glGetFloat((int)2982, (FloatBuffer)shadowModelView);
            shadowModelViewInverse = Shaders.invertMat4x(shadowModelView);
            return;
        }
        FloatBuffer newprojection = previousProjection;
        newprojection.clear();
        previousProjection = projection;
        projection = newprojection;
        GL11.glGetFloat((int)2983, (FloatBuffer)projection);
        projectionInverse = Shaders.invertMat4x(projection);
        previousModelView = modelView;
        modelView = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloat((int)2982, (FloatBuffer)modelView);
        modelViewInverse = Shaders.invertMat4x(modelView);
        Shaders.previousCameraPosition[0] = cameraPosition[0];
        Shaders.previousCameraPosition[1] = cameraPosition[1];
        Shaders.previousCameraPosition[2] = cameraPosition[2];
        Shaders.cameraPosition[0] = x2;
        Shaders.cameraPosition[1] = y2;
        Shaders.cameraPosition[2] = z2;
    }

    static void enableVertexEnt(baz tess) {
        if (entityAttrib >= 0) {
            ARBVertexProgram.glEnableVertexAttribArrayARB((int)entityAttrib);
            ARBVertexProgram.glVertexAttribPointerARB((int)entityAttrib, (int)2, (boolean)false, (boolean)false, (int)4, (ShortBuffer)((ShortBuffer)tess.shadersShortBuffer.position(0)));
        }
    }

    static void disableVertexEnt() {
        if (entityAttrib >= 0) {
            ARBVertexProgram.glDisableVertexAttribArrayARB((int)entityAttrib);
        }
    }

    public static void beginRender(Minecraft minecraft, float f2, long l2) {
        if (isShadowPass) {
            return;
        }
        mc = minecraft;
        long time = Shaders.mc.e.G();
        diffWorldTime = (time - lastWorldTime) % 24000L;
        if (diffWorldTime < 0L) {
            diffWorldTime += 24000L;
        }
        lastWorldTime = time;
        rainStrength = minecraft.e.j(f2);
        float temp1 = (float)Math.exp(Math.log(0.5) * (double)diffWorldTime / (double)(wetness < rainStrength ? drynessHalfLife : wetnessHalfLife));
        wetness = wetness * temp1 + rainStrength * (1.0f - temp1);
        if (!isInitialized) {
            Shaders.init();
        }
        if (Shaders.mc.c != renderWidth || Shaders.mc.d != renderHeight) {
            Shaders.resize();
        }
        if (shadowPassInterval > 0 && --shadowPassCounter <= 0) {
            preShadowPassThirdPersonView = Shaders.mc.y.W;
            Shaders.mc.y.W = 1;
            isShadowPass = true;
            shadowPassCounter = shadowPassInterval;
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)sfb);
            Shaders.useProgram(0);
            Shaders.mc.t.a(f2, l2);
            GL11.glFlush();
            isShadowPass = false;
            Shaders.mc.y.W = preShadowPassThirdPersonView;
        }
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)dfb);
        Shaders.useProgram(lightmapEnabled ? 3 : 2);
    }

    public static void endRender() {
        if (isShadowPass) {
            return;
        }
        Shaders.checkGLError("pre endRender");
        GL11.glPushMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)0.0, (double)1.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        Shaders.checkGLError("endRender pre-ProgramComposite");
        Shaders.useProgram(9);
        Shaders.checkGLError("ProgramComposite");
        GL20.glDrawBuffers((IntBuffer)dfbDrawBuffers);
        GL11.glBindTexture((int)3553, (int)dfbTextures.get(0));
        GL13.glActiveTexture((int)33985);
        GL11.glBindTexture((int)3553, (int)dfbTextures.get(1));
        GL13.glActiveTexture((int)33986);
        GL11.glBindTexture((int)3553, (int)dfbTextures.get(2));
        GL13.glActiveTexture((int)33987);
        GL11.glBindTexture((int)3553, (int)dfbTextures.get(3));
        if (shadowPassInterval > 0) {
            GL13.glActiveTexture((int)33988);
            GL11.glBindTexture((int)3553, (int)sfbDepthTexture);
        }
        if (colorAttachments >= 5) {
            GL13.glActiveTexture((int)33989);
            GL11.glBindTexture((int)3553, (int)dfbTextures.get(4));
            if (colorAttachments >= 6) {
                GL13.glActiveTexture((int)33990);
                GL11.glBindTexture((int)3553, (int)dfbTextures.get(5));
                if (colorAttachments >= 7) {
                    GL13.glActiveTexture((int)33991);
                    GL11.glBindTexture((int)3553, (int)dfbTextures.get(6));
                    if (colorAttachments >= 8) {
                        GL13.glActiveTexture((int)33992);
                        GL11.glBindTexture((int)3553, (int)dfbTextures.get(8));
                    }
                }
            }
        }
        GL13.glActiveTexture((int)33984);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glEnd();
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
        Shaders.checkGLError("endRender pre-ProgramFinal");
        Shaders.useProgram(10);
        Shaders.checkGLError("ProgramFinal");
        GL11.glClearColor((float)clearColor[0], (float)clearColor[1], (float)clearColor[2], (float)1.0f);
        GL11.glClear((int)16640);
        GL11.glBindTexture((int)3553, (int)dfbTextures.get(0));
        GL13.glActiveTexture((int)33985);
        GL11.glBindTexture((int)3553, (int)dfbTextures.get(1));
        GL13.glActiveTexture((int)33986);
        GL11.glBindTexture((int)3553, (int)dfbTextures.get(2));
        GL13.glActiveTexture((int)33987);
        GL11.glBindTexture((int)3553, (int)dfbTextures.get(3));
        if (shadowPassInterval > 0) {
            GL13.glActiveTexture((int)33988);
            GL11.glBindTexture((int)3553, (int)sfbDepthTexture);
        }
        if (colorAttachments >= 5) {
            GL13.glActiveTexture((int)33989);
            GL11.glBindTexture((int)3553, (int)dfbTextures.get(4));
            if (colorAttachments >= 6) {
                GL13.glActiveTexture((int)33990);
                GL11.glBindTexture((int)3553, (int)dfbTextures.get(5));
                if (colorAttachments >= 7) {
                    GL13.glActiveTexture((int)33991);
                    GL11.glBindTexture((int)3553, (int)dfbTextures.get(6));
                    if (colorAttachments >= 8) {
                        GL13.glActiveTexture((int)33992);
                        GL11.glBindTexture((int)3553, (int)dfbTextures.get(7));
                    }
                }
            }
        }
        GL13.glActiveTexture((int)33984);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glEnd();
        GL11.glEnable((int)3042);
        GL11.glPopMatrix();
        Shaders.useProgram(0);
        Shaders.checkGLError("endRender end");
    }

    public static void checkGLError(String location) {
        int errorCode = GL11.glGetError();
        if (errorCode != 0) {
            System.out.println("GL Error " + errorCode + ": " + GLU.gluErrorString((int)errorCode) + " @" + location);
        }
    }

    public static void beginTerrain() {
        Shaders.useProgram(4);
        GL11.glBindTexture((int)3553, (int)renderEngine.b("/terrain.png"));
    }

    public static void endTerrain() {
        Shaders.useProgram(lightmapEnabled ? 3 : 2);
    }

    public static void beginEntities() {
        Shaders.useProgram(5);
        GL11.glBindTexture((int)3553, (int)renderEngine.b("/terrain.png"));
    }

    public static void endEntities() {
        Shaders.useProgram(lightmapEnabled ? 3 : 2);
    }

    public static void beginWater() {
        Shaders.useProgram(6);
        GL11.glBindTexture((int)3553, (int)renderEngine.b("/terrain.png"));
    }

    public static void endWater() {
        Shaders.useProgram(lightmapEnabled ? 3 : 2);
    }

    public static void beginHand() {
        Shaders.useProgram(7);
    }

    public static void endHand() {
        GL11.glDisable((int)3042);
        Shaders.useProgram(lightmapEnabled ? 3 : 2);
        if (isShadowPass) {
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)sfb);
        }
    }

    public static void beginWeather() {
        GL11.glEnable((int)3042);
        Shaders.useProgram(8);
        if (isShadowPass) {
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
        }
    }

    public static void endWeather() {
        GL11.glDisable((int)3042);
        Shaders.useProgram(lightmapEnabled ? 3 : 2);
    }

    private static void resize() {
        renderWidth = Shaders.mc.c;
        renderHeight = Shaders.mc.d;
        Shaders.setupFrameBuffer();
    }

    private static void setupShadowMap() {
        Shaders.setupShadowFrameBuffer();
    }

    private static int setupProgram(String vShaderPath, String fShaderPath) {
        int program = ARBShaderObjects.glCreateProgramObjectARB();
        int vShader = 0;
        int fShader = 0;
        if (program != 0) {
            vShader = Shaders.createVertShader(vShaderPath);
            fShader = Shaders.createFragShader(fShaderPath);
        }
        if (vShader != 0 || fShader != 0) {
            if (vShader != 0) {
                ARBShaderObjects.glAttachObjectARB((int)program, (int)vShader);
            }
            if (fShader != 0) {
                ARBShaderObjects.glAttachObjectARB((int)program, (int)fShader);
            }
            if (entityAttrib >= 0) {
                ARBVertexShader.glBindAttribLocationARB((int)program, (int)entityAttrib, (CharSequence)"mc_Entity");
            }
            ARBShaderObjects.glLinkProgramARB((int)program);
            ARBShaderObjects.glValidateProgramARB((int)program);
            Shaders.printLogInfo(program, vShaderPath + "," + fShaderPath);
        } else if (program != 0) {
            ARBShaderObjects.glDeleteObjectARB((int)program);
            program = 0;
        }
        return program;
    }

    public static void useProgram(int program) {
        if (activeProgram == program) {
            return;
        }
        if (isShadowPass) {
            activeProgram = 0;
            ARBShaderObjects.glUseProgramObjectARB((int)programs[0]);
            normalMapEnabled = false;
            return;
        }
        activeProgram = program;
        ARBShaderObjects.glUseProgramObjectARB((int)programs[program]);
        if (programs[program] == 0) {
            normalMapEnabled = false;
            return;
        }
        switch (program) {
            case 2: {
                normalMapEnabled = false;
                Shaders.setProgramUniform1i("texture", 0);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                normalMapEnabled = true;
                Shaders.setProgramUniform1i("texture", 0);
                Shaders.setProgramUniform1i("lightmap", 1);
                Shaders.setProgramUniform1i("normals", 2);
                Shaders.setProgramUniform1i("specular", 3);
                break;
            }
            case 9: 
            case 10: {
                normalMapEnabled = false;
                Shaders.setProgramUniform1i("gcolor", 0);
                Shaders.setProgramUniform1i("gdepth", 1);
                Shaders.setProgramUniform1i("gnormal", 2);
                Shaders.setProgramUniform1i("composite", 3);
                Shaders.setProgramUniform1i("shadow", 4);
                Shaders.setProgramUniform1i("gaux1", 5);
                Shaders.setProgramUniform1i("gaux2", 6);
                Shaders.setProgramUniform1i("gaux3", 7);
                Shaders.setProgramUniform1i("gaux4", 8);
                Shaders.setProgramUniformMatrix4ARB("gbufferPreviousProjection", false, previousProjection);
                Shaders.setProgramUniformMatrix4ARB("gbufferProjection", false, projection);
                Shaders.setProgramUniformMatrix4ARB("gbufferProjectionInverse", false, projectionInverse);
                Shaders.setProgramUniformMatrix4ARB("gbufferPreviousModelView", false, previousModelView);
                if (shadowPassInterval <= 0) break;
                Shaders.setProgramUniformMatrix4ARB("shadowProjection", false, shadowProjection);
                Shaders.setProgramUniformMatrix4ARB("shadowProjectionInverse", false, shadowProjectionInverse);
                Shaders.setProgramUniformMatrix4ARB("shadowModelView", false, shadowModelView);
                Shaders.setProgramUniformMatrix4ARB("shadowModelViewInverse", false, shadowModelViewInverse);
                break;
            }
            default: {
                normalMapEnabled = false;
            }
        }
        ur stack = Shaders.mc.g.bJ.g();
        Shaders.setProgramUniform1i("heldItemId", stack == null ? -1 : stack.c);
        Shaders.setProgramUniform1i("heldBlockLightValue", stack == null || stack.c >= 256 ? 0 : amq.t[stack.c]);
        Shaders.setProgramUniform1i("fogMode", fogEnabled ? GL11.glGetInteger((int)2917) : 0);
        Shaders.setProgramUniform1i("worldTime", (int)(Shaders.mc.e.G() % 24000L));
        Shaders.setProgramUniform1f("rainStrength", rainStrength);
        Shaders.setProgramUniform1f("aspectRatio", (float)renderWidth / (float)renderHeight);
        Shaders.setProgramUniform1f("viewWidth", renderWidth);
        Shaders.setProgramUniform1f("viewHeight", renderHeight);
        Shaders.setProgramUniform1f("near", 0.05f);
        Shaders.setProgramUniform1f("far", 32 << 3 - Shaders.mc.y.e);
        Shaders.setProgramUniform3f("sunPosition", sunPosition[0], sunPosition[1], sunPosition[2]);
        Shaders.setProgramUniform3f("moonPosition", moonPosition[0], moonPosition[1], moonPosition[2]);
        Shaders.setProgramUniform3f("previousCameraPosition", (float)previousCameraPosition[0], (float)previousCameraPosition[1], (float)previousCameraPosition[2]);
        Shaders.setProgramUniform3f("cameraPosition", (float)cameraPosition[0], (float)cameraPosition[1], (float)cameraPosition[2]);
        Shaders.setProgramUniformMatrix4ARB("gbufferModelView", false, modelView);
        Shaders.setProgramUniformMatrix4ARB("gbufferModelViewInverse", false, modelViewInverse);
        Shaders.setProgramUniform1f("wetness", wetness);
    }

    public static void setProgramUniform1i(String name, int x2) {
        if (activeProgram == 0) {
            return;
        }
        int uniform = ARBShaderObjects.glGetUniformLocationARB((int)programs[activeProgram], (CharSequence)name);
        ARBShaderObjects.glUniform1iARB((int)uniform, (int)x2);
    }

    public static void setProgramUniform1f(String name, float x2) {
        if (activeProgram == 0) {
            return;
        }
        int uniform = ARBShaderObjects.glGetUniformLocationARB((int)programs[activeProgram], (CharSequence)name);
        ARBShaderObjects.glUniform1fARB((int)uniform, (float)x2);
    }

    public static void setProgramUniform3f(String name, float x2, float y2, float z2) {
        if (activeProgram == 0) {
            return;
        }
        int uniform = ARBShaderObjects.glGetUniformLocationARB((int)programs[activeProgram], (CharSequence)name);
        ARBShaderObjects.glUniform3fARB((int)uniform, (float)x2, (float)y2, (float)z2);
    }

    public static void setProgramUniformMatrix4ARB(String name, boolean transpose, FloatBuffer matrix) {
        if (activeProgram == 0 || matrix == null) {
            return;
        }
        int uniform = GL20.glGetUniformLocation((int)programs[activeProgram], (CharSequence)name);
        ARBShaderObjects.glUniformMatrix4ARB((int)uniform, (boolean)transpose, (FloatBuffer)matrix);
    }

    public static void setCelestialPosition() {
        FloatBuffer modelView = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloat((int)2982, (FloatBuffer)modelView);
        float[] mv2 = new float[16];
        modelView.get(mv2, 0, 16);
        float[] sunPos = Shaders.multiplyMat4xVec4(mv2, new float[]{0.0f, 100.0f, 0.0f, 0.0f});
        sunPosition = sunPos;
        float[] moonPos = Shaders.multiplyMat4xVec4(mv2, new float[]{0.0f, -100.0f, 0.0f, 0.0f});
        moonPosition = moonPos;
    }

    private static float[] multiplyMat4xVec4(float[] ta2, float[] tb2) {
        float[] mout = new float[]{ta2[0] * tb2[0] + ta2[4] * tb2[1] + ta2[8] * tb2[2] + ta2[12] * tb2[3], ta2[1] * tb2[0] + ta2[5] * tb2[1] + ta2[9] * tb2[2] + ta2[13] * tb2[3], ta2[2] * tb2[0] + ta2[6] * tb2[1] + ta2[10] * tb2[2] + ta2[14] * tb2[3], ta2[3] * tb2[0] + ta2[7] * tb2[1] + ta2[11] * tb2[2] + ta2[15] * tb2[3]};
        return mout;
    }

    private static FloatBuffer invertMat4x(FloatBuffer matin) {
        int i2;
        float[] m2 = new float[16];
        float[] inv = new float[16];
        for (i2 = 0; i2 < 16; ++i2) {
            m2[i2] = matin.get(i2);
        }
        inv[0] = m2[5] * m2[10] * m2[15] - m2[5] * m2[11] * m2[14] - m2[9] * m2[6] * m2[15] + m2[9] * m2[7] * m2[14] + m2[13] * m2[6] * m2[11] - m2[13] * m2[7] * m2[10];
        inv[4] = -m2[4] * m2[10] * m2[15] + m2[4] * m2[11] * m2[14] + m2[8] * m2[6] * m2[15] - m2[8] * m2[7] * m2[14] - m2[12] * m2[6] * m2[11] + m2[12] * m2[7] * m2[10];
        inv[8] = m2[4] * m2[9] * m2[15] - m2[4] * m2[11] * m2[13] - m2[8] * m2[5] * m2[15] + m2[8] * m2[7] * m2[13] + m2[12] * m2[5] * m2[11] - m2[12] * m2[7] * m2[9];
        inv[12] = -m2[4] * m2[9] * m2[14] + m2[4] * m2[10] * m2[13] + m2[8] * m2[5] * m2[14] - m2[8] * m2[6] * m2[13] - m2[12] * m2[5] * m2[10] + m2[12] * m2[6] * m2[9];
        inv[1] = -m2[1] * m2[10] * m2[15] + m2[1] * m2[11] * m2[14] + m2[9] * m2[2] * m2[15] - m2[9] * m2[3] * m2[14] - m2[13] * m2[2] * m2[11] + m2[13] * m2[3] * m2[10];
        inv[5] = m2[0] * m2[10] * m2[15] - m2[0] * m2[11] * m2[14] - m2[8] * m2[2] * m2[15] + m2[8] * m2[3] * m2[14] + m2[12] * m2[2] * m2[11] - m2[12] * m2[3] * m2[10];
        inv[9] = -m2[0] * m2[9] * m2[15] + m2[0] * m2[11] * m2[13] + m2[8] * m2[1] * m2[15] - m2[8] * m2[3] * m2[13] - m2[12] * m2[1] * m2[11] + m2[12] * m2[3] * m2[9];
        inv[13] = m2[0] * m2[9] * m2[14] - m2[0] * m2[10] * m2[13] - m2[8] * m2[1] * m2[14] + m2[8] * m2[2] * m2[13] + m2[12] * m2[1] * m2[10] - m2[12] * m2[2] * m2[9];
        inv[2] = m2[1] * m2[6] * m2[15] - m2[1] * m2[7] * m2[14] - m2[5] * m2[2] * m2[15] + m2[5] * m2[3] * m2[14] + m2[13] * m2[2] * m2[7] - m2[13] * m2[3] * m2[6];
        inv[6] = -m2[0] * m2[6] * m2[15] + m2[0] * m2[7] * m2[14] + m2[4] * m2[2] * m2[15] - m2[4] * m2[3] * m2[14] - m2[12] * m2[2] * m2[7] + m2[12] * m2[3] * m2[6];
        inv[10] = m2[0] * m2[5] * m2[15] - m2[0] * m2[7] * m2[13] - m2[4] * m2[1] * m2[15] + m2[4] * m2[3] * m2[13] + m2[12] * m2[1] * m2[7] - m2[12] * m2[3] * m2[5];
        inv[14] = -m2[0] * m2[5] * m2[14] + m2[0] * m2[6] * m2[13] + m2[4] * m2[1] * m2[14] - m2[4] * m2[2] * m2[13] - m2[12] * m2[1] * m2[6] + m2[12] * m2[2] * m2[5];
        inv[3] = -m2[1] * m2[6] * m2[11] + m2[1] * m2[7] * m2[10] + m2[5] * m2[2] * m2[11] - m2[5] * m2[3] * m2[10] - m2[9] * m2[2] * m2[7] + m2[9] * m2[3] * m2[6];
        inv[7] = m2[0] * m2[6] * m2[11] - m2[0] * m2[7] * m2[10] - m2[4] * m2[2] * m2[11] + m2[4] * m2[3] * m2[10] + m2[8] * m2[2] * m2[7] - m2[8] * m2[3] * m2[6];
        inv[11] = -m2[0] * m2[5] * m2[11] + m2[0] * m2[7] * m2[9] + m2[4] * m2[1] * m2[11] - m2[4] * m2[3] * m2[9] - m2[8] * m2[1] * m2[7] + m2[8] * m2[3] * m2[5];
        inv[15] = m2[0] * m2[5] * m2[10] - m2[0] * m2[6] * m2[9] - m2[4] * m2[1] * m2[10] + m2[4] * m2[2] * m2[9] + m2[8] * m2[1] * m2[6] - m2[8] * m2[2] * m2[5];
        float det = m2[0] * inv[0] + m2[1] * inv[4] + m2[2] * inv[8] + m2[3] * inv[12];
        FloatBuffer invout = BufferUtils.createFloatBuffer((int)16);
        if ((double)det == 0.0) {
            return invout;
        }
        for (i2 = 0; i2 < 16; ++i2) {
            invout.put(i2, inv[i2] / det);
        }
        return invout;
    }

    private static int createVertShader(String filename) {
        BufferedReader reader;
        int vertShader = ARBShaderObjects.glCreateShaderObjectARB((int)35633);
        if (vertShader == 0) {
            return 0;
        }
        String vertexCode = "";
        try {
            reader = new BufferedReader(new InputStreamReader(Shaders.class.getResourceAsStream(filename)));
        }
        catch (Exception e2) {
            try {
                reader = new BufferedReader(new FileReader(new File(filename)));
            }
            catch (Exception e22) {
                System.out.println("Couldn't open " + filename + "!");
                ARBShaderObjects.glDeleteObjectARB((int)vertShader);
                return 0;
            }
        }
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                vertexCode = vertexCode + line + "\n";
                if (!line.matches("attribute [_a-zA-Z0-9]+ mc_Entity.*")) continue;
                entityAttrib = 10;
            }
        }
        catch (Exception e3) {
            System.out.println("Couldn't read " + filename + "!");
            ARBShaderObjects.glDeleteObjectARB((int)vertShader);
            return 0;
        }
        try {
            reader.close();
        }
        catch (Exception e4) {
            System.out.println("Couldn't close " + filename + "!");
        }
        ARBShaderObjects.glShaderSourceARB((int)vertShader, (CharSequence)vertexCode);
        ARBShaderObjects.glCompileShaderARB((int)vertShader);
        Shaders.printLogInfo(vertShader, filename);
        return vertShader;
    }

    private static int createFragShader(String filename) {
        BufferedReader reader;
        int fragShader = ARBShaderObjects.glCreateShaderObjectARB((int)35632);
        if (fragShader == 0) {
            return 0;
        }
        String fragCode = "";
        try {
            reader = new BufferedReader(new InputStreamReader(Shaders.class.getResourceAsStream(filename)));
        }
        catch (Exception e2) {
            try {
                reader = new BufferedReader(new FileReader(new File(filename)));
            }
            catch (Exception e22) {
                System.out.println("Couldn't open " + filename + "!");
                ARBShaderObjects.glDeleteObjectARB((int)fragShader);
                return 0;
            }
        }
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                String[] parts;
                fragCode = fragCode + line + "\n";
                if (line.matches("uniform [ _a-zA-Z0-9]+ shadow;.*")) {
                    shadowPassInterval = 1;
                    continue;
                }
                if (colorAttachments < 5 && line.matches("uniform [ _a-zA-Z0-9]+ gaux1;.*")) {
                    colorAttachments = 5;
                    continue;
                }
                if (colorAttachments < 6 && line.matches("uniform [ _a-zA-Z0-9]+ gaux2;.*")) {
                    colorAttachments = 6;
                    continue;
                }
                if (colorAttachments < 7 && line.matches("uniform [ _a-zA-Z0-9]+ gaux3;.*")) {
                    colorAttachments = 7;
                    continue;
                }
                if (colorAttachments < 8 && line.matches("uniform [ _a-zA-Z0-9]+ gaux4;.*")) {
                    colorAttachments = 8;
                    continue;
                }
                if (line.matches("/\\* SHADOWRES:[0-9]+ \\*/.*")) {
                    parts = line.split("(:| )", 4);
                    System.out.println("Shadow map resolution: " + parts[2]);
                    shadowMapWidth = shadowMapHeight = Integer.parseInt(parts[2]);
                    continue;
                }
                if (line.matches("/\\* SHADOWFOV:[0-9\\.]+ \\*/.*")) {
                    parts = line.split("(:| )", 4);
                    System.out.println("Shadow map field of view: " + parts[2]);
                    shadowMapFOV = Float.parseFloat(parts[2]);
                    shadowMapIsOrtho = false;
                    continue;
                }
                if (line.matches("/\\* SHADOWHPL:[0-9\\.]+ \\*/.*")) {
                    parts = line.split("(:| )", 4);
                    System.out.println("Shadow map half-plane: " + parts[2]);
                    shadowMapHalfPlane = Float.parseFloat(parts[2]);
                    shadowMapIsOrtho = true;
                    continue;
                }
                if (line.matches("/\\* WETNESSHL:[0-9\\.]+ \\*/.*")) {
                    parts = line.split("(:| )", 4);
                    System.out.println("Wetness halflife: " + parts[2]);
                    wetnessHalfLife = Float.parseFloat(parts[2]);
                    continue;
                }
                if (!line.matches("/\\* DRYNESSHL:[0-9\\.]+ \\*/.*")) continue;
                parts = line.split("(:| )", 4);
                System.out.println("Dryness halflife: " + parts[2]);
                drynessHalfLife = Float.parseFloat(parts[2]);
            }
        }
        catch (Exception e3) {
            System.out.println("Couldn't read " + filename + "!");
            ARBShaderObjects.glDeleteObjectARB((int)fragShader);
            return 0;
        }
        try {
            reader.close();
        }
        catch (Exception e4) {
            System.out.println("Couldn't close " + filename + "!");
        }
        ARBShaderObjects.glShaderSourceARB((int)fragShader, (CharSequence)fragCode);
        ARBShaderObjects.glCompileShaderARB((int)fragShader);
        Shaders.printLogInfo(fragShader, filename);
        return fragShader;
    }

    private static boolean printLogInfo(int obj, String name) {
        IntBuffer iVal = BufferUtils.createIntBuffer((int)1);
        ARBShaderObjects.glGetObjectParameterARB((int)obj, (int)35716, (IntBuffer)iVal);
        int length = iVal.get();
        if (length > 1) {
            ByteBuffer infoLog = BufferUtils.createByteBuffer((int)length);
            iVal.flip();
            ARBShaderObjects.glGetInfoLogARB((int)obj, (IntBuffer)iVal, (ByteBuffer)infoLog);
            byte[] infoBytes = new byte[length];
            infoLog.get(infoBytes);
            if (infoBytes[length - 1] == 0) {
                infoBytes[length - 1] = 10;
            }
            String out = new String(infoBytes);
            System.out.println("Info log: " + name + "\n" + out);
            return false;
        }
        return true;
    }

    private static void setupFrameBuffer() {
        Shaders.setupRenderTextures();
        if (dfb != 0) {
            EXTFramebufferObject.glDeleteFramebuffersEXT((int)dfb);
            EXTFramebufferObject.glDeleteRenderbuffersEXT((IntBuffer)dfbRenderBuffers);
        }
        dfb = EXTFramebufferObject.glGenFramebuffersEXT();
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)dfb);
        EXTFramebufferObject.glGenRenderbuffersEXT((IntBuffer)dfbRenderBuffers);
        for (int i2 = 0; i2 < colorAttachments; ++i2) {
            EXTFramebufferObject.glBindRenderbufferEXT((int)36161, (int)dfbRenderBuffers.get(i2));
            if (i2 == 1) {
                EXTFramebufferObject.glRenderbufferStorageEXT((int)36161, (int)34837, (int)renderWidth, (int)renderHeight);
            } else {
                EXTFramebufferObject.glRenderbufferStorageEXT((int)36161, (int)6408, (int)renderWidth, (int)renderHeight);
            }
            EXTFramebufferObject.glFramebufferRenderbufferEXT((int)36160, (int)dfbDrawBuffers.get(i2), (int)36161, (int)dfbRenderBuffers.get(i2));
            EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)dfbDrawBuffers.get(i2), (int)3553, (int)dfbTextures.get(i2), (int)0);
        }
        EXTFramebufferObject.glDeleteRenderbuffersEXT((int)dfbDepthBuffer);
        dfbDepthBuffer = EXTFramebufferObject.glGenRenderbuffersEXT();
        EXTFramebufferObject.glBindRenderbufferEXT((int)36161, (int)dfbDepthBuffer);
        EXTFramebufferObject.glRenderbufferStorageEXT((int)36161, (int)6402, (int)renderWidth, (int)renderHeight);
        EXTFramebufferObject.glFramebufferRenderbufferEXT((int)36160, (int)36096, (int)36161, (int)dfbDepthBuffer);
        int status = EXTFramebufferObject.glCheckFramebufferStatusEXT((int)36160);
        if (status != 36053) {
            System.out.println("Failed creating framebuffer! (Status " + status + ")");
        }
    }

    private static void setupShadowFrameBuffer() {
        if (shadowPassInterval <= 0) {
            return;
        }
        Shaders.setupShadowRenderTexture();
        EXTFramebufferObject.glDeleteFramebuffersEXT((int)sfb);
        sfb = EXTFramebufferObject.glGenFramebuffersEXT();
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)sfb);
        GL11.glDrawBuffer((int)0);
        GL11.glReadBuffer((int)0);
        EXTFramebufferObject.glDeleteRenderbuffersEXT((int)sfbDepthBuffer);
        sfbDepthBuffer = EXTFramebufferObject.glGenRenderbuffersEXT();
        EXTFramebufferObject.glBindRenderbufferEXT((int)36161, (int)sfbDepthBuffer);
        EXTFramebufferObject.glRenderbufferStorageEXT((int)36161, (int)6402, (int)shadowMapWidth, (int)shadowMapHeight);
        EXTFramebufferObject.glFramebufferRenderbufferEXT((int)36160, (int)36096, (int)36161, (int)sfbDepthBuffer);
        EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36096, (int)3553, (int)sfbDepthTexture, (int)0);
        int status = EXTFramebufferObject.glCheckFramebufferStatusEXT((int)36160);
        if (status != 36053) {
            System.out.println("Failed creating shadow framebuffer! (Status " + status + ")");
        }
    }

    private static void setupRenderTextures() {
        GL11.glDeleteTextures((IntBuffer)dfbTextures);
        GL11.glGenTextures((IntBuffer)dfbTextures);
        for (int i2 = 0; i2 < colorAttachments; ++i2) {
            ByteBuffer buffer;
            GL11.glBindTexture((int)3553, (int)dfbTextures.get(i2));
            GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            if (i2 == 1) {
                buffer = ByteBuffer.allocateDirect(renderWidth * renderHeight * 4 * 4);
                GL11.glTexImage2D((int)3553, (int)0, (int)34837, (int)renderWidth, (int)renderHeight, (int)0, (int)6408, (int)5126, (ByteBuffer)buffer);
                continue;
            }
            buffer = ByteBuffer.allocateDirect(renderWidth * renderHeight * 4);
            GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)renderWidth, (int)renderHeight, (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
        }
    }

    private static void setupShadowRenderTexture() {
        if (shadowPassInterval <= 0) {
            return;
        }
        GL11.glDeleteTextures((int)sfbDepthTexture);
        sfbDepthTexture = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)sfbDepthTexture);
        GL11.glTexParameterf((int)3553, (int)10242, (float)10496.0f);
        GL11.glTexParameterf((int)3553, (int)10243, (float)10496.0f);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        ByteBuffer buffer = ByteBuffer.allocateDirect(shadowMapWidth * shadowMapHeight * 4);
        GL11.glTexImage2D((int)3553, (int)0, (int)6402, (int)shadowMapWidth, (int)shadowMapHeight, (int)0, (int)6402, (int)5126, (ByteBuffer)buffer);
    }

    static String versiontostring(int vv2) {
        String vs2 = Integer.toString(vv2);
        return Integer.toString(Integer.parseInt(vs2.substring(1, 3))) + "." + Integer.toString(Integer.parseInt(vs2.substring(3, 5))) + "." + Integer.toString(Integer.parseInt(vs2.substring(5)));
    }

    static void checkOptifine() {
        try {
            if (!ofVersion.equals(ofVersion)) {
                System.out.println("[Shaders] Wrong Optifine version (OptiFine_1.4.6_HD_U_A2) Use Optifine OptiFine_1.4.6_HD_U_A2 !");
                System.exit(-1);
            } else {
                System.out.println("[Shaders] Optifine (version OptiFine_1.4.6_HD_U_A2) is present.");
                System.out.println("[Shaders] Mod loaded version: " + Shaders.versiontostring(1010104));
            }
        }
        catch (Exception e2) {
            System.out.println("[Shaders] Optifine missing or wrong version! Install Optifine OptiFine_1.4.6_HD_U_A2 first and then the Shaders mod!");
            System.exit(-1);
        }
    }

    static ArrayList listofShaders() {
        ArrayList<String> list = new ArrayList<String>();
        File[] listOfFiles = shadersdir.listFiles();
        for (int i2 = 0; i2 < listOfFiles.length; ++i2) {
            int pos;
            String name;
            String ext;
            if (!listOfFiles[i2].isFile() || !(ext = (name = listOfFiles[i2].getName()).substring((pos = name.lastIndexOf(46)) + 1)).toLowerCase().equals("zip")) continue;
            list.add(name);
        }
        return list;
    }

    public static void loadShader() {
        File confshader;
        File currentshader;
        if (!shadersdir.exists()) {
            shadersdir.mkdir();
        }
        if (!(currentshader = new File(shadersdir, "temp")).exists()) {
            currentshader.mkdir();
        }
        if (!(confshader = new File(shadersdir, "current.cfg")).exists()) {
            try {
                BufferedWriter bufferedwriter = new BufferedWriter(new FileWriter(confshader, true));
                bufferedwriter.write("test.zip");
                bufferedwriter.newLine();
                if (dtweak) {
                    bufferedwriter.write("1");
                } else {
                    bufferedwriter.write("0");
                }
                bufferedwriter.newLine();
                bufferedwriter.close();
            }
            catch (Exception ex2) {
                // empty catch block
            }
        }
        try {
            BufferedReader bufferedreader = new BufferedReader(new FileReader(confshader));
            currentshadername = bufferedreader.readLine();
            dtweak = !bufferedreader.readLine().equals("0");
            bufferedreader.close();
            currentshader = new File(shadersdir, currentshadername);
            if (!currentshader.exists()) {
                currentshadername = "test.zip";
                currentshader = new File(shadersdir, currentshadername);
            }
        }
        catch (Exception ex3) {
            // empty catch block
        }
        if (!currentshader.exists()) {
            try {
                String eol = System.getProperty("line.separator");
                ZipOutputStream out = new ZipOutputStream(new FileOutputStream(currentshader));
                out.putNextEntry(new ZipEntry("gbuffers_terrain.fsh"));
                out.write(("#version 120" + eol + eol).getBytes());
                out.write(("uniform sampler2D texture;" + eol).getBytes());
                out.write(("uniform sampler2D lightmap;" + eol).getBytes());
                out.write(("varying vec4 color;" + eol).getBytes());
                out.write(("varying vec4 texcoord;" + eol).getBytes());
                out.write(("varying vec4 lmcoord;" + eol).getBytes());
                out.write(("" + eol).getBytes());
                out.write(("const int GL_LINEAR = 9729;" + eol).getBytes());
                out.write(("const int GL_EXP = 2048;" + eol).getBytes());
                out.write(("" + eol).getBytes());
                out.write(("uniform int fogMode;" + eol).getBytes());
                out.write(("" + eol).getBytes());
                out.write(("void main() {" + eol).getBytes());
                out.write(("\tgl_FragData[0] = texture2D(texture, texcoord.st) * texture2D(lightmap, lmcoord.st) * color;" + eol).getBytes());
                out.write(("\tgl_FragData[1] = vec4(vec3(gl_FragCoord.z), 1.0);" + eol).getBytes());
                out.write(("" + eol).getBytes());
                out.write(("\tif (fogMode == GL_EXP) {" + eol).getBytes());
                out.write(("\t\tgl_FragData[0].rgb = mix(gl_FragData[0].rgb, gl_Fog.color.rgb, 1.0 - clamp(exp(-gl_Fog.density * gl_FogFragCoord), 0.0, 1.0));" + eol).getBytes());
                out.write(("\t} else if (fogMode == GL_LINEAR) {" + eol).getBytes());
                out.write(("\t\tgl_FragData[0].rgb = mix(gl_FragData[0].rgb, gl_Fog.color.rgb, clamp((gl_FogFragCoord - gl_Fog.start) * gl_Fog.scale, 0.0, 1.0));" + eol).getBytes());
                out.write(("\t}" + eol).getBytes());
                out.write(("}" + eol).getBytes());
                out.closeEntry();
                out.putNextEntry(new ZipEntry("gbuffers_terrain.vsh"));
                out.write(("#version 120" + eol).getBytes());
                out.write(("" + eol).getBytes());
                out.write(("#define WAVING_GRASS" + eol).getBytes());
                out.write(("#define WAVING_LEAVES" + eol).getBytes());
                out.write(("" + eol).getBytes());
                out.write(("varying vec4 color;" + eol).getBytes());
                out.write(("varying vec4 texcoord;" + eol).getBytes());
                out.write(("varying vec4 lmcoord;" + eol).getBytes());
                out.write(("" + eol).getBytes());
                out.write(("attribute vec4 mc_Entity;" + eol).getBytes());
                out.write(("" + eol).getBytes());
                out.write(("uniform int worldTime;" + eol).getBytes());
                out.write(("" + eol).getBytes());
                out.write(("void main() {" + eol).getBytes());
                out.write(("" + eol).getBytes());
                out.write(("\ttexcoord = gl_TextureMatrix[0] * gl_MultiTexCoord0;" + eol).getBytes());
                out.write(("" + eol).getBytes());
                out.write(("\tvec4 position = gl_Vertex;" + eol).getBytes());
                out.write(("" + eol).getBytes());
                out.write(("#ifdef WAVING_GRASS" + eol).getBytes());
                out.write(("//Grass//" + eol).getBytes());
                out.write(("\tif (mc_Entity.x == 31.0 && texcoord.t < 0.15) {" + eol).getBytes());
                out.write(("\t\tfloat speed = 8.0;" + eol).getBytes());
                out.write(("" + eol).getBytes());
                out.write(("\t\tfloat magnitude = sin((worldTime * 3.14159265358979323846264 / (28.0)) + position.x + position.z) * 0.1 + 0.1;" + eol).getBytes());
                out.write(("\t\tfloat d0 = sin(worldTime * 3.14159265358979323846264 / (122.0 * speed)) * 3.0 - 1.5 + position.z;" + eol).getBytes());
                out.write(("\t\tfloat d1 = sin(worldTime * 3.14159265358979323846264 / (152.0 * speed)) * 3.0 - 1.5 + position.x;" + eol).getBytes());
                out.write(("\t\tfloat d2 = sin(worldTime * 3.14159265358979323846264 / (122.0 * speed)) * 3.0 - 1.5 + position.x;" + eol).getBytes());
                out.write(("\t\tfloat d3 = sin(worldTime * 3.14159265358979323846264 / (152.0 * speed)) * 3.0 - 1.5 + position.z;" + eol).getBytes());
                out.write(("\t\tposition.x += sin((worldTime * 3.14159265358979323846264 / (28.0 * speed)) + (position.x + d0) * 0.1 + (position.z + d1) * 0.1) * magnitude;" + eol).getBytes());
                out.write(("\t\tposition.z += sin((worldTime * 3.14159265358979323846264 / (28.0 * speed)) + (position.z + d2) * 0.1 + (position.x + d3) * 0.1) * magnitude;" + eol).getBytes());
                out.write(("\t}" + eol).getBytes());
                out.write(("" + eol).getBytes());
                out.write(("\t//small leaf movement" + eol).getBytes());
                out.write(("\tif (mc_Entity.x == 31.0 && texcoord.t < 0.15) {" + eol).getBytes());
                out.write(("\t\tfloat speed = 0.8;" + eol).getBytes());
                out.write(("" + eol).getBytes());
                out.write(("\t\tfloat magnitude = (sin(((position.y + position.x)/2.0 + worldTime * 3.14159265358979323846264 / ((28.0)))) * 0.05 + 0.15) * 0.4;" + eol).getBytes());
                out.write(("\t\tfloat d0 = sin(worldTime * 3.14159265358979323846264 / (112.0 * speed)) * 3.0 - 1.5;" + eol).getBytes());
                out.write(("\t\tfloat d1 = sin(worldTime * 3.14159265358979323846264 / (142.0 * speed)) * 3.0 - 1.5;" + eol).getBytes());
                out.write(("\t\tfloat d2 = sin(worldTime * 3.14159265358979323846264 / (112.0 * speed)) * 3.0 - 1.5;" + eol).getBytes());
                out.write(("\t\tfloat d3 = sin(worldTime * 3.14159265358979323846264 / (142.0 * speed)) * 3.0 - 1.5;" + eol).getBytes());
                out.write(("\t\tposition.x += sin((worldTime * 3.14159265358979323846264 / (18.0 * speed)) + (-position.x + d0)*1.6 + (position.z + d1)*1.6) * magnitude;" + eol).getBytes());
                out.write(("\t\tposition.z += sin((worldTime * 3.14159265358979323846264 / (18.0 * speed)) + (position.z + d2)*1.6 + (-position.x + d3)*1.6) * magnitude;" + eol).getBytes());
                out.write(("\t\tposition.y += sin((worldTime * 3.14159265358979323846264 / (11.0 * speed)) + (position.z + d2) + (position.x + d3)) * (magnitude/3.0);" + eol).getBytes());
                out.write(("\t}" + eol).getBytes());
                out.write(("" + eol).getBytes());
                out.write(("#endif" + eol).getBytes());
                out.write(("" + eol).getBytes());
                out.write(("#ifdef WAVING_LEAVES" + eol).getBytes());
                out.write(("//Leaves//" + eol).getBytes());
                out.write(("" + eol).getBytes());
                out.write(("\t//large scale movement" + eol).getBytes());
                out.write(("\tif (mc_Entity.x == 18.0 && texcoord.t < 1.20) {" + eol).getBytes());
                out.write(("\t\tfloat speed = 3.0;" + eol).getBytes());
                out.write(("" + eol).getBytes());
                out.write(("\t\tfloat magnitude = (sin(((position.y + position.x)/2.0 + worldTime * 3.14159265358979323846264 / ((88.0)))) * 0.05 + 0.15) * 0.35;" + eol).getBytes());
                out.write(("\t\tfloat d0 = sin(worldTime * 3.14159265358979323846264 / (122.0 * speed)) * 3.0 - 1.5;" + eol).getBytes());
                out.write(("\t\tfloat d1 = sin(worldTime * 3.14159265358979323846264 / (152.0 * speed)) * 3.0 - 1.5;" + eol).getBytes());
                out.write(("\t\tfloat d2 = sin(worldTime * 3.14159265358979323846264 / (192.0 * speed)) * 3.0 - 1.5;" + eol).getBytes());
                out.write(("\t\tfloat d3 = sin(worldTime * 3.14159265358979323846264 / (142.0 * speed)) * 3.0 - 1.5;" + eol).getBytes());
                out.write(("\t\tposition.x += sin((worldTime * 3.14159265358979323846264 / (16.0 * speed)) + (position.x + d0)*0.5 + (position.z + d1)*0.5 + (position.y)) * magnitude;" + eol).getBytes());
                out.write(("\t\tposition.z += sin((worldTime * 3.14159265358979323846264 / (18.0 * speed)) + (position.z + d2)*0.5 + (position.x + d3)*0.5 + (position.y)) * magnitude;" + eol).getBytes());
                out.write(("\t\t//position.y += sin((worldTime * 3.14159265358979323846264 / (10.0 * speed)) + (position.z + d2) + (position.x + d3)) * (magnitude/2.0);" + eol).getBytes());
                out.write(("\t}" + eol).getBytes());
                out.write(("" + eol).getBytes());
                out.write(("\t//small leaf movement" + eol).getBytes());
                out.write(("\tif (mc_Entity.x == 18.0 && texcoord.t < 0.20) {" + eol).getBytes());
                out.write(("\t\tfloat speed = 1.1;" + eol).getBytes());
                out.write(("" + eol).getBytes());
                out.write(("\t\tfloat magnitude = (sin(((position.y + position.x)/8.0 + worldTime * 3.14159265358979323846264 / ((88.0)))) * 0.15 + 0.05) * 0.22;" + eol).getBytes());
                out.write(("\t\tfloat d0 = sin(worldTime * 3.14159265358979323846264 / (112.0 * speed)) * 3.0 + 0.5;" + eol).getBytes());
                out.write(("\t\tfloat d1 = sin(worldTime * 3.14159265358979323846264 / (142.0 * speed)) * 3.0 + 0.5;" + eol).getBytes());
                out.write(("\t\tfloat d2 = sin(worldTime * 3.14159265358979323846264 / (112.0 * speed)) * 3.0 + 0.5;" + eol).getBytes());
                out.write(("\t\tfloat d3 = sin(worldTime * 3.14159265358979323846264 / (142.0 * speed)) * 3.0 + 0.5;" + eol).getBytes());
                out.write(("\t\tposition.x += sin((worldTime * 3.14159265358979323846264 / (18.0 * speed)) + (-position.x + d0)*1.6 + (position.z + d1)*1.6) * magnitude;" + eol).getBytes());
                out.write(("\t\tposition.z += sin((worldTime * 3.14159265358979323846264 / (18.0 * speed)) + (position.z + d2)*1.6 + (-position.x + d3)*1.6) * magnitude;" + eol).getBytes());
                out.write(("\t\tposition.y += sin((worldTime * 3.14159265358979323846264 / (11.0 * speed)) + (position.z + d2) + (position.x + d3)) * (magnitude/4.0);" + eol).getBytes());
                out.write(("\t}" + eol).getBytes());
                out.write(("" + eol).getBytes());
                out.write(("\t//redwood leaves" + eol).getBytes());
                out.write(("\tif (mc_Entity.x == 18.0 && texcoord.t < 0.60 && texcoord.t > 0.5) {" + eol).getBytes());
                out.write(("\t\tfloat speed = 1.0;" + eol).getBytes());
                out.write(("" + eol).getBytes());
                out.write(("\t\tfloat magnitude = (sin((position.y + position.x + worldTime * 3.14159265358979323846264 / ((28.0) * speed))) * 0.15 + 0.15) * 0.25;" + eol).getBytes());
                out.write(("\t\tfloat d0 = sin(worldTime * 3.14159265358979323846264 / (112.0 * speed)) * 3.0 - 1.5;" + eol).getBytes());
                out.write(("\t\tfloat d1 = sin(worldTime * 3.14159265358979323846264 / (142.0 * speed)) * 3.0 - 1.5;" + eol).getBytes());
                out.write(("\t\tfloat d2 = sin(worldTime * 3.14159265358979323846264 / (132.0 * speed)) * 3.0 - 1.5;" + eol).getBytes());
                out.write(("\t\tfloat d3 = sin(worldTime * 3.14159265358979323846264 / (122.0 * speed)) * 3.0 - 1.5;" + eol).getBytes());
                out.write(("\t\tposition.x += sin((worldTime * 3.14159265358979323846264 / (18.0 * speed)) + (-position.x + d0)*1.6 + (position.z + d1)*1.6) * magnitude;" + eol).getBytes());
                out.write(("\t\tposition.z += sin((worldTime * 3.14159265358979323846264 / (17.0 * speed)) + (position.z + d2)*1.6 + (-position.x + d3)*1.6) * magnitude;" + eol).getBytes());
                out.write(("\t\tposition.y += sin((worldTime * 3.14159265358979323846264 / (11.0 * speed)) + (position.z + d2) + (position.x + d3)) * (magnitude/2.0);" + eol).getBytes());
                out.write(("\t}" + eol).getBytes());
                out.write(("" + eol).getBytes());
                out.write(("\t\t//Jungle leaves" + eol).getBytes());
                out.write(("\tif (mc_Entity.x == 18.0 && texcoord.t < 1.90 && texcoord.t > -1.0) {" + eol).getBytes());
                out.write(("\t\tfloat speed = 1.0;" + eol).getBytes());
                out.write(("" + eol).getBytes());
                out.write(("\t\tfloat magnitude = (sin((position.y + position.x + worldTime * 3.14159265358979323846264 / ((28.0) * speed))) * 0.15 + 0.15) * 0.20;" + eol).getBytes());
                out.write(("\t\tfloat d0 = sin(worldTime * 3.14159265358979323846264 / (112.0 * speed)) * 3.0 - 1.5;" + eol).getBytes());
                out.write(("\t\tfloat d1 = sin(worldTime * 3.14159265358979323846264 / (142.0 * speed)) * 3.0 - 1.5;" + eol).getBytes());
                out.write(("\t\tfloat d2 = sin(worldTime * 3.14159265358979323846264 / (132.0 * speed)) * 3.0 - 1.5;" + eol).getBytes());
                out.write(("\t\tfloat d3 = sin(worldTime * 3.14159265358979323846264 / (122.0 * speed)) * 3.0 - 1.5;" + eol).getBytes());
                out.write(("\t\tposition.x += sin((worldTime * 3.14159265358979323846264 / (18.0 * speed)) + (-position.x + d0)*1.6 + (position.z + d1)*1.6) * magnitude;" + eol).getBytes());
                out.write(("\t\tposition.z += sin((worldTime * 3.14159265358979323846264 / (17.0 * speed)) + (position.z + d2)*1.6 + (-position.x + d3)*1.6) * magnitude;" + eol).getBytes());
                out.write(("\t\tposition.y += sin((worldTime * 3.14159265358979323846264 / (11.0 * speed)) + (position.z + d2) + (position.x + d3)) * (magnitude/2.0);" + eol).getBytes());
                out.write(("\t}" + eol).getBytes());
                out.write(("" + eol).getBytes());
                out.write(("#endif" + eol).getBytes());
                out.write(("" + eol).getBytes());
                out.write(("\tgl_Position = gl_ProjectionMatrix * (gl_ModelViewMatrix * position);" + eol).getBytes());
                out.write(("" + eol).getBytes());
                out.write(("\tcolor = gl_Color;" + eol).getBytes());
                out.write(("\tlmcoord = gl_TextureMatrix[1] * gl_MultiTexCoord1;" + eol).getBytes());
                out.write(("\tgl_FogFragCoord = gl_Position.z;" + eol).getBytes());
                out.write(("}" + eol).getBytes());
                out.closeEntry();
                out.close();
            }
            catch (Exception ex4) {
                // empty catch block
            }
        }
        HashSet<String> shaderfiles = new HashSet<String>();
        for (int si2 = 1; si2 < 10; ++si2) {
            shaderfiles.add(programNames[si2] + ".fsh");
            shaderfiles.add(programNames[si2] + ".vsh");
        }
        for (int si3 = 1; si3 < 10; ++si3) {
            File fil = new File(shadersdir, "temp" + File.separator + programNames[si3] + ".fsh");
            fil.delete();
            fil = new File(shadersdir, "temp" + File.separator + programNames[si3] + ".vsh");
            fil.delete();
        }
        try {
            int n2;
            ZipInputStream inp = new ZipInputStream(new FileInputStream(currentshader));
            System.out.println("[Shaders] Shader selected: " + currentshadername);
            boolean found = false;
            ZipEntry entry = inp.getNextEntry();
            while (entry != null) {
                if (entry.isDirectory() && entry.getName().toLowerCase().contains("shaders/contents/files/shaders/")) {
                    found = true;
                    break;
                }
                entry = inp.getNextEntry();
            }
            if (!found) {
                inp.close();
                inp = new ZipInputStream(new FileInputStream(currentshader));
                entry = inp.getNextEntry();
                while (entry != null) {
                    if (entry.isDirectory() && entry.getName().toLowerCase().contains("shaders/")) {
                        found = true;
                        break;
                    }
                    entry = inp.getNextEntry();
                }
            }
            if (!found) {
                inp.close();
                inp = new ZipInputStream(new FileInputStream(currentshader));
                entry = inp.getNextEntry();
            }
            byte[] buf = new byte[1024];
            String zippath = "";
            boolean seusrc5tweak = false;
            while (entry != null && shaderfiles.size() > 0) {
                String zipfile = new File(entry.getName()).getName();
                if (shaderfiles.contains(zipfile) && !entry.isDirectory()) {
                    String zippathfile = new File(entry.getName()).getPath();
                    if (shaderfiles.size() == 18) {
                        zippath = zippathfile.substring(0, zippathfile.length() - zipfile.length());
                    }
                    if (zippathfile.equals(zippath + zipfile)) {
                        shaderfiles.remove(zipfile);
                        if (zipfile.equals("gbuffers_water.vsh") && entry.getCrc() == 2530345120L) {
                            seusrc5tweak = true;
                        }
                        FileOutputStream fileoutputstream = new FileOutputStream(shadersdir + File.separator + "temp" + File.separator + zipfile);
                        while ((n2 = inp.read(buf, 0, 1024)) > -1) {
                            fileoutputstream.write(buf, 0, n2);
                        }
                        fileoutputstream.close();
                        System.out.println("[Shaders] Shader loaded: " + zippathfile);
                    }
                }
                entry = inp.getNextEntry();
            }
            inp.close();
            if (seusrc5tweak) {
                new File(shadersdir + File.separator + "temp" + File.separator + "gbuffers_water.fsh").delete();
                new File(shadersdir + File.separator + "temp" + File.separator + "gbuffers_water.vsh").delete();
                FileInputStream file = new FileInputStream(shadersdir + File.separator + "temp" + File.separator + "gbuffers_textured_lit.fsh");
                FileOutputStream file2 = new FileOutputStream(shadersdir + File.separator + "temp" + File.separator + "gbuffers_water.fsh", false);
                while ((n2 = file.read(buf, 0, 1024)) > -1) {
                    file2.write(buf, 0, n2);
                }
                file.close();
                file2.close();
                file = new FileInputStream(shadersdir + File.separator + "temp" + File.separator + "gbuffers_textured_lit.vsh");
                file2 = new FileOutputStream(shadersdir + File.separator + "temp" + File.separator + "gbuffers_water.vsh", false);
                while ((n2 = file.read(buf, 0, 1024)) > -1) {
                    file2.write(buf, 0, n2);
                }
                file.close();
                file2.close();
                System.out.println("[Shaders] Detected SEUS v10 RC5, copied gbuffers_textured_lit. to gbuffers_water.");
            }
        }
        catch (Exception exc) {
            // empty catch block
        }
        isInitialized = false;
        if (shaderfiles.size() == 18) {
            System.out.println("[Shaders] No Shader found in: " + currentshadername);
        } else {
            System.out.println("[Shaders] Shader loaded: " + currentshadername);
        }
    }

    static {
        isShadowPass = false;
        sfb = 0;
        sfbColorTexture = 0;
        sfbDepthTexture = 0;
        sfbRenderBuffer = 0;
        sfbDepthBuffer = 0;
        shadowProjection = null;
        shadowProjectionInverse = null;
        shadowModelView = null;
        shadowModelViewInverse = null;
        colorAttachments = 0;
        dfbDrawBuffers = null;
        dfbTextures = null;
        dfbRenderBuffers = null;
        dfb = 0;
        dfbDepthBuffer = 0;
        activeProgram = 0;
        programNames = new String[]{"", "gbuffers_basic", "gbuffers_textured", "gbuffers_textured_lit", "gbuffers_terrain", "gbuffers_entities", "gbuffers_water", "gbuffers_hand", "gbuffers_weather", "composite", "final"};
        programBackups = new int[]{0, 0, 1, 2, 3, 3, 4, 3, 3, 0, 0};
        programs = new int[11];
        renderEngine = null;
        textureIdMap = new HashMap();
        textureIdByNameMap = new HashMap();
        defaultTextureImageMap = new HashMap();
        defaultTextureImage_d = null;
        defaultTextureImage_n = null;
        defaultTextureImage_s = null;
        defaultTextureIdArray = null;
        normalMapEnabled = false;
        dtweak = false;
        shadersdir = new File(Minecraft.b(), "shaders");
        lastversion = 1010104;
        updateinterval = 48;
    }
}

