/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.util.ArrayList;

public class NaturalTextures {
    private static bba renderEngine = null;
    private static NaturalProperties[][] propertiesByTex = new NaturalProperties[0][];

    public static void update(bba re2) {
        propertiesByTex = new NaturalProperties[0][];
        renderEngine = re2;
        if (!Config.isNaturalTextures()) {
            return;
        }
        String fileName = "/natural.properties";
        InputStream in2 = re2.k.e().a(fileName);
        if (in2 == null) {
            Config.dbg("NaturalTextures: configuration \"" + fileName + "\" not found");
            propertiesByTex = NaturalTextures.makeDefaultProperties();
            return;
        }
        try {
            ArrayList<NaturalProperties[]> list = new ArrayList<NaturalProperties[]>(1024);
            String configStr = Config.readInputStream(in2);
            in2.close();
            String[] configLines = Config.tokenize(configStr, "\n\r");
            Config.dbg("Natural Textures: Parsing configuration \"" + fileName + "\"");
            for (int i2 = 0; i2 < configLines.length; ++i2) {
                int texNum;
                String line = configLines[i2].trim();
                if (line.startsWith("#")) continue;
                String[] strs = Config.tokenize(line, "=");
                if (strs.length != 2) {
                    Config.dbg("Natural Textures: Invalid \"" + fileName + "\" line: " + line);
                    continue;
                }
                String key = strs[0].trim();
                String type = strs[1].trim();
                String[] keyStrs = Config.tokenize(key, ":");
                if (keyStrs.length != 2) {
                    Config.dbg("Natural Textures: Invalid \"" + fileName + "\" line: " + line);
                    continue;
                }
                String texName = keyStrs[0];
                String tileNumStr = keyStrs[1];
                int tileNum = Config.parseInt(tileNumStr, -1);
                if (tileNum < 0 || tileNum > 255) {
                    Config.dbg("Natural Textures: Invalid \"" + fileName + "\" line: " + line);
                    continue;
                }
                NaturalProperties props = new NaturalProperties(type);
                if (!props.isValid() || (texNum = re2.b(texName)) < 0) continue;
                while (list.size() <= texNum) {
                    list.add(null);
                }
                NaturalProperties[] propsByTile = (NaturalProperties[])list.get(texNum);
                if (propsByTile == null) {
                    propsByTile = new NaturalProperties[256];
                    list.set(texNum, propsByTile);
                }
                propsByTile[tileNum] = props;
            }
            propertiesByTex = (NaturalProperties[][])list.toArray((T[])new NaturalProperties[list.size()][]);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static NaturalProperties getNaturalProperties(int texId, int tileNum) {
        if (texId < 0) {
            return null;
        }
        if (texId == 0) {
            texId = NaturalTextures.renderEngine.terrainTextureId;
        }
        if (texId > propertiesByTex.length) {
            return null;
        }
        NaturalProperties[] propsByTile = propertiesByTex[texId];
        if (propsByTile == null) {
            return null;
        }
        if (tileNum < 0 || tileNum >= propsByTile.length) {
            return null;
        }
        NaturalProperties props = propsByTile[tileNum];
        return props;
    }

    private static NaturalProperties[][] makeDefaultProperties() {
        if (!(NaturalTextures.renderEngine.k.e() instanceof bej)) {
            Config.dbg("NaturalTextures: Texture pack is not default, ignoring default configuration.");
            return new NaturalProperties[0][];
        }
        Config.dbg("Natural Textures: Using default configuration.");
        NaturalProperties[] terrainProps = new NaturalProperties[256];
        terrainProps[0] = new NaturalProperties("4F");
        terrainProps[1] = new NaturalProperties("2F");
        terrainProps[2] = new NaturalProperties("4F");
        terrainProps[3] = new NaturalProperties("F");
        terrainProps[38] = new NaturalProperties("F");
        terrainProps[6] = new NaturalProperties("F");
        terrainProps[17] = new NaturalProperties("2F");
        terrainProps[18] = new NaturalProperties("4F");
        terrainProps[19] = new NaturalProperties("2");
        terrainProps[20] = new NaturalProperties("2F");
        terrainProps[21] = new NaturalProperties("4F");
        terrainProps[32] = new NaturalProperties("2F");
        terrainProps[33] = new NaturalProperties("2F");
        terrainProps[34] = new NaturalProperties("2F");
        terrainProps[50] = new NaturalProperties("2F");
        terrainProps[51] = new NaturalProperties("2F");
        terrainProps[160] = new NaturalProperties("2F");
        terrainProps[37] = new NaturalProperties("4F");
        terrainProps[52] = new NaturalProperties("2F");
        terrainProps[53] = new NaturalProperties("2F");
        terrainProps[196] = new NaturalProperties("2");
        terrainProps[197] = new NaturalProperties("2");
        terrainProps[66] = new NaturalProperties("4F");
        terrainProps[68] = new NaturalProperties("F");
        terrainProps[70] = new NaturalProperties("2F");
        terrainProps[72] = new NaturalProperties("4F");
        terrainProps[77] = new NaturalProperties("F");
        terrainProps[78] = new NaturalProperties("4F");
        terrainProps[86] = new NaturalProperties("2F");
        terrainProps[87] = new NaturalProperties("2F");
        terrainProps[103] = new NaturalProperties("4F");
        terrainProps[104] = new NaturalProperties("4F");
        terrainProps[105] = new NaturalProperties("4");
        terrainProps[116] = new NaturalProperties("2F");
        terrainProps[117] = new NaturalProperties("F");
        terrainProps[132] = new NaturalProperties("2F");
        terrainProps[133] = new NaturalProperties("2F");
        terrainProps[153] = new NaturalProperties("2F");
        terrainProps[175] = new NaturalProperties("4");
        terrainProps[176] = new NaturalProperties("4");
        terrainProps[208] = new NaturalProperties("4F");
        terrainProps[211] = new NaturalProperties("4F");
        terrainProps[212] = new NaturalProperties("4F");
        int terrainTexId = NaturalTextures.renderEngine.terrainTextureId;
        NaturalProperties[][] defPropsByTex = new NaturalProperties[terrainTexId + 1][];
        defPropsByTex[terrainTexId] = terrainProps;
        return defPropsByTex;
    }
}

