/*
 * Decompiled with CFR 0.152.
 */
package person.mister.auw.tileEntity;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import person.mister.auw.BaseMod;
import person.mister.auw.GuiNamedTextField;
import person.mister.auw.tileEntity.GuiEditTileEntity;

public class GuiEditSkull
extends GuiEditTileEntity {
    private int addX;
    private int addY;
    private GuiScreen parent;
    private TileEntitySkull skull;
    private String name;
    private GuiNamedTextField nameField;
    private GuiButton typeButton;
    private int type;
    private String[] types = new String[]{"Skeleton", "Wither", "Zombie", "Player", "Creeper", "Skeleton 2"};
    private String[] directions = new String[]{"North", "North-Northeast", "Northeast", "East-Northeast", "East", "East-Southeast", "Southeast", "South-Southeast", "South", "South-Southwest", "Southwest", "West-Southwest", "West", "West-Northwest", "Northwest", "North-Northwest"};
    private GuiButton rotButton;
    private GuiButton dataButton;
    private int rot;
    private int metadata;
    private boolean rPress;
    private boolean click;

    public GuiEditSkull(GuiScreen parent, TileEntity skull) {
        this.skull = (TileEntitySkull)skull;
        this.parent = parent;
        if (skull == null) {
            skull = new TileEntitySkull();
        }
        if (Minecraft.func_71410_x().field_71441_e.func_147438_o(skull.field_145851_c, skull.field_145848_d, skull.field_145849_e) == null) {
            if (BaseMod.instance.getEntityMouseOver() != null && BaseMod.instance.getEntityMouseOver().field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                MovingObjectPosition block = BaseMod.instance.getEntityMouseOver();
                ((TileEntitySkull)skull).func_145903_a(this.getRotation(block));
                this.metadata = block.field_72310_e;
            }
        } else {
            this.metadata = Minecraft.func_71410_x().field_71441_e.func_72805_g(skull.field_145851_c, skull.field_145848_d, skull.field_145849_e);
        }
        NBTTagCompound tags = new NBTTagCompound();
        skull.func_145841_b(tags);
        GameProfile gameprofile = null;
        if (tags.func_150297_b("Owner", 10)) {
            gameprofile = NBTUtil.func_152459_a((NBTTagCompound)tags.func_74775_l("Owner"));
        } else if (tags.func_150297_b("SkullOwner", 8) && tags.func_74779_i("SkullOwner").length() > 0) {
            gameprofile = new GameProfile((UUID)null, tags.func_74779_i("SkullOwner"));
        }
        this.name = gameprofile != null ? gameprofile.getName() : null;
        this.type = tags.func_74771_c("SkullType");
        this.rot = tags.func_74771_c("Rot");
    }

    private int getRotation(MovingObjectPosition block) {
        if (block.field_72310_e == 1) {
            ++block.field_72312_c;
        }
        if (block.field_72310_e == 2) {
            --block.field_72309_d;
        }
        if (block.field_72310_e == 3) {
            ++block.field_72309_d;
        }
        if (block.field_72310_e == 4) {
            --block.field_72311_b;
        }
        if (block.field_72310_e == 5) {
            ++block.field_72311_b;
        }
        int i1 = 0;
        if (block.field_72310_e == 1) {
            i1 = MathHelper.func_76128_c((double)((double)(Minecraft.func_71410_x().field_71439_g.field_70177_z * 16.0f / 360.0f) + 0.5)) & 0xF;
        }
        return i1;
    }

    @Override
    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.textFields.clear();
        super.func_73866_w_();
        this.addX = this.field_146294_l / 2 - 160;
        this.addY = this.field_146295_m / 2 - 120;
        this.rPress = false;
        this.click = false;
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 - 52, this.field_146295_m - this.addY - 22, 50, 20, "Save"));
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 + 2, this.field_146295_m - this.addY - 22, 50, 20, "Cancel"));
        this.nameField = new GuiNamedTextField(this.field_146289_q, this.field_146294_l / 2 - 60, this.addY + 30, 120, 10, "Player Name");
        if (this.name != null) {
            this.nameField.func_146180_a(this.name);
        }
        this.textFields.add(this.nameField);
        this.nameField.func_146184_c(this.type == 3);
        this.typeButton = new GuiButton(2, this.field_146294_l / 2 - 60, this.addY + 55, 120, 20, this.types[this.type] + " (" + this.type + ")");
        this.rotButton = new GuiButton(3, this.field_146294_l / 2 - 60, this.addY + 80, 120, 20, this.directions[this.rot] + " (" + this.rot + ")");
        this.dataButton = new GuiButton(4, this.field_146294_l / 2 - 60, this.addY + 105, 120, 20, "Metadata*: " + this.metadata);
        this.field_146292_n.add(this.typeButton);
        this.field_146292_n.add(this.rotButton);
        this.field_146292_n.add(this.dataButton);
        this.colorButton(this.addX + 225, this.addY + 25);
    }

    @Override
    public void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        if (button.field_146127_k == 0) {
            this.updateTable();
            this.save();
            this.field_146297_k.func_147108_a(this.parent);
        } else if (button.field_146127_k == 1) {
            this.field_146297_k.func_147108_a(this.parent);
        } else if (button.field_146127_k == 2) {
            ++this.type;
            if (this.type >= 6) {
                this.type = 0;
            }
            this.nameField.func_146184_c(this.type == 3);
            this.typeButton.field_146126_j = this.types[this.type] + " (" + this.type + ")";
        } else if (button.field_146127_k == 3) {
            ++this.rot;
            if (this.rot > 15) {
                this.rot = 0;
            }
            this.rotButton.field_146126_j = this.directions[this.rot] + " (" + this.rot + ")";
        } else if (button.field_146127_k == 4) {
            ++this.metadata;
            if (this.metadata > 7) {
                this.metadata = 0;
            }
            this.dataButton.field_146126_j = "Metadata*: " + this.metadata;
        }
    }

    @Override
    public void func_73869_a(char key, int keyCode) {
        super.func_73869_a(key, keyCode);
        this.name = this.nameField.func_146179_b().isEmpty() ? null : this.nameField.func_146179_b();
        if (keyCode == BaseMod.proxy.keyCode) {
            this.rPress = true;
        }
    }

    @Override
    public void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        if (button == 0) {
            this.click = true;
        }
        if (!this.nameField.getEnabled()) {
            this.nameField.func_146195_b(false);
        }
    }

    @Override
    public void func_73863_a(int x, int y, float par) {
        this.func_146276_q_();
        if (BaseMod.debugMode) {
            GuiEditSkull.func_73734_a((int)this.addX, (int)this.addY, (int)(this.field_146294_l - this.addX), (int)(this.field_146295_m - this.addY), (int)-2005401788);
        }
        super.func_73863_a(x, y, par);
    }

    public void updateTable() {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74778_a("id", "EnchantTable");
        tags.func_74768_a("x", this.skull.field_145851_c);
        tags.func_74768_a("y", this.skull.field_145848_d);
        tags.func_74768_a("z", this.skull.field_145849_e);
        if (this.name != null && !this.name.isEmpty()) {
            tags.func_74778_a("ExtraType", this.name);
        }
        tags.func_74774_a("SkullType", (byte)this.type);
        tags.func_74774_a("Rot", (byte)this.rot);
        this.skull = new TileEntitySkull();
        this.skull.func_145839_a(tags);
    }

    @Override
    public TileEntity getTileEntity() {
        return this.skull;
    }

    @Override
    public void save() {
    }

    @Override
    public int getBlockID() {
        return 144;
    }

    @Override
    public int getMetadata() {
        return this.metadata;
    }
}

