/*
 * Decompiled with CFR 0.152.
 */
package person.mister.auw;

import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.StatCollector;
import person.mister.auw.GuiNamedTextField;
import person.mister.auw.GuiScrollBox;
import person.mister.auw.GuiWithTextBoxes;

public class GuiChoosePotions
extends GuiWithTextBoxes {
    private GuiScreen parent;
    private NBTTagCompound tags;
    private GuiScrollBox potionListBox;
    private GuiScrollBox potionsChosenBox;
    private GuiTextField amplifier;
    private GuiTextField duration;
    private boolean formatError;
    private String tagName;
    private boolean ticks;
    private boolean ambient = false;
    private int addX;
    private int addY;
    public ArrayList<PotionEffect> potions = new ArrayList();

    public GuiChoosePotions(NBTTagCompound tags, String tagName, GuiScreen parent) {
        this.parent = parent;
        this.tags = tags;
        this.tagName = tagName;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.textFields.clear();
        this.addX = this.field_146294_l / 2 - 160;
        this.addY = this.field_146295_m / 2 - 120;
        if (this.tags.func_74764_b(this.tagName)) {
            NBTTagList effects = this.tags.func_150295_c(this.tagName, 10);
            for (int i = 0; i < effects.func_74745_c(); ++i) {
                byte id = effects.func_150305_b(i).func_74771_c("Id");
                byte strength = effects.func_150305_b(i).func_74771_c("Amplifier");
                int length = effects.func_150305_b(i).func_74762_e("Duration");
                boolean ambient = effects.func_150305_b(i).func_74767_n("Ambient");
                this.potions.add(new PotionEffect((int)id, length, (int)strength, ambient));
            }
        }
        this.field_146292_n.add(new GuiButton(7200, this.field_146294_l / 2 - 50, this.field_146295_m - this.addY - 20, 100, 20, "Save"));
        this.potionListBox = new GuiScrollBox(this.addX + 0, this.addY + 30, 100, 210, 23, 75, 9){

            @Override
            public void drawElement(int index, int xOffset, int yOffset) {
                try {
                    this.func_73731_b(GuiChoosePotions.this.field_146289_q, StatCollector.func_74838_a((String)Potion.field_76425_a[index + 1].func_76393_a()), this.xPosition + xOffset + 2, this.yPosition + yOffset + 1, 0xFFFFFF);
                }
                catch (Exception e) {
                    this.func_73731_b(GuiChoosePotions.this.field_146289_q, "ERROR", this.xPosition + xOffset, this.yPosition + yOffset, 0xFF0000);
                }
            }

            @Override
            public void moveElement(int from, int to) {
            }
        };
        this.potionsChosenBox = new GuiScrollBox(this.addX + 105, this.addY + 30, 215, 185, this.potions.size(), 190, 12){

            @Override
            public void drawElement(int index, int xOffset, int yOffset) {
                try {
                    if (GuiChoosePotions.this.ticks) {
                        this.func_73731_b(GuiChoosePotions.this.field_146289_q, StatCollector.func_74838_a((String)GuiChoosePotions.this.potions.get(index).func_76453_d()) + " " + (GuiChoosePotions.this.potions.get(index).func_76458_c() + 1) + " For " + GuiChoosePotions.this.potions.get(index).func_76459_b() + " Ticks, Ambient: " + GuiChoosePotions.this.potions.get(index).func_82720_e(), this.xPosition + xOffset + 2, this.yPosition + yOffset + 2, 0xFFFFFF);
                    } else {
                        this.func_73731_b(GuiChoosePotions.this.field_146289_q, StatCollector.func_74838_a((String)GuiChoosePotions.this.potions.get(index).func_76453_d()) + " " + (GuiChoosePotions.this.potions.get(index).func_76458_c() + 1) + " " + Potion.func_76389_a((PotionEffect)GuiChoosePotions.this.potions.get(index)) + " Ambient: " + GuiChoosePotions.this.potions.get(index).func_82720_e(), this.xPosition + xOffset + 2, this.yPosition + yOffset + 2, 0xFFFFFF);
                    }
                }
                catch (Exception e) {
                    this.func_73731_b(GuiChoosePotions.this.field_146289_q, "ERROR", this.xPosition + xOffset, this.yPosition + yOffset, 0xFF0000);
                }
            }

            @Override
            public void moveElement(int from, int to) {
                PotionEffect temp = GuiChoosePotions.this.potions.get(from);
                GuiChoosePotions.this.potions.remove(from);
                GuiChoosePotions.this.potions.add(to, temp);
            }
        };
        this.potionListBox.selected = 0;
        this.potionsChosenBox.selected = 0;
        this.amplifier = new GuiNamedTextField(this.field_146289_q, this.addX + 1, this.addY + 13, 50, 10, "Strength");
        this.duration = new GuiNamedTextField(this.field_146289_q, this.addX + 56, this.addY + 13, 50, 10, "Duration");
        this.amplifier.func_146180_a("1");
        this.duration.func_146180_a("0:50");
        this.textFields.add(this.amplifier);
        this.textFields.add(this.duration);
        this.ambient = false;
        this.field_146292_n.add(new GuiButton(7205, this.addX + 108, this.addY + 5, 62, 20, "Ambient: No"));
        this.field_146292_n.add(new GuiButton(7201, this.addX + 220, this.addY + 5, 25, 20, "Add"));
        this.field_146292_n.add(new GuiButton(7202, this.addX + 247, this.addY + 5, 41, 20, "Remove"));
        this.field_146292_n.add(new GuiButton(7203, this.addX + 290, this.addY + 5, 30, 20, "Edit"));
        this.ticks = false;
        this.field_146292_n.add(new GuiButton(7204, this.addX + 182, this.addY + 5, 30, 20, this.ticks ? "ticks" : "time"));
        this.getButtonFromId((int)7202).field_146124_l = this.potions.size() != 0;
        this.getButtonFromId((int)7203).field_146124_l = this.potions.size() != 0;
        super.func_73866_w_();
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k == 7200) {
                this.save(this.tags);
                this.field_146297_k.func_147108_a(this.parent);
            } else if (button.field_146127_k == 7201) {
                try {
                    this.potions.add(new PotionEffect(this.potionListBox.selected + 1, this.parseTime(this.duration.func_146179_b()), Byte.parseByte(this.amplifier.func_146179_b()) - 1, this.ambient));
                    this.formatError = false;
                    this.potionsChosenBox.add();
                    this.getButtonFromId((int)7202).field_146124_l = true;
                    this.getButtonFromId((int)7203).field_146124_l = true;
                }
                catch (Exception e) {
                    if (!this.formatError) {
                        e.printStackTrace();
                    }
                    this.formatError = true;
                }
            } else if (button.field_146127_k == 7202) {
                this.potions.remove(this.potionsChosenBox.selected);
                this.potionsChosenBox.remove();
                if (this.potions.size() == 0) {
                    button.field_146124_l = false;
                    this.getButtonFromId((int)7203).field_146124_l = false;
                }
            } else if (button.field_146127_k == 7203) {
                if (button.field_146126_j.equals("Edit")) {
                    this.amplifier.func_146180_a("" + (this.potions.get(this.potionsChosenBox.selected).func_76458_c() + 1));
                    if (this.ticks) {
                        this.duration.func_146180_a("" + this.potions.get(this.potionsChosenBox.selected).func_76459_b());
                    } else {
                        int dur = this.potions.get(this.potionsChosenBox.selected).func_76459_b();
                        this.duration.func_146180_a("" + dur / 1200 + ":" + dur / 20 % 60);
                    }
                    this.potionListBox.selected = this.potions.get(this.potionsChosenBox.selected).func_76456_a() - 1;
                    this.ambient = this.potions.get(this.potionsChosenBox.selected).func_82720_e();
                    this.getButtonFromId((int)7205).field_146126_j = "Ambient: " + (this.ambient ? "Yes" : "No");
                    button.field_146126_j = "Done";
                } else {
                    try {
                        PotionEffect effect = new PotionEffect(this.potionListBox.selected + 1, this.parseTime(this.duration.func_146179_b()), Byte.parseByte(this.amplifier.func_146179_b()) - 1, this.ambient);
                        this.potions.remove(this.potionsChosenBox.selected);
                        this.potions.add(this.potionsChosenBox.selected, effect);
                        button.field_146126_j = "Edit";
                        this.formatError = false;
                    }
                    catch (Exception e) {
                        if (!this.formatError) {
                            e.printStackTrace();
                        }
                        this.formatError = true;
                    }
                }
            } else if (button.field_146127_k == 7204) {
                this.ticks = !this.ticks;
                String string = button.field_146126_j = this.ticks ? "ticks" : "time";
                if (this.ticks) {
                    try {
                        this.duration.func_146180_a("" + this.parseTime(this.duration.func_146179_b()));
                    }
                    catch (Exception e) {}
                } else {
                    try {
                        int dur = this.parseTime(this.duration.func_146179_b());
                        this.duration.func_146180_a("" + dur / 1200 + ":" + dur / 20 % 60);
                    }
                    catch (Exception exception) {}
                }
            } else if (button.field_146127_k == 7205) {
                this.ambient = !this.ambient;
                button.field_146126_j = "Ambient: " + (this.ambient ? "Yes" : "No");
            }
        }
        super.func_146284_a(button);
    }

    @Override
    public void func_73863_a(int par1, int par2, float par3) {
        this.func_146276_q_();
        super.func_73863_a(par1, par2, par3);
        this.potionsChosenBox.draw(par1, par2);
        this.potionListBox.draw(par1, par2);
        this.potionsChosenBox.update(par1, par2);
        this.potionListBox.update(par1, par2);
        if (this.formatError) {
            this.func_73732_a(this.field_146289_q, "One of the numbers is formated wrong.", this.field_146294_l / 2, this.field_146295_m - 30, 0xFFAAAA);
        }
    }

    @Override
    protected void func_73864_a(int x, int y, int button) {
        this.potionsChosenBox.mouseClick(x, y);
        this.potionListBox.mouseClick(x, y);
        super.func_73864_a(x, y, button);
    }

    private NBTTagCompound save(NBTTagCompound tagCompound) {
        if (!this.potions.isEmpty()) {
            NBTTagList list = new NBTTagList();
            for (PotionEffect effect : this.potions) {
                NBTTagCompound tags = new NBTTagCompound();
                tags.func_74774_a("Id", (byte)effect.func_76456_a());
                tags.func_74774_a("Amplifier", (byte)effect.func_76458_c());
                tags.func_74768_a("Duration", effect.func_76459_b());
                tags.func_74757_a("Ambient", effect.func_82720_e());
                boolean test = this.ambient;
                list.func_74742_a((NBTBase)tags);
            }
            tagCompound.func_74782_a(this.tagName, (NBTBase)list);
        }
        return tagCompound;
    }

    private int parseTime(String time) throws NumberFormatException {
        if (time.indexOf(58) == -1) {
            return Integer.parseInt(time);
        }
        String[] list = time.split(":", 2);
        return (list[0].isEmpty() ? 0 : Integer.parseInt(list[0])) * 1200 + (list[1].isEmpty() ? 0 : Integer.parseInt(list[1])) * 20;
    }
}

