/*
	Copyright (c) 2004-2012, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is an optimized version of Dojo, built for deployment and not for
	development. To get sources and documentation, please visit:

		http://dojotoolkit.org
*/

//>>built
require({cache:{"dojo/i18n":function(){
define(["./_base/kernel","require","./has","./_base/array","./_base/config","./_base/lang","./_base/xhr","./json","module"],function(_1,_2,_3,_4,_5,_6,_7,_8,_9){
_3.add("dojo-preload-i18n-Api",1);
1||_3.add("dojo-v1x-i18n-Api",1);
var _a=_1.i18n={},_b=/(^.*(^|\/)nls)(\/|$)([^\/]*)\/?([^\/]*)/,_c=function(_d,_e,_f,_10){
for(var _11=[_f+_10],_12=_e.split("-"),_13="",i=0;i<_12.length;i++){
_13+=(_13?"-":"")+_12[i];
if(!_d||_d[_13]){
_11.push(_f+_13+"/"+_10);
}
}
return _11;
},_14={},_15=function(_16,_17,_18){
_18=_18?_18.toLowerCase():_1.locale;
_16=_16.replace(/\./g,"/");
_17=_17.replace(/\./g,"/");
return (/root/i.test(_18))?(_16+"/nls/"+_17):(_16+"/nls/"+_18+"/"+_17);
},_19=_1.getL10nName=function(_1a,_1b,_1c){
return _1a=_9.id+"!"+_15(_1a,_1b,_1c);
},_1d=function(_1e,_1f,_20,_21,_22,_23){
_1e([_1f],function(_24){
var _25=_6.clone(_24.root),_26=_c(!_24._v1x&&_24,_22,_20,_21);
_1e(_26,function(){
for(var i=1;i<_26.length;i++){
_25=_6.mixin(_6.clone(_25),arguments[i]);
}
var _27=_1f+"/"+_22;
_14[_27]=_25;
_23();
});
});
},_28=function(id,_29){
return /^\./.test(id)?_29(id):id;
},_2a=function(_2b){
var _2c=_5.extraLocale||[];
_2c=_6.isArray(_2c)?_2c:[_2c];
_2c.push(_2b);
return _2c;
},_2d=function(id,_2e,_2f){
if(_3("dojo-preload-i18n-Api")){
var _30=id.split("*"),_31=_30[1]=="preload";
if(_31){
if(!_14[id]){
_14[id]=1;
_32(_30[2],_8.parse(_30[3]),1,_2e);
}
_2f(1);
}
if(_31||_33(id,_2e,_2f)){
return;
}
}
var _34=_b.exec(id),_35=_34[1]+"/",_36=_34[5]||_34[4],_37=_35+_36,_38=(_34[5]&&_34[4]),_39=_38||_1.locale,_3a=_37+"/"+_39,_3b=_38?[_39]:_2a(_39),_3c=_3b.length,_3d=function(){
if(!--_3c){
_2f(_6.delegate(_14[_3a]));
}
};
_4.forEach(_3b,function(_3e){
var _3f=_37+"/"+_3e;
if(_3("dojo-preload-i18n-Api")){
_40(_3f);
}
if(!_14[_3f]){
_1d(_2e,_37,_35,_36,_3e,_3d);
}else{
_3d();
}
});
};
if(_3("dojo-unit-tests")){
var _41=_a.unitTests=[];
}
if(_3("dojo-preload-i18n-Api")||1){
var _42=_a.normalizeLocale=function(_43){
var _44=_43?_43.toLowerCase():_1.locale;
return _44=="root"?"ROOT":_44;
},_45=function(mid,_46){
return (1&&1)?_46.isXdUrl(_2.toUrl(mid+".js")):true;
},_47=0,_48=[],_32=_a._preloadLocalizations=function(_49,_4a,_4b,_4c){
_4c=_4c||_2;
function _4d(mid,_4e){
if(_45(mid,_4c)||_4b){
_4c([mid],_4e);
}else{
_5a([mid],_4e,_4c);
}
};
function _4f(_50,_51){
var _52=_50.split("-");
while(_52.length){
if(_51(_52.join("-"))){
return;
}
_52.pop();
}
_51("ROOT");
};
function _53(_54){
_54=_42(_54);
_4f(_54,function(loc){
if(_4.indexOf(_4a,loc)>=0){
var mid=_49.replace(/\./g,"/")+"_"+loc;
_47++;
_4d(mid,function(_55){
for(var p in _55){
_14[_2.toAbsMid(p)+"/"+loc]=_55[p];
}
--_47;
while(!_47&&_48.length){
_2d.apply(null,_48.shift());
}
});
return true;
}
return false;
});
};
_53();
_4.forEach(_1.config.extraLocale,_53);
},_33=function(id,_56,_57){
if(_47){
_48.push([id,_56,_57]);
}
return _47;
},_40=function(){
};
}
if(1){
var _58={},_59=new Function("__bundle","__checkForLegacyModules","__mid","__amdValue","var define = function(mid, factory){define.called = 1; __amdValue.result = factory || mid;},"+"\t   require = function(){define.called = 1;};"+"try{"+"define.called = 0;"+"eval(__bundle);"+"if(define.called==1)"+"return __amdValue;"+"if((__checkForLegacyModules = __checkForLegacyModules(__mid)))"+"return __checkForLegacyModules;"+"}catch(e){}"+"try{"+"return eval('('+__bundle+')');"+"}catch(e){"+"return e;"+"}"),_5a=function(_5b,_5c,_5d){
var _5e=[];
_4.forEach(_5b,function(mid){
var url=_5d.toUrl(mid+".js");
function _2d(_5f){
var _60=_59(_5f,_40,mid,_58);
if(_60===_58){
_5e.push(_14[url]=_58.result);
}else{
if(_60 instanceof Error){
console.error("failed to evaluate i18n bundle; url="+url,_60);
_60={};
}
_5e.push(_14[url]=(/nls\/[^\/]+\/[^\/]+$/.test(url)?_60:{root:_60,_v1x:1}));
}
};
if(_14[url]){
_5e.push(_14[url]);
}else{
var _61=_5d.syncLoadNls(mid);
if(_61){
_5e.push(_61);
}else{
if(!_7){
try{
_5d.getText(url,true,_2d);
}
catch(e){
_5e.push(_14[url]={});
}
}else{
_7.get({url:url,sync:true,load:_2d,error:function(){
_5e.push(_14[url]={});
}});
}
}
}
});
_5c&&_5c.apply(null,_5e);
};
_40=function(_62){
for(var _63,_64=_62.split("/"),_65=_1.global[_64[0]],i=1;_65&&i<_64.length-1;_65=_65[_64[i++]]){
}
if(_65){
_63=_65[_64[i]];
if(!_63){
_63=_65[_64[i].replace(/-/g,"_")];
}
if(_63){
_14[_62]=_63;
}
}
return _63;
};
_a.getLocalization=function(_66,_67,_68){
var _69,_6a=_15(_66,_67,_68);
_2d(_6a,(!_45(_6a,_2)?function(_6b,_6c){
_5a(_6b,_6c,_2);
}:_2),function(_6d){
_69=_6d;
});
return _69;
};
if(_3("dojo-unit-tests")){
_41.push(function(doh){
doh.register("tests.i18n.unit",function(t){
var _6e;
_6e=_59("{prop:1}",_40,"nonsense",_58);
t.is({prop:1},_6e);
t.is(undefined,_6e[1]);
_6e=_59("({prop:1})",_40,"nonsense",_58);
t.is({prop:1},_6e);
t.is(undefined,_6e[1]);
_6e=_59("{'prop-x':1}",_40,"nonsense",_58);
t.is({"prop-x":1},_6e);
t.is(undefined,_6e[1]);
_6e=_59("({'prop-x':1})",_40,"nonsense",_58);
t.is({"prop-x":1},_6e);
t.is(undefined,_6e[1]);
_6e=_59("define({'prop-x':1})",_40,"nonsense",_58);
t.is(_58,_6e);
t.is({"prop-x":1},_58.result);
_6e=_59("define('some/module', {'prop-x':1})",_40,"nonsense",_58);
t.is(_58,_6e);
t.is({"prop-x":1},_58.result);
_6e=_59("this is total nonsense and should throw an error",_40,"nonsense",_58);
t.is(_6e instanceof Error,true);
});
});
}
}
return _6.mixin(_a,{dynamic:true,normalize:_28,load:_2d,cache:_14});
});
},"dijit/popup":function(){
define("dijit/popup",["dojo/_base/array","dojo/aspect","dojo/_base/connect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/_base/event","dojo/keys","dojo/_base/lang","dojo/on","dojo/sniff","./place","./BackgroundIframe","./main"],function(_6f,_70,_71,_72,dom,_73,_74,_75,_76,_77,_78,_79,on,has,_7a,_7b,_7c){
function _7d(){
if(this._popupWrapper){
_74.destroy(this._popupWrapper);
delete this._popupWrapper;
}
};
var _7e=_72(null,{_stack:[],_beginZIndex:1000,_idGen:1,_createWrapper:function(_7f){
var _80=_7f._popupWrapper,_81=_7f.domNode;
if(!_80){
_80=_74.create("div",{"class":"dijitPopup",style:{display:"none"},role:"presentation"},_7f.ownerDocumentBody);
_80.appendChild(_81);
var s=_81.style;
s.display="";
s.visibility="";
s.position="";
s.top="0px";
_7f._popupWrapper=_80;
_70.after(_7f,"destroy",_7d,true);
}
return _80;
},moveOffScreen:function(_82){
var _83=this._createWrapper(_82);
_76.set(_83,{visibility:"hidden",top:"-9999px",display:""});
},hide:function(_84){
var _85=this._createWrapper(_84);
_76.set(_85,"display","none");
},getTopPopup:function(){
var _86=this._stack;
for(var pi=_86.length-1;pi>0&&_86[pi].parent===_86[pi-1].widget;pi--){
}
return _86[pi];
},open:function(_87){
var _88=this._stack,_89=_87.popup,_8a=_87.orient||["below","below-alt","above","above-alt"],ltr=_87.parent?_87.parent.isLeftToRight():_75.isBodyLtr(_89.ownerDocument),_8b=_87.around,id=(_87.around&&_87.around.id)?(_87.around.id+"_dropdown"):("popup_"+this._idGen++);
while(_88.length&&(!_87.parent||!dom.isDescendant(_87.parent.domNode,_88[_88.length-1].widget.domNode))){
this.close(_88[_88.length-1].widget);
}
var _8c=this._createWrapper(_89);
_73.set(_8c,{id:id,style:{zIndex:this._beginZIndex+_88.length},"class":"dijitPopup "+(_89.baseClass||_89["class"]||"").split(" ")[0]+"Popup",dijitPopupParent:_87.parent?_87.parent.id:""});
if(has("ie")||has("mozilla")){
if(!_89.bgIframe){
_89.bgIframe=new _7b(_8c);
}
}
var _8d=_8b?_7a.around(_8c,_8b,_8a,ltr,_89.orient?_79.hitch(_89,"orient"):null):_7a.at(_8c,_87,_8a=="R"?["TR","BR","TL","BL"]:["TL","BL","TR","BR"],_87.padding);
_8c.style.display="";
_8c.style.visibility="visible";
_89.domNode.style.visibility="visible";
var _8e=[];
_8e.push(on(_8c,_71._keypress,_79.hitch(this,function(evt){
if(evt.charOrCode==_78.ESCAPE&&_87.onCancel){
_77.stop(evt);
_87.onCancel();
}else{
if(evt.charOrCode===_78.TAB){
_77.stop(evt);
var _8f=this.getTopPopup();
if(_8f&&_8f.onCancel){
_8f.onCancel();
}
}
}
})));
if(_89.onCancel&&_87.onCancel){
_8e.push(_89.on("cancel",_87.onCancel));
}
_8e.push(_89.on(_89.onExecute?"execute":"change",_79.hitch(this,function(){
var _90=this.getTopPopup();
if(_90&&_90.onExecute){
_90.onExecute();
}
})));
_88.push({widget:_89,parent:_87.parent,onExecute:_87.onExecute,onCancel:_87.onCancel,onClose:_87.onClose,handlers:_8e});
if(_89.onOpen){
_89.onOpen(_8d);
}
return _8d;
},close:function(_91){
var _92=this._stack;
while((_91&&_6f.some(_92,function(_93){
return _93.widget==_91;
}))||(!_91&&_92.length)){
var top=_92.pop(),_94=top.widget,_95=top.onClose;
if(_94.onClose){
_94.onClose();
}
var h;
while(h=top.handlers.pop()){
h.remove();
}
if(_94&&_94.domNode){
this.hide(_94);
}
if(_95){
_95();
}
}
}});
return (_7c.popup=new _7e());
});
},"dojo/string":function(){
define(["./_base/kernel","./_base/lang"],function(_96,_97){
var _98={};
_97.setObject("dojo.string",_98);
_98.rep=function(str,num){
if(num<=0||!str){
return "";
}
var buf=[];
for(;;){
if(num&1){
buf.push(str);
}
if(!(num>>=1)){
break;
}
str+=str;
}
return buf.join("");
};
_98.pad=function(_99,_9a,ch,end){
if(!ch){
ch="0";
}
var out=String(_99),pad=_98.rep(ch,Math.ceil((_9a-out.length)/ch.length));
return end?out+pad:pad+out;
};
_98.substitute=function(_9b,map,_9c,_9d){
_9d=_9d||_96.global;
_9c=_9c?_97.hitch(_9d,_9c):function(v){
return v;
};
return _9b.replace(/\$\{([^\s\:\}]+)(?:\:([^\s\:\}]+))?\}/g,function(_9e,key,_9f){
var _a0=_97.getObject(key,false,map);
if(_9f){
_a0=_97.getObject(_9f,false,_9d).call(_9d,_a0,key);
}
return _9c(_a0,key).toString();
});
};
_98.trim=String.prototype.trim?_97.trim:function(str){
str=str.replace(/^\s+/,"");
for(var i=str.length-1;i>=0;i--){
if(/\S/.test(str.charAt(i))){
str=str.substring(0,i+1);
break;
}
}
return str;
};
return _98;
});
},"dijit/a11y":function(){
define("dijit/a11y",["dojo/_base/array","dojo/_base/config","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-style","dojo/sniff","./main"],function(_a1,_a2,_a3,dom,_a4,_a5,has,_a6){
var _a7=(_a6._isElementShown=function(_a8){
var s=_a5.get(_a8);
return (s.visibility!="hidden")&&(s.visibility!="collapsed")&&(s.display!="none")&&(_a4.get(_a8,"type")!="hidden");
});
_a6.hasDefaultTabStop=function(_a9){
switch(_a9.nodeName.toLowerCase()){
case "a":
return _a4.has(_a9,"href");
case "area":
case "button":
case "input":
case "object":
case "select":
case "textarea":
return true;
case "iframe":
var _aa;
try{
var _ab=_a9.contentDocument;
if("designMode" in _ab&&_ab.designMode=="on"){
return true;
}
_aa=_ab.body;
}
catch(e1){
try{
_aa=_a9.contentWindow.document.body;
}
catch(e2){
return false;
}
}
return _aa&&(_aa.contentEditable=="true"||(_aa.firstChild&&_aa.firstChild.contentEditable=="true"));
default:
return _a9.contentEditable=="true";
}
};
var _ac=(_a6.isTabNavigable=function(_ad){
if(_a4.get(_ad,"disabled")){
return false;
}else{
if(_a4.has(_ad,"tabIndex")){
return _a4.get(_ad,"tabIndex")>=0;
}else{
return _a6.hasDefaultTabStop(_ad);
}
}
});
_a6._getTabNavigable=function(_ae){
var _af,_b0,_b1,_b2,_b3,_b4,_b5={};
function _b6(_b7){
return _b7&&_b7.tagName.toLowerCase()=="input"&&_b7.type&&_b7.type.toLowerCase()=="radio"&&_b7.name&&_b7.name.toLowerCase();
};
var _b8=function(_b9){
for(var _ba=_b9.firstChild;_ba;_ba=_ba.nextSibling){
if(_ba.nodeType!=1||(has("ie")<=9&&_ba.scopeName!=="HTML")||!_a7(_ba)){
continue;
}
if(_ac(_ba)){
var _bb=+_a4.get(_ba,"tabIndex");
if(!_a4.has(_ba,"tabIndex")||_bb==0){
if(!_af){
_af=_ba;
}
_b0=_ba;
}else{
if(_bb>0){
if(!_b1||_bb<_b2){
_b2=_bb;
_b1=_ba;
}
if(!_b3||_bb>=_b4){
_b4=_bb;
_b3=_ba;
}
}
}
var rn=_b6(_ba);
if(_a4.get(_ba,"checked")&&rn){
_b5[rn]=_ba;
}
}
if(_ba.nodeName.toUpperCase()!="SELECT"){
_b8(_ba);
}
}
};
if(_a7(_ae)){
_b8(_ae);
}
function rs(_bc){
return _b5[_b6(_bc)]||_bc;
};
return {first:rs(_af),last:rs(_b0),lowest:rs(_b1),highest:rs(_b3)};
};
_a6.getFirstInTabbingOrder=function(_bd,doc){
var _be=_a6._getTabNavigable(dom.byId(_bd,doc));
return _be.lowest?_be.lowest:_be.first;
};
_a6.getLastInTabbingOrder=function(_bf,doc){
var _c0=_a6._getTabNavigable(dom.byId(_bf,doc));
return _c0.last?_c0.last:_c0.highest;
};
return {hasDefaultTabStop:_a6.hasDefaultTabStop,isTabNavigable:_a6.isTabNavigable,_getTabNavigable:_a6._getTabNavigable,getFirstInTabbingOrder:_a6.getFirstInTabbingOrder,getLastInTabbingOrder:_a6.getLastInTabbingOrder};
});
},"dijit/form/Select":function(){
require({cache:{"url:dijit/form/templates/Select.html":"<table class=\"dijit dijitReset dijitInline dijitLeft\"\n\tdata-dojo-attach-point=\"_buttonNode,tableNode,focusNode\" cellspacing='0' cellpadding='0'\n\trole=\"listbox\" aria-haspopup=\"true\"\n\t><tbody role=\"presentation\"><tr role=\"presentation\"\n\t\t><td class=\"dijitReset dijitStretch dijitButtonContents\" role=\"presentation\"\n\t\t\t><div class=\"dijitReset dijitInputField dijitButtonText\"  data-dojo-attach-point=\"containerNode,_popupStateNode\" role=\"presentation\"></div\n\t\t\t><div class=\"dijitReset dijitValidationContainer\"\n\t\t\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t\t/></div\n\t\t\t><input type=\"hidden\" ${!nameAttrSetting} data-dojo-attach-point=\"valueNode\" value=\"${value}\" aria-hidden=\"true\"\n\t\t/></td\n\t\t><td class=\"dijitReset dijitRight dijitButtonNode dijitArrowButton dijitDownArrowButton dijitArrowButtonContainer\"\n\t\t\tdata-dojo-attach-point=\"titleNode\" role=\"presentation\"\n\t\t\t><input class=\"dijitReset dijitInputField dijitArrowButtonInner\" value=\"&#9660; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t\t\t${_buttonInputDisabled}\n\t\t/></td\n\t></tr></tbody\n></table>\n"}});
define("dijit/form/Select",["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/dom-class","dojo/dom-geometry","dojo/_base/event","dojo/i18n","dojo/_base/lang","dojo/sniff","./_FormSelectWidget","../_HasDropDown","../Menu","../MenuItem","../MenuSeparator","../Tooltip","dojo/text!./templates/Select.html","dojo/i18n!./nls/validate"],function(_c1,_c2,_c3,_c4,_c5,_c6,_c7,_c8,has,_c9,_ca,_cb,_cc,_cd,_ce,_cf){
var _d0=_c2("dijit.form._SelectMenu",_cb,{autoFocus:true,buildRendering:function(){
this.inherited(arguments);
var o=(this.menuTableNode=this.domNode);
var n=(this.domNode=this.ownerDocument.createElement("div"));
n.style.cssText="overflow-x: hidden; overflow-y: scroll";
if(o.parentNode){
o.parentNode.replaceChild(n,o);
}
_c4.remove(o,"dijitMenuTable");
n.className=o.className+" dijitSelectMenu";
o.className="dijitReset dijitMenuTable";
o.setAttribute("role","listbox");
n.setAttribute("role","presentation");
n.appendChild(o);
},postCreate:function(){
this.inherited(arguments);
this.connect(this.domNode,"onselectstart",_c6.stop);
},focus:function(){
var _d1=false,val=this.parentWidget.value;
if(_c8.isArray(val)){
val=val[val.length-1];
}
if(val){
_c1.forEach(this.parentWidget._getChildren(),function(_d2){
if(_d2.option&&(val===_d2.option.value)){
_d1=true;
this.focusChild(_d2,false);
}
},this);
}
if(!_d1){
this.inherited(arguments);
}
},resize:function(mb){
if(mb){
_c5.setMarginBox(this.domNode,mb);
if("w" in mb){
this.menuTableNode.style.width="100%";
}
}
}});
var _d3=_c2("dijit.form.Select",[_c9,_ca],{baseClass:"dijitSelect dijitValidationTextBox",templateString:_cf,_buttonInputDisabled:has("ie")?"disabled":"",required:false,state:"",message:"",tooltipPosition:[],emptyLabel:"&#160;",_isLoaded:false,_childrenLoaded:false,_fillContent:function(){
this.inherited(arguments);
if(this.options.length&&!this.value&&this.srcNodeRef){
var si=this.srcNodeRef.selectedIndex||0;
this.value=this.options[si>=0?si:0].value;
}
this.dropDown=new _d0({id:this.id+"_menu",parentWidget:this});
_c4.add(this.dropDown.domNode,this.baseClass.replace(/\s+|$/g,"Menu "));
},_getMenuItemForOption:function(_d4){
if(!_d4.value&&!_d4.label){
return new _cd({ownerDocument:this.ownerDocument});
}else{
var _d5=_c8.hitch(this,"_setValueAttr",_d4);
var _d6=new _cc({option:_d4,label:_d4.label||this.emptyLabel,onClick:_d5,ownerDocument:this.ownerDocument,dir:this.dir,disabled:_d4.disabled||false});
_d6.focusNode.setAttribute("role","option");
return _d6;
}
},_addOptionItem:function(_d7){
if(this.dropDown){
this.dropDown.addChild(this._getMenuItemForOption(_d7));
}
},_getChildren:function(){
if(!this.dropDown){
return [];
}
return this.dropDown.getChildren();
},_loadChildren:function(_d8){
if(_d8===true){
if(this.dropDown){
delete this.dropDown.focusedChild;
}
if(this.options.length){
this.inherited(arguments);
}else{
_c1.forEach(this._getChildren(),function(_d9){
_d9.destroyRecursive();
});
var _da=new _cc({ownerDocument:this.ownerDocument,label:this.emptyLabel});
this.dropDown.addChild(_da);
}
}else{
this._updateSelection();
}
this._isLoaded=false;
this._childrenLoaded=true;
if(!this._loadingStore){
this._setValueAttr(this.value,false);
}
},_refreshState:function(){
if(this._started){
this.validate(this.focused);
}
},startup:function(){
this.inherited(arguments);
this._refreshState();
},_setValueAttr:function(_db){
this.inherited(arguments);
_c3.set(this.valueNode,"value",this.get("value"));
this._refreshState();
},_setDisabledAttr:function(_dc){
this.inherited(arguments);
this._refreshState();
},_setRequiredAttr:function(_dd){
this._set("required",_dd);
this.focusNode.setAttribute("aria-required",_dd);
this._refreshState();
},_setOptionsAttr:function(_de){
this._isLoaded=false;
this._set("options",_de);
},_setDisplay:function(_df){
var lbl=_df||this.emptyLabel;
this.containerNode.innerHTML="<span role=\"option\" class=\"dijitReset dijitInline "+this.baseClass.replace(/\s+|$/g,"Label ")+"\">"+lbl+"</span>";
},validate:function(_e0){
var _e1=this.disabled||this.isValid(_e0);
this._set("state",_e1?"":(this._hasBeenBlurred?"Error":"Incomplete"));
this.focusNode.setAttribute("aria-invalid",_e1?"false":"true");
var _e2=_e1?"":this._missingMsg;
if(_e2&&this.focused&&this._hasBeenBlurred){
_ce.show(_e2,this.domNode,this.tooltipPosition,!this.isLeftToRight());
}else{
_ce.hide(this.domNode);
}
this._set("message",_e2);
return _e1;
},isValid:function(){
return (!this.required||this.value===0||!(/^\s*$/.test(this.value||"")));
},reset:function(){
this.inherited(arguments);
_ce.hide(this.domNode);
this._refreshState();
},postMixInProperties:function(){
this.inherited(arguments);
this._missingMsg=_c7.getLocalization("dijit.form","validate",this.lang).missingMessage;
},postCreate:function(){
this.inherited(arguments);
this.connect(this.domNode,"onselectstart",_c6.stop);
this.domNode.setAttribute("aria-expanded","false");
if(has("ie")<9){
this.defer(function(){
try{
var s=domStyle.getComputedStyle(this.domNode);
if(s){
var ff=s.fontFamily;
if(ff){
var _e3=this.domNode.getElementsByTagName("INPUT");
if(_e3){
for(var i=0;i<_e3.length;i++){
_e3[i].style.fontFamily=ff;
}
}
}
}
}
catch(e){
}
});
}
},_setStyleAttr:function(_e4){
this.inherited(arguments);
_c4.toggle(this.domNode,this.baseClass.replace(/\s+|$/g,"FixedWidth "),!!this.domNode.style.width);
},isLoaded:function(){
return this._isLoaded;
},loadDropDown:function(_e5){
this._loadChildren(true);
this._isLoaded=true;
_e5();
},closeDropDown:function(){
this.inherited(arguments);
if(this.dropDown&&this.dropDown.menuTableNode){
this.dropDown.menuTableNode.style.width="";
}
},destroy:function(_e6){
if(this.dropDown&&!this.dropDown._destroyed){
this.dropDown.destroyRecursive(_e6);
delete this.dropDown;
}
this.inherited(arguments);
},_onFocus:function(){
this.validate(true);
this.inherited(arguments);
},_onBlur:function(){
_ce.hide(this.domNode);
this.inherited(arguments);
this.validate(false);
}});
_d3._Menu=_d0;
return _d3;
});
},"dojo/dnd/autoscroll":function(){
define(["../_base/lang","../sniff","../_base/window","../dom-geometry","../dom-style","../window"],function(_e7,has,win,_e8,_e9,_ea){
var _eb={};
_e7.setObject("dojo.dnd.autoscroll",_eb);
_eb.getViewport=_ea.getBox;
_eb.V_TRIGGER_AUTOSCROLL=32;
_eb.H_TRIGGER_AUTOSCROLL=32;
_eb.V_AUTOSCROLL_VALUE=16;
_eb.H_AUTOSCROLL_VALUE=16;
var _ec,doc=win.doc,_ed=Infinity,_ee=Infinity;
_eb.autoScrollStart=function(d){
doc=d;
_ec=_ea.getBox(doc);
var _ef=win.body(doc).parentNode;
_ed=Math.max(_ef.scrollHeight-_ec.h,0);
_ee=Math.max(_ef.scrollWidth-_ec.w,0);
};
_eb.autoScroll=function(e){
var v=_ec||_ea.getBox(doc),_f0=win.body(doc).parentNode,dx=0,dy=0;
if(e.clientX<_eb.H_TRIGGER_AUTOSCROLL){
dx=-_eb.H_AUTOSCROLL_VALUE;
}else{
if(e.clientX>v.w-_eb.H_TRIGGER_AUTOSCROLL){
dx=Math.min(_eb.H_AUTOSCROLL_VALUE,_ee-_f0.scrollLeft);
}
}
if(e.clientY<_eb.V_TRIGGER_AUTOSCROLL){
dy=-_eb.V_AUTOSCROLL_VALUE;
}else{
if(e.clientY>v.h-_eb.V_TRIGGER_AUTOSCROLL){
dy=Math.min(_eb.V_AUTOSCROLL_VALUE,_ed-_f0.scrollTop);
}
}
window.scrollBy(dx,dy);
};
_eb._validNodes={"div":1,"p":1,"td":1};
_eb._validOverflow={"auto":1,"scroll":1};
_eb.autoScrollNodes=function(e){
var b,t,w,h,rx,ry,dx=0,dy=0,_f1,_f2;
for(var n=e.target;n;){
if(n.nodeType==1&&(n.tagName.toLowerCase() in _eb._validNodes)){
var s=_e9.getComputedStyle(n),_f3=(s.overflow.toLowerCase() in _eb._validOverflow),_f4=(s.overflowX.toLowerCase() in _eb._validOverflow),_f5=(s.overflowY.toLowerCase() in _eb._validOverflow);
if(_f3||_f4||_f5){
b=_e8.getContentBox(n,s);
t=_e8.position(n,true);
}
if(_f3||_f4){
w=Math.min(_eb.H_TRIGGER_AUTOSCROLL,b.w/2);
rx=e.pageX-t.x;
if(has("webkit")||has("opera")){
rx+=win.body().scrollLeft;
}
dx=0;
if(rx>0&&rx<b.w){
if(rx<w){
dx=-w;
}else{
if(rx>b.w-w){
dx=w;
}
}
_f1=n.scrollLeft;
n.scrollLeft=n.scrollLeft+dx;
}
}
if(_f3||_f5){
h=Math.min(_eb.V_TRIGGER_AUTOSCROLL,b.h/2);
ry=e.pageY-t.y;
if(has("webkit")||has("opera")){
ry+=win.body().scrollTop;
}
dy=0;
if(ry>0&&ry<b.h){
if(ry<h){
dy=-h;
}else{
if(ry>b.h-h){
dy=h;
}
}
_f2=n.scrollTop;
n.scrollTop=n.scrollTop+dy;
}
}
if(dx||dy){
return;
}
}
try{
n=n.parentNode;
}
catch(x){
n=null;
}
}
_eb.autoScroll(e);
};
return _eb;
});
},"dijit/Menu":function(){
define("dijit/Menu",["require","dojo/_base/array","dojo/_base/declare","dojo/_base/event","dojo/dom","dojo/dom-attr","dojo/dom-geometry","dojo/dom-style","dojo/keys","dojo/_base/lang","dojo/on","dojo/sniff","dojo/_base/window","dojo/window","./popup","./DropDownMenu","dojo/ready"],function(_f6,_f7,_f8,_f9,dom,_fa,_fb,_fc,_fd,_fe,on,has,win,_ff,pm,_100,_101){
if(has("dijit-legacy-requires")){
_101(0,function(){
var _102=["dijit/MenuItem","dijit/PopupMenuItem","dijit/CheckedMenuItem","dijit/MenuSeparator"];
_f6(_102);
});
}
return _f8("dijit.Menu",_100,{constructor:function(){
this._bindings=[];
},targetNodeIds:[],selector:"",contextMenuForWindow:false,leftClickToOpen:false,refocus:true,postCreate:function(){
if(this.contextMenuForWindow){
this.bindDomNode(this.ownerDocumentBody);
}else{
_f7.forEach(this.targetNodeIds,this.bindDomNode,this);
}
this.inherited(arguments);
},_iframeContentWindow:function(_103){
return _ff.get(this._iframeContentDocument(_103))||this._iframeContentDocument(_103)["__parent__"]||(_103.name&&win.doc.frames[_103.name])||null;
},_iframeContentDocument:function(_104){
return _104.contentDocument||(_104.contentWindow&&_104.contentWindow.document)||(_104.name&&win.doc.frames[_104.name]&&win.doc.frames[_104.name].document)||null;
},bindDomNode:function(node){
node=dom.byId(node,this.ownerDocument);
var cn;
if(node.tagName.toLowerCase()=="iframe"){
var _105=node,_106=this._iframeContentWindow(_105);
cn=win.body(_106.document);
}else{
cn=(node==win.body(this.ownerDocument)?this.ownerDocument.documentElement:node);
}
var _107={node:node,iframe:_105};
_fa.set(node,"_dijitMenu"+this.id,this._bindings.push(_107));
var _108=_fe.hitch(this,function(cn){
var _109=this.selector,_10a=_109?function(_10b){
return on.selector(_109,_10b);
}:function(_10c){
return _10c;
},self=this;
return [on(cn,_10a(this.leftClickToOpen?"click":"contextmenu"),function(evt){
_f9.stop(evt);
self._scheduleOpen(this,_105,{x:evt.pageX,y:evt.pageY});
}),on(cn,_10a("keydown"),function(evt){
if(evt.shiftKey&&evt.keyCode==_fd.F10){
_f9.stop(evt);
self._scheduleOpen(this,_105);
}
})];
});
_107.connects=cn?_108(cn):[];
if(_105){
_107.onloadHandler=_fe.hitch(this,function(){
var _10d=this._iframeContentWindow(_105);
cn=win.body(_10d.document);
_107.connects=_108(cn);
});
if(_105.addEventListener){
_105.addEventListener("load",_107.onloadHandler,false);
}else{
_105.attachEvent("onload",_107.onloadHandler);
}
}
},unBindDomNode:function(_10e){
var node;
try{
node=dom.byId(_10e,this.ownerDocument);
}
catch(e){
return;
}
var _10f="_dijitMenu"+this.id;
if(node&&_fa.has(node,_10f)){
var bid=_fa.get(node,_10f)-1,b=this._bindings[bid],h;
while((h=b.connects.pop())){
h.remove();
}
var _110=b.iframe;
if(_110){
if(_110.removeEventListener){
_110.removeEventListener("load",b.onloadHandler,false);
}else{
_110.detachEvent("onload",b.onloadHandler);
}
}
_fa.remove(node,_10f);
delete this._bindings[bid];
}
},_scheduleOpen:function(_111,_112,_113){
if(!this._openTimer){
this._openTimer=this.defer(function(){
delete this._openTimer;
this._openMyself({target:_111,iframe:_112,coords:_113});
},1);
}
},_openMyself:function(args){
var _114=args.target,_115=args.iframe,_116=args.coords;
this.currentTarget=_114;
if(_116){
if(_115){
var ifc=_fb.position(_115,true),_117=this._iframeContentWindow(_115),_118=_fb.docScroll(_117.document);
var cs=_fc.getComputedStyle(_115),tp=_fc.toPixelValue,left=(has("ie")&&has("quirks")?0:tp(_115,cs.paddingLeft))+(has("ie")&&has("quirks")?tp(_115,cs.borderLeftWidth):0),top=(has("ie")&&has("quirks")?0:tp(_115,cs.paddingTop))+(has("ie")&&has("quirks")?tp(_115,cs.borderTopWidth):0);
_116.x+=ifc.x+left-_118.x;
_116.y+=ifc.y+top-_118.y;
}
}else{
_116=_fb.position(_114,true);
_116.x+=10;
_116.y+=10;
}
var self=this;
var _119=this._focusManager.get("prevNode");
var _11a=this._focusManager.get("curNode");
var _11b=!_11a||(dom.isDescendant(_11a,this.domNode))?_119:_11a;
function _11c(){
if(self.refocus&&_11b){
_11b.focus();
}
pm.close(self);
};
pm.open({popup:this,x:_116.x,y:_116.y,onExecute:_11c,onCancel:_11c,orient:this.isLeftToRight()?"L":"R"});
this.focus();
this._onBlur=function(){
this.inherited("_onBlur",arguments);
pm.close(this);
};
},destroy:function(){
_f7.forEach(this._bindings,function(b){
if(b){
this.unBindDomNode(b.node);
}
},this);
this.inherited(arguments);
}});
});
},"dojo/hccss":function(){
define(["require","./_base/config","./dom-class","./dom-style","./has","./ready","./_base/window"],function(_11d,_11e,_11f,_120,has,_121,win){
has.add("highcontrast",function(){
var div=win.doc.createElement("div");
div.style.cssText="border: 1px solid; border-color:red green; position: absolute; height: 5px; top: -999px;"+"background-image: url("+(_11e.blankGif||_11d.toUrl("./resources/blank.gif"))+");";
win.body().appendChild(div);
var cs=_120.getComputedStyle(div),_122=cs.backgroundImage,hc=(cs.borderTopColor==cs.borderRightColor)||(_122&&(_122=="none"||_122=="url(invalid-url:)"));
if(has("ie")<=8){
div.outerHTML="";
}else{
win.body().removeChild(div);
}
return hc;
});
_121(90,function(){
if(has("highcontrast")){
_11f.add(win.body(),"dj_a11y");
}
});
return has;
});
},"dijit/_WidgetBase":function(){
define("dijit/_WidgetBase",["require","dojo/_base/array","dojo/aspect","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/ready","dojo/Stateful","dojo/topic","dojo/_base/window","./Destroyable","./registry"],function(_123,_124,_125,_126,_127,_128,dom,_129,_12a,_12b,_12c,_12d,has,_12e,lang,on,_12f,_130,_131,win,_132,_133){
has.add("dijit-legacy-requires",!_12e.isAsync);
if(has("dijit-legacy-requires")){
_12f(0,function(){
var _134=["dijit/_base/manager"];
_123(_134);
});
}
var _135={};
function _136(obj){
var ret={};
for(var attr in obj){
ret[attr.toLowerCase()]=true;
}
return ret;
};
function _137(attr){
return function(val){
_129[val?"set":"remove"](this.domNode,attr,val);
this._set(attr,val);
};
};
return _128("dijit._WidgetBase",[_130,_132],{id:"",_setIdAttr:"domNode",lang:"",_setLangAttr:_137("lang"),dir:"",_setDirAttr:_137("dir"),textDir:"","class":"",_setClassAttr:{node:"domNode",type:"class"},style:"",title:"",tooltip:"",baseClass:"",srcNodeRef:null,domNode:null,containerNode:null,ownerDocument:null,_setOwnerDocumentAttr:function(val){
this._set("ownerDocument",val);
},attributeMap:{},_blankGif:_126.blankGif||_123.toUrl("dojo/resources/blank.gif"),postscript:function(_138,_139){
this.create(_138,_139);
},create:function(_13a,_13b){
this.srcNodeRef=dom.byId(_13b);
this._connects=[];
this._supportingWidgets=[];
if(this.srcNodeRef&&(typeof this.srcNodeRef.id=="string")){
this.id=this.srcNodeRef.id;
}
if(_13a){
this.params=_13a;
lang.mixin(this,_13a);
}
this.postMixInProperties();
if(!this.id){
this.id=_133.getUniqueId(this.declaredClass.replace(/\./g,"_"));
if(this.params){
delete this.params.id;
}
}
this.ownerDocument=this.ownerDocument||(this.srcNodeRef?this.srcNodeRef.ownerDocument:win.doc);
this.ownerDocumentBody=win.body(this.ownerDocument);
_133.add(this);
this.buildRendering();
var _13c;
if(this.domNode){
this._applyAttributes();
var _13d=this.srcNodeRef;
if(_13d&&_13d.parentNode&&this.domNode!==_13d){
_13d.parentNode.replaceChild(this.domNode,_13d);
_13c=true;
}
this.domNode.setAttribute("widgetId",this.id);
}
this.postCreate();
if(_13c){
delete this.srcNodeRef;
}
this._created=true;
},_applyAttributes:function(){
var ctor=this.constructor,list=ctor._setterAttrs;
if(!list){
list=(ctor._setterAttrs=[]);
for(var attr in this.attributeMap){
list.push(attr);
}
var _13e=ctor.prototype;
for(var _13f in _13e){
if(_13f in this.attributeMap){
continue;
}
var _140="_set"+_13f.replace(/^[a-z]|-[a-zA-Z]/g,function(c){
return c.charAt(c.length-1).toUpperCase();
})+"Attr";
if(_140 in _13e){
list.push(_13f);
}
}
}
var _141={};
for(var key in this.params||{}){
_141[key]=this[key];
}
_124.forEach(list,function(attr){
if(attr in _141){
}else{
if(this[attr]){
this.set(attr,this[attr]);
}
}
},this);
for(key in _141){
this.set(key,_141[key]);
}
},postMixInProperties:function(){
},buildRendering:function(){
if(!this.domNode){
this.domNode=this.srcNodeRef||this.ownerDocument.createElement("div");
}
if(this.baseClass){
var _142=this.baseClass.split(" ");
if(!this.isLeftToRight()){
_142=_142.concat(_124.map(_142,function(name){
return name+"Rtl";
}));
}
_12a.add(this.domNode,_142);
}
},postCreate:function(){
},startup:function(){
if(this._started){
return;
}
this._started=true;
_124.forEach(this.getChildren(),function(obj){
if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){
obj.startup();
obj._started=true;
}
});
},destroyRecursive:function(_143){
this._beingDestroyed=true;
this.destroyDescendants(_143);
this.destroy(_143);
},destroy:function(_144){
this._beingDestroyed=true;
this.uninitialize();
function _145(w){
if(w.destroyRecursive){
w.destroyRecursive(_144);
}else{
if(w.destroy){
w.destroy(_144);
}
}
};
_124.forEach(this._connects,lang.hitch(this,"disconnect"));
_124.forEach(this._supportingWidgets,_145);
if(this.domNode){
_124.forEach(_133.findWidgets(this.domNode,this.containerNode),_145);
}
this.destroyRendering(_144);
_133.remove(this.id);
this._destroyed=true;
},destroyRendering:function(_146){
if(this.bgIframe){
this.bgIframe.destroy(_146);
delete this.bgIframe;
}
if(this.domNode){
if(_146){
_129.remove(this.domNode,"widgetId");
}else{
_12b.destroy(this.domNode);
}
delete this.domNode;
}
if(this.srcNodeRef){
if(!_146){
_12b.destroy(this.srcNodeRef);
}
delete this.srcNodeRef;
}
},destroyDescendants:function(_147){
_124.forEach(this.getChildren(),function(_148){
if(_148.destroyRecursive){
_148.destroyRecursive(_147);
}
});
},uninitialize:function(){
return false;
},_setStyleAttr:function(_149){
var _14a=this.domNode;
if(lang.isObject(_149)){
_12d.set(_14a,_149);
}else{
if(_14a.style.cssText){
_14a.style.cssText+="; "+_149;
}else{
_14a.style.cssText=_149;
}
}
this._set("style",_149);
},_attrToDom:function(attr,_14b,_14c){
_14c=arguments.length>=3?_14c:this.attributeMap[attr];
_124.forEach(lang.isArray(_14c)?_14c:[_14c],function(_14d){
var _14e=this[_14d.node||_14d||"domNode"];
var type=_14d.type||"attribute";
switch(type){
case "attribute":
if(lang.isFunction(_14b)){
_14b=lang.hitch(this,_14b);
}
var _14f=_14d.attribute?_14d.attribute:(/^on[A-Z][a-zA-Z]*$/.test(attr)?attr.toLowerCase():attr);
if(_14e.tagName){
_129.set(_14e,_14f,_14b);
}else{
_14e.set(_14f,_14b);
}
break;
case "innerText":
_14e.innerHTML="";
_14e.appendChild(this.ownerDocument.createTextNode(_14b));
break;
case "innerHTML":
_14e.innerHTML=_14b;
break;
case "class":
_12a.replace(_14e,_14b,this[attr]);
break;
}
},this);
},get:function(name){
var _150=this._getAttrNames(name);
return this[_150.g]?this[_150.g]():this[name];
},set:function(name,_151){
if(typeof name==="object"){
for(var x in name){
this.set(x,name[x]);
}
return this;
}
var _152=this._getAttrNames(name),_153=this[_152.s];
if(lang.isFunction(_153)){
var _154=_153.apply(this,Array.prototype.slice.call(arguments,1));
}else{
var _155=this.focusNode&&!lang.isFunction(this.focusNode)?"focusNode":"domNode",tag=this[_155].tagName,_156=_135[tag]||(_135[tag]=_136(this[_155])),map=name in this.attributeMap?this.attributeMap[name]:_152.s in this?this[_152.s]:((_152.l in _156&&typeof _151!="function")||/^aria-|^data-|^role$/.test(name))?_155:null;
if(map!=null){
this._attrToDom(name,_151,map);
}
this._set(name,_151);
}
return _154||this;
},_attrPairNames:{},_getAttrNames:function(name){
var apn=this._attrPairNames;
if(apn[name]){
return apn[name];
}
var uc=name.replace(/^[a-z]|-[a-zA-Z]/g,function(c){
return c.charAt(c.length-1).toUpperCase();
});
return (apn[name]={n:name+"Node",s:"_set"+uc+"Attr",g:"_get"+uc+"Attr",l:uc.toLowerCase()});
},_set:function(name,_157){
var _158=this[name];
this[name]=_157;
if(this._created&&_157!==_158){
if(this._watchCallbacks){
this._watchCallbacks(name,_158,_157);
}
this.emit("attrmodified-"+name,{detail:{prevValue:_158,newValue:_157}});
}
},emit:function(type,_159,_15a){
_159=_159||{};
if(_159.bubbles===undefined){
_159.bubbles=true;
}
if(_159.cancelable===undefined){
_159.cancelable=true;
}
if(!_159.detail){
_159.detail={};
}
_159.detail.widget=this;
var ret,_15b=this["on"+type];
if(_15b){
ret=_15b.apply(this,_15a?_15a:[_159]);
}
if(this._started&&!this._beingDestroyed){
on.emit(this.domNode,type.toLowerCase(),_159);
}
return ret;
},on:function(type,func){
var _15c=this._onMap(type);
if(_15c){
return _125.after(this,_15c,func,true);
}
return this.own(on(this.domNode,type,func))[0];
},_onMap:function(type){
var ctor=this.constructor,map=ctor._onMap;
if(!map){
map=(ctor._onMap={});
for(var attr in ctor.prototype){
if(/^on/.test(attr)){
map[attr.replace(/^on/,"").toLowerCase()]=attr;
}
}
}
return map[typeof type=="string"&&type.toLowerCase()];
},toString:function(){
return "[Widget "+this.declaredClass+", "+(this.id||"NO ID")+"]";
},getChildren:function(){
return this.containerNode?_133.findWidgets(this.containerNode):[];
},getParent:function(){
return _133.getEnclosingWidget(this.domNode.parentNode);
},connect:function(obj,_15d,_15e){
return this.own(_127.connect(obj,_15d,this,_15e))[0];
},disconnect:function(_15f){
_15f.remove();
},subscribe:function(t,_160){
return this.own(_131.subscribe(t,lang.hitch(this,_160)))[0];
},unsubscribe:function(_161){
_161.remove();
},isLeftToRight:function(){
return this.dir?(this.dir=="ltr"):_12c.isBodyLtr(this.ownerDocument);
},isFocusable:function(){
return this.focus&&(_12d.get(this.domNode,"display")!="none");
},placeAt:function(_162,_163){
var _164=!_162.tagName&&_133.byId(_162);
if(_164&&_164.addChild&&(!_163||typeof _163==="number")){
_164.addChild(this,_163);
}else{
var ref=_164?(_164.containerNode&&!/after|before|replace/.test(_163||"")?_164.containerNode:_164.domNode):dom.byId(_162,this.ownerDocument);
_12b.place(this.domNode,ref,_163);
if(!this._started&&(this.getParent()||{})._started){
this.startup();
}
}
return this;
},getTextDir:function(text,_165){
return _165;
},applyTextDir:function(){
},defer:function(fcn,_166){
var _167=setTimeout(lang.hitch(this,function(){
_167=null;
if(!this._destroyed){
lang.hitch(this,fcn)();
}
}),_166||0);
return {remove:function(){
if(_167){
clearTimeout(_167);
_167=null;
}
return null;
}};
}});
});
},"dijit/_MenuBase":function(){
define("dijit/_MenuBase",["dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/_base/lang","dojo/mouse","dojo/on","dojo/window","./a11yclick","./popup","./registry","./_Widget","./_KeyNavContainer","./_TemplatedMixin"],function(_168,_169,dom,_16a,_16b,lang,_16c,on,_16d,_16e,pm,_16f,_170,_171,_172){
return _169("dijit._MenuBase",[_170,_172,_171],{parentMenu:null,popupDelay:500,autoFocus:false,childSelector:function(node){
var _173=_16f.byNode(node);
return node.parentNode==this.containerNode&&_173&&_173.focus;
},postCreate:function(){
var self=this,_174=typeof this.childSelector=="string"?this.childSelector:lang.hitch(this,"childSelector");
this.own(on(this.containerNode,on.selector(_174,_16c.enter),function(){
self.onItemHover(_16f.byNode(this));
}),on(this.containerNode,on.selector(_174,_16c.leave),function(){
self.onItemUnhover(_16f.byNode(this));
}),on(this.containerNode,on.selector(_174,_16e),function(evt){
self.onItemClick(_16f.byNode(this),evt);
evt.stopPropagation();
evt.preventDefault();
}));
this.inherited(arguments);
},onExecute:function(){
},onCancel:function(){
},_moveToPopup:function(evt){
if(this.focusedChild&&this.focusedChild.popup&&!this.focusedChild.disabled){
this.onItemClick(this.focusedChild,evt);
}else{
var _175=this._getTopMenu();
if(_175&&_175._isMenuBar){
_175.focusNext();
}
}
},_onPopupHover:function(){
if(this.currentPopup&&this.currentPopup._pendingClose_timer){
var _176=this.currentPopup.parentMenu;
if(_176.focusedChild){
_176.focusedChild._setSelected(false);
}
_176.focusedChild=this.currentPopup.from_item;
_176.focusedChild._setSelected(true);
this._stopPendingCloseTimer(this.currentPopup);
}
},onItemHover:function(item){
if(this.isActive){
this.focusChild(item);
if(this.focusedChild.popup&&!this.focusedChild.disabled&&!this.hover_timer){
this.hover_timer=this.defer("_openPopup",this.popupDelay);
}
}
if(this.focusedChild){
this.focusChild(item);
}
this._hoveredChild=item;
item._set("hovering",true);
},_onChildBlur:function(item){
this._stopPopupTimer();
item._setSelected(false);
var _177=item.popup;
if(_177){
this._stopPendingCloseTimer(_177);
_177._pendingClose_timer=this.defer(function(){
_177._pendingClose_timer=null;
if(_177.parentMenu){
_177.parentMenu.currentPopup=null;
}
pm.close(_177);
},this.popupDelay);
}
},onItemUnhover:function(item){
if(this.isActive){
this._stopPopupTimer();
}
if(this._hoveredChild==item){
this._hoveredChild=null;
}
item._set("hovering",false);
},_stopPopupTimer:function(){
if(this.hover_timer){
this.hover_timer=this.hover_timer.remove();
}
},_stopPendingCloseTimer:function(_178){
if(_178._pendingClose_timer){
_178._pendingClose_timer=_178._pendingClose_timer.remove();
}
},_stopFocusTimer:function(){
if(this._focus_timer){
this._focus_timer=this._focus_timer.remove();
}
},_getTopMenu:function(){
for(var top=this;top.parentMenu;top=top.parentMenu){
}
return top;
},onItemClick:function(item,evt){
if(typeof this.isShowingNow=="undefined"){
this._markActive();
}
this.focusChild(item);
if(item.disabled){
return false;
}
if(item.popup){
this._openPopup(evt.type=="keypress");
}else{
this.onExecute();
item._onClick?item._onClick(evt):item.onClick(evt);
}
},_openPopup:function(_179){
this._stopPopupTimer();
var _17a=this.focusedChild;
if(!_17a){
return;
}
var _17b=_17a.popup;
if(!_17b.isShowingNow){
if(this.currentPopup){
this._stopPendingCloseTimer(this.currentPopup);
pm.close(this.currentPopup);
}
_17b.parentMenu=this;
_17b.from_item=_17a;
var self=this;
pm.open({parent:this,popup:_17b,around:_17a.domNode,orient:this._orient||["after","before"],onCancel:function(){
self.focusChild(_17a);
self._cleanUp();
_17a._setSelected(true);
self.focusedChild=_17a;
},onExecute:lang.hitch(this,"_cleanUp")});
this.currentPopup=_17b;
_17b.connect(_17b.domNode,"onmouseenter",lang.hitch(self,"_onPopupHover"));
}
if(_179&&_17b.focus){
_17b._focus_timer=this.defer(lang.hitch(_17b,function(){
this._focus_timer=null;
this.focus();
}));
}
},_markActive:function(){
this.isActive=true;
_16b.replace(this.domNode,"dijitMenuActive","dijitMenuPassive");
},onOpen:function(){
this.isShowingNow=true;
this._markActive();
},_markInactive:function(){
this.isActive=false;
_16b.replace(this.domNode,"dijitMenuPassive","dijitMenuActive");
},onClose:function(){
this._stopFocusTimer();
this._markInactive();
this.isShowingNow=false;
this.parentMenu=null;
},_closeChild:function(){
this._stopPopupTimer();
if(this.currentPopup){
if(_168.indexOf(this._focusManager.activeStack,this.id)>=0){
_16a.set(this.focusedChild.focusNode,"tabIndex",this.tabIndex);
this.focusedChild.focusNode.focus();
}
pm.close(this.currentPopup);
this.currentPopup=null;
}
if(this.focusedChild){
this.focusedChild._setSelected(false);
this.onItemUnhover(this.focusedChild);
this.focusedChild=null;
}
},_onItemFocus:function(item){
if(this._hoveredChild&&this._hoveredChild!=item){
this.onItemUnhover(this._hoveredChild);
}
},_onBlur:function(){
this._cleanUp();
this.inherited(arguments);
},_cleanUp:function(){
this._closeChild();
if(typeof this.isShowingNow=="undefined"){
this._markInactive();
}
}});
});
},"dojo/dnd/common":function(){
define(["../_base/connect","../_base/kernel","../_base/lang","../dom"],function(_17c,_17d,lang,dom){
var _17e=lang.getObject("dojo.dnd",true);
_17e.getCopyKeyState=_17c.isCopyKey;
_17e._uniqueId=0;
_17e.getUniqueId=function(){
var id;
do{
id=_17d._scopeName+"Unique"+(++_17e._uniqueId);
}while(dom.byId(id));
return id;
};
_17e._empty={};
_17e.isFormElement=function(e){
var t=e.target;
if(t.nodeType==3){
t=t.parentNode;
}
return " button textarea input select option ".indexOf(" "+t.tagName.toLowerCase()+" ")>=0;
};
return _17e;
});
},"dojo/touch":function(){
define(["./_base/kernel","./aspect","./dom","./on","./has","./mouse","./ready","./_base/window"],function(dojo,_17f,dom,on,has,_180,_181,win){
var _182=has("touch");
var ios4=false;
if(has("ios")){
var ua=navigator.userAgent;
var v=ua.match(/OS ([\d_]+)/)?RegExp.$1:"1";
var os=parseFloat(v.replace(/_/,".").replace(/_/g,""));
ios4=os<5;
}
var _183,_184;
if(_182){
_181(function(){
_184=win.body();
win.doc.addEventListener("touchstart",function(evt){
var _185=_184;
_184=evt.target;
on.emit(_185,"dojotouchout",{target:_185,relatedTarget:_184,bubbles:true});
on.emit(_184,"dojotouchover",{target:_184,relatedTarget:_185,bubbles:true});
},true);
on(win.doc,"touchmove",function(evt){
var _186=win.doc.elementFromPoint(evt.pageX-(ios4?0:win.global.pageXOffset),evt.pageY-(ios4?0:win.global.pageYOffset));
if(_186&&_184!==_186){
on.emit(_184,"dojotouchout",{target:_184,relatedTarget:_186,bubbles:true});
on.emit(_186,"dojotouchover",{target:_186,relatedTarget:_184,bubbles:true});
_184=_186;
}
});
});
_183=function(node,_187){
return on(win.doc,"touchmove",function(evt){
if(node===win.doc||dom.isDescendant(_184,node)){
evt.target=_184;
_187.call(this,evt);
}
});
};
}
function _188(type){
return function(node,_189){
return on(node,type,_189);
};
};
var _18a={press:_188(_182?"touchstart":"mousedown"),move:_182?_183:_188("mousemove"),release:_188(_182?"touchend":"mouseup"),cancel:_182?_188("touchcancel"):_180.leave,over:_188(_182?"dojotouchover":"mouseover"),out:_188(_182?"dojotouchout":"mouseout"),enter:_180._eventHandler(_182?"dojotouchover":"mouseover"),leave:_180._eventHandler(_182?"dojotouchout":"mouseout")};
1&&(dojo.touch=_18a);
return _18a;
});
},"url:dijit/form/templates/Button.html":"<span class=\"dijit dijitReset dijitInline\" role=\"presentation\"\n\t><span class=\"dijitReset dijitInline dijitButtonNode\"\n\t\tdata-dojo-attach-event=\"ondijitclick:_onClick\" role=\"presentation\"\n\t\t><span class=\"dijitReset dijitStretch dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"titleNode,focusNode\"\n\t\t\trole=\"button\" aria-labelledby=\"${id}_label\"\n\t\t\t><span class=\"dijitReset dijitInline dijitIcon\" data-dojo-attach-point=\"iconNode\"></span\n\t\t\t><span class=\"dijitReset dijitToggleButtonIconChar\">&#x25CF;</span\n\t\t\t><span class=\"dijitReset dijitInline dijitButtonText\"\n\t\t\t\tid=\"${id}_label\"\n\t\t\t\tdata-dojo-attach-point=\"containerNode\"\n\t\t\t></span\n\t\t></span\n\t></span\n\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" class=\"dijitOffScreen\"\n\t\ttabIndex=\"-1\" role=\"presentation\" data-dojo-attach-point=\"valueNode\"\n/></span>\n","dijit/form/_FormValueMixin":function(){
define("dijit/form/_FormValueMixin",["dojo/_base/declare","dojo/dom-attr","dojo/keys","dojo/sniff","./_FormWidgetMixin"],function(_18b,_18c,keys,has,_18d){
return _18b("dijit.form._FormValueMixin",_18d,{readOnly:false,_setReadOnlyAttr:function(_18e){
_18c.set(this.focusNode,"readOnly",_18e);
this._set("readOnly",_18e);
},postCreate:function(){
this.inherited(arguments);
if(has("ie")){
this.connect(this.focusNode||this.domNode,"onkeydown",this._onKeyDown);
}
if(this._resetValue===undefined){
this._lastValueReported=this._resetValue=this.value;
}
},_setValueAttr:function(_18f,_190){
this._handleOnChange(_18f,_190);
},_handleOnChange:function(_191,_192){
this._set("value",_191);
this.inherited(arguments);
},undo:function(){
this._setValueAttr(this._lastValueReported,false);
},reset:function(){
this._hasBeenBlurred=false;
this._setValueAttr(this._resetValue,true);
},_onKeyDown:function(e){
if(e.keyCode==keys.ESCAPE&&!(e.ctrlKey||e.altKey||e.metaKey)){
if(has("ie")<9||(has("ie")&&has("quirks"))){
e.preventDefault();
var node=e.srcElement,te=node.ownerDocument.createEventObject();
te.keyCode=keys.ESCAPE;
te.shiftKey=e.shiftKey;
node.fireEvent("onkeypress",te);
}
}
}});
});
},"dojo/Stateful":function(){
define(["./_base/declare","./_base/lang","./_base/array","dojo/when"],function(_193,lang,_194,when){
return _193("dojo.Stateful",null,{_attrPairNames:{},_getAttrNames:function(name){
var apn=this._attrPairNames;
if(apn[name]){
return apn[name];
}
return (apn[name]={s:"_"+name+"Setter",g:"_"+name+"Getter"});
},postscript:function(_195){
if(_195){
this.set(_195);
}
},_get:function(name,_196){
return typeof this[_196.g]==="function"?this[_196.g]():this[name];
},get:function(name){
return this._get(name,this._getAttrNames(name));
},set:function(name,_197){
if(typeof name==="object"){
for(var x in name){
if(name.hasOwnProperty(x)&&x!="_watchCallbacks"){
this.set(x,name[x]);
}
}
return this;
}
var _198=this._getAttrNames(name),_199=this._get(name,_198),_19a=this[_198.s],_19b;
if(typeof _19a==="function"){
_19b=_19a.apply(this,Array.prototype.slice.call(arguments,1));
}else{
this[name]=_197;
}
if(this._watchCallbacks){
var self=this;
when(_19b,function(){
self._watchCallbacks(name,_199,_197);
});
}
return this;
},_changeAttrValue:function(name,_19c){
var _19d=this.get(name);
this[name]=_19c;
if(this._watchCallbacks){
this._watchCallbacks(name,_19d,_19c);
}
return this;
},watch:function(name,_19e){
var _19f=this._watchCallbacks;
if(!_19f){
var self=this;
_19f=this._watchCallbacks=function(name,_1a0,_1a1,_1a2){
var _1a3=function(_1a4){
if(_1a4){
_1a4=_1a4.slice();
for(var i=0,l=_1a4.length;i<l;i++){
_1a4[i].call(self,name,_1a0,_1a1);
}
}
};
_1a3(_19f["_"+name]);
if(!_1a2){
_1a3(_19f["*"]);
}
};
}
if(!_19e&&typeof name==="function"){
_19e=name;
name="*";
}else{
name="_"+name;
}
var _1a5=_19f[name];
if(typeof _1a5!=="object"){
_1a5=_19f[name]=[];
}
_1a5.push(_19e);
var _1a6={};
_1a6.unwatch=_1a6.remove=function(){
var _1a7=_194.indexOf(_1a5,_19e);
if(_1a7>-1){
_1a5.splice(_1a7,1);
}
};
return _1a6;
}});
});
},"dijit/_CssStateMixin":function(){
define("dijit/_CssStateMixin",["dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/dom-class","dojo/has","dojo/_base/lang","dojo/on","dojo/ready","dojo/_base/window","./registry"],function(_1a8,_1a9,dom,_1aa,has,lang,on,_1ab,win,_1ac){
var _1ad=_1a9("dijit._CssStateMixin",[],{cssStateNodes:{},hovering:false,active:false,_applyAttributes:function(){
this.inherited(arguments);
_1a8.forEach(["disabled","readOnly","checked","selected","focused","state","hovering","active","_opened"],function(attr){
this.watch(attr,lang.hitch(this,"_setStateClass"));
},this);
for(var ap in this.cssStateNodes){
this._trackMouseState(this[ap],this.cssStateNodes[ap]);
}
this._trackMouseState(this.domNode,this.baseClass);
this._setStateClass();
},_cssMouseEvent:function(_1ae){
if(!this.disabled){
switch(_1ae.type){
case "mouseover":
this._set("hovering",true);
this._set("active",this._mouseDown);
break;
case "mouseout":
this._set("hovering",false);
this._set("active",false);
break;
case "mousedown":
case "touchstart":
this._set("active",true);
break;
case "mouseup":
case "touchend":
this._set("active",false);
break;
}
}
},_setStateClass:function(){
var _1af=this.baseClass.split(" ");
function _1b0(_1b1){
_1af=_1af.concat(_1a8.map(_1af,function(c){
return c+_1b1;
}),"dijit"+_1b1);
};
if(!this.isLeftToRight()){
_1b0("Rtl");
}
var _1b2=this.checked=="mixed"?"Mixed":(this.checked?"Checked":"");
if(this.checked){
_1b0(_1b2);
}
if(this.state){
_1b0(this.state);
}
if(this.selected){
_1b0("Selected");
}
if(this._opened){
_1b0("Opened");
}
if(this.disabled){
_1b0("Disabled");
}else{
if(this.readOnly){
_1b0("ReadOnly");
}else{
if(this.active){
_1b0("Active");
}else{
if(this.hovering){
_1b0("Hover");
}
}
}
}
if(this.focused){
_1b0("Focused");
}
var tn=this.stateNode||this.domNode,_1b3={};
_1a8.forEach(tn.className.split(" "),function(c){
_1b3[c]=true;
});
if("_stateClasses" in this){
_1a8.forEach(this._stateClasses,function(c){
delete _1b3[c];
});
}
_1a8.forEach(_1af,function(c){
_1b3[c]=true;
});
var _1b4=[];
for(var c in _1b3){
_1b4.push(c);
}
tn.className=_1b4.join(" ");
this._stateClasses=_1af;
},_subnodeCssMouseEvent:function(node,_1b5,evt){
if(this.disabled||this.readOnly){
return;
}
function _1b6(_1b7){
_1aa.toggle(node,_1b5+"Hover",_1b7);
};
function _1b8(_1b9){
_1aa.toggle(node,_1b5+"Active",_1b9);
};
function _1ba(_1bb){
_1aa.toggle(node,_1b5+"Focused",_1bb);
};
switch(evt.type){
case "mouseover":
_1b6(true);
break;
case "mouseout":
_1b6(false);
_1b8(false);
break;
case "mousedown":
case "touchstart":
_1b8(true);
break;
case "mouseup":
case "touchend":
_1b8(false);
break;
case "focus":
case "focusin":
_1ba(true);
break;
case "blur":
case "focusout":
_1ba(false);
break;
}
},_trackMouseState:function(node,_1bc){
node._cssState=_1bc;
}});
_1ab(function(){
function _1bd(evt){
if(!dom.isDescendant(evt.relatedTarget,evt.target)){
for(var node=evt.target;node&&node!=evt.relatedTarget;node=node.parentNode){
if(node._cssState){
var _1be=_1ac.getEnclosingWidget(node);
if(_1be){
if(node==_1be.domNode){
_1be._cssMouseEvent(evt);
}else{
_1be._subnodeCssMouseEvent(node,node._cssState,evt);
}
}
}
}
}
};
function _1bf(evt){
evt.target=evt.srcElement;
_1bd(evt);
};
var body=win.body(),_1c0=(has("touch")?[]:["mouseover","mouseout"]).concat(["mousedown","touchstart","mouseup","touchend"]);
_1a8.forEach(_1c0,function(type){
if(body.addEventListener){
body.addEventListener(type,_1bd,true);
}else{
body.attachEvent("on"+type,_1bf);
}
});
on(body,"focusin, focusout",function(evt){
var node=evt.target;
if(node._cssState&&!node.getAttribute("widgetId")){
var _1c1=_1ac.getEnclosingWidget(node);
_1c1._subnodeCssMouseEvent(node,node._cssState,evt);
}
});
});
return _1ad;
});
},"dijit/_base/manager":function(){
define("dijit/_base/manager",["dojo/_base/array","dojo/_base/config","dojo/_base/lang","../registry","../main"],function(_1c2,_1c3,lang,_1c4,_1c5){
var _1c6={};
_1c2.forEach(["byId","getUniqueId","findWidgets","_destroyAll","byNode","getEnclosingWidget"],function(name){
_1c6[name]=_1c4[name];
});
lang.mixin(_1c6,{defaultDuration:_1c3["defaultDuration"]||200});
lang.mixin(_1c5,_1c6);
return _1c5;
});
},"dojo/number":function(){
define(["./_base/lang","./i18n","./i18n!./cldr/nls/number","./string","./regexp"],function(lang,i18n,_1c7,_1c8,_1c9){
var _1ca={};
lang.setObject("dojo.number",_1ca);
_1ca.format=function(_1cb,_1cc){
_1cc=lang.mixin({},_1cc||{});
var _1cd=i18n.normalizeLocale(_1cc.locale),_1ce=i18n.getLocalization("dojo.cldr","number",_1cd);
_1cc.customs=_1ce;
var _1cf=_1cc.pattern||_1ce[(_1cc.type||"decimal")+"Format"];
if(isNaN(_1cb)||Math.abs(_1cb)==Infinity){
return null;
}
return _1ca._applyPattern(_1cb,_1cf,_1cc);
};
_1ca._numberPatternRE=/[#0,]*[#0](?:\.0*#*)?/;
_1ca._applyPattern=function(_1d0,_1d1,_1d2){
_1d2=_1d2||{};
var _1d3=_1d2.customs.group,_1d4=_1d2.customs.decimal,_1d5=_1d1.split(";"),_1d6=_1d5[0];
_1d1=_1d5[(_1d0<0)?1:0]||("-"+_1d6);
if(_1d1.indexOf("%")!=-1){
_1d0*=100;
}else{
if(_1d1.indexOf("‰")!=-1){
_1d0*=1000;
}else{
if(_1d1.indexOf("¤")!=-1){
_1d3=_1d2.customs.currencyGroup||_1d3;
_1d4=_1d2.customs.currencyDecimal||_1d4;
_1d1=_1d1.replace(/\u00a4{1,3}/,function(_1d7){
var prop=["symbol","currency","displayName"][_1d7.length-1];
return _1d2[prop]||_1d2.currency||"";
});
}else{
if(_1d1.indexOf("E")!=-1){
throw new Error("exponential notation not supported");
}
}
}
}
var _1d8=_1ca._numberPatternRE;
var _1d9=_1d6.match(_1d8);
if(!_1d9){
throw new Error("unable to find a number expression in pattern: "+_1d1);
}
if(_1d2.fractional===false){
_1d2.places=0;
}
return _1d1.replace(_1d8,_1ca._formatAbsolute(_1d0,_1d9[0],{decimal:_1d4,group:_1d3,places:_1d2.places,round:_1d2.round}));
};
_1ca.round=function(_1da,_1db,_1dc){
var _1dd=10/(_1dc||10);
return (_1dd*+_1da).toFixed(_1db)/_1dd;
};
if((0.9).toFixed()==0){
var _1de=_1ca.round;
_1ca.round=function(v,p,m){
var d=Math.pow(10,-p||0),a=Math.abs(v);
if(!v||a>=d){
d=0;
}else{
a/=d;
if(a<0.5||a>=0.95){
d=0;
}
}
return _1de(v,p,m)+(v>0?d:-d);
};
}
_1ca._formatAbsolute=function(_1df,_1e0,_1e1){
_1e1=_1e1||{};
if(_1e1.places===true){
_1e1.places=0;
}
if(_1e1.places===Infinity){
_1e1.places=6;
}
var _1e2=_1e0.split("."),_1e3=typeof _1e1.places=="string"&&_1e1.places.indexOf(","),_1e4=_1e1.places;
if(_1e3){
_1e4=_1e1.places.substring(_1e3+1);
}else{
if(!(_1e4>=0)){
_1e4=(_1e2[1]||[]).length;
}
}
if(!(_1e1.round<0)){
_1df=_1ca.round(_1df,_1e4,_1e1.round);
}
var _1e5=String(Math.abs(_1df)).split("."),_1e6=_1e5[1]||"";
if(_1e2[1]||_1e1.places){
if(_1e3){
_1e1.places=_1e1.places.substring(0,_1e3);
}
var pad=_1e1.places!==undefined?_1e1.places:(_1e2[1]&&_1e2[1].lastIndexOf("0")+1);
if(pad>_1e6.length){
_1e5[1]=_1c8.pad(_1e6,pad,"0",true);
}
if(_1e4<_1e6.length){
_1e5[1]=_1e6.substr(0,_1e4);
}
}else{
if(_1e5[1]){
_1e5.pop();
}
}
var _1e7=_1e2[0].replace(",","");
pad=_1e7.indexOf("0");
if(pad!=-1){
pad=_1e7.length-pad;
if(pad>_1e5[0].length){
_1e5[0]=_1c8.pad(_1e5[0],pad);
}
if(_1e7.indexOf("#")==-1){
_1e5[0]=_1e5[0].substr(_1e5[0].length-pad);
}
}
var _1e8=_1e2[0].lastIndexOf(","),_1e9,_1ea;
if(_1e8!=-1){
_1e9=_1e2[0].length-_1e8-1;
var _1eb=_1e2[0].substr(0,_1e8);
_1e8=_1eb.lastIndexOf(",");
if(_1e8!=-1){
_1ea=_1eb.length-_1e8-1;
}
}
var _1ec=[];
for(var _1ed=_1e5[0];_1ed;){
var off=_1ed.length-_1e9;
_1ec.push((off>0)?_1ed.substr(off):_1ed);
_1ed=(off>0)?_1ed.slice(0,off):"";
if(_1ea){
_1e9=_1ea;
delete _1ea;
}
}
_1e5[0]=_1ec.reverse().join(_1e1.group||",");
return _1e5.join(_1e1.decimal||".");
};
_1ca.regexp=function(_1ee){
return _1ca._parseInfo(_1ee).regexp;
};
_1ca._parseInfo=function(_1ef){
_1ef=_1ef||{};
var _1f0=i18n.normalizeLocale(_1ef.locale),_1f1=i18n.getLocalization("dojo.cldr","number",_1f0),_1f2=_1ef.pattern||_1f1[(_1ef.type||"decimal")+"Format"],_1f3=_1f1.group,_1f4=_1f1.decimal,_1f5=1;
if(_1f2.indexOf("%")!=-1){
_1f5/=100;
}else{
if(_1f2.indexOf("‰")!=-1){
_1f5/=1000;
}else{
var _1f6=_1f2.indexOf("¤")!=-1;
if(_1f6){
_1f3=_1f1.currencyGroup||_1f3;
_1f4=_1f1.currencyDecimal||_1f4;
}
}
}
var _1f7=_1f2.split(";");
if(_1f7.length==1){
_1f7.push("-"+_1f7[0]);
}
var re=_1c9.buildGroupRE(_1f7,function(_1f8){
_1f8="(?:"+_1c9.escapeString(_1f8,".")+")";
return _1f8.replace(_1ca._numberPatternRE,function(_1f9){
var _1fa={signed:false,separator:_1ef.strict?_1f3:[_1f3,""],fractional:_1ef.fractional,decimal:_1f4,exponent:false},_1fb=_1f9.split("."),_1fc=_1ef.places;
if(_1fb.length==1&&_1f5!=1){
_1fb[1]="###";
}
if(_1fb.length==1||_1fc===0){
_1fa.fractional=false;
}else{
if(_1fc===undefined){
_1fc=_1ef.pattern?_1fb[1].lastIndexOf("0")+1:Infinity;
}
if(_1fc&&_1ef.fractional==undefined){
_1fa.fractional=true;
}
if(!_1ef.places&&(_1fc<_1fb[1].length)){
_1fc+=","+_1fb[1].length;
}
_1fa.places=_1fc;
}
var _1fd=_1fb[0].split(",");
if(_1fd.length>1){
_1fa.groupSize=_1fd.pop().length;
if(_1fd.length>1){
_1fa.groupSize2=_1fd.pop().length;
}
}
return "("+_1ca._realNumberRegexp(_1fa)+")";
});
},true);
if(_1f6){
re=re.replace(/([\s\xa0]*)(\u00a4{1,3})([\s\xa0]*)/g,function(_1fe,_1ff,_200,_201){
var prop=["symbol","currency","displayName"][_200.length-1],_202=_1c9.escapeString(_1ef[prop]||_1ef.currency||"");
_1ff=_1ff?"[\\s\\xa0]":"";
_201=_201?"[\\s\\xa0]":"";
if(!_1ef.strict){
if(_1ff){
_1ff+="*";
}
if(_201){
_201+="*";
}
return "(?:"+_1ff+_202+_201+")?";
}
return _1ff+_202+_201;
});
}
return {regexp:re.replace(/[\xa0 ]/g,"[\\s\\xa0]"),group:_1f3,decimal:_1f4,factor:_1f5};
};
_1ca.parse=function(_203,_204){
var info=_1ca._parseInfo(_204),_205=(new RegExp("^"+info.regexp+"$")).exec(_203);
if(!_205){
return NaN;
}
var _206=_205[1];
if(!_205[1]){
if(!_205[2]){
return NaN;
}
_206=_205[2];
info.factor*=-1;
}
_206=_206.replace(new RegExp("["+info.group+"\\s\\xa0"+"]","g"),"").replace(info.decimal,".");
return _206*info.factor;
};
_1ca._realNumberRegexp=function(_207){
_207=_207||{};
if(!("places" in _207)){
_207.places=Infinity;
}
if(typeof _207.decimal!="string"){
_207.decimal=".";
}
if(!("fractional" in _207)||/^0/.test(_207.places)){
_207.fractional=[true,false];
}
if(!("exponent" in _207)){
_207.exponent=[true,false];
}
if(!("eSigned" in _207)){
_207.eSigned=[true,false];
}
var _208=_1ca._integerRegexp(_207),_209=_1c9.buildGroupRE(_207.fractional,function(q){
var re="";
if(q&&(_207.places!==0)){
re="\\"+_207.decimal;
if(_207.places==Infinity){
re="(?:"+re+"\\d+)?";
}else{
re+="\\d{"+_207.places+"}";
}
}
return re;
},true);
var _20a=_1c9.buildGroupRE(_207.exponent,function(q){
if(q){
return "([eE]"+_1ca._integerRegexp({signed:_207.eSigned})+")";
}
return "";
});
var _20b=_208+_209;
if(_209){
_20b="(?:(?:"+_20b+")|(?:"+_209+"))";
}
return _20b+_20a;
};
_1ca._integerRegexp=function(_20c){
_20c=_20c||{};
if(!("signed" in _20c)){
_20c.signed=[true,false];
}
if(!("separator" in _20c)){
_20c.separator="";
}else{
if(!("groupSize" in _20c)){
_20c.groupSize=3;
}
}
var _20d=_1c9.buildGroupRE(_20c.signed,function(q){
return q?"[-+]":"";
},true);
var _20e=_1c9.buildGroupRE(_20c.separator,function(sep){
if(!sep){
return "(?:\\d+)";
}
sep=_1c9.escapeString(sep);
if(sep==" "){
sep="\\s";
}else{
if(sep==" "){
sep="\\s\\xa0";
}
}
var grp=_20c.groupSize,grp2=_20c.groupSize2;
if(grp2){
var _20f="(?:0|[1-9]\\d{0,"+(grp2-1)+"}(?:["+sep+"]\\d{"+grp2+"})*["+sep+"]\\d{"+grp+"})";
return ((grp-grp2)>0)?"(?:"+_20f+"|(?:0|[1-9]\\d{0,"+(grp-1)+"}))":_20f;
}
return "(?:0|[1-9]\\d{0,"+(grp-1)+"}(?:["+sep+"]\\d{"+grp+"})*)";
},true);
return _20d+_20e;
};
return _1ca;
});
},"dojo/dnd/Moveable":function(){
define(["../_base/array","../_base/declare","../_base/event","../_base/lang","../dom","../dom-class","../Evented","../on","../topic","../touch","./common","./Mover","../_base/window"],function(_210,_211,_212,lang,dom,_213,_214,on,_215,_216,dnd,_217,win){
var _218=_211("dojo.dnd.Moveable",[_214],{handle:"",delay:0,skip:false,constructor:function(node,_219){
this.node=dom.byId(node);
if(!_219){
_219={};
}
this.handle=_219.handle?dom.byId(_219.handle):null;
if(!this.handle){
this.handle=this.node;
}
this.delay=_219.delay>0?_219.delay:0;
this.skip=_219.skip;
this.mover=_219.mover?_219.mover:_217;
this.events=[on(this.handle,_216.press,lang.hitch(this,"onMouseDown")),on(this.handle,"dragstart",lang.hitch(this,"onSelectStart")),on(this.handle,"selectstart",lang.hitch(this,"onSelectStart"))];
},markupFactory:function(_21a,node,Ctor){
return new Ctor(node,_21a);
},destroy:function(){
_210.forEach(this.events,function(_21b){
_21b.remove();
});
this.events=this.node=this.handle=null;
},onMouseDown:function(e){
if(this.skip&&dnd.isFormElement(e)){
return;
}
if(this.delay){
this.events.push(on(this.handle,_216.move,lang.hitch(this,"onMouseMove")),on(this.handle,_216.release,lang.hitch(this,"onMouseUp")));
this._lastX=e.pageX;
this._lastY=e.pageY;
}else{
this.onDragDetected(e);
}
_212.stop(e);
},onMouseMove:function(e){
if(Math.abs(e.pageX-this._lastX)>this.delay||Math.abs(e.pageY-this._lastY)>this.delay){
this.onMouseUp(e);
this.onDragDetected(e);
}
_212.stop(e);
},onMouseUp:function(e){
for(var i=0;i<2;++i){
this.events.pop().remove();
}
_212.stop(e);
},onSelectStart:function(e){
if(!this.skip||!dnd.isFormElement(e)){
_212.stop(e);
}
},onDragDetected:function(e){
new this.mover(this.node,e,this);
},onMoveStart:function(_21c){
_215.publish("/dnd/move/start",_21c);
_213.add(win.body(),"dojoMove");
_213.add(this.node,"dojoMoveItem");
},onMoveStop:function(_21d){
_215.publish("/dnd/move/stop",_21d);
_213.remove(win.body(),"dojoMove");
_213.remove(this.node,"dojoMoveItem");
},onFirstMove:function(){
},onMove:function(_21e,_21f){
this.onMoving(_21e,_21f);
var s=_21e.node.style;
s.left=_21f.l+"px";
s.top=_21f.t+"px";
this.onMoved(_21e,_21f);
},onMoving:function(){
},onMoved:function(){
}});
return _218;
});
},"url:dijit/templates/Menu.html":"<table class=\"dijit dijitMenu dijitMenuPassive dijitReset dijitMenuTable\" role=\"menu\" tabIndex=\"${tabIndex}\"\n\t   data-dojo-attach-event=\"onkeypress:_onKeyPress\" cellspacing=\"0\">\n\t<tbody class=\"dijitReset\" data-dojo-attach-point=\"containerNode\"></tbody>\n</table>\n","dijit/BackgroundIframe":function(){
define("dijit/BackgroundIframe",["require","./main","dojo/_base/config","dojo/dom-construct","dojo/dom-style","dojo/_base/lang","dojo/on","dojo/sniff","dojo/_base/window"],function(_220,_221,_222,_223,_224,lang,on,has,win){
var _225=new function(){
var _226=[];
this.pop=function(){
var _227;
if(_226.length){
_227=_226.pop();
_227.style.display="";
}else{
if(has("ie")<9){
var burl=_222["dojoBlankHtmlUrl"]||_220.toUrl("dojo/resources/blank.html")||"javascript:\"\"";
var html="<iframe src='"+burl+"' role='presentation'"+" style='position: absolute; left: 0px; top: 0px;"+"z-index: -1; filter:Alpha(Opacity=\"0\");'>";
_227=win.doc.createElement(html);
}else{
_227=_223.create("iframe");
_227.src="javascript:\"\"";
_227.className="dijitBackgroundIframe";
_227.setAttribute("role","presentation");
_224.set(_227,"opacity",0.1);
}
_227.tabIndex=-1;
}
return _227;
};
this.push=function(_228){
_228.style.display="none";
_226.push(_228);
};
}();
_221.BackgroundIframe=function(node){
if(!node.id){
throw new Error("no id");
}
if(has("ie")||has("mozilla")){
var _229=(this.iframe=_225.pop());
node.appendChild(_229);
if(has("ie")<7||has("quirks")){
this.resize(node);
this._conn=on(node,"resize",lang.hitch(this,function(){
this.resize(node);
}));
}else{
_224.set(_229,{width:"100%",height:"100%"});
}
}
};
lang.extend(_221.BackgroundIframe,{resize:function(node){
if(this.iframe){
_224.set(this.iframe,{width:node.offsetWidth+"px",height:node.offsetHeight+"px"});
}
},destroy:function(){
if(this._conn){
this._conn.remove();
this._conn=null;
}
if(this.iframe){
_225.push(this.iframe);
delete this.iframe;
}
}});
return _221.BackgroundIframe;
});
},"dijit/typematic":function(){
define("dijit/typematic",["dojo/_base/array","dojo/_base/connect","dojo/_base/event","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/sniff","./main"],function(_22a,_22b,_22c,_22d,lang,on,has,_22e){
var _22f=(_22e.typematic={_fireEventAndReload:function(){
this._timer=null;
this._callback(++this._count,this._node,this._evt);
this._currentTimeout=Math.max(this._currentTimeout<0?this._initialDelay:(this._subsequentDelay>1?this._subsequentDelay:Math.round(this._currentTimeout*this._subsequentDelay)),this._minDelay);
this._timer=setTimeout(lang.hitch(this,"_fireEventAndReload"),this._currentTimeout);
},trigger:function(evt,_230,node,_231,obj,_232,_233,_234){
if(obj!=this._obj){
this.stop();
this._initialDelay=_233||500;
this._subsequentDelay=_232||0.9;
this._minDelay=_234||10;
this._obj=obj;
this._node=node;
this._currentTimeout=-1;
this._count=-1;
this._callback=lang.hitch(_230,_231);
this._evt={faux:true};
for(var attr in evt){
if(attr!="layerX"&&attr!="layerY"){
var v=evt[attr];
if(typeof v!="function"&&typeof v!="undefined"){
this._evt[attr]=v;
}
}
}
this._fireEventAndReload();
}
},stop:function(){
if(this._timer){
clearTimeout(this._timer);
this._timer=null;
}
if(this._obj){
this._callback(-1,this._node,this._evt);
this._obj=null;
}
},addKeyListener:function(node,_235,_236,_237,_238,_239,_23a){
if(_235.keyCode){
_235.charOrCode=_235.keyCode;
_22d.deprecated("keyCode attribute parameter for dijit.typematic.addKeyListener is deprecated. Use charOrCode instead.","","2.0");
}else{
if(_235.charCode){
_235.charOrCode=String.fromCharCode(_235.charCode);
_22d.deprecated("charCode attribute parameter for dijit.typematic.addKeyListener is deprecated. Use charOrCode instead.","","2.0");
}
}
var _23b=[on(node,_22b._keypress,lang.hitch(this,function(evt){
if(evt.charOrCode==_235.charOrCode&&(_235.ctrlKey===undefined||_235.ctrlKey==evt.ctrlKey)&&(_235.altKey===undefined||_235.altKey==evt.altKey)&&(_235.metaKey===undefined||_235.metaKey==(evt.metaKey||false))&&(_235.shiftKey===undefined||_235.shiftKey==evt.shiftKey)){
_22c.stop(evt);
_22f.trigger(evt,_236,node,_237,_235,_238,_239,_23a);
}else{
if(_22f._obj==_235){
_22f.stop();
}
}
})),on(node,"keyup",lang.hitch(this,function(){
if(_22f._obj==_235){
_22f.stop();
}
}))];
return {remove:function(){
_22a.forEach(_23b,function(h){
h.remove();
});
}};
},addMouseListener:function(node,_23c,_23d,_23e,_23f,_240){
var _241=[on(node,"mousedown",lang.hitch(this,function(evt){
evt.preventDefault();
_22f.trigger(evt,_23c,node,_23d,node,_23e,_23f,_240);
})),on(node,"mouseup",lang.hitch(this,function(evt){
if(this._obj){
evt.preventDefault();
}
_22f.stop();
})),on(node,"mouseout",lang.hitch(this,function(evt){
if(this._obj){
evt.preventDefault();
}
_22f.stop();
})),on(node,"dblclick",lang.hitch(this,function(evt){
evt.preventDefault();
if(has("ie")<9){
_22f.trigger(evt,_23c,node,_23d,node,_23e,_23f,_240);
setTimeout(lang.hitch(this,_22f.stop),50);
}
}))];
return {remove:function(){
_22a.forEach(_241,function(h){
h.remove();
});
}};
},addListener:function(_242,_243,_244,_245,_246,_247,_248,_249){
var _24a=[this.addKeyListener(_243,_244,_245,_246,_247,_248,_249),this.addMouseListener(_242,_245,_246,_247,_248,_249)];
return {remove:function(){
_22a.forEach(_24a,function(h){
h.remove();
});
}};
}});
return _22f;
});
},"dijit/form/_ButtonMixin":function(){
define("dijit/form/_ButtonMixin",["dojo/_base/declare","dojo/dom","dojo/_base/event","../registry"],function(_24b,dom,_24c,_24d){
return _24b("dijit.form._ButtonMixin",null,{label:"",type:"button",_onClick:function(e){
if(this.disabled){
_24c.stop(e);
return false;
}
var _24e=this.onClick(e)===false;
if(!_24e&&this.type=="submit"&&!(this.valueNode||this.focusNode).form){
for(var node=this.domNode;node.parentNode;node=node.parentNode){
var _24f=_24d.byNode(node);
if(_24f&&typeof _24f._onSubmit=="function"){
_24f._onSubmit(e);
_24e=true;
break;
}
}
}
if(_24e){
e.preventDefault();
}
return !_24e;
},postCreate:function(){
this.inherited(arguments);
dom.setSelectable(this.focusNode,false);
},onClick:function(){
return true;
},_setLabelAttr:function(_250){
this._set("label",_250);
(this.containerNode||this.focusNode).innerHTML=_250;
}});
});
},"url:dijit/templates/MenuItem.html":"<tr class=\"dijitReset dijitMenuItem\" data-dojo-attach-point=\"focusNode\" role=\"menuitem\" tabIndex=\"-1\">\n\t<td class=\"dijitReset dijitMenuItemIconCell\" role=\"presentation\">\n\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitIcon dijitMenuItemIcon\" data-dojo-attach-point=\"iconNode\"/>\n\t</td>\n\t<td class=\"dijitReset dijitMenuItemLabel\" colspan=\"2\" data-dojo-attach-point=\"containerNode\"></td>\n\t<td class=\"dijitReset dijitMenuItemAccelKey\" style=\"display: none\" data-dojo-attach-point=\"accelKeyNode\"></td>\n\t<td class=\"dijitReset dijitMenuArrowCell\" role=\"presentation\">\n\t\t<div data-dojo-attach-point=\"arrowWrapper\" style=\"visibility: hidden\">\n\t\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitMenuExpand\"/>\n\t\t\t<span class=\"dijitMenuExpandA11y\">+</span>\n\t\t</div>\n\t</td>\n</tr>\n","dojo/data/util/sorter":function(){
define(["../../_base/lang"],function(lang){
var _251={};
lang.setObject("dojo.data.util.sorter",_251);
_251.basicComparator=function(a,b){
var r=-1;
if(a===null){
a=undefined;
}
if(b===null){
b=undefined;
}
if(a==b){
r=0;
}else{
if(a>b||a==null){
r=1;
}
}
return r;
};
_251.createSortFunction=function(_252,_253){
var _254=[];
function _255(attr,dir,comp,s){
return function(_256,_257){
var a=s.getValue(_256,attr);
var b=s.getValue(_257,attr);
return dir*comp(a,b);
};
};
var _258;
var map=_253.comparatorMap;
var bc=_251.basicComparator;
for(var i=0;i<_252.length;i++){
_258=_252[i];
var attr=_258.attribute;
if(attr){
var dir=(_258.descending)?-1:1;
var comp=bc;
if(map){
if(typeof attr!=="string"&&("toString" in attr)){
attr=attr.toString();
}
comp=map[attr]||bc;
}
_254.push(_255(attr,dir,comp,_253));
}
}
return function(rowA,rowB){
var i=0;
while(i<_254.length){
var ret=_254[i++](rowA,rowB);
if(ret!==0){
return ret;
}
}
return 0;
};
};
return _251;
});
},"dojo/text":function(){
define(["./_base/kernel","require","./has","./_base/xhr"],function(dojo,_259,has,xhr){
var _25a;
if(1){
_25a=function(url,sync,load){
xhr("GET",{url:url,sync:!!sync,load:load,headers:dojo.config.textPluginHeaders||{}});
};
}else{
if(_259.getText){
_25a=_259.getText;
}else{
console.error("dojo/text plugin failed to load because loader does not support getText");
}
}
var _25b={},_25c=function(text){
if(text){
text=text.replace(/^\s*<\?xml(\s)+version=[\'\"](\d)*.(\d)*[\'\"](\s)*\?>/im,"");
var _25d=text.match(/<body[^>]*>\s*([\s\S]+)\s*<\/body>/im);
if(_25d){
text=_25d[1];
}
}else{
text="";
}
return text;
},_25e={},_25f={};
dojo.cache=function(_260,url,_261){
var key;
if(typeof _260=="string"){
if(/\//.test(_260)){
key=_260;
_261=url;
}else{
key=_259.toUrl(_260.replace(/\./g,"/")+(url?("/"+url):""));
}
}else{
key=_260+"";
_261=url;
}
var val=(_261!=undefined&&typeof _261!="string")?_261.value:_261,_262=_261&&_261.sanitize;
if(typeof val=="string"){
_25b[key]=val;
return _262?_25c(val):val;
}else{
if(val===null){
delete _25b[key];
return null;
}else{
if(!(key in _25b)){
_25a(key,true,function(text){
_25b[key]=text;
});
}
return _262?_25c(_25b[key]):_25b[key];
}
}
};
return {dynamic:true,normalize:function(id,_263){
var _264=id.split("!"),url=_264[0];
return (/^\./.test(url)?_263(url):url)+(_264[1]?"!"+_264[1]:"");
},load:function(id,_265,load){
var _266=id.split("!"),_267=_266.length>1,_268=_266[0],url=_265.toUrl(_266[0]),_269="url:"+url,text=_25e,_26a=function(text){
load(_267?_25c(text):text);
};
if(_268 in _25b){
text=_25b[_268];
}else{
if(_269 in _265.cache){
text=_265.cache[_269];
}else{
if(url in _25b){
text=_25b[url];
}
}
}
if(text===_25e){
if(_25f[url]){
_25f[url].push(_26a);
}else{
var _26b=_25f[url]=[_26a];
_25a(url,!_265.async,function(text){
_25b[_268]=_25b[url]=text;
for(var i=0;i<_26b.length;){
_26b[i++](text);
}
delete _25f[url];
});
}
}else{
_26a(text);
}
}};
});
},"dijit/registry":function(){
define("dijit/registry",["dojo/_base/array","dojo/sniff","dojo/_base/unload","dojo/_base/window","./main"],function(_26c,has,_26d,win,_26e){
var _26f={},hash={};
var _270={length:0,add:function(_271){
if(hash[_271.id]){
throw new Error("Tried to register widget with id=="+_271.id+" but that id is already registered");
}
hash[_271.id]=_271;
this.length++;
},remove:function(id){
if(hash[id]){
delete hash[id];
this.length--;
}
},byId:function(id){
return typeof id=="string"?hash[id]:id;
},byNode:function(node){
return hash[node.getAttribute("widgetId")];
},toArray:function(){
var ar=[];
for(var id in hash){
ar.push(hash[id]);
}
return ar;
},getUniqueId:function(_272){
var id;
do{
id=_272+"_"+(_272 in _26f?++_26f[_272]:_26f[_272]=0);
}while(hash[id]);
return _26e._scopeName=="dijit"?id:_26e._scopeName+"_"+id;
},findWidgets:function(root,_273){
var _274=[];
function _275(root){
for(var node=root.firstChild;node;node=node.nextSibling){
if(node.nodeType==1){
var _276=node.getAttribute("widgetId");
if(_276){
var _277=hash[_276];
if(_277){
_274.push(_277);
}
}else{
if(node!==_273){
_275(node);
}
}
}
}
};
_275(root);
return _274;
},_destroyAll:function(){
_26e._curFocus=null;
_26e._prevFocus=null;
_26e._activeStack=[];
_26c.forEach(_270.findWidgets(win.body()),function(_278){
if(!_278._destroyed){
if(_278.destroyRecursive){
_278.destroyRecursive();
}else{
if(_278.destroy){
_278.destroy();
}
}
}
});
},getEnclosingWidget:function(node){
while(node){
var id=node.nodeType==1&&node.getAttribute("widgetId");
if(id){
return hash[id];
}
node=node.parentNode;
}
return null;
},_hash:hash};
_26e.registry=_270;
return _270;
});
},"dijit/form/_FormWidgetMixin":function(){
define("dijit/form/_FormWidgetMixin",["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/dom-style","dojo/_base/lang","dojo/mouse","dojo/sniff","dojo/window","../a11y"],function(_279,_27a,_27b,_27c,lang,_27d,has,_27e,a11y){
return _27a("dijit.form._FormWidgetMixin",null,{name:"",alt:"",value:"",type:"text","aria-label":"focusNode",tabIndex:"0",_setTabIndexAttr:"focusNode",disabled:false,intermediateChanges:false,scrollOnFocus:true,_setIdAttr:"focusNode",_setDisabledAttr:function(_27f){
this._set("disabled",_27f);
_27b.set(this.focusNode,"disabled",_27f);
if(this.valueNode){
_27b.set(this.valueNode,"disabled",_27f);
}
this.focusNode.setAttribute("aria-disabled",_27f?"true":"false");
if(_27f){
this._set("hovering",false);
this._set("active",false);
var _280="tabIndex" in this.attributeMap?this.attributeMap.tabIndex:("_setTabIndexAttr" in this)?this._setTabIndexAttr:"focusNode";
_279.forEach(lang.isArray(_280)?_280:[_280],function(_281){
var node=this[_281];
if(has("webkit")||a11y.hasDefaultTabStop(node)){
node.setAttribute("tabIndex","-1");
}else{
node.removeAttribute("tabIndex");
}
},this);
}else{
if(this.tabIndex!=""){
this.set("tabIndex",this.tabIndex);
}
}
},_onFocus:function(by){
if(by=="mouse"&&this.isFocusable()){
var _282=this.connect(this.focusNode,"onfocus",function(){
this.disconnect(_283);
this.disconnect(_282);
});
var _283=this.connect(this.ownerDocumentBody,"onmouseup",function(){
this.disconnect(_283);
this.disconnect(_282);
if(this.focused){
this.focus();
}
});
}
if(this.scrollOnFocus){
this.defer(function(){
_27e.scrollIntoView(this.domNode);
});
}
this.inherited(arguments);
},isFocusable:function(){
return !this.disabled&&this.focusNode&&(_27c.get(this.domNode,"display")!="none");
},focus:function(){
if(!this.disabled&&this.focusNode.focus){
try{
this.focusNode.focus();
}
catch(e){
}
}
},compare:function(val1,val2){
if(typeof val1=="number"&&typeof val2=="number"){
return (isNaN(val1)&&isNaN(val2))?0:val1-val2;
}else{
if(val1>val2){
return 1;
}else{
if(val1<val2){
return -1;
}else{
return 0;
}
}
}
},onChange:function(){
},_onChangeActive:false,_handleOnChange:function(_284,_285){
if(this._lastValueReported==undefined&&(_285===null||!this._onChangeActive)){
this._resetValue=this._lastValueReported=_284;
}
this._pendingOnChange=this._pendingOnChange||(typeof _284!=typeof this._lastValueReported)||(this.compare(_284,this._lastValueReported)!=0);
if((this.intermediateChanges||_285||_285===undefined)&&this._pendingOnChange){
this._lastValueReported=_284;
this._pendingOnChange=false;
if(this._onChangeActive){
if(this._onChangeHandle){
this._onChangeHandle.remove();
}
this._onChangeHandle=this.defer(function(){
this._onChangeHandle=null;
this.onChange(_284);
});
}
}
},create:function(){
this.inherited(arguments);
this._onChangeActive=true;
},destroy:function(){
if(this._onChangeHandle){
this._onChangeHandle.remove();
this.onChange(this._lastValueReported);
}
this.inherited(arguments);
}});
});
},"dojo/uacss":function(){
define(["./dom-geometry","./_base/lang","./ready","./sniff","./_base/window"],function(_286,lang,_287,has,_288){
var html=_288.doc.documentElement,ie=has("ie"),_289=has("opera"),maj=Math.floor,ff=has("ff"),_28a=_286.boxModel.replace(/-/,""),_28b={"dj_quirks":has("quirks"),"dj_opera":_289,"dj_khtml":has("khtml"),"dj_webkit":has("webkit"),"dj_safari":has("safari"),"dj_chrome":has("chrome"),"dj_gecko":has("mozilla")};
if(ie){
_28b["dj_ie"]=true;
_28b["dj_ie"+maj(ie)]=true;
_28b["dj_iequirks"]=has("quirks");
}
if(ff){
_28b["dj_ff"+maj(ff)]=true;
}
_28b["dj_"+_28a]=true;
var _28c="";
for(var clz in _28b){
if(_28b[clz]){
_28c+=clz+" ";
}
}
html.className=lang.trim(html.className+" "+_28c);
_287(90,function(){
if(!_286.isBodyLtr()){
var _28d="dj_rtl dijitRtl "+_28c.replace(/ /g,"-rtl ");
html.className=lang.trim(html.className+" "+_28d+"dj_rtl dijitRtl "+_28c.replace(/ /g,"-rtl "));
}
});
return has;
});
},"dijit/_KeyNavContainer":function(){
define("dijit/_KeyNavContainer",["dojo/_base/kernel","./_Container","./_FocusMixin","dojo/_base/array","dojo/keys","dojo/_base/declare","dojo/_base/event","dojo/dom-attr","dojo/_base/lang"],function(_28e,_28f,_290,_291,keys,_292,_293,_294,lang){
return _292("dijit._KeyNavContainer",[_290,_28f],{tabIndex:"0",connectKeyNavHandlers:function(_295,_296){
var _297=(this._keyNavCodes={});
var prev=lang.hitch(this,"focusPrev");
var next=lang.hitch(this,"focusNext");
_291.forEach(_295,function(code){
_297[code]=prev;
});
_291.forEach(_296,function(code){
_297[code]=next;
});
_297[keys.HOME]=lang.hitch(this,"focusFirstChild");
_297[keys.END]=lang.hitch(this,"focusLastChild");
this.connect(this.domNode,"onkeypress","_onContainerKeypress");
this.connect(this.domNode,"onfocus","_onContainerFocus");
},startupKeyNavChildren:function(){
_28e.deprecated("startupKeyNavChildren() call no longer needed","","2.0");
},startup:function(){
this.inherited(arguments);
_291.forEach(this.getChildren(),lang.hitch(this,"_startupChild"));
},addChild:function(_298,_299){
this.inherited(arguments);
this._startupChild(_298);
},focus:function(){
this.focusFirstChild();
},focusFirstChild:function(){
this.focusChild(this._getFirstFocusableChild());
},focusLastChild:function(){
this.focusChild(this._getLastFocusableChild());
},focusNext:function(){
this.focusChild(this._getNextFocusableChild(this.focusedChild,1));
},focusPrev:function(){
this.focusChild(this._getNextFocusableChild(this.focusedChild,-1),true);
},focusChild:function(_29a,last){
if(!_29a){
return;
}
if(this.focusedChild&&_29a!==this.focusedChild){
this._onChildBlur(this.focusedChild);
}
_29a.set("tabIndex",this.tabIndex);
_29a.focus(last?"end":"start");
this._set("focusedChild",_29a);
},_startupChild:function(_29b){
_29b.set("tabIndex","-1");
this.connect(_29b,"_onFocus",function(){
_29b.set("tabIndex",this.tabIndex);
});
this.connect(_29b,"_onBlur",function(){
_29b.set("tabIndex","-1");
});
},_onContainerFocus:function(evt){
if(evt.target!==this.domNode||this.focusedChild){
return;
}
this.focusFirstChild();
_294.set(this.domNode,"tabIndex","-1");
},_onBlur:function(evt){
if(this.tabIndex){
_294.set(this.domNode,"tabIndex",this.tabIndex);
}
this.focusedChild=null;
this.inherited(arguments);
},_onContainerKeypress:function(evt){
if(evt.ctrlKey||evt.altKey){
return;
}
var func=this._keyNavCodes[evt.charOrCode];
if(func){
func();
_293.stop(evt);
}
},_onChildBlur:function(){
},_getFirstFocusableChild:function(){
return this._getNextFocusableChild(null,1);
},_getLastFocusableChild:function(){
return this._getNextFocusableChild(null,-1);
},_getNextFocusableChild:function(_29c,dir){
if(_29c){
_29c=this._getSiblingOfChild(_29c,dir);
}
var _29d=this.getChildren();
for(var i=0;i<_29d.length;i++){
if(!_29c){
_29c=_29d[(dir>0)?0:(_29d.length-1)];
}
if(_29c.isFocusable()){
return _29c;
}
_29c=this._getSiblingOfChild(_29c,dir);
}
return null;
}});
});
},"dijit/place":function(){
define("dijit/place",["dojo/_base/array","dojo/dom-geometry","dojo/dom-style","dojo/_base/kernel","dojo/_base/window","dojo/window","./main"],function(_29e,_29f,_2a0,_2a1,win,_2a2,_2a3){
function _2a4(node,_2a5,_2a6,_2a7){
var view=_2a2.getBox(node.ownerDocument);
if(!node.parentNode||String(node.parentNode.tagName).toLowerCase()!="body"){
win.body(node.ownerDocument).appendChild(node);
}
var best=null;
_29e.some(_2a5,function(_2a8){
var _2a9=_2a8.corner;
var pos=_2a8.pos;
var _2aa=0;
var _2ab={w:{"L":view.l+view.w-pos.x,"R":pos.x-view.l,"M":view.w}[_2a9.charAt(1)],h:{"T":view.t+view.h-pos.y,"B":pos.y-view.t,"M":view.h}[_2a9.charAt(0)]};
var s=node.style;
s.left=s.right="auto";
if(_2a6){
var res=_2a6(node,_2a8.aroundCorner,_2a9,_2ab,_2a7);
_2aa=typeof res=="undefined"?0:res;
}
var _2ac=node.style;
var _2ad=_2ac.display;
var _2ae=_2ac.visibility;
if(_2ac.display=="none"){
_2ac.visibility="hidden";
_2ac.display="";
}
var bb=_29f.position(node);
_2ac.display=_2ad;
_2ac.visibility=_2ae;
var _2af={"L":pos.x,"R":pos.x-bb.w,"M":Math.max(view.l,Math.min(view.l+view.w,pos.x+(bb.w>>1))-bb.w)}[_2a9.charAt(1)],_2b0={"T":pos.y,"B":pos.y-bb.h,"M":Math.max(view.t,Math.min(view.t+view.h,pos.y+(bb.h>>1))-bb.h)}[_2a9.charAt(0)],_2b1=Math.max(view.l,_2af),_2b2=Math.max(view.t,_2b0),endX=Math.min(view.l+view.w,_2af+bb.w),endY=Math.min(view.t+view.h,_2b0+bb.h),_2b3=endX-_2b1,_2b4=endY-_2b2;
_2aa+=(bb.w-_2b3)+(bb.h-_2b4);
if(best==null||_2aa<best.overflow){
best={corner:_2a9,aroundCorner:_2a8.aroundCorner,x:_2b1,y:_2b2,w:_2b3,h:_2b4,overflow:_2aa,spaceAvailable:_2ab};
}
return !_2aa;
});
if(best.overflow&&_2a6){
_2a6(node,best.aroundCorner,best.corner,best.spaceAvailable,_2a7);
}
var l=_29f.isBodyLtr(node.ownerDocument),s=node.style;
s.top=best.y+"px";
s[l?"left":"right"]=(l?best.x:view.w-best.x-best.w)+"px";
s[l?"right":"left"]="auto";
return best;
};
var _2b5={at:function(node,pos,_2b6,_2b7){
var _2b8=_29e.map(_2b6,function(_2b9){
var c={corner:_2b9,pos:{x:pos.x,y:pos.y}};
if(_2b7){
c.pos.x+=_2b9.charAt(1)=="L"?_2b7.x:-_2b7.x;
c.pos.y+=_2b9.charAt(0)=="T"?_2b7.y:-_2b7.y;
}
return c;
});
return _2a4(node,_2b8);
},around:function(node,_2ba,_2bb,_2bc,_2bd){
var _2be=(typeof _2ba=="string"||"offsetWidth" in _2ba)?_29f.position(_2ba,true):_2ba;
if(_2ba.parentNode){
var _2bf=_2a0.getComputedStyle(_2ba).position=="absolute";
var _2c0=_2ba.parentNode;
while(_2c0&&_2c0.nodeType==1&&_2c0.nodeName!="BODY"){
var _2c1=_29f.position(_2c0,true),pcs=_2a0.getComputedStyle(_2c0);
if(/relative|absolute/.test(pcs.position)){
_2bf=false;
}
if(!_2bf&&/hidden|auto|scroll/.test(pcs.overflow)){
var _2c2=Math.min(_2be.y+_2be.h,_2c1.y+_2c1.h);
var _2c3=Math.min(_2be.x+_2be.w,_2c1.x+_2c1.w);
_2be.x=Math.max(_2be.x,_2c1.x);
_2be.y=Math.max(_2be.y,_2c1.y);
_2be.h=_2c2-_2be.y;
_2be.w=_2c3-_2be.x;
}
if(pcs.position=="absolute"){
_2bf=true;
}
_2c0=_2c0.parentNode;
}
}
var x=_2be.x,y=_2be.y,_2c4="w" in _2be?_2be.w:(_2be.w=_2be.width),_2c5="h" in _2be?_2be.h:(_2a1.deprecated("place.around: dijit/place.__Rectangle: { x:"+x+", y:"+y+", height:"+_2be.height+", width:"+_2c4+" } has been deprecated.  Please use { x:"+x+", y:"+y+", h:"+_2be.height+", w:"+_2c4+" }","","2.0"),_2be.h=_2be.height);
var _2c6=[];
function push(_2c7,_2c8){
_2c6.push({aroundCorner:_2c7,corner:_2c8,pos:{x:{"L":x,"R":x+_2c4,"M":x+(_2c4>>1)}[_2c7.charAt(1)],y:{"T":y,"B":y+_2c5,"M":y+(_2c5>>1)}[_2c7.charAt(0)]}});
};
_29e.forEach(_2bb,function(pos){
var ltr=_2bc;
switch(pos){
case "above-centered":
push("TM","BM");
break;
case "below-centered":
push("BM","TM");
break;
case "after-centered":
ltr=!ltr;
case "before-centered":
push(ltr?"ML":"MR",ltr?"MR":"ML");
break;
case "after":
ltr=!ltr;
case "before":
push(ltr?"TL":"TR",ltr?"TR":"TL");
push(ltr?"BL":"BR",ltr?"BR":"BL");
break;
case "below-alt":
ltr=!ltr;
case "below":
push(ltr?"BL":"BR",ltr?"TL":"TR");
push(ltr?"BR":"BL",ltr?"TR":"TL");
break;
case "above-alt":
ltr=!ltr;
case "above":
push(ltr?"TL":"TR",ltr?"BL":"BR");
push(ltr?"TR":"TL",ltr?"BR":"BL");
break;
default:
push(pos.aroundCorner,pos.corner);
}
});
var _2c9=_2a4(node,_2c6,_2bd,{w:_2c4,h:_2c5});
_2c9.aroundNodePos=_2be;
return _2c9;
}};
return _2a3.place=_2b5;
});
},"dojo/window":function(){
define(["./_base/lang","./sniff","./_base/window","./dom","./dom-geometry","./dom-style"],function(lang,has,_2ca,dom,geom,_2cb){
var _2cc={getBox:function(doc){
doc=doc||_2ca.doc;
var _2cd=(doc.compatMode=="BackCompat")?_2ca.body(doc):doc.documentElement,_2ce=geom.docScroll(doc),w,h;
if(has("touch")){
var _2cf=_2cc.get(doc);
w=_2cf.innerWidth||_2cd.clientWidth;
h=_2cf.innerHeight||_2cd.clientHeight;
}else{
w=_2cd.clientWidth;
h=_2cd.clientHeight;
}
return {l:_2ce.x,t:_2ce.y,w:w,h:h};
},get:function(doc){
if(has("ie")&&_2cc!==document.parentWindow){
doc.parentWindow.execScript("document._parentWindow = window;","Javascript");
var win=doc._parentWindow;
doc._parentWindow=null;
return win;
}
return doc.parentWindow||doc.defaultView;
},scrollIntoView:function(node,pos){
try{
node=dom.byId(node);
var doc=node.ownerDocument||_2ca.doc,body=_2ca.body(doc),html=doc.documentElement||body.parentNode,isIE=has("ie"),isWK=has("webkit");
if((!(has("mozilla")||isIE||isWK||has("opera"))||node==body||node==html)&&(typeof node.scrollIntoView!="undefined")){
node.scrollIntoView(false);
return;
}
var _2d0=doc.compatMode=="BackCompat",_2d1=(isIE>=9&&"frameElement" in node.ownerDocument.parentWindow)?((html.clientHeight>0&&html.clientWidth>0&&(body.clientHeight==0||body.clientWidth==0||body.clientHeight>html.clientHeight||body.clientWidth>html.clientWidth))?html:body):(_2d0?body:html),_2d2=isWK?body:_2d1,_2d3=_2d1.clientWidth,_2d4=_2d1.clientHeight,rtl=!geom.isBodyLtr(doc),_2d5=pos||geom.position(node),el=node.parentNode,_2d6=function(el){
return ((isIE<=6||(isIE&&_2d0))?false:(_2cb.get(el,"position").toLowerCase()=="fixed"));
};
if(_2d6(node)){
return;
}
while(el){
if(el==body){
el=_2d2;
}
var _2d7=geom.position(el),_2d8=_2d6(el);
if(el==_2d2){
_2d7.w=_2d3;
_2d7.h=_2d4;
if(_2d2==html&&isIE&&rtl){
_2d7.x+=_2d2.offsetWidth-_2d7.w;
}
if(_2d7.x<0||!isIE){
_2d7.x=0;
}
if(_2d7.y<0||!isIE){
_2d7.y=0;
}
}else{
var pb=geom.getPadBorderExtents(el);
_2d7.w-=pb.w;
_2d7.h-=pb.h;
_2d7.x+=pb.l;
_2d7.y+=pb.t;
var _2d9=el.clientWidth,_2da=_2d7.w-_2d9;
if(_2d9>0&&_2da>0){
_2d7.w=_2d9;
_2d7.x+=(rtl&&(isIE||el.clientLeft>pb.l))?_2da:0;
}
_2d9=el.clientHeight;
_2da=_2d7.h-_2d9;
if(_2d9>0&&_2da>0){
_2d7.h=_2d9;
}
}
if(_2d8){
if(_2d7.y<0){
_2d7.h+=_2d7.y;
_2d7.y=0;
}
if(_2d7.x<0){
_2d7.w+=_2d7.x;
_2d7.x=0;
}
if(_2d7.y+_2d7.h>_2d4){
_2d7.h=_2d4-_2d7.y;
}
if(_2d7.x+_2d7.w>_2d3){
_2d7.w=_2d3-_2d7.x;
}
}
var l=_2d5.x-_2d7.x,t=_2d5.y-Math.max(_2d7.y,0),r=l+_2d5.w-_2d7.w,bot=t+_2d5.h-_2d7.h;
if(r*l>0){
var s=Math[l<0?"max":"min"](l,r);
if(rtl&&((isIE==8&&!_2d0)||isIE>=9)){
s=-s;
}
_2d5.x+=el.scrollLeft;
el.scrollLeft+=s;
_2d5.x-=el.scrollLeft;
}
if(bot*t>0){
_2d5.y+=el.scrollTop;
el.scrollTop+=Math[t<0?"max":"min"](t,bot);
_2d5.y-=el.scrollTop;
}
el=(el!=_2d2)&&!_2d8&&el.parentNode;
}
}
catch(error){
console.error("scrollIntoView: "+error);
node.scrollIntoView(false);
}
}};
1&&lang.setObject("dojo.window",_2cc);
return _2cc;
});
},"dojo/dnd/Mover":function(){
define(["../_base/array","../_base/declare","../_base/event","../_base/lang","../sniff","../_base/window","../dom","../dom-geometry","../dom-style","../Evented","../on","../touch","./common","./autoscroll"],function(_2db,_2dc,_2dd,lang,has,win,dom,_2de,_2df,_2e0,on,_2e1,dnd,_2e2){
return _2dc("dojo.dnd.Mover",[_2e0],{constructor:function(node,e,host){
this.node=dom.byId(node);
this.marginBox={l:e.pageX,t:e.pageY};
this.mouseButton=e.button;
var h=(this.host=host),d=node.ownerDocument;
this.events=[on(d,_2e1.move,lang.hitch(this,"onFirstMove")),on(d,_2e1.move,lang.hitch(this,"onMouseMove")),on(d,_2e1.release,lang.hitch(this,"onMouseUp")),on(d,"dragstart",_2dd.stop),on(d.body,"selectstart",_2dd.stop)];
_2e2.autoScrollStart(d);
if(h&&h.onMoveStart){
h.onMoveStart(this);
}
},onMouseMove:function(e){
_2e2.autoScroll(e);
var m=this.marginBox;
this.host.onMove(this,{l:m.l+e.pageX,t:m.t+e.pageY},e);
_2dd.stop(e);
},onMouseUp:function(e){
if(has("webkit")&&has("mac")&&this.mouseButton==2?e.button==0:this.mouseButton==e.button){
this.destroy();
}
_2dd.stop(e);
},onFirstMove:function(e){
var s=this.node.style,l,t,h=this.host;
switch(s.position){
case "relative":
case "absolute":
l=Math.round(parseFloat(s.left))||0;
t=Math.round(parseFloat(s.top))||0;
break;
default:
s.position="absolute";
var m=_2de.getMarginBox(this.node);
var b=win.doc.body;
var bs=_2df.getComputedStyle(b);
var bm=_2de.getMarginBox(b,bs);
var bc=_2de.getContentBox(b,bs);
l=m.l-(bc.l-bm.l);
t=m.t-(bc.t-bm.t);
break;
}
this.marginBox.l=l-this.marginBox.l;
this.marginBox.t=t-this.marginBox.t;
if(h&&h.onFirstMove){
h.onFirstMove(this,e);
}
this.events.shift().remove();
},destroy:function(){
_2db.forEach(this.events,function(_2e3){
_2e3.remove();
});
var h=this.host;
if(h&&h.onMoveStop){
h.onMoveStop(this);
}
this.events=this.node=this.host=null;
}});
});
},"dijit/MenuSeparator":function(){
require({cache:{"url:dijit/templates/MenuSeparator.html":"<tr class=\"dijitMenuSeparator\">\n\t<td class=\"dijitMenuSeparatorIconCell\">\n\t\t<div class=\"dijitMenuSeparatorTop\"></div>\n\t\t<div class=\"dijitMenuSeparatorBottom\"></div>\n\t</td>\n\t<td colspan=\"3\" class=\"dijitMenuSeparatorLabelCell\">\n\t\t<div class=\"dijitMenuSeparatorTop dijitMenuSeparatorLabel\"></div>\n\t\t<div class=\"dijitMenuSeparatorBottom\"></div>\n\t</td>\n</tr>"}});
define("dijit/MenuSeparator",["dojo/_base/declare","dojo/dom","./_WidgetBase","./_TemplatedMixin","./_Contained","dojo/text!./templates/MenuSeparator.html"],function(_2e4,dom,_2e5,_2e6,_2e7,_2e8){
return _2e4("dijit.MenuSeparator",[_2e5,_2e6,_2e7],{templateString:_2e8,buildRendering:function(){
this.inherited(arguments);
dom.setSelectable(this.domNode,false);
},isFocusable:function(){
return false;
}});
});
},"dijit/form/Button":function(){
require({cache:{"url:dijit/form/templates/Button.html":"<span class=\"dijit dijitReset dijitInline\" role=\"presentation\"\n\t><span class=\"dijitReset dijitInline dijitButtonNode\"\n\t\tdata-dojo-attach-event=\"ondijitclick:_onClick\" role=\"presentation\"\n\t\t><span class=\"dijitReset dijitStretch dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"titleNode,focusNode\"\n\t\t\trole=\"button\" aria-labelledby=\"${id}_label\"\n\t\t\t><span class=\"dijitReset dijitInline dijitIcon\" data-dojo-attach-point=\"iconNode\"></span\n\t\t\t><span class=\"dijitReset dijitToggleButtonIconChar\">&#x25CF;</span\n\t\t\t><span class=\"dijitReset dijitInline dijitButtonText\"\n\t\t\t\tid=\"${id}_label\"\n\t\t\t\tdata-dojo-attach-point=\"containerNode\"\n\t\t\t></span\n\t\t></span\n\t></span\n\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" class=\"dijitOffScreen\"\n\t\ttabIndex=\"-1\" role=\"presentation\" data-dojo-attach-point=\"valueNode\"\n/></span>\n"}});
define("dijit/form/Button",["require","dojo/_base/declare","dojo/dom-class","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/ready","./_FormWidget","./_ButtonMixin","dojo/text!./templates/Button.html"],function(_2e9,_2ea,_2eb,has,_2ec,lang,_2ed,_2ee,_2ef,_2f0){
if(has("dijit-legacy-requires")){
_2ed(0,function(){
var _2f1=["dijit/form/DropDownButton","dijit/form/ComboButton","dijit/form/ToggleButton"];
_2e9(_2f1);
});
}
return _2ea("dijit.form.Button",[_2ee,_2ef],{showLabel:true,iconClass:"dijitNoIcon",_setIconClassAttr:{node:"iconNode",type:"class"},baseClass:"dijitButton",templateString:_2f0,_setValueAttr:"valueNode",_onClick:function(e){
var ok=this.inherited(arguments);
if(ok){
if(this.valueNode){
this.valueNode.click();
e.preventDefault();
e.stopPropagation();
}
}
return ok;
},_fillContent:function(_2f2){
if(_2f2&&(!this.params||!("label" in this.params))){
var _2f3=lang.trim(_2f2.innerHTML);
if(_2f3){
this.label=_2f3;
}
}
},_setShowLabelAttr:function(val){
if(this.containerNode){
_2eb.toggle(this.containerNode,"dijitDisplayNone",!val);
}
this._set("showLabel",val);
},setLabel:function(_2f4){
_2ec.deprecated("dijit.form.Button.setLabel() is deprecated.  Use set('label', ...) instead.","","2.0");
this.set("label",_2f4);
},_setLabelAttr:function(_2f5){
this.inherited(arguments);
if(!this.showLabel&&!("title" in this.params)){
this.titleNode.title=lang.trim(this.containerNode.innerText||this.containerNode.textContent||"");
}
}});
});
},"dijit/Tooltip":function(){
require({cache:{"url:dijit/templates/Tooltip.html":"<div class=\"dijitTooltip dijitTooltipLeft\" id=\"dojoTooltip\"\n\t><div class=\"dijitTooltipContainer dijitTooltipContents\" data-dojo-attach-point=\"containerNode\" role='alert'></div\n\t><div class=\"dijitTooltipConnector\" data-dojo-attach-point=\"connectorNode\"></div\n></div>\n"}});
define("dijit/Tooltip",["dojo/_base/array","dojo/_base/declare","dojo/_base/fx","dojo/dom","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang","dojo/mouse","dojo/on","dojo/sniff","./_base/manager","./place","./_Widget","./_TemplatedMixin","./BackgroundIframe","dojo/text!./templates/Tooltip.html","./main"],function(_2f6,_2f7,fx,dom,_2f8,_2f9,_2fa,lang,_2fb,on,has,_2fc,_2fd,_2fe,_2ff,_300,_301,_302){
var _303=_2f7("dijit._MasterTooltip",[_2fe,_2ff],{duration:_2fc.defaultDuration,templateString:_301,postCreate:function(){
this.ownerDocumentBody.appendChild(this.domNode);
this.bgIframe=new _300(this.domNode);
this.fadeIn=fx.fadeIn({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onShow")});
this.fadeOut=fx.fadeOut({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onHide")});
},show:function(_304,_305,_306,rtl,_307){
if(this.aroundNode&&this.aroundNode===_305&&this.containerNode.innerHTML==_304){
return;
}
if(this.fadeOut.status()=="playing"){
this._onDeck=arguments;
return;
}
this.containerNode.innerHTML=_304;
if(_307){
this.set("textDir",_307);
}
this.containerNode.align=rtl?"right":"left";
var pos=_2fd.around(this.domNode,_305,_306&&_306.length?_306:_308.defaultPosition,!rtl,lang.hitch(this,"orient"));
var _309=pos.aroundNodePos;
if(pos.corner.charAt(0)=="M"&&pos.aroundCorner.charAt(0)=="M"){
this.connectorNode.style.top=_309.y+((_309.h-this.connectorNode.offsetHeight)>>1)-pos.y+"px";
this.connectorNode.style.left="";
}else{
if(pos.corner.charAt(1)=="M"&&pos.aroundCorner.charAt(1)=="M"){
this.connectorNode.style.left=_309.x+((_309.w-this.connectorNode.offsetWidth)>>1)-pos.x+"px";
}else{
this.connectorNode.style.left="";
this.connectorNode.style.top="";
}
}
_2fa.set(this.domNode,"opacity",0);
this.fadeIn.play();
this.isShowingNow=true;
this.aroundNode=_305;
},orient:function(node,_30a,_30b,_30c,_30d){
this.connectorNode.style.top="";
var _30e=_30c.h,_30f=_30c.w;
node.className="dijitTooltip "+{"MR-ML":"dijitTooltipRight","ML-MR":"dijitTooltipLeft","TM-BM":"dijitTooltipAbove","BM-TM":"dijitTooltipBelow","BL-TL":"dijitTooltipBelow dijitTooltipABLeft","TL-BL":"dijitTooltipAbove dijitTooltipABLeft","BR-TR":"dijitTooltipBelow dijitTooltipABRight","TR-BR":"dijitTooltipAbove dijitTooltipABRight","BR-BL":"dijitTooltipRight","BL-BR":"dijitTooltipLeft"}[_30a+"-"+_30b];
this.domNode.style.width="auto";
var size=_2f9.position(this.domNode);
if(has("ie")==9){
size.w+=2;
}
var _310=Math.min((Math.max(_30f,1)),size.w);
_2f9.setMarginBox(this.domNode,{w:_310});
if(_30b.charAt(0)=="B"&&_30a.charAt(0)=="B"){
var bb=_2f9.position(node);
var _311=this.connectorNode.offsetHeight;
if(bb.h>_30e){
var _312=_30e-((_30d.h+_311)>>1);
this.connectorNode.style.top=_312+"px";
this.connectorNode.style.bottom="";
}else{
this.connectorNode.style.bottom=Math.min(Math.max(_30d.h/2-_311/2,0),bb.h-_311)+"px";
this.connectorNode.style.top="";
}
}else{
this.connectorNode.style.top="";
this.connectorNode.style.bottom="";
}
return Math.max(0,size.w-_30f);
},_onShow:function(){
if(has("ie")){
this.domNode.style.filter="";
}
},hide:function(_313){
if(this._onDeck&&this._onDeck[1]==_313){
this._onDeck=null;
}else{
if(this.aroundNode===_313){
this.fadeIn.stop();
this.isShowingNow=false;
this.aroundNode=null;
this.fadeOut.play();
}else{
}
}
},_onHide:function(){
this.domNode.style.cssText="";
this.containerNode.innerHTML="";
if(this._onDeck){
this.show.apply(this,this._onDeck);
this._onDeck=null;
}
},_setAutoTextDir:function(node){
this.applyTextDir(node,has("ie")?node.outerText:node.textContent);
_2f6.forEach(node.children,function(_314){
this._setAutoTextDir(_314);
},this);
},_setTextDirAttr:function(_315){
this._set("textDir",_315);
if(_315=="auto"){
this._setAutoTextDir(this.containerNode);
}else{
this.containerNode.dir=this.textDir;
}
}});
_302.showTooltip=function(_316,_317,_318,rtl,_319){
if(_318){
_318=_2f6.map(_318,function(val){
return {after:"after-centered",before:"before-centered"}[val]||val;
});
}
if(!_308._masterTT){
_302._masterTT=_308._masterTT=new _303();
}
return _308._masterTT.show(_316,_317,_318,rtl,_319);
};
_302.hideTooltip=function(_31a){
return _308._masterTT&&_308._masterTT.hide(_31a);
};
var _308=_2f7("dijit.Tooltip",_2fe,{label:"",showDelay:400,connectId:[],position:[],selector:"",_setConnectIdAttr:function(_31b){
_2f6.forEach(this._connections||[],function(_31c){
_2f6.forEach(_31c,function(_31d){
_31d.remove();
});
},this);
this._connectIds=_2f6.filter(lang.isArrayLike(_31b)?_31b:(_31b?[_31b]:[]),function(id){
return dom.byId(id,this.ownerDocument);
},this);
this._connections=_2f6.map(this._connectIds,function(id){
var node=dom.byId(id,this.ownerDocument),_31e=this.selector,_31f=_31e?function(_320){
return on.selector(_31e,_320);
}:function(_321){
return _321;
},self=this;
return [on(node,_31f(_2fb.enter),function(){
self._onHover(this);
}),on(node,_31f("focusin"),function(){
self._onHover(this);
}),on(node,_31f(_2fb.leave),lang.hitch(self,"_onUnHover")),on(node,_31f("focusout"),lang.hitch(self,"_onUnHover"))];
},this);
this._set("connectId",_31b);
},addTarget:function(node){
var id=node.id||node;
if(_2f6.indexOf(this._connectIds,id)==-1){
this.set("connectId",this._connectIds.concat(id));
}
},removeTarget:function(node){
var id=node.id||node,idx=_2f6.indexOf(this._connectIds,id);
if(idx>=0){
this._connectIds.splice(idx,1);
this.set("connectId",this._connectIds);
}
},buildRendering:function(){
this.inherited(arguments);
_2f8.add(this.domNode,"dijitTooltipData");
},startup:function(){
this.inherited(arguments);
var ids=this.connectId;
_2f6.forEach(lang.isArrayLike(ids)?ids:[ids],this.addTarget,this);
},getContent:function(node){
return this.label||this.domNode.innerHTML;
},_onHover:function(_322){
if(!this._showTimer){
this._showTimer=this.defer(function(){
this.open(_322);
},this.showDelay);
}
},_onUnHover:function(){
if(this._showTimer){
this._showTimer.remove();
delete this._showTimer;
}
this.close();
},open:function(_323){
if(this._showTimer){
this._showTimer.remove();
delete this._showTimer;
}
var _324=this.getContent(_323);
if(!_324){
return;
}
_308.show(_324,_323,this.position,!this.isLeftToRight(),this.textDir);
this._connectNode=_323;
this.onShow(_323,this.position);
},close:function(){
if(this._connectNode){
_308.hide(this._connectNode);
delete this._connectNode;
this.onHide();
}
if(this._showTimer){
this._showTimer.remove();
delete this._showTimer;
}
},onShow:function(){
},onHide:function(){
},destroy:function(){
this.close();
_2f6.forEach(this._connections||[],function(_325){
_2f6.forEach(_325,function(_326){
_326.remove();
});
},this);
this.inherited(arguments);
}});
_308._MasterTooltip=_303;
_308.show=_302.showTooltip;
_308.hide=_302.hideTooltip;
_308.defaultPosition=["after-centered","before-centered"];
return _308;
});
},"dijit/form/_FormValueWidget":function(){
define("dijit/form/_FormValueWidget",["dojo/_base/declare","dojo/sniff","./_FormWidget","./_FormValueMixin"],function(_327,has,_328,_329){
return _327("dijit.form._FormValueWidget",[_328,_329],{_layoutHackIE7:function(){
if(has("ie")==7){
var _32a=this.domNode;
var _32b=_32a.parentNode;
var _32c=_32a.firstChild||_32a;
var _32d=_32c.style.filter;
var _32e=this;
while(_32b&&_32b.clientHeight==0){
(function ping(){
var _32f=_32e.connect(_32b,"onscroll",function(){
_32e.disconnect(_32f);
_32c.style.filter=(new Date()).getMilliseconds();
_32e.defer(function(){
_32c.style.filter=_32d;
});
});
})();
_32b=_32b.parentNode;
}
}
}});
});
},"dojo/dnd/move":function(){
define(["../_base/declare","../dom-geometry","../dom-style","./common","./Mover","./Moveable"],function(_330,_331,_332,dnd,_333,_334){
var _335=_330("dojo.dnd.move.constrainedMoveable",_334,{constraints:function(){
},within:false,constructor:function(node,_336){
if(!_336){
_336={};
}
this.constraints=_336.constraints;
this.within=_336.within;
},onFirstMove:function(_337){
var c=this.constraintBox=this.constraints.call(this,_337);
c.r=c.l+c.w;
c.b=c.t+c.h;
if(this.within){
var mb=_331.getMarginSize(_337.node);
c.r-=mb.w;
c.b-=mb.h;
}
},onMove:function(_338,_339){
var c=this.constraintBox,s=_338.node.style;
this.onMoving(_338,_339);
_339.l=_339.l<c.l?c.l:c.r<_339.l?c.r:_339.l;
_339.t=_339.t<c.t?c.t:c.b<_339.t?c.b:_339.t;
s.left=_339.l+"px";
s.top=_339.t+"px";
this.onMoved(_338,_339);
}});
var _33a=_330("dojo.dnd.move.boxConstrainedMoveable",_335,{box:{},constructor:function(node,_33b){
var box=_33b&&_33b.box;
this.constraints=function(){
return box;
};
}});
var _33c=_330("dojo.dnd.move.parentConstrainedMoveable",_335,{area:"content",constructor:function(node,_33d){
var area=_33d&&_33d.area;
this.constraints=function(){
var n=this.node.parentNode,s=_332.getComputedStyle(n),mb=_331.getMarginBox(n,s);
if(area=="margin"){
return mb;
}
var t=_331.getMarginExtents(n,s);
mb.l+=t.l,mb.t+=t.t,mb.w-=t.w,mb.h-=t.h;
if(area=="border"){
return mb;
}
t=_331.getBorderExtents(n,s);
mb.l+=t.l,mb.t+=t.t,mb.w-=t.w,mb.h-=t.h;
if(area=="padding"){
return mb;
}
t=_331.getPadExtents(n,s);
mb.l+=t.l,mb.t+=t.t,mb.w-=t.w,mb.h-=t.h;
return mb;
};
}});
return {constrainedMoveable:_335,boxConstrainedMoveable:_33a,parentConstrainedMoveable:_33c};
});
},"dijit/_OnDijitClickMixin":function(){
define("dijit/_OnDijitClickMixin",["dojo/on","dojo/_base/array","dojo/keys","dojo/_base/declare","dojo/has","dojo/_base/unload","dojo/_base/window","./a11yclick"],function(on,_33e,keys,_33f,has,_340,win,_341){
var ret=_33f("dijit._OnDijitClickMixin",null,{connect:function(obj,_342,_343){
return this.inherited(arguments,[obj,_342=="ondijitclick"?_341:_342,_343]);
}});
ret.a11yclick=_341;
return ret;
});
},"dijit/a11yclick":function(){
define("dijit/a11yclick",["dojo/on","dojo/_base/array","dojo/keys","dojo/_base/declare","dojo/has","dojo/_base/unload","dojo/_base/window"],function(on,_344,keys,_345,has,_346,win){
var _347=null;
if(has("dom-addeventlistener")){
win.doc.addEventListener("keydown",function(evt){
_347=evt.target;
},true);
}else{
(function(){
var _348=function(evt){
_347=evt.srcElement;
};
win.doc.attachEvent("onkeydown",_348);
_346.addOnWindowUnload(function(){
win.doc.detachEvent("onkeydown",_348);
});
})();
}
function _349(e){
return (e.keyCode===keys.ENTER||e.keyCode===keys.SPACE)&&!e.ctrlKey&&!e.shiftKey&&!e.altKey&&!e.metaKey;
};
return function(node,_34a){
if(/input|button/i.test(node.nodeName)){
return on(node,"click",_34a);
}else{
var _34b=[on(node,"keydown",function(e){
if(_349(e)){
_347=e.target;
e.preventDefault();
}
}),on(node,"keyup",function(e){
if(_349(e)&&e.target==_347){
_347=null;
on.emit(e.target,"click",{cancelable:true,bubbles:true});
}
}),on(node,"click",function(e){
_34a.call(this,e);
})];
if(has("touch")){
var _34c;
_34b.push(on(node,"touchend",function(e){
var _34d=e.target;
_34c=setTimeout(function(){
_34c=null;
on.emit(_34d,"click",{cancelable:true,bubbles:true});
},600);
}),on(node,"click",function(e){
if(_34c){
clearTimeout(_34c);
}
}));
}
return {remove:function(){
_344.forEach(_34b,function(h){
h.remove();
});
if(_34c){
clearTimeout(_34c);
_34c=null;
}
}};
}
};
return ret;
});
},"dijit/hccss":function(){
define("dijit/hccss",["dojo/dom-class","dojo/hccss","dojo/ready","dojo/_base/window"],function(_34e,has,_34f,win){
_34f(90,function(){
if(has("highcontrast")){
_34e.add(win.body(),"dijit_a11y");
}
});
return has;
});
},"preview/silhouetteiframe":function(){
define("preview/silhouetteiframe",[],function(){
var _350=function(args){
var _351=this.rootNode=args.rootNode;
if(!_351){
return;
}
if(!this.verifyDOMTree(false)){
return;
}
this._isWebKit=navigator.userAgent.indexOf("WebKit")!=-1;
if(args.svgfilename){
this.svgfilename=args.svgfilename;
}
if(args.orientation){
this.orientation=args.orientation;
}
if(args.scalefactor){
this.scalefactor=args.scalefactor;
}
if(args.margin){
this.margin=args.margin;
}
this._silhouette_div_container_orig_style={};
var _352=_351.style;
for(var i=0;i<_352.length;i++){
this._silhouette_div_container_orig_style[_352.item(i)]=_352[_352.item(i)];
}
var _353=_351.querySelectorAll(".silhouetteiframe_iframe");
if(_353.length>0){
this._init_silhouetteiframe_iframe_orig_style();
}else{
this._silhouetteiframe_iframe_orig_style=null;
}
_351._silhouetteiframe=this;
this.addStyleDeclarations();
this.updateObjectElement();
};
var _354=1;
_350.prototype={rootNode:null,svgfilename:undefined,orientation:"portrait",scalefactor:1,margin:0,_object_elem:null,_silhouette_div_container_orig_style:{},_silhouetteiframe_iframe_orig_style:{},_init_silhouetteiframe_iframe_orig_style:function(){
this._silhouetteiframe_iframe_orig_style={};
var _355=this.rootNode.querySelectorAll(".silhouetteiframe_iframe")[0];
var _356=_355.style;
for(var i=0;i<_356.length;i++){
this._silhouetteiframe_iframe_orig_style[_356.item(i)]=_356[_356.item(i)];
}
},verifyDOMTree:function(_357){
var _358=this.rootNode;
if(_358&&_358.children&&_358.children.length){
var _359=_358.children[0];
if(_358.children[0].className==="loading"){
_359=_358.children[1];
}
}else{
console.error("silhouetteiframe.verifyDOMTree(): no children on rootNode");
return false;
}
if(_357){
if(_358.children.length<2){
console.error("silhouetteiframe.verifyDOMTree(): iframe child not present");
return false;
}
var _35a;
if(_358.children[0].className==="loading"){
_35a=_358.children[2];
}else{
_35a=_358.children[1];
}
}
if(_358.nodeName!="DIV"||_358.className.indexOf("silhouette_div_container")==-1||!_359||_359.nodeName!="SPAN"||_359.className.indexOf("silhouetteiframe_object_container")==-1||(_357&&(!_35a||_35a.nodeName!="IFRAME"||_35a.className.indexOf("silhouetteiframe_iframe")==-1))){
console.error("silhouetteiframe.verifyDOMTree(): incorrect DOM tree on rootNode");
return false;
}
return true;
},addStyleDeclarations:function(){
var _35b=document.querySelectorAll("style.silhouetteiframe_styles");
if(_35b.length==0){
var _35c=document.querySelectorAll("head")[0];
if(!_35c){
console.error("silhouetteiframe.js addStyleDeclarations(): no HEAD element");
return;
}
var _35d=document.createElement("style");
_35d.setAttribute("type","text/css");
_35d.setAttribute("class","silhouetteiframe_styles");
_35d.innerHTML=".silhouetteiframe_div_container { display:inline-block; text-align:left; }\n"+".silhouetteiframe_iframe { position:absolute; top:0px; left:0px; border:none; }";
_35c.appendChild(_35d);
}
},_restoreStyle:function(_35e,_35f){
if(_35e){
for(var i=_35e.length-1;i>=0;i--){
_35e.removeProperty(_35e.item(i));
}
if(_35f){
for(var i in _35f){
_35e[i]=_35f[i];
}
}
}
},updateObjectElement:function(){
var _360=this.rootNode.querySelectorAll(".silhouetteiframe_object_container",this.rootNode);
if(_360.length==0){
return;
}
var _361=_360[0];
_361.innerHTML="";
this.object_elem=null;
if(this.svgfilename){
var _362=this.rootNode;
if(!this.verifyDOMTree(true)){
return;
}
if(this._silhouetteiframe_iframe_orig_style===null){
this._init_silhouetteiframe_iframe_orig_style();
}
_361.innerHTML="<object class=\"silhouetteiframe_object\" data=\""+this.svgfilename+"\" type=\"image/svg+xml\" "+"onload=\"event.target.parentNode.parentNode._silhouetteiframe.svgloadhandler(event.target)\"></object>";
}else{
this._restoreStyle(this.rootNode.style,this._silhouette_div_container_orig_style);
var _363=this.rootNode.querySelectorAll(".silhouetteiframe_iframe",this.rootNode);
if(_363.length>0){
var _364=_363[0];
this._restoreStyle(_364.style,this._silhouetteiframe_iframe_orig_style);
}
}
},svgloadhandler:function(_365){
this._object_elem=_365;
var _366=_365.getSVGDocument();
if(_366&&_366.documentURI==_365.data){
this._loadcounter=null;
this._silhouette_reset_size_position(false);
}else{
if(!this._loadcounter){
this._loadcounter=1;
}else{
if(this._loadcounter>=5){
console.error("svgloadhandler failed after 5 tries");
return;
}
this._loadcounter++;
}
this.rootNode.style.display="none";
var that=this;
setTimeout(function(){
that.rootNode.style.display="block";
that._silhouette_reset_size_position(false);
},1);
}
},setSVGFilename:function(_367){
this.svgfilename=_367;
this.updateObjectElement();
},setScaleFactor:function(_368){
this.scalefactor=_368;
if(this._isWebKit){
this.updateObjectElement();
}else{
this._silhouette_reset_size_position(false);
}
},setOrientation:function(_369){
this.orientation=_369;
this._silhouette_reset_size_position(false);
},_silhouette_reset_size_position:function(_36a){
var _36b=this._object_elem;
var _36c=this.orientation;
var _36d=this.scalefactor;
if(!_36b){
return;
}
var _36e=_36b.getSVGDocument();
if(!_36e){
return;
}
var _36f=_36e.documentElement;
var _370=this.rootNode.querySelector(".silhouetteiframe_iframe");
if(!_370){
return;
}
var _371=_36e.querySelector("#DeviceRect");
if(!_371){
return;
}
var _372=_36e.querySelector("#ScreenRect");
if(!_372){
return;
}
var _373=_36e.querySelector("#ResolutionRect");
if(!_373){
}
if(_36d<=0){
return;
}
var _374=this.rootNode;
var _375=_371.getAttribute("x")-0;
var _376=_371.getAttribute("y")-0;
var _377=_371.getAttribute("width")-0;
var _378=_371.getAttribute("height")-0;
var _379=_372.getAttribute("x")-0;
var _37a=_372.getAttribute("y")-0;
var _37b=_372.getAttribute("width")-0;
var _37c=_372.getAttribute("height")-0;
var _37d=_379-_375;
var _37e=_37a-_376;
var _37f,_380;
if(_373){
var _381=_373.getAttribute("width")-0;
var _382=_373.getAttribute("height")-0;
if(_381>0&&_382>0&&_37b>0&&_37c>0){
_37f=(_381/_37b)*_36d;
_380=(_382/_37c)*_36d;
}
}
if(!_37f){
var _383=4/3;
_37f=_380=_383*_36d;
}
_371.style.display="none";
_372.style.display="none";
if(_373){
_373.style.display="none";
}
obj_style=_36b.style;
obj_style.overflow="hidden";
var _384=_377*_37f;
var _385=_378*_380;
var _386=_37b*_37f;
var _387=_37c*_380;
var _388=_37d*_37f;
var _389="http://www.w3.org/2000/svg";
var _38a="http://www.w3.org/1999/xlink";
var _38b="_aqzpqtxv";
var _38c="g1"+_38b,_38d="g2"+_38b,_38e="a1"+_38b,_38f="a2"+_38b;
var _390=_36e.getElementById(_38c);
var _391;
if(_390){
_391=_36e.getElementById(_38d);
if(!_391){
return;
}
}else{
_390=_36e.createElementNS(_389,"g");
_390.id=_38c;
_391=_36e.createElementNS(_389,"g");
_391.id=_38d;
_390.appendChild(_391);
var _392=null;
for(var i=_36f.childNodes.length-1;i>=0;i--){
_392=_391.insertBefore(_36f.childNodes[i],_392);
}
_36f.appendChild(_390);
}
var _393=_36e.createElementNS(_389,"rect");
_393.setAttribute("x",_379+1);
_393.setAttribute("y",_37a+1);
_393.setAttribute("width",_37b-2);
_393.setAttribute("height",_37c-2);
_393.setAttribute("fill","lightgray");
_391.appendChild(_393);
var _394=_374.style;
_394.position="relative";
_394.overflow="hidden";
_394.marginLeft="0px";
_394.marginTop="0px";
var _395=_370.style;
var _396=_370.contentDocument.documentElement;
var _397=_396.style;
var _398=_370.contentDocument.body;
var _399=_398.style;
_397.overflow="hidden";
_395.overflow="hidden";
_399.transformOrigin=_399.WebkitTransformOrigin=_399.MozTransformOrigin=_399.msTransformOrigin="left top";
_399.transform=_399.WebkitTransform=_399.MozTransform=_399.msTransform="scale("+_36d+")";
_399.width=(100/_36d)+"%";
_399.height=(100/_36d)+"%";
if(_36c!=="landscape"){
_36f.setAttribute("width",_384+"px");
_36f.setAttribute("height",_385+"px");
_36f.setAttribute("viewBox",0+" "+0+" "+_384+" "+_385);
var _39a=_37e*_380;
_395.marginLeft=_388+"px";
_395.marginTop=_39a+"px";
_395.width=_386+"px";
_395.height=_387+"px";
_390.setAttribute("transform","translate(0 0) rotate(0)");
_391.setAttribute("transform","scale("+_37f+","+_380+") translate(-"+_375+" -"+_376+")");
obj_style.width=_384+"px";
obj_style.height=_385+"px";
_394.width=_384+"px";
_394.height=_385+"px";
setTimeout(function(){
obj_style.width=Math.ceil(_384+1)+"px";
obj_style.height=Math.ceil(_385+1)+"px";
},10);
}else{
_36f.setAttribute("width",_385+"px");
_36f.setAttribute("height",_384+"px");
_36f.setAttribute("viewBox",0+" "+0+" "+_385+" "+_384);
_395.marginLeft=((_378-_37c-_37e)*_380)+"px";
_395.marginTop=_388+"px";
_395.width=_387+"px";
_395.height=_386+"px";
_390.setAttribute("transform","translate("+_385+" 0) rotate(90)");
_391.setAttribute("transform","scale("+_37f+","+_380+") translate(-"+_375+" -"+_376+")");
obj_style.width=_385+"px";
obj_style.height=_384+"px";
_394.width=_385+"px";
_394.height=_384+"px";
setTimeout(function(){
obj_style.width=Math.ceil(_385+1)+"px";
obj_style.height=Math.ceil(_384+1)+"px";
},10);
}
}};
_350.themeMap={"android_340x480.svg":"Android","android_480x800.svg":"Android","androidtablet.svg":"Android","bbplaybook.svg":"BlackBerry","blackberry.svg":"BlackBerry","ipad.svg":"iPad","iphone.svg":"iPhone"};
_350.themeCssMap={"Android":["android/android.css"],"BlackBerry":["blackberry/blackberry.css"],"iPad":["iphone/iphone.css","iphone/ipad.css"],"iPhone":["iphone/iphone.css"]};
_350.getMobileTheme=function(_39b){
return _350.themeMap[_39b.split("/").pop()];
};
_350.getMobileCss=function(_39c){
return _350.themeCssMap[_39c||"iPhone"];
};
return _350;
});
},"dijit/_TemplatedMixin":function(){
define("dijit/_TemplatedMixin",["dojo/_base/lang","dojo/touch","./_WidgetBase","dojo/string","dojo/cache","dojo/_base/array","dojo/_base/declare","dojo/dom-construct","dojo/sniff","dojo/_base/unload"],function(lang,_39d,_39e,_39f,_3a0,_3a1,_3a2,_3a3,has,_3a4){
var _3a5=_3a2("dijit._TemplatedMixin",null,{templateString:null,templatePath:null,_skipNodeCache:false,_earlyTemplatedStartup:false,constructor:function(){
this._attachPoints=[];
this._attachEvents=[];
},_stringRepl:function(tmpl){
var _3a6=this.declaredClass,_3a7=this;
return _39f.substitute(tmpl,this,function(_3a8,key){
if(key.charAt(0)=="!"){
_3a8=lang.getObject(key.substr(1),false,_3a7);
}
if(typeof _3a8=="undefined"){
throw new Error(_3a6+" template:"+key);
}
if(_3a8==null){
return "";
}
return key.charAt(0)=="!"?_3a8:_3a8.toString().replace(/"/g,"&quot;");
},this);
},buildRendering:function(){
if(!this.templateString){
this.templateString=_3a0(this.templatePath,{sanitize:true});
}
var _3a9=_3a5.getCachedTemplate(this.templateString,this._skipNodeCache,this.ownerDocument);
var node;
if(lang.isString(_3a9)){
node=_3a3.toDom(this._stringRepl(_3a9),this.ownerDocument);
if(node.nodeType!=1){
throw new Error("Invalid template: "+_3a9);
}
}else{
node=_3a9.cloneNode(true);
}
this.domNode=node;
this.inherited(arguments);
this._attachTemplateNodes(node,function(n,p){
return n.getAttribute(p);
});
this._beforeFillContent();
this._fillContent(this.srcNodeRef);
},_beforeFillContent:function(){
},_fillContent:function(_3aa){
var dest=this.containerNode;
if(_3aa&&dest){
while(_3aa.hasChildNodes()){
dest.appendChild(_3aa.firstChild);
}
}
},_attachTemplateNodes:function(_3ab,_3ac){
var _3ad=lang.isArray(_3ab)?_3ab:(_3ab.all||_3ab.getElementsByTagName("*"));
var x=lang.isArray(_3ab)?0:-1;
for(;x<0||_3ad[x];x++){
var _3ae=(x==-1)?_3ab:_3ad[x];
if(this.widgetsInTemplate&&(_3ac(_3ae,"dojoType")||_3ac(_3ae,"data-dojo-type"))){
continue;
}
var _3af=_3ac(_3ae,"dojoAttachPoint")||_3ac(_3ae,"data-dojo-attach-point");
if(_3af){
var _3b0,_3b1=_3af.split(/\s*,\s*/);
while((_3b0=_3b1.shift())){
if(lang.isArray(this[_3b0])){
this[_3b0].push(_3ae);
}else{
this[_3b0]=_3ae;
}
this._attachPoints.push(_3b0);
}
}
var _3b2=_3ac(_3ae,"dojoAttachEvent")||_3ac(_3ae,"data-dojo-attach-event");
if(_3b2){
var _3b3,_3b4=_3b2.split(/\s*,\s*/);
var trim=lang.trim;
while((_3b3=_3b4.shift())){
if(_3b3){
var _3b5=null;
if(_3b3.indexOf(":")!=-1){
var _3b6=_3b3.split(":");
_3b3=trim(_3b6[0]);
_3b5=trim(_3b6[1]);
}else{
_3b3=trim(_3b3);
}
if(!_3b5){
_3b5=_3b3;
}
this._attachEvents.push(this.connect(_3ae,_39d[_3b3]||_3b3,_3b5));
}
}
}
}
},destroyRendering:function(){
_3a1.forEach(this._attachPoints,function(_3b7){
delete this[_3b7];
},this);
this._attachPoints=[];
_3a1.forEach(this._attachEvents,this.disconnect,this);
this._attachEvents=[];
this.inherited(arguments);
}});
_3a5._templateCache={};
_3a5.getCachedTemplate=function(_3b8,_3b9,doc){
var _3ba=_3a5._templateCache;
var key=_3b8;
var _3bb=_3ba[key];
if(_3bb){
try{
if(!_3bb.ownerDocument||_3bb.ownerDocument==(doc||document)){
return _3bb;
}
}
catch(e){
}
_3a3.destroy(_3bb);
}
_3b8=_39f.trim(_3b8);
if(_3b9||_3b8.match(/\$\{([^\}]+)\}/g)){
return (_3ba[key]=_3b8);
}else{
var node=_3a3.toDom(_3b8,doc);
if(node.nodeType!=1){
throw new Error("Invalid template: "+_3b8);
}
return (_3ba[key]=node);
}
};
if(has("ie")){
_3a4.addOnWindowUnload(function(){
var _3bc=_3a5._templateCache;
for(var key in _3bc){
var _3bd=_3bc[key];
if(typeof _3bd=="object"){
_3a3.destroy(_3bd);
}
delete _3bc[key];
}
});
}
lang.extend(_39e,{dojoAttachEvent:"",dojoAttachPoint:""});
return _3a5;
});
},"url:dijit/form/templates/Select.html":"<table class=\"dijit dijitReset dijitInline dijitLeft\"\n\tdata-dojo-attach-point=\"_buttonNode,tableNode,focusNode\" cellspacing='0' cellpadding='0'\n\trole=\"listbox\" aria-haspopup=\"true\"\n\t><tbody role=\"presentation\"><tr role=\"presentation\"\n\t\t><td class=\"dijitReset dijitStretch dijitButtonContents\" role=\"presentation\"\n\t\t\t><div class=\"dijitReset dijitInputField dijitButtonText\"  data-dojo-attach-point=\"containerNode,_popupStateNode\" role=\"presentation\"></div\n\t\t\t><div class=\"dijitReset dijitValidationContainer\"\n\t\t\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t\t/></div\n\t\t\t><input type=\"hidden\" ${!nameAttrSetting} data-dojo-attach-point=\"valueNode\" value=\"${value}\" aria-hidden=\"true\"\n\t\t/></td\n\t\t><td class=\"dijitReset dijitRight dijitButtonNode dijitArrowButton dijitDownArrowButton dijitArrowButtonContainer\"\n\t\t\tdata-dojo-attach-point=\"titleNode\" role=\"presentation\"\n\t\t\t><input class=\"dijitReset dijitInputField dijitArrowButtonInner\" value=\"&#9660; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t\t\t${_buttonInputDisabled}\n\t\t/></td\n\t></tr></tbody\n></table>\n","dijit/form/HorizontalSlider":function(){
require({cache:{"url:dijit/form/templates/HorizontalSlider.html":"<table class=\"dijit dijitReset dijitSlider dijitSliderH\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" rules=\"none\" data-dojo-attach-event=\"onkeypress:_onKeyPress,onkeyup:_onKeyUp\"\n\trole=\"presentation\"\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\n\t\t><td data-dojo-attach-point=\"topDecoration\" class=\"dijitReset dijitSliderDecoration dijitSliderDecorationT dijitSliderDecorationH\"></td\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset dijitSliderButtonContainer dijitSliderButtonContainerH\"\n\t\t\t><div class=\"dijitSliderDecrementIconH\" style=\"display:none\" data-dojo-attach-point=\"decrementButton\"><span class=\"dijitSliderButtonInner\">-</span></div\n\t\t></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><div class=\"dijitSliderBar dijitSliderBumper dijitSliderBumperH dijitSliderLeftBumper\" data-dojo-attach-event=\"press:_onClkDecBumper\"></div\n\t\t></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><input data-dojo-attach-point=\"valueNode\" type=\"hidden\" ${!nameAttrSetting}\n\t\t\t/><div class=\"dijitReset dijitSliderBarContainerH\" role=\"presentation\" data-dojo-attach-point=\"sliderBarContainer\"\n\t\t\t\t><div role=\"presentation\" data-dojo-attach-point=\"progressBar\" class=\"dijitSliderBar dijitSliderBarH dijitSliderProgressBar dijitSliderProgressBarH\" data-dojo-attach-event=\"press:_onBarClick\"\n\t\t\t\t\t><div class=\"dijitSliderMoveable dijitSliderMoveableH\"\n\t\t\t\t\t\t><div data-dojo-attach-point=\"sliderHandle,focusNode\" class=\"dijitSliderImageHandle dijitSliderImageHandleH\" data-dojo-attach-event=\"press:_onHandleClick\" role=\"slider\"></div\n\t\t\t\t\t></div\n\t\t\t\t></div\n\t\t\t\t><div role=\"presentation\" data-dojo-attach-point=\"remainingBar\" class=\"dijitSliderBar dijitSliderBarH dijitSliderRemainingBar dijitSliderRemainingBarH\" data-dojo-attach-event=\"press:_onBarClick\"></div\n\t\t\t></div\n\t\t></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><div class=\"dijitSliderBar dijitSliderBumper dijitSliderBumperH dijitSliderRightBumper\" data-dojo-attach-event=\"press:_onClkIncBumper\"></div\n\t\t></td\n\t\t><td class=\"dijitReset dijitSliderButtonContainer dijitSliderButtonContainerH\"\n\t\t\t><div class=\"dijitSliderIncrementIconH\" style=\"display:none\" data-dojo-attach-point=\"incrementButton\"><span class=\"dijitSliderButtonInner\">+</span></div\n\t\t></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\n\t\t><td data-dojo-attach-point=\"containerNode,bottomDecoration\" class=\"dijitReset dijitSliderDecoration dijitSliderDecorationB dijitSliderDecorationH\"></td\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\n\t></tr\n></table>\n"}});
define("dijit/form/HorizontalSlider",["dojo/_base/array","dojo/_base/declare","dojo/dnd/move","dojo/_base/event","dojo/_base/fx","dojo/dom-geometry","dojo/dom-style","dojo/keys","dojo/_base/lang","dojo/sniff","dojo/dnd/Moveable","dojo/dnd/Mover","dojo/query","dojo/mouse","../registry","../focus","../typematic","./Button","./_FormValueWidget","../_Container","dojo/text!./templates/HorizontalSlider.html"],function(_3be,_3bf,move,_3c0,fx,_3c1,_3c2,keys,lang,has,_3c3,_3c4,_3c5,_3c6,_3c7,_3c8,_3c9,_3ca,_3cb,_3cc,_3cd){
var _3ce=_3bf("dijit.form._SliderMover",_3c4,{onMouseMove:function(e){
var _3cf=this.widget;
var _3d0=_3cf._abspos;
if(!_3d0){
_3d0=_3cf._abspos=_3c1.position(_3cf.sliderBarContainer,true);
_3cf._setPixelValue_=lang.hitch(_3cf,"_setPixelValue");
_3cf._isReversed_=_3cf._isReversed();
}
var _3d1=e[_3cf._mousePixelCoord]-_3d0[_3cf._startingPixelCoord];
_3cf._setPixelValue_(_3cf._isReversed_?(_3d0[_3cf._pixelCount]-_3d1):_3d1,_3d0[_3cf._pixelCount],false);
},destroy:function(e){
_3c4.prototype.destroy.apply(this,arguments);
var _3d2=this.widget;
_3d2._abspos=null;
_3d2._setValueAttr(_3d2.value,true);
}});
var _3d3=_3bf("dijit.form.HorizontalSlider",[_3cb,_3cc],{templateString:_3cd,value:0,showButtons:true,minimum:0,maximum:100,discreteValues:Infinity,pageIncrement:2,clickSelect:true,slideDuration:_3c7.defaultDuration,_setIdAttr:"",baseClass:"dijitSlider",cssStateNodes:{incrementButton:"dijitSliderIncrementButton",decrementButton:"dijitSliderDecrementButton",focusNode:"dijitSliderThumb"},_mousePixelCoord:"pageX",_pixelCount:"w",_startingPixelCoord:"x",_handleOffsetCoord:"left",_progressPixelSize:"width",_onKeyUp:function(e){
if(this.disabled||this.readOnly||e.altKey||e.ctrlKey||e.metaKey){
return;
}
this._setValueAttr(this.value,true);
},_onKeyPress:function(e){
if(this.disabled||this.readOnly||e.altKey||e.ctrlKey||e.metaKey){
return;
}
switch(e.charOrCode){
case keys.HOME:
this._setValueAttr(this.minimum,false);
break;
case keys.END:
this._setValueAttr(this.maximum,false);
break;
case ((this._descending||this.isLeftToRight())?keys.RIGHT_ARROW:keys.LEFT_ARROW):
case (this._descending===false?keys.DOWN_ARROW:keys.UP_ARROW):
case (this._descending===false?keys.PAGE_DOWN:keys.PAGE_UP):
this.increment(e);
break;
case ((this._descending||this.isLeftToRight())?keys.LEFT_ARROW:keys.RIGHT_ARROW):
case (this._descending===false?keys.UP_ARROW:keys.DOWN_ARROW):
case (this._descending===false?keys.PAGE_UP:keys.PAGE_DOWN):
this.decrement(e);
break;
default:
return;
}
_3c0.stop(e);
},_onHandleClick:function(e){
if(this.disabled||this.readOnly){
return;
}
if(!has("ie")){
_3c8.focus(this.sliderHandle);
}
_3c0.stop(e);
},_isReversed:function(){
return !this.isLeftToRight();
},_onBarClick:function(e){
if(this.disabled||this.readOnly||!this.clickSelect){
return;
}
_3c8.focus(this.sliderHandle);
_3c0.stop(e);
var _3d4=_3c1.position(this.sliderBarContainer,true);
var _3d5=e[this._mousePixelCoord]-_3d4[this._startingPixelCoord];
this._setPixelValue(this._isReversed()?(_3d4[this._pixelCount]-_3d5):_3d5,_3d4[this._pixelCount],true);
this._movable.onMouseDown(e);
},_setPixelValue:function(_3d6,_3d7,_3d8){
if(this.disabled||this.readOnly){
return;
}
var _3d9=this.discreteValues;
if(_3d9<=1||_3d9==Infinity){
_3d9=_3d7;
}
_3d9--;
var _3da=_3d7/_3d9;
var _3db=Math.round(_3d6/_3da);
this._setValueAttr(Math.max(Math.min((this.maximum-this.minimum)*_3db/_3d9+this.minimum,this.maximum),this.minimum),_3d8);
},_setValueAttr:function(_3dc,_3dd){
this._set("value",_3dc);
this.valueNode.value=_3dc;
this.focusNode.setAttribute("aria-valuenow",_3dc);
this.inherited(arguments);
var _3de=(_3dc-this.minimum)/(this.maximum-this.minimum);
var _3df=(this._descending===false)?this.remainingBar:this.progressBar;
var _3e0=(this._descending===false)?this.progressBar:this.remainingBar;
if(this._inProgressAnim&&this._inProgressAnim.status!="stopped"){
this._inProgressAnim.stop(true);
}
if(_3dd&&this.slideDuration>0&&_3df.style[this._progressPixelSize]){
var _3e1=this;
var _3e2={};
var _3e3=parseFloat(_3df.style[this._progressPixelSize]);
var _3e4=this.slideDuration*(_3de-_3e3/100);
if(_3e4==0){
return;
}
if(_3e4<0){
_3e4=0-_3e4;
}
_3e2[this._progressPixelSize]={start:_3e3,end:_3de*100,units:"%"};
this._inProgressAnim=fx.animateProperty({node:_3df,duration:_3e4,onAnimate:function(v){
_3e0.style[_3e1._progressPixelSize]=(100-parseFloat(v[_3e1._progressPixelSize]))+"%";
},onEnd:function(){
delete _3e1._inProgressAnim;
},properties:_3e2});
this._inProgressAnim.play();
}else{
_3df.style[this._progressPixelSize]=(_3de*100)+"%";
_3e0.style[this._progressPixelSize]=((1-_3de)*100)+"%";
}
},_bumpValue:function(_3e5,_3e6){
if(this.disabled||this.readOnly){
return;
}
var s=_3c2.getComputedStyle(this.sliderBarContainer);
var c=_3c1.getContentBox(this.sliderBarContainer,s);
var _3e7=this.discreteValues;
if(_3e7<=1||_3e7==Infinity){
_3e7=c[this._pixelCount];
}
_3e7--;
var _3e8=(this.value-this.minimum)*_3e7/(this.maximum-this.minimum)+_3e5;
if(_3e8<0){
_3e8=0;
}
if(_3e8>_3e7){
_3e8=_3e7;
}
_3e8=_3e8*(this.maximum-this.minimum)/_3e7+this.minimum;
this._setValueAttr(_3e8,_3e6);
},_onClkBumper:function(val){
if(this.disabled||this.readOnly||!this.clickSelect){
return;
}
this._setValueAttr(val,true);
},_onClkIncBumper:function(){
this._onClkBumper(this._descending===false?this.minimum:this.maximum);
},_onClkDecBumper:function(){
this._onClkBumper(this._descending===false?this.maximum:this.minimum);
},decrement:function(e){
this._bumpValue(e.charOrCode==keys.PAGE_DOWN?-this.pageIncrement:-1);
},increment:function(e){
this._bumpValue(e.charOrCode==keys.PAGE_UP?this.pageIncrement:1);
},_mouseWheeled:function(evt){
_3c0.stop(evt);
this._bumpValue(evt.wheelDelta<0?-1:1,true);
},startup:function(){
if(this._started){
return;
}
_3be.forEach(this.getChildren(),function(_3e9){
if(this[_3e9.container]!=this.containerNode){
this[_3e9.container].appendChild(_3e9.domNode);
}
},this);
this.inherited(arguments);
},_typematicCallback:function(_3ea,_3eb,e){
if(_3ea==-1){
this._setValueAttr(this.value,true);
}else{
this[(_3eb==(this._descending?this.incrementButton:this.decrementButton))?"decrement":"increment"](e);
}
},buildRendering:function(){
this.inherited(arguments);
if(this.showButtons){
this.incrementButton.style.display="";
this.decrementButton.style.display="";
}
var _3ec=_3c5("label[for=\""+this.id+"\"]");
if(_3ec.length){
if(!_3ec[0].id){
_3ec[0].id=this.id+"_label";
}
this.focusNode.setAttribute("aria-labelledby",_3ec[0].id);
}
this.focusNode.setAttribute("aria-valuemin",this.minimum);
this.focusNode.setAttribute("aria-valuemax",this.maximum);
},postCreate:function(){
this.inherited(arguments);
if(this.showButtons){
this.own(_3c9.addMouseListener(this.decrementButton,this,"_typematicCallback",25,500),_3c9.addMouseListener(this.incrementButton,this,"_typematicCallback",25,500));
}
this.connect(this.domNode,_3c6.wheel,"_mouseWheeled");
var _3ed=_3bf(_3ce,{widget:this});
this._movable=new _3c3(this.sliderHandle,{mover:_3ed});
this._layoutHackIE7();
},destroy:function(){
this._movable.destroy();
if(this._inProgressAnim&&this._inProgressAnim.status!="stopped"){
this._inProgressAnim.stop(true);
}
this.inherited(arguments);
}});
_3d3._Mover=_3ce;
return _3d3;
});
},"dijit/form/_FormWidget":function(){
define("dijit/form/_FormWidget",["dojo/_base/declare","dojo/has","dojo/_base/kernel","dojo/ready","../_Widget","../_CssStateMixin","../_TemplatedMixin","./_FormWidgetMixin"],function(_3ee,has,_3ef,_3f0,_3f1,_3f2,_3f3,_3f4){
if(has("dijit-legacy-requires")){
_3f0(0,function(){
var _3f5=["dijit/form/_FormValueWidget"];
require(_3f5);
});
}
return _3ee("dijit.form._FormWidget",[_3f1,_3f3,_3f2,_3f4],{setDisabled:function(_3f6){
_3ef.deprecated("setDisabled("+_3f6+") is deprecated. Use set('disabled',"+_3f6+") instead.","","2.0");
this.set("disabled",_3f6);
},setValue:function(_3f7){
_3ef.deprecated("dijit.form._FormWidget:setValue("+_3f7+") is deprecated.  Use set('value',"+_3f7+") instead.","","2.0");
this.set("value",_3f7);
},getValue:function(){
_3ef.deprecated(this.declaredClass+"::getValue() is deprecated. Use get('value') instead.","","2.0");
return this.get("value");
},postMixInProperties:function(){
this.nameAttrSetting=this.name?("name=\""+this.name.replace(/"/g,"&quot;")+"\""):"";
this.inherited(arguments);
},_setTypeAttr:null});
});
},"dijit/form/HorizontalRule":function(){
define("dijit/form/HorizontalRule",["dojo/_base/declare","../_Widget","../_TemplatedMixin"],function(_3f8,_3f9,_3fa){
return _3f8("dijit.form.HorizontalRule",[_3f9,_3fa],{templateString:"<div class=\"dijitRuleContainer dijitRuleContainerH\"></div>",count:3,container:"containerNode",ruleStyle:"",_positionPrefix:"<div class=\"dijitRuleMark dijitRuleMarkH\" style=\"left:",_positionSuffix:"%;",_suffix:"\"></div>",_genHTML:function(pos){
return this._positionPrefix+pos+this._positionSuffix+this.ruleStyle+this._suffix;
},_isHorizontal:true,buildRendering:function(){
this.inherited(arguments);
var _3fb;
if(this.count==1){
_3fb=this._genHTML(50,0);
}else{
var i;
var _3fc=100/(this.count-1);
if(!this._isHorizontal||this.isLeftToRight()){
_3fb=this._genHTML(0,0);
for(i=1;i<this.count-1;i++){
_3fb+=this._genHTML(_3fc*i,i);
}
_3fb+=this._genHTML(100,this.count-1);
}else{
_3fb=this._genHTML(100,0);
for(i=1;i<this.count-1;i++){
_3fb+=this._genHTML(100-_3fc*i,i);
}
_3fb+=this._genHTML(0,this.count-1);
}
}
this.domNode.innerHTML=_3fb;
}});
});
},"url:dijit/templates/MenuSeparator.html":"<tr class=\"dijitMenuSeparator\">\n\t<td class=\"dijitMenuSeparatorIconCell\">\n\t\t<div class=\"dijitMenuSeparatorTop\"></div>\n\t\t<div class=\"dijitMenuSeparatorBottom\"></div>\n\t</td>\n\t<td colspan=\"3\" class=\"dijitMenuSeparatorLabelCell\">\n\t\t<div class=\"dijitMenuSeparatorTop dijitMenuSeparatorLabel\"></div>\n\t\t<div class=\"dijitMenuSeparatorBottom\"></div>\n\t</td>\n</tr>","dijit/form/HorizontalRuleLabels":function(){
define("dijit/form/HorizontalRuleLabels",["dojo/_base/declare","dojo/number","dojo/query","./HorizontalRule"],function(_3fd,_3fe,_3ff,_400){
return _3fd("dijit.form.HorizontalRuleLabels",_400,{templateString:"<div class=\"dijitRuleContainer dijitRuleContainerH dijitRuleLabelsContainer dijitRuleLabelsContainerH\"></div>",labelStyle:"",labels:[],numericMargin:0,minimum:0,maximum:1,constraints:{pattern:"#%"},_positionPrefix:"<div class=\"dijitRuleLabelContainer dijitRuleLabelContainerH\" style=\"left:",_labelPrefix:"\"><div class=\"dijitRuleLabel dijitRuleLabelH\">",_suffix:"</div></div>",_calcPosition:function(pos){
return pos;
},_genHTML:function(pos,ndx){
return this._positionPrefix+this._calcPosition(pos)+this._positionSuffix+this.labelStyle+this._labelPrefix+this.labels[ndx]+this._suffix;
},getLabels:function(){
var _401=this.labels;
if(!_401.length&&this.srcNodeRef){
_401=_3ff("> li",this.srcNodeRef).map(function(node){
return String(node.innerHTML);
});
}
if(!_401.length&&this.count>1){
var _402=this.minimum;
var inc=(this.maximum-_402)/(this.count-1);
for(var i=0;i<this.count;i++){
_401.push((i<this.numericMargin||i>=(this.count-this.numericMargin))?"":_3fe.format(_402,this.constraints));
_402+=inc;
}
}
return _401;
},postMixInProperties:function(){
this.inherited(arguments);
this.labels=this.getLabels();
this.count=this.labels.length;
}});
});
},"dijit/_HasDropDown":function(){
define("dijit/_HasDropDown",["dojo/_base/declare","dojo/_base/Deferred","dojo/_base/event","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/has","dojo/keys","dojo/_base/lang","dojo/on","dojo/window","./registry","./focus","./popup","./_FocusMixin"],function(_403,_404,_405,dom,_406,_407,_408,_409,has,keys,lang,on,_40a,_40b,_40c,_40d,_40e){
return _403("dijit._HasDropDown",_40e,{_buttonNode:null,_arrowWrapperNode:null,_popupStateNode:null,_aroundNode:null,dropDown:null,autoWidth:true,forceWidth:false,maxHeight:0,dropDownPosition:["below","above"],_stopClickEvents:true,_onDropDownMouseDown:function(e){
if(this.disabled||this.readOnly){
return;
}
e.preventDefault();
this._docHandler=this.connect(this.ownerDocument,"mouseup","_onDropDownMouseUp");
this.toggleDropDown();
},_onDropDownMouseUp:function(e){
if(e&&this._docHandler){
this.disconnect(this._docHandler);
}
var _40f=this.dropDown,_410=false;
if(e&&this._opened){
var c=_408.position(this._buttonNode,true);
if(!(e.pageX>=c.x&&e.pageX<=c.x+c.w)||!(e.pageY>=c.y&&e.pageY<=c.y+c.h)){
var t=e.target;
while(t&&!_410){
if(_407.contains(t,"dijitPopup")){
_410=true;
}else{
t=t.parentNode;
}
}
if(_410){
t=e.target;
if(_40f.onItemClick){
var _411;
while(t&&!(_411=_40b.byNode(t))){
t=t.parentNode;
}
if(_411&&_411.onClick&&_411.getParent){
_411.getParent().onItemClick(_411,e);
}
}
return;
}
}
}
if(this._opened){
if(_40f.focus&&_40f.autoFocus!==false){
this._focusDropDownTimer=this.defer(function(){
_40f.focus();
delete this._focusDropDownTimer;
});
}
}else{
this.defer("focus");
}
if(has("touch")){
this._justGotMouseUp=true;
this.defer(function(){
this._justGotMouseUp=false;
});
}
},_onDropDownClick:function(e){
if(has("touch")&&!this._justGotMouseUp){
this._onDropDownMouseDown(e);
this._onDropDownMouseUp(e);
}
if(this._stopClickEvents){
_405.stop(e);
}
},buildRendering:function(){
this.inherited(arguments);
this._buttonNode=this._buttonNode||this.focusNode||this.domNode;
this._popupStateNode=this._popupStateNode||this.focusNode||this._buttonNode;
var _412={"after":this.isLeftToRight()?"Right":"Left","before":this.isLeftToRight()?"Left":"Right","above":"Up","below":"Down","left":"Left","right":"Right"}[this.dropDownPosition[0]]||this.dropDownPosition[0]||"Down";
_407.add(this._arrowWrapperNode||this._buttonNode,"dijit"+_412+"ArrowButton");
},postCreate:function(){
this.inherited(arguments);
var _413=this.focusNode||this.domNode;
this.own(on(this._buttonNode,"mousedown",lang.hitch(this,"_onDropDownMouseDown")),on(this._buttonNode,"click",lang.hitch(this,"_onDropDownClick")),on(_413,"keydown",lang.hitch(this,"_onKey")),on(_413,"keyup",lang.hitch(this,"_onKeyUp")));
},destroy:function(){
if(this.dropDown){
if(!this.dropDown._destroyed){
this.dropDown.destroyRecursive();
}
delete this.dropDown;
}
this.inherited(arguments);
},_onKey:function(e){
if(this.disabled||this.readOnly){
return;
}
var d=this.dropDown,_414=e.target;
if(d&&this._opened&&d.handleKey){
if(d.handleKey(e)===false){
_405.stop(e);
return;
}
}
if(d&&this._opened&&e.keyCode==keys.ESCAPE){
this.closeDropDown();
_405.stop(e);
}else{
if(!this._opened&&(e.keyCode==keys.DOWN_ARROW||((e.keyCode==keys.ENTER||e.keyCode==keys.SPACE)&&((_414.tagName||"").toLowerCase()!=="input"||(_414.type&&_414.type.toLowerCase()!=="text"))))){
this._toggleOnKeyUp=true;
_405.stop(e);
}
}
},_onKeyUp:function(){
if(this._toggleOnKeyUp){
delete this._toggleOnKeyUp;
this.toggleDropDown();
var d=this.dropDown;
if(d&&d.focus){
this.defer(lang.hitch(d,"focus"),1);
}
}
},_onBlur:function(){
var _415=_40c.curNode&&this.dropDown&&dom.isDescendant(_40c.curNode,this.dropDown.domNode);
this.closeDropDown(_415);
this.inherited(arguments);
},isLoaded:function(){
return true;
},loadDropDown:function(_416){
_416();
},loadAndOpenDropDown:function(){
var d=new _404(),_417=lang.hitch(this,function(){
this.openDropDown();
d.resolve(this.dropDown);
});
if(!this.isLoaded()){
this.loadDropDown(_417);
}else{
_417();
}
return d;
},toggleDropDown:function(){
if(this.disabled||this.readOnly){
return;
}
if(!this._opened){
this.loadAndOpenDropDown();
}else{
this.closeDropDown();
}
},openDropDown:function(){
var _418=this.dropDown,_419=_418.domNode,_41a=this._aroundNode||this.domNode,self=this;
if(!this._preparedNode){
this._preparedNode=true;
if(_419.style.width){
this._explicitDDWidth=true;
}
if(_419.style.height){
this._explicitDDHeight=true;
}
}
if(this.maxHeight||this.forceWidth||this.autoWidth){
var _41b={display:"",visibility:"hidden"};
if(!this._explicitDDWidth){
_41b.width="";
}
if(!this._explicitDDHeight){
_41b.height="";
}
_409.set(_419,_41b);
var _41c=this.maxHeight;
if(_41c==-1){
var _41d=_40a.getBox(this.ownerDocument),_41e=_408.position(_41a,false);
_41c=Math.floor(Math.max(_41e.y,_41d.h-(_41e.y+_41e.h)));
}
_40d.moveOffScreen(_418);
if(_418.startup&&!_418._started){
_418.startup();
}
var mb=_408.getMarginSize(_419);
var _41f=(_41c&&mb.h>_41c);
_409.set(_419,{overflowX:"visible",overflowY:_41f?"auto":"visible"});
if(_41f){
mb.h=_41c;
if("w" in mb){
mb.w+=16;
}
}else{
delete mb.h;
}
if(this.forceWidth){
mb.w=_41a.offsetWidth;
}else{
if(this.autoWidth){
mb.w=Math.max(mb.w,_41a.offsetWidth);
}else{
delete mb.w;
}
}
if(lang.isFunction(_418.resize)){
_418.resize(mb);
}else{
_408.setMarginBox(_419,mb);
}
}
var _420=_40d.open({parent:this,popup:_418,around:_41a,orient:this.dropDownPosition,onExecute:function(){
self.closeDropDown(true);
},onCancel:function(){
self.closeDropDown(true);
},onClose:function(){
_406.set(self._popupStateNode,"popupActive",false);
_407.remove(self._popupStateNode,"dijitHasDropDownOpen");
self._set("_opened",false);
}});
_406.set(this._popupStateNode,"popupActive","true");
_407.add(this._popupStateNode,"dijitHasDropDownOpen");
this._set("_opened",true);
this.domNode.setAttribute("aria-expanded","true");
return _420;
},closeDropDown:function(_421){
if(this._focusDropDownTimer){
this._focusDropDownTimer.remove();
delete this._focusDropDownTimer;
}
if(this._opened){
this.domNode.setAttribute("aria-expanded","false");
if(_421){
this.focus();
}
_40d.close(this.dropDown);
this._opened=false;
}
}});
});
},"dijit/_Widget":function(){
define("dijit/_Widget",["dojo/aspect","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/query","dojo/ready","./registry","./_WidgetBase","./_OnDijitClickMixin","./_FocusMixin","dojo/uacss","./hccss"],function(_422,_423,_424,_425,has,_426,lang,_427,_428,_429,_42a,_42b,_42c){
function _42d(){
};
function _42e(_42f){
return function(obj,_430,_431,_432){
if(obj&&typeof _430=="string"&&obj[_430]==_42d){
return obj.on(_430.substring(2).toLowerCase(),lang.hitch(_431,_432));
}
return _42f.apply(_424,arguments);
};
};
_422.around(_424,"connect",_42e);
if(_426.connect){
_422.around(_426,"connect",_42e);
}
var _433=_425("dijit._Widget",[_42a,_42b,_42c],{onClick:_42d,onDblClick:_42d,onKeyDown:_42d,onKeyPress:_42d,onKeyUp:_42d,onMouseDown:_42d,onMouseMove:_42d,onMouseOut:_42d,onMouseOver:_42d,onMouseLeave:_42d,onMouseEnter:_42d,onMouseUp:_42d,constructor:function(_434){
this._toConnect={};
for(var name in _434){
if(this[name]===_42d){
this._toConnect[name.replace(/^on/,"").toLowerCase()]=_434[name];
delete _434[name];
}
}
},postCreate:function(){
this.inherited(arguments);
for(var name in this._toConnect){
this.on(name,this._toConnect[name]);
}
delete this._toConnect;
},on:function(type,func){
if(this[this._onMap(type)]===_42d){
return _424.connect(this.domNode,type.toLowerCase(),this,func);
}
return this.inherited(arguments);
},_setFocusedAttr:function(val){
this._focused=val;
this._set("focused",val);
},setAttribute:function(attr,_435){
_426.deprecated(this.declaredClass+"::setAttribute(attr, value) is deprecated. Use set() instead.","","2.0");
this.set(attr,_435);
},attr:function(name,_436){
if(_423.isDebug){
var _437=arguments.callee._ach||(arguments.callee._ach={}),_438=(arguments.callee.caller||"unknown caller").toString();
if(!_437[_438]){
_426.deprecated(this.declaredClass+"::attr() is deprecated. Use get() or set() instead, called from "+_438,"","2.0");
_437[_438]=true;
}
}
var args=arguments.length;
if(args>=2||typeof name==="object"){
return this.set.apply(this,arguments);
}else{
return this.get(name);
}
},getDescendants:function(){
_426.deprecated(this.declaredClass+"::getDescendants() is deprecated. Use getChildren() instead.","","2.0");
return this.containerNode?_427("[widgetId]",this.containerNode).map(_429.byNode):[];
},_onShow:function(){
this.onShow();
},onShow:function(){
},onHide:function(){
},onClose:function(){
return true;
}});
if(has("dijit-legacy-requires")){
_428(0,function(){
var _439=["dijit/_base"];
require(_439);
});
}
return _433;
});
},"dijit/form/_FormSelectWidget":function(){
define("dijit/form/_FormSelectWidget",["dojo/_base/array","dojo/_base/Deferred","dojo/aspect","dojo/data/util/sorter","dojo/_base/declare","dojo/dom","dojo/dom-class","dojo/_base/kernel","dojo/_base/lang","dojo/query","dojo/when","dojo/store/util/QueryResults","./_FormValueWidget"],function(_43a,_43b,_43c,_43d,_43e,dom,_43f,_440,lang,_441,when,_442,_443){
var _444=_43e("dijit.form._FormSelectWidget",_443,{multiple:false,options:null,store:null,query:null,queryOptions:null,labelAttr:"",onFetch:null,sortByLabel:true,loadChildrenOnOpen:false,onLoadDeferred:null,getOptions:function(_445){
var _446=_445,opts=this.options||[],l=opts.length;
if(_446===undefined){
return opts;
}
if(lang.isArray(_446)){
return _43a.map(_446,"return this.getOptions(item);",this);
}
if(lang.isObject(_445)){
if(!_43a.some(this.options,function(o,idx){
if(o===_446||(o.value&&o.value===_446.value)){
_446=idx;
return true;
}
return false;
})){
_446=-1;
}
}
if(typeof _446=="string"){
for(var i=0;i<l;i++){
if(opts[i].value===_446){
_446=i;
break;
}
}
}
if(typeof _446=="number"&&_446>=0&&_446<l){
return this.options[_446];
}
return null;
},addOption:function(_447){
if(!lang.isArray(_447)){
_447=[_447];
}
_43a.forEach(_447,function(i){
if(i&&lang.isObject(i)){
this.options.push(i);
}
},this);
this._loadChildren();
},removeOption:function(_448){
if(!lang.isArray(_448)){
_448=[_448];
}
var _449=this.getOptions(_448);
_43a.forEach(_449,function(i){
if(i){
this.options=_43a.filter(this.options,function(node){
return (node.value!==i.value||node.label!==i.label);
});
this._removeOptionItem(i);
}
},this);
this._loadChildren();
},updateOption:function(_44a){
if(!lang.isArray(_44a)){
_44a=[_44a];
}
_43a.forEach(_44a,function(i){
var _44b=this.getOptions(i),k;
if(_44b){
for(k in i){
_44b[k]=i[k];
}
}
},this);
this._loadChildren();
},setStore:function(_44c,_44d,_44e){
var _44f=this.store;
_44e=_44e||{};
if(_44f!==_44c){
var h;
while((h=this._notifyConnections.pop())){
h.remove();
}
if(!_44c.get){
lang.mixin(_44c,{_oldAPI:true,get:function(id){
var _450=new _43b();
this.fetchItemByIdentity({identity:id,onItem:function(_451){
_450.resolve(_451);
},onError:function(_452){
_450.reject(_452);
}});
return _450.promise;
},query:function(_453,_454){
var _455=new _43b(function(){
if(_456.abort){
_456.abort();
}
});
_455.total=new _43b();
var _456=this.fetch(lang.mixin({query:_453,onBegin:function(_457){
_455.total.resolve(_457);
},onComplete:function(_458){
_455.resolve(_458);
},onError:function(_459){
_455.reject(_459);
}},_454));
return new _442(_455);
}});
if(_44c.getFeatures()["dojo.data.api.Notification"]){
this._notifyConnections=[_43c.after(_44c,"onNew",lang.hitch(this,"_onNewItem"),true),_43c.after(_44c,"onDelete",lang.hitch(this,"_onDeleteItem"),true),_43c.after(_44c,"onSet",lang.hitch(this,"_onSetItem"),true)];
}
}
this._set("store",_44c);
}
if(this.options&&this.options.length){
this.removeOption(this.options);
}
if(this._queryRes&&this._queryRes.close){
this._queryRes.close();
}
if(_44e.query){
this._set("query",_44e.query);
this._set("queryOptions",_44e.queryOptions);
}
if(_44c){
this._loadingStore=true;
this.onLoadDeferred=new _43b();
this._queryRes=_44c.query(this.query,this.queryOptions);
when(this._queryRes,lang.hitch(this,function(_45a){
if(this.sortByLabel&&!_44e.sort&&_45a.length){
if(_45a[0].getValue){
_45a.sort(_43d.createSortFunction([{attribute:_44c.getLabelAttributes(_45a[0])[0]}],_44c));
}else{
var _45b=this.labelAttr;
_45a.sort(function(a,b){
return a[_45b]>b[_45b]?1:b[_45b]>a[_45b]?-1:0;
});
}
}
if(_44e.onFetch){
_45a=_44e.onFetch.call(this,_45a,_44e);
}
_43a.forEach(_45a,function(i){
this._addOptionForItem(i);
},this);
if(this._queryRes.observe){
this._queryRes.observe(lang.hitch(this,function(_45c,_45d,_45e){
if(_45d==_45e){
this._onSetItem(_45c);
}else{
if(_45d!=-1){
this._onDeleteItem(_45c);
}
if(_45e!=-1){
this._onNewItem(_45c);
}
}
}),true);
}
this._loadingStore=false;
this.set("value","_pendingValue" in this?this._pendingValue:_44d);
delete this._pendingValue;
if(!this.loadChildrenOnOpen){
this._loadChildren();
}else{
this._pseudoLoadChildren(_45a);
}
this.onLoadDeferred.resolve(true);
this.onSetStore();
}),function(err){
console.error("dijit.form.Select: "+err.toString());
this.onLoadDeferred.reject(err);
});
}
return _44f;
},_setValueAttr:function(_45f,_460){
if(!this._onChangeActive){
_460=null;
}
if(this._loadingStore){
this._pendingValue=_45f;
return;
}
var opts=this.getOptions()||[];
if(!lang.isArray(_45f)){
_45f=[_45f];
}
_43a.forEach(_45f,function(i,idx){
if(!lang.isObject(i)){
i=i+"";
}
if(typeof i==="string"){
_45f[idx]=_43a.filter(opts,function(node){
return node.value===i;
})[0]||{value:"",label:""};
}
},this);
_45f=_43a.filter(_45f,function(i){
return i&&i.value;
});
if(!this.multiple&&(!_45f[0]||!_45f[0].value)&&opts.length){
_45f[0]=opts[0];
}
_43a.forEach(opts,function(i){
i.selected=_43a.some(_45f,function(v){
return v.value===i.value;
});
});
var val=_43a.map(_45f,function(i){
return i.value;
}),disp=_43a.map(_45f,function(i){
return i.label;
});
if(typeof val=="undefined"||typeof val[0]=="undefined"){
return;
}
this._setDisplay(this.multiple?disp:disp[0]);
this.inherited(arguments,[this.multiple?val:val[0],_460]);
this._updateSelection();
},_getDisplayedValueAttr:function(){
var val=this.get("value");
if(!lang.isArray(val)){
val=[val];
}
var ret=_43a.map(this.getOptions(val),function(v){
if(v&&"label" in v){
return v.label;
}else{
if(v){
return v.value;
}
}
return null;
},this);
return this.multiple?ret:ret[0];
},_loadChildren:function(){
if(this._loadingStore){
return;
}
_43a.forEach(this._getChildren(),function(_461){
_461.destroyRecursive();
});
_43a.forEach(this.options,this._addOptionItem,this);
this._updateSelection();
},_updateSelection:function(){
this._set("value",this._getValueFromOpts());
var val=this.value;
if(!lang.isArray(val)){
val=[val];
}
if(val&&val[0]){
_43a.forEach(this._getChildren(),function(_462){
var _463=_43a.some(val,function(v){
return _462.option&&(v===_462.option.value);
});
_43f.toggle(_462.domNode,this.baseClass.replace(/\s+|$/g,"SelectedOption "),_463);
_462.domNode.setAttribute("aria-selected",_463?"true":"false");
},this);
}
},_getValueFromOpts:function(){
var opts=this.getOptions()||[];
if(!this.multiple&&opts.length){
var opt=_43a.filter(opts,function(i){
return i.selected;
})[0];
if(opt&&opt.value){
return opt.value;
}else{
opts[0].selected=true;
return opts[0].value;
}
}else{
if(this.multiple){
return _43a.map(_43a.filter(opts,function(i){
return i.selected;
}),function(i){
return i.value;
})||[];
}
}
return "";
},_onNewItem:function(item,_464){
if(!_464||!_464.parent){
this._addOptionForItem(item);
}
},_onDeleteItem:function(item){
var _465=this.store;
this.removeOption(_465.getIdentity(item));
},_onSetItem:function(item){
this.updateOption(this._getOptionObjForItem(item));
},_getOptionObjForItem:function(item){
var _466=this.store,_467=(this.labelAttr&&this.labelAttr in item)?item[this.labelAttr]:_466.getLabel(item),_468=(_467?_466.getIdentity(item):null);
return {value:_468,label:_467,item:item};
},_addOptionForItem:function(item){
var _469=this.store;
if(_469.isItemLoaded&&!_469.isItemLoaded(item)){
_469.loadItem({item:item,onItem:function(i){
this._addOptionForItem(i);
},scope:this});
return;
}
var _46a=this._getOptionObjForItem(item);
this.addOption(_46a);
},constructor:function(_46b){
this._oValue=(_46b||{}).value||null;
this._notifyConnections=[];
},buildRendering:function(){
this.inherited(arguments);
dom.setSelectable(this.focusNode,false);
},_fillContent:function(){
if(!this.options){
this.options=this.srcNodeRef?_441("> *",this.srcNodeRef).map(function(node){
if(node.getAttribute("type")==="separator"){
return {value:"",label:"",selected:false,disabled:false};
}
return {value:(node.getAttribute("data-"+_440._scopeName+"-value")||node.getAttribute("value")),label:String(node.innerHTML),selected:node.getAttribute("selected")||false,disabled:node.getAttribute("disabled")||false};
},this):[];
}
if(!this.value){
this._set("value",this._getValueFromOpts());
}else{
if(this.multiple&&typeof this.value=="string"){
this._set("value",this.value.split(","));
}
}
},postCreate:function(){
this.inherited(arguments);
this.connect(this,"onChange","_updateSelection");
var _46c=this.store;
if(_46c&&(_46c.getIdentity||_46c.getFeatures()["dojo.data.api.Identity"])){
this.store=null;
this.setStore(_46c,this._oValue);
}
},startup:function(){
this._loadChildren();
this.inherited(arguments);
},destroy:function(){
var h;
while((h=this._notifyConnections.pop())){
h.remove();
}
if(this._queryRes&&this._queryRes.close){
this._queryRes.close();
}
this.inherited(arguments);
},_addOptionItem:function(){
},_removeOptionItem:function(){
},_setDisplay:function(){
},_getChildren:function(){
return [];
},_getSelectedOptionsAttr:function(){
return this.getOptions(this.get("value"));
},_pseudoLoadChildren:function(){
},onSetStore:function(){
}});
return _444;
});
},"dijit/_FocusMixin":function(){
define("dijit/_FocusMixin",["./focus","./_WidgetBase","dojo/_base/declare","dojo/_base/lang"],function(_46d,_46e,_46f,lang){
lang.extend(_46e,{focused:false,onFocus:function(){
},onBlur:function(){
},_onFocus:function(){
this.onFocus();
},_onBlur:function(){
this.onBlur();
}});
return _46f("dijit._FocusMixin",null,{_focusManager:_46d});
});
},"dijit/focus":function(){
define("dijit/focus",["dojo/aspect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-construct","dojo/Evented","dojo/_base/lang","dojo/on","dojo/ready","dojo/sniff","dojo/Stateful","dojo/_base/unload","dojo/_base/window","dojo/window","./a11y","./registry","./main"],function(_470,_471,dom,_472,_473,_474,lang,on,_475,has,_476,_477,win,_478,a11y,_479,_47a){
var _47b=_471([_476,_474],{curNode:null,activeStack:[],constructor:function(){
var _47c=lang.hitch(this,function(node){
if(dom.isDescendant(this.curNode,node)){
this.set("curNode",null);
}
if(dom.isDescendant(this.prevNode,node)){
this.set("prevNode",null);
}
});
_470.before(_473,"empty",_47c);
_470.before(_473,"destroy",_47c);
},registerIframe:function(_47d){
return this.registerWin(_47d.contentWindow,_47d);
},registerWin:function(_47e,_47f){
var _480=this;
var _481=function(evt){
_480._justMouseDowned=true;
setTimeout(function(){
_480._justMouseDowned=false;
},0);
if(has("ie")&&evt&&evt.srcElement&&evt.srcElement.parentNode==null){
return;
}
_480._onTouchNode(_47f||evt.target||evt.srcElement,"mouse");
};
var doc=has("ie")?_47e.document.documentElement:_47e.document;
if(doc){
if(has("ie")){
_47e.document.body.attachEvent("onmousedown",_481);
var _482=function(evt){
var tag=evt.srcElement.tagName.toLowerCase();
if(tag=="#document"||tag=="body"){
return;
}
if(a11y.isTabNavigable(evt.srcElement)){
_480._onFocusNode(_47f||evt.srcElement);
}else{
_480._onTouchNode(_47f||evt.srcElement);
}
};
doc.attachEvent("onfocusin",_482);
var _483=function(evt){
_480._onBlurNode(_47f||evt.srcElement);
};
doc.attachEvent("onfocusout",_483);
return {remove:function(){
_47e.document.detachEvent("onmousedown",_481);
doc.detachEvent("onfocusin",_482);
doc.detachEvent("onfocusout",_483);
doc=null;
}};
}else{
doc.body.addEventListener("mousedown",_481,true);
doc.body.addEventListener("touchstart",_481,true);
var _484=function(evt){
_480._onFocusNode(_47f||evt.target);
};
doc.addEventListener("focus",_484,true);
var _485=function(evt){
_480._onBlurNode(_47f||evt.target);
};
doc.addEventListener("blur",_485,true);
return {remove:function(){
doc.body.removeEventListener("mousedown",_481,true);
doc.body.removeEventListener("touchstart",_481,true);
doc.removeEventListener("focus",_484,true);
doc.removeEventListener("blur",_485,true);
doc=null;
}};
}
}
},_onBlurNode:function(node){
if(this._clearFocusTimer){
clearTimeout(this._clearFocusTimer);
}
this._clearFocusTimer=setTimeout(lang.hitch(this,function(){
this.set("prevNode",this.curNode);
this.set("curNode",null);
}),0);
if(this._justMouseDowned){
return;
}
if(this._clearActiveWidgetsTimer){
clearTimeout(this._clearActiveWidgetsTimer);
}
this._clearActiveWidgetsTimer=setTimeout(lang.hitch(this,function(){
delete this._clearActiveWidgetsTimer;
this._setStack([]);
}),0);
},_onTouchNode:function(node,by){
if(this._clearActiveWidgetsTimer){
clearTimeout(this._clearActiveWidgetsTimer);
delete this._clearActiveWidgetsTimer;
}
var _486=[];
try{
while(node){
var _487=_472.get(node,"dijitPopupParent");
if(_487){
node=_479.byId(_487).domNode;
}else{
if(node.tagName&&node.tagName.toLowerCase()=="body"){
if(node===win.body()){
break;
}
node=_478.get(node.ownerDocument).frameElement;
}else{
var id=node.getAttribute&&node.getAttribute("widgetId"),_488=id&&_479.byId(id);
if(_488&&!(by=="mouse"&&_488.get("disabled"))){
_486.unshift(id);
}
node=node.parentNode;
}
}
}
}
catch(e){
}
this._setStack(_486,by);
},_onFocusNode:function(node){
if(!node){
return;
}
if(node.nodeType==9){
return;
}
if(this._clearFocusTimer){
clearTimeout(this._clearFocusTimer);
delete this._clearFocusTimer;
}
this._onTouchNode(node);
if(node==this.curNode){
return;
}
this.set("prevNode",this.curNode);
this.set("curNode",node);
},_setStack:function(_489,by){
var _48a=this.activeStack;
this.set("activeStack",_489);
for(var _48b=0;_48b<Math.min(_48a.length,_489.length);_48b++){
if(_48a[_48b]!=_489[_48b]){
break;
}
}
var _48c;
for(var i=_48a.length-1;i>=_48b;i--){
_48c=_479.byId(_48a[i]);
if(_48c){
_48c._hasBeenBlurred=true;
_48c.set("focused",false);
if(_48c._focusManager==this){
_48c._onBlur(by);
}
this.emit("widget-blur",_48c,by);
}
}
for(i=_48b;i<_489.length;i++){
_48c=_479.byId(_489[i]);
if(_48c){
_48c.set("focused",true);
if(_48c._focusManager==this){
_48c._onFocus(by);
}
this.emit("widget-focus",_48c,by);
}
}
},focus:function(node){
if(node){
try{
node.focus();
}
catch(e){
}
}
}});
var _48d=new _47b();
_475(function(){
var _48e=_48d.registerWin(_478.get(win.doc));
if(has("ie")){
_477.addOnWindowUnload(function(){
if(_48e){
_48e.remove();
_48e=null;
}
});
}
});
_47a.focus=function(node){
_48d.focus(node);
};
for(var attr in _48d){
if(!/^_/.test(attr)){
_47a.focus[attr]=typeof _48d[attr]=="function"?lang.hitch(_48d,attr):_48d[attr];
}
}
_48d.watch(function(attr,_48f,_490){
_47a.focus[attr]=_490;
});
return _48d;
});
},"dojo/store/util/QueryResults":function(){
define(["../../_base/array","../../_base/lang","../../_base/Deferred"],function(_491,lang,_492){
var _493=function(_494){
if(!_494){
return _494;
}
if(_494.then){
_494=lang.delegate(_494);
}
function _495(_496){
if(!_494[_496]){
_494[_496]=function(){
var args=arguments;
return _492.when(_494,function(_497){
Array.prototype.unshift.call(args,_497);
return _493(_491[_496].apply(_491,args));
});
};
}
};
_495("forEach");
_495("filter");
_495("map");
if(!_494.total){
_494.total=_492.when(_494,function(_498){
return _498.length;
});
}
return _494;
};
lang.setObject("dojo.store.util.QueryResults",_493);
return _493;
});
},"dijit/_Contained":function(){
define("dijit/_Contained",["dojo/_base/declare","./registry"],function(_499,_49a){
return _499("dijit._Contained",null,{_getSibling:function(_49b){
var node=this.domNode;
do{
node=node[_49b+"Sibling"];
}while(node&&node.nodeType!=1);
return node&&_49a.byNode(node);
},getPreviousSibling:function(){
return this._getSibling("previous");
},getNextSibling:function(){
return this._getSibling("next");
},getIndexInParent:function(){
var p=this.getParent();
if(!p||!p.getIndexOfChild){
return -1;
}
return p.getIndexOfChild(this);
}});
});
},"dijit/main":function(){
define("dijit/main",["dojo/_base/kernel"],function(dojo){
return dojo.dijit;
});
},"dijit/Destroyable":function(){
define("dijit/Destroyable",["dojo/_base/array","dojo/aspect","dojo/_base/declare"],function(_49c,_49d,_49e){
return _49e("dijit.Destroyable",null,{destroy:function(_49f){
this._destroyed=true;
},own:function(){
_49c.forEach(arguments,function(_4a0){
var _4a1="destroyRecursive" in _4a0?"destroyRecursive":"destroy" in _4a0?"destroy":"remove";
var odh=_49d.before(this,"destroy",function(_4a2){
_4a0[_4a1](_4a2);
});
var hdh=_49d.after(_4a0,_4a1,function(){
odh.remove();
hdh.remove();
},true);
},this);
return arguments;
}});
});
},"dojo/regexp":function(){
define(["./_base/kernel","./_base/lang"],function(dojo,lang){
var _4a3={};
lang.setObject("dojo.regexp",_4a3);
_4a3.escapeString=function(str,_4a4){
return str.replace(/([\.$?*|{}\(\)\[\]\\\/\+^])/g,function(ch){
if(_4a4&&_4a4.indexOf(ch)!=-1){
return ch;
}
return "\\"+ch;
});
};
_4a3.buildGroupRE=function(arr,re,_4a5){
if(!(arr instanceof Array)){
return re(arr);
}
var b=[];
for(var i=0;i<arr.length;i++){
b.push(re(arr[i]));
}
return _4a3.group(b.join("|"),_4a5);
};
_4a3.group=function(_4a6,_4a7){
return "("+(_4a7?"?:":"")+_4a6+")";
};
return _4a3;
});
},"dojo/cache":function(){
define(["./_base/kernel","./text"],function(dojo){
return dojo.cache;
});
},"dijit/DropDownMenu":function(){
require({cache:{"url:dijit/templates/Menu.html":"<table class=\"dijit dijitMenu dijitMenuPassive dijitReset dijitMenuTable\" role=\"menu\" tabIndex=\"${tabIndex}\"\n\t   data-dojo-attach-event=\"onkeypress:_onKeyPress\" cellspacing=\"0\">\n\t<tbody class=\"dijitReset\" data-dojo-attach-point=\"containerNode\"></tbody>\n</table>\n"}});
define("dijit/DropDownMenu",["dojo/_base/declare","dojo/_base/event","dojo/keys","dojo/text!./templates/Menu.html","./_OnDijitClickMixin","./_MenuBase"],function(_4a8,_4a9,keys,_4aa,_4ab,_4ac){
return _4a8("dijit.DropDownMenu",[_4ac,_4ab],{templateString:_4aa,baseClass:"dijitMenu",postCreate:function(){
this.inherited(arguments);
var l=this.isLeftToRight();
this._openSubMenuKey=l?keys.RIGHT_ARROW:keys.LEFT_ARROW;
this._closeSubMenuKey=l?keys.LEFT_ARROW:keys.RIGHT_ARROW;
this.connectKeyNavHandlers([keys.UP_ARROW],[keys.DOWN_ARROW]);
},_onKeyPress:function(evt){
if(evt.ctrlKey||evt.altKey){
return;
}
switch(evt.charOrCode){
case this._openSubMenuKey:
this._moveToPopup(evt);
_4a9.stop(evt);
break;
case this._closeSubMenuKey:
if(this.parentMenu){
if(this.parentMenu._isMenuBar){
this.parentMenu.focusPrev();
}else{
this.onCancel(false);
}
}else{
_4a9.stop(evt);
}
break;
}
}});
});
},"dijit/MenuItem":function(){
require({cache:{"url:dijit/templates/MenuItem.html":"<tr class=\"dijitReset dijitMenuItem\" data-dojo-attach-point=\"focusNode\" role=\"menuitem\" tabIndex=\"-1\">\n\t<td class=\"dijitReset dijitMenuItemIconCell\" role=\"presentation\">\n\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitIcon dijitMenuItemIcon\" data-dojo-attach-point=\"iconNode\"/>\n\t</td>\n\t<td class=\"dijitReset dijitMenuItemLabel\" colspan=\"2\" data-dojo-attach-point=\"containerNode\"></td>\n\t<td class=\"dijitReset dijitMenuItemAccelKey\" style=\"display: none\" data-dojo-attach-point=\"accelKeyNode\"></td>\n\t<td class=\"dijitReset dijitMenuArrowCell\" role=\"presentation\">\n\t\t<div data-dojo-attach-point=\"arrowWrapper\" style=\"visibility: hidden\">\n\t\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitMenuExpand\"/>\n\t\t\t<span class=\"dijitMenuExpandA11y\">+</span>\n\t\t</div>\n\t</td>\n</tr>\n"}});
define("dijit/MenuItem",["dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/_base/kernel","dojo/sniff","./_Widget","./_TemplatedMixin","./_Contained","./_CssStateMixin","dojo/text!./templates/MenuItem.html"],function(_4ad,dom,_4ae,_4af,_4b0,has,_4b1,_4b2,_4b3,_4b4,_4b5){
return _4ad("dijit.MenuItem",[_4b1,_4b2,_4b3,_4b4],{templateString:_4b5,baseClass:"dijitMenuItem",label:"",_setLabelAttr:function(val){
this.containerNode.innerHTML=val;
this._set("label",val);
if(this.textDir==="auto"){
this.applyTextDir(this.focusNode,this.label);
}
},iconClass:"dijitNoIcon",_setIconClassAttr:{node:"iconNode",type:"class"},accelKey:"",disabled:false,_fillContent:function(_4b6){
if(_4b6&&!("label" in this.params)){
this.set("label",_4b6.innerHTML);
}
},buildRendering:function(){
this.inherited(arguments);
var _4b7=this.id+"_text";
_4ae.set(this.containerNode,"id",_4b7);
if(this.accelKeyNode){
_4ae.set(this.accelKeyNode,"id",this.id+"_accel");
_4b7+=" "+this.id+"_accel";
}
this.domNode.setAttribute("aria-labelledby",_4b7);
dom.setSelectable(this.domNode,false);
},onClick:function(){
},focus:function(){
try{
if(has("ie")==8){
this.containerNode.focus();
}
this.focusNode.focus();
}
catch(e){
}
},_onFocus:function(){
this._setSelected(true);
this.getParent()._onItemFocus(this);
this.inherited(arguments);
},_setSelected:function(_4b8){
_4af.toggle(this.domNode,"dijitMenuItemSelected",_4b8);
},setLabel:function(_4b9){
_4b0.deprecated("dijit.MenuItem.setLabel() is deprecated.  Use set('label', ...) instead.","","2.0");
this.set("label",_4b9);
},setDisabled:function(_4ba){
_4b0.deprecated("dijit.Menu.setDisabled() is deprecated.  Use set('disabled', bool) instead.","","2.0");
this.set("disabled",_4ba);
},_setDisabledAttr:function(_4bb){
this.focusNode.setAttribute("aria-disabled",_4bb?"true":"false");
this._set("disabled",_4bb);
},_setAccelKeyAttr:function(_4bc){
this.accelKeyNode.style.display=_4bc?"":"none";
this.accelKeyNode.innerHTML=_4bc;
_4ae.set(this.containerNode,"colSpan",_4bc?"1":"2");
this._set("accelKey",_4bc);
},_setTextDirAttr:function(_4bd){
if(!this._created||this.textDir!=_4bd){
this._set("textDir",_4bd);
this.applyTextDir(this.focusNode,this.label);
}
}});
});
},"url:dijit/form/templates/HorizontalSlider.html":"<table class=\"dijit dijitReset dijitSlider dijitSliderH\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" rules=\"none\" data-dojo-attach-event=\"onkeypress:_onKeyPress,onkeyup:_onKeyUp\"\n\trole=\"presentation\"\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\n\t\t><td data-dojo-attach-point=\"topDecoration\" class=\"dijitReset dijitSliderDecoration dijitSliderDecorationT dijitSliderDecorationH\"></td\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset dijitSliderButtonContainer dijitSliderButtonContainerH\"\n\t\t\t><div class=\"dijitSliderDecrementIconH\" style=\"display:none\" data-dojo-attach-point=\"decrementButton\"><span class=\"dijitSliderButtonInner\">-</span></div\n\t\t></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><div class=\"dijitSliderBar dijitSliderBumper dijitSliderBumperH dijitSliderLeftBumper\" data-dojo-attach-event=\"press:_onClkDecBumper\"></div\n\t\t></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><input data-dojo-attach-point=\"valueNode\" type=\"hidden\" ${!nameAttrSetting}\n\t\t\t/><div class=\"dijitReset dijitSliderBarContainerH\" role=\"presentation\" data-dojo-attach-point=\"sliderBarContainer\"\n\t\t\t\t><div role=\"presentation\" data-dojo-attach-point=\"progressBar\" class=\"dijitSliderBar dijitSliderBarH dijitSliderProgressBar dijitSliderProgressBarH\" data-dojo-attach-event=\"press:_onBarClick\"\n\t\t\t\t\t><div class=\"dijitSliderMoveable dijitSliderMoveableH\"\n\t\t\t\t\t\t><div data-dojo-attach-point=\"sliderHandle,focusNode\" class=\"dijitSliderImageHandle dijitSliderImageHandleH\" data-dojo-attach-event=\"press:_onHandleClick\" role=\"slider\"></div\n\t\t\t\t\t></div\n\t\t\t\t></div\n\t\t\t\t><div role=\"presentation\" data-dojo-attach-point=\"remainingBar\" class=\"dijitSliderBar dijitSliderBarH dijitSliderRemainingBar dijitSliderRemainingBarH\" data-dojo-attach-event=\"press:_onBarClick\"></div\n\t\t\t></div\n\t\t></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><div class=\"dijitSliderBar dijitSliderBumper dijitSliderBumperH dijitSliderRightBumper\" data-dojo-attach-event=\"press:_onClkIncBumper\"></div\n\t\t></td\n\t\t><td class=\"dijitReset dijitSliderButtonContainer dijitSliderButtonContainerH\"\n\t\t\t><div class=\"dijitSliderIncrementIconH\" style=\"display:none\" data-dojo-attach-point=\"incrementButton\"><span class=\"dijitSliderButtonInner\">+</span></div\n\t\t></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\n\t\t><td data-dojo-attach-point=\"containerNode,bottomDecoration\" class=\"dijitReset dijitSliderDecoration dijitSliderDecorationB dijitSliderDecorationH\"></td\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\n\t></tr\n></table>\n","url:dijit/templates/Tooltip.html":"<div class=\"dijitTooltip dijitTooltipLeft\" id=\"dojoTooltip\"\n\t><div class=\"dijitTooltipContainer dijitTooltipContents\" data-dojo-attach-point=\"containerNode\" role='alert'></div\n\t><div class=\"dijitTooltipConnector\" data-dojo-attach-point=\"connectorNode\"></div\n></div>\n","dijit/_Container":function(){
define("dijit/_Container",["dojo/_base/array","dojo/_base/declare","dojo/dom-construct"],function(_4be,_4bf,_4c0){
return _4bf("dijit._Container",null,{buildRendering:function(){
this.inherited(arguments);
if(!this.containerNode){
this.containerNode=this.domNode;
}
},addChild:function(_4c1,_4c2){
var _4c3=this.containerNode;
if(_4c2&&typeof _4c2=="number"){
var _4c4=this.getChildren();
if(_4c4&&_4c4.length>=_4c2){
_4c3=_4c4[_4c2-1].domNode;
_4c2="after";
}
}
_4c0.place(_4c1.domNode,_4c3,_4c2);
if(this._started&&!_4c1._started){
_4c1.startup();
}
},removeChild:function(_4c5){
if(typeof _4c5=="number"){
_4c5=this.getChildren()[_4c5];
}
if(_4c5){
var node=_4c5.domNode;
if(node&&node.parentNode){
node.parentNode.removeChild(node);
}
}
},hasChildren:function(){
return this.getChildren().length>0;
},_getSiblingOfChild:function(_4c6,dir){
var _4c7=this.getChildren(),idx=_4be.indexOf(this.getChildren(),_4c6);
return _4c7[idx+dir];
},getIndexOfChild:function(_4c8){
return _4be.indexOf(this.getChildren(),_4c8);
}});
});
},"*now":function(r){
r(["dojo/i18n!*preload*preview/nls/singlepreview*[\"ar\",\"ca\",\"cs\",\"da\",\"de\",\"el\",\"en-gb\",\"en-us\",\"es-es\",\"fi-fi\",\"fr-fr\",\"he-il\",\"hu\",\"it-it\",\"ja-jp\",\"ko-kr\",\"nl-nl\",\"nb\",\"pl\",\"pt-br\",\"pt-pt\",\"ru\",\"sk\",\"sl\",\"sv\",\"th\",\"tr\",\"zh-tw\",\"zh-cn\",\"ROOT\"]"]);
}}});
define("preview/singlepreview",["dojo/_base/declare","dijit/_WidgetBase","./silhouetteiframe","dijit/form/Button","dijit/form/HorizontalSlider","dijit/form/HorizontalRuleLabels","dijit/form/Select","dojo/_base/lang","dojo/dom-construct","dojo/query","dojo/dom-class","dojo/_base/connect","dojo/i18n!preview/nls/preview"],function(_4c9,_4ca,_4cb,_4cc,_4cd,_4ce,_4cf,lang,_4d0,_4d1,_4d2,_4d3,_4d4){
return _4c9([_4ca],{currentDevice:0,currentZoom:1,orientation:"portrait",scalefactor:1,showZoom:true,margin:0,pathToPreviewerFolder:"preview/",_randomUrlParam:"&"+Math.random()+"=1",buildRendering:function(){
this._connects=[];
if(this.devicelist&&this.devicelist.length&&this.iframefilename){
this.addStyleDeclarations();
this.domNode=this.srcNodeRef;
this.domNode.innerHTML=lang.replace("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">"+"<tr><td style=\"text-align:left;\">"+"<div class=\"controlbar\">"+"<span class=\"controlbar_label\">{device}</span>"+"<span class=\"controlbar_container controlbar_container_device\"><span class=\"controlbar_device\"></span></span>"+"<span class=\"controlbar_label controlbar_label_zoom\">{zoom}</span>"+"<span class=\"controlbar_container controlbar_container_zoom\"><span class=\"controlbar_zoom_labels\"></span><span class=\"controlbar_zoom\"></span></span>"+"<span class=\"controlbar_label\">{angle}</span>"+"<span class=\"controlbar_container controlbar_container_angle\"><span class=\"controlbar_angle\"></span></span>"+"</div>"+"</td></tr>"+"<tr><td style=\"text-align:left;\">"+"<div class=\"silhouette_container\" style=\"display:inline-block\"></div>"+"</td></tr></table>",_4d4);
if(!this.showZoom){
_4d1(".controlbar_label_zoom",this.domNode)[0].style.display="none";
_4d1(".controlbar_container_zoom",this.domNode)[0].style.display="none";
}
this.initControls();
}else{
}
},addStyleDeclarations:function(){
var _4d5=_4d1("style.singlepreview_styles");
if(!_4d5.length){
var _4d6=document.querySelectorAll("head")[0];
if(!_4d6){
console.error("silhouetteiframe.js addStyleDeclarations(): no HEAD element");
return;
}
_4d0.create("style",{type:"text/css","class":"singlepreview_styles",innerHTML:".controlbar { line-height:1.25em; }\n"+".controlbar_label { display:inline-block; vertical-align:middle; margin-top:14px; margin-left:.75em; }\n"+".controlbar_container { display:inline-block; vertical-align:top; }\n"+".controlbar_container_device { margin:9px 7px 0 1px; }\n"+".controlbar_container_zoom { margin-right:6px; }\n"+".controlbar_container_angle { margin:9px 9px 0 1px; }\n"+".control_angle { width:16px; height:16px; }\n"+".control_angle_cw { background-image:url("+this.pathToPreviewerFolder+"images/rotate_cw.png); }\n"+".control_angle_ccw { background-image:url("+this.pathToPreviewerFolder+"images/rotate_ccw.png); }\n"+".controlbar .controlbar_container.controlbar_container_angle .dijitButtonNode { padding: 0px; }"},_4d6);
}
},initControls:function(){
var _4d7=_4d1(".controlbar_device",this.domNode)[0];
var _4d8=this.device_select=new _4cf({},_4d7);
_4d8.addOption(this.devicelist);
setTimeout(lang.hitch(this,function(){
this.connect(_4d8,"onChange",function(_4d9){
if(_4d9!=this.currentDevice){
this.currentDevice=_4d9;
var _4da=_4cb.getMobileTheme(this.devicelist[this.currentDevice].file);
var _4db=this.iframefilename+"?theme="+_4da+this._randomUrlParam;
if(this.iframeSearch){
_4db+="&"+this.iframeSearch;
}
this.update_silhouette_container(_4db);
}
});
}),1);
if(this.showZoom){
var _4dc=_4d1(".controlbar_zoom",this.domNode)[0],_4dd=_4d1(".controlbar_zoom_labels",this.domNode)[0],_4de=this.sliderLabels=new _4ce({container:"topDecoration",count:14,labels:["",0,"","",1,"","",2,"","",3,""],style:"height:1.5em;font-size:100%;color:gray; width:74px"},_4dd),_4df=this.zoom_select=new _4cd({value:this.currentZoom,minimum:0.2,maximum:3,intermediateChanges:true,showButtons:false,style:"width:75px;"},_4dc);
this.connect(_4df,"onChange",lang.hitch(this,function(){
if(_4df.value!=this.currentZoom){
this.currentZoom=_4df.value;
this.silhouetteiframe.setScaleFactor(this.currentZoom);
}
}));
}
var _4e0=_4d1(".controlbar_angle",this.domNode)[0];
var _4e1=(this.orientation=="landscape")?"control_angle_ccw":"control_angle_cw";
var _4e2=this.angle_select=new _4cc({iconClass:"control_angle "+_4e1,showLabel:false},_4e0);
this.connect(_4e2,"onClick",lang.hitch(this,function(){
var _4e3=_4d1(".control_angle",this.domNode)[0];
if(this.orientation=="landscape"){
this.orientation="portrait";
_4d2.remove(_4e3,"control_angle_ccw");
_4d2.add(_4e3,"control_angle_cw");
}else{
this.orientation="landscape";
_4d2.remove(_4e3,"control_angle_cw");
_4d2.add(_4e3,"control_angle_ccw");
}
this.silhouetteiframe.setOrientation(this.orientation);
}));
var _4e4=_4cb.getMobileTheme(this.devicelist[this.currentDevice].file);
var _4e5=this.iframefilename+"?theme="+_4e4+this._randomUrlParam;
if(this.iframeSearch){
_4e5+="&"+this.iframeSearch;
}
this.update_silhouette_container(_4e5);
},update_silhouette_container:function(_4e6){
if(this.silhouetteiframe_connect_onload){
_4d3.disconnect(this.silhouetteiframe_connect_onload);
delete this.silhouetteiframe_connect_onload;
}
var _4e7=_4d1(".silhouette_container",this.domNode)[0];
_4e7.innerHTML="<div class=\"silhouette_div_container\">"+"<span class=\"silhouetteiframe_object_container\"></span>"+"<iframe src=\""+_4e6+"\" class=\"silhouetteiframe_iframe\"></iframe>"+"</div>";
var _4e8=_4d1(".silhouette_div_container",_4e7)[0];
var _4e9=_4d1(".silhouetteiframe_iframe",_4e7)[0];
this.silhouetteiframe_connect_onload=_4d3.connect(_4e9,"onload",lang.hitch(this,function(){
this.silhouetteiframe=new _4cb({rootNode:_4e8,svgfilename:this.devicelist[this.currentDevice].file,orientation:this.orientation,scalefactor:this.scalefactor,margin:this.margin});
}));
},destroy:function(_4ea){
if(this.silhouetteiframe_connect_onload){
_4d3.disconnect(this.silhouetteiframe_connect_onload);
delete this.silhouetteiframe_connect_onload;
}
this.device_select.destroy();
this.sliderLabels.destroy();
this.zoom_select.destroy();
this.angle_select.destroy();
this.inherited("destroy",arguments);
}});
});
