/*
	Copyright (c) 2004-2012, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is an optimized version of Dojo, built for deployment and not for
	development. To get sources and documentation, please visit:

		http://dojotoolkit.org
*/

//>>built
require({cache:{"dojo/i18n":function(){
define(["./_base/kernel","require","./has","./_base/array","./_base/config","./_base/lang","./_base/xhr","./json","module"],function(_1,_2,_3,_4,_5,_6,_7,_8,_9){
_3.add("dojo-preload-i18n-Api",1);
1||_3.add("dojo-v1x-i18n-Api",1);
var _a=_1.i18n={},_b=/(^.*(^|\/)nls)(\/|$)([^\/]*)\/?([^\/]*)/,_c=function(_d,_e,_f,_10){
for(var _11=[_f+_10],_12=_e.split("-"),_13="",i=0;i<_12.length;i++){
_13+=(_13?"-":"")+_12[i];
if(!_d||_d[_13]){
_11.push(_f+_13+"/"+_10);
}
}
return _11;
},_14={},_15=function(_16,_17,_18){
_18=_18?_18.toLowerCase():_1.locale;
_16=_16.replace(/\./g,"/");
_17=_17.replace(/\./g,"/");
return (/root/i.test(_18))?(_16+"/nls/"+_17):(_16+"/nls/"+_18+"/"+_17);
},_19=_1.getL10nName=function(_1a,_1b,_1c){
return _1a=_9.id+"!"+_15(_1a,_1b,_1c);
},_1d=function(_1e,_1f,_20,_21,_22,_23){
_1e([_1f],function(_24){
var _25=_6.clone(_24.root),_26=_c(!_24._v1x&&_24,_22,_20,_21);
_1e(_26,function(){
for(var i=1;i<_26.length;i++){
_25=_6.mixin(_6.clone(_25),arguments[i]);
}
var _27=_1f+"/"+_22;
_14[_27]=_25;
_23();
});
});
},_28=function(id,_29){
return /^\./.test(id)?_29(id):id;
},_2a=function(_2b){
var _2c=_5.extraLocale||[];
_2c=_6.isArray(_2c)?_2c:[_2c];
_2c.push(_2b);
return _2c;
},_2d=function(id,_2e,_2f){
if(_3("dojo-preload-i18n-Api")){
var _30=id.split("*"),_31=_30[1]=="preload";
if(_31){
if(!_14[id]){
_14[id]=1;
_32(_30[2],_8.parse(_30[3]),1,_2e);
}
_2f(1);
}
if(_31||_33(id,_2e,_2f)){
return;
}
}
var _34=_b.exec(id),_35=_34[1]+"/",_36=_34[5]||_34[4],_37=_35+_36,_38=(_34[5]&&_34[4]),_39=_38||_1.locale,_3a=_37+"/"+_39,_3b=_38?[_39]:_2a(_39),_3c=_3b.length,_3d=function(){
if(!--_3c){
_2f(_6.delegate(_14[_3a]));
}
};
_4.forEach(_3b,function(_3e){
var _3f=_37+"/"+_3e;
if(_3("dojo-preload-i18n-Api")){
_40(_3f);
}
if(!_14[_3f]){
_1d(_2e,_37,_35,_36,_3e,_3d);
}else{
_3d();
}
});
};
if(_3("dojo-unit-tests")){
var _41=_a.unitTests=[];
}
if(_3("dojo-preload-i18n-Api")||1){
var _42=_a.normalizeLocale=function(_43){
var _44=_43?_43.toLowerCase():_1.locale;
return _44=="root"?"ROOT":_44;
},_45=function(mid,_46){
return (1&&1)?_46.isXdUrl(_2.toUrl(mid+".js")):true;
},_47=0,_48=[],_32=_a._preloadLocalizations=function(_49,_4a,_4b,_4c){
_4c=_4c||_2;
function _4d(mid,_4e){
if(_45(mid,_4c)||_4b){
_4c([mid],_4e);
}else{
_5a([mid],_4e,_4c);
}
};
function _4f(_50,_51){
var _52=_50.split("-");
while(_52.length){
if(_51(_52.join("-"))){
return;
}
_52.pop();
}
_51("ROOT");
};
function _53(_54){
_54=_42(_54);
_4f(_54,function(loc){
if(_4.indexOf(_4a,loc)>=0){
var mid=_49.replace(/\./g,"/")+"_"+loc;
_47++;
_4d(mid,function(_55){
for(var p in _55){
_14[_2.toAbsMid(p)+"/"+loc]=_55[p];
}
--_47;
while(!_47&&_48.length){
_2d.apply(null,_48.shift());
}
});
return true;
}
return false;
});
};
_53();
_4.forEach(_1.config.extraLocale,_53);
},_33=function(id,_56,_57){
if(_47){
_48.push([id,_56,_57]);
}
return _47;
},_40=function(){
};
}
if(1){
var _58={},_59=new Function("__bundle","__checkForLegacyModules","__mid","__amdValue","var define = function(mid, factory){define.called = 1; __amdValue.result = factory || mid;},"+"\t   require = function(){define.called = 1;};"+"try{"+"define.called = 0;"+"eval(__bundle);"+"if(define.called==1)"+"return __amdValue;"+"if((__checkForLegacyModules = __checkForLegacyModules(__mid)))"+"return __checkForLegacyModules;"+"}catch(e){}"+"try{"+"return eval('('+__bundle+')');"+"}catch(e){"+"return e;"+"}"),_5a=function(_5b,_5c,_5d){
var _5e=[];
_4.forEach(_5b,function(mid){
var url=_5d.toUrl(mid+".js");
function _2d(_5f){
var _60=_59(_5f,_40,mid,_58);
if(_60===_58){
_5e.push(_14[url]=_58.result);
}else{
if(_60 instanceof Error){
console.error("failed to evaluate i18n bundle; url="+url,_60);
_60={};
}
_5e.push(_14[url]=(/nls\/[^\/]+\/[^\/]+$/.test(url)?_60:{root:_60,_v1x:1}));
}
};
if(_14[url]){
_5e.push(_14[url]);
}else{
var _61=_5d.syncLoadNls(mid);
if(_61){
_5e.push(_61);
}else{
if(!_7){
try{
_5d.getText(url,true,_2d);
}
catch(e){
_5e.push(_14[url]={});
}
}else{
_7.get({url:url,sync:true,load:_2d,error:function(){
_5e.push(_14[url]={});
}});
}
}
}
});
_5c&&_5c.apply(null,_5e);
};
_40=function(_62){
for(var _63,_64=_62.split("/"),_65=_1.global[_64[0]],i=1;_65&&i<_64.length-1;_65=_65[_64[i++]]){
}
if(_65){
_63=_65[_64[i]];
if(!_63){
_63=_65[_64[i].replace(/-/g,"_")];
}
if(_63){
_14[_62]=_63;
}
}
return _63;
};
_a.getLocalization=function(_66,_67,_68){
var _69,_6a=_15(_66,_67,_68);
_2d(_6a,(!_45(_6a,_2)?function(_6b,_6c){
_5a(_6b,_6c,_2);
}:_2),function(_6d){
_69=_6d;
});
return _69;
};
if(_3("dojo-unit-tests")){
_41.push(function(doh){
doh.register("tests.i18n.unit",function(t){
var _6e;
_6e=_59("{prop:1}",_40,"nonsense",_58);
t.is({prop:1},_6e);
t.is(undefined,_6e[1]);
_6e=_59("({prop:1})",_40,"nonsense",_58);
t.is({prop:1},_6e);
t.is(undefined,_6e[1]);
_6e=_59("{'prop-x':1}",_40,"nonsense",_58);
t.is({"prop-x":1},_6e);
t.is(undefined,_6e[1]);
_6e=_59("({'prop-x':1})",_40,"nonsense",_58);
t.is({"prop-x":1},_6e);
t.is(undefined,_6e[1]);
_6e=_59("define({'prop-x':1})",_40,"nonsense",_58);
t.is(_58,_6e);
t.is({"prop-x":1},_58.result);
_6e=_59("define('some/module', {'prop-x':1})",_40,"nonsense",_58);
t.is(_58,_6e);
t.is({"prop-x":1},_58.result);
_6e=_59("this is total nonsense and should throw an error",_40,"nonsense",_58);
t.is(_6e instanceof Error,true);
});
});
}
}
return _6.mixin(_a,{dynamic:true,normalize:_28,load:_2d,cache:_14});
});
},"dojo/string":function(){
define(["./_base/kernel","./_base/lang"],function(_6f,_70){
var _71={};
_70.setObject("dojo.string",_71);
_71.rep=function(str,num){
if(num<=0||!str){
return "";
}
var buf=[];
for(;;){
if(num&1){
buf.push(str);
}
if(!(num>>=1)){
break;
}
str+=str;
}
return buf.join("");
};
_71.pad=function(_72,_73,ch,end){
if(!ch){
ch="0";
}
var out=String(_72),pad=_71.rep(ch,Math.ceil((_73-out.length)/ch.length));
return end?out+pad:pad+out;
};
_71.substitute=function(_74,map,_75,_76){
_76=_76||_6f.global;
_75=_75?_70.hitch(_76,_75):function(v){
return v;
};
return _74.replace(/\$\{([^\s\:\}]+)(?:\:([^\s\:\}]+))?\}/g,function(_77,key,_78){
var _79=_70.getObject(key,false,map);
if(_78){
_79=_70.getObject(_78,false,_76).call(_76,_79,key);
}
return _75(_79,key).toString();
});
};
_71.trim=String.prototype.trim?_70.trim:function(str){
str=str.replace(/^\s+/,"");
for(var i=str.length-1;i>=0;i--){
if(/\S/.test(str.charAt(i))){
str=str.substring(0,i+1);
break;
}
}
return str;
};
return _71;
});
},"dijit/a11y":function(){
define(["dojo/_base/array","dojo/_base/config","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-style","dojo/sniff","./main"],function(_7a,_7b,_7c,dom,_7d,_7e,has,_7f){
var _80=(_7f._isElementShown=function(_81){
var s=_7e.get(_81);
return (s.visibility!="hidden")&&(s.visibility!="collapsed")&&(s.display!="none")&&(_7d.get(_81,"type")!="hidden");
});
_7f.hasDefaultTabStop=function(_82){
switch(_82.nodeName.toLowerCase()){
case "a":
return _7d.has(_82,"href");
case "area":
case "button":
case "input":
case "object":
case "select":
case "textarea":
return true;
case "iframe":
var _83;
try{
var _84=_82.contentDocument;
if("designMode" in _84&&_84.designMode=="on"){
return true;
}
_83=_84.body;
}
catch(e1){
try{
_83=_82.contentWindow.document.body;
}
catch(e2){
return false;
}
}
return _83&&(_83.contentEditable=="true"||(_83.firstChild&&_83.firstChild.contentEditable=="true"));
default:
return _82.contentEditable=="true";
}
};
var _85=(_7f.isTabNavigable=function(_86){
if(_7d.get(_86,"disabled")){
return false;
}else{
if(_7d.has(_86,"tabIndex")){
return _7d.get(_86,"tabIndex")>=0;
}else{
return _7f.hasDefaultTabStop(_86);
}
}
});
_7f._getTabNavigable=function(_87){
var _88,_89,_8a,_8b,_8c,_8d,_8e={};
function _8f(_90){
return _90&&_90.tagName.toLowerCase()=="input"&&_90.type&&_90.type.toLowerCase()=="radio"&&_90.name&&_90.name.toLowerCase();
};
var _91=function(_92){
for(var _93=_92.firstChild;_93;_93=_93.nextSibling){
if(_93.nodeType!=1||(has("ie")<=9&&_93.scopeName!=="HTML")||!_80(_93)){
continue;
}
if(_85(_93)){
var _94=+_7d.get(_93,"tabIndex");
if(!_7d.has(_93,"tabIndex")||_94==0){
if(!_88){
_88=_93;
}
_89=_93;
}else{
if(_94>0){
if(!_8a||_94<_8b){
_8b=_94;
_8a=_93;
}
if(!_8c||_94>=_8d){
_8d=_94;
_8c=_93;
}
}
}
var rn=_8f(_93);
if(_7d.get(_93,"checked")&&rn){
_8e[rn]=_93;
}
}
if(_93.nodeName.toUpperCase()!="SELECT"){
_91(_93);
}
}
};
if(_80(_87)){
_91(_87);
}
function rs(_95){
return _8e[_8f(_95)]||_95;
};
return {first:rs(_88),last:rs(_89),lowest:rs(_8a),highest:rs(_8c)};
};
_7f.getFirstInTabbingOrder=function(_96,doc){
var _97=_7f._getTabNavigable(dom.byId(_96,doc));
return _97.lowest?_97.lowest:_97.first;
};
_7f.getLastInTabbingOrder=function(_98,doc){
var _99=_7f._getTabNavigable(dom.byId(_98,doc));
return _99.last?_99.last:_99.highest;
};
return {hasDefaultTabStop:_7f.hasDefaultTabStop,isTabNavigable:_7f.isTabNavigable,_getTabNavigable:_7f._getTabNavigable,getFirstInTabbingOrder:_7f.getFirstInTabbingOrder,getLastInTabbingOrder:_7f.getLastInTabbingOrder};
});
},"dojo/dnd/autoscroll":function(){
define(["../_base/lang","../sniff","../_base/window","../dom-geometry","../dom-style","../window"],function(_9a,has,win,_9b,_9c,_9d){
var _9e={};
_9a.setObject("dojo.dnd.autoscroll",_9e);
_9e.getViewport=_9d.getBox;
_9e.V_TRIGGER_AUTOSCROLL=32;
_9e.H_TRIGGER_AUTOSCROLL=32;
_9e.V_AUTOSCROLL_VALUE=16;
_9e.H_AUTOSCROLL_VALUE=16;
var _9f,doc=win.doc,_a0=Infinity,_a1=Infinity;
_9e.autoScrollStart=function(d){
doc=d;
_9f=_9d.getBox(doc);
var _a2=win.body(doc).parentNode;
_a0=Math.max(_a2.scrollHeight-_9f.h,0);
_a1=Math.max(_a2.scrollWidth-_9f.w,0);
};
_9e.autoScroll=function(e){
var v=_9f||_9d.getBox(doc),_a3=win.body(doc).parentNode,dx=0,dy=0;
if(e.clientX<_9e.H_TRIGGER_AUTOSCROLL){
dx=-_9e.H_AUTOSCROLL_VALUE;
}else{
if(e.clientX>v.w-_9e.H_TRIGGER_AUTOSCROLL){
dx=Math.min(_9e.H_AUTOSCROLL_VALUE,_a1-_a3.scrollLeft);
}
}
if(e.clientY<_9e.V_TRIGGER_AUTOSCROLL){
dy=-_9e.V_AUTOSCROLL_VALUE;
}else{
if(e.clientY>v.h-_9e.V_TRIGGER_AUTOSCROLL){
dy=Math.min(_9e.V_AUTOSCROLL_VALUE,_a0-_a3.scrollTop);
}
}
window.scrollBy(dx,dy);
};
_9e._validNodes={"div":1,"p":1,"td":1};
_9e._validOverflow={"auto":1,"scroll":1};
_9e.autoScrollNodes=function(e){
var b,t,w,h,rx,ry,dx=0,dy=0,_a4,_a5;
for(var n=e.target;n;){
if(n.nodeType==1&&(n.tagName.toLowerCase() in _9e._validNodes)){
var s=_9c.getComputedStyle(n),_a6=(s.overflow.toLowerCase() in _9e._validOverflow),_a7=(s.overflowX.toLowerCase() in _9e._validOverflow),_a8=(s.overflowY.toLowerCase() in _9e._validOverflow);
if(_a6||_a7||_a8){
b=_9b.getContentBox(n,s);
t=_9b.position(n,true);
}
if(_a6||_a7){
w=Math.min(_9e.H_TRIGGER_AUTOSCROLL,b.w/2);
rx=e.pageX-t.x;
if(has("webkit")||has("opera")){
rx+=win.body().scrollLeft;
}
dx=0;
if(rx>0&&rx<b.w){
if(rx<w){
dx=-w;
}else{
if(rx>b.w-w){
dx=w;
}
}
_a4=n.scrollLeft;
n.scrollLeft=n.scrollLeft+dx;
}
}
if(_a6||_a8){
h=Math.min(_9e.V_TRIGGER_AUTOSCROLL,b.h/2);
ry=e.pageY-t.y;
if(has("webkit")||has("opera")){
ry+=win.body().scrollTop;
}
dy=0;
if(ry>0&&ry<b.h){
if(ry<h){
dy=-h;
}else{
if(ry>b.h-h){
dy=h;
}
}
_a5=n.scrollTop;
n.scrollTop=n.scrollTop+dy;
}
}
if(dx||dy){
return;
}
}
try{
n=n.parentNode;
}
catch(x){
n=null;
}
}
_9e.autoScroll(e);
};
return _9e;
});
},"dojox/grid/_View":function(){
define(["dojo","dijit/registry","../main","dojo/_base/declare","dojo/_base/array","dojo/_base/lang","dojo/_base/connect","dojo/_base/sniff","dojo/query","dojo/_base/window","dojo/text!./resources/View.html","dojo/dnd/Source","dijit/_Widget","dijit/_TemplatedMixin","dojox/html/metrics","./util","dojo/_base/html","./_Builder","dojo/dnd/Avatar","dojo/dnd/Manager"],function(_a9,_aa,_ab,_ac,_ad,_ae,_af,has,_b0,win,_b1,_b2,_b3,_b4,_b5,_b6,_b7,_b8,_b9,_ba){
var _bb=function(_bc,_bd){
return _bc.style.cssText==undefined?_bc.getAttribute("style"):_bc.style.cssText;
};
var _be=_ac("dojox.grid._View",[_b3,_b4],{defaultWidth:"18em",viewWidth:"",templateString:_b1,classTag:"dojoxGrid",marginBottom:0,rowPad:2,_togglingColumn:-1,_headerBuilderClass:_b8._HeaderBuilder,_contentBuilderClass:_b8._ContentBuilder,postMixInProperties:function(){
this.rowNodes={};
},postCreate:function(){
this.connect(this.scrollboxNode,"onscroll","doscroll");
_b6.funnelEvents(this.contentNode,this,"doContentEvent",["mouseover","mouseout","click","dblclick","contextmenu","mousedown"]);
_b6.funnelEvents(this.headerNode,this,"doHeaderEvent",["dblclick","mouseover","mouseout","mousemove","mousedown","click","contextmenu"]);
this.content=new this._contentBuilderClass(this);
this.header=new this._headerBuilderClass(this);
if(!this.grid.isLeftToRight()){
this.headerNodeContainer.style.width="";
}
},destroy:function(){
_b7.destroy(this.headerNode);
delete this.headerNode;
for(var i in this.rowNodes){
this._cleanupRowWidgets(this.rowNodes[i]);
_b7.destroy(this.rowNodes[i]);
}
this.rowNodes={};
if(this.source){
this.source.destroy();
}
this.inherited(arguments);
},focus:function(){
if(has("ie")||has("webkit")||has("opera")){
this.hiddenFocusNode.focus();
}else{
this.scrollboxNode.focus();
}
},setStructure:function(_bf){
var vs=(this.structure=_bf);
if(vs.width&&!isNaN(vs.width)){
this.viewWidth=vs.width+"em";
}else{
this.viewWidth=vs.width||(vs.noscroll?"auto":this.viewWidth);
}
this._onBeforeRow=vs.onBeforeRow||function(){
};
this._onAfterRow=vs.onAfterRow||function(){
};
this.noscroll=vs.noscroll;
if(this.noscroll){
this.scrollboxNode.style.overflow="hidden";
}
this.simpleStructure=Boolean(vs.cells.length==1);
this.testFlexCells();
this.updateStructure();
},_cleanupRowWidgets:function(_c0){
if(_c0){
_ad.forEach(_b0("[widgetId]",_c0).map(_aa.byNode),function(w){
if(w._destroyOnRemove){
w.destroy();
delete w;
}else{
if(w.domNode&&w.domNode.parentNode){
w.domNode.parentNode.removeChild(w.domNode);
}
}
});
}
},onBeforeRow:function(_c1,_c2){
this._onBeforeRow(_c1,_c2);
if(_c1>=0){
this._cleanupRowWidgets(this.getRowNode(_c1));
}
},onAfterRow:function(_c3,_c4,_c5){
this._onAfterRow(_c3,_c4,_c5);
var g=this.grid;
_ad.forEach(_b0(".dojoxGridStubNode",_c5),function(n){
if(n&&n.parentNode){
var lw=n.getAttribute("linkWidget");
var _c6=window.parseInt(_b7.attr(n,"cellIdx"),10);
var _c7=g.getCell(_c6);
var w=_aa.byId(lw);
if(w){
n.parentNode.replaceChild(w.domNode,n);
if(!w._started){
w.startup();
}
_a9.destroy(n);
}else{
n.innerHTML="";
}
}
},this);
},testFlexCells:function(){
this.flexCells=false;
for(var j=0,row;(row=this.structure.cells[j]);j++){
for(var i=0,_c8;(_c8=row[i]);i++){
_c8.view=this;
this.flexCells=this.flexCells||_c8.isFlex();
}
}
return this.flexCells;
},updateStructure:function(){
this.header.update();
this.content.update();
},getScrollbarWidth:function(){
var _c9=this.hasVScrollbar();
var _ca=_b7.style(this.scrollboxNode,"overflow");
if(this.noscroll||!_ca||_ca=="hidden"){
_c9=false;
}else{
if(_ca=="scroll"){
_c9=true;
}
}
return (_c9?_b5.getScrollbar().w:0);
},getColumnsWidth:function(){
var h=this.headerContentNode;
return h&&h.firstChild?(h.firstChild.offsetWidth||_b7.style(h.firstChild,"width")):0;
},setColumnsWidth:function(_cb){
this.headerContentNode.firstChild.style.width=_cb+"px";
if(this.viewWidth){
this.viewWidth=_cb+"px";
}
},getWidth:function(){
return this.viewWidth||(this.getColumnsWidth()+this.getScrollbarWidth())+"px";
},getContentWidth:function(){
return Math.max(0,_b7._getContentBox(this.domNode).w-this.getScrollbarWidth())+"px";
},render:function(){
this.scrollboxNode.style.height="";
this.renderHeader();
if(this._togglingColumn>=0){
this.setColumnsWidth(this.getColumnsWidth()-this._togglingColumn);
this._togglingColumn=-1;
}
var _cc=this.grid.layout.cells;
var _cd=_ae.hitch(this,function(_ce,_cf){
!this.grid.isLeftToRight()&&(_cf=!_cf);
var inc=_cf?-1:1;
var idx=this.header.getCellNodeIndex(_ce)+inc;
var _d0=_cc[idx];
while(_d0&&_d0.getHeaderNode()&&_d0.getHeaderNode().style.display=="none"){
idx+=inc;
_d0=_cc[idx];
}
if(_d0){
return _d0.getHeaderNode();
}
return null;
});
if(this.grid.columnReordering&&this.simpleStructure){
if(this.source){
this.source.destroy();
}
var _d1="dojoxGrid_bottomMarker";
var _d2="dojoxGrid_topMarker";
if(this.bottomMarker){
_b7.destroy(this.bottomMarker);
}
this.bottomMarker=_b7.byId(_d1);
if(this.topMarker){
_b7.destroy(this.topMarker);
}
this.topMarker=_b7.byId(_d2);
if(!this.bottomMarker){
this.bottomMarker=_b7.create("div",{"id":_d1,"class":"dojoxGridColPlaceBottom"},win.body());
this._hide(this.bottomMarker);
this.topMarker=_b7.create("div",{"id":_d2,"class":"dojoxGridColPlaceTop"},win.body());
this._hide(this.topMarker);
}
this.arrowDim=_b7.contentBox(this.bottomMarker);
var _d3=_b7.contentBox(this.headerContentNode.firstChild.rows[0]).h;
this.source=new _b2(this.headerContentNode.firstChild.rows[0],{horizontal:true,accept:["gridColumn_"+this.grid.id],viewIndex:this.index,generateText:false,onMouseDown:_ae.hitch(this,function(e){
this.header.decorateEvent(e);
if((this.header.overRightResizeArea(e)||this.header.overLeftResizeArea(e))&&this.header.canResize(e)&&!this.header.moveable){
this.header.beginColumnResize(e);
}else{
if(this.grid.headerMenu){
this.grid.headerMenu.onCancel(true);
}
if(e.button===(has("ie")<9?1:0)){
_b2.prototype.onMouseDown.call(this.source,e);
}
}
}),onMouseOver:_ae.hitch(this,function(e){
var src=this.source;
if(src._getChildByEvent(e)){
_b2.prototype.onMouseOver.apply(src,arguments);
}
}),_markTargetAnchor:_ae.hitch(this,function(_d4){
var src=this.source;
if(src.current==src.targetAnchor&&src.before==_d4){
return;
}
if(src.targetAnchor&&_cd(src.targetAnchor,src.before)){
src._removeItemClass(_cd(src.targetAnchor,src.before),src.before?"After":"Before");
}
_b2.prototype._markTargetAnchor.call(src,_d4);
var _d5=_d4?src.targetAnchor:_cd(src.targetAnchor,src.before);
var _d6=0;
if(!_d5){
_d5=src.targetAnchor;
_d6=_b7.contentBox(_d5).w+this.arrowDim.w/2+2;
}
var pos=_b7.position(_d5,true);
var _d7=Math.floor(pos.x-this.arrowDim.w/2+_d6);
_b7.style(this.bottomMarker,"visibility","visible");
_b7.style(this.topMarker,"visibility","visible");
_b7.style(this.bottomMarker,{"left":_d7+"px","top":(_d3+pos.y)+"px"});
_b7.style(this.topMarker,{"left":_d7+"px","top":(pos.y-this.arrowDim.h)+"px"});
if(src.targetAnchor&&_cd(src.targetAnchor,src.before)){
src._addItemClass(_cd(src.targetAnchor,src.before),src.before?"After":"Before");
}
}),_unmarkTargetAnchor:_ae.hitch(this,function(){
var src=this.source;
if(!src.targetAnchor){
return;
}
if(src.targetAnchor&&_cd(src.targetAnchor,src.before)){
src._removeItemClass(_cd(src.targetAnchor,src.before),src.before?"After":"Before");
}
this._hide(this.bottomMarker);
this._hide(this.topMarker);
_b2.prototype._unmarkTargetAnchor.call(src);
}),destroy:_ae.hitch(this,function(){
_af.disconnect(this._source_conn);
_af.unsubscribe(this._source_sub);
_b2.prototype.destroy.call(this.source);
if(this.bottomMarker){
_b7.destroy(this.bottomMarker);
delete this.bottomMarker;
}
if(this.topMarker){
_b7.destroy(this.topMarker);
delete this.topMarker;
}
}),onDndCancel:_ae.hitch(this,function(){
_b2.prototype.onDndCancel.call(this.source);
this._hide(this.bottomMarker);
this._hide(this.topMarker);
})});
this._source_conn=_af.connect(this.source,"onDndDrop",this,"_onDndDrop");
this._source_sub=_af.subscribe("/dnd/drop/before",this,"_onDndDropBefore");
this.source.startup();
}
},_hide:function(_d8){
_b7.style(_d8,{top:"-10000px","visibility":"hidden"});
},_onDndDropBefore:function(_d9,_da,_db){
if(_ba.manager().target!==this.source){
return;
}
this.source._targetNode=this.source.targetAnchor;
this.source._beforeTarget=this.source.before;
var _dc=this.grid.views.views;
var _dd=_dc[_d9.viewIndex];
var _de=_dc[this.index];
if(_de!=_dd){
_dd.convertColPctToFixed();
_de.convertColPctToFixed();
}
},_onDndDrop:function(_df,_e0,_e1){
if(_ba.manager().target!==this.source){
if(_ba.manager().source===this.source){
this._removingColumn=true;
}
return;
}
this._hide(this.bottomMarker);
this._hide(this.topMarker);
var _e2=function(n){
return n?_b7.attr(n,"idx"):null;
};
var w=_b7.marginBox(_e0[0]).w;
if(_df.viewIndex!==this.index){
var _e3=this.grid.views.views;
var _e4=_e3[_df.viewIndex];
var _e5=_e3[this.index];
if(_e4.viewWidth&&_e4.viewWidth!="auto"){
_e4.setColumnsWidth(_e4.getColumnsWidth()-w);
}
if(_e5.viewWidth&&_e5.viewWidth!="auto"){
_e5.setColumnsWidth(_e5.getColumnsWidth());
}
}
var stn=this.source._targetNode;
var stb=this.source._beforeTarget;
!this.grid.isLeftToRight()&&(stb=!stb);
var _e6=this.grid.layout;
var idx=this.index;
delete this.source._targetNode;
delete this.source._beforeTarget;
_e6.moveColumn(_df.viewIndex,idx,_e2(_e0[0]),_e2(stn),stb);
},renderHeader:function(){
this.headerContentNode.innerHTML=this.header.generateHtml(this._getHeaderContent);
if(this.flexCells){
this.contentWidth=this.getContentWidth();
this.headerContentNode.firstChild.style.width=this.contentWidth;
}
_b6.fire(this,"onAfterRow",[-1,this.structure.cells,this.headerContentNode]);
},_getHeaderContent:function(_e7){
var n=_e7.name||_e7.grid.getCellName(_e7);
if(/^\s+$/.test(n)){
n="&nbsp;";
}
var ret=["<div class=\"dojoxGridSortNode"];
if(_e7.index!=_e7.grid.getSortIndex()){
ret.push("\">");
}else{
ret=ret.concat([" ",_e7.grid.sortInfo>0?"dojoxGridSortUp":"dojoxGridSortDown","\"><div class=\"dojoxGridArrowButtonChar\">",_e7.grid.sortInfo>0?"&#9650;":"&#9660;","</div><div class=\"dojoxGridArrowButtonNode\" role=\"presentation\"></div>","<div class=\"dojoxGridColCaption\">"]);
}
ret=ret.concat([n,"</div></div>"]);
return ret.join("");
},resize:function(){
this.adaptHeight();
this.adaptWidth();
},hasHScrollbar:function(_e8){
var _e9=this._hasHScroll||false;
if(this._hasHScroll==undefined||_e8){
if(this.noscroll){
this._hasHScroll=false;
}else{
var _ea=_b7.style(this.scrollboxNode,"overflow");
if(_ea=="hidden"){
this._hasHScroll=false;
}else{
if(_ea=="scroll"){
this._hasHScroll=true;
}else{
this._hasHScroll=(this.scrollboxNode.offsetWidth-this.getScrollbarWidth()<this.contentNode.offsetWidth);
}
}
}
}
if(_e9!==this._hasHScroll){
this.grid.update();
}
return this._hasHScroll;
},hasVScrollbar:function(_eb){
var _ec=this._hasVScroll||false;
if(this._hasVScroll==undefined||_eb){
if(this.noscroll){
this._hasVScroll=false;
}else{
var _ed=_b7.style(this.scrollboxNode,"overflow");
if(_ed=="hidden"){
this._hasVScroll=false;
}else{
if(_ed=="scroll"){
this._hasVScroll=true;
}else{
this._hasVScroll=(this.scrollboxNode.scrollHeight>this.scrollboxNode.clientHeight);
}
}
}
}
if(_ec!==this._hasVScroll){
this.grid.update();
}
return this._hasVScroll;
},convertColPctToFixed:function(){
var _ee=false;
this.grid.initialWidth="";
var _ef=_b0("th",this.headerContentNode);
var _f0=_ad.map(_ef,function(c,_f1){
var w=c.style.width;
_b7.attr(c,"vIdx",_f1);
if(w&&w.slice(-1)=="%"){
_ee=true;
}else{
if(w&&w.slice(-2)=="px"){
return window.parseInt(w,10);
}
}
return _b7.contentBox(c).w;
});
if(_ee){
_ad.forEach(this.grid.layout.cells,function(_f2,idx){
if(_f2.view==this){
var _f3=_f2.view.getHeaderCellNode(_f2.index);
if(_f3&&_b7.hasAttr(_f3,"vIdx")){
var _f4=window.parseInt(_b7.attr(_f3,"vIdx"));
this.setColWidth(idx,_f0[_f4]);
_b7.removeAttr(_f3,"vIdx");
}
}
},this);
return true;
}
return false;
},adaptHeight:function(_f5){
if(!this.grid._autoHeight){
var h=(this.domNode.style.height&&parseInt(this.domNode.style.height.replace(/px/,""),10))||this.domNode.clientHeight;
var _f6=this;
var _f7=function(){
var v;
for(var i in _f6.grid.views.views){
v=_f6.grid.views.views[i];
if(v!==_f6&&v.hasHScrollbar()){
return true;
}
}
return false;
};
if(_f5||(this.noscroll&&_f7())){
h-=_b5.getScrollbar().h;
}
_b6.setStyleHeightPx(this.scrollboxNode,h);
}
this.hasVScrollbar(true);
},adaptWidth:function(){
if(this.flexCells){
this.contentWidth=this.getContentWidth();
this.headerContentNode.firstChild.style.width=this.contentWidth;
}
var w=this.scrollboxNode.offsetWidth-this.getScrollbarWidth();
if(!this._removingColumn){
w=Math.max(w,this.getColumnsWidth())+"px";
}else{
w=Math.min(w,this.getColumnsWidth())+"px";
this._removingColumn=false;
}
var cn=this.contentNode;
cn.style.width=w;
this.hasHScrollbar(true);
},setSize:function(w,h){
var ds=this.domNode.style;
var hs=this.headerNode.style;
if(w){
ds.width=w;
hs.width=w;
}
ds.height=(h>=0?h+"px":"");
},renderRow:function(_f8){
var _f9=this.createRowNode(_f8);
this.buildRow(_f8,_f9);
return _f9;
},createRowNode:function(_fa){
var _fb=document.createElement("div");
_fb.className=this.classTag+"Row";
if(this instanceof _ab.grid._RowSelector){
_b7.attr(_fb,"role","presentation");
}else{
_b7.attr(_fb,"role","row");
if(this.grid.selectionMode!="none"){
_fb.setAttribute("aria-selected","false");
}
}
_fb[_b6.gridViewTag]=this.id;
_fb[_b6.rowIndexTag]=_fa;
this.rowNodes[_fa]=_fb;
return _fb;
},buildRow:function(_fc,_fd){
this.buildRowContent(_fc,_fd);
this.styleRow(_fc,_fd);
},buildRowContent:function(_fe,_ff){
_ff.innerHTML=this.content.generateHtml(_fe,_fe);
if(this.flexCells&&this.contentWidth){
_ff.firstChild.style.width=this.contentWidth;
}
_b6.fire(this,"onAfterRow",[_fe,this.structure.cells,_ff]);
},rowRemoved:function(_100){
if(_100>=0){
this._cleanupRowWidgets(this.getRowNode(_100));
}
this.grid.edit.save(this,_100);
delete this.rowNodes[_100];
},getRowNode:function(_101){
return this.rowNodes[_101];
},getCellNode:function(_102,_103){
var row=this.getRowNode(_102);
if(row){
return this.content.getCellNode(row,_103);
}
},getHeaderCellNode:function(_104){
if(this.headerContentNode){
return this.header.getCellNode(this.headerContentNode,_104);
}
},styleRow:function(_105,_106){
_106._style=_bb(_106);
this.styleRowNode(_105,_106);
},styleRowNode:function(_107,_108){
if(_108){
this.doStyleRowNode(_107,_108);
}
},doStyleRowNode:function(_109,_10a){
this.grid.styleRowNode(_109,_10a);
},updateRow:function(_10b){
var _10c=this.getRowNode(_10b);
if(_10c){
_10c.style.height="";
this.buildRow(_10b,_10c);
}
return _10c;
},updateRowStyles:function(_10d){
this.styleRowNode(_10d,this.getRowNode(_10d));
},lastTop:0,firstScroll:0,_nativeScroll:false,doscroll:function(_10e){
if(has("ff")>=13){
this._nativeScroll=true;
}
var _10f=this.grid.isLeftToRight();
if(this.firstScroll<2){
if((!_10f&&this.firstScroll==1)||(_10f&&this.firstScroll===0)){
var s=_b7.marginBox(this.headerNodeContainer);
if(has("ie")){
this.headerNodeContainer.style.width=s.w+this.getScrollbarWidth()+"px";
}else{
if(has("mozilla")){
this.headerNodeContainer.style.width=s.w-this.getScrollbarWidth()+"px";
this.scrollboxNode.scrollLeft=_10f?this.scrollboxNode.clientWidth-this.scrollboxNode.scrollWidth:this.scrollboxNode.scrollWidth-this.scrollboxNode.clientWidth;
}
}
}
this.firstScroll++;
}
this.headerNode.scrollLeft=this.scrollboxNode.scrollLeft;
var top=this.scrollboxNode.scrollTop;
if(top!==this.lastTop){
this.grid.scrollTo(top);
}
this._nativeScroll=false;
},setScrollTop:function(_110){
this.lastTop=_110;
if(!this._nativeScroll){
this.scrollboxNode.scrollTop=_110;
}
return this.scrollboxNode.scrollTop;
},doContentEvent:function(e){
if(this.content.decorateEvent(e)){
this.grid.onContentEvent(e);
}
},doHeaderEvent:function(e){
if(this.header.decorateEvent(e)){
this.grid.onHeaderEvent(e);
}
},dispatchContentEvent:function(e){
return this.content.dispatchEvent(e);
},dispatchHeaderEvent:function(e){
return this.header.dispatchEvent(e);
},setColWidth:function(_111,_112){
this.grid.setCellWidth(_111,_112+"px");
},update:function(){
if(!this.domNode){
return;
}
this.content.update();
this.grid.update();
var left=this.scrollboxNode.scrollLeft;
this.scrollboxNode.scrollLeft=left;
this.headerNode.scrollLeft=left;
}});
var _113=_ac("dojox.grid._GridAvatar",_b9,{construct:function(){
var dd=win.doc;
var a=dd.createElement("table");
a.cellPadding=a.cellSpacing="0";
a.className="dojoxGridDndAvatar";
a.style.position="absolute";
a.style.zIndex=1999;
a.style.margin="0px";
var b=dd.createElement("tbody");
var tr=dd.createElement("tr");
var td=dd.createElement("td");
var img=dd.createElement("td");
tr.className="dojoxGridDndAvatarItem";
img.className="dojoxGridDndAvatarItemImage";
img.style.width="16px";
var _114=this.manager.source,node;
if(_114.creator){
node=_114._normalizedCreator(_114.getItem(this.manager.nodes[0].id).data,"avatar").node;
}else{
node=this.manager.nodes[0].cloneNode(true);
var _115,_116;
if(node.tagName.toLowerCase()=="tr"){
_115=dd.createElement("table");
_116=dd.createElement("tbody");
_116.appendChild(node);
_115.appendChild(_116);
node=_115;
}else{
if(node.tagName.toLowerCase()=="th"){
_115=dd.createElement("table");
_116=dd.createElement("tbody");
var r=dd.createElement("tr");
_115.cellPadding=_115.cellSpacing="0";
r.appendChild(node);
_116.appendChild(r);
_115.appendChild(_116);
node=_115;
}
}
}
node.id="";
td.appendChild(node);
tr.appendChild(img);
tr.appendChild(td);
_b7.style(tr,"opacity",0.9);
b.appendChild(tr);
a.appendChild(b);
this.node=a;
var m=_ba.manager();
this.oldOffsetY=m.OFFSET_Y;
m.OFFSET_Y=1;
},destroy:function(){
_ba.manager().OFFSET_Y=this.oldOffsetY;
this.inherited(arguments);
}});
var _117=_ba.manager().makeAvatar;
_ba.manager().makeAvatar=function(){
var src=this.source;
if(src.viewIndex!==undefined&&!_b7.hasClass(win.body(),"dijit_a11y")){
return new _113(this);
}
return _117.call(_ba.manager());
};
return _be;
});
},"dijit/CheckedMenuItem":function(){
define(["dojo/_base/declare","dojo/dom-class","./MenuItem","dojo/text!./templates/CheckedMenuItem.html","./hccss"],function(_118,_119,_11a,_11b){
return _118("dijit.CheckedMenuItem",_11a,{templateString:_11b,checked:false,_setCheckedAttr:function(_11c){
_119.toggle(this.domNode,"dijitCheckedMenuItemChecked",_11c);
this.domNode.setAttribute("aria-checked",_11c?"true":"false");
this._set("checked",_11c);
},iconClass:"",onChange:function(){
},_onClick:function(evt){
if(!this.disabled){
this.set("checked",!this.checked);
this.onChange(this.checked);
}
this.onClick(evt);
}});
});
},"dojo/hccss":function(){
define(["require","./_base/config","./dom-class","./dom-style","./has","./ready","./_base/window"],function(_11d,_11e,_11f,_120,has,_121,win){
has.add("highcontrast",function(){
var div=win.doc.createElement("div");
div.style.cssText="border: 1px solid; border-color:red green; position: absolute; height: 5px; top: -999px;"+"background-image: url("+(_11e.blankGif||_11d.toUrl("./resources/blank.gif"))+");";
win.body().appendChild(div);
var cs=_120.getComputedStyle(div),_122=cs.backgroundImage,hc=(cs.borderTopColor==cs.borderRightColor)||(_122&&(_122=="none"||_122=="url(invalid-url:)"));
if(has("ie")<=8){
div.outerHTML="";
}else{
win.body().removeChild(div);
}
return hc;
});
_121(90,function(){
if(has("highcontrast")){
_11f.add(win.body(),"dj_a11y");
}
});
return has;
});
},"dijit/_WidgetBase":function(){
define(["require","dojo/_base/array","dojo/aspect","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/ready","dojo/Stateful","dojo/topic","dojo/_base/window","./Destroyable","./registry"],function(_123,_124,_125,_126,_127,_128,dom,_129,_12a,_12b,_12c,_12d,has,_12e,lang,on,_12f,_130,_131,win,_132,_133){
has.add("dijit-legacy-requires",!_12e.isAsync);
if(has("dijit-legacy-requires")){
_12f(0,function(){
var _134=["dijit/_base/manager"];
_123(_134);
});
}
var _135={};
function _136(obj){
var ret={};
for(var attr in obj){
ret[attr.toLowerCase()]=true;
}
return ret;
};
function _137(attr){
return function(val){
_129[val?"set":"remove"](this.domNode,attr,val);
this._set(attr,val);
};
};
return _128("dijit._WidgetBase",[_130,_132],{id:"",_setIdAttr:"domNode",lang:"",_setLangAttr:_137("lang"),dir:"",_setDirAttr:_137("dir"),textDir:"","class":"",_setClassAttr:{node:"domNode",type:"class"},style:"",title:"",tooltip:"",baseClass:"",srcNodeRef:null,domNode:null,containerNode:null,ownerDocument:null,_setOwnerDocumentAttr:function(val){
this._set("ownerDocument",val);
},attributeMap:{},_blankGif:_126.blankGif||_123.toUrl("dojo/resources/blank.gif"),postscript:function(_138,_139){
this.create(_138,_139);
},create:function(_13a,_13b){
this.srcNodeRef=dom.byId(_13b);
this._connects=[];
this._supportingWidgets=[];
if(this.srcNodeRef&&(typeof this.srcNodeRef.id=="string")){
this.id=this.srcNodeRef.id;
}
if(_13a){
this.params=_13a;
lang.mixin(this,_13a);
}
this.postMixInProperties();
if(!this.id){
this.id=_133.getUniqueId(this.declaredClass.replace(/\./g,"_"));
if(this.params){
delete this.params.id;
}
}
this.ownerDocument=this.ownerDocument||(this.srcNodeRef?this.srcNodeRef.ownerDocument:win.doc);
this.ownerDocumentBody=win.body(this.ownerDocument);
_133.add(this);
this.buildRendering();
var _13c;
if(this.domNode){
this._applyAttributes();
var _13d=this.srcNodeRef;
if(_13d&&_13d.parentNode&&this.domNode!==_13d){
_13d.parentNode.replaceChild(this.domNode,_13d);
_13c=true;
}
this.domNode.setAttribute("widgetId",this.id);
}
this.postCreate();
if(_13c){
delete this.srcNodeRef;
}
this._created=true;
},_applyAttributes:function(){
var ctor=this.constructor,list=ctor._setterAttrs;
if(!list){
list=(ctor._setterAttrs=[]);
for(var attr in this.attributeMap){
list.push(attr);
}
var _13e=ctor.prototype;
for(var _13f in _13e){
if(_13f in this.attributeMap){
continue;
}
var _140="_set"+_13f.replace(/^[a-z]|-[a-zA-Z]/g,function(c){
return c.charAt(c.length-1).toUpperCase();
})+"Attr";
if(_140 in _13e){
list.push(_13f);
}
}
}
var _141={};
for(var key in this.params||{}){
_141[key]=this[key];
}
_124.forEach(list,function(attr){
if(attr in _141){
}else{
if(this[attr]){
this.set(attr,this[attr]);
}
}
},this);
for(key in _141){
this.set(key,_141[key]);
}
},postMixInProperties:function(){
},buildRendering:function(){
if(!this.domNode){
this.domNode=this.srcNodeRef||this.ownerDocument.createElement("div");
}
if(this.baseClass){
var _142=this.baseClass.split(" ");
if(!this.isLeftToRight()){
_142=_142.concat(_124.map(_142,function(name){
return name+"Rtl";
}));
}
_12a.add(this.domNode,_142);
}
},postCreate:function(){
},startup:function(){
if(this._started){
return;
}
this._started=true;
_124.forEach(this.getChildren(),function(obj){
if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){
obj.startup();
obj._started=true;
}
});
},destroyRecursive:function(_143){
this._beingDestroyed=true;
this.destroyDescendants(_143);
this.destroy(_143);
},destroy:function(_144){
this._beingDestroyed=true;
this.uninitialize();
function _145(w){
if(w.destroyRecursive){
w.destroyRecursive(_144);
}else{
if(w.destroy){
w.destroy(_144);
}
}
};
_124.forEach(this._connects,lang.hitch(this,"disconnect"));
_124.forEach(this._supportingWidgets,_145);
if(this.domNode){
_124.forEach(_133.findWidgets(this.domNode,this.containerNode),_145);
}
this.destroyRendering(_144);
_133.remove(this.id);
this._destroyed=true;
},destroyRendering:function(_146){
if(this.bgIframe){
this.bgIframe.destroy(_146);
delete this.bgIframe;
}
if(this.domNode){
if(_146){
_129.remove(this.domNode,"widgetId");
}else{
_12b.destroy(this.domNode);
}
delete this.domNode;
}
if(this.srcNodeRef){
if(!_146){
_12b.destroy(this.srcNodeRef);
}
delete this.srcNodeRef;
}
},destroyDescendants:function(_147){
_124.forEach(this.getChildren(),function(_148){
if(_148.destroyRecursive){
_148.destroyRecursive(_147);
}
});
},uninitialize:function(){
return false;
},_setStyleAttr:function(_149){
var _14a=this.domNode;
if(lang.isObject(_149)){
_12d.set(_14a,_149);
}else{
if(_14a.style.cssText){
_14a.style.cssText+="; "+_149;
}else{
_14a.style.cssText=_149;
}
}
this._set("style",_149);
},_attrToDom:function(attr,_14b,_14c){
_14c=arguments.length>=3?_14c:this.attributeMap[attr];
_124.forEach(lang.isArray(_14c)?_14c:[_14c],function(_14d){
var _14e=this[_14d.node||_14d||"domNode"];
var type=_14d.type||"attribute";
switch(type){
case "attribute":
if(lang.isFunction(_14b)){
_14b=lang.hitch(this,_14b);
}
var _14f=_14d.attribute?_14d.attribute:(/^on[A-Z][a-zA-Z]*$/.test(attr)?attr.toLowerCase():attr);
if(_14e.tagName){
_129.set(_14e,_14f,_14b);
}else{
_14e.set(_14f,_14b);
}
break;
case "innerText":
_14e.innerHTML="";
_14e.appendChild(this.ownerDocument.createTextNode(_14b));
break;
case "innerHTML":
_14e.innerHTML=_14b;
break;
case "class":
_12a.replace(_14e,_14b,this[attr]);
break;
}
},this);
},get:function(name){
var _150=this._getAttrNames(name);
return this[_150.g]?this[_150.g]():this[name];
},set:function(name,_151){
if(typeof name==="object"){
for(var x in name){
this.set(x,name[x]);
}
return this;
}
var _152=this._getAttrNames(name),_153=this[_152.s];
if(lang.isFunction(_153)){
var _154=_153.apply(this,Array.prototype.slice.call(arguments,1));
}else{
var _155=this.focusNode&&!lang.isFunction(this.focusNode)?"focusNode":"domNode",tag=this[_155].tagName,_156=_135[tag]||(_135[tag]=_136(this[_155])),map=name in this.attributeMap?this.attributeMap[name]:_152.s in this?this[_152.s]:((_152.l in _156&&typeof _151!="function")||/^aria-|^data-|^role$/.test(name))?_155:null;
if(map!=null){
this._attrToDom(name,_151,map);
}
this._set(name,_151);
}
return _154||this;
},_attrPairNames:{},_getAttrNames:function(name){
var apn=this._attrPairNames;
if(apn[name]){
return apn[name];
}
var uc=name.replace(/^[a-z]|-[a-zA-Z]/g,function(c){
return c.charAt(c.length-1).toUpperCase();
});
return (apn[name]={n:name+"Node",s:"_set"+uc+"Attr",g:"_get"+uc+"Attr",l:uc.toLowerCase()});
},_set:function(name,_157){
var _158=this[name];
this[name]=_157;
if(this._created&&_157!==_158){
if(this._watchCallbacks){
this._watchCallbacks(name,_158,_157);
}
this.emit("attrmodified-"+name,{detail:{prevValue:_158,newValue:_157}});
}
},emit:function(type,_159,_15a){
_159=_159||{};
if(_159.bubbles===undefined){
_159.bubbles=true;
}
if(_159.cancelable===undefined){
_159.cancelable=true;
}
if(!_159.detail){
_159.detail={};
}
_159.detail.widget=this;
var ret,_15b=this["on"+type];
if(_15b){
ret=_15b.apply(this,_15a?_15a:[_159]);
}
if(this._started&&!this._beingDestroyed){
on.emit(this.domNode,type.toLowerCase(),_159);
}
return ret;
},on:function(type,func){
var _15c=this._onMap(type);
if(_15c){
return _125.after(this,_15c,func,true);
}
return this.own(on(this.domNode,type,func))[0];
},_onMap:function(type){
var ctor=this.constructor,map=ctor._onMap;
if(!map){
map=(ctor._onMap={});
for(var attr in ctor.prototype){
if(/^on/.test(attr)){
map[attr.replace(/^on/,"").toLowerCase()]=attr;
}
}
}
return map[typeof type=="string"&&type.toLowerCase()];
},toString:function(){
return "[Widget "+this.declaredClass+", "+(this.id||"NO ID")+"]";
},getChildren:function(){
return this.containerNode?_133.findWidgets(this.containerNode):[];
},getParent:function(){
return _133.getEnclosingWidget(this.domNode.parentNode);
},connect:function(obj,_15d,_15e){
return this.own(_127.connect(obj,_15d,this,_15e))[0];
},disconnect:function(_15f){
_15f.remove();
},subscribe:function(t,_160){
return this.own(_131.subscribe(t,lang.hitch(this,_160)))[0];
},unsubscribe:function(_161){
_161.remove();
},isLeftToRight:function(){
return this.dir?(this.dir=="ltr"):_12c.isBodyLtr(this.ownerDocument);
},isFocusable:function(){
return this.focus&&(_12d.get(this.domNode,"display")!="none");
},placeAt:function(_162,_163){
var _164=!_162.tagName&&_133.byId(_162);
if(_164&&_164.addChild&&(!_163||typeof _163==="number")){
_164.addChild(this,_163);
}else{
var ref=_164?(_164.containerNode&&!/after|before|replace/.test(_163||"")?_164.containerNode:_164.domNode):dom.byId(_162,this.ownerDocument);
_12b.place(this.domNode,ref,_163);
if(!this._started&&(this.getParent()||{})._started){
this.startup();
}
}
return this;
},getTextDir:function(text,_165){
return _165;
},applyTextDir:function(){
},defer:function(fcn,_166){
var _167=setTimeout(lang.hitch(this,function(){
_167=null;
if(!this._destroyed){
lang.hitch(this,fcn)();
}
}),_166||0);
return {remove:function(){
if(_167){
clearTimeout(_167);
_167=null;
}
return null;
}};
}});
});
},"dojo/dnd/common":function(){
define(["../_base/connect","../_base/kernel","../_base/lang","../dom"],function(_168,_169,lang,dom){
var _16a=lang.getObject("dojo.dnd",true);
_16a.getCopyKeyState=_168.isCopyKey;
_16a._uniqueId=0;
_16a.getUniqueId=function(){
var id;
do{
id=_169._scopeName+"Unique"+(++_16a._uniqueId);
}while(dom.byId(id));
return id;
};
_16a._empty={};
_16a.isFormElement=function(e){
var t=e.target;
if(t.nodeType==3){
t=t.parentNode;
}
return " button textarea input select option ".indexOf(" "+t.tagName.toLowerCase()+" ")>=0;
};
return _16a;
});
},"dojox/main":function(){
define("dojox/main",["dojo/_base/kernel"],function(dojo){
return dojo.dojox;
});
},"dojo/touch":function(){
define(["./_base/kernel","./aspect","./dom","./on","./has","./mouse","./ready","./_base/window"],function(dojo,_16b,dom,on,has,_16c,_16d,win){
var _16e=has("touch");
var ios4=false;
if(has("ios")){
var ua=navigator.userAgent;
var v=ua.match(/OS ([\d_]+)/)?RegExp.$1:"1";
var os=parseFloat(v.replace(/_/,".").replace(/_/g,""));
ios4=os<5;
}
var _16f,_170;
if(_16e){
_16d(function(){
_170=win.body();
win.doc.addEventListener("touchstart",function(evt){
var _171=_170;
_170=evt.target;
on.emit(_171,"dojotouchout",{target:_171,relatedTarget:_170,bubbles:true});
on.emit(_170,"dojotouchover",{target:_170,relatedTarget:_171,bubbles:true});
},true);
on(win.doc,"touchmove",function(evt){
var _172=win.doc.elementFromPoint(evt.pageX-(ios4?0:win.global.pageXOffset),evt.pageY-(ios4?0:win.global.pageYOffset));
if(_172&&_170!==_172){
on.emit(_170,"dojotouchout",{target:_170,relatedTarget:_172,bubbles:true});
on.emit(_172,"dojotouchover",{target:_172,relatedTarget:_170,bubbles:true});
_170=_172;
}
});
});
_16f=function(node,_173){
return on(win.doc,"touchmove",function(evt){
if(node===win.doc||dom.isDescendant(_170,node)){
evt.target=_170;
_173.call(this,evt);
}
});
};
}
function _174(type){
return function(node,_175){
return on(node,type,_175);
};
};
var _176={press:_174(_16e?"touchstart":"mousedown"),move:_16e?_16f:_174("mousemove"),release:_174(_16e?"touchend":"mouseup"),cancel:_16e?_174("touchcancel"):_16c.leave,over:_174(_16e?"dojotouchover":"mouseover"),out:_174(_16e?"dojotouchout":"mouseout"),enter:_16c._eventHandler(_16e?"dojotouchover":"mouseover"),leave:_16c._eventHandler(_16e?"dojotouchout":"mouseout")};
1&&(dojo.touch=_176);
return _176;
});
},"dojox/grid/cells/_base":function(){
define("dojox/grid/cells/_base",["dojo/_base/kernel","dojo/_base/declare","dojo/_base/lang","dojo/_base/event","dojo/_base/connect","dojo/_base/array","dojo/_base/sniff","dojo/dom","dojo/dom-attr","dojo/dom-construct","dijit/_Widget","../util"],function(dojo,_177,lang,_178,_179,_17a,has,dom,_17b,_17c,_17d,util){
var _17e=_177("dojox.grid._DeferredTextWidget",_17d,{deferred:null,_destroyOnRemove:true,postCreate:function(){
if(this.deferred){
this.deferred.addBoth(lang.hitch(this,function(text){
if(this.domNode){
this.domNode.innerHTML=text;
}
}));
}
}});
var _17f=function(_180){
try{
util.fire(_180,"focus");
util.fire(_180,"select");
}
catch(e){
}
};
var _181=function(){
setTimeout(lang.hitch.apply(dojo,arguments),0);
};
var _182=_177("dojox.grid.cells._Base",null,{styles:"",classes:"",editable:false,alwaysEditing:false,formatter:null,defaultValue:"...",value:null,hidden:false,noresize:false,draggable:true,_valueProp:"value",_formatPending:false,constructor:function(_183){
this._props=_183||{};
lang.mixin(this,_183);
if(this.draggable===undefined){
this.draggable=true;
}
},_defaultFormat:function(_184,_185){
var s=this.grid.formatterScope||this;
var f=this.formatter;
if(f&&s&&typeof f=="string"){
f=this.formatter=s[f];
}
var v=(_184!=this.defaultValue&&f)?f.apply(s,_185):_184;
if(typeof v=="undefined"){
return this.defaultValue;
}
if(v&&v.addBoth){
v=new _17e({deferred:v},_17c.create("span",{innerHTML:this.defaultValue}));
}
if(v&&v.declaredClass&&v.startup){
return "<div class='dojoxGridStubNode' linkWidget='"+v.id+"' cellIdx='"+this.index+"'>"+this.defaultValue+"</div>";
}
return v;
},format:function(_186,_187){
var f,i=this.grid.edit.info,d=this.get?this.get(_186,_187):(this.value||this.defaultValue);
d=(d&&d.replace&&this.grid.escapeHTMLInData)?d.replace(/&/g,"&amp;").replace(/</g,"&lt;"):d;
if(this.editable&&(this.alwaysEditing||(i.rowIndex==_186&&i.cell==this))){
return this.formatEditing(d,_186);
}else{
return this._defaultFormat(d,[d,_186,this]);
}
},formatEditing:function(_188,_189){
},getNode:function(_18a){
return this.view.getCellNode(_18a,this.index);
},getHeaderNode:function(){
return this.view.getHeaderCellNode(this.index);
},getEditNode:function(_18b){
return (this.getNode(_18b)||0).firstChild||0;
},canResize:function(){
var uw=this.unitWidth;
return uw&&(uw!=="auto");
},isFlex:function(){
var uw=this.unitWidth;
return uw&&lang.isString(uw)&&(uw=="auto"||uw.slice(-1)=="%");
},applyEdit:function(_18c,_18d){
if(this.getNode(_18d)){
this.grid.edit.applyCellEdit(_18c,this,_18d);
}
},cancelEdit:function(_18e){
this.grid.doCancelEdit(_18e);
},_onEditBlur:function(_18f){
if(this.grid.edit.isEditCell(_18f,this.index)){
this.grid.edit.apply();
}
},registerOnBlur:function(_190,_191){
if(this.commitOnBlur){
_179.connect(_190,"onblur",function(e){
setTimeout(lang.hitch(this,"_onEditBlur",_191),250);
});
}
},needFormatNode:function(_192,_193){
this._formatPending=true;
_181(this,"_formatNode",_192,_193);
},cancelFormatNode:function(){
this._formatPending=false;
},_formatNode:function(_194,_195){
if(this._formatPending){
this._formatPending=false;
if(!has("ie")){
dom.setSelectable(this.grid.domNode,true);
}
this.formatNode(this.getEditNode(_195),_194,_195);
}
},formatNode:function(_196,_197,_198){
if(has("ie")){
_181(this,"focus",_198,_196);
}else{
this.focus(_198,_196);
}
},dispatchEvent:function(m,e){
if(m in this){
return this[m](e);
}
},getValue:function(_199){
return this.getEditNode(_199)[this._valueProp];
},setValue:function(_19a,_19b){
var n=this.getEditNode(_19a);
if(n){
n[this._valueProp]=_19b;
}
},focus:function(_19c,_19d){
_17f(_19d||this.getEditNode(_19c));
},save:function(_19e){
this.value=this.value||this.getValue(_19e);
},restore:function(_19f){
this.setValue(_19f,this.value);
},_finish:function(_1a0){
dom.setSelectable(this.grid.domNode,false);
this.cancelFormatNode();
},apply:function(_1a1){
this.applyEdit(this.getValue(_1a1),_1a1);
this._finish(_1a1);
},cancel:function(_1a2){
this.cancelEdit(_1a2);
this._finish(_1a2);
}});
_182.markupFactory=function(node,_1a3){
var _1a4=lang.trim(_17b.get(node,"formatter")||"");
if(_1a4){
_1a3.formatter=lang.getObject(_1a4)||_1a4;
}
var get=lang.trim(_17b.get(node,"get")||"");
if(get){
_1a3.get=lang.getObject(get);
}
var _1a5=function(attr,cell,_1a6){
var _1a7=lang.trim(_17b.get(node,attr)||"");
if(_1a7){
cell[_1a6||attr]=!(_1a7.toLowerCase()=="false");
}
};
_1a5("sortDesc",_1a3);
_1a5("editable",_1a3);
_1a5("alwaysEditing",_1a3);
_1a5("noresize",_1a3);
_1a5("draggable",_1a3);
var _1a8=lang.trim(_17b.get(node,"loadingText")||_17b.get(node,"defaultValue")||"");
if(_1a8){
_1a3.defaultValue=_1a8;
}
var _1a9=function(attr,cell,_1aa){
var _1ab=lang.trim(_17b.get(node,attr)||"")||undefined;
if(_1ab){
cell[_1aa||attr]=_1ab;
}
};
_1a9("styles",_1a3);
_1a9("headerStyles",_1a3);
_1a9("cellStyles",_1a3);
_1a9("classes",_1a3);
_1a9("headerClasses",_1a3);
_1a9("cellClasses",_1a3);
};
var Cell=_177("dojox.grid.cells.Cell",_182,{constructor:function(){
this.keyFilter=this.keyFilter;
},keyFilter:null,formatEditing:function(_1ac,_1ad){
this.needFormatNode(_1ac,_1ad);
return "<input class=\"dojoxGridInput\" type=\"text\" value=\""+_1ac+"\">";
},formatNode:function(_1ae,_1af,_1b0){
this.inherited(arguments);
this.registerOnBlur(_1ae,_1b0);
},doKey:function(e){
if(this.keyFilter){
var key=String.fromCharCode(e.charCode);
if(key.search(this.keyFilter)==-1){
_178.stop(e);
}
}
},_finish:function(_1b1){
this.inherited(arguments);
var n=this.getEditNode(_1b1);
try{
util.fire(n,"blur");
}
catch(e){
}
}});
Cell.markupFactory=function(node,_1b2){
_182.markupFactory(node,_1b2);
var _1b3=lang.trim(_17b.get(node,"keyFilter")||"");
if(_1b3){
_1b2.keyFilter=new RegExp(_1b3);
}
};
var _1b4=_177("dojox.grid.cells.RowIndex",Cell,{name:"Row",postscript:function(){
this.editable=false;
},get:function(_1b5){
return _1b5+1;
}});
_1b4.markupFactory=function(node,_1b6){
Cell.markupFactory(node,_1b6);
};
var _1b7=_177("dojox.grid.cells.Select",Cell,{options:null,values:null,returnIndex:-1,constructor:function(_1b8){
this.values=this.values||this.options;
},formatEditing:function(_1b9,_1ba){
this.needFormatNode(_1b9,_1ba);
var h=["<select class=\"dojoxGridSelect\">"];
for(var i=0,o,v;((o=this.options[i])!==undefined)&&((v=this.values[i])!==undefined);i++){
v=v.replace?v.replace(/&/g,"&amp;").replace(/</g,"&lt;"):v;
o=o.replace?o.replace(/&/g,"&amp;").replace(/</g,"&lt;"):o;
h.push("<option",(_1b9==v?" selected":"")," value=\""+v+"\"",">",o,"</option>");
}
h.push("</select>");
return h.join("");
},_defaultFormat:function(_1bb,_1bc){
var v=this.inherited(arguments);
if(!this.formatter&&this.values&&this.options){
var i=_17a.indexOf(this.values,v);
if(i>=0){
v=this.options[i];
}
}
return v;
},getValue:function(_1bd){
var n=this.getEditNode(_1bd);
if(n){
var i=n.selectedIndex,o=n.options[i];
return this.returnIndex>-1?i:o.value||o.innerHTML;
}
}});
_1b7.markupFactory=function(node,cell){
Cell.markupFactory(node,cell);
var _1be=lang.trim(_17b.get(node,"options")||"");
if(_1be){
var o=_1be.split(",");
if(o[0]!=_1be){
cell.options=o;
}
}
var _1bf=lang.trim(_17b.get(node,"values")||"");
if(_1bf){
var v=_1bf.split(",");
if(v[0]!=_1bf){
cell.values=v;
}
}
};
var _1c0=_177("dojox.grid.cells.AlwaysEdit",Cell,{alwaysEditing:true,_formatNode:function(_1c1,_1c2){
this.formatNode(this.getEditNode(_1c2),_1c1,_1c2);
},applyStaticValue:function(_1c3){
var e=this.grid.edit;
e.applyCellEdit(this.getValue(_1c3),this,_1c3);
e.start(this,_1c3,true);
}});
_1c0.markupFactory=function(node,cell){
Cell.markupFactory(node,cell);
};
var Bool=_177("dojox.grid.cells.Bool",_1c0,{_valueProp:"checked",formatEditing:function(_1c4,_1c5){
return "<input class=\"dojoxGridInput\" type=\"checkbox\""+(_1c4?" checked=\"checked\"":"")+" style=\"width: auto\" />";
},doclick:function(e){
if(e.target.tagName=="INPUT"){
this.applyStaticValue(e.rowIndex);
}
}});
Bool.markupFactory=function(node,cell){
_1c0.markupFactory(node,cell);
};
return _182;
});
},"url:dojox/grid/resources/View.html":"<div class=\"dojoxGridView\" role=\"presentation\">\n\t<div class=\"dojoxGridHeader\" dojoAttachPoint=\"headerNode\" role=\"presentation\">\n\t\t<div dojoAttachPoint=\"headerNodeContainer\" style=\"width:9000em\" role=\"presentation\">\n\t\t\t<div dojoAttachPoint=\"headerContentNode\" role=\"row\"></div>\n\t\t</div>\n\t</div>\n\t<input type=\"checkbox\" class=\"dojoxGridHiddenFocus\" dojoAttachPoint=\"hiddenFocusNode\" role=\"presentation\" />\n\t<input type=\"checkbox\" class=\"dojoxGridHiddenFocus\" role=\"presentation\" />\n\t<div class=\"dojoxGridScrollbox\" dojoAttachPoint=\"scrollboxNode\" role=\"presentation\">\n\t\t<div class=\"dojoxGridContent\" dojoAttachPoint=\"contentNode\" hidefocus=\"hidefocus\" role=\"presentation\"></div>\n\t</div>\n</div>\n","dojo/Stateful":function(){
define(["./_base/declare","./_base/lang","./_base/array","dojo/when"],function(_1c6,lang,_1c7,when){
return _1c6("dojo.Stateful",null,{_attrPairNames:{},_getAttrNames:function(name){
var apn=this._attrPairNames;
if(apn[name]){
return apn[name];
}
return (apn[name]={s:"_"+name+"Setter",g:"_"+name+"Getter"});
},postscript:function(_1c8){
if(_1c8){
this.set(_1c8);
}
},_get:function(name,_1c9){
return typeof this[_1c9.g]==="function"?this[_1c9.g]():this[name];
},get:function(name){
return this._get(name,this._getAttrNames(name));
},set:function(name,_1ca){
if(typeof name==="object"){
for(var x in name){
if(name.hasOwnProperty(x)&&x!="_watchCallbacks"){
this.set(x,name[x]);
}
}
return this;
}
var _1cb=this._getAttrNames(name),_1cc=this._get(name,_1cb),_1cd=this[_1cb.s],_1ce;
if(typeof _1cd==="function"){
_1ce=_1cd.apply(this,Array.prototype.slice.call(arguments,1));
}else{
this[name]=_1ca;
}
if(this._watchCallbacks){
var self=this;
when(_1ce,function(){
self._watchCallbacks(name,_1cc,_1ca);
});
}
return this;
},_changeAttrValue:function(name,_1cf){
var _1d0=this.get(name);
this[name]=_1cf;
if(this._watchCallbacks){
this._watchCallbacks(name,_1d0,_1cf);
}
return this;
},watch:function(name,_1d1){
var _1d2=this._watchCallbacks;
if(!_1d2){
var self=this;
_1d2=this._watchCallbacks=function(name,_1d3,_1d4,_1d5){
var _1d6=function(_1d7){
if(_1d7){
_1d7=_1d7.slice();
for(var i=0,l=_1d7.length;i<l;i++){
_1d7[i].call(self,name,_1d3,_1d4);
}
}
};
_1d6(_1d2["_"+name]);
if(!_1d5){
_1d6(_1d2["*"]);
}
};
}
if(!_1d1&&typeof name==="function"){
_1d1=name;
name="*";
}else{
name="_"+name;
}
var _1d8=_1d2[name];
if(typeof _1d8!=="object"){
_1d8=_1d2[name]=[];
}
_1d8.push(_1d1);
var _1d9={};
_1d9.unwatch=_1d9.remove=function(){
var _1da=_1c7.indexOf(_1d8,_1d1);
if(_1da>-1){
_1d8.splice(_1da,1);
}
};
return _1d9;
}});
});
},"dijit/_CssStateMixin":function(){
define(["dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/dom-class","dojo/has","dojo/_base/lang","dojo/on","dojo/ready","dojo/_base/window","./registry"],function(_1db,_1dc,dom,_1dd,has,lang,on,_1de,win,_1df){
var _1e0=_1dc("dijit._CssStateMixin",[],{cssStateNodes:{},hovering:false,active:false,_applyAttributes:function(){
this.inherited(arguments);
_1db.forEach(["disabled","readOnly","checked","selected","focused","state","hovering","active","_opened"],function(attr){
this.watch(attr,lang.hitch(this,"_setStateClass"));
},this);
for(var ap in this.cssStateNodes){
this._trackMouseState(this[ap],this.cssStateNodes[ap]);
}
this._trackMouseState(this.domNode,this.baseClass);
this._setStateClass();
},_cssMouseEvent:function(_1e1){
if(!this.disabled){
switch(_1e1.type){
case "mouseover":
this._set("hovering",true);
this._set("active",this._mouseDown);
break;
case "mouseout":
this._set("hovering",false);
this._set("active",false);
break;
case "mousedown":
case "touchstart":
this._set("active",true);
break;
case "mouseup":
case "touchend":
this._set("active",false);
break;
}
}
},_setStateClass:function(){
var _1e2=this.baseClass.split(" ");
function _1e3(_1e4){
_1e2=_1e2.concat(_1db.map(_1e2,function(c){
return c+_1e4;
}),"dijit"+_1e4);
};
if(!this.isLeftToRight()){
_1e3("Rtl");
}
var _1e5=this.checked=="mixed"?"Mixed":(this.checked?"Checked":"");
if(this.checked){
_1e3(_1e5);
}
if(this.state){
_1e3(this.state);
}
if(this.selected){
_1e3("Selected");
}
if(this._opened){
_1e3("Opened");
}
if(this.disabled){
_1e3("Disabled");
}else{
if(this.readOnly){
_1e3("ReadOnly");
}else{
if(this.active){
_1e3("Active");
}else{
if(this.hovering){
_1e3("Hover");
}
}
}
}
if(this.focused){
_1e3("Focused");
}
var tn=this.stateNode||this.domNode,_1e6={};
_1db.forEach(tn.className.split(" "),function(c){
_1e6[c]=true;
});
if("_stateClasses" in this){
_1db.forEach(this._stateClasses,function(c){
delete _1e6[c];
});
}
_1db.forEach(_1e2,function(c){
_1e6[c]=true;
});
var _1e7=[];
for(var c in _1e6){
_1e7.push(c);
}
tn.className=_1e7.join(" ");
this._stateClasses=_1e2;
},_subnodeCssMouseEvent:function(node,_1e8,evt){
if(this.disabled||this.readOnly){
return;
}
function _1e9(_1ea){
_1dd.toggle(node,_1e8+"Hover",_1ea);
};
function _1eb(_1ec){
_1dd.toggle(node,_1e8+"Active",_1ec);
};
function _1ed(_1ee){
_1dd.toggle(node,_1e8+"Focused",_1ee);
};
switch(evt.type){
case "mouseover":
_1e9(true);
break;
case "mouseout":
_1e9(false);
_1eb(false);
break;
case "mousedown":
case "touchstart":
_1eb(true);
break;
case "mouseup":
case "touchend":
_1eb(false);
break;
case "focus":
case "focusin":
_1ed(true);
break;
case "blur":
case "focusout":
_1ed(false);
break;
}
},_trackMouseState:function(node,_1ef){
node._cssState=_1ef;
}});
_1de(function(){
function _1f0(evt){
if(!dom.isDescendant(evt.relatedTarget,evt.target)){
for(var node=evt.target;node&&node!=evt.relatedTarget;node=node.parentNode){
if(node._cssState){
var _1f1=_1df.getEnclosingWidget(node);
if(_1f1){
if(node==_1f1.domNode){
_1f1._cssMouseEvent(evt);
}else{
_1f1._subnodeCssMouseEvent(node,node._cssState,evt);
}
}
}
}
}
};
function _1f2(evt){
evt.target=evt.srcElement;
_1f0(evt);
};
var body=win.body(),_1f3=(has("touch")?[]:["mouseover","mouseout"]).concat(["mousedown","touchstart","mouseup","touchend"]);
_1db.forEach(_1f3,function(type){
if(body.addEventListener){
body.addEventListener(type,_1f0,true);
}else{
body.attachEvent("on"+type,_1f2);
}
});
on(body,"focusin, focusout",function(evt){
var node=evt.target;
if(node._cssState&&!node.getAttribute("widgetId")){
var _1f4=_1df.getEnclosingWidget(node);
_1f4._subnodeCssMouseEvent(node,node._cssState,evt);
}
});
});
return _1e0;
});
},"dojo/dnd/Moveable":function(){
define(["../_base/array","../_base/declare","../_base/event","../_base/lang","../dom","../dom-class","../Evented","../on","../topic","../touch","./common","./Mover","../_base/window"],function(_1f5,_1f6,_1f7,lang,dom,_1f8,_1f9,on,_1fa,_1fb,dnd,_1fc,win){
var _1fd=_1f6("dojo.dnd.Moveable",[_1f9],{handle:"",delay:0,skip:false,constructor:function(node,_1fe){
this.node=dom.byId(node);
if(!_1fe){
_1fe={};
}
this.handle=_1fe.handle?dom.byId(_1fe.handle):null;
if(!this.handle){
this.handle=this.node;
}
this.delay=_1fe.delay>0?_1fe.delay:0;
this.skip=_1fe.skip;
this.mover=_1fe.mover?_1fe.mover:_1fc;
this.events=[on(this.handle,_1fb.press,lang.hitch(this,"onMouseDown")),on(this.handle,"dragstart",lang.hitch(this,"onSelectStart")),on(this.handle,"selectstart",lang.hitch(this,"onSelectStart"))];
},markupFactory:function(_1ff,node,Ctor){
return new Ctor(node,_1ff);
},destroy:function(){
_1f5.forEach(this.events,function(_200){
_200.remove();
});
this.events=this.node=this.handle=null;
},onMouseDown:function(e){
if(this.skip&&dnd.isFormElement(e)){
return;
}
if(this.delay){
this.events.push(on(this.handle,_1fb.move,lang.hitch(this,"onMouseMove")),on(this.handle,_1fb.release,lang.hitch(this,"onMouseUp")));
this._lastX=e.pageX;
this._lastY=e.pageY;
}else{
this.onDragDetected(e);
}
_1f7.stop(e);
},onMouseMove:function(e){
if(Math.abs(e.pageX-this._lastX)>this.delay||Math.abs(e.pageY-this._lastY)>this.delay){
this.onMouseUp(e);
this.onDragDetected(e);
}
_1f7.stop(e);
},onMouseUp:function(e){
for(var i=0;i<2;++i){
this.events.pop().remove();
}
_1f7.stop(e);
},onSelectStart:function(e){
if(!this.skip||!dnd.isFormElement(e)){
_1f7.stop(e);
}
},onDragDetected:function(e){
new this.mover(this.node,e,this);
},onMoveStart:function(_201){
_1fa.publish("/dnd/move/start",_201);
_1f8.add(win.body(),"dojoMove");
_1f8.add(this.node,"dojoMoveItem");
},onMoveStop:function(_202){
_1fa.publish("/dnd/move/stop",_202);
_1f8.remove(win.body(),"dojoMove");
_1f8.remove(this.node,"dojoMoveItem");
},onFirstMove:function(){
},onMove:function(_203,_204){
this.onMoving(_203,_204);
var s=_203.node.style;
s.left=_204.l+"px";
s.top=_204.t+"px";
this.onMoved(_203,_204);
},onMoving:function(){
},onMoved:function(){
}});
return _1fd;
});
},"dojox/grid/Selection":function(){
define(["dojo/_base/declare","dojo/_base/array","dojo/_base/lang","dojo/dom-attr"],function(_205,_206,lang,_207){
return _205("dojox.grid.Selection",null,{constructor:function(_208){
this.grid=_208;
this.selected=[];
this.setMode(_208.selectionMode);
},mode:"extended",selected:null,updating:0,selectedIndex:-1,rangeStartIndex:-1,setMode:function(mode){
if(this.selected.length){
this.deselectAll();
}
if(mode!="extended"&&mode!="multiple"&&mode!="single"&&mode!="none"){
this.mode="extended";
}else{
this.mode=mode;
}
},onCanSelect:function(_209){
return this.grid.onCanSelect(_209);
},onCanDeselect:function(_20a){
return this.grid.onCanDeselect(_20a);
},onSelected:function(_20b){
},onDeselected:function(_20c){
},onChanging:function(){
},onChanged:function(){
},isSelected:function(_20d){
if(this.mode=="none"){
return false;
}
return this.selected[_20d];
},getFirstSelected:function(){
if(!this.selected.length||this.mode=="none"){
return -1;
}
for(var i=0,l=this.selected.length;i<l;i++){
if(this.selected[i]){
return i;
}
}
return -1;
},getNextSelected:function(_20e){
if(this.mode=="none"){
return -1;
}
for(var i=_20e+1,l=this.selected.length;i<l;i++){
if(this.selected[i]){
return i;
}
}
return -1;
},getSelected:function(){
var _20f=[];
for(var i=0,l=this.selected.length;i<l;i++){
if(this.selected[i]){
_20f.push(i);
}
}
return _20f;
},getSelectedCount:function(){
var c=0;
for(var i=0;i<this.selected.length;i++){
if(this.selected[i]){
c++;
}
}
return c;
},_beginUpdate:function(){
if(this.updating===0){
this.onChanging();
}
this.updating++;
},_endUpdate:function(){
this.updating--;
if(this.updating===0){
this.onChanged();
}
},select:function(_210){
if(this.mode=="none"){
return;
}
if(this.mode!="multiple"){
this.deselectAll(_210);
this.addToSelection(_210);
}else{
this.toggleSelect(_210);
}
},addToSelection:function(_211){
if(this.mode=="none"){
return;
}
if(lang.isArray(_211)){
_206.forEach(_211,this.addToSelection,this);
return;
}
_211=Number(_211);
if(this.selected[_211]){
this.selectedIndex=_211;
}else{
if(this.onCanSelect(_211)!==false){
this.selectedIndex=_211;
var _212=this.grid.getRowNode(_211);
if(_212){
_207.set(_212,"aria-selected","true");
}
this._beginUpdate();
this.selected[_211]=true;
this.onSelected(_211);
this._endUpdate();
}
}
},deselect:function(_213){
if(this.mode=="none"){
return;
}
if(lang.isArray(_213)){
_206.forEach(_213,this.deselect,this);
return;
}
_213=Number(_213);
if(this.selectedIndex==_213){
this.selectedIndex=-1;
}
if(this.selected[_213]){
if(this.onCanDeselect(_213)===false){
return;
}
var _214=this.grid.getRowNode(_213);
if(_214){
_207.set(_214,"aria-selected","false");
}
this._beginUpdate();
delete this.selected[_213];
this.onDeselected(_213);
this._endUpdate();
}
},setSelected:function(_215,_216){
this[(_216?"addToSelection":"deselect")](_215);
},toggleSelect:function(_217){
if(lang.isArray(_217)){
_206.forEach(_217,this.toggleSelect,this);
return;
}
this.setSelected(_217,!this.selected[_217]);
},_range:function(_218,inTo,func){
var s=(_218>=0?_218:inTo),e=inTo;
if(s>e){
e=s;
s=inTo;
}
for(var i=s;i<=e;i++){
func(i);
}
},selectRange:function(_219,inTo){
this._range(_219,inTo,lang.hitch(this,"addToSelection"));
},deselectRange:function(_21a,inTo){
this._range(_21a,inTo,lang.hitch(this,"deselect"));
},insert:function(_21b){
this.selected.splice(_21b,0,false);
if(this.selectedIndex>=_21b){
this.selectedIndex++;
}
},remove:function(_21c){
this.selected.splice(_21c,1);
if(this.selectedIndex>=_21c){
this.selectedIndex--;
}
},deselectAll:function(_21d){
for(var i in this.selected){
if((i!=_21d)&&(this.selected[i]===true)){
this.deselect(i);
}
}
},clickSelect:function(_21e,_21f,_220){
if(this.mode=="none"){
return;
}
this._beginUpdate();
if(this.mode!="extended"){
this.select(_21e);
}else{
if(!_220||this.rangeStartIndex<0){
this.rangeStartIndex=_21e;
}
if(!_21f){
this.deselectAll(_21e);
}
if(_220){
this.selectRange(this.rangeStartIndex,_21e);
}else{
if(_21f){
this.toggleSelect(_21e);
}else{
this.addToSelection(_21e);
}
}
}
this._endUpdate();
},clickSelectEvent:function(e){
this.clickSelect(e.rowIndex,dojo.isCopyKey(e),e.shiftKey);
},clear:function(){
this._beginUpdate();
this.deselectAll();
this._endUpdate();
}});
});
},"dojox/grid/_Grid":function(){
require({cache:{"url:dojox/grid/resources/_Grid.html":"<div hidefocus=\"hidefocus\" role=\"grid\" dojoAttachEvent=\"onmouseout:_mouseOut\">\n\t<div class=\"dojoxGridMasterHeader\" dojoAttachPoint=\"viewsHeaderNode\" role=\"presentation\"></div>\n\t<div class=\"dojoxGridMasterView\" dojoAttachPoint=\"viewsNode\" role=\"presentation\"></div>\n\t<div class=\"dojoxGridMasterMessages\" style=\"display: none;\" dojoAttachPoint=\"messagesNode\"></div>\n\t<span dojoAttachPoint=\"lastFocusNode\" tabindex=\"0\"></span>\n</div>\n"}});
define("dojox/grid/_Grid",["dojo/_base/kernel","../main","dojo/_base/declare","./_Events","./_Scroller","./_Layout","./_View","./_ViewManager","./_RowManager","./_FocusManager","./_EditManager","./Selection","./_RowSelector","./util","dijit/_Widget","dijit/_TemplatedMixin","dijit/CheckedMenuItem","dojo/text!./resources/_Grid.html","dojo/string","dojo/_base/array","dojo/_base/lang","dojo/_base/sniff","dojox/html/metrics","dojo/_base/html","dojo/query","dojo/dnd/common","dojo/i18n!dijit/nls/loading"],function(dojo,_221,_222,_223,_224,_225,_226,_227,_228,_229,_22a,_22b,_22c,util,_22d,_22e,_22f,_230,_231,_232,lang,has,_233,html,_234){
if(!dojo.isCopyKey){
dojo.isCopyKey=dojo.dnd.getCopyKeyState;
}
var _235=_222("dojox.grid._Grid",[_22d,_22e,_223],{templateString:_230,classTag:"dojoxGrid",rowCount:5,keepRows:75,rowsPerPage:25,autoWidth:false,initialWidth:"",autoHeight:"",rowHeight:0,autoRender:true,defaultHeight:"15em",height:"",structure:null,elasticView:-1,singleClickEdit:false,selectionMode:"extended",rowSelector:"",columnReordering:false,headerMenu:null,placeholderLabel:"GridColumns",selectable:false,_click:null,loadingMessage:"<span class='dojoxGridLoading'>${loadingState}</span>",errorMessage:"<span class='dojoxGridError'>${errorState}</span>",noDataMessage:"",escapeHTMLInData:true,formatterScope:null,editable:false,summary:"",_setSummaryAttr:"domNode",sortInfo:0,_placeholders:null,_layoutClass:_225,buildRendering:function(){
this.inherited(arguments);
if(!this.domNode.getAttribute("tabIndex")){
this.domNode.tabIndex="0";
}
this.createScroller();
this.createLayout();
this.createViews();
this.createManagers();
this.createSelection();
this.connect(this.selection,"onSelected","onSelected");
this.connect(this.selection,"onDeselected","onDeselected");
this.connect(this.selection,"onChanged","onSelectionChanged");
_233.initOnFontResize();
this.connect(_233,"onFontResize","textSizeChanged");
util.funnelEvents(this.domNode,this,"doKeyEvent",util.keyEvents);
if(this.selectionMode!="none"){
this.domNode.setAttribute("aria-multiselectable",this.selectionMode=="single"?"false":"true");
}
html.addClass(this.domNode,this.classTag);
if(!this.isLeftToRight()){
html.addClass(this.domNode,this.classTag+"Rtl");
}
if(this.rowHeight>0){
html.addClass(this.viewsNode,this.classTag+"FixedRowHeight");
}
},postMixInProperties:function(){
this.inherited(arguments);
var _236=dojo.i18n.getLocalization("dijit","loading",this.lang);
this.loadingMessage=_231.substitute(this.loadingMessage,_236);
this.errorMessage=_231.substitute(this.errorMessage,_236);
if(this.srcNodeRef&&this.srcNodeRef.style.height){
this.height=this.srcNodeRef.style.height;
}
this._setAutoHeightAttr(this.autoHeight,true);
this.lastScrollTop=this.scrollTop=0;
},postCreate:function(){
this._placeholders=[];
this._setHeaderMenuAttr(this.headerMenu);
this._setStructureAttr(this.structure);
this._click=[];
this.inherited(arguments);
if(this.domNode&&this.autoWidth&&this.initialWidth){
this.domNode.style.width=this.initialWidth;
}
if(this.domNode&&!this.editable){
html.attr(this.domNode,"aria-readonly","true");
}
},destroy:function(){
this.domNode.onReveal=null;
this.domNode.onSizeChange=null;
delete this._click;
if(this.scroller){
this.scroller.destroy();
delete this.scroller;
}
this.edit.destroy();
delete this.edit;
this.views.destroyViews();
if(this.focus){
this.focus.destroy();
delete this.focus;
}
if(this.headerMenu&&this._placeholders.length){
_232.forEach(this._placeholders,function(p){
p.unReplace(true);
});
this.headerMenu.unBindDomNode(this.viewsHeaderNode);
}
this.inherited(arguments);
},_setAutoHeightAttr:function(ah,_237){
if(typeof ah=="string"){
if(!ah||ah=="false"){
ah=false;
}else{
if(ah=="true"){
ah=true;
}else{
ah=window.parseInt(ah,10);
}
}
}
if(typeof ah=="number"){
if(isNaN(ah)){
ah=false;
}
if(ah<0){
ah=true;
}else{
if(ah===0){
ah=false;
}
}
}
this.autoHeight=ah;
if(typeof ah=="boolean"){
this._autoHeight=ah;
}else{
if(typeof ah=="number"){
this._autoHeight=(ah>=this.get("rowCount"));
}else{
this._autoHeight=false;
}
}
if(this._started&&!_237){
this.render();
}
},_getRowCountAttr:function(){
return this.updating&&this.invalidated&&this.invalidated.rowCount!=undefined?this.invalidated.rowCount:this.rowCount;
},textSizeChanged:function(){
this.render();
},sizeChange:function(){
this.update();
},createManagers:function(){
this.rows=new _228(this);
this.focus=new _229(this);
this.edit=new _22a(this);
},createSelection:function(){
this.selection=new _22b(this);
},createScroller:function(){
this.scroller=new _224();
this.scroller.grid=this;
this.scroller.renderRow=lang.hitch(this,"renderRow");
this.scroller.removeRow=lang.hitch(this,"rowRemoved");
},createLayout:function(){
this.layout=new this._layoutClass(this);
this.connect(this.layout,"moveColumn","onMoveColumn");
},onMoveColumn:function(){
this.update();
},onResizeColumn:function(_238){
},createViews:function(){
this.views=new _227(this);
this.views.createView=lang.hitch(this,"createView");
},createView:function(_239,idx){
var c=lang.getObject(_239);
var view=new c({grid:this,index:idx});
this.viewsNode.appendChild(view.domNode);
this.viewsHeaderNode.appendChild(view.headerNode);
this.views.addView(view);
html.attr(this.domNode,"align",this.isLeftToRight()?"left":"right");
return view;
},buildViews:function(){
for(var i=0,vs;(vs=this.layout.structure[i]);i++){
this.createView(vs.type||_221._scopeName+".grid._View",i).setStructure(vs);
}
this.scroller.setContentNodes(this.views.getContentNodes());
},_setStructureAttr:function(_23a){
var s=_23a;
if(s&&lang.isString(s)){
dojo.deprecated("dojox.grid._Grid.set('structure', 'objVar')","use dojox.grid._Grid.set('structure', objVar) instead","2.0");
s=lang.getObject(s);
}
this.structure=s;
if(!s){
if(this.layout.structure){
s=this.layout.structure;
}else{
return;
}
}
this.views.destroyViews();
this.focus.focusView=null;
if(s!==this.layout.structure){
this.layout.setStructure(s);
}
this._structureChanged();
},setStructure:function(_23b){
dojo.deprecated("dojox.grid._Grid.setStructure(obj)","use dojox.grid._Grid.set('structure', obj) instead.","2.0");
this._setStructureAttr(_23b);
},getColumnTogglingItems:function(){
var _23c,_23d=[];
_23c=_232.map(this.layout.cells,function(cell){
if(!cell.menuItems){
cell.menuItems=[];
}
var self=this;
var item=new _22f({label:cell.name,checked:!cell.hidden,_gridCell:cell,onChange:function(_23e){
if(self.layout.setColumnVisibility(this._gridCell.index,_23e)){
var _23f=this._gridCell.menuItems;
if(_23f.length>1){
_232.forEach(_23f,function(item){
if(item!==this){
item.setAttribute("checked",_23e);
}
},this);
}
_23e=_232.filter(self.layout.cells,function(c){
if(c.menuItems.length>1){
_232.forEach(c.menuItems,"item.set('disabled', false);");
}else{
c.menuItems[0].set("disabled",false);
}
return !c.hidden;
});
if(_23e.length==1){
_232.forEach(_23e[0].menuItems,"item.set('disabled', true);");
}
}
},destroy:function(){
var _240=_232.indexOf(this._gridCell.menuItems,this);
this._gridCell.menuItems.splice(_240,1);
delete this._gridCell;
_22f.prototype.destroy.apply(this,arguments);
}});
cell.menuItems.push(item);
if(!cell.hidden){
_23d.push(item);
}
return item;
},this);
if(_23d.length==1){
_23d[0].set("disabled",true);
}
return _23c;
},_setHeaderMenuAttr:function(menu){
if(this._placeholders&&this._placeholders.length){
_232.forEach(this._placeholders,function(p){
p.unReplace(true);
});
this._placeholders=[];
}
if(this.headerMenu){
this.headerMenu.unBindDomNode(this.viewsHeaderNode);
}
this.headerMenu=menu;
if(!menu){
return;
}
this.headerMenu.bindDomNode(this.viewsHeaderNode);
if(this.headerMenu.getPlaceholders){
this._placeholders=this.headerMenu.getPlaceholders(this.placeholderLabel);
}
},setHeaderMenu:function(menu){
dojo.deprecated("dojox.grid._Grid.setHeaderMenu(obj)","use dojox.grid._Grid.set('headerMenu', obj) instead.","2.0");
this._setHeaderMenuAttr(menu);
},setupHeaderMenu:function(){
if(this._placeholders&&this._placeholders.length){
_232.forEach(this._placeholders,function(p){
if(p._replaced){
p.unReplace(true);
}
p.replace(this.getColumnTogglingItems());
},this);
}
},_fetch:function(_241){
this.setScrollTop(0);
},getItem:function(_242){
return null;
},showMessage:function(_243){
if(_243){
this.messagesNode.innerHTML=_243;
this.messagesNode.style.display="";
}else{
this.messagesNode.innerHTML="";
this.messagesNode.style.display="none";
}
},_structureChanged:function(){
this.buildViews();
if(this.autoRender&&this._started){
this.render();
}
},hasLayout:function(){
return this.layout.cells.length;
},resize:function(_244,_245){
this._pendingChangeSize=_244;
this._pendingResultSize=_245;
this.sizeChange();
},_getPadBorder:function(){
this._padBorder=this._padBorder||html._getPadBorderExtents(this.domNode);
return this._padBorder;
},_getHeaderHeight:function(){
var vns=this.viewsHeaderNode.style,t=vns.display=="none"?0:this.views.measureHeader();
vns.height=t+"px";
this.views.normalizeHeaderNodeHeight();
return t;
},_resize:function(_246,_247){
_246=_246||this._pendingChangeSize;
_247=_247||this._pendingResultSize;
delete this._pendingChangeSize;
delete this._pendingResultSize;
if(!this.domNode){
return;
}
var pn=this.domNode.parentNode;
if(!pn||pn.nodeType!=1||!this.hasLayout()||pn.style.visibility=="hidden"||pn.style.display=="none"){
return;
}
var _248=this._getPadBorder();
var hh=undefined;
var h;
if(this._autoHeight){
this.domNode.style.height="auto";
}else{
if(typeof this.autoHeight=="number"){
h=hh=this._getHeaderHeight();
h+=(this.scroller.averageRowHeight*this.autoHeight);
this.domNode.style.height=h+"px";
}else{
if(this.domNode.clientHeight<=_248.h){
if(pn==document.body){
this.domNode.style.height=this.defaultHeight;
}else{
if(this.height){
this.domNode.style.height=this.height;
}else{
this.fitTo="parent";
}
}
}
}
}
if(_247){
_246=_247;
}
if(!this._autoHeight&&_246){
html.marginBox(this.domNode,_246);
this.height=this.domNode.style.height;
delete this.fitTo;
}else{
if(this.fitTo=="parent"){
h=this._parentContentBoxHeight=(this._parentContentBoxHeight>0?this._parentContentBoxHeight:html._getContentBox(pn).h);
this.domNode.style.height=Math.max(0,h)+"px";
}
}
var _249=_232.some(this.views.views,function(v){
return v.flexCells;
});
if(!this._autoHeight&&(h||html._getContentBox(this.domNode).h)===0){
this.viewsHeaderNode.style.display="none";
}else{
this.viewsHeaderNode.style.display="block";
if(!_249&&hh===undefined){
hh=this._getHeaderHeight();
}
}
if(_249){
hh=undefined;
}
this.adaptWidth();
this.adaptHeight(hh);
this.postresize();
},adaptWidth:function(){
var _24a=(!this.initialWidth&&this.autoWidth);
var w=_24a?0:this.domNode.clientWidth||(this.domNode.offsetWidth-this._getPadBorder().w),vw=this.views.arrange(1,w);
this.views.onEach("adaptWidth");
if(_24a){
this.domNode.style.width=vw+"px";
}
},adaptHeight:function(_24b){
var t=_24b===undefined?this._getHeaderHeight():_24b;
var h=(this._autoHeight?-1:Math.max(this.domNode.clientHeight-t,0)||0);
this.views.onEach("setSize",[0,h]);
this.views.onEach("adaptHeight");
if(!this._autoHeight){
var _24c=0,_24d=0;
var _24e=_232.filter(this.views.views,function(v){
var has=v.hasHScrollbar();
if(has){
_24c++;
}else{
_24d++;
}
return (!has);
});
if(_24c>0&&_24d>0){
_232.forEach(_24e,function(v){
v.adaptHeight(true);
});
}
}
if(this.autoHeight===true||h!=-1||(typeof this.autoHeight=="number"&&this.autoHeight>=this.get("rowCount"))){
this.scroller.windowHeight=h;
}else{
this.scroller.windowHeight=Math.max(this.domNode.clientHeight-t,0);
}
},startup:function(){
if(this._started){
return;
}
this.inherited(arguments);
if(this.autoRender){
this.render();
}
},render:function(){
if(!this.domNode){
return;
}
if(!this._started){
return;
}
if(!this.hasLayout()){
this.scroller.init(0,this.keepRows,this.rowsPerPage);
return;
}
this.update=this.defaultUpdate;
this._render();
},_render:function(){
this.scroller.init(this.get("rowCount"),this.keepRows,this.rowsPerPage);
this.prerender();
this.setScrollTop(0);
this.postrender();
},prerender:function(){
this.keepRows=this._autoHeight?0:this.keepRows;
this.scroller.setKeepInfo(this.keepRows);
this.views.render();
this._resize();
},postrender:function(){
this.postresize();
this.focus.initFocusView();
html.setSelectable(this.domNode,this.selectable);
},postresize:function(){
if(this._autoHeight){
var size=Math.max(this.views.measureContent())+"px";
this.viewsNode.style.height=size;
}
},renderRow:function(_24f,_250){
this.views.renderRow(_24f,_250,this._skipRowRenormalize);
},rowRemoved:function(_251){
this.views.rowRemoved(_251);
},invalidated:null,updating:false,beginUpdate:function(){
this.invalidated=[];
this.updating=true;
},endUpdate:function(){
this.updating=false;
var i=this.invalidated,r;
if(i.all){
this.update();
}else{
if(i.rowCount!=undefined){
this.updateRowCount(i.rowCount);
}else{
for(r in i){
this.updateRow(Number(r));
}
}
}
this.invalidated=[];
},defaultUpdate:function(){
if(!this.domNode){
return;
}
if(this.updating){
this.invalidated.all=true;
return;
}
this.lastScrollTop=this.scrollTop;
this.prerender();
this.scroller.invalidateNodes();
this.setScrollTop(this.lastScrollTop);
this.postrender();
},update:function(){
this.render();
},updateRow:function(_252){
_252=Number(_252);
if(this.updating){
this.invalidated[_252]=true;
}else{
this.views.updateRow(_252);
this.scroller.rowHeightChanged(_252);
}
},updateRows:function(_253,_254){
_253=Number(_253);
_254=Number(_254);
var i;
if(this.updating){
for(i=0;i<_254;i++){
this.invalidated[i+_253]=true;
}
}else{
for(i=0;i<_254;i++){
this.views.updateRow(i+_253,this._skipRowRenormalize);
}
this.scroller.rowHeightChanged(_253);
}
},updateRowCount:function(_255){
if(this.updating){
this.invalidated.rowCount=_255;
}else{
this.rowCount=_255;
this._setAutoHeightAttr(this.autoHeight,true);
if(this.layout.cells.length){
this.scroller.updateRowCount(_255);
}
this._resize();
if(this.layout.cells.length){
this.setScrollTop(this.scrollTop);
}
}
},updateRowStyles:function(_256){
this.views.updateRowStyles(_256);
},getRowNode:function(_257){
if(this.focus.focusView&&!(this.focus.focusView instanceof _22c)){
return this.focus.focusView.rowNodes[_257];
}else{
for(var i=0,_258;(_258=this.views.views[i]);i++){
if(!(_258 instanceof _22c)){
return _258.rowNodes[_257];
}
}
}
return null;
},rowHeightChanged:function(_259){
this.views.renormalizeRow(_259);
this.scroller.rowHeightChanged(_259);
},fastScroll:true,delayScroll:false,scrollRedrawThreshold:(has("ie")?100:50),scrollTo:function(_25a){
if(!this.fastScroll){
this.setScrollTop(_25a);
return;
}
var _25b=Math.abs(this.lastScrollTop-_25a);
this.lastScrollTop=_25a;
if(_25b>this.scrollRedrawThreshold||this.delayScroll){
this.delayScroll=true;
this.scrollTop=_25a;
this.views.setScrollTop(_25a);
if(this._pendingScroll){
window.clearTimeout(this._pendingScroll);
}
var _25c=this;
this._pendingScroll=window.setTimeout(function(){
delete _25c._pendingScroll;
_25c.finishScrollJob();
},200);
}else{
this.setScrollTop(_25a);
}
},finishScrollJob:function(){
this.delayScroll=false;
this.setScrollTop(this.scrollTop);
},setScrollTop:function(_25d){
this.scroller.scroll(this.views.setScrollTop(_25d));
},scrollToRow:function(_25e){
this.setScrollTop(this.scroller.findScrollTop(_25e)+1);
},styleRowNode:function(_25f,_260){
if(_260){
this.rows.styleRowNode(_25f,_260);
}
},_mouseOut:function(e){
this.rows.setOverRow(-2);
},getCell:function(_261){
return this.layout.cells[_261];
},setCellWidth:function(_262,_263){
this.getCell(_262).unitWidth=_263;
},getCellName:function(_264){
return "Cell "+_264.index;
},canSort:function(_265){
},sort:function(){
},getSortAsc:function(_266){
_266=_266==undefined?this.sortInfo:_266;
return Boolean(_266>0);
},getSortIndex:function(_267){
_267=_267==undefined?this.sortInfo:_267;
return Math.abs(_267)-1;
},setSortIndex:function(_268,_269){
var si=_268+1;
if(_269!=undefined){
si*=(_269?1:-1);
}else{
if(this.getSortIndex()==_268){
si=-this.sortInfo;
}
}
this.setSortInfo(si);
},setSortInfo:function(_26a){
if(this.canSort(_26a)){
this.sortInfo=_26a;
this.sort();
this.update();
}
},doKeyEvent:function(e){
e.dispatch="do"+e.type;
this.onKeyEvent(e);
},_dispatch:function(m,e){
if(m in this){
return this[m](e);
}
return false;
},dispatchKeyEvent:function(e){
this._dispatch(e.dispatch,e);
},dispatchContentEvent:function(e){
this.edit.dispatchEvent(e)||e.sourceView.dispatchContentEvent(e)||this._dispatch(e.dispatch,e);
},dispatchHeaderEvent:function(e){
e.sourceView.dispatchHeaderEvent(e)||this._dispatch("doheader"+e.type,e);
},dokeydown:function(e){
this.onKeyDown(e);
},doclick:function(e){
if(e.cellNode){
this.onCellClick(e);
}else{
this.onRowClick(e);
}
},dodblclick:function(e){
if(e.cellNode){
this.onCellDblClick(e);
}else{
this.onRowDblClick(e);
}
},docontextmenu:function(e){
if(e.cellNode){
this.onCellContextMenu(e);
}else{
this.onRowContextMenu(e);
}
},doheaderclick:function(e){
if(e.cellNode){
this.onHeaderCellClick(e);
}else{
this.onHeaderClick(e);
}
},doheaderdblclick:function(e){
if(e.cellNode){
this.onHeaderCellDblClick(e);
}else{
this.onHeaderDblClick(e);
}
},doheadercontextmenu:function(e){
if(e.cellNode){
this.onHeaderCellContextMenu(e);
}else{
this.onHeaderContextMenu(e);
}
},doStartEdit:function(_26b,_26c){
this.onStartEdit(_26b,_26c);
},doApplyCellEdit:function(_26d,_26e,_26f){
this.onApplyCellEdit(_26d,_26e,_26f);
},doCancelEdit:function(_270){
this.onCancelEdit(_270);
},doApplyEdit:function(_271){
this.onApplyEdit(_271);
},addRow:function(){
this.updateRowCount(this.get("rowCount")+1);
},removeSelectedRows:function(){
if(this.allItemsSelected){
this.updateRowCount(0);
}else{
this.updateRowCount(Math.max(0,this.get("rowCount")-this.selection.getSelected().length));
}
this.selection.clear();
}});
_235.markupFactory=function(_272,node,ctor,_273){
var _274=function(n){
var w=html.attr(n,"width")||"auto";
if((w!="auto")&&(w.slice(-2)!="em")&&(w.slice(-1)!="%")){
w=parseInt(w,10)+"px";
}
return w;
};
if(!_272.structure&&node.nodeName.toLowerCase()=="table"){
_272.structure=_234("> colgroup",node).map(function(cg){
var sv=html.attr(cg,"span");
var v={noscroll:(html.attr(cg,"noscroll")=="true")?true:false,__span:(!!sv?parseInt(sv,10):1),cells:[]};
if(html.hasAttr(cg,"width")){
v.width=_274(cg);
}
return v;
});
if(!_272.structure.length){
_272.structure.push({__span:Infinity,cells:[]});
}
_234("thead > tr",node).forEach(function(tr,_275){
var _276=0;
var _277=0;
var _278;
var _279=null;
_234("> th",tr).map(function(th){
if(!_279){
_278=0;
_279=_272.structure[0];
}else{
if(_276>=(_278+_279.__span)){
_277++;
_278+=_279.__span;
var _27a=_279;
_279=_272.structure[_277];
}
}
var cell={name:lang.trim(html.attr(th,"name")||th.innerHTML),colSpan:parseInt(html.attr(th,"colspan")||1,10),type:lang.trim(html.attr(th,"cellType")||""),id:lang.trim(html.attr(th,"id")||"")};
_276+=cell.colSpan;
var _27b=html.attr(th,"rowspan");
if(_27b){
cell.rowSpan=_27b;
}
if(html.hasAttr(th,"width")){
cell.width=_274(th);
}
if(html.hasAttr(th,"relWidth")){
cell.relWidth=window.parseInt(html.attr(th,"relWidth"),10);
}
if(html.hasAttr(th,"hidden")){
cell.hidden=(html.attr(th,"hidden")=="true"||html.attr(th,"hidden")===true);
}
if(_273){
_273(th,cell);
}
cell.type=cell.type?lang.getObject(cell.type):_221.grid.cells.Cell;
if(cell.type&&cell.type.markupFactory){
cell.type.markupFactory(th,cell);
}
if(!_279.cells[_275]){
_279.cells[_275]=[];
}
_279.cells[_275].push(cell);
});
});
}
return new ctor(_272,node);
};
return _235;
});
},"dojo/dnd/Selector":function(){
define(["../_base/array","../_base/declare","../_base/event","../_base/kernel","../_base/lang","../dom","../dom-construct","../mouse","../_base/NodeList","../on","../touch","./common","./Container"],function(_27c,_27d,_27e,_27f,lang,dom,_280,_281,_282,on,_283,dnd,_284){
var _285=_27d("dojo.dnd.Selector",_284,{constructor:function(node,_286){
if(!_286){
_286={};
}
this.singular=_286.singular;
this.autoSync=_286.autoSync;
this.selection={};
this.anchor=null;
this.simpleSelection=false;
this.events.push(on(this.node,_283.press,lang.hitch(this,"onMouseDown")),on(this.node,_283.release,lang.hitch(this,"onMouseUp")));
},singular:false,getSelectedNodes:function(){
var t=new _282();
var e=dnd._empty;
for(var i in this.selection){
if(i in e){
continue;
}
t.push(dom.byId(i));
}
return t;
},selectNone:function(){
return this._removeSelection()._removeAnchor();
},selectAll:function(){
this.forInItems(function(data,id){
this._addItemClass(dom.byId(id),"Selected");
this.selection[id]=1;
},this);
return this._removeAnchor();
},deleteSelectedNodes:function(){
var e=dnd._empty;
for(var i in this.selection){
if(i in e){
continue;
}
var n=dom.byId(i);
this.delItem(i);
_280.destroy(n);
}
this.anchor=null;
this.selection={};
return this;
},forInSelectedItems:function(f,o){
o=o||_27f.global;
var s=this.selection,e=dnd._empty;
for(var i in s){
if(i in e){
continue;
}
f.call(o,this.getItem(i),i,this);
}
},sync:function(){
_285.superclass.sync.call(this);
if(this.anchor){
if(!this.getItem(this.anchor.id)){
this.anchor=null;
}
}
var t=[],e=dnd._empty;
for(var i in this.selection){
if(i in e){
continue;
}
if(!this.getItem(i)){
t.push(i);
}
}
_27c.forEach(t,function(i){
delete this.selection[i];
},this);
return this;
},insertNodes:function(_287,data,_288,_289){
var _28a=this._normalizedCreator;
this._normalizedCreator=function(item,hint){
var t=_28a.call(this,item,hint);
if(_287){
if(!this.anchor){
this.anchor=t.node;
this._removeItemClass(t.node,"Selected");
this._addItemClass(this.anchor,"Anchor");
}else{
if(this.anchor!=t.node){
this._removeItemClass(t.node,"Anchor");
this._addItemClass(t.node,"Selected");
}
}
this.selection[t.node.id]=1;
}else{
this._removeItemClass(t.node,"Selected");
this._removeItemClass(t.node,"Anchor");
}
return t;
};
_285.superclass.insertNodes.call(this,data,_288,_289);
this._normalizedCreator=_28a;
return this;
},destroy:function(){
_285.superclass.destroy.call(this);
this.selection=this.anchor=null;
},onMouseDown:function(e){
if(this.autoSync){
this.sync();
}
if(!this.current){
return;
}
if(!this.singular&&!dnd.getCopyKeyState(e)&&!e.shiftKey&&(this.current.id in this.selection)){
this.simpleSelection=true;
if(_281.isLeft(e)){
_27e.stop(e);
}
return;
}
if(!this.singular&&e.shiftKey){
if(!dnd.getCopyKeyState(e)){
this._removeSelection();
}
var c=this.getAllNodes();
if(c.length){
if(!this.anchor){
this.anchor=c[0];
this._addItemClass(this.anchor,"Anchor");
}
this.selection[this.anchor.id]=1;
if(this.anchor!=this.current){
var i=0,node;
for(;i<c.length;++i){
node=c[i];
if(node==this.anchor||node==this.current){
break;
}
}
for(++i;i<c.length;++i){
node=c[i];
if(node==this.anchor||node==this.current){
break;
}
this._addItemClass(node,"Selected");
this.selection[node.id]=1;
}
this._addItemClass(this.current,"Selected");
this.selection[this.current.id]=1;
}
}
}else{
if(this.singular){
if(this.anchor==this.current){
if(dnd.getCopyKeyState(e)){
this.selectNone();
}
}else{
this.selectNone();
this.anchor=this.current;
this._addItemClass(this.anchor,"Anchor");
this.selection[this.current.id]=1;
}
}else{
if(dnd.getCopyKeyState(e)){
if(this.anchor==this.current){
delete this.selection[this.anchor.id];
this._removeAnchor();
}else{
if(this.current.id in this.selection){
this._removeItemClass(this.current,"Selected");
delete this.selection[this.current.id];
}else{
if(this.anchor){
this._removeItemClass(this.anchor,"Anchor");
this._addItemClass(this.anchor,"Selected");
}
this.anchor=this.current;
this._addItemClass(this.current,"Anchor");
this.selection[this.current.id]=1;
}
}
}else{
if(!(this.current.id in this.selection)){
this.selectNone();
this.anchor=this.current;
this._addItemClass(this.current,"Anchor");
this.selection[this.current.id]=1;
}
}
}
}
_27e.stop(e);
},onMouseUp:function(){
if(!this.simpleSelection){
return;
}
this.simpleSelection=false;
this.selectNone();
if(this.current){
this.anchor=this.current;
this._addItemClass(this.anchor,"Anchor");
this.selection[this.current.id]=1;
}
},onMouseMove:function(){
this.simpleSelection=false;
},onOverEvent:function(){
this.onmousemoveEvent=on(this.node,_283.move,lang.hitch(this,"onMouseMove"));
},onOutEvent:function(){
if(this.onmousemoveEvent){
this.onmousemoveEvent.remove();
delete this.onmousemoveEvent;
}
},_removeSelection:function(){
var e=dnd._empty;
for(var i in this.selection){
if(i in e){
continue;
}
var node=dom.byId(i);
if(node){
this._removeItemClass(node,"Selected");
}
}
this.selection={};
return this;
},_removeAnchor:function(){
if(this.anchor){
this._removeItemClass(this.anchor,"Anchor");
this.anchor=null;
}
return this;
}});
return _285;
});
},"url:dijit/templates/MenuItem.html":"<tr class=\"dijitReset dijitMenuItem\" data-dojo-attach-point=\"focusNode\" role=\"menuitem\" tabIndex=\"-1\">\n\t<td class=\"dijitReset dijitMenuItemIconCell\" role=\"presentation\">\n\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitIcon dijitMenuItemIcon\" data-dojo-attach-point=\"iconNode\"/>\n\t</td>\n\t<td class=\"dijitReset dijitMenuItemLabel\" colspan=\"2\" data-dojo-attach-point=\"containerNode\"></td>\n\t<td class=\"dijitReset dijitMenuItemAccelKey\" style=\"display: none\" data-dojo-attach-point=\"accelKeyNode\"></td>\n\t<td class=\"dijitReset dijitMenuArrowCell\" role=\"presentation\">\n\t\t<div data-dojo-attach-point=\"arrowWrapper\" style=\"visibility: hidden\">\n\t\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitMenuExpand\"/>\n\t\t\t<span class=\"dijitMenuExpandA11y\">+</span>\n\t\t</div>\n\t</td>\n</tr>\n","dojo/text":function(){
define(["./_base/kernel","require","./has","./_base/xhr"],function(dojo,_28b,has,xhr){
var _28c;
if(1){
_28c=function(url,sync,load){
xhr("GET",{url:url,sync:!!sync,load:load,headers:dojo.config.textPluginHeaders||{}});
};
}else{
if(_28b.getText){
_28c=_28b.getText;
}else{
console.error("dojo/text plugin failed to load because loader does not support getText");
}
}
var _28d={},_28e=function(text){
if(text){
text=text.replace(/^\s*<\?xml(\s)+version=[\'\"](\d)*.(\d)*[\'\"](\s)*\?>/im,"");
var _28f=text.match(/<body[^>]*>\s*([\s\S]+)\s*<\/body>/im);
if(_28f){
text=_28f[1];
}
}else{
text="";
}
return text;
},_290={},_291={};
dojo.cache=function(_292,url,_293){
var key;
if(typeof _292=="string"){
if(/\//.test(_292)){
key=_292;
_293=url;
}else{
key=_28b.toUrl(_292.replace(/\./g,"/")+(url?("/"+url):""));
}
}else{
key=_292+"";
_293=url;
}
var val=(_293!=undefined&&typeof _293!="string")?_293.value:_293,_294=_293&&_293.sanitize;
if(typeof val=="string"){
_28d[key]=val;
return _294?_28e(val):val;
}else{
if(val===null){
delete _28d[key];
return null;
}else{
if(!(key in _28d)){
_28c(key,true,function(text){
_28d[key]=text;
});
}
return _294?_28e(_28d[key]):_28d[key];
}
}
};
return {dynamic:true,normalize:function(id,_295){
var _296=id.split("!"),url=_296[0];
return (/^\./.test(url)?_295(url):url)+(_296[1]?"!"+_296[1]:"");
},load:function(id,_297,load){
var _298=id.split("!"),_299=_298.length>1,_29a=_298[0],url=_297.toUrl(_298[0]),_29b="url:"+url,text=_290,_29c=function(text){
load(_299?_28e(text):text);
};
if(_29a in _28d){
text=_28d[_29a];
}else{
if(_29b in _297.cache){
text=_297.cache[_29b];
}else{
if(url in _28d){
text=_28d[url];
}
}
}
if(text===_290){
if(_291[url]){
_291[url].push(_29c);
}else{
var _29d=_291[url]=[_29c];
_28c(url,!_297.async,function(text){
_28d[_29a]=_28d[url]=text;
for(var i=0;i<_29d.length;){
_29d[i++](text);
}
delete _291[url];
});
}
}else{
_29c(text);
}
}};
});
},"dijit/registry":function(){
define(["dojo/_base/array","dojo/sniff","dojo/_base/unload","dojo/_base/window","./main"],function(_29e,has,_29f,win,_2a0){
var _2a1={},hash={};
var _2a2={length:0,add:function(_2a3){
if(hash[_2a3.id]){
throw new Error("Tried to register widget with id=="+_2a3.id+" but that id is already registered");
}
hash[_2a3.id]=_2a3;
this.length++;
},remove:function(id){
if(hash[id]){
delete hash[id];
this.length--;
}
},byId:function(id){
return typeof id=="string"?hash[id]:id;
},byNode:function(node){
return hash[node.getAttribute("widgetId")];
},toArray:function(){
var ar=[];
for(var id in hash){
ar.push(hash[id]);
}
return ar;
},getUniqueId:function(_2a4){
var id;
do{
id=_2a4+"_"+(_2a4 in _2a1?++_2a1[_2a4]:_2a1[_2a4]=0);
}while(hash[id]);
return _2a0._scopeName=="dijit"?id:_2a0._scopeName+"_"+id;
},findWidgets:function(root,_2a5){
var _2a6=[];
function _2a7(root){
for(var node=root.firstChild;node;node=node.nextSibling){
if(node.nodeType==1){
var _2a8=node.getAttribute("widgetId");
if(_2a8){
var _2a9=hash[_2a8];
if(_2a9){
_2a6.push(_2a9);
}
}else{
if(node!==_2a5){
_2a7(node);
}
}
}
}
};
_2a7(root);
return _2a6;
},_destroyAll:function(){
_2a0._curFocus=null;
_2a0._prevFocus=null;
_2a0._activeStack=[];
_29e.forEach(_2a2.findWidgets(win.body()),function(_2aa){
if(!_2aa._destroyed){
if(_2aa.destroyRecursive){
_2aa.destroyRecursive();
}else{
if(_2aa.destroy){
_2aa.destroy();
}
}
}
});
},getEnclosingWidget:function(node){
while(node){
var id=node.nodeType==1&&node.getAttribute("widgetId");
if(id){
return hash[id];
}
node=node.parentNode;
}
return null;
},_hash:hash};
_2a0.registry=_2a2;
return _2a2;
});
},"dojo/uacss":function(){
define(["./dom-geometry","./_base/lang","./ready","./sniff","./_base/window"],function(_2ab,lang,_2ac,has,_2ad){
var html=_2ad.doc.documentElement,ie=has("ie"),_2ae=has("opera"),maj=Math.floor,ff=has("ff"),_2af=_2ab.boxModel.replace(/-/,""),_2b0={"dj_quirks":has("quirks"),"dj_opera":_2ae,"dj_khtml":has("khtml"),"dj_webkit":has("webkit"),"dj_safari":has("safari"),"dj_chrome":has("chrome"),"dj_gecko":has("mozilla")};
if(ie){
_2b0["dj_ie"]=true;
_2b0["dj_ie"+maj(ie)]=true;
_2b0["dj_iequirks"]=has("quirks");
}
if(ff){
_2b0["dj_ff"+maj(ff)]=true;
}
_2b0["dj_"+_2af]=true;
var _2b1="";
for(var clz in _2b0){
if(_2b0[clz]){
_2b1+=clz+" ";
}
}
html.className=lang.trim(html.className+" "+_2b1);
_2ac(90,function(){
if(!_2ab.isBodyLtr()){
var _2b2="dj_rtl dijitRtl "+_2b1.replace(/ /g,"-rtl ");
html.className=lang.trim(html.className+" "+_2b2+"dj_rtl dijitRtl "+_2b1.replace(/ /g,"-rtl "));
}
});
return has;
});
},"dojo/window":function(){
define(["./_base/lang","./sniff","./_base/window","./dom","./dom-geometry","./dom-style"],function(lang,has,_2b3,dom,geom,_2b4){
var _2b5={getBox:function(doc){
doc=doc||_2b3.doc;
var _2b6=(doc.compatMode=="BackCompat")?_2b3.body(doc):doc.documentElement,_2b7=geom.docScroll(doc),w,h;
if(has("touch")){
var _2b8=_2b5.get(doc);
w=_2b8.innerWidth||_2b6.clientWidth;
h=_2b8.innerHeight||_2b6.clientHeight;
}else{
w=_2b6.clientWidth;
h=_2b6.clientHeight;
}
return {l:_2b7.x,t:_2b7.y,w:w,h:h};
},get:function(doc){
if(has("ie")&&_2b5!==document.parentWindow){
doc.parentWindow.execScript("document._parentWindow = window;","Javascript");
var win=doc._parentWindow;
doc._parentWindow=null;
return win;
}
return doc.parentWindow||doc.defaultView;
},scrollIntoView:function(node,pos){
try{
node=dom.byId(node);
var doc=node.ownerDocument||_2b3.doc,body=_2b3.body(doc),html=doc.documentElement||body.parentNode,isIE=has("ie"),isWK=has("webkit");
if((!(has("mozilla")||isIE||isWK||has("opera"))||node==body||node==html)&&(typeof node.scrollIntoView!="undefined")){
node.scrollIntoView(false);
return;
}
var _2b9=doc.compatMode=="BackCompat",_2ba=(isIE>=9&&"frameElement" in node.ownerDocument.parentWindow)?((html.clientHeight>0&&html.clientWidth>0&&(body.clientHeight==0||body.clientWidth==0||body.clientHeight>html.clientHeight||body.clientWidth>html.clientWidth))?html:body):(_2b9?body:html),_2bb=isWK?body:_2ba,_2bc=_2ba.clientWidth,_2bd=_2ba.clientHeight,rtl=!geom.isBodyLtr(doc),_2be=pos||geom.position(node),el=node.parentNode,_2bf=function(el){
return ((isIE<=6||(isIE&&_2b9))?false:(_2b4.get(el,"position").toLowerCase()=="fixed"));
};
if(_2bf(node)){
return;
}
while(el){
if(el==body){
el=_2bb;
}
var _2c0=geom.position(el),_2c1=_2bf(el);
if(el==_2bb){
_2c0.w=_2bc;
_2c0.h=_2bd;
if(_2bb==html&&isIE&&rtl){
_2c0.x+=_2bb.offsetWidth-_2c0.w;
}
if(_2c0.x<0||!isIE){
_2c0.x=0;
}
if(_2c0.y<0||!isIE){
_2c0.y=0;
}
}else{
var pb=geom.getPadBorderExtents(el);
_2c0.w-=pb.w;
_2c0.h-=pb.h;
_2c0.x+=pb.l;
_2c0.y+=pb.t;
var _2c2=el.clientWidth,_2c3=_2c0.w-_2c2;
if(_2c2>0&&_2c3>0){
_2c0.w=_2c2;
_2c0.x+=(rtl&&(isIE||el.clientLeft>pb.l))?_2c3:0;
}
_2c2=el.clientHeight;
_2c3=_2c0.h-_2c2;
if(_2c2>0&&_2c3>0){
_2c0.h=_2c2;
}
}
if(_2c1){
if(_2c0.y<0){
_2c0.h+=_2c0.y;
_2c0.y=0;
}
if(_2c0.x<0){
_2c0.w+=_2c0.x;
_2c0.x=0;
}
if(_2c0.y+_2c0.h>_2bd){
_2c0.h=_2bd-_2c0.y;
}
if(_2c0.x+_2c0.w>_2bc){
_2c0.w=_2bc-_2c0.x;
}
}
var l=_2be.x-_2c0.x,t=_2be.y-Math.max(_2c0.y,0),r=l+_2be.w-_2c0.w,bot=t+_2be.h-_2c0.h;
if(r*l>0){
var s=Math[l<0?"max":"min"](l,r);
if(rtl&&((isIE==8&&!_2b9)||isIE>=9)){
s=-s;
}
_2be.x+=el.scrollLeft;
el.scrollLeft+=s;
_2be.x-=el.scrollLeft;
}
if(bot*t>0){
_2be.y+=el.scrollTop;
el.scrollTop+=Math[t<0?"max":"min"](t,bot);
_2be.y-=el.scrollTop;
}
el=(el!=_2bb)&&!_2c1&&el.parentNode;
}
}
catch(error){
console.error("scrollIntoView: "+error);
node.scrollIntoView(false);
}
}};
1&&lang.setObject("dojo.window",_2b5);
return _2b5;
});
},"dojo/dnd/Mover":function(){
define(["../_base/array","../_base/declare","../_base/event","../_base/lang","../sniff","../_base/window","../dom","../dom-geometry","../dom-style","../Evented","../on","../touch","./common","./autoscroll"],function(_2c4,_2c5,_2c6,lang,has,win,dom,_2c7,_2c8,_2c9,on,_2ca,dnd,_2cb){
return _2c5("dojo.dnd.Mover",[_2c9],{constructor:function(node,e,host){
this.node=dom.byId(node);
this.marginBox={l:e.pageX,t:e.pageY};
this.mouseButton=e.button;
var h=(this.host=host),d=node.ownerDocument;
this.events=[on(d,_2ca.move,lang.hitch(this,"onFirstMove")),on(d,_2ca.move,lang.hitch(this,"onMouseMove")),on(d,_2ca.release,lang.hitch(this,"onMouseUp")),on(d,"dragstart",_2c6.stop),on(d.body,"selectstart",_2c6.stop)];
_2cb.autoScrollStart(d);
if(h&&h.onMoveStart){
h.onMoveStart(this);
}
},onMouseMove:function(e){
_2cb.autoScroll(e);
var m=this.marginBox;
this.host.onMove(this,{l:m.l+e.pageX,t:m.t+e.pageY},e);
_2c6.stop(e);
},onMouseUp:function(e){
if(has("webkit")&&has("mac")&&this.mouseButton==2?e.button==0:this.mouseButton==e.button){
this.destroy();
}
_2c6.stop(e);
},onFirstMove:function(e){
var s=this.node.style,l,t,h=this.host;
switch(s.position){
case "relative":
case "absolute":
l=Math.round(parseFloat(s.left))||0;
t=Math.round(parseFloat(s.top))||0;
break;
default:
s.position="absolute";
var m=_2c7.getMarginBox(this.node);
var b=win.doc.body;
var bs=_2c8.getComputedStyle(b);
var bm=_2c7.getMarginBox(b,bs);
var bc=_2c7.getContentBox(b,bs);
l=m.l-(bc.l-bm.l);
t=m.t-(bc.t-bm.t);
break;
}
this.marginBox.l=l-this.marginBox.l;
this.marginBox.t=t-this.marginBox.t;
if(h&&h.onFirstMove){
h.onFirstMove(this,e);
}
this.events.shift().remove();
},destroy:function(){
_2c4.forEach(this.events,function(_2cc){
_2cc.remove();
});
var h=this.host;
if(h&&h.onMoveStop){
h.onMoveStop(this);
}
this.events=this.node=this.host=null;
}});
});
},"url:dojox/grid/resources/_Grid.html":"<div hidefocus=\"hidefocus\" role=\"grid\" dojoAttachEvent=\"onmouseout:_mouseOut\">\n\t<div class=\"dojoxGridMasterHeader\" dojoAttachPoint=\"viewsHeaderNode\" role=\"presentation\"></div>\n\t<div class=\"dojoxGridMasterView\" dojoAttachPoint=\"viewsNode\" role=\"presentation\"></div>\n\t<div class=\"dojoxGridMasterMessages\" style=\"display: none;\" dojoAttachPoint=\"messagesNode\"></div>\n\t<span dojoAttachPoint=\"lastFocusNode\" tabindex=\"0\"></span>\n</div>\n","dojox/grid/_EditManager":function(){
define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/_base/connect","dojo/_base/sniff","./util"],function(lang,_2cd,_2ce,_2cf,has,util){
return _2ce("dojox.grid._EditManager",null,{constructor:function(_2d0){
this.grid=_2d0;
if(has("ie")){
this.connections=[_2cf.connect(document.body,"onfocus",lang.hitch(this,"_boomerangFocus"))];
}else{
this.connections=[_2cf.connect(this.grid,"onBlur",this,"apply")];
}
},info:{},destroy:function(){
_2cd.forEach(this.connections,_2cf.disconnect);
},cellFocus:function(_2d1,_2d2){
if(this.grid.singleClickEdit||this.isEditRow(_2d2)){
this.setEditCell(_2d1,_2d2);
}else{
this.apply();
}
if(this.isEditing()||(_2d1&&_2d1.editable&&_2d1.alwaysEditing)){
this._focusEditor(_2d1,_2d2);
}
},rowClick:function(e){
if(this.isEditing()&&!this.isEditRow(e.rowIndex)){
this.apply();
}
},styleRow:function(_2d3){
if(_2d3.index==this.info.rowIndex){
_2d3.customClasses+=" dojoxGridRowEditing";
}
},dispatchEvent:function(e){
var c=e.cell,ed=(c&&c["editable"])?c:0;
return ed&&ed.dispatchEvent(e.dispatch,e);
},isEditing:function(){
return this.info.rowIndex!==undefined;
},isEditCell:function(_2d4,_2d5){
return (this.info.rowIndex===_2d4)&&(this.info.cell.index==_2d5);
},isEditRow:function(_2d6){
return this.info.rowIndex===_2d6;
},setEditCell:function(_2d7,_2d8){
if(!this.isEditCell(_2d8,_2d7.index)&&this.grid.canEdit&&this.grid.canEdit(_2d7,_2d8)){
this.start(_2d7,_2d8,this.isEditRow(_2d8)||_2d7.editable);
}
},_focusEditor:function(_2d9,_2da){
util.fire(_2d9,"focus",[_2da]);
},focusEditor:function(){
if(this.isEditing()){
this._focusEditor(this.info.cell,this.info.rowIndex);
}
},_boomerangWindow:500,_shouldCatchBoomerang:function(){
return this._catchBoomerang>new Date().getTime();
},_boomerangFocus:function(){
if(this._shouldCatchBoomerang()){
this.grid.focus.focusGrid();
this.focusEditor();
this._catchBoomerang=0;
}
},_doCatchBoomerang:function(){
if(has("ie")){
this._catchBoomerang=new Date().getTime()+this._boomerangWindow;
}
},start:function(_2db,_2dc,_2dd){
if(!this._isValidInput()){
return;
}
this.grid.beginUpdate();
this.editorApply();
if(this.isEditing()&&!this.isEditRow(_2dc)){
this.applyRowEdit();
this.grid.updateRow(_2dc);
}
if(_2dd){
this.info={cell:_2db,rowIndex:_2dc};
this.grid.doStartEdit(_2db,_2dc);
this.grid.updateRow(_2dc);
}else{
this.info={};
}
this.grid.endUpdate();
this.grid.focus.focusGrid();
this._focusEditor(_2db,_2dc);
this._doCatchBoomerang();
},_editorDo:function(_2de){
var c=this.info.cell;
if(c&&c.editable){
c[_2de](this.info.rowIndex);
}
},editorApply:function(){
this._editorDo("apply");
},editorCancel:function(){
this._editorDo("cancel");
},applyCellEdit:function(_2df,_2e0,_2e1){
if(this.grid.canEdit(_2e0,_2e1)){
this.grid.doApplyCellEdit(_2df,_2e1,_2e0.field);
}
},applyRowEdit:function(){
this.grid.doApplyEdit(this.info.rowIndex,this.info.cell.field);
},apply:function(){
if(this.isEditing()&&this._isValidInput()){
this.grid.beginUpdate();
this.editorApply();
this.applyRowEdit();
this.info={};
this.grid.endUpdate();
this.grid.focus.focusGrid();
this._doCatchBoomerang();
}
},cancel:function(){
if(this.isEditing()){
this.grid.beginUpdate();
this.editorCancel();
this.info={};
this.grid.endUpdate();
this.grid.focus.focusGrid();
this._doCatchBoomerang();
}
},save:function(_2e2,_2e3){
var c=this.info.cell;
if(this.isEditRow(_2e2)&&(!_2e3||c.view==_2e3)&&c.editable){
c.save(c,this.info.rowIndex);
}
},restore:function(_2e4,_2e5){
var c=this.info.cell;
if(this.isEditRow(_2e5)&&c.view==_2e4&&c.editable){
c.restore(this.info.rowIndex);
}
},_isValidInput:function(){
var w=(this.info.cell||{}).widget;
if(!w||!w.isValid){
return true;
}
w.focused=true;
return w.isValid(true);
}});
});
},"dojox/grid/DataSelection":function(){
define("dojox/grid/DataSelection",["dojo/_base/declare","./_SelectionPreserver","./Selection"],function(_2e6,_2e7,_2e8){
return _2e6("dojox.grid.DataSelection",_2e8,{constructor:function(grid){
if(grid.keepSelection){
this.preserver=new _2e7(this);
}
},destroy:function(){
if(this.preserver){
this.preserver.destroy();
}
},getFirstSelected:function(){
var idx=_2e8.prototype.getFirstSelected.call(this);
if(idx==-1){
return null;
}
return this.grid.getItem(idx);
},getNextSelected:function(_2e9){
var _2ea=this.grid.getItemIndex(_2e9);
var idx=_2e8.prototype.getNextSelected.call(this,_2ea);
if(idx==-1){
return null;
}
return this.grid.getItem(idx);
},getSelected:function(){
var _2eb=[];
for(var i=0,l=this.selected.length;i<l;i++){
if(this.selected[i]){
_2eb.push(this.grid.getItem(i));
}
}
return _2eb;
},addToSelection:function(_2ec){
if(this.mode=="none"){
return;
}
var idx=null;
if(typeof _2ec=="number"||typeof _2ec=="string"){
idx=_2ec;
}else{
idx=this.grid.getItemIndex(_2ec);
}
_2e8.prototype.addToSelection.call(this,idx);
},deselect:function(_2ed){
if(this.mode=="none"){
return;
}
var idx=null;
if(typeof _2ed=="number"||typeof _2ed=="string"){
idx=_2ed;
}else{
idx=this.grid.getItemIndex(_2ed);
}
_2e8.prototype.deselect.call(this,idx);
},deselectAll:function(_2ee){
var idx=null;
if(_2ee||typeof _2ee=="number"){
if(typeof _2ee=="number"||typeof _2ee=="string"){
idx=_2ee;
}else{
idx=this.grid.getItemIndex(_2ee);
}
_2e8.prototype.deselectAll.call(this,idx);
}else{
this.inherited(arguments);
}
}});
});
},"dojox/grid/_ViewManager":function(){
define(["dojo/_base/declare","dojo/_base/sniff","dojo/dom-class"],function(_2ef,has,_2f0){
return _2ef("dojox.grid._ViewManager",null,{constructor:function(_2f1){
this.grid=_2f1;
},defaultWidth:200,views:[],resize:function(){
this.onEach("resize");
},render:function(){
this.onEach("render");
},addView:function(_2f2){
_2f2.idx=this.views.length;
this.views.push(_2f2);
},destroyViews:function(){
for(var i=0,v;v=this.views[i];i++){
v.destroy();
}
this.views=[];
},getContentNodes:function(){
var _2f3=[];
for(var i=0,v;v=this.views[i];i++){
_2f3.push(v.contentNode);
}
return _2f3;
},forEach:function(_2f4){
for(var i=0,v;v=this.views[i];i++){
_2f4(v,i);
}
},onEach:function(_2f5,_2f6){
_2f6=_2f6||[];
for(var i=0,v;v=this.views[i];i++){
if(_2f5 in v){
v[_2f5].apply(v,_2f6);
}
}
},normalizeHeaderNodeHeight:function(){
var _2f7=[];
for(var i=0,v;(v=this.views[i]);i++){
if(v.headerContentNode.firstChild){
_2f7.push(v.headerContentNode);
}
}
this.normalizeRowNodeHeights(_2f7);
},normalizeRowNodeHeights:function(_2f8){
var h=0;
var _2f9=[];
if(this.grid.rowHeight){
h=this.grid.rowHeight;
}else{
if(_2f8.length<=1){
return;
}
for(var i=0,n;(n=_2f8[i]);i++){
if(!_2f0.contains(n,"dojoxGridNonNormalizedCell")){
_2f9[i]=n.firstChild.offsetHeight;
h=Math.max(h,_2f9[i]);
}
}
h=(h>=0?h:0);
if((has("mozilla")||has("ie")>8)&&h){
h++;
}
}
for(i=0;(n=_2f8[i]);i++){
if(_2f9[i]!=h){
n.firstChild.style.height=h+"px";
}
}
},resetHeaderNodeHeight:function(){
for(var i=0,v,n;(v=this.views[i]);i++){
n=v.headerContentNode.firstChild;
if(n){
n.style.height="";
}
}
},renormalizeRow:function(_2fa){
var _2fb=[];
for(var i=0,v,n;(v=this.views[i])&&(n=v.getRowNode(_2fa));i++){
n.firstChild.style.height="";
_2fb.push(n);
}
this.normalizeRowNodeHeights(_2fb);
},getViewWidth:function(_2fc){
return this.views[_2fc].getWidth()||this.defaultWidth;
},measureHeader:function(){
this.resetHeaderNodeHeight();
this.forEach(function(_2fd){
_2fd.headerContentNode.style.height="";
});
var h=0;
this.forEach(function(_2fe){
h=Math.max(_2fe.headerNode.offsetHeight,h);
});
return h;
},measureContent:function(){
var h=0;
this.forEach(function(_2ff){
h=Math.max(_2ff.domNode.offsetHeight,h);
});
return h;
},findClient:function(_300){
var c=this.grid.elasticView||-1;
if(c<0){
for(var i=1,v;(v=this.views[i]);i++){
if(v.viewWidth){
for(i=1;(v=this.views[i]);i++){
if(!v.viewWidth){
c=i;
break;
}
}
break;
}
}
}
if(c<0){
c=Math.floor(this.views.length/2);
}
return c;
},arrange:function(l,w){
var i,v,vw,len=this.views.length,self=this;
var c=(w<=0?len:this.findClient());
var _301=function(v,l){
var ds=v.domNode.style;
var hs=v.headerNode.style;
if(!self.grid.isLeftToRight()){
ds.right=l+"px";
if(has("ff")<4){
hs.right=l+v.getScrollbarWidth()+"px";
}else{
hs.right=l+"px";
}
if(!has("webkit")){
hs.width=parseInt(hs.width,10)-v.getScrollbarWidth()+"px";
}
}else{
ds.left=l+"px";
hs.left=l+"px";
}
ds.top=0+"px";
hs.top=0;
};
for(i=0;(v=this.views[i])&&(i<c);i++){
vw=this.getViewWidth(i);
v.setSize(vw,0);
_301(v,l);
if(v.headerContentNode&&v.headerContentNode.firstChild){
vw=v.getColumnsWidth()+v.getScrollbarWidth();
}else{
vw=v.domNode.offsetWidth;
}
l+=vw;
}
i++;
var r=w;
for(var j=len-1;(v=this.views[j])&&(i<=j);j--){
vw=this.getViewWidth(j);
v.setSize(vw,0);
vw=v.domNode.offsetWidth;
r-=vw;
_301(v,r);
}
if(c<len){
v=this.views[c];
vw=Math.max(1,r-l);
v.setSize(vw+"px",0);
_301(v,l);
}
return l;
},renderRow:function(_302,_303,_304){
var _305=[];
for(var i=0,v,n,_306;(v=this.views[i])&&(n=_303[i]);i++){
_306=v.renderRow(_302);
n.appendChild(_306);
_305.push(_306);
}
if(!_304){
this.normalizeRowNodeHeights(_305);
}
},rowRemoved:function(_307){
this.onEach("rowRemoved",[_307]);
},updateRow:function(_308,_309){
for(var i=0,v;v=this.views[i];i++){
v.updateRow(_308);
}
if(!_309){
this.renormalizeRow(_308);
}
},updateRowStyles:function(_30a){
this.onEach("updateRowStyles",[_30a]);
},setScrollTop:function(_30b){
var top=_30b;
for(var i=0,v;v=this.views[i];i++){
top=v.setScrollTop(_30b);
if(has("ie")&&v.headerNode&&v.scrollboxNode){
v.headerNode.scrollLeft=v.scrollboxNode.scrollLeft;
}
}
return top;
},getFirstScrollingView:function(){
for(var i=0,v;(v=this.views[i]);i++){
if(v.hasHScrollbar()||v.hasVScrollbar()){
return v;
}
}
return null;
}});
});
},"dijit/_OnDijitClickMixin":function(){
define(["dojo/on","dojo/_base/array","dojo/keys","dojo/_base/declare","dojo/has","dojo/_base/unload","dojo/_base/window","./a11yclick"],function(on,_30c,keys,_30d,has,_30e,win,_30f){
var ret=_30d("dijit._OnDijitClickMixin",null,{connect:function(obj,_310,_311){
return this.inherited(arguments,[obj,_310=="ondijitclick"?_30f:_310,_311]);
}});
ret.a11yclick=_30f;
return ret;
});
},"dojox/grid/util":function(){
define("dojox/grid/util",["../main","dojo/_base/lang","dojo/dom"],function(_312,lang,dom){
var dgu=lang.getObject("grid.util",true,_312);
dgu.na="...";
dgu.rowIndexTag="gridRowIndex";
dgu.gridViewTag="gridView";
dgu.fire=function(ob,ev,args){
var fn=ob&&ev&&ob[ev];
return fn&&(args?fn.apply(ob,args):ob[ev]());
};
dgu.setStyleHeightPx=function(_313,_314){
if(_314>=0){
var s=_313.style;
var v=_314+"px";
if(_313&&s["height"]!=v){
s["height"]=v;
}
}
};
dgu.mouseEvents=["mouseover","mouseout","mousedown","mouseup","click","dblclick","contextmenu"];
dgu.keyEvents=["keyup","keydown","keypress"];
dgu.funnelEvents=function(_315,_316,_317,_318){
var evts=(_318?_318:dgu.mouseEvents.concat(dgu.keyEvents));
for(var i=0,l=evts.length;i<l;i++){
_316.connect(_315,"on"+evts[i],_317);
}
};
dgu.removeNode=function(_319){
_319=dom.byId(_319);
_319&&_319.parentNode&&_319.parentNode.removeChild(_319);
return _319;
};
dgu.arrayCompare=function(inA,inB){
for(var i=0,l=inA.length;i<l;i++){
if(inA[i]!=inB[i]){
return false;
}
}
return (inA.length==inB.length);
};
dgu.arrayInsert=function(_31a,_31b,_31c){
if(_31a.length<=_31b){
_31a[_31b]=_31c;
}else{
_31a.splice(_31b,0,_31c);
}
};
dgu.arrayRemove=function(_31d,_31e){
_31d.splice(_31e,1);
};
dgu.arraySwap=function(_31f,inI,inJ){
var _320=_31f[inI];
_31f[inI]=_31f[inJ];
_31f[inJ]=_320;
};
return dgu;
});
},"dijit/a11yclick":function(){
define(["dojo/on","dojo/_base/array","dojo/keys","dojo/_base/declare","dojo/has","dojo/_base/unload","dojo/_base/window"],function(on,_321,keys,_322,has,_323,win){
var _324=null;
if(has("dom-addeventlistener")){
win.doc.addEventListener("keydown",function(evt){
_324=evt.target;
},true);
}else{
(function(){
var _325=function(evt){
_324=evt.srcElement;
};
win.doc.attachEvent("onkeydown",_325);
_323.addOnWindowUnload(function(){
win.doc.detachEvent("onkeydown",_325);
});
})();
}
function _326(e){
return (e.keyCode===keys.ENTER||e.keyCode===keys.SPACE)&&!e.ctrlKey&&!e.shiftKey&&!e.altKey&&!e.metaKey;
};
return function(node,_327){
if(/input|button/i.test(node.nodeName)){
return on(node,"click",_327);
}else{
var _328=[on(node,"keydown",function(e){
if(_326(e)){
_324=e.target;
e.preventDefault();
}
}),on(node,"keyup",function(e){
if(_326(e)&&e.target==_324){
_324=null;
on.emit(e.target,"click",{cancelable:true,bubbles:true});
}
}),on(node,"click",function(e){
_327.call(this,e);
})];
if(has("touch")){
var _329;
_328.push(on(node,"touchend",function(e){
var _32a=e.target;
_329=setTimeout(function(){
_329=null;
on.emit(_32a,"click",{cancelable:true,bubbles:true});
},600);
}),on(node,"click",function(e){
if(_329){
clearTimeout(_329);
}
}));
}
return {remove:function(){
_321.forEach(_328,function(h){
h.remove();
});
if(_329){
clearTimeout(_329);
_329=null;
}
}};
}
};
return ret;
});
},"dijit/hccss":function(){
define(["dojo/dom-class","dojo/hccss","dojo/ready","dojo/_base/window"],function(_32b,has,_32c,win){
_32c(90,function(){
if(has("highcontrast")){
_32b.add(win.body(),"dijit_a11y");
}
});
return has;
});
},"dojox/grid/cells":function(){
define("dojox/grid/cells",["../main","./cells/_base"],function(_32d){
return _32d.grid.cells;
});
},"dijit/_TemplatedMixin":function(){
define(["dojo/_base/lang","dojo/touch","./_WidgetBase","dojo/string","dojo/cache","dojo/_base/array","dojo/_base/declare","dojo/dom-construct","dojo/sniff","dojo/_base/unload"],function(lang,_32e,_32f,_330,_331,_332,_333,_334,has,_335){
var _336=_333("dijit._TemplatedMixin",null,{templateString:null,templatePath:null,_skipNodeCache:false,_earlyTemplatedStartup:false,constructor:function(){
this._attachPoints=[];
this._attachEvents=[];
},_stringRepl:function(tmpl){
var _337=this.declaredClass,_338=this;
return _330.substitute(tmpl,this,function(_339,key){
if(key.charAt(0)=="!"){
_339=lang.getObject(key.substr(1),false,_338);
}
if(typeof _339=="undefined"){
throw new Error(_337+" template:"+key);
}
if(_339==null){
return "";
}
return key.charAt(0)=="!"?_339:_339.toString().replace(/"/g,"&quot;");
},this);
},buildRendering:function(){
if(!this.templateString){
this.templateString=_331(this.templatePath,{sanitize:true});
}
var _33a=_336.getCachedTemplate(this.templateString,this._skipNodeCache,this.ownerDocument);
var node;
if(lang.isString(_33a)){
node=_334.toDom(this._stringRepl(_33a),this.ownerDocument);
if(node.nodeType!=1){
throw new Error("Invalid template: "+_33a);
}
}else{
node=_33a.cloneNode(true);
}
this.domNode=node;
this.inherited(arguments);
this._attachTemplateNodes(node,function(n,p){
return n.getAttribute(p);
});
this._beforeFillContent();
this._fillContent(this.srcNodeRef);
},_beforeFillContent:function(){
},_fillContent:function(_33b){
var dest=this.containerNode;
if(_33b&&dest){
while(_33b.hasChildNodes()){
dest.appendChild(_33b.firstChild);
}
}
},_attachTemplateNodes:function(_33c,_33d){
var _33e=lang.isArray(_33c)?_33c:(_33c.all||_33c.getElementsByTagName("*"));
var x=lang.isArray(_33c)?0:-1;
for(;x<0||_33e[x];x++){
var _33f=(x==-1)?_33c:_33e[x];
if(this.widgetsInTemplate&&(_33d(_33f,"dojoType")||_33d(_33f,"data-dojo-type"))){
continue;
}
var _340=_33d(_33f,"dojoAttachPoint")||_33d(_33f,"data-dojo-attach-point");
if(_340){
var _341,_342=_340.split(/\s*,\s*/);
while((_341=_342.shift())){
if(lang.isArray(this[_341])){
this[_341].push(_33f);
}else{
this[_341]=_33f;
}
this._attachPoints.push(_341);
}
}
var _343=_33d(_33f,"dojoAttachEvent")||_33d(_33f,"data-dojo-attach-event");
if(_343){
var _344,_345=_343.split(/\s*,\s*/);
var trim=lang.trim;
while((_344=_345.shift())){
if(_344){
var _346=null;
if(_344.indexOf(":")!=-1){
var _347=_344.split(":");
_344=trim(_347[0]);
_346=trim(_347[1]);
}else{
_344=trim(_344);
}
if(!_346){
_346=_344;
}
this._attachEvents.push(this.connect(_33f,_32e[_344]||_344,_346));
}
}
}
}
},destroyRendering:function(){
_332.forEach(this._attachPoints,function(_348){
delete this[_348];
},this);
this._attachPoints=[];
_332.forEach(this._attachEvents,this.disconnect,this);
this._attachEvents=[];
this.inherited(arguments);
}});
_336._templateCache={};
_336.getCachedTemplate=function(_349,_34a,doc){
var _34b=_336._templateCache;
var key=_349;
var _34c=_34b[key];
if(_34c){
try{
if(!_34c.ownerDocument||_34c.ownerDocument==(doc||document)){
return _34c;
}
}
catch(e){
}
_334.destroy(_34c);
}
_349=_330.trim(_349);
if(_34a||_349.match(/\$\{([^\}]+)\}/g)){
return (_34b[key]=_349);
}else{
var node=_334.toDom(_349,doc);
if(node.nodeType!=1){
throw new Error("Invalid template: "+_349);
}
return (_34b[key]=node);
}
};
if(has("ie")){
_335.addOnWindowUnload(function(){
var _34d=_336._templateCache;
for(var key in _34d){
var _34e=_34d[key];
if(typeof _34e=="object"){
_334.destroy(_34e);
}
delete _34d[key];
}
});
}
lang.extend(_32f,{dojoAttachEvent:"",dojoAttachPoint:""});
return _336;
});
},"dojox/html/metrics":function(){
define("dojox/html/metrics",["dojo/_base/kernel","dojo/_base/lang","dojo/_base/sniff","dojo/ready","dojo/_base/unload","dojo/_base/window","dojo/dom-geometry"],function(_34f,lang,has,_350,_351,_352,_353){
var dhm=lang.getObject("dojox.html.metrics",true);
var _354=lang.getObject("dojox");
dhm.getFontMeasurements=function(){
var _355={"1em":0,"1ex":0,"100%":0,"12pt":0,"16px":0,"xx-small":0,"x-small":0,"small":0,"medium":0,"large":0,"x-large":0,"xx-large":0};
if(has("ie")){
_352.doc.documentElement.style.fontSize="100%";
}
var div=_352.doc.createElement("div");
var ds=div.style;
ds.position="absolute";
ds.left="-100px";
ds.top="0";
ds.width="30px";
ds.height="1000em";
ds.borderWidth="0";
ds.margin="0";
ds.padding="0";
ds.outline="0";
ds.lineHeight="1";
ds.overflow="hidden";
_352.body().appendChild(div);
for(var p in _355){
ds.fontSize=p;
_355[p]=Math.round(div.offsetHeight*12/16)*16/12/1000;
}
_352.body().removeChild(div);
div=null;
return _355;
};
var _356=null;
dhm.getCachedFontMeasurements=function(_357){
if(_357||!_356){
_356=dhm.getFontMeasurements();
}
return _356;
};
var _358=null,_359={};
dhm.getTextBox=function(text,_35a,_35b){
var m,s;
if(!_358){
m=_358=_352.doc.createElement("div");
var c=_352.doc.createElement("div");
c.appendChild(m);
s=c.style;
s.overflow="scroll";
s.position="absolute";
s.left="0px";
s.top="-10000px";
s.width="1px";
s.height="1px";
s.visibility="hidden";
s.borderWidth="0";
s.margin="0";
s.padding="0";
s.outline="0";
_352.body().appendChild(c);
}else{
m=_358;
}
m.className="";
s=m.style;
s.borderWidth="0";
s.margin="0";
s.padding="0";
s.outline="0";
if(arguments.length>1&&_35a){
for(var i in _35a){
if(i in _359){
continue;
}
s[i]=_35a[i];
}
}
if(arguments.length>2&&_35b){
m.className=_35b;
}
m.innerHTML=text;
var box=_353.position(m);
box.w=m.parentNode.scrollWidth;
return box;
};
var _35c={w:16,h:16};
dhm.getScrollbar=function(){
return {w:_35c.w,h:_35c.h};
};
dhm._fontResizeNode=null;
dhm.initOnFontResize=function(_35d){
var f=dhm._fontResizeNode=_352.doc.createElement("iframe");
var fs=f.style;
fs.position="absolute";
fs.width="5em";
fs.height="10em";
fs.top="-10000px";
fs.display="none";
if(has("ie")){
f.onreadystatechange=function(){
if(f.contentWindow.document.readyState=="complete"){
f.onresize=f.contentWindow.parent[_354._scopeName].html.metrics._fontresize;
}
};
}else{
f.onload=function(){
f.contentWindow.onresize=f.contentWindow.parent[_354._scopeName].html.metrics._fontresize;
};
}
f.setAttribute("src","javascript:'<html><head><script>if(\"loadFirebugConsole\" in window){window.loadFirebugConsole();}</script></head><body></body></html>'");
_352.body().appendChild(f);
dhm.initOnFontResize=function(){
};
};
dhm.onFontResize=function(){
};
dhm._fontresize=function(){
dhm.onFontResize();
};
_351.addOnUnload(function(){
var f=dhm._fontResizeNode;
if(f){
if(has("ie")&&f.onresize){
f.onresize=null;
}else{
if(f.contentWindow&&f.contentWindow.onresize){
f.contentWindow.onresize=null;
}
}
dhm._fontResizeNode=null;
}
});
_350(function(){
try{
var n=_352.doc.createElement("div");
n.style.cssText="top:0;left:0;width:100px;height:100px;overflow:scroll;position:absolute;visibility:hidden;";
_352.body().appendChild(n);
_35c.w=n.offsetWidth-n.clientWidth;
_35c.h=n.offsetHeight-n.clientHeight;
_352.body().removeChild(n);
delete n;
}
catch(e){
}
if("fontSizeWatch" in _34f.config&&!!_34f.config.fontSizeWatch){
dhm.initOnFontResize();
}
});
return dhm;
});
},"dojox/grid/_Builder":function(){
define(["../main","dojo/_base/array","dojo/_base/lang","dojo/_base/window","dojo/_base/event","dojo/_base/sniff","dojo/_base/connect","dojo/dnd/Moveable","dojox/html/metrics","./util","dojo/_base/html"],function(_35e,_35f,lang,win,_360,has,_361,_362,_363,util,html){
var dg=_35e.grid;
var _364=function(td){
return td.cellIndex>=0?td.cellIndex:_35f.indexOf(td.parentNode.cells,td);
};
var _365=function(tr){
return tr.rowIndex>=0?tr.rowIndex:_35f.indexOf(tr.parentNode.childNodes,tr);
};
var _366=function(_367,_368){
return _367&&((_367.rows||0)[_368]||_367.childNodes[_368]);
};
var _369=function(node){
for(var n=node;n&&n.tagName!="TABLE";n=n.parentNode){
}
return n;
};
var _36a=function(_36b,_36c){
for(var n=_36b;n&&_36c(n);n=n.parentNode){
}
return n;
};
var _36d=function(_36e){
var name=_36e.toUpperCase();
return function(node){
return node.tagName!=name;
};
};
var _36f=util.rowIndexTag;
var _370=util.gridViewTag;
var _371=dg._Builder=lang.extend(function(view){
if(view){
this.view=view;
this.grid=view.grid;
}
},{view:null,_table:"<table class=\"dojoxGridRowTable\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" role=\"presentation\"",getTableArray:function(){
var html=[this._table];
if(this.view.viewWidth){
html.push([" style=\"width:",this.view.viewWidth,";\""].join(""));
}
html.push(">");
return html;
},generateCellMarkup:function(_372,_373,_374,_375){
var _376=[],html;
if(_375){
var _377=_372.index!=_372.grid.getSortIndex()?"":_372.grid.sortInfo>0?"aria-sort=\"ascending\"":"aria-sort=\"descending\"";
if(!_372.id){
_372.id=this.grid.id+"Hdr"+_372.index;
}
html=["<th tabIndex=\"-1\" aria-readonly=\"true\" role=\"columnheader\"",_377,"id=\"",_372.id,"\""];
}else{
var _378=this.grid.editable&&!_372.editable?"aria-readonly=\"true\"":"";
html=["<td tabIndex=\"-1\" role=\"gridcell\"",_378];
}
if(_372.colSpan){
html.push(" colspan=\"",_372.colSpan,"\"");
}
if(_372.rowSpan){
html.push(" rowspan=\"",_372.rowSpan,"\"");
}
html.push(" class=\"dojoxGridCell ");
if(_372.classes){
html.push(_372.classes," ");
}
if(_374){
html.push(_374," ");
}
_376.push(html.join(""));
_376.push("");
html=["\" idx=\"",_372.index,"\" style=\""];
if(_373&&_373[_373.length-1]!=";"){
_373+=";";
}
html.push(_372.styles,_373||"",_372.hidden?"display:none;":"");
if(_372.unitWidth){
html.push("width:",_372.unitWidth,";");
}
_376.push(html.join(""));
_376.push("");
html=["\""];
if(_372.attrs){
html.push(" ",_372.attrs);
}
html.push(">");
_376.push(html.join(""));
_376.push("");
_376.push(_375?"</th>":"</td>");
return _376;
},isCellNode:function(_379){
return Boolean(_379&&_379!=win.doc&&html.attr(_379,"idx"));
},getCellNodeIndex:function(_37a){
return _37a?Number(html.attr(_37a,"idx")):-1;
},getCellNode:function(_37b,_37c){
for(var i=0,row;((row=_366(_37b.firstChild,i))&&row.cells);i++){
for(var j=0,cell;(cell=row.cells[j]);j++){
if(this.getCellNodeIndex(cell)==_37c){
return cell;
}
}
}
return null;
},findCellTarget:function(_37d,_37e){
var n=_37d;
while(n&&(!this.isCellNode(n)||(n.offsetParent&&_370 in n.offsetParent.parentNode&&n.offsetParent.parentNode[_370]!=this.view.id))&&(n!=_37e)){
n=n.parentNode;
}
return n!=_37e?n:null;
},baseDecorateEvent:function(e){
e.dispatch="do"+e.type;
e.grid=this.grid;
e.sourceView=this.view;
e.cellNode=this.findCellTarget(e.target,e.rowNode);
e.cellIndex=this.getCellNodeIndex(e.cellNode);
e.cell=(e.cellIndex>=0?this.grid.getCell(e.cellIndex):null);
},findTarget:function(_37f,_380){
var n=_37f;
while(n&&(n!=this.domNode)&&(!(_380 in n)||(_370 in n&&n[_370]!=this.view.id))){
n=n.parentNode;
}
return (n!=this.domNode)?n:null;
},findRowTarget:function(_381){
return this.findTarget(_381,_36f);
},isIntraNodeEvent:function(e){
try{
return (e.cellNode&&e.relatedTarget&&html.isDescendant(e.relatedTarget,e.cellNode));
}
catch(x){
return false;
}
},isIntraRowEvent:function(e){
try{
var row=e.relatedTarget&&this.findRowTarget(e.relatedTarget);
return !row&&(e.rowIndex==-1)||row&&(e.rowIndex==row.gridRowIndex);
}
catch(x){
return false;
}
},dispatchEvent:function(e){
if(e.dispatch in this){
return this[e.dispatch](e);
}
return false;
},domouseover:function(e){
if(e.cellNode&&(e.cellNode!=this.lastOverCellNode)){
this.lastOverCellNode=e.cellNode;
this.grid.onMouseOver(e);
}
this.grid.onMouseOverRow(e);
},domouseout:function(e){
if(e.cellNode&&(e.cellNode==this.lastOverCellNode)&&!this.isIntraNodeEvent(e,this.lastOverCellNode)){
this.lastOverCellNode=null;
this.grid.onMouseOut(e);
if(!this.isIntraRowEvent(e)){
this.grid.onMouseOutRow(e);
}
}
},domousedown:function(e){
if(e.cellNode){
this.grid.onMouseDown(e);
}
this.grid.onMouseDownRow(e);
}});
var _382=dg._ContentBuilder=lang.extend(function(view){
_371.call(this,view);
},_371.prototype,{update:function(){
this.prepareHtml();
},prepareHtml:function(){
var _383=this.grid.get,_384=this.view.structure.cells;
for(var j=0,row;(row=_384[j]);j++){
for(var i=0,cell;(cell=row[i]);i++){
cell.get=cell.get||(cell.value==undefined)&&_383;
cell.markup=this.generateCellMarkup(cell,cell.cellStyles,cell.cellClasses,false);
if(!this.grid.editable&&cell.editable){
this.grid.editable=true;
}
}
}
},generateHtml:function(_385,_386){
var html=this.getTableArray(),v=this.view,_387=v.structure.cells,item=this.grid.getItem(_386);
util.fire(this.view,"onBeforeRow",[_386,_387]);
for(var j=0,row;(row=_387[j]);j++){
if(row.hidden||row.header){
continue;
}
html.push(!row.invisible?"<tr>":"<tr class=\"dojoxGridInvisible\">");
for(var i=0,cell,m,cc,cs;(cell=row[i]);i++){
m=cell.markup;
cc=cell.customClasses=[];
cs=cell.customStyles=[];
m[5]=cell.format(_386,item);
m[1]=cc.join(" ");
m[3]=cs.join(";");
html.push.apply(html,m);
}
html.push("</tr>");
}
html.push("</table>");
return html.join("");
},decorateEvent:function(e){
e.rowNode=this.findRowTarget(e.target);
if(!e.rowNode){
return false;
}
e.rowIndex=e.rowNode[_36f];
this.baseDecorateEvent(e);
e.cell=this.grid.getCell(e.cellIndex);
return true;
}});
var _388=dg._HeaderBuilder=lang.extend(function(view){
this.moveable=null;
_371.call(this,view);
},_371.prototype,{_skipBogusClicks:false,overResizeWidth:4,minColWidth:1,update:function(){
if(this.tableMap){
this.tableMap.mapRows(this.view.structure.cells);
}else{
this.tableMap=new dg._TableMap(this.view.structure.cells);
}
},generateHtml:function(_389,_38a){
var html=this.getTableArray(),_38b=this.view.structure.cells;
util.fire(this.view,"onBeforeRow",[-1,_38b]);
for(var j=0,row;(row=_38b[j]);j++){
if(row.hidden){
continue;
}
html.push(!row.invisible?"<tr>":"<tr class=\"dojoxGridInvisible\">");
for(var i=0,cell,_38c;(cell=row[i]);i++){
cell.customClasses=[];
cell.customStyles=[];
if(this.view.simpleStructure){
if(cell.draggable){
if(cell.headerClasses){
if(cell.headerClasses.indexOf("dojoDndItem")==-1){
cell.headerClasses+=" dojoDndItem";
}
}else{
cell.headerClasses="dojoDndItem";
}
}
if(cell.attrs){
if(cell.attrs.indexOf("dndType='gridColumn_")==-1){
cell.attrs+=" dndType='gridColumn_"+this.grid.id+"'";
}
}else{
cell.attrs="dndType='gridColumn_"+this.grid.id+"'";
}
}
_38c=this.generateCellMarkup(cell,cell.headerStyles,cell.headerClasses,true);
_38c[5]=(_38a!=undefined?_38a:_389(cell));
_38c[3]=cell.customStyles.join(";");
_38c[1]=cell.customClasses.join(" ");
html.push(_38c.join(""));
}
html.push("</tr>");
}
html.push("</table>");
return html.join("");
},getCellX:function(e){
var n,x=e.layerX;
if(has("mozilla")||has("ie")>=9){
n=_36a(e.target,_36d("th"));
x-=(n&&n.offsetLeft)||0;
var t=e.sourceView.getScrollbarWidth();
if(!this.grid.isLeftToRight()){
table=_36a(n,_36d("table"));
x-=(table&&table.offsetLeft)||0;
}
}
n=_36a(e.target,function(){
if(!n||n==e.cellNode){
return false;
}
x+=(n.offsetLeft<0?0:n.offsetLeft);
return true;
});
return x;
},decorateEvent:function(e){
this.baseDecorateEvent(e);
e.rowIndex=-1;
e.cellX=this.getCellX(e);
return true;
},prepareResize:function(e,mod){
do{
var i=e.cellIndex;
e.cellNode=(i?e.cellNode.parentNode.cells[i+mod]:null);
e.cellIndex=(e.cellNode?this.getCellNodeIndex(e.cellNode):-1);
}while(e.cellNode&&e.cellNode.style.display=="none");
return Boolean(e.cellNode);
},canResize:function(e){
if(!e.cellNode||e.cellNode.colSpan>1){
return false;
}
var cell=this.grid.getCell(e.cellIndex);
return !cell.noresize&&cell.canResize();
},overLeftResizeArea:function(e){
if(html.hasClass(win.body(),"dojoDndMove")){
return false;
}
if(has("ie")){
var tN=e.target;
if(html.hasClass(tN,"dojoxGridArrowButtonNode")||html.hasClass(tN,"dojoxGridArrowButtonChar")||html.hasClass(tN,"dojoxGridColCaption")){
return false;
}
}
if(this.grid.isLeftToRight()){
return (e.cellIndex>0)&&(e.cellX>0&&e.cellX<this.overResizeWidth)&&this.prepareResize(e,-1);
}
var t=e.cellNode&&(e.cellX>0&&e.cellX<this.overResizeWidth);
return t;
},overRightResizeArea:function(e){
if(html.hasClass(win.body(),"dojoDndMove")){
return false;
}
if(has("ie")){
var tN=e.target;
if(html.hasClass(tN,"dojoxGridArrowButtonNode")||html.hasClass(tN,"dojoxGridArrowButtonChar")||html.hasClass(tN,"dojoxGridColCaption")){
return false;
}
}
if(this.grid.isLeftToRight()){
return e.cellNode&&(e.cellX>=e.cellNode.offsetWidth-this.overResizeWidth);
}
return (e.cellIndex>0)&&(e.cellX>=e.cellNode.offsetWidth-this.overResizeWidth)&&this.prepareResize(e,-1);
},domousemove:function(e){
if(!this.moveable){
var c=(this.overRightResizeArea(e)?"dojoxGridColResize":(this.overLeftResizeArea(e)?"dojoxGridColResize":""));
if(c&&!this.canResize(e)){
c="dojoxGridColNoResize";
}
html.toggleClass(e.sourceView.headerNode,"dojoxGridColNoResize",(c=="dojoxGridColNoResize"));
html.toggleClass(e.sourceView.headerNode,"dojoxGridColResize",(c=="dojoxGridColResize"));
if(c){
_360.stop(e);
}
}
},domousedown:function(e){
if(!this.moveable){
if((this.overRightResizeArea(e)||this.overLeftResizeArea(e))&&this.canResize(e)){
this.beginColumnResize(e);
}else{
this.grid.onMouseDown(e);
this.grid.onMouseOverRow(e);
}
}
},doclick:function(e){
if(this._skipBogusClicks){
_360.stop(e);
return true;
}
return false;
},colResizeSetup:function(e,_38d){
var _38e=html.contentBox(e.sourceView.headerNode);
if(_38d){
this.lineDiv=document.createElement("div");
var vw=html.position(e.sourceView.headerNode,true);
var _38f=html.contentBox(e.sourceView.domNode);
var l=e.pageX;
if(!this.grid.isLeftToRight()&&has("ie")<8){
l-=_363.getScrollbar().w;
}
html.style(this.lineDiv,{top:vw.y+"px",left:l+"px",height:(_38f.h+_38e.h)+"px"});
html.addClass(this.lineDiv,"dojoxGridResizeColLine");
this.lineDiv._origLeft=l;
win.body().appendChild(this.lineDiv);
}
var _390=[],_391=this.tableMap.findOverlappingNodes(e.cellNode);
for(var i=0,cell;(cell=_391[i]);i++){
_390.push({node:cell,index:this.getCellNodeIndex(cell),width:cell.offsetWidth});
}
var view=e.sourceView;
var adj=this.grid.isLeftToRight()?1:-1;
var _392=e.grid.views.views;
var _393=[];
for(var j=view.idx+adj,_394;(_394=_392[j]);j=j+adj){
_393.push({node:_394.headerNode,left:window.parseInt(_394.headerNode.style.left)});
}
var _395=view.headerContentNode.firstChild;
var drag={scrollLeft:e.sourceView.headerNode.scrollLeft,view:view,node:e.cellNode,index:e.cellIndex,w:html.contentBox(e.cellNode).w,vw:_38e.w,table:_395,tw:html.contentBox(_395).w,spanners:_390,followers:_393};
return drag;
},beginColumnResize:function(e){
this.moverDiv=document.createElement("div");
html.style(this.moverDiv,{position:"absolute",left:0});
win.body().appendChild(this.moverDiv);
html.addClass(this.grid.domNode,"dojoxGridColumnResizing");
var m=(this.moveable=new _362(this.moverDiv));
var drag=this.colResizeSetup(e,true);
m.onMove=lang.hitch(this,"doResizeColumn",drag);
_361.connect(m,"onMoveStop",lang.hitch(this,function(){
this.endResizeColumn(drag);
if(drag.node.releaseCapture){
drag.node.releaseCapture();
}
this.moveable.destroy();
delete this.moveable;
this.moveable=null;
html.removeClass(this.grid.domNode,"dojoxGridColumnResizing");
}));
if(e.cellNode.setCapture){
e.cellNode.setCapture();
}
m.onMouseDown(e);
},doResizeColumn:function(_396,_397,_398){
var _399=_398.l;
var data={deltaX:_399,w:_396.w+(this.grid.isLeftToRight()?_399:-_399),vw:_396.vw+_399,tw:_396.tw+_399};
this.dragRecord={inDrag:_396,mover:_397,leftTop:_398};
if(data.w>=this.minColWidth){
if(!_397){
this.doResizeNow(_396,data);
}else{
html.style(this.lineDiv,"left",(this.lineDiv._origLeft+data.deltaX)+"px");
}
}
},endResizeColumn:function(_39a){
if(this.dragRecord){
var _39b=this.dragRecord.leftTop;
var _39c=this.grid.isLeftToRight()?_39b.l:-_39b.l;
_39c+=Math.max(_39a.w+_39c,this.minColWidth)-(_39a.w+_39c);
if(has("webkit")&&_39a.spanners.length){
_39c+=html._getPadBorderExtents(_39a.spanners[0].node).w;
}
var data={deltaX:_39c,w:_39a.w+_39c,vw:_39a.vw+_39c,tw:_39a.tw+_39c};
this.doResizeNow(_39a,data);
delete this.dragRecord;
}
html.destroy(this.lineDiv);
html.destroy(this.moverDiv);
html.destroy(this.moverDiv);
delete this.moverDiv;
this._skipBogusClicks=true;
_39a.view.update();
this._skipBogusClicks=false;
this.grid.onResizeColumn(_39a.index);
},doResizeNow:function(_39d,data){
_39d.view.convertColPctToFixed();
if(_39d.view.flexCells&&!_39d.view.testFlexCells()){
var t=_369(_39d.node);
if(t){
(t.style.width="");
}
}
var i,s,sw,f,fl;
for(i=0;(s=_39d.spanners[i]);i++){
sw=s.width+data.deltaX;
if(sw>0){
s.node.style.width=sw+"px";
_39d.view.setColWidth(s.index,sw);
}
}
if(this.grid.isLeftToRight()||!has("ie")){
for(i=0;(f=_39d.followers[i]);i++){
fl=f.left+data.deltaX;
f.node.style.left=fl+"px";
}
}
_39d.node.style.width=data.w+"px";
_39d.view.setColWidth(_39d.index,data.w);
_39d.view.headerNode.style.width=data.vw+"px";
_39d.view.setColumnsWidth(data.tw);
if(!this.grid.isLeftToRight()){
_39d.view.headerNode.scrollLeft=_39d.scrollLeft+data.deltaX;
}
}});
dg._TableMap=lang.extend(function(rows){
this.mapRows(rows);
},{map:null,mapRows:function(_39e){
var _39f=_39e.length;
if(!_39f){
return;
}
this.map=[];
var row;
for(var k=0;(row=_39e[k]);k++){
this.map[k]=[];
}
for(var j=0;(row=_39e[j]);j++){
for(var i=0,x=0,cell,_3a0,_3a1;(cell=row[i]);i++){
while(this.map[j][x]){
x++;
}
this.map[j][x]={c:i,r:j};
_3a1=cell.rowSpan||1;
_3a0=cell.colSpan||1;
for(var y=0;y<_3a1;y++){
for(var s=0;s<_3a0;s++){
this.map[j+y][x+s]=this.map[j][x];
}
}
x+=_3a0;
}
}
},dumpMap:function(){
for(var j=0,row,h="";(row=this.map[j]);j++,h=""){
for(var i=0,cell;(cell=row[i]);i++){
h+=cell.r+","+cell.c+"   ";
}
}
},getMapCoords:function(_3a2,_3a3){
for(var j=0,row;(row=this.map[j]);j++){
for(var i=0,cell;(cell=row[i]);i++){
if(cell.c==_3a3&&cell.r==_3a2){
return {j:j,i:i};
}
}
}
return {j:-1,i:-1};
},getNode:function(_3a4,_3a5,_3a6){
var row=_3a4&&_3a4.rows[_3a5];
return row&&row.cells[_3a6];
},_findOverlappingNodes:function(_3a7,_3a8,_3a9){
var _3aa=[];
var m=this.getMapCoords(_3a8,_3a9);
for(var j=0,row;(row=this.map[j]);j++){
if(j==m.j){
continue;
}
var rw=row[m.i];
var n=(rw?this.getNode(_3a7,rw.r,rw.c):null);
if(n){
_3aa.push(n);
}
}
return _3aa;
},findOverlappingNodes:function(_3ab){
return this._findOverlappingNodes(_369(_3ab),_365(_3ab.parentNode),_364(_3ab));
}});
return {_Builder:_371,_HeaderBuilder:_388,_ContentBuilder:_382};
});
},"dojox/grid/_Scroller":function(){
define("dojox/grid/_Scroller",["dijit/registry","dojo/_base/declare","dojo/_base/lang","./util","dojo/_base/html"],function(_3ac,_3ad,lang,util,html){
var _3ae=function(_3af){
var i=0,n,p=_3af.parentNode;
while((n=p.childNodes[i++])){
if(n==_3af){
return i-1;
}
}
return -1;
};
var _3b0=function(_3b1){
if(!_3b1){
return;
}
dojo.forEach(_3ac.toArray(),function(w){
if(w.domNode&&html.isDescendant(w.domNode,_3b1,true)){
w.destroy();
}
});
};
var _3b2=function(_3b3){
var node=html.byId(_3b3);
return (node&&node.tagName?node.tagName.toLowerCase():"");
};
var _3b4=function(_3b5,_3b6){
var _3b7=[];
var i=0,n;
while((n=_3b5.childNodes[i])){
i++;
if(_3b2(n)==_3b6){
_3b7.push(n);
}
}
return _3b7;
};
var _3b8=function(_3b9){
return _3b4(_3b9,"div");
};
return _3ad("dojox.grid._Scroller",null,{constructor:function(_3ba){
this.setContentNodes(_3ba);
this.pageHeights=[];
this.pageNodes=[];
this.stack=[];
},rowCount:0,defaultRowHeight:32,keepRows:100,contentNode:null,scrollboxNode:null,defaultPageHeight:0,keepPages:10,pageCount:0,windowHeight:0,firstVisibleRow:0,lastVisibleRow:0,averageRowHeight:0,page:0,pageTop:0,init:function(_3bb,_3bc,_3bd){
switch(arguments.length){
case 3:
this.rowsPerPage=_3bd;
case 2:
this.keepRows=_3bc;
case 1:
this.rowCount=_3bb;
default:
break;
}
this.defaultPageHeight=(this.grid.rowHeight>0?this.grid.rowHeight:this.defaultRowHeight)*this.rowsPerPage;
this.pageCount=this._getPageCount(this.rowCount,this.rowsPerPage);
this.setKeepInfo(this.keepRows);
this.invalidate();
if(this.scrollboxNode){
this.scrollboxNode.scrollTop=0;
this.scroll(0);
this.scrollboxNode.onscroll=lang.hitch(this,"onscroll");
}
},_getPageCount:function(_3be,_3bf){
return _3be?(Math.ceil(_3be/_3bf)||1):0;
},destroy:function(){
this.invalidateNodes();
delete this.contentNodes;
delete this.contentNode;
delete this.scrollboxNode;
},setKeepInfo:function(_3c0){
this.keepRows=_3c0;
this.keepPages=!this.keepRows?this.keepPages:Math.max(Math.ceil(this.keepRows/this.rowsPerPage),2);
},setContentNodes:function(_3c1){
this.contentNodes=_3c1;
this.colCount=(this.contentNodes?this.contentNodes.length:0);
this.pageNodes=[];
for(var i=0;i<this.colCount;i++){
this.pageNodes[i]=[];
}
},getDefaultNodes:function(){
return this.pageNodes[0]||[];
},invalidate:function(){
this._invalidating=true;
this.invalidateNodes();
this.pageHeights=[];
this.height=(this.pageCount?(this.pageCount-1)*this.defaultPageHeight+this.calcLastPageHeight():0);
this.resize();
this._invalidating=false;
},updateRowCount:function(_3c2){
this.invalidateNodes();
this.rowCount=_3c2;
var _3c3=this.pageCount;
if(_3c3===0){
this.height=1;
}
this.pageCount=this._getPageCount(this.rowCount,this.rowsPerPage);
if(this.pageCount<_3c3){
for(var i=_3c3-1;i>=this.pageCount;i--){
this.height-=this.getPageHeight(i);
delete this.pageHeights[i];
}
}else{
if(this.pageCount>_3c3){
this.height+=this.defaultPageHeight*(this.pageCount-_3c3-1)+this.calcLastPageHeight();
}
}
this.resize();
},pageExists:function(_3c4){
return Boolean(this.getDefaultPageNode(_3c4));
},measurePage:function(_3c5){
if(this.grid.rowHeight){
return ((_3c5+1)*this.rowsPerPage>this.rowCount?this.rowCount-_3c5*this.rowsPerPage:this.rowsPerPage)*this.grid.rowHeight;
}
var n=this.getDefaultPageNode(_3c5);
return (n&&n.innerHTML)?n.offsetHeight:undefined;
},positionPage:function(_3c6,_3c7){
for(var i=0;i<this.colCount;i++){
this.pageNodes[i][_3c6].style.top=_3c7+"px";
}
},repositionPages:function(_3c8){
var _3c9=this.getDefaultNodes();
var last=0;
for(var i=0;i<this.stack.length;i++){
last=Math.max(this.stack[i],last);
}
var n=_3c9[_3c8];
var y=(n?this.getPageNodePosition(n)+this.getPageHeight(_3c8):0);
for(var p=_3c8+1;p<=last;p++){
n=_3c9[p];
if(n){
if(this.getPageNodePosition(n)==y){
return;
}
this.positionPage(p,y);
}
y+=this.getPageHeight(p);
}
},installPage:function(_3ca){
for(var i=0;i<this.colCount;i++){
this.contentNodes[i].appendChild(this.pageNodes[i][_3ca]);
}
},preparePage:function(_3cb,_3cc){
var p=(_3cc?this.popPage():null);
for(var i=0;i<this.colCount;i++){
var _3cd=this.pageNodes[i];
var _3ce=(p===null?this.createPageNode():this.invalidatePageNode(p,_3cd));
_3ce.pageIndex=_3cb;
_3cd[_3cb]=_3ce;
}
},renderPage:function(_3cf){
var _3d0=[];
var i,j;
for(i=0;i<this.colCount;i++){
_3d0[i]=this.pageNodes[i][_3cf];
}
for(i=0,j=_3cf*this.rowsPerPage;(i<this.rowsPerPage)&&(j<this.rowCount);i++,j++){
this.renderRow(j,_3d0);
}
},removePage:function(_3d1){
for(var i=0,j=_3d1*this.rowsPerPage;i<this.rowsPerPage;i++,j++){
this.removeRow(j);
}
},destroyPage:function(_3d2){
for(var i=0;i<this.colCount;i++){
var n=this.invalidatePageNode(_3d2,this.pageNodes[i]);
if(n){
html.destroy(n);
}
}
},pacify:function(_3d3){
},pacifying:false,pacifyTicks:200,setPacifying:function(_3d4){
if(this.pacifying!=_3d4){
this.pacifying=_3d4;
this.pacify(this.pacifying);
}
},startPacify:function(){
this.startPacifyTicks=new Date().getTime();
},doPacify:function(){
var _3d5=(new Date().getTime()-this.startPacifyTicks)>this.pacifyTicks;
this.setPacifying(true);
this.startPacify();
return _3d5;
},endPacify:function(){
this.setPacifying(false);
},resize:function(){
if(this.scrollboxNode){
this.windowHeight=this.scrollboxNode.clientHeight;
}
for(var i=0;i<this.colCount;i++){
util.setStyleHeightPx(this.contentNodes[i],Math.max(1,this.height));
}
var _3d6=(!this._invalidating);
if(!_3d6){
var ah=this.grid.get("autoHeight");
if(typeof ah=="number"&&ah<=Math.min(this.rowsPerPage,this.rowCount)){
_3d6=true;
}
}
if(_3d6){
this.needPage(this.page,this.pageTop);
}
var _3d7=(this.page<this.pageCount-1)?this.rowsPerPage:((this.rowCount%this.rowsPerPage)||this.rowsPerPage);
var _3d8=this.getPageHeight(this.page);
this.averageRowHeight=(_3d8>0&&_3d7>0)?(_3d8/_3d7):0;
},calcLastPageHeight:function(){
if(!this.pageCount){
return 0;
}
var _3d9=this.pageCount-1;
var _3da=((this.rowCount%this.rowsPerPage)||(this.rowsPerPage))*this.defaultRowHeight;
this.pageHeights[_3d9]=_3da;
return _3da;
},updateContentHeight:function(inDh){
this.height+=inDh;
this.resize();
},updatePageHeight:function(_3db,_3dc,_3dd){
if(this.pageExists(_3db)){
var oh=this.getPageHeight(_3db);
var h=(this.measurePage(_3db));
if(h===undefined){
h=oh;
}
this.pageHeights[_3db]=h;
if(oh!=h){
this.updateContentHeight(h-oh);
var ah=this.grid.get("autoHeight");
if((typeof ah=="number"&&ah>this.rowCount)||(ah===true&&!_3dc)){
if(!_3dd){
this.grid.sizeChange();
}else{
var ns=this.grid.viewsNode.style;
ns.height=parseInt(ns.height)+h-oh+"px";
this.repositionPages(_3db);
}
}else{
this.repositionPages(_3db);
}
}
return h;
}
return 0;
},rowHeightChanged:function(_3de,_3df){
this.updatePageHeight(Math.floor(_3de/this.rowsPerPage),false,_3df);
},invalidateNodes:function(){
while(this.stack.length){
this.destroyPage(this.popPage());
}
},createPageNode:function(){
var p=document.createElement("div");
html.attr(p,"role","presentation");
p.style.position="absolute";
p.style[this.grid.isLeftToRight()?"left":"right"]="0";
return p;
},getPageHeight:function(_3e0){
var ph=this.pageHeights[_3e0];
return (ph!==undefined?ph:this.defaultPageHeight);
},pushPage:function(_3e1){
return this.stack.push(_3e1);
},popPage:function(){
return this.stack.shift();
},findPage:function(_3e2){
var i=0,h=0;
for(var ph=0;i<this.pageCount;i++,h+=ph){
ph=this.getPageHeight(i);
if(h+ph>=_3e2){
break;
}
}
this.page=i;
this.pageTop=h;
},buildPage:function(_3e3,_3e4,_3e5){
this.preparePage(_3e3,_3e4);
this.positionPage(_3e3,_3e5);
this.installPage(_3e3);
this.renderPage(_3e3);
this.pushPage(_3e3);
},needPage:function(_3e6,_3e7){
var h=this.getPageHeight(_3e6),oh=h;
if(!this.pageExists(_3e6)){
this.buildPage(_3e6,(!this.grid._autoHeight&&this.keepPages&&(this.stack.length>=this.keepPages)),_3e7);
h=this.updatePageHeight(_3e6,true);
}else{
this.positionPage(_3e6,_3e7);
}
return h;
},onscroll:function(){
this.scroll(this.scrollboxNode.scrollTop);
},scroll:function(_3e8){
this.grid.scrollTop=_3e8;
if(this.colCount){
this.startPacify();
this.findPage(_3e8);
var h=this.height;
var b=this.getScrollBottom(_3e8);
for(var p=this.page,y=this.pageTop;(p<this.pageCount)&&((b<0)||(y<b));p++){
y+=this.needPage(p,y);
}
this.firstVisibleRow=this.getFirstVisibleRow(this.page,this.pageTop,_3e8);
this.lastVisibleRow=this.getLastVisibleRow(p-1,y,b);
if(h!=this.height){
this.repositionPages(p-1);
}
this.endPacify();
}
},getScrollBottom:function(_3e9){
return (this.windowHeight>=0?_3e9+this.windowHeight:-1);
},processNodeEvent:function(e,_3ea){
var t=e.target;
while(t&&(t!=_3ea)&&t.parentNode&&(t.parentNode.parentNode!=_3ea)){
t=t.parentNode;
}
if(!t||!t.parentNode||(t.parentNode.parentNode!=_3ea)){
return false;
}
var page=t.parentNode;
e.topRowIndex=page.pageIndex*this.rowsPerPage;
e.rowIndex=e.topRowIndex+_3ae(t);
e.rowTarget=t;
return true;
},processEvent:function(e){
return this.processNodeEvent(e,this.contentNode);
},renderRow:function(_3eb,_3ec){
},removeRow:function(_3ed){
},getDefaultPageNode:function(_3ee){
return this.getDefaultNodes()[_3ee];
},positionPageNode:function(_3ef,_3f0){
},getPageNodePosition:function(_3f1){
return _3f1.offsetTop;
},invalidatePageNode:function(_3f2,_3f3){
var p=_3f3[_3f2];
if(p){
delete _3f3[_3f2];
this.removePage(_3f2,p);
_3b0(p);
p.innerHTML="";
}
return p;
},getPageRow:function(_3f4){
return _3f4*this.rowsPerPage;
},getLastPageRow:function(_3f5){
return Math.min(this.rowCount,this.getPageRow(_3f5+1))-1;
},getFirstVisibleRow:function(_3f6,_3f7,_3f8){
if(!this.pageExists(_3f6)){
return 0;
}
var row=this.getPageRow(_3f6);
var _3f9=this.getDefaultNodes();
var rows=_3b8(_3f9[_3f6]);
for(var i=0,l=rows.length;i<l&&_3f7<_3f8;i++,row++){
_3f7+=rows[i].offsetHeight;
}
return (row?row-1:row);
},getLastVisibleRow:function(_3fa,_3fb,_3fc){
if(!this.pageExists(_3fa)){
return 0;
}
var _3fd=this.getDefaultNodes();
var row=this.getLastPageRow(_3fa);
var rows=_3b8(_3fd[_3fa]);
for(var i=rows.length-1;i>=0&&_3fb>_3fc;i--,row--){
_3fb-=rows[i].offsetHeight;
}
return row+1;
},findTopRow:function(_3fe){
var _3ff=this.getDefaultNodes();
var rows=_3b8(_3ff[this.page]);
for(var i=0,l=rows.length,t=this.pageTop,h;i<l;i++){
h=rows[i].offsetHeight;
t+=h;
if(t>=_3fe){
this.offset=h-(t-_3fe);
return i+this.page*this.rowsPerPage;
}
}
return -1;
},findScrollTop:function(_400){
var _401=Math.floor(_400/this.rowsPerPage);
var t=0;
var i,l;
for(i=0;i<_401;i++){
t+=this.getPageHeight(i);
}
this.pageTop=t;
this.page=_401;
this.needPage(_401,this.pageTop);
var _402=this.getDefaultNodes();
var rows=_3b8(_402[_401]);
var r=_400-this.rowsPerPage*_401;
for(i=0,l=rows.length;i<l&&i<r;i++){
t+=rows[i].offsetHeight;
}
return t;
},dummy:0});
});
},"dojox/grid/_Layout":function(){
define("dojox/grid/_Layout",["dojo/_base/kernel","../main","dojo/_base/declare","dojo/_base/array","dojo/_base/lang","dojo/dom-geometry","./cells","./_RowSelector"],function(dojo,_403,_404,_405,lang,_406){
return _404("dojox.grid._Layout",null,{constructor:function(_407){
this.grid=_407;
},cells:[],structure:null,defaultWidth:"6em",moveColumn:function(_408,_409,_40a,_40b,_40c){
var _40d=this.structure[_408].cells[0];
var _40e=this.structure[_409].cells[0];
var cell=null;
var _40f=0;
var _410=0;
for(var i=0,c;c=_40d[i];i++){
if(c.index==_40a){
_40f=i;
break;
}
}
cell=_40d.splice(_40f,1)[0];
cell.view=this.grid.views.views[_409];
for(i=0,c=null;c=_40e[i];i++){
if(c.index==_40b){
_410=i;
break;
}
}
if(!_40c){
_410+=1;
}
_40e.splice(_410,0,cell);
var _411=this.grid.getCell(this.grid.getSortIndex());
if(_411){
_411._currentlySorted=this.grid.getSortAsc();
}
this.cells=[];
_40a=0;
var v;
for(i=0;v=this.structure[i];i++){
for(var j=0,cs;cs=v.cells[j];j++){
for(var k=0;c=cs[k];k++){
c.index=_40a;
this.cells.push(c);
if("_currentlySorted" in c){
var si=_40a+1;
si*=c._currentlySorted?1:-1;
this.grid.sortInfo=si;
delete c._currentlySorted;
}
_40a++;
}
}
}
_405.forEach(this.cells,function(c){
var _412=c.markup[2].split(" ");
var _413=parseInt(_412[1].substring(5));
if(_413!=c.index){
_412[1]="idx=\""+c.index+"\"";
c.markup[2]=_412.join(" ");
}
});
this.grid.setupHeaderMenu();
},setColumnVisibility:function(_414,_415){
var cell=this.cells[_414];
if(cell.hidden==_415){
cell.hidden=!_415;
var v=cell.view,w=v.viewWidth;
if(w&&w!="auto"){
v._togglingColumn=_406.getMarginBox(cell.getHeaderNode()).w||0;
}
v.update();
return true;
}else{
return false;
}
},addCellDef:function(_416,_417,_418){
var self=this;
var _419=function(_41a){
var w=0;
if(_41a.colSpan>1){
w=0;
}else{
w=_41a.width||self._defaultCellProps.width||self.defaultWidth;
if(!isNaN(w)){
w=w+"em";
}
}
return w;
};
var _41b={grid:this.grid,subrow:_416,layoutIndex:_417,index:this.cells.length};
if(_418&&_418 instanceof _403.grid.cells._Base){
var _41c=lang.clone(_418);
_41b.unitWidth=_419(_41c._props);
_41c=lang.mixin(_41c,this._defaultCellProps,_418._props,_41b);
return _41c;
}
var _41d=_418.type||_418.cellType||this._defaultCellProps.type||this._defaultCellProps.cellType||_403.grid.cells.Cell;
if(lang.isString(_41d)){
_41d=lang.getObject(_41d);
}
_41b.unitWidth=_419(_418);
return new _41d(lang.mixin({},this._defaultCellProps,_418,_41b));
},addRowDef:function(_41e,_41f){
var _420=[];
var _421=0,_422=0,_423=true;
for(var i=0,def,cell;(def=_41f[i]);i++){
cell=this.addCellDef(_41e,i,def);
_420.push(cell);
this.cells.push(cell);
if(_423&&cell.relWidth){
_421+=cell.relWidth;
}else{
if(cell.width){
var w=cell.width;
if(typeof w=="string"&&w.slice(-1)=="%"){
_422+=window.parseInt(w,10);
}else{
if(w=="auto"){
_423=false;
}
}
}
}
}
if(_421&&_423){
_405.forEach(_420,function(cell){
if(cell.relWidth){
cell.width=cell.unitWidth=((cell.relWidth/_421)*(100-_422))+"%";
}
});
}
return _420;
},addRowsDef:function(_424){
var _425=[];
if(lang.isArray(_424)){
if(lang.isArray(_424[0])){
for(var i=0,row;_424&&(row=_424[i]);i++){
_425.push(this.addRowDef(i,row));
}
}else{
_425.push(this.addRowDef(0,_424));
}
}
return _425;
},addViewDef:function(_426){
this._defaultCellProps=_426.defaultCell||{};
if(_426.width&&_426.width=="auto"){
delete _426.width;
}
return lang.mixin({},_426,{cells:this.addRowsDef(_426.rows||_426.cells)});
},setStructure:function(_427){
this.fieldIndex=0;
this.cells=[];
var s=this.structure=[];
if(this.grid.rowSelector){
var sel={type:_403._scopeName+".grid._RowSelector"};
if(lang.isString(this.grid.rowSelector)){
var _428=this.grid.rowSelector;
if(_428=="false"){
sel=null;
}else{
if(_428!="true"){
sel["width"]=_428;
}
}
}else{
if(!this.grid.rowSelector){
sel=null;
}
}
if(sel){
s.push(this.addViewDef(sel));
}
}
var _429=function(def){
return ("name" in def||"field" in def||"get" in def);
};
var _42a=function(def){
if(lang.isArray(def)){
if(lang.isArray(def[0])||_429(def[0])){
return true;
}
}
return false;
};
var _42b=function(def){
return (def!==null&&lang.isObject(def)&&("cells" in def||"rows" in def||("type" in def&&!_429(def))));
};
if(lang.isArray(_427)){
var _42c=false;
for(var i=0,st;(st=_427[i]);i++){
if(_42b(st)){
_42c=true;
break;
}
}
if(!_42c){
s.push(this.addViewDef({cells:_427}));
}else{
for(i=0;(st=_427[i]);i++){
if(_42a(st)){
s.push(this.addViewDef({cells:st}));
}else{
if(_42b(st)){
s.push(this.addViewDef(st));
}
}
}
}
}else{
if(_42b(_427)){
s.push(this.addViewDef(_427));
}
}
this.cellCount=this.cells.length;
this.grid.setupHeaderMenu();
}});
});
},"dojo/dnd/Source":function(){
define(["../_base/array","../_base/connect","../_base/declare","../_base/kernel","../_base/lang","../dom-class","../dom-geometry","../mouse","../ready","../topic","./common","./Selector","./Manager"],function(_42d,_42e,_42f,_430,lang,_431,_432,_433,_434,_435,dnd,_436,_437){
if(!_430.isAsync){
_434(0,function(){
var _438=["dojo/dnd/AutoSource","dojo/dnd/Target"];
require(_438);
});
}
var _439=_42f("dojo.dnd.Source",_436,{isSource:true,horizontal:false,copyOnly:false,selfCopy:false,selfAccept:true,skipForm:false,withHandles:false,autoSync:false,delay:0,accept:["text"],generateText:true,constructor:function(node,_43a){
lang.mixin(this,lang.mixin({},_43a));
var type=this.accept;
if(type.length){
this.accept={};
for(var i=0;i<type.length;++i){
this.accept[type[i]]=1;
}
}
this.isDragging=false;
this.mouseDown=false;
this.targetAnchor=null;
this.targetBox=null;
this.before=true;
this._lastX=0;
this._lastY=0;
this.sourceState="";
if(this.isSource){
_431.add(this.node,"dojoDndSource");
}
this.targetState="";
if(this.accept){
_431.add(this.node,"dojoDndTarget");
}
if(this.horizontal){
_431.add(this.node,"dojoDndHorizontal");
}
this.topics=[_435.subscribe("/dnd/source/over",lang.hitch(this,"onDndSourceOver")),_435.subscribe("/dnd/start",lang.hitch(this,"onDndStart")),_435.subscribe("/dnd/drop",lang.hitch(this,"onDndDrop")),_435.subscribe("/dnd/cancel",lang.hitch(this,"onDndCancel"))];
},checkAcceptance:function(_43b,_43c){
if(this==_43b){
return !this.copyOnly||this.selfAccept;
}
for(var i=0;i<_43c.length;++i){
var type=_43b.getItem(_43c[i].id).type;
var flag=false;
for(var j=0;j<type.length;++j){
if(type[j] in this.accept){
flag=true;
break;
}
}
if(!flag){
return false;
}
}
return true;
},copyState:function(_43d,self){
if(_43d){
return true;
}
if(arguments.length<2){
self=this==_437.manager().target;
}
if(self){
if(this.copyOnly){
return this.selfCopy;
}
}else{
return this.copyOnly;
}
return false;
},destroy:function(){
_439.superclass.destroy.call(this);
_42d.forEach(this.topics,function(t){
t.remove();
});
this.targetAnchor=null;
},onMouseMove:function(e){
if(this.isDragging&&this.targetState=="Disabled"){
return;
}
_439.superclass.onMouseMove.call(this,e);
var m=_437.manager();
if(!this.isDragging){
if(this.mouseDown&&this.isSource&&(Math.abs(e.pageX-this._lastX)>this.delay||Math.abs(e.pageY-this._lastY)>this.delay)){
var _43e=this.getSelectedNodes();
if(_43e.length){
m.startDrag(this,_43e,this.copyState(dnd.getCopyKeyState(e),true));
}
}
}
if(this.isDragging){
var _43f=false;
if(this.current){
if(!this.targetBox||this.targetAnchor!=this.current){
this.targetBox=_432.position(this.current,true);
}
if(this.horizontal){
_43f=(e.pageX-this.targetBox.x<this.targetBox.w/2)==_432.isBodyLtr(this.current.ownerDocument);
}else{
_43f=(e.pageY-this.targetBox.y)<(this.targetBox.h/2);
}
}
if(this.current!=this.targetAnchor||_43f!=this.before){
this._markTargetAnchor(_43f);
m.canDrop(!this.current||m.source!=this||!(this.current.id in this.selection));
}
}
},onMouseDown:function(e){
if(!this.mouseDown&&this._legalMouseDown(e)&&(!this.skipForm||!dnd.isFormElement(e))){
this.mouseDown=true;
this._lastX=e.pageX;
this._lastY=e.pageY;
_439.superclass.onMouseDown.call(this,e);
}
},onMouseUp:function(e){
if(this.mouseDown){
this.mouseDown=false;
_439.superclass.onMouseUp.call(this,e);
}
},onDndSourceOver:function(_440){
if(this!==_440){
this.mouseDown=false;
if(this.targetAnchor){
this._unmarkTargetAnchor();
}
}else{
if(this.isDragging){
var m=_437.manager();
m.canDrop(this.targetState!="Disabled"&&(!this.current||m.source!=this||!(this.current.id in this.selection)));
}
}
},onDndStart:function(_441,_442,copy){
if(this.autoSync){
this.sync();
}
if(this.isSource){
this._changeState("Source",this==_441?(copy?"Copied":"Moved"):"");
}
var _443=this.accept&&this.checkAcceptance(_441,_442);
this._changeState("Target",_443?"":"Disabled");
if(this==_441){
_437.manager().overSource(this);
}
this.isDragging=true;
},onDndDrop:function(_444,_445,copy,_446){
if(this==_446){
this.onDrop(_444,_445,copy);
}
this.onDndCancel();
},onDndCancel:function(){
if(this.targetAnchor){
this._unmarkTargetAnchor();
this.targetAnchor=null;
}
this.before=true;
this.isDragging=false;
this.mouseDown=false;
this._changeState("Source","");
this._changeState("Target","");
},onDrop:function(_447,_448,copy){
if(this!=_447){
this.onDropExternal(_447,_448,copy);
}else{
this.onDropInternal(_448,copy);
}
},onDropExternal:function(_449,_44a,copy){
var _44b=this._normalizedCreator;
if(this.creator){
this._normalizedCreator=function(node,hint){
return _44b.call(this,_449.getItem(node.id).data,hint);
};
}else{
if(copy){
this._normalizedCreator=function(node){
var t=_449.getItem(node.id);
var n=node.cloneNode(true);
n.id=dnd.getUniqueId();
return {node:n,data:t.data,type:t.type};
};
}else{
this._normalizedCreator=function(node){
var t=_449.getItem(node.id);
_449.delItem(node.id);
return {node:node,data:t.data,type:t.type};
};
}
}
this.selectNone();
if(!copy&&!this.creator){
_449.selectNone();
}
this.insertNodes(true,_44a,this.before,this.current);
if(!copy&&this.creator){
_449.deleteSelectedNodes();
}
this._normalizedCreator=_44b;
},onDropInternal:function(_44c,copy){
var _44d=this._normalizedCreator;
if(this.current&&this.current.id in this.selection){
return;
}
if(copy){
if(this.creator){
this._normalizedCreator=function(node,hint){
return _44d.call(this,this.getItem(node.id).data,hint);
};
}else{
this._normalizedCreator=function(node){
var t=this.getItem(node.id);
var n=node.cloneNode(true);
n.id=dnd.getUniqueId();
return {node:n,data:t.data,type:t.type};
};
}
}else{
if(!this.current){
return;
}
this._normalizedCreator=function(node){
var t=this.getItem(node.id);
return {node:node,data:t.data,type:t.type};
};
}
this._removeSelection();
this.insertNodes(true,_44c,this.before,this.current);
this._normalizedCreator=_44d;
},onDraggingOver:function(){
},onDraggingOut:function(){
},onOverEvent:function(){
_439.superclass.onOverEvent.call(this);
_437.manager().overSource(this);
if(this.isDragging&&this.targetState!="Disabled"){
this.onDraggingOver();
}
},onOutEvent:function(){
_439.superclass.onOutEvent.call(this);
_437.manager().outSource(this);
if(this.isDragging&&this.targetState!="Disabled"){
this.onDraggingOut();
}
},_markTargetAnchor:function(_44e){
if(this.current==this.targetAnchor&&this.before==_44e){
return;
}
if(this.targetAnchor){
this._removeItemClass(this.targetAnchor,this.before?"Before":"After");
}
this.targetAnchor=this.current;
this.targetBox=null;
this.before=_44e;
if(this.targetAnchor){
this._addItemClass(this.targetAnchor,this.before?"Before":"After");
}
},_unmarkTargetAnchor:function(){
if(!this.targetAnchor){
return;
}
this._removeItemClass(this.targetAnchor,this.before?"Before":"After");
this.targetAnchor=null;
this.targetBox=null;
this.before=true;
},_markDndStatus:function(copy){
this._changeState("Source",copy?"Copied":"Moved");
},_legalMouseDown:function(e){
if(e.type!="touchstart"&&!_433.isLeft(e)){
return false;
}
if(!this.withHandles){
return true;
}
for(var node=e.target;node&&node!==this.node;node=node.parentNode){
if(_431.contains(node,"dojoDndHandle")){
return true;
}
if(_431.contains(node,"dojoDndItem")||_431.contains(node,"dojoDndIgnore")){
break;
}
}
return false;
}});
return _439;
});
},"dijit/_Widget":function(){
define(["dojo/aspect","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/query","dojo/ready","./registry","./_WidgetBase","./_OnDijitClickMixin","./_FocusMixin","dojo/uacss","./hccss"],function(_44f,_450,_451,_452,has,_453,lang,_454,_455,_456,_457,_458,_459){
function _45a(){
};
function _45b(_45c){
return function(obj,_45d,_45e,_45f){
if(obj&&typeof _45d=="string"&&obj[_45d]==_45a){
return obj.on(_45d.substring(2).toLowerCase(),lang.hitch(_45e,_45f));
}
return _45c.apply(_451,arguments);
};
};
_44f.around(_451,"connect",_45b);
if(_453.connect){
_44f.around(_453,"connect",_45b);
}
var _460=_452("dijit._Widget",[_457,_458,_459],{onClick:_45a,onDblClick:_45a,onKeyDown:_45a,onKeyPress:_45a,onKeyUp:_45a,onMouseDown:_45a,onMouseMove:_45a,onMouseOut:_45a,onMouseOver:_45a,onMouseLeave:_45a,onMouseEnter:_45a,onMouseUp:_45a,constructor:function(_461){
this._toConnect={};
for(var name in _461){
if(this[name]===_45a){
this._toConnect[name.replace(/^on/,"").toLowerCase()]=_461[name];
delete _461[name];
}
}
},postCreate:function(){
this.inherited(arguments);
for(var name in this._toConnect){
this.on(name,this._toConnect[name]);
}
delete this._toConnect;
},on:function(type,func){
if(this[this._onMap(type)]===_45a){
return _451.connect(this.domNode,type.toLowerCase(),this,func);
}
return this.inherited(arguments);
},_setFocusedAttr:function(val){
this._focused=val;
this._set("focused",val);
},setAttribute:function(attr,_462){
_453.deprecated(this.declaredClass+"::setAttribute(attr, value) is deprecated. Use set() instead.","","2.0");
this.set(attr,_462);
},attr:function(name,_463){
if(_450.isDebug){
var _464=arguments.callee._ach||(arguments.callee._ach={}),_465=(arguments.callee.caller||"unknown caller").toString();
if(!_464[_465]){
_453.deprecated(this.declaredClass+"::attr() is deprecated. Use get() or set() instead, called from "+_465,"","2.0");
_464[_465]=true;
}
}
var args=arguments.length;
if(args>=2||typeof name==="object"){
return this.set.apply(this,arguments);
}else{
return this.get(name);
}
},getDescendants:function(){
_453.deprecated(this.declaredClass+"::getDescendants() is deprecated. Use getChildren() instead.","","2.0");
return this.containerNode?_454("[widgetId]",this.containerNode).map(_456.byNode):[];
},_onShow:function(){
this.onShow();
},onShow:function(){
},onHide:function(){
},onClose:function(){
return true;
}});
if(has("dijit-legacy-requires")){
_455(0,function(){
var _466=["dijit/_base"];
require(_466);
});
}
return _460;
});
},"dijit/_FocusMixin":function(){
define(["./focus","./_WidgetBase","dojo/_base/declare","dojo/_base/lang"],function(_467,_468,_469,lang){
lang.extend(_468,{focused:false,onFocus:function(){
},onBlur:function(){
},_onFocus:function(){
this.onFocus();
},_onBlur:function(){
this.onBlur();
}});
return _469("dijit._FocusMixin",null,{_focusManager:_467});
});
},"dijit/focus":function(){
define(["dojo/aspect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-construct","dojo/Evented","dojo/_base/lang","dojo/on","dojo/ready","dojo/sniff","dojo/Stateful","dojo/_base/unload","dojo/_base/window","dojo/window","./a11y","./registry","./main"],function(_46a,_46b,dom,_46c,_46d,_46e,lang,on,_46f,has,_470,_471,win,_472,a11y,_473,_474){
var _475=_46b([_470,_46e],{curNode:null,activeStack:[],constructor:function(){
var _476=lang.hitch(this,function(node){
if(dom.isDescendant(this.curNode,node)){
this.set("curNode",null);
}
if(dom.isDescendant(this.prevNode,node)){
this.set("prevNode",null);
}
});
_46a.before(_46d,"empty",_476);
_46a.before(_46d,"destroy",_476);
},registerIframe:function(_477){
return this.registerWin(_477.contentWindow,_477);
},registerWin:function(_478,_479){
var _47a=this;
var _47b=function(evt){
_47a._justMouseDowned=true;
setTimeout(function(){
_47a._justMouseDowned=false;
},0);
if(has("ie")&&evt&&evt.srcElement&&evt.srcElement.parentNode==null){
return;
}
_47a._onTouchNode(_479||evt.target||evt.srcElement,"mouse");
};
var doc=has("ie")?_478.document.documentElement:_478.document;
if(doc){
if(has("ie")){
_478.document.body.attachEvent("onmousedown",_47b);
var _47c=function(evt){
var tag=evt.srcElement.tagName.toLowerCase();
if(tag=="#document"||tag=="body"){
return;
}
if(a11y.isTabNavigable(evt.srcElement)){
_47a._onFocusNode(_479||evt.srcElement);
}else{
_47a._onTouchNode(_479||evt.srcElement);
}
};
doc.attachEvent("onfocusin",_47c);
var _47d=function(evt){
_47a._onBlurNode(_479||evt.srcElement);
};
doc.attachEvent("onfocusout",_47d);
return {remove:function(){
_478.document.detachEvent("onmousedown",_47b);
doc.detachEvent("onfocusin",_47c);
doc.detachEvent("onfocusout",_47d);
doc=null;
}};
}else{
doc.body.addEventListener("mousedown",_47b,true);
doc.body.addEventListener("touchstart",_47b,true);
var _47e=function(evt){
_47a._onFocusNode(_479||evt.target);
};
doc.addEventListener("focus",_47e,true);
var _47f=function(evt){
_47a._onBlurNode(_479||evt.target);
};
doc.addEventListener("blur",_47f,true);
return {remove:function(){
doc.body.removeEventListener("mousedown",_47b,true);
doc.body.removeEventListener("touchstart",_47b,true);
doc.removeEventListener("focus",_47e,true);
doc.removeEventListener("blur",_47f,true);
doc=null;
}};
}
}
},_onBlurNode:function(node){
if(this._clearFocusTimer){
clearTimeout(this._clearFocusTimer);
}
this._clearFocusTimer=setTimeout(lang.hitch(this,function(){
this.set("prevNode",this.curNode);
this.set("curNode",null);
}),0);
if(this._justMouseDowned){
return;
}
if(this._clearActiveWidgetsTimer){
clearTimeout(this._clearActiveWidgetsTimer);
}
this._clearActiveWidgetsTimer=setTimeout(lang.hitch(this,function(){
delete this._clearActiveWidgetsTimer;
this._setStack([]);
}),0);
},_onTouchNode:function(node,by){
if(this._clearActiveWidgetsTimer){
clearTimeout(this._clearActiveWidgetsTimer);
delete this._clearActiveWidgetsTimer;
}
var _480=[];
try{
while(node){
var _481=_46c.get(node,"dijitPopupParent");
if(_481){
node=_473.byId(_481).domNode;
}else{
if(node.tagName&&node.tagName.toLowerCase()=="body"){
if(node===win.body()){
break;
}
node=_472.get(node.ownerDocument).frameElement;
}else{
var id=node.getAttribute&&node.getAttribute("widgetId"),_482=id&&_473.byId(id);
if(_482&&!(by=="mouse"&&_482.get("disabled"))){
_480.unshift(id);
}
node=node.parentNode;
}
}
}
}
catch(e){
}
this._setStack(_480,by);
},_onFocusNode:function(node){
if(!node){
return;
}
if(node.nodeType==9){
return;
}
if(this._clearFocusTimer){
clearTimeout(this._clearFocusTimer);
delete this._clearFocusTimer;
}
this._onTouchNode(node);
if(node==this.curNode){
return;
}
this.set("prevNode",this.curNode);
this.set("curNode",node);
},_setStack:function(_483,by){
var _484=this.activeStack;
this.set("activeStack",_483);
for(var _485=0;_485<Math.min(_484.length,_483.length);_485++){
if(_484[_485]!=_483[_485]){
break;
}
}
var _486;
for(var i=_484.length-1;i>=_485;i--){
_486=_473.byId(_484[i]);
if(_486){
_486._hasBeenBlurred=true;
_486.set("focused",false);
if(_486._focusManager==this){
_486._onBlur(by);
}
this.emit("widget-blur",_486,by);
}
}
for(i=_485;i<_483.length;i++){
_486=_473.byId(_483[i]);
if(_486){
_486.set("focused",true);
if(_486._focusManager==this){
_486._onFocus(by);
}
this.emit("widget-focus",_486,by);
}
}
},focus:function(node){
if(node){
try{
node.focus();
}
catch(e){
}
}
}});
var _487=new _475();
_46f(function(){
var _488=_487.registerWin(_472.get(win.doc));
if(has("ie")){
_471.addOnWindowUnload(function(){
if(_488){
_488.remove();
_488=null;
}
});
}
});
_474.focus=function(node){
_487.focus(node);
};
for(var attr in _487){
if(!/^_/.test(attr)){
_474.focus[attr]=typeof _487[attr]=="function"?lang.hitch(_487,attr):_487[attr];
}
}
_487.watch(function(attr,_489,_48a){
_474.focus[attr]=_48a;
});
return _487;
});
},"dijit/_Contained":function(){
define(["dojo/_base/declare","./registry"],function(_48b,_48c){
return _48b("dijit._Contained",null,{_getSibling:function(_48d){
var node=this.domNode;
do{
node=node[_48d+"Sibling"];
}while(node&&node.nodeType!=1);
return node&&_48c.byNode(node);
},getPreviousSibling:function(){
return this._getSibling("previous");
},getNextSibling:function(){
return this._getSibling("next");
},getIndexInParent:function(){
var p=this.getParent();
if(!p||!p.getIndexOfChild){
return -1;
}
return p.getIndexOfChild(this);
}});
});
},"dojox/grid/_RowManager":function(){
define(["dojo/_base/declare","dojo/_base/lang","dojo/dom-class"],function(_48e,lang,_48f){
var _490=function(_491,_492){
if(_491.style.cssText==undefined){
_491.setAttribute("style",_492);
}else{
_491.style.cssText=_492;
}
};
return _48e("dojox.grid._RowManager",null,{constructor:function(_493){
this.grid=_493;
},linesToEms:2,overRow:-2,prepareStylingRow:function(_494,_495){
return {index:_494,node:_495,odd:Boolean(_494&1),selected:!!this.grid.selection.isSelected(_494),over:this.isOver(_494),customStyles:"",customClasses:"dojoxGridRow"};
},styleRowNode:function(_496,_497){
var row=this.prepareStylingRow(_496,_497);
this.grid.onStyleRow(row);
this.applyStyles(row);
},applyStyles:function(_498){
var i=_498;
i.node.className=i.customClasses;
var h=i.node.style.height;
_490(i.node,i.customStyles+";"+(i.node._style||""));
i.node.style.height=h;
},updateStyles:function(_499){
this.grid.updateRowStyles(_499);
},setOverRow:function(_49a){
var last=this.overRow;
this.overRow=_49a;
if((last!=this.overRow)&&(lang.isString(last)||last>=0)){
this.updateStyles(last);
}
this.updateStyles(this.overRow);
},isOver:function(_49b){
return (this.overRow==_49b&&!_48f.contains(this.grid.domNode,"dojoxGridColumnResizing"));
}});
});
},"dijit/main":function(){
define(["dojo/_base/kernel"],function(dojo){
return dojo.dijit;
});
},"dijit/Destroyable":function(){
define(["dojo/_base/array","dojo/aspect","dojo/_base/declare"],function(_49c,_49d,_49e){
return _49e("dijit.Destroyable",null,{destroy:function(_49f){
this._destroyed=true;
},own:function(){
_49c.forEach(arguments,function(_4a0){
var _4a1="destroyRecursive" in _4a0?"destroyRecursive":"destroy" in _4a0?"destroy":"remove";
var odh=_49d.before(this,"destroy",function(_4a2){
_4a0[_4a1](_4a2);
});
var hdh=_49d.after(_4a0,_4a1,function(){
odh.remove();
hdh.remove();
},true);
},this);
return arguments;
}});
});
},"dojo/dnd/Container":function(){
define(["../_base/array","../_base/declare","../_base/event","../_base/kernel","../_base/lang","../_base/window","../dom","../dom-class","../dom-construct","../Evented","../has","../on","../query","../ready","../touch","./common"],function(_4a3,_4a4,_4a5,_4a6,lang,win,dom,_4a7,_4a8,_4a9,has,on,_4aa,_4ab,_4ac,dnd){
var _4ad=_4a4("dojo.dnd.Container",_4a9,{skipForm:false,allowNested:false,constructor:function(node,_4ae){
this.node=dom.byId(node);
if(!_4ae){
_4ae={};
}
this.creator=_4ae.creator||null;
this.skipForm=_4ae.skipForm;
this.parent=_4ae.dropParent&&dom.byId(_4ae.dropParent);
this.map={};
this.current=null;
this.containerState="";
_4a7.add(this.node,"dojoDndContainer");
if(!(_4ae&&_4ae._skipStartup)){
this.startup();
}
this.events=[on(this.node,_4ac.over,lang.hitch(this,"onMouseOver")),on(this.node,_4ac.out,lang.hitch(this,"onMouseOut")),on(this.node,"dragstart",lang.hitch(this,"onSelectStart")),on(this.node,"selectstart",lang.hitch(this,"onSelectStart"))];
},creator:function(){
},getItem:function(key){
return this.map[key];
},setItem:function(key,data){
this.map[key]=data;
},delItem:function(key){
delete this.map[key];
},forInItems:function(f,o){
o=o||_4a6.global;
var m=this.map,e=dnd._empty;
for(var i in m){
if(i in e){
continue;
}
f.call(o,m[i],i,this);
}
return o;
},clearItems:function(){
this.map={};
},getAllNodes:function(){
return _4aa((this.allowNested?"":"> ")+".dojoDndItem",this.parent);
},sync:function(){
var map={};
this.getAllNodes().forEach(function(node){
if(node.id){
var item=this.getItem(node.id);
if(item){
map[node.id]=item;
return;
}
}else{
node.id=dnd.getUniqueId();
}
var type=node.getAttribute("dndType"),data=node.getAttribute("dndData");
map[node.id]={data:data||node.innerHTML,type:type?type.split(/\s*,\s*/):["text"]};
},this);
this.map=map;
return this;
},insertNodes:function(data,_4af,_4b0){
if(!this.parent.firstChild){
_4b0=null;
}else{
if(_4af){
if(!_4b0){
_4b0=this.parent.firstChild;
}
}else{
if(_4b0){
_4b0=_4b0.nextSibling;
}
}
}
var i,t;
if(_4b0){
for(i=0;i<data.length;++i){
t=this._normalizedCreator(data[i]);
this.setItem(t.node.id,{data:t.data,type:t.type});
_4b0.parentNode.insertBefore(t.node,_4b0);
}
}else{
for(i=0;i<data.length;++i){
t=this._normalizedCreator(data[i]);
this.setItem(t.node.id,{data:t.data,type:t.type});
this.parent.appendChild(t.node);
}
}
return this;
},destroy:function(){
_4a3.forEach(this.events,function(_4b1){
_4b1.remove();
});
this.clearItems();
this.node=this.parent=this.current=null;
},markupFactory:function(_4b2,node,Ctor){
_4b2._skipStartup=true;
return new Ctor(node,_4b2);
},startup:function(){
if(!this.parent){
this.parent=this.node;
if(this.parent.tagName.toLowerCase()=="table"){
var c=this.parent.getElementsByTagName("tbody");
if(c&&c.length){
this.parent=c[0];
}
}
}
this.defaultCreator=dnd._defaultCreator(this.parent);
this.sync();
},onMouseOver:function(e){
var n=e.relatedTarget;
while(n){
if(n==this.node){
break;
}
try{
n=n.parentNode;
}
catch(x){
n=null;
}
}
if(!n){
this._changeState("Container","Over");
this.onOverEvent();
}
n=this._getChildByEvent(e);
if(this.current==n){
return;
}
if(this.current){
this._removeItemClass(this.current,"Over");
}
if(n){
this._addItemClass(n,"Over");
}
this.current=n;
},onMouseOut:function(e){
for(var n=e.relatedTarget;n;){
if(n==this.node){
return;
}
try{
n=n.parentNode;
}
catch(x){
n=null;
}
}
if(this.current){
this._removeItemClass(this.current,"Over");
this.current=null;
}
this._changeState("Container","");
this.onOutEvent();
},onSelectStart:function(e){
if(!this.skipForm||!dnd.isFormElement(e)){
_4a5.stop(e);
}
},onOverEvent:function(){
},onOutEvent:function(){
},_changeState:function(type,_4b3){
var _4b4="dojoDnd"+type;
var _4b5=type.toLowerCase()+"State";
_4a7.replace(this.node,_4b4+_4b3,_4b4+this[_4b5]);
this[_4b5]=_4b3;
},_addItemClass:function(node,type){
_4a7.add(node,"dojoDndItem"+type);
},_removeItemClass:function(node,type){
_4a7.remove(node,"dojoDndItem"+type);
},_getChildByEvent:function(e){
var node=e.target;
if(node){
for(var _4b6=node.parentNode;_4b6;node=_4b6,_4b6=node.parentNode){
if((_4b6==this.parent||this.allowNested)&&_4a7.contains(node,"dojoDndItem")){
return node;
}
}
}
return null;
},_normalizedCreator:function(item,hint){
var t=(this.creator||this.defaultCreator).call(this,item,hint);
if(!lang.isArray(t.type)){
t.type=["text"];
}
if(!t.node.id){
t.node.id=dnd.getUniqueId();
}
_4a7.add(t.node,"dojoDndItem");
return t;
}});
dnd._createNode=function(tag){
if(!tag){
return dnd._createSpan;
}
return function(text){
return _4a8.create(tag,{innerHTML:text});
};
};
dnd._createTrTd=function(text){
var tr=_4a8.create("tr");
_4a8.create("td",{innerHTML:text},tr);
return tr;
};
dnd._createSpan=function(text){
return _4a8.create("span",{innerHTML:text});
};
dnd._defaultCreatorNodes={ul:"li",ol:"li",div:"div",p:"div"};
dnd._defaultCreator=function(node){
var tag=node.tagName.toLowerCase();
var c=tag=="tbody"||tag=="thead"?dnd._createTrTd:dnd._createNode(dnd._defaultCreatorNodes[tag]);
return function(item,hint){
var _4b7=item&&lang.isObject(item),data,type,n;
if(_4b7&&item.tagName&&item.nodeType&&item.getAttribute){
data=item.getAttribute("dndData")||item.innerHTML;
type=item.getAttribute("dndType");
type=type?type.split(/\s*,\s*/):["text"];
n=item;
}else{
data=(_4b7&&item.data)?item.data:item;
type=(_4b7&&item.type)?item.type:["text"];
n=(hint=="avatar"?dnd._createSpan:c)(String(data));
}
if(!n.id){
n.id=dnd.getUniqueId();
}
return {node:n,data:data,type:type};
};
};
return _4ad;
});
},"url:dijit/templates/CheckedMenuItem.html":"<tr class=\"dijitReset dijitMenuItem\" data-dojo-attach-point=\"focusNode\" role=\"menuitemcheckbox\" tabIndex=\"-1\">\n\t<td class=\"dijitReset dijitMenuItemIconCell\" role=\"presentation\">\n\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitMenuItemIcon dijitCheckedMenuItemIcon\" data-dojo-attach-point=\"iconNode\"/>\n\t\t<span class=\"dijitCheckedMenuItemIconChar\">&#10003;</span>\n\t</td>\n\t<td class=\"dijitReset dijitMenuItemLabel\" colspan=\"2\" data-dojo-attach-point=\"containerNode,labelNode\"></td>\n\t<td class=\"dijitReset dijitMenuItemAccelKey\" style=\"display: none\" data-dojo-attach-point=\"accelKeyNode\"></td>\n\t<td class=\"dijitReset dijitMenuArrowCell\" role=\"presentation\">&#160;</td>\n</tr>\n","dojo/cache":function(){
define(["./_base/kernel","./text"],function(dojo){
return dojo.cache;
});
},"dojo/dnd/Manager":function(){
define(["../_base/array","../_base/declare","../_base/event","../_base/lang","../_base/window","../dom-class","../Evented","../has","../keys","../on","../topic","../touch","./common","./autoscroll","./Avatar"],function(_4b8,_4b9,_4ba,lang,win,_4bb,_4bc,has,keys,on,_4bd,_4be,dnd,_4bf,_4c0){
var _4c1=_4b9("dojo.dnd.Manager",[_4bc],{constructor:function(){
this.avatar=null;
this.source=null;
this.nodes=[];
this.copy=true;
this.target=null;
this.canDropFlag=false;
this.events=[];
},OFFSET_X:has("touch")?0:16,OFFSET_Y:has("touch")?-64:16,overSource:function(_4c2){
if(this.avatar){
this.target=(_4c2&&_4c2.targetState!="Disabled")?_4c2:null;
this.canDropFlag=Boolean(this.target);
this.avatar.update();
}
_4bd.publish("/dnd/source/over",_4c2);
},outSource:function(_4c3){
if(this.avatar){
if(this.target==_4c3){
this.target=null;
this.canDropFlag=false;
this.avatar.update();
_4bd.publish("/dnd/source/over",null);
}
}else{
_4bd.publish("/dnd/source/over",null);
}
},startDrag:function(_4c4,_4c5,copy){
_4bf.autoScrollStart(win.doc);
this.source=_4c4;
this.nodes=_4c5;
this.copy=Boolean(copy);
this.avatar=this.makeAvatar();
win.body().appendChild(this.avatar.node);
_4bd.publish("/dnd/start",_4c4,_4c5,this.copy);
this.events=[on(win.doc,_4be.move,lang.hitch(this,"onMouseMove")),on(win.doc,_4be.release,lang.hitch(this,"onMouseUp")),on(win.doc,"keydown",lang.hitch(this,"onKeyDown")),on(win.doc,"keyup",lang.hitch(this,"onKeyUp")),on(win.doc,"dragstart",_4ba.stop),on(win.body(),"selectstart",_4ba.stop)];
var c="dojoDnd"+(copy?"Copy":"Move");
_4bb.add(win.body(),c);
},canDrop:function(flag){
var _4c6=Boolean(this.target&&flag);
if(this.canDropFlag!=_4c6){
this.canDropFlag=_4c6;
this.avatar.update();
}
},stopDrag:function(){
_4bb.remove(win.body(),["dojoDndCopy","dojoDndMove"]);
_4b8.forEach(this.events,function(_4c7){
_4c7.remove();
});
this.events=[];
this.avatar.destroy();
this.avatar=null;
this.source=this.target=null;
this.nodes=[];
},makeAvatar:function(){
return new _4c0(this);
},updateAvatar:function(){
this.avatar.update();
},onMouseMove:function(e){
var a=this.avatar;
if(a){
_4bf.autoScrollNodes(e);
var s=a.node.style;
s.left=(e.pageX+this.OFFSET_X)+"px";
s.top=(e.pageY+this.OFFSET_Y)+"px";
var copy=Boolean(this.source.copyState(dnd.getCopyKeyState(e)));
if(this.copy!=copy){
this._setCopyStatus(copy);
}
}
if(has("touch")){
e.preventDefault();
}
},onMouseUp:function(e){
if(this.avatar){
if(this.target&&this.canDropFlag){
var copy=Boolean(this.source.copyState(dnd.getCopyKeyState(e)));
_4bd.publish("/dnd/drop/before",this.source,this.nodes,copy,this.target,e);
_4bd.publish("/dnd/drop",this.source,this.nodes,copy,this.target,e);
}else{
_4bd.publish("/dnd/cancel");
}
this.stopDrag();
}
},onKeyDown:function(e){
if(this.avatar){
switch(e.keyCode){
case keys.CTRL:
var copy=Boolean(this.source.copyState(true));
if(this.copy!=copy){
this._setCopyStatus(copy);
}
break;
case keys.ESCAPE:
_4bd.publish("/dnd/cancel");
this.stopDrag();
break;
}
}
},onKeyUp:function(e){
if(this.avatar&&e.keyCode==keys.CTRL){
var copy=Boolean(this.source.copyState(false));
if(this.copy!=copy){
this._setCopyStatus(copy);
}
}
},_setCopyStatus:function(copy){
this.copy=copy;
this.source._markDndStatus(this.copy);
this.updateAvatar();
_4bb.replace(win.body(),"dojoDnd"+(this.copy?"Copy":"Move"),"dojoDnd"+(this.copy?"Move":"Copy"));
}});
dnd._manager=null;
_4c1.manager=dnd.manager=function(){
if(!dnd._manager){
dnd._manager=new _4c1();
}
return dnd._manager;
};
return _4c1;
});
},"dojo/dnd/Avatar":function(){
define(["../_base/declare","../_base/window","../dom","../dom-attr","../dom-class","../dom-construct","../hccss","../query"],function(_4c8,win,dom,_4c9,_4ca,_4cb,has,_4cc){
return _4c8("dojo.dnd.Avatar",null,{constructor:function(_4cd){
this.manager=_4cd;
this.construct();
},construct:function(){
var a=_4cb.create("table",{"class":"dojoDndAvatar",style:{position:"absolute",zIndex:"1999",margin:"0px"}}),_4ce=this.manager.source,node,b=_4cb.create("tbody",null,a),tr=_4cb.create("tr",null,b),td=_4cb.create("td",null,tr),k=Math.min(5,this.manager.nodes.length),i=0;
if(has("highcontrast")){
_4cb.create("span",{id:"a11yIcon",innerHTML:this.manager.copy?"+":"<"},td);
}
_4cb.create("span",{innerHTML:_4ce.generateText?this._generateText():""},td);
_4c9.set(tr,{"class":"dojoDndAvatarHeader",style:{opacity:0.9}});
for(;i<k;++i){
if(_4ce.creator){
node=_4ce._normalizedCreator(_4ce.getItem(this.manager.nodes[i].id).data,"avatar").node;
}else{
node=this.manager.nodes[i].cloneNode(true);
if(node.tagName.toLowerCase()=="tr"){
var _4cf=_4cb.create("table"),_4d0=_4cb.create("tbody",null,_4cf);
_4d0.appendChild(node);
node=_4cf;
}
}
node.id="";
tr=_4cb.create("tr",null,b);
td=_4cb.create("td",null,tr);
td.appendChild(node);
_4c9.set(tr,{"class":"dojoDndAvatarItem",style:{opacity:(9-i)/10}});
}
this.node=a;
},destroy:function(){
_4cb.destroy(this.node);
this.node=false;
},update:function(){
_4ca.toggle(this.node,"dojoDndAvatarCanDrop",this.manager.canDropFlag);
if(has("highcontrast")){
var icon=dom.byId("a11yIcon");
var text="+";
if(this.manager.canDropFlag&&!this.manager.copy){
text="< ";
}else{
if(!this.manager.canDropFlag&&!this.manager.copy){
text="o";
}else{
if(!this.manager.canDropFlag){
text="x";
}
}
}
icon.innerHTML=text;
}
_4cc(("tr.dojoDndAvatarHeader td span"+(has("highcontrast")?" span":"")),this.node).forEach(function(node){
node.innerHTML=this.manager.source.generateText?this._generateText():"";
},this);
},_generateText:function(){
return this.manager.nodes.length.toString();
}});
});
},"dojox/grid/_SelectionPreserver":function(){
define("dojox/grid/_SelectionPreserver",["dojo/_base/declare","dojo/_base/connect","dojo/_base/lang","dojo/_base/array"],function(_4d1,_4d2,lang,_4d3){
return _4d1("dojox.grid._SelectionPreserver",null,{constructor:function(_4d4){
this.selection=_4d4;
var grid=this.grid=_4d4.grid;
this.reset();
this._connects=[_4d2.connect(grid,"_setStore",this,"reset"),_4d2.connect(grid,"_addItem",this,"_reSelectById"),_4d2.connect(_4d4,"onSelected",lang.hitch(this,"_selectById",true)),_4d2.connect(_4d4,"onDeselected",lang.hitch(this,"_selectById",false)),_4d2.connect(_4d4,"deselectAll",this,"reset")];
},destroy:function(){
this.reset();
_4d3.forEach(this._connects,_4d2.disconnect);
delete this._connects;
},reset:function(){
this._selectedById={};
},_reSelectById:function(item,_4d5){
if(item&&this.grid._hasIdentity){
this.selection.selected[_4d5]=this._selectedById[this.grid.store.getIdentity(item)];
}
},_selectById:function(_4d6,_4d7){
if(this.selection.mode=="none"||!this.grid._hasIdentity){
return;
}
var item=_4d7,g=this.grid;
if(typeof _4d7=="number"||typeof _4d7=="string"){
var _4d8=g._by_idx[_4d7];
item=_4d8&&_4d8.item;
}
if(item){
this._selectedById[g.store.getIdentity(item)]=!!_4d6;
}
return item;
}});
});
},"dojox/grid/_FocusManager":function(){
define("dojox/grid/_FocusManager",["dojo/_base/array","dojo/_base/lang","dojo/_base/declare","dojo/_base/connect","dojo/_base/event","dojo/_base/sniff","dojo/query","./util","dojo/_base/html"],function(_4d9,lang,_4da,_4db,_4dc,has,_4dd,util,html){
return _4da("dojox.grid._FocusManager",null,{constructor:function(_4de){
this.grid=_4de;
this.cell=null;
this.rowIndex=-1;
this._connects=[];
this._headerConnects=[];
this.headerMenu=this.grid.headerMenu;
this._connects.push(_4db.connect(this.grid.domNode,"onfocus",this,"doFocus"));
this._connects.push(_4db.connect(this.grid.domNode,"onblur",this,"doBlur"));
this._connects.push(_4db.connect(this.grid.domNode,"mousedown",this,"_mouseDown"));
this._connects.push(_4db.connect(this.grid.domNode,"mouseup",this,"_mouseUp"));
this._connects.push(_4db.connect(this.grid.domNode,"oncontextmenu",this,"doContextMenu"));
this._connects.push(_4db.connect(this.grid.lastFocusNode,"onfocus",this,"doLastNodeFocus"));
this._connects.push(_4db.connect(this.grid.lastFocusNode,"onblur",this,"doLastNodeBlur"));
this._connects.push(_4db.connect(this.grid,"_onFetchComplete",this,"_delayedCellFocus"));
this._connects.push(_4db.connect(this.grid,"postrender",this,"_delayedHeaderFocus"));
},destroy:function(){
_4d9.forEach(this._connects,_4db.disconnect);
_4d9.forEach(this._headerConnects,_4db.disconnect);
delete this.grid;
delete this.cell;
},_colHeadNode:null,_colHeadFocusIdx:null,_contextMenuBindNode:null,tabbingOut:false,focusClass:"dojoxGridCellFocus",focusView:null,initFocusView:function(){
this.focusView=this.grid.views.getFirstScrollingView()||this.focusView||this.grid.views.views[0];
this._initColumnHeaders();
},isFocusCell:function(_4df,_4e0){
return (this.cell==_4df)&&(this.rowIndex==_4e0);
},isLastFocusCell:function(){
if(this.cell){
return (this.rowIndex==this.grid.rowCount-1)&&(this.cell.index==this.grid.layout.cellCount-1);
}
return false;
},isFirstFocusCell:function(){
if(this.cell){
return (this.rowIndex===0)&&(this.cell.index===0);
}
return false;
},isNoFocusCell:function(){
return (this.rowIndex<0)||!this.cell;
},isNavHeader:function(){
return (!!this._colHeadNode);
},getHeaderIndex:function(){
if(this._colHeadNode){
return _4d9.indexOf(this._findHeaderCells(),this._colHeadNode);
}else{
return -1;
}
},_focusifyCellNode:function(_4e1){
var n=this.cell&&this.cell.getNode(this.rowIndex);
if(n){
html.toggleClass(n,this.focusClass,_4e1);
if(_4e1){
var sl=this.scrollIntoView();
try{
if(has("webkit")||!this.grid.edit.isEditing()){
util.fire(n,"focus");
if(sl){
this.cell.view.scrollboxNode.scrollLeft=sl;
}
}
}
catch(e){
}
}
}
},_delayedCellFocus:function(){
if(this.isNavHeader()||!this.grid.focused){
return;
}
var n=this.cell&&this.cell.getNode(this.rowIndex);
if(n){
try{
if(!this.grid.edit.isEditing()){
html.toggleClass(n,this.focusClass,true);
if(this._colHeadNode){
this.blurHeader();
}
util.fire(n,"focus");
}
}
catch(e){
}
}
},_delayedHeaderFocus:function(){
if(this.isNavHeader()){
this.focusHeader();
}
},_initColumnHeaders:function(){
_4d9.forEach(this._headerConnects,_4db.disconnect);
this._headerConnects=[];
var _4e2=this._findHeaderCells();
for(var i=0;i<_4e2.length;i++){
this._headerConnects.push(_4db.connect(_4e2[i],"onfocus",this,"doColHeaderFocus"));
this._headerConnects.push(_4db.connect(_4e2[i],"onblur",this,"doColHeaderBlur"));
}
},_findHeaderCells:function(){
var _4e3=_4dd("th",this.grid.viewsHeaderNode);
var _4e4=[];
for(var i=0;i<_4e3.length;i++){
var _4e5=_4e3[i];
var _4e6=html.hasAttr(_4e5,"tabIndex");
var _4e7=html.attr(_4e5,"tabIndex");
if(_4e6&&_4e7<0){
_4e4.push(_4e5);
}
}
return _4e4;
},_setActiveColHeader:function(_4e8,_4e9,_4ea){
this.grid.domNode.setAttribute("aria-activedescendant",_4e8.id);
if(_4ea!=null&&_4ea>=0&&_4ea!=_4e9){
html.toggleClass(this._findHeaderCells()[_4ea],this.focusClass,false);
}
html.toggleClass(_4e8,this.focusClass,true);
this._colHeadNode=_4e8;
this._colHeadFocusIdx=_4e9;
this._scrollHeader(this._colHeadFocusIdx);
},scrollIntoView:function(){
var info=(this.cell?this._scrollInfo(this.cell):null);
if(!info||!info.s){
return null;
}
var rt=this.grid.scroller.findScrollTop(this.rowIndex);
if(info.n&&info.sr){
if(info.n.offsetLeft+info.n.offsetWidth>info.sr.l+info.sr.w){
info.s.scrollLeft=info.n.offsetLeft+info.n.offsetWidth-info.sr.w;
}else{
if(info.n.offsetLeft<info.sr.l){
info.s.scrollLeft=info.n.offsetLeft;
}
}
}
if(info.r&&info.sr){
if(rt+info.r.offsetHeight>info.sr.t+info.sr.h){
this.grid.setScrollTop(rt+info.r.offsetHeight-info.sr.h);
}else{
if(rt<info.sr.t){
this.grid.setScrollTop(rt);
}
}
}
return info.s.scrollLeft;
},_scrollInfo:function(cell,_4eb){
if(cell){
var cl=cell,sbn=cl.view.scrollboxNode,sbnr={w:sbn.clientWidth,l:sbn.scrollLeft,t:sbn.scrollTop,h:sbn.clientHeight},rn=cl.view.getRowNode(this.rowIndex);
return {c:cl,s:sbn,sr:sbnr,n:(_4eb?_4eb:cell.getNode(this.rowIndex)),r:rn};
}
return null;
},_scrollHeader:function(_4ec){
var info=null;
if(this._colHeadNode){
var cell=this.grid.getCell(_4ec);
if(!cell){
return;
}
info=this._scrollInfo(cell,cell.getNode(0));
}
if(info&&info.s&&info.sr&&info.n){
var _4ed=info.sr.l+info.sr.w;
if(info.n.offsetLeft+info.n.offsetWidth>_4ed){
info.s.scrollLeft=info.n.offsetLeft+info.n.offsetWidth-info.sr.w;
}else{
if(info.n.offsetLeft<info.sr.l){
info.s.scrollLeft=info.n.offsetLeft;
}else{
if(has("ie")<=7&&cell&&cell.view.headerNode){
cell.view.headerNode.scrollLeft=info.s.scrollLeft;
}
}
}
}
},_isHeaderHidden:function(){
var _4ee=this.focusView;
if(!_4ee){
for(var i=0,_4ef;(_4ef=this.grid.views.views[i]);i++){
if(_4ef.headerNode){
_4ee=_4ef;
break;
}
}
}
return (_4ee&&html.getComputedStyle(_4ee.headerNode).display=="none");
},colSizeAdjust:function(e,_4f0,_4f1){
var _4f2=this._findHeaderCells();
var view=this.focusView;
if(!view||!view.header.tableMap.map){
for(var i=0,_4f3;(_4f3=this.grid.views.views[i]);i++){
if(_4f3.header.tableMap.map){
view=_4f3;
break;
}
}
}
var _4f4=_4f2[_4f0];
if(!view||(_4f0==_4f2.length-1&&_4f0===0)){
return;
}
view.content.baseDecorateEvent(e);
e.cellNode=_4f4;
e.cellIndex=view.content.getCellNodeIndex(e.cellNode);
e.cell=(e.cellIndex>=0?this.grid.getCell(e.cellIndex):null);
if(view.header.canResize(e)){
var _4f5={l:_4f1};
var drag=view.header.colResizeSetup(e,false);
view.header.doResizeColumn(drag,null,_4f5);
view.update();
}
},styleRow:function(_4f6){
return;
},setFocusIndex:function(_4f7,_4f8){
this.setFocusCell(this.grid.getCell(_4f8),_4f7);
},setFocusCell:function(_4f9,_4fa){
if(_4f9&&!this.isFocusCell(_4f9,_4fa)){
this.tabbingOut=false;
if(this._colHeadNode){
this.blurHeader();
}
this._colHeadNode=this._colHeadFocusIdx=null;
this.focusGridView();
this._focusifyCellNode(false);
this.cell=_4f9;
this.rowIndex=_4fa;
this._focusifyCellNode(true);
}
if(has("opera")){
setTimeout(lang.hitch(this.grid,"onCellFocus",this.cell,this.rowIndex),1);
}else{
this.grid.onCellFocus(this.cell,this.rowIndex);
}
},next:function(){
if(this.cell){
var row=this.rowIndex,col=this.cell.index+1,cc=this.grid.layout.cellCount-1,rc=this.grid.rowCount-1;
if(col>cc){
col=0;
row++;
}
if(row>rc){
col=cc;
row=rc;
}
if(this.grid.edit.isEditing()){
var _4fb=this.grid.getCell(col);
if(!this.isLastFocusCell()&&(!_4fb.editable||this.grid.canEdit&&!this.grid.canEdit(_4fb,row))){
this.cell=_4fb;
this.rowIndex=row;
this.next();
return;
}
}
this.setFocusIndex(row,col);
}
},previous:function(){
if(this.cell){
var row=(this.rowIndex||0),col=(this.cell.index||0)-1;
if(col<0){
col=this.grid.layout.cellCount-1;
row--;
}
if(row<0){
row=0;
col=0;
}
if(this.grid.edit.isEditing()){
var _4fc=this.grid.getCell(col);
if(!this.isFirstFocusCell()&&!_4fc.editable){
this.cell=_4fc;
this.rowIndex=row;
this.previous();
return;
}
}
this.setFocusIndex(row,col);
}
},move:function(_4fd,_4fe){
var _4ff=_4fe<0?-1:1;
if(this.isNavHeader()){
var _500=this._findHeaderCells();
var _501=currentIdx=_4d9.indexOf(_500,this._colHeadNode);
currentIdx+=_4fe;
while(currentIdx>=0&&currentIdx<_500.length&&_500[currentIdx].style.display=="none"){
currentIdx+=_4ff;
}
if((currentIdx>=0)&&(currentIdx<_500.length)){
this._setActiveColHeader(_500[currentIdx],currentIdx,_501);
}
}else{
if(this.cell){
var sc=this.grid.scroller,r=this.rowIndex,rc=this.grid.rowCount-1,row=Math.min(rc,Math.max(0,r+_4fd));
if(_4fd){
if(_4fd>0){
if(row>sc.getLastPageRow(sc.page)){
this.grid.setScrollTop(this.grid.scrollTop+sc.findScrollTop(row)-sc.findScrollTop(r));
}
}else{
if(_4fd<0){
if(row<=sc.getPageRow(sc.page)){
this.grid.setScrollTop(this.grid.scrollTop-sc.findScrollTop(r)-sc.findScrollTop(row));
}
}
}
}
var cc=this.grid.layout.cellCount-1,i=this.cell.index,col=Math.min(cc,Math.max(0,i+_4fe));
var cell=this.grid.getCell(col);
while(col>=0&&col<cc&&cell&&cell.hidden===true){
col+=_4ff;
cell=this.grid.getCell(col);
}
if(!cell||cell.hidden===true){
col=i;
}
var n=cell.getNode(row);
if(!n&&_4fd){
if((row+_4fd)>=0&&(row+_4fd)<=rc){
this.move(_4fd>0?++_4fd:--_4fd,_4fe);
}
return;
}else{
if((!n||html.style(n,"display")==="none")&&_4fe){
if((col+_4fe)>=0&&(col+_4fe)<=cc){
this.move(_4fd,_4fe>0?++_4fe:--_4fe);
}
return;
}
}
this.setFocusIndex(row,col);
if(_4fd){
this.grid.updateRow(r);
}
}
}
},previousKey:function(e){
if(this.grid.edit.isEditing()){
_4dc.stop(e);
this.previous();
}else{
if(!this.isNavHeader()&&!this._isHeaderHidden()){
this.grid.domNode.focus();
_4dc.stop(e);
}else{
this.tabOut(this.grid.domNode);
if(this._colHeadFocusIdx!=null){
html.toggleClass(this._findHeaderCells()[this._colHeadFocusIdx],this.focusClass,false);
this._colHeadFocusIdx=null;
}
this._focusifyCellNode(false);
}
}
},nextKey:function(e){
var _502=(this.grid.rowCount===0);
if(e.target===this.grid.domNode&&this._colHeadFocusIdx==null){
this.focusHeader();
_4dc.stop(e);
}else{
if(this.isNavHeader()){
this.blurHeader();
if(!this.findAndFocusGridCell()){
this.tabOut(this.grid.lastFocusNode);
}
this._colHeadNode=this._colHeadFocusIdx=null;
}else{
if(this.grid.edit.isEditing()){
_4dc.stop(e);
this.next();
}else{
this.tabOut(this.grid.lastFocusNode);
}
}
}
},tabOut:function(_503){
this.tabbingOut=true;
_503.focus();
},focusGridView:function(){
util.fire(this.focusView,"focus");
},focusGrid:function(_504){
this.focusGridView();
this._focusifyCellNode(true);
},findAndFocusGridCell:function(){
var _505=true;
var _506=(this.grid.rowCount===0);
if(this.isNoFocusCell()&&!_506){
var _507=0;
var cell=this.grid.getCell(_507);
if(cell.hidden){
_507=this.isNavHeader()?this._colHeadFocusIdx:0;
}
this.setFocusIndex(0,_507);
}else{
if(this.cell&&!_506){
if(this.focusView&&!this.focusView.rowNodes[this.rowIndex]){
this.grid.scrollToRow(this.rowIndex);
}
this.focusGrid();
}else{
_505=false;
}
}
this._colHeadNode=this._colHeadFocusIdx=null;
return _505;
},focusHeader:function(){
var _508=this._findHeaderCells();
var _509=this._colHeadFocusIdx;
if(this._isHeaderHidden()){
this.findAndFocusGridCell();
}else{
if(!this._colHeadFocusIdx){
if(this.isNoFocusCell()){
this._colHeadFocusIdx=0;
}else{
this._colHeadFocusIdx=this.cell.index;
}
}
}
this._colHeadNode=_508[this._colHeadFocusIdx];
while(this._colHeadNode&&this._colHeadFocusIdx>=0&&this._colHeadFocusIdx<_508.length&&this._colHeadNode.style.display=="none"){
this._colHeadFocusIdx++;
this._colHeadNode=_508[this._colHeadFocusIdx];
}
if(this._colHeadNode&&this._colHeadNode.style.display!="none"){
if(this.headerMenu&&this._contextMenuBindNode!=this.grid.domNode){
this.headerMenu.unBindDomNode(this.grid.viewsHeaderNode);
this.headerMenu.bindDomNode(this.grid.domNode);
this._contextMenuBindNode=this.grid.domNode;
}
this._setActiveColHeader(this._colHeadNode,this._colHeadFocusIdx,_509);
this._scrollHeader(this._colHeadFocusIdx);
this._focusifyCellNode(false);
}else{
this.findAndFocusGridCell();
}
},blurHeader:function(){
html.removeClass(this._colHeadNode,this.focusClass);
html.removeAttr(this.grid.domNode,"aria-activedescendant");
if(this.headerMenu&&this._contextMenuBindNode==this.grid.domNode){
var _50a=this.grid.viewsHeaderNode;
this.headerMenu.unBindDomNode(this.grid.domNode);
this.headerMenu.bindDomNode(_50a);
this._contextMenuBindNode=_50a;
}
},doFocus:function(e){
if(e&&e.target!=e.currentTarget){
_4dc.stop(e);
return;
}
if(this._clickFocus){
return;
}
if(!this.tabbingOut){
this.focusHeader();
}
this.tabbingOut=false;
_4dc.stop(e);
},doBlur:function(e){
_4dc.stop(e);
},doContextMenu:function(e){
if(!this.headerMenu){
_4dc.stop(e);
}
},doLastNodeFocus:function(e){
if(this.tabbingOut){
this._focusifyCellNode(false);
}else{
if(this.grid.rowCount>0){
if(this.isNoFocusCell()){
this.setFocusIndex(0,0);
}
this._focusifyCellNode(true);
}else{
this.focusHeader();
}
}
this.tabbingOut=false;
_4dc.stop(e);
},doLastNodeBlur:function(e){
_4dc.stop(e);
},doColHeaderFocus:function(e){
this._setActiveColHeader(e.target,html.attr(e.target,"idx"),this._colHeadFocusIdx);
this._scrollHeader(this.getHeaderIndex());
_4dc.stop(e);
},doColHeaderBlur:function(e){
html.toggleClass(e.target,this.focusClass,false);
},_mouseDown:function(e){
this._clickFocus=dojo.some(this.grid.views.views,function(v){
return v.scrollboxNode===e.target;
});
},_mouseUp:function(e){
this._clickFocus=false;
}});
});
},"dojox/grid/_Events":function(){
define("dojox/grid/_Events",["dojo/keys","dojo/dom-class","dojo/_base/declare","dojo/_base/event","dojo/_base/sniff"],function(keys,_50b,_50c,_50d,has){
return _50c("dojox.grid._Events",null,{cellOverClass:"dojoxGridCellOver",onKeyEvent:function(e){
this.dispatchKeyEvent(e);
},onContentEvent:function(e){
this.dispatchContentEvent(e);
},onHeaderEvent:function(e){
this.dispatchHeaderEvent(e);
},onStyleRow:function(_50e){
var i=_50e;
i.customClasses+=(i.odd?" dojoxGridRowOdd":"")+(i.selected?" dojoxGridRowSelected":"")+(i.over?" dojoxGridRowOver":"");
this.focus.styleRow(_50e);
this.edit.styleRow(_50e);
},onKeyDown:function(e){
if(e.altKey||e.metaKey){
return;
}
var _50f;
switch(e.keyCode){
case keys.ESCAPE:
this.edit.cancel();
break;
case keys.ENTER:
if(!this.edit.isEditing()){
_50f=this.focus.getHeaderIndex();
if(_50f>=0){
this.setSortIndex(_50f);
break;
}else{
this.selection.clickSelect(this.focus.rowIndex,dojo.isCopyKey(e),e.shiftKey);
}
_50d.stop(e);
}
if(!e.shiftKey){
var _510=this.edit.isEditing();
this.edit.apply();
if(!_510){
this.edit.setEditCell(this.focus.cell,this.focus.rowIndex);
}
}
if(!this.edit.isEditing()){
var _511=this.focus.focusView||this.views.views[0];
_511.content.decorateEvent(e);
this.onRowClick(e);
_50d.stop(e);
}
break;
case keys.SPACE:
if(!this.edit.isEditing()){
_50f=this.focus.getHeaderIndex();
if(_50f>=0){
this.setSortIndex(_50f);
break;
}else{
this.selection.clickSelect(this.focus.rowIndex,dojo.isCopyKey(e),e.shiftKey);
}
_50d.stop(e);
}
break;
case keys.TAB:
this.focus[e.shiftKey?"previousKey":"nextKey"](e);
break;
case keys.LEFT_ARROW:
case keys.RIGHT_ARROW:
if(!this.edit.isEditing()){
var _512=e.keyCode;
_50d.stop(e);
_50f=this.focus.getHeaderIndex();
if(_50f>=0&&(e.shiftKey&&e.ctrlKey)){
this.focus.colSizeAdjust(e,_50f,(_512==keys.LEFT_ARROW?-1:1)*5);
}else{
var _513=(_512==keys.LEFT_ARROW)?1:-1;
if(this.isLeftToRight()){
_513*=-1;
}
this.focus.move(0,_513);
}
}
break;
case keys.UP_ARROW:
if(!this.edit.isEditing()&&this.focus.rowIndex!==0){
_50d.stop(e);
this.focus.move(-1,0);
}
break;
case keys.DOWN_ARROW:
if(!this.edit.isEditing()&&this.focus.rowIndex+1!=this.rowCount){
_50d.stop(e);
this.focus.move(1,0);
}
break;
case keys.PAGE_UP:
if(!this.edit.isEditing()&&this.focus.rowIndex!==0){
_50d.stop(e);
if(this.focus.rowIndex!=this.scroller.firstVisibleRow+1){
this.focus.move(this.scroller.firstVisibleRow-this.focus.rowIndex,0);
}else{
this.setScrollTop(this.scroller.findScrollTop(this.focus.rowIndex-1));
this.focus.move(this.scroller.firstVisibleRow-this.scroller.lastVisibleRow+1,0);
}
}
break;
case keys.PAGE_DOWN:
if(!this.edit.isEditing()&&this.focus.rowIndex+1!=this.rowCount){
_50d.stop(e);
if(this.focus.rowIndex!=this.scroller.lastVisibleRow-1){
this.focus.move(this.scroller.lastVisibleRow-this.focus.rowIndex-1,0);
}else{
this.setScrollTop(this.scroller.findScrollTop(this.focus.rowIndex+1));
this.focus.move(this.scroller.lastVisibleRow-this.scroller.firstVisibleRow-1,0);
}
}
break;
default:
break;
}
},onMouseOver:function(e){
e.rowIndex==-1?this.onHeaderCellMouseOver(e):this.onCellMouseOver(e);
},onMouseOut:function(e){
e.rowIndex==-1?this.onHeaderCellMouseOut(e):this.onCellMouseOut(e);
},onMouseDown:function(e){
e.rowIndex==-1?this.onHeaderCellMouseDown(e):this.onCellMouseDown(e);
},onMouseOverRow:function(e){
if(!this.rows.isOver(e.rowIndex)){
this.rows.setOverRow(e.rowIndex);
e.rowIndex==-1?this.onHeaderMouseOver(e):this.onRowMouseOver(e);
}
},onMouseOutRow:function(e){
if(this.rows.isOver(-1)){
this.onHeaderMouseOut(e);
}else{
if(!this.rows.isOver(-2)){
this.rows.setOverRow(-2);
this.onRowMouseOut(e);
}
}
},onMouseDownRow:function(e){
if(e.rowIndex!=-1){
this.onRowMouseDown(e);
}
},onCellMouseOver:function(e){
if(e.cellNode){
_50b.add(e.cellNode,this.cellOverClass);
}
},onCellMouseOut:function(e){
if(e.cellNode){
_50b.remove(e.cellNode,this.cellOverClass);
}
},onCellMouseDown:function(e){
},onCellClick:function(e){
this._click[0]=this._click[1];
this._click[1]=e;
if(!this.edit.isEditCell(e.rowIndex,e.cellIndex)){
this.focus.setFocusCell(e.cell,e.rowIndex);
}
if(this._click.length>1&&this._click[0]==null){
this._click.shift();
}
this.onRowClick(e);
},onCellDblClick:function(e){
var _514;
if(this._click.length>1&&has("ie")){
_514=this._click[1];
}else{
if(this._click.length>1&&this._click[0].rowIndex!=this._click[1].rowIndex){
_514=this._click[0];
}else{
_514=e;
}
}
this.focus.setFocusCell(_514.cell,_514.rowIndex);
this.onRowClick(_514);
this.edit.setEditCell(_514.cell,_514.rowIndex);
this.onRowDblClick(e);
},onCellContextMenu:function(e){
this.onRowContextMenu(e);
},onCellFocus:function(_515,_516){
this.edit.cellFocus(_515,_516);
},onRowClick:function(e){
this.edit.rowClick(e);
this.selection.clickSelectEvent(e);
},onRowDblClick:function(e){
},onRowMouseOver:function(e){
},onRowMouseOut:function(e){
},onRowMouseDown:function(e){
},onRowContextMenu:function(e){
_50d.stop(e);
},onHeaderMouseOver:function(e){
},onHeaderMouseOut:function(e){
},onHeaderCellMouseOver:function(e){
if(e.cellNode){
_50b.add(e.cellNode,this.cellOverClass);
}
},onHeaderCellMouseOut:function(e){
if(e.cellNode){
_50b.remove(e.cellNode,this.cellOverClass);
}
},onHeaderCellMouseDown:function(e){
},onHeaderClick:function(e){
},onHeaderCellClick:function(e){
this.setSortIndex(e.cell.index);
this.onHeaderClick(e);
},onHeaderDblClick:function(e){
},onHeaderCellDblClick:function(e){
this.onHeaderDblClick(e);
},onHeaderCellContextMenu:function(e){
this.onHeaderContextMenu(e);
},onHeaderContextMenu:function(e){
if(!this.headerMenu){
_50d.stop(e);
}
},onStartEdit:function(_517,_518){
},onApplyCellEdit:function(_519,_51a,_51b){
},onCancelEdit:function(_51c){
},onApplyEdit:function(_51d){
},onCanSelect:function(_51e){
return true;
},onCanDeselect:function(_51f){
return true;
},onSelected:function(_520){
this.updateRowStyles(_520);
},onDeselected:function(_521){
this.updateRowStyles(_521);
},onSelectionChanged:function(){
}});
});
},"dijit/MenuItem":function(){
define(["dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/_base/kernel","dojo/sniff","./_Widget","./_TemplatedMixin","./_Contained","./_CssStateMixin","dojo/text!./templates/MenuItem.html"],function(_522,dom,_523,_524,_525,has,_526,_527,_528,_529,_52a){
return _522("dijit.MenuItem",[_526,_527,_528,_529],{templateString:_52a,baseClass:"dijitMenuItem",label:"",_setLabelAttr:function(val){
this.containerNode.innerHTML=val;
this._set("label",val);
if(this.textDir==="auto"){
this.applyTextDir(this.focusNode,this.label);
}
},iconClass:"dijitNoIcon",_setIconClassAttr:{node:"iconNode",type:"class"},accelKey:"",disabled:false,_fillContent:function(_52b){
if(_52b&&!("label" in this.params)){
this.set("label",_52b.innerHTML);
}
},buildRendering:function(){
this.inherited(arguments);
var _52c=this.id+"_text";
_523.set(this.containerNode,"id",_52c);
if(this.accelKeyNode){
_523.set(this.accelKeyNode,"id",this.id+"_accel");
_52c+=" "+this.id+"_accel";
}
this.domNode.setAttribute("aria-labelledby",_52c);
dom.setSelectable(this.domNode,false);
},onClick:function(){
},focus:function(){
try{
if(has("ie")==8){
this.containerNode.focus();
}
this.focusNode.focus();
}
catch(e){
}
},_onFocus:function(){
this._setSelected(true);
this.getParent()._onItemFocus(this);
this.inherited(arguments);
},_setSelected:function(_52d){
_524.toggle(this.domNode,"dijitMenuItemSelected",_52d);
},setLabel:function(_52e){
_525.deprecated("dijit.MenuItem.setLabel() is deprecated.  Use set('label', ...) instead.","","2.0");
this.set("label",_52e);
},setDisabled:function(_52f){
_525.deprecated("dijit.Menu.setDisabled() is deprecated.  Use set('disabled', bool) instead.","","2.0");
this.set("disabled",_52f);
},_setDisabledAttr:function(_530){
this.focusNode.setAttribute("aria-disabled",_530?"true":"false");
this._set("disabled",_530);
},_setAccelKeyAttr:function(_531){
this.accelKeyNode.style.display=_531?"":"none";
this.accelKeyNode.innerHTML=_531;
_523.set(this.containerNode,"colSpan",_531?"1":"2");
this._set("accelKey",_531);
},_setTextDirAttr:function(_532){
if(!this._created||this.textDir!=_532){
this._set("textDir",_532);
this.applyTextDir(this.focusNode,this.label);
}
}});
});
},"dojox/grid/_RowSelector":function(){
define(["dojo/_base/declare","./_View"],function(_533,_534){
return _533("dojox.grid._RowSelector",_534,{defaultWidth:"2em",noscroll:true,padBorderWidth:2,buildRendering:function(){
this.inherited("buildRendering",arguments);
this.scrollboxNode.style.overflow="hidden";
this.headerNode.style.visibility="hidden";
},getWidth:function(){
return this.viewWidth||this.defaultWidth;
},buildRowContent:function(_535,_536){
var w=this.contentWidth||0;
_536.innerHTML="<table class=\"dojoxGridRowbarTable\" style=\"width:"+w+"px;height:1px;\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" role=\"presentation\"><tr><td class=\"dojoxGridRowbarInner\">&nbsp;</td></tr></table>";
},renderHeader:function(){
},updateRow:function(){
},resize:function(){
this.adaptHeight();
},adaptWidth:function(){
if(!("contentWidth" in this)&&this.contentNode&&this.contentNode.offsetWidth>0){
this.contentWidth=this.contentNode.offsetWidth-this.padBorderWidth;
}
},doStyleRowNode:function(_537,_538){
var n=["dojoxGridRowbar dojoxGridNonNormalizedCell"];
if(this.grid.rows.isOver(_537)){
n.push("dojoxGridRowbarOver");
}
if(this.grid.selection.isSelected(_537)){
n.push("dojoxGridRowbarSelected");
}
_538.className=n.join(" ");
},domouseover:function(e){
this.grid.onMouseOverRow(e);
},domouseout:function(e){
if(!this.isIntraRowEvent(e)){
this.grid.onMouseOutRow(e);
}
}});
});
},"*now":function(r){
r(["dojo/i18n!*preload*dojox/grid/nls/DataGrid*[\"ar\",\"ca\",\"cs\",\"da\",\"de\",\"el\",\"en-gb\",\"en-us\",\"es-es\",\"fi-fi\",\"fr-fr\",\"he-il\",\"hu\",\"it-it\",\"ja-jp\",\"ko-kr\",\"nl-nl\",\"nb\",\"pl\",\"pt-br\",\"pt-pt\",\"ru\",\"sk\",\"sl\",\"sv\",\"th\",\"tr\",\"zh-tw\",\"zh-cn\",\"ROOT\"]"]);
}}});
define("dojox/grid/DataGrid",["../main","dojo/_base/array","dojo/_base/lang","dojo/_base/json","dojo/_base/sniff","dojo/_base/declare","./_Grid","./DataSelection","dojo/_base/html"],function(_539,_53a,lang,json,has,_53b,_53c,_53d,html){
var _53e=_53b("dojox.grid.DataGrid",_53c,{store:null,query:null,queryOptions:null,fetchText:"...",sortFields:null,updateDelay:1,items:null,_store_connects:null,_by_idty:null,_by_idx:null,_cache:null,_pages:null,_pending_requests:null,_bop:-1,_eop:-1,_requests:0,rowCount:0,_isLoaded:false,_isLoading:false,keepSelection:false,postCreate:function(){
this._pages=[];
this._store_connects=[];
this._by_idty={};
this._by_idx=[];
this._cache=[];
this._pending_requests={};
this._setStore(this.store);
this.inherited(arguments);
},destroy:function(){
this.selection.destroy();
this.inherited(arguments);
},createSelection:function(){
this.selection=new _53d(this);
},get:function(_53f,_540){
if(_540&&this.field=="_item"&&!this.fields){
return _540;
}else{
if(_540&&this.fields){
var ret=[];
var s=this.grid.store;
_53a.forEach(this.fields,function(f){
ret=ret.concat(s.getValues(_540,f));
});
return ret;
}else{
if(!_540&&typeof _53f==="string"){
return this.inherited(arguments);
}
}
}
return (!_540?this.defaultValue:(!this.field?this.value:(this.field=="_item"?_540:this.grid.store.getValue(_540,this.field))));
},_checkUpdateStatus:function(){
if(this.updateDelay>0){
var _541=false;
if(this._endUpdateDelay){
clearTimeout(this._endUpdateDelay);
delete this._endUpdateDelay;
_541=true;
}
if(!this.updating){
this.beginUpdate();
_541=true;
}
if(_541){
var _542=this;
this._endUpdateDelay=setTimeout(function(){
delete _542._endUpdateDelay;
_542.endUpdate();
},this.updateDelay);
}
}
},_onSet:function(item,_543,_544,_545){
this._checkUpdateStatus();
var idx=this.getItemIndex(item);
if(idx>-1){
this.updateRow(idx);
}
},_createItem:function(item,_546){
var idty=this._hasIdentity?this.store.getIdentity(item):json.toJson(this.query)+":idx:"+_546+":sort:"+json.toJson(this.getSortProps());
var o=this._by_idty[idty]={idty:idty,item:item};
return o;
},_addItem:function(item,_547,_548){
this._by_idx[_547]=this._createItem(item,_547);
if(!_548){
this.updateRow(_547);
}
},_onNew:function(item,_549){
this._checkUpdateStatus();
var _54a=this.get("rowCount");
this._addingItem=true;
this.updateRowCount(_54a+1);
this._addingItem=false;
this._addItem(item,_54a);
this.showMessage();
},_onDelete:function(item){
this._checkUpdateStatus();
var idx=this._getItemIndex(item,true);
if(idx>=0){
this._pages=[];
this._bop=-1;
this._eop=-1;
var o=this._by_idx[idx];
this._by_idx.splice(idx,1);
delete this._by_idty[o.idty];
this.updateRowCount(this.get("rowCount")-1);
if(this.get("rowCount")===0){
this.showMessage(this.noDataMessage);
}
}
if(this.selection.isSelected(idx)){
this.selection.deselect(idx);
this.selection.selected.splice(idx,1);
}
},_onRevert:function(){
this._refresh();
},setStore:function(_54b,_54c,_54d){
if(this._requestsPending(0)){
return;
}
this._setQuery(_54c,_54d);
this._setStore(_54b);
this._refresh(true);
},setQuery:function(_54e,_54f){
if(this._requestsPending(0)){
return;
}
this._setQuery(_54e,_54f);
this._refresh(true);
},setItems:function(_550){
this.items=_550;
this._setStore(this.store);
this._refresh(true);
},_setQuery:function(_551,_552){
this.query=_551;
this.queryOptions=_552||this.queryOptions;
},_setStore:function(_553){
if(this.store&&this._store_connects){
_53a.forEach(this._store_connects,this.disconnect,this);
}
this.store=_553;
if(this.store){
var f=this.store.getFeatures();
var h=[];
this._canEdit=!!f["dojo.data.api.Write"]&&!!f["dojo.data.api.Identity"];
this._hasIdentity=!!f["dojo.data.api.Identity"];
if(!!f["dojo.data.api.Notification"]&&!this.items){
h.push(this.connect(this.store,"onSet","_onSet"));
h.push(this.connect(this.store,"onNew","_onNew"));
h.push(this.connect(this.store,"onDelete","_onDelete"));
}
if(this._canEdit){
h.push(this.connect(this.store,"revert","_onRevert"));
}
this._store_connects=h;
}
},_onFetchBegin:function(size,req){
if(!this.scroller){
return;
}
if(this.rowCount!=size){
if(req.isRender){
this.scroller.init(size,this.keepRows,this.rowsPerPage);
this.rowCount=size;
this._setAutoHeightAttr(this.autoHeight,true);
this._skipRowRenormalize=true;
this.prerender();
this._skipRowRenormalize=false;
}else{
this.updateRowCount(size);
}
}
if(!size){
this.views.render();
this._resize();
this.showMessage(this.noDataMessage);
this.focus.initFocusView();
}else{
this.showMessage();
}
},_onFetchComplete:function(_554,req){
if(!this.scroller){
return;
}
if(_554&&_554.length>0){
_53a.forEach(_554,function(item,idx){
this._addItem(item,req.start+idx,true);
},this);
this.updateRows(req.start,_554.length);
if(req.isRender){
this.setScrollTop(0);
this.postrender();
}else{
if(this._lastScrollTop){
this.setScrollTop(this._lastScrollTop);
}
}
if(has("ie")){
html.setSelectable(this.domNode,this.selectable);
}
}
delete this._lastScrollTop;
if(!this._isLoaded){
this._isLoading=false;
this._isLoaded=true;
}
this._pending_requests[req.start]=false;
},_onFetchError:function(err,req){
delete this._lastScrollTop;
if(!this._isLoaded){
this._isLoading=false;
this._isLoaded=true;
this.showMessage(this.errorMessage);
}
this._pending_requests[req.start]=false;
this.onFetchError(err,req);
},onFetchError:function(err,req){
},_fetch:function(_555,_556){
_555=_555||0;
if(this.store&&!this._pending_requests[_555]){
if(!this._isLoaded&&!this._isLoading){
this._isLoading=true;
this.showMessage(this.loadingMessage);
}
this._pending_requests[_555]=true;
try{
if(this.items){
var _557=this.items;
var _558=this.store;
this.rowsPerPage=_557.length;
var req={start:_555,count:this.rowsPerPage,isRender:_556};
this._onFetchBegin(_557.length,req);
var _559=0;
_53a.forEach(_557,function(i){
if(!_558.isItemLoaded(i)){
_559++;
}
});
if(_559===0){
this._onFetchComplete(_557,req);
}else{
var _55a=function(item){
_559--;
if(_559===0){
this._onFetchComplete(_557,req);
}
};
_53a.forEach(_557,function(i){
if(!_558.isItemLoaded(i)){
_558.loadItem({item:i,onItem:_55a,scope:this});
}
},this);
}
}else{
this.store.fetch({start:_555,count:this.rowsPerPage,query:this.query,sort:this.getSortProps(),queryOptions:this.queryOptions,isRender:_556,onBegin:lang.hitch(this,"_onFetchBegin"),onComplete:lang.hitch(this,"_onFetchComplete"),onError:lang.hitch(this,"_onFetchError")});
}
}
catch(e){
this._onFetchError(e,{start:_555,count:this.rowsPerPage});
}
}
},_clearData:function(){
this.updateRowCount(0);
this._by_idty={};
this._by_idx=[];
this._pages=[];
this._bop=this._eop=-1;
this._isLoaded=false;
this._isLoading=false;
},getItem:function(idx){
var data=this._by_idx[idx];
if(!data||(data&&!data.item)){
this._preparePage(idx);
return null;
}
return data.item;
},getItemIndex:function(item){
return this._getItemIndex(item,false);
},_getItemIndex:function(item,_55b){
if(!_55b&&!this.store.isItem(item)){
return -1;
}
var idty=this._hasIdentity?this.store.getIdentity(item):null;
for(var i=0,l=this._by_idx.length;i<l;i++){
var d=this._by_idx[i];
if(d&&((idty&&d.idty==idty)||(d.item===item))){
return i;
}
}
return -1;
},filter:function(_55c,_55d){
this.query=_55c;
if(_55d){
this._clearData();
}
this._fetch();
},_getItemAttr:function(idx,attr){
var item=this.getItem(idx);
return (!item?this.fetchText:this.store.getValue(item,attr));
},_render:function(){
if(this.domNode.parentNode){
this.scroller.init(this.get("rowCount"),this.keepRows,this.rowsPerPage);
this.prerender();
this._fetch(0,true);
}
},_requestsPending:function(_55e){
return this._pending_requests[_55e];
},_rowToPage:function(_55f){
return (this.rowsPerPage?Math.floor(_55f/this.rowsPerPage):_55f);
},_pageToRow:function(_560){
return (this.rowsPerPage?this.rowsPerPage*_560:_560);
},_preparePage:function(_561){
if((_561<this._bop||_561>=this._eop)&&!this._addingItem){
var _562=this._rowToPage(_561);
this._needPage(_562);
this._bop=_562*this.rowsPerPage;
this._eop=this._bop+(this.rowsPerPage||this.get("rowCount"));
}
},_needPage:function(_563){
if(!this._pages[_563]){
this._pages[_563]=true;
this._requestPage(_563);
}
},_requestPage:function(_564){
var row=this._pageToRow(_564);
var _565=Math.min(this.rowsPerPage,this.get("rowCount")-row);
if(_565>0){
this._requests++;
if(!this._requestsPending(row)){
setTimeout(lang.hitch(this,"_fetch",row,false),1);
}
}
},getCellName:function(_566){
return _566.field;
},_refresh:function(_567){
this._clearData();
this._fetch(0,_567);
},sort:function(){
this.edit.apply();
this._lastScrollTop=this.scrollTop;
this._refresh();
},canSort:function(){
return (!this._isLoading);
},getSortProps:function(){
var c=this.getCell(this.getSortIndex());
if(!c){
if(this.sortFields){
return this.sortFields;
}
return null;
}else{
var desc=c["sortDesc"];
var si=!(this.sortInfo>0);
if(typeof desc=="undefined"){
desc=si;
}else{
desc=si?!desc:desc;
}
return [{attribute:c.field,descending:desc}];
}
},styleRowState:function(_568){
if(this.store&&this.store.getState){
var _569=this.store.getState(_568.index),c="";
for(var i=0,ss=["inflight","error","inserting"],s;s=ss[i];i++){
if(_569[s]){
c=" dojoxGridRow-"+s;
break;
}
}
_568.customClasses+=c;
}
},onStyleRow:function(_56a){
this.styleRowState(_56a);
this.inherited(arguments);
},canEdit:function(_56b,_56c){
return this._canEdit;
},_copyAttr:function(idx,attr){
var row={};
var _56d={};
var src=this.getItem(idx);
return this.store.getValue(src,attr);
},doStartEdit:function(_56e,_56f){
if(!this._cache[_56f]){
this._cache[_56f]=this._copyAttr(_56f,_56e.field);
}
this.onStartEdit(_56e,_56f);
},doApplyCellEdit:function(_570,_571,_572){
this.store.fetchItemByIdentity({identity:this._by_idx[_571].idty,onItem:lang.hitch(this,function(item){
var _573=this.store.getValue(item,_572);
if(typeof _573=="number"){
_570=isNaN(_570)?_570:parseFloat(_570);
}else{
if(typeof _573=="boolean"){
_570=_570=="true"?true:_570=="false"?false:_570;
}else{
if(_573 instanceof Date){
var _574=new Date(_570);
_570=isNaN(_574.getTime())?_570:_574;
}
}
}
this.store.setValue(item,_572,_570);
this.onApplyCellEdit(_570,_571,_572);
})});
},doCancelEdit:function(_575){
var _576=this._cache[_575];
if(_576){
this.updateRow(_575);
delete this._cache[_575];
}
this.onCancelEdit.apply(this,arguments);
},doApplyEdit:function(_577,_578){
var _579=this._cache[_577];
this.onApplyEdit(_577);
},removeSelectedRows:function(){
if(this._canEdit){
this.edit.apply();
var fx=lang.hitch(this,function(_57a){
if(_57a.length){
_53a.forEach(_57a,this.store.deleteItem,this.store);
this.selection.clear();
}
});
if(this.allItemsSelected){
this.store.fetch({query:this.query,queryOptions:this.queryOptions,onComplete:fx});
}else{
fx(this.selection.getSelected());
}
}
}});
_53e.cell_markupFactory=function(_57b,node,_57c){
var _57d=lang.trim(html.attr(node,"field")||"");
if(_57d){
_57c.field=_57d;
}
_57c.field=_57c.field||_57c.name;
var _57e=lang.trim(html.attr(node,"fields")||"");
if(_57e){
_57c.fields=_57e.split(",");
}
if(_57b){
_57b(node,_57c);
}
};
_53e.markupFactory=function(_57f,node,ctor,_580){
return _53c.markupFactory(_57f,node,ctor,lang.partial(_53e.cell_markupFactory,_580));
};
return _53e;
});
