/*
	Copyright (c) 2004-2012, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is an optimized version of Dojo, built for deployment and not for
	development. To get sources and documentation, please visit:

		http://dojotoolkit.org
*/

//>>built
require({cache:{"davinci/review/widgets/CommentForm":function(){
require({cache:{"url:davinci/review/widgets/templates/CommentForm.html":"<div class=\"davinciComment davinciComment2\">\n\t<div dojoAttachPoint=\"toolbarNode\"></div>\n\t<div dojoAttachPoint=\"subjectNode\" class=\"commentSubjectEdit\"></div>\n\t<div dojoAttachPoint=\"contentNode\" class=\"contentNode\">\n\t<span dojoAttachPoint=\"placeHolder\" style=\"padding:3px 0 0 2px;\" class=\"dijitPlaceHolder dijitInputField\">${comment}</span>\n\t</div>\n\t<div class=\"submitCancelDiv\">\n\t\t<div dojoAttachPoint=\"submitNode\"></div>\n\t\t<a dojoAttachPoint=\"cancelNode\" class=\"commentLinkButton\" class=\"cancelLink\">${buttonCancel}</a>\n\t</div>\n</div>\n"}});
define("davinci/review/widgets/CommentForm",["dojo/_base/declare","dijit/_Widget","dijit/_Templated","dijit/form/TextBox","dijit/form/SimpleTextarea","dijit/Menu","dijit/MenuItem","dijit/form/Button","dijit/form/DropDownButton","dojo/i18n!./nls/widgets","davinci/Runtime","dojo/text!./templates/CommentForm.html"],function(_1,_2,_3,_4,_5,_6,_7,_8,_9,_a,_b,_c){
return _1("davinci.review.widgets.CommentForm",[_2,_3],{templateString:_c,postMixInProperties:function(){
this.inherited(arguments);
this.comment=_a.comment;
this.buttonCancel=_a.buttonCancel;
},postCreate:function(){
this.subject=new _4({placeHolder:_a.subjectPlaceHolder,style:"width: 100%"},this.subjectNode);
this.content=new _5({rows:4,style:"width: 100%; margin: 2px 0px 2px 0px;font-family:Verdana, Arial, Helvetica, sans-serif;font-size:100%;"},dojo.create("div"));
this.contentNode.appendChild(this.content.domNode);
new _8({label:_a.submit,onClick:dojo.hitch(this,"_submit")},this.submitNode);
this.replyTo="root";
this.connect(this.cancelNode,"click","hide");
this.connect(this.content,"onFocus","hidePlaceHolder");
this.connect(this.content,"onBlur","showPlaceHolder");
this.connect(this.placeHolder,"click",function(){
this.hidePlaceHolder();
this.content.focus();
});
var _d=this._getActions();
var tb=dojo.create("span",{style:{display:"inline-block"}},this.toolbarNode);
var _e=this._toolbar=davinci.Workbench._createToolBar("toolbarPath",tb,_d,this);
dojo.style(_e.domNode,{"display":"inline-block"});
dojo.subscribe("/davinci/review/drawing/selectshape",this,function(_f,_10){
this._updateToolbarEnablement();
}.bind(this));
dojo.subscribe("/davinci/review/drawing/deselectshape",this,function(_11,_12){
this._updateToolbarEnablement();
}.bind(this));
},_updateToolbarEnablement:function(){
var _13=this._toolbar.getChildren();
dojo.forEach(_13,function(_14){
var _15=_14._maqAction;
if(_15&&_15.action&&_15.action.isEnabled){
var _16=_15.action.isEnabled();
_14.set("disabled",!_16);
}
});
},_getActions:function(){
var _17=[];
_b.getExtensions("davinci.annotationActions",function(ext){
_17.push(ext.editorContribution);
return true;
});
return _17;
},hide:function(){
this.isShowing=false;
this.onHide();
dojo.style(this.domNode,"display","none");
this.reset();
dojo.publish("/davinci/review/view/closeComment",[]);
},onHide:function(){
},show:function(){
this.isShowing=true;
this.onShow();
dojo.style(this.domNode,"display","block");
dojo.window.scrollIntoView(this.domNode);
dojo.publish("/davinci/review/view/openComment",[]);
this._updateToolbarEnablement();
},onShow:function(){
},_submit:function(){
var _18=this.subject.get("value"),_19=this.content.get("value"),_1a=this._update?"onUpdate":"onSubmit";
this[_1a]({subject:_18,content:_19});
},onSubmit:function(_1b){
},onUpdate:function(_1c){
},reset:function(){
dojo.style(this.subject.domNode,"display","block");
this.placeHolder.innerHTML=_a.comment;
this.showPlaceHolder();
this.subject.set("value","");
this.content.set("value","");
this.replyTo="root";
this.placeAt(this.parentNode,"first");
this._update=false;
this.isShowing=false;
this.editFrom=null;
},showPlaceHolder:function(){
if(this.content.get("value")==""){
dojo.removeClass(this.placeHolder,"davinciReviewHide");
}
},hidePlaceHolder:function(){
dojo.addClass(this.placeHolder,"davinciReviewHide");
},setReplyMode:function(){
dojo.style(this.subject.domNode,"display","none");
this.placeHolder.innerHTML=_a.commentReply;
},setEditMode:function(){
this._update=true;
},moveTo:function(_1d){
if(!this.parentNode){
this.parentNode=_1d;
}
this.placeAt(_1d);
}});
});
},"davinci/review/Review":function(){
define("davinci/review/Review",["davinci/Runtime","./Color"],function(_1e,_1f){
return {getColor:function(_20){
var _21;
dojo.some(_1e.reviewers,function(_22,n){
if(_22.email==_20){
_21=n;
return true;
}
return false;
});
return _1f.colors[_21];
}};
});
},"url:davinci/review/widgets/templates/CommentForm.html":"<div class=\"davinciComment davinciComment2\">\n\t<div dojoAttachPoint=\"toolbarNode\"></div>\n\t<div dojoAttachPoint=\"subjectNode\" class=\"commentSubjectEdit\"></div>\n\t<div dojoAttachPoint=\"contentNode\" class=\"contentNode\">\n\t<span dojoAttachPoint=\"placeHolder\" style=\"padding:3px 0 0 2px;\" class=\"dijitPlaceHolder dijitInputField\">${comment}</span>\n\t</div>\n\t<div class=\"submitCancelDiv\">\n\t\t<div dojoAttachPoint=\"submitNode\"></div>\n\t\t<a dojoAttachPoint=\"cancelNode\" class=\"commentLinkButton\" class=\"cancelLink\">${buttonCancel}</a>\n\t</div>\n</div>\n","url:davinci/review/widgets/templates/Comment.html":"<div class=\"davinciComment\">\n    <div dojoAttachPoint=\"mainBody\" class=\"commentBody\">\n        <div class=\"commentSubject\" dojoAttachPoint=\"subjectNode\"></div>\n        <div class=\"commentSubtitle\">\n            ${by}&nbsp;<span dojoAttachPoint=\"ownerName\"></span>\n            &nbsp;<span dojoAttachPoint=\"createTime\"></span>\n            <span class='editReplyBlock'>\n                <a class=\"commentLinkButton\" dojoAttachPoint=\"editButton\">${edit}</a>\n                <span class='editReplySpace'></span>\n                <a class=\"commentLinkButton\" dojoAttachPoint=\"replyButton\">${reply}</a>\n            </span>\n        </div>\n        <div class=\"commentContent\" dojoAttachPoint=\"contentNode\"></div>\n    </div>\n    <div dojoAttachPoint=\"tempForm\"></div>\n    <div dojoAttachPoint=\"replyRegion\" class=\"displayNone\">\n        <div class=\"commentReplyBar\">\n            <img class=\"dijitTreeExpando dijitTreeExpandoOpen commentLinkButton\" src=\"app/dojo/resources/blank.gif\" style=\"vertical-align: middle;\" dojoAttachPoint=\"imgNode\"/>\n            <a class=\"commentLinkButton\" dojoAttachPoint=\"replyCountButton\"></a>\n        </div>\n        <div class=\"commentReplies\" dojoAttachPoint=\"commentReplies\"></div>\n    </div>\n</div>","davinci/review/Color":function(){
define({colors:["firebrick","darkblue","darkgreen","purple","darkorange","darkgoldenrod","brown","darkgrey","darkcyan","deeppink"]});
},"davinci/review/widgets/Comment":function(){
define(["dojo/_base/declare","davinci/XPathUtils","davinci/maqetta/AppStates","davinci/review/Review","davinci/Runtime","davinci/Workbench","dijit/_WidgetBase","dijit/_TemplatedMixin","dijit/Menu","dijit/MenuItem","dijit/form/DropDownButton","dojo/date/locale","dojo/date/stamp","dojo/Deferred","dojo/string","dojo/i18n!./nls/widgets","dojo/text!./templates/Comment.html","dojo/text!./templates/MailFailureDialogContent.html"],function(_23,_24,_25,_26,_27,_28,_29,_2a,_2b,_2c,_2d,_2e,_2f,_30,_31,_32,_33,_34){
var _35=_25.prototype;
var _36=function(_37,_38,_39){
var _3a=_37.getTime()-_38.getTime();
var _3b=_3a<0?"ago":"later";
var day,_3c,min,_3d;
_3a=Math.floor(Math.abs(_3a)/1000);
if(_3a<=60){
return "just now";
}
if(_39&&_3a>_39){
return _2e.format(_37,{formatLength:"short",selector:"date"});
}
_3d=_3a%60;
_3a=Math.floor(_3a/60);
min=_3a%60;
_3a=Math.floor(_3a/60);
_3c=_3a%24;
_3a=Math.floor(_3a/24);
day=_3a;
var _3e=day?day+" days ":_3c?_3c+" hours ":min?min+" mins ":"";
return _3e+_3b;
};
return _23("davinci.review.widgets.Comment",[_29,_2a],{templateString:_33,postMixInProperties:function(){
this.inherited(arguments);
dojo.mixin(this,_32);
},VISIBLE_PART_LENGTH:80,postCreate:function(){
this._createdPromise=new _30();
if(!this.existed){
var _3f={id:this.commentId,subject:this.subject,content:this.content,ownerId:this.ownerId,email:this.email,previous:this.previous,next:this.next,pageState:this.pageState,pageStateList:this.pageStateList?dojo.toJson(this.pageStateList):"",viewScene:this.viewScene,viewSceneList:this.viewSceneList?dojo.toJson(this.viewSceneList):"",designerId:this.designerId,pageName:this.pageName,replyTo:this.replyTo||"root",drawingJson:this.drawingJson};
if(_27.currentEditor&&_27.currentEditor.getContext().getPreference("zazl")){
urlParms.zazl=true;
}
dojo.xhrGet({url:"cmd/addComment",handleAs:"json",content:_3f,error:dojo.hitch(this,function(_40){
dojo.publish("/davinci/review/commentAddedError",[this]);
var msg=_40.responseText;
msg=msg.substring(msg.indexOf("<title>")+7,msg.indexOf("</title>"));
_27.handleError(dojo.string.substitute(_32.errorAddingCom,[_40,msg]));
})}).then(dojo.hitch(this,function(_41){
this.created=_41.created;
this._populate(this);
this._createdPromise.resolve(this.created);
if(_41.emailResult&&_41.emailResult!=="OK"){
var _42=_31.substitute(_34,{htmlContent:_41.emailResult,inviteNotSent:_32.commentNotSent,mailFailureMsg:_32.commentMailFailureMsg});
_28.showMessage(_32.warning,_42);
}
}.bind(this)));
}else{
this._populate(this);
this._createdPromise.resolve(this.created);
}
this.comments=[];
this.collapsed=false;
this.enabled=true;
this.focused=false;
var _43=this.color=_26.getColor(this.email);
this.subjectNode.innerHTML=this.subject;
dojo.style(this.subjectNode,"color",_43);
var _44=_27.getUserDisplayName({email:this.email,userId:this.ownerId,userDisplayName:this.displayName});
this.ownerName.innerHTML=_44;
dojo.style(this.ownerName,"color",_43);
this.contentNode.innerHTML=this.content;
this._ajustLengthOfCommentContent(true);
if(this.isReply()){
dojo.addClass(this.subjectNode,"displayNone");
}
this.connect(this.imgNode,"click","_toggleReplies");
this.connect(this.replyCountButton,"click","_toggleReplies");
this.connect(this.editButton,"click","_editComment");
this.connect(this.replyButton,"click","_newReply");
this.connect(this.mainBody,"click","focusComment");
this.connect(this.mainBody,"dblclick","_editComment");
if(this.closed){
dojo.style(this.editButton,"display","none");
dojo.style(this.replyButton,"display","none");
}
if(_27.userName!=this.ownerId){
dojo.style(this.editButton,"display","none");
}
},getCreated:function(){
var _45=new _30();
this._createdPromise.then(function(_46){
_45.resolve(_46);
});
return _45;
},refresh:function(){
dojo.style(this.editButton,"display","inline");
dojo.style(this.replyButton,"display","inline");
if(this.closed){
dojo.style(this.editButton,"display","none");
dojo.style(this.replyButton,"display","none");
}
if(_27.userName!=this.ownerId){
dojo.style(this.editButton,"display","none");
}
},_populate:function(_47){
this.createdFormatted=_2f.fromISOString(_47.created);
this.createTime.innerHTML=_36(this.createdFormatted,new Date(),604800);
},update:function(arg){
this.subjectNode.innerHTML=this.subject;
this.contentNode.innerHTML=this.content;
this._ajustLengthOfCommentContent(true);
dojo.xhrGet({url:"cmd/updateComment",handleAs:"json",content:{id:this.commentId,designerId:this.designerId,subject:this.subject,content:this.content,pageState:this.pageState,pageStateList:this.pageStateList?dojo.toJson(this.pageStateList):"",viewScene:this.viewScene,viewSceneList:this.viewSceneList?dojo.toJson(this.viewSceneList):"",drawingJson:this.drawingJson},error:function(_48){
var msg=_48.responseText;
msg=msg.substring(msg.indexOf("<title>")+7,msg.indexOf("</title>"));
_27.handleError(dojo.string.substitute(_32.errorUpdateCom,[_48,msg]));
}});
},_editComment:function(){
if(this.isDisabled){
return;
}
this.onEditComment({commentId:this.commentId});
},onEditComment:function(_49){
},_newReply:function(){
if(this.isDisabled){
return;
}
this.onNewReply({replyTo:this.commentId,subject:"Re: "+this.subject});
},onNewReply:function(_4a){
},isReply:function(){
return this.replyTo!="root";
},isPageOwner:function(){
return this.designerId==_27.userName;
},appendReply:function(_4b){
this.comments.push(_4b);
_4b.placeAt(this.commentReplies);
if(dojo.hasClass(this.replyRegion,"displayNone")){
dojo.removeClass(this.replyRegion,"displayNone");
}
var len=this.getReplies().length;
this.replyCountButton.innerHTML=len+(len==1?" Reply":" Replies");
},getReplies:function(){
return this.comments;
},_toggleReplies:function(){
if(this.collapsed){
this.expand();
}else{
this.collapse();
}
},collapse:function(all){
if(all){
var _4c=this.getReplies();
dojo.forEach(_4c,function(_4d){
_4d.collapse(all);
});
}
if(!this.collapsed){
dojo.removeClass(this.imgNode,"dijitTreeExpandoOpen");
dojo.addClass(this.imgNode,"dijitTreeExpandoClosed");
dojo.addClass(this.commentReplies,"displayNone");
}
this.collapsed=true;
},expand:function(all){
if(all){
var _4e=this.getReplies();
dojo.forEach(_4e,function(_4f){
_4f.expand(all);
});
}
if(this.collapsed){
dojo.removeClass(this.imgNode,"dijitTreeExpandoClosed");
dojo.addClass(this.imgNode,"dijitTreeExpandoOpen");
dojo.removeClass(this.commentReplies,"displayNone");
}
this.collapsed=false;
},focusComment:function(evt){
if(this.isDisabled){
return;
}
if(this.isFocused&&evt&&(evt.ctrlKey||evt.metaKey)){
this.blurComment();
}else{
this.onCommentFocus(this,evt);
dojo.addClass(this.mainBody,"commentFocused");
this.isFocused=true;
}
},onCommentFocus:function(_50){
},blurComment:function(_51){
if(!_51){
this.onCommentBlur(this);
}
dojo.removeClass(this.mainBody,"commentFocused");
this.isFocused=false;
},onCommentBlur:function(_52){
},_ajustLengthOfCommentContent:function(_53){
var _54=this.content;
if(_54.length<=this.VISIBLE_PART_LENGTH){
var _55=dojo.query("a",this.contentNode);
if(_55.length>0){
this.contentNode.removeChild(_55[0]);
}
return;
}
var _56=_53?_32.more:_32.commentHide;
var _57=dojo.create("a",{"class":"commentLinkButton",innerHTML:_56,onclick:dojo.hitch(this,"_ajustLengthOfCommentContent",!_53)});
if(_54){
if(_53){
this.contentNode.innerHTML=_54.substring(0,this.VISIBLE_PART_LENGTH);
}else{
this.contentNode.innerHTML=_54;
}
this.contentNode.appendChild(_57);
}
},hide:function(){
dojo.style(this.mainBody,"display","none");
},show:function(){
dojo.style(this.mainBody,"display","block");
dojo.window.scrollIntoView(this.domNode);
},enable:function(){
dojo.removeClass(this.domNode,"disabled");
dojo.removeClass(this.mainBody,"commentBodyDisabled");
dojo.style(this.subjectNode,"color",this.color);
dojo.style(this.ownerName,"color",this.color);
this.isDisabled=false;
},disable:function(){
dojo.addClass(this.domNode,"disabled");
dojo.removeAttr(this.mainBody,"style");
dojo.addClass(this.mainBody,"commentBodyDisabled");
dojo.style(this.subjectNode,"color","");
dojo.style(this.ownerName,"color","");
this.isDisabled=true;
},getBody:function(){
return this.mainBody;
},setStatesScenes:function(){
var e=davinci.Workbench.getOpenEditor();
var ctx=(e&&e.getContext)?e.getContext():null;
var _58=ctx?ctx.rootNode:null;
var doc=_58&&_58.ownerDocument;
if(doc){
if(this.pageStateList){
for(var i=this.pageStateList.length-1;i>-0;i--){
var o=this.pageStateList[i];
var _59=o.id?doc.getElementById(o.id):null;
if(!_59&&o.xpath){
var _5a=_24.toCssPath(o.xpath);
_59=doc.querySelector(_5a);
}
if(_59){
_35.setState(o.state,_59,{updateWhenCurrent:true});
}
}
}
if(this.viewSceneList&&ctx.sceneManagers){
for(var _5b in this.viewSceneList){
var sm=ctx.sceneManagers[_5b];
if(sm){
var _5c=this.viewSceneList[_5b];
for(var j=_5c.length-1;j>=0;j--){
var o=_5c[j];
var _5d=o.scId?doc.getElementById(o.scId):null;
if(!_5d&&o.scXpath){
var _5a=_24.toCssPath(o.scXpath);
_5d=doc.querySelector(_5a);
}
if(_5d&&o.sceneId){
sm.selectScene({sceneContainerNode:_5d,sceneId:o.sceneId});
}
}
}
}
}
}
}});
});
}}});
define("davinci/review/view/CommentView",["dojo/_base/declare","davinci/Workbench","davinci/Runtime","davinci/maqetta/AppStates","davinci/review/Review","davinci/workbench/ViewPart","davinci/review/widgets/Comment","davinci/review/widgets/CommentForm","dijit/form/Button","dijit/form/TextBox","dijit/form/DropDownButton","dijit/Toolbar","dijit/ToolbarSeparator","dijit/CheckedMenuItem","dijit/MenuSeparator","dijit/Dialog","dijit/Menu","dojo/fx","dojo/i18n!./nls/view","dojo/i18n!davinci/workbench/nls/workbench"],function(_5e,_5f,_60,_61,_62,_63,_64,_65,_66,_67,_68,_69,_6a,_6b,_6c,_6d,_6e,_6f,_70,_71){
var _72=_61.prototype;
var _73=function(){
var _74="";
for(var i=1;i<=32;i++){
var n=Math.floor(Math.random()*16).toString(16);
_74+=n;
if((i==8)||(i==12)||(i==16)||(i==20)){
_74+="-";
}
}
return _74;
};
return _5e("davinci.review.view.CommentView",_63,{interval:33554432,id:0,postCreate:function(){
this.inherited(arguments);
this._cached={};
this._cached.indices={};
this.comments=[];
this.commentIndices={"root":this};
this._commentConns=[];
this.container=new dijit.layout.ContentPane();
this.commentReplies=this.container.domNode;
dojo.attr(this.commentReplies,"tabindex","0");
this.setContent(this.container);
this.attachToolbar();
this._initCommentForm();
this.connect(this.commentReplies,"keydown",function(evt){
var _75=this;
var _76=function(_77){
if(_75.commentIsActive(_77)){
_77.enable();
}else{
_77.disable();
}
var _78=_77.getReplies();
if(_78.length>0){
dojo.forEach(_78,_76);
}
};
if(!this._currentPage){
return;
}
if(evt.keyCode==dojo.keys.CTRL||evt.keyCode==dojo.keys.META){
var _79=this._cached[this._currentPage].focusedComments;
if(_79.length>0){
var _7a=this.commentIndices[_79[0]].pageState;
dojo.forEach(this.comments,_76);
}
}
});
this.connect(this.commentReplies,"keyup",function(evt){
if(evt.keyCode==dojo.keys.CTRL||evt.keyCode==dojo.keys.META){
var _7b=function(_7c){
_7c.enable();
var _7d=_7c.getReplies();
if(_7d.length>0){
dojo.forEach(_7d,_7b);
}
};
dojo.forEach(this.comments,_7b);
}
});
this.connect(this.commentReplies,"click",function(evt){
if(evt.target!==this.commentReplies){
return;
}
this._blurAllComments();
});
dojo.subscribe("/davinci/review/view/canvasFocused",this,function(){
this._blurAllComments();
});
dojo.subscribe("/davinci/review/resourceChanged",this,function(_7e,_7f,_80){
if(_7f!="open"&&_7f!="closed"||!this._currentPage){
return;
}
if(this._currentPage.split("/")[2]==_80.timeStamp){
this._versionClosed=_7f=="closed";
}
dijit.byId("davinciReviewToolbar.Add").set("disabled",this._versionClosed);
dijit.byId("davinciReviewToolbar.Reviewers").set("disabled",false);
dojo.publish(this._currentPage+"/davinci/review/drawing/addShape",["[]",true]);
this._destroyCommentWidgets();
this._render();
var _81=this._cached[this._currentPage].pageState,_82=this._cached[this._currentPage].pageStateList,_83=this._cached[this._currentPage].viewScene||this._getCurrentScene().s,_84=this._cached[this._currentPage].viewSceneList||this._context.getCurrentScenes();
dojo.publish(this._currentPage+"/davinci/review/drawing/filter",[{},[]]);
});
dojo.subscribe("/davinci/review/context/loaded",this,function(_85,_86){
_85._commentView=this;
this._context=_85;
var _87=dojo.window.get(_85.containerNode.ownerDocument);
var _88=_85.resourceFile.parent.designerId;
this._loadCommentData(_88,_86);
if(_5f.getOpenEditor()===_85.containerEditor){
this._currentPage=_86;
this._cached[this._currentPage].context=_85;
this._destroyCommentWidgets();
setTimeout(function(){
this._render();
this._updateToolbar({editor:_85});
this._reviewFilterChanged();
var _89=this._context.rootNode;
var _8a=this._context.getCurrentStates();
var _8b=this._getCurrentScene().s;
var _8c=this._context.getCurrentScenes();
dojo.publish(this._currentPage+"/davinci/review/drawing/filter",[{},[]]);
}.bind(this),100);
}
if(_87&&_87.require){
var _8d=_87.require("dojo/_base/connect");
_8d.subscribe("/maqetta/appstates/state/changed",this,function(_8e){
if(!_60.currentEditor||_60.currentEditor.editorID!="davinci.review.CommentReviewEditor"){
return;
}
if(!this._cached||!this._currentPage||!this._cached[this._currentPage]){
return;
}
var _8f=_8e.newState||"Normal";
this._cached[this._currentPage].pageState=_8f;
var _90=this._cached[this._currentPage].pageStateList=this._context.getCurrentStates();
var _91=this._cached[this._currentPage].viewScene=this._getCurrentScene().s;
var _92=this._cached[this._currentPage].viewSceneList=this._context.getCurrentScenes();
dojo.publish(this._currentPage+"/davinci/review/drawing/filter",[{},[]]);
});
}
this.updateStatesScenes();
});
dojo.subscribe("/davinci/ui/editorSelected",this,function(_93){
var _94=this._editor=_93.editor;
if(_93.oldEditor&&_93.oldEditor.basePath){
if(this._commentForm.isShowing){
var _95={commentId:this._commentForm.commentId,replyTo:this._commentForm.replyTo,subject:this._commentForm.subject.get("value"),content:this._commentForm.content.get("value").replace(/\n/g,"<br/>"),editFrom:this._commentForm.editFrom};
this._setPendingEditComment(_93.oldEditor,_95);
}else{
this._setPendingEditComment(_93.oldEditor,null);
}
}
if(_94&&_94.basePath){
this._currentPage=_94.basePath.path;
this._commentForm.hide();
this._destroyCommentWidgets();
this._updateToolbar(_93);
this._render();
var _96=this._cached[this._currentPage]&&this._cached[this._currentPage].focusedComments;
if(_96){
dojo.forEach(_96,dojo.hitch(this,function(_97){
this.commentIndices[_97].focusComment({ctrlKey:true,metaKey:true,silent:true});
}));
}
if(this._cached[this._currentPage]&&this._cached[this._currentPage].editComment){
var _98=this._commentForm,_99=this._cached[this._currentPage].editComment;
_98.reset();
_98.commentId=_99.commentId;
_98.subject.set("value",_99.subject);
_98.content.set("value",_99.content.replace(/<br\/>/g,"\n"));
if(_99.content){
_98.hidePlaceHolder();
}
var _9a;
if(_99.replyTo!=="root"){
_98.setReplyMode();
_98.replyTo=_99.replyTo;
_9a=this.commentIndices[_99.replyTo];
_98.moveTo(_9a.tempForm);
var _9b=_9a;
while(_9b&&_9b.expand){
_9b.expand();
_9b=this.commentIndices[_9b.replyTo];
}
dojo.window.scrollIntoView(_9a.domNode);
}
if(_99.editFrom){
_98.setEditMode();
_9a=this.commentIndices[_99.editFrom];
_9a.hide();
_98.moveTo(_9a.tempForm);
dojo.window.scrollIntoView(_9a.domNode);
}
_98.show();
}
}
if(!_94||_94.editorID!="davinci.review.CommentReviewEditor"){
this._resetCommentView();
this._currentPage=null;
}else{
this._versionClosed=_94.resourceFile.parent.closed;
}
});
dojo.subscribe("/davinci/review/drawing/annotationSelected",this,function(_9c,_9d){
var _9e=this.commentIndices[_9c];
var _9f=this._cached[this._currentPage].focusedComments;
if(_9e&&!_9e.isFocused||_9f.length>1){
var _a0=this.commentIndices[_9e.replyTo];
while(_a0&&_a0.expand){
_a0.expand();
_a0=this.commentIndices[_a0.replyTo];
}
dojo.window.scrollIntoView(_9e.domNode);
_9e.focusComment();
this._flash(_9e.getBody());
}else{
if(_9e){
_9e.blurComment();
}
}
});
dojo.subscribe("/davinci/review/commentAddedError",this,this._onErrorCreateNewComment);
},_getCurrentScene:function(){
var _a1=this._context.sceneManagers;
var _a2;
for(var _a3 in _a1){
var sm=_a1[_a3];
if(sm.getCurrentScene){
_a2=sm.getCurrentScene();
if(_a2){
break;
}
}
}
return {sm:sm,s:_a2};
},_setPendingEditComment:function(_a4,_a5){
var key=null;
if(typeof _a4==="string"){
key=_a4;
}else{
if(_a4.basePath&&_a4.basePath.path){
key=_a4.basePath.path;
}
}
if(key){
var _a6=this._cached[key];
if(_a6){
_a6.editComment=_a5;
}
}
},_resetCommentView:function(){
dijit.byId("davinciReviewToolbar.Add").set("disabled",true);
dijit.byId("davinciReviewToolbar.Reviewers").set("disabled",true);
this._commentForm.hide();
this._destroyCommentWidgets();
},_initCommentForm:function(){
var _a7=this._commentForm=new _65({onSubmit:dojo.hitch(this,"_onCreateNewComment"),onUpdate:dojo.hitch(this,"_onUpdateComment"),onShow:dojo.hitch(this,"_onCommentFormShown")});
this.connect(_a7.cancelNode,"click","_onCommentFormCancel");
_a7.moveTo(this.container.domNode);
_a7.hide();
},_onCommentFormShown:function(){
},_onErrorCreateNewComment:function(_a8){
var _a9=this._cached[this._currentPage];
var _aa;
for(var i=0;i<_a9.length;i++){
if(_a9[i]&&_a9[i].id==_a8.commentId){
_aa=i;
}
_a9[i]._hasPopulate=false;
}
if(_aa){
_a9.splice(_aa,1);
}
delete this._cached.indices[_a8.commentId];
this._destroyCommentWidgets();
dojo.publish(this._currentPage+"/davinci/review/drawing/addShape",["[]",true]);
this._render();
},_onCreateNewComment:function(_ab){
var _ac=this._commentForm,_ad=this._cached[this._currentPage]||[];
var _ae=this._cached[this._currentPage].context.rootNode;
dojo.publish(this._currentPage+"/davinci/review/drawing/getShapesInEditing",[this,{state:this._cached[this._currentPage].pageState,stateList:this._cached[this._currentPage].pageStateList,scene:(this._cached[this._currentPage].viewScene||this._getCurrentScene().s),sceneList:(this._cached[this._currentPage].viewSceneList||this._context.getCurrentScenes())}]);
var _af=new _64({commentId:_ac.commentId,subject:_ab.subject,content:_ab.content,designerId:this._getDesignerId(),pageName:this._currentPage,pageState:this._cached[this._currentPage].pageState,pageStateList:this._cached[this._currentPage].pageStateList,viewScene:this._cached[this._currentPage].viewScene||this._getCurrentScene().s,viewSceneList:this._cached[this._currentPage].viewSceneList||this._context.getCurrentScenes(),ownerId:_60.userName,email:_60.userEmail,displayName:_60.getUserDisplayName(),replyTo:_ac.replyTo,drawingJson:this.drawingJson});
this._commentConns.push(dojo.connect(_af,"onNewReply",this,"_onNewReply"),dojo.connect(_af,"onEditComment",this,"_onEditComment"),dojo.connect(_af,"onCommentFocus",this,"_onCommentFocus"),dojo.connect(_af,"onCommentBlur",this,"_onCommentBlur"));
this.commentIndices[_af.commentId]=_af;
_ac.hide();
var _b0=this.commentIndices[_af.replyTo];
_b0.appendReply(_af);
if(_b0.expand){
_b0.expand();
}
dojo.window.scrollIntoView(_af.domNode);
_af.focusComment();
this._flash(_af.getBody());
var _b1={id:_af.commentId,subject:_af.subject,content:_af.content,pageName:_af.pageName,pageState:_af.pageState,pageStateList:_af.pageStateList,viewScene:_af.viewScene,viewSceneList:_af.viewSceneList,ownerId:_af.ownerId,email:_af.email,displayName:_af.displayName,depth:_af.depth,replyTo:_af.replyTo,drawingJson:_af.drawingJson};
_ad.push(_b1);
this._cached.indices[_b1.id]=_b1;
_af.getCreated().then(function(_b2){
_b1.created=_b2;
});
},_onUpdateComment:function(_b3){
var _b4=this._commentForm,_b5=this.commentIndices[_b4.commentId];
dojo.publish(this._currentPage+"/davinci/review/drawing/getShapesInEditing",[this,{state:this._cached[this._currentPage].pageState,stateList:this._cached[this._currentPage].pageStateList,scene:(this._cached[this._currentPage].viewScene||this._getCurrentScene().s),sceneList:(this._cached[this._currentPage].viewSceneList||this._context.getCurrentScenes())}]);
_b5.subject=_b3.subject;
_b5.content=_b3.content;
_b5.pageState=this._cached[this._currentPage].pageState;
_b5.pageStateList=this._cached[this._currentPage].pageStateList;
_b5.viewScene=this._cached[this._currentPage].viewScene||this._getCurrentScene().s;
_b5.viewSceneList=this._cached[this._currentPage].viewSceneList||this._context.getCurrentScenes();
_b5.drawingJson=this.drawingJson;
_b4.hide();
_b5.update();
_b5.show();
this._flash(_b5.getBody());
var _b6=this._cached.indices[_b5.commentId];
_b6.subject=_b5.subject;
_b6.content=_b5.content;
_b6.pageState=_b5.pageState;
_b6.pageStateList=_b5.pageStateList;
_b6.viewScene=_b5.viewScene;
_b6.viewSceneList=_b5.viewSceneList;
_b6.drawingJson=_b5.drawingJson;
},_loadCommentData:function(_b7,_b8){
this._cached[_b8]=_60.serverJSONRequest({url:"cmd/getComments",sync:true,content:{ownerId:_b7,pageName:_b8}}).sort(function(c1,c2){
return c1.created>c2.created?1:c1.created<c2.created?-1:0;
});
for(var i=0;i<this._cached[_b8].length;i++){
var _b9=this._cached[_b8][i];
_b9.pageStateList=(_b9.hasOwnProperty("pageStateList")&&_b9.pageStateList)?dojo.fromJson(_b9.pageStateList):[];
_b9.viewSceneList=(_b9.hasOwnProperty("viewSceneList")&&_b9.viewSceneList)?dojo.fromJson(_b9.viewSceneList):[];
}
this._cached[_b8].pageState="Normal";
this._cached[_b8].pageStateList=this._context.getCurrentStates();
this._cached[_b8].viewSceneList=this._context.getCurrentScenes();
this._cached[_b8].focusedComments=[];
},_destroyCommentWidgets:function(){
var _ba=this.comments;
dojo.forEach(_ba,function(_bb){
_bb.destroyRecursive();
});
this.comments=[];
dojo.forEach(this._commentConns,dojo.disconnect);
this._commentConns=[];
},_render:function(){
var _bc=this._cached[this._currentPage];
dojo.forEach(_bc,function(_bd,i){
var _be=new _64({commentId:_bd.id,subject:_bd.subject,content:_bd.content,designerId:_bd.designerId,pageName:this._currentPage,pageState:_bd.pageState,pageStateList:_bd.pageStateList,viewScene:_bd.viewScene,viewSceneList:_bd.viewSceneList,ownerId:_bd.ownerId,email:_bd.email,displayName:_bd.displayName,created:_bd.created,parent:this,existed:true,replyTo:_bd.replyTo,drawingJson:_bd.drawingJson,closed:this._versionClosed});
this._cached.indices[_bd.id]=_bd;
this.commentIndices[_be.commentId]=_be;
this.commentIndices[_be.replyTo].appendReply(_be);
this._commentConns.push(dojo.connect(_be,"onNewReply",this,"_onNewReply"),dojo.connect(_be,"onEditComment",this,"_onEditComment"),dojo.connect(_be,"onCommentFocus",this,"_onCommentFocus"),dojo.connect(_be,"onCommentBlur",this,"_onCommentBlur"));
if(i===0){
dojo.style(_be.domNode,"borderTop","none");
}
if(!_bd._hasPopulate){
_be.drawingJson=_be.drawingJson.replace(/\"colorAlias\":\"[\S+]\"/,"\"colorAlias\":\""+_be.email+"\"");
dojo.publish(this._currentPage+"/davinci/review/drawing/addShape",[_be.drawingJson]);
_bd._hasPopulate=true;
}
},this);
dojo.forEach(this.comments,function(_bf){
_bf.collapse(true);
});
},_onEditComment:function(_c0){
var _c1=this._commentForm,_c2=this.commentIndices[_c0.commentId];
if(_c2.ownerId!=_60.userName){
return;
}
if(_c1.isShowing){
this._onCommentFormCancel();
}
_c1.reset();
_c1.commentId=_c0.commentId;
_c1.subject.set("value",_c2.subject);
_c1.content.set("value",_c2.content.replace(/<br\/>/g,"\n"));
if(_c2.content){
_c1.hidePlaceHolder();
}
_c1.setEditMode();
if(_c2.isReply()){
_c1.setReplyMode();
}
_c1.replyTo=_c2.replyTo;
_c2.hide();
_c1.moveTo(_c2.tempForm);
_c1.editFrom=_c0.commentId;
_c1.show();
dojo.publish(this._currentPage+"/davinci/review/drawing/enableEditing",[_60.userEmail,_c1.commentId,{pageState:_c2.pageState,pageStateList:_c2.pageStateList,viewScene:_c2.viewScene,viewSceneList:_c2.viewSceneList}]);
},_onNewReply:function(_c3){
var _c4=this._commentForm;
if(_c4.isShowing){
this._onCommentFormCancel();
}
_c4.reset();
_c4.commentId=_73();
_c4.setReplyMode();
_c4.replyTo=_c3.replyTo;
_c4.subject.set("value",_c3.subject);
var _c5=this.commentIndices[_c3.replyTo];
_c4.moveTo(_c5.tempForm);
_c4.show();
dojo.publish(this._currentPage+"/davinci/review/drawing/enableEditing",[_60.userEmail,_c4.commentId,{pageState:this._cached[this._currentPage].pageState,pageStateList:this._cached[this._currentPage].pageStateList,viewScene:this._cached[this._currentPage].viewScene,viewSceneList:this._cached[this._currentPage].viewSceneList}]);
},_onCommentFocus:function(_c6,evt){
var _c7=this._cached[this._currentPage].focusedComments;
if(!evt||(!evt.ctrlKey&&!evt.metaKey)){
dojo.forEach(_c7,function(_c8){
this.commentIndices[_c8].blurComment(true);
},this);
_c7.length=0;
_c7.push(_c6.commentId);
var _c9=this.commentIndices[_c6.commentId];
_c9.setStatesScenes();
}else{
if(evt.ctrlKey||evt.metaKey){
if(!dojo.some(_c7,function(_ca){
return _ca==_c6.commentId;
})){
_c7.push(_c6.commentId);
var _c9=this.commentIndices[_c6.commentId];
_c9.setStatesScenes();
}
}
}
if(!evt||!evt.silent){
if(this._editor){
var _cb=this._editor.getContext();
var _cc=(_cb&&_cb.rootNode&&_cb.rootNode.ownerDocument&&_cb.rootNode.ownerDocument.defaultView&&_cb.rootNode.ownerDocument.defaultView.davinci&&_cb.rootNode.ownerDocument.defaultView.davinci.states);
if(_cc){
_cc.setState(_c6.pageState);
}
}
var _cd;
var _ce=this._getCurrentScene();
if(_ce&&_ce.sm&&_ce.sm.selectScene&&_c6.viewScene){
_ce.sm.selectScene({sceneId:_c6.viewScene});
_cd=_c6.viewScene;
}
this.publish(this._currentPage+"/davinci/review/drawing/filter",[{},_c7]);
}
},_onCommentBlur:function(_cf){
var _d0=this._cached[this._currentPage].focusedComments;
for(var i=0;i<_d0.length;i++){
if(_d0[i]==_cf.commentId){
if(i==_d0.length-1){
_d0.pop();
}else{
_d0[i]=_d0.pop();
}
}
}
var _d1=this._cached[this._currentPage].viewScene||this._getCurrentScene().s;
this.publish(this._currentPage+"/davinci/review/drawing/filter",[{},_d0]);
this.publish(this._currentPage+"/davinci/review/drawing/filter",[{pageState:this._cached[this._currentPage].pageState,viewScene:_d1},_d0]);
},_onCommentFormCancel:function(){
dojo.publish(this._currentPage+"/davinci/review/drawing/cancelEditing",[]);
var dim=this._cached[this._currentPage],_d2=dim.pageState,_d3=dim.pageStateList,_d4=dim.viewScene,_d5=dim.viewSceneList,_d6=dim.focusedComments;
if(_d6.length>0){
this.commentIndices[_d6[0]].show();
}
dojo.publish(this._currentPage+"/davinci/review/drawing/filter",[{},_d6]);
},_updateToolbar:function(_d7){
dijit.byId("davinciReviewToolbar.Add").set("disabled",this._versionClosed);
dijit.byId("davinciReviewToolbar.Reviewers").set("disabled",false);
var _d8=_d7.editor;
if(_d8&&_d8.resourceFile){
var _d9=_d8.resourceFile.parent;
var _da=_d9.reviewers;
var _db=this._cached[this._currentPage];
dojo.forEach(_db,function(_dc){
if(!dojo.some(_da,function(_dd){
return _dd.email==_dc.email;
})&&_60.userName!=_d9.name){
_da.push({name:_dc.ownerId,email:_dc.email});
}
});
var _de=this.reviewerList.getChildren();
for(var i=2;i<_de.length;i++){
_de[i].destroy();
}
_60.reviewers=_da;
dojo.forEach(_da,dojo.hitch(this,function(_df,_e0){
if(_df.email){
var _e1=_60.getUserDisplayName({email:_df.email,userId:_df.name,userDisplayName:_df.displayName});
var _e2=new _6b({label:"<div class='davinciReviewToolbarReviewersColor' style='background-color:"+_62.getColor(_df.email)+";'></div><span>"+_e1+"</span>",onChange:dojo.hitch(this,function(){
this._reviewFilterChanged();
this._reviewersBtn.openDropDown();
}),checked:true,reviewer:_df,title:_df.email});
this.reviewerList.addChild(_e2);
if(this._cached[this._currentPage]&&this._cached[this._currentPage].shownColors){
var _e3=dojo.some(this._cached[this._currentPage].shownColors,function(_e4){
if(_e4==_df.email){
return true;
}
return false;
});
_e2.set("checked",_e3);
}
}
}));
this._reviewFilterChanged();
}
},getTopAdditions:function(){
this.category="content";
var _e5=new _67({id:"filterText",placeHolder:_70.filter});
dojo.connect(_e5.domNode,"onkeyup",this,function(e){
this._filter();
dojo.stopEvent(e);
});
var _e6=new _69({id:"davinciReviewToolbar"},dojo.create("div"));
var _e7=new _66({id:_e6.get("id")+".Add",showLabel:false,disabled:true,iconClass:"davinciReviewToolbarAdd",title:_70.addComment,onClick:dojo.hitch(this,"_showCommentForm")});
var _e8=new _6e({});
_e8.addChild(new _6b({label:_70.allReviewers,checked:true,onChange:dojo.hitch(this,function(_e9){
var _ea=_e8.getChildren();
for(var i=2;i<_ea.length;i++){
_ea[i].set("checked",_e9);
}
this._reviewFilterChanged();
this._reviewersBtn.openDropDown();
})}));
_e8.addChild(new _6c());
var _eb=this._reviewersBtn=new _68({id:_e6.get("id")+".Reviewers",showLabel:false,disabled:true,iconClass:"davinciReviewToolbarReviewers",title:_70.showReviewer,dropDown:_e8});
this.reviewerList=_e8;
_e6.addChild(_e7);
_e6.addChild(new _6a());
_e6.addChild(_eb);
dojo.place(dojo.create("br"),_e6.domNode);
_e6.addChild(_e5);
return _e6.domNode;
},_reviewFilterChanged:function(){
var _ec=[];
var _ed=this.reviewerList.getChildren();
for(var i=2;i<_ed.length;i++){
if(_ed[i].checked){
_ec.push(_ed[i].reviewer.email);
}
}
_ed[0].set("checked",_ec.length==_ed.length-2);
if(this._cached[this._currentPage]){
this._cached[this._currentPage].shownColors=_ec;
}
dojo.publish(this._currentPage+"/davinci/review/drawing/setShownColorAliases",[_ec]);
},_createEditButton:function(){
if(this.editButton){
this.editButton.domNode.style.display="block";
}else{
this.editButton=new _66({label:"",iconClass:"editButtonIcon",disabled:true,onClick:dojo.hitch(this,"")});
this.container.domNode.appendChild(this.editButton.domNode);
}
},_createViewSwitch:function(){
this.switchWrapper=dojo.create("div",{style:{"float":"right"}});
var _ee=new _66({label:null,iconClass:"collapseViewActive",onClick:dojo.hitch(this,"collapseAll")});
var _ef=new _66({label:null,iconClass:"expandViewActive",onClick:dojo.hitch(this,"expandAll")});
this.switchWrapper.appendChild(_ee.domNode);
this.switchWrapper.appendChild(_ef.domNode);
this.container.domNode.appendChild(this.switchWrapper);
},_showCommentForm:function(){
var _f0=this._commentForm;
if(_f0.isShowing){
this._onCommentFormCancel();
}
_f0.reset();
_f0.commentId=_73();
_f0.show();
dojo.publish(this._currentPage+"/davinci/review/drawing/enableEditing",[_60.userEmail,_f0.commentId,{pageState:this._cached[this._currentPage].pageState,pageStateList:this._cached[this._currentPage].pageStateList,viewScene:this._cached[this._currentPage].viewScene,viewSceneList:this._cached[this._currentPage].viewSceneList}]);
},_filter:function(){
var _f1=dijit.byId("filterText").get("displayedValue");
dojo.query(".davinciComment",this.container.domNode).removeClass("davinciReviewHide davinciReviewShow").forEach(function(_f2){
var _f3=dijit.getEnclosingWidget(_f2);
var _f4=true;
_f4=_f3.subjectNode.innerHTML.toLowerCase().indexOf(_f1.toLowerCase())>=0||_f3.contentNode.innerHTML.toLowerCase().indexOf(_f1.toLowerCase())>=0||_f3.ownerName&&_f3.ownerName.innerHTML.toLowerCase().indexOf(_f1.toLowerCase())>=0;
if(_f4){
dojo.addClass(_f2,"davinciReviewShow");
while(_f3.replyTo!=="root"){
_f3=this.commentIndices[_f3.replyTo];
dojo.addClass(_f3.domNode,"davinciReviewShow");
dojo.removeClass(_f3.domNode,"davinciReviewHide");
}
return;
}
dojo.addClass(_f2,"davinciReviewHide");
},this);
},expandAll:function(){
dojo.query(".repliesCount",this.container.domNode).removeClass("davinciReviewShow").addClass("davinciReviewHide");
dojo.query(".currentScope",this.container.domNode).addClass("davinciReviewShow").removeClass("davinciReviewHide");
},isPageOwner:function(){
return this._getDesignerId()==_60.userName;
},_getDesignerId:function(){
var _f5=null;
var _f6=this._cached[this._currentPage].context;
if(_f6){
_f5=_f6.resourceFile.parent.designerId;
}
return _f5;
},popupWarning:function(_f7){
var _f8=dijit.byId("warningDialog");
if(!_f8){
_f8=new _6d({id:"warningDialog",title:"",style:"width: 300px"},dojo.create("p",{innerHTML:_f7}));
}
_f8.show();
},getReplies:function(){
return this.comments;
},appendReply:function(_f9){
this.comments.push(_f9);
if(this.comments.length==1){
dojo.style(_f9.domNode,"borderTop","none");
}
_f9.placeAt(this.container.domNode);
},_blurAllComments:function(){
var _fa=this._cached[this._currentPage].focusedComments,_fb=[];
if(_fa){
dojo.forEach(_fa,function(_fc){
var _fd=this.commentIndices[_fc];
_fd&&_fb.push(_fd);
},this);
dojo.forEach(_fb,function(c){
c.blurComment();
},this);
}
},_flash:function(_fe){
if(!_fe){
return;
}
if(!this._originalBkColor){
this._originalBkColor=dojo.style(_fe,"backgroundColor");
}
_6f.chain([dojo.animateProperty({node:_fe,duration:250,properties:{backgroundColor:{start:this._originalBkColor,end:"#fef7d9"}}}),dojo.animateProperty({node:_fe,duration:250,properties:{backgroundColor:{start:"#fef7d9",end:this._originalBkColor}}})]).play();
},updateStatesScenes:function(){
var _ff=this._context.rootNode;
var _100=_72.getFocus(_ff);
var _101=this._cached[this._currentPage].pageState=_100?_100.state:undefined;
var _102=this._cached[this._currentPage].pageStateList=this._context.getCurrentStates();
var _103=this._cached[this._currentPage].viewScene=this._getCurrentScene().s;
var _104=this._cached[this._currentPage].viewSceneList=this._context.getCurrentScenes();
var _105=this._cached[this._currentPage].focusedComments;
dojo.publish(this._currentPage+"/davinci/review/drawing/filter",[{},_105]);
},commentIsActive:function(_106){
function _107(val){
return !val?_72.NORMAL:val;
};
var _108=this._cached[this._currentPage];
var doc=this._context.getDocument();
var i,_109,_10a;
for(i=0;i<_108.pageStateList.length;i++){
_109=_108.pageStateList[i];
var _10b=_107(_109.state);
_10a=_106.pageStateList[i];
var _10c=_107(_10a.state);
if(_109&&_10a){
if(((_10a.id&&_10a.id===_109.id)||(_10a.xpath&&_10a.xpath===_109.xpath))&&_10c!==_10b){
return false;
}
}
}
for(var _10d in _108.viewSceneList){
var _10e=_108.viewSceneList[_10d];
var _10f=_106.viewSceneList[_10d];
if(_10e&&_10f){
for(i=0;i<_10e.length;i++){
_109=_10e[i];
_10a=_10f[i];
if(_109&&_10a){
if(((_10a.scId&&_10a.scId===_109.scId)||(_10a.scXpath&&_10a.scXpath===_109.scXpath))&&((_10a.sceneId&&_10a.sceneId!==_109.sceneId)||(_10a.sceneXpath&&_10a.sceneXpath!==_109.sceneXpath))){
return false;
}
}
}
}
}
return true;
}});
});
