/*
	Copyright (c) 2004-2012, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is an optimized version of Dojo, built for deployment and not for
	development. To get sources and documentation, please visit:

		http://dojotoolkit.org
*/

//>>built
require({cache:{"dijit/_editor/plugins/FontChoice":function(){
define(["dojo/_base/array","dojo/_base/declare","dojo/dom-construct","dojo/i18n","dojo/_base/lang","dojo/store/Memory","../../registry","../../_Widget","../../_TemplatedMixin","../../_WidgetsInTemplateMixin","../../form/FilteringSelect","../_Plugin","../range","dojo/i18n!../nls/FontChoice"],function(_1,_2,_3,_4,_5,_6,_7,_8,_9,_a,_b,_c,_d){
var _e=_2("dijit._editor.plugins._FontDropDown",[_8,_9,_a],{label:"",plainText:false,templateString:"<span style='white-space: nowrap' class='dijit dijitReset dijitInline'>"+"<label class='dijitLeft dijitInline' for='${selectId}'>${label}</label>"+"<input data-dojo-type='dijit.form.FilteringSelect' required='false' "+"data-dojo-props='labelType:\"html\", labelAttr:\"label\", searchAttr:\"name\"' "+"tabIndex='-1' id='${selectId}' data-dojo-attach-point='select' value=''/>"+"</span>",postMixInProperties:function(){
this.inherited(arguments);
this.strings=_4.getLocalization("dijit._editor","FontChoice");
this.label=this.strings[this.command];
this.id=_7.getUniqueId(this.declaredClass.replace(/\./g,"_"));
this.selectId=this.id+"_select";
this.inherited(arguments);
},postCreate:function(){
this.select.set("store",new _6({idProperty:"value",data:_1.map(this.values,function(_f){
var _10=this.strings[_f]||_f;
return {label:this.getLabel(_f,_10),name:_10,value:_f};
},this)}));
this.select.set("value","",false);
this.disabled=this.select.get("disabled");
},_setValueAttr:function(_11,_12){
_12=_12!==false;
this.select.set("value",_1.indexOf(this.values,_11)<0?"":_11,_12);
if(!_12){
this.select._lastValueReported=null;
}
},_getValueAttr:function(){
return this.select.get("value");
},focus:function(){
this.select.focus();
},_setDisabledAttr:function(_13){
this.disabled=_13;
this.select.set("disabled",_13);
}});
var _14=_2("dijit._editor.plugins._FontNameDropDown",_e,{generic:false,command:"fontName",postMixInProperties:function(){
if(!this.values){
this.values=this.generic?["serif","sans-serif","monospace","cursive","fantasy"]:["Arial","Times New Roman","Comic Sans MS","Courier New"];
}
this.inherited(arguments);
},getLabel:function(_15,_16){
if(this.plainText){
return _16;
}else{
return "<div style='font-family: "+_15+"'>"+_16+"</div>";
}
},_setValueAttr:function(_17,_18){
_18=_18!==false;
if(this.generic){
var map={"Arial":"sans-serif","Helvetica":"sans-serif","Myriad":"sans-serif","Times":"serif","Times New Roman":"serif","Comic Sans MS":"cursive","Apple Chancery":"cursive","Courier":"monospace","Courier New":"monospace","Papyrus":"fantasy","Estrangelo Edessa":"cursive","Gabriola":"fantasy"};
_17=map[_17]||_17;
}
this.inherited(arguments,[_17,_18]);
}});
var _19=_2("dijit._editor.plugins._FontSizeDropDown",_e,{command:"fontSize",values:[1,2,3,4,5,6,7],getLabel:function(_1a,_1b){
if(this.plainText){
return _1b;
}else{
return "<font size="+_1a+"'>"+_1b+"</font>";
}
},_setValueAttr:function(_1c,_1d){
_1d=_1d!==false;
if(_1c.indexOf&&_1c.indexOf("px")!=-1){
var _1e=parseInt(_1c,10);
_1c={10:1,13:2,16:3,18:4,24:5,32:6,48:7}[_1e]||_1c;
}
this.inherited(arguments,[_1c,_1d]);
}});
var _1f=_2("dijit._editor.plugins._FormatBlockDropDown",_e,{command:"formatBlock",values:["noFormat","p","h1","h2","h3","pre"],postCreate:function(){
this.inherited(arguments);
this.set("value","noFormat",false);
},getLabel:function(_20,_21){
if(this.plainText||_20=="noFormat"){
return _21;
}else{
return "<"+_20+">"+_21+"</"+_20+">";
}
},_execCommand:function(_22,_23,_24){
if(_24==="noFormat"){
var _25;
var end;
var sel=_d.getSelection(_22.window);
if(sel&&sel.rangeCount>0){
var _26=sel.getRangeAt(0);
var _27,tag;
if(_26){
_25=_26.startContainer;
end=_26.endContainer;
while(_25&&_25!==_22.editNode&&_25!==_22.document.body&&_25.nodeType!==1){
_25=_25.parentNode;
}
while(end&&end!==_22.editNode&&end!==_22.document.body&&end.nodeType!==1){
end=end.parentNode;
}
var _28=_5.hitch(this,function(_29,ary){
if(_29.childNodes&&_29.childNodes.length){
var i;
for(i=0;i<_29.childNodes.length;i++){
var c=_29.childNodes[i];
if(c.nodeType==1){
if(_22._sCall("inSelection",[c])){
var tag=c.tagName?c.tagName.toLowerCase():"";
if(_1.indexOf(this.values,tag)!==-1){
ary.push(c);
}
_28(c,ary);
}
}
}
}
});
var _2a=_5.hitch(this,function(_2b){
if(_2b&&_2b.length){
_22.beginEditing();
while(_2b.length){
this._removeFormat(_22,_2b.pop());
}
_22.endEditing();
}
});
var _2c=[];
if(_25==end){
var _2d;
_27=_25;
while(_27&&_27!==_22.editNode&&_27!==_22.document.body){
if(_27.nodeType==1){
tag=_27.tagName?_27.tagName.toLowerCase():"";
if(_1.indexOf(this.values,tag)!==-1){
_2d=_27;
break;
}
}
_27=_27.parentNode;
}
_28(_25,_2c);
if(_2d){
_2c=[_2d].concat(_2c);
}
_2a(_2c);
}else{
_27=_25;
while(_22._sCall("inSelection",[_27])){
if(_27.nodeType==1){
tag=_27.tagName?_27.tagName.toLowerCase():"";
if(_1.indexOf(this.values,tag)!==-1){
_2c.push(_27);
}
_28(_27,_2c);
}
_27=_27.nextSibling;
}
_2a(_2c);
}
_22.onDisplayChanged();
}
}
}else{
_22.execCommand(_23,_24);
}
},_removeFormat:function(_2e,_2f){
if(_2e.customUndo){
while(_2f.firstChild){
_3.place(_2f.firstChild,_2f,"before");
}
_2f.parentNode.removeChild(_2f);
}else{
_2e._sCall("selectElementChildren",[_2f]);
var _30=_2e._sCall("getSelectedHtml",[]);
_2e._sCall("selectElement",[_2f]);
_2e.execCommand("inserthtml",_30||"");
}
}});
var _31=_2("dijit._editor.plugins.FontChoice",_c,{useDefaultCommand:false,_initButton:function(){
var _32={fontName:_14,fontSize:_19,formatBlock:_1f}[this.command],_33=this.params;
if(this.params.custom){
_33.values=this.params.custom;
}
var _34=this.editor;
this.button=new _32(_5.delegate({dir:_34.dir,lang:_34.lang},_33));
this.connect(this.button.select,"onChange",function(_35){
this.editor.focus();
if(this.command=="fontName"&&_35.indexOf(" ")!=-1){
_35="'"+_35+"'";
}
if(this.button._execCommand){
this.button._execCommand(this.editor,this.command,_35);
}else{
this.editor.execCommand(this.command,_35);
}
});
},updateState:function(){
var _36=this.editor;
var _37=this.command;
if(!_36||!_36.isLoaded||!_37.length){
return;
}
if(this.button){
var _38=this.get("disabled");
this.button.set("disabled",_38);
if(_38){
return;
}
var _39;
try{
_39=_36.queryCommandValue(_37)||"";
}
catch(e){
_39="";
}
var _3a=_5.isString(_39)&&_39.match(/'([^']*)'/);
if(_3a){
_39=_3a[1];
}
if(_37==="formatBlock"){
if(!_39||_39=="p"){
_39=null;
var _3b;
var sel=_d.getSelection(this.editor.window);
if(sel&&sel.rangeCount>0){
var _3c=sel.getRangeAt(0);
if(_3c){
_3b=_3c.endContainer;
}
}
while(_3b&&_3b!==_36.editNode&&_3b!==_36.document){
var tg=_3b.tagName?_3b.tagName.toLowerCase():"";
if(tg&&_1.indexOf(this.button.values,tg)>-1){
_39=tg;
break;
}
_3b=_3b.parentNode;
}
if(!_39){
_39="noFormat";
}
}else{
if(_1.indexOf(this.button.values,_39)<0){
_39="noFormat";
}
}
}
if(_39!==this.button.get("value")){
this.button.set("value",_39,false);
}
}
}});
_1.forEach(["fontName","fontSize","formatBlock"],function(_3d){
_c.registry[_3d]=function(_3e){
return new _31({command:_3d,plainText:_3e.plainText});
};
});
_31._FontDropDown=_e;
_31._FontNameDropDown=_14;
_31._FontSizeDropDown=_19;
_31._FormatBlockDropDown=_1f;
return _31;
});
},"url:dijit/templates/CheckedMenuItem.html":"<tr class=\"dijitReset dijitMenuItem\" data-dojo-attach-point=\"focusNode\" role=\"menuitemcheckbox\" tabIndex=\"-1\">\n\t<td class=\"dijitReset dijitMenuItemIconCell\" role=\"presentation\">\n\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitMenuItemIcon dijitCheckedMenuItemIcon\" data-dojo-attach-point=\"iconNode\"/>\n\t\t<span class=\"dijitCheckedMenuItemIconChar\">&#10003;</span>\n\t</td>\n\t<td class=\"dijitReset dijitMenuItemLabel\" colspan=\"2\" data-dojo-attach-point=\"containerNode,labelNode\"></td>\n\t<td class=\"dijitReset dijitMenuItemAccelKey\" style=\"display: none\" data-dojo-attach-point=\"accelKeyNode\"></td>\n\t<td class=\"dijitReset dijitMenuArrowCell\" role=\"presentation\">&#160;</td>\n</tr>\n","dijit/form/TextBox":function(){
define(["dojo/_base/declare","dojo/dom-construct","dojo/dom-style","dojo/_base/kernel","dojo/_base/lang","dojo/sniff","./_FormValueWidget","./_TextBoxMixin","dojo/text!./templates/TextBox.html","../main"],function(_3f,_40,_41,_42,_43,has,_44,_45,_46,_47){
var _48=_3f("dijit.form.TextBox",[_44,_45],{templateString:_46,_singleNodeTemplate:"<input class=\"dijit dijitReset dijitLeft dijitInputField\" data-dojo-attach-point=\"textbox,focusNode\" autocomplete=\"off\" type=\"${type}\" ${!nameAttrSetting} />",_buttonInputDisabled:has("ie")?"disabled":"",baseClass:"dijitTextBox",postMixInProperties:function(){
var _49=this.type.toLowerCase();
if(this.templateString&&this.templateString.toLowerCase()=="input"||((_49=="hidden"||_49=="file")&&this.templateString==this.constructor.prototype.templateString)){
this.templateString=this._singleNodeTemplate;
}
this.inherited(arguments);
},postCreate:function(){
this.inherited(arguments);
if(has("ie")<9){
this.defer(function(){
try{
var s=_41.getComputedStyle(this.domNode);
if(s){
var ff=s.fontFamily;
if(ff){
var _4a=this.domNode.getElementsByTagName("INPUT");
if(_4a){
for(var i=0;i<_4a.length;i++){
_4a[i].style.fontFamily=ff;
}
}
}
}
}
catch(e){
}
});
}
},_onInput:function(e){
this.inherited(arguments);
if(this.intermediateChanges){
this.defer(function(){
this._handleOnChange(this.get("value"),false);
});
}
},_setPlaceHolderAttr:function(v){
this._set("placeHolder",v);
if(!this._phspan){
this._attachPoints.push("_phspan");
this._phspan=_40.create("span",{onmousedown:function(e){
e.preventDefault();
},className:"dijitPlaceHolder dijitInputField"},this.textbox,"after");
}
this._phspan.innerHTML="";
this._phspan.appendChild(this._phspan.ownerDocument.createTextNode(v));
this._updatePlaceHolder();
},_updatePlaceHolder:function(){
if(this._phspan){
this._phspan.style.display=(this.placeHolder&&!this.focused&&!this.textbox.value)?"":"none";
}
},_setValueAttr:function(_4b,_4c,_4d){
this.inherited(arguments);
this._updatePlaceHolder();
},getDisplayedValue:function(){
_42.deprecated(this.declaredClass+"::getDisplayedValue() is deprecated. Use get('displayedValue') instead.","","2.0");
return this.get("displayedValue");
},setDisplayedValue:function(_4e){
_42.deprecated(this.declaredClass+"::setDisplayedValue() is deprecated. Use set('displayedValue', ...) instead.","","2.0");
this.set("displayedValue",_4e);
},_onBlur:function(e){
if(this.disabled){
return;
}
this.inherited(arguments);
this._updatePlaceHolder();
if(has("mozilla")){
if(this.selectOnClick){
this.textbox.selectionStart=this.textbox.selectionEnd=undefined;
}
}
},_onFocus:function(by){
if(this.disabled||this.readOnly){
return;
}
this.inherited(arguments);
this._updatePlaceHolder();
}});
if(has("ie")){
_48.prototype._isTextSelected=function(){
var _4f=this.ownerDocument.selection.createRange();
var _50=_4f.parentElement();
return _50==this.textbox&&_4f.text.length>0;
};
_47._setSelectionRange=_45._setSelectionRange=function(_51,_52,_53){
if(_51.createTextRange){
var r=_51.createTextRange();
r.collapse(true);
r.moveStart("character",-99999);
r.moveStart("character",_52);
r.moveEnd("character",_53-_52);
r.select();
}
};
}
return _48;
});
},"dojo/currency":function(){
define(["./_base/array","./_base/lang","./number","./i18n","./i18n!./cldr/nls/currency","./cldr/monetary"],function(_54,_55,_56,_57,_58,_59){
var _5a={};
_55.setObject("dojo.currency",_5a);
_5a._mixInDefaults=function(_5b){
_5b=_5b||{};
_5b.type="currency";
var _5c=_57.getLocalization("dojo.cldr","currency",_5b.locale)||{};
var iso=_5b.currency;
var _5d=_59.getData(iso);
_54.forEach(["displayName","symbol","group","decimal"],function(_5e){
_5d[_5e]=_5c[iso+"_"+_5e];
});
_5d.fractional=[true,false];
return _55.mixin(_5d,_5b);
};
_5a.format=function(_5f,_60){
return _56.format(_5f,_5a._mixInDefaults(_60));
};
_5a.regexp=function(_61){
return _56.regexp(_5a._mixInDefaults(_61));
};
_5a.parse=function(_62,_63){
return _56.parse(_62,_5a._mixInDefaults(_63));
};
return _5a;
});
},"dijit/layout/ScrollingTabController":function(){
define(["dojo/_base/array","dojo/_base/declare","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/fx","dojo/_base/lang","dojo/on","dojo/query","dojo/sniff","../registry","dojo/text!./templates/ScrollingTabController.html","dojo/text!./templates/_ScrollingTabControllerButton.html","./TabController","./utils","../_WidgetsInTemplateMixin","../Menu","../MenuItem","../form/Button","../_HasDropDown","dojo/NodeList-dom"],function(_64,_65,_66,_67,_68,fx,_69,on,_6a,has,_6b,_6c,_6d,_6e,_6f,_70,_71,_72,_73,_74){
var _75=_65("dijit.layout.ScrollingTabController",[_6e,_70],{baseClass:"dijitTabController dijitScrollingTabController",templateString:_6c,useMenu:true,useSlider:true,tabStripClass:"",widgetsInTemplate:true,_minScroll:5,_setClassAttr:{node:"containerNode",type:"class"},buildRendering:function(){
this.inherited(arguments);
var n=this.domNode;
this.scrollNode=this.tablistWrapper;
this._initButtons();
if(!this.tabStripClass){
this.tabStripClass="dijitTabContainer"+this.tabPosition.charAt(0).toUpperCase()+this.tabPosition.substr(1).replace(/-.*/,"")+"None";
_66.add(n,"tabStrip-disabled");
}
_66.add(this.tablistWrapper,this.tabStripClass);
},onStartup:function(){
this.inherited(arguments);
_68.set(this.domNode,"visibility","");
this._postStartup=true;
this.own(on(this.containerNode,"attrmodified-label, attrmodified-iconclass",_69.hitch(this,function(evt){
if(this._dim){
this.resize(this._dim);
}
})));
},onAddChild:function(_76,_77){
this.inherited(arguments);
_68.set(this.containerNode,"width",(_68.get(this.containerNode,"width")+200)+"px");
},onRemoveChild:function(_78,_79){
var _7a=this.pane2button[_78.id];
if(this._selectedTab===_7a.domNode){
this._selectedTab=null;
}
this.inherited(arguments);
},_initButtons:function(){
this._btnWidth=0;
this._buttons=_6a("> .tabStripButton",this.domNode).filter(function(btn){
if((this.useMenu&&btn==this._menuBtn.domNode)||(this.useSlider&&(btn==this._rightBtn.domNode||btn==this._leftBtn.domNode))){
this._btnWidth+=_67.getMarginSize(btn).w;
return true;
}else{
_68.set(btn,"display","none");
return false;
}
},this);
},_getTabsWidth:function(){
var _7b=this.getChildren();
if(_7b.length){
var _7c=_7b[this.isLeftToRight()?0:_7b.length-1].domNode,_7d=_7b[this.isLeftToRight()?_7b.length-1:0].domNode;
return _7d.offsetLeft+_7d.offsetWidth-_7c.offsetLeft;
}else{
return 0;
}
},_enableBtn:function(_7e){
var _7f=this._getTabsWidth();
_7e=_7e||_68.get(this.scrollNode,"width");
return _7f>0&&_7e<_7f;
},resize:function(dim){
this._dim=dim;
this.scrollNode.style.height="auto";
var cb=this._contentBox=_6f.marginBox2contentBox(this.domNode,{h:0,w:dim.w});
cb.h=this.scrollNode.offsetHeight;
_67.setContentSize(this.domNode,cb);
var _80=this._enableBtn(this._contentBox.w);
this._buttons.style("display",_80?"":"none");
this._leftBtn.layoutAlign="left";
this._rightBtn.layoutAlign="right";
this._menuBtn.layoutAlign=this.isLeftToRight()?"right":"left";
_6f.layoutChildren(this.domNode,this._contentBox,[this._menuBtn,this._leftBtn,this._rightBtn,{domNode:this.scrollNode,layoutAlign:"client"}]);
if(this._selectedTab){
if(this._anim&&this._anim.status()=="playing"){
this._anim.stop();
}
this.scrollNode.scrollLeft=this._convertToScrollLeft(this._getScrollForSelectedTab());
}
this._setButtonClass(this._getScroll());
this._postResize=true;
return {h:this._contentBox.h,w:dim.w};
},_getScroll:function(){
return (this.isLeftToRight()||has("ie")<8||(has("ie")&&has("quirks"))||has("webkit"))?this.scrollNode.scrollLeft:_68.get(this.containerNode,"width")-_68.get(this.scrollNode,"width")+(has("ie")>=8?-1:1)*this.scrollNode.scrollLeft;
},_convertToScrollLeft:function(val){
if(this.isLeftToRight()||has("ie")<8||(has("ie")&&has("quirks"))||has("webkit")){
return val;
}else{
var _81=_68.get(this.containerNode,"width")-_68.get(this.scrollNode,"width");
return (has("ie")>=8?-1:1)*(val-_81);
}
},onSelectChild:function(_82){
var tab=this.pane2button[_82.id];
if(!tab||!_82){
return;
}
var _83=tab.domNode;
if(_83!=this._selectedTab){
this._selectedTab=_83;
if(this._postResize){
var sl=this._getScroll();
if(sl>_83.offsetLeft||sl+_68.get(this.scrollNode,"width")<_83.offsetLeft+_68.get(_83,"width")){
this.createSmoothScroll().play();
}
}
}
this.inherited(arguments);
},_getScrollBounds:function(){
var _84=this.getChildren(),_85=_68.get(this.scrollNode,"width"),_86=_68.get(this.containerNode,"width"),_87=_86-_85,_88=this._getTabsWidth();
if(_84.length&&_88>_85){
return {min:this.isLeftToRight()?0:_84[_84.length-1].domNode.offsetLeft,max:this.isLeftToRight()?(_84[_84.length-1].domNode.offsetLeft+_84[_84.length-1].domNode.offsetWidth)-_85:_87};
}else{
var _89=this.isLeftToRight()?0:_87;
return {min:_89,max:_89};
}
},_getScrollForSelectedTab:function(){
var w=this.scrollNode,n=this._selectedTab,_8a=_68.get(this.scrollNode,"width"),_8b=this._getScrollBounds();
var pos=(n.offsetLeft+_68.get(n,"width")/2)-_8a/2;
pos=Math.min(Math.max(pos,_8b.min),_8b.max);
return pos;
},createSmoothScroll:function(x){
if(arguments.length>0){
var _8c=this._getScrollBounds();
x=Math.min(Math.max(x,_8c.min),_8c.max);
}else{
x=this._getScrollForSelectedTab();
}
if(this._anim&&this._anim.status()=="playing"){
this._anim.stop();
}
var _8d=this,w=this.scrollNode,_8e=new fx.Animation({beforeBegin:function(){
if(this.curve){
delete this.curve;
}
var _8f=w.scrollLeft,_90=_8d._convertToScrollLeft(x);
_8e.curve=new fx._Line(_8f,_90);
},onAnimate:function(val){
w.scrollLeft=val;
}});
this._anim=_8e;
this._setButtonClass(x);
return _8e;
},_getBtnNode:function(e){
var n=e.target;
while(n&&!_66.contains(n,"tabStripButton")){
n=n.parentNode;
}
return n;
},doSlideRight:function(e){
this.doSlide(1,this._getBtnNode(e));
},doSlideLeft:function(e){
this.doSlide(-1,this._getBtnNode(e));
},doSlide:function(_91,_92){
if(_92&&_66.contains(_92,"dijitTabDisabled")){
return;
}
var _93=_68.get(this.scrollNode,"width");
var d=(_93*0.75)*_91;
var to=this._getScroll()+d;
this._setButtonClass(to);
this.createSmoothScroll(to).play();
},_setButtonClass:function(_94){
var _95=this._getScrollBounds();
this._leftBtn.set("disabled",_94<=_95.min);
this._rightBtn.set("disabled",_94>=_95.max);
}});
var _96=_65("dijit.layout._ScrollingTabControllerButtonMixin",null,{baseClass:"dijitTab tabStripButton",templateString:_6d,tabIndex:"",isFocusable:function(){
return false;
}});
_65("dijit.layout._ScrollingTabControllerButton",[_73,_96]);
_65("dijit.layout._ScrollingTabControllerMenuButton",[_73,_74,_96],{containerId:"",tabIndex:"-1",isLoaded:function(){
return false;
},loadDropDown:function(_97){
this.dropDown=new _71({id:this.containerId+"_menu",ownerDocument:this.ownerDocument,dir:this.dir,lang:this.lang,textDir:this.textDir});
var _98=_6b.byId(this.containerId);
_64.forEach(_98.getChildren(),function(_99){
var _9a=new _72({id:_99.id+"_stcMi",label:_99.title,iconClass:_99.iconClass,disabled:_99.disabled,ownerDocument:this.ownerDocument,dir:_99.dir,lang:_99.lang,textDir:_99.textDir,onClick:function(){
_98.selectChild(_99);
}});
this.dropDown.addChild(_9a);
},this);
_97();
},closeDropDown:function(_9b){
this.inherited(arguments);
if(this.dropDown){
this.dropDown.destroyRecursive();
delete this.dropDown;
}
}});
return _75;
});
},"url:dijit/form/templates/ComboButton.html":"<table class=\"dijit dijitReset dijitInline dijitLeft\"\n\tcellspacing='0' cellpadding='0' role=\"presentation\"\n\t><tbody role=\"presentation\"><tr role=\"presentation\"\n\t\t><td class=\"dijitReset dijitStretch dijitButtonNode\" data-dojo-attach-point=\"buttonNode\" data-dojo-attach-event=\"ondijitclick:_onClick,onkeypress:_onButtonKeyPress\"\n\t\t><div id=\"${id}_button\" class=\"dijitReset dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"titleNode\"\n\t\t\trole=\"button\" aria-labelledby=\"${id}_label\"\n\t\t\t><div class=\"dijitReset dijitInline dijitIcon\" data-dojo-attach-point=\"iconNode\" role=\"presentation\"></div\n\t\t\t><div class=\"dijitReset dijitInline dijitButtonText\" id=\"${id}_label\" data-dojo-attach-point=\"containerNode\" role=\"presentation\"></div\n\t\t></div\n\t\t></td\n\t\t><td id=\"${id}_arrow\" class='dijitReset dijitRight dijitButtonNode dijitArrowButton'\n\t\t\tdata-dojo-attach-point=\"_popupStateNode,focusNode,_buttonNode\"\n\t\t\tdata-dojo-attach-event=\"onkeypress:_onArrowKeyPress\"\n\t\t\ttitle=\"${optionsTitle}\"\n\t\t\trole=\"button\" aria-haspopup=\"true\"\n\t\t\t><div class=\"dijitReset dijitArrowButtonInner\" role=\"presentation\"></div\n\t\t\t><div class=\"dijitReset dijitArrowButtonChar\" role=\"presentation\">&#9660;</div\n\t\t></td\n\t\t><td style=\"display:none !important;\"\n\t\t\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" data-dojo-attach-point=\"valueNode\" role=\"presentation\"\n\t\t/></td></tr></tbody\n></table>\n","dijit/DialogUnderlay":function(){
define(["dojo/_base/declare","dojo/dom-attr","dojo/window","./_Widget","./_TemplatedMixin","./BackgroundIframe"],function(_9c,_9d,_9e,_9f,_a0,_a1){
return _9c("dijit.DialogUnderlay",[_9f,_a0],{templateString:"<div class='dijitDialogUnderlayWrapper'><div class='dijitDialogUnderlay' data-dojo-attach-point='node'></div></div>",dialogId:"","class":"",_setDialogIdAttr:function(id){
_9d.set(this.node,"id",id+"_underlay");
this._set("dialogId",id);
},_setClassAttr:function(_a2){
this.node.className="dijitDialogUnderlay "+_a2;
this._set("class",_a2);
},postCreate:function(){
this.ownerDocumentBody.appendChild(this.domNode);
},layout:function(){
var is=this.node.style,os=this.domNode.style;
os.display="none";
var _a3=_9e.getBox(this.ownerDocument);
os.top=_a3.t+"px";
os.left=_a3.l+"px";
is.width=_a3.w+"px";
is.height=_a3.h+"px";
os.display="block";
},show:function(){
this.domNode.style.display="block";
this.layout();
this.bgIframe=new _a1(this.domNode);
},hide:function(){
this.bgIframe.destroy();
delete this.bgIframe;
this.domNode.style.display="none";
}});
});
},"dijit/_editor/html":function(){
define(["dojo/_base/array","dojo/_base/lang","dojo/sniff"],function(_a4,_a5,has){
var _a6={};
_a5.setObject("dijit._editor.html",_a6);
var _a7=_a6.escapeXml=function(str,_a8){
str=str.replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;");
if(!_a8){
str=str.replace(/'/gm,"&#39;");
}
return str;
};
_a6.getNodeHtml=function(_a9){
var _aa=[];
_a6.getNodeHtmlHelper(_a9,_aa);
return _aa.join("");
};
_a6.getNodeHtmlHelper=function(_ab,_ac){
switch(_ab.nodeType){
case 1:
var _ad=_ab.nodeName.toLowerCase();
if(!_ad||_ad.charAt(0)=="/"){
return "";
}
_ac.push("<",_ad);
var _ae=[],_af={};
var _b0;
if(has("dom-attributes-explicit")||has("dom-attributes-specified-flag")){
var i=0;
while((_b0=_ab.attributes[i++])){
var n=_b0.name;
if(n.substr(0,3)!=="_dj"&&(!has("dom-attributes-specified-flag")||_b0.specified)&&!(n in _af)){
var v=_b0.value;
if(n=="src"||n=="href"){
if(_ab.getAttribute("_djrealurl")){
v=_ab.getAttribute("_djrealurl");
}
}
if(has("ie")===8&&n==="style"){
v=v.replace("HEIGHT:","height:").replace("WIDTH:","width:");
}
_ae.push([n,v]);
_af[n]=v;
}
}
}else{
var _b1=/^input$|^img$/i.test(_ab.nodeName)?_ab:_ab.cloneNode(false);
var s=_b1.outerHTML;
var _b2=/[\w-]+=("[^"]*"|'[^']*'|\S*)/gi;
var _b3=s.match(_b2);
s=s.substr(0,s.indexOf(">"));
_a4.forEach(_b3,function(_b4){
if(_b4){
var idx=_b4.indexOf("=");
if(idx>0){
var key=_b4.substring(0,idx);
if(key.substr(0,3)!="_dj"){
if(key=="src"||key=="href"){
if(_ab.getAttribute("_djrealurl")){
_ae.push([key,_ab.getAttribute("_djrealurl")]);
return;
}
}
var val,_b5;
switch(key){
case "style":
val=_ab.style.cssText.toLowerCase();
break;
case "class":
val=_ab.className;
break;
case "width":
if(_ad==="img"){
_b5=/width=(\S+)/i.exec(s);
if(_b5){
val=_b5[1];
}
break;
}
case "height":
if(_ad==="img"){
_b5=/height=(\S+)/i.exec(s);
if(_b5){
val=_b5[1];
}
break;
}
default:
val=_ab.getAttribute(key);
}
if(val!=null){
_ae.push([key,val.toString()]);
}
}
}
}
},this);
}
_ae.sort(function(a,b){
return a[0]<b[0]?-1:(a[0]==b[0]?0:1);
});
var j=0;
while((_b0=_ae[j++])){
_ac.push(" ",_b0[0],"=\"",(typeof _b0[1]==="string"?_a7(_b0[1],true):_b0[1]),"\"");
}
switch(_ad){
case "br":
case "hr":
case "img":
case "input":
case "base":
case "meta":
case "area":
case "basefont":
_ac.push(" />");
break;
case "script":
_ac.push(">",_ab.innerHTML,"</",_ad,">");
break;
default:
_ac.push(">");
if(_ab.hasChildNodes()){
_a6.getChildrenHtmlHelper(_ab,_ac);
}
_ac.push("</",_ad,">");
}
break;
case 4:
case 3:
_ac.push(_a7(_ab.nodeValue,true));
break;
case 8:
_ac.push("<!--",_a7(_ab.nodeValue,true),"-->");
break;
default:
_ac.push("<!-- Element not recognized - Type: ",_ab.nodeType," Name: ",_ab.nodeName,"-->");
}
};
_a6.getChildrenHtml=function(_b6){
var _b7=[];
_a6.getChildrenHtmlHelper(_b6,_b7);
return _b7.join("");
};
_a6.getChildrenHtmlHelper=function(dom,_b8){
if(!dom){
return;
}
var _b9=dom["childNodes"]||dom;
var _ba=!has("ie")||_b9!==dom;
var _bb,i=0;
while((_bb=_b9[i++])){
if(!_ba||_bb.parentNode==dom){
_a6.getNodeHtmlHelper(_bb,_b8);
}
}
};
return _a6;
});
},"dijit/_HasDropDown":function(){
define(["dojo/_base/declare","dojo/_base/Deferred","dojo/_base/event","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/has","dojo/keys","dojo/_base/lang","dojo/on","dojo/window","./registry","./focus","./popup","./_FocusMixin"],function(_bc,_bd,_be,dom,_bf,_c0,_c1,_c2,has,_c3,_c4,on,_c5,_c6,_c7,_c8,_c9){
return _bc("dijit._HasDropDown",_c9,{_buttonNode:null,_arrowWrapperNode:null,_popupStateNode:null,_aroundNode:null,dropDown:null,autoWidth:true,forceWidth:false,maxHeight:0,dropDownPosition:["below","above"],_stopClickEvents:true,_onDropDownMouseDown:function(e){
if(this.disabled||this.readOnly){
return;
}
e.preventDefault();
this._docHandler=this.connect(this.ownerDocument,"mouseup","_onDropDownMouseUp");
this.toggleDropDown();
},_onDropDownMouseUp:function(e){
if(e&&this._docHandler){
this.disconnect(this._docHandler);
}
var _ca=this.dropDown,_cb=false;
if(e&&this._opened){
var c=_c1.position(this._buttonNode,true);
if(!(e.pageX>=c.x&&e.pageX<=c.x+c.w)||!(e.pageY>=c.y&&e.pageY<=c.y+c.h)){
var t=e.target;
while(t&&!_cb){
if(_c0.contains(t,"dijitPopup")){
_cb=true;
}else{
t=t.parentNode;
}
}
if(_cb){
t=e.target;
if(_ca.onItemClick){
var _cc;
while(t&&!(_cc=_c6.byNode(t))){
t=t.parentNode;
}
if(_cc&&_cc.onClick&&_cc.getParent){
_cc.getParent().onItemClick(_cc,e);
}
}
return;
}
}
}
if(this._opened){
if(_ca.focus&&_ca.autoFocus!==false){
this._focusDropDownTimer=this.defer(function(){
_ca.focus();
delete this._focusDropDownTimer;
});
}
}else{
this.defer("focus");
}
if(has("touch")){
this._justGotMouseUp=true;
this.defer(function(){
this._justGotMouseUp=false;
});
}
},_onDropDownClick:function(e){
if(has("touch")&&!this._justGotMouseUp){
this._onDropDownMouseDown(e);
this._onDropDownMouseUp(e);
}
if(this._stopClickEvents){
_be.stop(e);
}
},buildRendering:function(){
this.inherited(arguments);
this._buttonNode=this._buttonNode||this.focusNode||this.domNode;
this._popupStateNode=this._popupStateNode||this.focusNode||this._buttonNode;
var _cd={"after":this.isLeftToRight()?"Right":"Left","before":this.isLeftToRight()?"Left":"Right","above":"Up","below":"Down","left":"Left","right":"Right"}[this.dropDownPosition[0]]||this.dropDownPosition[0]||"Down";
_c0.add(this._arrowWrapperNode||this._buttonNode,"dijit"+_cd+"ArrowButton");
},postCreate:function(){
this.inherited(arguments);
var _ce=this.focusNode||this.domNode;
this.own(on(this._buttonNode,"mousedown",_c4.hitch(this,"_onDropDownMouseDown")),on(this._buttonNode,"click",_c4.hitch(this,"_onDropDownClick")),on(_ce,"keydown",_c4.hitch(this,"_onKey")),on(_ce,"keyup",_c4.hitch(this,"_onKeyUp")));
},destroy:function(){
if(this.dropDown){
if(!this.dropDown._destroyed){
this.dropDown.destroyRecursive();
}
delete this.dropDown;
}
this.inherited(arguments);
},_onKey:function(e){
if(this.disabled||this.readOnly){
return;
}
var d=this.dropDown,_cf=e.target;
if(d&&this._opened&&d.handleKey){
if(d.handleKey(e)===false){
_be.stop(e);
return;
}
}
if(d&&this._opened&&e.keyCode==_c3.ESCAPE){
this.closeDropDown();
_be.stop(e);
}else{
if(!this._opened&&(e.keyCode==_c3.DOWN_ARROW||((e.keyCode==_c3.ENTER||e.keyCode==_c3.SPACE)&&((_cf.tagName||"").toLowerCase()!=="input"||(_cf.type&&_cf.type.toLowerCase()!=="text"))))){
this._toggleOnKeyUp=true;
_be.stop(e);
}
}
},_onKeyUp:function(){
if(this._toggleOnKeyUp){
delete this._toggleOnKeyUp;
this.toggleDropDown();
var d=this.dropDown;
if(d&&d.focus){
this.defer(_c4.hitch(d,"focus"),1);
}
}
},_onBlur:function(){
var _d0=_c7.curNode&&this.dropDown&&dom.isDescendant(_c7.curNode,this.dropDown.domNode);
this.closeDropDown(_d0);
this.inherited(arguments);
},isLoaded:function(){
return true;
},loadDropDown:function(_d1){
_d1();
},loadAndOpenDropDown:function(){
var d=new _bd(),_d2=_c4.hitch(this,function(){
this.openDropDown();
d.resolve(this.dropDown);
});
if(!this.isLoaded()){
this.loadDropDown(_d2);
}else{
_d2();
}
return d;
},toggleDropDown:function(){
if(this.disabled||this.readOnly){
return;
}
if(!this._opened){
this.loadAndOpenDropDown();
}else{
this.closeDropDown();
}
},openDropDown:function(){
var _d3=this.dropDown,_d4=_d3.domNode,_d5=this._aroundNode||this.domNode,_d6=this;
if(!this._preparedNode){
this._preparedNode=true;
if(_d4.style.width){
this._explicitDDWidth=true;
}
if(_d4.style.height){
this._explicitDDHeight=true;
}
}
if(this.maxHeight||this.forceWidth||this.autoWidth){
var _d7={display:"",visibility:"hidden"};
if(!this._explicitDDWidth){
_d7.width="";
}
if(!this._explicitDDHeight){
_d7.height="";
}
_c2.set(_d4,_d7);
var _d8=this.maxHeight;
if(_d8==-1){
var _d9=_c5.getBox(this.ownerDocument),_da=_c1.position(_d5,false);
_d8=Math.floor(Math.max(_da.y,_d9.h-(_da.y+_da.h)));
}
_c8.moveOffScreen(_d3);
if(_d3.startup&&!_d3._started){
_d3.startup();
}
var mb=_c1.getMarginSize(_d4);
var _db=(_d8&&mb.h>_d8);
_c2.set(_d4,{overflowX:"visible",overflowY:_db?"auto":"visible"});
if(_db){
mb.h=_d8;
if("w" in mb){
mb.w+=16;
}
}else{
delete mb.h;
}
if(this.forceWidth){
mb.w=_d5.offsetWidth;
}else{
if(this.autoWidth){
mb.w=Math.max(mb.w,_d5.offsetWidth);
}else{
delete mb.w;
}
}
if(_c4.isFunction(_d3.resize)){
_d3.resize(mb);
}else{
_c1.setMarginBox(_d4,mb);
}
}
var _dc=_c8.open({parent:this,popup:_d3,around:_d5,orient:this.dropDownPosition,onExecute:function(){
_d6.closeDropDown(true);
},onCancel:function(){
_d6.closeDropDown(true);
},onClose:function(){
_bf.set(_d6._popupStateNode,"popupActive",false);
_c0.remove(_d6._popupStateNode,"dijitHasDropDownOpen");
_d6._set("_opened",false);
}});
_bf.set(this._popupStateNode,"popupActive","true");
_c0.add(this._popupStateNode,"dijitHasDropDownOpen");
this._set("_opened",true);
this.domNode.setAttribute("aria-expanded","true");
return _dc;
},closeDropDown:function(_dd){
if(this._focusDropDownTimer){
this._focusDropDownTimer.remove();
delete this._focusDropDownTimer;
}
if(this._opened){
this.domNode.setAttribute("aria-expanded","false");
if(_dd){
this.focus();
}
_c8.close(this.dropDown);
this._opened=false;
}
}});
});
},"dijit/tree/TreeStoreModel":function(){
define(["dojo/_base/array","dojo/aspect","dojo/_base/declare","dojo/_base/lang"],function(_de,_df,_e0,_e1){
return _e0("dijit.tree.TreeStoreModel",null,{store:null,childrenAttrs:["children"],newItemIdAttr:"id",labelAttr:"",root:null,query:null,deferItemLoadingUntilExpand:false,constructor:function(_e2){
_e1.mixin(this,_e2);
this.connects=[];
var _e3=this.store;
if(!_e3.getFeatures()["dojo.data.api.Identity"]){
throw new Error("dijit.tree.TreeStoreModel: store must support dojo.data.Identity");
}
if(_e3.getFeatures()["dojo.data.api.Notification"]){
this.connects=this.connects.concat([_df.after(_e3,"onNew",_e1.hitch(this,"onNewItem"),true),_df.after(_e3,"onDelete",_e1.hitch(this,"onDeleteItem"),true),_df.after(_e3,"onSet",_e1.hitch(this,"onSetItem"),true)]);
}
},destroy:function(){
var h;
while(h=this.connects.pop()){
h.remove();
}
},getRoot:function(_e4,_e5){
if(this.root){
_e4(this.root);
}else{
this.store.fetch({query:this.query,onComplete:_e1.hitch(this,function(_e6){
if(_e6.length!=1){
throw new Error("dijit.tree.TreeStoreModel: root query returned "+_e6.length+" items, but must return exactly one");
}
this.root=_e6[0];
_e4(this.root);
}),onError:_e5});
}
},mayHaveChildren:function(_e7){
return _de.some(this.childrenAttrs,function(_e8){
return this.store.hasAttribute(_e7,_e8);
},this);
},getChildren:function(_e9,_ea,_eb){
var _ec=this.store;
if(!_ec.isItemLoaded(_e9)){
var _ed=_e1.hitch(this,arguments.callee);
_ec.loadItem({item:_e9,onItem:function(_ee){
_ed(_ee,_ea,_eb);
},onError:_eb});
return;
}
var _ef=[];
for(var i=0;i<this.childrenAttrs.length;i++){
var _f0=_ec.getValues(_e9,this.childrenAttrs[i]);
_ef=_ef.concat(_f0);
}
var _f1=0;
if(!this.deferItemLoadingUntilExpand){
_de.forEach(_ef,function(_f2){
if(!_ec.isItemLoaded(_f2)){
_f1++;
}
});
}
if(_f1==0){
_ea(_ef);
}else{
_de.forEach(_ef,function(_f3,idx){
if(!_ec.isItemLoaded(_f3)){
_ec.loadItem({item:_f3,onItem:function(_f4){
_ef[idx]=_f4;
if(--_f1==0){
_ea(_ef);
}
},onError:_eb});
}
});
}
},isItem:function(_f5){
return this.store.isItem(_f5);
},fetchItemByIdentity:function(_f6){
this.store.fetchItemByIdentity(_f6);
},getIdentity:function(_f7){
return this.store.getIdentity(_f7);
},getLabel:function(_f8){
if(this.labelAttr){
return this.store.getValue(_f8,this.labelAttr);
}else{
return this.store.getLabel(_f8);
}
},newItem:function(_f9,_fa,_fb){
var _fc={parent:_fa,attribute:this.childrenAttrs[0]},_fd;
if(this.newItemIdAttr&&_f9[this.newItemIdAttr]){
this.fetchItemByIdentity({identity:_f9[this.newItemIdAttr],scope:this,onItem:function(_fe){
if(_fe){
this.pasteItem(_fe,null,_fa,true,_fb);
}else{
_fd=this.store.newItem(_f9,_fc);
if(_fd&&(_fb!=undefined)){
this.pasteItem(_fd,_fa,_fa,false,_fb);
}
}
}});
}else{
_fd=this.store.newItem(_f9,_fc);
if(_fd&&(_fb!=undefined)){
this.pasteItem(_fd,_fa,_fa,false,_fb);
}
}
},pasteItem:function(_ff,_100,_101,_102,_103){
var _104=this.store,_105=this.childrenAttrs[0];
if(_100){
_de.forEach(this.childrenAttrs,function(attr){
if(_104.containsValue(_100,attr,_ff)){
if(!_102){
var _106=_de.filter(_104.getValues(_100,attr),function(x){
return x!=_ff;
});
_104.setValues(_100,attr,_106);
}
_105=attr;
}
});
}
if(_101){
if(typeof _103=="number"){
var _107=_104.getValues(_101,_105).slice();
_107.splice(_103,0,_ff);
_104.setValues(_101,_105,_107);
}else{
_104.setValues(_101,_105,_104.getValues(_101,_105).concat(_ff));
}
}
},onChange:function(){
},onChildrenChange:function(){
},onDelete:function(){
},onNewItem:function(item,_108){
if(!_108){
return;
}
this.getChildren(_108.item,_e1.hitch(this,function(_109){
this.onChildrenChange(_108.item,_109);
}));
},onDeleteItem:function(item){
this.onDelete(item);
},onSetItem:function(item,_10a){
if(_de.indexOf(this.childrenAttrs,_10a)!=-1){
this.getChildren(item,_e1.hitch(this,function(_10b){
this.onChildrenChange(item,_10b);
}));
}else{
this.onChange(item);
}
}});
});
},"dijit/_editor/plugins/EnterKeyHandling":function(){
define(["dojo/_base/declare","dojo/dom-construct","dojo/_base/event","dojo/keys","dojo/_base/lang","dojo/sniff","dojo/_base/window","dojo/window","../_Plugin","../RichText","../range","../../_base/focus"],function(_10c,_10d,_10e,keys,lang,has,win,_10f,_110,_111,_112,_113){
return _10c("dijit._editor.plugins.EnterKeyHandling",_110,{blockNodeForEnter:"BR",constructor:function(args){
if(args){
if("blockNodeForEnter" in args){
args.blockNodeForEnter=args.blockNodeForEnter.toUpperCase();
}
lang.mixin(this,args);
}
},setEditor:function(_114){
if(this.editor===_114){
return;
}
this.editor=_114;
if(this.blockNodeForEnter=="BR"){
this.editor.customUndo=true;
_114.onLoadDeferred.then(lang.hitch(this,function(d){
this.connect(_114.document,"onkeypress",function(e){
if(e.charOrCode==keys.ENTER){
var ne=lang.mixin({},e);
ne.shiftKey=true;
if(!this.handleEnterKey(ne)){
_10e.stop(e);
}
}
});
if(has("ie")>=9){
this.connect(_114.document,"onpaste",function(e){
setTimeout(dojo.hitch(this,function(){
var r=this.editor.document.selection.createRange();
r.move("character",-1);
r.select();
r.move("character",1);
r.select();
}),0);
});
}
return d;
}));
}else{
if(this.blockNodeForEnter){
var h=lang.hitch(this,this.handleEnterKey);
_114.addKeyHandler(13,0,0,h);
_114.addKeyHandler(13,0,1,h);
this.connect(this.editor,"onKeyPressed","onKeyPressed");
}
}
},onKeyPressed:function(){
if(this._checkListLater){
if(win.withGlobal(this.editor.window,"isCollapsed",_113)){
var _115=this.editor._sCall("getAncestorElement",["LI"]);
if(!_115){
_111.prototype.execCommand.call(this.editor,"formatblock",this.blockNodeForEnter);
var _116=this.editor._sCall("getAncestorElement",[this.blockNodeForEnter]);
if(_116){
_116.innerHTML=this.bogusHtmlContent;
if(has("ie")<=9){
var r=this.editor.document.selection.createRange();
r.move("character",-1);
r.select();
}
}else{
console.error("onKeyPressed: Cannot find the new block node");
}
}else{
if(has("mozilla")){
if(_115.parentNode.parentNode.nodeName=="LI"){
_115=_115.parentNode.parentNode;
}
}
var fc=_115.firstChild;
if(fc&&fc.nodeType==1&&(fc.nodeName=="UL"||fc.nodeName=="OL")){
_115.insertBefore(fc.ownerDocument.createTextNode(" "),fc);
var _117=_112.create(this.editor.window);
_117.setStart(_115.firstChild,0);
var _118=_112.getSelection(this.editor.window,true);
_118.removeAllRanges();
_118.addRange(_117);
}
}
}
this._checkListLater=false;
}
if(this._pressedEnterInBlock){
if(this._pressedEnterInBlock.previousSibling){
this.removeTrailingBr(this._pressedEnterInBlock.previousSibling);
}
delete this._pressedEnterInBlock;
}
},bogusHtmlContent:"&#160;",blockNodes:/^(?:P|H1|H2|H3|H4|H5|H6|LI)$/,handleEnterKey:function(e){
var _119,_11a,_11b,_11c,_11d,_11e,doc=this.editor.document,br,rs,txt;
if(e.shiftKey){
var _11f=this.editor._sCall("getParentElement",[]);
var _120=_112.getAncestor(_11f,this.blockNodes);
if(_120){
if(_120.tagName=="LI"){
return true;
}
_119=_112.getSelection(this.editor.window);
_11a=_119.getRangeAt(0);
if(!_11a.collapsed){
_11a.deleteContents();
_119=_112.getSelection(this.editor.window);
_11a=_119.getRangeAt(0);
}
if(_112.atBeginningOfContainer(_120,_11a.startContainer,_11a.startOffset)){
br=doc.createElement("br");
_11b=_112.create(this.editor.window);
_120.insertBefore(br,_120.firstChild);
_11b.setStartAfter(br);
_119.removeAllRanges();
_119.addRange(_11b);
}else{
if(_112.atEndOfContainer(_120,_11a.startContainer,_11a.startOffset)){
_11b=_112.create(this.editor.window);
br=doc.createElement("br");
_120.appendChild(br);
_120.appendChild(doc.createTextNode(" "));
_11b.setStart(_120.lastChild,0);
_119.removeAllRanges();
_119.addRange(_11b);
}else{
rs=_11a.startContainer;
if(rs&&rs.nodeType==3){
txt=rs.nodeValue;
_11c=doc.createTextNode(txt.substring(0,_11a.startOffset));
_11d=doc.createTextNode(txt.substring(_11a.startOffset));
_11e=doc.createElement("br");
if(_11d.nodeValue==""&&has("webkit")){
_11d=doc.createTextNode(" ");
}
_10d.place(_11c,rs,"after");
_10d.place(_11e,_11c,"after");
_10d.place(_11d,_11e,"after");
_10d.destroy(rs);
_11b=_112.create(this.editor.window);
_11b.setStart(_11d,0);
_119.removeAllRanges();
_119.addRange(_11b);
return false;
}
return true;
}
}
}else{
_119=_112.getSelection(this.editor.window);
if(_119.rangeCount){
_11a=_119.getRangeAt(0);
if(_11a&&_11a.startContainer){
if(!_11a.collapsed){
_11a.deleteContents();
_119=_112.getSelection(this.editor.window);
_11a=_119.getRangeAt(0);
}
rs=_11a.startContainer;
if(rs&&rs.nodeType==3){
var _121=false;
var _122=_11a.startOffset;
if(rs.length<_122){
ret=this._adjustNodeAndOffset(rs,_122);
rs=ret.node;
_122=ret.offset;
}
txt=rs.nodeValue;
_11c=doc.createTextNode(txt.substring(0,_122));
_11d=doc.createTextNode(txt.substring(_122));
_11e=doc.createElement("br");
if(!_11d.length){
_11d=doc.createTextNode(" ");
_121=true;
}
if(_11c.length){
_10d.place(_11c,rs,"after");
}else{
_11c=rs;
}
_10d.place(_11e,_11c,"after");
_10d.place(_11d,_11e,"after");
_10d.destroy(rs);
_11b=_112.create(this.editor.window);
_11b.setStart(_11d,0);
_11b.setEnd(_11d,_11d.length);
_119.removeAllRanges();
_119.addRange(_11b);
if(_121&&!has("webkit")){
this.editor._sCall("remove",[]);
}else{
this.editor._sCall("collapse",[true]);
}
}else{
var _123;
if(_11a.startOffset>=0){
_123=rs.childNodes[_11a.startOffset];
}
var _11e=doc.createElement("br");
var _11d=doc.createTextNode(" ");
if(!_123){
rs.appendChild(_11e);
rs.appendChild(_11d);
}else{
_10d.place(_11e,_123,"before");
_10d.place(_11d,_11e,"after");
}
_11b=_112.create(this.editor.window);
_11b.setStart(_11d,0);
_11b.setEnd(_11d,_11d.length);
_119.removeAllRanges();
_119.addRange(_11b);
this.editor._sCall("collapse",[true]);
}
}
}else{
_111.prototype.execCommand.call(this.editor,"inserthtml","<br>");
}
}
return false;
}
var _124=true;
_119=_112.getSelection(this.editor.window);
_11a=_119.getRangeAt(0);
if(!_11a.collapsed){
_11a.deleteContents();
_119=_112.getSelection(this.editor.window);
_11a=_119.getRangeAt(0);
}
var _125=_112.getBlockAncestor(_11a.endContainer,null,this.editor.editNode);
var _126=_125.blockNode;
if((this._checkListLater=(_126&&(_126.nodeName=="LI"||_126.parentNode.nodeName=="LI")))){
if(has("mozilla")){
this._pressedEnterInBlock=_126;
}
if(/^(\s|&nbsp;|&#160;|\xA0|<span\b[^>]*\bclass=['"]Apple-style-span['"][^>]*>(\s|&nbsp;|&#160;|\xA0)<\/span>)?(<br>)?$/.test(_126.innerHTML)){
_126.innerHTML="";
if(has("webkit")){
_11b=_112.create(this.editor.window);
_11b.setStart(_126,0);
_119.removeAllRanges();
_119.addRange(_11b);
}
this._checkListLater=false;
}
return true;
}
if(!_125.blockNode||_125.blockNode===this.editor.editNode){
try{
_111.prototype.execCommand.call(this.editor,"formatblock",this.blockNodeForEnter);
}
catch(e2){
}
_125={blockNode:this.editor._sCall("getAncestorElement",[this.blockNodeForEnter]),blockContainer:this.editor.editNode};
if(_125.blockNode){
if(_125.blockNode!=this.editor.editNode&&(!(_125.blockNode.textContent||_125.blockNode.innerHTML).replace(/^\s+|\s+$/g,"").length)){
this.removeTrailingBr(_125.blockNode);
return false;
}
}else{
_125.blockNode=this.editor.editNode;
}
_119=_112.getSelection(this.editor.window);
_11a=_119.getRangeAt(0);
}
var _127=doc.createElement(this.blockNodeForEnter);
_127.innerHTML=this.bogusHtmlContent;
this.removeTrailingBr(_125.blockNode);
var _128=_11a.endOffset;
var node=_11a.endContainer;
if(node.length<_128){
var ret=this._adjustNodeAndOffset(node,_128);
node=ret.node;
_128=ret.offset;
}
if(_112.atEndOfContainer(_125.blockNode,node,_128)){
if(_125.blockNode===_125.blockContainer){
_125.blockNode.appendChild(_127);
}else{
_10d.place(_127,_125.blockNode,"after");
}
_124=false;
_11b=_112.create(this.editor.window);
_11b.setStart(_127,0);
_119.removeAllRanges();
_119.addRange(_11b);
if(this.editor.height){
_10f.scrollIntoView(_127);
}
}else{
if(_112.atBeginningOfContainer(_125.blockNode,_11a.startContainer,_11a.startOffset)){
_10d.place(_127,_125.blockNode,_125.blockNode===_125.blockContainer?"first":"before");
if(_127.nextSibling&&this.editor.height){
_11b=_112.create(this.editor.window);
_11b.setStart(_127.nextSibling,0);
_119.removeAllRanges();
_119.addRange(_11b);
_10f.scrollIntoView(_127.nextSibling);
}
_124=false;
}else{
if(_125.blockNode===_125.blockContainer){
_125.blockNode.appendChild(_127);
}else{
_10d.place(_127,_125.blockNode,"after");
}
_124=false;
if(_125.blockNode.style){
if(_127.style){
if(_125.blockNode.style.cssText){
_127.style.cssText=_125.blockNode.style.cssText;
}
}
}
rs=_11a.startContainer;
var _129;
if(rs&&rs.nodeType==3){
var _12a,_12b;
_128=_11a.endOffset;
if(rs.length<_128){
ret=this._adjustNodeAndOffset(rs,_128);
rs=ret.node;
_128=ret.offset;
}
txt=rs.nodeValue;
_11c=doc.createTextNode(txt.substring(0,_128));
_11d=doc.createTextNode(txt.substring(_128,txt.length));
_10d.place(_11c,rs,"before");
_10d.place(_11d,rs,"after");
_10d.destroy(rs);
var _12c=_11c.parentNode;
while(_12c!==_125.blockNode){
var tg=_12c.tagName;
var _12d=doc.createElement(tg);
if(_12c.style){
if(_12d.style){
if(_12c.style.cssText){
_12d.style.cssText=_12c.style.cssText;
}
}
}
if(_12c.tagName==="FONT"){
if(_12c.color){
_12d.color=_12c.color;
}
if(_12c.face){
_12d.face=_12c.face;
}
if(_12c.size){
_12d.size=_12c.size;
}
}
_12a=_11d;
while(_12a){
_12b=_12a.nextSibling;
_12d.appendChild(_12a);
_12a=_12b;
}
_10d.place(_12d,_12c,"after");
_11c=_12c;
_11d=_12d;
_12c=_12c.parentNode;
}
_12a=_11d;
if(_12a.nodeType==1||(_12a.nodeType==3&&_12a.nodeValue)){
_127.innerHTML="";
}
_129=_12a;
while(_12a){
_12b=_12a.nextSibling;
_127.appendChild(_12a);
_12a=_12b;
}
}
_11b=_112.create(this.editor.window);
var _12e;
var _12f=_129;
if(this.blockNodeForEnter!=="BR"){
while(_12f){
_12e=_12f;
_12b=_12f.firstChild;
_12f=_12b;
}
if(_12e&&_12e.parentNode){
_127=_12e.parentNode;
_11b.setStart(_127,0);
_119.removeAllRanges();
_119.addRange(_11b);
if(this.editor.height){
_10f.scrollIntoView(_127);
}
if(has("mozilla")){
this._pressedEnterInBlock=_125.blockNode;
}
}else{
_124=true;
}
}else{
_11b.setStart(_127,0);
_119.removeAllRanges();
_119.addRange(_11b);
if(this.editor.height){
_10f.scrollIntoView(_127);
}
if(has("mozilla")){
this._pressedEnterInBlock=_125.blockNode;
}
}
}
}
return _124;
},_adjustNodeAndOffset:function(node,_130){
while(node.length<_130&&node.nextSibling&&node.nextSibling.nodeType==3){
_130=_130-node.length;
node=node.nextSibling;
}
return {"node":node,"offset":_130};
},removeTrailingBr:function(_131){
var para=/P|DIV|LI/i.test(_131.tagName)?_131:this.editor._sCall("getParentOfType",[_131,["P","DIV","LI"]]);
if(!para){
return;
}
if(para.lastChild){
if((para.childNodes.length>1&&para.lastChild.nodeType==3&&/^[\s\xAD]*$/.test(para.lastChild.nodeValue))||para.lastChild.tagName=="BR"){
_10d.destroy(para.lastChild);
}
}
if(!para.childNodes.length){
para.innerHTML=this.bogusHtmlContent;
}
}});
});
},"dijit/_MenuBase":function(){
define(["dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/_base/lang","dojo/mouse","dojo/on","dojo/window","./a11yclick","./popup","./registry","./_Widget","./_KeyNavContainer","./_TemplatedMixin"],function(_132,_133,dom,_134,_135,lang,_136,on,_137,_138,pm,_139,_13a,_13b,_13c){
return _133("dijit._MenuBase",[_13a,_13c,_13b],{parentMenu:null,popupDelay:500,autoFocus:false,childSelector:function(node){
var _13d=_139.byNode(node);
return node.parentNode==this.containerNode&&_13d&&_13d.focus;
},postCreate:function(){
var self=this,_13e=typeof this.childSelector=="string"?this.childSelector:lang.hitch(this,"childSelector");
this.own(on(this.containerNode,on.selector(_13e,_136.enter),function(){
self.onItemHover(_139.byNode(this));
}),on(this.containerNode,on.selector(_13e,_136.leave),function(){
self.onItemUnhover(_139.byNode(this));
}),on(this.containerNode,on.selector(_13e,_138),function(evt){
self.onItemClick(_139.byNode(this),evt);
evt.stopPropagation();
evt.preventDefault();
}));
this.inherited(arguments);
},onExecute:function(){
},onCancel:function(){
},_moveToPopup:function(evt){
if(this.focusedChild&&this.focusedChild.popup&&!this.focusedChild.disabled){
this.onItemClick(this.focusedChild,evt);
}else{
var _13f=this._getTopMenu();
if(_13f&&_13f._isMenuBar){
_13f.focusNext();
}
}
},_onPopupHover:function(){
if(this.currentPopup&&this.currentPopup._pendingClose_timer){
var _140=this.currentPopup.parentMenu;
if(_140.focusedChild){
_140.focusedChild._setSelected(false);
}
_140.focusedChild=this.currentPopup.from_item;
_140.focusedChild._setSelected(true);
this._stopPendingCloseTimer(this.currentPopup);
}
},onItemHover:function(item){
if(this.isActive){
this.focusChild(item);
if(this.focusedChild.popup&&!this.focusedChild.disabled&&!this.hover_timer){
this.hover_timer=this.defer("_openPopup",this.popupDelay);
}
}
if(this.focusedChild){
this.focusChild(item);
}
this._hoveredChild=item;
item._set("hovering",true);
},_onChildBlur:function(item){
this._stopPopupTimer();
item._setSelected(false);
var _141=item.popup;
if(_141){
this._stopPendingCloseTimer(_141);
_141._pendingClose_timer=this.defer(function(){
_141._pendingClose_timer=null;
if(_141.parentMenu){
_141.parentMenu.currentPopup=null;
}
pm.close(_141);
},this.popupDelay);
}
},onItemUnhover:function(item){
if(this.isActive){
this._stopPopupTimer();
}
if(this._hoveredChild==item){
this._hoveredChild=null;
}
item._set("hovering",false);
},_stopPopupTimer:function(){
if(this.hover_timer){
this.hover_timer=this.hover_timer.remove();
}
},_stopPendingCloseTimer:function(_142){
if(_142._pendingClose_timer){
_142._pendingClose_timer=_142._pendingClose_timer.remove();
}
},_stopFocusTimer:function(){
if(this._focus_timer){
this._focus_timer=this._focus_timer.remove();
}
},_getTopMenu:function(){
for(var top=this;top.parentMenu;top=top.parentMenu){
}
return top;
},onItemClick:function(item,evt){
if(typeof this.isShowingNow=="undefined"){
this._markActive();
}
this.focusChild(item);
if(item.disabled){
return false;
}
if(item.popup){
this._openPopup(evt.type=="keypress");
}else{
this.onExecute();
item._onClick?item._onClick(evt):item.onClick(evt);
}
},_openPopup:function(_143){
this._stopPopupTimer();
var _144=this.focusedChild;
if(!_144){
return;
}
var _145=_144.popup;
if(!_145.isShowingNow){
if(this.currentPopup){
this._stopPendingCloseTimer(this.currentPopup);
pm.close(this.currentPopup);
}
_145.parentMenu=this;
_145.from_item=_144;
var self=this;
pm.open({parent:this,popup:_145,around:_144.domNode,orient:this._orient||["after","before"],onCancel:function(){
self.focusChild(_144);
self._cleanUp();
_144._setSelected(true);
self.focusedChild=_144;
},onExecute:lang.hitch(this,"_cleanUp")});
this.currentPopup=_145;
_145.connect(_145.domNode,"onmouseenter",lang.hitch(self,"_onPopupHover"));
}
if(_143&&_145.focus){
_145._focus_timer=this.defer(lang.hitch(_145,function(){
this._focus_timer=null;
this.focus();
}));
}
},_markActive:function(){
this.isActive=true;
_135.replace(this.domNode,"dijitMenuActive","dijitMenuPassive");
},onOpen:function(){
this.isShowingNow=true;
this._markActive();
},_markInactive:function(){
this.isActive=false;
_135.replace(this.domNode,"dijitMenuPassive","dijitMenuActive");
},onClose:function(){
this._stopFocusTimer();
this._markInactive();
this.isShowingNow=false;
this.parentMenu=null;
},_closeChild:function(){
this._stopPopupTimer();
if(this.currentPopup){
if(_132.indexOf(this._focusManager.activeStack,this.id)>=0){
_134.set(this.focusedChild.focusNode,"tabIndex",this.tabIndex);
this.focusedChild.focusNode.focus();
}
pm.close(this.currentPopup);
this.currentPopup=null;
}
if(this.focusedChild){
this.focusedChild._setSelected(false);
this.onItemUnhover(this.focusedChild);
this.focusedChild=null;
}
},_onItemFocus:function(item){
if(this._hoveredChild&&this._hoveredChild!=item){
this.onItemUnhover(this._hoveredChild);
}
},_onBlur:function(){
this._cleanUp();
this.inherited(arguments);
},_cleanUp:function(){
this._closeChild();
if(typeof this.isShowingNow=="undefined"){
this._markInactive();
}
}});
});
},"dojo/i18n":function(){
define(["./_base/kernel","require","./has","./_base/array","./_base/config","./_base/lang","./_base/xhr","./json","module"],function(dojo,_146,has,_147,_148,lang,xhr,json,_149){
has.add("dojo-preload-i18n-Api",1);
1||has.add("dojo-v1x-i18n-Api",1);
var _14a=dojo.i18n={},_14b=/(^.*(^|\/)nls)(\/|$)([^\/]*)\/?([^\/]*)/,_14c=function(root,_14d,_14e,_14f){
for(var _150=[_14e+_14f],_151=_14d.split("-"),_152="",i=0;i<_151.length;i++){
_152+=(_152?"-":"")+_151[i];
if(!root||root[_152]){
_150.push(_14e+_152+"/"+_14f);
}
}
return _150;
},_153={},_154=function(_155,_156,_157){
_157=_157?_157.toLowerCase():dojo.locale;
_155=_155.replace(/\./g,"/");
_156=_156.replace(/\./g,"/");
return (/root/i.test(_157))?(_155+"/nls/"+_156):(_155+"/nls/"+_157+"/"+_156);
},_158=dojo.getL10nName=function(_159,_15a,_15b){
return _159=_149.id+"!"+_154(_159,_15a,_15b);
},_15c=function(_15d,_15e,_15f,_160,_161,load){
_15d([_15e],function(root){
var _162=lang.clone(root.root),_163=_14c(!root._v1x&&root,_161,_15f,_160);
_15d(_163,function(){
for(var i=1;i<_163.length;i++){
_162=lang.mixin(lang.clone(_162),arguments[i]);
}
var _164=_15e+"/"+_161;
_153[_164]=_162;
load();
});
});
},_165=function(id,_166){
return /^\./.test(id)?_166(id):id;
},_167=function(_168){
var list=_148.extraLocale||[];
list=lang.isArray(list)?list:[list];
list.push(_168);
return list;
},load=function(id,_169,load){
if(has("dojo-preload-i18n-Api")){
var _16a=id.split("*"),_16b=_16a[1]=="preload";
if(_16b){
if(!_153[id]){
_153[id]=1;
_16c(_16a[2],json.parse(_16a[3]),1,_169);
}
load(1);
}
if(_16b||_16d(id,_169,load)){
return;
}
}
var _16e=_14b.exec(id),_16f=_16e[1]+"/",_170=_16e[5]||_16e[4],_171=_16f+_170,_172=(_16e[5]&&_16e[4]),_173=_172||dojo.locale,_174=_171+"/"+_173,_175=_172?[_173]:_167(_173),_176=_175.length,_177=function(){
if(!--_176){
load(lang.delegate(_153[_174]));
}
};
_147.forEach(_175,function(_178){
var _179=_171+"/"+_178;
if(has("dojo-preload-i18n-Api")){
_17a(_179);
}
if(!_153[_179]){
_15c(_169,_171,_16f,_170,_178,_177);
}else{
_177();
}
});
};
if(has("dojo-unit-tests")){
var _17b=_14a.unitTests=[];
}
if(has("dojo-preload-i18n-Api")||1){
var _17c=_14a.normalizeLocale=function(_17d){
var _17e=_17d?_17d.toLowerCase():dojo.locale;
return _17e=="root"?"ROOT":_17e;
},isXd=function(mid,_17f){
return (1&&1)?_17f.isXdUrl(_146.toUrl(mid+".js")):true;
},_180=0,_181=[],_16c=_14a._preloadLocalizations=function(_182,_183,_184,_185){
_185=_185||_146;
function _186(mid,_187){
if(isXd(mid,_185)||_184){
_185([mid],_187);
}else{
_191([mid],_187,_185);
}
};
function _188(_189,func){
var _18a=_189.split("-");
while(_18a.length){
if(func(_18a.join("-"))){
return;
}
_18a.pop();
}
func("ROOT");
};
function _18b(_18c){
_18c=_17c(_18c);
_188(_18c,function(loc){
if(_147.indexOf(_183,loc)>=0){
var mid=_182.replace(/\./g,"/")+"_"+loc;
_180++;
_186(mid,function(_18d){
for(var p in _18d){
_153[_146.toAbsMid(p)+"/"+loc]=_18d[p];
}
--_180;
while(!_180&&_181.length){
load.apply(null,_181.shift());
}
});
return true;
}
return false;
});
};
_18b();
_147.forEach(dojo.config.extraLocale,_18b);
},_16d=function(id,_18e,load){
if(_180){
_181.push([id,_18e,load]);
}
return _180;
},_17a=function(){
};
}
if(1){
var _18f={},_190=new Function("__bundle","__checkForLegacyModules","__mid","__amdValue","var define = function(mid, factory){define.called = 1; __amdValue.result = factory || mid;},"+"\t   require = function(){define.called = 1;};"+"try{"+"define.called = 0;"+"eval(__bundle);"+"if(define.called==1)"+"return __amdValue;"+"if((__checkForLegacyModules = __checkForLegacyModules(__mid)))"+"return __checkForLegacyModules;"+"}catch(e){}"+"try{"+"return eval('('+__bundle+')');"+"}catch(e){"+"return e;"+"}"),_191=function(deps,_192,_193){
var _194=[];
_147.forEach(deps,function(mid){
var url=_193.toUrl(mid+".js");
function load(text){
var _195=_190(text,_17a,mid,_18f);
if(_195===_18f){
_194.push(_153[url]=_18f.result);
}else{
if(_195 instanceof Error){
console.error("failed to evaluate i18n bundle; url="+url,_195);
_195={};
}
_194.push(_153[url]=(/nls\/[^\/]+\/[^\/]+$/.test(url)?_195:{root:_195,_v1x:1}));
}
};
if(_153[url]){
_194.push(_153[url]);
}else{
var _196=_193.syncLoadNls(mid);
if(_196){
_194.push(_196);
}else{
if(!xhr){
try{
_193.getText(url,true,load);
}
catch(e){
_194.push(_153[url]={});
}
}else{
xhr.get({url:url,sync:true,load:load,error:function(){
_194.push(_153[url]={});
}});
}
}
}
});
_192&&_192.apply(null,_194);
};
_17a=function(_197){
for(var _198,_199=_197.split("/"),_19a=dojo.global[_199[0]],i=1;_19a&&i<_199.length-1;_19a=_19a[_199[i++]]){
}
if(_19a){
_198=_19a[_199[i]];
if(!_198){
_198=_19a[_199[i].replace(/-/g,"_")];
}
if(_198){
_153[_197]=_198;
}
}
return _198;
};
_14a.getLocalization=function(_19b,_19c,_19d){
var _19e,_19f=_154(_19b,_19c,_19d);
load(_19f,(!isXd(_19f,_146)?function(deps,_1a0){
_191(deps,_1a0,_146);
}:_146),function(_1a1){
_19e=_1a1;
});
return _19e;
};
if(has("dojo-unit-tests")){
_17b.push(function(doh){
doh.register("tests.i18n.unit",function(t){
var _1a2;
_1a2=_190("{prop:1}",_17a,"nonsense",_18f);
t.is({prop:1},_1a2);
t.is(undefined,_1a2[1]);
_1a2=_190("({prop:1})",_17a,"nonsense",_18f);
t.is({prop:1},_1a2);
t.is(undefined,_1a2[1]);
_1a2=_190("{'prop-x':1}",_17a,"nonsense",_18f);
t.is({"prop-x":1},_1a2);
t.is(undefined,_1a2[1]);
_1a2=_190("({'prop-x':1})",_17a,"nonsense",_18f);
t.is({"prop-x":1},_1a2);
t.is(undefined,_1a2[1]);
_1a2=_190("define({'prop-x':1})",_17a,"nonsense",_18f);
t.is(_18f,_1a2);
t.is({"prop-x":1},_18f.result);
_1a2=_190("define('some/module', {'prop-x':1})",_17a,"nonsense",_18f);
t.is(_18f,_1a2);
t.is({"prop-x":1},_18f.result);
_1a2=_190("this is total nonsense and should throw an error",_17a,"nonsense",_18f);
t.is(_1a2 instanceof Error,true);
});
});
}
}
return lang.mixin(_14a,{dynamic:true,normalize:_165,load:load,cache:_153});
});
},"dijit/tree/ForestStoreModel":function(){
define("dijit/tree/ForestStoreModel",["dojo/_base/array","dojo/_base/declare","dojo/_base/kernel","dojo/_base/lang","./TreeStoreModel"],function(_1a3,_1a4,_1a5,lang,_1a6){
return _1a4("dijit.tree.ForestStoreModel",_1a6,{rootId:"$root$",rootLabel:"ROOT",query:null,constructor:function(_1a7){
this.root={store:this,root:true,id:_1a7.rootId,label:_1a7.rootLabel,children:_1a7.rootChildren};
},mayHaveChildren:function(item){
return item===this.root||this.inherited(arguments);
},getChildren:function(_1a8,_1a9,_1aa){
if(_1a8===this.root){
if(this.root.children){
_1a9(this.root.children);
}else{
this.store.fetch({query:this.query,onComplete:lang.hitch(this,function(_1ab){
this.root.children=_1ab;
_1a9(_1ab);
}),onError:_1aa});
}
}else{
this.inherited(arguments);
}
},isItem:function(_1ac){
return (_1ac===this.root)?true:this.inherited(arguments);
},fetchItemByIdentity:function(_1ad){
if(_1ad.identity==this.root.id){
var _1ae=_1ad.scope||_1a5.global;
if(_1ad.onItem){
_1ad.onItem.call(_1ae,this.root);
}
}else{
this.inherited(arguments);
}
},getIdentity:function(item){
return (item===this.root)?this.root.id:this.inherited(arguments);
},getLabel:function(item){
return (item===this.root)?this.root.label:this.inherited(arguments);
},newItem:function(args,_1af,_1b0){
if(_1af===this.root){
this.onNewRootItem(args);
return this.store.newItem(args);
}else{
return this.inherited(arguments);
}
},onNewRootItem:function(){
},pasteItem:function(_1b1,_1b2,_1b3,_1b4,_1b5){
if(_1b2===this.root){
if(!_1b4){
this.onLeaveRoot(_1b1);
}
}
this.inherited(arguments,[_1b1,_1b2===this.root?null:_1b2,_1b3===this.root?null:_1b3,_1b4,_1b5]);
if(_1b3===this.root){
this.onAddToRoot(_1b1);
}
},onAddToRoot:function(item){
},onLeaveRoot:function(item){
},_requeryTop:function(){
var _1b6=this.root.children||[];
this.store.fetch({query:this.query,onComplete:lang.hitch(this,function(_1b7){
this.root.children=_1b7;
if(_1b6.length!=_1b7.length||_1a3.some(_1b6,function(item,idx){
return _1b7[idx]!=item;
})){
this.onChildrenChange(this.root,_1b7);
}
})});
},onNewItem:function(item,_1b8){
this._requeryTop();
this.inherited(arguments);
},onDeleteItem:function(item){
if(_1a3.indexOf(this.root.children,item)!=-1){
this._requeryTop();
}
this.inherited(arguments);
},onSetItem:function(item,_1b9,_1ba,_1bb){
this._requeryTop();
this.inherited(arguments);
}});
});
},"dijit/PopupMenuBarItem":function(){
define(["dojo/_base/declare","./PopupMenuItem","./MenuBarItem"],function(_1bc,_1bd,_1be){
var _1bf=_1be._MenuBarItemMixin;
return _1bc("dijit.PopupMenuBarItem",[_1bd,_1bf],{});
});
},"url:dijit/layout/templates/AccordionButton.html":"<div data-dojo-attach-event='onclick:_onTitleClick' class='dijitAccordionTitle' role=\"presentation\">\n\t<div data-dojo-attach-point='titleNode,focusNode' data-dojo-attach-event='onkeypress:_onTitleKeyPress'\n\t\t\tclass='dijitAccordionTitleFocus' role=\"tab\" aria-expanded=\"false\"\n\t\t><span class='dijitInline dijitAccordionArrow' role=\"presentation\"></span\n\t\t><span class='arrowTextUp' role=\"presentation\">+</span\n\t\t><span class='arrowTextDown' role=\"presentation\">-</span\n\t\t><img src=\"${_blankGif}\" alt=\"\" class=\"dijitIcon\" data-dojo-attach-point='iconNode' style=\"vertical-align: middle\" role=\"presentation\"/>\n\t\t<span role=\"presentation\" data-dojo-attach-point='titleTextNode' class='dijitAccordionText'></span>\n\t</div>\n</div>\n","dijit/TitlePane":function(){
define(["dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-geometry","dojo/_base/event","dojo/fx","dojo/_base/kernel","dojo/keys","./_CssStateMixin","./_TemplatedMixin","./layout/ContentPane","dojo/text!./templates/TitlePane.html","./_base/manager"],function(_1c0,_1c1,dom,_1c2,_1c3,_1c4,_1c5,_1c6,_1c7,keys,_1c8,_1c9,_1ca,_1cb,_1cc){
return _1c1("dijit.TitlePane",[_1ca,_1c9,_1c8],{title:"",_setTitleAttr:{node:"titleNode",type:"innerHTML"},open:true,toggleable:true,tabIndex:"0",duration:_1cc.defaultDuration,baseClass:"dijitTitlePane",templateString:_1cb,doLayout:false,_setTooltipAttr:{node:"focusNode",type:"attribute",attribute:"title"},buildRendering:function(){
this.inherited(arguments);
dom.setSelectable(this.titleNode,false);
},postCreate:function(){
this.inherited(arguments);
if(this.toggleable){
this._trackMouseState(this.titleBarNode,"dijitTitlePaneTitle");
}
var _1cd=this.hideNode,_1ce=this.wipeNode;
this._wipeIn=_1c6.wipeIn({node:_1ce,duration:this.duration,beforeBegin:function(){
_1cd.style.display="";
}});
this._wipeOut=_1c6.wipeOut({node:_1ce,duration:this.duration,onEnd:function(){
_1cd.style.display="none";
}});
},_setOpenAttr:function(open,_1cf){
_1c0.forEach([this._wipeIn,this._wipeOut],function(_1d0){
if(_1d0&&_1d0.status()=="playing"){
_1d0.stop();
}
});
if(_1cf){
var anim=this[open?"_wipeIn":"_wipeOut"];
anim.play();
}else{
this.hideNode.style.display=this.wipeNode.style.display=open?"":"none";
}
if(this._started){
if(open){
this._onShow();
}else{
this.onHide();
}
}
this.containerNode.setAttribute("aria-hidden",open?"false":"true");
this.focusNode.setAttribute("aria-pressed",open?"true":"false");
this._set("open",open);
this._setCss();
},_setToggleableAttr:function(_1d1){
this.focusNode.setAttribute("role",_1d1?"button":"heading");
if(_1d1){
this.focusNode.setAttribute("aria-controls",this.id+"_pane");
this.focusNode.setAttribute("tabIndex",this.tabIndex);
this.focusNode.setAttribute("aria-pressed",this.open);
}else{
_1c2.remove(this.focusNode,"aria-controls");
_1c2.remove(this.focusNode,"tabIndex");
_1c2.remove(this.focusNode,"aria-pressed");
}
this._set("toggleable",_1d1);
this._setCss();
},_setContentAttr:function(_1d2){
if(!this.open||!this._wipeOut||this._wipeOut.status()=="playing"){
this.inherited(arguments);
}else{
if(this._wipeIn&&this._wipeIn.status()=="playing"){
this._wipeIn.stop();
}
_1c4.setMarginBox(this.wipeNode,{h:_1c4.getMarginBox(this.wipeNode).h});
this.inherited(arguments);
if(this._wipeIn){
this._wipeIn.play();
}else{
this.hideNode.style.display="";
}
}
},toggle:function(){
this._setOpenAttr(!this.open,true);
},_setCss:function(){
var node=this.titleBarNode||this.focusNode;
var _1d3=this._titleBarClass;
this._titleBarClass="dijit"+(this.toggleable?"":"Fixed")+(this.open?"Open":"Closed");
_1c3.replace(node,this._titleBarClass,_1d3||"");
this.arrowNodeInner.innerHTML=this.open?"-":"+";
},_onTitleKey:function(e){
if(e.keyCode==keys.ENTER||e.keyCode==keys.SPACE){
if(this.toggleable){
this.toggle();
_1c5.stop(e);
}
}else{
if(e.keyCode==keys.DOWN_ARROW&&this.open){
this.containerNode.focus();
e.preventDefault();
}
}
},_onTitleClick:function(){
if(this.toggleable){
this.toggle();
}
},setTitle:function(_1d4){
_1c7.deprecated("dijit.TitlePane.setTitle() is deprecated.  Use set('title', ...) instead.","","2.0");
this.set("title",_1d4);
}});
});
},"dijit/form/_ComboBoxMenuMixin":function(){
define(["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/i18n","dojo/i18n!./nls/ComboBox"],function(_1d5,_1d6,_1d7,i18n){
return _1d6("dijit.form._ComboBoxMenuMixin",null,{_messages:null,postMixInProperties:function(){
this.inherited(arguments);
this._messages=i18n.getLocalization("dijit.form","ComboBox",this.lang);
},buildRendering:function(){
this.inherited(arguments);
this.previousButton.innerHTML=this._messages["previousMessage"];
this.nextButton.innerHTML=this._messages["nextMessage"];
},_setValueAttr:function(_1d8){
this.value=_1d8;
this.onChange(_1d8);
},onClick:function(node){
if(node==this.previousButton){
this._setSelectedAttr(null);
this.onPage(-1);
}else{
if(node==this.nextButton){
this._setSelectedAttr(null);
this.onPage(1);
}else{
this.onChange(node);
}
}
},onChange:function(){
},onPage:function(){
},onClose:function(){
this._setSelectedAttr(null);
},_createOption:function(item,_1d9){
var _1da=this._createMenuItem();
var _1db=_1d9(item);
if(_1db.html){
_1da.innerHTML=_1db.label;
}else{
_1da.appendChild(_1da.ownerDocument.createTextNode(_1db.label));
}
if(_1da.innerHTML==""){
_1da.innerHTML="&#160;";
}
this.applyTextDir(_1da,(_1da.innerText||_1da.textContent||""));
return _1da;
},createOptions:function(_1dc,_1dd,_1de){
this.items=_1dc;
this.previousButton.style.display=(_1dd.start==0)?"none":"";
_1d7.set(this.previousButton,"id",this.id+"_prev");
_1d5.forEach(_1dc,function(item,i){
var _1df=this._createOption(item,_1de);
_1df.setAttribute("item",i);
_1d7.set(_1df,"id",this.id+i);
this.nextButton.parentNode.insertBefore(_1df,this.nextButton);
},this);
var _1e0=false;
if(_1dc.total&&!_1dc.total.then&&_1dc.total!=-1){
if((_1dd.start+_1dd.count)<_1dc.total){
_1e0=true;
}else{
if((_1dd.start+_1dd.count)>_1dc.total&&_1dd.count==_1dc.length){
_1e0=true;
}
}
}else{
if(_1dd.count==_1dc.length){
_1e0=true;
}
}
this.nextButton.style.display=_1e0?"":"none";
_1d7.set(this.nextButton,"id",this.id+"_next");
},clearResultList:function(){
var _1e1=this.containerNode;
while(_1e1.childNodes.length>2){
_1e1.removeChild(_1e1.childNodes[_1e1.childNodes.length-2]);
}
this._setSelectedAttr(null);
},highlightFirstOption:function(){
this.selectFirstNode();
},highlightLastOption:function(){
this.selectLastNode();
},selectFirstNode:function(){
this.inherited(arguments);
if(this.getHighlightedOption()==this.previousButton){
this.selectNextNode();
}
},selectLastNode:function(){
this.inherited(arguments);
if(this.getHighlightedOption()==this.nextButton){
this.selectPreviousNode();
}
},getHighlightedOption:function(){
return this.selected;
}});
});
},"dijit/form/_SearchMixin":function(){
define("dijit/form/_SearchMixin",["dojo/data/util/filter","dojo/_base/declare","dojo/_base/event","dojo/keys","dojo/_base/lang","dojo/query","dojo/sniff","dojo/string","dojo/when","../registry"],function(_1e2,_1e3,_1e4,keys,lang,_1e5,has,_1e6,when,_1e7){
return _1e3("dijit.form._SearchMixin",null,{pageSize:Infinity,store:null,fetchProperties:{},query:{},searchDelay:200,searchAttr:"name",queryExpr:"${0}*",ignoreCase:true,_abortQuery:function(){
if(this.searchTimer){
this.searchTimer=this.searchTimer.remove();
}
if(this._queryDeferHandle){
this._queryDeferHandle=this._queryDeferHandle.remove();
}
if(this._fetchHandle){
if(this._fetchHandle.abort){
this._cancelingQuery=true;
this._fetchHandle.abort();
this._cancelingQuery=false;
}
if(this._fetchHandle.cancel){
this._cancelingQuery=true;
this._fetchHandle.cancel();
this._cancelingQuery=false;
}
this._fetchHandle=null;
}
},_processInput:function(evt){
if(this.disabled||this.readOnly){
return;
}
var key=evt.charOrCode;
if(evt.altKey||((evt.ctrlKey||evt.metaKey)&&(key!="x"&&key!="v"))||key==keys.SHIFT){
return;
}
var _1e8=false;
this._prev_key_backspace=false;
switch(key){
case keys.DELETE:
case keys.BACKSPACE:
this._prev_key_backspace=true;
this._maskValidSubsetError=true;
_1e8=true;
break;
default:
_1e8=typeof key=="string"||key==229;
}
if(_1e8){
if(!this.store){
this.onSearch();
}else{
this.searchTimer=this.defer("_startSearchFromInput",1);
}
}
},onSearch:function(){
},_startSearchFromInput:function(){
this._startSearch(this.focusNode.value.replace(/([\\\*\?])/g,"\\$1"));
},_startSearch:function(text){
this._abortQuery();
var _1e9=this,_1e5=lang.clone(this.query),_1ea={start:0,count:this.pageSize,queryOptions:{ignoreCase:this.ignoreCase,deep:true}},qs=_1e6.substitute(this.queryExpr,[text]),q,_1eb=function(){
var _1ec=_1e9._fetchHandle=_1e9.store.query(_1e5,_1ea);
if(_1e9.disabled||_1e9.readOnly||(q!==_1e9._lastQuery)){
return;
}
when(_1ec,function(res){
_1e9._fetchHandle=null;
if(!_1e9.disabled&&!_1e9.readOnly&&(q===_1e9._lastQuery)){
when(_1ec.total,function(_1ed){
res.total=_1ed;
var _1ee=_1e9.pageSize;
if(isNaN(_1ee)||_1ee>res.total){
_1ee=res.total;
}
res.nextPage=function(_1ef){
_1ea.direction=_1ef=_1ef!==false;
_1ea.count=_1ee;
if(_1ef){
_1ea.start+=res.length;
if(_1ea.start>=res.total){
_1ea.count=0;
}
}else{
_1ea.start-=_1ee;
if(_1ea.start<0){
_1ea.count=Math.max(_1ee+_1ea.start,0);
_1ea.start=0;
}
}
if(_1ea.count<=0){
res.length=0;
_1e9.onSearch(res,_1e5,_1ea);
}else{
_1eb();
}
};
_1e9.onSearch(res,_1e5,_1ea);
});
}
},function(err){
_1e9._fetchHandle=null;
if(!_1e9._cancelingQuery){
console.error(_1e9.declaredClass+" "+err.toString());
}
});
};
lang.mixin(_1ea,this.fetchProperties);
if(this.store._oldAPI){
q=qs;
}else{
q=_1e2.patternToRegExp(qs,this.ignoreCase);
q.toString=function(){
return qs;
};
}
this._lastQuery=_1e5[this.searchAttr]=q;
this._queryDeferHandle=this.defer(_1eb,this.searchDelay);
},constructor:function(){
this.query={};
this.fetchProperties={};
},postMixInProperties:function(){
if(!this.store){
var list=this.list;
if(list){
this.store=_1e7.byId(list);
}
}
this.inherited(arguments);
}});
});
},"url:dijit/form/templates/DropDownButton.html":"<span class=\"dijit dijitReset dijitInline\"\n\t><span class='dijitReset dijitInline dijitButtonNode'\n\t\tdata-dojo-attach-event=\"ondijitclick:_onClick\" data-dojo-attach-point=\"_buttonNode\"\n\t\t><span class=\"dijitReset dijitStretch dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"focusNode,titleNode,_arrowWrapperNode\"\n\t\t\trole=\"button\" aria-haspopup=\"true\" aria-labelledby=\"${id}_label\"\n\t\t\t><span class=\"dijitReset dijitInline dijitIcon\"\n\t\t\t\tdata-dojo-attach-point=\"iconNode\"\n\t\t\t></span\n\t\t\t><span class=\"dijitReset dijitInline dijitButtonText\"\n\t\t\t\tdata-dojo-attach-point=\"containerNode,_popupStateNode\"\n\t\t\t\tid=\"${id}_label\"\n\t\t\t></span\n\t\t\t><span class=\"dijitReset dijitInline dijitArrowButtonInner\"></span\n\t\t\t><span class=\"dijitReset dijitInline dijitArrowButtonChar\">&#9660;</span\n\t\t></span\n\t></span\n\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" class=\"dijitOffScreen\" tabIndex=\"-1\"\n\t\tdata-dojo-attach-point=\"valueNode\" role=\"presentation\"\n/></span>\n","dijit/form/ToggleButton":function(){
define("dijit/form/ToggleButton",["dojo/_base/declare","dojo/_base/kernel","./Button","./_ToggleButtonMixin"],function(_1f0,_1f1,_1f2,_1f3){
return _1f0("dijit.form.ToggleButton",[_1f2,_1f3],{baseClass:"dijitToggleButton",setChecked:function(_1f4){
_1f1.deprecated("setChecked("+_1f4+") is deprecated. Use set('checked',"+_1f4+") instead.","","2.0");
this.set("checked",_1f4);
}});
});
},"dijit/form/NumberSpinner":function(){
define(["dojo/_base/declare","dojo/_base/event","dojo/keys","./_Spinner","./NumberTextBox"],function(_1f5,_1f6,keys,_1f7,_1f8){
return _1f5("dijit.form.NumberSpinner",[_1f7,_1f8.Mixin],{baseClass:"dijitTextBox dijitSpinner dijitNumberTextBox",adjust:function(val,_1f9){
var tc=this.constraints,v=isNaN(val),_1fa=!isNaN(tc.max),_1fb=!isNaN(tc.min);
if(v&&_1f9!=0){
val=(_1f9>0)?_1fb?tc.min:_1fa?tc.max:0:_1fa?this.constraints.max:_1fb?tc.min:0;
}
var _1fc=val+_1f9;
if(v||isNaN(_1fc)){
return val;
}
if(_1fa&&(_1fc>tc.max)){
_1fc=tc.max;
}
if(_1fb&&(_1fc<tc.min)){
_1fc=tc.min;
}
return _1fc;
},_onKeyPress:function(e){
if((e.charOrCode==keys.HOME||e.charOrCode==keys.END)&&!(e.ctrlKey||e.altKey||e.metaKey)&&typeof this.get("value")!="undefined"){
var _1fd=this.constraints[(e.charOrCode==keys.HOME?"min":"max")];
if(typeof _1fd=="number"){
this._setValueAttr(_1fd,false);
}
_1f6.stop(e);
}
}});
});
},"dijit/form/Textarea":function(){
define(["dojo/_base/declare","dojo/dom-style","./_ExpandingTextAreaMixin","./SimpleTextarea"],function(_1fe,_1ff,_200,_201){
return _1fe("dijit.form.Textarea",[_201,_200],{baseClass:"dijitTextBox dijitTextArea dijitExpandingTextArea",cols:"",buildRendering:function(){
this.inherited(arguments);
_1ff.set(this.textbox,{overflowY:"hidden",overflowX:"auto",boxSizing:"border-box",MsBoxSizing:"border-box",WebkitBoxSizing:"border-box",MozBoxSizing:"border-box"});
}});
});
},"dijit/form/DateTextBox":function(){
define(["dojo/_base/declare","../Calendar","./_DateTimeTextBox"],function(_202,_203,_204){
return _202("dijit.form.DateTextBox",_204,{baseClass:"dijitTextBox dijitComboBox dijitDateTextBox",popupClass:_203,_selector:"date",value:new Date("")});
});
},"dijit/layout/AccordionContainer":function(){
require({cache:{"url:dijit/layout/templates/AccordionButton.html":"<div data-dojo-attach-event='onclick:_onTitleClick' class='dijitAccordionTitle' role=\"presentation\">\n\t<div data-dojo-attach-point='titleNode,focusNode' data-dojo-attach-event='onkeypress:_onTitleKeyPress'\n\t\t\tclass='dijitAccordionTitleFocus' role=\"tab\" aria-expanded=\"false\"\n\t\t><span class='dijitInline dijitAccordionArrow' role=\"presentation\"></span\n\t\t><span class='arrowTextUp' role=\"presentation\">+</span\n\t\t><span class='arrowTextDown' role=\"presentation\">-</span\n\t\t><img src=\"${_blankGif}\" alt=\"\" class=\"dijitIcon\" data-dojo-attach-point='iconNode' style=\"vertical-align: middle\" role=\"presentation\"/>\n\t\t<span role=\"presentation\" data-dojo-attach-point='titleTextNode' class='dijitAccordionText'></span>\n\t</div>\n</div>\n"}});
define("dijit/layout/AccordionContainer",["require","dojo/_base/array","dojo/_base/declare","dojo/_base/event","dojo/_base/fx","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/keys","dojo/_base/lang","dojo/sniff","dojo/topic","../focus","../_base/manager","dojo/ready","../_Widget","../_Container","../_TemplatedMixin","../_CssStateMixin","./StackContainer","./ContentPane","dojo/text!./templates/AccordionButton.html"],function(_205,_206,_207,_208,fx,dom,_209,_20a,_20b,_20c,keys,lang,has,_20d,_20e,_20f,_210,_211,_212,_213,_214,_215,_216,_217){
var _218=_207("dijit.layout._AccordionButton",[_211,_213,_214],{templateString:_217,label:"",_setLabelAttr:{node:"titleTextNode",type:"innerHTML"},title:"",_setTitleAttr:{node:"titleTextNode",type:"attribute",attribute:"title"},iconClassAttr:"",_setIconClassAttr:{node:"iconNode",type:"class"},baseClass:"dijitAccordionTitle",getParent:function(){
return this.parent;
},buildRendering:function(){
this.inherited(arguments);
var _219=this.id.replace(" ","_");
_209.set(this.titleTextNode,"id",_219+"_title");
this.focusNode.setAttribute("aria-labelledby",_209.get(this.titleTextNode,"id"));
dom.setSelectable(this.domNode,false);
},getTitleHeight:function(){
return _20c.getMarginSize(this.domNode).h;
},_onTitleClick:function(){
var _21a=this.getParent();
_21a.selectChild(this.contentWidget,true);
_20e.focus(this.focusNode);
},_onTitleKeyPress:function(evt){
return this.getParent()._onKeyPress(evt,this.contentWidget);
},_setSelectedAttr:function(_21b){
this._set("selected",_21b);
this.focusNode.setAttribute("aria-expanded",_21b?"true":"false");
this.focusNode.setAttribute("aria-selected",_21b?"true":"false");
this.focusNode.setAttribute("tabIndex",_21b?"0":"-1");
}});
var _21c=_207("dijit.layout._AccordionInnerContainer",[_211,_214],{baseClass:"dijitAccordionInnerContainer",isLayoutContainer:true,buildRendering:function(){
this.domNode=_20b.place("<div class='"+this.baseClass+"' role='presentation'>",this.contentWidget.domNode,"after");
var _21d=this.contentWidget,cls=lang.isString(this.buttonWidget)?lang.getObject(this.buttonWidget):this.buttonWidget;
this.button=_21d._buttonWidget=(new cls({contentWidget:_21d,label:_21d.title,title:_21d.tooltip,dir:_21d.dir,lang:_21d.lang,textDir:_21d.textDir,iconClass:_21d.iconClass,id:_21d.id+"_button",parent:this.parent})).placeAt(this.domNode);
this.containerNode=_20b.place("<div class='dijitAccordionChildWrapper' style='display:none'>",this.domNode);
_20b.place(this.contentWidget.domNode,this.containerNode);
},postCreate:function(){
this.inherited(arguments);
var _21e=this.button;
this._contentWidgetWatches=[this.contentWidget.watch("title",lang.hitch(this,function(name,_21f,_220){
_21e.set("label",_220);
})),this.contentWidget.watch("tooltip",lang.hitch(this,function(name,_221,_222){
_21e.set("title",_222);
})),this.contentWidget.watch("iconClass",lang.hitch(this,function(name,_223,_224){
_21e.set("iconClass",_224);
}))];
},_setSelectedAttr:function(_225){
this._set("selected",_225);
this.button.set("selected",_225);
if(_225){
var cw=this.contentWidget;
if(cw.onSelected){
cw.onSelected();
}
}
},startup:function(){
this.contentWidget.startup();
},destroy:function(){
this.button.destroyRecursive();
_206.forEach(this._contentWidgetWatches||[],function(w){
w.unwatch();
});
delete this.contentWidget._buttonWidget;
delete this.contentWidget._wrapperWidget;
this.inherited(arguments);
},destroyDescendants:function(_226){
this.contentWidget.destroyRecursive(_226);
}});
var _227=_207("dijit.layout.AccordionContainer",_215,{duration:_20f.defaultDuration,buttonWidget:_218,baseClass:"dijitAccordionContainer",buildRendering:function(){
this.inherited(arguments);
this.domNode.style.overflow="hidden";
this.domNode.setAttribute("role","tablist");
},startup:function(){
if(this._started){
return;
}
this.inherited(arguments);
if(this.selectedChildWidget){
this.selectedChildWidget._wrapperWidget.set("selected",true);
}
},layout:function(){
var _228=this.selectedChildWidget;
if(!_228){
return;
}
var _229=_228._wrapperWidget.domNode,_22a=_20c.getMarginExtents(_229),_22b=_20c.getPadBorderExtents(_229),_22c=_228._wrapperWidget.containerNode,_22d=_20c.getMarginExtents(_22c),_22e=_20c.getPadBorderExtents(_22c),_22f=this._contentBox;
var _230=0;
_206.forEach(this.getChildren(),function(_231){
if(_231!=_228){
_230+=_20c.getMarginSize(_231._wrapperWidget.domNode).h;
}
});
this._verticalSpace=_22f.h-_230-_22a.h-_22b.h-_22d.h-_22e.h-_228._buttonWidget.getTitleHeight();
this._containerContentBox={h:this._verticalSpace,w:this._contentBox.w-_22a.w-_22b.w-_22d.w-_22e.w};
if(_228){
_228.resize(this._containerContentBox);
}
},_setupChild:function(_232){
_232._wrapperWidget=_21c({contentWidget:_232,buttonWidget:this.buttonWidget,id:_232.id+"_wrapper",dir:_232.dir,lang:_232.lang,textDir:_232.textDir,parent:this});
this.inherited(arguments);
},addChild:function(_233,_234){
if(this._started){
var _235=this.containerNode;
if(_234&&typeof _234=="number"){
var _236=_211.prototype.getChildren.call(this);
if(_236&&_236.length>=_234){
_235=_236[_234-1].domNode;
_234="after";
}
}
_20b.place(_233.domNode,_235,_234);
if(!_233._started){
_233.startup();
}
this._setupChild(_233);
_20d.publish(this.id+"-addChild",_233,_234);
this.layout();
if(!this.selectedChildWidget){
this.selectChild(_233);
}
}else{
this.inherited(arguments);
}
},removeChild:function(_237){
if(_237._wrapperWidget){
_20b.place(_237.domNode,_237._wrapperWidget.domNode,"after");
_237._wrapperWidget.destroy();
delete _237._wrapperWidget;
}
_20a.remove(_237.domNode,"dijitHidden");
this.inherited(arguments);
},getChildren:function(){
return _206.map(this.inherited(arguments),function(_238){
return _238.declaredClass=="dijit.layout._AccordionInnerContainer"?_238.contentWidget:_238;
},this);
},destroy:function(){
if(this._animation){
this._animation.stop();
}
_206.forEach(this.getChildren(),function(_239){
if(_239._wrapperWidget){
_239._wrapperWidget.destroy();
}else{
_239.destroyRecursive();
}
});
this.inherited(arguments);
},_showChild:function(_23a){
_23a._wrapperWidget.containerNode.style.display="block";
return this.inherited(arguments);
},_hideChild:function(_23b){
_23b._wrapperWidget.containerNode.style.display="none";
this.inherited(arguments);
},_transition:function(_23c,_23d,_23e){
if(has("ie")<8){
_23e=false;
}
if(this._animation){
this._animation.stop(true);
delete this._animation;
}
var self=this;
if(_23c){
_23c._wrapperWidget.set("selected",true);
var d=this._showChild(_23c);
if(this.doLayout&&_23c.resize){
_23c.resize(this._containerContentBox);
}
}
if(_23d){
_23d._wrapperWidget.set("selected",false);
if(!_23e){
this._hideChild(_23d);
}
}
if(_23e){
var _23f=_23c._wrapperWidget.containerNode,_240=_23d._wrapperWidget.containerNode;
var _241=_23c._wrapperWidget.containerNode,_242=_20c.getMarginExtents(_241),_243=_20c.getPadBorderExtents(_241),_244=_242.h+_243.h;
_240.style.height=(self._verticalSpace-_244)+"px";
this._animation=new fx.Animation({node:_23f,duration:this.duration,curve:[1,this._verticalSpace-_244-1],onAnimate:function(_245){
_245=Math.floor(_245);
_23f.style.height=_245+"px";
_240.style.height=(self._verticalSpace-_244-_245)+"px";
},onEnd:function(){
delete self._animation;
_23f.style.height="auto";
_23d._wrapperWidget.containerNode.style.display="none";
_240.style.height="auto";
self._hideChild(_23d);
}});
this._animation.onStop=this._animation.onEnd;
this._animation.play();
}
return d;
},_onKeyPress:function(e,_246){
if(this.disabled||e.altKey||!(_246||e.ctrlKey)){
return;
}
var c=e.charOrCode;
if((_246&&(c==keys.LEFT_ARROW||c==keys.UP_ARROW))||(e.ctrlKey&&c==keys.PAGE_UP)){
this._adjacent(false)._buttonWidget._onTitleClick();
_208.stop(e);
}else{
if((_246&&(c==keys.RIGHT_ARROW||c==keys.DOWN_ARROW))||(e.ctrlKey&&(c==keys.PAGE_DOWN||c==keys.TAB))){
this._adjacent(true)._buttonWidget._onTitleClick();
_208.stop(e);
}
}
}});
if(has("dijit-legacy-requires")){
_210(0,function(){
var _247=["dijit/layout/AccordionPane"];
_205(_247);
});
}
_227._InnerContainer=_21c;
_227._Button=_218;
return _227;
});
},"dijit/form/ComboButton":function(){
define(["dojo/_base/declare","dojo/_base/event","dojo/keys","../focus","./DropDownButton","dojo/text!./templates/ComboButton.html"],function(_248,_249,keys,_24a,_24b,_24c){
return _248("dijit.form.ComboButton",_24b,{templateString:_24c,_setIdAttr:"",_setTabIndexAttr:["focusNode","titleNode"],_setTitleAttr:"titleNode",optionsTitle:"",baseClass:"dijitComboButton",cssStateNodes:{"buttonNode":"dijitButtonNode","titleNode":"dijitButtonContents","_popupStateNode":"dijitDownArrowButton"},_focusedNode:null,_onButtonKeyPress:function(evt){
if(evt.charOrCode==keys[this.isLeftToRight()?"RIGHT_ARROW":"LEFT_ARROW"]){
_24a.focus(this._popupStateNode);
_249.stop(evt);
}
},_onArrowKeyPress:function(evt){
if(evt.charOrCode==keys[this.isLeftToRight()?"LEFT_ARROW":"RIGHT_ARROW"]){
_24a.focus(this.titleNode);
_249.stop(evt);
}
},focus:function(_24d){
if(!this.disabled){
_24a.focus(_24d=="start"?this.titleNode:this._popupStateNode);
}
}});
});
},"dijit/layout/SplitContainer":function(){
define("dijit/layout/SplitContainer",["dojo/_base/array","dojo/cookie","dojo/_base/declare","dojo/dom","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/_base/event","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/sniff","../registry","../_WidgetBase","./_LayoutWidget"],function(_24e,_24f,_250,dom,_251,_252,_253,_254,_255,_256,lang,on,has,_257,_258,_259){
var _25a=_250("dijit.layout.SplitContainer",_259,{constructor:function(){
_256.deprecated("dijit.layout.SplitContainer is deprecated","use BorderContainer with splitter instead",2);
},activeSizing:false,sizerWidth:7,orientation:"horizontal",persist:true,baseClass:"dijitSplitContainer",postMixInProperties:function(){
this.inherited("postMixInProperties",arguments);
this.isHorizontal=(this.orientation=="horizontal");
},postCreate:function(){
this.inherited(arguments);
this.sizers=[];
if(has("mozilla")){
this.domNode.style.overflow="-moz-scrollbars-none";
}
if(typeof this.sizerWidth=="object"){
try{
this.sizerWidth=parseInt(this.sizerWidth.toString());
}
catch(e){
this.sizerWidth=7;
}
}
var _25b=this.ownerDocument.createElement("div");
this.virtualSizer=_25b;
_25b.style.position="relative";
_25b.style.zIndex=10;
_25b.className=this.isHorizontal?"dijitSplitContainerVirtualSizerH":"dijitSplitContainerVirtualSizerV";
this.domNode.appendChild(_25b);
dom.setSelectable(_25b,false);
},destroy:function(){
delete this.virtualSizer;
if(this._ownconnects){
var h;
while(h=this._ownconnects.pop()){
h.remove();
}
}
this.inherited(arguments);
},startup:function(){
if(this._started){
return;
}
_24e.forEach(this.getChildren(),function(_25c,i,_25d){
this._setupChild(_25c);
if(i<_25d.length-1){
this._addSizer();
}
},this);
if(this.persist){
this._restoreState();
}
this.inherited(arguments);
},_setupChild:function(_25e){
this.inherited(arguments);
_25e.domNode.style.position="absolute";
_251.add(_25e.domNode,"dijitSplitPane");
},_onSizerMouseDown:function(e){
if(e.target.id){
for(var i=0;i<this.sizers.length;i++){
if(this.sizers[i].id==e.target.id){
break;
}
}
if(i<this.sizers.length){
this.beginSizing(e,i);
}
}
},_addSizer:function(_25f){
_25f=_25f===undefined?this.sizers.length:_25f;
var _260=this.ownerDocument.createElement("div");
_260.id=_257.getUniqueId("dijit_layout_SplitterContainer_Splitter");
this.sizers.splice(_25f,0,_260);
this.domNode.appendChild(_260);
_260.className=this.isHorizontal?"dijitSplitContainerSizerH":"dijitSplitContainerSizerV";
var _261=this.ownerDocument.createElement("div");
_261.className="thumb";
_260.appendChild(_261);
this.connect(_260,"onmousedown","_onSizerMouseDown");
dom.setSelectable(_260,false);
},removeChild:function(_262){
if(this.sizers.length){
var i=_24e.indexOf(this.getChildren(),_262);
if(i!=-1){
if(i==this.sizers.length){
i--;
}
_252.destroy(this.sizers[i]);
this.sizers.splice(i,1);
}
}
this.inherited(arguments);
if(this._started){
this.layout();
}
},addChild:function(_263,_264){
this.inherited(arguments);
if(this._started){
var _265=this.getChildren();
if(_265.length>1){
this._addSizer(_264);
}
this.layout();
}
},layout:function(){
this.paneWidth=this._contentBox.w;
this.paneHeight=this._contentBox.h;
var _266=this.getChildren();
if(!_266.length){
return;
}
var _267=this.isHorizontal?this.paneWidth:this.paneHeight;
if(_266.length>1){
_267-=this.sizerWidth*(_266.length-1);
}
var _268=0;
_24e.forEach(_266,function(_269){
_268+=_269.sizeShare;
});
var _26a=_267/_268;
var _26b=0;
_24e.forEach(_266.slice(0,_266.length-1),function(_26c){
var size=Math.round(_26a*_26c.sizeShare);
_26c.sizeActual=size;
_26b+=size;
});
_266[_266.length-1].sizeActual=_267-_26b;
this._checkSizes();
var pos=0;
var size=_266[0].sizeActual;
this._movePanel(_266[0],pos,size);
_266[0].position=pos;
pos+=size;
if(!this.sizers){
return;
}
_24e.some(_266.slice(1),function(_26d,i){
if(!this.sizers[i]){
return true;
}
this._moveSlider(this.sizers[i],pos,this.sizerWidth);
this.sizers[i].position=pos;
pos+=this.sizerWidth;
size=_26d.sizeActual;
this._movePanel(_26d,pos,size);
_26d.position=pos;
pos+=size;
},this);
},_movePanel:function(_26e,pos,size){
var box;
if(this.isHorizontal){
_26e.domNode.style.left=pos+"px";
_26e.domNode.style.top=0;
box={w:size,h:this.paneHeight};
if(_26e.resize){
_26e.resize(box);
}else{
_253.setMarginBox(_26e.domNode,box);
}
}else{
_26e.domNode.style.left=0;
_26e.domNode.style.top=pos+"px";
box={w:this.paneWidth,h:size};
if(_26e.resize){
_26e.resize(box);
}else{
_253.setMarginBox(_26e.domNode,box);
}
}
},_moveSlider:function(_26f,pos,size){
if(this.isHorizontal){
_26f.style.left=pos+"px";
_26f.style.top=0;
_253.setMarginBox(_26f,{w:size,h:this.paneHeight});
}else{
_26f.style.left=0;
_26f.style.top=pos+"px";
_253.setMarginBox(_26f,{w:this.paneWidth,h:size});
}
},_growPane:function(_270,pane){
if(_270>0){
if(pane.sizeActual>pane.sizeMin){
if((pane.sizeActual-pane.sizeMin)>_270){
pane.sizeActual=pane.sizeActual-_270;
_270=0;
}else{
_270-=pane.sizeActual-pane.sizeMin;
pane.sizeActual=pane.sizeMin;
}
}
}
return _270;
},_checkSizes:function(){
var _271=0;
var _272=0;
var _273=this.getChildren();
_24e.forEach(_273,function(_274){
_272+=_274.sizeActual;
_271+=_274.sizeMin;
});
if(_271<=_272){
var _275=0;
_24e.forEach(_273,function(_276){
if(_276.sizeActual<_276.sizeMin){
_275+=_276.sizeMin-_276.sizeActual;
_276.sizeActual=_276.sizeMin;
}
});
if(_275>0){
var list=this.isDraggingLeft?_273.reverse():_273;
_24e.forEach(list,function(_277){
_275=this._growPane(_275,_277);
},this);
}
}else{
_24e.forEach(_273,function(_278){
_278.sizeActual=Math.round(_272*(_278.sizeMin/_271));
});
}
},beginSizing:function(e,i){
var _279=this.getChildren();
this.paneBefore=_279[i];
this.paneAfter=_279[i+1];
this.paneBefore.sizeBeforeDrag=this.paneBefore.sizeActual;
this.paneAfter.sizeBeforeDrag=this.paneAfter.sizeActual;
this.paneAfter.positionBeforeDrag=this.paneAfter.position;
this.isSizing=true;
this.sizingSplitter=this.sizers[i];
this.sizingSplitter.positionBeforeDrag=_254.get(this.sizingSplitter,(this.isHorizontal?"left":"top"));
if(!this.cover){
this.cover=_252.create("div",{style:{position:"absolute",zIndex:5,top:0,left:0,width:"100%",height:"100%"}},this.domNode);
}else{
this.cover.style.zIndex=5;
}
this.sizingSplitter.style.zIndex=6;
this.startPoint=this.lastPoint=(this.isHorizontal?e.pageX:e.pageY);
this.maxDelta=this.paneAfter.sizeActual-this.paneAfter.sizeMin;
this.minDelta=-1*(this.paneBefore.sizeActual-this.paneBefore.sizeMin);
if(!this.activeSizing){
this._showSizingLine();
}
this._ownconnects=[on(this.ownerDocument.documentElement,"mousemove",lang.hitch(this,"changeSizing")),on(this.ownerDocument.documentElement,"mouseup",lang.hitch(this,"endSizing"))];
_255.stop(e);
},changeSizing:function(e){
if(!this.isSizing){
return;
}
this.lastPoint=this.isHorizontal?e.pageX:e.pageY;
var _27a=Math.max(Math.min(this.lastPoint-this.startPoint,this.maxDelta),this.minDelta);
if(this.activeSizing){
this._updateSize(_27a);
}else{
this._moveSizingLine(_27a);
}
_255.stop(e);
},endSizing:function(){
if(!this.isSizing){
return;
}
if(this.cover){
this.cover.style.zIndex=-1;
}
if(!this.activeSizing){
this._hideSizingLine();
}
var _27b=Math.max(Math.min(this.lastPoint-this.startPoint,this.maxDelta),this.minDelta);
this._updateSize(_27b);
this.isSizing=false;
if(this.persist){
this._saveState(this);
}
var h;
while(h=this._ownconnects.pop()){
h.remove();
}
},_updateSize:function(_27c){
this.paneBefore.sizeActual=this.paneBefore.sizeBeforeDrag+_27c;
this.paneAfter.position=this.paneAfter.positionBeforeDrag+_27c;
this.paneAfter.sizeActual=this.paneAfter.sizeBeforeDrag-_27c;
_24e.forEach(this.getChildren(),function(_27d){
_27d.sizeShare=_27d.sizeActual;
});
if(this._started){
this.layout();
}
},_showSizingLine:function(){
this._moveSizingLine(0);
_253.setMarginBox(this.virtualSizer,this.isHorizontal?{w:this.sizerWidth,h:this.paneHeight}:{w:this.paneWidth,h:this.sizerWidth});
this.virtualSizer.style.display="block";
},_hideSizingLine:function(){
this.virtualSizer.style.display="none";
},_moveSizingLine:function(_27e){
var pos=_27e+this.sizingSplitter.positionBeforeDrag;
_254.set(this.virtualSizer,(this.isHorizontal?"left":"top"),pos+"px");
},_getCookieName:function(i){
return this.id+"_"+i;
},_restoreState:function(){
_24e.forEach(this.getChildren(),function(_27f,i){
var _280=this._getCookieName(i);
var _281=_24f(_280);
if(_281){
var pos=parseInt(_281);
if(typeof pos=="number"){
_27f.sizeShare=pos;
}
}
},this);
},_saveState:function(){
if(!this.persist){
return;
}
_24e.forEach(this.getChildren(),function(_282,i){
_24f(this._getCookieName(i),_282.sizeShare,{expires:365});
},this);
}});
_25a.ChildWidgetProperties={sizeMin:10,sizeShare:10};
lang.extend(_258,_25a.ChildWidgetProperties);
return _25a;
});
},"url:dijit/templates/Calendar.html":"<table cellspacing=\"0\" cellpadding=\"0\" class=\"dijitCalendarContainer\" role=\"grid\" aria-labelledby=\"${id}_mddb ${id}_year\">\n\t<thead>\n\t\t<tr class=\"dijitReset dijitCalendarMonthContainer\" valign=\"top\">\n\t\t\t<th class='dijitReset dijitCalendarArrow' data-dojo-attach-point=\"decrementMonth\">\n\t\t\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitCalendarIncrementControl dijitCalendarDecrease\" role=\"presentation\"/>\n\t\t\t\t<span data-dojo-attach-point=\"decreaseArrowNode\" class=\"dijitA11ySideArrow\">-</span>\n\t\t\t</th>\n\t\t\t<th class='dijitReset' colspan=\"5\">\n\t\t\t\t<div data-dojo-attach-point=\"monthNode\">\n\t\t\t\t</div>\n\t\t\t</th>\n\t\t\t<th class='dijitReset dijitCalendarArrow' data-dojo-attach-point=\"incrementMonth\">\n\t\t\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitCalendarIncrementControl dijitCalendarIncrease\" role=\"presentation\"/>\n\t\t\t\t<span data-dojo-attach-point=\"increaseArrowNode\" class=\"dijitA11ySideArrow\">+</span>\n\t\t\t</th>\n\t\t</tr>\n\t\t<tr role=\"row\">\n\t\t\t${!dayCellsHtml}\n\t\t</tr>\n\t</thead>\n\t<tbody data-dojo-attach-point=\"dateRowsNode\" data-dojo-attach-event=\"onclick: _onDayClick\" class=\"dijitReset dijitCalendarBodyContainer\">\n\t\t\t${!dateRowsHtml}\n\t</tbody>\n\t<tfoot class=\"dijitReset dijitCalendarYearContainer\">\n\t\t<tr>\n\t\t\t<td class='dijitReset' valign=\"top\" colspan=\"7\" role=\"presentation\">\n\t\t\t\t<div class=\"dijitCalendarYearLabel\">\n\t\t\t\t\t<span data-dojo-attach-point=\"previousYearLabelNode\" class=\"dijitInline dijitCalendarPreviousYear\" role=\"button\"></span>\n\t\t\t\t\t<span data-dojo-attach-point=\"currentYearLabelNode\" class=\"dijitInline dijitCalendarSelectedYear\" role=\"button\" id=\"${id}_year\"></span>\n\t\t\t\t\t<span data-dojo-attach-point=\"nextYearLabelNode\" class=\"dijitInline dijitCalendarNextYear\" role=\"button\"></span>\n\t\t\t\t</div>\n\t\t\t</td>\n\t\t</tr>\n\t</tfoot>\n</table>\n","dijit/form/_AutoCompleterMixin":function(){
define(["dojo/data/util/filter","dojo/_base/declare","dojo/dom-attr","dojo/_base/event","dojo/keys","dojo/_base/lang","dojo/query","dojo/regexp","dojo/sniff","dojo/string","./DataList","../registry","./_TextBoxMixin","./_SearchMixin"],function(_283,_284,_285,_286,keys,lang,_287,_288,has,_289,_28a,_28b,_28c,_28d){
return _284("dijit.form._AutoCompleterMixin",_28d,{item:null,autoComplete:true,highlightMatch:"first",labelAttr:"",labelType:"text",maxHeight:-1,_stopClickEvents:false,_getCaretPos:function(_28e){
var pos=0;
if(typeof (_28e.selectionStart)=="number"){
pos=_28e.selectionStart;
}else{
if(has("ie")){
var tr=_28e.ownerDocument.selection.createRange().duplicate();
var ntr=_28e.createTextRange();
tr.move("character",0);
ntr.move("character",0);
try{
ntr.setEndPoint("EndToEnd",tr);
pos=String(ntr.text).replace(/\r/g,"").length;
}
catch(e){
}
}
}
return pos;
},_setCaretPos:function(_28f,_290){
_290=parseInt(_290);
_28c.selectInputText(_28f,_290,_290);
},_setDisabledAttr:function(_291){
this.inherited(arguments);
this.domNode.setAttribute("aria-disabled",_291?"true":"false");
},_onKey:function(evt){
if(evt.charCode>=32){
return;
}
var key=evt.charCode||evt.keyCode;
if(key==keys.ALT||key==keys.CTRL||key==keys.META||key==keys.SHIFT){
return;
}
var pw=this.dropDown;
var _292=null;
this._abortQuery();
this.inherited(arguments);
if(evt.altKey||evt.ctrlKey||evt.metaKey){
return;
}
if(this._opened){
_292=pw.getHighlightedOption();
}
switch(key){
case keys.PAGE_DOWN:
case keys.DOWN_ARROW:
case keys.PAGE_UP:
case keys.UP_ARROW:
if(this._opened){
this._announceOption(_292);
}
_286.stop(evt);
break;
case keys.ENTER:
if(_292){
if(_292==pw.nextButton){
this._nextSearch(1);
_286.stop(evt);
break;
}else{
if(_292==pw.previousButton){
this._nextSearch(-1);
_286.stop(evt);
break;
}
}
_286.stop(evt);
}else{
this._setBlurValue();
this._setCaretPos(this.focusNode,this.focusNode.value.length);
}
case keys.TAB:
var _293=this.get("displayedValue");
if(pw&&(_293==pw._messages["previousMessage"]||_293==pw._messages["nextMessage"])){
break;
}
if(_292){
this._selectOption(_292);
}
case keys.ESCAPE:
if(this._opened){
this._lastQuery=null;
this.closeDropDown();
}
break;
}
},_autoCompleteText:function(text){
var fn=this.focusNode;
_28c.selectInputText(fn,fn.value.length);
var _294=this.ignoreCase?"toLowerCase":"substr";
if(text[_294](0).indexOf(this.focusNode.value[_294](0))==0){
var cpos=this.autoComplete?this._getCaretPos(fn):fn.value.length;
if((cpos+1)>fn.value.length){
fn.value=text;
_28c.selectInputText(fn,cpos);
}
}else{
fn.value=text;
_28c.selectInputText(fn);
}
},_openResultList:function(_295,_296,_297){
var _298=this.dropDown.getHighlightedOption();
this.dropDown.clearResultList();
if(!_295.length&&_297.start==0){
this.closeDropDown();
return;
}
this._nextSearch=this.dropDown.onPage=lang.hitch(this,function(_299){
_295.nextPage(_299!==-1);
this.focus();
});
this.dropDown.createOptions(_295,_297,lang.hitch(this,"_getMenuLabelFromItem"));
this._showResultList();
if("direction" in _297){
if(_297.direction){
this.dropDown.highlightFirstOption();
}else{
if(!_297.direction){
this.dropDown.highlightLastOption();
}
}
if(_298){
this._announceOption(this.dropDown.getHighlightedOption());
}
}else{
if(this.autoComplete&&!this._prev_key_backspace&&!/^[*]+$/.test(_296[this.searchAttr].toString())){
this._announceOption(this.dropDown.containerNode.firstChild.nextSibling);
}
}
},_showResultList:function(){
this.closeDropDown(true);
this.openDropDown();
this.domNode.setAttribute("aria-expanded","true");
},loadDropDown:function(){
this._startSearchAll();
},isLoaded:function(){
return false;
},closeDropDown:function(){
this._abortQuery();
if(this._opened){
this.inherited(arguments);
this.domNode.setAttribute("aria-expanded","false");
this.focusNode.removeAttribute("aria-activedescendant");
}
},_setBlurValue:function(){
var _29a=this.get("displayedValue");
var pw=this.dropDown;
if(pw&&(_29a==pw._messages["previousMessage"]||_29a==pw._messages["nextMessage"])){
this._setValueAttr(this._lastValueReported,true);
}else{
if(typeof this.item=="undefined"){
this.item=null;
this.set("displayedValue",_29a);
}else{
if(this.value!=this._lastValueReported){
this._handleOnChange(this.value,true);
}
this._refreshState();
}
}
},_setItemAttr:function(item,_29b,_29c){
var _29d="";
if(item){
if(!_29c){
_29c=this.store._oldAPI?this.store.getValue(item,this.searchAttr):item[this.searchAttr];
}
_29d=this._getValueField()!=this.searchAttr?this.store.getIdentity(item):_29c;
}
this.set("value",_29d,_29b,_29c,item);
},_announceOption:function(node){
if(!node){
return;
}
var _29e;
if(node==this.dropDown.nextButton||node==this.dropDown.previousButton){
_29e=node.innerHTML;
this.item=undefined;
this.value="";
}else{
var item=this.dropDown.items[node.getAttribute("item")];
_29e=(this.store._oldAPI?this.store.getValue(item,this.searchAttr):item[this.searchAttr]).toString();
this.set("item",item,false,_29e);
}
this.focusNode.value=this.focusNode.value.substring(0,this._lastInput.length);
this.focusNode.setAttribute("aria-activedescendant",_285.get(node,"id"));
this._autoCompleteText(_29e);
},_selectOption:function(_29f){
this.closeDropDown();
if(_29f){
this._announceOption(_29f);
}
this._setCaretPos(this.focusNode,this.focusNode.value.length);
this._handleOnChange(this.value,true);
},_startSearchAll:function(){
this._startSearch("");
},_startSearchFromInput:function(){
this.item=undefined;
this.inherited(arguments);
},_startSearch:function(key){
if(!this.dropDown){
var _2a0=this.id+"_popup",_2a1=lang.isString(this.dropDownClass)?lang.getObject(this.dropDownClass,false):this.dropDownClass;
this.dropDown=new _2a1({onChange:lang.hitch(this,this._selectOption),id:_2a0,dir:this.dir,textDir:this.textDir});
this.focusNode.removeAttribute("aria-activedescendant");
this.textbox.setAttribute("aria-owns",_2a0);
}
this._lastInput=key;
this.inherited(arguments);
},_getValueField:function(){
return this.searchAttr;
},postMixInProperties:function(){
this.inherited(arguments);
if(!this.store){
var _2a2=this.srcNodeRef;
this.store=new _28a({},_2a2);
if(!("value" in this.params)){
var item=(this.item=this.store.fetchSelectedItem());
if(item){
var _2a3=this._getValueField();
this.value=this.store._oldAPI?this.store.getValue(item,_2a3):item[_2a3];
}
}
}
},postCreate:function(){
var _2a4=_287("label[for=\""+this.id+"\"]");
if(_2a4.length){
if(!_2a4[0].id){
_2a4[0].id=this.id+"_label";
}
this.domNode.setAttribute("aria-labelledby",_2a4[0].id);
}
this.inherited(arguments);
this.connect(this,"onSearch","_openResultList");
},_getMenuLabelFromItem:function(item){
var _2a5=this.labelFunc(item,this.store),_2a6=this.labelType;
if(this.highlightMatch!="none"&&this.labelType=="text"&&this._lastInput){
_2a5=this.doHighlight(_2a5,this._lastInput);
_2a6="html";
}
return {html:_2a6=="html",label:_2a5};
},doHighlight:function(_2a7,find){
var _2a8=(this.ignoreCase?"i":"")+(this.highlightMatch=="all"?"g":""),i=this.queryExpr.indexOf("${0}");
find=_288.escapeString(find);
return this._escapeHtml(_2a7.replace(new RegExp((i==0?"^":"")+"("+find+")"+(i==(this.queryExpr.length-4)?"$":""),_2a8),"\uffff$1\uffff")).replace(/\uFFFF([^\uFFFF]+)\uFFFF/g,"<span class=\"dijitComboBoxHighlightMatch\">$1</span>");
},_escapeHtml:function(str){
str=String(str).replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;");
return str;
},reset:function(){
this.item=null;
this.inherited(arguments);
},labelFunc:function(item,_2a9){
return (_2a9._oldAPI?_2a9.getValue(item,this.labelAttr||this.searchAttr):item[this.labelAttr||this.searchAttr]).toString();
},_setValueAttr:function(_2aa,_2ab,_2ac,item){
this._set("item",item||null);
if(_2aa==null){
_2aa="";
}
this.inherited(arguments);
},_setTextDirAttr:function(_2ad){
this.inherited(arguments);
if(this.dropDown){
this.dropDown._set("textDir",_2ad);
}
}});
});
},"url:dijit/templates/ColorPalette.html":"<div class=\"dijitInline dijitColorPalette\">\n\t<table dojoAttachPoint=\"paletteTableNode\" class=\"dijitPaletteTable\" cellSpacing=\"0\" cellPadding=\"0\" role=\"grid\">\n\t\t<tbody data-dojo-attach-point=\"gridNode\"></tbody>\n\t</table>\n</div>\n","url:dijit/layout/templates/_ScrollingTabControllerButton.html":"<div data-dojo-attach-event=\"onclick:_onClick\" class=\"dijitTabInnerDiv dijitTabContent dijitButtonContents\"  data-dojo-attach-point=\"focusNode\">\n\t<img role=\"presentation\" alt=\"\" src=\"${_blankGif}\" class=\"dijitTabStripIcon\" data-dojo-attach-point=\"iconNode\"/>\n\t<span data-dojo-attach-point=\"containerNode,titleNode\" class=\"dijitButtonText\"></span>\n</div>","dijit/form/MappedTextBox":function(){
define(["dojo/_base/declare","dojo/dom-construct","./ValidationTextBox"],function(_2ae,_2af,_2b0){
return _2ae("dijit.form.MappedTextBox",_2b0,{postMixInProperties:function(){
this.inherited(arguments);
this.nameAttrSetting="";
},_setNameAttr:null,serialize:function(val){
return val.toString?val.toString():"";
},toString:function(){
var val=this.filter(this.get("value"));
return val!=null?(typeof val=="string"?val:this.serialize(val,this.constraints)):"";
},validate:function(){
this.valueNode.value=this.toString();
return this.inherited(arguments);
},buildRendering:function(){
this.inherited(arguments);
this.valueNode=_2af.place("<input type='hidden'"+(this.name?" name=\""+this.name.replace(/"/g,"&quot;")+"\"":"")+"/>",this.textbox,"after");
},reset:function(){
this.valueNode.value="";
this.inherited(arguments);
}});
});
},"dijit/form/ComboBoxMixin":function(){
define(["dojo/_base/declare","dojo/_base/Deferred","dojo/_base/kernel","dojo/_base/lang","dojo/store/util/QueryResults","./_AutoCompleterMixin","./_ComboBoxMenu","../_HasDropDown","dojo/text!./templates/DropDownBox.html"],function(_2b1,_2b2,_2b3,lang,_2b4,_2b5,_2b6,_2b7,_2b8){
return _2b1("dijit.form.ComboBoxMixin",[_2b7,_2b5],{dropDownClass:_2b6,hasDownArrow:true,templateString:_2b8,baseClass:"dijitTextBox dijitComboBox",cssStateNodes:{"_buttonNode":"dijitDownArrowButton"},_setHasDownArrowAttr:function(val){
this._set("hasDownArrow",val);
this._buttonNode.style.display=val?"":"none";
},_showResultList:function(){
this.displayMessage("");
this.inherited(arguments);
},_setStoreAttr:function(_2b9){
if(!_2b9.get){
lang.mixin(_2b9,{_oldAPI:true,get:function(id){
var _2ba=new _2b2();
this.fetchItemByIdentity({identity:id,onItem:function(_2bb){
_2ba.resolve(_2bb);
},onError:function(_2bc){
_2ba.reject(_2bc);
}});
return _2ba.promise;
},query:function(_2bd,_2be){
var _2bf=new _2b2(function(){
_2c0.abort&&_2c0.abort();
});
_2bf.total=new _2b2();
var _2c0=this.fetch(lang.mixin({query:_2bd,onBegin:function(_2c1){
_2bf.total.resolve(_2c1);
},onComplete:function(_2c2){
_2bf.resolve(_2c2);
},onError:function(_2c3){
_2bf.reject(_2c3);
}},_2be));
return _2b4(_2bf);
}});
}
this._set("store",_2b9);
},postMixInProperties:function(){
var _2c4=this.params.store||this.store;
if(_2c4){
this._setStoreAttr(_2c4);
}
this.inherited(arguments);
if(!this.params.store&&!this.store._oldAPI){
var _2c5=this.declaredClass;
lang.mixin(this.store,{getValue:function(item,attr){
_2b3.deprecated(_2c5+".store.getValue(item, attr) is deprecated for builtin store.  Use item.attr directly","","2.0");
return item[attr];
},getLabel:function(item){
_2b3.deprecated(_2c5+".store.getLabel(item) is deprecated for builtin store.  Use item.label directly","","2.0");
return item.name;
},fetch:function(args){
_2b3.deprecated(_2c5+".store.fetch() is deprecated for builtin store.","Use store.query()","2.0");
var shim=["dojo/data/ObjectStore"];
require(shim,lang.hitch(this,function(_2c6){
new _2c6({objectStore:this}).fetch(args);
}));
}});
}
}});
});
},"dojo/_base/query":function(){
define(["../query","./NodeList"],function(_2c7){
return _2c7;
});
},"dijit/form/_TextBoxMixin":function(){
define(["dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/_base/event","dojo/keys","dojo/_base/lang","dojo/on","../main"],function(_2c8,_2c9,dom,_2ca,keys,lang,on,_2cb){
var _2cc=_2c9("dijit.form._TextBoxMixin",null,{trim:false,uppercase:false,lowercase:false,propercase:false,maxLength:"",selectOnClick:false,placeHolder:"",_getValueAttr:function(){
return this.parse(this.get("displayedValue"),this.constraints);
},_setValueAttr:function(_2cd,_2ce,_2cf){
var _2d0;
if(_2cd!==undefined){
_2d0=this.filter(_2cd);
if(typeof _2cf!="string"){
if(_2d0!==null&&((typeof _2d0!="number")||!isNaN(_2d0))){
_2cf=this.filter(this.format(_2d0,this.constraints));
}else{
_2cf="";
}
}
}
if(_2cf!=null&&((typeof _2cf)!="number"||!isNaN(_2cf))&&this.textbox.value!=_2cf){
this.textbox.value=_2cf;
this._set("displayedValue",this.get("displayedValue"));
}
if(this.textDir=="auto"){
this.applyTextDir(this.focusNode,_2cf);
}
this.inherited(arguments,[_2d0,_2ce]);
},displayedValue:"",_getDisplayedValueAttr:function(){
return this.filter(this.textbox.value);
},_setDisplayedValueAttr:function(_2d1){
if(_2d1==null){
_2d1="";
}else{
if(typeof _2d1!="string"){
_2d1=String(_2d1);
}
}
this.textbox.value=_2d1;
this._setValueAttr(this.get("value"),undefined);
this._set("displayedValue",this.get("displayedValue"));
if(this.textDir=="auto"){
this.applyTextDir(this.focusNode,_2d1);
}
},format:function(_2d2){
return _2d2==null?"":(_2d2.toString?_2d2.toString():_2d2);
},parse:function(_2d3){
return _2d3;
},_refreshState:function(){
},onInput:function(){
},__skipInputEvent:false,_onInput:function(evt){
if(this.textDir=="auto"){
this.applyTextDir(this.focusNode,this.focusNode.value);
}
this._processInput(evt);
},_processInput:function(evt){
this._refreshState();
this._set("displayedValue",this.get("displayedValue"));
},postCreate:function(){
this.textbox.setAttribute("value",this.textbox.value);
this.inherited(arguments);
var _2d4=function(e){
var _2d5;
if(e.type=="keydown"){
_2d5=e.keyCode;
switch(_2d5){
case keys.SHIFT:
case keys.ALT:
case keys.CTRL:
case keys.META:
case keys.CAPS_LOCK:
case keys.NUM_LOCK:
case keys.SCROLL_LOCK:
return;
}
if(!e.ctrlKey&&!e.metaKey&&!e.altKey){
switch(_2d5){
case keys.NUMPAD_0:
case keys.NUMPAD_1:
case keys.NUMPAD_2:
case keys.NUMPAD_3:
case keys.NUMPAD_4:
case keys.NUMPAD_5:
case keys.NUMPAD_6:
case keys.NUMPAD_7:
case keys.NUMPAD_8:
case keys.NUMPAD_9:
case keys.NUMPAD_MULTIPLY:
case keys.NUMPAD_PLUS:
case keys.NUMPAD_ENTER:
case keys.NUMPAD_MINUS:
case keys.NUMPAD_PERIOD:
case keys.NUMPAD_DIVIDE:
return;
}
if((_2d5>=65&&_2d5<=90)||(_2d5>=48&&_2d5<=57)||_2d5==keys.SPACE){
return;
}
var _2d6=false;
for(var i in keys){
if(keys[i]===e.keyCode){
_2d6=true;
break;
}
}
if(!_2d6){
return;
}
}
}
_2d5=e.charCode>=32?String.fromCharCode(e.charCode):e.charCode;
if(!_2d5){
_2d5=(e.keyCode>=65&&e.keyCode<=90)||(e.keyCode>=48&&e.keyCode<=57)||e.keyCode==keys.SPACE?String.fromCharCode(e.keyCode):e.keyCode;
}
if(!_2d5){
_2d5=229;
}
if(e.type=="keypress"){
if(typeof _2d5!="string"){
return;
}
if((_2d5>="a"&&_2d5<="z")||(_2d5>="A"&&_2d5<="Z")||(_2d5>="0"&&_2d5<="9")||(_2d5===" ")){
if(e.ctrlKey||e.metaKey||e.altKey){
return;
}
}
}
if(e.type=="input"){
if(this.__skipInputEvent){
this.__skipInputEvent=false;
return;
}
}else{
this.__skipInputEvent=true;
}
var faux={faux:true},attr;
for(attr in e){
if(attr!="layerX"&&attr!="layerY"){
var v=e[attr];
if(typeof v!="function"&&typeof v!="undefined"){
faux[attr]=v;
}
}
}
lang.mixin(faux,{charOrCode:_2d5,_wasConsumed:false,preventDefault:function(){
faux._wasConsumed=true;
e.preventDefault();
},stopPropagation:function(){
e.stopPropagation();
}});
if(this.onInput(faux)===false){
faux.preventDefault();
faux.stopPropagation();
}
if(faux._wasConsumed){
return;
}
this.defer(function(){
this._onInput(faux);
});
};
this.own(on(this.textbox,"keydown, keypress, paste, cut, input, compositionend",lang.hitch(this,_2d4)));
},_blankValue:"",filter:function(val){
if(val===null){
return this._blankValue;
}
if(typeof val!="string"){
return val;
}
if(this.trim){
val=lang.trim(val);
}
if(this.uppercase){
val=val.toUpperCase();
}
if(this.lowercase){
val=val.toLowerCase();
}
if(this.propercase){
val=val.replace(/[^\s]+/g,function(word){
return word.substring(0,1).toUpperCase()+word.substring(1);
});
}
return val;
},_setBlurValue:function(){
this._setValueAttr(this.get("value"),true);
},_onBlur:function(e){
if(this.disabled){
return;
}
this._setBlurValue();
this.inherited(arguments);
},_isTextSelected:function(){
return this.textbox.selectionStart!=this.textbox.selectionEnd;
},_onFocus:function(by){
if(this.disabled||this.readOnly){
return;
}
if(this.selectOnClick&&by=="mouse"){
this._selectOnClickHandle=this.connect(this.domNode,"onmouseup",function(){
this.disconnect(this._selectOnClickHandle);
this._selectOnClickHandle=null;
if(!this._isTextSelected()){
_2cc.selectInputText(this.textbox);
}
});
this.defer(function(){
if(this._selectOnClickHandle){
this.disconnect(this._selectOnClickHandle);
this._selectOnClickHandle=null;
}
},500);
}
this.inherited(arguments);
this._refreshState();
},reset:function(){
this.textbox.value="";
this.inherited(arguments);
},_setTextDirAttr:function(_2d7){
if(!this._created||this.textDir!=_2d7){
this._set("textDir",_2d7);
this.applyTextDir(this.focusNode,this.focusNode.value);
}
}});
_2cc._setSelectionRange=_2cb._setSelectionRange=function(_2d8,_2d9,stop){
if(_2d8.setSelectionRange){
_2d8.setSelectionRange(_2d9,stop);
}
};
_2cc.selectInputText=_2cb.selectInputText=function(_2da,_2db,stop){
_2da=dom.byId(_2da);
if(isNaN(_2db)){
_2db=0;
}
if(isNaN(stop)){
stop=_2da.value?_2da.value.length:0;
}
try{
_2da.focus();
_2cc._setSelectionRange(_2da,_2db,stop);
}
catch(e){
}
};
return _2cc;
});
},"dijit/form/SimpleTextarea":function(){
define("dijit/form/SimpleTextarea",["dojo/_base/declare","dojo/dom-class","dojo/sniff","./TextBox"],function(_2dc,_2dd,has,_2de){
return _2dc("dijit.form.SimpleTextarea",_2de,{baseClass:"dijitTextBox dijitTextArea",rows:"3",cols:"20",templateString:"<textarea ${!nameAttrSetting} data-dojo-attach-point='focusNode,containerNode,textbox' autocomplete='off'></textarea>",postMixInProperties:function(){
if(!this.value&&this.srcNodeRef){
this.value=this.srcNodeRef.value;
}
this.inherited(arguments);
},buildRendering:function(){
this.inherited(arguments);
if(has("ie")&&this.cols){
_2dd.add(this.textbox,"dijitTextAreaCols");
}
},filter:function(_2df){
if(_2df){
_2df=_2df.replace(/\r/g,"");
}
return this.inherited(arguments);
},_onInput:function(e){
if(this.maxLength){
var _2e0=parseInt(this.maxLength);
var _2e1=this.textbox.value.replace(/\r/g,"");
var _2e2=_2e1.length-_2e0;
if(_2e2>0){
var _2e3=this.textbox;
if(_2e3.selectionStart){
var pos=_2e3.selectionStart;
var cr=0;
if(has("opera")){
cr=(this.textbox.value.substring(0,pos).match(/\r/g)||[]).length;
}
this.textbox.value=_2e1.substring(0,pos-_2e2-cr)+_2e1.substring(pos-cr);
_2e3.setSelectionRange(pos-_2e2,pos-_2e2);
}else{
if(this.ownerDocument.selection){
_2e3.focus();
var _2e4=this.ownerDocument.selection.createRange();
_2e4.moveStart("character",-_2e2);
_2e4.text="";
_2e4.select();
}
}
}
}
this.inherited(arguments);
}});
});
},"url:dijit/layout/templates/_TabButton.html":"<div role=\"presentation\" data-dojo-attach-point=\"titleNode,innerDiv,tabContent\" class=\"dijitTabInner dijitTabContent\">\n\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitIcon dijitTabButtonIcon\" data-dojo-attach-point='iconNode'/>\n\t<span data-dojo-attach-point='containerNode,focusNode' class='tabLabel'></span>\n\t<span class=\"dijitInline dijitTabCloseButton dijitTabCloseIcon\" data-dojo-attach-point='closeNode'\n\t\t  role=\"presentation\">\n\t\t<span data-dojo-attach-point='closeText' class='dijitTabCloseText'>[x]</span\n\t\t\t\t></span>\n</div>\n","dijit/PopupMenuItem":function(){
define(["dojo/_base/declare","dojo/dom-style","dojo/query","./registry","./MenuItem","./hccss"],function(_2e5,_2e6,_2e7,_2e8,_2e9){
return _2e5("dijit.PopupMenuItem",_2e9,{_fillContent:function(){
if(this.srcNodeRef){
var _2ea=_2e7("*",this.srcNodeRef);
this.inherited(arguments,[_2ea[0]]);
this.dropDownContainer=this.srcNodeRef;
}
},startup:function(){
if(this._started){
return;
}
this.inherited(arguments);
if(!this.popup){
var node=_2e7("[widgetId]",this.dropDownContainer)[0];
this.popup=_2e8.byNode(node);
}
this.ownerDocumentBody.appendChild(this.popup.domNode);
this.popup.startup();
this.popup.domNode.style.display="none";
if(this.arrowWrapper){
_2e6.set(this.arrowWrapper,"visibility","");
}
this.focusNode.setAttribute("aria-haspopup","true");
},destroyDescendants:function(_2eb){
if(this.popup){
if(!this.popup._destroyed){
this.popup.destroyRecursive(_2eb);
}
delete this.popup;
}
this.inherited(arguments);
}});
});
},"dijit/_TimePicker":function(){
define(["dojo/_base/array","dojo/date","dojo/date/locale","dojo/date/stamp","dojo/_base/declare","dojo/dom-class","dojo/dom-construct","dojo/_base/event","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/sniff","dojo/query","dojo/mouse","./typematic","./_Widget","./_TemplatedMixin","./form/_FormValueWidget","dojo/text!./templates/TimePicker.html"],function(_2ec,_2ed,_2ee,_2ef,_2f0,_2f1,_2f2,_2f3,_2f4,keys,lang,has,_2f5,_2f6,_2f7,_2f8,_2f9,_2fa,_2fb){
var _2fc=_2f0("dijit._TimePicker",[_2f8,_2f9],{templateString:_2fb,baseClass:"dijitTimePicker",clickableIncrement:"T00:15:00",visibleIncrement:"T01:00:00",visibleRange:"T05:00:00",value:new Date(),_visibleIncrement:2,_clickableIncrement:1,_totalIncrements:10,constraints:{},serialize:_2ef.toISOString,setValue:function(_2fd){
_2f4.deprecated("dijit._TimePicker:setValue() is deprecated.  Use set('value', ...) instead.","","2.0");
this.set("value",_2fd);
},_setValueAttr:function(date){
this._set("value",date);
this._showText();
},_setFilterStringAttr:function(val){
this._set("filterString",val);
this._showText();
},isDisabledDate:function(){
return false;
},_getFilteredNodes:function(_2fe,_2ff,_300,_301){
var _302=[],_303=_301?_301.date:this._refDate,n,i=_2fe,max=this._maxIncrement+Math.abs(i),chk=_300?-1:1,dec=_300?1:0,inc=1-dec;
do{
i-=dec;
n=this._createOption(i);
if(n){
if((_300&&n.date>_303)||(!_300&&n.date<_303)){
break;
}
_302[_300?"unshift":"push"](n);
_303=n.date;
}
i+=inc;
}while(_302.length<_2ff&&(i*chk)<max);
return _302;
},_showText:function(){
var _304=_2ef.fromISOString;
this.timeMenu.innerHTML="";
this._clickableIncrementDate=_304(this.clickableIncrement);
this._visibleIncrementDate=_304(this.visibleIncrement);
this._visibleRangeDate=_304(this.visibleRange);
var _305=function(date){
return date.getHours()*60*60+date.getMinutes()*60+date.getSeconds();
},_306=_305(this._clickableIncrementDate),_307=_305(this._visibleIncrementDate),_308=_305(this._visibleRangeDate),time=(this.value||this.currentFocus).getTime();
this._refDate=new Date(time-time%(_306*1000));
this._refDate.setFullYear(1970,0,1);
this._clickableIncrement=1;
this._totalIncrements=_308/_306;
this._visibleIncrement=_307/_306;
this._maxIncrement=(60*60*24)/_306;
var _309=Math.min(this._totalIncrements,10),_30a=this._getFilteredNodes(0,(_309>>1)+1,false),_30b=[],_30c=_309-_30a.length,_30d=this._getFilteredNodes(0,_30c,true,_30a[0]);
if(_30d.length<_30c&&_30a.length>0){
_30b=this._getFilteredNodes(_30a[_30a.length-1].idx+1,_30c-_30d.length,false,_30a[_30a.length-1]);
}
_2ec.forEach(_30d.concat(_30a,_30b),function(n){
this.timeMenu.appendChild(n);
},this);
if(!_30d.length&&!_30a.length&&!_30b.length&&this.filterString){
this.filterString="";
this._showText();
}
},constructor:function(){
this.constraints={};
},postMixInProperties:function(){
this.inherited(arguments);
this._setConstraintsAttr(this.constraints);
},_setConstraintsAttr:function(_30e){
lang.mixin(this,_30e);
if(!_30e.locale){
_30e.locale=this.lang;
}
},postCreate:function(){
this.connect(this.timeMenu,_2f6.wheel,"_mouseWheeled");
this.own(_2f7.addMouseListener(this.upArrow,this,"_onArrowUp",33,250),_2f7.addMouseListener(this.downArrow,this,"_onArrowDown",33,250));
this.inherited(arguments);
},_buttonMouse:function(e){
_2f1.toggle(e.currentTarget,e.currentTarget==this.upArrow?"dijitUpArrowHover":"dijitDownArrowHover",e.type=="mouseenter"||e.type=="mouseover");
},_createOption:function(_30f){
var date=new Date(this._refDate);
var _310=this._clickableIncrementDate;
date.setTime(date.getTime()+_310.getHours()*_30f*3600000+_310.getMinutes()*_30f*60000+_310.getSeconds()*_30f*1000);
if(this.constraints.selector=="time"){
date.setFullYear(1970,0,1);
}
var _311=_2ee.format(date,this.constraints);
if(this.filterString&&_311.toLowerCase().indexOf(this.filterString)!==0){
return null;
}
var div=this.ownerDocument.createElement("div");
div.className=this.baseClass+"Item";
div.date=date;
div.idx=_30f;
_2f2.create("div",{"class":this.baseClass+"ItemInner",innerHTML:_311},div);
if(_30f%this._visibleIncrement<1&&_30f%this._visibleIncrement>-1){
_2f1.add(div,this.baseClass+"Marker");
}else{
if(!(_30f%this._clickableIncrement)){
_2f1.add(div,this.baseClass+"Tick");
}
}
if(this.isDisabledDate(date)){
_2f1.add(div,this.baseClass+"ItemDisabled");
}
if(this.value&&!_2ed.compare(this.value,date,this.constraints.selector)){
div.selected=true;
_2f1.add(div,this.baseClass+"ItemSelected");
if(_2f1.contains(div,this.baseClass+"Marker")){
_2f1.add(div,this.baseClass+"MarkerSelected");
}else{
_2f1.add(div,this.baseClass+"TickSelected");
}
this._highlightOption(div,true);
}
return div;
},_onOptionSelected:function(tgt){
var _312=tgt.target.date||tgt.target.parentNode.date;
if(!_312||this.isDisabledDate(_312)){
return;
}
this._highlighted_option=null;
this.set("value",_312);
this.onChange(_312);
},onChange:function(){
},_highlightOption:function(node,_313){
if(!node){
return;
}
if(_313){
if(this._highlighted_option){
this._highlightOption(this._highlighted_option,false);
}
this._highlighted_option=node;
}else{
if(this._highlighted_option!==node){
return;
}else{
this._highlighted_option=null;
}
}
_2f1.toggle(node,this.baseClass+"ItemHover",_313);
if(_2f1.contains(node,this.baseClass+"Marker")){
_2f1.toggle(node,this.baseClass+"MarkerHover",_313);
}else{
_2f1.toggle(node,this.baseClass+"TickHover",_313);
}
},onmouseover:function(e){
this._keyboardSelected=null;
var tgr=(e.target.parentNode===this.timeMenu)?e.target:e.target.parentNode;
if(!_2f1.contains(tgr,this.baseClass+"Item")){
return;
}
this._highlightOption(tgr,true);
},onmouseout:function(e){
this._keyboardSelected=null;
var tgr=(e.target.parentNode===this.timeMenu)?e.target:e.target.parentNode;
this._highlightOption(tgr,false);
},_mouseWheeled:function(e){
this._keyboardSelected=null;
_2f3.stop(e);
this[(e.wheelDelta>0?"_onArrowUp":"_onArrowDown")]();
},_onArrowUp:function(_314){
if(_314===-1){
_2f1.remove(this.upArrow,"dijitUpArrowActive");
return;
}else{
if(_314===0){
_2f1.add(this.upArrow,"dijitUpArrowActive");
}
}
if(!this.timeMenu.childNodes.length){
return;
}
var _315=this.timeMenu.childNodes[0].idx;
var divs=this._getFilteredNodes(_315,1,true,this.timeMenu.childNodes[0]);
if(divs.length){
this.timeMenu.removeChild(this.timeMenu.childNodes[this.timeMenu.childNodes.length-1]);
this.timeMenu.insertBefore(divs[0],this.timeMenu.childNodes[0]);
}
},_onArrowDown:function(_316){
if(_316===-1){
_2f1.remove(this.downArrow,"dijitDownArrowActive");
return;
}else{
if(_316===0){
_2f1.add(this.downArrow,"dijitDownArrowActive");
}
}
if(!this.timeMenu.childNodes.length){
return;
}
var _317=this.timeMenu.childNodes[this.timeMenu.childNodes.length-1].idx+1;
var divs=this._getFilteredNodes(_317,1,false,this.timeMenu.childNodes[this.timeMenu.childNodes.length-1]);
if(divs.length){
this.timeMenu.removeChild(this.timeMenu.childNodes[0]);
this.timeMenu.appendChild(divs[0]);
}
},handleKey:function(e){
if(e.keyCode==keys.DOWN_ARROW||e.keyCode==keys.UP_ARROW){
_2f3.stop(e);
if(this._highlighted_option&&!this._highlighted_option.parentNode){
this._highlighted_option=null;
}
var _318=this.timeMenu,tgt=this._highlighted_option||_2f5("."+this.baseClass+"ItemSelected",_318)[0];
if(!tgt){
tgt=_318.childNodes[0];
}else{
if(_318.childNodes.length){
if(e.keyCode==keys.DOWN_ARROW&&!tgt.nextSibling){
this._onArrowDown();
}else{
if(e.keyCode==keys.UP_ARROW&&!tgt.previousSibling){
this._onArrowUp();
}
}
if(e.keyCode==keys.DOWN_ARROW){
tgt=tgt.nextSibling;
}else{
tgt=tgt.previousSibling;
}
}
}
this._highlightOption(tgt,true);
this._keyboardSelected=tgt;
return false;
}else{
if(e.keyCode==keys.ENTER||e.keyCode===keys.TAB){
if(!this._keyboardSelected&&e.keyCode===keys.TAB){
return true;
}
if(this._highlighted_option){
this._onOptionSelected({target:this._highlighted_option});
}
return e.keyCode===keys.TAB;
}
}
return undefined;
}});
return _2fc;
});
},"dijit/form/RadioButton":function(){
define("dijit/form/RadioButton",["dojo/_base/declare","./CheckBox","./_RadioButtonMixin"],function(_319,_31a,_31b){
return _319("dijit.form.RadioButton",[_31a,_31b],{baseClass:"dijitRadio"});
});
},"url:dijit/form/templates/HorizontalSlider.html":"<table class=\"dijit dijitReset dijitSlider dijitSliderH\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" rules=\"none\" data-dojo-attach-event=\"onkeypress:_onKeyPress,onkeyup:_onKeyUp\"\n\trole=\"presentation\"\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\n\t\t><td data-dojo-attach-point=\"topDecoration\" class=\"dijitReset dijitSliderDecoration dijitSliderDecorationT dijitSliderDecorationH\"></td\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset dijitSliderButtonContainer dijitSliderButtonContainerH\"\n\t\t\t><div class=\"dijitSliderDecrementIconH\" style=\"display:none\" data-dojo-attach-point=\"decrementButton\"><span class=\"dijitSliderButtonInner\">-</span></div\n\t\t></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><div class=\"dijitSliderBar dijitSliderBumper dijitSliderBumperH dijitSliderLeftBumper\" data-dojo-attach-event=\"press:_onClkDecBumper\"></div\n\t\t></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><input data-dojo-attach-point=\"valueNode\" type=\"hidden\" ${!nameAttrSetting}\n\t\t\t/><div class=\"dijitReset dijitSliderBarContainerH\" role=\"presentation\" data-dojo-attach-point=\"sliderBarContainer\"\n\t\t\t\t><div role=\"presentation\" data-dojo-attach-point=\"progressBar\" class=\"dijitSliderBar dijitSliderBarH dijitSliderProgressBar dijitSliderProgressBarH\" data-dojo-attach-event=\"press:_onBarClick\"\n\t\t\t\t\t><div class=\"dijitSliderMoveable dijitSliderMoveableH\"\n\t\t\t\t\t\t><div data-dojo-attach-point=\"sliderHandle,focusNode\" class=\"dijitSliderImageHandle dijitSliderImageHandleH\" data-dojo-attach-event=\"press:_onHandleClick\" role=\"slider\"></div\n\t\t\t\t\t></div\n\t\t\t\t></div\n\t\t\t\t><div role=\"presentation\" data-dojo-attach-point=\"remainingBar\" class=\"dijitSliderBar dijitSliderBarH dijitSliderRemainingBar dijitSliderRemainingBarH\" data-dojo-attach-event=\"press:_onBarClick\"></div\n\t\t\t></div\n\t\t></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><div class=\"dijitSliderBar dijitSliderBumper dijitSliderBumperH dijitSliderRightBumper\" data-dojo-attach-event=\"press:_onClkIncBumper\"></div\n\t\t></td\n\t\t><td class=\"dijitReset dijitSliderButtonContainer dijitSliderButtonContainerH\"\n\t\t\t><div class=\"dijitSliderIncrementIconH\" style=\"display:none\" data-dojo-attach-point=\"incrementButton\"><span class=\"dijitSliderButtonInner\">+</span></div\n\t\t></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\n\t\t><td data-dojo-attach-point=\"containerNode,bottomDecoration\" class=\"dijitReset dijitSliderDecoration dijitSliderDecorationB dijitSliderDecorationH\"></td\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\n\t></tr\n></table>\n","url:dijit/templates/TimePicker.html":"<div id=\"widget_${id}\" class=\"dijitMenu\"\n    ><div data-dojo-attach-point=\"upArrow\" class=\"dijitButtonNode dijitUpArrowButton\" data-dojo-attach-event=\"onmouseenter:_buttonMouse,onmouseleave:_buttonMouse\"\n\t\t><div class=\"dijitReset dijitInline dijitArrowButtonInner\" role=\"presentation\">&#160;</div\n\t\t><div class=\"dijitArrowButtonChar\">&#9650;</div></div\n    ><div data-dojo-attach-point=\"timeMenu,focusNode\" data-dojo-attach-event=\"onclick:_onOptionSelected,onmouseover,onmouseout\"></div\n    ><div data-dojo-attach-point=\"downArrow\" class=\"dijitButtonNode dijitDownArrowButton\" data-dojo-attach-event=\"onmouseenter:_buttonMouse,onmouseleave:_buttonMouse\"\n\t\t><div class=\"dijitReset dijitInline dijitArrowButtonInner\" role=\"presentation\">&#160;</div\n\t\t><div class=\"dijitArrowButtonChar\">&#9660;</div></div\n></div>\n","dijit/InlineEditBox":function(){
define(["require","dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-style","dojo/_base/event","dojo/i18n","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/sniff","dojo/when","./focus","./_Widget","./_TemplatedMixin","./_WidgetsInTemplateMixin","./_Container","./form/Button","./form/_TextBoxMixin","./form/TextBox","dojo/text!./templates/InlineEditBox.html","dojo/i18n!./nls/common"],function(_31c,_31d,_31e,_31f,_320,_321,_322,_323,i18n,_324,keys,lang,has,when,fm,_325,_326,_327,_328,_329,_32a,_32b,_32c){
var _32d=_31e("dijit._InlineEditor",[_325,_326,_327],{templateString:_32c,postMixInProperties:function(){
this.inherited(arguments);
this.messages=i18n.getLocalization("dijit","common",this.lang);
_31d.forEach(["buttonSave","buttonCancel"],function(prop){
if(!this[prop]){
this[prop]=this.messages[prop];
}
},this);
},buildRendering:function(){
this.inherited(arguments);
var Cls=typeof this.editor=="string"?(lang.getObject(this.editor)||_31c(this.editor)):this.editor;
var _32e=this.sourceStyle,_32f="line-height:"+_32e.lineHeight+";",_330=_322.getComputedStyle(this.domNode);
_31d.forEach(["Weight","Family","Size","Style"],function(prop){
var _331=_32e["font"+prop],_332=_330["font"+prop];
if(_332!=_331){
_32f+="font-"+prop+":"+_32e["font"+prop]+";";
}
},this);
_31d.forEach(["marginTop","marginBottom","marginLeft","marginRight","position","left","top","right","bottom","float","clear","display"],function(prop){
this.domNode.style[prop]=_32e[prop];
},this);
var _333=this.inlineEditBox.width;
if(_333=="100%"){
_32f+="width:100%;";
this.domNode.style.display="block";
}else{
_32f+="width:"+(_333+(Number(_333)==_333?"px":""))+";";
}
var _334=lang.delegate(this.inlineEditBox.editorParams,{style:_32f,dir:this.dir,lang:this.lang,textDir:this.textDir});
_334["displayedValue" in Cls.prototype?"displayedValue":"value"]=this.value;
this.editWidget=new Cls(_334,this.editorPlaceholder);
if(this.inlineEditBox.autoSave){
_321.destroy(this.buttonContainer);
}
},postCreate:function(){
this.inherited(arguments);
var ew=this.editWidget;
if(this.inlineEditBox.autoSave){
this.connect(ew,"onChange","_onChange");
this.connect(ew,"onKeyPress","_onKeyPress");
}else{
if("intermediateChanges" in ew){
ew.set("intermediateChanges",true);
this.connect(ew,"onChange","_onIntermediateChange");
this.saveButton.set("disabled",true);
}
}
},startup:function(){
this.editWidget.startup();
this.inherited(arguments);
},_onIntermediateChange:function(){
this.saveButton.set("disabled",(this.getValue()==this._resetValue)||!this.enableSave());
},destroy:function(){
this.editWidget.destroy(true);
this.inherited(arguments);
},getValue:function(){
var ew=this.editWidget;
return String(ew.get("displayedValue" in ew?"displayedValue":"value"));
},_onKeyPress:function(e){
if(this.inlineEditBox.autoSave&&this.inlineEditBox.editing){
if(e.altKey||e.ctrlKey){
return;
}
if(e.charOrCode==keys.ESCAPE){
_323.stop(e);
this.cancel(true);
}else{
if(e.charOrCode==keys.ENTER&&e.target.tagName=="INPUT"){
_323.stop(e);
this._onChange();
}
}
}
},_onBlur:function(){
this.inherited(arguments);
if(this.inlineEditBox.autoSave&&this.inlineEditBox.editing){
if(this.getValue()==this._resetValue){
this.cancel(false);
}else{
if(this.enableSave()){
this.save(false);
}
}
}
},_onChange:function(){
if(this.inlineEditBox.autoSave&&this.inlineEditBox.editing&&this.enableSave()){
fm.focus(this.inlineEditBox.displayNode);
}
},enableSave:function(){
return this.editWidget.isValid?this.editWidget.isValid():true;
},focus:function(){
this.editWidget.focus();
if(this.editWidget.focusNode){
fm._onFocusNode(this.editWidget.focusNode);
if(this.editWidget.focusNode.tagName=="INPUT"){
this.defer(function(){
_32a.selectInputText(this.editWidget.focusNode);
});
}
}
}});
var _335=_31e("dijit.InlineEditBox",_325,{editing:false,autoSave:true,buttonSave:"",buttonCancel:"",renderAsHtml:false,editor:_32b,editorWrapper:_32d,editorParams:{},disabled:false,onChange:function(){
},onCancel:function(){
},width:"100%",value:"",noValueIndicator:has("ie")<=6?"<span style='font-family: wingdings; text-decoration: underline;'>&#160;&#160;&#160;&#160;&#x270d;&#160;&#160;&#160;&#160;</span>":"<span style='text-decoration: underline;'>&#160;&#160;&#160;&#160;&#x270d;&#160;&#160;&#160;&#160;</span>",constructor:function(){
this.editorParams={};
},postMixInProperties:function(){
this.inherited(arguments);
this.displayNode=this.srcNodeRef;
var _336={ondijitclick:"_onClick",onmouseover:"_onMouseOver",onmouseout:"_onMouseOut",onfocus:"_onMouseOver",onblur:"_onMouseOut"};
for(var name in _336){
this.connect(this.displayNode,name,_336[name]);
}
this.displayNode.setAttribute("role","button");
if(!this.displayNode.getAttribute("tabIndex")){
this.displayNode.setAttribute("tabIndex",0);
}
if(!this.value&&!("value" in this.params)){
this.value=lang.trim(this.renderAsHtml?this.displayNode.innerHTML:(this.displayNode.innerText||this.displayNode.textContent||""));
}
if(!this.value){
this.displayNode.innerHTML=this.noValueIndicator;
}
_320.add(this.displayNode,"dijitInlineEditBoxDisplayMode");
},setDisabled:function(_337){
_324.deprecated("dijit.InlineEditBox.setDisabled() is deprecated.  Use set('disabled', bool) instead.","","2.0");
this.set("disabled",_337);
},_setDisabledAttr:function(_338){
this.domNode.setAttribute("aria-disabled",_338?"true":"false");
if(_338){
this.displayNode.removeAttribute("tabIndex");
}else{
this.displayNode.setAttribute("tabIndex",0);
}
_320.toggle(this.displayNode,"dijitInlineEditBoxDisplayModeDisabled",_338);
this._set("disabled",_338);
},_onMouseOver:function(){
if(!this.disabled){
_320.add(this.displayNode,"dijitInlineEditBoxDisplayModeHover");
}
},_onMouseOut:function(){
_320.remove(this.displayNode,"dijitInlineEditBoxDisplayModeHover");
},_onClick:function(e){
if(this.disabled){
return;
}
if(e){
_323.stop(e);
}
this._onMouseOut();
this.defer("edit");
},edit:function(){
if(this.disabled||this.editing){
return;
}
this._set("editing",true);
this._savedTabIndex=_31f.get(this.displayNode,"tabIndex")||"0";
if(this.wrapperWidget){
var ew=this.wrapperWidget.editWidget;
ew.set("displayedValue" in ew?"displayedValue":"value",this.value);
}else{
var _339=_321.create("span",null,this.domNode,"before");
var Ewc=typeof this.editorWrapper=="string"?lang.getObject(this.editorWrapper):this.editorWrapper;
this.wrapperWidget=new Ewc({value:this.value,buttonSave:this.buttonSave,buttonCancel:this.buttonCancel,dir:this.dir,lang:this.lang,tabIndex:this._savedTabIndex,editor:this.editor,inlineEditBox:this,sourceStyle:_322.getComputedStyle(this.displayNode),save:lang.hitch(this,"save"),cancel:lang.hitch(this,"cancel"),textDir:this.textDir},_339);
if(!this.wrapperWidget._started){
this.wrapperWidget.startup();
}
if(!this._started){
this.startup();
}
}
var ww=this.wrapperWidget;
_320.add(this.displayNode,"dijitOffScreen");
_320.remove(ww.domNode,"dijitOffScreen");
_322.set(ww.domNode,{visibility:"visible"});
_31f.set(this.displayNode,"tabIndex","-1");
when(ww.editWidget.onLoadDeferred,lang.hitch(ww,function(){
this.defer(function(){
this.focus();
this._resetValue=this.getValue();
});
}));
},_onBlur:function(){
this.inherited(arguments);
if(!this.editing){
}
},destroy:function(){
if(this.wrapperWidget&&!this.wrapperWidget._destroyed){
this.wrapperWidget.destroy();
delete this.wrapperWidget;
}
this.inherited(arguments);
},_showText:function(_33a){
var ww=this.wrapperWidget;
_322.set(ww.domNode,{visibility:"hidden"});
_320.add(ww.domNode,"dijitOffScreen");
_320.remove(this.displayNode,"dijitOffScreen");
_31f.set(this.displayNode,"tabIndex",this._savedTabIndex);
if(_33a){
fm.focus(this.displayNode);
}
},save:function(_33b){
if(this.disabled||!this.editing){
return;
}
this._set("editing",false);
var ww=this.wrapperWidget;
var _33c=ww.getValue();
this.set("value",_33c);
this._showText(_33b);
},setValue:function(val){
_324.deprecated("dijit.InlineEditBox.setValue() is deprecated.  Use set('value', ...) instead.","","2.0");
return this.set("value",val);
},_setValueAttr:function(val){
val=lang.trim(val);
var _33d=this.renderAsHtml?val:val.replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;").replace(/\n/g,"<br>");
this.displayNode.innerHTML=_33d||this.noValueIndicator;
this._set("value",val);
if(this._started){
this.defer(function(){
this.onChange(val);
});
}
if(this.textDir=="auto"){
this.applyTextDir(this.displayNode,this.displayNode.innerText);
}
},getValue:function(){
_324.deprecated("dijit.InlineEditBox.getValue() is deprecated.  Use get('value') instead.","","2.0");
return this.get("value");
},cancel:function(_33e){
if(this.disabled||!this.editing){
return;
}
this._set("editing",false);
this.defer("onCancel");
this._showText(_33e);
},_setTextDirAttr:function(_33f){
if(!this._created||this.textDir!=_33f){
this._set("textDir",_33f);
this.applyTextDir(this.displayNode,this.displayNode.innerText);
this.displayNode.align=this.dir=="rtl"?"right":"left";
}
}});
_335._InlineEditor=_32d;
return _335;
});
},"dojo/dnd/autoscroll":function(){
define(["../_base/lang","../sniff","../_base/window","../dom-geometry","../dom-style","../window"],function(lang,has,win,_340,_341,_342){
var _343={};
lang.setObject("dojo.dnd.autoscroll",_343);
_343.getViewport=_342.getBox;
_343.V_TRIGGER_AUTOSCROLL=32;
_343.H_TRIGGER_AUTOSCROLL=32;
_343.V_AUTOSCROLL_VALUE=16;
_343.H_AUTOSCROLL_VALUE=16;
var _344,doc=win.doc,_345=Infinity,_346=Infinity;
_343.autoScrollStart=function(d){
doc=d;
_344=_342.getBox(doc);
var html=win.body(doc).parentNode;
_345=Math.max(html.scrollHeight-_344.h,0);
_346=Math.max(html.scrollWidth-_344.w,0);
};
_343.autoScroll=function(e){
var v=_344||_342.getBox(doc),html=win.body(doc).parentNode,dx=0,dy=0;
if(e.clientX<_343.H_TRIGGER_AUTOSCROLL){
dx=-_343.H_AUTOSCROLL_VALUE;
}else{
if(e.clientX>v.w-_343.H_TRIGGER_AUTOSCROLL){
dx=Math.min(_343.H_AUTOSCROLL_VALUE,_346-html.scrollLeft);
}
}
if(e.clientY<_343.V_TRIGGER_AUTOSCROLL){
dy=-_343.V_AUTOSCROLL_VALUE;
}else{
if(e.clientY>v.h-_343.V_TRIGGER_AUTOSCROLL){
dy=Math.min(_343.V_AUTOSCROLL_VALUE,_345-html.scrollTop);
}
}
window.scrollBy(dx,dy);
};
_343._validNodes={"div":1,"p":1,"td":1};
_343._validOverflow={"auto":1,"scroll":1};
_343.autoScrollNodes=function(e){
var b,t,w,h,rx,ry,dx=0,dy=0,_347,_348;
for(var n=e.target;n;){
if(n.nodeType==1&&(n.tagName.toLowerCase() in _343._validNodes)){
var s=_341.getComputedStyle(n),_349=(s.overflow.toLowerCase() in _343._validOverflow),_34a=(s.overflowX.toLowerCase() in _343._validOverflow),_34b=(s.overflowY.toLowerCase() in _343._validOverflow);
if(_349||_34a||_34b){
b=_340.getContentBox(n,s);
t=_340.position(n,true);
}
if(_349||_34a){
w=Math.min(_343.H_TRIGGER_AUTOSCROLL,b.w/2);
rx=e.pageX-t.x;
if(has("webkit")||has("opera")){
rx+=win.body().scrollLeft;
}
dx=0;
if(rx>0&&rx<b.w){
if(rx<w){
dx=-w;
}else{
if(rx>b.w-w){
dx=w;
}
}
_347=n.scrollLeft;
n.scrollLeft=n.scrollLeft+dx;
}
}
if(_349||_34b){
h=Math.min(_343.V_TRIGGER_AUTOSCROLL,b.h/2);
ry=e.pageY-t.y;
if(has("webkit")||has("opera")){
ry+=win.body().scrollTop;
}
dy=0;
if(ry>0&&ry<b.h){
if(ry<h){
dy=-h;
}else{
if(ry>b.h-h){
dy=h;
}
}
_348=n.scrollTop;
n.scrollTop=n.scrollTop+dy;
}
}
if(dx||dy){
return;
}
}
try{
n=n.parentNode;
}
catch(x){
n=null;
}
}
_343.autoScroll(e);
};
return _343;
});
},"dijit/form/_RadioButtonMixin":function(){
define(["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/_base/event","dojo/_base/lang","dojo/query","../registry"],function(_34c,_34d,_34e,_34f,lang,_350,_351){
return _34d("dijit.form._RadioButtonMixin",null,{type:"radio",_getRelatedWidgets:function(){
var ary=[];
_350("input[type=radio]",this.focusNode.form||this.ownerDocument).forEach(lang.hitch(this,function(_352){
if(_352.name==this.name&&_352.form==this.focusNode.form){
var _353=_351.getEnclosingWidget(_352);
if(_353){
ary.push(_353);
}
}
}));
return ary;
},_setCheckedAttr:function(_354){
this.inherited(arguments);
if(!this._created){
return;
}
if(_354){
_34c.forEach(this._getRelatedWidgets(),lang.hitch(this,function(_355){
if(_355!=this&&_355.checked){
_355.set("checked",false);
}
}));
}
},_getSubmitValue:function(_356){
return _356===null?"on":_356;
},_onClick:function(e){
if(this.checked||this.disabled){
_34f.stop(e);
return false;
}
if(this.readOnly){
_34f.stop(e);
_34c.forEach(this._getRelatedWidgets(),lang.hitch(this,function(_357){
_34e.set(this.focusNode||this.domNode,"checked",_357.checked);
}));
return false;
}
return this.inherited(arguments);
}});
});
},"url:dijit/templates/TreeNode.html":"<div class=\"dijitTreeNode\" role=\"presentation\"\n\t><div data-dojo-attach-point=\"rowNode\" class=\"dijitTreeRow dijitInline\" role=\"presentation\"\n\t\t><div data-dojo-attach-point=\"indentNode\" class=\"dijitInline\"></div\n\t\t><img src=\"${_blankGif}\" alt=\"\" data-dojo-attach-point=\"expandoNode\" class=\"dijitTreeExpando\" role=\"presentation\"\n\t\t/><span data-dojo-attach-point=\"expandoNodeText\" class=\"dijitExpandoText\" role=\"presentation\"\n\t\t></span\n\t\t><span data-dojo-attach-point=\"contentNode\"\n\t\t\tclass=\"dijitTreeContent\" role=\"presentation\">\n\t\t\t<img src=\"${_blankGif}\" alt=\"\" data-dojo-attach-point=\"iconNode\" class=\"dijitIcon dijitTreeIcon\" role=\"presentation\"\n\t\t\t/><span data-dojo-attach-point=\"labelNode\" class=\"dijitTreeLabel\" role=\"treeitem\" tabindex=\"-1\" aria-selected=\"false\"></span>\n\t\t</span\n\t></div>\n\t<div data-dojo-attach-point=\"containerNode\" class=\"dijitTreeContainer\" role=\"presentation\" style=\"display: none;\"></div>\n</div>\n","dojo/dnd/TimedMoveable":function(){
define(["../_base/declare","./Moveable"],function(_358,_359){
var _35a=_359.prototype.onMove;
return _358("dojo.dnd.TimedMoveable",_359,{timeout:40,constructor:function(node,_35b){
if(!_35b){
_35b={};
}
if(_35b.timeout&&typeof _35b.timeout=="number"&&_35b.timeout>=0){
this.timeout=_35b.timeout;
}
},onMoveStop:function(_35c){
if(_35c._timer){
clearTimeout(_35c._timer);
_35a.call(this,_35c,_35c._leftTop);
}
_359.prototype.onMoveStop.apply(this,arguments);
},onMove:function(_35d,_35e){
_35d._leftTop=_35e;
if(!_35d._timer){
var _35f=this;
_35d._timer=setTimeout(function(){
_35d._timer=null;
_35a.call(_35f,_35d,_35d._leftTop);
},this.timeout);
}
}});
});
},"dijit/layout/LinkPane":function(){
define(["./ContentPane","../_TemplatedMixin","dojo/_base/declare"],function(_360,_361,_362){
return _362("dijit.layout.LinkPane",[_360,_361],{templateString:"<div class=\"dijitLinkPane\" data-dojo-attach-point=\"containerNode\"></div>",postMixInProperties:function(){
if(this.srcNodeRef){
this.title+=this.srcNodeRef.innerHTML;
}
this.inherited(arguments);
},_fillContent:function(){
}});
});
},"dijit/form/_ListMouseMixin":function(){
define(["dojo/_base/declare","dojo/mouse","dojo/on","dojo/touch","./_ListBase"],function(_363,_364,on,_365,_366){
return _363("dijit.form._ListMouseMixin",_366,{postCreate:function(){
this.inherited(arguments);
this.own(on(this.domNode,_365.press,function(evt){
evt.preventDefault();
}));
this._listConnect(_365.press,"_onMouseDown");
this._listConnect(_365.release,"_onMouseUp");
this._listConnect(_364.enter,"_onMouseOver");
this._listConnect(_364.leave,"_onMouseOut");
},_onMouseDown:function(evt,_367){
if(this._hoveredNode){
this.onUnhover(this._hoveredNode);
this._hoveredNode=null;
}
this._isDragging=true;
this._setSelectedAttr(_367);
},_onMouseUp:function(evt,_368){
this._isDragging=false;
var _369=this.selected;
var _36a=this._hoveredNode;
if(_369&&_368==_369){
this.onClick(_369);
}else{
if(_36a&&_368==_36a){
this._setSelectedAttr(_36a);
this.onClick(_36a);
}
}
},_onMouseOut:function(evt,_36b){
if(this._hoveredNode){
this.onUnhover(this._hoveredNode);
this._hoveredNode=null;
}
if(this._isDragging){
this._cancelDrag=(new Date()).getTime()+1000;
}
},_onMouseOver:function(evt,_36c){
if(this._cancelDrag){
var time=(new Date()).getTime();
if(time>this._cancelDrag){
this._isDragging=false;
}
this._cancelDrag=null;
}
this._hoveredNode=_36c;
this.onHover(_36c);
if(this._isDragging){
this._setSelectedAttr(_36c);
}
}});
});
},"url:dijit/templates/Tree.html":"<div class=\"dijitTree dijitTreeContainer\" role=\"tree\">\n\t<div class=\"dijitInline dijitTreeIndent\" style=\"position: absolute; top: -9999px\" data-dojo-attach-point=\"indentDetector\"></div>\n</div>\n","dojo/cldr/monetary":function(){
define(["../_base/kernel","../_base/lang"],function(dojo,lang){
var _36d={};
lang.setObject("dojo.cldr.monetary",_36d);
_36d.getData=function(code){
var _36e={ADP:0,AFN:0,ALL:0,AMD:0,BHD:3,BIF:0,BYR:0,CLF:0,CLP:0,COP:0,CRC:0,DJF:0,ESP:0,GNF:0,GYD:0,HUF:0,IDR:0,IQD:0,IRR:3,ISK:0,ITL:0,JOD:3,JPY:0,KMF:0,KPW:0,KRW:0,KWD:3,LAK:0,LBP:0,LUF:0,LYD:3,MGA:0,MGF:0,MMK:0,MNT:0,MRO:0,MUR:0,OMR:3,PKR:0,PYG:0,RSD:0,RWF:0,SLL:0,SOS:0,STD:0,SYP:0,TMM:0,TND:3,TRL:0,TZS:0,UGX:0,UZS:0,VND:0,VUV:0,XAF:0,XOF:0,XPF:0,YER:0,ZMK:0,ZWD:0};
var _36f={CHF:5};
var _370=_36e[code],_371=_36f[code];
if(typeof _370=="undefined"){
_370=2;
}
if(typeof _371=="undefined"){
_371=0;
}
return {places:_370,round:_371};
};
return _36d;
});
},"dojo/cookie":function(){
define(["./_base/kernel","./regexp"],function(dojo,_372){
dojo.cookie=function(name,_373,_374){
var c=document.cookie,ret;
if(arguments.length==1){
var _375=c.match(new RegExp("(?:^|; )"+_372.escapeString(name)+"=([^;]*)"));
ret=_375?decodeURIComponent(_375[1]):undefined;
}else{
_374=_374||{};
var exp=_374.expires;
if(typeof exp=="number"){
var d=new Date();
d.setTime(d.getTime()+exp*24*60*60*1000);
exp=_374.expires=d;
}
if(exp&&exp.toUTCString){
_374.expires=exp.toUTCString();
}
_373=encodeURIComponent(_373);
var _376=name+"="+_373,_377;
for(_377 in _374){
_376+="; "+_377;
var _378=_374[_377];
if(_378!==true){
_376+="="+_378;
}
}
document.cookie=_376;
}
return ret;
};
dojo.cookie.isSupported=function(){
if(!("cookieEnabled" in navigator)){
this("__djCookieTest__","CookiesAllowed");
navigator.cookieEnabled=this("__djCookieTest__")=="CookiesAllowed";
if(navigator.cookieEnabled){
this("__djCookieTest__","",{expires:-1});
}
}
return navigator.cookieEnabled;
};
return dojo.cookie;
});
},"url:dijit/form/templates/DropDownBox.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\"\n\tid=\"widget_${id}\"\n\trole=\"combobox\"\n\t><div class='dijitReset dijitRight dijitButtonNode dijitArrowButton dijitDownArrowButton dijitArrowButtonContainer'\n\t\tdata-dojo-attach-point=\"_buttonNode, _popupStateNode\" role=\"presentation\"\n\t\t><input class=\"dijitReset dijitInputField dijitArrowButtonInner\" value=\"&#9660; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"button presentation\" aria-hidden=\"true\"\n\t\t\t${_buttonInputDisabled}\n\t/></div\n\t><div class='dijitReset dijitValidationContainer'\n\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t/></div\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class='dijitReset dijitInputInner' ${!nameAttrSetting} type=\"text\" autocomplete=\"off\"\n\t\t\tdata-dojo-attach-point=\"textbox,focusNode\" role=\"textbox\" aria-haspopup=\"true\"\n\t/></div\n></div>\n","dijit/ProgressBar":function(){
define(["require","dojo/_base/declare","dojo/dom-class","dojo/_base/lang","dojo/number","./_Widget","./_TemplatedMixin","dojo/text!./templates/ProgressBar.html"],function(_379,_37a,_37b,lang,_37c,_37d,_37e,_37f){
return _37a("dijit.ProgressBar",[_37d,_37e],{progress:"0",value:"",maximum:100,places:0,indeterminate:false,label:"",name:"",templateString:_37f,_indeterminateHighContrastImagePath:_379.toUrl("./themes/a11y/indeterminate_progress.gif"),postMixInProperties:function(){
this.inherited(arguments);
if(!(this.params&&"value" in this.params)){
this.value=this.indeterminate?Infinity:this.progress;
}
},buildRendering:function(){
this.inherited(arguments);
this.indeterminateHighContrastImage.setAttribute("src",this._indeterminateHighContrastImagePath.toString());
this.update();
},update:function(_380){
lang.mixin(this,_380||{});
var tip=this.internalProgress,ap=this.domNode;
var _381=1;
if(this.indeterminate){
ap.removeAttribute("aria-valuenow");
}else{
if(String(this.progress).indexOf("%")!=-1){
_381=Math.min(parseFloat(this.progress)/100,1);
this.progress=_381*this.maximum;
}else{
this.progress=Math.min(this.progress,this.maximum);
_381=this.maximum?this.progress/this.maximum:0;
}
ap.setAttribute("aria-valuenow",this.progress);
}
ap.setAttribute("aria-describedby",this.labelNode.id);
ap.setAttribute("aria-valuemin",0);
ap.setAttribute("aria-valuemax",this.maximum);
this.labelNode.innerHTML=this.report(_381);
_37b.toggle(this.domNode,"dijitProgressBarIndeterminate",this.indeterminate);
tip.style.width=(_381*100)+"%";
this.onChange();
},_setValueAttr:function(v){
this._set("value",v);
if(v==Infinity){
this.update({indeterminate:true});
}else{
this.update({indeterminate:false,progress:v});
}
},_setLabelAttr:function(_382){
this._set("label",_382);
this.update();
},_setIndeterminateAttr:function(_383){
this.indeterminate=_383;
this.update();
},report:function(_384){
return this.label?this.label:(this.indeterminate?"&#160;":_37c.format(_384,{type:"percent",places:this.places,locale:this.lang}));
},onChange:function(){
}});
});
},"dijit/form/NumberTextBox":function(){
define(["dojo/_base/declare","dojo/_base/lang","dojo/number","./RangeBoundTextBox"],function(_385,lang,_386,_387){
var _388=_385("dijit.form.NumberTextBoxMixin",null,{pattern:_386.regexp,value:NaN,editOptions:{pattern:"#.######"},_formatter:_386.format,postMixInProperties:function(){
this.inherited(arguments);
this._set("type","text");
},_setConstraintsAttr:function(_389){
var _38a=typeof _389.places=="number"?_389.places:0;
if(_38a){
_38a++;
}
if(typeof _389.max!="number"){
_389.max=9*Math.pow(10,15-_38a);
}
if(typeof _389.min!="number"){
_389.min=-9*Math.pow(10,15-_38a);
}
this.inherited(arguments,[_389]);
if(this.focusNode&&this.focusNode.value&&!isNaN(this.value)){
this.set("value",this.value);
}
},_onFocus:function(){
if(this.disabled){
return;
}
var val=this.get("value");
if(typeof val=="number"&&!isNaN(val)){
var _38b=this.format(val,this.constraints);
if(_38b!==undefined){
this.textbox.value=_38b;
}
}
this.inherited(arguments);
},format:function(_38c,_38d){
var _38e=String(_38c);
if(typeof _38c!="number"){
return _38e;
}
if(isNaN(_38c)){
return "";
}
if(!("rangeCheck" in this&&this.rangeCheck(_38c,_38d))&&_38d.exponent!==false&&/\de[-+]?\d/i.test(_38e)){
return _38e;
}
if(this.editOptions&&this.focused){
_38d=lang.mixin({},_38d,this.editOptions);
}
return this._formatter(_38c,_38d);
},_parser:_386.parse,parse:function(_38f,_390){
var v=this._parser(_38f,lang.mixin({},_390,(this.editOptions&&this.focused)?this.editOptions:{}));
if(this.editOptions&&this.focused&&isNaN(v)){
v=this._parser(_38f,_390);
}
return v;
},_getDisplayedValueAttr:function(){
var v=this.inherited(arguments);
return isNaN(v)?this.textbox.value:v;
},filter:function(_391){
return (_391==null||_391==="")?NaN:this.inherited(arguments);
},serialize:function(_392,_393){
return (typeof _392!="number"||isNaN(_392))?"":this.inherited(arguments);
},_setBlurValue:function(){
var val=lang.hitch(lang.mixin({},this,{focused:true}),"get")("value");
this._setValueAttr(val,true);
},_setValueAttr:function(_394,_395,_396){
if(_394!==undefined&&_396===undefined){
_396=String(_394);
if(typeof _394=="number"){
if(isNaN(_394)){
_396="";
}else{
if(("rangeCheck" in this&&this.rangeCheck(_394,this.constraints))||this.constraints.exponent===false||!/\de[-+]?\d/i.test(_396)){
_396=undefined;
}
}
}else{
if(!_394){
_396="";
_394=NaN;
}else{
_394=undefined;
}
}
}
this.inherited(arguments,[_394,_395,_396]);
},_getValueAttr:function(){
var v=this.inherited(arguments);
if(isNaN(v)&&this.textbox.value!==""){
if(this.constraints.exponent!==false&&/\de[-+]?\d/i.test(this.textbox.value)&&(new RegExp("^"+_386._realNumberRegexp(lang.mixin({},this.constraints))+"$").test(this.textbox.value))){
var n=Number(this.textbox.value);
return isNaN(n)?undefined:n;
}else{
return undefined;
}
}else{
return v;
}
},isValid:function(_397){
if(!this.focused||this._isEmpty(this.textbox.value)){
return this.inherited(arguments);
}else{
var v=this.get("value");
if(!isNaN(v)&&this.rangeCheck(v,this.constraints)){
if(this.constraints.exponent!==false&&/\de[-+]?\d/i.test(this.textbox.value)){
return true;
}else{
return this.inherited(arguments);
}
}else{
return false;
}
}
}});
var _398=_385("dijit.form.NumberTextBox",[_387,_388],{baseClass:"dijitTextBox dijitNumberTextBox"});
_398.Mixin=_388;
return _398;
});
},"dijit/form/TimeTextBox":function(){
define("dijit/form/TimeTextBox",["dojo/_base/declare","dojo/keys","dojo/_base/lang","../_TimePicker","./_DateTimeTextBox"],function(_399,keys,lang,_39a,_39b){
return _399("dijit.form.TimeTextBox",_39b,{baseClass:"dijitTextBox dijitComboBox dijitTimeTextBox",popupClass:_39a,_selector:"time",value:new Date(""),_onKey:function(evt){
if(this.disabled||this.readOnly){
return;
}
this.inherited(arguments);
switch(evt.keyCode){
case keys.ENTER:
case keys.TAB:
case keys.ESCAPE:
case keys.DOWN_ARROW:
case keys.UP_ARROW:
break;
default:
this.defer(function(){
var val=this.get("displayedValue");
this.filterString=(val&&!this.parse(val,this.constraints))?val.toLowerCase():"";
if(this._opened){
this.closeDropDown();
}
this.openDropDown();
});
}
}});
});
},"dijit/ColorPalette":function(){
define(["require","dojo/text!./templates/ColorPalette.html","./_Widget","./_TemplatedMixin","./_PaletteMixin","./hccss","dojo/i18n","dojo/_base/Color","dojo/_base/declare","dojo/dom-construct","dojo/string","dojo/i18n!dojo/nls/colors","dojo/colors"],function(_39c,_39d,_39e,_39f,_3a0,has,i18n,_3a1,_3a2,_3a3,_3a4){
var _3a5=_3a2("dijit.ColorPalette",[_39e,_39f,_3a0],{palette:"7x10",_palettes:{"7x10":[["white","seashell","cornsilk","lemonchiffon","lightyellow","palegreen","paleturquoise","lightcyan","lavender","plum"],["lightgray","pink","bisque","moccasin","khaki","lightgreen","lightseagreen","lightskyblue","cornflowerblue","violet"],["silver","lightcoral","sandybrown","orange","palegoldenrod","chartreuse","mediumturquoise","skyblue","mediumslateblue","orchid"],["gray","red","orangered","darkorange","yellow","limegreen","darkseagreen","royalblue","slateblue","mediumorchid"],["dimgray","crimson","chocolate","coral","gold","forestgreen","seagreen","blue","blueviolet","darkorchid"],["darkslategray","firebrick","saddlebrown","sienna","olive","green","darkcyan","mediumblue","darkslateblue","darkmagenta"],["black","darkred","maroon","brown","darkolivegreen","darkgreen","midnightblue","navy","indigo","purple"]],"3x4":[["white","lime","green","blue"],["silver","yellow","fuchsia","navy"],["gray","red","purple","black"]]},templateString:_39d,baseClass:"dijitColorPalette",_dyeFactory:function(_3a6,row,col,_3a7){
return new this._dyeClass(_3a6,row,col,_3a7);
},buildRendering:function(){
this.inherited(arguments);
this._dyeClass=_3a2(_3a5._Color,{palette:this.palette});
this._preparePalette(this._palettes[this.palette],i18n.getLocalization("dojo","colors",this.lang));
}});
_3a5._Color=_3a2("dijit._Color",_3a1,{template:"<span class='dijitInline dijitPaletteImg'>"+"<img src='${blankGif}' alt='${alt}' title='${title}' class='dijitColorPaletteSwatch' style='background-color: ${color}'/>"+"</span>",hcTemplate:"<span class='dijitInline dijitPaletteImg' style='position: relative; overflow: hidden; height: 12px; width: 14px;'>"+"<img src='${image}' alt='${alt}' title='${title}' style='position: absolute; left: ${left}px; top: ${top}px; ${size}'/>"+"</span>",_imagePaths:{"7x10":_39c.toUrl("./themes/a11y/colors7x10.png"),"3x4":_39c.toUrl("./themes/a11y/colors3x4.png")},constructor:function(_3a8,row,col,_3a9){
this._title=_3a9;
this._row=row;
this._col=col;
this.setColor(_3a1.named[_3a8]);
},getValue:function(){
return this.toHex();
},fillCell:function(cell,_3aa){
var html=_3a4.substitute(has("highcontrast")?this.hcTemplate:this.template,{color:this.toHex(),blankGif:_3aa,alt:this._title,title:this._title,image:this._imagePaths[this.palette].toString(),left:this._col*-20-5,top:this._row*-20-5,size:this.palette=="7x10"?"height: 145px; width: 206px":"height: 64px; width: 86px"});
_3a3.place(html,cell);
}});
return _3a5;
});
},"url:dijit/form/templates/Button.html":"<span class=\"dijit dijitReset dijitInline\" role=\"presentation\"\n\t><span class=\"dijitReset dijitInline dijitButtonNode\"\n\t\tdata-dojo-attach-event=\"ondijitclick:_onClick\" role=\"presentation\"\n\t\t><span class=\"dijitReset dijitStretch dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"titleNode,focusNode\"\n\t\t\trole=\"button\" aria-labelledby=\"${id}_label\"\n\t\t\t><span class=\"dijitReset dijitInline dijitIcon\" data-dojo-attach-point=\"iconNode\"></span\n\t\t\t><span class=\"dijitReset dijitToggleButtonIconChar\">&#x25CF;</span\n\t\t\t><span class=\"dijitReset dijitInline dijitButtonText\"\n\t\t\t\tid=\"${id}_label\"\n\t\t\t\tdata-dojo-attach-point=\"containerNode\"\n\t\t\t></span\n\t\t></span\n\t></span\n\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" class=\"dijitOffScreen\"\n\t\ttabIndex=\"-1\" role=\"presentation\" data-dojo-attach-point=\"valueNode\"\n/></span>\n","dijit/form/CurrencyTextBox":function(){
define(["dojo/currency","dojo/_base/declare","dojo/_base/lang","./NumberTextBox"],function(_3ab,_3ac,lang,_3ad){
return _3ac("dijit.form.CurrencyTextBox",_3ad,{currency:"",baseClass:"dijitTextBox dijitCurrencyTextBox",pattern:function(_3ae){
return "("+(this.focused?this.inherited(arguments,[lang.mixin({},_3ae,this.editOptions)])+"|":"")+_3ab.regexp(_3ae)+")";
},_formatter:_3ab.format,_parser:_3ab.parse,parse:function(_3af,_3b0){
var v=this.inherited(arguments);
if(isNaN(v)&&/\d+/.test(_3af)){
v=lang.hitch(lang.mixin({},this,{_parser:_3ad.prototype._parser}),"inherited")(arguments);
}
return v;
},_setConstraintsAttr:function(_3b1){
if(!_3b1.currency&&this.currency){
_3b1.currency=this.currency;
}
this.inherited(arguments,[_3ab._mixInDefaults(lang.mixin(_3b1,{exponent:false}))]);
}});
});
},"url:dijit/templates/MenuItem.html":"<tr class=\"dijitReset dijitMenuItem\" data-dojo-attach-point=\"focusNode\" role=\"menuitem\" tabIndex=\"-1\">\n\t<td class=\"dijitReset dijitMenuItemIconCell\" role=\"presentation\">\n\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitIcon dijitMenuItemIcon\" data-dojo-attach-point=\"iconNode\"/>\n\t</td>\n\t<td class=\"dijitReset dijitMenuItemLabel\" colspan=\"2\" data-dojo-attach-point=\"containerNode\"></td>\n\t<td class=\"dijitReset dijitMenuItemAccelKey\" style=\"display: none\" data-dojo-attach-point=\"accelKeyNode\"></td>\n\t<td class=\"dijitReset dijitMenuArrowCell\" role=\"presentation\">\n\t\t<div data-dojo-attach-point=\"arrowWrapper\" style=\"visibility: hidden\">\n\t\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitMenuExpand\"/>\n\t\t\t<span class=\"dijitMenuExpandA11y\">+</span>\n\t\t</div>\n\t</td>\n</tr>\n","url:dijit/form/templates/CheckBox.html":"<div class=\"dijit dijitReset dijitInline\" role=\"presentation\"\n\t><input\n\t \t${!nameAttrSetting} type=\"${type}\" role=\"${type}\" aria-checked=\"false\" ${checkedAttrSetting}\n\t\tclass=\"dijitReset dijitCheckBoxInput\"\n\t\tdata-dojo-attach-point=\"focusNode\"\n\t \tdata-dojo-attach-event=\"onclick:_onClick\"\n/></div>\n","url:dijit/form/templates/VerticalSlider.html":"<table class=\"dijit dijitReset dijitSlider dijitSliderV\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" rules=\"none\" data-dojo-attach-event=\"onkeypress:_onKeyPress,onkeyup:_onKeyUp\"\n\trole=\"presentation\"\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\"></td\n\t\t><td class=\"dijitReset dijitSliderButtonContainer dijitSliderButtonContainerV\"\n\t\t\t><div class=\"dijitSliderIncrementIconV\" style=\"display:none\" data-dojo-attach-point=\"decrementButton\"><span class=\"dijitSliderButtonInner\">+</span></div\n\t\t></td\n\t\t><td class=\"dijitReset\"></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\"></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><center><div class=\"dijitSliderBar dijitSliderBumper dijitSliderBumperV dijitSliderTopBumper\" data-dojo-attach-event=\"press:_onClkIncBumper\"></div></center\n\t\t></td\n\t\t><td class=\"dijitReset\"></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td data-dojo-attach-point=\"leftDecoration\" class=\"dijitReset dijitInline dijitSliderDecoration dijitSliderDecorationL dijitSliderDecorationV\"></td\n\t\t><td class=\"dijitReset dijitSliderDecorationC\" style=\"height:100%;\"\n\t\t\t><input data-dojo-attach-point=\"valueNode\" type=\"hidden\" ${!nameAttrSetting}\n\t\t\t/><center class=\"dijitReset dijitSliderBarContainerV\" role=\"presentation\" data-dojo-attach-point=\"sliderBarContainer\"\n\t\t\t\t><div role=\"presentation\" data-dojo-attach-point=\"remainingBar\" class=\"dijitSliderBar dijitSliderBarV dijitSliderRemainingBar dijitSliderRemainingBarV\" data-dojo-attach-event=\"press:_onBarClick\"><!--#5629--></div\n\t\t\t\t><div role=\"presentation\" data-dojo-attach-point=\"progressBar\" class=\"dijitSliderBar dijitSliderBarV dijitSliderProgressBar dijitSliderProgressBarV\" data-dojo-attach-event=\"press:_onBarClick\"\n\t\t\t\t\t><div class=\"dijitSliderMoveable dijitSliderMoveableV\" style=\"vertical-align:top;\"\n\t\t\t\t\t\t><div data-dojo-attach-point=\"sliderHandle,focusNode\" class=\"dijitSliderImageHandle dijitSliderImageHandleV\" data-dojo-attach-event=\"press:_onHandleClick\" role=\"slider\"></div\n\t\t\t\t\t></div\n\t\t\t\t></div\n\t\t\t></center\n\t\t></td\n\t\t><td data-dojo-attach-point=\"containerNode,rightDecoration\" class=\"dijitReset dijitInline dijitSliderDecoration dijitSliderDecorationR dijitSliderDecorationV\"></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\"></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><center><div class=\"dijitSliderBar dijitSliderBumper dijitSliderBumperV dijitSliderBottomBumper\" data-dojo-attach-event=\"press:_onClkDecBumper\"></div></center\n\t\t></td\n\t\t><td class=\"dijitReset\"></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\"></td\n\t\t><td class=\"dijitReset dijitSliderButtonContainer dijitSliderButtonContainerV\"\n\t\t\t><div class=\"dijitSliderDecrementIconV\" style=\"display:none\" data-dojo-attach-point=\"incrementButton\"><span class=\"dijitSliderButtonInner\">-</span></div\n\t\t></td\n\t\t><td class=\"dijitReset\"></td\n\t></tr\n></table>\n","dijit/layout/LayoutContainer":function(){
define(["dojo/_base/kernel","dojo/_base/lang","dojo/_base/declare","../_WidgetBase","./_LayoutWidget","./utils"],function(_3b2,lang,_3b3,_3b4,_3b5,_3b6){
var _3b7=_3b3("dijit.layout.LayoutContainer",_3b5,{baseClass:"dijitLayoutContainer",constructor:function(){
_3b2.deprecated("dijit.layout.LayoutContainer is deprecated","use BorderContainer instead",2);
},layout:function(){
_3b6.layoutChildren(this.domNode,this._contentBox,this.getChildren());
},addChild:function(_3b8,_3b9){
this.inherited(arguments);
if(this._started){
_3b6.layoutChildren(this.domNode,this._contentBox,this.getChildren());
}
},removeChild:function(_3ba){
this.inherited(arguments);
if(this._started){
_3b6.layoutChildren(this.domNode,this._contentBox,this.getChildren());
}
}});
_3b7.ChildWidgetProperties={layoutAlign:"none"};
lang.extend(_3b4,_3b7.ChildWidgetProperties);
return _3b7;
});
},"dijit/Tooltip":function(){
define(["dojo/_base/array","dojo/_base/declare","dojo/_base/fx","dojo/dom","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang","dojo/mouse","dojo/on","dojo/sniff","./_base/manager","./place","./_Widget","./_TemplatedMixin","./BackgroundIframe","dojo/text!./templates/Tooltip.html","./main"],function(_3bb,_3bc,fx,dom,_3bd,_3be,_3bf,lang,_3c0,on,has,_3c1,_3c2,_3c3,_3c4,_3c5,_3c6,_3c7){
var _3c8=_3bc("dijit._MasterTooltip",[_3c3,_3c4],{duration:_3c1.defaultDuration,templateString:_3c6,postCreate:function(){
this.ownerDocumentBody.appendChild(this.domNode);
this.bgIframe=new _3c5(this.domNode);
this.fadeIn=fx.fadeIn({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onShow")});
this.fadeOut=fx.fadeOut({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onHide")});
},show:function(_3c9,_3ca,_3cb,rtl,_3cc){
if(this.aroundNode&&this.aroundNode===_3ca&&this.containerNode.innerHTML==_3c9){
return;
}
if(this.fadeOut.status()=="playing"){
this._onDeck=arguments;
return;
}
this.containerNode.innerHTML=_3c9;
if(_3cc){
this.set("textDir",_3cc);
}
this.containerNode.align=rtl?"right":"left";
var pos=_3c2.around(this.domNode,_3ca,_3cb&&_3cb.length?_3cb:_3cd.defaultPosition,!rtl,lang.hitch(this,"orient"));
var _3ce=pos.aroundNodePos;
if(pos.corner.charAt(0)=="M"&&pos.aroundCorner.charAt(0)=="M"){
this.connectorNode.style.top=_3ce.y+((_3ce.h-this.connectorNode.offsetHeight)>>1)-pos.y+"px";
this.connectorNode.style.left="";
}else{
if(pos.corner.charAt(1)=="M"&&pos.aroundCorner.charAt(1)=="M"){
this.connectorNode.style.left=_3ce.x+((_3ce.w-this.connectorNode.offsetWidth)>>1)-pos.x+"px";
}else{
this.connectorNode.style.left="";
this.connectorNode.style.top="";
}
}
_3bf.set(this.domNode,"opacity",0);
this.fadeIn.play();
this.isShowingNow=true;
this.aroundNode=_3ca;
},orient:function(node,_3cf,_3d0,_3d1,_3d2){
this.connectorNode.style.top="";
var _3d3=_3d1.h,_3d4=_3d1.w;
node.className="dijitTooltip "+{"MR-ML":"dijitTooltipRight","ML-MR":"dijitTooltipLeft","TM-BM":"dijitTooltipAbove","BM-TM":"dijitTooltipBelow","BL-TL":"dijitTooltipBelow dijitTooltipABLeft","TL-BL":"dijitTooltipAbove dijitTooltipABLeft","BR-TR":"dijitTooltipBelow dijitTooltipABRight","TR-BR":"dijitTooltipAbove dijitTooltipABRight","BR-BL":"dijitTooltipRight","BL-BR":"dijitTooltipLeft"}[_3cf+"-"+_3d0];
this.domNode.style.width="auto";
var size=_3be.position(this.domNode);
if(has("ie")==9){
size.w+=2;
}
var _3d5=Math.min((Math.max(_3d4,1)),size.w);
_3be.setMarginBox(this.domNode,{w:_3d5});
if(_3d0.charAt(0)=="B"&&_3cf.charAt(0)=="B"){
var bb=_3be.position(node);
var _3d6=this.connectorNode.offsetHeight;
if(bb.h>_3d3){
var _3d7=_3d3-((_3d2.h+_3d6)>>1);
this.connectorNode.style.top=_3d7+"px";
this.connectorNode.style.bottom="";
}else{
this.connectorNode.style.bottom=Math.min(Math.max(_3d2.h/2-_3d6/2,0),bb.h-_3d6)+"px";
this.connectorNode.style.top="";
}
}else{
this.connectorNode.style.top="";
this.connectorNode.style.bottom="";
}
return Math.max(0,size.w-_3d4);
},_onShow:function(){
if(has("ie")){
this.domNode.style.filter="";
}
},hide:function(_3d8){
if(this._onDeck&&this._onDeck[1]==_3d8){
this._onDeck=null;
}else{
if(this.aroundNode===_3d8){
this.fadeIn.stop();
this.isShowingNow=false;
this.aroundNode=null;
this.fadeOut.play();
}else{
}
}
},_onHide:function(){
this.domNode.style.cssText="";
this.containerNode.innerHTML="";
if(this._onDeck){
this.show.apply(this,this._onDeck);
this._onDeck=null;
}
},_setAutoTextDir:function(node){
this.applyTextDir(node,has("ie")?node.outerText:node.textContent);
_3bb.forEach(node.children,function(_3d9){
this._setAutoTextDir(_3d9);
},this);
},_setTextDirAttr:function(_3da){
this._set("textDir",_3da);
if(_3da=="auto"){
this._setAutoTextDir(this.containerNode);
}else{
this.containerNode.dir=this.textDir;
}
}});
_3c7.showTooltip=function(_3db,_3dc,_3dd,rtl,_3de){
if(_3dd){
_3dd=_3bb.map(_3dd,function(val){
return {after:"after-centered",before:"before-centered"}[val]||val;
});
}
if(!_3cd._masterTT){
_3c7._masterTT=_3cd._masterTT=new _3c8();
}
return _3cd._masterTT.show(_3db,_3dc,_3dd,rtl,_3de);
};
_3c7.hideTooltip=function(_3df){
return _3cd._masterTT&&_3cd._masterTT.hide(_3df);
};
var _3cd=_3bc("dijit.Tooltip",_3c3,{label:"",showDelay:400,connectId:[],position:[],selector:"",_setConnectIdAttr:function(_3e0){
_3bb.forEach(this._connections||[],function(_3e1){
_3bb.forEach(_3e1,function(_3e2){
_3e2.remove();
});
},this);
this._connectIds=_3bb.filter(lang.isArrayLike(_3e0)?_3e0:(_3e0?[_3e0]:[]),function(id){
return dom.byId(id,this.ownerDocument);
},this);
this._connections=_3bb.map(this._connectIds,function(id){
var node=dom.byId(id,this.ownerDocument),_3e3=this.selector,_3e4=_3e3?function(_3e5){
return on.selector(_3e3,_3e5);
}:function(_3e6){
return _3e6;
},self=this;
return [on(node,_3e4(_3c0.enter),function(){
self._onHover(this);
}),on(node,_3e4("focusin"),function(){
self._onHover(this);
}),on(node,_3e4(_3c0.leave),lang.hitch(self,"_onUnHover")),on(node,_3e4("focusout"),lang.hitch(self,"_onUnHover"))];
},this);
this._set("connectId",_3e0);
},addTarget:function(node){
var id=node.id||node;
if(_3bb.indexOf(this._connectIds,id)==-1){
this.set("connectId",this._connectIds.concat(id));
}
},removeTarget:function(node){
var id=node.id||node,idx=_3bb.indexOf(this._connectIds,id);
if(idx>=0){
this._connectIds.splice(idx,1);
this.set("connectId",this._connectIds);
}
},buildRendering:function(){
this.inherited(arguments);
_3bd.add(this.domNode,"dijitTooltipData");
},startup:function(){
this.inherited(arguments);
var ids=this.connectId;
_3bb.forEach(lang.isArrayLike(ids)?ids:[ids],this.addTarget,this);
},getContent:function(node){
return this.label||this.domNode.innerHTML;
},_onHover:function(_3e7){
if(!this._showTimer){
this._showTimer=this.defer(function(){
this.open(_3e7);
},this.showDelay);
}
},_onUnHover:function(){
if(this._showTimer){
this._showTimer.remove();
delete this._showTimer;
}
this.close();
},open:function(_3e8){
if(this._showTimer){
this._showTimer.remove();
delete this._showTimer;
}
var _3e9=this.getContent(_3e8);
if(!_3e9){
return;
}
_3cd.show(_3e9,_3e8,this.position,!this.isLeftToRight(),this.textDir);
this._connectNode=_3e8;
this.onShow(_3e8,this.position);
},close:function(){
if(this._connectNode){
_3cd.hide(this._connectNode);
delete this._connectNode;
this.onHide();
}
if(this._showTimer){
this._showTimer.remove();
delete this._showTimer;
}
},onShow:function(){
},onHide:function(){
},destroy:function(){
this.close();
_3bb.forEach(this._connections||[],function(_3ea){
_3bb.forEach(_3ea,function(_3eb){
_3eb.remove();
});
},this);
this.inherited(arguments);
}});
_3cd._MasterTooltip=_3c8;
_3cd.show=_3c7.showTooltip;
_3cd.hide=_3c7.hideTooltip;
_3cd.defaultPosition=["after-centered","before-centered"];
return _3cd;
});
},"url:dijit/templates/MenuSeparator.html":"<tr class=\"dijitMenuSeparator\">\n\t<td class=\"dijitMenuSeparatorIconCell\">\n\t\t<div class=\"dijitMenuSeparatorTop\"></div>\n\t\t<div class=\"dijitMenuSeparatorBottom\"></div>\n\t</td>\n\t<td colspan=\"3\" class=\"dijitMenuSeparatorLabelCell\">\n\t\t<div class=\"dijitMenuSeparatorTop dijitMenuSeparatorLabel\"></div>\n\t\t<div class=\"dijitMenuSeparatorBottom\"></div>\n\t</td>\n</tr>","dijit/form/VerticalSlider":function(){
define(["dojo/_base/declare","./HorizontalSlider","dojo/text!./templates/VerticalSlider.html"],function(_3ec,_3ed,_3ee){
return _3ec("dijit.form.VerticalSlider",_3ed,{templateString:_3ee,_mousePixelCoord:"pageY",_pixelCount:"h",_startingPixelCoord:"y",_handleOffsetCoord:"top",_progressPixelSize:"height",_descending:true,_isReversed:function(){
return this._descending;
}});
});
},"dijit/form/DropDownButton":function(){
define(["dojo/_base/declare","dojo/_base/lang","dojo/query","../registry","../popup","./Button","../_Container","../_HasDropDown","dojo/text!./templates/DropDownButton.html"],function(_3ef,lang,_3f0,_3f1,_3f2,_3f3,_3f4,_3f5,_3f6){
return _3ef("dijit.form.DropDownButton",[_3f3,_3f4,_3f5],{baseClass:"dijitDropDownButton",templateString:_3f6,_fillContent:function(){
if(this.srcNodeRef){
var _3f7=_3f0("*",this.srcNodeRef);
this.inherited(arguments,[_3f7[0]]);
this.dropDownContainer=this.srcNodeRef;
}
},startup:function(){
if(this._started){
return;
}
if(!this.dropDown&&this.dropDownContainer){
var _3f8=_3f0("[widgetId]",this.dropDownContainer)[0];
this.dropDown=_3f1.byNode(_3f8);
delete this.dropDownContainer;
}
if(this.dropDown){
_3f2.hide(this.dropDown);
}
this.inherited(arguments);
},isLoaded:function(){
var _3f9=this.dropDown;
return (!!_3f9&&(!_3f9.href||_3f9.isLoaded));
},loadDropDown:function(_3fa){
var _3fb=this.dropDown;
var _3fc=_3fb.on("load",lang.hitch(this,function(){
_3fc.remove();
_3fa();
}));
_3fb.refresh();
},isFocusable:function(){
return this.inherited(arguments)&&!this._mouseDown;
}});
});
},"url:dijit/templates/ProgressBar.html":"<div class=\"dijitProgressBar dijitProgressBarEmpty\" role=\"progressbar\"\n\t><div  data-dojo-attach-point=\"internalProgress\" class=\"dijitProgressBarFull\"\n\t\t><div class=\"dijitProgressBarTile\" role=\"presentation\"></div\n\t\t><span style=\"visibility:hidden\">&#160;</span\n\t></div\n\t><div data-dojo-attach-point=\"labelNode\" class=\"dijitProgressBarLabel\" id=\"${id}_label\"></div\n\t><img data-dojo-attach-point=\"indeterminateHighContrastImage\" class=\"dijitProgressBarIndeterminateHighContrastImage\" alt=\"\"\n/></div>\n","dojo/date":function(){
define(["./has","./_base/lang"],function(has,lang){
var date={};
date.getDaysInMonth=function(_3fd){
var _3fe=_3fd.getMonth();
var days=[31,28,31,30,31,30,31,31,30,31,30,31];
if(_3fe==1&&date.isLeapYear(_3fd)){
return 29;
}
return days[_3fe];
};
date.isLeapYear=function(_3ff){
var year=_3ff.getFullYear();
return !(year%400)||(!(year%4)&&!!(year%100));
};
date.getTimezoneName=function(_400){
var str=_400.toString();
var tz="";
var _401;
var pos=str.indexOf("(");
if(pos>-1){
tz=str.substring(++pos,str.indexOf(")"));
}else{
var pat=/([A-Z\/]+) \d{4}$/;
if((_401=str.match(pat))){
tz=_401[1];
}else{
str=_400.toLocaleString();
pat=/ ([A-Z\/]+)$/;
if((_401=str.match(pat))){
tz=_401[1];
}
}
}
return (tz=="AM"||tz=="PM")?"":tz;
};
date.compare=function(_402,_403,_404){
_402=new Date(+_402);
_403=new Date(+(_403||new Date()));
if(_404=="date"){
_402.setHours(0,0,0,0);
_403.setHours(0,0,0,0);
}else{
if(_404=="time"){
_402.setFullYear(0,0,0);
_403.setFullYear(0,0,0);
}
}
if(_402>_403){
return 1;
}
if(_402<_403){
return -1;
}
return 0;
};
date.add=function(date,_405,_406){
var sum=new Date(+date);
var _407=false;
var _408="Date";
switch(_405){
case "day":
break;
case "weekday":
var days,_409;
var mod=_406%5;
if(!mod){
days=(_406>0)?5:-5;
_409=(_406>0)?((_406-5)/5):((_406+5)/5);
}else{
days=mod;
_409=parseInt(_406/5);
}
var strt=date.getDay();
var adj=0;
if(strt==6&&_406>0){
adj=1;
}else{
if(strt==0&&_406<0){
adj=-1;
}
}
var trgt=strt+days;
if(trgt==0||trgt==6){
adj=(_406>0)?2:-2;
}
_406=(7*_409)+days+adj;
break;
case "year":
_408="FullYear";
_407=true;
break;
case "week":
_406*=7;
break;
case "quarter":
_406*=3;
case "month":
_407=true;
_408="Month";
break;
default:
_408="UTC"+_405.charAt(0).toUpperCase()+_405.substring(1)+"s";
}
if(_408){
sum["set"+_408](sum["get"+_408]()+_406);
}
if(_407&&(sum.getDate()<date.getDate())){
sum.setDate(0);
}
return sum;
};
date.difference=function(_40a,_40b,_40c){
_40b=_40b||new Date();
_40c=_40c||"day";
var _40d=_40b.getFullYear()-_40a.getFullYear();
var _40e=1;
switch(_40c){
case "quarter":
var m1=_40a.getMonth();
var m2=_40b.getMonth();
var q1=Math.floor(m1/3)+1;
var q2=Math.floor(m2/3)+1;
q2+=(_40d*4);
_40e=q2-q1;
break;
case "weekday":
var days=Math.round(date.difference(_40a,_40b,"day"));
var _40f=parseInt(date.difference(_40a,_40b,"week"));
var mod=days%7;
if(mod==0){
days=_40f*5;
}else{
var adj=0;
var aDay=_40a.getDay();
var bDay=_40b.getDay();
_40f=parseInt(days/7);
mod=days%7;
var _410=new Date(_40a);
_410.setDate(_410.getDate()+(_40f*7));
var _411=_410.getDay();
if(days>0){
switch(true){
case aDay==6:
adj=-1;
break;
case aDay==0:
adj=0;
break;
case bDay==6:
adj=-1;
break;
case bDay==0:
adj=-2;
break;
case (_411+mod)>5:
adj=-2;
}
}else{
if(days<0){
switch(true){
case aDay==6:
adj=0;
break;
case aDay==0:
adj=1;
break;
case bDay==6:
adj=2;
break;
case bDay==0:
adj=1;
break;
case (_411+mod)<0:
adj=2;
}
}
}
days+=adj;
days-=(_40f*2);
}
_40e=days;
break;
case "year":
_40e=_40d;
break;
case "month":
_40e=(_40b.getMonth()-_40a.getMonth())+(_40d*12);
break;
case "week":
_40e=parseInt(date.difference(_40a,_40b,"day")/7);
break;
case "day":
_40e/=24;
case "hour":
_40e/=60;
case "minute":
_40e/=60;
case "second":
_40e/=1000;
case "millisecond":
_40e*=_40b.getTime()-_40a.getTime();
}
return Math.round(_40e);
};
1&&lang.mixin(lang.getObject("dojo.date",true),date);
return date;
});
},"dijit/layout/_ContentPaneResizeMixin":function(){
define(["dojo/_base/array","dojo/_base/declare","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang","dojo/query","dojo/sniff","../registry","../Viewport","./utils"],function(_412,_413,_414,_415,_416,lang,_417,has,_418,_419,_41a){
return _413("dijit.layout._ContentPaneResizeMixin",null,{doLayout:true,isLayoutContainer:true,startup:function(){
if(this._started){
return;
}
var _41b=this.getParent();
this._childOfLayoutWidget=_41b&&_41b.isLayoutContainer;
this._needLayout=!this._childOfLayoutWidget;
this.inherited(arguments);
if(this._isShown()){
this._onShow();
}
if(!this._childOfLayoutWidget){
this.own(_419.on("resize",lang.hitch(this,"resize")));
}
},_checkIfSingleChild:function(){
var _41c=[],_41d=false;
_417("> *",this.containerNode).some(function(node){
var _41e=_418.byNode(node);
if(_41e&&_41e.resize){
_41c.push(_41e);
}else{
if(node.offsetHeight){
_41d=true;
}
}
});
this._singleChild=_41c.length==1&&!_41d?_41c[0]:null;
_414.toggle(this.containerNode,this.baseClass+"SingleChild",!!this._singleChild);
},resize:function(_41f,_420){
this._resizeCalled=true;
this._scheduleLayout(_41f,_420);
},_scheduleLayout:function(_421,_422){
if(this._isShown()){
this._layout(_421,_422);
}else{
this._needLayout=true;
this._changeSize=_421;
this._resultSize=_422;
}
},_layout:function(_423,_424){
delete this._needLayout;
if(!this._wasShown&&this.open!==false){
this._onShow();
}
if(_423){
_415.setMarginBox(this.domNode,_423);
}
var cn=this.containerNode;
if(cn===this.domNode){
var mb=_424||{};
lang.mixin(mb,_423||{});
if(!("h" in mb)||!("w" in mb)){
mb=lang.mixin(_415.getMarginBox(cn),mb);
}
this._contentBox=_41a.marginBox2contentBox(cn,mb);
}else{
this._contentBox=_415.getContentBox(cn);
}
this._layoutChildren();
},_layoutChildren:function(){
if(this.doLayout){
this._checkIfSingleChild();
}
if(this._singleChild&&this._singleChild.resize){
var cb=this._contentBox||_415.getContentBox(this.containerNode);
this._singleChild.resize({w:cb.w,h:cb.h});
}else{
_412.forEach(this.getChildren(),function(_425){
if(_425.resize){
_425.resize();
}
});
}
},_isShown:function(){
if(this._childOfLayoutWidget){
if(this._resizeCalled&&"open" in this){
return this.open;
}
return this._resizeCalled;
}else{
if("open" in this){
return this.open;
}else{
var node=this.domNode,_426=this.domNode.parentNode;
return (node.style.display!="none")&&(node.style.visibility!="hidden")&&!_414.contains(node,"dijitHidden")&&_426&&_426.style&&(_426.style.display!="none");
}
}
},_onShow:function(){
this._wasShown=true;
if(this._needLayout){
this._layout(this._changeSize,this._resultSize);
}
this.inherited(arguments);
}});
});
},"dijit/form/RangeBoundTextBox":function(){
define(["dojo/_base/declare","dojo/i18n","./MappedTextBox"],function(_427,i18n,_428){
var _429=_427("dijit.form.RangeBoundTextBox",_428,{rangeMessage:"",rangeCheck:function(_42a,_42b){
return ("min" in _42b?(this.compare(_42a,_42b.min)>=0):true)&&("max" in _42b?(this.compare(_42a,_42b.max)<=0):true);
},isInRange:function(){
return this.rangeCheck(this.get("value"),this.constraints);
},_isDefinitelyOutOfRange:function(){
var val=this.get("value");
if(val==null){
return false;
}
var _42c=false;
if("min" in this.constraints){
var min=this.constraints.min;
_42c=this.compare(val,((typeof min=="number")&&min>=0&&val!=0)?0:min)<0;
}
if(!_42c&&("max" in this.constraints)){
var max=this.constraints.max;
_42c=this.compare(val,((typeof max!="number")||max>0)?max:0)>0;
}
return _42c;
},_isValidSubset:function(){
return this.inherited(arguments)&&!this._isDefinitelyOutOfRange();
},isValid:function(_42d){
return this.inherited(arguments)&&((this._isEmpty(this.textbox.value)&&!this.required)||this.isInRange(_42d));
},getErrorMessage:function(_42e){
var v=this.get("value");
if(v!=null&&v!==""&&(typeof v!="number"||!isNaN(v))&&!this.isInRange(_42e)){
return this.rangeMessage;
}
return this.inherited(arguments);
},postMixInProperties:function(){
this.inherited(arguments);
if(!this.rangeMessage){
this.messages=i18n.getLocalization("dijit.form","validate",this.lang);
this.rangeMessage=this.messages.rangeMessage;
}
},applyTextDir:function(){
}});
return _429;
});
},"dijit/_editor/RichText":function(){
define("dijit/_editor/RichText",["dojo/_base/array","dojo/_base/config","dojo/_base/declare","dojo/_base/Deferred","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/_base/event","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/on","dojo/query","dojo/ready","dojo/sniff","dojo/topic","dojo/_base/unload","dojo/_base/url","dojo/_base/window","../_Widget","../_CssStateMixin","./selection","./range","./html","../focus","../main"],function(_42f,_430,_431,_432,dom,_433,_434,_435,_436,_437,_438,_439,keys,lang,on,_43a,_43b,has,_43c,_43d,_43e,win,_43f,_440,_441,_442,_443,_444,_445){
var _446=_431("dijit._editor.RichText",[_43f,_440],{constructor:function(_447){
this.contentPreFilters=[];
this.contentPostFilters=[];
this.contentDomPreFilters=[];
this.contentDomPostFilters=[];
this.editingAreaStyleSheets=[];
this.events=[].concat(this.events);
this._keyHandlers={};
if(_447&&lang.isString(_447.value)){
this.value=_447.value;
}
this.onLoadDeferred=new _432();
},baseClass:"dijitEditor",inheritWidth:false,focusOnLoad:false,name:"",styleSheets:"",height:"300px",minHeight:"1em",isClosed:true,isLoaded:false,_SEPARATOR:"@@**%%__RICHTEXTBOUNDRY__%%**@@",_NAME_CONTENT_SEP:"@@**%%:%%**@@",onLoadDeferred:null,isTabIndent:false,disableSpellCheck:false,postCreate:function(){
if("textarea"===this.domNode.tagName.toLowerCase()){
console.warn("RichText should not be used with the TEXTAREA tag.  See dijit._editor.RichText docs.");
}
this.contentPreFilters=[lang.hitch(this,"_preFixUrlAttributes")].concat(this.contentPreFilters);
if(has("mozilla")){
this.contentPreFilters=[this._normalizeFontStyle].concat(this.contentPreFilters);
this.contentPostFilters=[this._removeMozBogus].concat(this.contentPostFilters);
}
if(has("webkit")){
this.contentPreFilters=[this._removeWebkitBogus].concat(this.contentPreFilters);
this.contentPostFilters=[this._removeWebkitBogus].concat(this.contentPostFilters);
}
if(has("ie")){
this.contentPostFilters=[this._normalizeFontStyle].concat(this.contentPostFilters);
this.contentDomPostFilters=[lang.hitch(this,this._stripBreakerNodes)].concat(this.contentDomPostFilters);
}
this.inherited(arguments);
_43c.publish(_445._scopeName+"._editor.RichText::init",this);
this.open();
this.setupDefaultShortcuts();
},setupDefaultShortcuts:function(){
var exec=lang.hitch(this,function(cmd,arg){
return function(){
return !this.execCommand(cmd,arg);
};
});
var _448={b:exec("bold"),i:exec("italic"),u:exec("underline"),a:exec("selectall"),s:function(){
this.save(true);
},m:function(){
this.isTabIndent=!this.isTabIndent;
},"1":exec("formatblock","h1"),"2":exec("formatblock","h2"),"3":exec("formatblock","h3"),"4":exec("formatblock","h4"),"\\":exec("insertunorderedlist")};
if(!has("ie")){
_448.Z=exec("redo");
}
var key;
for(key in _448){
this.addKeyHandler(key,true,false,_448[key]);
}
},events:["onKeyPress","onKeyDown","onKeyUp"],captureEvents:[],_editorCommandsLocalized:false,_localizeEditorCommands:function(){
if(_446._editorCommandsLocalized){
this._local2NativeFormatNames=_446._local2NativeFormatNames;
this._native2LocalFormatNames=_446._native2LocalFormatNames;
return;
}
_446._editorCommandsLocalized=true;
_446._local2NativeFormatNames={};
_446._native2LocalFormatNames={};
this._local2NativeFormatNames=_446._local2NativeFormatNames;
this._native2LocalFormatNames=_446._native2LocalFormatNames;
var _449=["div","p","pre","h1","h2","h3","h4","h5","h6","ol","ul","address"];
var _44a="",_44b,i=0;
while((_44b=_449[i++])){
if(_44b.charAt(1)!=="l"){
_44a+="<"+_44b+"><span>content</span></"+_44b+"><br/>";
}else{
_44a+="<"+_44b+"><li>content</li></"+_44b+"><br/>";
}
}
var _44c={position:"absolute",top:"0px",zIndex:10,opacity:0.01};
var div=_435.create("div",{style:_44c,innerHTML:_44a});
this.ownerDocumentBody.appendChild(div);
var _44d=lang.hitch(this,function(){
var node=div.firstChild;
while(node){
try{
this._sCall("selectElement",[node.firstChild]);
var _44e=node.tagName.toLowerCase();
this._local2NativeFormatNames[_44e]=document.queryCommandValue("formatblock");
this._native2LocalFormatNames[this._local2NativeFormatNames[_44e]]=_44e;
node=node.nextSibling.nextSibling;
}
catch(e){
}
}
_435.destroy(div);
});
this.defer(_44d);
},open:function(_44f){
if(!this.onLoadDeferred||this.onLoadDeferred.fired>=0){
this.onLoadDeferred=new _432();
}
if(!this.isClosed){
this.close();
}
_43c.publish(_445._scopeName+"._editor.RichText::open",this);
if(arguments.length===1&&_44f.nodeName){
this.domNode=_44f;
}
var dn=this.domNode;
var html;
if(lang.isString(this.value)){
html=this.value;
delete this.value;
dn.innerHTML="";
}else{
if(dn.nodeName&&dn.nodeName.toLowerCase()=="textarea"){
var ta=(this.textarea=dn);
this.name=ta.name;
html=ta.value;
dn=this.domNode=this.ownerDocument.createElement("div");
dn.setAttribute("widgetId",this.id);
ta.removeAttribute("widgetId");
dn.cssText=ta.cssText;
dn.className+=" "+ta.className;
_435.place(dn,ta,"before");
var _450=lang.hitch(this,function(){
_437.set(ta,{display:"block",position:"absolute",top:"-1000px"});
if(has("ie")){
var s=ta.style;
this.__overflow=s.overflow;
s.overflow="hidden";
}
});
if(has("ie")){
this.defer(_450,10);
}else{
_450();
}
if(ta.form){
var _451=ta.value;
this.reset=function(){
var _452=this.getValue();
if(_452!==_451){
this.replaceValue(_451);
}
};
on(ta.form,"submit",lang.hitch(this,function(){
_433.set(ta,"disabled",this.disabled);
ta.value=this.getValue();
}));
}
}else{
html=_443.getChildrenHtml(dn);
dn.innerHTML="";
}
}
this.value=html;
if(dn.nodeName&&dn.nodeName==="LI"){
dn.innerHTML=" <br>";
}
this.header=dn.ownerDocument.createElement("div");
dn.appendChild(this.header);
this.editingArea=dn.ownerDocument.createElement("div");
dn.appendChild(this.editingArea);
this.footer=dn.ownerDocument.createElement("div");
dn.appendChild(this.footer);
if(!this.name){
this.name=this.id+"_AUTOGEN";
}
if(this.name!==""&&(!_430["useXDomain"]||_430["allowXdRichTextSave"])){
var _453=dom.byId(_445._scopeName+"._editor.RichText.value");
if(_453&&_453.value!==""){
var _454=_453.value.split(this._SEPARATOR),i=0,dat;
while((dat=_454[i++])){
var data=dat.split(this._NAME_CONTENT_SEP);
if(data[0]===this.name){
html=data[1];
_454=_454.splice(i,1);
_453.value=_454.join(this._SEPARATOR);
break;
}
}
}
if(!_446._globalSaveHandler){
_446._globalSaveHandler={};
_43d.addOnUnload(function(){
var id;
for(id in _446._globalSaveHandler){
var f=_446._globalSaveHandler[id];
if(lang.isFunction(f)){
f();
}
}
});
}
_446._globalSaveHandler[this.id]=lang.hitch(this,"_saveContent");
}
this.isClosed=false;
var ifr=(this.editorObject=this.iframe=this.ownerDocument.createElement("iframe"));
ifr.id=this.id+"_iframe";
ifr.style.border="none";
ifr.style.width="100%";
if(this._layoutMode){
ifr.style.height="100%";
}else{
if(has("ie")>=7){
if(this.height){
ifr.style.height=this.height;
}
if(this.minHeight){
ifr.style.minHeight=this.minHeight;
}
}else{
ifr.style.height=this.height?this.height:this.minHeight;
}
}
ifr.frameBorder=0;
ifr._loadFunc=lang.hitch(this,function(w){
this.window=w;
this.document=this.window.document;
if(has("ie")){
this._localizeEditorCommands();
}
this.onLoad(html);
});
var src=this._getIframeDocTxt(),s="javascript: '"+src.replace(/\\/g,"\\\\").replace(/'/g,"\\'")+"'";
ifr.setAttribute("src",s);
this.editingArea.appendChild(ifr);
if(has("safari")<=4){
src=ifr.getAttribute("src");
if(!src||src.indexOf("javascript")===-1){
this.defer(function(){
ifr.setAttribute("src",s);
});
}
}
if(dn.nodeName==="LI"){
dn.lastChild.style.marginTop="-1.2em";
}
_434.add(this.domNode,this.baseClass);
},_local2NativeFormatNames:{},_native2LocalFormatNames:{},_getIframeDocTxt:function(){
var _455=_437.getComputedStyle(this.domNode);
var html="";
var _456=true;
if(has("ie")||has("webkit")||(!this.height&&!has("mozilla"))){
html="<div id='dijitEditorBody'></div>";
_456=false;
}else{
if(has("mozilla")){
this._cursorToStart=true;
html="&#160;";
}
}
var font=[_455.fontWeight,_455.fontSize,_455.fontFamily].join(" ");
var _457=_455.lineHeight;
if(_457.indexOf("px")>=0){
_457=parseFloat(_457)/parseFloat(_455.fontSize);
}else{
if(_457.indexOf("em")>=0){
_457=parseFloat(_457);
}else{
_457="normal";
}
}
var _458="";
var self=this;
this.style.replace(/(^|;)\s*(line-|font-?)[^;]+/ig,function(_459){
_459=_459.replace(/^;/ig,"")+";";
var s=_459.split(":")[0];
if(s){
s=lang.trim(s);
s=s.toLowerCase();
var i;
var sC="";
for(i=0;i<s.length;i++){
var c=s.charAt(i);
switch(c){
case "-":
i++;
c=s.charAt(i).toUpperCase();
default:
sC+=c;
}
}
_437.set(self.domNode,sC,"");
}
_458+=_459+";";
});
var _45a=_43a("label[for=\""+this.id+"\"]");
return [this.isLeftToRight()?"<html>\n<head>\n":"<html dir='rtl'>\n<head>\n",(has("mozilla")&&_45a.length?"<title>"+_45a[0].innerHTML+"</title>\n":""),"<meta http-equiv='Content-Type' content='text/html'>\n","<style>\n","\tbody,html {\n","\t\tbackground:transparent;\n","\t\tpadding: 1px 0 0 0;\n","\t\tmargin: -1px 0 0 0;\n",((has("webkit"))?"\t\twidth: 100%;\n":""),((has("webkit"))?"\t\theight: 100%;\n":""),"\t}\n","\tbody{\n","\t\ttop:0px;\n","\t\tleft:0px;\n","\t\tright:0px;\n","\t\tfont:",font,";\n",((this.height||has("opera"))?"":"\t\tposition: fixed;\n"),"\t\tmin-height:",this.minHeight,";\n","\t\tline-height:",_457,";\n","\t}\n","\tp{ margin: 1em 0; }\n",(!_456&&!this.height?"\tbody,html {overflow-y: hidden;}\n":""),"\t#dijitEditorBody{overflow-x: auto; overflow-y:"+(this.height?"auto;":"hidden;")+" outline: 0px;}\n","\tli > ul:-moz-first-node, li > ol:-moz-first-node{ padding-top: 1.2em; }\n",(!has("ie")?"\tli{ min-height:1.2em; }\n":""),"</style>\n",this._applyEditingAreaStyleSheets(),"\n","</head>\n<body ",(_456?"id='dijitEditorBody' ":""),"onload='frameElement && frameElement._loadFunc(window,document)' ","style='"+_458+"'>",html,"</body>\n</html>"].join("");
},_applyEditingAreaStyleSheets:function(){
var _45b=[];
if(this.styleSheets){
_45b=this.styleSheets.split(";");
this.styleSheets="";
}
_45b=_45b.concat(this.editingAreaStyleSheets);
this.editingAreaStyleSheets=[];
var text="",i=0,url;
while((url=_45b[i++])){
var _45c=(new _43e(win.global.location,url)).toString();
this.editingAreaStyleSheets.push(_45c);
text+="<link rel=\"stylesheet\" type=\"text/css\" href=\""+_45c+"\"/>";
}
return text;
},addStyleSheet:function(uri){
var url=uri.toString();
if(url.charAt(0)==="."||(url.charAt(0)!=="/"&&!uri.host)){
url=(new _43e(win.global.location,url)).toString();
}
if(_42f.indexOf(this.editingAreaStyleSheets,url)>-1){
return;
}
this.editingAreaStyleSheets.push(url);
this.onLoadDeferred.then(lang.hitch(this,function(){
if(this.document.createStyleSheet){
this.document.createStyleSheet(url);
}else{
var head=this.document.getElementsByTagName("head")[0];
var _45d=this.document.createElement("link");
_45d.rel="stylesheet";
_45d.type="text/css";
_45d.href=url;
head.appendChild(_45d);
}
}));
},removeStyleSheet:function(uri){
var url=uri.toString();
if(url.charAt(0)==="."||(url.charAt(0)!=="/"&&!uri.host)){
url=(new _43e(win.global.location,url)).toString();
}
var _45e=_42f.indexOf(this.editingAreaStyleSheets,url);
if(_45e===-1){
return;
}
delete this.editingAreaStyleSheets[_45e];
_43a("link:[href=\""+url+"\"]",this.window.document).orphan();
},disabled:false,_mozSettingProps:{"styleWithCSS":false},_setDisabledAttr:function(_45f){
_45f=!!_45f;
this._set("disabled",_45f);
if(!this.isLoaded){
return;
}
if(has("ie")||has("webkit")||has("opera")){
var _460=has("ie")&&(this.isLoaded||!this.focusOnLoad);
if(_460){
this.editNode.unselectable="on";
}
this.editNode.contentEditable=!_45f;
if(_460){
this.defer(function(){
if(this.editNode){
this.editNode.unselectable="off";
}
});
}
}else{
try{
this.document.designMode=(_45f?"off":"on");
}
catch(e){
return;
}
if(!_45f&&this._mozSettingProps){
var ps=this._mozSettingProps;
var n;
for(n in ps){
if(ps.hasOwnProperty(n)){
try{
this.document.execCommand(n,false,ps[n]);
}
catch(e2){
}
}
}
}
}
this._disabledOK=true;
},onLoad:function(html){
if(!this.window.__registeredWindow){
this.window.__registeredWindow=true;
this._iframeRegHandle=_444.registerIframe(this.iframe);
}
if(!has("ie")&&!has("webkit")&&(this.height||has("mozilla"))){
this.editNode=this.document.body;
}else{
this.editNode=this.document.body.firstChild;
var _461=this;
if(has("ie")){
this.tabStop=_435.create("div",{tabIndex:-1},this.editingArea);
this.iframe.onfocus=function(){
_461.editNode.setActive();
};
}
}
this.focusNode=this.editNode;
var _462=this.events.concat(this.captureEvents);
var ap=this.iframe?this.document:this.editNode;
_42f.forEach(_462,function(item){
this.connect(ap,item.toLowerCase(),item);
},this);
this.connect(ap,"onmouseup","onClick");
if(has("ie")){
this.connect(this.document,"onmousedown","_onIEMouseDown");
this.editNode.style.zoom=1;
}else{
this.connect(this.document,"onmousedown",function(){
delete this._cursorToStart;
});
}
if(has("webkit")){
this._webkitListener=this.connect(this.document,"onmouseup","onDisplayChanged");
this.connect(this.document,"onmousedown",function(e){
var t=e.target;
if(t&&(t===this.document.body||t===this.document)){
this.defer("placeCursorAtEnd");
}
});
}
if(has("ie")){
try{
this.document.execCommand("RespectVisibilityInDesign",true,null);
}
catch(e){
}
}
this.isLoaded=true;
this.set("disabled",this.disabled);
var _463=lang.hitch(this,function(){
this.setValue(html);
if(this.onLoadDeferred){
this.onLoadDeferred.resolve(true);
}
this.onDisplayChanged();
if(this.focusOnLoad){
_43b(lang.hitch(this,"defer","focus",this.updateInterval));
}
this.value=this.getValue(true);
});
if(this.setValueDeferred){
this.setValueDeferred.then(_463);
}else{
_463();
}
},onKeyDown:function(e){
if(e.keyCode===keys.TAB&&this.isTabIndent){
_438.stop(e);
if(this.queryCommandEnabled((e.shiftKey?"outdent":"indent"))){
this.execCommand((e.shiftKey?"outdent":"indent"));
}
}
if(has("ie")){
if(e.keyCode==keys.TAB&&!this.isTabIndent){
if(e.shiftKey&&!e.ctrlKey&&!e.altKey){
this.iframe.focus();
}else{
if(!e.shiftKey&&!e.ctrlKey&&!e.altKey){
this.tabStop.focus();
}
}
}else{
if(e.keyCode===keys.BACKSPACE&&this.document.selection.type==="Control"){
_438.stop(e);
this.execCommand("delete");
}else{
if((65<=e.keyCode&&e.keyCode<=90)||(e.keyCode>=37&&e.keyCode<=40)){
e.charCode=e.keyCode;
this.onKeyPress(e);
}
}
}
}
if(has("ff")){
if(e.keyCode===keys.PAGE_UP||e.keyCode===keys.PAGE_DOWN){
if(this.editNode.clientHeight>=this.editNode.scrollHeight){
e.preventDefault();
}
}
}
return true;
},onKeyUp:function(){
},setDisabled:function(_464){
_439.deprecated("dijit.Editor::setDisabled is deprecated","use dijit.Editor::attr(\"disabled\",boolean) instead",2);
this.set("disabled",_464);
},_setValueAttr:function(_465){
this.setValue(_465);
},_setDisableSpellCheckAttr:function(_466){
if(this.document){
_433.set(this.document.body,"spellcheck",!_466);
}else{
this.onLoadDeferred.then(lang.hitch(this,function(){
_433.set(this.document.body,"spellcheck",!_466);
}));
}
this._set("disableSpellCheck",_466);
},onKeyPress:function(e){
var c=(e.keyChar&&e.keyChar.toLowerCase())||e.keyCode,_467=this._keyHandlers[c],args=arguments;
if(_467&&!e.altKey){
_42f.some(_467,function(h){
if(!(h.shift^e.shiftKey)&&!(h.ctrl^(e.ctrlKey||e.metaKey))){
if(!h.handler.apply(this,args)){
e.preventDefault();
}
return true;
}
},this);
}
if(!this._onKeyHitch){
this._onKeyHitch=lang.hitch(this,"onKeyPressed");
}
this.defer("_onKeyHitch",1);
return true;
},addKeyHandler:function(key,ctrl,_468,_469){
if(!lang.isArray(this._keyHandlers[key])){
this._keyHandlers[key]=[];
}
this._keyHandlers[key].push({shift:_468||false,ctrl:ctrl||false,handler:_469});
},onKeyPressed:function(){
this.onDisplayChanged();
},onClick:function(e){
this.onDisplayChanged(e);
},_onIEMouseDown:function(){
if(!this.focused&&!this.disabled){
this.focus();
}
},_onBlur:function(e){
this.inherited(arguments);
var _46a=this.getValue(true);
if(_46a!==this.value){
this.onChange(_46a);
}
this._set("value",_46a);
},_onFocus:function(e){
if(!this.disabled){
if(!this._disabledOK){
this.set("disabled",false);
}
this.inherited(arguments);
}
},blur:function(){
if(!has("ie")&&this.window.document.documentElement&&this.window.document.documentElement.focus){
this.window.document.documentElement.focus();
}else{
if(this.ownerDocumentBody.focus){
this.ownerDocumentBody.focus();
}
}
},focus:function(){
if(!this.isLoaded){
this.focusOnLoad=true;
return;
}
if(this._cursorToStart){
delete this._cursorToStart;
if(this.editNode.childNodes){
this.placeCursorAtStart();
return;
}
}
if(!has("ie")){
_444.focus(this.iframe);
}else{
if(this.editNode&&this.editNode.focus){
this.iframe.fireEvent("onfocus",document.createEventObject());
}
}
},updateInterval:200,_updateTimer:null,onDisplayChanged:function(){
if(this._updateTimer){
this._updateTimer.remove();
}
this._updateTimer=this.defer("onNormalizedDisplayChanged",this.updateInterval);
},onNormalizedDisplayChanged:function(){
delete this._updateTimer;
},onChange:function(){
},_normalizeCommand:function(cmd,_46b){
var _46c=cmd.toLowerCase();
if(_46c==="formatblock"){
if(has("safari")&&_46b===undefined){
_46c="heading";
}
}else{
if(_46c==="hilitecolor"&&!has("mozilla")){
_46c="backcolor";
}
}
return _46c;
},_qcaCache:{},queryCommandAvailable:function(_46d){
var ca=this._qcaCache[_46d];
if(ca!==undefined){
return ca;
}
return (this._qcaCache[_46d]=this._queryCommandAvailable(_46d));
},_queryCommandAvailable:function(_46e){
var ie=1;
var _46f=1<<1;
var _470=1<<2;
var _471=1<<3;
function _472(_473){
return {ie:Boolean(_473&ie),mozilla:Boolean(_473&_46f),webkit:Boolean(_473&_470),opera:Boolean(_473&_471)};
};
var _474=null;
switch(_46e.toLowerCase()){
case "bold":
case "italic":
case "underline":
case "subscript":
case "superscript":
case "fontname":
case "fontsize":
case "forecolor":
case "hilitecolor":
case "justifycenter":
case "justifyfull":
case "justifyleft":
case "justifyright":
case "delete":
case "selectall":
case "toggledir":
_474=_472(_46f|ie|_470|_471);
break;
case "createlink":
case "unlink":
case "removeformat":
case "inserthorizontalrule":
case "insertimage":
case "insertorderedlist":
case "insertunorderedlist":
case "indent":
case "outdent":
case "formatblock":
case "inserthtml":
case "undo":
case "redo":
case "strikethrough":
case "tabindent":
_474=_472(_46f|ie|_471|_470);
break;
case "blockdirltr":
case "blockdirrtl":
case "dirltr":
case "dirrtl":
case "inlinedirltr":
case "inlinedirrtl":
_474=_472(ie);
break;
case "cut":
case "copy":
case "paste":
_474=_472(ie|_46f|_470|_471);
break;
case "inserttable":
_474=_472(_46f|ie);
break;
case "insertcell":
case "insertcol":
case "insertrow":
case "deletecells":
case "deletecols":
case "deleterows":
case "mergecells":
case "splitcell":
_474=_472(ie|_46f);
break;
default:
return false;
}
return (has("ie")&&_474.ie)||(has("mozilla")&&_474.mozilla)||(has("webkit")&&_474.webkit)||(has("opera")&&_474.opera);
},execCommand:function(_475,_476){
var _477;
this.focus();
_475=this._normalizeCommand(_475,_476);
if(_476!==undefined){
if(_475==="heading"){
throw new Error("unimplemented");
}else{
if((_475==="formatblock")&&has("ie")){
_476="<"+_476+">";
}
}
}
var _478="_"+_475+"Impl";
if(this[_478]){
_477=this[_478](_476);
}else{
_476=arguments.length>1?_476:null;
if(_476||_475!=="createlink"){
_477=this.document.execCommand(_475,false,_476);
}
}
this.onDisplayChanged();
return _477;
},queryCommandEnabled:function(_479){
if(this.disabled||!this._disabledOK){
return false;
}
_479=this._normalizeCommand(_479);
var _47a="_"+_479+"EnabledImpl";
if(this[_47a]){
return this[_47a](_479);
}else{
return this._browserQueryCommandEnabled(_479);
}
},queryCommandState:function(_47b){
if(this.disabled||!this._disabledOK){
return false;
}
_47b=this._normalizeCommand(_47b);
try{
return this.document.queryCommandState(_47b);
}
catch(e){
return false;
}
},queryCommandValue:function(_47c){
if(this.disabled||!this._disabledOK){
return false;
}
var r;
_47c=this._normalizeCommand(_47c);
if(has("ie")&&_47c==="formatblock"){
r=this._native2LocalFormatNames[this.document.queryCommandValue(_47c)];
}else{
if(has("mozilla")&&_47c==="hilitecolor"){
var _47d;
try{
_47d=this.document.queryCommandValue("styleWithCSS");
}
catch(e){
_47d=false;
}
this.document.execCommand("styleWithCSS",false,true);
r=this.document.queryCommandValue(_47c);
this.document.execCommand("styleWithCSS",false,_47d);
}else{
r=this.document.queryCommandValue(_47c);
}
}
return r;
},_sCall:function(name,args){
return win.withGlobal(this.window,name,_441,args);
},placeCursorAtStart:function(){
this.focus();
var _47e=false;
if(has("mozilla")){
var _47f=this.editNode.firstChild;
while(_47f){
if(_47f.nodeType===3){
if(_47f.nodeValue.replace(/^\s+|\s+$/g,"").length>0){
_47e=true;
this._sCall("selectElement",[_47f]);
break;
}
}else{
if(_47f.nodeType===1){
_47e=true;
var tg=_47f.tagName?_47f.tagName.toLowerCase():"";
if(/br|input|img|base|meta|area|basefont|hr|link/.test(tg)){
this._sCall("selectElement",[_47f]);
}else{
this._sCall("selectElementChildren",[_47f]);
}
break;
}
}
_47f=_47f.nextSibling;
}
}else{
_47e=true;
this._sCall("selectElementChildren",[this.editNode]);
}
if(_47e){
this._sCall("collapse",[true]);
}
},placeCursorAtEnd:function(){
this.focus();
var _480=false;
if(has("mozilla")){
var last=this.editNode.lastChild;
while(last){
if(last.nodeType===3){
if(last.nodeValue.replace(/^\s+|\s+$/g,"").length>0){
_480=true;
this._sCall("selectElement",[last]);
break;
}
}else{
if(last.nodeType===1){
_480=true;
this._sCall("selectElement",[last.lastChild||last]);
break;
}
}
last=last.previousSibling;
}
}else{
_480=true;
this._sCall("selectElementChildren",[this.editNode]);
}
if(_480){
this._sCall("collapse",[false]);
}
},getValue:function(_481){
if(this.textarea){
if(this.isClosed||!this.isLoaded){
return this.textarea.value;
}
}
return this._postFilterContent(null,_481);
},_getValueAttr:function(){
return this.getValue(true);
},setValue:function(html){
if(!this.isLoaded){
this.onLoadDeferred.then(lang.hitch(this,function(){
this.setValue(html);
}));
return;
}
this._cursorToStart=true;
if(this.textarea&&(this.isClosed||!this.isLoaded)){
this.textarea.value=html;
}else{
html=this._preFilterContent(html);
var node=this.isClosed?this.domNode:this.editNode;
if(html&&has("mozilla")&&html.toLowerCase()==="<p></p>"){
html="<p>&#160;</p>";
}
if(!html&&has("webkit")){
html="&#160;";
}
node.innerHTML=html;
this._preDomFilterContent(node);
}
this.onDisplayChanged();
this._set("value",this.getValue(true));
},replaceValue:function(html){
if(this.isClosed){
this.setValue(html);
}else{
if(this.window&&this.window.getSelection&&!has("mozilla")){
this.setValue(html);
}else{
if(this.window&&this.window.getSelection){
html=this._preFilterContent(html);
this.execCommand("selectall");
if(!html){
this._cursorToStart=true;
html="&#160;";
}
this.execCommand("inserthtml",html);
this._preDomFilterContent(this.editNode);
}else{
if(this.document&&this.document.selection){
this.setValue(html);
}
}
}
}
this._set("value",this.getValue(true));
},_preFilterContent:function(html){
var ec=html;
_42f.forEach(this.contentPreFilters,function(ef){
if(ef){
ec=ef(ec);
}
});
return ec;
},_preDomFilterContent:function(dom){
dom=dom||this.editNode;
_42f.forEach(this.contentDomPreFilters,function(ef){
if(ef&&lang.isFunction(ef)){
ef(dom);
}
},this);
},_postFilterContent:function(dom,_482){
var ec;
if(!lang.isString(dom)){
dom=dom||this.editNode;
if(this.contentDomPostFilters.length){
if(_482){
dom=lang.clone(dom);
}
_42f.forEach(this.contentDomPostFilters,function(ef){
dom=ef(dom);
});
}
ec=_443.getChildrenHtml(dom);
}else{
ec=dom;
}
if(!lang.trim(ec.replace(/^\xA0\xA0*/,"").replace(/\xA0\xA0*$/,"")).length){
ec="";
}
_42f.forEach(this.contentPostFilters,function(ef){
ec=ef(ec);
});
return ec;
},_saveContent:function(){
var _483=dom.byId(_445._scopeName+"._editor.RichText.value");
if(_483){
if(_483.value){
_483.value+=this._SEPARATOR;
}
_483.value+=this.name+this._NAME_CONTENT_SEP+this.getValue(true);
}
},escapeXml:function(str,_484){
str=str.replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;");
if(!_484){
str=str.replace(/'/gm,"&#39;");
}
return str;
},getNodeHtml:function(node){
_439.deprecated("dijit.Editor::getNodeHtml is deprecated","use dijit/_editor/html::getNodeHtml instead",2);
return _443.getNodeHtml(node);
},getNodeChildrenHtml:function(dom){
_439.deprecated("dijit.Editor::getNodeChildrenHtml is deprecated","use dijit/_editor/html::getChildrenHtml instead",2);
return _443.getChildrenHtml(dom);
},close:function(save){
if(this.isClosed){
return;
}
if(!arguments.length){
save=true;
}
if(save){
this._set("value",this.getValue(true));
}
if(this.interval){
clearInterval(this.interval);
}
if(this._webkitListener){
this.disconnect(this._webkitListener);
delete this._webkitListener;
}
if(has("ie")){
this.iframe.onfocus=null;
}
this.iframe._loadFunc=null;
if(this._iframeRegHandle){
this._iframeRegHandle.remove();
delete this._iframeRegHandle;
}
if(this.textarea){
var s=this.textarea.style;
s.position="";
s.left=s.top="";
if(has("ie")){
s.overflow=this.__overflow;
this.__overflow=null;
}
this.textarea.value=this.value;
_435.destroy(this.domNode);
this.domNode=this.textarea;
}else{
this.domNode.innerHTML=this.value;
}
delete this.iframe;
_434.remove(this.domNode,this.baseClass);
this.isClosed=true;
this.isLoaded=false;
delete this.editNode;
delete this.focusNode;
if(this.window&&this.window._frameElement){
this.window._frameElement=null;
}
this.window=null;
this.document=null;
this.editingArea=null;
this.editorObject=null;
},destroy:function(){
if(!this.isClosed){
this.close(false);
}
if(this._updateTimer){
this._updateTimer.remove();
}
this.inherited(arguments);
if(_446._globalSaveHandler){
delete _446._globalSaveHandler[this.id];
}
},_removeMozBogus:function(html){
return html.replace(/\stype="_moz"/gi,"").replace(/\s_moz_dirty=""/gi,"").replace(/_moz_resizing="(true|false)"/gi,"");
},_removeWebkitBogus:function(html){
html=html.replace(/\sclass="webkit-block-placeholder"/gi,"");
html=html.replace(/\sclass="apple-style-span"/gi,"");
html=html.replace(/<meta charset=\"utf-8\" \/>/gi,"");
return html;
},_normalizeFontStyle:function(html){
return html.replace(/<(\/)?strong([ \>])/gi,"<$1b$2").replace(/<(\/)?em([ \>])/gi,"<$1i$2");
},_preFixUrlAttributes:function(html){
return html.replace(/(?:(<a(?=\s).*?\shref=)("|')(.*?)\2)|(?:(<a\s.*?href=)([^"'][^ >]+))/gi,"$1$4$2$3$5$2 _djrealurl=$2$3$5$2").replace(/(?:(<img(?=\s).*?\ssrc=)("|')(.*?)\2)|(?:(<img\s.*?src=)([^"'][^ >]+))/gi,"$1$4$2$3$5$2 _djrealurl=$2$3$5$2");
},_browserQueryCommandEnabled:function(_485){
if(!_485){
return false;
}
var elem=has("ie")?this.document.selection.createRange():this.document;
try{
return elem.queryCommandEnabled(_485);
}
catch(e){
return false;
}
},_createlinkEnabledImpl:function(){
var _486=true;
if(has("opera")){
var sel=this.window.getSelection();
if(sel.isCollapsed){
_486=true;
}else{
_486=this.document.queryCommandEnabled("createlink");
}
}else{
_486=this._browserQueryCommandEnabled("createlink");
}
return _486;
},_unlinkEnabledImpl:function(){
var _487=true;
if(has("mozilla")||has("webkit")){
_487=this._sCall("hasAncestorElement",["a"]);
}else{
_487=this._browserQueryCommandEnabled("unlink");
}
return _487;
},_inserttableEnabledImpl:function(){
var _488=true;
if(has("mozilla")||has("webkit")){
_488=true;
}else{
_488=this._browserQueryCommandEnabled("inserttable");
}
return _488;
},_cutEnabledImpl:function(){
var _489=true;
if(has("webkit")){
var sel=this.window.getSelection();
if(sel){
sel=sel.toString();
}
_489=!!sel;
}else{
_489=this._browserQueryCommandEnabled("cut");
}
return _489;
},_copyEnabledImpl:function(){
var _48a=true;
if(has("webkit")){
var sel=this.window.getSelection();
if(sel){
sel=sel.toString();
}
_48a=!!sel;
}else{
_48a=this._browserQueryCommandEnabled("copy");
}
return _48a;
},_pasteEnabledImpl:function(){
var _48b=true;
if(has("webkit")){
return true;
}else{
_48b=this._browserQueryCommandEnabled("paste");
}
return _48b;
},_inserthorizontalruleImpl:function(_48c){
if(has("ie")){
return this._inserthtmlImpl("<hr>");
}
return this.document.execCommand("inserthorizontalrule",false,_48c);
},_unlinkImpl:function(_48d){
if((this.queryCommandEnabled("unlink"))&&(has("mozilla")||has("webkit"))){
var a=this._sCall("getAncestorElement",["a"]);
this._sCall("selectElement",[a]);
return this.document.execCommand("unlink",false,null);
}
return this.document.execCommand("unlink",false,_48d);
},_hilitecolorImpl:function(_48e){
var _48f;
var _490=this._handleTextColorOrProperties("hilitecolor",_48e);
if(!_490){
if(has("mozilla")){
this.document.execCommand("styleWithCSS",false,true);
_48f=this.document.execCommand("hilitecolor",false,_48e);
this.document.execCommand("styleWithCSS",false,false);
}else{
_48f=this.document.execCommand("hilitecolor",false,_48e);
}
}
return _48f;
},_backcolorImpl:function(_491){
if(has("ie")){
_491=_491?_491:null;
}
var _492=this._handleTextColorOrProperties("backcolor",_491);
if(!_492){
_492=this.document.execCommand("backcolor",false,_491);
}
return _492;
},_forecolorImpl:function(_493){
if(has("ie")){
_493=_493?_493:null;
}
var _494=false;
_494=this._handleTextColorOrProperties("forecolor",_493);
if(!_494){
_494=this.document.execCommand("forecolor",false,_493);
}
return _494;
},_inserthtmlImpl:function(_495){
_495=this._preFilterContent(_495);
var rv=true;
if(has("ie")){
var _496=this.document.selection.createRange();
if(this.document.selection.type.toUpperCase()==="CONTROL"){
var n=_496.item(0);
while(_496.length){
_496.remove(_496.item(0));
}
n.outerHTML=_495;
}else{
_496.pasteHTML(_495);
}
_496.select();
}else{
if(has("mozilla")&&!_495.length){
this._sCall("remove");
}else{
rv=this.document.execCommand("inserthtml",false,_495);
}
}
return rv;
},_boldImpl:function(_497){
var _498=false;
if(has("ie")){
this._adaptIESelection();
_498=this._adaptIEFormatAreaAndExec("bold");
}
if(!_498){
_498=this.document.execCommand("bold",false,_497);
}
return _498;
},_italicImpl:function(_499){
var _49a=false;
if(has("ie")){
this._adaptIESelection();
_49a=this._adaptIEFormatAreaAndExec("italic");
}
if(!_49a){
_49a=this.document.execCommand("italic",false,_499);
}
return _49a;
},_underlineImpl:function(_49b){
var _49c=false;
if(has("ie")){
this._adaptIESelection();
_49c=this._adaptIEFormatAreaAndExec("underline");
}
if(!_49c){
_49c=this.document.execCommand("underline",false,_49b);
}
return _49c;
},_strikethroughImpl:function(_49d){
var _49e=false;
if(has("ie")){
this._adaptIESelection();
_49e=this._adaptIEFormatAreaAndExec("strikethrough");
}
if(!_49e){
_49e=this.document.execCommand("strikethrough",false,_49d);
}
return _49e;
},_superscriptImpl:function(_49f){
var _4a0=false;
if(has("ie")){
this._adaptIESelection();
_4a0=this._adaptIEFormatAreaAndExec("superscript");
}
if(!_4a0){
_4a0=this.document.execCommand("superscript",false,_49f);
}
return _4a0;
},_subscriptImpl:function(_4a1){
var _4a2=false;
if(has("ie")){
this._adaptIESelection();
_4a2=this._adaptIEFormatAreaAndExec("subscript");
}
if(!_4a2){
_4a2=this.document.execCommand("subscript",false,_4a1);
}
return _4a2;
},_fontnameImpl:function(_4a3){
var _4a4;
if(has("ie")){
_4a4=this._handleTextColorOrProperties("fontname",_4a3);
}
if(!_4a4){
_4a4=this.document.execCommand("fontname",false,_4a3);
}
return _4a4;
},_fontsizeImpl:function(_4a5){
var _4a6;
if(has("ie")){
_4a6=this._handleTextColorOrProperties("fontsize",_4a5);
}
if(!_4a6){
_4a6=this.document.execCommand("fontsize",false,_4a5);
}
return _4a6;
},_insertorderedlistImpl:function(_4a7){
var _4a8=false;
if(has("ie")){
_4a8=this._adaptIEList("insertorderedlist",_4a7);
}
if(!_4a8){
_4a8=this.document.execCommand("insertorderedlist",false,_4a7);
}
return _4a8;
},_insertunorderedlistImpl:function(_4a9){
var _4aa=false;
if(has("ie")){
_4aa=this._adaptIEList("insertunorderedlist",_4a9);
}
if(!_4aa){
_4aa=this.document.execCommand("insertunorderedlist",false,_4a9);
}
return _4aa;
},getHeaderHeight:function(){
return this._getNodeChildrenHeight(this.header);
},getFooterHeight:function(){
return this._getNodeChildrenHeight(this.footer);
},_getNodeChildrenHeight:function(node){
var h=0;
if(node&&node.childNodes){
var i;
for(i=0;i<node.childNodes.length;i++){
var size=_436.position(node.childNodes[i]);
h+=size.h;
}
}
return h;
},_isNodeEmpty:function(node,_4ab){
if(node.nodeType===1){
if(node.childNodes.length>0){
return this._isNodeEmpty(node.childNodes[0],_4ab);
}
return true;
}else{
if(node.nodeType===3){
return (node.nodeValue.substring(_4ab)==="");
}
}
return false;
},_removeStartingRangeFromRange:function(node,_4ac){
if(node.nextSibling){
_4ac.setStart(node.nextSibling,0);
}else{
var _4ad=node.parentNode;
while(_4ad&&_4ad.nextSibling==null){
_4ad=_4ad.parentNode;
}
if(_4ad){
_4ac.setStart(_4ad.nextSibling,0);
}
}
return _4ac;
},_adaptIESelection:function(){
var _4ae=_442.getSelection(this.window);
if(_4ae&&_4ae.rangeCount&&!_4ae.isCollapsed){
var _4af=_4ae.getRangeAt(0);
var _4b0=_4af.startContainer;
var _4b1=_4af.startOffset;
while(_4b0.nodeType===3&&_4b1>=_4b0.length&&_4b0.nextSibling){
_4b1=_4b1-_4b0.length;
_4b0=_4b0.nextSibling;
}
var _4b2=null;
while(this._isNodeEmpty(_4b0,_4b1)&&_4b0!==_4b2){
_4b2=_4b0;
_4af=this._removeStartingRangeFromRange(_4b0,_4af);
_4b0=_4af.startContainer;
_4b1=0;
}
_4ae.removeAllRanges();
_4ae.addRange(_4af);
}
},_adaptIEFormatAreaAndExec:function(_4b3){
var _4b4=_442.getSelection(this.window);
var doc=this.document;
var rs,ret,_4b5,txt,_4b6,_4b7,_4b8,_4b9;
if(_4b3&&_4b4&&_4b4.isCollapsed){
var _4ba=this.queryCommandValue(_4b3);
if(_4ba){
var _4bb=this._tagNamesForCommand(_4b3);
_4b5=_4b4.getRangeAt(0);
var fs=_4b5.startContainer;
if(fs.nodeType===3){
var _4bc=_4b5.endOffset;
if(fs.length<_4bc){
ret=this._adjustNodeAndOffset(rs,_4bc);
fs=ret.node;
_4bc=ret.offset;
}
}
var _4bd;
while(fs&&fs!==this.editNode){
var _4be=fs.tagName?fs.tagName.toLowerCase():"";
if(_42f.indexOf(_4bb,_4be)>-1){
_4bd=fs;
break;
}
fs=fs.parentNode;
}
if(_4bd){
rs=_4b5.startContainer;
var _4bf=doc.createElement(_4bd.tagName);
_435.place(_4bf,_4bd,"after");
if(rs&&rs.nodeType===3){
var _4c0,_4c1;
var _4c2=_4b5.endOffset;
if(rs.length<_4c2){
ret=this._adjustNodeAndOffset(rs,_4c2);
rs=ret.node;
_4c2=ret.offset;
}
txt=rs.nodeValue;
_4b6=doc.createTextNode(txt.substring(0,_4c2));
var _4c3=txt.substring(_4c2,txt.length);
if(_4c3){
_4b7=doc.createTextNode(_4c3);
}
_435.place(_4b6,rs,"before");
if(_4b7){
_4b8=doc.createElement("span");
_4b8.className="ieFormatBreakerSpan";
_435.place(_4b8,rs,"after");
_435.place(_4b7,_4b8,"after");
_4b7=_4b8;
}
_435.destroy(rs);
var _4c4=_4b6.parentNode;
var _4c5=[];
var _4c6;
while(_4c4!==_4bd){
var tg=_4c4.tagName;
_4c6={tagName:tg};
_4c5.push(_4c6);
var _4c7=doc.createElement(tg);
if(_4c4.style){
if(_4c7.style){
if(_4c4.style.cssText){
_4c7.style.cssText=_4c4.style.cssText;
_4c6.cssText=_4c4.style.cssText;
}
}
}
if(_4c4.tagName==="FONT"){
if(_4c4.color){
_4c7.color=_4c4.color;
_4c6.color=_4c4.color;
}
if(_4c4.face){
_4c7.face=_4c4.face;
_4c6.face=_4c4.face;
}
if(_4c4.size){
_4c7.size=_4c4.size;
_4c6.size=_4c4.size;
}
}
if(_4c4.className){
_4c7.className=_4c4.className;
_4c6.className=_4c4.className;
}
if(_4b7){
_4c0=_4b7;
while(_4c0){
_4c1=_4c0.nextSibling;
_4c7.appendChild(_4c0);
_4c0=_4c1;
}
}
if(_4c7.tagName==_4c4.tagName){
_4b8=doc.createElement("span");
_4b8.className="ieFormatBreakerSpan";
_435.place(_4b8,_4c4,"after");
_435.place(_4c7,_4b8,"after");
}else{
_435.place(_4c7,_4c4,"after");
}
_4b6=_4c4;
_4b7=_4c7;
_4c4=_4c4.parentNode;
}
if(_4b7){
_4c0=_4b7;
if(_4c0.nodeType===1||(_4c0.nodeType===3&&_4c0.nodeValue)){
_4bf.innerHTML="";
}
while(_4c0){
_4c1=_4c0.nextSibling;
_4bf.appendChild(_4c0);
_4c0=_4c1;
}
}
var _4c8;
if(_4c5.length){
_4c6=_4c5.pop();
var _4c9=doc.createElement(_4c6.tagName);
if(_4c6.cssText&&_4c9.style){
_4c9.style.cssText=_4c6.cssText;
}
if(_4c6.className){
_4c9.className=_4c6.className;
}
if(_4c6.tagName==="FONT"){
if(_4c6.color){
_4c9.color=_4c6.color;
}
if(_4c6.face){
_4c9.face=_4c6.face;
}
if(_4c6.size){
_4c9.size=_4c6.size;
}
}
_435.place(_4c9,_4bf,"before");
while(_4c5.length){
_4c6=_4c5.pop();
var _4ca=doc.createElement(_4c6.tagName);
if(_4c6.cssText&&_4ca.style){
_4ca.style.cssText=_4c6.cssText;
}
if(_4c6.className){
_4ca.className=_4c6.className;
}
if(_4c6.tagName==="FONT"){
if(_4c6.color){
_4ca.color=_4c6.color;
}
if(_4c6.face){
_4ca.face=_4c6.face;
}
if(_4c6.size){
_4ca.size=_4c6.size;
}
}
_4c9.appendChild(_4ca);
_4c9=_4ca;
}
_4b9=doc.createTextNode(".");
_4b8.appendChild(_4b9);
_4c9.appendChild(_4b9);
_4c8=_442.create(this.window);
_4c8.setStart(_4b9,0);
_4c8.setEnd(_4b9,_4b9.length);
_4b4.removeAllRanges();
_4b4.addRange(_4c8);
this._sCall("collapse",[false]);
_4b9.parentNode.innerHTML="";
}else{
_4b8=doc.createElement("span");
_4b8.className="ieFormatBreakerSpan";
_4b9=doc.createTextNode(".");
_4b8.appendChild(_4b9);
_435.place(_4b8,_4bf,"before");
_4c8=_442.create(this.window);
_4c8.setStart(_4b9,0);
_4c8.setEnd(_4b9,_4b9.length);
_4b4.removeAllRanges();
_4b4.addRange(_4c8);
this._sCall("collapse",[false]);
_4b9.parentNode.innerHTML="";
}
if(!_4bf.firstChild){
_435.destroy(_4bf);
}
return true;
}
}
return false;
}else{
_4b5=_4b4.getRangeAt(0);
rs=_4b5.startContainer;
if(rs&&rs.nodeType===3){
var _4bc=_4b5.startOffset;
if(rs.length<_4bc){
ret=this._adjustNodeAndOffset(rs,_4bc);
rs=ret.node;
_4bc=ret.offset;
}
txt=rs.nodeValue;
_4b6=doc.createTextNode(txt.substring(0,_4bc));
var _4c3=txt.substring(_4bc);
if(_4c3!==""){
_4b7=doc.createTextNode(txt.substring(_4bc));
}
_4b8=doc.createElement("span");
_4b9=doc.createTextNode(".");
_4b8.appendChild(_4b9);
if(_4b6.length){
_435.place(_4b6,rs,"after");
}else{
_4b6=rs;
}
_435.place(_4b8,_4b6,"after");
if(_4b7){
_435.place(_4b7,_4b8,"after");
}
_435.destroy(rs);
var _4c8=_442.create(this.window);
_4c8.setStart(_4b9,0);
_4c8.setEnd(_4b9,_4b9.length);
_4b4.removeAllRanges();
_4b4.addRange(_4c8);
doc.execCommand(_4b3);
_435.place(_4b8.firstChild,_4b8,"before");
_435.destroy(_4b8);
_4c8.setStart(_4b9,0);
_4c8.setEnd(_4b9,_4b9.length);
_4b4.removeAllRanges();
_4b4.addRange(_4c8);
this._sCall("collapse",[false]);
_4b9.parentNode.innerHTML="";
return true;
}
}
}else{
return false;
}
},_adaptIEList:function(_4cb){
var _4cc=_442.getSelection(this.window);
if(_4cc.isCollapsed){
if(_4cc.rangeCount&&!this.queryCommandValue(_4cb)){
var _4cd=_4cc.getRangeAt(0);
var sc=_4cd.startContainer;
if(sc&&sc.nodeType==3){
if(!_4cd.startOffset){
var _4ce="ul";
if(_4cb==="insertorderedlist"){
_4ce="ol";
}
var list=this.document.createElement(_4ce);
var li=_435.create("li",null,list);
_435.place(list,sc,"before");
li.appendChild(sc);
_435.create("br",null,list,"after");
var _4cf=_442.create(this.window);
_4cf.setStart(sc,0);
_4cf.setEnd(sc,sc.length);
_4cc.removeAllRanges();
_4cc.addRange(_4cf);
this._sCall("collapse",[true]);
return true;
}
}
}
}
return false;
},_handleTextColorOrProperties:function(_4d0,_4d1){
var _4d2=_442.getSelection(this.window);
var doc=this.document;
var rs,ret,_4d3,txt,_4d4,_4d5,_4d6,_4d7;
_4d1=_4d1||null;
if(_4d0&&_4d2&&_4d2.isCollapsed){
if(_4d2.rangeCount){
_4d3=_4d2.getRangeAt(0);
rs=_4d3.startContainer;
if(rs&&rs.nodeType===3){
var _4d8=_4d3.startOffset;
if(rs.length<_4d8){
ret=this._adjustNodeAndOffset(rs,_4d8);
rs=ret.node;
_4d8=ret.offset;
}
txt=rs.nodeValue;
_4d4=doc.createTextNode(txt.substring(0,_4d8));
var _4d9=txt.substring(_4d8);
if(_4d9!==""){
_4d5=doc.createTextNode(txt.substring(_4d8));
}
_4d6=doc.createElement("span");
_4d7=doc.createTextNode(".");
_4d6.appendChild(_4d7);
var _4da=doc.createElement("span");
_4d6.appendChild(_4da);
if(_4d4.length){
_435.place(_4d4,rs,"after");
}else{
_4d4=rs;
}
_435.place(_4d6,_4d4,"after");
if(_4d5){
_435.place(_4d5,_4d6,"after");
}
_435.destroy(rs);
var _4db=_442.create(this.window);
_4db.setStart(_4d7,0);
_4db.setEnd(_4d7,_4d7.length);
_4d2.removeAllRanges();
_4d2.addRange(_4db);
if(has("webkit")){
var _4dc="color";
if(_4d0==="hilitecolor"||_4d0==="backcolor"){
_4dc="backgroundColor";
}
_437.set(_4d6,_4dc,_4d1);
this._sCall("remove",[]);
_435.destroy(_4da);
_4d6.innerHTML="&#160;";
this._sCall("selectElement",[_4d6]);
this.focus();
}else{
this.execCommand(_4d0,_4d1);
_435.place(_4d6.firstChild,_4d6,"before");
_435.destroy(_4d6);
_4db.setStart(_4d7,0);
_4db.setEnd(_4d7,_4d7.length);
_4d2.removeAllRanges();
_4d2.addRange(_4db);
this._sCall("collapse",[false]);
_4d7.parentNode.removeChild(_4d7);
}
return true;
}
}
}
return false;
},_adjustNodeAndOffset:function(node,_4dd){
while(node.length<_4dd&&node.nextSibling&&node.nextSibling.nodeType===3){
_4dd=_4dd-node.length;
node=node.nextSibling;
}
return {"node":node,"offset":_4dd};
},_tagNamesForCommand:function(_4de){
if(_4de==="bold"){
return ["b","strong"];
}else{
if(_4de==="italic"){
return ["i","em"];
}else{
if(_4de==="strikethrough"){
return ["s","strike"];
}else{
if(_4de==="superscript"){
return ["sup"];
}else{
if(_4de==="subscript"){
return ["sub"];
}else{
if(_4de==="underline"){
return ["u"];
}
}
}
}
}
}
return [];
},_stripBreakerNodes:function(node){
if(!this.isLoaded){
return;
}
_43a(".ieFormatBreakerSpan",node).forEach(function(b){
while(b.firstChild){
_435.place(b.firstChild,b,"before");
}
_435.destroy(b);
});
return node;
}});
return _446;
});
},"dojo/dnd/Moveable":function(){
define(["../_base/array","../_base/declare","../_base/event","../_base/lang","../dom","../dom-class","../Evented","../on","../topic","../touch","./common","./Mover","../_base/window"],function(_4df,_4e0,_4e1,lang,dom,_4e2,_4e3,on,_4e4,_4e5,dnd,_4e6,win){
var _4e7=_4e0("dojo.dnd.Moveable",[_4e3],{handle:"",delay:0,skip:false,constructor:function(node,_4e8){
this.node=dom.byId(node);
if(!_4e8){
_4e8={};
}
this.handle=_4e8.handle?dom.byId(_4e8.handle):null;
if(!this.handle){
this.handle=this.node;
}
this.delay=_4e8.delay>0?_4e8.delay:0;
this.skip=_4e8.skip;
this.mover=_4e8.mover?_4e8.mover:_4e6;
this.events=[on(this.handle,_4e5.press,lang.hitch(this,"onMouseDown")),on(this.handle,"dragstart",lang.hitch(this,"onSelectStart")),on(this.handle,"selectstart",lang.hitch(this,"onSelectStart"))];
},markupFactory:function(_4e9,node,Ctor){
return new Ctor(node,_4e9);
},destroy:function(){
_4df.forEach(this.events,function(_4ea){
_4ea.remove();
});
this.events=this.node=this.handle=null;
},onMouseDown:function(e){
if(this.skip&&dnd.isFormElement(e)){
return;
}
if(this.delay){
this.events.push(on(this.handle,_4e5.move,lang.hitch(this,"onMouseMove")),on(this.handle,_4e5.release,lang.hitch(this,"onMouseUp")));
this._lastX=e.pageX;
this._lastY=e.pageY;
}else{
this.onDragDetected(e);
}
_4e1.stop(e);
},onMouseMove:function(e){
if(Math.abs(e.pageX-this._lastX)>this.delay||Math.abs(e.pageY-this._lastY)>this.delay){
this.onMouseUp(e);
this.onDragDetected(e);
}
_4e1.stop(e);
},onMouseUp:function(e){
for(var i=0;i<2;++i){
this.events.pop().remove();
}
_4e1.stop(e);
},onSelectStart:function(e){
if(!this.skip||!dnd.isFormElement(e)){
_4e1.stop(e);
}
},onDragDetected:function(e){
new this.mover(this.node,e,this);
},onMoveStart:function(_4eb){
_4e4.publish("/dnd/move/start",_4eb);
_4e2.add(win.body(),"dojoMove");
_4e2.add(this.node,"dojoMoveItem");
},onMoveStop:function(_4ec){
_4e4.publish("/dnd/move/stop",_4ec);
_4e2.remove(win.body(),"dojoMove");
_4e2.remove(this.node,"dojoMoveItem");
},onFirstMove:function(){
},onMove:function(_4ed,_4ee){
this.onMoving(_4ed,_4ee);
var s=_4ed.node.style;
s.left=_4ee.l+"px";
s.top=_4ee.t+"px";
this.onMoved(_4ed,_4ee);
},onMoving:function(){
},onMoved:function(){
}});
return _4e7;
});
},"dijit/TooltipDialog":function(){
define(["dojo/_base/declare","dojo/dom-class","dojo/_base/event","dojo/keys","dojo/_base/lang","./focus","./layout/ContentPane","./_DialogMixin","./form/_FormMixin","./_TemplatedMixin","dojo/text!./templates/TooltipDialog.html","./main"],function(_4ef,_4f0,_4f1,keys,lang,_4f2,_4f3,_4f4,_4f5,_4f6,_4f7,_4f8){
return _4ef("dijit.TooltipDialog",[_4f3,_4f6,_4f5,_4f4],{title:"",doLayout:false,autofocus:true,baseClass:"dijitTooltipDialog",_firstFocusItem:null,_lastFocusItem:null,templateString:_4f7,_setTitleAttr:function(_4f9){
this.containerNode.title=_4f9;
this._set("title",_4f9);
},postCreate:function(){
this.inherited(arguments);
this.connect(this.containerNode,"onkeypress","_onKey");
},orient:function(node,_4fa,_4fb){
var newC={"MR-ML":"dijitTooltipRight","ML-MR":"dijitTooltipLeft","TM-BM":"dijitTooltipAbove","BM-TM":"dijitTooltipBelow","BL-TL":"dijitTooltipBelow dijitTooltipABLeft","TL-BL":"dijitTooltipAbove dijitTooltipABLeft","BR-TR":"dijitTooltipBelow dijitTooltipABRight","TR-BR":"dijitTooltipAbove dijitTooltipABRight","BR-BL":"dijitTooltipRight","BL-BR":"dijitTooltipLeft"}[_4fa+"-"+_4fb];
_4f0.replace(this.domNode,newC,this._currentOrientClass||"");
this._currentOrientClass=newC;
},focus:function(){
this._getFocusItems(this.containerNode);
_4f2.focus(this._firstFocusItem);
},onOpen:function(pos){
this.orient(this.domNode,pos.aroundCorner,pos.corner);
var _4fc=pos.aroundNodePos;
if(pos.corner.charAt(0)=="M"&&pos.aroundCorner.charAt(0)=="M"){
this.connectorNode.style.top=_4fc.y+((_4fc.h-this.connectorNode.offsetHeight)>>1)-pos.y+"px";
this.connectorNode.style.left="";
}else{
if(pos.corner.charAt(1)=="M"&&pos.aroundCorner.charAt(1)=="M"){
this.connectorNode.style.left=_4fc.x+((_4fc.w-this.connectorNode.offsetWidth)>>1)-pos.x+"px";
}
}
this._onShow();
},onClose:function(){
this.onHide();
},_onKey:function(evt){
var node=evt.target;
if(evt.charOrCode===keys.TAB){
this._getFocusItems(this.containerNode);
}
var _4fd=(this._firstFocusItem==this._lastFocusItem);
if(evt.charOrCode==keys.ESCAPE){
this.defer("onCancel");
_4f1.stop(evt);
}else{
if(node==this._firstFocusItem&&evt.shiftKey&&evt.charOrCode===keys.TAB){
if(!_4fd){
_4f2.focus(this._lastFocusItem);
}
_4f1.stop(evt);
}else{
if(node==this._lastFocusItem&&evt.charOrCode===keys.TAB&&!evt.shiftKey){
if(!_4fd){
_4f2.focus(this._firstFocusItem);
}
_4f1.stop(evt);
}else{
if(evt.charOrCode===keys.TAB){
evt.stopPropagation();
}
}
}
}
}});
});
},"dojo/store/util/SimpleQueryEngine":function(){
define(["../../_base/array"],function(_4fe){
return function(_4ff,_500){
switch(typeof _4ff){
default:
throw new Error("Can not query with a "+typeof _4ff);
case "object":
case "undefined":
var _501=_4ff;
_4ff=function(_502){
for(var key in _501){
var _503=_501[key];
if(_503&&_503.test){
if(!_503.test(_502[key],_502)){
return false;
}
}else{
if(_503!=_502[key]){
return false;
}
}
}
return true;
};
break;
case "string":
if(!this[_4ff]){
throw new Error("No filter function "+_4ff+" was found in store");
}
_4ff=this[_4ff];
case "function":
}
function _504(_505){
var _506=_4fe.filter(_505,_4ff);
var _507=_500&&_500.sort;
if(_507){
_506.sort(typeof _507=="function"?_507:function(a,b){
for(var sort,i=0;sort=_507[i];i++){
var _508=a[sort.attribute];
var _509=b[sort.attribute];
if(_508!=_509){
return !!sort.descending==(_508==null||_508>_509)?-1:1;
}
}
return 0;
});
}
if(_500&&(_500.start||_500.count)){
var _50a=_506.length;
_506=_506.slice(_500.start||0,(_500.start||0)+(_500.count||Infinity));
_506.total=_50a;
}
return _506;
};
_504.matches=_4ff;
return _504;
};
});
},"dijit/form/_ExpandingTextAreaMixin":function(){
define(["dojo/_base/declare","dojo/dom-construct","dojo/has","dojo/_base/lang","dojo/on","dojo/_base/window","../Viewport"],function(_50b,_50c,has,lang,on,win,_50d){
has.add("textarea-needs-help-shrinking",function(){
var body=win.body(),te=_50c.create("textarea",{rows:"5",cols:"20",value:" ",style:{zoom:1,fontSize:"12px",height:"96px",overflow:"hidden",visibility:"hidden",position:"absolute",border:"5px solid white",margin:"0",padding:"0",boxSizing:"border-box",MsBoxSizing:"border-box",WebkitBoxSizing:"border-box",MozBoxSizing:"border-box"}},body,"last");
var _50e=te.scrollHeight>=te.clientHeight;
body.removeChild(te);
return _50e;
});
return _50b("dijit.form._ExpandingTextAreaMixin",null,{_setValueAttr:function(){
this.inherited(arguments);
this.resize();
},postCreate:function(){
this.inherited(arguments);
var _50f=this.textbox;
_50f.style.overflowY="hidden";
this.own(on(_50f,"focus, resize",lang.hitch(this,"_resizeLater")));
},startup:function(){
this.inherited(arguments);
this.own(_50d.on("resize",lang.hitch(this,"_resizeLater")));
this._resizeLater();
},_onInput:function(e){
this.inherited(arguments);
this.resize();
},_estimateHeight:function(){
var _510=this.textbox;
_510.rows=(_510.value.match(/\n/g)||[]).length+1;
},_resizeLater:function(){
this.defer("resize");
},resize:function(){
var _511=this.textbox;
function _512(){
var _513=false;
if(_511.value===""){
_511.value=" ";
_513=true;
}
var sh=_511.scrollHeight;
if(_513){
_511.value="";
}
return sh;
};
if(_511.style.overflowY=="hidden"){
_511.scrollTop=0;
}
if(this.busyResizing){
return;
}
this.busyResizing=true;
if(_512()||_511.offsetHeight){
var newH=_512()+Math.max(_511.offsetHeight-_511.clientHeight,0);
var _514=newH+"px";
if(_514!=_511.style.height){
_511.style.height=_514;
_511.rows=1;
}
if(has("textarea-needs-help-shrinking")){
var _515=_512(),_516=_515,_517=_511.style.minHeight,_518=4,_519,_51a=_511.scrollTop;
_511.style.minHeight=_514;
_511.style.height="auto";
while(newH>0){
_511.style.minHeight=Math.max(newH-_518,4)+"px";
_519=_512();
var _51b=_516-_519;
newH-=_51b;
if(_51b<_518){
break;
}
_516=_519;
_518<<=1;
}
_511.style.height=newH+"px";
_511.style.minHeight=_517;
_511.scrollTop=_51a;
}
_511.style.overflowY=_512()>_511.clientHeight?"auto":"hidden";
if(_511.style.overflowY=="hidden"){
_511.scrollTop=0;
}
}else{
this._estimateHeight();
}
this.busyResizing=false;
}});
});
},"dijit/MenuItem":function(){
define(["dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/_base/kernel","dojo/sniff","./_Widget","./_TemplatedMixin","./_Contained","./_CssStateMixin","dojo/text!./templates/MenuItem.html"],function(_51c,dom,_51d,_51e,_51f,has,_520,_521,_522,_523,_524){
return _51c("dijit.MenuItem",[_520,_521,_522,_523],{templateString:_524,baseClass:"dijitMenuItem",label:"",_setLabelAttr:function(val){
this.containerNode.innerHTML=val;
this._set("label",val);
if(this.textDir==="auto"){
this.applyTextDir(this.focusNode,this.label);
}
},iconClass:"dijitNoIcon",_setIconClassAttr:{node:"iconNode",type:"class"},accelKey:"",disabled:false,_fillContent:function(_525){
if(_525&&!("label" in this.params)){
this.set("label",_525.innerHTML);
}
},buildRendering:function(){
this.inherited(arguments);
var _526=this.id+"_text";
_51d.set(this.containerNode,"id",_526);
if(this.accelKeyNode){
_51d.set(this.accelKeyNode,"id",this.id+"_accel");
_526+=" "+this.id+"_accel";
}
this.domNode.setAttribute("aria-labelledby",_526);
dom.setSelectable(this.domNode,false);
},onClick:function(){
},focus:function(){
try{
if(has("ie")==8){
this.containerNode.focus();
}
this.focusNode.focus();
}
catch(e){
}
},_onFocus:function(){
this._setSelected(true);
this.getParent()._onItemFocus(this);
this.inherited(arguments);
},_setSelected:function(_527){
_51e.toggle(this.domNode,"dijitMenuItemSelected",_527);
},setLabel:function(_528){
_51f.deprecated("dijit.MenuItem.setLabel() is deprecated.  Use set('label', ...) instead.","","2.0");
this.set("label",_528);
},setDisabled:function(_529){
_51f.deprecated("dijit.Menu.setDisabled() is deprecated.  Use set('disabled', bool) instead.","","2.0");
this.set("disabled",_529);
},_setDisabledAttr:function(_52a){
this.focusNode.setAttribute("aria-disabled",_52a?"true":"false");
this._set("disabled",_52a);
},_setAccelKeyAttr:function(_52b){
this.accelKeyNode.style.display=_52b?"":"none";
this.accelKeyNode.innerHTML=_52b;
_51d.set(this.containerNode,"colSpan",_52b?"1":"2");
this._set("accelKey",_52b);
},_setTextDirAttr:function(_52c){
if(!this._created||this.textDir!=_52c){
this._set("textDir",_52c);
this.applyTextDir(this.focusNode,this.label);
}
}});
});
},"dijit/MenuBarItem":function(){
define(["dojo/_base/declare","./MenuItem","dojo/text!./templates/MenuBarItem.html"],function(_52d,_52e,_52f){
var _530=_52d("dijit._MenuBarItemMixin",null,{templateString:_52f,_setIconClassAttr:null});
var _531=_52d("dijit.MenuBarItem",[_52e,_530],{});
_531._MenuBarItemMixin=_530;
return _531;
});
},"dijit/layout/TabController":function(){
define(["dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/i18n","dojo/_base/lang","./StackController","../registry","../Menu","../MenuItem","dojo/text!./templates/_TabButton.html","dojo/i18n!../nls/common"],function(_532,dom,_533,_534,i18n,lang,_535,_536,Menu,_537,_538){
var _539=_532("dijit.layout._TabButton",_535.StackButton,{baseClass:"dijitTab",cssStateNodes:{closeNode:"dijitTabCloseButton"},templateString:_538,scrollOnFocus:false,buildRendering:function(){
this.inherited(arguments);
dom.setSelectable(this.containerNode,false);
},startup:function(){
this.inherited(arguments);
var n=this.domNode;
this.defer(function(){
n.className=n.className;
},1);
},_setCloseButtonAttr:function(disp){
this._set("closeButton",disp);
_534.toggle(this.domNode,"dijitClosable",disp);
this.closeNode.style.display=disp?"":"none";
if(disp){
var _53a=i18n.getLocalization("dijit","common");
if(this.closeNode){
_533.set(this.closeNode,"title",_53a.itemClose);
}
}
},_setDisabledAttr:function(_53b){
this.inherited(arguments);
if(this.closeNode){
if(_53b){
_533.remove(this.closeNode,"title");
}else{
var _53c=i18n.getLocalization("dijit","common");
_533.set(this.closeNode,"title",_53c.itemClose);
}
}
},_setLabelAttr:function(_53d){
this.inherited(arguments);
if(!this.showLabel&&!this.params.title){
this.iconNode.alt=lang.trim(this.containerNode.innerText||this.containerNode.textContent||"");
}
}});
var _53e=_532("dijit.layout.TabController",_535,{baseClass:"dijitTabController",templateString:"<div role='tablist' data-dojo-attach-event='onkeypress:onkeypress'></div>",tabPosition:"top",buttonWidget:_539,buttonWidgetCloseClass:"dijitTabCloseButton",postCreate:function(){
this.inherited(arguments);
var _53f=new Menu({id:this.id+"_Menu",ownerDocument:this.ownerDocument,dir:this.dir,lang:this.lang,textDir:this.textDir,targetNodeIds:[this.domNode],selector:function(node){
return _534.contains(node,"dijitClosable")&&!_534.contains(node,"dijitTabDisabled");
}});
this.own(_53f);
var _540=i18n.getLocalization("dijit","common"),_541=this;
_53f.addChild(new _537({label:_540.itemClose,ownerDocument:this.ownerDocument,dir:this.dir,lang:this.lang,textDir:this.textDir,onClick:function(evt){
var _542=_536.byNode(this.getParent().currentTarget);
_541.onCloseButtonClick(_542.page);
}}));
}});
_53e.TabButton=_539;
return _53e;
});
},"dojo/cldr/supplemental":function(){
define(["../_base/lang","../i18n"],function(lang,i18n){
var _543={};
lang.setObject("dojo.cldr.supplemental",_543);
_543.getFirstDayOfWeek=function(_544){
var _545={bd:5,mv:5,ae:6,af:6,bh:6,dj:6,dz:6,eg:6,iq:6,ir:6,jo:6,kw:6,ly:6,ma:6,om:6,qa:6,sa:6,sd:6,sy:6,ye:6,ag:0,ar:0,as:0,au:0,br:0,bs:0,bt:0,bw:0,by:0,bz:0,ca:0,cn:0,co:0,dm:0,"do":0,et:0,gt:0,gu:0,hk:0,hn:0,id:0,ie:0,il:0,"in":0,jm:0,jp:0,ke:0,kh:0,kr:0,la:0,mh:0,mm:0,mo:0,mt:0,mx:0,mz:0,ni:0,np:0,nz:0,pa:0,pe:0,ph:0,pk:0,pr:0,py:0,sg:0,sv:0,th:0,tn:0,tt:0,tw:0,um:0,us:0,ve:0,vi:0,ws:0,za:0,zw:0};
var _546=_543._region(_544);
var dow=_545[_546];
return (dow===undefined)?1:dow;
};
_543._region=function(_547){
_547=i18n.normalizeLocale(_547);
var tags=_547.split("-");
var _548=tags[1];
if(!_548){
_548={de:"de",en:"us",es:"es",fi:"fi",fr:"fr",he:"il",hu:"hu",it:"it",ja:"jp",ko:"kr",nl:"nl",pt:"br",sv:"se",zh:"cn"}[tags[0]];
}else{
if(_548.length==4){
_548=tags[2];
}
}
return _548;
};
_543.getWeekend=function(_549){
var _54a={"in":0,af:4,dz:4,ir:4,om:4,sa:4,ye:4,ae:5,bh:5,eg:5,il:5,iq:5,jo:5,kw:5,ly:5,ma:5,qa:5,sd:5,sy:5,tn:5},_54b={af:5,dz:5,ir:5,om:5,sa:5,ye:5,ae:6,bh:5,eg:6,il:6,iq:6,jo:6,kw:6,ly:6,ma:6,qa:6,sd:6,sy:6,tn:6},_54c=_543._region(_549),_54d=_54a[_54c],end=_54b[_54c];
if(_54d===undefined){
_54d=6;
}
if(end===undefined){
end=0;
}
return {start:_54d,end:end};
};
return _543;
});
},"dijit/MenuBar":function(){
require({cache:{"url:dijit/templates/MenuBar.html":"<div class=\"dijitMenuBar dijitMenuPassive\" data-dojo-attach-point=\"containerNode\"  role=\"menubar\" tabIndex=\"${tabIndex}\" data-dojo-attach-event=\"onkeypress: _onKeyPress\"></div>\n"}});
define("dijit/MenuBar",["dojo/_base/declare","dojo/_base/event","dojo/keys","./_MenuBase","dojo/text!./templates/MenuBar.html"],function(_54e,_54f,keys,_550,_551){
return _54e("dijit.MenuBar",_550,{templateString:_551,baseClass:"dijitMenuBar",_isMenuBar:true,postCreate:function(){
this.inherited(arguments);
var l=this.isLeftToRight();
this.connectKeyNavHandlers(l?[keys.LEFT_ARROW]:[keys.RIGHT_ARROW],l?[keys.RIGHT_ARROW]:[keys.LEFT_ARROW]);
this._orient=["below"];
},_moveToPopup:function(evt){
if(this.focusedChild&&this.focusedChild.popup&&!this.focusedChild.disabled){
this.onItemClick(this.focusedChild,evt);
}
},focusChild:function(item){
var _552=this.focusedChild,_553=_552&&_552.popup&&_552.popup.isShowingNow;
this.inherited(arguments);
if(_553&&item.popup&&!item.disabled){
this._openPopup(true);
}
},_onKeyPress:function(evt){
if(evt.ctrlKey||evt.altKey){
return;
}
switch(evt.charOrCode){
case keys.DOWN_ARROW:
this._moveToPopup(evt);
_54f.stop(evt);
}
},onItemClick:function(item,evt){
if(item.popup&&item.popup.isShowingNow&&(evt.type!=="keypress"||evt.keyCode!==keys.DOWN_ARROW)){
item.popup.onCancel();
}else{
this.inherited(arguments);
}
}});
});
},"dijit/ToolbarSeparator":function(){
define("dijit/ToolbarSeparator",["dojo/_base/declare","dojo/dom","./_Widget","./_TemplatedMixin"],function(_554,dom,_555,_556){
return _554("dijit.ToolbarSeparator",[_555,_556],{templateString:"<div class=\"dijitToolbarSeparator dijitInline\" role=\"presentation\"></div>",buildRendering:function(){
this.inherited(arguments);
dom.setSelectable(this.domNode,false);
},isFocusable:function(){
return false;
}});
});
},"dijit/layout/StackController":function(){
define(["dojo/_base/array","dojo/_base/declare","dojo/dom-class","dojo/_base/event","dojo/keys","dojo/_base/lang","dojo/on","../focus","../registry","../_Widget","../_TemplatedMixin","../_Container","../form/ToggleButton","dojo/i18n!../nls/common"],function(_557,_558,_559,_55a,keys,lang,on,_55b,_55c,_55d,_55e,_55f,_560){
var _561=_558("dijit.layout._StackButton",_560,{tabIndex:"-1",closeButton:false,_aria_attr:"aria-selected",buildRendering:function(evt){
this.inherited(arguments);
(this.focusNode||this.domNode).setAttribute("role","tab");
}});
var _562=_558("dijit.layout.StackController",[_55d,_55e,_55f],{baseClass:"dijitStackController",templateString:"<span role='tablist' data-dojo-attach-event='onkeypress'></span>",containerId:"",buttonWidget:_561,buttonWidgetCloseClass:"dijitStackCloseButton",constructor:function(_563){
this.pane2button={};
},postCreate:function(){
this.inherited(arguments);
this.subscribe(this.containerId+"-startup","onStartup");
this.subscribe(this.containerId+"-addChild","onAddChild");
this.subscribe(this.containerId+"-removeChild","onRemoveChild");
this.subscribe(this.containerId+"-selectChild","onSelectChild");
this.subscribe(this.containerId+"-containerKeyPress","onContainerKeyPress");
this.connect(this.containerNode,"click",function(evt){
var _564=_55c.getEnclosingWidget(evt.target);
if(_564!=this.containerNode&&!_564.disabled&&_564.page){
for(var _565=evt.target;_565!==this.containerNode;_565=_565.parentNode){
if(_559.contains(_565,this.buttonWidgetCloseClass)){
this.onCloseButtonClick(_564.page);
break;
}else{
if(_565==_564.domNode){
this.onButtonClick(_564.page);
break;
}
}
}
}
});
},onStartup:function(info){
_557.forEach(info.children,this.onAddChild,this);
if(info.selected){
this.onSelectChild(info.selected);
}
var _566=_55c.byId(this.containerId).containerNode,_567=this.pane2button,_568={"title":"label","showtitle":"showLabel","iconclass":"iconClass","closable":"closeButton","tooltip":"title","disabled":"disabled"},_569=function(attr,_56a){
return on(_566,"attrmodified-"+attr,function(evt){
var _56b=_567[evt.detail&&evt.detail.widget&&evt.detail.widget.id];
if(_56b){
_56b.set(_56a,evt.detail.newValue);
}
});
};
for(var attr in _568){
this.own(_569(attr,_568[attr]));
}
},destroy:function(){
for(var pane in this.pane2button){
this.onRemoveChild(_55c.byId(pane));
}
this.inherited(arguments);
},onAddChild:function(page,_56c){
var Cls=lang.isString(this.buttonWidget)?lang.getObject(this.buttonWidget):this.buttonWidget;
var _56d=new Cls({id:this.id+"_"+page.id,name:this.id+"_"+page.id,label:page.title,disabled:page.disabled,ownerDocument:this.ownerDocument,dir:page.dir,lang:page.lang,textDir:page.textDir,showLabel:page.showTitle,iconClass:page.iconClass,closeButton:page.closable,title:page.tooltip,page:page});
this.addChild(_56d,_56c);
this.pane2button[page.id]=_56d;
page.controlButton=_56d;
if(!this._currentChild){
this.onSelectChild(page);
}
},onRemoveChild:function(page){
if(this._currentChild===page){
this._currentChild=null;
}
var _56e=this.pane2button[page.id];
if(_56e){
this.removeChild(_56e);
delete this.pane2button[page.id];
_56e.destroy();
}
delete page.controlButton;
},onSelectChild:function(page){
if(!page){
return;
}
if(this._currentChild){
var _56f=this.pane2button[this._currentChild.id];
_56f.set("checked",false);
_56f.focusNode.setAttribute("tabIndex","-1");
}
var _570=this.pane2button[page.id];
_570.set("checked",true);
this._currentChild=page;
_570.focusNode.setAttribute("tabIndex","0");
var _571=_55c.byId(this.containerId);
_571.containerNode.setAttribute("aria-labelledby",_570.id);
},onButtonClick:function(page){
var _572=this.pane2button[page.id];
_55b.focus(_572.focusNode);
if(this._currentChild&&this._currentChild.id===page.id){
_572.set("checked",true);
}
var _573=_55c.byId(this.containerId);
_573.selectChild(page);
},onCloseButtonClick:function(page){
var _574=_55c.byId(this.containerId);
_574.closeChild(page);
if(this._currentChild){
var b=this.pane2button[this._currentChild.id];
if(b){
_55b.focus(b.focusNode||b.domNode);
}
}
},adjacent:function(_575){
if(!this.isLeftToRight()&&(!this.tabPosition||/top|bottom/.test(this.tabPosition))){
_575=!_575;
}
var _576=this.getChildren();
var idx=_557.indexOf(_576,this.pane2button[this._currentChild.id]),_577=_576[idx];
var _578;
do{
idx=(idx+(_575?1:_576.length-1))%_576.length;
_578=_576[idx];
}while(_578.disabled&&_578!=_577);
return _578;
},onkeypress:function(e){
if(this.disabled||e.altKey){
return;
}
var _579=null;
if(e.ctrlKey||!e._djpage){
switch(e.charOrCode){
case keys.LEFT_ARROW:
case keys.UP_ARROW:
if(!e._djpage){
_579=false;
}
break;
case keys.PAGE_UP:
if(e.ctrlKey){
_579=false;
}
break;
case keys.RIGHT_ARROW:
case keys.DOWN_ARROW:
if(!e._djpage){
_579=true;
}
break;
case keys.PAGE_DOWN:
if(e.ctrlKey){
_579=true;
}
break;
case keys.HOME:
var _57a=this.getChildren();
for(var idx=0;idx<_57a.length;idx++){
var _57b=_57a[idx];
if(!_57b.disabled){
this.onButtonClick(_57b.page);
break;
}
}
_55a.stop(e);
break;
case keys.END:
var _57a=this.getChildren();
for(var idx=_57a.length-1;idx>=0;idx--){
var _57b=_57a[idx];
if(!_57b.disabled){
this.onButtonClick(_57b.page);
break;
}
}
_55a.stop(e);
break;
case keys.DELETE:
if(this._currentChild.closable){
this.onCloseButtonClick(this._currentChild);
}
_55a.stop(e);
break;
default:
if(e.ctrlKey){
if(e.charOrCode===keys.TAB){
this.onButtonClick(this.adjacent(!e.shiftKey).page);
_55a.stop(e);
}else{
if(e.charOrCode=="w"){
if(this._currentChild.closable){
this.onCloseButtonClick(this._currentChild);
}
_55a.stop(e);
}
}
}
}
if(_579!==null){
this.onButtonClick(this.adjacent(_579).page);
_55a.stop(e);
}
}
},onContainerKeyPress:function(info){
info.e._djpage=info.page;
this.onkeypress(info.e);
}});
_562.StackButton=_561;
return _562;
});
},"url:dijit/templates/TooltipDialog.html":"<div role=\"presentation\" tabIndex=\"-1\">\n\t<div class=\"dijitTooltipContainer\" role=\"presentation\">\n\t\t<div class =\"dijitTooltipContents dijitTooltipFocusNode\" data-dojo-attach-point=\"containerNode\" role=\"dialog\"></div>\n\t</div>\n\t<div class=\"dijitTooltipConnector\" role=\"presentation\" data-dojo-attach-point=\"connectorNode\"></div>\n</div>\n","dojo/dnd/Mover":function(){
define(["../_base/array","../_base/declare","../_base/event","../_base/lang","../sniff","../_base/window","../dom","../dom-geometry","../dom-style","../Evented","../on","../touch","./common","./autoscroll"],function(_57c,_57d,_57e,lang,has,win,dom,_57f,_580,_581,on,_582,dnd,_583){
return _57d("dojo.dnd.Mover",[_581],{constructor:function(node,e,host){
this.node=dom.byId(node);
this.marginBox={l:e.pageX,t:e.pageY};
this.mouseButton=e.button;
var h=(this.host=host),d=node.ownerDocument;
this.events=[on(d,_582.move,lang.hitch(this,"onFirstMove")),on(d,_582.move,lang.hitch(this,"onMouseMove")),on(d,_582.release,lang.hitch(this,"onMouseUp")),on(d,"dragstart",_57e.stop),on(d.body,"selectstart",_57e.stop)];
_583.autoScrollStart(d);
if(h&&h.onMoveStart){
h.onMoveStart(this);
}
},onMouseMove:function(e){
_583.autoScroll(e);
var m=this.marginBox;
this.host.onMove(this,{l:m.l+e.pageX,t:m.t+e.pageY},e);
_57e.stop(e);
},onMouseUp:function(e){
if(has("webkit")&&has("mac")&&this.mouseButton==2?e.button==0:this.mouseButton==e.button){
this.destroy();
}
_57e.stop(e);
},onFirstMove:function(e){
var s=this.node.style,l,t,h=this.host;
switch(s.position){
case "relative":
case "absolute":
l=Math.round(parseFloat(s.left))||0;
t=Math.round(parseFloat(s.top))||0;
break;
default:
s.position="absolute";
var m=_57f.getMarginBox(this.node);
var b=win.doc.body;
var bs=_580.getComputedStyle(b);
var bm=_57f.getMarginBox(b,bs);
var bc=_57f.getContentBox(b,bs);
l=m.l-(bc.l-bm.l);
t=m.t-(bc.t-bm.t);
break;
}
this.marginBox.l=l-this.marginBox.l;
this.marginBox.t=t-this.marginBox.t;
if(h&&h.onFirstMove){
h.onFirstMove(this,e);
}
this.events.shift().remove();
},destroy:function(){
_57c.forEach(this.events,function(_584){
_584.remove();
});
var h=this.host;
if(h&&h.onMoveStop){
h.onMoveStop(this);
}
this.events=this.node=this.host=null;
}});
});
},"dijit/form/HorizontalRule":function(){
define(["dojo/_base/declare","../_Widget","../_TemplatedMixin"],function(_585,_586,_587){
return _585("dijit.form.HorizontalRule",[_586,_587],{templateString:"<div class=\"dijitRuleContainer dijitRuleContainerH\"></div>",count:3,container:"containerNode",ruleStyle:"",_positionPrefix:"<div class=\"dijitRuleMark dijitRuleMarkH\" style=\"left:",_positionSuffix:"%;",_suffix:"\"></div>",_genHTML:function(pos){
return this._positionPrefix+pos+this._positionSuffix+this.ruleStyle+this._suffix;
},_isHorizontal:true,buildRendering:function(){
this.inherited(arguments);
var _588;
if(this.count==1){
_588=this._genHTML(50,0);
}else{
var i;
var _589=100/(this.count-1);
if(!this._isHorizontal||this.isLeftToRight()){
_588=this._genHTML(0,0);
for(i=1;i<this.count-1;i++){
_588+=this._genHTML(_589*i,i);
}
_588+=this._genHTML(100,this.count-1);
}else{
_588=this._genHTML(100,0);
for(i=1;i<this.count-1;i++){
_588+=this._genHTML(100-_589*i,i);
}
_588+=this._genHTML(0,this.count-1);
}
}
this.domNode.innerHTML=_588;
}});
});
},"dijit/layout/TabContainer":function(){
define(["dojo/_base/lang","dojo/_base/declare","./_TabContainerBase","./TabController","./ScrollingTabController"],function(lang,_58a,_58b,_58c,_58d){
return _58a("dijit.layout.TabContainer",_58b,{useMenu:true,useSlider:true,controllerWidget:"",_makeController:function(_58e){
var cls=this.baseClass+"-tabs"+(this.doLayout?"":" dijitTabNoLayout"),_58c=typeof this.controllerWidget=="string"?lang.getObject(this.controllerWidget):this.controllerWidget;
return new _58c({id:this.id+"_tablist",ownerDocument:this.ownerDocument,dir:this.dir,lang:this.lang,textDir:this.textDir,tabPosition:this.tabPosition,doLayout:this.doLayout,containerId:this.id,"class":cls,nested:this.nested,useMenu:this.useMenu,useSlider:this.useSlider,tabStripClass:this.tabStrip?this.baseClass+(this.tabStrip?"":"No")+"Strip":null},_58e);
},postMixInProperties:function(){
this.inherited(arguments);
if(!this.controllerWidget){
this.controllerWidget=(this.tabPosition=="top"||this.tabPosition=="bottom")&&!this.nested?_58d:_58c;
}
}});
});
},"url:dijit/templates/Menu.html":"<table class=\"dijit dijitMenu dijitMenuPassive dijitReset dijitMenuTable\" role=\"menu\" tabIndex=\"${tabIndex}\"\n\t   data-dojo-attach-event=\"onkeypress:_onKeyPress\" cellspacing=\"0\">\n\t<tbody class=\"dijitReset\" data-dojo-attach-point=\"containerNode\"></tbody>\n</table>\n","dijit/form/_Spinner":function(){
define(["dojo/_base/declare","dojo/_base/event","dojo/keys","dojo/_base/lang","dojo/sniff","dojo/mouse","../typematic","./RangeBoundTextBox","dojo/text!./templates/Spinner.html","./_TextBoxMixin"],function(_58f,_590,keys,lang,has,_591,_592,_593,_594,_595){
return _58f("dijit.form._Spinner",_593,{defaultTimeout:500,minimumTimeout:10,timeoutChangeRate:0.9,smallDelta:1,largeDelta:10,templateString:_594,baseClass:"dijitTextBox dijitSpinner",cssStateNodes:{"upArrowNode":"dijitUpArrowButton","downArrowNode":"dijitDownArrowButton"},adjust:function(val){
return val;
},_arrowPressed:function(_596,_597,_598){
if(this.disabled||this.readOnly){
return;
}
this._setValueAttr(this.adjust(this.get("value"),_597*_598),false);
_595.selectInputText(this.textbox,this.textbox.value.length);
},_arrowReleased:function(){
this._wheelTimer=null;
},_typematicCallback:function(_599,node,evt){
var inc=this.smallDelta;
if(node==this.textbox){
var key=evt.charOrCode;
inc=(key==keys.PAGE_UP||key==keys.PAGE_DOWN)?this.largeDelta:this.smallDelta;
node=(key==keys.UP_ARROW||key==keys.PAGE_UP)?this.upArrowNode:this.downArrowNode;
}
if(_599==-1){
this._arrowReleased(node);
}else{
this._arrowPressed(node,(node==this.upArrowNode)?1:-1,inc);
}
},_wheelTimer:null,_mouseWheeled:function(evt){
_590.stop(evt);
var _59a=evt.wheelDelta/120;
if(Math.floor(_59a)!=_59a){
_59a=evt.wheelDelta>0?1:-1;
}
var _59b=evt.detail?(evt.detail*-1):_59a;
if(_59b!==0){
var node=this[(_59b>0?"upArrowNode":"downArrowNode")];
this._arrowPressed(node,_59b,this.smallDelta);
if(this._wheelTimer){
this._wheelTimer.remove();
}
this._wheelTimer=this.defer(function(){
this._arrowReleased(node);
},50);
}
},_setConstraintsAttr:function(_59c){
this.inherited(arguments);
if(this.focusNode){
if(this.constraints.min!==undefined){
this.focusNode.setAttribute("aria-valuemin",this.constraints.min);
}else{
this.focusNode.removeAttribute("aria-valuemin");
}
if(this.constraints.max!==undefined){
this.focusNode.setAttribute("aria-valuemax",this.constraints.max);
}else{
this.focusNode.removeAttribute("aria-valuemax");
}
}
},_setValueAttr:function(_59d,_59e){
this.focusNode.setAttribute("aria-valuenow",_59d);
this.inherited(arguments);
},postCreate:function(){
this.inherited(arguments);
this.connect(this.domNode,_591.wheel,"_mouseWheeled");
this.own(_592.addListener(this.upArrowNode,this.textbox,{charOrCode:keys.UP_ARROW,ctrlKey:false,altKey:false,shiftKey:false,metaKey:false},this,"_typematicCallback",this.timeoutChangeRate,this.defaultTimeout,this.minimumTimeout),_592.addListener(this.downArrowNode,this.textbox,{charOrCode:keys.DOWN_ARROW,ctrlKey:false,altKey:false,shiftKey:false,metaKey:false},this,"_typematicCallback",this.timeoutChangeRate,this.defaultTimeout,this.minimumTimeout),_592.addListener(this.upArrowNode,this.textbox,{charOrCode:keys.PAGE_UP,ctrlKey:false,altKey:false,shiftKey:false,metaKey:false},this,"_typematicCallback",this.timeoutChangeRate,this.defaultTimeout,this.minimumTimeout),_592.addListener(this.downArrowNode,this.textbox,{charOrCode:keys.PAGE_DOWN,ctrlKey:false,altKey:false,shiftKey:false,metaKey:false},this,"_typematicCallback",this.timeoutChangeRate,this.defaultTimeout,this.minimumTimeout));
}});
});
},"dijit/form/Button":function(){
define(["require","dojo/_base/declare","dojo/dom-class","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/ready","./_FormWidget","./_ButtonMixin","dojo/text!./templates/Button.html"],function(_59f,_5a0,_5a1,has,_5a2,lang,_5a3,_5a4,_5a5,_5a6){
if(has("dijit-legacy-requires")){
_5a3(0,function(){
var _5a7=["dijit/form/DropDownButton","dijit/form/ComboButton","dijit/form/ToggleButton"];
_59f(_5a7);
});
}
return _5a0("dijit.form.Button",[_5a4,_5a5],{showLabel:true,iconClass:"dijitNoIcon",_setIconClassAttr:{node:"iconNode",type:"class"},baseClass:"dijitButton",templateString:_5a6,_setValueAttr:"valueNode",_onClick:function(e){
var ok=this.inherited(arguments);
if(ok){
if(this.valueNode){
this.valueNode.click();
e.preventDefault();
e.stopPropagation();
}
}
return ok;
},_fillContent:function(_5a8){
if(_5a8&&(!this.params||!("label" in this.params))){
var _5a9=lang.trim(_5a8.innerHTML);
if(_5a9){
this.label=_5a9;
}
}
},_setShowLabelAttr:function(val){
if(this.containerNode){
_5a1.toggle(this.containerNode,"dijitDisplayNone",!val);
}
this._set("showLabel",val);
},setLabel:function(_5aa){
_5a2.deprecated("dijit.form.Button.setLabel() is deprecated.  Use set('label', ...) instead.","","2.0");
this.set("label",_5aa);
},_setLabelAttr:function(_5ab){
this.inherited(arguments);
if(!this.showLabel&&!("title" in this.params)){
this.titleNode.title=lang.trim(this.containerNode.innerText||this.containerNode.textContent||"");
}
}});
});
},"url:dijit/layout/templates/TabContainer.html":"<div class=\"dijitTabContainer\">\n\t<div class=\"dijitTabListWrapper\" data-dojo-attach-point=\"tablistNode\"></div>\n\t<div data-dojo-attach-point=\"tablistSpacer\" class=\"dijitTabSpacer ${baseClass}-spacer\"></div>\n\t<div class=\"dijitTabPaneWrapper ${baseClass}-container\" data-dojo-attach-point=\"containerNode\"></div>\n</div>\n","dojo/dnd/move":function(){
define(["../_base/declare","../dom-geometry","../dom-style","./common","./Mover","./Moveable"],function(_5ac,_5ad,_5ae,dnd,_5af,_5b0){
var _5b1=_5ac("dojo.dnd.move.constrainedMoveable",_5b0,{constraints:function(){
},within:false,constructor:function(node,_5b2){
if(!_5b2){
_5b2={};
}
this.constraints=_5b2.constraints;
this.within=_5b2.within;
},onFirstMove:function(_5b3){
var c=this.constraintBox=this.constraints.call(this,_5b3);
c.r=c.l+c.w;
c.b=c.t+c.h;
if(this.within){
var mb=_5ad.getMarginSize(_5b3.node);
c.r-=mb.w;
c.b-=mb.h;
}
},onMove:function(_5b4,_5b5){
var c=this.constraintBox,s=_5b4.node.style;
this.onMoving(_5b4,_5b5);
_5b5.l=_5b5.l<c.l?c.l:c.r<_5b5.l?c.r:_5b5.l;
_5b5.t=_5b5.t<c.t?c.t:c.b<_5b5.t?c.b:_5b5.t;
s.left=_5b5.l+"px";
s.top=_5b5.t+"px";
this.onMoved(_5b4,_5b5);
}});
var _5b6=_5ac("dojo.dnd.move.boxConstrainedMoveable",_5b1,{box:{},constructor:function(node,_5b7){
var box=_5b7&&_5b7.box;
this.constraints=function(){
return box;
};
}});
var _5b8=_5ac("dojo.dnd.move.parentConstrainedMoveable",_5b1,{area:"content",constructor:function(node,_5b9){
var area=_5b9&&_5b9.area;
this.constraints=function(){
var n=this.node.parentNode,s=_5ae.getComputedStyle(n),mb=_5ad.getMarginBox(n,s);
if(area=="margin"){
return mb;
}
var t=_5ad.getMarginExtents(n,s);
mb.l+=t.l,mb.t+=t.t,mb.w-=t.w,mb.h-=t.h;
if(area=="border"){
return mb;
}
t=_5ad.getBorderExtents(n,s);
mb.l+=t.l,mb.t+=t.t,mb.w-=t.w,mb.h-=t.h;
if(area=="padding"){
return mb;
}
t=_5ad.getPadExtents(n,s);
mb.l+=t.l,mb.t+=t.t,mb.w-=t.w,mb.h-=t.h;
return mb;
};
}});
return {constrainedMoveable:_5b1,boxConstrainedMoveable:_5b6,parentConstrainedMoveable:_5b8};
});
},"dijit/layout/_TabContainerBase":function(){
define(["dojo/text!./templates/TabContainer.html","./StackContainer","./utils","../_TemplatedMixin","dojo/_base/declare","dojo/dom-class","dojo/dom-geometry","dojo/dom-style"],function(_5ba,_5bb,_5bc,_5bd,_5be,_5bf,_5c0,_5c1){
return _5be("dijit.layout._TabContainerBase",[_5bb,_5bd],{tabPosition:"top",baseClass:"dijitTabContainer",tabStrip:false,nested:false,templateString:_5ba,postMixInProperties:function(){
this.baseClass+=this.tabPosition.charAt(0).toUpperCase()+this.tabPosition.substr(1).replace(/-.*/,"");
this.srcNodeRef&&_5c1.set(this.srcNodeRef,"visibility","hidden");
this.inherited(arguments);
},buildRendering:function(){
this.inherited(arguments);
this.tablist=this._makeController(this.tablistNode);
if(!this.doLayout){
_5bf.add(this.domNode,"dijitTabContainerNoLayout");
}
if(this.nested){
_5bf.add(this.domNode,"dijitTabContainerNested");
_5bf.add(this.tablist.containerNode,"dijitTabContainerTabListNested");
_5bf.add(this.tablistSpacer,"dijitTabContainerSpacerNested");
_5bf.add(this.containerNode,"dijitTabPaneWrapperNested");
}else{
_5bf.add(this.domNode,"tabStrip-"+(this.tabStrip?"enabled":"disabled"));
}
},_setupChild:function(tab){
_5bf.add(tab.domNode,"dijitTabPane");
this.inherited(arguments);
},startup:function(){
if(this._started){
return;
}
this.tablist.startup();
this.inherited(arguments);
},layout:function(){
if(!this._contentBox||typeof (this._contentBox.l)=="undefined"){
return;
}
var sc=this.selectedChildWidget;
if(this.doLayout){
var _5c2=this.tabPosition.replace(/-h/,"");
this.tablist.layoutAlign=_5c2;
var _5c3=[this.tablist,{domNode:this.tablistSpacer,layoutAlign:_5c2},{domNode:this.containerNode,layoutAlign:"client"}];
_5bc.layoutChildren(this.domNode,this._contentBox,_5c3);
this._containerContentBox=_5bc.marginBox2contentBox(this.containerNode,_5c3[2]);
if(sc&&sc.resize){
sc.resize(this._containerContentBox);
}
}else{
if(this.tablist.resize){
var s=this.tablist.domNode.style;
s.width="0";
var _5c4=_5c0.getContentBox(this.domNode).w;
s.width="";
this.tablist.resize({w:_5c4});
}
if(sc&&sc.resize){
sc.resize();
}
}
},destroy:function(){
if(this.tablist){
this.tablist.destroy();
}
this.inherited(arguments);
}});
});
},"dijit/form/Form":function(){
define(["dojo/_base/declare","dojo/dom-attr","dojo/_base/event","dojo/_base/kernel","dojo/sniff","../_Widget","../_TemplatedMixin","./_FormMixin","../layout/_ContentPaneResizeMixin"],function(_5c5,_5c6,_5c7,_5c8,has,_5c9,_5ca,_5cb,_5cc){
return _5c5("dijit.form.Form",[_5c9,_5ca,_5cb,_5cc],{name:"",action:"",method:"",encType:"","accept-charset":"",accept:"",target:"",templateString:"<form data-dojo-attach-point='containerNode' data-dojo-attach-event='onreset:_onReset,onsubmit:_onSubmit' ${!nameAttrSetting}></form>",postMixInProperties:function(){
this.nameAttrSetting=this.name?("name='"+this.name+"'"):"";
this.inherited(arguments);
},execute:function(){
},onExecute:function(){
},_setEncTypeAttr:function(_5cd){
this.encType=_5cd;
_5c6.set(this.domNode,"encType",_5cd);
if(has("ie")){
this.domNode.encoding=_5cd;
}
},reset:function(e){
var faux={returnValue:true,preventDefault:function(){
this.returnValue=false;
},stopPropagation:function(){
},currentTarget:e?e.target:this.domNode,target:e?e.target:this.domNode};
if(!(this.onReset(faux)===false)&&faux.returnValue){
this.inherited(arguments,[]);
}
},onReset:function(){
return true;
},_onReset:function(e){
this.reset(e);
_5c7.stop(e);
return false;
},_onSubmit:function(e){
var fp=this.constructor.prototype;
if(this.execute!=fp.execute||this.onExecute!=fp.onExecute){
_5c8.deprecated("dijit.form.Form:execute()/onExecute() are deprecated. Use onSubmit() instead.","","2.0");
this.onExecute();
this.execute(this.getValues());
}
if(this.onSubmit(e)===false){
_5c7.stop(e);
}
},onSubmit:function(){
return this.isValid();
},submit:function(){
if(!(this.onSubmit()===false)){
this.containerNode.submit();
}
}});
});
},"dojo/store/Memory":function(){
define(["../_base/declare","./util/QueryResults","./util/SimpleQueryEngine"],function(_5ce,_5cf,_5d0){
var base=null;
return _5ce("dojo.store.Memory",base,{constructor:function(_5d1){
for(var i in _5d1){
this[i]=_5d1[i];
}
this.setData(this.data||[]);
},data:null,idProperty:"id",index:null,queryEngine:_5d0,get:function(id){
return this.data[this.index[id]];
},getIdentity:function(_5d2){
return _5d2[this.idProperty];
},put:function(_5d3,_5d4){
var data=this.data,_5d5=this.index,_5d6=this.idProperty;
var id=_5d3[_5d6]=(_5d4&&"id" in _5d4)?_5d4.id:_5d6 in _5d3?_5d3[_5d6]:Math.random();
if(id in _5d5){
if(_5d4&&_5d4.overwrite===false){
throw new Error("Object already exists");
}
data[_5d5[id]]=_5d3;
}else{
_5d5[id]=data.push(_5d3)-1;
}
return id;
},add:function(_5d7,_5d8){
(_5d8=_5d8||{}).overwrite=false;
return this.put(_5d7,_5d8);
},remove:function(id){
var _5d9=this.index;
var data=this.data;
if(id in _5d9){
data.splice(_5d9[id],1);
this.setData(data);
return true;
}
},query:function(_5da,_5db){
return _5cf(this.queryEngine(_5da,_5db)(this.data));
},setData:function(data){
if(data.items){
this.idProperty=data.identifier;
data=this.data=data.items;
}else{
this.data=data;
}
this.index={};
for(var i=0,l=data.length;i<l;i++){
this.index[data[i][this.idProperty]]=i;
}
}});
});
},"url:dijit/templates/Tooltip.html":"<div class=\"dijitTooltip dijitTooltipLeft\" id=\"dojoTooltip\"\n\t><div class=\"dijitTooltipContainer dijitTooltipContents\" data-dojo-attach-point=\"containerNode\" role='alert'></div\n\t><div class=\"dijitTooltipConnector\" data-dojo-attach-point=\"connectorNode\"></div\n></div>\n","dijit/Editor":function(){
define(["require","dojo/_base/array","dojo/_base/declare","dojo/_base/Deferred","dojo/i18n","dojo/dom-attr","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/event","dojo/keys","dojo/_base/lang","dojo/sniff","dojo/string","dojo/topic","dojo/_base/window","./_base/focus","./_Container","./Toolbar","./ToolbarSeparator","./layout/_LayoutWidget","./form/ToggleButton","./_editor/_Plugin","./_editor/plugins/EnterKeyHandling","./_editor/html","./_editor/range","./_editor/RichText","./main","dojo/i18n!./_editor/nls/commands"],function(_5dc,_5dd,_5de,_5df,i18n,_5e0,_5e1,_5e2,_5e3,_5e4,keys,lang,has,_5e5,_5e6,win,_5e7,_5e8,_5e9,_5ea,_5eb,_5ec,_5ed,_5ee,html,_5ef,_5f0,_5f1){
var _5f2=_5de("dijit.Editor",_5f0,{plugins:null,extraPlugins:null,constructor:function(){
if(!lang.isArray(this.plugins)){
this.plugins=["undo","redo","|","cut","copy","paste","|","bold","italic","underline","strikethrough","|","insertOrderedList","insertUnorderedList","indent","outdent","|","justifyLeft","justifyRight","justifyCenter","justifyFull",_5ee];
}
this._plugins=[];
this._editInterval=this.editActionInterval*1000;
if(has("ie")){
this.events.push("onBeforeDeactivate");
this.events.push("onBeforeActivate");
}
},postMixInProperties:function(){
this.setValueDeferred=new _5df();
this.inherited(arguments);
},postCreate:function(){
this._steps=this._steps.slice(0);
this._undoedSteps=this._undoedSteps.slice(0);
if(lang.isArray(this.extraPlugins)){
this.plugins=this.plugins.concat(this.extraPlugins);
}
this.inherited(arguments);
this.commands=i18n.getLocalization("dijit._editor","commands",this.lang);
if(!this.toolbar){
this.toolbar=new _5e9({ownerDocument:this.ownerDocument,dir:this.dir,lang:this.lang});
this.header.appendChild(this.toolbar.domNode);
}
_5dd.forEach(this.plugins,this.addPlugin,this);
this.setValueDeferred.resolve(true);
_5e1.add(this.iframe.parentNode,"dijitEditorIFrameContainer");
_5e1.add(this.iframe,"dijitEditorIFrame");
_5e0.set(this.iframe,"allowTransparency",true);
if(has("webkit")){
_5e3.set(this.domNode,"KhtmlUserSelect","none");
}
this.toolbar.startup();
this.onNormalizedDisplayChanged();
},destroy:function(){
_5dd.forEach(this._plugins,function(p){
if(p&&p.destroy){
p.destroy();
}
});
this._plugins=[];
this.toolbar.destroyRecursive();
delete this.toolbar;
this.inherited(arguments);
},addPlugin:function(_5f3,_5f4){
var args=lang.isString(_5f3)?{name:_5f3}:lang.isFunction(_5f3)?{ctor:_5f3}:_5f3;
if(!args.setEditor){
var o={"args":args,"plugin":null,"editor":this};
if(args.name){
if(_5ed.registry[args.name]){
o.plugin=_5ed.registry[args.name](args);
}else{
_5e6.publish(_5f1._scopeName+".Editor.getPlugin",o);
}
}
if(!o.plugin){
try{
var pc=args.ctor||lang.getObject(args.name)||_5dc(args.name);
if(pc){
o.plugin=new pc(args);
}
}
catch(e){
throw new Error(this.id+": cannot find plugin ["+args.name+"]");
}
}
if(!o.plugin){
throw new Error(this.id+": cannot find plugin ["+args.name+"]");
}
_5f3=o.plugin;
}
if(arguments.length>1){
this._plugins[_5f4]=_5f3;
}else{
this._plugins.push(_5f3);
}
_5f3.setEditor(this);
if(lang.isFunction(_5f3.setToolbar)){
_5f3.setToolbar(this.toolbar);
}
},resize:function(size){
if(size){
_5eb.prototype.resize.apply(this,arguments);
}
},layout:function(){
var _5f5=(this._contentBox.h-(this.getHeaderHeight()+this.getFooterHeight()+_5e2.getPadBorderExtents(this.iframe.parentNode).h+_5e2.getMarginExtents(this.iframe.parentNode).h));
this.editingArea.style.height=_5f5+"px";
if(this.iframe){
this.iframe.style.height="100%";
}
this._layoutMode=true;
},_onIEMouseDown:function(e){
var _5f6;
var b=this.document.body;
var _5f7=b.clientWidth;
var _5f8=b.clientHeight;
var _5f9=b.clientLeft;
var _5fa=b.offsetWidth;
var _5fb=b.offsetHeight;
var _5fc=b.offsetLeft;
if(/^rtl$/i.test(b.dir||"")){
if(_5f7<_5fa&&e.x>_5f7&&e.x<_5fa){
_5f6=true;
}
}else{
if(e.x<_5f9&&e.x>_5fc){
_5f6=true;
}
}
if(!_5f6){
if(_5f8<_5fb&&e.y>_5f8&&e.y<_5fb){
_5f6=true;
}
}
if(!_5f6){
delete this._cursorToStart;
delete this._savedSelection;
if(e.target.tagName=="BODY"){
this.defer("placeCursorAtEnd");
}
this.inherited(arguments);
}
},onBeforeActivate:function(){
this._restoreSelection();
},onBeforeDeactivate:function(e){
if(this.customUndo){
this.endEditing(true);
}
if(e.target.tagName!="BODY"){
this._saveSelection();
}
},customUndo:true,editActionInterval:3,beginEditing:function(cmd){
if(!this._inEditing){
this._inEditing=true;
this._beginEditing(cmd);
}
if(this.editActionInterval>0){
if(this._editTimer){
this._editTimer.remove();
}
this._editTimer=this.defer("endEditing",this._editInterval);
}
},_steps:[],_undoedSteps:[],execCommand:function(cmd){
if(this.customUndo&&(cmd=="undo"||cmd=="redo")){
return this[cmd]();
}else{
if(this.customUndo){
this.endEditing();
this._beginEditing();
}
var r=this.inherited(arguments);
if(this.customUndo){
this._endEditing();
}
return r;
}
},_pasteImpl:function(){
return this._clipboardCommand("paste");
},_cutImpl:function(){
return this._clipboardCommand("cut");
},_copyImpl:function(){
return this._clipboardCommand("copy");
},_clipboardCommand:function(cmd){
var r;
try{
r=this.document.execCommand(cmd,false,null);
if(has("webkit")&&!r){
throw {code:1011};
}
}
catch(e){
if(e.code==1011||(e.code==9&&has("opera"))){
var sub=_5e5.substitute,_5fd={cut:"X",copy:"C",paste:"V"};
alert(sub(this.commands.systemShortcut,[this.commands[cmd],sub(this.commands[has("mac")?"appleKey":"ctrlKey"],[_5fd[cmd]])]));
}
r=false;
}
return r;
},queryCommandEnabled:function(cmd){
if(this.customUndo&&(cmd=="undo"||cmd=="redo")){
return cmd=="undo"?(this._steps.length>1):(this._undoedSteps.length>0);
}else{
return this.inherited(arguments);
}
},_moveToBookmark:function(b){
var _5fe=b.mark;
var mark=b.mark;
var col=b.isCollapsed;
var r,_5ff,_600,sel;
if(mark){
if(has("ie")<9){
if(lang.isArray(mark)){
_5fe=[];
_5dd.forEach(mark,function(n){
_5fe.push(_5ef.getNode(n,this.editNode));
},this);
win.withGlobal(this.window,"moveToBookmark",_5e7,[{mark:_5fe,isCollapsed:col}]);
}else{
if(mark.startContainer&&mark.endContainer){
sel=_5ef.getSelection(this.window);
if(sel&&sel.removeAllRanges){
sel.removeAllRanges();
r=_5ef.create(this.window);
_5ff=_5ef.getNode(mark.startContainer,this.editNode);
_600=_5ef.getNode(mark.endContainer,this.editNode);
if(_5ff&&_600){
r.setStart(_5ff,mark.startOffset);
r.setEnd(_600,mark.endOffset);
sel.addRange(r);
}
}
}
}
}else{
sel=_5ef.getSelection(this.window);
if(sel&&sel.removeAllRanges){
sel.removeAllRanges();
r=_5ef.create(this.window);
_5ff=_5ef.getNode(mark.startContainer,this.editNode);
_600=_5ef.getNode(mark.endContainer,this.editNode);
if(_5ff&&_600){
r.setStart(_5ff,mark.startOffset);
r.setEnd(_600,mark.endOffset);
sel.addRange(r);
}
}
}
}
},_changeToStep:function(from,to){
this.setValue(to.text);
var b=to.bookmark;
if(!b){
return;
}
this._moveToBookmark(b);
},undo:function(){
var ret=false;
if(!this._undoRedoActive){
this._undoRedoActive=true;
this.endEditing(true);
var s=this._steps.pop();
if(s&&this._steps.length>0){
this.focus();
this._changeToStep(s,this._steps[this._steps.length-1]);
this._undoedSteps.push(s);
this.onDisplayChanged();
delete this._undoRedoActive;
ret=true;
}
delete this._undoRedoActive;
}
return ret;
},redo:function(){
var ret=false;
if(!this._undoRedoActive){
this._undoRedoActive=true;
this.endEditing(true);
var s=this._undoedSteps.pop();
if(s&&this._steps.length>0){
this.focus();
this._changeToStep(this._steps[this._steps.length-1],s);
this._steps.push(s);
this.onDisplayChanged();
ret=true;
}
delete this._undoRedoActive;
}
return ret;
},endEditing:function(_601){
if(this._editTimer){
this._editTimer=this._editTimer.remove();
}
if(this._inEditing){
this._endEditing(_601);
this._inEditing=false;
}
},_getBookmark:function(){
var b=win.withGlobal(this.window,_5e7.getBookmark);
var tmp=[];
if(b&&b.mark){
var mark=b.mark;
if(has("ie")<9){
var sel=_5ef.getSelection(this.window);
if(!lang.isArray(mark)){
if(sel){
var _602;
if(sel.rangeCount){
_602=sel.getRangeAt(0);
}
if(_602){
b.mark=_602.cloneRange();
}else{
b.mark=win.withGlobal(this.window,_5e7.getBookmark);
}
}
}else{
_5dd.forEach(b.mark,function(n){
tmp.push(_5ef.getIndex(n,this.editNode).o);
},this);
b.mark=tmp;
}
}
try{
if(b.mark&&b.mark.startContainer){
tmp=_5ef.getIndex(b.mark.startContainer,this.editNode).o;
b.mark={startContainer:tmp,startOffset:b.mark.startOffset,endContainer:b.mark.endContainer===b.mark.startContainer?tmp:_5ef.getIndex(b.mark.endContainer,this.editNode).o,endOffset:b.mark.endOffset};
}
}
catch(e){
b.mark=null;
}
}
return b;
},_beginEditing:function(){
if(this._steps.length===0){
this._steps.push({"text":html.getChildrenHtml(this.editNode),"bookmark":this._getBookmark()});
}
},_endEditing:function(){
var v=html.getChildrenHtml(this.editNode);
this._undoedSteps=[];
this._steps.push({text:v,bookmark:this._getBookmark()});
},onKeyDown:function(e){
if(!has("ie")&&!this.iframe&&e.keyCode==keys.TAB&&!this.tabIndent){
this._saveSelection();
}
if(!this.customUndo){
this.inherited(arguments);
return;
}
var k=e.keyCode;
if(e.ctrlKey&&!e.altKey){
if(k==90||k==122){
_5e4.stop(e);
this.undo();
return;
}else{
if(k==89||k==121){
_5e4.stop(e);
this.redo();
return;
}
}
}
this.inherited(arguments);
switch(k){
case keys.ENTER:
case keys.BACKSPACE:
case keys.DELETE:
this.beginEditing();
break;
case 88:
case 86:
if(e.ctrlKey&&!e.altKey&&!e.metaKey){
this.endEditing();
if(e.keyCode==88){
this.beginEditing("cut");
}else{
this.beginEditing("paste");
}
this.defer("endEditing",1);
break;
}
default:
if(!e.ctrlKey&&!e.altKey&&!e.metaKey&&(e.keyCode<keys.F1||e.keyCode>keys.F15)){
this.beginEditing();
break;
}
case keys.ALT:
this.endEditing();
break;
case keys.UP_ARROW:
case keys.DOWN_ARROW:
case keys.LEFT_ARROW:
case keys.RIGHT_ARROW:
case keys.HOME:
case keys.END:
case keys.PAGE_UP:
case keys.PAGE_DOWN:
this.endEditing(true);
break;
case keys.CTRL:
case keys.SHIFT:
case keys.TAB:
break;
}
},_onBlur:function(){
this.inherited(arguments);
this.endEditing(true);
},_saveSelection:function(){
try{
this._savedSelection=this._getBookmark();
}
catch(e){
}
},_restoreSelection:function(){
if(this._savedSelection){
delete this._cursorToStart;
if(win.withGlobal(this.window,"isCollapsed",_5e7)){
this._moveToBookmark(this._savedSelection);
}
delete this._savedSelection;
}
},onClick:function(){
this.endEditing(true);
this.inherited(arguments);
},replaceValue:function(html){
if(!this.customUndo){
this.inherited(arguments);
}else{
if(this.isClosed){
this.setValue(html);
}else{
this.beginEditing();
if(!html){
html="&#160;";
}
this.setValue(html);
this.endEditing();
}
}
},_setDisabledAttr:function(_603){
this.setValueDeferred.then(lang.hitch(this,function(){
if((!this.disabled&&_603)||(!this._buttonEnabledPlugins&&_603)){
_5dd.forEach(this._plugins,function(p){
p.set("disabled",true);
});
}else{
if(this.disabled&&!_603){
_5dd.forEach(this._plugins,function(p){
p.set("disabled",false);
});
}
}
}));
this.inherited(arguments);
},_setStateClass:function(){
try{
this.inherited(arguments);
if(this.document&&this.document.body){
_5e3.set(this.document.body,"color",_5e3.get(this.iframe,"color"));
}
}
catch(e){
}
}});
function _604(args){
return new _5ed({command:args.name});
};
function _605(args){
return new _5ed({buttonClass:_5ec,command:args.name});
};
lang.mixin(_5ed.registry,{"undo":_604,"redo":_604,"cut":_604,"copy":_604,"paste":_604,"insertOrderedList":_604,"insertUnorderedList":_604,"indent":_604,"outdent":_604,"justifyCenter":_604,"justifyFull":_604,"justifyLeft":_604,"justifyRight":_604,"delete":_604,"selectAll":_604,"removeFormat":_604,"unlink":_604,"insertHorizontalRule":_604,"bold":_605,"italic":_605,"underline":_605,"strikethrough":_605,"subscript":_605,"superscript":_605,"|":function(){
return new _5ed({setEditor:function(_606){
this.editor=_606;
this.button=new _5ea({ownerDocument:_606.ownerDocument});
}});
}});
return _5f2;
});
},"dijit/Toolbar":function(){
define(["require","dojo/_base/declare","dojo/has","dojo/keys","dojo/ready","./_Widget","./_KeyNavContainer","./_TemplatedMixin"],function(_607,_608,has,keys,_609,_60a,_60b,_60c){
if(has("dijit-legacy-requires")){
_609(0,function(){
var _60d=["dijit/ToolbarSeparator"];
_607(_60d);
});
}
return _608("dijit.Toolbar",[_60a,_60c,_60b],{templateString:"<div class=\"dijit\" role=\"toolbar\" tabIndex=\"${tabIndex}\" data-dojo-attach-point=\"containerNode\">"+"</div>",baseClass:"dijitToolbar",postCreate:function(){
this.inherited(arguments);
this.connectKeyNavHandlers(this.isLeftToRight()?[keys.LEFT_ARROW]:[keys.RIGHT_ARROW],this.isLeftToRight()?[keys.RIGHT_ARROW]:[keys.LEFT_ARROW]);
}});
});
},"dijit/layout/StackContainer":function(){
define(["dojo/_base/array","dojo/cookie","dojo/_base/declare","dojo/dom-class","dojo/has","dojo/_base/lang","dojo/ready","dojo/topic","../registry","../_WidgetBase","./_LayoutWidget","dojo/i18n!../nls/common"],function(_60e,_60f,_610,_611,has,lang,_612,_613,_614,_615,_616){
if(has("dijit-legacy-requires")){
_612(0,function(){
var _617=["dijit/layout/StackController"];
require(_617);
});
}
var _618=_610("dijit.layout.StackContainer",_616,{doLayout:true,persist:false,baseClass:"dijitStackContainer",buildRendering:function(){
this.inherited(arguments);
_611.add(this.domNode,"dijitLayoutContainer");
this.containerNode.setAttribute("role","tabpanel");
},postCreate:function(){
this.inherited(arguments);
this.connect(this.domNode,"onkeypress",this._onKeyPress);
},startup:function(){
if(this._started){
return;
}
var _619=this.getChildren();
_60e.forEach(_619,this._setupChild,this);
if(this.persist){
this.selectedChildWidget=_614.byId(_60f(this.id+"_selectedChild"));
}else{
_60e.some(_619,function(_61a){
if(_61a.selected){
this.selectedChildWidget=_61a;
}
return _61a.selected;
},this);
}
var _61b=this.selectedChildWidget;
if(!_61b&&_619[0]){
_61b=this.selectedChildWidget=_619[0];
_61b.selected=true;
}
_613.publish(this.id+"-startup",{children:_619,selected:_61b});
this.inherited(arguments);
},resize:function(){
if(!this._hasBeenShown){
this._hasBeenShown=true;
var _61c=this.selectedChildWidget;
if(_61c){
this._showChild(_61c);
}
}
this.inherited(arguments);
},_setupChild:function(_61d){
this.inherited(arguments);
_611.replace(_61d.domNode,"dijitHidden","dijitVisible");
_61d.domNode.title="";
},addChild:function(_61e,_61f){
this.inherited(arguments);
if(this._started){
_613.publish(this.id+"-addChild",_61e,_61f);
this.layout();
if(!this.selectedChildWidget){
this.selectChild(_61e);
}
}
},removeChild:function(page){
this.inherited(arguments);
if(this._started){
_613.publish(this.id+"-removeChild",page);
}
if(this._descendantsBeingDestroyed){
return;
}
if(this.selectedChildWidget===page){
this.selectedChildWidget=undefined;
if(this._started){
var _620=this.getChildren();
if(_620.length){
this.selectChild(_620[0]);
}
}
}
if(this._started){
this.layout();
}
},selectChild:function(page,_621){
page=_614.byId(page);
if(this.selectedChildWidget!=page){
var d=this._transition(page,this.selectedChildWidget,_621);
this._set("selectedChildWidget",page);
_613.publish(this.id+"-selectChild",page);
if(this.persist){
_60f(this.id+"_selectedChild",this.selectedChildWidget.id);
}
}
return d;
},_transition:function(_622,_623){
if(_623){
this._hideChild(_623);
}
var d=this._showChild(_622);
if(_622.resize){
if(this.doLayout){
_622.resize(this._containerContentBox||this._contentBox);
}else{
_622.resize();
}
}
return d;
},_adjacent:function(_624){
var _625=this.getChildren();
var _626=_60e.indexOf(_625,this.selectedChildWidget);
_626+=_624?1:_625.length-1;
return _625[_626%_625.length];
},forward:function(){
return this.selectChild(this._adjacent(true),true);
},back:function(){
return this.selectChild(this._adjacent(false),true);
},_onKeyPress:function(e){
_613.publish(this.id+"-containerKeyPress",{e:e,page:this});
},layout:function(){
var _627=this.selectedChildWidget;
if(_627&&_627.resize){
if(this.doLayout){
_627.resize(this._containerContentBox||this._contentBox);
}else{
_627.resize();
}
}
},_showChild:function(page){
var _628=this.getChildren();
page.isFirstChild=(page==_628[0]);
page.isLastChild=(page==_628[_628.length-1]);
page._set("selected",true);
_611.replace(page.domNode,"dijitVisible","dijitHidden");
return (page._onShow&&page._onShow())||true;
},_hideChild:function(page){
page._set("selected",false);
_611.replace(page.domNode,"dijitHidden","dijitVisible");
page.onHide&&page.onHide();
},closeChild:function(page){
var _629=page.onClose(this,page);
if(_629){
this.removeChild(page);
page.destroyRecursive();
}
},destroyDescendants:function(_62a){
this._descendantsBeingDestroyed=true;
this.selectedChildWidget=undefined;
_60e.forEach(this.getChildren(),function(_62b){
if(!_62a){
this.removeChild(_62b);
}
_62b.destroyRecursive(_62a);
},this);
this._descendantsBeingDestroyed=false;
}});
_618.ChildWidgetProperties={selected:false,disabled:false,closable:false,iconClass:"dijitNoIcon",showTitle:true};
lang.extend(_615,_618.ChildWidgetProperties);
return _618;
});
},"dojo/regexp":function(){
define(["./_base/kernel","./_base/lang"],function(dojo,lang){
var _62c={};
lang.setObject("dojo.regexp",_62c);
_62c.escapeString=function(str,_62d){
return str.replace(/([\.$?*|{}\(\)\[\]\\\/\+^])/g,function(ch){
if(_62d&&_62d.indexOf(ch)!=-1){
return ch;
}
return "\\"+ch;
});
};
_62c.buildGroupRE=function(arr,re,_62e){
if(!(arr instanceof Array)){
return re(arr);
}
var b=[];
for(var i=0;i<arr.length;i++){
b.push(re(arr[i]));
}
return _62c.group(b.join("|"),_62e);
};
_62c.group=function(_62f,_630){
return "("+(_630?"?:":"")+_62f+")";
};
return _62c;
});
},"dijit/form/ComboBox":function(){
define(["dojo/_base/declare","./ValidationTextBox","./ComboBoxMixin"],function(_631,_632,_633){
return _631("dijit.form.ComboBox",[_632,_633],{});
});
},"dijit/_editor/plugins/LinkDialog":function(){
define(["require","dojo/_base/declare","dojo/dom-attr","dojo/keys","dojo/_base/lang","dojo/sniff","dojo/_base/query","dojo/string","../../_Widget","../_Plugin","../../form/DropDownButton","../range"],function(_634,_635,_636,keys,lang,has,_637,_638,_639,_63a,_63b,_63c){
var _63d=_635("dijit._editor.plugins.LinkDialog",_63a,{buttonClass:_63b,useDefaultCommand:false,urlRegExp:"((https?|ftps?|file)\\://|./|../|/|)(/[a-zA-Z]{1,1}:/|)(((?:(?:[\\da-zA-Z](?:[-\\da-zA-Z]{0,61}[\\da-zA-Z])?)\\.)*(?:[a-zA-Z](?:[-\\da-zA-Z]{0,80}[\\da-zA-Z])?)\\.?)|(((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){3}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])|(0[xX]0*[\\da-fA-F]?[\\da-fA-F]\\.){3}0[xX]0*[\\da-fA-F]?[\\da-fA-F]|(0+[0-3][0-7][0-7]\\.){3}0+[0-3][0-7][0-7]|(0|[1-9]\\d{0,8}|[1-3]\\d{9}|4[01]\\d{8}|42[0-8]\\d{7}|429[0-3]\\d{6}|4294[0-8]\\d{5}|42949[0-5]\\d{4}|429496[0-6]\\d{3}|4294967[01]\\d{2}|42949672[0-8]\\d|429496729[0-5])|0[xX]0*[\\da-fA-F]{1,8}|([\\da-fA-F]{1,4}\\:){7}[\\da-fA-F]{1,4}|([\\da-fA-F]{1,4}\\:){6}((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){3}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])))(\\:\\d+)?(/(?:[^?#\\s/]+/)*(?:[^?#\\s/]{0,}(?:\\?[^?#\\s/]*)?(?:#.*)?)?)?",emailRegExp:"<?(mailto\\:)([!#-'*+\\-\\/-9=?A-Z^-~]+[.])*[!#-'*+\\-\\/-9=?A-Z^-~]+"+"@"+"((?:(?:[\\da-zA-Z](?:[-\\da-zA-Z]{0,61}[\\da-zA-Z])?)\\.)+(?:[a-zA-Z](?:[-\\da-zA-Z]{0,6}[\\da-zA-Z])?)\\.?)|localhost|^[^-][a-zA-Z0-9_-]*>?",htmlTemplate:"<a href=\"${urlInput}\" _djrealurl=\"${urlInput}\""+" target=\"${targetSelect}\""+">${textInput}</a>",tag:"a",_hostRxp:/^((([^\[:]+):)?([^@]+)@)?(\[([^\]]+)\]|([^\[:]*))(:([0-9]+))?$/,_userAtRxp:/^([!#-'*+\-\/-9=?A-Z^-~]+[.])*[!#-'*+\-\/-9=?A-Z^-~]+@/i,linkDialogTemplate:["<table role='presentation'><tr><td>","<label for='${id}_urlInput'>${url}</label>","</td><td>","<input data-dojo-type='dijit.form.ValidationTextBox' required='true' "+"id='${id}_urlInput' name='urlInput' data-dojo-props='intermediateChanges:true'/>","</td></tr><tr><td>","<label for='${id}_textInput'>${text}</label>","</td><td>","<input data-dojo-type='dijit.form.ValidationTextBox' required='true' id='${id}_textInput' "+"name='textInput' data-dojo-props='intermediateChanges:true'/>","</td></tr><tr><td>","<label for='${id}_targetSelect'>${target}</label>","</td><td>","<select id='${id}_targetSelect' name='targetSelect' data-dojo-type='dijit.form.Select'>","<option selected='selected' value='_self'>${currentWindow}</option>","<option value='_blank'>${newWindow}</option>","<option value='_top'>${topWindow}</option>","<option value='_parent'>${parentWindow}</option>","</select>","</td></tr><tr><td colspan='2'>","<button data-dojo-type='dijit.form.Button' type='submit' id='${id}_setButton'>${set}</button>","<button data-dojo-type='dijit.form.Button' type='button' id='${id}_cancelButton'>${buttonCancel}</button>","</td></tr></table>"].join(""),_initButton:function(){
this.inherited(arguments);
this.button.loadDropDown=lang.hitch(this,"_loadDropDown");
this._connectTagEvents();
},_loadDropDown:function(_63e){
_634(["dojo/i18n","../../TooltipDialog","../../registry","../../form/Button","../../form/Select","../../form/ValidationTextBox","dojo/i18n!../../nls/common","dojo/i18n!../nls/LinkDialog"],lang.hitch(this,function(i18n,_63f,_640){
var _641=this;
this.tag=this.command=="insertImage"?"img":"a";
var _642=lang.delegate(i18n.getLocalization("dijit","common",this.lang),i18n.getLocalization("dijit._editor","LinkDialog",this.lang));
var _643=(this.dropDown=this.button.dropDown=new _63f({title:_642[this.command+"Title"],ownerDocument:this.editor.ownerDocument,dir:this.editor.dir,execute:lang.hitch(this,"setValue"),onOpen:function(){
_641._onOpenDialog();
_63f.prototype.onOpen.apply(this,arguments);
},onCancel:function(){
setTimeout(lang.hitch(_641,"_onCloseDialog"),0);
}}));
_642.urlRegExp=this.urlRegExp;
_642.id=_640.getUniqueId(this.editor.id);
this._uniqueId=_642.id;
this._setContent(_643.title+"<div style='border-bottom: 1px black solid;padding-bottom:2pt;margin-bottom:4pt'></div>"+_638.substitute(this.linkDialogTemplate,_642));
_643.startup();
this._urlInput=_640.byId(this._uniqueId+"_urlInput");
this._textInput=_640.byId(this._uniqueId+"_textInput");
this._setButton=_640.byId(this._uniqueId+"_setButton");
this.connect(_640.byId(this._uniqueId+"_cancelButton"),"onClick",function(){
this.dropDown.onCancel();
});
if(this._urlInput){
this.connect(this._urlInput,"onChange","_checkAndFixInput");
}
if(this._textInput){
this.connect(this._textInput,"onChange","_checkAndFixInput");
}
this._urlRegExp=new RegExp("^"+this.urlRegExp+"$","i");
this._emailRegExp=new RegExp("^"+this.emailRegExp+"$","i");
this._urlInput.isValid=lang.hitch(this,function(){
var _644=this._urlInput.get("value");
return this._urlRegExp.test(_644)||this._emailRegExp.test(_644);
});
this.connect(_643.domNode,"onkeypress",function(e){
if(e&&e.charOrCode==keys.ENTER&&!e.shiftKey&&!e.metaKey&&!e.ctrlKey&&!e.altKey){
if(!this._setButton.get("disabled")){
_643.onExecute();
_643.execute(_643.get("value"));
}
}
});
_63e();
}));
},_checkAndFixInput:function(){
var self=this;
var url=this._urlInput.get("value");
var _645=function(url){
var _646=false;
var _647=false;
if(url&&url.length>1){
url=lang.trim(url);
if(url.indexOf("mailto:")!==0){
if(url.indexOf("/")>0){
if(url.indexOf("://")===-1){
if(url.charAt(0)!=="/"&&url.indexOf("./")&&url.indexOf("../")!==0){
if(self._hostRxp.test(url)){
_646=true;
}
}
}
}else{
if(self._userAtRxp.test(url)){
_647=true;
}
}
}
}
if(_646){
self._urlInput.set("value","http://"+url);
}
if(_647){
self._urlInput.set("value","mailto:"+url);
}
self._setButton.set("disabled",!self._isValid());
};
if(this._delayedCheck){
clearTimeout(this._delayedCheck);
this._delayedCheck=null;
}
this._delayedCheck=setTimeout(function(){
_645(url);
},250);
},_connectTagEvents:function(){
this.editor.onLoadDeferred.then(lang.hitch(this,function(){
this.connect(this.editor.editNode,"ondblclick",this._onDblClick);
}));
},_isValid:function(){
return this._urlInput.isValid()&&this._textInput.isValid();
},_setContent:function(_648){
this.dropDown.set({parserScope:"dojo",content:_648});
},_checkValues:function(args){
if(args&&args.urlInput){
args.urlInput=args.urlInput.replace(/"/g,"&quot;");
}
return args;
},setValue:function(args){
this._onCloseDialog();
if(has("ie")<9){
var sel=_63c.getSelection(this.editor.window);
var _649=sel.getRangeAt(0);
var a=_649.endContainer;
if(a.nodeType===3){
a=a.parentNode;
}
if(a&&(a.nodeName&&a.nodeName.toLowerCase()!==this.tag)){
a=this.editor._sCall("getSelectedElement",[this.tag]);
}
if(a&&(a.nodeName&&a.nodeName.toLowerCase()===this.tag)){
if(this.editor.queryCommandEnabled("unlink")){
this.editor._sCall("selectElementChildren",[a]);
this.editor.execCommand("unlink");
}
}
}
args=this._checkValues(args);
this.editor.execCommand("inserthtml",_638.substitute(this.htmlTemplate,args));
_637("a",this.editor.document).forEach(function(a){
if(!a.innerHTML&&!_636.has(a,"name")){
a.parentNode.removeChild(a);
}
},this);
},_onCloseDialog:function(){
this.editor.focus();
},_getCurrentValues:function(a){
var url,text,_64a;
if(a&&a.tagName.toLowerCase()===this.tag){
url=a.getAttribute("_djrealurl")||a.getAttribute("href");
_64a=a.getAttribute("target")||"_self";
text=a.textContent||a.innerText;
this.editor._sCall("selectElement",[a,true]);
}else{
text=this.editor._sCall("getSelectedText");
}
return {urlInput:url||"",textInput:text||"",targetSelect:_64a||""};
},_onOpenDialog:function(){
var a,b,fc;
if(has("ie")){
var sel=_63c.getSelection(this.editor.window);
if(sel.rangeCount){
var _64b=sel.getRangeAt(0);
a=_64b.endContainer;
if(a.nodeType===3){
a=a.parentNode;
}
if(a&&(a.nodeName&&a.nodeName.toLowerCase()!==this.tag)){
a=this.editor._sCall("getSelectedElement",[this.tag]);
}
if(!a||(a.nodeName&&a.nodeName.toLowerCase()!==this.tag)){
b=this.editor._sCall("getAncestorElement",[this.tag]);
if(b&&(b.nodeName&&b.nodeName.toLowerCase()==this.tag)){
a=b;
this.editor._sCall("selectElement",[a]);
}else{
if(_64b.startContainer===_64b.endContainer){
fc=_64b.startContainer.firstChild;
if(fc&&(fc.nodeName&&fc.nodeName.toLowerCase()==this.tag)){
a=fc;
this.editor._sCall("selectElement",[a]);
}
}
}
}
}
}else{
a=this.editor._sCall("getAncestorElement",[this.tag]);
}
this.dropDown.reset();
this._setButton.set("disabled",true);
this.dropDown.set("value",this._getCurrentValues(a));
},_onDblClick:function(e){
if(e&&e.target){
var t=e.target;
var tg=t.tagName?t.tagName.toLowerCase():"";
if(tg===this.tag&&_636.get(t,"href")){
var _64c=this.editor;
this.editor._sCall("selectElement",[t]);
_64c.onDisplayChanged();
if(_64c._updateTimer){
_64c._updateTimer.remove();
delete _64c._updateTimer;
}
_64c.onNormalizedDisplayChanged();
var _64d=this.button;
setTimeout(function(){
_64d.set("disabled",false);
_64d.loadAndOpenDropDown().then(function(){
if(_64d.dropDown.focus){
_64d.dropDown.focus();
}
});
},10);
}
}
}});
var _64e=_635("dijit._editor.plugins.ImgLinkDialog",[_63d],{linkDialogTemplate:["<table role='presentation'><tr><td>","<label for='${id}_urlInput'>${url}</label>","</td><td>","<input dojoType='dijit.form.ValidationTextBox' regExp='${urlRegExp}' "+"required='true' id='${id}_urlInput' name='urlInput' data-dojo-props='intermediateChanges:true'/>","</td></tr><tr><td>","<label for='${id}_textInput'>${text}</label>","</td><td>","<input data-dojo-type='dijit.form.ValidationTextBox' required='false' id='${id}_textInput' "+"name='textInput' data-dojo-props='intermediateChanges:true'/>","</td></tr><tr><td>","</td><td>","</td></tr><tr><td colspan='2'>","<button data-dojo-type='dijit.form.Button' type='submit' id='${id}_setButton'>${set}</button>","<button data-dojo-type='dijit.form.Button' type='button' id='${id}_cancelButton'>${buttonCancel}</button>","</td></tr></table>"].join(""),htmlTemplate:"<img src=\"${urlInput}\" _djrealurl=\"${urlInput}\" alt=\"${textInput}\" />",tag:"img",_getCurrentValues:function(img){
var url,text;
if(img&&img.tagName.toLowerCase()===this.tag){
url=img.getAttribute("_djrealurl")||img.getAttribute("src");
text=img.getAttribute("alt");
this.editor._sCall("selectElement",[img,true]);
}else{
text=this.editor._sCall("getSelectedText",[]);
}
return {urlInput:url||"",textInput:text||""};
},_isValid:function(){
return this._urlInput.isValid();
},_connectTagEvents:function(){
this.inherited(arguments);
this.editor.onLoadDeferred.then(lang.hitch(this,function(){
this.connect(this.editor.editNode,"onmousedown",this._selectTag);
}));
},_selectTag:function(e){
if(e&&e.target){
var t=e.target;
var tg=t.tagName?t.tagName.toLowerCase():"";
if(tg===this.tag){
this.editor._sCall("selectElement",[t]);
}
}
},_checkValues:function(args){
if(args&&args.urlInput){
args.urlInput=args.urlInput.replace(/"/g,"&quot;");
}
if(args&&args.textInput){
args.textInput=args.textInput.replace(/"/g,"&quot;");
}
return args;
},_onDblClick:function(e){
if(e&&e.target){
var t=e.target;
var tg=t.tagName?t.tagName.toLowerCase():"";
if(tg===this.tag&&_636.get(t,"src")){
var _64f=this.editor;
this.editor._sCall("selectElement",[t]);
_64f.onDisplayChanged();
if(_64f._updateTimer){
_64f._updateTimer.remove();
delete _64f._updateTimer;
}
_64f.onNormalizedDisplayChanged();
var _650=this.button;
setTimeout(function(){
_650.set("disabled",false);
_650.loadAndOpenDropDown().then(function(){
if(_650.dropDown.focus){
_650.dropDown.focus();
}
});
},10);
}
}
}});
_63a.registry["createLink"]=function(){
return new _63d({command:"createLink"});
};
_63a.registry["insertImage"]=function(){
return new _64e({command:"insertImage"});
};
_63d.ImgLinkDialog=_64e;
return _63d;
});
},"dijit/DropDownMenu":function(){
define(["dojo/_base/declare","dojo/_base/event","dojo/keys","dojo/text!./templates/Menu.html","./_OnDijitClickMixin","./_MenuBase"],function(_651,_652,keys,_653,_654,_655){
return _651("dijit.DropDownMenu",[_655,_654],{templateString:_653,baseClass:"dijitMenu",postCreate:function(){
this.inherited(arguments);
var l=this.isLeftToRight();
this._openSubMenuKey=l?keys.RIGHT_ARROW:keys.LEFT_ARROW;
this._closeSubMenuKey=l?keys.LEFT_ARROW:keys.RIGHT_ARROW;
this.connectKeyNavHandlers([keys.UP_ARROW],[keys.DOWN_ARROW]);
},_onKeyPress:function(evt){
if(evt.ctrlKey||evt.altKey){
return;
}
switch(evt.charOrCode){
case this._openSubMenuKey:
this._moveToPopup(evt);
_652.stop(evt);
break;
case this._closeSubMenuKey:
if(this.parentMenu){
if(this.parentMenu._isMenuBar){
this.parentMenu.focusPrev();
}else{
this.onCancel(false);
}
}else{
_652.stop(evt);
}
break;
}
}});
});
},"dijit/form/_FormMixin":function(){
define(["dojo/_base/array","dojo/_base/declare","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/window"],function(_656,_657,_658,lang,on,_659){
return _657("dijit.form._FormMixin",null,{state:"",_getDescendantFormWidgets:function(_65a){
var res=[];
_656.forEach(_65a||this.getChildren(),function(_65b){
if("value" in _65b){
res.push(_65b);
}else{
res=res.concat(this._getDescendantFormWidgets(_65b.getChildren()));
}
},this);
return res;
},reset:function(){
_656.forEach(this._getDescendantFormWidgets(),function(_65c){
if(_65c.reset){
_65c.reset();
}
});
},validate:function(){
var _65d=false;
return _656.every(_656.map(this._getDescendantFormWidgets(),function(_65e){
_65e._hasBeenBlurred=true;
var _65f=_65e.disabled||!_65e.validate||_65e.validate();
if(!_65f&&!_65d){
_659.scrollIntoView(_65e.containerNode||_65e.domNode);
_65e.focus();
_65d=true;
}
return _65f;
}),function(item){
return item;
});
},setValues:function(val){
_658.deprecated(this.declaredClass+"::setValues() is deprecated. Use set('value', val) instead.","","2.0");
return this.set("value",val);
},_setValueAttr:function(obj){
var map={};
_656.forEach(this._getDescendantFormWidgets(),function(_660){
if(!_660.name){
return;
}
var _661=map[_660.name]||(map[_660.name]=[]);
_661.push(_660);
});
for(var name in map){
if(!map.hasOwnProperty(name)){
continue;
}
var _662=map[name],_663=lang.getObject(name,false,obj);
if(_663===undefined){
continue;
}
if(!lang.isArray(_663)){
_663=[_663];
}
if(typeof _662[0].checked=="boolean"){
_656.forEach(_662,function(w){
w.set("value",_656.indexOf(_663,w.value)!=-1);
});
}else{
if(_662[0].multiple){
_662[0].set("value",_663);
}else{
_656.forEach(_662,function(w,i){
w.set("value",_663[i]);
});
}
}
}
},getValues:function(){
_658.deprecated(this.declaredClass+"::getValues() is deprecated. Use get('value') instead.","","2.0");
return this.get("value");
},_getValueAttr:function(){
var obj={};
_656.forEach(this._getDescendantFormWidgets(),function(_664){
var name=_664.name;
if(!name||_664.disabled){
return;
}
var _665=_664.get("value");
if(typeof _664.checked=="boolean"){
if(/Radio/.test(_664.declaredClass)){
if(_665!==false){
lang.setObject(name,_665,obj);
}else{
_665=lang.getObject(name,false,obj);
if(_665===undefined){
lang.setObject(name,null,obj);
}
}
}else{
var ary=lang.getObject(name,false,obj);
if(!ary){
ary=[];
lang.setObject(name,ary,obj);
}
if(_665!==false){
ary.push(_665);
}
}
}else{
var prev=lang.getObject(name,false,obj);
if(typeof prev!="undefined"){
if(lang.isArray(prev)){
prev.push(_665);
}else{
lang.setObject(name,[prev,_665],obj);
}
}else{
lang.setObject(name,_665,obj);
}
}
});
return obj;
},isValid:function(){
return this.state=="";
},onValidStateChange:function(){
},_getState:function(){
var _666=_656.map(this._descendants,function(w){
return w.get("state")||"";
});
return _656.indexOf(_666,"Error")>=0?"Error":_656.indexOf(_666,"Incomplete")>=0?"Incomplete":"";
},disconnectChildren:function(){
},connectChildren:function(_667){
this._descendants=this._getDescendantFormWidgets();
_656.forEach(this._descendants,function(_668){
if(!_668._started){
_668.startup();
}
});
if(!_667){
this._onChildChange();
}
},_onChildChange:function(attr){
if(!attr||attr=="state"||attr=="disabled"){
this._set("state",this._getState());
}
if(!attr||attr=="value"||attr=="disabled"||attr=="checked"){
if(this._onChangeDelayTimer){
this._onChangeDelayTimer.remove();
}
this._onChangeDelayTimer=this.defer(function(){
delete this._onChangeDelayTimer;
this._set("value",this.get("value"));
},10);
}
},startup:function(){
this.inherited(arguments);
this._descendants=this._getDescendantFormWidgets();
this.value=this.get("value");
this.state=this._getState();
var self=this;
this.own(on(this.containerNode,"attrmodified-state, attrmodified-disabled, attrmodified-value, attrmodified-checked",function(evt){
if(evt.target==self.domNode){
return;
}
self._onChildChange(evt.type.replace("attrmodified-",""));
}));
this.watch("state",function(attr,_669,_66a){
this.onValidStateChange(_66a=="");
});
},destroy:function(){
this.inherited(arguments);
}});
});
},"dijit/Menu":function(){
define("dijit/Menu",["require","dojo/_base/array","dojo/_base/declare","dojo/_base/event","dojo/dom","dojo/dom-attr","dojo/dom-geometry","dojo/dom-style","dojo/keys","dojo/_base/lang","dojo/on","dojo/sniff","dojo/_base/window","dojo/window","./popup","./DropDownMenu","dojo/ready"],function(_66b,_66c,_66d,_66e,dom,_66f,_670,_671,keys,lang,on,has,win,_672,pm,_673,_674){
if(has("dijit-legacy-requires")){
_674(0,function(){
var _675=["dijit/MenuItem","dijit/PopupMenuItem","dijit/CheckedMenuItem","dijit/MenuSeparator"];
_66b(_675);
});
}
return _66d("dijit.Menu",_673,{constructor:function(){
this._bindings=[];
},targetNodeIds:[],selector:"",contextMenuForWindow:false,leftClickToOpen:false,refocus:true,postCreate:function(){
if(this.contextMenuForWindow){
this.bindDomNode(this.ownerDocumentBody);
}else{
_66c.forEach(this.targetNodeIds,this.bindDomNode,this);
}
this.inherited(arguments);
},_iframeContentWindow:function(_676){
return _672.get(this._iframeContentDocument(_676))||this._iframeContentDocument(_676)["__parent__"]||(_676.name&&win.doc.frames[_676.name])||null;
},_iframeContentDocument:function(_677){
return _677.contentDocument||(_677.contentWindow&&_677.contentWindow.document)||(_677.name&&win.doc.frames[_677.name]&&win.doc.frames[_677.name].document)||null;
},bindDomNode:function(node){
node=dom.byId(node,this.ownerDocument);
var cn;
if(node.tagName.toLowerCase()=="iframe"){
var _678=node,_679=this._iframeContentWindow(_678);
cn=win.body(_679.document);
}else{
cn=(node==win.body(this.ownerDocument)?this.ownerDocument.documentElement:node);
}
var _67a={node:node,iframe:_678};
_66f.set(node,"_dijitMenu"+this.id,this._bindings.push(_67a));
var _67b=lang.hitch(this,function(cn){
var _67c=this.selector,_67d=_67c?function(_67e){
return on.selector(_67c,_67e);
}:function(_67f){
return _67f;
},self=this;
return [on(cn,_67d(this.leftClickToOpen?"click":"contextmenu"),function(evt){
_66e.stop(evt);
self._scheduleOpen(this,_678,{x:evt.pageX,y:evt.pageY});
}),on(cn,_67d("keydown"),function(evt){
if(evt.shiftKey&&evt.keyCode==keys.F10){
_66e.stop(evt);
self._scheduleOpen(this,_678);
}
})];
});
_67a.connects=cn?_67b(cn):[];
if(_678){
_67a.onloadHandler=lang.hitch(this,function(){
var _680=this._iframeContentWindow(_678);
cn=win.body(_680.document);
_67a.connects=_67b(cn);
});
if(_678.addEventListener){
_678.addEventListener("load",_67a.onloadHandler,false);
}else{
_678.attachEvent("onload",_67a.onloadHandler);
}
}
},unBindDomNode:function(_681){
var node;
try{
node=dom.byId(_681,this.ownerDocument);
}
catch(e){
return;
}
var _682="_dijitMenu"+this.id;
if(node&&_66f.has(node,_682)){
var bid=_66f.get(node,_682)-1,b=this._bindings[bid],h;
while((h=b.connects.pop())){
h.remove();
}
var _683=b.iframe;
if(_683){
if(_683.removeEventListener){
_683.removeEventListener("load",b.onloadHandler,false);
}else{
_683.detachEvent("onload",b.onloadHandler);
}
}
_66f.remove(node,_682);
delete this._bindings[bid];
}
},_scheduleOpen:function(_684,_685,_686){
if(!this._openTimer){
this._openTimer=this.defer(function(){
delete this._openTimer;
this._openMyself({target:_684,iframe:_685,coords:_686});
},1);
}
},_openMyself:function(args){
var _687=args.target,_688=args.iframe,_689=args.coords;
this.currentTarget=_687;
if(_689){
if(_688){
var ifc=_670.position(_688,true),_68a=this._iframeContentWindow(_688),_68b=_670.docScroll(_68a.document);
var cs=_671.getComputedStyle(_688),tp=_671.toPixelValue,left=(has("ie")&&has("quirks")?0:tp(_688,cs.paddingLeft))+(has("ie")&&has("quirks")?tp(_688,cs.borderLeftWidth):0),top=(has("ie")&&has("quirks")?0:tp(_688,cs.paddingTop))+(has("ie")&&has("quirks")?tp(_688,cs.borderTopWidth):0);
_689.x+=ifc.x+left-_68b.x;
_689.y+=ifc.y+top-_68b.y;
}
}else{
_689=_670.position(_687,true);
_689.x+=10;
_689.y+=10;
}
var self=this;
var _68c=this._focusManager.get("prevNode");
var _68d=this._focusManager.get("curNode");
var _68e=!_68d||(dom.isDescendant(_68d,this.domNode))?_68c:_68d;
function _68f(){
if(self.refocus&&_68e){
_68e.focus();
}
pm.close(self);
};
pm.open({popup:this,x:_689.x,y:_689.y,onExecute:_68f,onCancel:_68f,orient:this.isLeftToRight()?"L":"R"});
this.focus();
this._onBlur=function(){
this.inherited("_onBlur",arguments);
pm.close(this);
};
},destroy:function(){
_66c.forEach(this._bindings,function(b){
if(b){
this.unBindDomNode(b.node);
}
},this);
this.inherited(arguments);
}});
});
},"dijit/form/_CheckBoxMixin":function(){
define(["dojo/_base/declare","dojo/dom-attr","dojo/_base/event"],function(_690,_691,_692){
return _690("dijit.form._CheckBoxMixin",null,{type:"checkbox",value:"on",readOnly:false,_aria_attr:"aria-checked",_setReadOnlyAttr:function(_693){
this._set("readOnly",_693);
_691.set(this.focusNode,"readOnly",_693);
},_setLabelAttr:undefined,_getSubmitValue:function(_694){
return !_694&&_694!==0?"on":_694;
},_setValueAttr:function(_695){
_695=this._getSubmitValue(_695);
this._set("value",_695);
_691.set(this.focusNode,"value",_695);
},reset:function(){
this.inherited(arguments);
this._set("value",this.params.value||"on");
_691.set(this.focusNode,"value",this.value);
},_onClick:function(e){
if(this.readOnly){
_692.stop(e);
return false;
}
return this.inherited(arguments);
}});
});
},"dijit/layout/ContentPane":function(){
define(["dojo/_base/kernel","dojo/_base/lang","../_Widget","../_Container","./_ContentPaneResizeMixin","dojo/string","dojo/html","dojo/i18n!../nls/loading","dojo/_base/array","dojo/_base/declare","dojo/_base/Deferred","dojo/dom","dojo/dom-attr","dojo/dom-construct","dojo/_base/xhr","dojo/i18n","dojo/when"],function(_696,lang,_697,_698,_699,_69a,html,_69b,_69c,_69d,_69e,dom,_69f,_6a0,xhr,i18n,when){
return _69d("dijit.layout.ContentPane",[_697,_698,_699],{href:"",content:"",extractContent:false,parseOnLoad:true,parserScope:_696._scopeName,preventCache:false,preload:false,refreshOnShow:false,loadingMessage:"<span class='dijitContentPaneLoading'><span class='dijitInline dijitIconLoading'></span>${loadingState}</span>",errorMessage:"<span class='dijitContentPaneError'><span class='dijitInline dijitIconError'></span>${errorState}</span>",isLoaded:false,baseClass:"dijitContentPane",ioArgs:{},onLoadDeferred:null,_setTitleAttr:null,stopParser:true,template:false,create:function(_6a1,_6a2){
if((!_6a1||!_6a1.template)&&_6a2&&!("href" in _6a1)&&!("content" in _6a1)){
_6a2=dom.byId(_6a2);
var df=_6a2.ownerDocument.createDocumentFragment();
while(_6a2.firstChild){
df.appendChild(_6a2.firstChild);
}
_6a1=lang.delegate(_6a1,{content:df});
}
this.inherited(arguments,[_6a1,_6a2]);
},postMixInProperties:function(){
this.inherited(arguments);
var _6a3=i18n.getLocalization("dijit","loading",this.lang);
this.loadingMessage=_69a.substitute(this.loadingMessage,_6a3);
this.errorMessage=_69a.substitute(this.errorMessage,_6a3);
},buildRendering:function(){
this.inherited(arguments);
if(!this.containerNode){
this.containerNode=this.domNode;
}
this.domNode.title="";
if(!_69f.get(this.domNode,"role")){
this.domNode.setAttribute("role","group");
}
},startup:function(){
this.inherited(arguments);
if(this._contentSetter){
_69c.forEach(this._contentSetter.parseResults,function(obj){
if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){
obj.startup();
obj._started=true;
}
},this);
}
},_startChildren:function(){
_69c.forEach(this.getChildren(),function(obj){
if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){
obj.startup();
obj._started=true;
}
});
if(this._contentSetter){
_69c.forEach(this._contentSetter.parseResults,function(obj){
if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){
obj.startup();
obj._started=true;
}
},this);
}
},setHref:function(href){
_696.deprecated("dijit.layout.ContentPane.setHref() is deprecated. Use set('href', ...) instead.","","2.0");
return this.set("href",href);
},_setHrefAttr:function(href){
this.cancel();
this.onLoadDeferred=new _69e(lang.hitch(this,"cancel"));
this.onLoadDeferred.then(lang.hitch(this,"onLoad"));
this._set("href",href);
if(this.preload||(this._created&&this._isShown())){
this._load();
}else{
this._hrefChanged=true;
}
return this.onLoadDeferred;
},setContent:function(data){
_696.deprecated("dijit.layout.ContentPane.setContent() is deprecated.  Use set('content', ...) instead.","","2.0");
this.set("content",data);
},_setContentAttr:function(data){
this._set("href","");
this.cancel();
this.onLoadDeferred=new _69e(lang.hitch(this,"cancel"));
if(this._created){
this.onLoadDeferred.then(lang.hitch(this,"onLoad"));
}
this._setContent(data||"");
this._isDownloaded=false;
return this.onLoadDeferred;
},_getContentAttr:function(){
return this.containerNode.innerHTML;
},cancel:function(){
if(this._xhrDfd&&(this._xhrDfd.fired==-1)){
this._xhrDfd.cancel();
}
delete this._xhrDfd;
this.onLoadDeferred=null;
},destroy:function(){
this.cancel();
this.inherited(arguments);
},destroyRecursive:function(_6a4){
if(this._beingDestroyed){
return;
}
this.inherited(arguments);
},_onShow:function(){
this.inherited(arguments);
if(this.href){
if(!this._xhrDfd&&(!this.isLoaded||this._hrefChanged||this.refreshOnShow)){
return this.refresh();
}
}
},refresh:function(){
this.cancel();
this.onLoadDeferred=new _69e(lang.hitch(this,"cancel"));
this.onLoadDeferred.then(lang.hitch(this,"onLoad"));
this._load();
return this.onLoadDeferred;
},_load:function(){
this._setContent(this.onDownloadStart(),true);
var self=this;
var _6a5={preventCache:(this.preventCache||this.refreshOnShow),url:this.href,handleAs:"text"};
if(lang.isObject(this.ioArgs)){
lang.mixin(_6a5,this.ioArgs);
}
var hand=(this._xhrDfd=(this.ioMethod||xhr.get)(_6a5)),_6a6;
hand.then(function(html){
_6a6=html;
try{
self._isDownloaded=true;
return self._setContent(html,false);
}
catch(err){
self._onError("Content",err);
}
},function(err){
if(!hand.canceled){
self._onError("Download",err);
}
delete self._xhrDfd;
return err;
}).then(function(){
self.onDownloadEnd();
delete self._xhrDfd;
return _6a6;
});
delete this._hrefChanged;
},_onLoadHandler:function(data){
this._set("isLoaded",true);
try{
this.onLoadDeferred.resolve(data);
}
catch(e){
console.error("Error "+this.widgetId+" running custom onLoad code: "+e.message);
}
},_onUnloadHandler:function(){
this._set("isLoaded",false);
try{
this.onUnload();
}
catch(e){
console.error("Error "+this.widgetId+" running custom onUnload code: "+e.message);
}
},destroyDescendants:function(_6a7){
if(this.isLoaded){
this._onUnloadHandler();
}
var _6a8=this._contentSetter;
_69c.forEach(this.getChildren(),function(_6a9){
if(_6a9.destroyRecursive){
_6a9.destroyRecursive(_6a7);
}else{
if(_6a9.destroy){
_6a9.destroy(_6a7);
}
}
_6a9._destroyed=true;
});
if(_6a8){
_69c.forEach(_6a8.parseResults,function(_6aa){
if(!_6aa._destroyed){
if(_6aa.destroyRecursive){
_6aa.destroyRecursive(_6a7);
}else{
if(_6aa.destroy){
_6aa.destroy(_6a7);
}
}
_6aa._destroyed=true;
}
});
delete _6a8.parseResults;
}
if(!_6a7){
_6a0.empty(this.containerNode);
}
delete this._singleChild;
},_setContent:function(cont,_6ab){
this.destroyDescendants();
var _6ac=this._contentSetter;
if(!(_6ac&&_6ac instanceof html._ContentSetter)){
_6ac=this._contentSetter=new html._ContentSetter({node:this.containerNode,_onError:lang.hitch(this,this._onError),onContentError:lang.hitch(this,function(e){
var _6ad=this.onContentError(e);
try{
this.containerNode.innerHTML=_6ad;
}
catch(e){
console.error("Fatal "+this.id+" could not change content due to "+e.message,e);
}
})});
}
var _6ae=lang.mixin({cleanContent:this.cleanContent,extractContent:this.extractContent,parseContent:!cont.domNode&&this.parseOnLoad,parserScope:this.parserScope,startup:false,dir:this.dir,lang:this.lang,textDir:this.textDir},this._contentSetterParams||{});
var p=_6ac.set((lang.isObject(cont)&&cont.domNode)?cont.domNode:cont,_6ae);
var self=this;
return when(p&&p.then?p:_6ac.parseDeferred,function(){
delete self._contentSetterParams;
if(!_6ab){
if(self._started){
self._startChildren();
self._scheduleLayout();
}
self._onLoadHandler(cont);
}
});
},_onError:function(type,err,_6af){
this.onLoadDeferred.reject(err);
var _6b0=this["on"+type+"Error"].call(this,err);
if(_6af){
console.error(_6af,err);
}else{
if(_6b0){
this._setContent(_6b0,true);
}
}
},onLoad:function(){
},onUnload:function(){
},onDownloadStart:function(){
return this.loadingMessage;
},onContentError:function(){
},onDownloadError:function(){
return this.errorMessage;
},onDownloadEnd:function(){
}});
});
},"url:dijit/form/templates/ValidationTextBox.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\"\n\tid=\"widget_${id}\" role=\"presentation\"\n\t><div class='dijitReset dijitValidationContainer'\n\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t/></div\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class=\"dijitReset dijitInputInner\" data-dojo-attach-point='textbox,focusNode' autocomplete=\"off\"\n\t\t\t${!nameAttrSetting} type='${type}'\n\t/></div\n></div>\n","url:dijit/form/templates/TextBox.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\" id=\"widget_${id}\" role=\"presentation\"\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class=\"dijitReset dijitInputInner\" data-dojo-attach-point='textbox,focusNode' autocomplete=\"off\"\n\t\t\t${!nameAttrSetting} type='${type}'\n\t/></div\n></div>\n","dijit/_KeyNavContainer":function(){
define(["dojo/_base/kernel","./_Container","./_FocusMixin","dojo/_base/array","dojo/keys","dojo/_base/declare","dojo/_base/event","dojo/dom-attr","dojo/_base/lang"],function(_6b1,_6b2,_6b3,_6b4,keys,_6b5,_6b6,_6b7,lang){
return _6b5("dijit._KeyNavContainer",[_6b3,_6b2],{tabIndex:"0",connectKeyNavHandlers:function(_6b8,_6b9){
var _6ba=(this._keyNavCodes={});
var prev=lang.hitch(this,"focusPrev");
var next=lang.hitch(this,"focusNext");
_6b4.forEach(_6b8,function(code){
_6ba[code]=prev;
});
_6b4.forEach(_6b9,function(code){
_6ba[code]=next;
});
_6ba[keys.HOME]=lang.hitch(this,"focusFirstChild");
_6ba[keys.END]=lang.hitch(this,"focusLastChild");
this.connect(this.domNode,"onkeypress","_onContainerKeypress");
this.connect(this.domNode,"onfocus","_onContainerFocus");
},startupKeyNavChildren:function(){
_6b1.deprecated("startupKeyNavChildren() call no longer needed","","2.0");
},startup:function(){
this.inherited(arguments);
_6b4.forEach(this.getChildren(),lang.hitch(this,"_startupChild"));
},addChild:function(_6bb,_6bc){
this.inherited(arguments);
this._startupChild(_6bb);
},focus:function(){
this.focusFirstChild();
},focusFirstChild:function(){
this.focusChild(this._getFirstFocusableChild());
},focusLastChild:function(){
this.focusChild(this._getLastFocusableChild());
},focusNext:function(){
this.focusChild(this._getNextFocusableChild(this.focusedChild,1));
},focusPrev:function(){
this.focusChild(this._getNextFocusableChild(this.focusedChild,-1),true);
},focusChild:function(_6bd,last){
if(!_6bd){
return;
}
if(this.focusedChild&&_6bd!==this.focusedChild){
this._onChildBlur(this.focusedChild);
}
_6bd.set("tabIndex",this.tabIndex);
_6bd.focus(last?"end":"start");
this._set("focusedChild",_6bd);
},_startupChild:function(_6be){
_6be.set("tabIndex","-1");
this.connect(_6be,"_onFocus",function(){
_6be.set("tabIndex",this.tabIndex);
});
this.connect(_6be,"_onBlur",function(){
_6be.set("tabIndex","-1");
});
},_onContainerFocus:function(evt){
if(evt.target!==this.domNode||this.focusedChild){
return;
}
this.focusFirstChild();
_6b7.set(this.domNode,"tabIndex","-1");
},_onBlur:function(evt){
if(this.tabIndex){
_6b7.set(this.domNode,"tabIndex",this.tabIndex);
}
this.focusedChild=null;
this.inherited(arguments);
},_onContainerKeypress:function(evt){
if(evt.ctrlKey||evt.altKey){
return;
}
var func=this._keyNavCodes[evt.charOrCode];
if(func){
func();
_6b6.stop(evt);
}
},_onChildBlur:function(){
},_getFirstFocusableChild:function(){
return this._getNextFocusableChild(null,1);
},_getLastFocusableChild:function(){
return this._getNextFocusableChild(null,-1);
},_getNextFocusableChild:function(_6bf,dir){
if(_6bf){
_6bf=this._getSiblingOfChild(_6bf,dir);
}
var _6c0=this.getChildren();
for(var i=0;i<_6c0.length;i++){
if(!_6bf){
_6bf=_6c0[(dir>0)?0:(_6c0.length-1)];
}
if(_6bf.isFocusable()){
return _6bf;
}
_6bf=this._getSiblingOfChild(_6bf,dir);
}
return null;
}});
});
},"dijit/layout/utils":function(){
define(["dojo/_base/array","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang","../main"],function(_6c1,_6c2,_6c3,_6c4,lang,_6c5){
var _6c6=lang.getObject("layout",true,_6c5);
_6c6.marginBox2contentBox=function(node,mb){
var cs=_6c4.getComputedStyle(node);
var me=_6c3.getMarginExtents(node,cs);
var pb=_6c3.getPadBorderExtents(node,cs);
return {l:_6c4.toPixelValue(node,cs.paddingLeft),t:_6c4.toPixelValue(node,cs.paddingTop),w:mb.w-(me.w+pb.w),h:mb.h-(me.h+pb.h)};
};
function _6c7(word){
return word.substring(0,1).toUpperCase()+word.substring(1);
};
function size(_6c8,dim){
var _6c9=_6c8.resize?_6c8.resize(dim):_6c3.setMarginBox(_6c8.domNode,dim);
if(_6c9){
lang.mixin(_6c8,_6c9);
}else{
lang.mixin(_6c8,_6c3.getMarginBox(_6c8.domNode));
lang.mixin(_6c8,dim);
}
};
_6c6.layoutChildren=function(_6ca,dim,_6cb,_6cc,_6cd){
dim=lang.mixin({},dim);
_6c2.add(_6ca,"dijitLayoutContainer");
_6cb=_6c1.filter(_6cb,function(item){
return item.region!="center"&&item.layoutAlign!="client";
}).concat(_6c1.filter(_6cb,function(item){
return item.region=="center"||item.layoutAlign=="client";
}));
_6c1.forEach(_6cb,function(_6ce){
var elm=_6ce.domNode,pos=(_6ce.region||_6ce.layoutAlign);
if(!pos){
throw new Error("No region setting for "+_6ce.id);
}
var _6cf=elm.style;
_6cf.left=dim.l+"px";
_6cf.top=dim.t+"px";
_6cf.position="absolute";
_6c2.add(elm,"dijitAlign"+_6c7(pos));
var _6d0={};
if(_6cc&&_6cc==_6ce.id){
_6d0[_6ce.region=="top"||_6ce.region=="bottom"?"h":"w"]=_6cd;
}
if(pos=="top"||pos=="bottom"){
_6d0.w=dim.w;
size(_6ce,_6d0);
dim.h-=_6ce.h;
if(pos=="top"){
dim.t+=_6ce.h;
}else{
_6cf.top=dim.t+dim.h+"px";
}
}else{
if(pos=="left"||pos=="right"){
_6d0.h=dim.h;
size(_6ce,_6d0);
dim.w-=_6ce.w;
if(pos=="left"){
dim.l+=_6ce.w;
}else{
_6cf.left=dim.l+dim.w+"px";
}
}else{
if(pos=="client"||pos=="center"){
size(_6ce,dim);
}
}
}
});
};
return {marginBox2contentBox:_6c6.marginBox2contentBox,layoutChildren:_6c6.layoutChildren};
});
},"dijit/form/DataList":function(){
define(["dojo/_base/declare","dojo/dom","dojo/_base/lang","dojo/query","dojo/store/Memory","../registry"],function(_6d1,dom,lang,_6d2,_6d3,_6d4){
function _6d5(_6d6){
return {id:_6d6.value,value:_6d6.value,name:lang.trim(_6d6.innerText||_6d6.textContent||"")};
};
return _6d1("dijit.form.DataList",_6d3,{constructor:function(_6d7,_6d8){
this.domNode=dom.byId(_6d8);
lang.mixin(this,_6d7);
if(this.id){
_6d4.add(this);
}
this.domNode.style.display="none";
this.inherited(arguments,[{data:_6d2("option",this.domNode).map(_6d5)}]);
},destroy:function(){
_6d4.remove(this.id);
},fetchSelectedItem:function(){
var _6d9=_6d2("> option[selected]",this.domNode)[0]||_6d2("> option",this.domNode)[0];
return _6d9&&_6d5(_6d9);
}});
});
},"url:dijit/templates/Dialog.html":"<div class=\"dijitDialog\" role=\"dialog\" aria-labelledby=\"${id}_title\">\n\t<div data-dojo-attach-point=\"titleBar\" class=\"dijitDialogTitleBar\">\n\t\t<span data-dojo-attach-point=\"titleNode\" class=\"dijitDialogTitle\" id=\"${id}_title\"\n\t\t\t\trole=\"heading\" level=\"1\"></span>\n\t\t<span data-dojo-attach-point=\"closeButtonNode\" class=\"dijitDialogCloseIcon\" data-dojo-attach-event=\"ondijitclick: onCancel\" title=\"${buttonCancel}\" role=\"button\" tabIndex=\"-1\">\n\t\t\t<span data-dojo-attach-point=\"closeText\" class=\"closeText\" title=\"${buttonCancel}\">x</span>\n\t\t</span>\n\t</div>\n\t<div data-dojo-attach-point=\"containerNode\" class=\"dijitDialogPaneContent\"></div>\n</div>\n","dijit/form/CheckBox":function(){
define(["require","dojo/_base/declare","dojo/dom-attr","dojo/has","dojo/query","dojo/ready","./ToggleButton","./_CheckBoxMixin","dojo/text!./templates/CheckBox.html","dojo/NodeList-dom"],function(_6da,_6db,_6dc,has,_6dd,_6de,_6df,_6e0,_6e1){
if(has("dijit-legacy-requires")){
_6de(0,function(){
var _6e2=["dijit/form/RadioButton"];
_6da(_6e2);
});
}
return _6db("dijit.form.CheckBox",[_6df,_6e0],{templateString:_6e1,baseClass:"dijitCheckBox",_setValueAttr:function(_6e3,_6e4){
if(typeof _6e3=="string"){
this.inherited(arguments);
_6e3=true;
}
if(this._created){
this.set("checked",_6e3,_6e4);
}
},_getValueAttr:function(){
return (this.checked?this.value:false);
},_setIconClassAttr:null,postMixInProperties:function(){
this.inherited(arguments);
this.checkedAttrSetting=this.checked?"checked":"";
},_fillContent:function(){
},_onFocus:function(){
if(this.id){
_6dd("label[for='"+this.id+"']").addClass("dijitFocusedLabel");
}
this.inherited(arguments);
},_onBlur:function(){
if(this.id){
_6dd("label[for='"+this.id+"']").removeClass("dijitFocusedLabel");
}
this.inherited(arguments);
}});
});
},"dijit/_editor/_Plugin":function(){
define(["dojo/_base/connect","dojo/_base/declare","dojo/_base/lang","../form/Button"],function(_6e5,_6e6,lang,_6e7){
var _6e8=_6e6("dijit._editor._Plugin",null,{constructor:function(args){
this.params=args||{};
lang.mixin(this,this.params);
this._connects=[];
this._attrPairNames={};
},editor:null,iconClassPrefix:"dijitEditorIcon",button:null,command:"",useDefaultCommand:true,buttonClass:_6e7,disabled:false,getLabel:function(key){
return this.editor.commands[key];
},_initButton:function(){
if(this.command.length){
var _6e9=this.getLabel(this.command),_6ea=this.editor,_6eb=this.iconClassPrefix+" "+this.iconClassPrefix+this.command.charAt(0).toUpperCase()+this.command.substr(1);
if(!this.button){
var _6ec=lang.mixin({label:_6e9,ownerDocument:_6ea.ownerDocument,dir:_6ea.dir,lang:_6ea.lang,showLabel:false,iconClass:_6eb,dropDown:this.dropDown,tabIndex:"-1"},this.params||{});
this.button=new this.buttonClass(_6ec);
}
}
if(this.get("disabled")&&this.button){
this.button.set("disabled",this.get("disabled"));
}
},destroy:function(){
var h;
while(h=this._connects.pop()){
h.remove();
}
if(this.dropDown){
this.dropDown.destroyRecursive();
}
},connect:function(o,f,tf){
this._connects.push(_6e5.connect(o,f,this,tf));
},updateState:function(){
var e=this.editor,c=this.command,_6ed,_6ee;
if(!e||!e.isLoaded||!c.length){
return;
}
var _6ef=this.get("disabled");
if(this.button){
try{
_6ee=!_6ef&&e.queryCommandEnabled(c);
if(this.enabled!==_6ee){
this.enabled=_6ee;
this.button.set("disabled",!_6ee);
}
if(_6ee){
if(typeof this.button.checked=="boolean"){
_6ed=e.queryCommandState(c);
if(this.checked!==_6ed){
this.checked=_6ed;
this.button.set("checked",e.queryCommandState(c));
}
}
}
}
catch(e){
}
}
},setEditor:function(_6f0){
this.editor=_6f0;
this._initButton();
if(this.button&&this.useDefaultCommand){
if(this.editor.queryCommandAvailable(this.command)){
this.connect(this.button,"onClick",lang.hitch(this.editor,"execCommand",this.command,this.commandArg));
}else{
this.button.domNode.style.display="none";
}
}
this.connect(this.editor,"onNormalizedDisplayChanged","updateState");
},setToolbar:function(_6f1){
if(this.button){
_6f1.addChild(this.button);
}
},set:function(name,_6f2){
if(typeof name==="object"){
for(var x in name){
this.set(x,name[x]);
}
return this;
}
var _6f3=this._getAttrNames(name);
if(this[_6f3.s]){
var _6f4=this[_6f3.s].apply(this,Array.prototype.slice.call(arguments,1));
}else{
this._set(name,_6f2);
}
return _6f4||this;
},get:function(name){
var _6f5=this._getAttrNames(name);
return this[_6f5.g]?this[_6f5.g]():this[name];
},_setDisabledAttr:function(_6f6){
this.disabled=_6f6;
this.updateState();
},_getAttrNames:function(name){
var apn=this._attrPairNames;
if(apn[name]){
return apn[name];
}
var uc=name.charAt(0).toUpperCase()+name.substr(1);
return (apn[name]={s:"_set"+uc+"Attr",g:"_get"+uc+"Attr"});
},_set:function(name,_6f7){
this[name]=_6f7;
}});
_6e8.registry={};
return _6e8;
});
},"url:dijit/templates/MenuBar.html":"<div class=\"dijitMenuBar dijitMenuPassive\" data-dojo-attach-point=\"containerNode\"  role=\"menubar\" tabIndex=\"${tabIndex}\" data-dojo-attach-event=\"onkeypress: _onKeyPress\"></div>\n","dijit/tree/_dndSelector":function(){
define(["dojo/_base/array","dojo/_base/connect","dojo/_base/declare","dojo/_base/Deferred","dojo/_base/kernel","dojo/_base/lang","dojo/cookie","dojo/mouse","dojo/on","dojo/touch","./_dndContainer"],function(_6f8,_6f9,_6fa,_6fb,_6fc,lang,_6fd,_6fe,on,_6ff,_700){
return _6fa("dijit.tree._dndSelector",_700,{constructor:function(){
this.selection={};
this.anchor=null;
if(!this.cookieName&&this.tree.id){
this.cookieName=this.tree.id+"SaveSelectedCookie";
}
this.events.push(on(this.tree.domNode,_6ff.press,lang.hitch(this,"onMouseDown")),on(this.tree.domNode,_6ff.release,lang.hitch(this,"onMouseUp")),on(this.tree.domNode,_6ff.move,lang.hitch(this,"onMouseMove")));
},singular:false,getSelectedTreeNodes:function(){
var _701=[],sel=this.selection;
for(var i in sel){
_701.push(sel[i]);
}
return _701;
},selectNone:function(){
this.setSelection([]);
return this;
},destroy:function(){
this.inherited(arguments);
this.selection=this.anchor=null;
},addTreeNode:function(node,_702){
this.setSelection(this.getSelectedTreeNodes().concat([node]));
if(_702){
this.anchor=node;
}
return node;
},removeTreeNode:function(node){
this.setSelection(this._setDifference(this.getSelectedTreeNodes(),[node]));
return node;
},isTreeNodeSelected:function(node){
return node.id&&!!this.selection[node.id];
},setSelection:function(_703){
var _704=this.getSelectedTreeNodes();
_6f8.forEach(this._setDifference(_704,_703),lang.hitch(this,function(node){
node.setSelected(false);
if(this.anchor==node){
delete this.anchor;
}
delete this.selection[node.id];
}));
_6f8.forEach(this._setDifference(_703,_704),lang.hitch(this,function(node){
node.setSelected(true);
this.selection[node.id]=node;
}));
this._updateSelectionProperties();
},_setDifference:function(xs,ys){
_6f8.forEach(ys,function(y){
y.__exclude__=true;
});
var ret=_6f8.filter(xs,function(x){
return !x.__exclude__;
});
_6f8.forEach(ys,function(y){
delete y["__exclude__"];
});
return ret;
},_updateSelectionProperties:function(){
var _705=this.getSelectedTreeNodes();
var _706=[],_707=[],_708=[];
_6f8.forEach(_705,function(node){
var ary=node.getTreePath(),_709=this.tree.model;
_707.push(node);
_706.push(ary);
ary=_6f8.map(ary,function(item){
return _709.getIdentity(item);
},this);
_708.push(ary.join("/"));
},this);
var _70a=_6f8.map(_707,function(node){
return node.item;
});
this.tree._set("paths",_706);
this.tree._set("path",_706[0]||[]);
this.tree._set("selectedNodes",_707);
this.tree._set("selectedNode",_707[0]||null);
this.tree._set("selectedItems",_70a);
this.tree._set("selectedItem",_70a[0]||null);
if(this.tree.persist&&_708.length>0){
_6fd(this.cookieName,_708.join(","),{expires:365});
}
},_getSavedPaths:function(){
var tree=this.tree;
if(tree.persist&&tree.dndController.cookieName){
var oreo,_70b=[];
oreo=_6fd(tree.dndController.cookieName);
if(oreo){
_70b=_6f8.map(oreo.split(","),function(path){
return path.split("/");
});
}
return _70b;
}
},onMouseDown:function(e){
if(!this.current||this.tree.isExpandoNode(e.target,this.current)){
return;
}
if(_6fe.isLeft(e)){
e.preventDefault();
}else{
if(e.type!="touchstart"){
return;
}
}
var _70c=this.current,copy=_6f9.isCopyKey(e),id=_70c.id;
if(!this.singular&&!e.shiftKey&&this.selection[id]){
this._doDeselect=true;
return;
}else{
this._doDeselect=false;
}
this.userSelect(_70c,copy,e.shiftKey);
},onMouseUp:function(e){
if(!this._doDeselect){
return;
}
this._doDeselect=false;
this.userSelect(this.current,_6f9.isCopyKey(e),e.shiftKey);
},onMouseMove:function(){
this._doDeselect=false;
},_compareNodes:function(n1,n2){
if(n1===n2){
return 0;
}
if("sourceIndex" in document.documentElement){
return n1.sourceIndex-n2.sourceIndex;
}else{
if("compareDocumentPosition" in document.documentElement){
return n1.compareDocumentPosition(n2)&2?1:-1;
}else{
if(document.createRange){
var r1=doc.createRange();
r1.setStartBefore(n1);
var r2=doc.createRange();
r2.setStartBefore(n2);
return r1.compareBoundaryPoints(r1.END_TO_END,r2);
}else{
throw Error("dijit.tree._compareNodes don't know how to compare two different nodes in this browser");
}
}
}
},userSelect:function(node,_70d,_70e){
if(this.singular){
if(this.anchor==node&&_70d){
this.selectNone();
}else{
this.setSelection([node]);
this.anchor=node;
}
}else{
if(_70e&&this.anchor){
var cr=this._compareNodes(this.anchor.rowNode,node.rowNode),_70f,end,_710=this.anchor;
if(cr<0){
_70f=_710;
end=node;
}else{
_70f=node;
end=_710;
}
var _711=[];
while(_70f!=end){
_711.push(_70f);
_70f=this.tree._getNextNode(_70f);
}
_711.push(end);
this.setSelection(_711);
}else{
if(this.selection[node.id]&&_70d){
this.removeTreeNode(node);
}else{
if(_70d){
this.addTreeNode(node,true);
}else{
this.setSelection([node]);
this.anchor=node;
}
}
}
}
},getItem:function(key){
var _712=this.selection[key];
return {data:_712,type:["treeNode"]};
},forInSelectedItems:function(f,o){
o=o||_6fc.global;
for(var id in this.selection){
f.call(o,this.getItem(id),id,this);
}
}});
});
},"dojo/html":function(){
define(["./_base/kernel","./_base/lang","./_base/array","./_base/declare","./dom","./dom-construct","./parser"],function(_713,lang,_714,_715,dom,_716,_717){
var html={};
lang.setObject("dojo.html",html);
var _718=0;
html._secureForInnerHtml=function(cont){
return cont.replace(/(?:\s*<!DOCTYPE\s[^>]+>|<title[^>]*>[\s\S]*?<\/title>)/ig,"");
};
html._emptyNode=_716.empty;
html._setNodeContent=function(node,cont){
_716.empty(node);
if(cont){
if(typeof cont=="string"){
cont=_716.toDom(cont,node.ownerDocument);
}
if(!cont.nodeType&&lang.isArrayLike(cont)){
for(var _719=cont.length,i=0;i<cont.length;i=_719==cont.length?i+1:0){
_716.place(cont[i],node,"last");
}
}else{
_716.place(cont,node,"last");
}
}
return node;
};
html._ContentSetter=_715("dojo.html._ContentSetter",null,{node:"",content:"",id:"",cleanContent:false,extractContent:false,parseContent:false,parserScope:_713._scopeName,startup:true,constructor:function(_71a,node){
lang.mixin(this,_71a||{});
node=this.node=dom.byId(this.node||node);
if(!this.id){
this.id=["Setter",(node)?node.id||node.tagName:"",_718++].join("_");
}
},set:function(cont,_71b){
if(undefined!==cont){
this.content=cont;
}
if(_71b){
this._mixin(_71b);
}
this.onBegin();
this.setContent();
var ret=this.onEnd();
if(ret&&ret.then){
return ret;
}else{
return this.node;
}
},setContent:function(){
var node=this.node;
if(!node){
throw new Error(this.declaredClass+": setContent given no node");
}
try{
node=html._setNodeContent(node,this.content);
}
catch(e){
var _71c=this.onContentError(e);
try{
node.innerHTML=_71c;
}
catch(e){
console.error("Fatal "+this.declaredClass+".setContent could not change content due to "+e.message,e);
}
}
this.node=node;
},empty:function(){
if(this.parseDeferred){
if(!this.parseDeferred.isResolved()){
this.parseDeferred.cancel();
}
delete this.parseDeferred;
}
if(this.parseResults&&this.parseResults.length){
_714.forEach(this.parseResults,function(w){
if(w.destroy){
w.destroy();
}
});
delete this.parseResults;
}
_716.empty(this.node);
},onBegin:function(){
var cont=this.content;
if(lang.isString(cont)){
if(this.cleanContent){
cont=html._secureForInnerHtml(cont);
}
if(this.extractContent){
var _71d=cont.match(/<body[^>]*>\s*([\s\S]+)\s*<\/body>/im);
if(_71d){
cont=_71d[1];
}
}
}
this.empty();
this.content=cont;
return this.node;
},onEnd:function(){
if(this.parseContent){
this._parse();
}
return this.node;
},tearDown:function(){
delete this.parseResults;
delete this.parseDeferred;
delete this.node;
delete this.content;
},onContentError:function(err){
return "Error occurred setting content: "+err;
},onExecError:function(err){
return "Error occurred executing scripts: "+err;
},_mixin:function(_71e){
var _71f={},key;
for(key in _71e){
if(key in _71f){
continue;
}
this[key]=_71e[key];
}
},_parse:function(){
var _720=this.node;
try{
var _721={};
_714.forEach(["dir","lang","textDir"],function(name){
if(this[name]){
_721[name]=this[name];
}
},this);
var self=this;
this.parseDeferred=_717.parse({rootNode:_720,noStart:!this.startup,inherited:_721,scope:this.parserScope}).then(function(_722){
return self.parseResults=_722;
});
}
catch(e){
this._onError("Content",e,"Error parsing in _ContentSetter#"+this.id);
}
},_onError:function(type,err,_723){
var _724=this["on"+type+"Error"].call(this,err);
if(_723){
console.error(_723,err);
}else{
if(_724){
html._setNodeContent(this.node,_724,true);
}
}
}});
html.set=function(node,cont,_725){
if(undefined==cont){
console.warn("dojo.html.set: no cont argument provided, using empty string");
cont="";
}
if(!_725){
return html._setNodeContent(node,cont,true);
}else{
var op=new html._ContentSetter(lang.mixin(_725,{content:cont,node:node}));
return op.set();
}
};
return html;
});
},"dijit/_PaletteMixin":function(){
define(["dojo/_base/declare","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/_base/event","dojo/keys","dojo/_base/lang","./_CssStateMixin","./focus","./typematic"],function(_726,_727,_728,_729,_72a,keys,lang,_72b,_72c,_72d){
return _726("dijit._PaletteMixin",[_72b],{defaultTimeout:500,timeoutChangeRate:0.9,value:"",_selectedCell:-1,tabIndex:"0",cellClass:"dijitPaletteCell",dyeClass:null,summary:"",_setSummaryAttr:"paletteTableNode",_dyeFactory:function(_72e){
var _72f=typeof this.dyeClass=="string"?lang.getObject(this.dyeClass):this.dyeClass;
return new _72f(_72e);
},_preparePalette:function(_730,_731){
this._cells=[];
var url=this._blankGif;
this.connect(this.gridNode,"ondijitclick","_onCellClick");
for(var row=0;row<_730.length;row++){
var _732=_729.create("tr",{tabIndex:"-1"},this.gridNode);
for(var col=0;col<_730[row].length;col++){
var _733=_730[row][col];
if(_733){
var _734=this._dyeFactory(_733,row,col,_731[_733]);
var _735=_729.create("td",{"class":this.cellClass,tabIndex:"-1",title:_731[_733],role:"gridcell"},_732);
_734.fillCell(_735,url);
_735.idx=this._cells.length;
this._cells.push({node:_735,dye:_734});
}
}
}
this._xDim=_730[0].length;
this._yDim=_730.length;
var _736={UP_ARROW:-this._xDim,DOWN_ARROW:this._xDim,RIGHT_ARROW:this.isLeftToRight()?1:-1,LEFT_ARROW:this.isLeftToRight()?-1:1};
for(var key in _736){
this.own(_72d.addKeyListener(this.domNode,{charOrCode:keys[key],ctrlKey:false,altKey:false,shiftKey:false},this,function(){
var _737=_736[key];
return function(_738){
this._navigateByKey(_737,_738);
};
}(),this.timeoutChangeRate,this.defaultTimeout));
}
},postCreate:function(){
this.inherited(arguments);
this._setCurrent(this._cells[0].node);
},focus:function(){
_72c.focus(this._currentFocus);
},_onCellClick:function(evt){
var _739=evt.target;
while(_739.tagName!="TD"){
if(!_739.parentNode||_739==this.gridNode){
return;
}
_739=_739.parentNode;
}
var _73a=this._getDye(_739).getValue();
this._setCurrent(_739);
_72c.focus(_739);
this._setValueAttr(_73a,true);
_72a.stop(evt);
},_setCurrent:function(node){
if("_currentFocus" in this){
_727.set(this._currentFocus,"tabIndex","-1");
}
this._currentFocus=node;
if(node){
_727.set(node,"tabIndex",this.tabIndex);
}
},_setValueAttr:function(_73b,_73c){
if(this._selectedCell>=0){
_728.remove(this._cells[this._selectedCell].node,this.cellClass+"Selected");
}
this._selectedCell=-1;
if(_73b){
for(var i=0;i<this._cells.length;i++){
if(_73b==this._cells[i].dye.getValue()){
this._selectedCell=i;
_728.add(this._cells[i].node,this.cellClass+"Selected");
break;
}
}
}
this._set("value",this._selectedCell>=0?_73b:null);
if(_73c||_73c===undefined){
this.onChange(_73b);
}
},onChange:function(){
},_navigateByKey:function(_73d,_73e){
if(_73e==-1){
return;
}
var _73f=this._currentFocus.idx+_73d;
if(_73f<this._cells.length&&_73f>-1){
var _740=this._cells[_73f].node;
this._setCurrent(_740);
this.defer(lang.hitch(_72c,"focus",_740));
}
},_getDye:function(cell){
return this._cells[cell.idx].dye;
}});
});
},"url:dijit/templates/TitlePane.html":"<div>\n\t<div data-dojo-attach-event=\"onclick:_onTitleClick, onkeydown:_onTitleKey\"\n\t\t\tclass=\"dijitTitlePaneTitle\" data-dojo-attach-point=\"titleBarNode\" id=\"${id}_titleBarNode\">\n\t\t<div class=\"dijitTitlePaneTitleFocus\" data-dojo-attach-point=\"focusNode\">\n\t\t\t<img src=\"${_blankGif}\" alt=\"\" data-dojo-attach-point=\"arrowNode\" class=\"dijitArrowNode\" role=\"presentation\"\n\t\t\t/><span data-dojo-attach-point=\"arrowNodeInner\" class=\"dijitArrowNodeInner\"></span\n\t\t\t><span data-dojo-attach-point=\"titleNode\" class=\"dijitTitlePaneTextNode\"></span>\n\t\t</div>\n\t</div>\n\t<div class=\"dijitTitlePaneContentOuter\" data-dojo-attach-point=\"hideNode\" role=\"presentation\">\n\t\t<div class=\"dijitReset\" data-dojo-attach-point=\"wipeNode\" role=\"presentation\">\n\t\t\t<div class=\"dijitTitlePaneContentInner\" data-dojo-attach-point=\"containerNode\" role=\"region\" id=\"${id}_pane\" aria-labelledby=\"${id}_titleBarNode\">\n\t\t\t\t<!-- nested divs because wipeIn()/wipeOut() doesn't work right on node w/padding etc.  Put padding on inner div. -->\n\t\t\t</div>\n\t\t</div>\n\t</div>\n</div>\n","dijit/form/ValidationTextBox":function(){
define(["dojo/_base/declare","dojo/_base/kernel","dojo/i18n","./TextBox","../Tooltip","dojo/text!./templates/ValidationTextBox.html","dojo/i18n!./nls/validate"],function(_741,_742,i18n,_743,_744,_745){
var _746;
return _746=_741("dijit.form.ValidationTextBox",_743,{templateString:_745,required:false,promptMessage:"",invalidMessage:"$_unset_$",missingMessage:"$_unset_$",message:"",constraints:{},pattern:".*",regExp:"",regExpGen:function(){
},state:"",tooltipPosition:[],_deprecateRegExp:function(attr,_747){
if(_747!=_746.prototype[attr]){
_742.deprecated("ValidationTextBox id="+this.id+", set('"+attr+"', ...) is deprecated.  Use set('pattern', ...) instead.","","2.0");
this.set("pattern",_747);
}
},_setRegExpGenAttr:function(_748){
this._deprecateRegExp("regExpGen",_748);
this.regExpGen=this._getPatternAttr;
},_setRegExpAttr:function(_749){
this._deprecateRegExp("regExp",_749);
},_setValueAttr:function(){
this.inherited(arguments);
this.validate(this.focused);
},validator:function(_74a,_74b){
return (new RegExp("^(?:"+this._getPatternAttr(_74b)+")"+(this.required?"":"?")+"$")).test(_74a)&&(!this.required||!this._isEmpty(_74a))&&(this._isEmpty(_74a)||this.parse(_74a,_74b)!==undefined);
},_isValidSubset:function(){
return this.textbox.value.search(this._partialre)==0;
},isValid:function(){
return this.validator(this.textbox.value,this.constraints);
},_isEmpty:function(_74c){
return (this.trim?/^\s*$/:/^$/).test(_74c);
},getErrorMessage:function(){
var _74d=this.invalidMessage=="$_unset_$"?this.messages.invalidMessage:!this.invalidMessage?this.promptMessage:this.invalidMessage;
var _74e=this.missingMessage=="$_unset_$"?this.messages.missingMessage:!this.missingMessage?_74d:this.missingMessage;
return (this.required&&this._isEmpty(this.textbox.value))?_74e:_74d;
},getPromptMessage:function(){
return this.promptMessage;
},_maskValidSubsetError:true,validate:function(_74f){
var _750="";
var _751=this.disabled||this.isValid(_74f);
if(_751){
this._maskValidSubsetError=true;
}
var _752=this._isEmpty(this.textbox.value);
var _753=!_751&&_74f&&this._isValidSubset();
this._set("state",_751?"":(((((!this._hasBeenBlurred||_74f)&&_752)||_753)&&(this._maskValidSubsetError||(_753&&!this._hasBeenBlurred&&_74f)))?"Incomplete":"Error"));
this.focusNode.setAttribute("aria-invalid",_751?"false":"true");
if(this.state=="Error"){
this._maskValidSubsetError=_74f&&_753;
_750=this.getErrorMessage(_74f);
}else{
if(this.state=="Incomplete"){
_750=this.getPromptMessage(_74f);
this._maskValidSubsetError=!this._hasBeenBlurred||_74f;
}else{
if(_752){
_750=this.getPromptMessage(_74f);
}
}
}
this.set("message",_750);
return _751;
},displayMessage:function(_754){
if(_754&&this.focused){
_744.show(_754,this.domNode,this.tooltipPosition,!this.isLeftToRight());
}else{
_744.hide(this.domNode);
}
},_refreshState:function(){
if(this._created){
this.validate(this.focused);
}
this.inherited(arguments);
},constructor:function(_755){
this.constraints={};
this.baseClass+=" dijitValidationTextBox";
},startup:function(){
this.inherited(arguments);
this._refreshState();
},_setConstraintsAttr:function(_756){
if(!_756.locale&&this.lang){
_756.locale=this.lang;
}
this._set("constraints",_756);
this._refreshState();
},_setPatternAttr:function(_757){
this._set("pattern",_757);
},_getPatternAttr:function(_758){
var p=this.pattern;
var type=(typeof p).toLowerCase();
if(type=="function"){
p=this.pattern(_758||this.constraints);
}
if(p!=this._lastRegExp){
var _759="";
this._lastRegExp=p;
if(p!=".*"){
p.replace(/\\.|\[\]|\[.*?[^\\]{1}\]|\{.*?\}|\(\?[=:!]|./g,function(re){
switch(re.charAt(0)){
case "{":
case "+":
case "?":
case "*":
case "^":
case "$":
case "|":
case "(":
_759+=re;
break;
case ")":
_759+="|$)";
break;
default:
_759+="(?:"+re+"|$)";
break;
}
});
}
try{
"".search(_759);
}
catch(e){
_759=this.pattern;
console.warn("RegExp error in "+this.declaredClass+": "+this.pattern);
}
this._partialre="^(?:"+_759+")$";
}
return p;
},postMixInProperties:function(){
this.inherited(arguments);
this.messages=i18n.getLocalization("dijit.form","validate",this.lang);
this._setConstraintsAttr(this.constraints);
},_setDisabledAttr:function(_75a){
this.inherited(arguments);
this._refreshState();
},_setRequiredAttr:function(_75b){
this._set("required",_75b);
this.focusNode.setAttribute("aria-required",_75b);
this._refreshState();
},_setMessageAttr:function(_75c){
this._set("message",_75c);
this.displayMessage(_75c);
},reset:function(){
this._maskValidSubsetError=true;
this.inherited(arguments);
},_onBlur:function(){
this.displayMessage("");
this.inherited(arguments);
}});
});
},"dijit/layout/BorderContainer":function(){
define(["dojo/_base/array","dojo/cookie","dojo/_base/declare","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/_base/event","dojo/keys","dojo/_base/lang","dojo/on","dojo/touch","../_WidgetBase","../_Widget","../_TemplatedMixin","./_LayoutWidget","./utils"],function(_75d,_75e,_75f,_760,_761,_762,_763,_764,keys,lang,on,_765,_766,_767,_768,_769,_76a){
var _76b=_75f("dijit.layout._Splitter",[_767,_768],{live:true,templateString:"<div class=\"dijitSplitter\" data-dojo-attach-event=\"onkeypress:_onKeyPress,press:_startDrag,onmouseenter:_onMouse,onmouseleave:_onMouse\" tabIndex=\"0\" role=\"separator\"><div class=\"dijitSplitterThumb\"></div></div>",constructor:function(){
this._handlers=[];
},postMixInProperties:function(){
this.inherited(arguments);
this.horizontal=/top|bottom/.test(this.region);
this._factor=/top|left/.test(this.region)?1:-1;
this._cookieName=this.container.id+"_"+this.region;
},buildRendering:function(){
this.inherited(arguments);
_760.add(this.domNode,"dijitSplitter"+(this.horizontal?"H":"V"));
if(this.container.persist){
var _76c=_75e(this._cookieName);
if(_76c){
this.child.domNode.style[this.horizontal?"height":"width"]=_76c;
}
}
},_computeMaxSize:function(){
var dim=this.horizontal?"h":"w",_76d=_762.getMarginBox(this.child.domNode)[dim],_76e=_75d.filter(this.container.getChildren(),function(_76f){
return _76f.region=="center";
})[0],_770=_762.getMarginBox(_76e.domNode)[dim];
return Math.min(this.child.maxSize,_76d+_770);
},_startDrag:function(e){
if(!this.cover){
this.cover=_761.place("<div class=dijitSplitterCover></div>",this.child.domNode,"after");
}
_760.add(this.cover,"dijitSplitterCoverActive");
if(this.fake){
_761.destroy(this.fake);
}
if(!(this._resize=this.live)){
(this.fake=this.domNode.cloneNode(true)).removeAttribute("id");
_760.add(this.domNode,"dijitSplitterShadow");
_761.place(this.fake,this.domNode,"after");
}
_760.add(this.domNode,"dijitSplitterActive dijitSplitter"+(this.horizontal?"H":"V")+"Active");
if(this.fake){
_760.remove(this.fake,"dijitSplitterHover dijitSplitter"+(this.horizontal?"H":"V")+"Hover");
}
var _771=this._factor,_772=this.horizontal,axis=_772?"pageY":"pageX",_773=e[axis],_774=this.domNode.style,dim=_772?"h":"w",_775=_762.getMarginBox(this.child.domNode)[dim],max=this._computeMaxSize(),min=this.child.minSize||20,_776=this.region,_777=_776=="top"||_776=="bottom"?"top":"left",_778=parseInt(_774[_777],10),_779=this._resize,_77a=lang.hitch(this.container,"_layoutChildren",this.child.id),de=this.ownerDocument;
this._handlers=this._handlers.concat([on(de,_765.move,this._drag=function(e,_77b){
var _77c=e[axis]-_773,_77d=_771*_77c+_775,_77e=Math.max(Math.min(_77d,max),min);
if(_779||_77b){
_77a(_77e);
}
_774[_777]=_77c+_778+_771*(_77e-_77d)+"px";
}),on(de,"dragstart",_764.stop),on(this.ownerDocumentBody,"selectstart",_764.stop),on(de,_765.release,lang.hitch(this,"_stopDrag"))]);
_764.stop(e);
},_onMouse:function(e){
var o=(e.type=="mouseover"||e.type=="mouseenter");
_760.toggle(this.domNode,"dijitSplitterHover",o);
_760.toggle(this.domNode,"dijitSplitter"+(this.horizontal?"H":"V")+"Hover",o);
},_stopDrag:function(e){
try{
if(this.cover){
_760.remove(this.cover,"dijitSplitterCoverActive");
}
if(this.fake){
_761.destroy(this.fake);
}
_760.remove(this.domNode,"dijitSplitterActive dijitSplitter"+(this.horizontal?"H":"V")+"Active dijitSplitterShadow");
this._drag(e);
this._drag(e,true);
}
finally{
this._cleanupHandlers();
delete this._drag;
}
if(this.container.persist){
_75e(this._cookieName,this.child.domNode.style[this.horizontal?"height":"width"],{expires:365});
}
},_cleanupHandlers:function(){
var h;
while(h=this._handlers.pop()){
h.remove();
}
},_onKeyPress:function(e){
this._resize=true;
var _77f=this.horizontal;
var tick=1;
switch(e.charOrCode){
case _77f?keys.UP_ARROW:keys.LEFT_ARROW:
tick*=-1;
case _77f?keys.DOWN_ARROW:keys.RIGHT_ARROW:
break;
default:
return;
}
var _780=_762.getMarginSize(this.child.domNode)[_77f?"h":"w"]+this._factor*tick;
this.container._layoutChildren(this.child.id,Math.max(Math.min(_780,this._computeMaxSize()),this.child.minSize));
_764.stop(e);
},destroy:function(){
this._cleanupHandlers();
delete this.child;
delete this.container;
delete this.cover;
delete this.fake;
this.inherited(arguments);
}});
var _781=_75f("dijit.layout._Gutter",[_767,_768],{templateString:"<div class=\"dijitGutter\" role=\"presentation\"></div>",postMixInProperties:function(){
this.inherited(arguments);
this.horizontal=/top|bottom/.test(this.region);
},buildRendering:function(){
this.inherited(arguments);
_760.add(this.domNode,"dijitGutter"+(this.horizontal?"H":"V"));
}});
var _782=_75f("dijit.layout.BorderContainer",_769,{design:"headline",gutters:true,liveSplitters:true,persist:false,baseClass:"dijitBorderContainer",_splitterClass:_76b,postMixInProperties:function(){
if(!this.gutters){
this.baseClass+="NoGutter";
}
this.inherited(arguments);
},startup:function(){
if(this._started){
return;
}
_75d.forEach(this.getChildren(),this._setupChild,this);
this.inherited(arguments);
},_setupChild:function(_783){
var _784=_783.region;
if(_784){
this.inherited(arguments);
_760.add(_783.domNode,this.baseClass+"Pane");
var ltr=this.isLeftToRight();
if(_784=="leading"){
_784=ltr?"left":"right";
}
if(_784=="trailing"){
_784=ltr?"right":"left";
}
if(_784!="center"&&(_783.splitter||this.gutters)&&!_783._splitterWidget){
var _785=_783.splitter?this._splitterClass:_781;
if(lang.isString(_785)){
_785=lang.getObject(_785);
}
var _786=new _785({id:_783.id+"_splitter",container:this,child:_783,region:_784,live:this.liveSplitters});
_786.isSplitter=true;
_783._splitterWidget=_786;
_761.place(_786.domNode,_783.domNode,"after");
_786.startup();
}
_783.region=_784;
}
},layout:function(){
this._layoutChildren();
},addChild:function(_787,_788){
this.inherited(arguments);
if(this._started){
this.layout();
}
},removeChild:function(_789){
var _78a=_789.region;
var _78b=_789._splitterWidget;
if(_78b){
_78b.destroy();
delete _789._splitterWidget;
}
this.inherited(arguments);
if(this._started){
this._layoutChildren();
}
_760.remove(_789.domNode,this.baseClass+"Pane");
_763.set(_789.domNode,{top:"auto",bottom:"auto",left:"auto",right:"auto",position:"static"});
_763.set(_789.domNode,_78a=="top"||_78a=="bottom"?"width":"height","auto");
},getChildren:function(){
return _75d.filter(this.inherited(arguments),function(_78c){
return !_78c.isSplitter;
});
},getSplitter:function(_78d){
return _75d.filter(this.getChildren(),function(_78e){
return _78e.region==_78d;
})[0]._splitterWidget;
},resize:function(_78f,_790){
if(!this.cs||!this.pe){
var node=this.domNode;
this.cs=_763.getComputedStyle(node);
this.pe=_762.getPadExtents(node,this.cs);
this.pe.r=_763.toPixelValue(node,this.cs.paddingRight);
this.pe.b=_763.toPixelValue(node,this.cs.paddingBottom);
_763.set(node,"padding","0px");
}
this.inherited(arguments);
},_layoutChildren:function(_791,_792){
if(!this._borderBox||!this._borderBox.h){
return;
}
var _793=_75d.map(this.getChildren(),function(_794,idx){
return {pane:_794,weight:[_794.region=="center"?Infinity:0,_794.layoutPriority,(this.design=="sidebar"?1:-1)*(/top|bottom/.test(_794.region)?1:-1),idx]};
},this);
_793.sort(function(a,b){
var aw=a.weight,bw=b.weight;
for(var i=0;i<aw.length;i++){
if(aw[i]!=bw[i]){
return aw[i]-bw[i];
}
}
return 0;
});
var _795=[];
_75d.forEach(_793,function(_796){
var pane=_796.pane;
_795.push(pane);
if(pane._splitterWidget){
_795.push(pane._splitterWidget);
}
});
var dim={l:this.pe.l,t:this.pe.t,w:this._borderBox.w-this.pe.w,h:this._borderBox.h-this.pe.h};
_76a.layoutChildren(this.domNode,dim,_795,_791,_792);
},destroyRecursive:function(){
_75d.forEach(this.getChildren(),function(_797){
var _798=_797._splitterWidget;
if(_798){
_798.destroy();
}
delete _797._splitterWidget;
});
this.inherited(arguments);
}});
_782.ChildWidgetProperties={region:"",layoutPriority:0,splitter:false,minSize:0,maxSize:Infinity};
lang.extend(_766,_782.ChildWidgetProperties);
_782._Splitter=_76b;
_782._Gutter=_781;
return _782;
});
},"dojo/number":function(){
define(["./_base/lang","./i18n","./i18n!./cldr/nls/number","./string","./regexp"],function(lang,i18n,_799,_79a,_79b){
var _79c={};
lang.setObject("dojo.number",_79c);
_79c.format=function(_79d,_79e){
_79e=lang.mixin({},_79e||{});
var _79f=i18n.normalizeLocale(_79e.locale),_7a0=i18n.getLocalization("dojo.cldr","number",_79f);
_79e.customs=_7a0;
var _7a1=_79e.pattern||_7a0[(_79e.type||"decimal")+"Format"];
if(isNaN(_79d)||Math.abs(_79d)==Infinity){
return null;
}
return _79c._applyPattern(_79d,_7a1,_79e);
};
_79c._numberPatternRE=/[#0,]*[#0](?:\.0*#*)?/;
_79c._applyPattern=function(_7a2,_7a3,_7a4){
_7a4=_7a4||{};
var _7a5=_7a4.customs.group,_7a6=_7a4.customs.decimal,_7a7=_7a3.split(";"),_7a8=_7a7[0];
_7a3=_7a7[(_7a2<0)?1:0]||("-"+_7a8);
if(_7a3.indexOf("%")!=-1){
_7a2*=100;
}else{
if(_7a3.indexOf("‰")!=-1){
_7a2*=1000;
}else{
if(_7a3.indexOf("¤")!=-1){
_7a5=_7a4.customs.currencyGroup||_7a5;
_7a6=_7a4.customs.currencyDecimal||_7a6;
_7a3=_7a3.replace(/\u00a4{1,3}/,function(_7a9){
var prop=["symbol","currency","displayName"][_7a9.length-1];
return _7a4[prop]||_7a4.currency||"";
});
}else{
if(_7a3.indexOf("E")!=-1){
throw new Error("exponential notation not supported");
}
}
}
}
var _7aa=_79c._numberPatternRE;
var _7ab=_7a8.match(_7aa);
if(!_7ab){
throw new Error("unable to find a number expression in pattern: "+_7a3);
}
if(_7a4.fractional===false){
_7a4.places=0;
}
return _7a3.replace(_7aa,_79c._formatAbsolute(_7a2,_7ab[0],{decimal:_7a6,group:_7a5,places:_7a4.places,round:_7a4.round}));
};
_79c.round=function(_7ac,_7ad,_7ae){
var _7af=10/(_7ae||10);
return (_7af*+_7ac).toFixed(_7ad)/_7af;
};
if((0.9).toFixed()==0){
var _7b0=_79c.round;
_79c.round=function(v,p,m){
var d=Math.pow(10,-p||0),a=Math.abs(v);
if(!v||a>=d){
d=0;
}else{
a/=d;
if(a<0.5||a>=0.95){
d=0;
}
}
return _7b0(v,p,m)+(v>0?d:-d);
};
}
_79c._formatAbsolute=function(_7b1,_7b2,_7b3){
_7b3=_7b3||{};
if(_7b3.places===true){
_7b3.places=0;
}
if(_7b3.places===Infinity){
_7b3.places=6;
}
var _7b4=_7b2.split("."),_7b5=typeof _7b3.places=="string"&&_7b3.places.indexOf(","),_7b6=_7b3.places;
if(_7b5){
_7b6=_7b3.places.substring(_7b5+1);
}else{
if(!(_7b6>=0)){
_7b6=(_7b4[1]||[]).length;
}
}
if(!(_7b3.round<0)){
_7b1=_79c.round(_7b1,_7b6,_7b3.round);
}
var _7b7=String(Math.abs(_7b1)).split("."),_7b8=_7b7[1]||"";
if(_7b4[1]||_7b3.places){
if(_7b5){
_7b3.places=_7b3.places.substring(0,_7b5);
}
var pad=_7b3.places!==undefined?_7b3.places:(_7b4[1]&&_7b4[1].lastIndexOf("0")+1);
if(pad>_7b8.length){
_7b7[1]=_79a.pad(_7b8,pad,"0",true);
}
if(_7b6<_7b8.length){
_7b7[1]=_7b8.substr(0,_7b6);
}
}else{
if(_7b7[1]){
_7b7.pop();
}
}
var _7b9=_7b4[0].replace(",","");
pad=_7b9.indexOf("0");
if(pad!=-1){
pad=_7b9.length-pad;
if(pad>_7b7[0].length){
_7b7[0]=_79a.pad(_7b7[0],pad);
}
if(_7b9.indexOf("#")==-1){
_7b7[0]=_7b7[0].substr(_7b7[0].length-pad);
}
}
var _7ba=_7b4[0].lastIndexOf(","),_7bb,_7bc;
if(_7ba!=-1){
_7bb=_7b4[0].length-_7ba-1;
var _7bd=_7b4[0].substr(0,_7ba);
_7ba=_7bd.lastIndexOf(",");
if(_7ba!=-1){
_7bc=_7bd.length-_7ba-1;
}
}
var _7be=[];
for(var _7bf=_7b7[0];_7bf;){
var off=_7bf.length-_7bb;
_7be.push((off>0)?_7bf.substr(off):_7bf);
_7bf=(off>0)?_7bf.slice(0,off):"";
if(_7bc){
_7bb=_7bc;
delete _7bc;
}
}
_7b7[0]=_7be.reverse().join(_7b3.group||",");
return _7b7.join(_7b3.decimal||".");
};
_79c.regexp=function(_7c0){
return _79c._parseInfo(_7c0).regexp;
};
_79c._parseInfo=function(_7c1){
_7c1=_7c1||{};
var _7c2=i18n.normalizeLocale(_7c1.locale),_7c3=i18n.getLocalization("dojo.cldr","number",_7c2),_7c4=_7c1.pattern||_7c3[(_7c1.type||"decimal")+"Format"],_7c5=_7c3.group,_7c6=_7c3.decimal,_7c7=1;
if(_7c4.indexOf("%")!=-1){
_7c7/=100;
}else{
if(_7c4.indexOf("‰")!=-1){
_7c7/=1000;
}else{
var _7c8=_7c4.indexOf("¤")!=-1;
if(_7c8){
_7c5=_7c3.currencyGroup||_7c5;
_7c6=_7c3.currencyDecimal||_7c6;
}
}
}
var _7c9=_7c4.split(";");
if(_7c9.length==1){
_7c9.push("-"+_7c9[0]);
}
var re=_79b.buildGroupRE(_7c9,function(_7ca){
_7ca="(?:"+_79b.escapeString(_7ca,".")+")";
return _7ca.replace(_79c._numberPatternRE,function(_7cb){
var _7cc={signed:false,separator:_7c1.strict?_7c5:[_7c5,""],fractional:_7c1.fractional,decimal:_7c6,exponent:false},_7cd=_7cb.split("."),_7ce=_7c1.places;
if(_7cd.length==1&&_7c7!=1){
_7cd[1]="###";
}
if(_7cd.length==1||_7ce===0){
_7cc.fractional=false;
}else{
if(_7ce===undefined){
_7ce=_7c1.pattern?_7cd[1].lastIndexOf("0")+1:Infinity;
}
if(_7ce&&_7c1.fractional==undefined){
_7cc.fractional=true;
}
if(!_7c1.places&&(_7ce<_7cd[1].length)){
_7ce+=","+_7cd[1].length;
}
_7cc.places=_7ce;
}
var _7cf=_7cd[0].split(",");
if(_7cf.length>1){
_7cc.groupSize=_7cf.pop().length;
if(_7cf.length>1){
_7cc.groupSize2=_7cf.pop().length;
}
}
return "("+_79c._realNumberRegexp(_7cc)+")";
});
},true);
if(_7c8){
re=re.replace(/([\s\xa0]*)(\u00a4{1,3})([\s\xa0]*)/g,function(_7d0,_7d1,_7d2,_7d3){
var prop=["symbol","currency","displayName"][_7d2.length-1],_7d4=_79b.escapeString(_7c1[prop]||_7c1.currency||"");
_7d1=_7d1?"[\\s\\xa0]":"";
_7d3=_7d3?"[\\s\\xa0]":"";
if(!_7c1.strict){
if(_7d1){
_7d1+="*";
}
if(_7d3){
_7d3+="*";
}
return "(?:"+_7d1+_7d4+_7d3+")?";
}
return _7d1+_7d4+_7d3;
});
}
return {regexp:re.replace(/[\xa0 ]/g,"[\\s\\xa0]"),group:_7c5,decimal:_7c6,factor:_7c7};
};
_79c.parse=function(_7d5,_7d6){
var info=_79c._parseInfo(_7d6),_7d7=(new RegExp("^"+info.regexp+"$")).exec(_7d5);
if(!_7d7){
return NaN;
}
var _7d8=_7d7[1];
if(!_7d7[1]){
if(!_7d7[2]){
return NaN;
}
_7d8=_7d7[2];
info.factor*=-1;
}
_7d8=_7d8.replace(new RegExp("["+info.group+"\\s\\xa0"+"]","g"),"").replace(info.decimal,".");
return _7d8*info.factor;
};
_79c._realNumberRegexp=function(_7d9){
_7d9=_7d9||{};
if(!("places" in _7d9)){
_7d9.places=Infinity;
}
if(typeof _7d9.decimal!="string"){
_7d9.decimal=".";
}
if(!("fractional" in _7d9)||/^0/.test(_7d9.places)){
_7d9.fractional=[true,false];
}
if(!("exponent" in _7d9)){
_7d9.exponent=[true,false];
}
if(!("eSigned" in _7d9)){
_7d9.eSigned=[true,false];
}
var _7da=_79c._integerRegexp(_7d9),_7db=_79b.buildGroupRE(_7d9.fractional,function(q){
var re="";
if(q&&(_7d9.places!==0)){
re="\\"+_7d9.decimal;
if(_7d9.places==Infinity){
re="(?:"+re+"\\d+)?";
}else{
re+="\\d{"+_7d9.places+"}";
}
}
return re;
},true);
var _7dc=_79b.buildGroupRE(_7d9.exponent,function(q){
if(q){
return "([eE]"+_79c._integerRegexp({signed:_7d9.eSigned})+")";
}
return "";
});
var _7dd=_7da+_7db;
if(_7db){
_7dd="(?:(?:"+_7dd+")|(?:"+_7db+"))";
}
return _7dd+_7dc;
};
_79c._integerRegexp=function(_7de){
_7de=_7de||{};
if(!("signed" in _7de)){
_7de.signed=[true,false];
}
if(!("separator" in _7de)){
_7de.separator="";
}else{
if(!("groupSize" in _7de)){
_7de.groupSize=3;
}
}
var _7df=_79b.buildGroupRE(_7de.signed,function(q){
return q?"[-+]":"";
},true);
var _7e0=_79b.buildGroupRE(_7de.separator,function(sep){
if(!sep){
return "(?:\\d+)";
}
sep=_79b.escapeString(sep);
if(sep==" "){
sep="\\s";
}else{
if(sep==" "){
sep="\\s\\xa0";
}
}
var grp=_7de.groupSize,grp2=_7de.groupSize2;
if(grp2){
var _7e1="(?:0|[1-9]\\d{0,"+(grp2-1)+"}(?:["+sep+"]\\d{"+grp2+"})*["+sep+"]\\d{"+grp+"})";
return ((grp-grp2)>0)?"(?:"+_7e1+"|(?:0|[1-9]\\d{0,"+(grp-1)+"}))":_7e1;
}
return "(?:0|[1-9]\\d{0,"+(grp-1)+"}(?:["+sep+"]\\d{"+grp+"})*)";
},true);
return _7df+_7e0;
};
return _79c;
});
},"dojo/data/util/filter":function(){
define(["../../_base/lang"],function(lang){
var _7e2={};
lang.setObject("dojo.data.util.filter",_7e2);
_7e2.patternToRegExp=function(_7e3,_7e4){
var rxp="^";
var c=null;
for(var i=0;i<_7e3.length;i++){
c=_7e3.charAt(i);
switch(c){
case "\\":
rxp+=c;
i++;
rxp+=_7e3.charAt(i);
break;
case "*":
rxp+=".*";
break;
case "?":
rxp+=".";
break;
case "$":
case "^":
case "/":
case "+":
case ".":
case "|":
case "(":
case ")":
case "{":
case "}":
case "[":
case "]":
rxp+="\\";
default:
rxp+=c;
}
}
rxp+="$";
if(_7e4){
return new RegExp(rxp,"mi");
}else{
return new RegExp(rxp,"m");
}
};
return _7e2;
});
},"dijit/_WidgetsInTemplateMixin":function(){
define(["dojo/_base/array","dojo/_base/declare","dojo/parser"],function(_7e5,_7e6,_7e7){
return _7e6("dijit._WidgetsInTemplateMixin",null,{_earlyTemplatedStartup:false,widgetsInTemplate:true,_beforeFillContent:function(){
if(this.widgetsInTemplate){
var node=this.domNode;
var cw=(this._startupWidgets=_7e7.parse(node,{noStart:!this._earlyTemplatedStartup,template:true,inherited:{dir:this.dir,lang:this.lang,textDir:this.textDir},propsThis:this,scope:"dojo"}));
if(!cw.isFulfilled()){
throw new Error(this.declaredClass+": parser returned unfilled promise (probably waiting for module auto-load), "+"unsupported by _WidgetsInTemplateMixin.   Must pre-load all supporting widgets before instantiation.");
}
this._attachTemplateNodes(cw,function(n,p){
return n[p];
});
}
},startup:function(){
_7e5.forEach(this._startupWidgets,function(w){
if(w&&!w._started&&w.startup){
w.startup();
}
});
this.inherited(arguments);
}});
});
},"dijit/form/HorizontalRuleLabels":function(){
define(["dojo/_base/declare","dojo/number","dojo/query","./HorizontalRule"],function(_7e8,_7e9,_7ea,_7eb){
return _7e8("dijit.form.HorizontalRuleLabels",_7eb,{templateString:"<div class=\"dijitRuleContainer dijitRuleContainerH dijitRuleLabelsContainer dijitRuleLabelsContainerH\"></div>",labelStyle:"",labels:[],numericMargin:0,minimum:0,maximum:1,constraints:{pattern:"#%"},_positionPrefix:"<div class=\"dijitRuleLabelContainer dijitRuleLabelContainerH\" style=\"left:",_labelPrefix:"\"><div class=\"dijitRuleLabel dijitRuleLabelH\">",_suffix:"</div></div>",_calcPosition:function(pos){
return pos;
},_genHTML:function(pos,ndx){
return this._positionPrefix+this._calcPosition(pos)+this._positionSuffix+this.labelStyle+this._labelPrefix+this.labels[ndx]+this._suffix;
},getLabels:function(){
var _7ec=this.labels;
if(!_7ec.length&&this.srcNodeRef){
_7ec=_7ea("> li",this.srcNodeRef).map(function(node){
return String(node.innerHTML);
});
}
if(!_7ec.length&&this.count>1){
var _7ed=this.minimum;
var inc=(this.maximum-_7ed)/(this.count-1);
for(var i=0;i<this.count;i++){
_7ec.push((i<this.numericMargin||i>=(this.count-this.numericMargin))?"":_7e9.format(_7ed,this.constraints));
_7ed+=inc;
}
}
return _7ec;
},postMixInProperties:function(){
this.inherited(arguments);
this.labels=this.getLabels();
this.count=this.labels.length;
}});
});
},"url:dijit/templates/MenuBarItem.html":"<div class=\"dijitReset dijitInline dijitMenuItem dijitMenuItemLabel\" data-dojo-attach-point=\"focusNode\"\n\t \trole=\"menuitem\" tabIndex=\"-1\">\n\t<span data-dojo-attach-point=\"containerNode\"></span>\n</div>\n","dijit/form/FilteringSelect":function(){
define(["dojo/data/util/filter","dojo/_base/declare","dojo/_base/lang","dojo/when","./MappedTextBox","./ComboBoxMixin"],function(_7ee,_7ef,lang,when,_7f0,_7f1){
return _7ef("dijit.form.FilteringSelect",[_7f0,_7f1],{required:true,_lastDisplayedValue:"",_isValidSubset:function(){
return this._opened;
},isValid:function(){
return !!this.item||(!this.required&&this.get("displayedValue")=="");
},_refreshState:function(){
if(!this.searchTimer){
this.inherited(arguments);
}
},_callbackSetLabel:function(_7f2,_7f3,_7f4,_7f5){
if((_7f3&&_7f3[this.searchAttr]!==this._lastQuery)||(!_7f3&&_7f2.length&&this.store.getIdentity(_7f2[0])!=this._lastQuery)){
return;
}
if(!_7f2.length){
this.set("value","",_7f5||(_7f5===undefined&&!this.focused),this.textbox.value,null);
}else{
this.set("item",_7f2[0],_7f5);
}
},_openResultList:function(_7f6,_7f7,_7f8){
if(_7f7[this.searchAttr]!==this._lastQuery){
return;
}
this.inherited(arguments);
if(this.item===undefined){
this.validate(true);
}
},_getValueAttr:function(){
return this.valueNode.value;
},_getValueField:function(){
return "value";
},_setValueAttr:function(_7f9,_7fa,_7fb,item){
if(!this._onChangeActive){
_7fa=null;
}
if(item===undefined){
if(_7f9===null||_7f9===""){
_7f9="";
if(!lang.isString(_7fb)){
this._setDisplayedValueAttr(_7fb||"",_7fa);
return;
}
}
var self=this;
this._lastQuery=_7f9;
when(this.store.get(_7f9),function(item){
self._callbackSetLabel(item?[item]:[],undefined,undefined,_7fa);
});
}else{
this.valueNode.value=_7f9;
this.inherited(arguments);
}
},_setItemAttr:function(item,_7fc,_7fd){
this.inherited(arguments);
this._lastDisplayedValue=this.textbox.value;
},_getDisplayQueryString:function(text){
return text.replace(/([\\\*\?])/g,"\\$1");
},_setDisplayedValueAttr:function(_7fe,_7ff){
if(_7fe==null){
_7fe="";
}
if(!this._created){
if(!("displayedValue" in this.params)){
return;
}
_7ff=false;
}
if(this.store){
this.closeDropDown();
var _800=lang.clone(this.query);
var qs=this._getDisplayQueryString(_7fe),q;
if(this.store._oldAPI){
q=qs;
}else{
q=_7ee.patternToRegExp(qs,this.ignoreCase);
q.toString=function(){
return qs;
};
}
this._lastQuery=_800[this.searchAttr]=q;
this.textbox.value=_7fe;
this._lastDisplayedValue=_7fe;
this._set("displayedValue",_7fe);
var _801=this;
var _802={ignoreCase:this.ignoreCase,deep:true};
lang.mixin(_802,this.fetchProperties);
this._fetchHandle=this.store.query(_800,_802);
when(this._fetchHandle,function(_803){
_801._fetchHandle=null;
_801._callbackSetLabel(_803||[],_800,_802,_7ff);
},function(err){
_801._fetchHandle=null;
if(!_801._cancelingQuery){
console.error("dijit.form.FilteringSelect: "+err.toString());
}
});
}
},undo:function(){
this.set("displayedValue",this._lastDisplayedValue);
}});
});
},"dojo/data/util/sorter":function(){
define(["../../_base/lang"],function(lang){
var _804={};
lang.setObject("dojo.data.util.sorter",_804);
_804.basicComparator=function(a,b){
var r=-1;
if(a===null){
a=undefined;
}
if(b===null){
b=undefined;
}
if(a==b){
r=0;
}else{
if(a>b||a==null){
r=1;
}
}
return r;
};
_804.createSortFunction=function(_805,_806){
var _807=[];
function _808(attr,dir,comp,s){
return function(_809,_80a){
var a=s.getValue(_809,attr);
var b=s.getValue(_80a,attr);
return dir*comp(a,b);
};
};
var _80b;
var map=_806.comparatorMap;
var bc=_804.basicComparator;
for(var i=0;i<_805.length;i++){
_80b=_805[i];
var attr=_80b.attribute;
if(attr){
var dir=(_80b.descending)?-1:1;
var comp=bc;
if(map){
if(typeof attr!=="string"&&("toString" in attr)){
attr=attr.toString();
}
comp=map[attr]||bc;
}
_807.push(_808(attr,dir,comp,_806));
}
}
return function(rowA,rowB){
var i=0;
while(i<_807.length){
var ret=_807[i++](rowA,rowB);
if(ret!==0){
return ret;
}
}
return 0;
};
};
return _804;
});
},"dijit/form/_ButtonMixin":function(){
define(["dojo/_base/declare","dojo/dom","dojo/_base/event","../registry"],function(_80c,dom,_80d,_80e){
return _80c("dijit.form._ButtonMixin",null,{label:"",type:"button",_onClick:function(e){
if(this.disabled){
_80d.stop(e);
return false;
}
var _80f=this.onClick(e)===false;
if(!_80f&&this.type=="submit"&&!(this.valueNode||this.focusNode).form){
for(var node=this.domNode;node.parentNode;node=node.parentNode){
var _810=_80e.byNode(node);
if(_810&&typeof _810._onSubmit=="function"){
_810._onSubmit(e);
_80f=true;
break;
}
}
}
if(_80f){
e.preventDefault();
}
return !_80f;
},postCreate:function(){
this.inherited(arguments);
dom.setSelectable(this.focusNode,false);
},onClick:function(){
return true;
},_setLabelAttr:function(_811){
this._set("label",_811);
(this.containerNode||this.focusNode).innerHTML=_811;
}});
});
},"dojo/colors":function(){
define(["./_base/kernel","./_base/lang","./_base/Color","./_base/array"],function(dojo,lang,_812,_813){
var _814={};
lang.setObject("dojo.colors",_814);
var _815=function(m1,m2,h){
if(h<0){
++h;
}
if(h>1){
--h;
}
var h6=6*h;
if(h6<1){
return m1+(m2-m1)*h6;
}
if(2*h<1){
return m2;
}
if(3*h<2){
return m1+(m2-m1)*(2/3-h)*6;
}
return m1;
};
dojo.colorFromRgb=_812.fromRgb=function(_816,obj){
var m=_816.toLowerCase().match(/^(rgba?|hsla?)\(([\s\.\-,%0-9]+)\)/);
if(m){
var c=m[2].split(/\s*,\s*/),l=c.length,t=m[1],a;
if((t=="rgb"&&l==3)||(t=="rgba"&&l==4)){
var r=c[0];
if(r.charAt(r.length-1)=="%"){
a=_813.map(c,function(x){
return parseFloat(x)*2.56;
});
if(l==4){
a[3]=c[3];
}
return _812.fromArray(a,obj);
}
return _812.fromArray(c,obj);
}
if((t=="hsl"&&l==3)||(t=="hsla"&&l==4)){
var H=((parseFloat(c[0])%360)+360)%360/360,S=parseFloat(c[1])/100,L=parseFloat(c[2])/100,m2=L<=0.5?L*(S+1):L+S-L*S,m1=2*L-m2;
a=[_815(m1,m2,H+1/3)*256,_815(m1,m2,H)*256,_815(m1,m2,H-1/3)*256,1];
if(l==4){
a[3]=c[3];
}
return _812.fromArray(a,obj);
}
}
return null;
};
var _817=function(c,low,high){
c=Number(c);
return isNaN(c)?high:c<low?low:c>high?high:c;
};
_812.prototype.sanitize=function(){
var t=this;
t.r=Math.round(_817(t.r,0,255));
t.g=Math.round(_817(t.g,0,255));
t.b=Math.round(_817(t.b,0,255));
t.a=_817(t.a,0,1);
return this;
};
_814.makeGrey=_812.makeGrey=function(g,a){
return _812.fromArray([g,g,g,a]);
};
lang.mixin(_812.named,{"aliceblue":[240,248,255],"antiquewhite":[250,235,215],"aquamarine":[127,255,212],"azure":[240,255,255],"beige":[245,245,220],"bisque":[255,228,196],"blanchedalmond":[255,235,205],"blueviolet":[138,43,226],"brown":[165,42,42],"burlywood":[222,184,135],"cadetblue":[95,158,160],"chartreuse":[127,255,0],"chocolate":[210,105,30],"coral":[255,127,80],"cornflowerblue":[100,149,237],"cornsilk":[255,248,220],"crimson":[220,20,60],"cyan":[0,255,255],"darkblue":[0,0,139],"darkcyan":[0,139,139],"darkgoldenrod":[184,134,11],"darkgray":[169,169,169],"darkgreen":[0,100,0],"darkgrey":[169,169,169],"darkkhaki":[189,183,107],"darkmagenta":[139,0,139],"darkolivegreen":[85,107,47],"darkorange":[255,140,0],"darkorchid":[153,50,204],"darkred":[139,0,0],"darksalmon":[233,150,122],"darkseagreen":[143,188,143],"darkslateblue":[72,61,139],"darkslategray":[47,79,79],"darkslategrey":[47,79,79],"darkturquoise":[0,206,209],"darkviolet":[148,0,211],"deeppink":[255,20,147],"deepskyblue":[0,191,255],"dimgray":[105,105,105],"dimgrey":[105,105,105],"dodgerblue":[30,144,255],"firebrick":[178,34,34],"floralwhite":[255,250,240],"forestgreen":[34,139,34],"gainsboro":[220,220,220],"ghostwhite":[248,248,255],"gold":[255,215,0],"goldenrod":[218,165,32],"greenyellow":[173,255,47],"grey":[128,128,128],"honeydew":[240,255,240],"hotpink":[255,105,180],"indianred":[205,92,92],"indigo":[75,0,130],"ivory":[255,255,240],"khaki":[240,230,140],"lavender":[230,230,250],"lavenderblush":[255,240,245],"lawngreen":[124,252,0],"lemonchiffon":[255,250,205],"lightblue":[173,216,230],"lightcoral":[240,128,128],"lightcyan":[224,255,255],"lightgoldenrodyellow":[250,250,210],"lightgray":[211,211,211],"lightgreen":[144,238,144],"lightgrey":[211,211,211],"lightpink":[255,182,193],"lightsalmon":[255,160,122],"lightseagreen":[32,178,170],"lightskyblue":[135,206,250],"lightslategray":[119,136,153],"lightslategrey":[119,136,153],"lightsteelblue":[176,196,222],"lightyellow":[255,255,224],"limegreen":[50,205,50],"linen":[250,240,230],"magenta":[255,0,255],"mediumaquamarine":[102,205,170],"mediumblue":[0,0,205],"mediumorchid":[186,85,211],"mediumpurple":[147,112,219],"mediumseagreen":[60,179,113],"mediumslateblue":[123,104,238],"mediumspringgreen":[0,250,154],"mediumturquoise":[72,209,204],"mediumvioletred":[199,21,133],"midnightblue":[25,25,112],"mintcream":[245,255,250],"mistyrose":[255,228,225],"moccasin":[255,228,181],"navajowhite":[255,222,173],"oldlace":[253,245,230],"olivedrab":[107,142,35],"orange":[255,165,0],"orangered":[255,69,0],"orchid":[218,112,214],"palegoldenrod":[238,232,170],"palegreen":[152,251,152],"paleturquoise":[175,238,238],"palevioletred":[219,112,147],"papayawhip":[255,239,213],"peachpuff":[255,218,185],"peru":[205,133,63],"pink":[255,192,203],"plum":[221,160,221],"powderblue":[176,224,230],"rosybrown":[188,143,143],"royalblue":[65,105,225],"saddlebrown":[139,69,19],"salmon":[250,128,114],"sandybrown":[244,164,96],"seagreen":[46,139,87],"seashell":[255,245,238],"sienna":[160,82,45],"skyblue":[135,206,235],"slateblue":[106,90,205],"slategray":[112,128,144],"slategrey":[112,128,144],"snow":[255,250,250],"springgreen":[0,255,127],"steelblue":[70,130,180],"tan":[210,180,140],"thistle":[216,191,216],"tomato":[255,99,71],"turquoise":[64,224,208],"violet":[238,130,238],"wheat":[245,222,179],"whitesmoke":[245,245,245],"yellowgreen":[154,205,50]});
return _812;
});
},"url:dijit/form/templates/Spinner.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\"\n\tid=\"widget_${id}\" role=\"presentation\"\n\t><div class=\"dijitReset dijitButtonNode dijitSpinnerButtonContainer\"\n\t\t><input class=\"dijitReset dijitInputField dijitSpinnerButtonInner\" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t/><div class=\"dijitReset dijitLeft dijitButtonNode dijitArrowButton dijitUpArrowButton\"\n\t\t\tdata-dojo-attach-point=\"upArrowNode\"\n\t\t\t><div class=\"dijitArrowButtonInner\"\n\t\t\t\t><input class=\"dijitReset dijitInputField\" value=\"&#9650; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t\t\t\t${_buttonInputDisabled}\n\t\t\t/></div\n\t\t></div\n\t\t><div class=\"dijitReset dijitLeft dijitButtonNode dijitArrowButton dijitDownArrowButton\"\n\t\t\tdata-dojo-attach-point=\"downArrowNode\"\n\t\t\t><div class=\"dijitArrowButtonInner\"\n\t\t\t\t><input class=\"dijitReset dijitInputField\" value=\"&#9660; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t\t\t\t${_buttonInputDisabled}\n\t\t\t/></div\n\t\t></div\n\t></div\n\t><div class='dijitReset dijitValidationContainer'\n\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t/></div\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class='dijitReset dijitInputInner' data-dojo-attach-point=\"textbox,focusNode\" type=\"${type}\" data-dojo-attach-event=\"onkeypress:_onKeyPress\"\n\t\t\trole=\"spinbutton\" autocomplete=\"off\" ${!nameAttrSetting}\n\t/></div\n></div>\n","dijit/tree/_dndContainer":function(){
define(["dojo/aspect","dojo/_base/declare","dojo/dom-class","dojo/_base/event","dojo/_base/lang","dojo/on","dojo/touch"],function(_818,_819,_81a,_81b,lang,on,_81c){
return _819("dijit.tree._dndContainer",null,{constructor:function(tree,_81d){
this.tree=tree;
this.node=tree.domNode;
lang.mixin(this,_81d);
this.current=null;
this.containerState="";
_81a.add(this.node,"dojoDndContainer");
this.events=[on(this.node,_81c.enter,lang.hitch(this,"onOverEvent")),on(this.node,_81c.leave,lang.hitch(this,"onOutEvent")),_818.after(this.tree,"_onNodeMouseEnter",lang.hitch(this,"onMouseOver"),true),_818.after(this.tree,"_onNodeMouseLeave",lang.hitch(this,"onMouseOut"),true),on(this.node,"dragstart",lang.hitch(_81b,"stop")),on(this.node,"selectstart",lang.hitch(_81b,"stop"))];
},destroy:function(){
var h;
while(h=this.events.pop()){
h.remove();
}
this.node=this.parent=null;
},onMouseOver:function(_81e){
this.current=_81e;
},onMouseOut:function(){
this.current=null;
},_changeState:function(type,_81f){
var _820="dojoDnd"+type;
var _821=type.toLowerCase()+"State";
_81a.replace(this.node,_820+_81f,_820+this[_821]);
this[_821]=_81f;
},_addItemClass:function(node,type){
_81a.add(node,"dojoDndItem"+type);
},_removeItemClass:function(node,type){
_81a.remove(node,"dojoDndItem"+type);
},onOverEvent:function(){
this._changeState("Container","Over");
},onOutEvent:function(){
this._changeState("Container","");
}});
});
},"dojo/date/locale":function(){
define(["../_base/lang","../_base/array","../date","../cldr/supplemental","../i18n","../regexp","../string","../i18n!../cldr/nls/gregorian","module"],function(lang,_822,date,_823,i18n,_824,_825,_826,_827){
var _828={};
lang.setObject(_827.id.replace(/\//g,"."),_828);
function _829(_82a,_82b,_82c,_82d){
return _82d.replace(/([a-z])\1*/ig,function(_82e){
var s,pad,c=_82e.charAt(0),l=_82e.length,_82f=["abbr","wide","narrow"];
switch(c){
case "G":
s=_82b[(l<4)?"eraAbbr":"eraNames"][_82a.getFullYear()<0?0:1];
break;
case "y":
s=_82a.getFullYear();
switch(l){
case 1:
break;
case 2:
if(!_82c.fullYear){
s=String(s);
s=s.substr(s.length-2);
break;
}
default:
pad=true;
}
break;
case "Q":
case "q":
s=Math.ceil((_82a.getMonth()+1)/3);
pad=true;
break;
case "M":
case "L":
var m=_82a.getMonth();
if(l<3){
s=m+1;
pad=true;
}else{
var _830=["months",c=="L"?"standAlone":"format",_82f[l-3]].join("-");
s=_82b[_830][m];
}
break;
case "w":
var _831=0;
s=_828._getWeekOfYear(_82a,_831);
pad=true;
break;
case "d":
s=_82a.getDate();
pad=true;
break;
case "D":
s=_828._getDayOfYear(_82a);
pad=true;
break;
case "e":
case "c":
var d=_82a.getDay();
if(l<2){
s=(d-_823.getFirstDayOfWeek(_82c.locale)+8)%7;
break;
}
case "E":
d=_82a.getDay();
if(l<3){
s=d+1;
pad=true;
}else{
var _832=["days",c=="c"?"standAlone":"format",_82f[l-3]].join("-");
s=_82b[_832][d];
}
break;
case "a":
var _833=_82a.getHours()<12?"am":"pm";
s=_82c[_833]||_82b["dayPeriods-format-wide-"+_833];
break;
case "h":
case "H":
case "K":
case "k":
var h=_82a.getHours();
switch(c){
case "h":
s=(h%12)||12;
break;
case "H":
s=h;
break;
case "K":
s=(h%12);
break;
case "k":
s=h||24;
break;
}
pad=true;
break;
case "m":
s=_82a.getMinutes();
pad=true;
break;
case "s":
s=_82a.getSeconds();
pad=true;
break;
case "S":
s=Math.round(_82a.getMilliseconds()*Math.pow(10,l-3));
pad=true;
break;
case "v":
case "z":
s=_828._getZone(_82a,true,_82c);
if(s){
break;
}
l=4;
case "Z":
var _834=_828._getZone(_82a,false,_82c);
var tz=[(_834<=0?"+":"-"),_825.pad(Math.floor(Math.abs(_834)/60),2),_825.pad(Math.abs(_834)%60,2)];
if(l==4){
tz.splice(0,0,"GMT");
tz.splice(3,0,":");
}
s=tz.join("");
break;
default:
throw new Error("dojo.date.locale.format: invalid pattern char: "+_82d);
}
if(pad){
s=_825.pad(s,l);
}
return s;
});
};
_828._getZone=function(_835,_836,_837){
if(_836){
return date.getTimezoneName(_835);
}else{
return _835.getTimezoneOffset();
}
};
_828.format=function(_838,_839){
_839=_839||{};
var _83a=i18n.normalizeLocale(_839.locale),_83b=_839.formatLength||"short",_83c=_828._getGregorianBundle(_83a),str=[],_83d=lang.hitch(this,_829,_838,_83c,_839);
if(_839.selector=="year"){
return _83e(_83c["dateFormatItem-yyyy"]||"yyyy",_83d);
}
var _83f;
if(_839.selector!="date"){
_83f=_839.timePattern||_83c["timeFormat-"+_83b];
if(_83f){
str.push(_83e(_83f,_83d));
}
}
if(_839.selector!="time"){
_83f=_839.datePattern||_83c["dateFormat-"+_83b];
if(_83f){
str.push(_83e(_83f,_83d));
}
}
return str.length==1?str[0]:_83c["dateTimeFormat-"+_83b].replace(/\'/g,"").replace(/\{(\d+)\}/g,function(_840,key){
return str[key];
});
};
_828.regexp=function(_841){
return _828._parseInfo(_841).regexp;
};
_828._parseInfo=function(_842){
_842=_842||{};
var _843=i18n.normalizeLocale(_842.locale),_844=_828._getGregorianBundle(_843),_845=_842.formatLength||"short",_846=_842.datePattern||_844["dateFormat-"+_845],_847=_842.timePattern||_844["timeFormat-"+_845],_848;
if(_842.selector=="date"){
_848=_846;
}else{
if(_842.selector=="time"){
_848=_847;
}else{
_848=_844["dateTimeFormat-"+_845].replace(/\{(\d+)\}/g,function(_849,key){
return [_847,_846][key];
});
}
}
var _84a=[],re=_83e(_848,lang.hitch(this,_84b,_84a,_844,_842));
return {regexp:re,tokens:_84a,bundle:_844};
};
_828.parse=function(_84c,_84d){
var _84e=/[\u200E\u200F\u202A\u202E]/g,info=_828._parseInfo(_84d),_84f=info.tokens,_850=info.bundle,re=new RegExp("^"+info.regexp.replace(_84e,"")+"$",info.strict?"":"i"),_851=re.exec(_84c&&_84c.replace(_84e,""));
if(!_851){
return null;
}
var _852=["abbr","wide","narrow"],_853=[1970,0,1,0,0,0,0],amPm="",_854=_822.every(_851,function(v,i){
if(!i){
return true;
}
var _855=_84f[i-1],l=_855.length,c=_855.charAt(0);
switch(c){
case "y":
if(l!=2&&_84d.strict){
_853[0]=v;
}else{
if(v<100){
v=Number(v);
var year=""+new Date().getFullYear(),_856=year.substring(0,2)*100,_857=Math.min(Number(year.substring(2,4))+20,99);
_853[0]=(v<_857)?_856+v:_856-100+v;
}else{
if(_84d.strict){
return false;
}
_853[0]=v;
}
}
break;
case "M":
case "L":
if(l>2){
var _858=_850["months-"+(c=="L"?"standAlone":"format")+"-"+_852[l-3]].concat();
if(!_84d.strict){
v=v.replace(".","").toLowerCase();
_858=_822.map(_858,function(s){
return s.replace(".","").toLowerCase();
});
}
v=_822.indexOf(_858,v);
if(v==-1){
return false;
}
}else{
v--;
}
_853[1]=v;
break;
case "E":
case "e":
case "c":
var days=_850["days-"+(c=="c"?"standAlone":"format")+"-"+_852[l-3]].concat();
if(!_84d.strict){
v=v.toLowerCase();
days=_822.map(days,function(d){
return d.toLowerCase();
});
}
v=_822.indexOf(days,v);
if(v==-1){
return false;
}
break;
case "D":
_853[1]=0;
case "d":
_853[2]=v;
break;
case "a":
var am=_84d.am||_850["dayPeriods-format-wide-am"],pm=_84d.pm||_850["dayPeriods-format-wide-pm"];
if(!_84d.strict){
var _859=/\./g;
v=v.replace(_859,"").toLowerCase();
am=am.replace(_859,"").toLowerCase();
pm=pm.replace(_859,"").toLowerCase();
}
if(_84d.strict&&v!=am&&v!=pm){
return false;
}
amPm=(v==pm)?"p":(v==am)?"a":"";
break;
case "K":
if(v==24){
v=0;
}
case "h":
case "H":
case "k":
if(v>23){
return false;
}
_853[3]=v;
break;
case "m":
_853[4]=v;
break;
case "s":
_853[5]=v;
break;
case "S":
_853[6]=v;
}
return true;
});
var _85a=+_853[3];
if(amPm==="p"&&_85a<12){
_853[3]=_85a+12;
}else{
if(amPm==="a"&&_85a==12){
_853[3]=0;
}
}
var _85b=new Date(_853[0],_853[1],_853[2],_853[3],_853[4],_853[5],_853[6]);
if(_84d.strict){
_85b.setFullYear(_853[0]);
}
var _85c=_84f.join(""),_85d=_85c.indexOf("d")!=-1,_85e=_85c.indexOf("M")!=-1;
if(!_854||(_85e&&_85b.getMonth()>_853[1])||(_85d&&_85b.getDate()>_853[2])){
return null;
}
if((_85e&&_85b.getMonth()<_853[1])||(_85d&&_85b.getDate()<_853[2])){
_85b=date.add(_85b,"hour",1);
}
return _85b;
};
function _83e(_85f,_860,_861,_862){
var _863=function(x){
return x;
};
_860=_860||_863;
_861=_861||_863;
_862=_862||_863;
var _864=_85f.match(/(''|[^'])+/g),_865=_85f.charAt(0)=="'";
_822.forEach(_864,function(_866,i){
if(!_866){
_864[i]="";
}else{
_864[i]=(_865?_861:_860)(_866.replace(/''/g,"'"));
_865=!_865;
}
});
return _862(_864.join(""));
};
function _84b(_867,_868,_869,_86a){
_86a=_824.escapeString(_86a);
if(!_869.strict){
_86a=_86a.replace(" a"," ?a");
}
return _86a.replace(/([a-z])\1*/ig,function(_86b){
var s,c=_86b.charAt(0),l=_86b.length,p2="",p3="";
if(_869.strict){
if(l>1){
p2="0"+"{"+(l-1)+"}";
}
if(l>2){
p3="0"+"{"+(l-2)+"}";
}
}else{
p2="0?";
p3="0{0,2}";
}
switch(c){
case "y":
s="\\d{2,4}";
break;
case "M":
case "L":
s=(l>2)?"\\S+?":"1[0-2]|"+p2+"[1-9]";
break;
case "D":
s="[12][0-9][0-9]|3[0-5][0-9]|36[0-6]|"+p2+"[1-9][0-9]|"+p3+"[1-9]";
break;
case "d":
s="3[01]|[12]\\d|"+p2+"[1-9]";
break;
case "w":
s="[1-4][0-9]|5[0-3]|"+p2+"[1-9]";
break;
case "E":
case "e":
case "c":
s="\\S+";
break;
case "h":
s="1[0-2]|"+p2+"[1-9]";
break;
case "k":
s="1[01]|"+p2+"\\d";
break;
case "H":
s="1\\d|2[0-3]|"+p2+"\\d";
break;
case "K":
s="1\\d|2[0-4]|"+p2+"[1-9]";
break;
case "m":
case "s":
s="[0-5]\\d";
break;
case "S":
s="\\d{"+l+"}";
break;
case "a":
var am=_869.am||_868["dayPeriods-format-wide-am"],pm=_869.pm||_868["dayPeriods-format-wide-pm"];
s=am+"|"+pm;
if(!_869.strict){
if(am!=am.toLowerCase()){
s+="|"+am.toLowerCase();
}
if(pm!=pm.toLowerCase()){
s+="|"+pm.toLowerCase();
}
if(s.indexOf(".")!=-1){
s+="|"+s.replace(/\./g,"");
}
}
s=s.replace(/\./g,"\\.");
break;
default:
s=".*";
}
if(_867){
_867.push(_86b);
}
return "("+s+")";
}).replace(/[\xa0 ]/g,"[\\s\\xa0]");
};
var _86c=[];
_828.addCustomFormats=function(_86d,_86e){
_86c.push({pkg:_86d,name:_86e});
};
_828._getGregorianBundle=function(_86f){
var _870={};
_822.forEach(_86c,function(desc){
var _871=i18n.getLocalization(desc.pkg,desc.name,_86f);
_870=lang.mixin(_870,_871);
},this);
return _870;
};
_828.addCustomFormats(_827.id.replace(/\/date\/locale$/,".cldr"),"gregorian");
_828.getNames=function(item,type,_872,_873){
var _874,_875=_828._getGregorianBundle(_873),_876=[item,_872,type];
if(_872=="standAlone"){
var key=_876.join("-");
_874=_875[key];
if(_874[0]==1){
_874=undefined;
}
}
_876[1]="format";
return (_874||_875[_876.join("-")]).concat();
};
_828.isWeekend=function(_877,_878){
var _879=_823.getWeekend(_878),day=(_877||new Date()).getDay();
if(_879.end<_879.start){
_879.end+=7;
if(day<_879.start){
day+=7;
}
}
return day>=_879.start&&day<=_879.end;
};
_828._getDayOfYear=function(_87a){
return date.difference(new Date(_87a.getFullYear(),0,1,_87a.getHours()),_87a)+1;
};
_828._getWeekOfYear=function(_87b,_87c){
if(arguments.length==1){
_87c=0;
}
var _87d=new Date(_87b.getFullYear(),0,1).getDay(),adj=(_87d-_87c+7)%7,week=Math.floor((_828._getDayOfYear(_87b)+adj-1)/7);
if(_87d==_87c){
week++;
}
return week;
};
return _828;
});
},"url:dijit/templates/InlineEditBox.html":"<span data-dojo-attach-point=\"editNode\" role=\"presentation\" class=\"dijitReset dijitInline dijitOffScreen\"\n\tdata-dojo-attach-event=\"onkeypress: _onKeyPress\"\n\t><span data-dojo-attach-point=\"editorPlaceholder\"></span\n\t><span data-dojo-attach-point=\"buttonContainer\"\n\t\t><button data-dojo-type=\"dijit/form/Button\" data-dojo-props=\"label: '${buttonSave}', 'class': 'saveButton'\"\n\t\t\tdata-dojo-attach-point=\"saveButton\" data-dojo-attach-event=\"onClick:save\"></button\n\t\t><button data-dojo-type=\"dijit/form/Button\"  data-dojo-props=\"label: '${buttonCancel}', 'class': 'cancelButton'\"\n\t\t\tdata-dojo-attach-point=\"cancelButton\" data-dojo-attach-event=\"onClick:cancel\"></button\n\t></span\n></span>\n","dijit/form/VerticalRule":function(){
define(["dojo/_base/declare","./HorizontalRule"],function(_87e,_87f){
return _87e("dijit.form.VerticalRule",_87f,{templateString:"<div class=\"dijitRuleContainer dijitRuleContainerV\"></div>",_positionPrefix:"<div class=\"dijitRuleMark dijitRuleMarkV\" style=\"top:",_isHorizontal:false});
});
},"dijit/form/_FormSelectWidget":function(){
define(["dojo/_base/array","dojo/_base/Deferred","dojo/aspect","dojo/data/util/sorter","dojo/_base/declare","dojo/dom","dojo/dom-class","dojo/_base/kernel","dojo/_base/lang","dojo/query","dojo/when","dojo/store/util/QueryResults","./_FormValueWidget"],function(_880,_881,_882,_883,_884,dom,_885,_886,lang,_887,when,_888,_889){
var _88a=_884("dijit.form._FormSelectWidget",_889,{multiple:false,options:null,store:null,query:null,queryOptions:null,labelAttr:"",onFetch:null,sortByLabel:true,loadChildrenOnOpen:false,onLoadDeferred:null,getOptions:function(_88b){
var _88c=_88b,opts=this.options||[],l=opts.length;
if(_88c===undefined){
return opts;
}
if(lang.isArray(_88c)){
return _880.map(_88c,"return this.getOptions(item);",this);
}
if(lang.isObject(_88b)){
if(!_880.some(this.options,function(o,idx){
if(o===_88c||(o.value&&o.value===_88c.value)){
_88c=idx;
return true;
}
return false;
})){
_88c=-1;
}
}
if(typeof _88c=="string"){
for(var i=0;i<l;i++){
if(opts[i].value===_88c){
_88c=i;
break;
}
}
}
if(typeof _88c=="number"&&_88c>=0&&_88c<l){
return this.options[_88c];
}
return null;
},addOption:function(_88d){
if(!lang.isArray(_88d)){
_88d=[_88d];
}
_880.forEach(_88d,function(i){
if(i&&lang.isObject(i)){
this.options.push(i);
}
},this);
this._loadChildren();
},removeOption:function(_88e){
if(!lang.isArray(_88e)){
_88e=[_88e];
}
var _88f=this.getOptions(_88e);
_880.forEach(_88f,function(i){
if(i){
this.options=_880.filter(this.options,function(node){
return (node.value!==i.value||node.label!==i.label);
});
this._removeOptionItem(i);
}
},this);
this._loadChildren();
},updateOption:function(_890){
if(!lang.isArray(_890)){
_890=[_890];
}
_880.forEach(_890,function(i){
var _891=this.getOptions(i),k;
if(_891){
for(k in i){
_891[k]=i[k];
}
}
},this);
this._loadChildren();
},setStore:function(_892,_893,_894){
var _895=this.store;
_894=_894||{};
if(_895!==_892){
var h;
while((h=this._notifyConnections.pop())){
h.remove();
}
if(!_892.get){
lang.mixin(_892,{_oldAPI:true,get:function(id){
var _896=new _881();
this.fetchItemByIdentity({identity:id,onItem:function(_897){
_896.resolve(_897);
},onError:function(_898){
_896.reject(_898);
}});
return _896.promise;
},query:function(_899,_89a){
var _89b=new _881(function(){
if(_89c.abort){
_89c.abort();
}
});
_89b.total=new _881();
var _89c=this.fetch(lang.mixin({query:_899,onBegin:function(_89d){
_89b.total.resolve(_89d);
},onComplete:function(_89e){
_89b.resolve(_89e);
},onError:function(_89f){
_89b.reject(_89f);
}},_89a));
return new _888(_89b);
}});
if(_892.getFeatures()["dojo.data.api.Notification"]){
this._notifyConnections=[_882.after(_892,"onNew",lang.hitch(this,"_onNewItem"),true),_882.after(_892,"onDelete",lang.hitch(this,"_onDeleteItem"),true),_882.after(_892,"onSet",lang.hitch(this,"_onSetItem"),true)];
}
}
this._set("store",_892);
}
if(this.options&&this.options.length){
this.removeOption(this.options);
}
if(this._queryRes&&this._queryRes.close){
this._queryRes.close();
}
if(_894.query){
this._set("query",_894.query);
this._set("queryOptions",_894.queryOptions);
}
if(_892){
this._loadingStore=true;
this.onLoadDeferred=new _881();
this._queryRes=_892.query(this.query,this.queryOptions);
when(this._queryRes,lang.hitch(this,function(_8a0){
if(this.sortByLabel&&!_894.sort&&_8a0.length){
if(_8a0[0].getValue){
_8a0.sort(_883.createSortFunction([{attribute:_892.getLabelAttributes(_8a0[0])[0]}],_892));
}else{
var _8a1=this.labelAttr;
_8a0.sort(function(a,b){
return a[_8a1]>b[_8a1]?1:b[_8a1]>a[_8a1]?-1:0;
});
}
}
if(_894.onFetch){
_8a0=_894.onFetch.call(this,_8a0,_894);
}
_880.forEach(_8a0,function(i){
this._addOptionForItem(i);
},this);
if(this._queryRes.observe){
this._queryRes.observe(lang.hitch(this,function(_8a2,_8a3,_8a4){
if(_8a3==_8a4){
this._onSetItem(_8a2);
}else{
if(_8a3!=-1){
this._onDeleteItem(_8a2);
}
if(_8a4!=-1){
this._onNewItem(_8a2);
}
}
}),true);
}
this._loadingStore=false;
this.set("value","_pendingValue" in this?this._pendingValue:_893);
delete this._pendingValue;
if(!this.loadChildrenOnOpen){
this._loadChildren();
}else{
this._pseudoLoadChildren(_8a0);
}
this.onLoadDeferred.resolve(true);
this.onSetStore();
}),function(err){
console.error("dijit.form.Select: "+err.toString());
this.onLoadDeferred.reject(err);
});
}
return _895;
},_setValueAttr:function(_8a5,_8a6){
if(!this._onChangeActive){
_8a6=null;
}
if(this._loadingStore){
this._pendingValue=_8a5;
return;
}
var opts=this.getOptions()||[];
if(!lang.isArray(_8a5)){
_8a5=[_8a5];
}
_880.forEach(_8a5,function(i,idx){
if(!lang.isObject(i)){
i=i+"";
}
if(typeof i==="string"){
_8a5[idx]=_880.filter(opts,function(node){
return node.value===i;
})[0]||{value:"",label:""};
}
},this);
_8a5=_880.filter(_8a5,function(i){
return i&&i.value;
});
if(!this.multiple&&(!_8a5[0]||!_8a5[0].value)&&opts.length){
_8a5[0]=opts[0];
}
_880.forEach(opts,function(i){
i.selected=_880.some(_8a5,function(v){
return v.value===i.value;
});
});
var val=_880.map(_8a5,function(i){
return i.value;
}),disp=_880.map(_8a5,function(i){
return i.label;
});
if(typeof val=="undefined"||typeof val[0]=="undefined"){
return;
}
this._setDisplay(this.multiple?disp:disp[0]);
this.inherited(arguments,[this.multiple?val:val[0],_8a6]);
this._updateSelection();
},_getDisplayedValueAttr:function(){
var val=this.get("value");
if(!lang.isArray(val)){
val=[val];
}
var ret=_880.map(this.getOptions(val),function(v){
if(v&&"label" in v){
return v.label;
}else{
if(v){
return v.value;
}
}
return null;
},this);
return this.multiple?ret:ret[0];
},_loadChildren:function(){
if(this._loadingStore){
return;
}
_880.forEach(this._getChildren(),function(_8a7){
_8a7.destroyRecursive();
});
_880.forEach(this.options,this._addOptionItem,this);
this._updateSelection();
},_updateSelection:function(){
this._set("value",this._getValueFromOpts());
var val=this.value;
if(!lang.isArray(val)){
val=[val];
}
if(val&&val[0]){
_880.forEach(this._getChildren(),function(_8a8){
var _8a9=_880.some(val,function(v){
return _8a8.option&&(v===_8a8.option.value);
});
_885.toggle(_8a8.domNode,this.baseClass.replace(/\s+|$/g,"SelectedOption "),_8a9);
_8a8.domNode.setAttribute("aria-selected",_8a9?"true":"false");
},this);
}
},_getValueFromOpts:function(){
var opts=this.getOptions()||[];
if(!this.multiple&&opts.length){
var opt=_880.filter(opts,function(i){
return i.selected;
})[0];
if(opt&&opt.value){
return opt.value;
}else{
opts[0].selected=true;
return opts[0].value;
}
}else{
if(this.multiple){
return _880.map(_880.filter(opts,function(i){
return i.selected;
}),function(i){
return i.value;
})||[];
}
}
return "";
},_onNewItem:function(item,_8aa){
if(!_8aa||!_8aa.parent){
this._addOptionForItem(item);
}
},_onDeleteItem:function(item){
var _8ab=this.store;
this.removeOption(_8ab.getIdentity(item));
},_onSetItem:function(item){
this.updateOption(this._getOptionObjForItem(item));
},_getOptionObjForItem:function(item){
var _8ac=this.store,_8ad=(this.labelAttr&&this.labelAttr in item)?item[this.labelAttr]:_8ac.getLabel(item),_8ae=(_8ad?_8ac.getIdentity(item):null);
return {value:_8ae,label:_8ad,item:item};
},_addOptionForItem:function(item){
var _8af=this.store;
if(_8af.isItemLoaded&&!_8af.isItemLoaded(item)){
_8af.loadItem({item:item,onItem:function(i){
this._addOptionForItem(i);
},scope:this});
return;
}
var _8b0=this._getOptionObjForItem(item);
this.addOption(_8b0);
},constructor:function(_8b1){
this._oValue=(_8b1||{}).value||null;
this._notifyConnections=[];
},buildRendering:function(){
this.inherited(arguments);
dom.setSelectable(this.focusNode,false);
},_fillContent:function(){
if(!this.options){
this.options=this.srcNodeRef?_887("> *",this.srcNodeRef).map(function(node){
if(node.getAttribute("type")==="separator"){
return {value:"",label:"",selected:false,disabled:false};
}
return {value:(node.getAttribute("data-"+_886._scopeName+"-value")||node.getAttribute("value")),label:String(node.innerHTML),selected:node.getAttribute("selected")||false,disabled:node.getAttribute("disabled")||false};
},this):[];
}
if(!this.value){
this._set("value",this._getValueFromOpts());
}else{
if(this.multiple&&typeof this.value=="string"){
this._set("value",this.value.split(","));
}
}
},postCreate:function(){
this.inherited(arguments);
this.connect(this,"onChange","_updateSelection");
var _8b2=this.store;
if(_8b2&&(_8b2.getIdentity||_8b2.getFeatures()["dojo.data.api.Identity"])){
this.store=null;
this.setStore(_8b2,this._oValue);
}
},startup:function(){
this._loadChildren();
this.inherited(arguments);
},destroy:function(){
var h;
while((h=this._notifyConnections.pop())){
h.remove();
}
if(this._queryRes&&this._queryRes.close){
this._queryRes.close();
}
this.inherited(arguments);
},_addOptionItem:function(){
},_removeOptionItem:function(){
},_setDisplay:function(){
},_getChildren:function(){
return [];
},_getSelectedOptionsAttr:function(){
return this.getOptions(this.get("value"));
},_pseudoLoadChildren:function(){
},onSetStore:function(){
}});
return _88a;
});
},"dijit/form/Select":function(){
define(["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/dom-class","dojo/dom-geometry","dojo/_base/event","dojo/i18n","dojo/_base/lang","dojo/sniff","./_FormSelectWidget","../_HasDropDown","../Menu","../MenuItem","../MenuSeparator","../Tooltip","dojo/text!./templates/Select.html","dojo/i18n!./nls/validate"],function(_8b3,_8b4,_8b5,_8b6,_8b7,_8b8,i18n,lang,has,_8b9,_8ba,Menu,_8bb,_8bc,_8bd,_8be){
var _8bf=_8b4("dijit.form._SelectMenu",Menu,{autoFocus:true,buildRendering:function(){
this.inherited(arguments);
var o=(this.menuTableNode=this.domNode);
var n=(this.domNode=this.ownerDocument.createElement("div"));
n.style.cssText="overflow-x: hidden; overflow-y: scroll";
if(o.parentNode){
o.parentNode.replaceChild(n,o);
}
_8b6.remove(o,"dijitMenuTable");
n.className=o.className+" dijitSelectMenu";
o.className="dijitReset dijitMenuTable";
o.setAttribute("role","listbox");
n.setAttribute("role","presentation");
n.appendChild(o);
},postCreate:function(){
this.inherited(arguments);
this.connect(this.domNode,"onselectstart",_8b8.stop);
},focus:function(){
var _8c0=false,val=this.parentWidget.value;
if(lang.isArray(val)){
val=val[val.length-1];
}
if(val){
_8b3.forEach(this.parentWidget._getChildren(),function(_8c1){
if(_8c1.option&&(val===_8c1.option.value)){
_8c0=true;
this.focusChild(_8c1,false);
}
},this);
}
if(!_8c0){
this.inherited(arguments);
}
},resize:function(mb){
if(mb){
_8b7.setMarginBox(this.domNode,mb);
if("w" in mb){
this.menuTableNode.style.width="100%";
}
}
}});
var _8c2=_8b4("dijit.form.Select",[_8b9,_8ba],{baseClass:"dijitSelect dijitValidationTextBox",templateString:_8be,_buttonInputDisabled:has("ie")?"disabled":"",required:false,state:"",message:"",tooltipPosition:[],emptyLabel:"&#160;",_isLoaded:false,_childrenLoaded:false,_fillContent:function(){
this.inherited(arguments);
if(this.options.length&&!this.value&&this.srcNodeRef){
var si=this.srcNodeRef.selectedIndex||0;
this.value=this.options[si>=0?si:0].value;
}
this.dropDown=new _8bf({id:this.id+"_menu",parentWidget:this});
_8b6.add(this.dropDown.domNode,this.baseClass.replace(/\s+|$/g,"Menu "));
},_getMenuItemForOption:function(_8c3){
if(!_8c3.value&&!_8c3.label){
return new _8bc({ownerDocument:this.ownerDocument});
}else{
var _8c4=lang.hitch(this,"_setValueAttr",_8c3);
var item=new _8bb({option:_8c3,label:_8c3.label||this.emptyLabel,onClick:_8c4,ownerDocument:this.ownerDocument,dir:this.dir,disabled:_8c3.disabled||false});
item.focusNode.setAttribute("role","option");
return item;
}
},_addOptionItem:function(_8c5){
if(this.dropDown){
this.dropDown.addChild(this._getMenuItemForOption(_8c5));
}
},_getChildren:function(){
if(!this.dropDown){
return [];
}
return this.dropDown.getChildren();
},_loadChildren:function(_8c6){
if(_8c6===true){
if(this.dropDown){
delete this.dropDown.focusedChild;
}
if(this.options.length){
this.inherited(arguments);
}else{
_8b3.forEach(this._getChildren(),function(_8c7){
_8c7.destroyRecursive();
});
var item=new _8bb({ownerDocument:this.ownerDocument,label:this.emptyLabel});
this.dropDown.addChild(item);
}
}else{
this._updateSelection();
}
this._isLoaded=false;
this._childrenLoaded=true;
if(!this._loadingStore){
this._setValueAttr(this.value,false);
}
},_refreshState:function(){
if(this._started){
this.validate(this.focused);
}
},startup:function(){
this.inherited(arguments);
this._refreshState();
},_setValueAttr:function(_8c8){
this.inherited(arguments);
_8b5.set(this.valueNode,"value",this.get("value"));
this._refreshState();
},_setDisabledAttr:function(_8c9){
this.inherited(arguments);
this._refreshState();
},_setRequiredAttr:function(_8ca){
this._set("required",_8ca);
this.focusNode.setAttribute("aria-required",_8ca);
this._refreshState();
},_setOptionsAttr:function(_8cb){
this._isLoaded=false;
this._set("options",_8cb);
},_setDisplay:function(_8cc){
var lbl=_8cc||this.emptyLabel;
this.containerNode.innerHTML="<span role=\"option\" class=\"dijitReset dijitInline "+this.baseClass.replace(/\s+|$/g,"Label ")+"\">"+lbl+"</span>";
},validate:function(_8cd){
var _8ce=this.disabled||this.isValid(_8cd);
this._set("state",_8ce?"":(this._hasBeenBlurred?"Error":"Incomplete"));
this.focusNode.setAttribute("aria-invalid",_8ce?"false":"true");
var _8cf=_8ce?"":this._missingMsg;
if(_8cf&&this.focused&&this._hasBeenBlurred){
_8bd.show(_8cf,this.domNode,this.tooltipPosition,!this.isLeftToRight());
}else{
_8bd.hide(this.domNode);
}
this._set("message",_8cf);
return _8ce;
},isValid:function(){
return (!this.required||this.value===0||!(/^\s*$/.test(this.value||"")));
},reset:function(){
this.inherited(arguments);
_8bd.hide(this.domNode);
this._refreshState();
},postMixInProperties:function(){
this.inherited(arguments);
this._missingMsg=i18n.getLocalization("dijit.form","validate",this.lang).missingMessage;
},postCreate:function(){
this.inherited(arguments);
this.connect(this.domNode,"onselectstart",_8b8.stop);
this.domNode.setAttribute("aria-expanded","false");
if(has("ie")<9){
this.defer(function(){
try{
var s=domStyle.getComputedStyle(this.domNode);
if(s){
var ff=s.fontFamily;
if(ff){
var _8d0=this.domNode.getElementsByTagName("INPUT");
if(_8d0){
for(var i=0;i<_8d0.length;i++){
_8d0[i].style.fontFamily=ff;
}
}
}
}
}
catch(e){
}
});
}
},_setStyleAttr:function(_8d1){
this.inherited(arguments);
_8b6.toggle(this.domNode,this.baseClass.replace(/\s+|$/g,"FixedWidth "),!!this.domNode.style.width);
},isLoaded:function(){
return this._isLoaded;
},loadDropDown:function(_8d2){
this._loadChildren(true);
this._isLoaded=true;
_8d2();
},closeDropDown:function(){
this.inherited(arguments);
if(this.dropDown&&this.dropDown.menuTableNode){
this.dropDown.menuTableNode.style.width="";
}
},destroy:function(_8d3){
if(this.dropDown&&!this.dropDown._destroyed){
this.dropDown.destroyRecursive(_8d3);
delete this.dropDown;
}
this.inherited(arguments);
},_onFocus:function(){
this.validate(true);
this.inherited(arguments);
},_onBlur:function(){
_8bd.hide(this.domNode);
this.inherited(arguments);
this.validate(false);
}});
_8c2._Menu=_8bf;
return _8c2;
});
},"dijit/_editor/range":function(){
define("dijit/_editor/range",["dojo/_base/array","dojo/_base/declare","dojo/_base/lang","dojo/_base/window","../main"],function(_8d4,_8d5,lang,win,_8d6){
_8d6.range={};
_8d6.range.getIndex=function(node,_8d7){
var ret=[],retR=[];
var _8d8=node;
var _8d9,n;
while(node!=_8d7){
var i=0;
_8d9=node.parentNode;
while((n=_8d9.childNodes[i++])){
if(n===node){
--i;
break;
}
}
ret.unshift(i);
retR.unshift(i-_8d9.childNodes.length);
node=_8d9;
}
if(ret.length>0&&_8d8.nodeType==3){
n=_8d8.previousSibling;
while(n&&n.nodeType==3){
ret[ret.length-1]--;
n=n.previousSibling;
}
n=_8d8.nextSibling;
while(n&&n.nodeType==3){
retR[retR.length-1]++;
n=n.nextSibling;
}
}
return {o:ret,r:retR};
};
_8d6.range.getNode=function(_8da,_8db){
if(!lang.isArray(_8da)||_8da.length==0){
return _8db;
}
var node=_8db;
_8d4.every(_8da,function(i){
if(i>=0&&i<node.childNodes.length){
node=node.childNodes[i];
}else{
node=null;
return false;
}
return true;
});
return node;
};
_8d6.range.getCommonAncestor=function(n1,n2,root){
root=root||n1.ownerDocument.body;
var _8dc=function(n){
var as=[];
while(n){
as.unshift(n);
if(n!==root){
n=n.parentNode;
}else{
break;
}
}
return as;
};
var n1as=_8dc(n1);
var n2as=_8dc(n2);
var m=Math.min(n1as.length,n2as.length);
var com=n1as[0];
for(var i=1;i<m;i++){
if(n1as[i]===n2as[i]){
com=n1as[i];
}else{
break;
}
}
return com;
};
_8d6.range.getAncestor=function(node,_8dd,root){
root=root||node.ownerDocument.body;
while(node&&node!==root){
var name=node.nodeName.toUpperCase();
if(_8dd.test(name)){
return node;
}
node=node.parentNode;
}
return null;
};
_8d6.range.BlockTagNames=/^(?:P|DIV|H1|H2|H3|H4|H5|H6|ADDRESS|PRE|OL|UL|LI|DT|DE)$/;
_8d6.range.getBlockAncestor=function(node,_8de,root){
root=root||node.ownerDocument.body;
_8de=_8de||_8d6.range.BlockTagNames;
var _8df=null,_8e0;
while(node&&node!==root){
var name=node.nodeName.toUpperCase();
if(!_8df&&_8de.test(name)){
_8df=node;
}
if(!_8e0&&(/^(?:BODY|TD|TH|CAPTION)$/).test(name)){
_8e0=node;
}
node=node.parentNode;
}
return {blockNode:_8df,blockContainer:_8e0||node.ownerDocument.body};
};
_8d6.range.atBeginningOfContainer=function(_8e1,node,_8e2){
var _8e3=false;
var _8e4=(_8e2==0);
if(!_8e4&&node.nodeType==3){
if(/^[\s\xA0]+$/.test(node.nodeValue.substr(0,_8e2))){
_8e4=true;
}
}
if(_8e4){
var _8e5=node;
_8e3=true;
while(_8e5&&_8e5!==_8e1){
if(_8e5.previousSibling){
_8e3=false;
break;
}
_8e5=_8e5.parentNode;
}
}
return _8e3;
};
_8d6.range.atEndOfContainer=function(_8e6,node,_8e7){
var _8e8=false;
var _8e9=(_8e7==(node.length||node.childNodes.length));
if(!_8e9&&node.nodeType==3){
if(/^[\s\xA0]+$/.test(node.nodeValue.substr(_8e7))){
_8e9=true;
}
}
if(_8e9){
var _8ea=node;
_8e8=true;
while(_8ea&&_8ea!==_8e6){
if(_8ea.nextSibling){
_8e8=false;
break;
}
_8ea=_8ea.parentNode;
}
}
return _8e8;
};
_8d6.range.adjacentNoneTextNode=function(_8eb,next){
var node=_8eb;
var len=(0-_8eb.length)||0;
var prop=next?"nextSibling":"previousSibling";
while(node){
if(node.nodeType!=3){
break;
}
len+=node.length;
node=node[prop];
}
return [node,len];
};
_8d6.range.create=function(win){
win=win||window;
if(win.getSelection){
return win.document.createRange();
}else{
return new _8d6.range.W3CRange();
}
};
_8d6.range.getSelection=function(_8ec,_8ed){
if(_8ec.getSelection){
return _8ec.getSelection();
}else{
var s=new _8d6.range.ie.selection(_8ec);
if(!_8ed){
s._getCurrentSelection();
}
return s;
}
};
if(!window.getSelection){
_8d6.range.ie={cachedSelection:{},selection:function(_8ee){
this._ranges=[];
this.addRange=function(r,_8ef){
this._ranges.push(r);
if(!_8ef){
r._select();
}
this.rangeCount=this._ranges.length;
};
this.removeAllRanges=function(){
this._ranges=[];
this.rangeCount=0;
};
var _8f0=function(){
var r=_8ee.document.selection.createRange();
var type=_8ee.document.selection.type.toUpperCase();
if(type=="CONTROL"){
return new _8d6.range.W3CRange(_8d6.range.ie.decomposeControlRange(r));
}else{
return new _8d6.range.W3CRange(_8d6.range.ie.decomposeTextRange(r));
}
};
this.getRangeAt=function(i){
return this._ranges[i];
};
this._getCurrentSelection=function(){
this.removeAllRanges();
var r=_8f0();
if(r){
this.addRange(r,true);
this.isCollapsed=r.collapsed;
}else{
this.isCollapsed=true;
}
};
},decomposeControlRange:function(_8f1){
var _8f2=_8f1.item(0),_8f3=_8f1.item(_8f1.length-1);
var _8f4=_8f2.parentNode,_8f5=_8f3.parentNode;
var _8f6=_8d6.range.getIndex(_8f2,_8f4).o[0];
var _8f7=_8d6.range.getIndex(_8f3,_8f5).o[0]+1;
return [_8f4,_8f6,_8f5,_8f7];
},getEndPoint:function(_8f8,end){
var _8f9=_8f8.duplicate();
_8f9.collapse(!end);
var _8fa="EndTo"+(end?"End":"Start");
var _8fb=_8f9.parentElement();
var _8fc,_8fd,_8fe;
if(_8fb.childNodes.length>0){
_8d4.every(_8fb.childNodes,function(node,i){
var _8ff;
if(node.nodeType!=3){
_8f9.moveToElementText(node);
if(_8f9.compareEndPoints(_8fa,_8f8)>0){
if(_8fe&&_8fe.nodeType==3){
_8fc=_8fe;
_8ff=true;
}else{
_8fc=_8fb;
_8fd=i;
return false;
}
}else{
if(i==_8fb.childNodes.length-1){
_8fc=_8fb;
_8fd=_8fb.childNodes.length;
return false;
}
}
}else{
if(i==_8fb.childNodes.length-1){
_8fc=node;
_8ff=true;
}
}
if(_8ff&&_8fc){
var _900=_8d6.range.adjacentNoneTextNode(_8fc)[0];
if(_900){
_8fc=_900.nextSibling;
}else{
_8fc=_8fb.firstChild;
}
var _901=_8d6.range.adjacentNoneTextNode(_8fc);
_900=_901[0];
var _902=_901[1];
if(_900){
_8f9.moveToElementText(_900);
_8f9.collapse(false);
}else{
_8f9.moveToElementText(_8fb);
}
_8f9.setEndPoint(_8fa,_8f8);
_8fd=_8f9.text.length-_902;
return false;
}
_8fe=node;
return true;
});
}else{
_8fc=_8fb;
_8fd=0;
}
if(!end&&_8fc.nodeType==1&&_8fd==_8fc.childNodes.length){
var _903=_8fc.nextSibling;
if(_903&&_903.nodeType==3){
_8fc=_903;
_8fd=0;
}
}
return [_8fc,_8fd];
},setEndPoint:function(_904,_905,_906){
var _907=_904.duplicate(),node,len;
if(_905.nodeType!=3){
if(_906>0){
node=_905.childNodes[_906-1];
if(node){
if(node.nodeType==3){
_905=node;
_906=node.length;
}else{
if(node.nextSibling&&node.nextSibling.nodeType==3){
_905=node.nextSibling;
_906=0;
}else{
_907.moveToElementText(node.nextSibling?node:_905);
var _908=node.parentNode;
var _909=_908.insertBefore(node.ownerDocument.createTextNode(" "),node.nextSibling);
_907.collapse(false);
_908.removeChild(_909);
}
}
}
}else{
_907.moveToElementText(_905);
_907.collapse(true);
}
}
if(_905.nodeType==3){
var _90a=_8d6.range.adjacentNoneTextNode(_905);
var _90b=_90a[0];
len=_90a[1];
if(_90b){
_907.moveToElementText(_90b);
_907.collapse(false);
if(_90b.contentEditable!="inherit"){
len++;
}
}else{
_907.moveToElementText(_905.parentNode);
_907.collapse(true);
_907.move("character",1);
_907.move("character",-1);
}
_906+=len;
if(_906>0){
if(_907.move("character",_906)!=_906){
console.error("Error when moving!");
}
}
}
return _907;
},decomposeTextRange:function(_90c){
var _90d=_8d6.range.ie.getEndPoint(_90c);
var _90e=_90d[0],_90f=_90d[1];
var _910=_90d[0],_911=_90d[1];
if(_90c.htmlText.length){
if(_90c.htmlText==_90c.text){
_911=_90f+_90c.text.length;
}else{
_90d=_8d6.range.ie.getEndPoint(_90c,true);
_910=_90d[0],_911=_90d[1];
}
}
return [_90e,_90f,_910,_911];
},setRange:function(_912,_913,_914,_915,_916,_917){
var _918=_8d6.range.ie.setEndPoint(_912,_913,_914);
_912.setEndPoint("StartToStart",_918);
if(!_917){
var end=_8d6.range.ie.setEndPoint(_912,_915,_916);
}
_912.setEndPoint("EndToEnd",end||_918);
return _912;
}};
_8d5("dijit.range.W3CRange",null,{constructor:function(){
if(arguments.length>0){
this.setStart(arguments[0][0],arguments[0][1]);
this.setEnd(arguments[0][2],arguments[0][3]);
}else{
this.commonAncestorContainer=null;
this.startContainer=null;
this.startOffset=0;
this.endContainer=null;
this.endOffset=0;
this.collapsed=true;
}
},_updateInternal:function(){
if(this.startContainer!==this.endContainer){
this.commonAncestorContainer=_8d6.range.getCommonAncestor(this.startContainer,this.endContainer);
}else{
this.commonAncestorContainer=this.startContainer;
}
this.collapsed=(this.startContainer===this.endContainer)&&(this.startOffset==this.endOffset);
},setStart:function(node,_919){
_919=parseInt(_919);
if(this.startContainer===node&&this.startOffset==_919){
return;
}
delete this._cachedBookmark;
this.startContainer=node;
this.startOffset=_919;
if(!this.endContainer){
this.setEnd(node,_919);
}else{
this._updateInternal();
}
},setEnd:function(node,_91a){
_91a=parseInt(_91a);
if(this.endContainer===node&&this.endOffset==_91a){
return;
}
delete this._cachedBookmark;
this.endContainer=node;
this.endOffset=_91a;
if(!this.startContainer){
this.setStart(node,_91a);
}else{
this._updateInternal();
}
},setStartAfter:function(node,_91b){
this._setPoint("setStart",node,_91b,1);
},setStartBefore:function(node,_91c){
this._setPoint("setStart",node,_91c,0);
},setEndAfter:function(node,_91d){
this._setPoint("setEnd",node,_91d,1);
},setEndBefore:function(node,_91e){
this._setPoint("setEnd",node,_91e,0);
},_setPoint:function(what,node,_91f,ext){
var _920=_8d6.range.getIndex(node,node.parentNode).o;
this[what](node.parentNode,_920.pop()+ext);
},_getIERange:function(){
var r=(this._body||this.endContainer.ownerDocument.body).createTextRange();
_8d6.range.ie.setRange(r,this.startContainer,this.startOffset,this.endContainer,this.endOffset,this.collapsed);
return r;
},getBookmark:function(){
this._getIERange();
return this._cachedBookmark;
},_select:function(){
var r=this._getIERange();
r.select();
},deleteContents:function(){
var s=this.startContainer,r=this._getIERange();
if(s.nodeType===3&&!this.startOffset){
this.setStartBefore(s);
}
r.pasteHTML("");
this.endContainer=this.startContainer;
this.endOffset=this.startOffset;
this.collapsed=true;
},cloneRange:function(){
var r=new _8d6.range.W3CRange([this.startContainer,this.startOffset,this.endContainer,this.endOffset]);
r._body=this._body;
return r;
},detach:function(){
this._body=null;
this.commonAncestorContainer=null;
this.startContainer=null;
this.startOffset=0;
this.endContainer=null;
this.endOffset=0;
this.collapsed=true;
}});
}
return _8d6.range;
});
},"dojo/store/util/QueryResults":function(){
define(["../../_base/array","../../_base/lang","../../_base/Deferred"],function(_921,lang,_922){
var _923=function(_924){
if(!_924){
return _924;
}
if(_924.then){
_924=lang.delegate(_924);
}
function _925(_926){
if(!_924[_926]){
_924[_926]=function(){
var args=arguments;
return _922.when(_924,function(_927){
Array.prototype.unshift.call(args,_927);
return _923(_921[_926].apply(_921,args));
});
};
}
};
_925("forEach");
_925("filter");
_925("map");
if(!_924.total){
_924.total=_922.when(_924,function(_928){
return _928.length;
});
}
return _924;
};
lang.setObject("dojo.store.util.QueryResults",_923);
return _923;
});
},"dijit/form/_ListBase":function(){
define(["dojo/_base/declare","dojo/on","dojo/window"],function(_929,on,_92a){
return _929("dijit.form._ListBase",null,{selected:null,_listConnect:function(_92b,_92c){
var self=this;
return self.own(on(self.containerNode,on.selector(function(_92d,_92e,_92f){
return _92d.parentNode==_92f;
},_92b),function(evt){
evt.preventDefault();
self[_92c](evt,this);
}));
},selectFirstNode:function(){
var _930=this.containerNode.firstChild;
while(_930&&_930.style.display=="none"){
_930=_930.nextSibling;
}
this._setSelectedAttr(_930);
},selectLastNode:function(){
var last=this.containerNode.lastChild;
while(last&&last.style.display=="none"){
last=last.previousSibling;
}
this._setSelectedAttr(last);
},selectNextNode:function(){
var _931=this.selected;
if(!_931){
this.selectFirstNode();
}else{
var next=_931.nextSibling;
while(next&&next.style.display=="none"){
next=next.nextSibling;
}
if(!next){
this.selectFirstNode();
}else{
this._setSelectedAttr(next);
}
}
},selectPreviousNode:function(){
var _932=this.selected;
if(!_932){
this.selectLastNode();
}else{
var prev=_932.previousSibling;
while(prev&&prev.style.display=="none"){
prev=prev.previousSibling;
}
if(!prev){
this.selectLastNode();
}else{
this._setSelectedAttr(prev);
}
}
},_setSelectedAttr:function(node){
if(this.selected!=node){
var _933=this.selected;
if(_933){
this.onDeselect(_933);
this.selected=null;
}
if(node){
this.selected=node;
_92a.scrollIntoView(node);
this.onSelect(node);
}
}else{
if(node){
this.onSelect(node);
}
}
}});
});
},"dojo/DeferredList":function(){
define(["./_base/kernel","./_base/Deferred","./_base/array"],function(dojo,_934,_935){
dojo.DeferredList=function(list,_936,_937,_938,_939){
var _93a=[];
_934.call(this);
var self=this;
if(list.length===0&&!_936){
this.resolve([0,[]]);
}
var _93b=0;
_935.forEach(list,function(item,i){
item.then(function(_93c){
if(_936){
self.resolve([i,_93c]);
}else{
_93d(true,_93c);
}
},function(_93e){
if(_937){
self.reject(_93e);
}else{
_93d(false,_93e);
}
if(_938){
return null;
}
throw _93e;
});
function _93d(_93f,_940){
_93a[i]=[_93f,_940];
_93b++;
if(_93b===list.length){
self.resolve(_93a);
}
};
});
};
dojo.DeferredList.prototype=new _934();
dojo.DeferredList.prototype.gatherResults=function(_941){
var d=new dojo.DeferredList(_941,false,true,false);
d.addCallback(function(_942){
var ret=[];
_935.forEach(_942,function(_943){
ret.push(_943[1]);
});
return ret;
});
return d;
};
return dojo.DeferredList;
});
},"dojo/dnd/common":function(){
define(["../_base/connect","../_base/kernel","../_base/lang","../dom"],function(_944,_945,lang,dom){
var _946=lang.getObject("dojo.dnd",true);
_946.getCopyKeyState=_944.isCopyKey;
_946._uniqueId=0;
_946.getUniqueId=function(){
var id;
do{
id=_945._scopeName+"Unique"+(++_946._uniqueId);
}while(dom.byId(id));
return id;
};
_946._empty={};
_946.isFormElement=function(e){
var t=e.target;
if(t.nodeType==3){
t=t.parentNode;
}
return " button textarea input select option ".indexOf(" "+t.tagName.toLowerCase()+" ")>=0;
};
return _946;
});
},"dijit/CalendarLite":function(){
define(["dojo/_base/array","dojo/_base/declare","dojo/cldr/supplemental","dojo/date","dojo/date/locale","dojo/date/stamp","dojo/dom","dojo/dom-class","dojo/_base/event","dojo/_base/lang","dojo/sniff","dojo/string","./_WidgetBase","./_TemplatedMixin","dojo/text!./templates/Calendar.html","./hccss"],function(_947,_948,_949,date,_94a,_94b,dom,_94c,_94d,lang,has,_94e,_94f,_950,_951){
var _952=_948("dijit.CalendarLite",[_94f,_950],{templateString:_951,dowTemplateString:"<th class=\"dijitReset dijitCalendarDayLabelTemplate\" role=\"columnheader\"><span class=\"dijitCalendarDayLabel\">${d}</span></th>",dateTemplateString:"<td class=\"dijitReset\" role=\"gridcell\" data-dojo-attach-point=\"dateCells\"><span class=\"dijitCalendarDateLabel\" data-dojo-attach-point=\"dateLabels\"></span></td>",weekTemplateString:"<tr class=\"dijitReset dijitCalendarWeekTemplate\" role=\"row\">${d}${d}${d}${d}${d}${d}${d}</tr>",value:new Date(""),datePackage:"",dayWidth:"narrow",tabIndex:"0",currentFocus:new Date(),baseClass:"dijitCalendar",_isValidDate:function(_953){
return _953&&!isNaN(_953)&&typeof _953=="object"&&_953.toString()!=this.constructor.prototype.value.toString();
},_getValueAttr:function(){
if(this.value&&!isNaN(this.value)){
var _954=new this.dateClassObj(this.value);
_954.setHours(0,0,0,0);
if(_954.getDate()<this.value.getDate()){
_954=this.dateModule.add(_954,"hour",1);
}
return _954;
}else{
return null;
}
},_setValueAttr:function(_955,_956){
if(typeof _955=="string"){
_955=_94b.fromISOString(_955);
}
_955=this._patchDate(_955);
if(this._isValidDate(_955)&&!this.isDisabledDate(_955,this.lang)){
this._set("value",_955);
this.set("currentFocus",_955);
this._markSelectedDates([_955]);
if(this._created&&(_956||typeof _956=="undefined")){
this.onChange(this.get("value"));
}
}else{
this._set("value",null);
this._markSelectedDates([]);
}
},_patchDate:function(_957){
if(_957){
_957=new this.dateClassObj(_957);
_957.setHours(1,0,0,0);
}
return _957;
},_setText:function(node,text){
while(node.firstChild){
node.removeChild(node.firstChild);
}
node.appendChild(node.ownerDocument.createTextNode(text));
},_populateGrid:function(){
var _958=new this.dateClassObj(this.currentFocus);
_958.setDate(1);
var _959=_958.getDay(),_95a=this.dateModule.getDaysInMonth(_958),_95b=this.dateModule.getDaysInMonth(this.dateModule.add(_958,"month",-1)),_95c=new this.dateClassObj(),_95d=_949.getFirstDayOfWeek(this.lang);
if(_95d>_959){
_95d-=7;
}
this._date2cell={};
_947.forEach(this.dateCells,function(_95e,idx){
var i=idx+_95d;
var date=new this.dateClassObj(_958),_95f,_960="dijitCalendar",adj=0;
if(i<_959){
_95f=_95b-_959+i+1;
adj=-1;
_960+="Previous";
}else{
if(i>=(_959+_95a)){
_95f=i-_959-_95a+1;
adj=1;
_960+="Next";
}else{
_95f=i-_959+1;
_960+="Current";
}
}
if(adj){
date=this.dateModule.add(date,"month",adj);
}
date.setDate(_95f);
if(!this.dateModule.compare(date,_95c,"date")){
_960="dijitCalendarCurrentDate "+_960;
}
if(this.isDisabledDate(date,this.lang)){
_960="dijitCalendarDisabledDate "+_960;
_95e.setAttribute("aria-disabled","true");
}else{
_960="dijitCalendarEnabledDate "+_960;
_95e.removeAttribute("aria-disabled");
_95e.setAttribute("aria-selected","false");
}
var _961=this.getClassForDate(date,this.lang);
if(_961){
_960=_961+" "+_960;
}
_95e.className=_960+"Month dijitCalendarDateTemplate";
var _962=date.valueOf();
this._date2cell[_962]=_95e;
_95e.dijitDateValue=_962;
this._setText(this.dateLabels[idx],date.getDateLocalized?date.getDateLocalized(this.lang):date.getDate());
},this);
},_populateControls:function(){
var _963=new this.dateClassObj(this.currentFocus);
_963.setDate(1);
this.monthWidget.set("month",_963);
var y=_963.getFullYear()-1;
var d=new this.dateClassObj();
_947.forEach(["previous","current","next"],function(name){
d.setFullYear(y++);
this._setText(this[name+"YearLabelNode"],this.dateLocaleModule.format(d,{selector:"year",locale:this.lang}));
},this);
},goToToday:function(){
this.set("value",new this.dateClassObj());
},constructor:function(_964){
this.dateModule=_964.datePackage?lang.getObject(_964.datePackage,false):date;
this.dateClassObj=this.dateModule.Date||Date;
this.dateLocaleModule=_964.datePackage?lang.getObject(_964.datePackage+".locale",false):_94a;
},_createMonthWidget:function(){
return _952._MonthWidget({id:this.id+"_mw",lang:this.lang,dateLocaleModule:this.dateLocaleModule},this.monthNode);
},buildRendering:function(){
var d=this.dowTemplateString,_965=this.dateLocaleModule.getNames("days",this.dayWidth,"standAlone",this.lang),_966=_949.getFirstDayOfWeek(this.lang);
this.dayCellsHtml=_94e.substitute([d,d,d,d,d,d,d].join(""),{d:""},function(){
return _965[_966++%7];
});
var r=_94e.substitute(this.weekTemplateString,{d:this.dateTemplateString});
this.dateRowsHtml=[r,r,r,r,r,r].join("");
this.dateCells=[];
this.dateLabels=[];
this.inherited(arguments);
dom.setSelectable(this.domNode,false);
var _967=new this.dateClassObj(this.currentFocus);
this.monthWidget=this._createMonthWidget();
this.set("currentFocus",_967,false);
},postCreate:function(){
this.inherited(arguments);
this._connectControls();
},_connectControls:function(){
var _968=lang.hitch(this,function(_969,part,_96a){
this.connect(this[_969],"onclick",function(){
this._setCurrentFocusAttr(this.dateModule.add(this.currentFocus,part,_96a));
});
});
_968("incrementMonth","month",1);
_968("decrementMonth","month",-1);
_968("nextYearLabelNode","year",1);
_968("previousYearLabelNode","year",-1);
},_setCurrentFocusAttr:function(date,_96b){
var _96c=this.currentFocus,_96d=this._getNodeByDate(_96c);
date=this._patchDate(date);
this._set("currentFocus",date);
if(!this._date2cell||this.dateModule.difference(_96c,date,"month")!=0){
this._populateGrid();
this._populateControls();
this._markSelectedDates([this.value]);
}
var _96e=this._getNodeByDate(date);
_96e.setAttribute("tabIndex",this.tabIndex);
if(this.focused||_96b){
_96e.focus();
}
if(_96d&&_96d!=_96e){
if(has("webkit")){
_96d.setAttribute("tabIndex","-1");
}else{
_96d.removeAttribute("tabIndex");
}
}
},focus:function(){
this._setCurrentFocusAttr(this.currentFocus,true);
},_onDayClick:function(evt){
_94d.stop(evt);
for(var node=evt.target;node&&!node.dijitDateValue;node=node.parentNode){
}
if(node&&!_94c.contains(node,"dijitCalendarDisabledDate")){
this.set("value",node.dijitDateValue);
}
},_getNodeByDate:function(_96f){
_96f=this._patchDate(_96f);
return _96f&&this._date2cell?this._date2cell[_96f.valueOf()]:null;
},_markSelectedDates:function(_970){
function mark(_971,cell){
_94c.toggle(cell,"dijitCalendarSelectedDate",_971);
cell.setAttribute("aria-selected",_971?"true":"false");
};
_947.forEach(this._selectedCells||[],lang.partial(mark,false));
this._selectedCells=_947.filter(_947.map(_970,this._getNodeByDate,this),function(n){
return n;
});
_947.forEach(this._selectedCells,lang.partial(mark,true));
},onChange:function(){
},isDisabledDate:function(){
},getClassForDate:function(){
}});
_952._MonthWidget=_948("dijit.CalendarLite._MonthWidget",_94f,{_setMonthAttr:function(_972){
var _973=this.dateLocaleModule.getNames("months","wide","standAlone",this.lang,_972),_974=(has("ie")==6?"":"<div class='dijitSpacer'>"+_947.map(_973,function(s){
return "<div>"+s+"</div>";
}).join("")+"</div>");
this.domNode.innerHTML=_974+"<div class='dijitCalendarMonthLabel dijitCalendarCurrentMonthLabel'>"+_973[_972.getMonth()]+"</div>";
}});
return _952;
});
},"dijit/CheckedMenuItem":function(){
require({cache:{"url:dijit/templates/CheckedMenuItem.html":"<tr class=\"dijitReset dijitMenuItem\" data-dojo-attach-point=\"focusNode\" role=\"menuitemcheckbox\" tabIndex=\"-1\">\n\t<td class=\"dijitReset dijitMenuItemIconCell\" role=\"presentation\">\n\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitMenuItemIcon dijitCheckedMenuItemIcon\" data-dojo-attach-point=\"iconNode\"/>\n\t\t<span class=\"dijitCheckedMenuItemIconChar\">&#10003;</span>\n\t</td>\n\t<td class=\"dijitReset dijitMenuItemLabel\" colspan=\"2\" data-dojo-attach-point=\"containerNode,labelNode\"></td>\n\t<td class=\"dijitReset dijitMenuItemAccelKey\" style=\"display: none\" data-dojo-attach-point=\"accelKeyNode\"></td>\n\t<td class=\"dijitReset dijitMenuArrowCell\" role=\"presentation\">&#160;</td>\n</tr>\n"}});
define("dijit/CheckedMenuItem",["dojo/_base/declare","dojo/dom-class","./MenuItem","dojo/text!./templates/CheckedMenuItem.html","./hccss"],function(_975,_976,_977,_978){
return _975("dijit.CheckedMenuItem",_977,{templateString:_978,checked:false,_setCheckedAttr:function(_979){
_976.toggle(this.domNode,"dijitCheckedMenuItemChecked",_979);
this.domNode.setAttribute("aria-checked",_979?"true":"false");
this._set("checked",_979);
},iconClass:"",onChange:function(){
},_onClick:function(evt){
if(!this.disabled){
this.set("checked",!this.checked);
this.onChange(this.checked);
}
this.onClick(evt);
}});
});
},"dijit/form/VerticalRuleLabels":function(){
define(["dojo/_base/declare","./HorizontalRuleLabels"],function(_97a,_97b){
return _97a("dijit.form.VerticalRuleLabels",_97b,{templateString:"<div class=\"dijitRuleContainer dijitRuleContainerV dijitRuleLabelsContainer dijitRuleLabelsContainerV\"></div>",_positionPrefix:"<div class=\"dijitRuleLabelContainer dijitRuleLabelContainerV\" style=\"top:",_labelPrefix:"\"><span class=\"dijitRuleLabel dijitRuleLabelV\">",_calcPosition:function(pos){
return 100-pos;
},_isHorizontal:false});
});
},"dijit/Declaration":function(){
define(["dojo/_base/array","dojo/_base/connect","dojo/_base/declare","dojo/_base/lang","dojo/parser","dojo/query","./_Widget","./_TemplatedMixin","./_WidgetsInTemplateMixin","dojo/NodeList-dom"],function(_97c,_97d,_97e,lang,_97f,_980,_981,_982,_983){
return _97e("dijit.Declaration",_981,{_noScript:true,stopParser:true,widgetClass:"",defaults:null,mixins:[],buildRendering:function(){
var src=this.srcNodeRef.parentNode.removeChild(this.srcNodeRef),_984=_980("> script[type^='dojo/method']",src).orphan(),_985=_980("> script[type^='dojo/connect']",src).orphan(),_986=src.nodeName;
var _987=this.defaults||{};
_97c.forEach(_984,function(s){
var evt=s.getAttribute("event")||s.getAttribute("data-dojo-event"),func=_97f._functionFromScript(s);
if(evt){
_987[evt]=func;
}else{
_985.push(s);
}
});
if(this.mixins.length){
this.mixins=_97c.map(this.mixins,function(name){
return lang.getObject(name);
});
}else{
this.mixins=[_981,_982,_983];
}
_987._skipNodeCache=true;
_987.templateString="<"+_986+" class='"+src.className+"'"+" data-dojo-attach-point='"+(src.getAttribute("data-dojo-attach-point")||src.getAttribute("dojoAttachPoint")||"")+"' data-dojo-attach-event='"+(src.getAttribute("data-dojo-attach-event")||src.getAttribute("dojoAttachEvent")||"")+"' >"+src.innerHTML.replace(/\%7B/g,"{").replace(/\%7D/g,"}")+"</"+_986+">";
var wc=_97e(this.widgetClass,this.mixins,_987);
_97c.forEach(_985,function(s){
var evt=s.getAttribute("event")||s.getAttribute("data-dojo-event")||"postscript",func=_97f._functionFromScript(s);
_97d.connect(wc.prototype,evt,func);
});
}});
});
},"dijit/MenuSeparator":function(){
require({cache:{"url:dijit/templates/MenuSeparator.html":"<tr class=\"dijitMenuSeparator\">\n\t<td class=\"dijitMenuSeparatorIconCell\">\n\t\t<div class=\"dijitMenuSeparatorTop\"></div>\n\t\t<div class=\"dijitMenuSeparatorBottom\"></div>\n\t</td>\n\t<td colspan=\"3\" class=\"dijitMenuSeparatorLabelCell\">\n\t\t<div class=\"dijitMenuSeparatorTop dijitMenuSeparatorLabel\"></div>\n\t\t<div class=\"dijitMenuSeparatorBottom\"></div>\n\t</td>\n</tr>"}});
define("dijit/MenuSeparator",["dojo/_base/declare","dojo/dom","./_WidgetBase","./_TemplatedMixin","./_Contained","dojo/text!./templates/MenuSeparator.html"],function(_988,dom,_989,_98a,_98b,_98c){
return _988("dijit.MenuSeparator",[_989,_98a,_98b],{templateString:_98c,buildRendering:function(){
this.inherited(arguments);
dom.setSelectable(this.domNode,false);
},isFocusable:function(){
return false;
}});
});
},"dijit/form/_ComboBoxMenu":function(){
define(["dojo/_base/declare","dojo/dom-class","dojo/dom-style","dojo/keys","../_WidgetBase","../_TemplatedMixin","./_ComboBoxMenuMixin","./_ListMouseMixin"],function(_98d,_98e,_98f,keys,_990,_991,_992,_993){
return _98d("dijit.form._ComboBoxMenu",[_990,_991,_993,_992],{templateString:"<div class='dijitReset dijitMenu' data-dojo-attach-point='containerNode' style='overflow: auto; overflow-x: hidden;' role='listbox'>"+"<div class='dijitMenuItem dijitMenuPreviousButton' data-dojo-attach-point='previousButton' role='option'></div>"+"<div class='dijitMenuItem dijitMenuNextButton' data-dojo-attach-point='nextButton' role='option'></div>"+"</div>",baseClass:"dijitComboBoxMenu",postCreate:function(){
this.inherited(arguments);
if(!this.isLeftToRight()){
_98e.add(this.previousButton,"dijitMenuItemRtl");
_98e.add(this.nextButton,"dijitMenuItemRtl");
}
},_createMenuItem:function(){
var item=this.ownerDocument.createElement("div");
item.className="dijitReset dijitMenuItem"+(this.isLeftToRight()?"":" dijitMenuItemRtl");
item.setAttribute("role","option");
return item;
},onHover:function(node){
_98e.add(node,"dijitMenuItemHover");
},onUnhover:function(node){
_98e.remove(node,"dijitMenuItemHover");
},onSelect:function(node){
_98e.add(node,"dijitMenuItemSelected");
},onDeselect:function(node){
_98e.remove(node,"dijitMenuItemSelected");
},_page:function(up){
var _994=0;
var _995=this.domNode.scrollTop;
var _996=_98f.get(this.domNode,"height");
if(!this.getHighlightedOption()){
this.selectNextNode();
}
while(_994<_996){
var _997=this.getHighlightedOption();
if(up){
if(!_997.previousSibling||_997.previousSibling.style.display=="none"){
break;
}
this.selectPreviousNode();
}else{
if(!_997.nextSibling||_997.nextSibling.style.display=="none"){
break;
}
this.selectNextNode();
}
var _998=this.domNode.scrollTop;
_994+=(_998-_995)*(up?-1:1);
_995=_998;
}
},handleKey:function(evt){
switch(evt.keyCode){
case keys.DOWN_ARROW:
this.selectNextNode();
return false;
case keys.PAGE_DOWN:
this._page(false);
return false;
case keys.UP_ARROW:
this.selectPreviousNode();
return false;
case keys.PAGE_UP:
this._page(true);
return false;
default:
return true;
}
}});
});
},"url:dijit/layout/templates/ScrollingTabController.html":"<div class=\"dijitTabListContainer-${tabPosition}\" style=\"visibility:hidden\">\n\t<div data-dojo-type=\"dijit.layout._ScrollingTabControllerMenuButton\"\n\t\t\tclass=\"tabStripButton-${tabPosition}\"\n\t\t\tid=\"${id}_menuBtn\"\n\t\t\tdata-dojo-props=\"containerId: '${containerId}', iconClass: 'dijitTabStripMenuIcon',\n\t\t\t\t\tdropDownPosition: ['below-alt', 'above-alt']\"\n\t\t\tdata-dojo-attach-point=\"_menuBtn\" showLabel=\"false\" title=\"\">&#9660;</div>\n\t<div data-dojo-type=\"dijit.layout._ScrollingTabControllerButton\"\n\t\t\tclass=\"tabStripButton-${tabPosition}\"\n\t\t\tid=\"${id}_leftBtn\"\n\t\t\tdata-dojo-props=\"iconClass:'dijitTabStripSlideLeftIcon', showLabel:false, title:''\"\n\t\t\tdata-dojo-attach-point=\"_leftBtn\" data-dojo-attach-event=\"onClick: doSlideLeft\">&#9664;</div>\n\t<div data-dojo-type=\"dijit.layout._ScrollingTabControllerButton\"\n\t\t\tclass=\"tabStripButton-${tabPosition}\"\n\t\t\tid=\"${id}_rightBtn\"\n\t\t\tdata-dojo-props=\"iconClass:'dijitTabStripSlideRightIcon', showLabel:false, title:''\"\n\t\t\tdata-dojo-attach-point=\"_rightBtn\" data-dojo-attach-event=\"onClick: doSlideRight\">&#9654;</div>\n\t<div class='dijitTabListWrapper' data-dojo-attach-point='tablistWrapper'>\n\t\t<div role='tablist' data-dojo-attach-event='onkeypress:onkeypress'\n\t\t\t\tdata-dojo-attach-point='containerNode' class='nowrapTabStrip'></div>\n\t</div>\n</div>","dijit/Dialog":function(){
require({cache:{"url:dijit/templates/Dialog.html":"<div class=\"dijitDialog\" role=\"dialog\" aria-labelledby=\"${id}_title\">\n\t<div data-dojo-attach-point=\"titleBar\" class=\"dijitDialogTitleBar\">\n\t\t<span data-dojo-attach-point=\"titleNode\" class=\"dijitDialogTitle\" id=\"${id}_title\"\n\t\t\t\trole=\"heading\" level=\"1\"></span>\n\t\t<span data-dojo-attach-point=\"closeButtonNode\" class=\"dijitDialogCloseIcon\" data-dojo-attach-event=\"ondijitclick: onCancel\" title=\"${buttonCancel}\" role=\"button\" tabIndex=\"-1\">\n\t\t\t<span data-dojo-attach-point=\"closeText\" class=\"closeText\" title=\"${buttonCancel}\">x</span>\n\t\t</span>\n\t</div>\n\t<div data-dojo-attach-point=\"containerNode\" class=\"dijitDialogPaneContent\"></div>\n</div>\n"}});
define("dijit/Dialog",["require","dojo/_base/array","dojo/_base/connect","dojo/_base/declare","dojo/_base/Deferred","dojo/dom","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/event","dojo/_base/fx","dojo/i18n","dojo/keys","dojo/_base/lang","dojo/on","dojo/ready","dojo/sniff","dojo/window","dojo/dnd/Moveable","dojo/dnd/TimedMoveable","./focus","./_base/manager","./_Widget","./_TemplatedMixin","./_CssStateMixin","./form/_FormMixin","./_DialogMixin","./DialogUnderlay","./layout/ContentPane","dojo/text!./templates/Dialog.html","./main","dojo/i18n!./nls/common"],function(_999,_99a,_99b,_99c,_99d,dom,_99e,_99f,_9a0,_9a1,fx,i18n,keys,lang,on,_9a2,has,_9a3,_9a4,_9a5,_9a6,_9a7,_9a8,_9a9,_9aa,_9ab,_9ac,_9ad,_9ae,_9af,_9b0){
var _9b1=_99c("dijit._DialogBase",[_9a9,_9ab,_9ac,_9aa],{templateString:_9af,baseClass:"dijitDialog",cssStateNodes:{closeButtonNode:"dijitDialogCloseIcon"},_setTitleAttr:[{node:"titleNode",type:"innerHTML"},{node:"titleBar",type:"attribute"}],open:false,duration:_9a7.defaultDuration,refocus:true,autofocus:true,_firstFocusItem:null,_lastFocusItem:null,doLayout:false,draggable:true,_setDraggableAttr:function(val){
this._set("draggable",val);
},"aria-describedby":"",maxRatio:0.9,postMixInProperties:function(){
var _9b2=i18n.getLocalization("dijit","common");
lang.mixin(this,_9b2);
this.inherited(arguments);
},postCreate:function(){
_9a0.set(this.domNode,{display:"none",position:"absolute"});
this.ownerDocumentBody.appendChild(this.domNode);
this.inherited(arguments);
this.connect(this,"onExecute","hide");
this.connect(this,"onCancel","hide");
this._modalconnects=[];
},onLoad:function(){
this._position();
if(this.autofocus&&_9b3.isTop(this)){
this._getFocusItems(this.domNode);
_9a6.focus(this._firstFocusItem);
}
this.inherited(arguments);
},_onBlur:function(by){
this.inherited(arguments);
var _9b4=lang.hitch(this,function(){
if(this.open&&!this._destroyed&&_9b3.isTop(this)){
this._getFocusItems(this.domNode);
_9a6.focus(this._firstFocusItem);
}
});
if(by=="mouse"){
on.once(this.ownerDocument,"mouseup",_9b4);
}else{
_9b4();
}
},_endDrag:function(){
var _9b5=_99f.position(this.domNode),_9b6=_9a3.getBox(this.ownerDocument);
_9b5.y=Math.min(Math.max(_9b5.y,0),(_9b6.h-_9b5.h));
_9b5.x=Math.min(Math.max(_9b5.x,0),(_9b6.w-_9b5.w));
this._relativePosition=_9b5;
this._position();
},_setup:function(){
var node=this.domNode;
if(this.titleBar&&this.draggable){
this._moveable=new ((has("ie")==6)?_9a5:_9a4)(node,{handle:this.titleBar});
this.connect(this._moveable,"onMoveStop","_endDrag");
}else{
_99e.add(node,"dijitDialogFixed");
}
this.underlayAttrs={dialogId:this.id,"class":_99a.map(this["class"].split(/\s/),function(s){
return s+"_underlay";
}).join(" "),ownerDocument:this.ownerDocument};
},_size:function(){
this._checkIfSingleChild();
if(this._singleChild){
if(typeof this._singleChildOriginalStyle!="undefined"){
this._singleChild.domNode.style.cssText=this._singleChildOriginalStyle;
delete this._singleChildOriginalStyle;
}
}else{
_9a0.set(this.containerNode,{width:"auto",height:"auto"});
}
var bb=_99f.position(this.domNode);
var _9b7=_9a3.getBox(this.ownerDocument);
_9b7.w*=this.maxRatio;
_9b7.h*=this.maxRatio;
if(bb.w>=_9b7.w||bb.h>=_9b7.h){
var _9b8=_99f.position(this.containerNode),w=Math.min(bb.w,_9b7.w)-(bb.w-_9b8.w),h=Math.min(bb.h,_9b7.h)-(bb.h-_9b8.h);
if(this._singleChild&&this._singleChild.resize){
if(typeof this._singleChildOriginalStyle=="undefined"){
this._singleChildOriginalStyle=this._singleChild.domNode.style.cssText;
}
this._singleChild.resize({w:w,h:h});
}else{
_9a0.set(this.containerNode,{width:w+"px",height:h+"px",overflow:"auto",position:"relative"});
}
}else{
if(this._singleChild&&this._singleChild.resize){
this._singleChild.resize();
}
}
},_position:function(){
if(!_99e.contains(this.ownerDocumentBody,"dojoMove")){
var node=this.domNode,_9b9=_9a3.getBox(this.ownerDocument),p=this._relativePosition,bb=p?null:_99f.position(node),l=Math.floor(_9b9.l+(p?p.x:(_9b9.w-bb.w)/2)),t=Math.floor(_9b9.t+(p?p.y:(_9b9.h-bb.h)/2));
_9a0.set(node,{left:l+"px",top:t+"px"});
}
},_onKey:function(evt){
if(evt.charOrCode){
var node=evt.target;
if(evt.charOrCode===keys.TAB){
this._getFocusItems(this.domNode);
}
var _9ba=(this._firstFocusItem==this._lastFocusItem);
if(node==this._firstFocusItem&&evt.shiftKey&&evt.charOrCode===keys.TAB){
if(!_9ba){
_9a6.focus(this._lastFocusItem);
}
_9a1.stop(evt);
}else{
if(node==this._lastFocusItem&&evt.charOrCode===keys.TAB&&!evt.shiftKey){
if(!_9ba){
_9a6.focus(this._firstFocusItem);
}
_9a1.stop(evt);
}else{
while(node){
if(node==this.domNode||_99e.contains(node,"dijitPopup")){
if(evt.charOrCode==keys.ESCAPE){
this.onCancel();
}else{
return;
}
}
node=node.parentNode;
}
if(evt.charOrCode!==keys.TAB){
_9a1.stop(evt);
}else{
if(!has("opera")){
try{
this._firstFocusItem.focus();
}
catch(e){
}
}
}
}
}
}
},show:function(){
if(this.open){
return;
}
if(!this._started){
this.startup();
}
if(!this._alreadyInitialized){
this._setup();
this._alreadyInitialized=true;
}
if(this._fadeOutDeferred){
this._fadeOutDeferred.cancel();
}
var win=_9a3.get(this.ownerDocument);
this._modalconnects.push(on(win,"scroll",lang.hitch(this,"resize")));
this._modalconnects.push(on(this.domNode,_99b._keypress,lang.hitch(this,"_onKey")));
_9a0.set(this.domNode,{opacity:0,display:""});
this._set("open",true);
this._onShow();
this._size();
this._position();
var _9bb;
this._fadeInDeferred=new _99d(lang.hitch(this,function(){
_9bb.stop();
delete this._fadeInDeferred;
}));
_9bb=fx.fadeIn({node:this.domNode,duration:this.duration,beforeBegin:lang.hitch(this,function(){
_9b3.show(this,this.underlayAttrs);
}),onEnd:lang.hitch(this,function(){
if(this.autofocus&&_9b3.isTop(this)){
this._getFocusItems(this.domNode);
_9a6.focus(this._firstFocusItem);
}
this._fadeInDeferred.resolve(true);
delete this._fadeInDeferred;
})}).play();
return this._fadeInDeferred;
},hide:function(){
if(!this._alreadyInitialized||!this.open){
return;
}
if(this._fadeInDeferred){
this._fadeInDeferred.cancel();
}
var _9bc;
this._fadeOutDeferred=new _99d(lang.hitch(this,function(){
_9bc.stop();
delete this._fadeOutDeferred;
}));
this._fadeOutDeferred.then(lang.hitch(this,"onHide"));
_9bc=fx.fadeOut({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,function(){
this.domNode.style.display="none";
_9b3.hide(this);
this._fadeOutDeferred.resolve(true);
delete this._fadeOutDeferred;
})}).play();
if(this._scrollConnected){
this._scrollConnected=false;
}
var h;
while(h=this._modalconnects.pop()){
h.remove();
}
if(this._relativePosition){
delete this._relativePosition;
}
this._set("open",false);
return this._fadeOutDeferred;
},resize:function(){
if(this.domNode.style.display!="none"){
if(_9ad._singleton){
_9ad._singleton.layout();
}
this._position();
this._size();
}
},destroy:function(){
if(this._fadeInDeferred){
this._fadeInDeferred.cancel();
}
if(this._fadeOutDeferred){
this._fadeOutDeferred.cancel();
}
if(this._moveable){
this._moveable.destroy();
}
var h;
while(h=this._modalconnects.pop()){
h.remove();
}
_9b3.hide(this);
this.inherited(arguments);
}});
var _9bd=_99c("dijit.Dialog",[_9ae,_9b1],{});
_9bd._DialogBase=_9b1;
var _9b3=_9bd._DialogLevelManager={_beginZIndex:950,show:function(_9be,_9bf){
ds[ds.length-1].focus=_9a6.curNode;
var _9c0=_9ad._singleton;
if(!_9c0||_9c0._destroyed){
_9c0=_9b0._underlay=_9ad._singleton=new _9ad(_9bf);
}else{
_9c0.set(_9be.underlayAttrs);
}
var _9c1=ds[ds.length-1].dialog?ds[ds.length-1].zIndex+2:_9bd._DialogLevelManager._beginZIndex;
if(ds.length==1){
_9c0.show();
}
_9a0.set(_9ad._singleton.domNode,"zIndex",_9c1-1);
_9a0.set(_9be.domNode,"zIndex",_9c1);
ds.push({dialog:_9be,underlayAttrs:_9bf,zIndex:_9c1});
},hide:function(_9c2){
if(ds[ds.length-1].dialog==_9c2){
ds.pop();
var pd=ds[ds.length-1];
if(!_9ad._singleton._destroyed){
if(ds.length==1){
_9ad._singleton.hide();
}else{
_9a0.set(_9ad._singleton.domNode,"zIndex",pd.zIndex-1);
_9ad._singleton.set(pd.underlayAttrs);
}
}
if(_9c2.refocus){
var _9c3=pd.focus;
if(pd.dialog&&(!_9c3||!dom.isDescendant(_9c3,pd.dialog.domNode))){
pd.dialog._getFocusItems(pd.dialog.domNode);
_9c3=pd.dialog._firstFocusItem;
}
if(_9c3){
try{
_9c3.focus();
}
catch(e){
}
}
}
}else{
var idx=_99a.indexOf(_99a.map(ds,function(elem){
return elem.dialog;
}),_9c2);
if(idx!=-1){
ds.splice(idx,1);
}
}
},isTop:function(_9c4){
return ds[ds.length-1].dialog==_9c4;
}};
var ds=_9bd._dialogStack=[{dialog:null,focus:null,underlayAttrs:null}];
if(has("dijit-legacy-requires")){
_9a2(0,function(){
var _9c5=["dijit/TooltipDialog"];
_999(_9c5);
});
}
return _9bd;
});
},"dijit/form/MultiSelect":function(){
define("dijit/form/MultiSelect",["dojo/_base/array","dojo/_base/declare","dojo/dom-geometry","dojo/query","./_FormValueWidget"],function(_9c6,_9c7,_9c8,_9c9,_9ca){
return _9c7("dijit.form.MultiSelect",_9ca,{size:7,templateString:"<select multiple='true' ${!nameAttrSetting} data-dojo-attach-point='containerNode,focusNode' data-dojo-attach-event='onchange: _onChange'></select>",addSelected:function(_9cb){
_9cb.getSelected().forEach(function(n){
if(this.restoreOriginalText){
n.text=this.enforceTextDirWithUcc(this.restoreOriginalText(n),n.text);
}
this.containerNode.appendChild(n);
this.domNode.scrollTop=this.domNode.offsetHeight;
var _9cc=_9cb.domNode.scrollTop;
_9cb.domNode.scrollTop=0;
_9cb.domNode.scrollTop=_9cc;
},this);
this._set("value",this.get("value"));
},getSelected:function(){
return _9c9("option",this.containerNode).filter(function(n){
return n.selected;
});
},_getValueAttr:function(){
return _9c6.map(this.getSelected(),function(n){
return n.value;
});
},multiple:true,_setValueAttr:function(_9cd,_9ce){
_9c9("option",this.containerNode).forEach(function(n){
n.selected=(_9c6.indexOf(_9cd,n.value)!=-1);
});
this.inherited(arguments);
},invertSelection:function(_9cf){
var val=[];
_9c9("option",this.containerNode).forEach(function(n){
if(!n.selected){
val.push(n.value);
}
});
this._setValueAttr(val,!(_9cf===false||_9cf==null));
},_onChange:function(){
this._handleOnChange(this.get("value"),true);
},resize:function(size){
if(size){
_9c8.setMarginBox(this.domNode,size);
}
},postCreate:function(){
this._set("value",this.get("value"));
this.inherited(arguments);
},_setTextDirAttr:function(_9d0){
if((this.textDir!=_9d0||!this._created)&&this.enforceTextDirWithUcc){
this._set("textDir",_9d0);
_9c9("option",this.containerNode).forEach(function(_9d1){
if(!this._created&&_9d1.value===_9d1.text){
_9d1.value=_9d1.text;
}
_9d1.text=this.enforceTextDirWithUcc(_9d1,_9d1.originalText||_9d1.text);
},this);
}
}});
});
},"dijit/form/_DateTimeTextBox":function(){
define(["dojo/date","dojo/date/locale","dojo/date/stamp","dojo/_base/declare","dojo/_base/lang","./RangeBoundTextBox","../_HasDropDown","dojo/text!./templates/DropDownBox.html"],function(date,_9d2,_9d3,_9d4,lang,_9d5,_9d6,_9d7){
new Date("X");
var _9d8=_9d4("dijit.form._DateTimeTextBox",[_9d5,_9d6],{templateString:_9d7,hasDownArrow:true,cssStateNodes:{"_buttonNode":"dijitDownArrowButton"},pattern:_9d2.regexp,datePackage:"",postMixInProperties:function(){
this.inherited(arguments);
this._set("type","text");
},compare:function(val1,val2){
var _9d9=this._isInvalidDate(val1);
var _9da=this._isInvalidDate(val2);
return _9d9?(_9da?0:-1):(_9da?1:date.compare(val1,val2,this._selector));
},forceWidth:true,format:function(_9db,_9dc){
if(!_9db){
return "";
}
return this.dateLocaleModule.format(_9db,_9dc);
},"parse":function(_9dd,_9de){
return this.dateLocaleModule.parse(_9dd,_9de)||(this._isEmpty(_9dd)?null:undefined);
},serialize:function(val,_9df){
if(val.toGregorian){
val=val.toGregorian();
}
return _9d3.toISOString(val,_9df);
},dropDownDefaultValue:new Date(),value:new Date(""),_blankValue:null,popupClass:"",_selector:"",constructor:function(_9e0){
this.dateModule=_9e0.datePackage?lang.getObject(_9e0.datePackage,false):date;
this.dateClassObj=this.dateModule.Date||Date;
this.dateLocaleModule=_9e0.datePackage?lang.getObject(_9e0.datePackage+".locale",false):_9d2;
this._set("pattern",this.dateLocaleModule.regexp);
this._invalidDate=this.constructor.prototype.value.toString();
},buildRendering:function(){
this.inherited(arguments);
if(!this.hasDownArrow){
this._buttonNode.style.display="none";
}
if(!this.hasDownArrow){
this._buttonNode=this.domNode;
this.baseClass+=" dijitComboBoxOpenOnClick";
}
},_setConstraintsAttr:function(_9e1){
_9e1.selector=this._selector;
_9e1.fullYear=true;
var _9e2=_9d3.fromISOString;
if(typeof _9e1.min=="string"){
_9e1.min=_9e2(_9e1.min);
}
if(typeof _9e1.max=="string"){
_9e1.max=_9e2(_9e1.max);
}
this.inherited(arguments);
},_isInvalidDate:function(_9e3){
return !_9e3||isNaN(_9e3)||typeof _9e3!="object"||_9e3.toString()==this._invalidDate;
},_setValueAttr:function(_9e4,_9e5,_9e6){
if(_9e4!==undefined){
if(typeof _9e4=="string"){
_9e4=_9d3.fromISOString(_9e4);
}
if(this._isInvalidDate(_9e4)){
_9e4=null;
}
if(_9e4 instanceof Date&&!(this.dateClassObj instanceof Date)){
_9e4=new this.dateClassObj(_9e4);
}
}
this.inherited(arguments);
if(this.value instanceof Date){
this.filterString="";
}
if(this.dropDown){
this.dropDown.set("value",_9e4,false);
}
},_set:function(attr,_9e7){
if(attr=="value"&&this.value instanceof Date&&this.compare(_9e7,this.value)==0){
return;
}
this.inherited(arguments);
},_setDropDownDefaultValueAttr:function(val){
if(this._isInvalidDate(val)){
val=new this.dateClassObj();
}
this.dropDownDefaultValue=val;
},openDropDown:function(_9e8){
if(this.dropDown){
this.dropDown.destroy();
}
var _9e9=lang.isString(this.popupClass)?lang.getObject(this.popupClass,false):this.popupClass,_9ea=this,_9eb=this.get("value");
this.dropDown=new _9e9({onChange:function(_9ec){
_9ea.set("value",_9ec,true);
},id:this.id+"_popup",dir:_9ea.dir,lang:_9ea.lang,value:_9eb,currentFocus:!this._isInvalidDate(_9eb)?_9eb:this.dropDownDefaultValue,constraints:_9ea.constraints,filterString:_9ea.filterString,datePackage:_9ea.params.datePackage,isDisabledDate:function(date){
return !_9ea.rangeCheck(date,_9ea.constraints);
}});
this.inherited(arguments);
},_getDisplayedValueAttr:function(){
return this.textbox.value;
},_setDisplayedValueAttr:function(_9ed,_9ee){
this._setValueAttr(this.parse(_9ed,this.constraints),_9ee,_9ed);
}});
return _9d8;
});
},"dijit/form/_ToggleButtonMixin":function(){
define(["dojo/_base/declare","dojo/dom-attr"],function(_9ef,_9f0){
return _9ef("dijit.form._ToggleButtonMixin",null,{checked:false,_aria_attr:"aria-pressed",_onClick:function(evt){
var _9f1=this.checked;
this._set("checked",!_9f1);
var ret=this.inherited(arguments);
this.set("checked",ret?this.checked:_9f1);
return ret;
},_setCheckedAttr:function(_9f2,_9f3){
this._set("checked",_9f2);
var node=this.focusNode||this.domNode;
_9f0.set(node,"checked",!!_9f2);
if(_9f2){
node.setAttribute("checked","");
}else{
node.removeAttribute("checked");
}
node.setAttribute(this._aria_attr,String(_9f2));
this._handleOnChange(_9f2,_9f3);
},reset:function(){
this._hasBeenBlurred=false;
this.set("checked",this.params.checked||false);
}});
});
},"dijit/Calendar":function(){
define(["dojo/_base/array","dojo/date","dojo/date/locale","dojo/_base/declare","dojo/dom-attr","dojo/dom-class","dojo/_base/event","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/sniff","./CalendarLite","./_Widget","./_CssStateMixin","./_TemplatedMixin","./form/DropDownButton"],function(_9f4,date,_9f5,_9f6,_9f7,_9f8,_9f9,_9fa,keys,lang,has,_9fb,_9fc,_9fd,_9fe,_9ff){
var _a00=_9f6("dijit.Calendar",[_9fb,_9fc,_9fd],{cssStateNodes:{"decrementMonth":"dijitCalendarArrow","incrementMonth":"dijitCalendarArrow","previousYearLabelNode":"dijitCalendarPreviousYear","nextYearLabelNode":"dijitCalendarNextYear"},setValue:function(_a01){
_9fa.deprecated("dijit.Calendar:setValue() is deprecated.  Use set('value', ...) instead.","","2.0");
this.set("value",_a01);
},_createMonthWidget:function(){
return new _a00._MonthDropDownButton({id:this.id+"_mddb",tabIndex:-1,onMonthSelect:lang.hitch(this,"_onMonthSelect"),lang:this.lang,dateLocaleModule:this.dateLocaleModule},this.monthNode);
},postCreate:function(){
this.inherited(arguments);
this.connect(this.domNode,"onkeydown","_onKeyDown");
this.connect(this.dateRowsNode,"onmouseover","_onDayMouseOver");
this.connect(this.dateRowsNode,"onmouseout","_onDayMouseOut");
this.connect(this.dateRowsNode,"onmousedown","_onDayMouseDown");
this.connect(this.dateRowsNode,"onmouseup","_onDayMouseUp");
},_onMonthSelect:function(_a02){
var date=new this.dateClassObj(this.currentFocus);
date.setDate(1);
date.setMonth(_a02);
var _a03=this.dateModule.getDaysInMonth(date);
var _a04=this.currentFocus.getDate();
date.setDate(Math.min(_a04,_a03));
this._setCurrentFocusAttr(date);
},_onDayMouseOver:function(evt){
var node=_9f8.contains(evt.target,"dijitCalendarDateLabel")?evt.target.parentNode:evt.target;
if(node&&((node.dijitDateValue&&!_9f8.contains(node,"dijitCalendarDisabledDate"))||node==this.previousYearLabelNode||node==this.nextYearLabelNode)){
_9f8.add(node,"dijitCalendarHoveredDate");
this._currentNode=node;
}
},_onDayMouseOut:function(evt){
if(!this._currentNode){
return;
}
if(evt.relatedTarget&&evt.relatedTarget.parentNode==this._currentNode){
return;
}
var cls="dijitCalendarHoveredDate";
if(_9f8.contains(this._currentNode,"dijitCalendarActiveDate")){
cls+=" dijitCalendarActiveDate";
}
_9f8.remove(this._currentNode,cls);
this._currentNode=null;
},_onDayMouseDown:function(evt){
var node=evt.target.parentNode;
if(node&&node.dijitDateValue&&!_9f8.contains(node,"dijitCalendarDisabledDate")){
_9f8.add(node,"dijitCalendarActiveDate");
this._currentNode=node;
}
},_onDayMouseUp:function(evt){
var node=evt.target.parentNode;
if(node&&node.dijitDateValue){
_9f8.remove(node,"dijitCalendarActiveDate");
}
},handleKey:function(evt){
var _a05=-1,_a06,_a07=this.currentFocus;
switch(evt.keyCode){
case keys.RIGHT_ARROW:
_a05=1;
case keys.LEFT_ARROW:
_a06="day";
if(!this.isLeftToRight()){
_a05*=-1;
}
break;
case keys.DOWN_ARROW:
_a05=1;
case keys.UP_ARROW:
_a06="week";
break;
case keys.PAGE_DOWN:
_a05=1;
case keys.PAGE_UP:
_a06=evt.ctrlKey||evt.altKey?"year":"month";
break;
case keys.END:
_a07=this.dateModule.add(_a07,"month",1);
_a06="day";
case keys.HOME:
_a07=new this.dateClassObj(_a07);
_a07.setDate(1);
break;
case keys.ENTER:
case keys.SPACE:
this.set("value",this.currentFocus);
break;
default:
return true;
}
if(_a06){
_a07=this.dateModule.add(_a07,_a06,_a05);
}
this._setCurrentFocusAttr(_a07);
return false;
},_onKeyDown:function(evt){
if(!this.handleKey(evt)){
_9f9.stop(evt);
}
},onValueSelected:function(){
},onChange:function(_a08){
this.onValueSelected(_a08);
},getClassForDate:function(){
}});
_a00._MonthDropDownButton=_9f6("dijit.Calendar._MonthDropDownButton",_9ff,{onMonthSelect:function(){
},postCreate:function(){
this.inherited(arguments);
this.dropDown=new _a00._MonthDropDown({id:this.id+"_mdd",onChange:this.onMonthSelect});
},_setMonthAttr:function(_a09){
var _a0a=this.dateLocaleModule.getNames("months","wide","standAlone",this.lang,_a09);
this.dropDown.set("months",_a0a);
this.containerNode.innerHTML=(has("ie")==6?"":"<div class='dijitSpacer'>"+this.dropDown.domNode.innerHTML+"</div>")+"<div class='dijitCalendarMonthLabel dijitCalendarCurrentMonthLabel'>"+_a0a[_a09.getMonth()]+"</div>";
}});
_a00._MonthDropDown=_9f6("dijit.Calendar._MonthDropDown",[_9fc,_9fe],{months:[],templateString:"<div class='dijitCalendarMonthMenu dijitMenu' "+"data-dojo-attach-event='onclick:_onClick,onmouseover:_onMenuHover,onmouseout:_onMenuHover'></div>",_setMonthsAttr:function(_a0b){
this.domNode.innerHTML=_9f4.map(_a0b,function(_a0c,idx){
return _a0c?"<div class='dijitCalendarMonthLabel' month='"+idx+"'>"+_a0c+"</div>":"";
}).join("");
},_onClick:function(evt){
this.onChange(_9f7.get(evt.target,"month"));
},onChange:function(){
},_onMenuHover:function(evt){
_9f8.toggle(evt.target,"dijitCalendarMonthLabelHover",evt.type=="mouseover");
}});
return _a00;
});
},"url:dijit/form/templates/Select.html":"<table class=\"dijit dijitReset dijitInline dijitLeft\"\n\tdata-dojo-attach-point=\"_buttonNode,tableNode,focusNode\" cellspacing='0' cellpadding='0'\n\trole=\"listbox\" aria-haspopup=\"true\"\n\t><tbody role=\"presentation\"><tr role=\"presentation\"\n\t\t><td class=\"dijitReset dijitStretch dijitButtonContents\" role=\"presentation\"\n\t\t\t><div class=\"dijitReset dijitInputField dijitButtonText\"  data-dojo-attach-point=\"containerNode,_popupStateNode\" role=\"presentation\"></div\n\t\t\t><div class=\"dijitReset dijitValidationContainer\"\n\t\t\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t\t/></div\n\t\t\t><input type=\"hidden\" ${!nameAttrSetting} data-dojo-attach-point=\"valueNode\" value=\"${value}\" aria-hidden=\"true\"\n\t\t/></td\n\t\t><td class=\"dijitReset dijitRight dijitButtonNode dijitArrowButton dijitDownArrowButton dijitArrowButtonContainer\"\n\t\t\tdata-dojo-attach-point=\"titleNode\" role=\"presentation\"\n\t\t\t><input class=\"dijitReset dijitInputField dijitArrowButtonInner\" value=\"&#9660; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t\t\t${_buttonInputDisabled}\n\t\t/></td\n\t></tr></tbody\n></table>\n","dijit/_editor/selection":function(){
define(["dojo/dom","dojo/_base/lang","dojo/sniff","dojo/_base/window","../main"],function(dom,lang,has,win,_a0d){
var _a0e={getType:function(){
if(win.doc.getSelection){
var _a0f="text";
var oSel;
try{
oSel=win.global.getSelection();
}
catch(e){
}
if(oSel&&oSel.rangeCount==1){
var _a10=oSel.getRangeAt(0);
if((_a10.startContainer==_a10.endContainer)&&((_a10.endOffset-_a10.startOffset)==1)&&(_a10.startContainer.nodeType!=3)){
_a0f="control";
}
}
return _a0f;
}else{
return win.doc.selection.type.toLowerCase();
}
},getSelectedText:function(){
if(win.doc.getSelection){
var _a11=win.global.getSelection();
return _a11?_a11.toString():"";
}else{
if(_a0d._editor.selection.getType()=="control"){
return null;
}
return win.doc.selection.createRange().text;
}
},getSelectedHtml:function(){
if(win.doc.getSelection){
var _a12=win.global.getSelection();
if(_a12&&_a12.rangeCount){
var i;
var html="";
for(i=0;i<_a12.rangeCount;i++){
var frag=_a12.getRangeAt(i).cloneContents();
var div=win.doc.createElement("div");
div.appendChild(frag);
html+=div.innerHTML;
}
return html;
}
return null;
}else{
if(_a0d._editor.selection.getType()=="control"){
return null;
}
return win.doc.selection.createRange().htmlText;
}
},getSelectedElement:function(){
if(_a0d._editor.selection.getType()=="control"){
if(win.doc.getSelection){
var _a13=win.global.getSelection();
return _a13.anchorNode.childNodes[_a13.anchorOffset];
}else{
var _a14=win.doc.selection.createRange();
if(_a14&&_a14.item){
return win.doc.selection.createRange().item(0);
}
}
}
return null;
},getParentElement:function(){
if(_a0d._editor.selection.getType()=="control"){
var p=this.getSelectedElement();
if(p){
return p.parentNode;
}
}else{
if(win.doc.getSelection){
var _a15=win.global.getSelection();
if(_a15){
var node=_a15.anchorNode;
while(node&&(node.nodeType!=1)){
node=node.parentNode;
}
return node;
}
}else{
var r=win.doc.selection.createRange();
r.collapse(true);
return r.parentElement();
}
}
return null;
},hasAncestorElement:function(_a16){
return this.getAncestorElement.apply(this,arguments)!=null;
},getAncestorElement:function(_a17){
var node=this.getSelectedElement()||this.getParentElement();
return this.getParentOfType(node,arguments);
},isTag:function(node,tags){
if(node&&node.tagName){
var _a18=node.tagName.toLowerCase();
for(var i=0;i<tags.length;i++){
var _a19=String(tags[i]).toLowerCase();
if(_a18==_a19){
return _a19;
}
}
}
return "";
},getParentOfType:function(node,tags){
while(node){
if(this.isTag(node,tags).length){
return node;
}
node=node.parentNode;
}
return null;
},collapse:function(_a1a){
if(win.doc.getSelection){
var _a1b=win.global.getSelection();
if(_a1b.removeAllRanges){
if(_a1a){
_a1b.collapseToStart();
}else{
_a1b.collapseToEnd();
}
}else{
_a1b.collapse(_a1a);
}
}else{
var _a1c=win.doc.selection.createRange();
_a1c.collapse(_a1a);
_a1c.select();
}
},remove:function(){
var sel=win.doc.selection;
if(win.doc.getSelection){
sel=win.global.getSelection();
sel.deleteFromDocument();
return sel;
}else{
if(sel.type.toLowerCase()!="none"){
sel.clear();
}
return sel;
}
},selectElementChildren:function(_a1d,_a1e){
var doc=win.doc;
var _a1f;
_a1d=dom.byId(_a1d);
if(win.doc.getSelection){
var _a20=win.global.getSelection();
if(has("opera")){
if(_a20.rangeCount){
_a1f=_a20.getRangeAt(0);
}else{
_a1f=doc.createRange();
}
_a1f.setStart(_a1d,0);
_a1f.setEnd(_a1d,(_a1d.nodeType==3)?_a1d.length:_a1d.childNodes.length);
_a20.addRange(_a1f);
}else{
_a20.selectAllChildren(_a1d);
}
}else{
_a1f=_a1d.ownerDocument.body.createTextRange();
_a1f.moveToElementText(_a1d);
if(!_a1e){
try{
_a1f.select();
}
catch(e){
}
}
}
},selectElement:function(_a21,_a22){
var _a23;
_a21=dom.byId(_a21);
var doc=_a21.ownerDocument;
var _a24=win.global;
if(doc.getSelection){
var _a25=_a24.getSelection();
_a23=doc.createRange();
if(_a25.removeAllRanges){
if(has("opera")){
if(_a25.getRangeAt(0)){
_a23=_a25.getRangeAt(0);
}
}
_a23.selectNode(_a21);
_a25.removeAllRanges();
_a25.addRange(_a23);
}
}else{
try{
var tg=_a21.tagName?_a21.tagName.toLowerCase():"";
if(tg==="img"||tg==="table"){
_a23=win.body(doc).createControlRange();
}else{
_a23=win.body(doc).createRange();
}
_a23.addElement(_a21);
if(!_a22){
_a23.select();
}
}
catch(e){
this.selectElementChildren(_a21,_a22);
}
}
},inSelection:function(node){
if(node){
var _a26;
var doc=win.doc;
var _a27;
if(win.doc.getSelection){
var sel=win.global.getSelection();
if(sel&&sel.rangeCount>0){
_a27=sel.getRangeAt(0);
}
if(_a27&&_a27.compareBoundaryPoints&&doc.createRange){
try{
_a26=doc.createRange();
_a26.setStart(node,0);
if(_a27.compareBoundaryPoints(_a27.START_TO_END,_a26)===1){
return true;
}
}
catch(e){
}
}
}else{
_a27=doc.selection.createRange();
try{
_a26=node.ownerDocument.body.createControlRange();
if(_a26){
_a26.addElement(node);
}
}
catch(e1){
try{
_a26=node.ownerDocument.body.createTextRange();
_a26.moveToElementText(node);
}
catch(e2){
}
}
if(_a27&&_a26){
if(_a27.compareEndPoints("EndToStart",_a26)===1){
return true;
}
}
}
}
return false;
}};
lang.setObject("dijit._editor.selection",_a0e);
return _a0e;
});
},"dojo/fx":function(){
define(["./_base/lang","./Evented","./_base/kernel","./_base/array","./_base/connect","./_base/fx","./dom","./dom-style","./dom-geometry","./ready","require"],function(lang,_a28,dojo,_a29,_a2a,_a2b,dom,_a2c,geom,_a2d,_a2e){
if(!dojo.isAsync){
_a2d(0,function(){
var _a2f=["./fx/Toggler"];
_a2e(_a2f);
});
}
var _a30=dojo.fx={};
var _a31={_fire:function(evt,args){
if(this[evt]){
this[evt].apply(this,args||[]);
}
return this;
}};
var _a32=function(_a33){
this._index=-1;
this._animations=_a33||[];
this._current=this._onAnimateCtx=this._onEndCtx=null;
this.duration=0;
_a29.forEach(this._animations,function(a){
this.duration+=a.duration;
if(a.delay){
this.duration+=a.delay;
}
},this);
};
_a32.prototype=new _a28();
lang.extend(_a32,{_onAnimate:function(){
this._fire("onAnimate",arguments);
},_onEnd:function(){
_a2a.disconnect(this._onAnimateCtx);
_a2a.disconnect(this._onEndCtx);
this._onAnimateCtx=this._onEndCtx=null;
if(this._index+1==this._animations.length){
this._fire("onEnd");
}else{
this._current=this._animations[++this._index];
this._onAnimateCtx=_a2a.connect(this._current,"onAnimate",this,"_onAnimate");
this._onEndCtx=_a2a.connect(this._current,"onEnd",this,"_onEnd");
this._current.play(0,true);
}
},play:function(_a34,_a35){
if(!this._current){
this._current=this._animations[this._index=0];
}
if(!_a35&&this._current.status()=="playing"){
return this;
}
var _a36=_a2a.connect(this._current,"beforeBegin",this,function(){
this._fire("beforeBegin");
}),_a37=_a2a.connect(this._current,"onBegin",this,function(arg){
this._fire("onBegin",arguments);
}),_a38=_a2a.connect(this._current,"onPlay",this,function(arg){
this._fire("onPlay",arguments);
_a2a.disconnect(_a36);
_a2a.disconnect(_a37);
_a2a.disconnect(_a38);
});
if(this._onAnimateCtx){
_a2a.disconnect(this._onAnimateCtx);
}
this._onAnimateCtx=_a2a.connect(this._current,"onAnimate",this,"_onAnimate");
if(this._onEndCtx){
_a2a.disconnect(this._onEndCtx);
}
this._onEndCtx=_a2a.connect(this._current,"onEnd",this,"_onEnd");
this._current.play.apply(this._current,arguments);
return this;
},pause:function(){
if(this._current){
var e=_a2a.connect(this._current,"onPause",this,function(arg){
this._fire("onPause",arguments);
_a2a.disconnect(e);
});
this._current.pause();
}
return this;
},gotoPercent:function(_a39,_a3a){
this.pause();
var _a3b=this.duration*_a39;
this._current=null;
_a29.some(this._animations,function(a){
if(a.duration<=_a3b){
this._current=a;
return true;
}
_a3b-=a.duration;
return false;
});
if(this._current){
this._current.gotoPercent(_a3b/this._current.duration,_a3a);
}
return this;
},stop:function(_a3c){
if(this._current){
if(_a3c){
for(;this._index+1<this._animations.length;++this._index){
this._animations[this._index].stop(true);
}
this._current=this._animations[this._index];
}
var e=_a2a.connect(this._current,"onStop",this,function(arg){
this._fire("onStop",arguments);
_a2a.disconnect(e);
});
this._current.stop();
}
return this;
},status:function(){
return this._current?this._current.status():"stopped";
},destroy:function(){
if(this._onAnimateCtx){
_a2a.disconnect(this._onAnimateCtx);
}
if(this._onEndCtx){
_a2a.disconnect(this._onEndCtx);
}
}});
lang.extend(_a32,_a31);
_a30.chain=function(_a3d){
return new _a32(_a3d);
};
var _a3e=function(_a3f){
this._animations=_a3f||[];
this._connects=[];
this._finished=0;
this.duration=0;
_a29.forEach(_a3f,function(a){
var _a40=a.duration;
if(a.delay){
_a40+=a.delay;
}
if(this.duration<_a40){
this.duration=_a40;
}
this._connects.push(_a2a.connect(a,"onEnd",this,"_onEnd"));
},this);
this._pseudoAnimation=new _a2b.Animation({curve:[0,1],duration:this.duration});
var self=this;
_a29.forEach(["beforeBegin","onBegin","onPlay","onAnimate","onPause","onStop","onEnd"],function(evt){
self._connects.push(_a2a.connect(self._pseudoAnimation,evt,function(){
self._fire(evt,arguments);
}));
});
};
lang.extend(_a3e,{_doAction:function(_a41,args){
_a29.forEach(this._animations,function(a){
a[_a41].apply(a,args);
});
return this;
},_onEnd:function(){
if(++this._finished>this._animations.length){
this._fire("onEnd");
}
},_call:function(_a42,args){
var t=this._pseudoAnimation;
t[_a42].apply(t,args);
},play:function(_a43,_a44){
this._finished=0;
this._doAction("play",arguments);
this._call("play",arguments);
return this;
},pause:function(){
this._doAction("pause",arguments);
this._call("pause",arguments);
return this;
},gotoPercent:function(_a45,_a46){
var ms=this.duration*_a45;
_a29.forEach(this._animations,function(a){
a.gotoPercent(a.duration<ms?1:(ms/a.duration),_a46);
});
this._call("gotoPercent",arguments);
return this;
},stop:function(_a47){
this._doAction("stop",arguments);
this._call("stop",arguments);
return this;
},status:function(){
return this._pseudoAnimation.status();
},destroy:function(){
_a29.forEach(this._connects,_a2a.disconnect);
}});
lang.extend(_a3e,_a31);
_a30.combine=function(_a48){
return new _a3e(_a48);
};
_a30.wipeIn=function(args){
var node=args.node=dom.byId(args.node),s=node.style,o;
var anim=_a2b.animateProperty(lang.mixin({properties:{height:{start:function(){
o=s.overflow;
s.overflow="hidden";
if(s.visibility=="hidden"||s.display=="none"){
s.height="1px";
s.display="";
s.visibility="";
return 1;
}else{
var _a49=_a2c.get(node,"height");
return Math.max(_a49,1);
}
},end:function(){
return node.scrollHeight;
}}}},args));
var fini=function(){
s.height="auto";
s.overflow=o;
};
_a2a.connect(anim,"onStop",fini);
_a2a.connect(anim,"onEnd",fini);
return anim;
};
_a30.wipeOut=function(args){
var node=args.node=dom.byId(args.node),s=node.style,o;
var anim=_a2b.animateProperty(lang.mixin({properties:{height:{end:1}}},args));
_a2a.connect(anim,"beforeBegin",function(){
o=s.overflow;
s.overflow="hidden";
s.display="";
});
var fini=function(){
s.overflow=o;
s.height="auto";
s.display="none";
};
_a2a.connect(anim,"onStop",fini);
_a2a.connect(anim,"onEnd",fini);
return anim;
};
_a30.slideTo=function(args){
var node=args.node=dom.byId(args.node),top=null,left=null;
var init=(function(n){
return function(){
var cs=_a2c.getComputedStyle(n);
var pos=cs.position;
top=(pos=="absolute"?n.offsetTop:parseInt(cs.top)||0);
left=(pos=="absolute"?n.offsetLeft:parseInt(cs.left)||0);
if(pos!="absolute"&&pos!="relative"){
var ret=geom.position(n,true);
top=ret.y;
left=ret.x;
n.style.position="absolute";
n.style.top=top+"px";
n.style.left=left+"px";
}
};
})(node);
init();
var anim=_a2b.animateProperty(lang.mixin({properties:{top:args.top||0,left:args.left||0}},args));
_a2a.connect(anim,"beforeBegin",anim,init);
return anim;
};
return _a30;
});
},"dijit/_DialogMixin":function(){
define("dijit/_DialogMixin",["dojo/_base/declare","./a11y"],function(_a4a,a11y){
return _a4a("dijit._DialogMixin",null,{execute:function(){
},onCancel:function(){
},onExecute:function(){
},_onSubmit:function(){
this.onExecute();
this.execute(this.get("value"));
},_getFocusItems:function(){
var _a4b=a11y._getTabNavigable(this.containerNode);
this._firstFocusItem=_a4b.lowest||_a4b.first||this.closeButtonNode||this.domNode;
this._lastFocusItem=_a4b.last||_a4b.highest||this._firstFocusItem;
}});
});
},"dijit/Tree":function(){
define(["dojo/_base/array","dojo/_base/connect","dojo/cookie","dojo/_base/declare","dojo/Deferred","dojo/DeferredList","dojo/dom","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/event","dojo/errors/create","dojo/fx","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/on","dojo/topic","dojo/touch","dojo/when","./focus","./registry","./_base/manager","./_Widget","./_TemplatedMixin","./_Container","./_Contained","./_CssStateMixin","dojo/text!./templates/TreeNode.html","dojo/text!./templates/Tree.html","./tree/TreeStoreModel","./tree/ForestStoreModel","./tree/_dndSelector"],function(_a4c,_a4d,_a4e,_a4f,_a50,_a51,dom,_a52,_a53,_a54,_a55,_a56,_a57,_a58,keys,lang,on,_a59,_a5a,when,_a5b,_a5c,_a5d,_a5e,_a5f,_a60,_a61,_a62,_a63,_a64,_a65,_a66,_a67){
_a50=_a4f(_a50,{addCallback:function(_a68){
this.then(_a68);
},addErrback:function(_a69){
this.then(null,_a69);
}});
var _a6a=_a4f("dijit._TreeNode",[_a5e,_a5f,_a60,_a61,_a62],{item:null,isTreeNode:true,label:"",_setLabelAttr:{node:"labelNode",type:"innerText"},isExpandable:null,isExpanded:false,state:"UNCHECKED",templateString:_a63,baseClass:"dijitTreeNode",cssStateNodes:{rowNode:"dijitTreeRow"},_setTooltipAttr:{node:"rowNode",type:"attribute",attribute:"title"},buildRendering:function(){
this.inherited(arguments);
this._setExpando();
this._updateItemClasses(this.item);
if(this.isExpandable){
this.labelNode.setAttribute("aria-expanded",this.isExpanded);
}
this.setSelected(false);
},_setIndentAttr:function(_a6b){
var _a6c=(Math.max(_a6b,0)*this.tree._nodePixelIndent)+"px";
_a54.set(this.domNode,"backgroundPosition",_a6c+" 0px");
_a54.set(this.indentNode,this.isLeftToRight()?"paddingLeft":"paddingRight",_a6c);
_a4c.forEach(this.getChildren(),function(_a6d){
_a6d.set("indent",_a6b+1);
});
this._set("indent",_a6b);
},markProcessing:function(){
this.state="LOADING";
this._setExpando(true);
},unmarkProcessing:function(){
this._setExpando(false);
},_updateItemClasses:function(item){
var tree=this.tree,_a6e=tree.model;
if(tree._v10Compat&&item===_a6e.root){
item=null;
}
this._applyClassAndStyle(item,"icon","Icon");
this._applyClassAndStyle(item,"label","Label");
this._applyClassAndStyle(item,"row","Row");
this.tree._startPaint(true);
},_applyClassAndStyle:function(item,_a6f,_a70){
var _a71="_"+_a6f+"Class";
var _a72=_a6f+"Node";
var _a73=this[_a71];
this[_a71]=this.tree["get"+_a70+"Class"](item,this.isExpanded);
_a52.replace(this[_a72],this[_a71]||"",_a73||"");
_a54.set(this[_a72],this.tree["get"+_a70+"Style"](item,this.isExpanded)||{});
},_updateLayout:function(){
var _a74=this.getParent();
if(!_a74||!_a74.rowNode||_a74.rowNode.style.display=="none"){
_a52.add(this.domNode,"dijitTreeIsRoot");
}else{
_a52.toggle(this.domNode,"dijitTreeIsLast",!this.getNextSibling());
}
},_setExpando:function(_a75){
var _a76=["dijitTreeExpandoLoading","dijitTreeExpandoOpened","dijitTreeExpandoClosed","dijitTreeExpandoLeaf"],_a77=["*","-","+","*"],idx=_a75?0:(this.isExpandable?(this.isExpanded?1:2):3);
_a52.replace(this.expandoNode,_a76[idx],_a76);
this.expandoNodeText.innerHTML=_a77[idx];
},expand:function(){
if(this._expandDeferred){
return this._expandDeferred;
}
if(this._collapseDeferred){
this._collapseDeferred.cancel();
delete this._collapseDeferred;
}
this.isExpanded=true;
this.labelNode.setAttribute("aria-expanded","true");
if(this.tree.showRoot||this!==this.tree.rootNode){
this.containerNode.setAttribute("role","group");
}
_a52.add(this.contentNode,"dijitTreeContentExpanded");
this._setExpando();
this._updateItemClasses(this.item);
if(this==this.tree.rootNode&&this.tree.showRoot){
this.tree.domNode.setAttribute("aria-expanded","true");
}
var def,_a78=_a57.wipeIn({node:this.containerNode,duration:_a5d.defaultDuration,onEnd:function(){
def.resolve(true);
}});
def=(this._expandDeferred=new _a50(function(){
_a78.stop();
}));
_a78.play();
return def;
},collapse:function(){
if(this._collapseDeferred){
return this._collapseDeferred;
}
if(this._expandDeferred){
this._expandDeferred.cancel();
delete this._expandDeferred;
}
this.isExpanded=false;
this.labelNode.setAttribute("aria-expanded","false");
if(this==this.tree.rootNode&&this.tree.showRoot){
this.tree.domNode.setAttribute("aria-expanded","false");
}
_a52.remove(this.contentNode,"dijitTreeContentExpanded");
this._setExpando();
this._updateItemClasses(this.item);
var def,_a79=_a57.wipeOut({node:this.containerNode,duration:_a5d.defaultDuration,onEnd:function(){
def.resolve(true);
}});
def=(this._collapseDeferred=new _a50(function(){
_a79.stop();
}));
_a79.play();
return def;
},indent:0,setChildItems:function(_a7a){
var tree=this.tree,_a7b=tree.model,defs=[];
var _a7c=this.getChildren();
_a4c.forEach(_a7c,function(_a7d){
_a60.prototype.removeChild.call(this,_a7d);
},this);
this.defer(function(){
_a4c.forEach(_a7c,function(node){
if(!node._destroyed&&!node.getParent()){
tree.dndController.removeTreeNode(node);
var id=_a7b.getIdentity(node.item),ary=tree._itemNodesMap[id];
if(ary.length==1){
delete tree._itemNodesMap[id];
}else{
var _a7e=_a4c.indexOf(ary,node);
if(_a7e!=-1){
ary.splice(_a7e,1);
}
}
node.destroyRecursive();
}
});
});
this.state="LOADED";
if(_a7a&&_a7a.length>0){
this.isExpandable=true;
_a4c.forEach(_a7a,function(item){
var id=_a7b.getIdentity(item),_a7f=tree._itemNodesMap[id],node;
if(_a7f){
for(var i=0;i<_a7f.length;i++){
if(_a7f[i]&&!_a7f[i].getParent()){
node=_a7f[i];
node.set("indent",this.indent+1);
break;
}
}
}
if(!node){
node=this.tree._createTreeNode({item:item,tree:tree,isExpandable:_a7b.mayHaveChildren(item),label:tree.getLabel(item),tooltip:tree.getTooltip(item),ownerDocument:tree.ownerDocument,dir:tree.dir,lang:tree.lang,textDir:tree.textDir,indent:this.indent+1});
if(_a7f){
_a7f.push(node);
}else{
tree._itemNodesMap[id]=[node];
}
}
this.addChild(node);
if(this.tree.autoExpand||this.tree._state(node)){
defs.push(tree._expandNode(node));
}
},this);
_a4c.forEach(this.getChildren(),function(_a80){
_a80._updateLayout();
});
}else{
this.isExpandable=false;
}
if(this._setExpando){
this._setExpando(false);
}
this._updateItemClasses(this.item);
if(this==tree.rootNode){
var fc=this.tree.showRoot?this:this.getChildren()[0];
if(fc){
fc.setFocusable(true);
tree.lastFocused=fc;
}else{
tree.domNode.setAttribute("tabIndex","0");
}
}
var def=new _a51(defs);
this.tree._startPaint(def);
return def;
},getTreePath:function(){
var node=this;
var path=[];
while(node&&node!==this.tree.rootNode){
path.unshift(node.item);
node=node.getParent();
}
path.unshift(this.tree.rootNode.item);
return path;
},getIdentity:function(){
return this.tree.model.getIdentity(this.item);
},removeChild:function(node){
this.inherited(arguments);
var _a81=this.getChildren();
if(_a81.length==0){
this.isExpandable=false;
this.collapse();
}
_a4c.forEach(_a81,function(_a82){
_a82._updateLayout();
});
},makeExpandable:function(){
this.isExpandable=true;
this._setExpando(false);
},setSelected:function(_a83){
this.labelNode.setAttribute("aria-selected",_a83?"true":"false");
_a52.toggle(this.rowNode,"dijitTreeRowSelected",_a83);
},setFocusable:function(_a84){
this.labelNode.setAttribute("tabIndex",_a84?"0":"-1");
},_setTextDirAttr:function(_a85){
if(_a85&&((this.textDir!=_a85)||!this._created)){
this._set("textDir",_a85);
this.applyTextDir(this.labelNode,this.labelNode.innerText||this.labelNode.textContent||"");
_a4c.forEach(this.getChildren(),function(_a86){
_a86.set("textDir",_a85);
},this);
}
}});
var Tree=_a4f("dijit.Tree",[_a5e,_a5f],{store:null,model:null,query:null,label:"",showRoot:true,childrenAttr:["children"],paths:[],path:[],selectedItems:null,selectedItem:null,openOnClick:false,openOnDblClick:false,templateString:_a64,persist:true,autoExpand:false,dndController:_a67,dndParams:["onDndDrop","itemCreator","onDndCancel","checkAcceptance","checkItemAcceptance","dragThreshold","betweenThreshold"],onDndDrop:null,itemCreator:null,onDndCancel:null,checkAcceptance:null,checkItemAcceptance:null,dragThreshold:5,betweenThreshold:0,_nodePixelIndent:19,_publish:function(_a87,_a88){
_a59.publish(this.id,lang.mixin({tree:this,event:_a87},_a88||{}));
},postMixInProperties:function(){
this.tree=this;
if(this.autoExpand){
this.persist=false;
}
this._itemNodesMap={};
if(!this.cookieName&&this.id){
this.cookieName=this.id+"SaveStateCookie";
}
this.expandChildrenDeferred=new _a50();
this.pendingCommandsDeferred=this.expandChildrenDeferred;
this.inherited(arguments);
},postCreate:function(){
this._initState();
var self=this;
this.own(on(this.domNode,on.selector(".dijitTreeNode",_a5a.enter),function(evt){
self._onNodeMouseEnter(_a5c.byNode(this),evt);
}),on(this.domNode,on.selector(".dijitTreeNode",_a5a.leave),function(evt){
self._onNodeMouseLeave(_a5c.byNode(this),evt);
}),on(this.domNode,on.selector(".dijitTreeNode","click"),function(evt){
self._onClick(_a5c.byNode(this),evt);
}),on(this.domNode,on.selector(".dijitTreeNode","dblclick"),function(evt){
self._onDblClick(_a5c.byNode(this),evt);
}),on(this.domNode,on.selector(".dijitTreeNode","keypress"),function(evt){
self._onKeyPress(_a5c.byNode(this),evt);
}),on(this.domNode,on.selector(".dijitTreeNode","keydown"),function(evt){
self._onKeyDown(_a5c.byNode(this),evt);
}),on(this.domNode,on.selector(".dijitTreeRow","focusin"),function(evt){
self._onNodeFocus(_a5c.getEnclosingWidget(this),evt);
}));
if(!this.model){
this._store2model();
}
this.connect(this.model,"onChange","_onItemChange");
this.connect(this.model,"onChildrenChange","_onItemChildrenChange");
this.connect(this.model,"onDelete","_onItemDelete");
this.inherited(arguments);
if(this.dndController){
if(lang.isString(this.dndController)){
this.dndController=lang.getObject(this.dndController);
}
var _a89={};
for(var i=0;i<this.dndParams.length;i++){
if(this[this.dndParams[i]]){
_a89[this.dndParams[i]]=this[this.dndParams[i]];
}
}
this.dndController=new this.dndController(this,_a89);
}
this._load();
if(!this.params.path&&!this.params.paths&&this.persist){
this.set("paths",this.dndController._getSavedPaths());
}
this.onLoadDeferred=this.pendingCommandsDeferred;
this.onLoadDeferred.then(lang.hitch(this,"onLoad"));
},_store2model:function(){
this._v10Compat=true;
_a58.deprecated("Tree: from version 2.0, should specify a model object rather than a store/query");
var _a8a={id:this.id+"_ForestStoreModel",store:this.store,query:this.query,childrenAttrs:this.childrenAttr};
if(this.params.mayHaveChildren){
_a8a.mayHaveChildren=lang.hitch(this,"mayHaveChildren");
}
if(this.params.getItemChildren){
_a8a.getChildren=lang.hitch(this,function(item,_a8b,_a8c){
this.getItemChildren((this._v10Compat&&item===this.model.root)?null:item,_a8b,_a8c);
});
}
this.model=new _a66(_a8a);
this.showRoot=Boolean(this.label);
},onLoad:function(){
},_load:function(){
this.model.getRoot(lang.hitch(this,function(item){
var rn=(this.rootNode=this.tree._createTreeNode({item:item,tree:this,isExpandable:true,label:this.label||this.getLabel(item),textDir:this.textDir,indent:this.showRoot?0:-1}));
if(!this.showRoot){
rn.rowNode.style.display="none";
this.domNode.setAttribute("role","presentation");
this.domNode.removeAttribute("aria-expanded");
this.domNode.removeAttribute("aria-multiselectable");
rn.labelNode.setAttribute("role","presentation");
rn.containerNode.setAttribute("role","tree");
rn.containerNode.setAttribute("aria-expanded","true");
rn.containerNode.setAttribute("aria-multiselectable",!this.dndController.singular);
}else{
this.domNode.setAttribute("aria-multiselectable",!this.dndController.singular);
}
this.domNode.appendChild(rn.domNode);
var _a8d=this.model.getIdentity(item);
if(this._itemNodesMap[_a8d]){
this._itemNodesMap[_a8d].push(rn);
}else{
this._itemNodesMap[_a8d]=[rn];
}
rn._updateLayout();
this._expandNode(rn).then(lang.hitch(this,function(){
this.expandChildrenDeferred.resolve(true);
}));
}),lang.hitch(this,function(err){
console.error(this,": error loading root: ",err);
}));
},getNodesByItem:function(item){
if(!item){
return [];
}
var _a8e=lang.isString(item)?item:this.model.getIdentity(item);
return [].concat(this._itemNodesMap[_a8e]);
},_setSelectedItemAttr:function(item){
this.set("selectedItems",[item]);
},_setSelectedItemsAttr:function(_a8f){
var tree=this;
return this.pendingCommandsDeferred=this.pendingCommandsDeferred.then(lang.hitch(this,function(){
var _a90=_a4c.map(_a8f,function(item){
return (!item||lang.isString(item))?item:tree.model.getIdentity(item);
});
var _a91=[];
_a4c.forEach(_a90,function(id){
_a91=_a91.concat(tree._itemNodesMap[id]||[]);
});
this.set("selectedNodes",_a91);
}));
},_setPathAttr:function(path){
if(path.length){
return this.set("paths",[path]);
}else{
return this.set("paths",[]);
}
},_setPathsAttr:function(_a92){
var tree=this;
return this.pendingCommandsDeferred=this.pendingCommandsDeferred.then(function(){
return new _a51(_a4c.map(_a92,function(path){
var d=new _a50();
path=_a4c.map(path,function(item){
return lang.isString(item)?item:tree.model.getIdentity(item);
});
if(path.length){
_a93(path,[tree.rootNode],d);
}else{
d.reject(new Tree.PathError("Empty path"));
}
return d;
}));
}).then(_a94);
function _a93(path,_a95,def){
var _a96=path.shift();
var _a97=_a4c.filter(_a95,function(node){
return node.getIdentity()==_a96;
})[0];
if(!!_a97){
if(path.length){
tree._expandNode(_a97).then(function(){
_a93(path,_a97.getChildren(),def);
});
}else{
def.resolve(_a97);
}
}else{
def.reject(new Tree.PathError("Could not expand path at "+_a96));
}
};
function _a94(_a98){
tree.set("selectedNodes",_a4c.map(_a4c.filter(_a98,function(x){
return x[0];
}),function(x){
return x[1];
}));
};
},_setSelectedNodeAttr:function(node){
this.set("selectedNodes",[node]);
},_setSelectedNodesAttr:function(_a99){
this.dndController.setSelection(_a99);
},expandAll:function(){
var _a9a=this;
function _a9b(node){
var def=new dojo.Deferred();
_a9a._expandNode(node).then(function(){
var _a9c=_a4c.filter(node.getChildren()||[],function(node){
return node.isExpandable;
}),defs=_a4c.map(_a9c,_a9b);
new dojo.DeferredList(defs).then(function(){
def.resolve(true);
});
});
return def;
};
return _a9b(this.rootNode);
},collapseAll:function(){
var _a9d=this;
function _a9e(node){
var def=new dojo.Deferred();
def.label="collapseAllDeferred";
var _a9f=_a4c.filter(node.getChildren()||[],function(node){
return node.isExpandable;
}),defs=_a4c.map(_a9f,_a9e);
new dojo.DeferredList(defs).then(function(){
if(!node.isExpanded||(node==_a9d.rootNode&&!_a9d.showRoot)){
def.resolve(true);
}else{
_a9d._collapseNode(node).then(function(){
def.resolve(true);
});
}
});
return def;
};
return _a9e(this.rootNode);
},mayHaveChildren:function(){
},getItemChildren:function(){
},getLabel:function(item){
return this.model.getLabel(item);
},getIconClass:function(item,_aa0){
return (!item||this.model.mayHaveChildren(item))?(_aa0?"dijitFolderOpened":"dijitFolderClosed"):"dijitLeaf";
},getLabelClass:function(){
},getRowClass:function(){
},getIconStyle:function(){
},getLabelStyle:function(){
},getRowStyle:function(){
},getTooltip:function(){
return "";
},_onKeyPress:function(_aa1,e){
if(e.charCode<=32){
return;
}
if(!e.altKey&&!e.ctrlKey&&!e.shiftKey&&!e.metaKey){
var c=String.fromCharCode(e.charCode);
this._onLetterKeyNav({node:_aa1,key:c.toLowerCase()});
_a55.stop(e);
}
},_onKeyDown:function(_aa2,e){
var key=e.keyCode;
var map=this._keyHandlerMap;
if(!map){
map={};
map[keys.ENTER]=map[keys.SPACE]=map[" "]="_onEnterKey";
map[this.isLeftToRight()?keys.LEFT_ARROW:keys.RIGHT_ARROW]="_onLeftArrow";
map[this.isLeftToRight()?keys.RIGHT_ARROW:keys.LEFT_ARROW]="_onRightArrow";
map[keys.UP_ARROW]="_onUpArrow";
map[keys.DOWN_ARROW]="_onDownArrow";
map[keys.HOME]="_onHomeKey";
map[keys.END]="_onEndKey";
this._keyHandlerMap=map;
}
if(this._keyHandlerMap[key]){
if(this._curSearch){
this._curSearch.timer.remove();
delete this._curSearch;
}
this[this._keyHandlerMap[key]]({node:_aa2,item:_aa2.item,evt:e});
_a55.stop(e);
}
},_onEnterKey:function(_aa3){
this._publish("execute",{item:_aa3.item,node:_aa3.node});
this.dndController.userSelect(_aa3.node,_a4d.isCopyKey(_aa3.evt),_aa3.evt.shiftKey);
this.onClick(_aa3.item,_aa3.node,_aa3.evt);
},_onDownArrow:function(_aa4){
var node=this._getNextNode(_aa4.node);
if(node&&node.isTreeNode){
this.focusNode(node);
}
},_onUpArrow:function(_aa5){
var node=_aa5.node;
var _aa6=node.getPreviousSibling();
if(_aa6){
node=_aa6;
while(node.isExpandable&&node.isExpanded&&node.hasChildren()){
var _aa7=node.getChildren();
node=_aa7[_aa7.length-1];
}
}else{
var _aa8=node.getParent();
if(!(!this.showRoot&&_aa8===this.rootNode)){
node=_aa8;
}
}
if(node&&node.isTreeNode){
this.focusNode(node);
}
},_onRightArrow:function(_aa9){
var node=_aa9.node;
if(node.isExpandable&&!node.isExpanded){
this._expandNode(node);
}else{
if(node.hasChildren()){
node=node.getChildren()[0];
if(node&&node.isTreeNode){
this.focusNode(node);
}
}
}
},_onLeftArrow:function(_aaa){
var node=_aaa.node;
if(node.isExpandable&&node.isExpanded){
this._collapseNode(node);
}else{
var _aab=node.getParent();
if(_aab&&_aab.isTreeNode&&!(!this.showRoot&&_aab===this.rootNode)){
this.focusNode(_aab);
}
}
},_onHomeKey:function(){
var node=this._getRootOrFirstNode();
if(node){
this.focusNode(node);
}
},_onEndKey:function(){
var node=this.rootNode;
while(node.isExpanded){
var c=node.getChildren();
node=c[c.length-1];
}
if(node&&node.isTreeNode){
this.focusNode(node);
}
},multiCharSearchDuration:250,_onLetterKeyNav:function(_aac){
var cs=this._curSearch;
if(cs){
cs.pattern=cs.pattern+_aac.key;
cs.timer.remove();
}else{
cs=this._curSearch={pattern:_aac.key,startNode:_aac.node};
}
cs.timer=this.defer(function(){
delete this._curSearch;
},this.multiCharSearchDuration);
var node=cs.startNode;
do{
node=this._getNextNode(node);
if(!node){
node=this._getRootOrFirstNode();
}
}while(node!==cs.startNode&&(node.label.toLowerCase().substr(0,cs.pattern.length)!=cs.pattern));
if(node&&node.isTreeNode){
if(node!==cs.startNode){
this.focusNode(node);
}
}
},isExpandoNode:function(node,_aad){
return dom.isDescendant(node,_aad.expandoNode)||dom.isDescendant(node,_aad.expandoNodeText);
},_onClick:function(_aae,e){
var _aaf=e.target,_ab0=this.isExpandoNode(_aaf,_aae);
if((this.openOnClick&&_aae.isExpandable)||_ab0){
if(_aae.isExpandable){
this._onExpandoClick({node:_aae});
}
}else{
this._publish("execute",{item:_aae.item,node:_aae,evt:e});
this.onClick(_aae.item,_aae,e);
this.focusNode(_aae);
}
_a55.stop(e);
},_onDblClick:function(_ab1,e){
var _ab2=e.target,_ab3=(_ab2==_ab1.expandoNode||_ab2==_ab1.expandoNodeText);
if((this.openOnDblClick&&_ab1.isExpandable)||_ab3){
if(_ab1.isExpandable){
this._onExpandoClick({node:_ab1});
}
}else{
this._publish("execute",{item:_ab1.item,node:_ab1,evt:e});
this.onDblClick(_ab1.item,_ab1,e);
this.focusNode(_ab1);
}
_a55.stop(e);
},_onExpandoClick:function(_ab4){
var node=_ab4.node;
this.focusNode(node);
if(node.isExpanded){
this._collapseNode(node);
}else{
this._expandNode(node);
}
},onClick:function(){
},onDblClick:function(){
},onOpen:function(){
},onClose:function(){
},_getNextNode:function(node){
if(node.isExpandable&&node.isExpanded&&node.hasChildren()){
return node.getChildren()[0];
}else{
while(node&&node.isTreeNode){
var _ab5=node.getNextSibling();
if(_ab5){
return _ab5;
}
node=node.getParent();
}
return null;
}
},_getRootOrFirstNode:function(){
return this.showRoot?this.rootNode:this.rootNode.getChildren()[0];
},_collapseNode:function(node){
if(node._expandNodeDeferred){
delete node._expandNodeDeferred;
}
if(node.state=="LOADING"){
return;
}
if(node.isExpanded){
var ret=node.collapse();
this.onClose(node.item,node);
this._state(node,false);
this._startPaint(ret);
return ret;
}
},_expandNode:function(node){
var def=new _a50();
if(node._expandNodeDeferred){
return node._expandNodeDeferred;
}
var _ab6=this.model,item=node.item,_ab7=this;
if(!node._loadDeferred){
node.markProcessing();
node._loadDeferred=new _a50();
_ab6.getChildren(item,function(_ab8){
node.unmarkProcessing();
node.setChildItems(_ab8).then(function(){
node._loadDeferred.resolve(_ab8);
});
},function(err){
console.error(_ab7,": error loading "+node.label+" children: ",err);
node._loadDeferred.reject(err);
});
}
node._loadDeferred.then(lang.hitch(this,function(){
node.expand().then(function(){
def.resolve(true);
});
this.onOpen(node.item,node);
this._state(node,true);
}));
this._startPaint(def);
return def;
},focusNode:function(node){
_a5b.focus(node.labelNode);
},_onNodeFocus:function(node){
if(node&&node!=this.lastFocused){
if(this.lastFocused&&!this.lastFocused._destroyed){
this.lastFocused.setFocusable(false);
}
node.setFocusable(true);
this.lastFocused=node;
}
},_onNodeMouseEnter:function(){
},_onNodeMouseLeave:function(){
},_onItemChange:function(item){
var _ab9=this.model,_aba=_ab9.getIdentity(item),_abb=this._itemNodesMap[_aba];
if(_abb){
var _abc=this.getLabel(item),_abd=this.getTooltip(item);
_a4c.forEach(_abb,function(node){
node.set({item:item,label:_abc,tooltip:_abd});
node._updateItemClasses(item);
});
}
},_onItemChildrenChange:function(_abe,_abf){
var _ac0=this.model,_ac1=_ac0.getIdentity(_abe),_ac2=this._itemNodesMap[_ac1];
if(_ac2){
_a4c.forEach(_ac2,function(_ac3){
_ac3.setChildItems(_abf);
});
}
},_onItemDelete:function(item){
var _ac4=this.model,_ac5=_ac4.getIdentity(item),_ac6=this._itemNodesMap[_ac5];
if(_ac6){
_a4c.forEach(_ac6,function(node){
this.dndController.removeTreeNode(node);
var _ac7=node.getParent();
if(_ac7){
_ac7.removeChild(node);
}
node.destroyRecursive();
},this);
delete this._itemNodesMap[_ac5];
}
},_initState:function(){
this._openedNodes={};
if(this.persist&&this.cookieName){
var oreo=_a4e(this.cookieName);
if(oreo){
_a4c.forEach(oreo.split(","),function(item){
this._openedNodes[item]=true;
},this);
}
}
},_state:function(node,_ac8){
if(!this.persist){
return false;
}
var path=_a4c.map(node.getTreePath(),function(item){
return this.model.getIdentity(item);
},this).join("/");
if(arguments.length===1){
return this._openedNodes[path];
}else{
if(_ac8){
this._openedNodes[path]=true;
}else{
delete this._openedNodes[path];
}
if(this.persist&&this.cookieName){
var ary=[];
for(var id in this._openedNodes){
ary.push(id);
}
_a4e(this.cookieName,ary.join(","),{expires:365});
}
}
},destroy:function(){
if(this._curSearch){
this._curSearch.timer.remove();
delete this._curSearch;
}
if(this.rootNode){
this.rootNode.destroyRecursive();
}
if(this.dndController&&!lang.isString(this.dndController)){
this.dndController.destroy();
}
this.rootNode=null;
this.inherited(arguments);
},destroyRecursive:function(){
this.destroy();
},resize:function(_ac9){
if(_ac9){
_a53.setMarginBox(this.domNode,_ac9);
}
this._nodePixelIndent=_a53.position(this.tree.indentDetector).w||this._nodePixelIndent;
this.expandChildrenDeferred.then(lang.hitch(this,function(){
this.rootNode.set("indent",this.showRoot?0:-1);
this._adjustWidths();
}));
},_outstandingPaintOperations:0,_startPaint:function(p){
this._outstandingPaintOperations++;
if(this._adjustWidthsTimer){
this._adjustWidthsTimer.remove();
delete this._adjustWidthsTimer;
}
var oc=lang.hitch(this,function(){
this._outstandingPaintOperations--;
if(this._outstandingPaintOperations<=0&&!this._adjustWidthsTimer&&this._started){
this._adjustWidthsTimer=this.defer("_adjustWidths");
}
});
when(p,oc,oc);
},_adjustWidths:function(){
if(this._adjustWidthsTimer){
this._adjustWidthsTimer.remove();
delete this._adjustWidthsTimer;
}
var _aca=0,_acb=[];
function _acc(_acd){
var node=_acd.rowNode;
node.style.width="auto";
_aca=Math.max(_aca,node.clientWidth);
_acb.push(node);
if(_acd.isExpanded){
_a4c.forEach(_acd.getChildren(),_acc);
}
};
_acc(this.rootNode);
_aca=Math.max(_aca,_a53.getContentBox(this.domNode).w);
_a4c.forEach(_acb,function(node){
node.style.width=_aca+"px";
});
},_createTreeNode:function(args){
return new _a6a(args);
},_setTextDirAttr:function(_ace){
if(_ace&&this.textDir!=_ace){
this._set("textDir",_ace);
this.rootNode.set("textDir",_ace);
}
}});
Tree.PathError=_a56("TreePathError");
Tree._TreeNode=_a6a;
return Tree;
});
},"dijit/form/HorizontalSlider":function(){
define(["dojo/_base/array","dojo/_base/declare","dojo/dnd/move","dojo/_base/event","dojo/_base/fx","dojo/dom-geometry","dojo/dom-style","dojo/keys","dojo/_base/lang","dojo/sniff","dojo/dnd/Moveable","dojo/dnd/Mover","dojo/query","dojo/mouse","../registry","../focus","../typematic","./Button","./_FormValueWidget","../_Container","dojo/text!./templates/HorizontalSlider.html"],function(_acf,_ad0,move,_ad1,fx,_ad2,_ad3,keys,lang,has,_ad4,_ad5,_ad6,_ad7,_ad8,_ad9,_ada,_adb,_adc,_add,_ade){
var _adf=_ad0("dijit.form._SliderMover",_ad5,{onMouseMove:function(e){
var _ae0=this.widget;
var _ae1=_ae0._abspos;
if(!_ae1){
_ae1=_ae0._abspos=_ad2.position(_ae0.sliderBarContainer,true);
_ae0._setPixelValue_=lang.hitch(_ae0,"_setPixelValue");
_ae0._isReversed_=_ae0._isReversed();
}
var _ae2=e[_ae0._mousePixelCoord]-_ae1[_ae0._startingPixelCoord];
_ae0._setPixelValue_(_ae0._isReversed_?(_ae1[_ae0._pixelCount]-_ae2):_ae2,_ae1[_ae0._pixelCount],false);
},destroy:function(e){
_ad5.prototype.destroy.apply(this,arguments);
var _ae3=this.widget;
_ae3._abspos=null;
_ae3._setValueAttr(_ae3.value,true);
}});
var _ae4=_ad0("dijit.form.HorizontalSlider",[_adc,_add],{templateString:_ade,value:0,showButtons:true,minimum:0,maximum:100,discreteValues:Infinity,pageIncrement:2,clickSelect:true,slideDuration:_ad8.defaultDuration,_setIdAttr:"",baseClass:"dijitSlider",cssStateNodes:{incrementButton:"dijitSliderIncrementButton",decrementButton:"dijitSliderDecrementButton",focusNode:"dijitSliderThumb"},_mousePixelCoord:"pageX",_pixelCount:"w",_startingPixelCoord:"x",_handleOffsetCoord:"left",_progressPixelSize:"width",_onKeyUp:function(e){
if(this.disabled||this.readOnly||e.altKey||e.ctrlKey||e.metaKey){
return;
}
this._setValueAttr(this.value,true);
},_onKeyPress:function(e){
if(this.disabled||this.readOnly||e.altKey||e.ctrlKey||e.metaKey){
return;
}
switch(e.charOrCode){
case keys.HOME:
this._setValueAttr(this.minimum,false);
break;
case keys.END:
this._setValueAttr(this.maximum,false);
break;
case ((this._descending||this.isLeftToRight())?keys.RIGHT_ARROW:keys.LEFT_ARROW):
case (this._descending===false?keys.DOWN_ARROW:keys.UP_ARROW):
case (this._descending===false?keys.PAGE_DOWN:keys.PAGE_UP):
this.increment(e);
break;
case ((this._descending||this.isLeftToRight())?keys.LEFT_ARROW:keys.RIGHT_ARROW):
case (this._descending===false?keys.UP_ARROW:keys.DOWN_ARROW):
case (this._descending===false?keys.PAGE_UP:keys.PAGE_DOWN):
this.decrement(e);
break;
default:
return;
}
_ad1.stop(e);
},_onHandleClick:function(e){
if(this.disabled||this.readOnly){
return;
}
if(!has("ie")){
_ad9.focus(this.sliderHandle);
}
_ad1.stop(e);
},_isReversed:function(){
return !this.isLeftToRight();
},_onBarClick:function(e){
if(this.disabled||this.readOnly||!this.clickSelect){
return;
}
_ad9.focus(this.sliderHandle);
_ad1.stop(e);
var _ae5=_ad2.position(this.sliderBarContainer,true);
var _ae6=e[this._mousePixelCoord]-_ae5[this._startingPixelCoord];
this._setPixelValue(this._isReversed()?(_ae5[this._pixelCount]-_ae6):_ae6,_ae5[this._pixelCount],true);
this._movable.onMouseDown(e);
},_setPixelValue:function(_ae7,_ae8,_ae9){
if(this.disabled||this.readOnly){
return;
}
var _aea=this.discreteValues;
if(_aea<=1||_aea==Infinity){
_aea=_ae8;
}
_aea--;
var _aeb=_ae8/_aea;
var _aec=Math.round(_ae7/_aeb);
this._setValueAttr(Math.max(Math.min((this.maximum-this.minimum)*_aec/_aea+this.minimum,this.maximum),this.minimum),_ae9);
},_setValueAttr:function(_aed,_aee){
this._set("value",_aed);
this.valueNode.value=_aed;
this.focusNode.setAttribute("aria-valuenow",_aed);
this.inherited(arguments);
var _aef=(_aed-this.minimum)/(this.maximum-this.minimum);
var _af0=(this._descending===false)?this.remainingBar:this.progressBar;
var _af1=(this._descending===false)?this.progressBar:this.remainingBar;
if(this._inProgressAnim&&this._inProgressAnim.status!="stopped"){
this._inProgressAnim.stop(true);
}
if(_aee&&this.slideDuration>0&&_af0.style[this._progressPixelSize]){
var _af2=this;
var _af3={};
var _af4=parseFloat(_af0.style[this._progressPixelSize]);
var _af5=this.slideDuration*(_aef-_af4/100);
if(_af5==0){
return;
}
if(_af5<0){
_af5=0-_af5;
}
_af3[this._progressPixelSize]={start:_af4,end:_aef*100,units:"%"};
this._inProgressAnim=fx.animateProperty({node:_af0,duration:_af5,onAnimate:function(v){
_af1.style[_af2._progressPixelSize]=(100-parseFloat(v[_af2._progressPixelSize]))+"%";
},onEnd:function(){
delete _af2._inProgressAnim;
},properties:_af3});
this._inProgressAnim.play();
}else{
_af0.style[this._progressPixelSize]=(_aef*100)+"%";
_af1.style[this._progressPixelSize]=((1-_aef)*100)+"%";
}
},_bumpValue:function(_af6,_af7){
if(this.disabled||this.readOnly){
return;
}
var s=_ad3.getComputedStyle(this.sliderBarContainer);
var c=_ad2.getContentBox(this.sliderBarContainer,s);
var _af8=this.discreteValues;
if(_af8<=1||_af8==Infinity){
_af8=c[this._pixelCount];
}
_af8--;
var _af9=(this.value-this.minimum)*_af8/(this.maximum-this.minimum)+_af6;
if(_af9<0){
_af9=0;
}
if(_af9>_af8){
_af9=_af8;
}
_af9=_af9*(this.maximum-this.minimum)/_af8+this.minimum;
this._setValueAttr(_af9,_af7);
},_onClkBumper:function(val){
if(this.disabled||this.readOnly||!this.clickSelect){
return;
}
this._setValueAttr(val,true);
},_onClkIncBumper:function(){
this._onClkBumper(this._descending===false?this.minimum:this.maximum);
},_onClkDecBumper:function(){
this._onClkBumper(this._descending===false?this.maximum:this.minimum);
},decrement:function(e){
this._bumpValue(e.charOrCode==keys.PAGE_DOWN?-this.pageIncrement:-1);
},increment:function(e){
this._bumpValue(e.charOrCode==keys.PAGE_UP?this.pageIncrement:1);
},_mouseWheeled:function(evt){
_ad1.stop(evt);
this._bumpValue(evt.wheelDelta<0?-1:1,true);
},startup:function(){
if(this._started){
return;
}
_acf.forEach(this.getChildren(),function(_afa){
if(this[_afa.container]!=this.containerNode){
this[_afa.container].appendChild(_afa.domNode);
}
},this);
this.inherited(arguments);
},_typematicCallback:function(_afb,_afc,e){
if(_afb==-1){
this._setValueAttr(this.value,true);
}else{
this[(_afc==(this._descending?this.incrementButton:this.decrementButton))?"decrement":"increment"](e);
}
},buildRendering:function(){
this.inherited(arguments);
if(this.showButtons){
this.incrementButton.style.display="";
this.decrementButton.style.display="";
}
var _afd=_ad6("label[for=\""+this.id+"\"]");
if(_afd.length){
if(!_afd[0].id){
_afd[0].id=this.id+"_label";
}
this.focusNode.setAttribute("aria-labelledby",_afd[0].id);
}
this.focusNode.setAttribute("aria-valuemin",this.minimum);
this.focusNode.setAttribute("aria-valuemax",this.maximum);
},postCreate:function(){
this.inherited(arguments);
if(this.showButtons){
this.own(_ada.addMouseListener(this.decrementButton,this,"_typematicCallback",25,500),_ada.addMouseListener(this.incrementButton,this,"_typematicCallback",25,500));
}
this.connect(this.domNode,_ad7.wheel,"_mouseWheeled");
var _afe=_ad0(_adf,{widget:this});
this._movable=new _ad4(this.sliderHandle,{mover:_afe});
this._layoutHackIE7();
},destroy:function(){
this._movable.destroy();
if(this._inProgressAnim&&this._inProgressAnim.status!="stopped"){
this._inProgressAnim.stop(true);
}
this.inherited(arguments);
}});
_ae4._Mover=_adf;
return _ae4;
});
},"*now":function(r){
r(["dojo/i18n!*preload*dijit/nls/dijit-all*[\"ar\",\"ca\",\"cs\",\"da\",\"de\",\"el\",\"en-gb\",\"en-us\",\"es-es\",\"fi-fi\",\"fr-fr\",\"he-il\",\"hu\",\"it-it\",\"ja-jp\",\"ko-kr\",\"nl-nl\",\"nb\",\"pl\",\"pt-br\",\"pt-pt\",\"ru\",\"sk\",\"sl\",\"sv\",\"th\",\"tr\",\"zh-tw\",\"zh-cn\",\"ROOT\"]"]);
}}});
define("dijit/dijit-all",["./main","./dijit","./ColorPalette","./Declaration","./Dialog","./DialogUnderlay","./TooltipDialog","./Editor","./_editor/plugins/FontChoice","./_editor/plugins/LinkDialog","./Menu","./MenuItem","./PopupMenuItem","./CheckedMenuItem","./MenuBar","./MenuBarItem","./PopupMenuBarItem","./MenuSeparator","./ProgressBar","./TitlePane","./Toolbar","./Tooltip","./Tree","./InlineEditBox","./form/Form","./form/Button","./form/DropDownButton","./form/ComboButton","./form/ToggleButton","./form/CheckBox","./form/RadioButton","./form/TextBox","./form/ValidationTextBox","./form/CurrencyTextBox","./form/DateTextBox","./form/TimeTextBox","./form/NumberSpinner","./form/NumberTextBox","./form/ComboBox","./form/FilteringSelect","./form/MultiSelect","./form/Select","./form/HorizontalSlider","./form/VerticalSlider","./form/HorizontalRule","./form/VerticalRule","./form/HorizontalRuleLabels","./form/VerticalRuleLabels","./form/SimpleTextarea","./form/Textarea","./layout/AccordionContainer","./layout/ContentPane","./layout/BorderContainer","./layout/LayoutContainer","./layout/LinkPane","./layout/SplitContainer","./layout/StackContainer","./layout/TabContainer"],function(_aff){
console.warn("dijit-all may include much more code than your application actually requires. We strongly recommend that you investigate a custom build or the web build tool");
return _aff;
});
