/*
	Copyright (c) 2004-2012, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is an optimized version of Dojo, built for deployment and not for
	development. To get sources and documentation, please visit:

		http://dojotoolkit.org
*/

//>>built
require({cache:{"dojox/mobile/EdgeToEdgeList":function(){
define(["dojo/_base/declare","./RoundRectList"],function(_1,_2){
return _1("dojox.mobile.EdgeToEdgeList",_2,{buildRendering:function(){
this.inherited(arguments);
this.domNode.className="mblEdgeToEdgeList";
}});
});
},"dojo/touch":function(){
define(["./_base/kernel","./aspect","./dom","./on","./has","./mouse","./ready","./_base/window"],function(_3,_4,_5,on,_6,_7,_8,_9){
var _a=_6("touch");
var _b=false;
if(_6("ios")){
var ua=navigator.userAgent;
var v=ua.match(/OS ([\d_]+)/)?RegExp.$1:"1";
var os=parseFloat(v.replace(/_/,".").replace(/_/g,""));
_b=os<5;
}
var _c,_d;
if(_a){
_8(function(){
_d=_9.body();
_9.doc.addEventListener("touchstart",function(_e){
var _f=_d;
_d=_e.target;
on.emit(_f,"dojotouchout",{target:_f,relatedTarget:_d,bubbles:true});
on.emit(_d,"dojotouchover",{target:_d,relatedTarget:_f,bubbles:true});
},true);
on(_9.doc,"touchmove",function(evt){
var _10=_9.doc.elementFromPoint(evt.pageX-(_b?0:_9.global.pageXOffset),evt.pageY-(_b?0:_9.global.pageYOffset));
if(_10&&_d!==_10){
on.emit(_d,"dojotouchout",{target:_d,relatedTarget:_10,bubbles:true});
on.emit(_10,"dojotouchover",{target:_10,relatedTarget:_d,bubbles:true});
_d=_10;
}
});
});
_c=function(_11,_12){
return on(_9.doc,"touchmove",function(evt){
if(_11===_9.doc||_5.isDescendant(_d,_11)){
evt.target=_d;
_12.call(this,evt);
}
});
};
}
function _13(_14){
return function(_15,_16){
return on(_15,_14,_16);
};
};
var _17={press:_13(_a?"touchstart":"mousedown"),move:_a?_c:_13("mousemove"),release:_13(_a?"touchend":"mouseup"),cancel:_a?_13("touchcancel"):_7.leave,over:_13(_a?"dojotouchover":"mouseover"),out:_13(_a?"dojotouchout":"mouseout"),enter:_7._eventHandler(_a?"dojotouchover":"mouseover"),leave:_7._eventHandler(_a?"dojotouchout":"mouseout")};
1&&(_3.touch=_17);
return _17;
});
},"dojox/mobile/iconUtils":function(){
define(["dojo/_base/array","dojo/_base/config","dojo/_base/connect","dojo/_base/event","dojo/_base/lang","dojo/_base/window","dojo/dom-class","dojo/dom-construct","dojo/dom-style","./sniff"],function(_18,_19,_1a,_1b,_1c,win,_1d,_1e,_1f,has){
var dm=_1c.getObject("dojox.mobile",true);
var _20=function(){
this.setupSpriteIcon=function(_21,_22){
if(_21&&_22){
var arr=_18.map(_22.split(/[ ,]/),function(_23){
return _23-0;
});
var t=arr[0];
var r=arr[1]+arr[2];
var b=arr[0]+arr[3];
var l=arr[1];
_1f.set(_21,{clip:"rect("+t+"px "+r+"px "+b+"px "+l+"px)",top:(_21.parentNode?_1f.get(_21,"top"):0)-t+"px",left:-l+"px"});
_1d.add(_21,"mblSpriteIcon");
}
};
this.createDomButton=function(_24,_25,_26){
if(!this._domButtons){
if(has("webkit")){
var _27=function(_28,dic){
var i,j;
if(!_28){
var _29={};
var ss=win.doc.styleSheets;
for(i=0;i<ss.length;i++){
ss[i]&&_27(ss[i],_29);
}
return _29;
}
var _2a=_28.cssRules||[];
for(i=0;i<_2a.length;i++){
var _2b=_2a[i];
if(_2b.href&&_2b.styleSheet){
_27(_2b.styleSheet,dic);
}else{
if(_2b.selectorText){
var _2c=_2b.selectorText.split(/,/);
for(j=0;j<_2c.length;j++){
var sel=_2c[j];
var n=sel.split(/>/).length-1;
if(sel.match(/(mblDomButton\w+)/)){
var cls=RegExp.$1;
if(!dic[cls]||n>dic[cls]){
dic[cls]=n;
}
}
}
}
}
}
return dic;
};
this._domButtons=_27();
}else{
this._domButtons={};
}
}
var s=_24.className;
var _2d=_26||_24;
if(s.match(/(mblDomButton\w+)/)&&s.indexOf("/")===-1){
var _2e=RegExp.$1;
var _2f=4;
if(s.match(/(mblDomButton\w+_(\d+))/)){
_2f=RegExp.$2-0;
}else{
if(this._domButtons[_2e]!==undefined){
_2f=this._domButtons[_2e];
}
}
var _30=null;
if(has("bb")&&_19["mblBBBoxShadowWorkaround"]!==false){
_30={style:"-webkit-box-shadow:none"};
}
for(var i=0,p=_2d;i<_2f;i++){
p=p.firstChild||_1e.create("div",_30,p);
}
if(_26){
setTimeout(function(){
_1d.remove(_24,_2e);
},0);
_1d.add(_26,_2e);
}
}else{
if(s.indexOf(".")!==-1){
_1e.create("img",{src:s},_2d);
}else{
return null;
}
}
_1d.add(_2d,"mblDomButton");
!!_25&&_1f.set(_2d,_25);
return _2d;
};
this.createIcon=function(_31,_32,_33,_34,_35,_36,pos){
_34=_34||"";
if(_31&&_31.indexOf("mblDomButton")===0){
if(!_33){
_33=_1e.create("div",null,_36||_35,pos);
}else{
if(_33.className.match(/(mblDomButton\w+)/)){
_1d.remove(_33,RegExp.$1);
}
}
_33.title=_34;
_1d.add(_33,_31);
this.createDomButton(_33);
}else{
if(_31&&_31!=="none"){
if(!_33||_33.nodeName!=="IMG"){
_33=_1e.create("img",{alt:_34},_36||_35,pos);
}
_33.src=(_31||"").replace("${theme}",dm.currentTheme);
this.setupSpriteIcon(_33,_32);
if(_32&&_35){
var arr=_32.split(/[ ,]/);
_1f.set(_35,{width:arr[2]+"px",height:arr[3]+"px"});
_1d.add(_35,"mblSpriteIconParent");
}
_1a.connect(_33,"ondragstart",_1b,"stop");
}
}
return _33;
};
this.iconWrapper=false;
this.setIcon=function(_37,_38,_39,alt,_3a,_3b,pos){
if(!_3a||!_37&&!_39){
return null;
}
if(_37&&_37!=="none"){
if(!this.iconWrapper&&_37.indexOf("mblDomButton")!==0&&!_38){
if(_39&&_39.tagName==="DIV"){
_1e.destroy(_39);
_39=null;
}
_39=this.createIcon(_37,null,_39,alt,_3a,_3b,pos);
_1d.add(_39,"mblImageIcon");
}else{
if(_39&&_39.tagName==="IMG"){
_1e.destroy(_39);
_39=null;
}
_39&&_1e.empty(_39);
if(!_39){
_39=_1e.create("div",null,_3b||_3a,pos);
}
this.createIcon(_37,_38,null,null,_39);
if(alt){
_39.title=alt;
}
}
_1d.remove(_3a,"mblNoIcon");
return _39;
}else{
_1e.destroy(_39);
_1d.add(_3a,"mblNoIcon");
return null;
}
};
};
return new _20();
});
},"dojox/mobile/uacss":function(){
define("dojox/mobile/uacss",["dojo/_base/kernel","dojo/_base/lang","dojo/_base/window","./sniff"],function(_3c,_3d,win,has){
var _3e=win.doc.documentElement;
_3e.className=_3d.trim(_3e.className+" "+[has("bb")?"dj_bb":"",has("android")?"dj_android":"",has("iphone")?"dj_iphone":"",has("ipod")?"dj_ipod":"",has("ipad")?"dj_ipad":""].join(" ").replace(/ +/g," "));
return _3c;
});
},"dojox/mobile/Pane":function(){
define(["dojo/_base/array","dojo/_base/declare","dijit/_Contained","dijit/_WidgetBase"],function(_3f,_40,_41,_42){
return _40("dojox.mobile.Pane",[_42,_41],{baseClass:"mblPane",buildRendering:function(){
this.inherited(arguments);
if(!this.containerNode){
this.containerNode=this.domNode;
}
},resize:function(){
_3f.forEach(this.getChildren(),function(_43){
if(_43.resize){
_43.resize();
}
});
}});
});
},"dojox/mobile/RoundRect":function(){
define(["dojo/_base/declare","dojo/dom-class","./Container"],function(_44,_45,_46){
return _44("dojox.mobile.RoundRect",_46,{shadow:false,baseClass:"mblRoundRect",buildRendering:function(){
this.inherited(arguments);
if(this.shadow){
_45.add(this.domNode,"mblShadow");
}
}});
});
},"dojox/mobile/ListItem":function(){
define("dojox/mobile/ListItem",["dojo/_base/array","dojo/_base/declare","dojo/_base/lang","dojo/dom-class","dojo/dom-construct","dojo/dom-style","dijit/registry","dijit/_WidgetBase","./iconUtils","./_ItemBase","./ProgressIndicator"],function(_47,_48,_49,_4a,_4b,_4c,_4d,_4e,_4f,_50,_51){
var _52=_48("dojox.mobile.ListItem",_50,{rightText:"",rightIcon:"",rightIcon2:"",deleteIcon:"",anchorLabel:false,noArrow:false,checked:false,arrowClass:"",checkClass:"",uncheckClass:"",variableHeight:false,rightIconTitle:"",rightIcon2Title:"",header:false,tag:"li",busy:false,progStyle:"",paramsToInherit:"variableHeight,transition,deleteIcon,icon,rightIcon,rightIcon2,uncheckIcon,arrowClass,checkClass,uncheckClass,deleteIconTitle,deleteIconRole",baseClass:"mblListItem",_selStartMethod:"touch",_selEndMethod:"timer",_delayedSelection:true,_selClass:"mblListItemSelected",buildRendering:function(){
this.domNode=this.containerNode=this.srcNodeRef||_4b.create(this.tag);
this.inherited(arguments);
if(this.selected){
_4a.add(this.domNode,this._selClass);
}
if(this.header){
_4a.replace(this.domNode,"mblEdgeToEdgeCategory",this.baseClass);
}
this.labelNode=_4b.create("div",{className:"mblListItemLabel"});
var ref=this.srcNodeRef;
if(ref&&ref.childNodes.length===1&&ref.firstChild.nodeType===3){
this.labelNode.appendChild(ref.firstChild);
}
this.domNode.appendChild(this.labelNode);
if(this.anchorLabel){
this.labelNode.style.display="inline";
this.labelNode.style.cursor="pointer";
this._anchorClickHandle=this.connect(this.labelNode,"onclick","_onClick");
this.onTouchStart=function(e){
return (e.target!==this.labelNode);
};
}
this._layoutChildren=[];
},startup:function(){
if(this._started){
return;
}
var _53=this.getParent();
var _54=this.getTransOpts();
if(_54.moveTo||_54.href||_54.url||this.clickable||(_53&&_53.select)){
this._keydownHandle=this.connect(this.domNode,"onkeydown","_onClick");
}else{
this._handleClick=false;
}
this.inherited(arguments);
if(_4a.contains(this.domNode,"mblVariableHeight")){
this.variableHeight=true;
}
if(this.variableHeight){
_4a.add(this.domNode,"mblVariableHeight");
this.defer(_49.hitch(this,"layoutVariableHeight"),0);
}
if(!this._isOnLine){
this._isOnLine=true;
this.set({icon:this._pending_icon!==undefined?this._pending_icon:this.icon,deleteIcon:this._pending_deleteIcon!==undefined?this._pending_deleteIcon:this.deleteIcon,rightIcon:this._pending_rightIcon!==undefined?this._pending_rightIcon:this.rightIcon,rightIcon2:this._pending_rightIcon2!==undefined?this._pending_rightIcon2:this.rightIcon2,uncheckIcon:this._pending_uncheckIcon!==undefined?this._pending_uncheckIcon:this.uncheckIcon});
delete this._pending_icon;
delete this._pending_deleteIcon;
delete this._pending_rightIcon;
delete this._pending_rightIcon2;
delete this._pending_uncheckIcon;
}
if(_53&&_53.select){
this.set("checked",this._pendingChecked!==undefined?this._pendingChecked:this.checked);
delete this._pendingChecked;
}
this.setArrow();
this.layoutChildren();
},layoutChildren:function(){
var _55;
_47.forEach(this.domNode.childNodes,function(n){
if(n.nodeType!==1){
return;
}
var _56=n.getAttribute("layout")||(_4d.byNode(n)||{}).layout;
if(_56){
_4a.add(n,"mblListItemLayout"+_56.charAt(0).toUpperCase()+_56.substring(1));
this._layoutChildren.push(n);
if(_56==="center"){
_55=n;
}
}
},this);
if(_55){
this.domNode.insertBefore(_55,this.domNode.firstChild);
}
},resize:function(){
if(this.variableHeight){
this.layoutVariableHeight();
}
this.labelNode.style.display=this.labelNode.firstChild?"block":"inline";
},_onTouchStart:function(e){
if(e.target.getAttribute("preventTouch")||(_4d.getEnclosingWidget(e.target)||{}).preventTouch){
return;
}
this.inherited(arguments);
},_onClick:function(e){
if(this.getParent().isEditing||e&&e.type==="keydown"&&e.keyCode!==13){
return;
}
if(this.onClick(e)===false){
return;
}
var n=this.labelNode;
if(this.anchorLabel&&e.currentTarget===n){
_4a.add(n,"mblListItemLabelSelected");
setTimeout(function(){
_4a.remove(n,"mblListItemLabelSelected");
},this._duration);
this.onAnchorLabelClicked(e);
return;
}
var _57=this.getParent();
if(_57.select){
if(_57.select==="single"){
if(!this.checked){
this.set("checked",true);
}
}else{
if(_57.select==="multiple"){
this.set("checked",!this.checked);
}
}
}
this.defaultClickAction(e);
},onClick:function(){
},onAnchorLabelClicked:function(e){
},layoutVariableHeight:function(){
var h=this.domNode.offsetHeight;
if(h===this.domNodeHeight){
return;
}
this.domNodeHeight=h;
_47.forEach(this._layoutChildren.concat([this.rightTextNode,this.rightIcon2Node,this.rightIconNode,this.uncheckIconNode,this.iconNode,this.deleteIconNode,this.knobIconNode]),function(n){
if(n){
var _58=this.domNode;
var f=function(){
var t=Math.round((_58.offsetHeight-n.offsetHeight)/2)-_4c.get(_58,"paddingTop");
n.style.marginTop=t+"px";
};
if(n.offsetHeight===0&&n.tagName==="IMG"){
n.onload=f;
}else{
f();
}
}
},this);
},setArrow:function(){
if(this.checked){
return;
}
var c="";
var _59=this.getParent();
var _5a=this.getTransOpts();
if(_5a.moveTo||_5a.href||_5a.url||this.clickable){
if(!this.noArrow&&!(_59&&_59.selectOne)){
c=this.arrowClass||"mblDomButtonArrow";
}
}
if(c){
this._setRightIconAttr(c);
}
},_findRef:function(_5b){
var i,_5c,_5d=["deleteIcon","icon","rightIcon","uncheckIcon","rightIcon2","rightText"];
for(i=_47.indexOf(_5d,_5b)+1;i<_5d.length;i++){
_5c=this[_5d[i]+"Node"];
if(_5c){
return _5c;
}
}
for(i=_5d.length-1;i>=0;i--){
_5c=this[_5d[i]+"Node"];
if(_5c){
return _5c.nextSibling;
}
}
return this.domNode.firstChild;
},_setIcon:function(_5e,_5f){
if(!this._isOnLine){
this["_pending_"+_5f]=_5e;
return;
}
this._set(_5f,_5e);
this[_5f+"Node"]=_4f.setIcon(_5e,this[_5f+"Pos"],this[_5f+"Node"],this[_5f+"Title"]||this.alt,this.domNode,this._findRef(_5f),"before");
if(this[_5f+"Node"]){
var cap=_5f.charAt(0).toUpperCase()+_5f.substring(1);
_4a.add(this[_5f+"Node"],"mblListItem"+cap);
}
var _60=this[_5f+"Role"];
if(_60){
this[_5f+"Node"].setAttribute("role",_60);
}
},_setDeleteIconAttr:function(_61){
this._setIcon(_61,"deleteIcon");
},_setIconAttr:function(_62){
this._setIcon(_62,"icon");
},_setRightTextAttr:function(_63){
if(!this.rightTextNode){
this.rightTextNode=_4b.create("div",{className:"mblListItemRightText"},this.labelNode,"before");
}
this.rightText=_63;
this.rightTextNode.innerHTML=this._cv?this._cv(_63):_63;
},_setRightIconAttr:function(_64){
this._setIcon(_64,"rightIcon");
},_setUncheckIconAttr:function(_65){
this._setIcon(_65,"uncheckIcon");
},_setRightIcon2Attr:function(_66){
this._setIcon(_66,"rightIcon2");
},_setCheckedAttr:function(_67){
if(!this._isOnLine){
this._pendingChecked=_67;
return;
}
var _68=this.getParent();
if(_68&&_68.select==="single"&&_67){
_47.forEach(_68.getChildren(),function(_69){
_69!==this&&_69.checked&&_69.set("checked",false);
},this);
}
this._setRightIconAttr(this.checkClass||"mblDomButtonCheck");
this._setUncheckIconAttr(this.uncheckClass);
_4a.toggle(this.domNode,"mblListItemChecked",_67);
_4a.toggle(this.domNode,"mblListItemUnchecked",!_67);
_4a.toggle(this.domNode,"mblListItemHasUncheck",!!this.uncheckIconNode);
this.rightIconNode.style.position=(this.uncheckIconNode&&!_67)?"absolute":"";
if(_68&&this.checked!==_67){
_68.onCheckStateChanged(this,_67);
}
this._set("checked",_67);
},_setBusyAttr:function(_6a){
var _6b=this._prog;
if(_6a){
if(!this._progNode){
this._progNode=_4b.create("div",{className:"mblListItemIcon"});
_6b=this._prog=new _51({size:25,center:false});
_4a.add(_6b.domNode,this.progStyle);
this._progNode.appendChild(_6b.domNode);
}
if(this.iconNode){
this.domNode.replaceChild(this._progNode,this.iconNode);
}else{
_4b.place(this._progNode,this._findRef("icon"),"before");
}
_6b.start();
}else{
if(this.iconNode){
this.domNode.replaceChild(this.iconNode,this._progNode);
}else{
this.domNode.removeChild(this._progNode);
}
_6b.stop();
}
this._set("busy",_6a);
},_setSelectedAttr:function(_6c){
this.inherited(arguments);
_4a.toggle(this.domNode,this._selClass,_6c);
}});
_52.ChildWidgetProperties={layout:"",preventTouch:false};
_49.extend(_4e,_52.ChildWidgetProperties);
return _52;
});
},"dojox/mobile/TransitionEvent":function(){
define(["dojo/_base/declare","dojo/_base/Deferred","dojo/_base/lang","dojo/on","./transition"],function(_6d,_6e,_6f,on,_70){
return _6d("dojox.mobile.TransitionEvent",null,{constructor:function(_71,_72,_73){
this.transitionOptions=_72;
this.target=_71;
this.triggerEvent=_73||null;
},dispatch:function(){
var _74={bubbles:true,cancelable:true,detail:this.transitionOptions,triggerEvent:this.triggerEvent};
var evt=on.emit(this.target,"startTransition",_74);
if(evt){
_6e.when(_70,_6f.hitch(this,function(_75){
_6e.when(_75.call(this,evt),_6f.hitch(this,function(_76){
this.endTransition(_76);
}));
}));
}
},endTransition:function(_77){
on.emit(this.target,"endTransition",{detail:_77.transitionOptions});
}});
});
},"dijit/_Contained":function(){
define(["dojo/_base/declare","./registry"],function(_78,_79){
return _78("dijit._Contained",null,{_getSibling:function(_7a){
var _7b=this.domNode;
do{
_7b=_7b[_7a+"Sibling"];
}while(_7b&&_7b.nodeType!=1);
return _7b&&_79.byNode(_7b);
},getPreviousSibling:function(){
return this._getSibling("previous");
},getNextSibling:function(){
return this._getSibling("next");
},getIndexInParent:function(){
var p=this.getParent();
if(!p||!p.getIndexOfChild){
return -1;
}
return p.getIndexOfChild(this);
}});
});
},"dojox/mobile/sniff":function(){
define(["dojo/_base/window","dojo/_base/sniff"],function(win,has){
var ua=navigator.userAgent;
has.add("bb",(ua.indexOf("BlackBerry")>=0||ua.indexOf("BB10"))&&parseFloat(ua.split("Version/")[1])||undefined,undefined,true);
has.add("android",parseFloat(ua.split("Android ")[1])||undefined,undefined,true);
if(ua.match(/(iPhone|iPod|iPad)/)){
var p=RegExp.$1.replace(/P/,"p");
var v=ua.match(/OS ([\d_]+)/)?RegExp.$1:"1";
var os=parseFloat(v.replace(/_/,".").replace(/_/g,""));
has.add(p,os,undefined,true);
has.add("iphone",os,undefined,true);
}
if(has("webkit")){
has.add("touch",(typeof win.doc.documentElement.ontouchstart!="undefined"&&navigator.appVersion.indexOf("Mobile")!=-1)||!!has("android"),undefined,true);
}
return has;
});
},"dojox/mobile/_ItemBase":function(){
define("dojox/mobile/_ItemBase",["dojo/_base/array","dojo/_base/declare","dojo/_base/lang","dojo/_base/window","dojo/dom-class","dojo/touch","dijit/registry","dijit/_Contained","dijit/_Container","dijit/_WidgetBase","./TransitionEvent","./iconUtils","./sniff"],function(_7c,_7d,_7e,win,_7f,_80,_81,_82,_83,_84,_85,_86,has){
return _7d("dojox.mobile._ItemBase",[_84,_83,_82],{icon:"",iconPos:"",alt:"",href:"",hrefTarget:"",moveTo:"",scene:"",clickable:false,url:"",urlTarget:"",back:false,transition:"",transitionDir:1,transitionOptions:null,callback:null,label:"",toggle:false,selected:false,tabIndex:"0",_setTabIndexAttr:"",paramsToInherit:"transition,icon",_selStartMethod:"none",_selEndMethod:"none",_delayedSelection:false,_duration:800,_handleClick:true,buildRendering:function(){
this.inherited(arguments);
this._isOnLine=this.inheritParams();
},startup:function(){
if(this._started){
return;
}
if(!this._isOnLine){
this.inheritParams();
}
if(this._handleClick&&this._selStartMethod==="touch"){
this._onTouchStartHandle=this.connect(this.domNode,_80.press,"_onTouchStart");
}
this.inherited(arguments);
},inheritParams:function(){
var _87=this.getParent();
if(_87){
_7c.forEach(this.paramsToInherit.split(/,/),function(p){
if(p.match(/icon/i)){
var _88=p+"Base",pos=p+"Pos";
if(this[p]&&_87[_88]&&_87[_88].charAt(_87[_88].length-1)==="/"){
this[p]=_87[_88]+this[p];
}
if(!this[p]){
this[p]=_87[_88];
}
if(!this[pos]){
this[pos]=_87[pos];
}
}
if(!this[p]){
this[p]=_87[p];
}
},this);
}
return !!_87;
},getTransOpts:function(){
var _89=this.transitionOptions||{};
_7c.forEach(["moveTo","href","hrefTarget","url","target","urlTarget","scene","transition","transitionDir"],function(p){
_89[p]=_89[p]||this[p];
},this);
return _89;
},userClickAction:function(){
},defaultClickAction:function(e){
this.handleSelection(e);
if(this.userClickAction(e)===false){
return;
}
this.makeTransition(e);
},handleSelection:function(e){
if(this._delayedSelection){
this.set("selected",true);
}
if(this._onTouchEndHandle){
this.disconnect(this._onTouchEndHandle);
this._onTouchEndHandle=null;
}
var p=this.getParent();
if(this.toggle){
this.set("selected",!this._currentSel);
}else{
if(p&&p.selectOne){
this.set("selected",true);
}else{
if(this._selEndMethod==="touch"){
this.set("selected",false);
}else{
if(this._selEndMethod==="timer"){
var _8a=this;
this.defer(function(){
_8a.set("selected",false);
},this._duration);
}
}
}
}
},makeTransition:function(e){
if(this.back&&history){
history.back();
return;
}
if(this.href&&this.hrefTarget){
win.global.open(this.href,this.hrefTarget||"_blank");
this._onNewWindowOpened(e);
return;
}
var _8b=this.getTransOpts();
var _8c=!!(_8b.moveTo||_8b.href||_8b.url||_8b.target||_8b.scene);
if(this._prepareForTransition(e,_8c?_8b:null)===false){
return;
}
if(_8c){
this.setTransitionPos(e);
new _85(this.domNode,_8b,e).dispatch();
}
},_onNewWindowOpened:function(){
},_prepareForTransition:function(e,_8d){
},_onTouchStart:function(e){
if(this.getParent().isEditing||this.onTouchStart(e)===false){
return;
}
if(!this._onTouchEndHandle&&this._selStartMethod==="touch"){
this._onTouchMoveHandle=this.connect(win.body(),_80.move,"_onTouchMove");
this._onTouchEndHandle=this.connect(win.body(),_80.release,"_onTouchEnd");
}
this.touchStartX=e.touches?e.touches[0].pageX:e.clientX;
this.touchStartY=e.touches?e.touches[0].pageY:e.clientY;
this._currentSel=this.selected;
if(this._delayedSelection){
this._selTimer=setTimeout(_7e.hitch(this,function(){
this.set("selected",true);
}),100);
}else{
this.set("selected",true);
}
},onTouchStart:function(){
},_onTouchMove:function(e){
var x=e.touches?e.touches[0].pageX:e.clientX;
var y=e.touches?e.touches[0].pageY:e.clientY;
if(Math.abs(x-this.touchStartX)>=4||Math.abs(y-this.touchStartY)>=4){
this.cancel();
var p=this.getParent();
if(p&&p.selectOne){
this._prevSel&&this._prevSel.set("selected",true);
}else{
this.set("selected",false);
}
}
},_disconnect:function(){
this.disconnect(this._onTouchMoveHandle);
this.disconnect(this._onTouchEndHandle);
this._onTouchMoveHandle=this._onTouchEndHandle=null;
},cancel:function(){
if(this._selTimer){
clearTimeout(this._selTimer);
this._selTimer=null;
}
this._disconnect();
},_onTouchEnd:function(e){
if(!this._selTimer&&this._delayedSelection){
return;
}
this.cancel();
this._onClick(e);
},setTransitionPos:function(e){
var w=this;
while(true){
w=w.getParent();
if(!w||_7f.contains(w.domNode,"mblView")){
break;
}
}
if(w){
w.clickedPosX=e.clientX;
w.clickedPosY=e.clientY;
}
},transitionTo:function(_8e,_8f,url,_90){
var _91=(_8e&&typeof (_8e)==="object")?_8e:{moveTo:_8e,href:_8f,url:url,scene:_90,transition:this.transition,transitionDir:this.transitionDir};
new _85(this.domNode,_91).dispatch();
},_setIconAttr:function(_92){
if(!this._isOnLine){
this._pendingIcon=_92;
return;
}
this._set("icon",_92);
this.iconNode=_86.setIcon(_92,this.iconPos,this.iconNode,this.alt,this.iconParentNode,this.refNode,this.position);
},_setLabelAttr:function(_93){
this._set("label",_93);
this.labelNode.innerHTML=this._cv?this._cv(_93):_93;
},_setSelectedAttr:function(_94){
if(_94){
var p=this.getParent();
if(p&&p.selectOne){
var arr=_7c.filter(p.getChildren(),function(w){
return w.selected;
});
_7c.forEach(arr,function(c){
this._prevSel=c;
c.set("selected",false);
},this);
}
}
this._set("selected",_94);
}});
});
},"dijit/Destroyable":function(){
define(["dojo/_base/array","dojo/aspect","dojo/_base/declare"],function(_95,_96,_97){
return _97("dijit.Destroyable",null,{destroy:function(_98){
this._destroyed=true;
},own:function(){
_95.forEach(arguments,function(_99){
var _9a="destroyRecursive" in _99?"destroyRecursive":"destroy" in _99?"destroy":"remove";
var odh=_96.before(this,"destroy",function(_9b){
_99[_9a](_9b);
});
var hdh=_96.after(_99,_9a,function(){
odh.remove();
hdh.remove();
},true);
},this);
return arguments;
}});
});
},"dojox/mobile/View":function(){
define("dojox/mobile/View",["dojo/_base/array","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/_base/lang","dojo/_base/sniff","dojo/_base/window","dojo/_base/Deferred","dojo/dom","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dijit/registry","dijit/_Contained","dijit/_Container","dijit/_WidgetBase","./ViewController","./common","./transition","./viewRegistry"],function(_9c,_9d,_9e,_9f,_a0,has,win,_a1,dom,_a2,_a3,_a4,_a5,_a6,_a7,_a8,_a9,_aa,_ab,_ac,_ad){
var dm=_a0.getObject("dojox.mobile",true);
return _9f("dojox.mobile.View",[_a9,_a8,_a7],{selected:false,keepScrollPos:true,tag:"div",baseClass:"mblView",constructor:function(_ae,_af){
if(_af){
dom.byId(_af).style.visibility="hidden";
}
},destroy:function(){
_ad.remove(this.id);
this.inherited(arguments);
},buildRendering:function(){
this.domNode=this.containerNode=this.srcNodeRef||_a3.create(this.tag);
this._animEndHandle=this.connect(this.domNode,"webkitAnimationEnd","onAnimationEnd");
this._animStartHandle=this.connect(this.domNode,"webkitAnimationStart","onAnimationStart");
if(!_9d["mblCSS3Transition"]){
this._transEndHandle=this.connect(this.domNode,"webkitTransitionEnd","onAnimationEnd");
}
if(has("mblAndroid3Workaround")){
_a5.set(this.domNode,"webkitTransformStyle","preserve-3d");
}
_ad.add(this);
this.inherited(arguments);
},startup:function(){
if(this._started){
return;
}
if(this._visible===undefined){
var _b0=this.getSiblingViews();
var ids=location.hash&&location.hash.substring(1).split(/,/);
var _b1,_b2,_b3;
_9c.forEach(_b0,function(v,i){
if(_9c.indexOf(ids,v.id)!==-1){
_b1=v;
}
if(i==0){
_b3=v;
}
if(v.selected){
_b2=v;
}
v._visible=false;
},this);
(_b1||_b2||_b3)._visible=true;
}
if(this._visible){
this.show(true,true);
this.defer(function(){
this.onStartView();
_9e.publish("/dojox/mobile/startView",[this]);
});
}
if(this.domNode.style.visibility!="visible"){
this.domNode.style.visibility="visible";
}
this.inherited(arguments);
var _b4=this.getParent();
if(!_b4||!_b4.resize){
this.resize();
}
if(!this._visible){
this.hide();
}
},resize:function(){
_9c.forEach(this.getChildren(),function(_b5){
if(_b5.resize){
_b5.resize();
}
});
},onStartView:function(){
},onBeforeTransitionIn:function(_b6,dir,_b7,_b8,_b9){
},onAfterTransitionIn:function(_ba,dir,_bb,_bc,_bd){
},onBeforeTransitionOut:function(_be,dir,_bf,_c0,_c1){
},onAfterTransitionOut:function(_c2,dir,_c3,_c4,_c5){
},_clearClasses:function(_c6){
if(!_c6){
return;
}
var _c7=[];
_9c.forEach(_a0.trim(_c6.className||"").split(/\s+/),function(c){
if(c.match(/^mbl\w*View$/)||c.indexOf("mbl")===-1){
_c7.push(c);
}
},this);
_c6.className=_c7.join(" ");
},_fixViewState:function(_c8){
var _c9=this.domNode.parentNode.childNodes;
for(var i=0;i<_c9.length;i++){
var n=_c9[i];
if(n.nodeType===1&&_a2.contains(n,"mblView")){
this._clearClasses(n);
}
}
this._clearClasses(_c8);
},convertToId:function(_ca){
if(typeof (_ca)=="string"){
return _ca.replace(/^#?([^&?]+).*/,"$1");
}
return _ca;
},_isBookmarkable:function(_cb){
return _cb.moveTo&&(_9d["mblForceBookmarkable"]||_cb.moveTo.charAt(0)==="#")&&!_cb.hashchange;
},performTransition:function(_cc,_cd,_ce,_cf,_d0){
if(this._detail){
return;
}
var _d1,_d2;
if(_cc&&typeof (_cc)==="object"){
_d1=_cc;
_d2=_cd;
}else{
_d1={moveTo:_cc,transitionDir:_cd,transition:_ce,context:_cf,method:_d0};
_d2=[];
for(var i=5;i<arguments.length;i++){
_d2.push(arguments[i]);
}
}
this._detail=_d1;
this._optArgs=_d2;
this._arguments=[_d1.moveTo,_d1.transitionDir,_d1.transition,_d1.context,_d1.method];
if(_d1.moveTo==="#"){
return;
}
var _d3;
if(_d1.moveTo){
_d3=this.convertToId(_d1.moveTo);
}else{
if(!this._dummyNode){
this._dummyNode=win.doc.createElement("div");
win.body().appendChild(this._dummyNode);
}
_d3=this._dummyNode;
}
if(this.addTransitionInfo&&typeof (_d1.moveTo)=="string"&&this._isBookmarkable(_d1)){
this.addTransitionInfo(this.id,_d1.moveTo,{transitionDir:_d1.transitionDir,transition:_d1.transition});
}
var _d4=this.domNode;
var _d5=_d4.offsetTop;
_d3=this.toNode=dom.byId(_d3);
if(!_d3){
return;
}
_d3.style.visibility="hidden";
_d3.style.display="";
this._fixViewState(_d3);
var _d6=_a6.byNode(_d3);
if(_d6){
if(_9d["mblAlwaysResizeOnTransition"]||!_d6._resized){
_ab.resizeAll(null,_d6);
_d6._resized=true;
}
if(_d1.transition&&_d1.transition!="none"){
_d6.containerNode.style.paddingTop=_d5+"px";
}
_d6.load&&_d6.load();
_d6.movedFrom=_d4.id;
}
if(has("mblAndroidWorkaround")&&!_9d["mblCSS3Transition"]&&_d1.transition&&_d1.transition!="none"){
_a5.set(_d3,"webkitTransformStyle","preserve-3d");
_a5.set(_d4,"webkitTransformStyle","preserve-3d");
_a2.add(_d3,"mblAndroidWorkaround");
}
this.onBeforeTransitionOut.apply(this,this._arguments);
_9e.publish("/dojox/mobile/beforeTransitionOut",[this].concat(_a0._toArray(this._arguments)));
if(_d6){
if(this.keepScrollPos&&!this.getParent()){
var _d7=win.body().scrollTop||win.doc.documentElement.scrollTop||win.global.pageYOffset||0;
_d4._scrollTop=_d7;
var _d8=(_d1.transitionDir==1)?0:(_d3._scrollTop||0);
_d3.style.top="0px";
if(_d7>1||_d8!==0){
_d4.style.top=_d8-_d7+"px";
if(_9d["mblHideAddressBar"]!==false){
setTimeout(function(){
win.global.scrollTo(0,(_d8||1));
},0);
}
}
}else{
_d3.style.top="0px";
}
_d6.onBeforeTransitionIn.apply(_d6,this._arguments);
_9e.publish("/dojox/mobile/beforeTransitionIn",[_d6].concat(_a0._toArray(this._arguments)));
}
_d3.style.display="none";
_d3.style.visibility="visible";
_ab.fromView=this;
_ab.toView=_d6;
this._doTransition(_d4,_d3,_d1.transition,_d1.transitionDir);
},_toCls:function(s){
return "mbl"+s.charAt(0).toUpperCase()+s.substring(1);
},_doTransition:function(_d9,_da,_db,_dc){
var rev=(_dc==-1)?" mblReverse":"";
_da.style.display="";
if(!_db||_db=="none"){
this.domNode.style.display="none";
this.invokeCallback();
}else{
if(_9d["mblCSS3Transition"]){
_a1.when(_ac,_a0.hitch(this,function(_dd){
var _de=_a5.get(_da,"position");
_a5.set(_da,"position","absolute");
_a1.when(_dd(_d9,_da,{transition:_db,reverse:(_dc===-1)?true:false}),_a0.hitch(this,function(){
_a5.set(_da,"position",_de);
this.invokeCallback();
}));
}));
}else{
if(_db.indexOf("cube")!=-1){
if(has("ipad")){
_a5.set(_da.parentNode,{webkitPerspective:1600});
}else{
if(has("iphone")){
_a5.set(_da.parentNode,{webkitPerspective:800});
}
}
}
var s=this._toCls(_db);
if(has("mblAndroidWorkaround")){
setTimeout(function(){
_a2.add(_d9,s+" mblOut"+rev);
_a2.add(_da,s+" mblIn"+rev);
_a2.remove(_da,"mblAndroidWorkaround");
setTimeout(function(){
_a2.add(_d9,"mblTransition");
_a2.add(_da,"mblTransition");
},30);
},70);
}else{
_a2.add(_d9,s+" mblOut"+rev);
_a2.add(_da,s+" mblIn"+rev);
setTimeout(function(){
_a2.add(_d9,"mblTransition");
_a2.add(_da,"mblTransition");
},100);
}
var _df="50% 50%";
var _e0="50% 50%";
var _e1,_e2,_e3;
if(_db.indexOf("swirl")!=-1||_db.indexOf("zoom")!=-1){
if(this.keepScrollPos&&!this.getParent()){
_e1=win.body().scrollTop||win.doc.documentElement.scrollTop||win.global.pageYOffset||0;
}else{
_e1=-_a4.position(_d9,true).y;
}
_e3=win.global.innerHeight/2+_e1;
_df="50% "+_e3+"px";
_e0="50% "+_e3+"px";
}else{
if(_db.indexOf("scale")!=-1){
var _e4=_a4.position(_d9,true);
_e2=((this.clickedPosX!==undefined)?this.clickedPosX:win.global.innerWidth/2)-_e4.x;
if(this.keepScrollPos&&!this.getParent()){
_e1=win.body().scrollTop||win.doc.documentElement.scrollTop||win.global.pageYOffset||0;
}else{
_e1=-_e4.y;
}
_e3=((this.clickedPosY!==undefined)?this.clickedPosY:win.global.innerHeight/2)+_e1;
_df=_e2+"px "+_e3+"px";
_e0=_e2+"px "+_e3+"px";
}
}
_a5.set(_d9,{webkitTransformOrigin:_df});
_a5.set(_da,{webkitTransformOrigin:_e0});
}
}
},onAnimationStart:function(e){
},onAnimationEnd:function(e){
var _e5=e.animationName||e.target.className;
if(_e5.indexOf("Out")===-1&&_e5.indexOf("In")===-1&&_e5.indexOf("Shrink")===-1){
return;
}
var _e6=false;
if(_a2.contains(this.domNode,"mblOut")){
_e6=true;
this.domNode.style.display="none";
_a2.remove(this.domNode,[this._toCls(this._detail.transition),"mblIn","mblOut","mblReverse"]);
}else{
this.containerNode.style.paddingTop="";
}
_a5.set(this.domNode,{webkitTransformOrigin:""});
if(_e5.indexOf("Shrink")!==-1){
var li=e.target;
li.style.display="none";
_a2.remove(li,"mblCloseContent");
var p=_ad.getEnclosingScrollable(this.domNode);
p&&p.onTouchEnd();
}
if(_e6){
this.invokeCallback();
}
this._clearClasses(this.domNode);
this.clickedPosX=this.clickedPosY=undefined;
if(_e5.indexOf("Cube")!==-1&&_e5.indexOf("In")!==-1&&has("iphone")){
this.domNode.parentNode.style.webkitPerspective="";
}
},invokeCallback:function(){
this.onAfterTransitionOut.apply(this,this._arguments);
_9e.publish("/dojox/mobile/afterTransitionOut",[this].concat(this._arguments));
var _e7=_a6.byNode(this.toNode);
if(_e7){
_e7.onAfterTransitionIn.apply(_e7,this._arguments);
_9e.publish("/dojox/mobile/afterTransitionIn",[_e7].concat(this._arguments));
_e7.movedFrom=undefined;
if(this.setFragIds&&this._isBookmarkable(this._detail)){
this.setFragIds(_e7);
}
}
if(has("mblAndroidWorkaround")){
setTimeout(_a0.hitch(this,function(){
if(_e7){
_a5.set(this.toNode,"webkitTransformStyle","");
}
_a5.set(this.domNode,"webkitTransformStyle","");
}),0);
}
var c=this._detail.context,m=this._detail.method;
if(c||m){
if(!m){
m=c;
c=null;
}
c=c||win.global;
if(typeof (m)=="string"){
c[m].apply(c,this._optArgs);
}else{
if(typeof (m)=="function"){
m.apply(c,this._optArgs);
}
}
}
this._detail=this._optArgs=this._arguments=undefined;
},isVisible:function(_e8){
var _e9=function(_ea){
return _a5.get(_ea,"display")!=="none";
};
if(_e8){
for(var n=this.domNode;n.tagName!=="BODY";n=n.parentNode){
if(!_e9(n)){
return false;
}
}
return true;
}else{
return _e9(this.domNode);
}
},getShowingView:function(){
var _eb=this.domNode.parentNode.childNodes;
for(var i=0;i<_eb.length;i++){
var n=_eb[i];
if(n.nodeType===1&&_a2.contains(n,"mblView")&&n.style.display!=="none"){
return _a6.byNode(n);
}
}
return null;
},getSiblingViews:function(){
if(!this.domNode.parentNode){
return [this];
}
return _9c.map(_9c.filter(this.domNode.parentNode.childNodes,function(n){
return n.nodeType===1&&_a2.contains(n,"mblView");
}),function(n){
return _a6.byNode(n);
});
},show:function(_ec,_ed){
var out=this.getShowingView();
if(!_ec){
if(out){
out.onBeforeTransitionOut(out.id);
_9e.publish("/dojox/mobile/beforeTransitionOut",[out,out.id]);
}
this.onBeforeTransitionIn(this.id);
_9e.publish("/dojox/mobile/beforeTransitionIn",[this,this.id]);
}
if(_ed){
this.domNode.style.display="";
}else{
_9c.forEach(this.getSiblingViews(),function(v){
v.domNode.style.display=(v===this)?"":"none";
},this);
}
this.load&&this.load();
if(!_ec){
if(out){
out.onAfterTransitionOut(out.id);
_9e.publish("/dojox/mobile/afterTransitionOut",[out,out.id]);
}
this.onAfterTransitionIn(this.id);
_9e.publish("/dojox/mobile/afterTransitionIn",[this,this.id]);
}
},hide:function(){
this.domNode.style.display="none";
}});
});
},"dojox/mobile/_base":function(){
define(["./common","./View","./Heading","./RoundRect","./RoundRectCategory","./EdgeToEdgeCategory","./RoundRectList","./EdgeToEdgeList","./ListItem","./Container","./Pane","./Switch","./ToolBarButton","./ProgressIndicator"],function(_ee,_ef,_f0,_f1,_f2,_f3,_f4,_f5,_f6,_f7,_f8,_f9){
return _ee;
});
},"dijit/main":function(){
define(["dojo/_base/kernel"],function(_fa){
return _fa.dijit;
});
},"dijit/registry":function(){
define(["dojo/_base/array","dojo/sniff","dojo/_base/unload","dojo/_base/window","./main"],function(_fb,has,_fc,win,_fd){
var _fe={},_ff={};
var _100={length:0,add:function(_101){
if(_ff[_101.id]){
throw new Error("Tried to register widget with id=="+_101.id+" but that id is already registered");
}
_ff[_101.id]=_101;
this.length++;
},remove:function(id){
if(_ff[id]){
delete _ff[id];
this.length--;
}
},byId:function(id){
return typeof id=="string"?_ff[id]:id;
},byNode:function(node){
return _ff[node.getAttribute("widgetId")];
},toArray:function(){
var ar=[];
for(var id in _ff){
ar.push(_ff[id]);
}
return ar;
},getUniqueId:function(_102){
var id;
do{
id=_102+"_"+(_102 in _fe?++_fe[_102]:_fe[_102]=0);
}while(_ff[id]);
return _fd._scopeName=="dijit"?id:_fd._scopeName+"_"+id;
},findWidgets:function(root,_103){
var _104=[];
function _105(root){
for(var node=root.firstChild;node;node=node.nextSibling){
if(node.nodeType==1){
var _106=node.getAttribute("widgetId");
if(_106){
var _107=_ff[_106];
if(_107){
_104.push(_107);
}
}else{
if(node!==_103){
_105(node);
}
}
}
}
};
_105(root);
return _104;
},_destroyAll:function(){
_fd._curFocus=null;
_fd._prevFocus=null;
_fd._activeStack=[];
_fb.forEach(_100.findWidgets(win.body()),function(_108){
if(!_108._destroyed){
if(_108.destroyRecursive){
_108.destroyRecursive();
}else{
if(_108.destroy){
_108.destroy();
}
}
}
});
},getEnclosingWidget:function(node){
while(node){
var id=node.nodeType==1&&node.getAttribute("widgetId");
if(id){
return _ff[id];
}
node=node.parentNode;
}
return null;
},_hash:_ff};
_fd.registry=_100;
return _100;
});
},"dojox/mobile/viewRegistry":function(){
define(["dojo/_base/array","dojo/dom-class","dijit/registry"],function(_109,_10a,_10b){
var _10c={length:0,hash:{},initialView:null,add:function(view){
this.hash[view.id]=view;
this.length++;
},remove:function(id){
if(this.hash[id]){
delete this.hash[id];
this.length--;
}
},getViews:function(){
var arr=[];
for(var i in this.hash){
arr.push(this.hash[i]);
}
return arr;
},getParentView:function(view){
for(var v=view.getParent();v;v=v.getParent()){
if(_10a.contains(v.domNode,"mblView")){
return v;
}
}
return null;
},getChildViews:function(_10d){
return _109.filter(this.getViews(),function(v){
return this.getParentView(v)===_10d;
},this);
},getEnclosingView:function(node){
for(var n=node;n&&n.tagName!=="BODY";n=n.parentNode){
if(n.nodeType===1&&_10a.contains(n,"mblView")){
return _10b.byNode(n);
}
}
return null;
},getEnclosingScrollable:function(node){
for(var w=_10b.getEnclosingWidget(node);w;w=w.getParent()){
if(w.scrollableParams&&w._v){
return w;
}
}
return null;
}};
return _10c;
});
},"dojox/mobile/Heading":function(){
define(["dojo/_base/array","dojo/_base/connect","dojo/_base/declare","dojo/_base/lang","dojo/_base/window","dojo/dom","dojo/dom-class","dojo/dom-construct","dojo/dom-style","dijit/registry","dijit/_Contained","dijit/_Container","dijit/_WidgetBase","./ProgressIndicator","./ToolBarButton","./View"],function(_10e,_10f,_110,lang,win,dom,_111,_112,_113,_114,_115,_116,_117,_118,_119,View){
var dm=lang.getObject("dojox.mobile",true);
return _110("dojox.mobile.Heading",[_117,_116,_115],{back:"",href:"",moveTo:"",transition:"slide",label:"",iconBase:"",tag:"h1",busy:false,progStyle:"mblProgWhite",baseClass:"mblHeading",buildRendering:function(){
this.domNode=this.containerNode=this.srcNodeRef||win.doc.createElement(this.tag);
this.inherited(arguments);
if(!this.label){
_10e.forEach(this.domNode.childNodes,function(n){
if(n.nodeType==3){
var v=lang.trim(n.nodeValue);
if(v){
this.label=v;
this.labelNode=_112.create("span",{innerHTML:v},n,"replace");
}
}
},this);
}
if(!this.labelNode){
this.labelNode=_112.create("span",null,this.domNode);
}
this.labelNode.className="mblHeadingSpanTitle";
this.labelDivNode=_112.create("div",{className:"mblHeadingDivTitle",innerHTML:this.labelNode.innerHTML},this.domNode);
dom.setSelectable(this.domNode,false);
},startup:function(){
if(this._started){
return;
}
var _11a=this.getParent&&this.getParent();
if(!_11a||!_11a.resize){
var _11b=this;
setTimeout(function(){
_11b.resize();
},0);
}
this.inherited(arguments);
},resize:function(){
if(this.labelNode){
var _11c,_11d;
var _11e=this.containerNode.childNodes;
for(var i=_11e.length-1;i>=0;i--){
var c=_11e[i];
if(c.nodeType===1&&_113.get(c,"display")!=="none"){
if(!_11d&&_113.get(c,"float")==="right"){
_11d=c;
}
if(!_11c&&_113.get(c,"float")==="left"){
_11c=c;
}
}
}
if(!this.labelNodeLen&&this.label){
this.labelNode.style.display="inline";
this.labelNodeLen=this.labelNode.offsetWidth;
this.labelNode.style.display="";
}
var bw=this.domNode.offsetWidth;
var rw=_11d?bw-_11d.offsetLeft+5:0;
var lw=_11c?_11c.offsetLeft+_11c.offsetWidth+5:0;
var tw=this.labelNodeLen||0;
_111[bw-Math.max(rw,lw)*2>tw?"add":"remove"](this.domNode,"mblHeadingCenterTitle");
}
_10e.forEach(this.getChildren(),function(_11f){
if(_11f.resize){
_11f.resize();
}
});
},_setBackAttr:function(back){
this._set("back",back);
if(!this.backButton){
this.backButton=new _119({arrow:"left",label:back,moveTo:this.moveTo,back:!this.moveTo,href:this.href,transition:this.transition,transitionDir:-1});
this.backButton.placeAt(this.domNode,"first");
}else{
this.backButton.set("label",back);
}
this.resize();
},_setMoveToAttr:function(_120){
this._set("moveTo",_120);
if(this.backButton){
this.backButton.set("moveTo",_120);
}
},_setLabelAttr:function(_121){
this._set("label",_121);
this.labelNode.innerHTML=this.labelDivNode.innerHTML=this._cv?this._cv(_121):_121;
},_setBusyAttr:function(busy){
var prog=this._prog;
if(busy){
if(!prog){
prog=this._prog=new _118({size:30,center:false});
_111.add(prog.domNode,this.progStyle);
}
_112.place(prog.domNode,this.domNode,"first");
prog.start();
}else{
prog.stop();
}
this._set("busy",busy);
}});
});
},"dojox/mobile/ProgressIndicator":function(){
define(["dojo/_base/config","dojo/_base/declare","dojo/_base/lang","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/has","dijit/_Contained","dijit/_WidgetBase"],function(_122,_123,lang,_124,_125,_126,_127,has,_128,_129){
var cls=_123("dojox.mobile.ProgressIndicator",[_129,_128],{interval:100,size:40,removeOnStop:true,startSpinning:false,center:true,colors:null,baseClass:"mblProgressIndicator",constructor:function(){
this.colors=[];
this._bars=[];
},buildRendering:function(){
this.inherited(arguments);
if(this.center){
_124.add(this.domNode,"mblProgressIndicatorCenter");
}
this.containerNode=_125.create("div",{className:"mblProgContainer"},this.domNode);
this.spinnerNode=_125.create("div",null,this.containerNode);
for(var i=0;i<12;i++){
var div=_125.create("div",{className:"mblProg mblProg"+i},this.spinnerNode);
this._bars.push(div);
}
this.scale(this.size);
if(this.startSpinning){
this.start();
}
},scale:function(size){
var _12a=size/40;
_127.set(this.containerNode,{webkitTransform:"scale("+_12a+")",webkitTransformOrigin:"0 0"});
_126.setMarginBox(this.domNode,{w:size,h:size});
_126.setMarginBox(this.containerNode,{w:size/_12a,h:size/_12a});
},start:function(){
if(this.imageNode){
var img=this.imageNode;
var l=Math.round((this.containerNode.offsetWidth-img.offsetWidth)/2);
var t=Math.round((this.containerNode.offsetHeight-img.offsetHeight)/2);
img.style.margin=t+"px "+l+"px";
return;
}
var cntr=0;
var _12b=this;
var n=12;
this.timer=setInterval(function(){
cntr--;
cntr=cntr<0?n-1:cntr;
var c=_12b.colors;
for(var i=0;i<n;i++){
var idx=(cntr+i)%n;
if(c[idx]){
_12b._bars[i].style.backgroundColor=c[idx];
}else{
_124.replace(_12b._bars[i],"mblProg"+idx+"Color","mblProg"+(idx===n-1?0:idx+1)+"Color");
}
}
},this.interval);
},stop:function(){
if(this.timer){
clearInterval(this.timer);
}
this.timer=null;
if(this.removeOnStop&&this.domNode&&this.domNode.parentNode){
this.domNode.parentNode.removeChild(this.domNode);
}
},setImage:function(file){
if(file){
this.imageNode=_125.create("img",{src:file},this.containerNode);
this.spinnerNode.style.display="none";
}else{
if(this.imageNode){
this.containerNode.removeChild(this.imageNode);
this.imageNode=null;
}
this.spinnerNode.style.display="";
}
},destroy:function(){
this.inherited(arguments);
if(this===cls._instance){
cls._instance=null;
}
}});
cls._instance=null;
cls.getInstance=function(_12c){
if(!cls._instance){
cls._instance=new cls(_12c);
}
return cls._instance;
};
return cls;
});
},"dojox/mobile/Container":function(){
define(["dojo/_base/declare","dijit/_Container","./Pane"],function(_12d,_12e,Pane){
return _12d("dojox.mobile.Container",[Pane,_12e],{baseClass:"mblContainer"});
});
},"dojox/mobile/RoundRectList":function(){
define(["dojo/_base/array","dojo/_base/declare","dojo/_base/event","dojo/_base/lang","dojo/_base/window","dojo/dom-construct","dijit/_Contained","dijit/_Container","dijit/_WidgetBase"],function(_12f,_130,_131,lang,win,_132,_133,_134,_135){
return _130("dojox.mobile.RoundRectList",[_135,_134,_133],{transition:"slide",iconBase:"",iconPos:"",select:"",stateful:false,syncWithViews:false,editable:false,tag:"ul",editableMixinClass:"dojox/mobile/_EditableListMixin",baseClass:"mblRoundRectList",buildRendering:function(){
this.domNode=this.srcNodeRef||_132.create(this.tag);
this.inherited(arguments);
},postCreate:function(){
if(this.editable){
require([this.editableMixinClass],lang.hitch(this,function(_136){
_130.safeMixin(this,new _136());
}));
}
this.connect(this.domNode,"onselectstart",_131.stop);
if(this.syncWithViews){
var f=function(view,_137,dir,_138,_139,_13a){
var _13b=_12f.filter(this.getChildren(),function(w){
return w.moveTo==="#"+view.id||w.moveTo===view.id;
})[0];
if(_13b){
_13b.set("selected",true);
}
};
this.subscribe("/dojox/mobile/afterTransitionIn",f);
this.subscribe("/dojox/mobile/startView",f);
}
},resize:function(){
_12f.forEach(this.getChildren(),function(_13c){
if(_13c.resize){
_13c.resize();
}
});
},onCheckStateChanged:function(){
},_setStatefulAttr:function(_13d){
this._set("stateful",_13d);
this.selectOne=_13d;
_12f.forEach(this.getChildren(),function(_13e){
_13e.setArrow&&_13e.setArrow();
});
},deselectItem:function(item){
item.set("selected",false);
},deselectAll:function(){
_12f.forEach(this.getChildren(),function(_13f){
_13f.set("selected",false);
});
},selectItem:function(item){
item.set("selected",true);
}});
});
},"dijit/_Container":function(){
define(["dojo/_base/array","dojo/_base/declare","dojo/dom-construct"],function(_140,_141,_142){
return _141("dijit._Container",null,{buildRendering:function(){
this.inherited(arguments);
if(!this.containerNode){
this.containerNode=this.domNode;
}
},addChild:function(_143,_144){
var _145=this.containerNode;
if(_144&&typeof _144=="number"){
var _146=this.getChildren();
if(_146&&_146.length>=_144){
_145=_146[_144-1].domNode;
_144="after";
}
}
_142.place(_143.domNode,_145,_144);
if(this._started&&!_143._started){
_143.startup();
}
},removeChild:function(_147){
if(typeof _147=="number"){
_147=this.getChildren()[_147];
}
if(_147){
var node=_147.domNode;
if(node&&node.parentNode){
node.parentNode.removeChild(node);
}
}
},hasChildren:function(){
return this.getChildren().length>0;
},_getSiblingOfChild:function(_148,dir){
var _149=this.getChildren(),idx=_140.indexOf(this.getChildren(),_148);
return _149[idx+dir];
},getIndexOfChild:function(_14a){
return _140.indexOf(this.getChildren(),_14a);
}});
});
},"dojox/mobile/Switch":function(){
define(["dojo/_base/array","dojo/_base/connect","dojo/_base/declare","dojo/_base/event","dojo/_base/window","dojo/dom-class","dojo/dom-construct","dojo/dom-style","dojo/touch","dijit/_Contained","dijit/_WidgetBase","./sniff"],function(_14b,_14c,_14d,_14e,win,_14f,_150,_151,_152,_153,_154,has){
return _14d("dojox.mobile.Switch",[_154,_153],{value:"on",name:"",leftLabel:"ON",rightLabel:"OFF",shape:"mblSwDefaultShape",tabIndex:"0",_setTabIndexAttr:"",baseClass:"mblSwitch",role:"",_createdMasks:[],buildRendering:function(){
this.domNode=(this.srcNodeRef&&this.srcNodeRef.tagName==="SPAN")?this.srcNodeRef:_150.create("span");
this.inherited(arguments);
var c=(this.srcNodeRef&&this.srcNodeRef.className)||this.className||this["class"];
if((c=c.match(/mblSw.*Shape\d*/))){
this.shape=c;
}
_14f.add(this.domNode,this.shape);
var _155=this.name?" name=\""+this.name+"\"":"";
this.domNode.innerHTML="<div class=\"mblSwitchInner\">"+"<div class=\"mblSwitchBg mblSwitchBgLeft\">"+"<div class=\"mblSwitchText mblSwitchTextLeft\"></div>"+"</div>"+"<div class=\"mblSwitchBg mblSwitchBgRight\">"+"<div class=\"mblSwitchText mblSwitchTextRight\"></div>"+"</div>"+"<div class=\"mblSwitchKnob\"></div>"+"<input type=\"hidden\""+_155+"></div>"+"</div>";
var n=this.inner=this.domNode.firstChild;
this.left=n.childNodes[0];
this.right=n.childNodes[1];
this.knob=n.childNodes[2];
this.input=n.childNodes[3];
},postCreate:function(){
this._clickHandle=this.connect(this.domNode,"onclick","_onClick");
this._keydownHandle=this.connect(this.domNode,"onkeydown","_onClick");
this._startHandle=this.connect(this.domNode,_152.press,"onTouchStart");
this._initialValue=this.value;
},_changeState:function(_156,anim){
var on=(_156==="on");
this.left.style.display="";
this.right.style.display="";
this.inner.style.left="";
if(anim){
_14f.add(this.domNode,"mblSwitchAnimation");
}
_14f.remove(this.domNode,on?"mblSwitchOff":"mblSwitchOn");
_14f.add(this.domNode,on?"mblSwitchOn":"mblSwitchOff");
var _157=this;
setTimeout(function(){
_157.left.style.display=on?"":"none";
_157.right.style.display=!on?"":"none";
_14f.remove(_157.domNode,"mblSwitchAnimation");
},anim?300:0);
},_createMaskImage:function(){
if(this._hasMaskImage){
return;
}
this._width=this.domNode.offsetWidth-this.knob.offsetWidth;
this._hasMaskImage=true;
if(!has("webkit")){
return;
}
var rDef=_151.get(this.left,"borderTopLeftRadius");
if(rDef=="0px"){
return;
}
var _158=rDef.split(" ");
var rx=parseFloat(_158[0]),ry=(_158.length==1)?rx:parseFloat(_158[1]);
var w=this.domNode.offsetWidth,h=this.domNode.offsetHeight;
var id=(this.shape+"Mask"+w+h+rx+ry).replace(/\./,"_");
if(!this._createdMasks[id]){
this._createdMasks[id]=1;
var ctx=win.doc.getCSSCanvasContext("2d",id,w,h);
ctx.fillStyle="#000000";
ctx.beginPath();
if(rx==ry){
ctx.moveTo(rx,0);
ctx.arcTo(0,0,0,rx,rx);
ctx.lineTo(0,h-rx);
ctx.arcTo(0,h,rx,h,rx);
ctx.lineTo(w-rx,h);
ctx.arcTo(w,h,w,rx,rx);
ctx.lineTo(w,rx);
ctx.arcTo(w,0,w-rx,0,rx);
}else{
var pi=Math.PI;
ctx.scale(1,ry/rx);
ctx.moveTo(rx,0);
ctx.arc(rx,rx,rx,1.5*pi,0.5*pi,true);
ctx.lineTo(w-rx,2*rx);
ctx.arc(w-rx,rx,rx,0.5*pi,1.5*pi,true);
}
ctx.closePath();
ctx.fill();
}
this.domNode.style.webkitMaskImage="-webkit-canvas("+id+")";
},_onClick:function(e){
if(e&&e.type==="keydown"&&e.keyCode!==13){
return;
}
if(this.onClick(e)===false){
return;
}
if(this._moved){
return;
}
this.value=this.input.value=(this.value=="on")?"off":"on";
this._changeState(this.value,true);
this.onStateChanged(this.value);
},onClick:function(){
},onTouchStart:function(e){
this._moved=false;
this.innerStartX=this.inner.offsetLeft;
if(!this._conn){
this._conn=[this.connect(this.inner,_152.move,"onTouchMove"),this.connect(this.inner,_152.release,"onTouchEnd")];
}
this.touchStartX=e.touches?e.touches[0].pageX:e.clientX;
this.left.style.display="";
this.right.style.display="";
_14e.stop(e);
this._createMaskImage();
},onTouchMove:function(e){
e.preventDefault();
var dx;
if(e.targetTouches){
if(e.targetTouches.length!=1){
return;
}
dx=e.targetTouches[0].clientX-this.touchStartX;
}else{
dx=e.clientX-this.touchStartX;
}
var pos=this.innerStartX+dx;
var d=10;
if(pos<=-(this._width-d)){
pos=-this._width;
}
if(pos>=-d){
pos=0;
}
this.inner.style.left=pos+"px";
if(Math.abs(dx)>d){
this._moved=true;
}
},onTouchEnd:function(e){
_14b.forEach(this._conn,_14c.disconnect);
this._conn=null;
if(this.innerStartX==this.inner.offsetLeft){
if(has("touch")&&!(has("android")>=4.1)){
var ev=win.doc.createEvent("MouseEvents");
ev.initEvent("click",true,true);
this.inner.dispatchEvent(ev);
}
return;
}
var _159=(this.inner.offsetLeft<-(this._width/2))?"off":"on";
this._changeState(_159,true);
if(_159!=this.value){
this.value=this.input.value=_159;
this.onStateChanged(_159);
}
},onStateChanged:function(_15a){
},_setValueAttr:function(_15b){
this._changeState(_15b,false);
if(this.value!=_15b){
this.onStateChanged(_15b);
}
this.value=this.input.value=_15b;
},_setLeftLabelAttr:function(_15c){
this.leftLabel=_15c;
this.left.firstChild.innerHTML=this._cv?this._cv(_15c):_15c;
},_setRightLabelAttr:function(_15d){
this.rightLabel=_15d;
this.right.firstChild.innerHTML=this._cv?this._cv(_15d):_15d;
},reset:function(){
this.set("value",this._initialValue);
}});
});
},"dojox/mobile/EdgeToEdgeCategory":function(){
define(["dojo/_base/declare","./RoundRectCategory"],function(_15e,_15f){
return _15e("dojox.mobile.EdgeToEdgeCategory",_15f,{buildRendering:function(){
this.inherited(arguments);
this.domNode.className="mblEdgeToEdgeCategory";
}});
});
},"dojox/mobile/transition":function(){
define(["dojo/_base/Deferred","dojo/_base/config"],function(_160,_161){
if(_161["mblCSS3Transition"]){
var _162=new _160();
require([_161["mblCSS3Transition"]],function(_163){
_162.resolve(_163);
});
return _162;
}
return null;
});
},"dijit/_WidgetBase":function(){
define(["require","dojo/_base/array","dojo/aspect","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/ready","dojo/Stateful","dojo/topic","dojo/_base/window","./Destroyable","./registry"],function(_164,_165,_166,_167,_168,_169,dom,_16a,_16b,_16c,_16d,_16e,has,_16f,lang,on,_170,_171,_172,win,_173,_174){
has.add("dijit-legacy-requires",!_16f.isAsync);
if(has("dijit-legacy-requires")){
_170(0,function(){
var _175=["dijit/_base/manager"];
_164(_175);
});
}
var _176={};
function _177(obj){
var ret={};
for(var attr in obj){
ret[attr.toLowerCase()]=true;
}
return ret;
};
function _178(attr){
return function(val){
_16a[val?"set":"remove"](this.domNode,attr,val);
this._set(attr,val);
};
};
return _169("dijit._WidgetBase",[_171,_173],{id:"",_setIdAttr:"domNode",lang:"",_setLangAttr:_178("lang"),dir:"",_setDirAttr:_178("dir"),textDir:"","class":"",_setClassAttr:{node:"domNode",type:"class"},style:"",title:"",tooltip:"",baseClass:"",srcNodeRef:null,domNode:null,containerNode:null,ownerDocument:null,_setOwnerDocumentAttr:function(val){
this._set("ownerDocument",val);
},attributeMap:{},_blankGif:_167.blankGif||_164.toUrl("dojo/resources/blank.gif"),postscript:function(_179,_17a){
this.create(_179,_17a);
},create:function(_17b,_17c){
this.srcNodeRef=dom.byId(_17c);
this._connects=[];
this._supportingWidgets=[];
if(this.srcNodeRef&&(typeof this.srcNodeRef.id=="string")){
this.id=this.srcNodeRef.id;
}
if(_17b){
this.params=_17b;
lang.mixin(this,_17b);
}
this.postMixInProperties();
if(!this.id){
this.id=_174.getUniqueId(this.declaredClass.replace(/\./g,"_"));
if(this.params){
delete this.params.id;
}
}
this.ownerDocument=this.ownerDocument||(this.srcNodeRef?this.srcNodeRef.ownerDocument:win.doc);
this.ownerDocumentBody=win.body(this.ownerDocument);
_174.add(this);
this.buildRendering();
var _17d;
if(this.domNode){
this._applyAttributes();
var _17e=this.srcNodeRef;
if(_17e&&_17e.parentNode&&this.domNode!==_17e){
_17e.parentNode.replaceChild(this.domNode,_17e);
_17d=true;
}
this.domNode.setAttribute("widgetId",this.id);
}
this.postCreate();
if(_17d){
delete this.srcNodeRef;
}
this._created=true;
},_applyAttributes:function(){
var ctor=this.constructor,list=ctor._setterAttrs;
if(!list){
list=(ctor._setterAttrs=[]);
for(var attr in this.attributeMap){
list.push(attr);
}
var _17f=ctor.prototype;
for(var _180 in _17f){
if(_180 in this.attributeMap){
continue;
}
var _181="_set"+_180.replace(/^[a-z]|-[a-zA-Z]/g,function(c){
return c.charAt(c.length-1).toUpperCase();
})+"Attr";
if(_181 in _17f){
list.push(_180);
}
}
}
var _182={};
for(var key in this.params||{}){
_182[key]=this[key];
}
_165.forEach(list,function(attr){
if(attr in _182){
}else{
if(this[attr]){
this.set(attr,this[attr]);
}
}
},this);
for(key in _182){
this.set(key,_182[key]);
}
},postMixInProperties:function(){
},buildRendering:function(){
if(!this.domNode){
this.domNode=this.srcNodeRef||this.ownerDocument.createElement("div");
}
if(this.baseClass){
var _183=this.baseClass.split(" ");
if(!this.isLeftToRight()){
_183=_183.concat(_165.map(_183,function(name){
return name+"Rtl";
}));
}
_16b.add(this.domNode,_183);
}
},postCreate:function(){
},startup:function(){
if(this._started){
return;
}
this._started=true;
_165.forEach(this.getChildren(),function(obj){
if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){
obj.startup();
obj._started=true;
}
});
},destroyRecursive:function(_184){
this._beingDestroyed=true;
this.destroyDescendants(_184);
this.destroy(_184);
},destroy:function(_185){
this._beingDestroyed=true;
this.uninitialize();
function _186(w){
if(w.destroyRecursive){
w.destroyRecursive(_185);
}else{
if(w.destroy){
w.destroy(_185);
}
}
};
_165.forEach(this._connects,lang.hitch(this,"disconnect"));
_165.forEach(this._supportingWidgets,_186);
if(this.domNode){
_165.forEach(_174.findWidgets(this.domNode,this.containerNode),_186);
}
this.destroyRendering(_185);
_174.remove(this.id);
this._destroyed=true;
},destroyRendering:function(_187){
if(this.bgIframe){
this.bgIframe.destroy(_187);
delete this.bgIframe;
}
if(this.domNode){
if(_187){
_16a.remove(this.domNode,"widgetId");
}else{
_16c.destroy(this.domNode);
}
delete this.domNode;
}
if(this.srcNodeRef){
if(!_187){
_16c.destroy(this.srcNodeRef);
}
delete this.srcNodeRef;
}
},destroyDescendants:function(_188){
_165.forEach(this.getChildren(),function(_189){
if(_189.destroyRecursive){
_189.destroyRecursive(_188);
}
});
},uninitialize:function(){
return false;
},_setStyleAttr:function(_18a){
var _18b=this.domNode;
if(lang.isObject(_18a)){
_16e.set(_18b,_18a);
}else{
if(_18b.style.cssText){
_18b.style.cssText+="; "+_18a;
}else{
_18b.style.cssText=_18a;
}
}
this._set("style",_18a);
},_attrToDom:function(attr,_18c,_18d){
_18d=arguments.length>=3?_18d:this.attributeMap[attr];
_165.forEach(lang.isArray(_18d)?_18d:[_18d],function(_18e){
var _18f=this[_18e.node||_18e||"domNode"];
var type=_18e.type||"attribute";
switch(type){
case "attribute":
if(lang.isFunction(_18c)){
_18c=lang.hitch(this,_18c);
}
var _190=_18e.attribute?_18e.attribute:(/^on[A-Z][a-zA-Z]*$/.test(attr)?attr.toLowerCase():attr);
if(_18f.tagName){
_16a.set(_18f,_190,_18c);
}else{
_18f.set(_190,_18c);
}
break;
case "innerText":
_18f.innerHTML="";
_18f.appendChild(this.ownerDocument.createTextNode(_18c));
break;
case "innerHTML":
_18f.innerHTML=_18c;
break;
case "class":
_16b.replace(_18f,_18c,this[attr]);
break;
}
},this);
},get:function(name){
var _191=this._getAttrNames(name);
return this[_191.g]?this[_191.g]():this[name];
},set:function(name,_192){
if(typeof name==="object"){
for(var x in name){
this.set(x,name[x]);
}
return this;
}
var _193=this._getAttrNames(name),_194=this[_193.s];
if(lang.isFunction(_194)){
var _195=_194.apply(this,Array.prototype.slice.call(arguments,1));
}else{
var _196=this.focusNode&&!lang.isFunction(this.focusNode)?"focusNode":"domNode",tag=this[_196].tagName,_197=_176[tag]||(_176[tag]=_177(this[_196])),map=name in this.attributeMap?this.attributeMap[name]:_193.s in this?this[_193.s]:((_193.l in _197&&typeof _192!="function")||/^aria-|^data-|^role$/.test(name))?_196:null;
if(map!=null){
this._attrToDom(name,_192,map);
}
this._set(name,_192);
}
return _195||this;
},_attrPairNames:{},_getAttrNames:function(name){
var apn=this._attrPairNames;
if(apn[name]){
return apn[name];
}
var uc=name.replace(/^[a-z]|-[a-zA-Z]/g,function(c){
return c.charAt(c.length-1).toUpperCase();
});
return (apn[name]={n:name+"Node",s:"_set"+uc+"Attr",g:"_get"+uc+"Attr",l:uc.toLowerCase()});
},_set:function(name,_198){
var _199=this[name];
this[name]=_198;
if(this._created&&_198!==_199){
if(this._watchCallbacks){
this._watchCallbacks(name,_199,_198);
}
this.emit("attrmodified-"+name,{detail:{prevValue:_199,newValue:_198}});
}
},emit:function(type,_19a,_19b){
_19a=_19a||{};
if(_19a.bubbles===undefined){
_19a.bubbles=true;
}
if(_19a.cancelable===undefined){
_19a.cancelable=true;
}
if(!_19a.detail){
_19a.detail={};
}
_19a.detail.widget=this;
var ret,_19c=this["on"+type];
if(_19c){
ret=_19c.apply(this,_19b?_19b:[_19a]);
}
if(this._started&&!this._beingDestroyed){
on.emit(this.domNode,type.toLowerCase(),_19a);
}
return ret;
},on:function(type,func){
var _19d=this._onMap(type);
if(_19d){
return _166.after(this,_19d,func,true);
}
return this.own(on(this.domNode,type,func))[0];
},_onMap:function(type){
var ctor=this.constructor,map=ctor._onMap;
if(!map){
map=(ctor._onMap={});
for(var attr in ctor.prototype){
if(/^on/.test(attr)){
map[attr.replace(/^on/,"").toLowerCase()]=attr;
}
}
}
return map[typeof type=="string"&&type.toLowerCase()];
},toString:function(){
return "[Widget "+this.declaredClass+", "+(this.id||"NO ID")+"]";
},getChildren:function(){
return this.containerNode?_174.findWidgets(this.containerNode):[];
},getParent:function(){
return _174.getEnclosingWidget(this.domNode.parentNode);
},connect:function(obj,_19e,_19f){
return this.own(_168.connect(obj,_19e,this,_19f))[0];
},disconnect:function(_1a0){
_1a0.remove();
},subscribe:function(t,_1a1){
return this.own(_172.subscribe(t,lang.hitch(this,_1a1)))[0];
},unsubscribe:function(_1a2){
_1a2.remove();
},isLeftToRight:function(){
return this.dir?(this.dir=="ltr"):_16d.isBodyLtr(this.ownerDocument);
},isFocusable:function(){
return this.focus&&(_16e.get(this.domNode,"display")!="none");
},placeAt:function(_1a3,_1a4){
var _1a5=!_1a3.tagName&&_174.byId(_1a3);
if(_1a5&&_1a5.addChild&&(!_1a4||typeof _1a4==="number")){
_1a5.addChild(this,_1a4);
}else{
var ref=_1a5?(_1a5.containerNode&&!/after|before|replace/.test(_1a4||"")?_1a5.containerNode:_1a5.domNode):dom.byId(_1a3,this.ownerDocument);
_16c.place(this.domNode,ref,_1a4);
if(!this._started&&(this.getParent()||{})._started){
this.startup();
}
}
return this;
},getTextDir:function(text,_1a6){
return _1a6;
},applyTextDir:function(){
},defer:function(fcn,_1a7){
var _1a8=setTimeout(lang.hitch(this,function(){
_1a8=null;
if(!this._destroyed){
lang.hitch(this,fcn)();
}
}),_1a7||0);
return {remove:function(){
if(_1a8){
clearTimeout(_1a8);
_1a8=null;
}
return null;
}};
}});
});
},"dojox/main":function(){
define(["dojo/_base/kernel"],function(dojo){
return dojo.dojox;
});
},"dojox/mobile/common":function(){
define(["dojo/_base/array","dojo/_base/config","dojo/_base/connect","dojo/_base/lang","dojo/_base/window","dojo/dom-class","dojo/dom-construct","dojo/ready","dijit/registry","./sniff","./uacss"],function(_1a9,_1aa,_1ab,lang,win,_1ac,_1ad,_1ae,_1af,has){
var dm=lang.getObject("dojox.mobile",true);
dm.getScreenSize=function(){
return {h:win.global.innerHeight||win.doc.documentElement.clientHeight,w:win.global.innerWidth||win.doc.documentElement.clientWidth};
};
dm.updateOrient=function(){
var dim=dm.getScreenSize();
_1ac.replace(win.doc.documentElement,dim.h>dim.w?"dj_portrait":"dj_landscape",dim.h>dim.w?"dj_landscape":"dj_portrait");
};
dm.updateOrient();
dm.tabletSize=500;
dm.detectScreenSize=function(_1b0){
var dim=dm.getScreenSize();
var sz=Math.min(dim.w,dim.h);
var from,to;
if(sz>=dm.tabletSize&&(_1b0||(!this._sz||this._sz<dm.tabletSize))){
from="phone";
to="tablet";
}else{
if(sz<dm.tabletSize&&(_1b0||(!this._sz||this._sz>=dm.tabletSize))){
from="tablet";
to="phone";
}
}
if(to){
_1ac.replace(win.doc.documentElement,"dj_"+to,"dj_"+from);
_1ab.publish("/dojox/mobile/screenSize/"+to,[dim]);
}
this._sz=sz;
};
dm.detectScreenSize();
dm.hideAddressBarWait=typeof (_1aa["mblHideAddressBarWait"])==="number"?_1aa["mblHideAddressBarWait"]:1500;
dm.hide_1=function(){
scrollTo(0,1);
dm._hidingTimer=(dm._hidingTimer==0)?200:dm._hidingTimer*2;
setTimeout(function(){
if(dm.isAddressBarHidden()||dm._hidingTimer>dm.hideAddressBarWait){
dm.resizeAll();
dm._hiding=false;
}else{
setTimeout(dm.hide_1,dm._hidingTimer);
}
},50);
};
dm.hideAddressBar=function(evt){
if(dm.disableHideAddressBar||dm._hiding){
return;
}
dm._hiding=true;
dm._hidingTimer=has("iphone")?200:0;
var minH=screen.availHeight;
if(has("android")){
minH=outerHeight/devicePixelRatio;
if(minH==0){
dm._hiding=false;
setTimeout(function(){
dm.hideAddressBar();
},200);
}
if(minH<=innerHeight){
minH=outerHeight;
}
if(has("android")<3){
win.doc.documentElement.style.overflow=win.body().style.overflow="visible";
}
}
if(win.body().offsetHeight<minH){
win.body().style.minHeight=minH+"px";
dm._resetMinHeight=true;
}
setTimeout(dm.hide_1,dm._hidingTimer);
};
dm.isAddressBarHidden=function(){
return pageYOffset===1;
};
dm.resizeAll=function(evt,root){
if(dm.disableResizeAll){
return;
}
_1ab.publish("/dojox/mobile/resizeAll",[evt,root]);
_1ab.publish("/dojox/mobile/beforeResizeAll",[evt,root]);
if(dm._resetMinHeight){
win.body().style.minHeight=dm.getScreenSize().h+"px";
}
dm.updateOrient();
dm.detectScreenSize();
var _1b1=function(w){
var _1b2=w.getParent&&w.getParent();
return !!((!_1b2||!_1b2.resize)&&w.resize);
};
var _1b3=function(w){
_1a9.forEach(w.getChildren(),function(_1b4){
if(_1b1(_1b4)){
_1b4.resize();
}
_1b3(_1b4);
});
};
if(root){
if(root.resize){
root.resize();
}
_1b3(root);
}else{
_1a9.forEach(_1a9.filter(_1af.toArray(),_1b1),function(w){
w.resize();
});
}
_1ab.publish("/dojox/mobile/afterResizeAll",[evt,root]);
};
dm.openWindow=function(url,_1b5){
win.global.open(url,_1b5||"_blank");
};
if(_1aa["mblApplyPageStyles"]!==false){
_1ac.add(win.doc.documentElement,"mobile");
}
if(has("chrome")){
_1ac.add(win.doc.documentElement,"dj_chrome");
}
if(win.global._no_dojo_dm){
var _1b6=win.global._no_dojo_dm;
for(var i in _1b6){
dm[i]=_1b6[i];
}
dm.deviceTheme.setDm(dm);
}
has.add("mblAndroidWorkaround",_1aa["mblAndroidWorkaround"]!==false&&has("android")<3,undefined,true);
has.add("mblAndroid3Workaround",_1aa["mblAndroid3Workaround"]!==false&&has("android")>=3,undefined,true);
_1ae(function(){
dm.detectScreenSize(true);
if(_1aa["mblAndroidWorkaroundButtonStyle"]!==false&&has("android")){
_1ad.create("style",{innerHTML:"BUTTON,INPUT[type='button'],INPUT[type='submit'],INPUT[type='reset'],INPUT[type='file']::-webkit-file-upload-button{-webkit-appearance:none;}"},win.doc.head,"first");
}
if(has("mblAndroidWorkaround")){
_1ad.create("style",{innerHTML:".mblView.mblAndroidWorkaround{position:absolute;top:-9999px !important;left:-9999px !important;}"},win.doc.head,"last");
}
var f=dm.resizeAll;
if(_1aa["mblHideAddressBar"]!==false&&navigator.appVersion.indexOf("Mobile")!=-1||_1aa["mblForceHideAddressBar"]===true){
dm.hideAddressBar();
if(_1aa["mblAlwaysHideAddressBar"]===true){
f=dm.hideAddressBar;
}
}
var ios6=has("iphone")>=6;
if((has("android")||ios6)&&win.global.onorientationchange!==undefined){
var _1b7=f;
f=function(evt){
var _1b8=_1ab.connect(null,"onresize",null,function(e){
_1ab.disconnect(_1b8);
_1b7(e);
});
};
var _1b9=dm.getScreenSize();
var _1ba=ios6?20:100;
var _1bb=null;
var _1bc=null;
if(ios6){
_1ab.connect(null,"onkeyup",null,function(e){
_1bb=(new Date()).getTime();
});
_1bc=function(node){
if(node&&node.nodeType!==1){
node=node.parentNode;
}
if(!node||node.nodeType!==1){
return false;
}
var t=node.tagName;
return (t==="SELECT"||t==="INPUT"||t==="TEXTAREA"||t==="BUTTON");
};
}
_1ab.connect(null,"onresize",null,function(e){
var _1bd=dm.getScreenSize();
if(_1bd.w==_1b9.w&&Math.abs(_1bd.h-_1b9.h)>=_1ba&&!(ios6&&((_1bb&&((new Date()).getTime()-_1bb)<400)||_1bc(win.doc.activeElement)))){
if(ios6&&pageYOffset>1){
dm.resizeAll();
}else{
_1b7(e);
}
}
_1b9=_1bd;
});
}
_1ab.connect(null,win.global.onorientationchange!==undefined?"onorientationchange":"onresize",null,f);
win.body().style.visibility="visible";
});
return dm;
});
},"dojox/mobile/ViewController":function(){
define(["dojo/_base/kernel","dojo/_base/array","dojo/_base/connect","dojo/_base/declare","dojo/_base/lang","dojo/_base/window","dojo/_base/Deferred","dojo/dom","dojo/dom-class","dojo/dom-construct","dojo/on","dojo/ready","dijit/registry","./ProgressIndicator","./TransitionEvent","./viewRegistry"],function(dojo,_1be,_1bf,_1c0,lang,win,_1c1,dom,_1c2,_1c3,on,_1c4,_1c5,_1c6,_1c7,_1c8){
var _1c9=_1c0("dojox.mobile.ViewController",null,{dataHandlerClass:"dojox/mobile/dh/DataHandler",dataSourceClass:"dojox/mobile/dh/UrlDataSource",fileTypeMapClass:"dojox/mobile/dh/SuffixFileTypeMap",constructor:function(){
this.viewMap={};
_1c4(lang.hitch(this,function(){
on(win.body(),"startTransition",lang.hitch(this,"onStartTransition"));
}));
},findTransitionViews:function(_1ca){
if(!_1ca){
return [];
}
_1ca.match(/^#?([^&?]+)(.*)/);
var _1cb=RegExp.$2;
var view=_1c5.byId(RegExp.$1);
if(!view){
return [];
}
for(var v=view.getParent();v;v=v.getParent()){
if(v.isVisible&&!v.isVisible()){
var sv=view.getShowingView();
if(sv&&sv.id!==view.id){
view.show();
}
view=v;
}
}
return [view.getShowingView(),view,_1cb];
},openExternalView:function(_1cc,_1cd){
var d=new _1c1();
var id=this.viewMap[_1cc.url];
if(id){
_1cc.moveTo=id;
if(_1cc.noTransition){
_1c5.byId(id).hide();
}else{
new _1c7(win.body(),_1cc).dispatch();
}
d.resolve(true);
return d;
}
var _1ce=null;
for(var i=_1cd.childNodes.length-1;i>=0;i--){
var c=_1cd.childNodes[i];
if(c.nodeType===1){
var _1cf=c.getAttribute("fixed")||(_1c5.byNode(c)&&_1c5.byNode(c).fixed);
if(_1cf==="bottom"){
_1ce=c;
break;
}
}
}
var dh=_1cc.dataHandlerClass||this.dataHandlerClass;
var ds=_1cc.dataSourceClass||this.dataSourceClass;
var ft=_1cc.fileTypeMapClass||this.fileTypeMapClass;
require([dh,ds,ft],lang.hitch(this,function(_1d0,_1d1,_1d2){
var _1d3=new _1d0(new _1d1(_1cc.data||_1cc.url),_1cd,_1ce);
var _1d4=_1cc.contentType||_1d2.getContentType(_1cc.url)||"html";
_1d3.processData(_1d4,lang.hitch(this,function(id){
if(id){
this.viewMap[_1cc.url]=_1cc.moveTo=id;
if(_1cc.noTransition){
_1c5.byId(id).hide();
}else{
new _1c7(win.body(),_1cc).dispatch();
}
d.resolve(true);
}else{
d.reject("Failed to load "+_1cc.url);
}
}));
}));
return d;
},onStartTransition:function(evt){
evt.preventDefault();
if(!evt.detail){
return;
}
var _1d5=evt.detail;
if(!_1d5.moveTo&&!_1d5.href&&!_1d5.url&&!_1d5.scene){
return;
}
if(_1d5.url&&!_1d5.moveTo){
var _1d6=_1d5.urlTarget;
var w=_1c5.byId(_1d6);
var _1d7=w&&w.containerNode||dom.byId(_1d6);
if(!_1d7){
w=_1c8.getEnclosingView(evt.target);
_1d7=w&&w.domNode.parentNode||win.body();
}
this.openExternalView(_1d5,_1d7);
return;
}else{
if(_1d5.href){
if(_1d5.hrefTarget){
win.global.open(_1d5.href,_1d5.hrefTarget);
}else{
var view;
for(var v=_1c8.getEnclosingView(evt.target);v;v=_1c8.getParentView(v)){
view=v;
}
if(view){
view.performTransition(null,_1d5.transitionDir,_1d5.transition,evt.target,function(){
location.href=_1d5.href;
});
}
}
return;
}else{
if(_1d5.scene){
_1bf.publish("/dojox/mobile/app/pushScene",[_1d5.scene]);
return;
}
}
}
var arr=this.findTransitionViews(_1d5.moveTo),_1d8=arr[0],_1d9=arr[1],_1da=arr[2];
if(!location.hash&&!_1d5.hashchange){
_1c8.initialView=_1d8;
}
if(_1d5.moveTo&&_1d9){
_1d5.moveTo=(_1d5.moveTo.charAt(0)==="#"?"#"+_1d9.id:_1d9.id)+_1da;
}
if(!_1d8||(_1d5.moveTo&&_1d8===_1c5.byId(_1d5.moveTo.replace(/^#?([^&?]+).*/,"$1")))){
return;
}
var src=_1c5.getEnclosingWidget(evt.target);
if(src&&src.callback){
_1d5.context=src;
_1d5.method=src.callback;
}
_1d8.performTransition(_1d5);
}});
_1c9._instance=new _1c9();
_1c9.getInstance=function(){
return _1c9._instance;
};
return _1c9;
});
},"dojo/Stateful":function(){
define(["./_base/declare","./_base/lang","./_base/array","dojo/when"],function(_1db,lang,_1dc,when){
return _1db("dojo.Stateful",null,{_attrPairNames:{},_getAttrNames:function(name){
var apn=this._attrPairNames;
if(apn[name]){
return apn[name];
}
return (apn[name]={s:"_"+name+"Setter",g:"_"+name+"Getter"});
},postscript:function(_1dd){
if(_1dd){
this.set(_1dd);
}
},_get:function(name,_1de){
return typeof this[_1de.g]==="function"?this[_1de.g]():this[name];
},get:function(name){
return this._get(name,this._getAttrNames(name));
},set:function(name,_1df){
if(typeof name==="object"){
for(var x in name){
if(name.hasOwnProperty(x)&&x!="_watchCallbacks"){
this.set(x,name[x]);
}
}
return this;
}
var _1e0=this._getAttrNames(name),_1e1=this._get(name,_1e0),_1e2=this[_1e0.s],_1e3;
if(typeof _1e2==="function"){
_1e3=_1e2.apply(this,Array.prototype.slice.call(arguments,1));
}else{
this[name]=_1df;
}
if(this._watchCallbacks){
var self=this;
when(_1e3,function(){
self._watchCallbacks(name,_1e1,_1df);
});
}
return this;
},_changeAttrValue:function(name,_1e4){
var _1e5=this.get(name);
this[name]=_1e4;
if(this._watchCallbacks){
this._watchCallbacks(name,_1e5,_1e4);
}
return this;
},watch:function(name,_1e6){
var _1e7=this._watchCallbacks;
if(!_1e7){
var self=this;
_1e7=this._watchCallbacks=function(name,_1e8,_1e9,_1ea){
var _1eb=function(_1ec){
if(_1ec){
_1ec=_1ec.slice();
for(var i=0,l=_1ec.length;i<l;i++){
_1ec[i].call(self,name,_1e8,_1e9);
}
}
};
_1eb(_1e7["_"+name]);
if(!_1ea){
_1eb(_1e7["*"]);
}
};
}
if(!_1e6&&typeof name==="function"){
_1e6=name;
name="*";
}else{
name="_"+name;
}
var _1ed=_1e7[name];
if(typeof _1ed!=="object"){
_1ed=_1e7[name]=[];
}
_1ed.push(_1e6);
var _1ee={};
_1ee.unwatch=_1ee.remove=function(){
var _1ef=_1dc.indexOf(_1ed,_1e6);
if(_1ef>-1){
_1ed.splice(_1ef,1);
}
};
return _1ee;
}});
});
},"dojox/mobile/RoundRectCategory":function(){
define(["dojo/_base/declare","dojo/_base/window","dojo/dom-construct","dijit/_Contained","dijit/_WidgetBase"],function(_1f0,win,_1f1,_1f2,_1f3){
return _1f0("dojox.mobile.RoundRectCategory",[_1f3,_1f2],{label:"",tag:"h2",baseClass:"mblRoundRectCategory",buildRendering:function(){
var _1f4=this.domNode=this.containerNode=this.srcNodeRef||_1f1.create(this.tag);
this.inherited(arguments);
if(!this.label&&_1f4.childNodes.length===1&&_1f4.firstChild.nodeType===3){
this.label=_1f4.firstChild.nodeValue;
}
},_setLabelAttr:function(_1f5){
this.label=_1f5;
this.domNode.innerHTML=this._cv?this._cv(_1f5):_1f5;
}});
});
},"dojox/mobile/ToolBarButton":function(){
define(["dojo/_base/declare","dojo/_base/lang","dojo/_base/window","dojo/dom-class","dojo/dom-construct","dojo/dom-style","./sniff","./_ItemBase"],function(_1f6,lang,win,_1f7,_1f8,_1f9,has,_1fa){
return _1f6("dojox.mobile.ToolBarButton",_1fa,{selected:false,arrow:"",light:true,defaultColor:"mblColorDefault",selColor:"mblColorDefaultSel",baseClass:"mblToolBarButton",_selStartMethod:"touch",_selEndMethod:"touch",buildRendering:function(){
if(!this.label&&this.srcNodeRef){
this.label=this.srcNodeRef.innerHTML;
}
this.label=lang.trim(this.label);
this.domNode=(this.srcNodeRef&&this.srcNodeRef.tagName==="SPAN")?this.srcNodeRef:_1f8.create("span");
this.inherited(arguments);
if(this.light&&!this.arrow&&(!this.icon||!this.label)){
this.labelNode=this.tableNode=this.bodyNode=this.iconParentNode=this.domNode;
_1f7.add(this.domNode,this.defaultColor+" mblToolBarButtonBody"+(this.icon?" mblToolBarButtonLightIcon":" mblToolBarButtonLightText"));
return;
}
this.domNode.innerHTML="";
if(this.arrow==="left"||this.arrow==="right"){
this.arrowNode=_1f8.create("span",{className:"mblToolBarButtonArrow mblToolBarButton"+(this.arrow==="left"?"Left":"Right")+"Arrow "+(has("ie")?"":(this.defaultColor+" "+this.defaultColor+"45"))},this.domNode);
_1f7.add(this.domNode,"mblToolBarButtonHas"+(this.arrow==="left"?"Left":"Right")+"Arrow");
}
this.bodyNode=_1f8.create("span",{className:"mblToolBarButtonBody"},this.domNode);
this.tableNode=_1f8.create("table",{cellPadding:"0",cellSpacing:"0",border:"0"},this.bodyNode);
var row=this.tableNode.insertRow(-1);
this.iconParentNode=row.insertCell(-1);
this.labelNode=row.insertCell(-1);
this.iconParentNode.className="mblToolBarButtonIcon";
this.labelNode.className="mblToolBarButtonLabel";
if(this.icon&&this.icon!=="none"&&this.label){
_1f7.add(this.domNode,"mblToolBarButtonHasIcon");
_1f7.add(this.bodyNode,"mblToolBarButtonLabeledIcon");
}
_1f7.add(this.bodyNode,this.defaultColor);
},startup:function(){
if(this._started){
return;
}
this._keydownHandle=this.connect(this.domNode,"onkeydown","_onClick");
this.inherited(arguments);
if(!this._isOnLine){
this._isOnLine=true;
this.set("icon",this._pendingIcon!==undefined?this._pendingIcon:this.icon);
delete this._pendingIcon;
}
},_onClick:function(e){
if(e&&e.type==="keydown"&&e.keyCode!==13){
return;
}
if(this.onClick(e)===false){
return;
}
this.defaultClickAction(e);
},onClick:function(){
},_setLabelAttr:function(text){
this.inherited(arguments);
_1f7.toggle(this.tableNode,"mblToolBarButtonText",text);
},_setSelectedAttr:function(_1fb){
var _1fc=function(node,a,b){
_1f7.replace(node,a+" "+a+"45",b+" "+b+"45");
};
this.inherited(arguments);
if(_1fb){
_1f7.replace(this.bodyNode,this.selColor,this.defaultColor);
if(!has("ie")&&this.arrowNode){
_1fc(this.arrowNode,this.selColor,this.defaultColor);
}
}else{
_1f7.replace(this.bodyNode,this.defaultColor,this.selColor);
if(!has("ie")&&this.arrowNode){
_1fc(this.arrowNode,this.defaultColor,this.selColor);
}
}
_1f7.toggle(this.domNode,"mblToolBarButtonSelected",_1fb);
_1f7.toggle(this.bodyNode,"mblToolBarButtonBodySelected",_1fb);
}});
});
}}});
define("dojox/mobile",[".","dojo/_base/lang","dojox/mobile/_base"],function(_1fd,lang,base){
lang.getObject("mobile",true,_1fd);
return _1fd.mobile;
});
