/*
 * Decompiled with CFR 0.152.
 */
package org.maqetta.server;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.maqetta.server.IStorage;
import org.maqetta.server.IVResource;

public class VFile
implements IVResource {
    protected IStorage file = null;
    protected boolean isWorkingCopy;
    protected String virtualPath;
    protected IStorage workingCopy;
    protected IVResource parent;

    public VFile(IStorage file, IVResource parent, String virtualPath) {
        if (virtualPath != null && virtualPath.indexOf(".workingcopy") > 0) {
            this.workingCopy = file;
            Path path = new Path(file.getPath());
            this.file = file.newInstance(path.removeFileExtension().toString());
            this.virtualPath = virtualPath.replace(".workingcopy", "");
        } else {
            this.file = file;
            this.virtualPath = virtualPath;
            this.workingCopy = this.getWorkingCopy(file);
        }
        this.parent = parent;
    }

    public boolean hasSource() {
        return false;
    }

    public boolean isSource() {
        return this.parent != null && this.parent.isSource();
    }

    public IVResource getSource() {
        return this;
    }

    public VFile(IStorage file, IVResource parent) {
        this(file, parent, "");
    }

    public VFile(IStorage file) {
        this(file, null, file.getPath());
    }

    public IStorage getFile() {
        if (this.workingCopy.exists()) {
            return this.workingCopy;
        }
        return this.file;
    }

    protected IStorage getWorkingCopy(IStorage original) {
        IStorage parent = original.getParentFile();
        IStorage workingCopy = parent != null ? original.newInstance(parent, String.valueOf(original.getName()) + ".workingcopy") : original.newInstance(String.valueOf(original.getName()) + ".workingcopy");
        return workingCopy;
    }

    public boolean exists() {
        return this.file.exists() || this.workingCopy.exists();
    }

    public boolean isDirty() {
        return this.workingCopy.exists();
    }

    public String toString() {
        return this.getPath();
    }

    public URLConnection openConnection() throws MalformedURLException, IOException {
        return this.getFile().toURI().toURL().openConnection();
    }

    public String getPath() {
        if (this.parent == null) {
            return this.virtualPath;
        }
        return new Path(this.parent.getPath()).append(this.virtualPath).toString();
    }

    public void createNewInstance() throws IOException {
        this.workingCopy.createNewFile();
    }

    private boolean deleteDirectory(IStorage path) throws IOException {
        if (path.exists()) {
            IStorage[] files = path.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    this.deleteDirectory(files[i]);
                } else {
                    files[i].delete();
                }
                ++i;
            }
        }
        return path.delete();
    }

    public boolean delete() throws IOException {
        IStorage target = null;
        target = this.workingCopy.exists() ? this.workingCopy : this.file;
        if (target.isDirectory()) {
            return this.deleteDirectory(target);
        }
        return target.delete();
    }

    public OutputStream getOutputStreem() throws IOException {
        if (!this.workingCopy.exists()) {
            this.workingCopy.createNewFile();
        }
        return new BufferedOutputStream(this.workingCopy.getOutputStream());
    }

    public InputStream getInputStreem() throws IOException {
        return new BufferedInputStream(this.getFile().getInputStream());
    }

    public IVResource[] listFiles() {
        IStorage[] list = this.file.listFiles();
        Hashtable<String, VFile> results = new Hashtable<String, VFile>();
        int i = 0;
        while (i < list.length) {
            VFile resource = new VFile(list[i], this, list[i].getName());
            results.put(resource.getPath(), resource);
            ++i;
        }
        Collection c = results.values();
        return c.toArray(new IVResource[c.size()]);
    }

    public String getName() {
        if (this.virtualPath == null) {
            return ".";
        }
        if (this.parent == null) {
            return ".";
        }
        String name = this.virtualPath;
        if (name != null && name.length() > 0 && name.charAt(name.length() - 1) == '/') {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public URI getURI() throws URISyntaxException {
        return this.file.toURI();
    }

    public boolean mkdir() throws IOException {
        return this.file.mkdirs();
    }

    protected static boolean wildCardMatch(String text, String pattern) {
        String[] cards;
        String[] stringArray = cards = pattern.split("\\*");
        int n = cards.length;
        int n2 = 0;
        while (n2 < n) {
            String card = stringArray[n2];
            int idx = text.indexOf(card);
            if (idx + card.length() < text.length() && card.length() > 0) {
                return false;
            }
            if (idx == -1) {
                return false;
            }
            text = text.substring(idx + card.length());
            ++n2;
        }
        return true;
    }

    public IVResource[] find(String pattern) {
        if (!this.isDirectory()) {
            if (VFile.wildCardMatch(this.getName(), pattern)) {
                return new IVResource[]{this};
            }
            return new IVResource[0];
        }
        ArrayList<IVResource> found = new ArrayList<IVResource>();
        IVResource[] children = this.listFiles();
        int i = 0;
        while (i < children.length) {
            found.addAll(Arrays.asList(children[i].find(pattern)));
            ++i;
        }
        return found.toArray(new IVResource[found.size()]);
    }

    public IVResource create(String path) throws IOException {
        if (!this.isDirectory()) {
            return null;
        }
        IPath a = new Path(this.file.getAbsolutePath()).append(path);
        boolean directory = path.charAt(path.length() - 1) == '/';
        String[] segments = a.segments();
        Path me = new Path(this.file.getAbsolutePath());
        VFile parent = this;
        int i = me.matchingFirstSegments(a);
        while (i < segments.length) {
            int segsToEnd = segments.length - i - 1;
            IStorage f = this.file.newInstance(a.removeLastSegments(segsToEnd).toString());
            if (i + 1 == segments.length && directory) {
                f.mkdir();
            }
            parent = new VFile(f, parent, segments[i]);
            ++i;
        }
        return parent;
    }

    public boolean isVirtual() {
        return false;
    }

    public void flushWorkingCopy() throws IOException {
        if (this.workingCopy.exists()) {
            this.file.delete();
            this.workingCopy.renameTo(this.file);
        }
    }

    public void removeWorkingCopy() throws IOException {
        this.workingCopy.delete();
    }

    public IVResource[] getParents() {
        IVResource parent = this.parent;
        ArrayList<IVResource> parents = new ArrayList<IVResource>();
        while (parent != null) {
            parents.add(0, parent);
            parent = parent.getParent();
        }
        return parents.toArray(new IVResource[parents.size()]);
    }

    public IVResource getParent() {
        return this.parent;
    }

    public void setParent(IVResource parent) {
        this.parent = parent;
    }

    public void add(IVResource v) {
    }

    public IVResource get(String childName) {
        return null;
    }

    public boolean isNew() {
        return !this.file.exists() && this.workingCopy.exists();
    }

    public boolean readOnly() {
        if (this.parent != null) {
            return this.parent.readOnly();
        }
        return false;
    }

    public IVResource[] findChildren(String childName) {
        return this.find(childName);
    }
}

