/*
 * Decompiled with CFR 0.152.
 */
package org.davinci.server.review.cache;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.davinci.server.review.Comment;
import org.davinci.server.review.CommentsDocument;
import org.davinci.server.review.Utils;
import org.davinci.server.review.Version;
import org.davinci.server.review.persistence.Marshaller;
import org.davinci.server.review.persistence.Unmarshaller;
import org.davinci.server.user.IDavinciProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReviewCacheManager
extends Thread {
    public static final ReviewCacheManager $ = new ReviewCacheManager();
    private static final Logger theLogger = Logger.getLogger(ReviewCacheManager.class.getName());
    private static final String LAST_ACCESS_TIME = "lastAccessTime";
    private static final long DESTROY_TIME = 600000L;
    private static final long SLEEP_TIME = 30000L;
    private Hashtable<IDavinciProject, Hashtable<String, Comment>> reviewFilePool = new Hashtable();
    private volatile boolean stop = false;

    private ReviewCacheManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateComments(List<Comment> comments) {
        for (Comment comment : comments) {
            IDavinciProject project;
            IDavinciProject iDavinciProject = project = comment.getProject();
            synchronized (iDavinciProject) {
                Hashtable<String, Comment> reviewHash = this.loadReviewFile(project);
                if (reviewHash == null) {
                    theLogger.severe("Can't find project " + project.getProjectName() + " review file for comment " + comment.getId());
                    continue;
                }
                reviewHash.put(comment.getId(), comment);
                this.updateLastAccessTime(project);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Comment> getCommentsByPageName(IDavinciProject project, String pageName) {
        Hashtable<String, Comment> reviewHash = this.loadReviewFile(project);
        LinkedList<Comment> result = new LinkedList<Comment>();
        if (reviewHash == null) {
            return result;
        }
        Set<Map.Entry<String, Comment>> entries = reviewHash.entrySet();
        IDavinciProject iDavinciProject = project;
        synchronized (iDavinciProject) {
            for (Map.Entry<String, Comment> entry : entries) {
                if (LAST_ACCESS_TIME.equals(entry.getKey()) || pageName != null && !"".equals(pageName) && !pageName.equals(entry.getValue().getPageName())) continue;
                result.add(entry.getValue());
            }
        }
        this.updateLastAccessTime(project);
        return result;
    }

    public Comment getComment(IDavinciProject project, String commentId) {
        Hashtable<String, Comment> reviewHash = this.loadReviewFile(project);
        if (reviewHash == null) {
            return null;
        }
        this.updateLastAccessTime(project);
        return reviewHash.get(commentId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateLastAccessTime(IDavinciProject project) {
        if (project == null) {
            return false;
        }
        IDavinciProject iDavinciProject = project;
        synchronized (iDavinciProject) {
            Hashtable<String, Comment> reviewHash;
            block5: {
                reviewHash = this.reviewFilePool.get(project);
                if (reviewHash != null) break block5;
                return true;
            }
            Comment lastAccessTime = new Comment();
            lastAccessTime.setCreated(new Date(System.currentTimeMillis()));
            reviewHash.put(LAST_ACCESS_TIME, lastAccessTime);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hashtable<String, Comment> loadReviewFile(IDavinciProject project) {
        Hashtable<String, Comment> reviewHash;
        if (project == null) {
            return null;
        }
        IDavinciProject iDavinciProject = project;
        synchronized (iDavinciProject) {
            reviewHash = this.reviewFilePool.get(project);
        }
        if (reviewHash != null) {
            return reviewHash;
        }
        Unmarshaller unmarshaller = new Unmarshaller();
        CommentsDocument document = null;
        IDavinciProject iDavinciProject2 = project;
        synchronized (iDavinciProject2) {
            document = unmarshaller.unmarshall(project);
            List<Comment> commentList = document.getCommentList();
            reviewHash = new Hashtable();
            for (Comment comment : commentList) {
                reviewHash.put(comment.getId(), comment);
            }
            this.reviewFilePool.put(project, reviewHash);
        }
        this.updateLastAccessTime(project);
        return reviewHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean persistReviewFile(IDavinciProject project) {
        if (project == null) {
            return false;
        }
        Hashtable<String, Comment> reviewHash = this.reviewFilePool.get(project);
        if (reviewHash == null) {
            return false;
        }
        CommentsDocument doc = project.getCommentsDocument();
        if (doc == null) {
            doc = new CommentsDocument(project);
            project.setCommentsDocument(doc);
        }
        Comment lastAccessTime = reviewHash.get(LAST_ACCESS_TIME);
        reviewHash.remove(LAST_ACCESS_TIME);
        doc.setCommentList(new ArrayList<Comment>(reviewHash.values()));
        Marshaller marshaller = new Marshaller(project);
        IDavinciProject iDavinciProject = project;
        synchronized (iDavinciProject) {
            try {
                marshaller.marshall(false);
                reviewHash.put(LAST_ACCESS_TIME, lastAccessTime);
                return true;
            }
            catch (Throwable throwable) {
                try {
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearReviewByProject(IDavinciProject project) {
        Hashtable<String, Comment> reviewHash = this.reviewFilePool.get(project);
        if (reviewHash == null) {
            return true;
        }
        IDavinciProject iDavinciProject = project;
        synchronized (iDavinciProject) {
            Comment lastAccessTime = reviewHash.get(LAST_ACCESS_TIME);
            lastAccessTime.setCreated(new Date(0L));
            reviewHash.clear();
            reviewHash.put(LAST_ACCESS_TIME, lastAccessTime);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean destroyReviewFile(IDavinciProject project, boolean forced) {
        if (project == null) {
            return false;
        }
        Hashtable<String, Comment> reviewHash = this.reviewFilePool.get(project);
        if (reviewHash == null) {
            return true;
        }
        Comment lastAccessTime = reviewHash.get(LAST_ACCESS_TIME);
        if (System.currentTimeMillis() - lastAccessTime.getCreated().getTime() > 600000L || forced) {
            IDavinciProject iDavinciProject = project;
            synchronized (iDavinciProject) {
                this.persistReviewFile(project);
                reviewHash.clear();
            }
            return true;
        }
        return false;
    }

    public boolean destroyAllReview() {
        Set<IDavinciProject> keys = this.reviewFilePool.keySet();
        Iterator<IDavinciProject> it = keys.iterator();
        while (it.hasNext()) {
            IDavinciProject project = it.next();
            this.destroyReviewFile(project, true);
            it.remove();
        }
        return true;
    }

    @Override
    public void run() {
        while (!this.stop) {
            try {
                Thread.sleep(30000L);
                this.recycle();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void recycle() {
        Set<IDavinciProject> keySet = this.reviewFilePool.keySet();
        Iterator<IDavinciProject> it = keySet.iterator();
        while (it.hasNext()) {
            IDavinciProject prj = it.next();
            if (this.destroyReviewFile(prj, false)) continue;
            this.persistReviewFile(prj);
            it.remove();
        }
    }

    public void markStop() {
        this.stop = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean republish(IDavinciProject project, String parentVersion, Version version) {
        IDavinciProject iDavinciProject = project;
        synchronized (iDavinciProject) {
            Hashtable<String, Comment> reviewHash;
            block11: {
                reviewHash = this.loadReviewFile(project);
                if (reviewHash != null) break block11;
                return false;
            }
            Set<Map.Entry<String, Comment>> entries = reviewHash.entrySet();
            HashMap<String, Comment> tmpReview = new HashMap<String, Comment>();
            for (Map.Entry<String, Comment> entry : entries) {
                String[] parts;
                Comment oldOne;
                if (LAST_ACCESS_TIME.equals(entry.getKey()) || !parentVersion.equals((oldOne = entry.getValue()).getPageVersion())) continue;
                Comment newOne = (Comment)Utils.deepClone(oldOne);
                String str = newOne.getId();
                String drawingJson = newOne.getDrawingJson();
                if (str.contains("_")) {
                    parts = str.split("_");
                    str = String.valueOf(parts[0]) + '_' + (Integer.parseInt(parts[1]) + 1);
                } else {
                    str = String.valueOf(str) + "_1";
                }
                drawingJson = drawingJson.replace(newOne.getId(), str);
                newOne.setDrawingJson(drawingJson);
                newOne.setId(str);
                str = newOne.getReplyTo();
                if (!"0".equals(str)) {
                    if (str.contains("_")) {
                        parts = str.split("_");
                        str = String.valueOf(parts[0]) + '_' + (Integer.parseInt(parts[1]) + 1);
                    } else {
                        str = String.valueOf(str) + "_1";
                    }
                }
                newOne.setReplyTo(str);
                str = newOne.getPageName();
                if (str != null) {
                    parts = str.split("/");
                    newOne.setPageName(String.valueOf(parts[0]) + '/' + parts[1] + '/' + version.getTime() + '/' + parts[3] + '/' + parts[4]);
                }
                tmpReview.put(newOne.getId(), newOne);
            }
            reviewHash.putAll(tmpReview);
        }
        return true;
    }
}

