/*
 * Decompiled with CFR 0.152.
 */
package org.davinci.server.review;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.SimpleTimeZone;
import org.davinci.server.review.user.Reviewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Version {
    private boolean hasClosedManually = false;
    private static final SimpleDateFormat formatter;
    private static final SimpleDateFormat shortFormatter;
    private String versionID;
    private String versionTitle;
    private String time;
    private boolean isDraft;
    private Calendar dueDate;
    private int desireWidth;
    private int desireHeight;
    private String restartFrom = "0";
    private String description = "";
    private boolean receiveEmail = true;
    private boolean hasRestarted = false;
    public List<String> resources = Collections.synchronizedList(new ArrayList());
    List<Reviewer> reviewers = Collections.synchronizedList(new ArrayList());

    static {
        Calendar gmt = Calendar.getInstance(new SimpleTimeZone(0, "GMT"));
        shortFormatter = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        shortFormatter.setCalendar(gmt);
        formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        formatter.setCalendar(gmt);
    }

    public Version(String versionID, String time, boolean isDraft, String dueDate, String width, String height) {
        this.versionID = versionID;
        this.time = time;
        this.isDraft = isDraft;
        this.dueDate = this.s2Date(dueDate);
        this.desireWidth = width == null ? 0 : Integer.parseInt(width);
        this.desireHeight = height == null ? 0 : Integer.parseInt(height);
    }

    private Calendar s2Date(String time) {
        Calendar result = Calendar.getInstance();
        if (time.equals("infinite")) {
            result.setTimeInMillis(Long.MAX_VALUE);
            return result;
        }
        try {
            result.setTime(formatter.parse(time));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return result;
    }

    public Calendar getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Calendar dueDate) {
        this.dueDate = dueDate;
    }

    public void setDueDate(String sDueDate) {
        this.dueDate = this.s2Date(sDueDate);
    }

    public int getDesireWidth() {
        return this.desireWidth;
    }

    public void setDesireWidth(int desireWidth) {
        this.desireWidth = desireWidth;
    }

    public void setDesireWidth(String width) {
        this.desireWidth = width == null ? 0 : Integer.parseInt(width);
    }

    public void setDesireHeight(String height) {
        this.desireHeight = height == null ? 0 : Integer.parseInt(height);
    }

    public int getDesireHeight() {
        return this.desireHeight;
    }

    public void setDesireHeight(int desireHeight) {
        this.desireHeight = desireHeight;
    }

    public String dueDateString() {
        if (this.dueDate.getTimeInMillis() == Long.MAX_VALUE) {
            return "infinite";
        }
        return formatter.format(this.dueDate.getTime());
    }

    public boolean isDraft() {
        return this.isDraft;
    }

    public void setDraft(boolean isDraft) {
        this.isDraft = isDraft;
    }

    public List<String> getResources() {
        return this.resources;
    }

    public void setResources(List<String> resources) {
        this.resources = resources;
    }

    public String getTime() {
        return this.time;
    }

    public String getVersionID() {
        return this.versionID;
    }

    public void setVersionID(String versionID) {
        this.versionID = versionID;
    }

    public void setVersionTitle(String versionTitle) {
        this.versionTitle = versionTitle;
    }

    public String getVersionTitle() {
        return this.versionTitle;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public void setResource(String[] paths) {
        this.resources = Collections.synchronizedList(new ArrayList());
        if (paths != null) {
            String[] stringArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                this.addResource(path);
                ++n2;
            }
        }
    }

    public void addResource(String path) {
        this.resources.add(path);
    }

    public void addReviewer(Reviewer reviewer) {
        this.reviewers.add(reviewer);
    }

    public void setReviewers(List<Reviewer> reviewers) {
        this.reviewers = reviewers;
    }

    public List<Reviewer> getReviewers() {
        return this.reviewers;
    }

    public boolean containsUser(String userEmail) {
        for (Reviewer reviewer : this.reviewers) {
            if (!reviewer.getEmail().equals(userEmail)) continue;
            return true;
        }
        return false;
    }

    public void closeVersion() {
        this.hasClosedManually = true;
    }

    public void openVersion() {
        this.hasClosedManually = false;
    }

    public boolean isClosed() {
        if (this.hasClosedManually) {
            return true;
        }
        Calendar current = Calendar.getInstance();
        current.add(5, -1);
        return current.compareTo(this.dueDate) > 0;
    }

    public boolean isHasClosedManually() {
        return this.hasClosedManually;
    }

    public void setHasClosedManually(boolean hasClosedManually) {
        this.hasClosedManually = hasClosedManually;
    }

    public String getRestartFrom() {
        return this.restartFrom;
    }

    public void setRestartFrom(String restartFrom) {
        this.restartFrom = restartFrom;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isReceiveEmail() {
        return this.receiveEmail;
    }

    public void setReceiveEmail(boolean receiveEmail) {
        this.receiveEmail = receiveEmail;
    }

    public boolean isHasRestarted() {
        return this.hasRestarted;
    }

    public void setHasRestarted(boolean hasRestarted) {
        this.hasRestarted = hasRestarted;
    }

    public static boolean isValidISOTimeStamp(String timeStamp) {
        boolean result = false;
        try {
            shortFormatter.parse(timeStamp);
            result = true;
        }
        catch (ParseException parseException) {
            try {
                formatter.parse(timeStamp);
                result = true;
            }
            catch (ParseException parseException2) {}
        }
        return result;
    }
}

