/*
 * Decompiled with CFR 0.152.
 */
package org.davinci.server.review;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static Properties templateProperties = new Properties();
    private static final String START_FLAG = "${";
    private static final String END_FLAG = "}";

    static {
        try {
            templateProperties.load(new Utils().getClass().getClassLoader().getResourceAsStream("review.properties"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Object deepClone(Object obj) {
        Object object;
        ObjectOutputStream oos = null;
        ObjectInputStream ois = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.flush();
            ByteArrayInputStream bin = new ByteArrayInputStream(bos.toByteArray());
            ois = new ObjectInputStream(bin);
            object = ois.readObject();
            Utils.close(oos);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        finally {
            Utils.close(oos);
            Utils.close(ois);
        }
        Utils.close(ois);
        return object;
    }

    public static void close(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void close(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isBlank(String str) {
        return str == null || str.length() == 0 || str.trim().length() == 0;
    }

    public static Properties getTemplates() {
        return templateProperties;
    }

    public static String substitute(String s, Map<String, String> map) {
        int end;
        int start;
        StringBuilder ret = new StringBuilder(s.length());
        int pos = 0;
        while ((start = s.indexOf(START_FLAG, pos)) != -1 && (end = s.indexOf(END_FLAG, start)) != -1) {
            ret.append(s.substring(pos, start)).append(map.get(s.substring(start + START_FLAG.length(), end)));
            pos = end + END_FLAG.length();
        }
        ret.append(s.substring(pos, s.length()));
        return ret.toString();
    }
}

