/*
 * Decompiled with CFR 0.152.
 */
package org.davinci.server.internal;

import java.util.ArrayList;
import org.davinci.server.internal.IRegistryListener;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator,
ServiceTrackerCustomizer,
IRegistryChangeListener {
    static Activator theActivator;
    Bundle bundle;
    private BundleContext context;
    private PackageAdmin packageAdmin;
    private IExtensionRegistry registry;
    private ServiceTracker packageAdminTracker;
    private ServiceTracker registryTracker;
    private ArrayList registryChangeListeners = new ArrayList();

    public static Activator getActivator() {
        return theActivator;
    }

    public Activator() {
        theActivator = this;
    }

    public void start(BundleContext context) throws Exception {
        this.context = context;
        this.bundle = context.getBundle();
        this.packageAdminTracker = new ServiceTracker(context, PackageAdmin.class.getName(), (ServiceTrackerCustomizer)this);
        this.packageAdminTracker.open();
        this.registryTracker = new ServiceTracker(context, IExtensionRegistry.class.getName(), (ServiceTrackerCustomizer)this);
        this.registryTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        this.context = context;
    }

    public Object addingService(ServiceReference reference) {
        Object service = this.context.getService(reference);
        if (service instanceof PackageAdmin && this.packageAdmin == null) {
            this.packageAdmin = (PackageAdmin)service;
        }
        if (service instanceof IExtensionRegistry && this.registry == null) {
            this.registry = (IExtensionRegistry)service;
            this.registryChanged(null);
            this.registry.addRegistryChangeListener((IRegistryChangeListener)this, "maqetta.core.server");
        }
        return service;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        if (service == this.packageAdmin) {
            this.packageAdmin = null;
        }
        if (service == this.registry) {
            this.registry = null;
        }
    }

    public IExtensionRegistry getRegistry() {
        return this.registry;
    }

    public void addRegistryChangeListener(IRegistryListener listener) {
        this.registryChangeListeners.add(listener);
    }

    public Bundle getOtherBundle(String symbolicName) {
        Bundle[] bundles = this.packageAdmin.getBundles(symbolicName, null);
        if (bundles == null) {
            return null;
        }
        int i = 0;
        while (i < bundles.length) {
            if ((bundles[i].getState() & 3) == 0) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    public void registryChanged(IRegistryChangeEvent event) {
        for (IRegistryListener listener : this.registryChangeListeners) {
            listener.registryChanged();
        }
    }
}

