/*
 * Decompiled with CFR 0.152.
 */
package org.davinci.ajaxLibrary;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import org.davinci.ajaxLibrary.ILibraryFinder;
import org.davinci.ajaxLibrary.ILibraryManager;
import org.davinci.ajaxLibrary.Library;
import org.davinci.server.internal.Activator;
import org.davinci.server.internal.IRegistryListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.maqetta.server.ServerManager;
import org.osgi.framework.Bundle;

public class LibraryManager
implements ILibraryManager {
    private static final Logger theLogger = Logger.getLogger(LibraryManager.class.getName());
    private Library[] installedLibraries;
    private ILibraryFinder[] libFinders;

    public LibraryManager() {
        this.initialize();
        Activator.getActivator().addRegistryChangeListener(new IRegistryListener(){

            public void registryChanged() {
                LibraryManager.this.initialize();
            }
        });
    }

    Library findLibrary(String id, String version) {
        int i = 0;
        while (i < this.installedLibraries.length) {
            if (this.installedLibraries[i] != null && this.installedLibraries[i].getID().equals(id) && this.installedLibraries[i].getVersion().equals(version)) {
                return this.installedLibraries[i];
            }
            ++i;
        }
        return null;
    }

    public String getDefaultRoot(String id, String version) {
        Library l = this.findLibrary(id, version);
        return l.defaultRoot;
    }

    public ILibraryFinder[] getLibraryFinders() {
        if (this.libFinders == null) {
            Vector<Object> libs = new Vector<Object>();
            List<IConfigurationElement> libraryElements = ServerManager.getServerManager().getExtensions("libraryFinder", "libraryFinder");
            if (libraryElements != null) {
                int i = 0;
                while (i < libraryElements.size()) {
                    try {
                        Object o = libraryElements.get(i).createExecutableExtension("class");
                        if (o != null) {
                            libs.add(o);
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
            }
            this.libFinders = libs.toArray(new ILibraryFinder[libs.size()]);
        }
        return this.libFinders;
    }

    void initialize() {
        List<IConfigurationElement> extensions = ServerManager.getServerManager().getExtensions("ajaxLibrary", "ajaxLibrary");
        this.installedLibraries = new Library[extensions.size()];
        int count = -1;
        Iterator<IConfigurationElement> iterator = extensions.iterator();
        while (iterator.hasNext()) {
            Library libInfo;
            ++count;
            IConfigurationElement libraryElement = iterator.next();
            String id = libraryElement.getAttribute("id");
            String version = libraryElement.getAttribute("version");
            if (id == null || version == null || id.equals("") || version.equals("")) {
                System.err.println("Problem reading library data, no ID or Version defined :" + libraryElement.getName());
            }
            if ((libInfo = this.findLibrary(id, version)) == null) {
                this.installedLibraries[count] = libInfo = new BundleLibraryInfo(id, version);
            }
            String required = libraryElement.getAttribute("required");
            ((BundleLibraryInfo)libInfo).setRequired(required);
            IConfigurationElement[] libraryPathElements = libraryElement.getChildren("libraryPath");
            int i = 0;
            while (i < libraryPathElements.length) {
                String virtualPath = libraryPathElements[i].getAttribute("name");
                String bundlePath = libraryPathElements[i].getAttribute("location");
                String source = libraryPathElements[i].getAttribute("source");
                ((BundleLibraryInfo)libInfo).setBasePath(bundlePath, virtualPath, source);
                ++i;
            }
            if (libInfo instanceof BundleLibraryInfo) {
                ((BundleLibraryInfo)libInfo).bundleBase = this.getLibraryBundle(libraryElement);
            }
            IConfigurationElement[] meta = libraryElement.getChildren("metadata");
            int i2 = 0;
            while (i2 < meta.length) {
                libInfo.setMetadataPath(meta[i2].getAttribute("location"));
                ++i2;
            }
        }
    }

    private Bundle getLibraryBundle(IConfigurationElement configElement) {
        String name = configElement.getDeclaringExtension().getContributor().getName();
        return Activator.getActivator().getOtherBundle(name);
    }

    public Library[] getAllLibraries() {
        return this.installedLibraries;
    }

    public Library getLibrary(String id, String version) {
        int i = 0;
        while (i < this.installedLibraries.length) {
            if (this.installedLibraries[i].getID().equals(id) && this.installedLibraries[i].getVersion().equals(version)) {
                return this.installedLibraries[i];
            }
            ++i;
        }
        return null;
    }

    class BundleLibraryInfo
    extends Library {
        Bundle bundleBase;
        String basePath;

        BundleLibraryInfo(String ID, String version, String basePath, String defaultRoot, URL bundleBase) {
            this.ID = ID;
            this.version = version;
            this.basePath = basePath;
        }

        BundleLibraryInfo(String id, String version) {
            this.ID = id;
            this.version = version;
        }

        public void setBasePath(String basePath, String defaultRoot, String source) {
            this.basePath = basePath;
            this.defaultRoot = defaultRoot;
            this.sourcePath = source;
        }

        public URL[] find(String path, boolean recurse, boolean useSource) {
            IPath p1 = null;
            p1 = useSource ? new Path(this.sourcePath).append(path) : new Path(this.basePath).append(path);
            String name = p1.lastSegment();
            IPath newBase = p1.removeLastSegments(1);
            Enumeration e = this.bundleBase.findEntries(newBase.toString(), name, recurse);
            Vector found = new Vector();
            while (e != null && e.hasMoreElements()) {
                found.add(e.nextElement());
            }
            return found.toArray(new URL[found.size()]);
        }

        private URL getUri(String base, String path) {
            Path basePath = new Path(base);
            IPath fullPath = basePath.append(path);
            URL entry = this.bundleBase.getEntry(fullPath.toString());
            if (entry == null) {
                theLogger.severe("Library file not found! :" + fullPath);
            }
            return entry;
        }

        private URL[] listUri(String base, String path) {
            Path basePath = new Path(base);
            IPath fullPath = basePath.append(path);
            Vector results = new Vector();
            Enumeration e = this.bundleBase.findEntries(fullPath.toString(), "*", false);
            while (e.hasMoreElements()) {
                results.add(e.nextElement());
            }
            return results.toArray(new URL[results.size()]);
        }

        public String getMetadata() throws IOException {
            if (this.metadataPath == null) {
                return "";
            }
            URL metadata = this.bundleBase.getEntry(String.valueOf(this.metadataPath) + "/widgets.json");
            BufferedInputStream stream = null;
            StringBuffer out = new StringBuffer();
            try {
                int n;
                stream = new BufferedInputStream(metadata.openStream());
                byte[] b = new byte[4096];
                while ((n = ((InputStream)stream).read(b)) != -1) {
                    out.append(new String(b, 0, n));
                }
            }
            finally {
                if (stream != null) {
                    ((InputStream)stream).close();
                }
            }
            return out.toString();
        }

        public URL getURL(String path, boolean useSource) {
            if (useSource) {
                return this.getUri(this.sourcePath, path);
            }
            return this.getUri(this.basePath, path);
        }

        public URL[] listURL(String path, boolean useSource) {
            if (useSource) {
                return this.listUri(this.sourcePath, path);
            }
            return this.listUri(this.basePath, path);
        }

        public URL getSourceURL(String path) {
            return this.getUri(this.sourcePath, path);
        }
    }
}

