/*
 * Decompiled with CFR 0.152.
 */
package maqetta.core.server.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.davinci.server.util.XMLFile;
import org.maqetta.server.ILink;
import org.maqetta.server.ILinks;
import org.maqetta.server.IStorage;
import org.w3c.dom.Element;

public class Links
extends XMLFile
implements ILinks {
    public static final int SYSTEM_PATH = 1;
    static final String STR_SYSTEM_PATH = "systemPath";
    ILink[] links;
    IStorage linksFile;

    public Links(IStorage dir) {
        this.linksFile = dir.newInstance(dir, "links.settings");
        ArrayList list = this.load(this.linksFile);
        this.links = list.toArray(new ILink[list.size()]);
    }

    public List findLinks(String path) {
        if (path.startsWith("./")) {
            path = path.substring(2);
        } else if (path.charAt(0) == '.') {
            path = path.substring(1);
        }
        ArrayList<ILink> list = new ArrayList<ILink>();
        int i = 0;
        while (i < this.links.length) {
            ILink cfr_ignored_0 = this.links[i];
            if (ILink.parentPath.equals(path)) {
                list.add(this.links[i]);
            }
            ++i;
        }
        return list;
    }

    public ILink isLinkTarget(String path) {
        int i = 0;
        while (i < this.links.length) {
            ILink cfr_ignored_0 = this.links[i];
            if (ILink.location.equals(path)) {
                return this.links[i];
            }
            ++i;
        }
        return null;
    }

    public String findPath(String path) {
        int i = 0;
        while (i < this.links.length) {
            ILink cfr_ignored_0 = this.links[i];
            if (ILink.path.equals(path)) {
                ILink cfr_ignored_1 = this.links[i];
                return ILink.location;
            }
            ++i;
        }
        return null;
    }

    public ILink hasLink(String path) {
        int i = 0;
        while (i < this.links.length) {
            ILink cfr_ignored_0 = this.links[i];
            if (path.startsWith(ILink.path)) {
                return this.links[i];
            }
            ++i;
        }
        return null;
    }

    public boolean addLink(String path, String location, int type) throws IOException {
        String loc = this.findPath(path);
        if (loc != null) {
            return false;
        }
        Link link = new Link(path, location, type);
        Link[] newLinks = new Link[this.links.length + 1];
        System.arraycopy(this.links, 0, newLinks, 0, this.links.length);
        newLinks[this.links.length] = link;
        this.links = newLinks;
        this.save();
        return true;
    }

    public ILink[] allLinks() {
        return this.links;
    }

    public boolean removeLink(String path) throws IOException {
        int i = 0;
        while (i < this.links.length) {
            ILink cfr_ignored_0 = this.links[i];
            if (ILink.path.equals(path)) {
                Link[] newLinks = new Link[this.links.length - 1];
                System.arraycopy(this.links, 0, newLinks, 0, i);
                System.arraycopy(this.links, i + 1, newLinks, i, this.links.length - 1 - i);
                this.links = newLinks;
                this.save();
                return true;
            }
            ++i;
        }
        return false;
    }

    private void save() throws IOException {
        this.save(this.linksFile, Arrays.asList(this.links));
    }

    protected Object createObject(Element element, String[] attributeNames, String[] attributes) {
        int type = 0;
        if (STR_SYSTEM_PATH.equals(attributes[2])) {
            type = 1;
        }
        Link link = new Link(attributes[0], attributes[1], type);
        return link;
    }

    protected String[] getAttributeNames() {
        return new String[]{"path", "location", "type"};
    }

    protected String[] getAttributeValues(Object object) {
        Link link = (Link)object;
        String linkAttr = null;
        if (link.type == 1) {
            linkAttr = STR_SYSTEM_PATH;
        }
        return new String[]{link.path, link.location, linkAttr};
    }

    protected String getElementTag() {
        return "link";
    }

    protected String getRootTag() {
        return "links";
    }

    protected String getAttributeValue(String attribute, Object object) {
        Link link = (Link)object;
        if (attribute.equalsIgnoreCase("path")) {
            return link.path;
        }
        if (attribute.equalsIgnoreCase("location")) {
            return link.location;
        }
        if (attribute.equalsIgnoreCase("type")) {
            String linkAttr = null;
            if (link.type == 1) {
                linkAttr = STR_SYSTEM_PATH;
            }
            return linkAttr;
        }
        return null;
    }

    public static class Link
    implements ILink {
        public String path;
        public String location;
        int type;
        public String parentPath;
        public String name;

        Link(String path, String location, int type) {
            this.path = path;
            this.location = location.trim();
            this.type = type;
            int inx = this.path.lastIndexOf(47);
            if (inx < 0) {
                this.parentPath = "";
                this.name = path;
            } else {
                this.parentPath = this.path.substring(0, inx);
                this.name = this.path.substring(inx + 1);
            }
        }
    }
}

