/*
 * Decompiled with CFR 0.152.
 */
package maqetta.core.server.command;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.davinci.ajaxLibrary.Library;
import org.davinci.server.user.IUser;
import org.davinci.server.util.JSONReader;
import org.davinci.server.util.JSONWriter;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.maqetta.server.Command;
import org.maqetta.server.IVResource;
import org.maqetta.server.ServerManager;
import org.maqetta.server.VLibraryResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Download
extends Command {
    private static final Logger theLogger = Logger.getLogger(Download.class.getName());
    private Vector<String> zippedEntries;
    private URL buildURL = null;
    public static final String DOWNLOAD_FILE_REPLACE_REGEXP = "[^a-zA-z0-9_.]";
    public static String buildBase = "http://build.dojotoolkit.org";

    public Download() {
        String builderProp = ServerManager.getServerManager().getDavinciProperty("maqetta.dojoWebBuilder");
        if (builderProp != null) {
            buildBase = builderProp;
        }
    }

    @Override
    public void handleCommand(HttpServletRequest req, HttpServletResponse resp, IUser user) throws IOException {
        if (user == null) {
            return;
        }
        this.zippedEntries = new Vector();
        String path = req.getParameter("fileName");
        path = this.sanitizeFileName(path);
        String res = req.getParameter("resources");
        String libs = req.getParameter("libs");
        String root = req.getParameter("root");
        String build = req.getParameter("build");
        boolean useFullSource = "1".equals(req.getParameter("fullsource"));
        if (build != null) {
            this.buildURL = this.getBuildURL(user, req.getRequestURL().toString());
        }
        ArrayList o = (ArrayList)JSONReader.read(res);
        List lib = null;
        boolean includeLibs = true;
        if (libs != null) {
            lib = (List)JSONReader.read(libs);
            includeLibs = false;
        }
        String[] resources = o.toArray(new String[o.size()]);
        IVResource[] files = new IVResource[resources.length];
        int i = 0;
        while (i < files.length) {
            files[i] = user.getResource(resources[i]);
            ++i;
        }
        try {
            resp.setContentType("application/x-download");
            resp.setHeader("Content-Disposition", "attachment; filename=" + path);
            ZipOutputStream zos = new ZipOutputStream((OutputStream)resp.getOutputStream());
            Path rootPath = new Path(root);
            this.zipFiles(files, (IPath)rootPath, zos, includeLibs);
            if (lib != null) {
                this.zipLibs(lib, (IPath)rootPath, zos, useFullSource);
            }
            zos.close();
        }
        catch (IOException e) {
            this.responseString = "Error creating download file : " + e;
        }
    }

    private URL getBuildURL(IUser user, String requestURLString) throws IOException {
        Map<String, List<String>> dependencies;
        URL buildURL;
        block8: {
            buildURL = new URL(buildBase);
            dependencies = this.analyzeWorkspace(user, requestURLString);
            if (dependencies != null) break block8;
            return null;
        }
        try {
            String statusCookie = this.requestBuild(dependencies);
            URL status = new URL(buildURL, statusCookie);
            String result = null;
            while (result == null) {
                InputStream is = status.openStream();
                try {
                    int size;
                    byte[] buffer = new byte[2048];
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(buffer.length);
                    while ((size = is.read(buffer, 0, buffer.length)) != -1) {
                        baos.write(buffer, 0, size);
                    }
                    String content = baos.toString();
                    theLogger.finest("build status: " + content);
                    Map json = (Map)JSONReader.read(content);
                    result = (String)json.get("result");
                }
                finally {
                    is.close();
                }
                Thread.sleep(1000L);
            }
            theLogger.fine("build result: " + result);
            buildURL = new URL(buildURL, result);
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Thread interrupted.  Did not obtain build result.");
        }
        return buildURL;
    }

    private Map<String, List<String>> analyzeWorkspace(IUser user, String requestURL) throws IOException {
        IVResource[] files = user.findFiles("*.html", false, true);
        HttpClient client = new HttpClient();
        Map result = null;
        String userID = user.getUserID();
        theLogger.finest("analyzeWorkspace: number of files: " + files.length);
        int i = 0;
        while (i < files.length) {
            if (files[i].isVirtual()) {
                theLogger.finest("isVirtual name=" + files[i].getPath());
            } else {
                PostMethod method = new PostMethod(String.valueOf(buildBase) + "/api/dependencies");
                try {
                    String url = new URL(new URL(requestURL), "/maqetta/user/" + userID + "/ws/workspace/" + files[i].getPath()).toExternalForm();
                    theLogger.finest("DWB: Analyse url=" + url);
                    Part[] parts = new Part[]{new StringPart("value", url, "utf-8"), new StringPart("type", "URL")};
                    method.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, method.getParams()));
                    int statusCode = client.executeMethod((HttpMethod)method);
                    String body = method.getResponseBodyAsString();
                    if (statusCode != 200) {
                        throw new IOException(String.valueOf(buildBase) + "/api/dependencies: Analyse failed: " + method.getStatusLine() + "\n" + body);
                    }
                    int start = body.indexOf("<textarea>");
                    int end = body.indexOf("</textarea>");
                    if (start == -1 || end == -1) {
                        throw new IOException(String.valueOf(buildBase) + "/api/dependencies: unable to parse output: " + body);
                    }
                    String content = body.substring(start + 10, end);
                    theLogger.finest("DWB: Analyse result=" + content);
                    Map dependencies = (Map)JSONReader.read(content);
                    if (result == null) {
                        result = dependencies;
                    } else {
                        List requiredDojoModules = (List)result.get("requiredDojoModules");
                        List additionalModules = (List)dependencies.get("requiredDojoModules");
                        int j = 0;
                        while (j < additionalModules.size()) {
                            String additionalModule = (String)additionalModules.get(j);
                            if (!requiredDojoModules.contains(additionalModule)) {
                                requiredDojoModules.add(additionalModule);
                                theLogger.finest("add " + additionalModule);
                            }
                            ++j;
                        }
                    }
                }
                finally {
                    method.releaseConnection();
                }
            }
            ++i;
        }
        return result;
    }

    private String requestBuild(Map<String, List<String>> dependencies) throws IOException {
        JSONWriter jsonWriter = new JSONWriter(false);
        jsonWriter.addField("optimise", "shrinksafe").addField("cdn", "none").addField("platforms", "all").addField("themes", "claro").addField("cssOptimise", "comments");
        jsonWriter.addFieldName("packages").startArray();
        jsonWriter.startObject().addField("name", "dojo").addField("version", "1.8.0").endObject();
        jsonWriter.endArray();
        jsonWriter.addFieldName("layers").startArray();
        jsonWriter.startObject();
        jsonWriter.addField("name", "dojo.js");
        jsonWriter.addFieldName("modules");
        jsonWriter.startArray();
        List<String> requiredDojoModules = dependencies.get("requiredDojoModules");
        int i = 0;
        while (i < requiredDojoModules.size()) {
            jsonWriter.startObject();
            jsonWriter.addField("name", requiredDojoModules.get(i));
            jsonWriter.addField("package", "dojo");
            jsonWriter.endObject();
            ++i;
        }
        jsonWriter.endArray();
        jsonWriter.endObject();
        jsonWriter.endArray();
        String content = jsonWriter.getJSON();
        HttpClient client = new HttpClient();
        PostMethod method = new PostMethod(String.valueOf(buildBase) + "/api/build");
        theLogger.finest("/api/build: " + content);
        try {
            method.setRequestEntity((RequestEntity)new StringRequestEntity(content, "application/json", "utf-8"));
            int statusCode = client.executeMethod((HttpMethod)method);
            String json = method.getResponseBodyAsString();
            theLogger.finest("/api/build response: " + json);
            if (statusCode != 202 && statusCode != 200) {
                throw new IOException(String.valueOf(buildBase) + "/api/build failed with status: " + statusCode + "\n" + json);
            }
            Map status = (Map)JSONReader.read(json);
            String statusLink = (String)status.get("buildStatusLink");
            if (statusLink == null) {
                throw new IOException(String.valueOf(buildBase) + "/api/build failed with error: " + (String)status.get("error"));
            }
            String string = statusLink;
            return string;
        }
        finally {
            method.releaseConnection();
        }
    }

    private void transferBuildStream(URL resultURL, String dirString, ZipOutputStream zos) throws IOException {
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(resultURL.openStream()));
        byte[] readBuffer = new byte[2156];
        try {
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                int bytesIn;
                String pathString = dirString.concat(entry.getName());
                zos.putNextEntry(new ZipEntry(pathString));
                theLogger.finest("transferBuildStream:" + pathString);
                while ((bytesIn = zis.read(readBuffer)) != -1) {
                    zos.write(readBuffer, 0, bytesIn);
                }
            }
        }
        finally {
            zis.close();
        }
    }

    private String sanitizeFileName(String fileName) {
        if (fileName == null || fileName.equals("")) {
            fileName = "workspace1.zip";
        }
        fileName = fileName.replaceAll(DOWNLOAD_FILE_REPLACE_REGEXP, "_");
        return fileName;
    }

    private boolean addEntry(String path) {
        int i = 0;
        while (i < this.zippedEntries.size()) {
            String entry = this.zippedEntries.get(i);
            if (entry.compareTo(path) == 0) {
                return false;
            }
            ++i;
        }
        this.zippedEntries.add(path);
        return true;
    }

    private void zipLibs(List<Map<String, String>> libs, IPath root, ZipOutputStream zos, boolean useSource) throws IOException {
        int i = 0;
        while (i < libs.size()) {
            Map<String, String> libEntry = libs.get(i);
            String id = libEntry.get("id");
            String version = libEntry.get("version");
            String path = libEntry.get("root");
            Library lib = ServerManager.getServerManager().getLibraryManager().getLibrary(id, version);
            boolean sourceLibrary = lib.getSourcePath() != null && useSource;
            VLibraryResource libResource = new VLibraryResource(lib, lib.getURL("", sourceLibrary), path, "", sourceLibrary);
            this.zipDir(libResource, root, zos, true);
            ++i;
        }
    }

    private void zipDir(IVResource zipDir, IPath root, ZipOutputStream zos, boolean includeLibs) throws IOException {
        IVResource[] dirList = zipDir.listFiles();
        if (!includeLibs && zipDir instanceof VLibraryResource) {
            return;
        }
        this.zipFiles(dirList, root, zos, includeLibs);
    }

    private void zipFiles(IVResource[] files, IPath root, ZipOutputStream zos, boolean includeLibs) throws IOException {
        byte[] readBuffer = new byte[2156];
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                this.zipDir(files[i], root, zos, includeLibs);
            } else if (includeLibs || !(files[i] instanceof VLibraryResource)) {
                Path filePath = new Path(files[i].getPath());
                String pathString = filePath.removeFirstSegments(filePath.matchingFirstSegments(root)).toString();
                if (pathString == null) {
                    return;
                }
                if (pathString.length() > 1 && pathString.indexOf("./") == 0) {
                    pathString = pathString.substring(2);
                }
                if (this.addEntry(pathString)) {
                    String dirString = pathString.substring(0, pathString.lastIndexOf(47) + 1);
                    if (this.buildURL != null && files[i].getPath().equals("lib/dojo/dojo/dojo.js")) {
                        this.transferBuildStream(this.buildURL, dirString, zos);
                    } else {
                        InputStream is = null;
                        try {
                            int bytesIn;
                            is = files[i].getInputStreem();
                            zos.putNextEntry(new ZipEntry(pathString));
                            while ((bytesIn = is.read(readBuffer)) != -1) {
                                zos.write(readBuffer, 0, bytesIn);
                            }
                        }
                        finally {
                            if (is != null) {
                                is.close();
                            }
                            files[i].removeWorkingCopy();
                        }
                    }
                }
            }
            ++i;
        }
    }
}

