/*
 * Decompiled with CFR 0.152.
 */
package maqetta.server.orion.user;

import java.io.IOException;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import maqetta.core.server.user.manager.UserManagerImpl;
import maqetta.server.orion.user.OrionPersonManager;
import maqetta.server.orion.user.OrionUser;
import org.davinci.server.user.IPerson;
import org.davinci.server.user.IUser;
import org.davinci.server.user.UserException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.orion.server.configurator.ConfiguratorActivator;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.authentication.IAuthenticationService;
import org.eclipse.orion.server.core.users.OrionScope;
import org.maqetta.server.IStorage;
import org.maqetta.server.ServerManager;
import org.osgi.service.prefs.BackingStoreException;

public class OrionUserManager
extends UserManagerImpl {
    private IAuthenticationService authenticationService;
    private Properties authProperties;

    public OrionUserManager() {
        ServerManager serverManger = ServerManager.getServerManager();
        this.personManager = ServerManager.getServerManager().getPersonManager();
        String maxUsersStr = serverManger.getDavinciProperty("maqetta.maxUsers");
        if (maxUsersStr != null && maxUsersStr.length() > 0) {
            this.maxUsers = Integer.valueOf(maxUsersStr);
        }
    }

    private void assertValidUserId(String uid) {
        if (uid.indexOf("@") != -1) {
            throw new Error("Invalid user ID");
        }
    }

    private IAuthenticationService getAuthenticationService() {
        if (this.authenticationService == null) {
            this.authenticationService = ConfiguratorActivator.getDefault().getAuthService();
        }
        return this.authenticationService;
    }

    protected void initWorkspace() {
    }

    protected boolean checkUserExists(String userName) {
        return OrionPersonManager.getOrionUser(userName) != null;
    }

    protected boolean checkUserExistsByEmail(String email) {
        return OrionPersonManager.getOrionUserByEmail(email) != null;
    }

    public IUser getUser(String userName) throws UserException {
        this.assertValidUserId(userName);
        if (ServerManager.LOCAL_INSTALL && "maqettaUser".equals(userName)) {
            return this.getSingleUser();
        }
        if (this.checkUserExists(userName)) {
            IPerson person = this.personManager.getPerson(userName);
            return this.newUser(person, null);
        }
        return null;
    }

    public IUser getUserByEmail(String email) throws UserException {
        if (this.checkUserExistsByEmail(email)) {
            IPerson person = this.personManager.getPersonByEmail(email);
            return this.newUser(person, null);
        }
        return null;
    }

    public IUser newUser(IPerson person, IStorage baseDirectory) throws UserException {
        OrionUser user;
        try {
            user = new OrionUser(person);
        }
        catch (CoreException e) {
            throw new UserException((Throwable)e);
        }
        if (this.init(person.getUserID())) {
            try {
                user.createProject("project1");
            }
            catch (IOException e) {
                throw new UserException((Throwable)e);
            }
        }
        return user;
    }

    public IUser addUser(String userName, String password, String email) throws UserException, IOException {
        this.assertValidUserId(userName);
        if (this.checkUserExists(userName)) {
            throw new UserException("User already exists");
        }
        if (this.maxUsers > 0 && this.usersCount >= this.maxUsers) {
            throw new UserException("Maximum number of Maqetta users exceded");
        }
        IPerson person = this.personManager.addPerson(userName, password, email);
        if (person != null) {
            IUser user = this.newUser(person, null);
            user.createProject("project1");
            ++this.usersCount;
            return user;
        }
        return null;
    }

    private boolean init(String userName) {
        this.assertValidUserId(userName);
        IEclipsePreferences users = new OrionScope().getNode("Users");
        IEclipsePreferences result = (IEclipsePreferences)users.node(userName);
        boolean wasInit = result.getBoolean("maqettaInit", false);
        if (!wasInit) {
            result.putBoolean("maqettaInit", true);
            try {
                result.parent().flush();
            }
            catch (BackingStoreException e) {
                LogHelper.log((Throwable)e);
            }
        }
        return !wasInit;
    }

    public IUser getUser(HttpServletRequest req) {
        String user = null;
        try {
            user = this.getAuthenticationService().getAuthenticatedUser(req, null, this.authProperties);
            if (user != null) {
                return this.newUser(this.personManager.addPerson(user, null, null), null);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (UserException e) {
            e.printStackTrace();
        }
        return null;
    }

    public boolean isValidUserByEmail(String email) throws UserException {
        IUser user = this.getUserByEmail(email);
        return user != null;
    }
}

