/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.user.securestorage;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import javax.crypto.spec.PBEKeySpec;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.orion.internal.server.user.securestorage.Activator;
import org.eclipse.orion.internal.server.user.securestorage.SecureStorageUserProfileNode;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.user.profile.IOrionUserProfileNode;
import org.eclipse.orion.server.user.profile.IOrionUserProfileService;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class SecureStorageUserProfileService
implements IOrionUserProfileService {
    static final String ORION_SERVER_NODE = "org.eclipse.orion.server";
    static final String USERS = "users";
    static final String USER_PROFILE = "profile";
    private ISecurePreferences storage;

    public SecureStorageUserProfileService() {
        this.initSecurePreferences();
    }

    public IOrionUserProfileNode getUserProfileNode(String userName, String partId) {
        return new SecureStorageUserProfileNode(this.storage.node("users/" + userName + "/" + USER_PROFILE + "/" + partId));
    }

    public IOrionUserProfileNode getUserProfileNode(String userName, boolean create) {
        if (create || this.storage.nodeExists("users/" + userName)) {
            return new SecureStorageUserProfileNode(this.storage.node("users/" + userName + "/" + USER_PROFILE));
        }
        return null;
    }

    public String[] getUserNames() {
        if (!this.storage.nodeExists(USERS)) {
            return null;
        }
        return this.storage.node(USERS).childrenNames();
    }

    private void initSecurePreferences() {
        URL location = this.getStorageLocation();
        if (location != null) {
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("org.eclipse.equinox.security.storage.promptUser", Boolean.FALSE);
            String password = System.getProperty("orion.storage.password", "");
            options.put("org.eclipse.equinox.security.storage.defaultPassword", new PBEKeySpec(password.toCharArray()));
            try {
                this.storage = SecurePreferencesFactory.open((URL)location, options);
            }
            catch (IOException e) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.orion.server.user.securestorage", "Error initializing user storage location", (Throwable)e));
            }
        } else {
            LogHelper.log((IStatus)new Status(2, "org.eclipse.orion.server.user.securestorage", "No instance location set. Storing user data in user home directory"));
        }
        if (this.storage == null) {
            this.storage = SecurePreferencesFactory.getDefault().node(ORION_SERVER_NODE);
        }
    }

    private URL getStorageLocation() {
        Collection refs;
        BundleContext context = Activator.getContext();
        try {
            refs = context.getServiceReferences(Location.class, Location.INSTANCE_FILTER);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
        if (refs.isEmpty()) {
            return null;
        }
        ServiceReference ref = (ServiceReference)refs.iterator().next();
        Location location = (Location)context.getService(ref);
        try {
            if (location != null) {
                URL uRL = location.getDataArea("org.eclipse.orion.server.user.securestorage/user_store");
                return uRL;
            }
        }
        catch (IOException e) {
            LogHelper.log((Throwable)e);
        }
        finally {
            context.ungetService(ref);
        }
        return null;
    }
}

