/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.server.git.servlets.GitUtils;

public abstract class BaseToCloneConverter {
    public static final BaseToCloneConverter FILE = new BaseToCloneConverter(){

        @Override
        public IPath getFilePath(URI base) throws URISyntaxException {
            return new Path(base.getPath()).makeRelative();
        }
    };
    public static final BaseToCloneConverter STATUS;
    public static final BaseToCloneConverter COMMIT;
    public static final BaseToCloneConverter REMOTE_LIST;
    public static final BaseToCloneConverter BRANCH_LIST;
    public static final BaseToCloneConverter TAG_LIST;
    public static final BaseToCloneConverter REMOTE;
    public static final BaseToCloneConverter BRANCH;
    public static final BaseToCloneConverter COMMIT_REFRANGE;
    public static final BaseToCloneConverter CONFIG;
    public static final BaseToCloneConverter DIFF;
    public static final BaseToCloneConverter TAG;
    public static final BaseToCloneConverter REMOTE_BRANCH;
    public static final BaseToCloneConverter CONFIG_OPTION;

    static {
        COMMIT = STATUS = new BaseToCloneConverter(){

            @Override
            public IPath getFilePath(URI base) throws URISyntaxException {
                return new Path(base.getPath()).removeFirstSegments(2).makeRelative();
            }
        };
        REMOTE_LIST = STATUS;
        BRANCH_LIST = STATUS;
        TAG_LIST = STATUS;
        BRANCH = REMOTE = new BaseToCloneConverter(){

            @Override
            public IPath getFilePath(URI base) throws URISyntaxException {
                return new Path(base.getPath()).removeFirstSegments(3).makeRelative();
            }
        };
        COMMIT_REFRANGE = REMOTE;
        CONFIG = REMOTE;
        DIFF = REMOTE;
        TAG = REMOTE;
        CONFIG_OPTION = REMOTE_BRANCH = new BaseToCloneConverter(){

            @Override
            public IPath getFilePath(URI base) throws URISyntaxException {
                return new Path(base.getPath()).removeFirstSegments(4).makeRelative();
            }
        };
    }

    public static URI getCloneLocation(URI base, BaseToCloneConverter converter) throws URISyntaxException, CoreException {
        IPath filePath = converter.getFilePath(base);
        IPath clonePath = BaseToCloneConverter.findClonePath(filePath);
        if (clonePath == null) {
            return null;
        }
        IPath p = new Path("/gitapi").append("clone").append(clonePath).addTrailingSeparator();
        return new URI(base.getScheme(), base.getUserInfo(), base.getHost(), base.getPort(), p.toString(), base.getQuery(), base.getFragment());
    }

    public abstract IPath getFilePath(URI var1) throws URISyntaxException;

    private static IPath findClonePath(IPath filePath) throws CoreException {
        Map<IPath, File> dirs = GitUtils.getGitDirs(filePath, GitUtils.Traverse.GO_UP);
        if (dirs.size() != 1) {
            return null;
        }
        IPath relativePath = dirs.keySet().iterator().next();
        return filePath.append(relativePath);
    }
}

