/*
 * Decompiled with CFR 0.152.
 */
package maqetta.zazl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.davinci.ajaxLibrary.ILibInfo;
import org.davinci.ajaxLibrary.Library;
import org.davinci.server.user.IUser;
import org.davinci.server.user.IUserManager;
import org.davinci.server.user.UserException;
import org.dojotoolkit.server.util.osgi.OSGiResourceLoader;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.maqetta.server.IVResource;
import org.osgi.framework.BundleContext;

public class MaqettaOSGiResourceLoader
extends OSGiResourceLoader {
    private static Logger logger = Logger.getLogger("maqetta.zazl");
    private IUserManager userManager = null;
    private List<Library> srcLibs = null;
    private String contextPathSegment = null;

    public MaqettaOSGiResourceLoader(BundleContext bundleContext, String[] bundleIds, IUserManager userManager, List<Library> srcLibs) {
        super(bundleContext, bundleIds);
        this.userManager = userManager;
        this.srcLibs = srcLibs;
    }

    public void setContextPath(String contextPath) {
        this.contextPathSegment = !contextPath.equals("") ? contextPath.substring(1) : "";
    }

    public boolean contextPathSet() {
        return this.contextPathSegment != null;
    }

    protected URL _getResource(String path) {
        IVResource resource;
        URL url = super._getResource(path);
        if (url != null) {
            return url;
        }
        IUser user = null;
        Path ipath = new Path(path);
        if (ipath.segment(0).equals(this.contextPathSegment)) {
            ipath = ipath.removeFirstSegments(1);
        }
        if (ipath.segment(0).equals("maqetta")) {
            ILibInfo[] projectLibs;
            if (ipath.segment(1).equals("user")) {
                ipath = ipath.removeFirstSegments(2);
                String userName = ipath.segment(0);
                try {
                    user = this.userManager.getUser(userName);
                }
                catch (UserException e) {
                    e.printStackTrace();
                    return null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
                ipath = ipath.removeFirstSegments(1);
                if (ipath.segment(0).equals("ws") && ipath.segment(1).equals("workspace")) {
                    ipath = ipath.removeFirstSegments(2);
                }
            } else {
                user = this.userManager.getSingleUser();
            }
            int removecount = 0;
            removecount = ipath.segment(0).equals(".review") ? 4 : (user.getResource(String.valueOf(ipath.segment(0)) + "/.project") == null ? 1 : 2);
            url = this.scanSrcLibs((IPath)ipath, removecount, projectLibs = user.getLibs(ipath.segment(0)));
            if (url != null) {
                return url;
            }
        }
        if ((resource = user.getResource(ipath.toString())) != null) {
            try {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, ((Object)((Object)this)).getClass().getName(), "_getResource", "resource [" + path + "] loaded from project");
                }
                return resource.getURI().toURL();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private URL scanSrcLibs(IPath ipath, int removecount, ILibInfo[] projectLibs) {
        for (Library srcLib : this.srcLibs) {
            URL url;
            IPath srcPath = ipath.removeFirstSegments(removecount);
            String root = this.getRoot(srcLib, projectLibs);
            if (root.charAt(0) == '/') {
                root = root.substring(1);
            }
            Path srcLibPath = new Path(root);
            IPath srcRelPath = srcPath.removeFirstSegments(srcLibPath.segmentCount());
            if (!srcPath.toString().startsWith(root) || (url = srcLib.getURL(srcRelPath.toString(), true)) == null) continue;
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, ((Object)((Object)this)).getClass().getName(), "_getResource", "resource [" + srcPath.toString() + "] loaded from srclib [" + srcLib.getID() + "]");
            }
            return url;
        }
        return null;
    }

    private String getRoot(Library srcLib, ILibInfo[] projectLibs) {
        ILibInfo[] iLibInfoArray = projectLibs;
        int n = projectLibs.length;
        int n2 = 0;
        while (n2 < n) {
            ILibInfo projectLib = iLibInfoArray[n2];
            if (projectLib.getId().equals(srcLib.getID())) {
                return projectLib.getVirtualRoot();
            }
            ++n2;
        }
        return srcLib.getDefaultRoot();
    }
}

