/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.search;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.eclipse.orion.internal.server.search.SearchActivator;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.servlets.OrionServlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchServlet
extends OrionServlet {
    private static final long serialVersionUID = 1L;
    private static final String FIELD_NAMES = "Id,Name,NameLower,Length,Directory,LastModified,Location,Path";
    private static final List<String> FIELD_LIST = Arrays.asList("Id,Name,NameLower,Length,Directory,LastModified,Location,Path".split(","));

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.traceRequest(req);
        SolrQuery query = this.buildSolrQuery(req);
        if (query == null) {
            this.handleException(resp, "Invalid search request", null, 400);
            return;
        }
        try {
            QueryResponse solrResponse = SearchActivator.getInstance().getSolrServer().query((SolrParams)query);
            this.writeResponse(query, req, resp, solrResponse);
        }
        catch (SolrServerException e) {
            LogHelper.log((Throwable)e);
            resp.sendError(500, e.getMessage());
        }
    }

    private SolrQuery buildSolrQuery(HttpServletRequest req) {
        SolrQuery query = new SolrQuery();
        query.setParam("wt", new String[]{"json"});
        query.setParam("fl", new String[]{FIELD_NAMES});
        String queryString = this.getEncodedParameter(req, "q");
        if (queryString == null) {
            return null;
        }
        if (queryString.length() > 0) {
            String processedQuery = "";
            ArrayList<String> terms = new ArrayList<String>(Arrays.asList(queryString.split("[\\s\\+]+")));
            while (!terms.isEmpty()) {
                String term = (String)terms.remove(0);
                if (term.length() == 0) continue;
                if (this.isSearchField(term)) {
                    processedQuery = term.startsWith("NameLower:") ? String.valueOf(processedQuery) + "NameLower:" + term.substring(10).toLowerCase() : String.valueOf(processedQuery) + term;
                } else {
                    try {
                        term = URLDecoder.decode(term, "UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                    boolean isPhrase = term.charAt(0) == '\"';
                    String processedTerm = ClientUtils.escapeQueryChars((String)term.toLowerCase());
                    if (!isPhrase) {
                        if (processedTerm.charAt(0) != '*') {
                            processedTerm = String.valueOf('*') + processedTerm;
                        }
                        if (processedTerm.charAt(processedTerm.length() - 1) != '*') {
                            processedTerm = String.valueOf(processedTerm) + '*';
                        }
                    }
                    processedQuery = String.valueOf(processedQuery) + processedTerm;
                }
                processedQuery = String.valueOf(processedQuery) + " AND ";
            }
            queryString = processedQuery;
        }
        queryString = String.valueOf(queryString) + "UserName:" + ClientUtils.escapeQueryChars((String)req.getRemoteUser());
        query.setQuery(queryString);
        this.setField(req, query, "rows");
        this.setField(req, query, "start");
        this.setField(req, query, "sort");
        return query;
    }

    private String getEncodedParameter(HttpServletRequest req, String key) {
        String query = req.getQueryString();
        String[] stringArray = query.split("&");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            String[] pair = param.split("=", 2);
            if (pair.length == 2 && key.equals(pair[0])) {
                return pair[1];
            }
            ++n2;
        }
        return null;
    }

    private boolean isSearchField(String term) {
        for (String field : FIELD_LIST) {
            if (!term.startsWith(String.valueOf(field) + ":")) continue;
            return true;
        }
        return false;
    }

    private void setField(HttpServletRequest req, SolrQuery query, String parameter) {
        String value = req.getParameter(parameter);
        if (value != null) {
            query.set(parameter, new String[]{value});
        }
    }

    private void writeResponse(SolrQuery query, HttpServletRequest httpRequest, HttpServletResponse httpResponse, QueryResponse queryResponse) throws IOException {
        SolrCore core = SearchActivator.getInstance().getSolrCore();
        LocalSolrQueryRequest solrRequest = new LocalSolrQueryRequest(core, query.toNamedList());
        SolrQueryResponse solrResponse = new SolrQueryResponse();
        NamedList params = (NamedList)queryResponse.getHeader().get("params");
        params.remove("q");
        params.add("q", (Object)httpRequest.getParameter("q"));
        NamedList values = queryResponse.getResponse();
        String contextPath = httpRequest.getContextPath();
        if (contextPath.length() > 0) {
            this.setSearchResultContext((NamedList<Object>)values, contextPath);
        }
        solrResponse.setAllValues(values);
        QueryResponseWriter writer = core.getQueryResponseWriter("json");
        writer.write((Writer)httpResponse.getWriter(), (SolrQueryRequest)solrRequest, solrResponse);
    }

    private void setSearchResultContext(NamedList<Object> values, String contextPath) {
        SolrDocumentList documents = (SolrDocumentList)values.get("response");
        if (documents == null) {
            return;
        }
        for (SolrDocument doc : documents) {
            String location = (String)doc.getFieldValue("Location");
            if (location == null) continue;
            location = String.valueOf(contextPath) + location;
            doc.setField("Location", (Object)location);
        }
    }
}

