/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.workspace;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.orion.internal.server.servlets.workspace.WebElement;
import org.eclipse.orion.internal.server.servlets.workspace.WebProject;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.resources.Base64Counter;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebWorkspace
extends WebElement {
    private static final String WORKSPACE_NODE_NAME = "Workspaces";
    private static final Base64Counter workspaceCounter = new Base64Counter();

    public static List<WebWorkspace> allWorkspaces() {
        ArrayList<WebWorkspace> result = new ArrayList<WebWorkspace>();
        IEclipsePreferences workspaceRoot = scope.getNode(WORKSPACE_NODE_NAME);
        try {
            String[] ids;
            String[] stringArray = ids = workspaceRoot.childrenNames();
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                result.add(WebWorkspace.fromId(id));
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            LogHelper.log((Throwable)e);
        }
        return result;
    }

    public static boolean exists(String id) {
        if (id == null) {
            return false;
        }
        try {
            return scope.getNode(WORKSPACE_NODE_NAME).nodeExists(id);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static WebWorkspace fromId(String id) {
        WebWorkspace result = new WebWorkspace((IEclipsePreferences)scope.getNode(WORKSPACE_NODE_NAME).node(id));
        result.setId(id);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String nextWorkspaceId(String defaultId) {
        Base64Counter base64Counter = workspaceCounter;
        synchronized (base64Counter) {
            String candidate = defaultId;
            while (WebWorkspace.exists(candidate)) {
                candidate = workspaceCounter.toString();
                workspaceCounter.increment();
            }
            return candidate;
        }
    }

    public WebWorkspace(IEclipsePreferences store) {
        super(store);
    }

    public void addProject(WebProject project) throws CoreException {
        JSONArray allProjects = this.getProjectsJSON();
        String newProjectId = project.getId();
        String newProjectName = project.getName();
        int i = 0;
        while (i < allProjects.length()) {
            try {
                JSONObject existing = (JSONObject)allProjects.get(i);
                if (newProjectId.equals(existing.get("Id")) || newProjectName.equals(existing.get("Name"))) {
                    String msg = NLS.bind((String)"Project already exists: {0}", (Object)newProjectName);
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.orion.server.servlets", msg));
                }
            }
            catch (JSONException jSONException) {}
            ++i;
        }
        JSONObject storedProject = new JSONObject();
        try {
            storedProject.put("Id", (Object)newProjectId);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        allProjects.put((Object)storedProject);
        this.store.put("Projects", allProjects.toString());
    }

    public WebProject getProjectByName(String name) {
        JSONArray projects = this.getProjectsJSON();
        int i = 0;
        while (i < projects.length()) {
            try {
                JSONObject projectJSON = (JSONObject)projects.get(i);
                WebProject project = WebProject.fromId(projectJSON.optString("Id", ""));
                if (name.equals(project.getName())) {
                    return project;
                }
            }
            catch (JSONException jSONException) {}
            ++i;
        }
        return null;
    }

    public JSONArray getProjectsJSON() {
        try {
            String projects = this.store.get("Projects", null);
            if (projects != null) {
                return new JSONArray(projects);
            }
        }
        catch (JSONException jSONException) {}
        JSONArray result = new JSONArray();
        return result;
    }

    public List<WebProject> getProjects() {
        JSONArray projectsJSON = this.getProjectsJSON();
        ArrayList<WebProject> allProjects = new ArrayList<WebProject>(projectsJSON.length());
        int i = 0;
        while (i < projectsJSON.length()) {
            try {
                JSONObject projectJSON = projectsJSON.getJSONObject(i);
                String projectId = projectJSON.getString("Id");
                allProjects.add(WebProject.fromId(projectId));
            }
            catch (JSONException jSONException) {}
            ++i;
        }
        return allProjects;
    }

    public void removeProject(WebProject project) {
        JSONArray allProjects;
        String existingProjects = this.store.get("Projects", "[]");
        try {
            allProjects = new JSONArray(existingProjects);
        }
        catch (JSONException jSONException) {
            allProjects = new JSONArray();
        }
        String newProjectId = project.getId();
        int index = -1;
        int i = 0;
        while (i < allProjects.length()) {
            try {
                if (newProjectId.equals(((JSONObject)allProjects.get(i)).get("Id"))) {
                    index = i;
                    break;
                }
            }
            catch (JSONException jSONException) {}
            ++i;
        }
        if (index == -1) {
            return;
        }
        allProjects.remove(index);
        this.store.put("Projects", allProjects.toString());
    }
}

