/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.shell;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.tools.ToolErrorReporter;
import org.mozilla.javascript.tools.shell.Global;
import org.mozilla.javascript.tools.shell.SecurityProxy;
import org.mozilla.javascript.tools.shell.ShellContextFactory;

public class Main {
    public static final ShellContextFactory shellContextFactory = new ShellContextFactory();
    protected static final Global global = new Global();
    protected static ToolErrorReporter errorReporter;
    protected static int exitCode;
    private static final int EXITCODE_RUNTIME_ERROR = 3;
    private static final int EXITCODE_FILE_NOT_FOUND = 4;
    static boolean processStdin;
    static boolean sealedStdLib;
    static Vector fileList;
    private static SecurityProxy securityImpl;

    public static void main(String[] stringArray) {
        try {
            if (Boolean.getBoolean("rhino.use_java_policy_security")) {
                Main.initJavaPolicySecuritySupport();
            }
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace(System.err);
        }
        int n = Main.exec(stringArray);
        if (n != 0) {
            System.exit(n);
        }
    }

    public static int exec(String[] stringArray) {
        Object object;
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            if (!((String)object).equals("-sealedlib")) continue;
            sealedStdLib = true;
            break;
        }
        errorReporter = new ToolErrorReporter(false, global.getErr());
        shellContextFactory.setErrorReporter(errorReporter);
        String[] stringArray2 = Main.processOptions(stringArray);
        if (processStdin) {
            fileList.addElement(null);
        }
        object = new IProxy(1);
        ((IProxy)object).args = stringArray2;
        shellContextFactory.call((ContextAction)object);
        return exitCode;
    }

    static void processFiles(Context context, String[] stringArray) {
        if (!Main.global.initialized) {
            global.init(context);
        }
        Object[] objectArray = new Object[stringArray.length];
        System.arraycopy(stringArray, 0, objectArray, 0, stringArray.length);
        Scriptable scriptable = context.newArray((Scriptable)global, objectArray);
        global.defineProperty("arguments", scriptable, 2);
        for (int i = 0; i < fileList.size(); ++i) {
            Main.processSource(context, (String)fileList.elementAt(i));
        }
    }

    public static Global getGlobal() {
        return global;
    }

    public static String[] processOptions(String[] stringArray) {
        String string;
        int n = 0;
        while (true) {
            if (n == stringArray.length) {
                return new String[0];
            }
            String string2 = stringArray[n];
            if (!string2.startsWith("-")) {
                processStdin = false;
                fileList.addElement(string2);
                String[] stringArray2 = new String[stringArray.length - n - 1];
                System.arraycopy(stringArray, n + 1, stringArray2, 0, stringArray.length - n - 1);
                return stringArray2;
            }
            if (string2.equals("-version")) {
                int n2;
                if (++n == stringArray.length) {
                    string = string2;
                    break;
                }
                try {
                    n2 = Integer.parseInt(stringArray[n]);
                }
                catch (NumberFormatException numberFormatException) {
                    string = stringArray[n];
                    break;
                }
                if (!Context.isValidLanguageVersion(n2)) {
                    string = stringArray[n];
                    break;
                }
                shellContextFactory.setLanguageVersion(n2);
            } else if (string2.equals("-opt") || string2.equals("-O")) {
                int n3;
                if (++n == stringArray.length) {
                    string = string2;
                    break;
                }
                try {
                    n3 = Integer.parseInt(stringArray[n]);
                }
                catch (NumberFormatException numberFormatException) {
                    string = stringArray[n];
                    break;
                }
                if (n3 == -2) {
                    n3 = -1;
                } else if (!Context.isValidOptimizationLevel(n3)) {
                    string = stringArray[n];
                    break;
                }
                shellContextFactory.setOptimizationLevel(n3);
            } else if (string2.equals("-strict")) {
                shellContextFactory.setStrictMode(true);
            } else if (string2.equals("-e")) {
                processStdin = false;
                if (++n == stringArray.length) {
                    string = string2;
                    break;
                }
                IProxy iProxy = new IProxy(2);
                iProxy.scriptText = stringArray[n];
                shellContextFactory.call(iProxy);
            } else if (string2.equals("-w")) {
                errorReporter.setIsReportingWarnings(true);
            } else if (string2.equals("-f")) {
                processStdin = false;
                if (++n == stringArray.length) {
                    string = string2;
                    break;
                }
                fileList.addElement(stringArray[n].equals("-") ? null : stringArray[n]);
            } else if (string2.equals("-sealedlib")) {
                if (!sealedStdLib) {
                    Kit.codeBug();
                }
            } else {
                string = string2;
                break;
            }
            ++n;
        }
        Main.p(ToolErrorReporter.getMessage("msg.shell.usage", string));
        System.exit(1);
        return null;
    }

    private static void initJavaPolicySecuritySupport() {
        Throwable throwable;
        try {
            Class<?> clazz = Class.forName("org.mozilla.javascript.tools.shell.JavaPolicySecurity");
            securityImpl = (SecurityProxy)clazz.newInstance();
            SecurityController.initGlobal(securityImpl);
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throwable = classNotFoundException;
        }
        catch (IllegalAccessException illegalAccessException) {
            throwable = illegalAccessException;
        }
        catch (InstantiationException instantiationException) {
            throwable = instantiationException;
        }
        catch (LinkageError linkageError) {
            throwable = linkageError;
        }
        throw Kit.initCause(new IllegalStateException("Can not load security support: " + throwable), throwable);
    }

    public static void processSource(Context context, String string) {
        if (string == null || string.equals("-")) {
            if (string == null) {
                Main.getOut().println(context.getImplementationVersion());
            }
            context.setOptimizationLevel(-1);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(global.getIn()));
            int n = 1;
            boolean bl = false;
            while (!bl) {
                Object object;
                int n2 = n;
                if (string == null) {
                    global.getErr().print("js> ");
                }
                global.getErr().flush();
                String string2 = "";
                do {
                    try {
                        object = bufferedReader.readLine();
                    }
                    catch (IOException iOException) {
                        global.getErr().println(iOException.toString());
                        break;
                    }
                    if (object == null) {
                        bl = true;
                        break;
                    }
                    string2 = string2 + (String)object + "\n";
                    ++n;
                } while (!context.stringIsCompilableUnit(string2));
                object = Main.evaluateScript(context, global, null, string2, "<stdin>", n2, null);
                if (object != context.getUndefinedValue()) {
                    try {
                        global.getErr().println(Context.toString(object));
                    }
                    catch (RhinoException rhinoException) {
                        errorReporter.reportException(rhinoException);
                    }
                }
                NativeArray nativeArray = Main.global.history;
                nativeArray.put((int)nativeArray.getLength(), (Scriptable)nativeArray, (Object)string2);
            }
            global.getErr().println();
        } else {
            Main.processFile(context, global, string);
        }
        System.gc();
    }

    public static void processFile(Context context, Scriptable scriptable, String string) {
        if (securityImpl == null) {
            Main.processFileSecure(context, scriptable, string, null);
        } else {
            securityImpl.callProcessFileSecure(context, scriptable, string);
        }
    }

    static void processFileSecure(Context context, Scriptable scriptable, String string, Object object) {
        Reader reader = null;
        try {
            URL uRL = new URL(string);
            InputStream inputStream = uRL.openStream();
            reader = new BufferedReader(new InputStreamReader(inputStream));
        }
        catch (MalformedURLException malformedURLException) {
            reader = null;
        }
        catch (IOException iOException) {
            Context.reportError(ToolErrorReporter.getMessage("msg.couldnt.open.url", string, iOException.toString()));
            exitCode = 4;
            return;
        }
        if (reader == null) {
            try {
                reader = new PushbackReader(new FileReader(string));
                int n = reader.read();
                if (n == 35) {
                    while ((n = reader.read()) != -1 && n != 10 && n != 13) {
                    }
                    ((PushbackReader)reader).unread(n);
                } else {
                    reader.close();
                    reader = new FileReader(string);
                }
                string = new File(string).getCanonicalPath();
            }
            catch (FileNotFoundException fileNotFoundException) {
                Context.reportError(ToolErrorReporter.getMessage("msg.couldnt.open", string));
                exitCode = 4;
                return;
            }
            catch (IOException iOException) {
                global.getErr().println(iOException.toString());
            }
        }
        Main.evaluateScript(context, scriptable, reader, null, string, 1, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object evaluateScript(Context context, Scriptable scriptable, Reader reader, String string, String string2, int n, Object object) {
        Object object2;
        block12: {
            if (!Main.global.initialized) {
                global.init(context);
            }
            object2 = context.getUndefinedValue();
            try {
                if (reader != null) {
                    try {
                        try {
                            object2 = context.evaluateReader(scriptable, reader, string2, n, object);
                            break block12;
                        }
                        finally {
                            reader.close();
                        }
                    }
                    catch (IOException iOException) {
                        global.getErr().println(iOException.toString());
                    }
                    break block12;
                }
                object2 = context.evaluateString(scriptable, string, string2, n, object);
            }
            catch (WrappedException wrappedException) {
                global.getErr().println(wrappedException.getWrappedException().toString());
                wrappedException.printStackTrace();
            }
            catch (EvaluatorException evaluatorException) {
                exitCode = 3;
            }
            catch (RhinoException rhinoException) {
                errorReporter.reportException(rhinoException);
                exitCode = 3;
            }
            catch (VirtualMachineError virtualMachineError) {
                virtualMachineError.printStackTrace();
                String string3 = ToolErrorReporter.getMessage("msg.uncaughtJSException", virtualMachineError.toString());
                exitCode = 3;
                Context.reportError(string3);
            }
        }
        return object2;
    }

    private static void p(String string) {
        global.getOut().println(string);
    }

    public static ScriptableObject getScope() {
        if (!Main.global.initialized) {
            global.init(Context.getCurrentContext());
        }
        return global;
    }

    public static InputStream getIn() {
        return Global.getInstance(Main.getGlobal()).getIn();
    }

    public static void setIn(InputStream inputStream) {
        Global.getInstance(Main.getGlobal()).setIn(inputStream);
    }

    public static PrintStream getOut() {
        return Global.getInstance(Main.getGlobal()).getOut();
    }

    public static void setOut(PrintStream printStream) {
        Global.getInstance(Main.getGlobal()).setOut(printStream);
    }

    public static PrintStream getErr() {
        return Global.getInstance(Main.getGlobal()).getErr();
    }

    public static void setErr(PrintStream printStream) {
        Global.getInstance(Main.getGlobal()).setErr(printStream);
    }

    static {
        exitCode = 0;
        processStdin = true;
        sealedStdLib = false;
        fileList = new Vector(5);
    }

    private static class IProxy
    implements ContextAction {
        private static final int PROCESS_FILES = 1;
        private static final int EVAL_INLINE_SCRIPT = 2;
        private int type;
        String[] args;
        String scriptText;

        IProxy(int n) {
            this.type = n;
        }

        public Object run(Context context) {
            if (this.type == 1) {
                Main.processFiles(context, this.args);
            } else if (this.type == 2) {
                Main.evaluateScript(context, Main.getGlobal(), null, this.scriptText, "<command>", 1, null);
            } else {
                throw Kit.codeBug();
            }
            return null;
        }
    }
}

