/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Decompiler;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.UintMap;
import org.mozilla.javascript.debug.DebuggableScript;

public abstract class NativeFunction
extends BaseFunction {
    public final void initScriptFunction(Context context, Scriptable scriptable, String string) {
        this.functionName = string;
        ScriptRuntime.setFunctionProtoAndParent(this, scriptable);
    }

    public final void initScriptObject() {
        this.functionName = "";
    }

    final String decompile(int n, int n2) {
        String string = this.getEncodedSource();
        if (string == null) {
            return super.decompile(n, n2);
        }
        UintMap uintMap = new UintMap(1);
        uintMap.put(1, n);
        return Decompiler.decompile(string, n2, uintMap);
    }

    public int getLength() {
        int n = this.getParamCount();
        if (this.getLanguageVersion() != 120) {
            return n;
        }
        Context context = Context.getContext();
        NativeCall nativeCall = ScriptRuntime.findFunctionActivation(context, this);
        if (nativeCall == null) {
            return n;
        }
        return nativeCall.originalArgs.length;
    }

    public int getArity() {
        return this.getParamCount();
    }

    public String jsGet_name() {
        return this.getFunctionName();
    }

    public String getEncodedSource() {
        return null;
    }

    public DebuggableScript getDebuggableView() {
        return null;
    }

    protected abstract int getLanguageVersion();

    protected abstract int getParamCount();

    protected abstract int getParamAndVarCount();

    protected abstract String getParamOrVarName(int var1);
}

