/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeString;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class NativeArray
extends IdScriptableObject {
    private static final Object ARRAY_TAG = new Object();
    private static final int Id_length = 1;
    private static final int MAX_INSTANCE_ID = 1;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toLocaleString = 3;
    private static final int Id_toSource = 4;
    private static final int Id_join = 5;
    private static final int Id_reverse = 6;
    private static final int Id_sort = 7;
    private static final int Id_push = 8;
    private static final int Id_pop = 9;
    private static final int Id_shift = 10;
    private static final int Id_unshift = 11;
    private static final int Id_splice = 12;
    private static final int Id_concat = 13;
    private static final int Id_slice = 14;
    private static final int MAX_PROTOTYPE_ID = 14;
    private long length;
    private Object[] dense;
    private static final int maximumDenseLength = 10000;

    static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeArray nativeArray = new NativeArray();
        nativeArray.exportAsJSClass(14, scriptable, bl);
    }

    private NativeArray() {
        this.dense = null;
        this.length = 0L;
    }

    public NativeArray(long l) {
        int n = (int)l;
        if ((long)n == l && n > 0) {
            if (n > 10000) {
                n = 10000;
            }
            this.dense = new Object[n];
            for (int i = 0; i < n; ++i) {
                this.dense[i] = Scriptable.NOT_FOUND;
            }
        }
        this.length = l;
    }

    public NativeArray(Object[] objectArray) {
        this.dense = objectArray;
        this.length = objectArray.length;
    }

    public String getClassName() {
        return "Array";
    }

    protected int getMaxInstanceId() {
        return 1;
    }

    protected int findInstanceIdInfo(String string) {
        if (string.equals("length")) {
            return IdScriptableObject.instanceIdInfo(6, 1);
        }
        return super.findInstanceIdInfo(string);
    }

    protected String getInstanceIdName(int n) {
        if (n == 1) {
            return "length";
        }
        return super.getInstanceIdName(n);
    }

    protected Object getInstanceIdValue(int n) {
        if (n == 1) {
            return ScriptRuntime.wrapNumber(this.length);
        }
        return super.getInstanceIdValue(n);
    }

    protected void setInstanceIdValue(int n, Object object) {
        if (n == 1) {
            this.setLength(object);
            return;
        }
        super.setInstanceIdValue(n, object);
    }

    protected void initPrototypeId(int n) {
        String string;
        int n2;
        switch (n) {
            case 1: {
                n2 = 1;
                string = "constructor";
                break;
            }
            case 2: {
                n2 = 0;
                string = "toString";
                break;
            }
            case 3: {
                n2 = 1;
                string = "toLocaleString";
                break;
            }
            case 4: {
                n2 = 0;
                string = "toSource";
                break;
            }
            case 5: {
                n2 = 1;
                string = "join";
                break;
            }
            case 6: {
                n2 = 0;
                string = "reverse";
                break;
            }
            case 7: {
                n2 = 1;
                string = "sort";
                break;
            }
            case 8: {
                n2 = 1;
                string = "push";
                break;
            }
            case 9: {
                n2 = 1;
                string = "pop";
                break;
            }
            case 10: {
                n2 = 1;
                string = "shift";
                break;
            }
            case 11: {
                n2 = 1;
                string = "unshift";
                break;
            }
            case 12: {
                n2 = 1;
                string = "splice";
                break;
            }
            case 13: {
                n2 = 1;
                string = "concat";
                break;
            }
            case 14: {
                n2 = 1;
                string = "slice";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(ARRAY_TAG, n, string, n2);
    }

    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(ARRAY_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        switch (n) {
            case 1: {
                boolean bl;
                boolean bl2 = bl = scriptable2 == null;
                if (!bl) {
                    return idFunctionObject.construct(context, scriptable, objectArray);
                }
                return NativeArray.jsConstructor(context, scriptable, objectArray);
            }
            case 2: {
                return NativeArray.toStringHelper(context, scriptable, scriptable2, context.hasFeature(4), false);
            }
            case 3: {
                return NativeArray.toStringHelper(context, scriptable, scriptable2, false, true);
            }
            case 4: {
                return NativeArray.toStringHelper(context, scriptable, scriptable2, true, false);
            }
            case 5: {
                return NativeArray.js_join(context, scriptable2, objectArray);
            }
            case 6: {
                return NativeArray.js_reverse(context, scriptable2, objectArray);
            }
            case 7: {
                return NativeArray.js_sort(context, scriptable, scriptable2, objectArray);
            }
            case 8: {
                return NativeArray.js_push(context, scriptable2, objectArray);
            }
            case 9: {
                return NativeArray.js_pop(context, scriptable2, objectArray);
            }
            case 10: {
                return NativeArray.js_shift(context, scriptable2, objectArray);
            }
            case 11: {
                return NativeArray.js_unshift(context, scriptable2, objectArray);
            }
            case 12: {
                return NativeArray.js_splice(context, scriptable, scriptable2, objectArray);
            }
            case 13: {
                return NativeArray.js_concat(context, scriptable, scriptable2, objectArray);
            }
            case 14: {
                return this.js_slice(context, scriptable2, objectArray);
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    public Object get(int n, Scriptable scriptable) {
        if (this.dense != null && 0 <= n && n < this.dense.length) {
            return this.dense[n];
        }
        return super.get(n, scriptable);
    }

    public boolean has(int n, Scriptable scriptable) {
        if (this.dense != null && 0 <= n && n < this.dense.length) {
            return this.dense[n] != Scriptable.NOT_FOUND;
        }
        return super.has(n, scriptable);
    }

    private static long toArrayIndex(String string) {
        long l;
        double d = ScriptRuntime.toNumber(string);
        if (d == d && (double)(l = ScriptRuntime.toUint32(d)) == d && l != 0xFFFFFFFFL && Long.toString(l).equals(string)) {
            return l;
        }
        return -1L;
    }

    public void put(String string, Scriptable scriptable, Object object) {
        long l;
        super.put(string, scriptable, object);
        if (scriptable == this && (l = NativeArray.toArrayIndex(string)) >= this.length) {
            this.length = l + 1L;
        }
    }

    public void put(int n, Scriptable scriptable, Object object) {
        if (scriptable == this && !this.isSealed() && this.dense != null && 0 <= n && n < this.dense.length) {
            this.dense[n] = object;
        } else {
            super.put(n, scriptable, object);
        }
        if (scriptable == this && this.length <= (long)n) {
            this.length = (long)n + 1L;
        }
    }

    public void delete(int n) {
        if (!this.isSealed() && this.dense != null && 0 <= n && n < this.dense.length) {
            this.dense[n] = Scriptable.NOT_FOUND;
        } else {
            super.delete(n);
        }
    }

    public Object[] getIds() {
        Object[] objectArray = super.getIds();
        if (this.dense == null) {
            return objectArray;
        }
        int n = this.dense.length;
        long l = this.length;
        if ((long)n > l) {
            n = (int)l;
        }
        if (n == 0) {
            return objectArray;
        }
        int n2 = objectArray.length;
        Object[] objectArray2 = new Object[n + n2];
        System.arraycopy(this.dense, 0, objectArray2, 0, n);
        int n3 = 0;
        for (int i = 0; i != n; ++i) {
            if (objectArray2[i] == Scriptable.NOT_FOUND) continue;
            objectArray2[n3] = new Integer(i);
            ++n3;
        }
        if (n3 != n) {
            Object[] objectArray3 = new Object[n3 + n2];
            System.arraycopy(objectArray2, 0, objectArray3, 0, n3);
            objectArray2 = objectArray3;
        }
        System.arraycopy(objectArray, 0, objectArray2, n3, n2);
        return objectArray2;
    }

    public Object getDefaultValue(Class clazz) {
        Context context;
        if (clazz == ScriptRuntime.NumberClass && (context = Context.getContext()).getLanguageVersion() == 120) {
            return new Long(this.length);
        }
        return super.getDefaultValue(clazz);
    }

    private static Object jsConstructor(Context context, Scriptable scriptable, Object[] objectArray) {
        if (objectArray.length == 0) {
            return new NativeArray();
        }
        if (context.getLanguageVersion() == 120) {
            return new NativeArray(objectArray);
        }
        Object object = objectArray[0];
        if (objectArray.length > 1 || !(object instanceof Number)) {
            return new NativeArray(objectArray);
        }
        long l = ScriptRuntime.toUint32(object);
        if ((double)l != ((Number)object).doubleValue()) {
            throw Context.reportRuntimeError0("msg.arraylength.bad");
        }
        return new NativeArray(l);
    }

    public long getLength() {
        return this.length;
    }

    public long jsGet_length() {
        return this.getLength();
    }

    private void setLength(Object object) {
        double d = ScriptRuntime.toNumber(object);
        long l = ScriptRuntime.toUint32(d);
        if ((double)l != d) {
            throw Context.reportRuntimeError0("msg.arraylength.bad");
        }
        if (l < this.length) {
            if (this.length - l > 4096L) {
                Object[] objectArray = this.getIds();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object2 = objectArray[i];
                    if (object2 instanceof String) {
                        String string = (String)object2;
                        long l2 = NativeArray.toArrayIndex(string);
                        if (l2 < l) continue;
                        this.delete(string);
                        continue;
                    }
                    int n = (Integer)object2;
                    if ((long)n < l) continue;
                    this.delete(n);
                }
            } else {
                for (long i = l; i < this.length; ++i) {
                    NativeArray.deleteElem(this, i);
                }
            }
        }
        this.length = l;
    }

    static long getLengthProperty(Context context, Scriptable scriptable) {
        if (scriptable instanceof NativeString) {
            return ((NativeString)scriptable).getLength();
        }
        if (scriptable instanceof NativeArray) {
            return ((NativeArray)scriptable).getLength();
        }
        if (!(scriptable instanceof Scriptable)) {
            return 0L;
        }
        return ScriptRuntime.toUint32(ScriptRuntime.getObjectProp(scriptable, "length", context));
    }

    private static Object setLengthProperty(Context context, Scriptable scriptable, long l) {
        return ScriptRuntime.setObjectProp(scriptable, "length", (Object)ScriptRuntime.wrapNumber(l), context);
    }

    private static void deleteElem(Scriptable scriptable, long l) {
        int n = (int)l;
        if ((long)n == l) {
            scriptable.delete(n);
        } else {
            scriptable.delete(Long.toString(l));
        }
    }

    private static Object getElem(Context context, Scriptable scriptable, long l) {
        if (l > Integer.MAX_VALUE) {
            String string = Long.toString(l);
            return ScriptRuntime.getObjectProp(scriptable, string, context);
        }
        return ScriptRuntime.getObjectIndex(scriptable, (int)l, context);
    }

    private static void setElem(Context context, Scriptable scriptable, long l, Object object) {
        if (l > Integer.MAX_VALUE) {
            String string = Long.toString(l);
            ScriptRuntime.setObjectProp(scriptable, string, object, context);
        } else {
            ScriptRuntime.setObjectIndex(scriptable, (int)l, object, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String toStringHelper(Context context, Scriptable scriptable, Scriptable scriptable2, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4;
        String string;
        long l = NativeArray.getLengthProperty(context, scriptable2);
        StringBuffer stringBuffer = new StringBuffer(256);
        if (bl) {
            stringBuffer.append('[');
            string = ", ";
        } else {
            string = ",";
        }
        boolean bl5 = false;
        long l2 = 0L;
        if (context.iterating == null) {
            bl4 = true;
            bl3 = false;
            context.iterating = new ObjToIntMap(31);
        } else {
            bl4 = false;
            bl3 = context.iterating.has(scriptable2);
        }
        try {
            if (!bl3) {
                context.iterating.put(scriptable2, 0);
                for (l2 = 0L; l2 < l; ++l2) {
                    Object object;
                    Object object2;
                    if (l2 > 0L) {
                        stringBuffer.append(string);
                    }
                    if ((object2 = NativeArray.getElem(context, scriptable2, l2)) == null || object2 == Undefined.instance) {
                        bl5 = false;
                        continue;
                    }
                    bl5 = true;
                    if (bl) {
                        stringBuffer.append(ScriptRuntime.uneval(context, scriptable, object2));
                        continue;
                    }
                    if (object2 instanceof String) {
                        object = (String)object2;
                        if (bl) {
                            stringBuffer.append('\"');
                            stringBuffer.append(ScriptRuntime.escapeString((String)object));
                            stringBuffer.append('\"');
                            continue;
                        }
                        stringBuffer.append((String)object);
                        continue;
                    }
                    if (bl2 && object2 != Undefined.instance && object2 != null) {
                        object = ScriptRuntime.getPropFunctionAndThis(object2, "toLocaleString", context);
                        Scriptable scriptable3 = ScriptRuntime.lastStoredScriptable(context);
                        object2 = object.call(context, scriptable, scriptable3, ScriptRuntime.emptyArgs);
                    }
                    stringBuffer.append(ScriptRuntime.toString(object2));
                }
            }
        }
        finally {
            if (bl4) {
                context.iterating = null;
            }
        }
        if (bl) {
            if (!bl5 && l2 > 0L) {
                stringBuffer.append(", ]");
            } else {
                stringBuffer.append(']');
            }
        }
        return stringBuffer.toString();
    }

    private static String js_join(Context context, Scriptable scriptable, Object[] objectArray) {
        String string;
        int n;
        long l = NativeArray.getLengthProperty(context, scriptable);
        if (l != (long)(n = (int)l)) {
            throw Context.reportRuntimeError1("msg.arraylength.too.big", String.valueOf(l));
        }
        String string2 = objectArray.length < 1 || objectArray[0] == Undefined.instance ? "," : ScriptRuntime.toString(objectArray[0]);
        if (n == 0) {
            return "";
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        for (int i = 0; i != n; ++i) {
            Object object = NativeArray.getElem(context, scriptable, i);
            if (object == null || object == Undefined.instance) continue;
            string = ScriptRuntime.toString(object);
            n2 += string.length();
            stringArray[i] = string;
        }
        StringBuffer stringBuffer = new StringBuffer(n2 += (n - 1) * string2.length());
        for (int i = 0; i != n; ++i) {
            if (i != 0) {
                stringBuffer.append(string2);
            }
            if ((string = stringArray[i]) == null) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private static Scriptable js_reverse(Context context, Scriptable scriptable, Object[] objectArray) {
        long l = NativeArray.getLengthProperty(context, scriptable);
        long l2 = l / 2L;
        for (long i = 0L; i < l2; ++i) {
            long l3 = l - i - 1L;
            Object object = NativeArray.getElem(context, scriptable, i);
            Object object2 = NativeArray.getElem(context, scriptable, l3);
            NativeArray.setElem(context, scriptable, i, object2);
            NativeArray.setElem(context, scriptable, l3, object);
        }
        return scriptable;
    }

    private static Scriptable js_sort(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Object[] objectArray2;
        Object object;
        long l = NativeArray.getLengthProperty(context, scriptable2);
        if (l <= 1L) {
            return scriptable2;
        }
        if (objectArray.length > 0 && Undefined.instance != objectArray[0]) {
            object = objectArray[0];
            objectArray2 = new Object[2];
        } else {
            object = null;
            objectArray2 = null;
        }
        if (l >= Integer.MAX_VALUE) {
            NativeArray.heapsort_extended(context, scriptable, scriptable2, l, object, objectArray2);
        } else {
            int n;
            int n2 = (int)l;
            Object[] objectArray3 = new Object[n2];
            for (n = 0; n != n2; ++n) {
                objectArray3[n] = NativeArray.getElem(context, scriptable2, n);
            }
            NativeArray.heapsort(context, scriptable, objectArray3, n2, object, objectArray2);
            for (n = 0; n != n2; ++n) {
                NativeArray.setElem(context, scriptable2, n, objectArray3[n]);
            }
        }
        return scriptable2;
    }

    private static boolean isBigger(Context context, Scriptable scriptable, Object object, Object object2, Object object3, Object[] objectArray) {
        Scriptable scriptable2;
        Scriptable scriptable3;
        if (object3 == null) {
            if (objectArray != null) {
                Kit.codeBug();
            }
        } else if (objectArray == null || objectArray.length != 2) {
            Kit.codeBug();
        }
        if ((scriptable3 = Undefined.instance) == object2) {
            return false;
        }
        if (scriptable3 == object) {
            return true;
        }
        if (object3 == null) {
            String string;
            String string2 = ScriptRuntime.toString(object);
            return string2.compareTo(string = ScriptRuntime.toString(object2)) > 0;
        }
        objectArray[0] = object;
        objectArray[1] = object2;
        Function function = ScriptRuntime.getValueFunctionAndThis(object3, context);
        Object object4 = function.call(context, scriptable, scriptable2 = ScriptRuntime.lastStoredScriptable(context), objectArray);
        double d = ScriptRuntime.toNumber(object4);
        return d > 0.0;
    }

    private static void heapsort(Context context, Scriptable scriptable, Object[] objectArray, int n, Object object, Object[] objectArray2) {
        Object object2;
        if (n <= 1) {
            Kit.codeBug();
        }
        int n2 = n / 2;
        while (n2 != 0) {
            object2 = objectArray[--n2];
            NativeArray.heapify(context, scriptable, object2, objectArray, n2, n, object, objectArray2);
        }
        n2 = n;
        while (n2 != 1) {
            object2 = objectArray[--n2];
            objectArray[n2] = objectArray[0];
            NativeArray.heapify(context, scriptable, object2, objectArray, 0, n2, object, objectArray2);
        }
    }

    private static void heapify(Context context, Scriptable scriptable, Object object, Object[] objectArray, int n, int n2, Object object2, Object[] objectArray2) {
        int n3;
        while ((n3 = n * 2 + 1) < n2) {
            Object object3;
            Object object4 = objectArray[n3];
            if (n3 + 1 < n2 && NativeArray.isBigger(context, scriptable, object3 = objectArray[n3 + 1], object4, object2, objectArray2)) {
                ++n3;
                object4 = object3;
            }
            if (!NativeArray.isBigger(context, scriptable, object4, object, object2, objectArray2)) break;
            objectArray[n] = object4;
            n = n3;
        }
        objectArray[n] = object;
    }

    private static void heapsort_extended(Context context, Scriptable scriptable, Scriptable scriptable2, long l, Object object, Object[] objectArray) {
        Object object2;
        if (l <= 1L) {
            Kit.codeBug();
        }
        long l2 = l / 2L;
        while (l2 != 0L) {
            object2 = NativeArray.getElem(context, scriptable2, --l2);
            NativeArray.heapify_extended(context, scriptable, object2, scriptable2, l2, l, object, objectArray);
        }
        l2 = l;
        while (l2 != 1L) {
            object2 = NativeArray.getElem(context, scriptable2, --l2);
            NativeArray.setElem(context, scriptable2, l2, NativeArray.getElem(context, scriptable2, 0L));
            NativeArray.heapify_extended(context, scriptable, object2, scriptable2, 0L, l2, object, objectArray);
        }
    }

    private static void heapify_extended(Context context, Scriptable scriptable, Object object, Scriptable scriptable2, long l, long l2, Object object2, Object[] objectArray) {
        long l3;
        while ((l3 = l * 2L + 1L) < l2) {
            Object object3;
            Object object4 = NativeArray.getElem(context, scriptable2, l3);
            if (l3 + 1L < l2 && NativeArray.isBigger(context, scriptable, object3 = NativeArray.getElem(context, scriptable2, l3 + 1L), object4, object2, objectArray)) {
                ++l3;
                object4 = object3;
            }
            if (!NativeArray.isBigger(context, scriptable, object4, object, object2, objectArray)) break;
            NativeArray.setElem(context, scriptable2, l, object4);
            l = l3;
        }
        NativeArray.setElem(context, scriptable2, l, object);
    }

    private static Object js_push(Context context, Scriptable scriptable, Object[] objectArray) {
        long l = NativeArray.getLengthProperty(context, scriptable);
        for (int i = 0; i < objectArray.length; ++i) {
            NativeArray.setElem(context, scriptable, l + (long)i, objectArray[i]);
        }
        Object object = NativeArray.setLengthProperty(context, scriptable, l += (long)objectArray.length);
        if (context.getLanguageVersion() == 120) {
            return objectArray.length == 0 ? Context.getUndefinedValue() : objectArray[objectArray.length - 1];
        }
        return object;
    }

    private static Object js_pop(Context context, Scriptable scriptable, Object[] objectArray) {
        long l = NativeArray.getLengthProperty(context, scriptable);
        Object object = l > 0L ? NativeArray.getElem(context, scriptable, --l) : Context.getUndefinedValue();
        NativeArray.setLengthProperty(context, scriptable, l);
        return object;
    }

    private static Object js_shift(Context context, Scriptable scriptable, Object[] objectArray) {
        Object object;
        long l = NativeArray.getLengthProperty(context, scriptable);
        if (l > 0L) {
            long l2 = 0L;
            object = NativeArray.getElem(context, scriptable, l2);
            if (--l > 0L) {
                for (l2 = 1L; l2 <= l; ++l2) {
                    Object object2 = NativeArray.getElem(context, scriptable, l2);
                    NativeArray.setElem(context, scriptable, l2 - 1L, object2);
                }
            }
        } else {
            object = Context.getUndefinedValue();
        }
        NativeArray.setLengthProperty(context, scriptable, l);
        return object;
    }

    private static Object js_unshift(Context context, Scriptable scriptable, Object[] objectArray) {
        long l = NativeArray.getLengthProperty(context, scriptable);
        int n = objectArray.length;
        if (objectArray.length > 0) {
            if (l > 0L) {
                for (long i = l - 1L; i >= 0L; --i) {
                    Object object = NativeArray.getElem(context, scriptable, i);
                    NativeArray.setElem(context, scriptable, i + (long)n, object);
                }
            }
            for (int i = 0; i < objectArray.length; ++i) {
                NativeArray.setElem(context, scriptable, i, objectArray[i]);
            }
            return NativeArray.setLengthProperty(context, scriptable, l += (long)objectArray.length);
        }
        return ScriptRuntime.wrapNumber(l);
    }

    private static Object js_splice(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Object object;
        long l;
        long l2;
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        Object object2 = ScriptRuntime.newObject(context, scriptable, "Array", null);
        int n = objectArray.length;
        if (n == 0) {
            return object2;
        }
        long l3 = NativeArray.getLengthProperty(context, scriptable2);
        long l4 = NativeArray.toSliceIndex(ScriptRuntime.toInteger(objectArray[0]), l3);
        --n;
        if (objectArray.length == 1) {
            l2 = l3 - l4;
        } else {
            double d = ScriptRuntime.toInteger(objectArray[1]);
            l2 = d < 0.0 ? 0L : (d > (double)(l3 - l4) ? l3 - l4 : (long)d);
            --n;
        }
        long l5 = l4 + l2;
        if (l2 != 0L) {
            if (l2 == 1L && context.getLanguageVersion() == 120) {
                object2 = NativeArray.getElem(context, scriptable2, l4);
            } else {
                for (l = l4; l != l5; ++l) {
                    Scriptable scriptable3 = (Scriptable)object2;
                    Object object3 = NativeArray.getElem(context, scriptable2, l);
                    NativeArray.setElem(context, scriptable3, l - l4, object3);
                }
            }
        } else if (l2 == 0L && context.getLanguageVersion() == 120) {
            object2 = Context.getUndefinedValue();
        }
        l = (long)n - l2;
        if (l > 0L) {
            for (long i = l3 - 1L; i >= l5; --i) {
                object = NativeArray.getElem(context, scriptable2, i);
                NativeArray.setElem(context, scriptable2, i + l, object);
            }
        } else if (l < 0L) {
            for (long i = l5; i < l3; ++i) {
                object = NativeArray.getElem(context, scriptable2, i);
                NativeArray.setElem(context, scriptable2, i + l, object);
            }
        }
        int n2 = objectArray.length - n;
        for (int i = 0; i < n; ++i) {
            NativeArray.setElem(context, scriptable2, l4 + (long)i, objectArray[i + n2]);
        }
        NativeArray.setLengthProperty(context, scriptable2, l3 + l);
        return object2;
    }

    private static Scriptable js_concat(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        long l;
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        Function function = ScriptRuntime.getExistingCtor(context, scriptable, "Array");
        Scriptable scriptable3 = function.construct(context, scriptable, ScriptRuntime.emptyArgs);
        long l2 = 0L;
        if (ScriptRuntime.instanceOf(scriptable2, function, context, scriptable)) {
            l = NativeArray.getLengthProperty(context, scriptable2);
            for (l2 = 0L; l2 < l; ++l2) {
                Object object = NativeArray.getElem(context, scriptable2, l2);
                NativeArray.setElem(context, scriptable3, l2, object);
            }
        } else {
            NativeArray.setElem(context, scriptable3, l2++, scriptable2);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (ScriptRuntime.instanceOf(objectArray[i], function, context, scriptable)) {
                Scriptable scriptable4 = (Scriptable)objectArray[i];
                l = NativeArray.getLengthProperty(context, scriptable4);
                long l3 = 0L;
                while (l3 < l) {
                    Object object = NativeArray.getElem(context, scriptable4, l3);
                    NativeArray.setElem(context, scriptable3, l2, object);
                    ++l3;
                    ++l2;
                }
                continue;
            }
            NativeArray.setElem(context, scriptable3, l2++, objectArray[i]);
        }
        return scriptable3;
    }

    private Scriptable js_slice(Context context, Scriptable scriptable, Object[] objectArray) {
        long l;
        long l2;
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(this);
        Scriptable scriptable3 = ScriptRuntime.newObject(context, scriptable2, "Array", null);
        long l3 = NativeArray.getLengthProperty(context, scriptable);
        if (objectArray.length == 0) {
            l2 = 0L;
            l = l3;
        } else {
            l2 = NativeArray.toSliceIndex(ScriptRuntime.toInteger(objectArray[0]), l3);
            l = objectArray.length == 1 ? l3 : NativeArray.toSliceIndex(ScriptRuntime.toInteger(objectArray[1]), l3);
        }
        for (long i = l2; i < l; ++i) {
            Object object = NativeArray.getElem(context, scriptable, i);
            NativeArray.setElem(context, scriptable3, i - l2, object);
        }
        return scriptable3;
    }

    private static long toSliceIndex(double d, long l) {
        long l2 = d < 0.0 ? (d + (double)l < 0.0 ? 0L : (long)(d + (double)l)) : (d > (double)l ? l : (long)d);
        return l2;
    }

    protected int findPrototypeId(String string) {
        int n = 0;
        String string2 = null;
        switch (string.length()) {
            case 3: {
                string2 = "pop";
                n = 9;
                break;
            }
            case 4: {
                char c = string.charAt(0);
                if (c == 'j') {
                    string2 = "join";
                    n = 5;
                    break;
                }
                if (c == 'p') {
                    string2 = "push";
                    n = 8;
                    break;
                }
                if (c != 's') break;
                string2 = "sort";
                n = 7;
                break;
            }
            case 5: {
                char c = string.charAt(1);
                if (c == 'h') {
                    string2 = "shift";
                    n = 10;
                    break;
                }
                if (c != 'l') break;
                string2 = "slice";
                n = 14;
                break;
            }
            case 6: {
                char c = string.charAt(0);
                if (c == 'c') {
                    string2 = "concat";
                    n = 13;
                    break;
                }
                if (c != 's') break;
                string2 = "splice";
                n = 12;
                break;
            }
            case 7: {
                char c = string.charAt(0);
                if (c == 'r') {
                    string2 = "reverse";
                    n = 6;
                    break;
                }
                if (c != 'u') break;
                string2 = "unshift";
                n = 11;
                break;
            }
            case 8: {
                char c = string.charAt(3);
                if (c == 'o') {
                    string2 = "toSource";
                    n = 4;
                    break;
                }
                if (c != 't') break;
                string2 = "toString";
                n = 2;
                break;
            }
            case 11: {
                string2 = "constructor";
                n = 1;
                break;
            }
            case 14: {
                string2 = "toLocaleString";
                n = 3;
                break;
            }
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        return n;
    }
}

