/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.ScriptRuntime;

final class IRFactory {
    private Parser parser;
    private static final int LOOP_DO_WHILE = 0;
    private static final int LOOP_WHILE = 1;
    private static final int LOOP_FOR = 2;
    private static final int ALWAYS_TRUE_BOOLEAN = 1;
    private static final int ALWAYS_FALSE_BOOLEAN = -1;

    IRFactory(Parser parser) {
        this.parser = parser;
    }

    ScriptOrFnNode createScript() {
        return new ScriptOrFnNode(132);
    }

    void initScript(ScriptOrFnNode scriptOrFnNode, Node node) {
        Node node2 = node.getFirstChild();
        if (node2 != null) {
            scriptOrFnNode.addChildrenToBack(node2);
        }
    }

    Node createLeaf(int n) {
        return new Node(n);
    }

    Node createLeaf(int n, int n2) {
        return new Node(n, n2);
    }

    Node createSwitch(Node node, int n) {
        Node.Jump jump = new Node.Jump(110, node, n);
        Node node2 = new Node(125, jump);
        return node2;
    }

    void addSwitchCase(Node node, Node node2, Node node3) {
        if (node.getType() != 125) {
            throw Kit.codeBug();
        }
        Node.Jump jump = (Node.Jump)node.getFirstChild();
        if (jump.getType() != 110) {
            throw Kit.codeBug();
        }
        Node node4 = Node.newTarget();
        if (node2 != null) {
            Node.Jump jump2 = new Node.Jump(111, node2);
            jump2.target = node4;
            jump.addChildToBack(jump2);
        } else {
            jump.setDefault(node4);
        }
        node.addChildToBack(node4);
        node.addChildToBack(node3);
    }

    void closeSwitch(Node node) {
        Node node2;
        if (node.getType() != 125) {
            throw Kit.codeBug();
        }
        Node.Jump jump = (Node.Jump)node.getFirstChild();
        if (jump.getType() != 110) {
            throw Kit.codeBug();
        }
        jump.target = node2 = Node.newTarget();
        Node node3 = jump.getDefault();
        if (node3 == null) {
            node3 = node2;
        }
        node.addChildAfter(this.makeJump(5, node3), jump);
        node.addChildToBack(node2);
    }

    Node createVariables(int n) {
        return new Node(118, n);
    }

    Node createExprStatement(Node node, int n) {
        int n2 = this.parser.insideFunction() ? 129 : 130;
        return new Node(n2, node, n);
    }

    Node createExprStatementNoReturn(Node node, int n) {
        return new Node(129, node, n);
    }

    Node createDefaultNamespace(Node node, int n) {
        this.setRequiresActivation();
        Node node2 = this.createUnary(70, node);
        Node node3 = this.createExprStatement(node2, n);
        return node3;
    }

    Node createName(String string) {
        this.checkActivationName(string, 38);
        return Node.newString(38, string);
    }

    Node createString(String string) {
        return Node.newString(string);
    }

    Node createNumber(double d) {
        return Node.newNumber(d);
    }

    Node createCatch(String string, Node node, Node node2, int n) {
        if (node == null) {
            node = new Node(124);
        }
        return new Node(120, this.createName(string), node, node2, n);
    }

    Node createThrow(Node node, int n) {
        return new Node(49, node, n);
    }

    Node createReturn(Node node, int n) {
        return node == null ? new Node(4, n) : new Node(4, node, n);
    }

    Node createLabel(int n) {
        return new Node.Jump(126, n);
    }

    Node getLabelLoop(Node node) {
        return ((Node.Jump)node).getLoop();
    }

    Node createLabeledStatement(Node node, Node node2) {
        Node.Jump jump = (Node.Jump)node;
        Node node3 = Node.newTarget();
        Node node4 = new Node(125, (Node)jump, node2, node3);
        jump.target = node3;
        return node4;
    }

    Node createBreak(Node node, int n) {
        Node.Jump jump;
        Node.Jump jump2 = new Node.Jump(116, n);
        int n2 = node.getType();
        if (n2 == 128 || n2 == 126) {
            jump = (Node.Jump)node;
        } else if (n2 == 125 && node.getFirstChild().getType() == 110) {
            jump = (Node.Jump)node.getFirstChild();
        } else {
            throw Kit.codeBug();
        }
        jump2.setJumpStatement(jump);
        return jump2;
    }

    Node createContinue(Node node, int n) {
        if (node.getType() != 128) {
            Kit.codeBug();
        }
        Node.Jump jump = new Node.Jump(117, n);
        jump.setJumpStatement((Node.Jump)node);
        return jump;
    }

    Node createBlock(int n) {
        return new Node(125, n);
    }

    FunctionNode createFunction(String string) {
        return new FunctionNode(string);
    }

    Node initFunction(FunctionNode functionNode, int n, Node node, int n2) {
        Node node2;
        String string;
        Node node3;
        functionNode.itsFunctionType = n2;
        functionNode.addChildToBack(node);
        int n3 = functionNode.getFunctionCount();
        if (n3 != 0) {
            functionNode.itsNeedsActivation = true;
            for (int i = 0; i != n3; ++i) {
                String string2;
                node3 = functionNode.getFunctionNode(i);
                if (((FunctionNode)node3).getFunctionType() != 3 || (string2 = ((FunctionNode)node3).getFunctionName()) == null || string2.length() == 0) continue;
                functionNode.removeParamOrVar(string2);
            }
        }
        if (n2 == 2 && (string = functionNode.getFunctionName()) != null && string.length() != 0 && !functionNode.hasParamOrVar(string)) {
            functionNode.addVar(string);
            node3 = new Node(129, new Node(55, Node.newString(string), new Node(61)));
            node.addChildrenToFront(node3);
        }
        if ((node2 = node.getLastChild()) == null || node2.getType() != 4) {
            node.addChildToBack(new Node(4));
        }
        node3 = Node.newString(105, functionNode.getFunctionName());
        node3.putIntProp(1, n);
        return node3;
    }

    void addChildToBack(Node node, Node node2) {
        node.addChildToBack(node2);
    }

    Node createLoopNode(Node node, int n) {
        Node.Jump jump = new Node.Jump(128, n);
        if (node != null) {
            ((Node.Jump)node).setLoop(jump);
        }
        return jump;
    }

    Node createWhile(Node node, Node node2, Node node3) {
        return this.createLoop((Node.Jump)node, 1, node3, node2, null, null);
    }

    Node createDoWhile(Node node, Node node2, Node node3) {
        return this.createLoop((Node.Jump)node, 0, node2, node3, null, null);
    }

    Node createFor(Node node, Node node2, Node node3, Node node4, Node node5) {
        return this.createLoop((Node.Jump)node, 2, node5, node3, node2, node4);
    }

    private Node createLoop(Node.Jump jump, int n, Node node, Node node2, Node node3, Node node4) {
        Node node5 = Node.newTarget();
        Node node6 = Node.newTarget();
        if (n == 2 && node2.getType() == 124) {
            node2 = new Node(44);
        }
        Node.Jump jump2 = new Node.Jump(6, node2);
        jump2.target = node5;
        Node node7 = Node.newTarget();
        jump.addChildToBack(node5);
        jump.addChildrenToBack(node);
        if (n == 1 || n == 2) {
            jump.addChildrenToBack(new Node(124, jump.getLineno()));
        }
        jump.addChildToBack(node6);
        jump.addChildToBack(jump2);
        jump.addChildToBack(node7);
        jump.target = node7;
        Node node8 = node6;
        if (n == 1 || n == 2) {
            jump.addChildToFront(this.makeJump(5, node6));
            if (n == 2) {
                if (node3.getType() != 124) {
                    if (node3.getType() != 118) {
                        node3 = new Node(129, node3);
                    }
                    jump.addChildToFront(node3);
                }
                Node node9 = Node.newTarget();
                jump.addChildAfter(node9, node);
                if (node4.getType() != 124) {
                    node4 = new Node(129, node4);
                    jump.addChildAfter(node4, node9);
                }
                node8 = node9;
            }
        }
        jump.setContinue(node8);
        return jump;
    }

    Node createForIn(Node node, Node node2, Node node3, Node node4, boolean bl) {
        Node node5;
        Node node6;
        int n = node2.getType();
        if (n == 118) {
            node6 = node2.getLastChild();
            if (node2.getFirstChild() != node6) {
                this.parser.reportError("msg.mult.index");
            }
            node5 = Node.newString(38, node6.getString());
        } else {
            node5 = this.makeReference(node2);
            if (node5 == null) {
                this.parser.reportError("msg.bad.for.in.lhs");
                return node3;
            }
        }
        node6 = new Node(137);
        int n2 = bl ? 58 : 57;
        Node node7 = new Node(n2, node3);
        node7.putProp(3, node6);
        Node node8 = new Node(59);
        node8.putProp(3, node6);
        Node node9 = new Node(60);
        node9.putProp(3, node6);
        Node node10 = new Node(125);
        Node node11 = this.simpleAssignment(node5, node9);
        node10.addChildToBack(new Node(129, node11));
        node10.addChildToBack(node4);
        node = this.createWhile(node, node8, node10);
        node.addChildToFront(node7);
        if (n == 118) {
            node.addChildToFront(node2);
        }
        node6.addChildToBack(node);
        return node6;
    }

    Node createTryCatchFinally(Node node, Node node2, Node node3, int n) {
        Node node4;
        Node node5;
        Node node6;
        boolean bl;
        boolean bl2 = bl = node3 != null && (node3.getType() != 125 || node3.hasChildren());
        if (node.getType() == 125 && !node.hasChildren() && !bl) {
            return node;
        }
        boolean bl3 = node2.hasChildren();
        if (!bl && !bl3) {
            return node;
        }
        Node node7 = new Node(137);
        Node.Jump jump = new Node.Jump(77, node, n);
        jump.putProp(3, node7);
        if (bl3) {
            node6 = Node.newTarget();
            jump.addChildToBack(this.makeJump(5, node6));
            jump.target = node5 = Node.newTarget();
            jump.addChildToBack(node5);
            node4 = new Node(137);
            Node node8 = node2.getFirstChild();
            boolean bl4 = false;
            int n2 = 0;
            while (node8 != null) {
                Node node9;
                int n3 = node8.getLineno();
                Node node10 = node8.getFirstChild();
                Node node11 = node10.getNext();
                Node node12 = node11.getNext();
                node8.removeChild(node10);
                node8.removeChild(node11);
                node8.removeChild(node12);
                node12.addChildToBack(new Node(3));
                node12.addChildToBack(this.makeJump(5, node6));
                if (node11.getType() == 124) {
                    node9 = node12;
                    bl4 = true;
                } else {
                    node9 = this.createIf(node11, node12, null, n3);
                }
                Node node13 = new Node(56, node10, this.createUseLocal(node7));
                node13.putProp(3, node4);
                node13.putIntProp(14, n2);
                node4.addChildToBack(node13);
                node4.addChildToBack(this.createWith(this.createUseLocal(node4), node9, n3));
                node8 = node8.getNext();
                ++n2;
            }
            jump.addChildToBack(node4);
            if (!bl4) {
                Node node14 = new Node(50);
                node14.putProp(3, node7);
                jump.addChildToBack(node14);
            }
            jump.addChildToBack(node6);
        }
        if (bl) {
            node6 = Node.newTarget();
            jump.setFinally(node6);
            jump.addChildToBack(this.makeJump(131, node6));
            node5 = Node.newTarget();
            jump.addChildToBack(this.makeJump(5, node5));
            jump.addChildToBack(node6);
            node4 = new Node(121, node3);
            node4.putProp(3, node7);
            jump.addChildToBack(node4);
            jump.addChildToBack(node5);
        }
        node7.addChildToBack(jump);
        return node7;
    }

    Node createWith(Node node, Node node2, int n) {
        this.setRequiresActivation();
        Node node3 = new Node(125, n);
        node3.addChildToBack(new Node(2, node));
        Node node4 = new Node(119, node2, n);
        node3.addChildrenToBack(node4);
        node3.addChildToBack(new Node(3));
        return node3;
    }

    public Node createDotQuery(Node node, Node node2, int n) {
        this.setRequiresActivation();
        Node node3 = new Node(142, node, node2, n);
        return node3;
    }

    Node createArrayLiteral(ObjArray objArray, int n) {
        int n2 = objArray.size();
        int[] nArray = null;
        if (n != 0) {
            nArray = new int[n];
        }
        Node node = new Node(63);
        int n3 = 0;
        for (int i = 0; i != n2; ++i) {
            Node node2 = (Node)objArray.get(i);
            if (node2 != null) {
                node.addChildToBack(node2);
                continue;
            }
            nArray[n3] = i;
            ++n3;
        }
        if (n != 0) {
            node.putProp(11, nArray);
        }
        return node;
    }

    Node createObjectLiteral(ObjArray objArray) {
        Object[] objectArray;
        int n = objArray.size() / 2;
        Node node = new Node(64);
        if (n == 0) {
            objectArray = ScriptRuntime.emptyArgs;
        } else {
            objectArray = new Object[n];
            for (int i = 0; i != n; ++i) {
                objectArray[i] = objArray.get(2 * i);
                Node node2 = (Node)objArray.get(2 * i + 1);
                node.addChildToBack(node2);
            }
        }
        node.putProp(12, objectArray);
        return node;
    }

    Node createRegExp(int n) {
        Node node = new Node(47);
        node.putIntProp(4, n);
        return node;
    }

    Node createIf(Node node, Node node2, Node node3, int n) {
        int n2 = IRFactory.isAlwaysDefinedBoolean(node);
        if (n2 == 1) {
            return node2;
        }
        if (n2 == -1) {
            if (node3 != null) {
                return node3;
            }
            return new Node(125, n);
        }
        Node node4 = new Node(125, n);
        Node node5 = Node.newTarget();
        Node.Jump jump = new Node.Jump(7, node);
        jump.target = node5;
        node4.addChildToBack(jump);
        node4.addChildrenToBack(node2);
        if (node3 != null) {
            Node node6 = Node.newTarget();
            node4.addChildToBack(this.makeJump(5, node6));
            node4.addChildToBack(node5);
            node4.addChildrenToBack(node3);
            node4.addChildToBack(node6);
        } else {
            node4.addChildToBack(node5);
        }
        return node4;
    }

    Node createCondExpr(Node node, Node node2, Node node3) {
        int n = IRFactory.isAlwaysDefinedBoolean(node);
        if (n == 1) {
            return node2;
        }
        if (n == -1) {
            return node3;
        }
        return new Node(98, node, node2, node3);
    }

    Node createUnary(int n, Node node) {
        int n2 = node.getType();
        switch (n) {
            case 31: {
                Node node2;
                if (n2 == 38) {
                    node.setType(48);
                    Node node3 = node;
                    Node node4 = Node.newString(node.getString());
                    node2 = new Node(n, node3, node4);
                } else if (n2 == 33 || n2 == 35) {
                    Node node5 = node.getFirstChild();
                    Node node6 = node.getLastChild();
                    node.removeChild(node5);
                    node.removeChild(node6);
                    node2 = new Node(n, node5, node6);
                } else if (n2 == 65) {
                    Node node7 = node.getFirstChild();
                    node.removeChild(node7);
                    node2 = new Node(67, node7);
                } else {
                    node2 = new Node(44);
                }
                return node2;
            }
            case 32: {
                if (n2 != 38) break;
                node.setType(133);
                return node;
            }
            case 27: {
                if (n2 != 39) break;
                int n3 = ScriptRuntime.toInt32(node.getDouble());
                node.setDouble(~n3);
                return node;
            }
            case 29: {
                if (n2 != 39) break;
                node.setDouble(-node.getDouble());
                return node;
            }
            case 26: {
                int n4 = IRFactory.isAlwaysDefinedBoolean(node);
                if (n4 == 0) break;
                int n5 = n4 == 1 ? 43 : 44;
                if (n2 == 44 || n2 == 43) {
                    node.setType(n5);
                    return node;
                }
                return new Node(n5);
            }
        }
        return new Node(n, node);
    }

    Node createCallOrNew(int n, Node node) {
        Object object;
        int n2 = 0;
        if (node.getType() == 38) {
            object = node.getString();
            if (((String)object).equals("eval")) {
                n2 = 1;
            } else if (((String)object).equals("With")) {
                n2 = 2;
            }
        } else if (node.getType() == 33 && ((String)(object = node.getLastChild().getString())).equals("eval")) {
            n2 = 1;
        }
        object = new Node(n, node);
        if (n2 != 0) {
            this.setRequiresActivation();
            ((Node)object).putIntProp(10, n2);
        }
        return object;
    }

    Node createIncDec(int n, boolean bl, Node node) {
        if ((node = this.makeReference(node)) == null) {
            String string = n == 103 ? "msg.bad.decr" : "msg.bad.incr";
            this.parser.reportError(string);
            return null;
        }
        int n2 = node.getType();
        switch (n2) {
            case 33: 
            case 35: 
            case 38: 
            case 65: {
                Node node2 = new Node(n, node);
                int n3 = 0;
                if (n == 103) {
                    n3 |= 1;
                }
                if (bl) {
                    n3 |= 2;
                }
                node2.putIntProp(13, n3);
                return node2;
            }
        }
        throw Kit.codeBug();
    }

    Node createPropertyGet(Node node, String string, String string2, int n) {
        if (string == null && n == 0) {
            if (node == null) {
                return this.createName(string2);
            }
            this.checkActivationName(string2, 33);
            if (ScriptRuntime.isSpecialProperty(string2)) {
                Node node2 = new Node(69, node);
                node2.putProp(17, string2);
                return new Node(65, node2);
            }
            return new Node(33, node, this.createString(string2));
        }
        Node node3 = this.createString(string2);
        return this.createMemberRefGet(node, string, node3, n |= 1);
    }

    Node createElementGet(Node node, String string, Node node2, int n) {
        if (string == null && n == 0) {
            if (node == null) {
                throw Kit.codeBug();
            }
            return new Node(35, node, node2);
        }
        return this.createMemberRefGet(node, string, node2, n);
    }

    private Node createMemberRefGet(Node node, String string, Node node2, int n) {
        Node node3 = null;
        if (string != null) {
            node3 = string.equals("*") ? new Node(41) : this.createName(string);
        }
        Node node4 = node == null ? (string == null ? new Node(75, node2) : new Node(76, node3, node2)) : (string == null ? new Node(73, node, node2) : new Node(74, node, node3, node2));
        if (n != 0) {
            node4.putIntProp(16, n);
        }
        return new Node(65, node4);
    }

    Node createBinary(int n, Node node, Node node2) {
        switch (n) {
            case 21: {
                if (node.type == 40) {
                    String string;
                    if (node2.type == 40) {
                        string = node2.getString();
                    } else {
                        if (node2.type != 39) break;
                        string = ScriptRuntime.numberToString(node2.getDouble(), 10);
                    }
                    String string2 = node.getString();
                    node.setString(string2.concat(string));
                    return node;
                }
                if (node.type != 39) break;
                if (node2.type == 39) {
                    node.setDouble(node.getDouble() + node2.getDouble());
                    return node;
                }
                if (node2.type != 40) break;
                String string = ScriptRuntime.numberToString(node.getDouble(), 10);
                String string3 = node2.getString();
                node2.setString(string.concat(string3));
                return node2;
            }
            case 22: {
                if (node.type == 39) {
                    double d = node.getDouble();
                    if (node2.type == 39) {
                        node.setDouble(d - node2.getDouble());
                        return node;
                    }
                    if (d != 0.0) break;
                    return new Node(29, node2);
                }
                if (node2.type != 39 || node2.getDouble() != 0.0) break;
                return new Node(28, node);
            }
            case 23: {
                if (node.type == 39) {
                    double d = node.getDouble();
                    if (node2.type == 39) {
                        node.setDouble(d * node2.getDouble());
                        return node;
                    }
                    if (d != 1.0) break;
                    return new Node(28, node2);
                }
                if (node2.type != 39 || node2.getDouble() != 1.0) break;
                return new Node(28, node);
            }
            case 24: {
                if (node2.type != 39) break;
                double d = node2.getDouble();
                if (node.type == 39) {
                    node.setDouble(node.getDouble() / d);
                    return node;
                }
                if (d != 1.0) break;
                return new Node(28, node);
            }
            case 101: {
                int n2 = IRFactory.isAlwaysDefinedBoolean(node);
                if (n2 == -1) {
                    return new Node(43);
                }
                if (n2 == 1) {
                    return node2;
                }
                int n3 = IRFactory.isAlwaysDefinedBoolean(node2);
                if (n3 == -1) {
                    if (IRFactory.hasSideEffects(node)) break;
                    return new Node(43);
                }
                if (n3 != 1) break;
                return node;
            }
            case 100: {
                int n4 = IRFactory.isAlwaysDefinedBoolean(node);
                if (n4 == 1) {
                    return new Node(44);
                }
                if (n4 == -1) {
                    return node2;
                }
                int n5 = IRFactory.isAlwaysDefinedBoolean(node2);
                if (n5 == 1) {
                    if (IRFactory.hasSideEffects(node)) break;
                    return new Node(44);
                }
                if (n5 != -1) break;
                return node;
            }
        }
        return new Node(n, node, node2);
    }

    private Node simpleAssignment(Node node, Node node2) {
        int n = node.getType();
        switch (n) {
            case 38: {
                node.setType(48);
                return new Node(8, node, node2);
            }
            case 33: 
            case 35: {
                Node node3 = node.getFirstChild();
                Node node4 = node.getLastChild();
                int n2 = n == 33 ? 34 : 36;
                return new Node(n2, node3, node4, node2);
            }
            case 65: {
                Node node5 = node.getFirstChild();
                return new Node(66, node5, node2);
            }
        }
        throw Kit.codeBug();
    }

    Node createAssignment(int n, Node node, Node node2) {
        int n2;
        if ((node = this.makeReference(node)) == null) {
            this.parser.reportError("msg.bad.assign.left");
            return node2;
        }
        switch (n) {
            case 86: {
                return this.simpleAssignment(node, node2);
            }
            case 87: {
                n2 = 9;
                break;
            }
            case 88: {
                n2 = 10;
                break;
            }
            case 89: {
                n2 = 11;
                break;
            }
            case 90: {
                n2 = 18;
                break;
            }
            case 91: {
                n2 = 19;
                break;
            }
            case 92: {
                n2 = 20;
                break;
            }
            case 93: {
                n2 = 21;
                break;
            }
            case 94: {
                n2 = 22;
                break;
            }
            case 95: {
                n2 = 23;
                break;
            }
            case 96: {
                n2 = 24;
                break;
            }
            case 97: {
                n2 = 25;
                break;
            }
            default: {
                throw Kit.codeBug();
            }
        }
        int n3 = node.getType();
        switch (n3) {
            case 38: {
                String string = node.getString();
                Node node3 = Node.newString(38, string);
                Node node4 = new Node(n2, node3, node2);
                Node node5 = Node.newString(48, string);
                return new Node(8, node5, node4);
            }
            case 33: 
            case 35: {
                Node node6 = node.getFirstChild();
                Node node7 = node.getLastChild();
                int n4 = n3 == 33 ? 135 : 136;
                Node node8 = new Node(134);
                Node node9 = new Node(n2, node8, node2);
                return new Node(n4, node6, node7, node9);
            }
            case 65: {
                Node node10 = node.getFirstChild();
                Node node11 = new Node(134);
                Node node12 = new Node(n2, node11, node2);
                return new Node(138, node10, node12);
            }
        }
        throw Kit.codeBug();
    }

    Node createUseLocal(Node node) {
        if (137 != node.getType()) {
            throw Kit.codeBug();
        }
        Node node2 = new Node(53);
        node2.putProp(3, node);
        return node2;
    }

    private Node.Jump makeJump(int n, Node node) {
        Node.Jump jump = new Node.Jump(n);
        jump.target = node;
        return jump;
    }

    private Node makeReference(Node node) {
        int n = node.getType();
        switch (n) {
            case 33: 
            case 35: 
            case 38: 
            case 65: {
                return node;
            }
            case 37: {
                node.setType(68);
                return new Node(65, node);
            }
        }
        return null;
    }

    private static int isAlwaysDefinedBoolean(Node node) {
        switch (node.getType()) {
            case 41: 
            case 43: {
                return -1;
            }
            case 44: {
                return 1;
            }
            case 39: {
                double d = node.getDouble();
                if (d == d && d != 0.0) {
                    return 1;
                }
                return -1;
            }
        }
        return 0;
    }

    private static boolean hasSideEffects(Node node) {
        switch (node.getType()) {
            case 8: 
            case 30: 
            case 34: 
            case 36: 
            case 37: 
            case 102: 
            case 103: {
                return true;
            }
        }
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            if (!IRFactory.hasSideEffects(node2)) continue;
            return true;
        }
        return false;
    }

    private void checkActivationName(String string, int n) {
        if (this.parser.insideFunction()) {
            boolean bl = false;
            if ("arguments".equals(string) || this.parser.compilerEnv.activationNames != null && this.parser.compilerEnv.activationNames.containsKey(string)) {
                bl = true;
            } else if ("length".equals(string) && n == 33 && this.parser.compilerEnv.getLanguageVersion() == 120) {
                bl = true;
            }
            if (bl) {
                this.setRequiresActivation();
            }
        }
    }

    private void setRequiresActivation() {
        if (this.parser.insideFunction()) {
            ((FunctionNode)this.parser.currentScriptOrFn).itsNeedsActivation = true;
        }
    }
}

