/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Locale;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ContextListener;
import org.mozilla.javascript.DefaultErrorReporter;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrapFactory;
import org.mozilla.javascript.WrapHandler;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.debug.DebuggableScript;
import org.mozilla.javascript.debug.Debugger;
import org.mozilla.javascript.xml.XMLLib;

public class Context {
    public static final int VERSION_UNKNOWN = -1;
    public static final int VERSION_DEFAULT = 0;
    public static final int VERSION_1_0 = 100;
    public static final int VERSION_1_1 = 110;
    public static final int VERSION_1_2 = 120;
    public static final int VERSION_1_3 = 130;
    public static final int VERSION_1_4 = 140;
    public static final int VERSION_1_5 = 150;
    public static final int VERSION_1_6 = 160;
    public static final int FEATURE_NON_ECMA_GET_YEAR = 1;
    public static final int FEATURE_MEMBER_EXPR_AS_FUNCTION_NAME = 2;
    public static final int FEATURE_RESERVED_KEYWORD_AS_IDENTIFIER = 3;
    public static final int FEATURE_TO_STRING_AS_SOURCE = 4;
    public static final int FEATURE_PARENT_PROTO_PROPRTIES = 5;
    public static final int FEATURE_E4X = 6;
    public static final int FEATURE_DYNAMIC_SCOPE = 7;
    public static final int FEATURE_STRICT_VARS = 8;
    public static final int FEATURE_STRICT_EVAL = 9;
    public static final String languageVersionProperty = "language version";
    public static final String errorReporterProperty = "error reporter";
    public static final Object[] emptyArgs = ScriptRuntime.emptyArgs;
    private static Class codegenClass = Kit.classOrNull("org.mozilla.javascript.optimizer.Codegen");
    private static Hashtable threadContexts = new Hashtable(11);
    private static Object threadLocalCx;
    private static Method threadLocalGet;
    private static Method threadLocalSet;
    private static Method method_getContextClassLoader;
    private static String implementationVersion;
    private ContextFactory factory;
    private boolean sealed;
    private Object sealKey;
    Scriptable topCallScope;
    NativeCall currentActivationCall;
    XMLLib cachedXMLLib;
    ObjToIntMap iterating;
    Object interpreterSecurityDomain;
    int version;
    private SecurityController securityController;
    private ClassShutter classShutter;
    private ErrorReporter errorReporter;
    private RegExpProxy regExpProxy;
    private Locale locale;
    private boolean generatingDebug;
    private boolean generatingDebugChanged;
    private boolean generatingSource = true;
    boolean compileFunctionsWithDynamicScopeFlag;
    boolean useDynamicScope;
    private int optimizationLevel;
    private WrapFactory wrapFactory;
    Debugger debugger;
    private Object debuggerData;
    private int enterCount;
    private Object propertyListeners;
    private Hashtable hashtable;
    private ClassLoader applicationClassLoader;
    private boolean creationEventWasSent;
    Hashtable activationNames;
    Object interpreterLineCounting;
    int instructionCount;
    int instructionThreshold;
    int scratchIndex;
    long scratchUint32;
    Scriptable scratchScriptable;
    Scriptable scratchRefTarget;

    public Context() {
        this.setLanguageVersion(0);
        this.optimizationLevel = codegenClass != null ? 0 : -1;
    }

    public static Context enter() {
        return Context.enter(null);
    }

    public static Context enter(Context context) {
        Context[] contextArray = Context.getThreadContextStorage();
        Context context2 = contextArray != null ? contextArray[0] : Context.getCurrentContext_jdk11();
        if (context2 != null) {
            if (context != null && context != context2 && context.enterCount != 0) {
                throw new IllegalArgumentException("Cannot enter Context active on another thread");
            }
            if (context2.factory != null) {
                return context2;
            }
            if (context2.sealed) {
                Context.onSealedMutation();
            }
            context = context2;
        } else {
            if (context == null) {
                context = ContextFactory.getGlobal().makeContext();
            } else if (context.sealed) {
                Context.onSealedMutation();
            }
            if (context.enterCount != 0 || context.factory != null) {
                throw new IllegalStateException();
            }
            if (!context.creationEventWasSent) {
                context.creationEventWasSent = true;
                ContextFactory.getGlobal().onContextCreated(context);
            }
        }
        if (context2 == null) {
            if (contextArray != null) {
                contextArray[0] = context;
            } else {
                Context.setThreadContext_jdk11(context);
            }
        }
        ++context.enterCount;
        return context;
    }

    public static void exit() {
        Context[] contextArray = Context.getThreadContextStorage();
        Context context = contextArray != null ? contextArray[0] : Context.getCurrentContext_jdk11();
        if (context == null) {
            throw new IllegalStateException("Calling Context.exit without previous Context.enter");
        }
        if (context.factory != null) {
            return;
        }
        if (context.enterCount < 1) {
            Kit.codeBug();
        }
        if (context.sealed) {
            Context.onSealedMutation();
        }
        --context.enterCount;
        if (context.enterCount == 0) {
            if (contextArray != null) {
                contextArray[0] = null;
            } else {
                Context.setThreadContext_jdk11(null);
            }
        }
        if (context.enterCount == 0) {
            ContextFactory.getGlobal().onContextReleased(context);
        }
    }

    public static Object call(ContextAction contextAction) {
        return Context.call(ContextFactory.getGlobal(), contextAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object call(ContextFactory contextFactory, Callable callable, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Context[] contextArray;
        Context context;
        if (contextFactory == null) {
            contextFactory = ScriptRuntime.getContextFactory(scriptable);
        }
        if ((context = (contextArray = Context.getThreadContextStorage()) != null ? contextArray[0] : Context.getCurrentContext_jdk11()) != null) {
            if (context.factory != null) {
                return callable.call(context, scriptable, scriptable2, objectArray);
            }
            context.factory = contextFactory;
            try {
                Object object = callable.call(context, scriptable, scriptable2, objectArray);
                return object;
            }
            finally {
                context.factory = null;
            }
        }
        context = Context.prepareNewContext(contextFactory, contextArray);
        try {
            Object object = callable.call(context, scriptable, scriptable2, objectArray);
            return object;
        }
        finally {
            Context.releaseContext(contextArray, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object call(ContextFactory contextFactory, ContextAction contextAction) {
        Context[] contextArray = Context.getThreadContextStorage();
        Context context = contextArray != null ? contextArray[0] : Context.getCurrentContext_jdk11();
        if (context != null) {
            if (context.factory != null) {
                return contextAction.run(context);
            }
            context.factory = contextFactory;
            try {
                Object object = contextAction.run(context);
                return object;
            }
            finally {
                context.factory = null;
            }
        }
        context = Context.prepareNewContext(contextFactory, contextArray);
        try {
            Object object = contextAction.run(context);
            return object;
        }
        finally {
            Context.releaseContext(contextArray, context);
        }
    }

    private static Context prepareNewContext(ContextFactory contextFactory, Context[] contextArray) {
        Context context = contextFactory.makeContext();
        if (context.factory != null || context.enterCount != 0) {
            throw new IllegalStateException("factory.makeContext() returned Context instance already associated with some thread");
        }
        context.factory = contextFactory;
        contextFactory.onContextCreated(context);
        if (contextFactory.isSealed() && !context.isSealed()) {
            context.seal(null);
        }
        if (contextArray != null) {
            contextArray[0] = context;
        } else {
            Context.setThreadContext_jdk11(context);
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseContext(Context[] contextArray, Context context) {
        if (contextArray != null) {
            contextArray[0] = null;
        } else {
            Context.setThreadContext_jdk11(null);
        }
        try {
            context.factory.onContextReleased(context);
        }
        finally {
            context.factory = null;
        }
    }

    public static void addContextListener(ContextListener contextListener) {
        String string = "org.mozilla.javascript.tools.debugger.Main";
        if (string.equals(contextListener.getClass().getName())) {
            Class<?> clazz = contextListener.getClass();
            Class clazz2 = Kit.classOrNull("org.mozilla.javascript.ContextFactory");
            Class[] classArray = new Class[]{clazz2};
            Object[] objectArray = new Object[]{ContextFactory.getGlobal()};
            try {
                Method method = clazz.getMethod("attachTo", classArray);
                method.invoke((Object)contextListener, objectArray);
            }
            catch (Exception exception) {
                RuntimeException runtimeException = new RuntimeException();
                Kit.initCause(runtimeException, exception);
                throw runtimeException;
            }
            return;
        }
        ContextFactory.getGlobal().addListener(contextListener);
    }

    public static void removeContextListener(ContextListener contextListener) {
        ContextFactory.getGlobal().addListener(contextListener);
    }

    public static void disableStaticContextListening() {
        ContextFactory.getGlobal().disableContextListening();
    }

    public static Context getCurrentContext() {
        Context[] contextArray = Context.getThreadContextStorage();
        if (contextArray != null) {
            return contextArray[0];
        }
        return Context.getCurrentContext_jdk11();
    }

    private static Context[] getThreadContextStorage() {
        if (threadLocalCx != null) {
            try {
                Context[] contextArray = (Context[])threadLocalGet.invoke(threadLocalCx, null);
                if (contextArray == null) {
                    contextArray = new Context[1];
                    threadLocalSet.invoke(threadLocalCx, new Object[]{contextArray});
                }
                return contextArray;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static Context getCurrentContext_jdk11() {
        Thread thread = Thread.currentThread();
        return (Context)threadContexts.get(thread);
    }

    private static void setThreadContext_jdk11(Context context) {
        Thread thread = Thread.currentThread();
        if (context != null) {
            threadContexts.put(thread, context);
        } else {
            threadContexts.remove(thread);
        }
    }

    public final ContextFactory getFactory() {
        ContextFactory contextFactory = this.factory;
        if (contextFactory == null) {
            contextFactory = ContextFactory.getGlobal();
        }
        return contextFactory;
    }

    public final boolean isSealed() {
        return this.sealed;
    }

    public final void seal(Object object) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        this.sealed = true;
        this.sealKey = object;
    }

    public final void unseal(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        if (this.sealKey != object) {
            throw new IllegalArgumentException();
        }
        if (!this.sealed) {
            throw new IllegalStateException();
        }
        this.sealed = false;
        this.sealKey = null;
    }

    static void onSealedMutation() {
        throw new IllegalStateException();
    }

    public final int getLanguageVersion() {
        return this.version;
    }

    public void setLanguageVersion(int n) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        Context.checkLanguageVersion(n);
        Object object = this.propertyListeners;
        if (object != null && n != this.version) {
            this.firePropertyChangeImpl(object, languageVersionProperty, new Integer(this.version), new Integer(n));
        }
        this.version = n;
    }

    public static boolean isValidLanguageVersion(int n) {
        switch (n) {
            case 0: 
            case 100: 
            case 110: 
            case 120: 
            case 130: 
            case 140: 
            case 150: 
            case 160: {
                return true;
            }
        }
        return false;
    }

    public static void checkLanguageVersion(int n) {
        if (Context.isValidLanguageVersion(n)) {
            return;
        }
        throw new IllegalArgumentException("Bad language version: " + n);
    }

    public final String getImplementationVersion() {
        if (implementationVersion == null) {
            implementationVersion = ScriptRuntime.getMessage0("implementation.version");
        }
        return implementationVersion;
    }

    public final ErrorReporter getErrorReporter() {
        if (this.errorReporter == null) {
            return DefaultErrorReporter.instance;
        }
        return this.errorReporter;
    }

    public final ErrorReporter setErrorReporter(ErrorReporter errorReporter) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (errorReporter == null) {
            throw new IllegalArgumentException();
        }
        ErrorReporter errorReporter2 = this.getErrorReporter();
        if (errorReporter == errorReporter2) {
            return errorReporter2;
        }
        Object object = this.propertyListeners;
        if (object != null) {
            this.firePropertyChangeImpl(object, errorReporterProperty, errorReporter2, errorReporter);
        }
        this.errorReporter = errorReporter;
        return errorReporter2;
    }

    public final Locale getLocale() {
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        return this.locale;
    }

    public final Locale setLocale(Locale locale) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        Locale locale2 = this.locale;
        this.locale = locale;
        return locale2;
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        this.propertyListeners = Kit.addListener(this.propertyListeners, propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        this.propertyListeners = Kit.removeListener(this.propertyListeners, propertyChangeListener);
    }

    final void firePropertyChange(String string, Object object, Object object2) {
        Object object3 = this.propertyListeners;
        if (object3 != null) {
            this.firePropertyChangeImpl(object3, string, object, object2);
        }
    }

    private void firePropertyChangeImpl(Object object, String string, Object object2, Object object3) {
        Object object4;
        int n = 0;
        while ((object4 = Kit.getListener(object, n)) != null) {
            if (object4 instanceof PropertyChangeListener) {
                PropertyChangeListener propertyChangeListener = (PropertyChangeListener)object4;
                propertyChangeListener.propertyChange(new PropertyChangeEvent(this, string, object2, object3));
            }
            ++n;
        }
    }

    public static void reportWarning(String string, String string2, int n, String string3, int n2) {
        Context context = Context.getContext();
        context.getErrorReporter().warning(string, string2, n, string3, n2);
    }

    public static void reportWarning(String string) {
        int[] nArray = new int[]{0};
        String string2 = Context.getSourcePositionFromStack(nArray);
        Context.reportWarning(string, string2, nArray[0], null, 0);
    }

    public static void reportError(String string, String string2, int n, String string3, int n2) {
        Context context = Context.getCurrentContext();
        if (context == null) {
            throw new EvaluatorException(string, string2, n, string3, n2);
        }
        context.getErrorReporter().error(string, string2, n, string3, n2);
    }

    public static void reportError(String string) {
        int[] nArray = new int[]{0};
        String string2 = Context.getSourcePositionFromStack(nArray);
        Context.reportError(string, string2, nArray[0], null, 0);
    }

    public static EvaluatorException reportRuntimeError(String string, String string2, int n, String string3, int n2) {
        Context context = Context.getCurrentContext();
        if (context != null) {
            return context.getErrorReporter().runtimeError(string, string2, n, string3, n2);
        }
        throw new EvaluatorException(string, string2, n, string3, n2);
    }

    static EvaluatorException reportRuntimeError0(String string) {
        String string2 = ScriptRuntime.getMessage0(string);
        return Context.reportRuntimeError(string2);
    }

    static EvaluatorException reportRuntimeError1(String string, Object object) {
        String string2 = ScriptRuntime.getMessage1(string, object);
        return Context.reportRuntimeError(string2);
    }

    static EvaluatorException reportRuntimeError2(String string, Object object, Object object2) {
        String string2 = ScriptRuntime.getMessage2(string, object, object2);
        return Context.reportRuntimeError(string2);
    }

    static EvaluatorException reportRuntimeError3(String string, Object object, Object object2, Object object3) {
        String string2 = ScriptRuntime.getMessage3(string, object, object2, object3);
        return Context.reportRuntimeError(string2);
    }

    static EvaluatorException reportRuntimeError4(String string, Object object, Object object2, Object object3, Object object4) {
        String string2 = ScriptRuntime.getMessage4(string, object, object2, object3, object4);
        return Context.reportRuntimeError(string2);
    }

    public static EvaluatorException reportRuntimeError(String string) {
        int[] nArray = new int[]{0};
        String string2 = Context.getSourcePositionFromStack(nArray);
        return Context.reportRuntimeError(string, string2, nArray[0], null, 0);
    }

    public final ScriptableObject initStandardObjects() {
        return this.initStandardObjects(null, false);
    }

    public final Scriptable initStandardObjects(ScriptableObject scriptableObject) {
        return this.initStandardObjects(scriptableObject, false);
    }

    public ScriptableObject initStandardObjects(ScriptableObject scriptableObject, boolean bl) {
        return ScriptRuntime.initStandardObjects(this, scriptableObject, bl);
    }

    public static Object getUndefinedValue() {
        return Undefined.instance;
    }

    public final Object evaluateString(Scriptable scriptable, String string, String string2, int n, Object object) {
        Script script = this.compileString(string, string2, n, object);
        if (script != null) {
            return script.exec(this, scriptable);
        }
        return null;
    }

    public final Object evaluateReader(Scriptable scriptable, Reader reader, String string, int n, Object object) throws IOException {
        Script script = this.compileReader(scriptable, reader, string, n, object);
        if (script != null) {
            return script.exec(this, scriptable);
        }
        return null;
    }

    public final boolean stringIsCompilableUnit(String string) {
        boolean bl = false;
        CompilerEnvirons compilerEnvirons = new CompilerEnvirons();
        compilerEnvirons.initFromContext(this);
        compilerEnvirons.setGeneratingSource(false);
        Parser parser = new Parser(compilerEnvirons, DefaultErrorReporter.instance);
        try {
            parser.parse(string, null, 1);
        }
        catch (EvaluatorException evaluatorException) {
            bl = true;
        }
        return !bl || !parser.eof();
    }

    public final Script compileReader(Scriptable scriptable, Reader reader, String string, int n, Object object) throws IOException {
        return this.compileReader(reader, string, n, object);
    }

    public final Script compileReader(Reader reader, String string, int n, Object object) throws IOException {
        if (n < 0) {
            n = 0;
        }
        return (Script)this.compileImpl(null, reader, null, string, n, object, false, null, null);
    }

    public final Script compileString(String string, String string2, int n, Object object) {
        if (n < 0) {
            n = 0;
        }
        return this.compileString(string, null, null, string2, n, object);
    }

    final Script compileString(String string, Interpreter interpreter, ErrorReporter errorReporter, String string2, int n, Object object) {
        try {
            return (Script)this.compileImpl(null, null, string, string2, n, object, false, interpreter, errorReporter);
        }
        catch (IOException iOException) {
            throw new RuntimeException();
        }
    }

    public final Function compileFunction(Scriptable scriptable, String string, String string2, int n, Object object) {
        return this.compileFunction(scriptable, string, null, null, string2, n, object);
    }

    final Function compileFunction(Scriptable scriptable, String string, Interpreter interpreter, ErrorReporter errorReporter, String string2, int n, Object object) {
        try {
            return (Function)this.compileImpl(scriptable, null, string, string2, n, object, true, interpreter, errorReporter);
        }
        catch (IOException iOException) {
            throw new RuntimeException();
        }
    }

    public final String decompileScript(Script script, Scriptable scriptable, int n) {
        return this.decompileScript(script, n);
    }

    public final String decompileScript(Script script, int n) {
        NativeFunction nativeFunction = (NativeFunction)((Object)script);
        return nativeFunction.decompile(n, 0);
    }

    public final String decompileFunction(Function function, int n) {
        if (function instanceof BaseFunction) {
            return ((BaseFunction)function).decompile(n, 0);
        }
        return "function " + function.getClassName() + "() {\n\t[native code]\n}\n";
    }

    public final String decompileFunctionBody(Function function, int n) {
        if (function instanceof BaseFunction) {
            BaseFunction baseFunction = (BaseFunction)function;
            return baseFunction.decompile(n, 1);
        }
        return "[native code]\n";
    }

    public final Scriptable newObject(Scriptable scriptable) {
        return this.newObject(scriptable, "Object", ScriptRuntime.emptyArgs);
    }

    public final Scriptable newObject(Scriptable scriptable, String string) {
        return this.newObject(scriptable, string, ScriptRuntime.emptyArgs);
    }

    public final Scriptable newObject(Scriptable scriptable, String string, Object[] objectArray) {
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        Function function = ScriptRuntime.getExistingCtor(this, scriptable, string);
        if (objectArray == null) {
            objectArray = ScriptRuntime.emptyArgs;
        }
        return function.construct(this, scriptable, objectArray);
    }

    public final Scriptable newArray(Scriptable scriptable, int n) {
        NativeArray nativeArray = new NativeArray(n);
        ScriptRuntime.setObjectProtoAndParent(nativeArray, scriptable);
        return nativeArray;
    }

    public final Scriptable newArray(Scriptable scriptable, Object[] objectArray) {
        if (objectArray.getClass().getComponentType() != ScriptRuntime.ObjectClass) {
            throw new IllegalArgumentException();
        }
        NativeArray nativeArray = new NativeArray(objectArray);
        ScriptRuntime.setObjectProtoAndParent(nativeArray, scriptable);
        return nativeArray;
    }

    public final Object[] getElements(Scriptable scriptable) {
        return ScriptRuntime.getArrayElements(scriptable);
    }

    public static boolean toBoolean(Object object) {
        return ScriptRuntime.toBoolean(object);
    }

    public static double toNumber(Object object) {
        return ScriptRuntime.toNumber(object);
    }

    public static String toString(Object object) {
        return ScriptRuntime.toString(object);
    }

    public static Scriptable toObject(Object object, Scriptable scriptable) {
        return ScriptRuntime.toObject(scriptable, object);
    }

    public static Scriptable toObject(Object object, Scriptable scriptable, Class clazz) {
        return ScriptRuntime.toObject(scriptable, object);
    }

    public static Object javaToJS(Object object, Scriptable scriptable) {
        if (object instanceof String || object instanceof Number || object instanceof Boolean || object instanceof Scriptable) {
            return object;
        }
        if (object instanceof Character) {
            return String.valueOf(((Character)object).charValue());
        }
        Context context = Context.getContext();
        return context.getWrapFactory().wrap(context, scriptable, object, null);
    }

    public static Object toType(Object object, Class clazz) throws IllegalArgumentException {
        return NativeJavaObject.coerceType(clazz, object, false);
    }

    public static RuntimeException throwAsScriptRuntimeEx(Throwable throwable) {
        while (throwable instanceof InvocationTargetException) {
            throwable = ((InvocationTargetException)throwable).getTargetException();
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof EvaluatorException) {
            throw (EvaluatorException)throwable;
        }
        if (throwable instanceof EcmaError) {
            throw (EcmaError)throwable;
        }
        throw new WrappedException(throwable);
    }

    public final boolean isGeneratingDebug() {
        return this.generatingDebug;
    }

    public final void setGeneratingDebug(boolean bl) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        this.generatingDebugChanged = true;
        if (bl && this.getOptimizationLevel() > 0) {
            this.setOptimizationLevel(0);
        }
        this.generatingDebug = bl;
    }

    public final boolean isGeneratingSource() {
        return this.generatingSource;
    }

    public final void setGeneratingSource(boolean bl) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        this.generatingSource = bl;
    }

    public final int getOptimizationLevel() {
        return this.optimizationLevel;
    }

    public final void setOptimizationLevel(int n) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (n == -2) {
            n = -1;
        }
        Context.checkOptimizationLevel(n);
        if (codegenClass == null) {
            n = -1;
        }
        this.optimizationLevel = n;
    }

    public static boolean isValidOptimizationLevel(int n) {
        return -1 <= n && n <= 9;
    }

    public static void checkOptimizationLevel(int n) {
        if (Context.isValidOptimizationLevel(n)) {
            return;
        }
        throw new IllegalArgumentException("Optimization level outside [-1..9]: " + n);
    }

    public final void setSecurityController(SecurityController securityController) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (securityController == null) {
            throw new IllegalArgumentException();
        }
        if (this.securityController != null) {
            throw new SecurityException("Can not overwrite existing SecurityController object");
        }
        if (SecurityController.hasGlobal()) {
            throw new SecurityException("Can not overwrite existing global SecurityController object");
        }
        this.securityController = securityController;
    }

    public final void setClassShutter(ClassShutter classShutter) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (classShutter == null) {
            throw new IllegalArgumentException();
        }
        if (this.classShutter != null) {
            throw new SecurityException("Cannot overwrite existing ClassShutter object");
        }
        this.classShutter = classShutter;
    }

    final ClassShutter getClassShutter() {
        return this.classShutter;
    }

    public final Object getThreadLocal(Object object) {
        if (this.hashtable == null) {
            return null;
        }
        return this.hashtable.get(object);
    }

    public final void putThreadLocal(Object object, Object object2) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (this.hashtable == null) {
            this.hashtable = new Hashtable();
        }
        this.hashtable.put(object, object2);
    }

    public final void removeThreadLocal(Object object) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (this.hashtable == null) {
            return;
        }
        this.hashtable.remove(object);
    }

    public final boolean hasCompileFunctionsWithDynamicScope() {
        return this.compileFunctionsWithDynamicScopeFlag;
    }

    public final void setCompileFunctionsWithDynamicScope(boolean bl) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        this.compileFunctionsWithDynamicScopeFlag = bl;
    }

    public static void setCachingEnabled(boolean bl) {
    }

    public final void setWrapHandler(WrapHandler wrapHandler) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (wrapHandler == null) {
            this.setWrapFactory(new WrapFactory());
        } else {
            this.setWrapFactory(new WrapHandlerProxy(wrapHandler));
        }
    }

    public final WrapHandler getWrapHandler() {
        WrapFactory wrapFactory = this.getWrapFactory();
        if (wrapFactory instanceof WrapHandlerProxy) {
            return ((WrapHandlerProxy)wrapFactory)._handler;
        }
        return null;
    }

    public final void setWrapFactory(WrapFactory wrapFactory) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (wrapFactory == null) {
            throw new IllegalArgumentException();
        }
        this.wrapFactory = wrapFactory;
    }

    public final WrapFactory getWrapFactory() {
        if (this.wrapFactory == null) {
            this.wrapFactory = new WrapFactory();
        }
        return this.wrapFactory;
    }

    public final Debugger getDebugger() {
        return this.debugger;
    }

    public final Object getDebuggerContextData() {
        return this.debuggerData;
    }

    public final void setDebugger(Debugger debugger, Object object) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        this.debugger = debugger;
        this.debuggerData = object;
    }

    public static DebuggableScript getDebuggableView(Script script) {
        if (script instanceof NativeFunction) {
            return ((NativeFunction)((Object)script)).getDebuggableView();
        }
        return null;
    }

    public boolean hasFeature(int n) {
        ContextFactory contextFactory = this.getFactory();
        return contextFactory.hasFeature(this, n);
    }

    public final int getInstructionObserverThreshold() {
        return this.instructionThreshold;
    }

    public final void setInstructionObserverThreshold(int n) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.instructionThreshold = n;
    }

    protected void observeInstructionCount(int n) {
        ContextFactory contextFactory = this.getFactory();
        contextFactory.observeInstructionCount(this, n);
    }

    public GeneratedClassLoader createClassLoader(ClassLoader classLoader) {
        ContextFactory contextFactory = this.getFactory();
        return contextFactory.createClassLoader(classLoader);
    }

    public final ClassLoader getApplicationClassLoader() {
        if (this.applicationClassLoader == null) {
            Class<?> clazz = this.getClass();
            ClassLoader classLoader = clazz.getClassLoader();
            if (method_getContextClassLoader != null) {
                Thread thread = Thread.currentThread();
                ClassLoader classLoader2 = null;
                try {
                    classLoader2 = (ClassLoader)method_getContextClassLoader.invoke((Object)thread, ScriptRuntime.emptyArgs);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (classLoader2 != null && classLoader2 != classLoader && Context.testIfCanUseLoader(classLoader2, clazz)) {
                    return classLoader2;
                }
            }
            this.applicationClassLoader = classLoader;
        }
        return this.applicationClassLoader;
    }

    public final void setApplicationClassLoader(ClassLoader classLoader) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (classLoader == null) {
            this.applicationClassLoader = null;
            return;
        }
        if (!Context.testIfCanUseLoader(classLoader, this.getClass())) {
            throw new IllegalArgumentException("Loader can not resolve Rhino classes");
        }
        this.applicationClassLoader = classLoader;
    }

    private static boolean testIfCanUseLoader(ClassLoader classLoader, Class clazz) {
        Class clazz2 = Kit.classOrNull(classLoader, clazz.getName());
        return clazz2 == clazz;
    }

    static Context getContext() {
        Context context = Context.getCurrentContext();
        if (context == null) {
            throw new RuntimeException("No Context associated with current Thread");
        }
        return context;
    }

    private Object compileImpl(Scriptable scriptable, Reader reader, String string, String string2, int n, Object object, boolean bl, Interpreter interpreter, ErrorReporter errorReporter) throws IOException {
        Object object2;
        if (object != null && this.securityController == null) {
            throw new IllegalArgumentException("securityDomain should be null if setSecurityController() was never called");
        }
        if (!(reader == null ^ string == null)) {
            Kit.codeBug();
        }
        if (!(scriptable == null ^ bl)) {
            Kit.codeBug();
        }
        CompilerEnvirons compilerEnvirons = new CompilerEnvirons();
        compilerEnvirons.initFromContext(this);
        if (errorReporter == null) {
            errorReporter = compilerEnvirons.getErrorReporter();
        }
        if (this.debugger != null && reader != null) {
            string = Kit.readReader(reader);
            reader = null;
        }
        Parser parser = new Parser(compilerEnvirons, errorReporter);
        ScriptOrFnNode scriptOrFnNode = string != null ? parser.parse(string, string2, n) : parser.parse(reader, string2, n);
        if (bl && (scriptOrFnNode.getFunctionCount() != 1 || scriptOrFnNode.getFirstChild() == null || scriptOrFnNode.getFirstChild().getType() != 105)) {
            throw new IllegalArgumentException("compileFunction only accepts source with single JS function: " + string);
        }
        if (interpreter == null) {
            interpreter = this.createCompiler();
        }
        String string3 = parser.getEncodedSource();
        Object object3 = interpreter.compile(compilerEnvirons, scriptOrFnNode, string3, bl);
        if (this.debugger != null) {
            if (string == null) {
                Kit.codeBug();
            }
            if (object3 instanceof DebuggableScript) {
                object2 = (DebuggableScript)object3;
                Context.notifyDebugger_r(this, (DebuggableScript)object2, string);
            } else {
                throw new RuntimeException("NOT SUPPORTED");
            }
        }
        object2 = bl ? interpreter.createFunctionObject(this, scriptable, object3, object) : interpreter.createScriptObject(object3, object);
        return object2;
    }

    private static void notifyDebugger_r(Context context, DebuggableScript debuggableScript, String string) {
        context.debugger.handleCompilationDone(context, debuggableScript, string);
        for (int i = 0; i != debuggableScript.getFunctionCount(); ++i) {
            Context.notifyDebugger_r(context, debuggableScript.getFunction(i), string);
        }
    }

    private Interpreter createCompiler() {
        Interpreter interpreter = null;
        if (this.optimizationLevel >= 0 && codegenClass != null) {
            interpreter = (Interpreter)Kit.newInstanceOrNull(codegenClass);
        }
        if (interpreter == null) {
            interpreter = new Interpreter();
        }
        return interpreter;
    }

    static String getSourcePositionFromStack(int[] nArray) {
        Context context = Context.getCurrentContext();
        if (context == null) {
            return null;
        }
        if (context.interpreterLineCounting != null) {
            return Interpreter.getSourcePositionFromStack(context, nArray);
        }
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        RuntimeException runtimeException = new RuntimeException();
        runtimeException.printStackTrace(new PrintWriter(charArrayWriter));
        String string = charArrayWriter.toString();
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ':') {
                n3 = i;
                continue;
            }
            if (c == '(') {
                n = i;
                continue;
            }
            if (c == ')') {
                n2 = i;
                continue;
            }
            if (c != '\n' || n == -1 || n2 == -1 || n3 == -1 || n >= n3 || n3 >= n2) continue;
            String string2 = string.substring(n + 1, n3);
            if (!string2.endsWith(".java")) {
                String string3 = string.substring(n3 + 1, n2);
                try {
                    nArray[0] = Integer.parseInt(string3);
                    if (nArray[0] < 0) {
                        nArray[0] = 0;
                    }
                    return string2;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            n3 = -1;
            n2 = -1;
            n = -1;
        }
        return null;
    }

    RegExpProxy getRegExpProxy() {
        Class clazz;
        if (this.regExpProxy == null && (clazz = Kit.classOrNull("org.mozilla.javascript.regexp.RegExpImpl")) != null) {
            this.regExpProxy = (RegExpProxy)Kit.newInstanceOrNull(clazz);
        }
        return this.regExpProxy;
    }

    final boolean isVersionECMA1() {
        return this.version == 0 || this.version >= 130;
    }

    SecurityController getSecurityController() {
        SecurityController securityController = SecurityController.global();
        if (securityController != null) {
            return securityController;
        }
        return this.securityController;
    }

    public final boolean isGeneratingDebugChanged() {
        return this.generatingDebugChanged;
    }

    public void addActivationName(String string) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (this.activationNames == null) {
            this.activationNames = new Hashtable(5);
        }
        this.activationNames.put(string, string);
    }

    public final boolean isActivationNeeded(String string) {
        return this.activationNames != null && this.activationNames.containsKey(string);
    }

    public void removeActivationName(String string) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (this.activationNames != null) {
            this.activationNames.remove(string);
        }
    }

    static {
        Class clazz = Kit.classOrNull("java.lang.ThreadLocal");
        if (clazz != null) {
            try {
                threadLocalGet = clazz.getMethod("get", null);
                threadLocalSet = clazz.getMethod("set", ScriptRuntime.ObjectClass);
                threadLocalCx = clazz.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((clazz = Kit.classOrNull("java.lang.Thread")) != null) {
            try {
                method_getContextClassLoader = clazz.getDeclaredMethod("getContextClassLoader", new Class[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class WrapHandlerProxy
    extends WrapFactory {
        WrapHandler _handler;

        WrapHandlerProxy(WrapHandler wrapHandler) {
            this._handler = wrapHandler;
        }

        public Object wrap(Context context, Scriptable scriptable, Object object, Class clazz) {
            if (object == null) {
                return object;
            }
            Object object2 = this._handler.wrap(scriptable, object, clazz);
            if (object2 == null) {
                object2 = super.wrap(context, scriptable, object, clazz);
            }
            return object2;
        }

        public Scriptable wrapNewObject(Context context, Scriptable scriptable, Object object) {
            Object object2 = this._handler.wrap(scriptable, object, object.getClass());
            if (object2 instanceof Scriptable) {
                return (Scriptable)object2;
            }
            if (object2 == null) {
                return super.wrapNewObject(context, scriptable, object);
            }
            throw new RuntimeException("Please upgrade from WrapHandler to WrapFactory");
        }
    }
}

