/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Hashtable;
import org.mozilla.javascript.Invoker;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ClassCache {
    private static final Object AKEY = new Object();
    private volatile boolean cachingIsEnabled = true;
    Hashtable classTable = new Hashtable();
    boolean invokerOptimization = false;
    Invoker invokerMaster;
    Hashtable javaAdapterGeneratedClasses = new Hashtable();
    private Hashtable interfaceAdapterCache;
    private int generatedClassSerial;

    public static ClassCache get(Scriptable scriptable) {
        ClassCache classCache = (ClassCache)ScriptableObject.getTopScopeValue(scriptable, AKEY);
        if (classCache == null) {
            classCache = new ClassCache();
        }
        return classCache;
    }

    public boolean associate(ScriptableObject scriptableObject) {
        if (scriptableObject.getParentScope() != null) {
            throw new IllegalArgumentException();
        }
        return this != scriptableObject.associateValue(AKEY, this);
    }

    public synchronized void clearCaches() {
        this.classTable = new Hashtable();
        this.javaAdapterGeneratedClasses = new Hashtable();
        Invoker invoker = this.invokerMaster;
        if (invoker != null) {
            invoker.clearMasterCaches();
        }
        this.interfaceAdapterCache = null;
    }

    public final boolean isCachingEnabled() {
        return this.cachingIsEnabled;
    }

    public synchronized void setCachingEnabled(boolean bl) {
        if (bl == this.cachingIsEnabled) {
            return;
        }
        if (!bl) {
            this.clearCaches();
        }
        this.cachingIsEnabled = bl;
    }

    public boolean isInvokerOptimizationEnabled() {
        return this.invokerOptimization;
    }

    public synchronized void setInvokerOptimizationEnabled(boolean bl) {
        if (this.invokerOptimization == bl) {
            return;
        }
        if (!bl) {
            this.invokerMaster = null;
        }
        this.invokerOptimization = bl;
    }

    public final synchronized int newClassSerialNumber() {
        return ++this.generatedClassSerial;
    }

    Object getInterfaceAdapter(Class clazz) {
        Hashtable hashtable = this.interfaceAdapterCache;
        Object var2_3 = hashtable == null ? null : hashtable.get(clazz);
        return var2_3;
    }

    synchronized void cacheInterfaceAdapter(Class clazz, Object object) {
        if (this.cachingIsEnabled) {
            if (this.interfaceAdapterCache == null) {
                this.interfaceAdapterCache = new Hashtable();
            }
            this.interfaceAdapterCache.put(clazz, object);
        }
    }
}

