/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke.plugins;

import java.util.Collection;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.TermsEnum;
import org.getopt.luke.LukePlugin;
import org.getopt.luke.SlowThread;
import org.getopt.luke.Util;
import org.getopt.luke.plugins.VocabChart;
import thinlet.Thinlet;

public class VocabAnalysisPlugin
extends LukePlugin {
    VocabChart chart = null;
    String selectedField;

    public String getXULName() {
        return "/xml/vocab-plugin.xml";
    }

    public String getPluginName() {
        return "Vocabulary Analysis Tool";
    }

    public String getPluginInfo() {
        return "Tool for showing index's vocabulary growth, by Mark Harwood";
    }

    public String getPluginHome() {
        return "mailto:mharwood@apache.org";
    }

    public void setMyUi(Object ui) {
        super.setMyUi(ui);
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean init() throws Exception {
        Object combobox = this.app.find(this.myUi, "fields");
        this.app.removeAll(combobox);
        Object maxdoc = this.app.find(this.myUi, "maxdoc");
        this.app.setString(maxdoc, "text", "");
        Object middoc = this.app.find(this.myUi, "middoc");
        this.app.setString(middoc, "text", "");
        Object bean = this.app.find(this.myUi, "vocabchart");
        Object container = this.app.getParent(bean);
        this.chart = new VocabChart(this.app, container);
        IndexReader reader = this.getReader();
        if (reader != null) {
            Collection<String> fieldNames = Util.fieldNames(reader, true);
            String firstField = null;
            for (String fieldName : fieldNames) {
                if (firstField == null) {
                    firstField = fieldName;
                }
                Object choice = Thinlet.create("choice");
                this.app.setString(choice, "text", fieldName);
                this.app.add(combobox, choice);
            }
            this.app.setInteger(combobox, "selected", 0);
            this.app.setString(combobox, "text", firstField);
            this.app.setComponent(bean, "bean", this.chart);
            this.app.setString(maxdoc, "text", reader.maxDoc() + "");
            this.app.setString(middoc, "text", reader.maxDoc() / 2 + "");
        }
        return true;
    }

    public void cleanChart() {
        this.chart.setScores(null);
        this.chart.invalidate();
        this.app.repaint();
    }

    public void analyze() {
        Object combobox = this.app.find(this.myUi, "fields");
        final String field = this.app.getString(combobox, "text");
        Object ckbox = this.app.find(this.myUi, "cumul");
        final boolean cumul = this.app.getBoolean(ckbox, "selected");
        IndexReader reader = this.getReader();
        if (reader == null) {
            this.app.showStatus("No index loaded");
            this.cleanChart();
            return;
        }
        SlowThread st = new SlowThread(this.app){

            public void execute() {
                try {
                    int numAgeGroups = 100;
                    float numDocs = VocabAnalysisPlugin.this.ir.maxDoc();
                    if (numDocs < (float)numAgeGroups) {
                        numAgeGroups = VocabAnalysisPlugin.this.ir.maxDoc();
                    }
                    float[] ageTotals = new float[numAgeGroups];
                    TermsEnum te = MultiFields.getTerms(VocabAnalysisPlugin.this.ir, field).iterator(null);
                    while (te.next() != null) {
                        int ageBracket;
                        DocsEnum td = te.docs(null, null, false);
                        td.nextDoc();
                        float firstDocId = td.docID();
                        int n = ageBracket = (int)(firstDocId / numDocs * (float)numAgeGroups);
                        ageTotals[n] = ageTotals[n] + 1.0f;
                    }
                    float total = 0.0f;
                    float max = 0.0f;
                    for (int i = 0; i < ageTotals.length; ++i) {
                        if (ageTotals[i] > max) {
                            max = ageTotals[i];
                        }
                        total += ageTotals[i];
                        if (i <= 0 || !cumul) continue;
                        int n = i;
                        ageTotals[n] = ageTotals[n] + ageTotals[i - 1];
                    }
                    Object maxpct = VocabAnalysisPlugin.this.app.find(VocabAnalysisPlugin.this.myUi, "maxpct");
                    if (cumul) {
                        VocabAnalysisPlugin.this.app.setString(maxpct, "text", "100 %");
                    } else {
                        VocabAnalysisPlugin.this.app.setString(maxpct, "text", (float)Math.round(max * 10000.0f / total) / 100.0f + " %");
                    }
                    VocabAnalysisPlugin.this.chart.setScores(ageTotals);
                    VocabAnalysisPlugin.this.chart.invalidate();
                    VocabAnalysisPlugin.this.app.repaint();
                }
                catch (Exception e) {
                    VocabAnalysisPlugin.this.app.showStatus("ERROR: " + e.getMessage());
                }
            }
        };
        if (this.app.isSlowAccess()) {
            st.start();
        } else {
            st.execute();
        }
    }

    public String getSelectedField() {
        return this.selectedField;
    }

    public void setSelectedField(String selectedField) {
        this.selectedField = selectedField;
    }
}

