/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke.plugins;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.Collection;
import java.util.Random;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.lucene.store.BufferedIndexInput;
import org.apache.lucene.store.BufferedIndexOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.getopt.luke.plugins.IOReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FsDirectory
extends Directory {
    private static final Logger LOG = LoggerFactory.getLogger(FsDirectory.class);
    private FileSystem fs;
    private Path directory;
    private int ioFileBufferSize;
    public static final IOReporter NULL_REPORTER = new NullReporter();
    private IOReporter reporter;
    Cache cache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FsDirectory(FileSystem fs, Path directory, boolean create, Configuration conf, IOReporter reporter, int bufSize) throws IOException {
        CacheManager mgr;
        this.fs = fs;
        this.directory = directory;
        this.reporter = reporter;
        this.ioFileBufferSize = bufSize;
        String diskCacheDir = new File(conf.get("hadoop.tmp.dir"), "fsdir-cache").toString();
        LogManager.getLogger(FsDirectory.class).setLevel(Level.WARN);
        CacheManager cacheManager = mgr = CacheManager.create();
        synchronized (cacheManager) {
            this.cache = mgr.getCache("dfsin");
            if (this.cache == null) {
                this.cache = new Cache("dfsin", 2000, MemoryStoreEvictionPolicy.LFU, true, diskCacheDir, false, 1800L, 600L, false, 300L, null);
                mgr.addCache(this.cache);
                this.cache = mgr.getCache("dfsin");
                LOG.info("Created cache: " + this.cache.toString());
            }
        }
        if (create) {
            this.create();
        }
        if (!fs.getFileStatus(directory).isDir()) {
            throw new IOException(directory + " not a directory");
        }
    }

    private void create() throws IOException {
        if (!this.fs.exists(this.directory)) {
            this.fs.mkdirs(this.directory);
            this.reporter.reportStatus("Created " + this.directory);
        }
        if (!this.fs.getFileStatus(this.directory).isDir()) {
            throw new IOException(this.directory + " not a directory");
        }
        FileStatus[] fstats = this.fs.listStatus(this.directory);
        Path[] files = FileUtil.stat2Paths(fstats);
        if (files.length > 0) {
            this.reporter.reportStatus("Cleaning " + files.length + " old files.");
        }
        for (int i = 0; i < files.length; ++i) {
            if (this.fs.delete(files[i], false)) continue;
            throw new IOException("Cannot delete " + files[i]);
        }
    }

    @Override
    public String[] listAll() throws IOException {
        FileStatus[] fstats = this.fs.listStatus(this.directory);
        Path[] files = FileUtil.stat2Paths(fstats);
        if (files == null) {
            return null;
        }
        String[] result = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            result[i] = files[i].getName();
        }
        return result;
    }

    @Override
    public boolean fileExists(String name) throws IOException {
        return this.fs.exists(new Path(this.directory, name));
    }

    public long fileModified(String name) throws IOException {
        return this.fs.getFileStatus(new Path(this.directory, name)).getModificationTime();
    }

    public void touchFile(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long fileLength(String name) throws IOException {
        return this.fs.getFileStatus(new Path(this.directory, name)).getLen();
    }

    @Override
    public void deleteFile(String name) throws IOException {
        if (!this.fs.delete(new Path(this.directory, name), false)) {
            throw new IOException("Cannot delete " + name);
        }
    }

    public void renameFile(String from, String to) throws IOException {
        Path target = new Path(this.directory, to);
        if (this.fs.exists(target)) {
            this.fs.delete(target, false);
        }
        this.fs.rename(new Path(this.directory, from), target);
    }

    @Override
    public IndexOutput createOutput(String name, IOContext ctx) throws IOException {
        Path file = new Path(this.directory, name);
        if (this.fs.exists(file) && !this.fs.delete(file, false)) {
            throw new IOException("Cannot overwrite: " + file);
        }
        return new DfsIndexOutput(file, this.ioFileBufferSize);
    }

    @Override
    public IndexInput openInput(String name, IOContext ctx) throws IOException {
        int bufSize = this.ioFileBufferSize;
        if (name.endsWith(".nrm")) {
            bufSize += bufSize;
        } else if (name.endsWith(".tii") && bufSize < 65536) {
            bufSize = 65536;
        }
        return new DfsIndexInput(new Path(this.directory, name), bufSize, this.reporter);
    }

    @Override
    public Lock makeLock(final String name) {
        return new Lock(){

            public boolean obtain() {
                return true;
            }

            public void release() {
            }

            public boolean isLocked() {
                throw new UnsupportedOperationException();
            }

            public String toString() {
                return "Lock@" + new Path(FsDirectory.this.directory, name);
            }
        };
    }

    @Override
    public synchronized void close() throws IOException {
        this.fs.close();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "@" + this.directory;
    }

    @Override
    public void sync(Collection<String> names) throws IOException {
    }

    private class DfsIndexOutput
    extends BufferedIndexOutput {
        private FSDataOutputStream out;
        private RandomAccessFile local;
        private File localFile;

        public DfsIndexOutput(Path path, int ioFileBufferSize) throws IOException {
            String randStr = Integer.toString(new Random().nextInt(Integer.MAX_VALUE));
            this.localFile = File.createTempFile("index_" + randStr, ".tmp");
            this.localFile.deleteOnExit();
            this.local = new RandomAccessFile(this.localFile, "rw");
            this.out = FsDirectory.this.fs.create(path);
        }

        public void flushBuffer(byte[] b, int offset, int size) throws IOException {
            this.local.write(b, offset, size);
        }

        public void close() throws IOException {
            super.close();
            byte[] buffer = new byte[4096];
            this.local.seek(0L);
            int read = -1;
            while ((read = this.local.read(buffer)) != -1) {
                this.out.write(buffer, 0, read);
            }
            this.out.close();
            this.local.close();
        }

        public void seek(long pos) throws IOException {
            super.seek(pos);
            this.local.seek(pos);
        }

        public long length() throws IOException {
            return this.local.length();
        }
    }

    private class DfsIndexInput
    extends BufferedIndexInput {
        private final Descriptor descriptor;
        private final long length;
        private boolean isClone;
        private IOReporter reporter;
        private String name;
        private String keyPrefix;

        public DfsIndexInput(Path path, int ioFileBufferSize, IOReporter reporter) throws IOException {
            super(path.getName(), ioFileBufferSize);
            this.descriptor = new Descriptor(path, ioFileBufferSize);
            this.length = FsDirectory.this.fs.getFileStatus(path).getLen();
            this.reporter = reporter;
            this.name = path.getName();
            this.keyPrefix = path.toString() + ":";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void readInternal(byte[] b, int offset, int len) throws IOException {
            Descriptor descriptor = this.descriptor;
            synchronized (descriptor) {
                int i;
                long position = this.getFilePointer();
                String key = this.keyPrefix + position + "+" + len;
                Element el = FsDirectory.this.cache.get((Serializable)((Object)key));
                if (el != null) {
                    LOG.info(FsDirectory.this.cache.getStatistics().toString());
                    byte[] data = (byte[])el.getObjectValue();
                    assert (data.length == len);
                    System.arraycopy(data, 0, b, offset, len);
                    this.reporter.reportIO(this.name, len, false);
                    return;
                }
                if (position != this.descriptor.position) {
                    this.descriptor.in.seek(position);
                    this.descriptor.position = position;
                }
                int total = 0;
                do {
                    i = this.descriptor.in.read(b, offset + total, len - total);
                    this.reporter.reportIO(this.name, i, true);
                    if (i == -1) {
                        throw new IOException("read past EOF");
                    }
                    this.descriptor.position += (long)i;
                } while ((total += i) < len);
                byte[] data = new byte[len];
                System.arraycopy(b, offset, data, 0, len);
                FsDirectory.this.cache.put(new Element((Serializable)((Object)key), (Serializable)data));
            }
        }

        public void close() throws IOException {
            if (!this.isClone) {
                this.descriptor.in.close();
            }
        }

        protected void seekInternal(long position) {
        }

        public long length() {
            return this.length;
        }

        protected void finalize() throws IOException {
            this.close();
        }

        public BufferedIndexInput clone() {
            DfsIndexInput clone = (DfsIndexInput)super.clone();
            clone.isClone = true;
            return clone;
        }

        private class Descriptor {
            public FSDataInputStream in;
            public long position;

            public Descriptor(Path file, int ioFileBufferSize) throws IOException {
                this.in = FsDirectory.this.fs.open(file);
            }
        }
    }

    public static class NullReporter
    implements IOReporter {
        public void reportIO(String name, long bytes, boolean read) {
        }

        public void reportStatus(String msg) {
        }
    }
}

