/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.zip.GZIPOutputStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.CompositeReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexGate;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.SlowCompositeReaderWrapper;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.getopt.luke.IndexInfo;
import org.getopt.luke.ProgressNotification;
import org.getopt.luke.Ranges;
import org.getopt.luke.TermStats;
import org.getopt.luke.Util;
import org.getopt.luke.decoders.Decoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLExporter
extends Observable {
    private AtomicReader atomicReader = null;
    private IndexReader indexReader;
    private String indexPath;
    private boolean abort = false;
    private boolean running = false;
    private boolean decode = false;
    private ProgressNotification pn = new ProgressNotification();
    private List<String> fieldNames;
    private Map<String, Decoder> decoders;
    private FieldInfos infos;

    public XMLExporter(IndexReader indexReader, String indexPath, Map<String, Decoder> decoders) throws IOException {
        this.indexReader = indexReader;
        if (indexReader instanceof CompositeReader) {
            this.atomicReader = new SlowCompositeReaderWrapper((CompositeReader)indexReader);
        } else if (indexReader instanceof AtomicReader) {
            this.atomicReader = (AtomicReader)indexReader;
        }
        if (this.atomicReader != null) {
            this.infos = this.atomicReader.getFieldInfos();
        }
        this.indexPath = indexPath;
        this.decoders = decoders;
        this.fieldNames = new ArrayList<String>();
        this.fieldNames.addAll(Util.fieldNames(indexReader, false));
        Collections.sort(this.fieldNames);
    }

    public void abort() {
        this.abort = true;
    }

    public boolean isAborted() {
        return this.abort;
    }

    public boolean exportJS(String outputFile, boolean decode, boolean gzip, boolean preamble, boolean info, String rootElementName) throws Exception {
        OutputStream out = gzip ? new GZIPOutputStream(new FileOutputStream(outputFile)) : new FileOutputStream(outputFile);
        return this.export(out, decode, preamble, info, rootElementName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean export(OutputStream output, boolean decode, boolean preamble, boolean info, String rootElementName, Ranges ranges) throws Exception {
        block22: {
            this.running = true;
            this.pn.message = "Export running ...";
            this.pn.minValue = 0;
            this.pn.maxValue = this.atomicReader.maxDoc();
            this.pn.curValue = 0;
            this.setChanged();
            this.notifyObservers(this.pn);
            if (rootElementName == null) {
                rootElementName = "index";
            }
            if (this.decoders == null || this.decoders.isEmpty()) {
                decode = false;
            }
            boolean rootWritten = false;
            int delta = this.atomicReader.maxDoc() / 100;
            if (delta == 0) {
                delta = 1;
            }
            int cnt = 0;
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(output, "UTF-8"));
            Bits live = this.atomicReader.getLiveDocs();
            try {
                if (preamble) {
                    bw.write("<?xml version='1.0' encoding='UTF-8'?>\n");
                }
                bw.write("<" + rootElementName + ">\n");
                rootWritten = true;
                if (info) {
                    this.writeIndexInfo(bw);
                }
                Document doc = null;
                int i = -1;
                if (ranges == null) {
                    ranges = new Ranges();
                    ranges.set(0, this.atomicReader.maxDoc());
                }
                if (ranges.cardinality() <= 0L) break block22;
                while (true) {
                    ++i;
                    if ((i = ranges.nextSetBit(i)) == -1) break;
                    if (i >= this.atomicReader.maxDoc()) {
                        break;
                    }
                    if (this.abort) {
                        this.pn.message = "User requested abort.";
                        this.pn.aborted = true;
                        this.running = false;
                        this.setChanged();
                        this.notifyObservers(this.pn);
                        break;
                    }
                    if (live != null && !live.get(i)) continue;
                    doc = this.atomicReader.document(i);
                    this.writeDoc(bw, i, doc, decode, live);
                    this.pn.curValue = i + 1;
                    if (++cnt <= delta) continue;
                    cnt = 0;
                    this.setChanged();
                    this.notifyObservers(this.pn);
                }
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
                this.pn.message = "ERROR creating output: " + ioe.toString();
                this.pn.aborted = true;
                this.running = false;
                this.setChanged();
                this.notifyObservers(this.pn);
                boolean bl = false;
                return bl;
            }
            finally {
                if (bw != null) {
                    try {
                        if (rootWritten) {
                            bw.write("</" + rootElementName + ">");
                        }
                        bw.flush();
                    }
                    catch (Exception e) {
                        this.pn.message = "ERROR closing output: " + e.toString();
                        this.pn.aborted = true;
                        this.running = false;
                        this.setChanged();
                        this.notifyObservers(this.pn);
                        return false;
                    }
                }
            }
        }
        this.pn.message = "Finished.";
        this.setChanged();
        this.notifyObservers(this.pn);
        this.running = false;
        return !this.pn.aborted;
    }

    private void writeDoc(BufferedWriter bw, int docNum, Document doc, boolean decode, Bits liveDocs) throws Exception {
        bw.write("<doc id='" + docNum + "'>\n");
        BytesRef bytes = new BytesRef();
        for (String fieldName : this.fieldNames) {
            IndexableField[] fields = doc.getFields(fieldName);
            if (fields == null || fields.length == 0) continue;
            bw.write("<field name='" + Util.xmlEscape(fields[0].name()));
            DocValues dv = this.atomicReader.normValues(fields[0].name());
            if (dv != null) {
                String type = dv.getType().toString();
                if (type.contains("INT")) {
                    bw.write("' norm='" + dv.getSource().getInt(docNum));
                } else if (type.startsWith("FLOAT")) {
                    bw.write("' norm='" + dv.getSource().getFloat(docNum));
                } else if (type.startsWith("BYTES")) {
                    dv.getSource().getBytes(docNum, bytes);
                    bw.write("' norm='" + Util.bytesToHex(bytes, false));
                }
            }
            bw.write("' flags='" + Util.fieldFlags((Field)fields[0], this.infos.fieldInfo(fields[0].name())) + "'>\n");
            for (IndexableField ixf : fields) {
                Decoder d;
                String val = null;
                Field f = (Field)ixf;
                if (decode && (d = this.decoders.get(f.name())) != null) {
                    val = d.decodeStored(f.name(), f);
                }
                if (!decode || val == null) {
                    val = f.binaryValue() != null ? Util.bytesToHex(f.binaryValue(), false) : f.stringValue();
                }
                bw.write("<val>" + Util.xmlEscape(val) + "</val>\n");
            }
            Terms tfv = this.atomicReader.getTermVector(docNum, fieldName);
            if (tfv != null) {
                this.writeTermVector(bw, tfv, liveDocs);
            }
            bw.write("</field>\n");
        }
        bw.write("</doc>\n");
    }

    private void writeTermVector(BufferedWriter bw, Terms tfv, Bits liveDocs) throws Exception {
        bw.write("<tv>\n");
        TermsEnum te = tfv.iterator(null);
        DocsAndPositionsEnum dpe = null;
        StringBuilder positions = new StringBuilder();
        StringBuilder offsets = new StringBuilder();
        while (te.next() != null) {
            positions.setLength(0);
            offsets.setLength(0);
            DocsAndPositionsEnum newDpe = te.docsAndPositions(liveDocs, dpe, true);
            if (newDpe == null || (dpe = newDpe).nextDoc() == Integer.MAX_VALUE) continue;
            for (int k = 0; k < dpe.freq(); ++k) {
                int pos = dpe.nextPosition();
                if (pos != -1) {
                    if (positions.length() > 0) {
                        positions.append(' ');
                    }
                    positions.append(String.valueOf(pos));
                }
                if (dpe.startOffset() == -1) continue;
                if (offsets.length() > 0) {
                    offsets.append(' ');
                }
                offsets.append(dpe.startOffset() + "-" + dpe.endOffset());
            }
            bw.write("<t text='" + Util.xmlEscape(te.term().utf8ToString()) + "' freq='" + dpe.freq() + "'");
            if (positions.length() > 0) {
                bw.write(" positions='" + positions.toString() + "'");
            }
            if (offsets.length() > 0) {
                bw.write(" offsets='" + offsets.toString() + "'");
            }
            bw.write("/>\n");
        }
        bw.write("</tv>\n");
    }

    private void writeIndexInfo(BufferedWriter bw) throws Exception {
        TermStats[] topTerms;
        bw.write("<info>\n");
        IndexInfo indexInfo = new IndexInfo(this.indexReader, this.indexPath);
        bw.write(" <indexPath>" + Util.xmlEscape(this.indexPath) + "</indexPath>\n");
        bw.write(" <fields count='" + indexInfo.getFieldNames().size() + "'>\n");
        for (String fname : indexInfo.getFieldNames()) {
            bw.write("  <field name='" + Util.xmlEscape(fname) + "'/>\n");
        }
        bw.write(" </fields>\n");
        bw.write(" <numDocs>" + this.atomicReader.numDocs() + "</numDocs>\n");
        bw.write(" <maxDoc>" + this.atomicReader.maxDoc() + "</maxDoc>\n");
        bw.write(" <numDeletedDocs>" + this.atomicReader.numDeletedDocs() + "</numDeletedDocs>\n");
        bw.write(" <numTerms>" + indexInfo.getNumTerms() + "</numTerms>\n");
        bw.write(" <hasDeletions>" + this.atomicReader.hasDeletions() + "</hasDeletions>\n");
        bw.write(" <lastModified>" + indexInfo.getLastModified() + "</lastModified>\n");
        bw.write(" <indexVersion>" + indexInfo.getVersion() + "</indexVersion>\n");
        bw.write(" <indexFormat>\n");
        bw.write("  <genericName>" + indexInfo.getIndexFormat().genericName + "</genericName>\n");
        bw.write("  <capabilities>" + indexInfo.getIndexFormat().capabilities + "</capabilities>\n");
        bw.write(" </indexFormat>\n");
        bw.write(" <directoryImpl>" + indexInfo.getDirImpl() + "</directoryImpl>\n");
        Directory dir = indexInfo.getDirectory();
        if (dir != null) {
            bw.write(" <files count='" + dir.listAll().length + "'>\n");
            Object[] files = dir.listAll();
            Arrays.sort(files);
            for (Object file : files) {
                bw.write("  <file name='" + (String)file + "' size='" + dir.fileLength((String)file) + "' func='" + IndexGate.getFileFunction((String)file) + "'/>\n");
            }
            bw.write(" </files>\n");
            List<IndexCommit> commits = DirectoryReader.listCommits(dir);
            bw.write(" <commits count='" + commits.size() + "'>\n");
            for (IndexCommit ic : commits) {
                bw.write("  <commit segment='" + ic.getSegmentsFileName() + "' segCount='" + ic.getSegmentCount() + "' deleted='" + ic.isDeleted() + "' files='" + ic.getFileNames().size() + "'>\n");
                for (String p : ic.getFileNames()) {
                    bw.write("   <file name='" + p.toString() + "'/>\n");
                }
                Map<String, String> userData = ic.getUserData();
                if (userData != null && userData.size() > 0) {
                    bw.write("   <userData size='" + userData.size() + "'>" + userData.toString() + "</userData>\n");
                }
                bw.write("  </commit>\n");
            }
            bw.write(" </commits>\n");
        }
        if ((topTerms = indexInfo.getTopTerms()) != null) {
            bw.write(" <topTerms count='" + topTerms.length + "'>\n");
            for (TermStats ts : topTerms) {
                Decoder d;
                String val = null;
                if (this.decode && (d = this.decoders.get(ts.field)) != null) {
                    val = d.decodeTerm(ts.field, ts.termtext);
                }
                if (!this.decode || val == null) {
                    val = ts.termtext.utf8ToString();
                }
                val = Util.xmlEscape(val);
                bw.write("  <term field='" + Util.xmlEscape(ts.field) + "' text='" + val + "' docFreq='" + ts.docFreq + "'/>\n");
            }
        }
        bw.write(" </topTerms>\n");
        bw.write("</info>\n");
    }

    public boolean isRunning() {
        return this.running;
    }

    public static void main(String[] args) throws Exception {
        FSDirectory dir;
        if (args.length < 2) {
            System.err.println("Usage: XMLExporter <indexPath> <outputFile> [-gzip] [-onlyInfo] [-range ..expr..]");
            System.err.println("\tindexPath\tname of the directory containing the index");
            System.err.println("\toutputFile\toutput file, or '-' for System.out");
            System.err.println("\tgzip\tcompress output using gzip compression");
            System.err.println("\tonlyInfo\texport only the overall information about the index");
            System.err.println("\trange\tspecify ranges of documents to export. Expressions cannot contain whitespace!");
            System.err.println("\t\tExample: 0-5,15,32-100,101,103,105-500");
            System.exit(-1);
        }
        if (!DirectoryReader.indexExists(dir = FSDirectory.open(new File(args[0])))) {
            throw new Exception("There is no valid Lucene index here: '" + args[0] + "'");
        }
        File out = null;
        if (!args[1].equals("-")) {
            out = new File(args[1]);
        }
        if (out != null && out.exists()) {
            throw new Exception("Output file already exists: '" + out.getAbsolutePath() + "'");
        }
        boolean gzip = false;
        Ranges ranges = null;
        boolean onlyInfo = false;
        for (int i = 2; i < args.length; ++i) {
            if (args[i].equals("-gzip")) {
                gzip = true;
                continue;
            }
            if (args[i].equals("-range")) {
                ranges = Ranges.parse(args[++i]);
                continue;
            }
            if (args[i].equals("-onlyInfo")) {
                onlyInfo = true;
                continue;
            }
            throw new Exception("Unknown argument: '" + args[i] + "'");
        }
        DirectoryReader reader = DirectoryReader.open(dir);
        XMLExporter exporter = new XMLExporter(reader, args[0], null);
        OutputStream os = out == null ? System.out : new FileOutputStream(out);
        if (gzip) {
            os = new GZIPOutputStream(os);
        }
        if (onlyInfo) {
            ranges = new Ranges();
        }
        exporter.export(os, false, false, true, "index", ranges);
        os.flush();
        os.close();
        System.exit(0);
    }
}

