/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.CompositeReader;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SlowCompositeReaderWrapper;
import org.apache.lucene.search.similarities.TFIDFSimilarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static HashMap<String, DateTools.Resolution> resolutionMap = new HashMap();

    public static String xmlEscape(String in) {
        if (in == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(in.length());
        block7: for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&#039;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String bytesToHex(BytesRef bytes, boolean wrap) {
        return Util.bytesToHex(bytes.bytes, bytes.offset, bytes.length, wrap);
    }

    public static String bytesToHex(byte[] bytes, int offset, int length, boolean wrap) {
        StringBuffer sb = new StringBuffer();
        boolean newLine = false;
        for (int i = offset; i < offset + length; ++i) {
            if (i > offset && !newLine) {
                sb.append(" ");
            }
            sb.append(Integer.toHexString(256 + (bytes[i] & 0xFF)).substring(1));
            if (i > 0 && (i + 1) % 16 == 0 && wrap) {
                sb.append("\n");
                newLine = true;
                continue;
            }
            newLine = false;
        }
        return sb.toString();
    }

    public static byte[] hexToBytes(String hex) {
        if (hex == null) {
            return EMPTY_BYTES;
        }
        if ((hex = hex.replaceAll("\\s+", "")).length() == 0) {
            return EMPTY_BYTES;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(hex.length() / 2);
        for (int i = 0; i < hex.length(); ++i) {
            int high = Util.charToNibble(hex.charAt(i));
            int low = 0;
            if (i < hex.length() - 1) {
                low = Util.charToNibble(hex.charAt(++i));
            }
            byte b = (byte)(high << 4 | low);
            baos.write(b);
        }
        return baos.toByteArray();
    }

    static final int charToNibble(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return 10 + (c - 97);
        }
        if (c >= 'A' && c <= 'F') {
            return 10 + (c - 65);
        }
        throw new RuntimeException("Not a hex character: '" + c + "'");
    }

    public static String byteToHex(byte b) {
        return Util.bytesToHex(new byte[]{b}, 0, 1, false);
    }

    public static String escape(String[] values, String sep) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                sb.append(sep);
            }
            sb.append(Util.escape(values[i]));
        }
        return sb.toString();
    }

    public static String escape(String value) {
        if (value == null) {
            return null;
        }
        if (value.length() == 0) {
            return value;
        }
        StringBuffer sb = new StringBuffer();
        block5: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\t': {
                    sb.append("\\t");
                    continue block5;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block5;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block5;
                }
                default: {
                    if (c >= ' ' && c <= '\u007f' || Character.isLetterOrDigit(c)) {
                        sb.append(c);
                        continue block5;
                    }
                    sb.append("&#" + c + ";");
                }
            }
        }
        return sb.toString();
    }

    public static Collection<String> fieldNames(IndexReader r, boolean indexedOnly) throws IOException {
        AtomicReader reader = r instanceof CompositeReader ? new SlowCompositeReaderWrapper((CompositeReader)r) : (AtomicReader)r;
        HashSet<String> res = new HashSet<String>();
        FieldInfos infos = reader.getFieldInfos();
        for (FieldInfo info : infos) {
            if (indexedOnly && info.isIndexed()) {
                res.add(info.name);
                continue;
            }
            res.add(info.name);
        }
        return res;
    }

    public static String normsToString(DocValues norms, String fName, int docid, TFIDFSimilarity sim) {
        DocValues.Source src;
        if (norms == null) {
            return "-?-";
        }
        try {
            src = norms.getSource();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return "???" + e1.getMessage();
        }
        switch (norms.getType()) {
            case FIXED_INTS_8: {
                if (sim != null) {
                    try {
                        return String.valueOf(Util.decodeNormValue((byte)src.getInt(docid), fName, sim));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return String.valueOf(src.getInt(docid));
            }
            case FIXED_INTS_16: 
            case FIXED_INTS_32: 
            case FIXED_INTS_64: 
            case VAR_INTS: {
                return String.valueOf(src.getInt(docid));
            }
            case FLOAT_32: 
            case FLOAT_64: {
                return String.valueOf(src.getFloat(docid));
            }
            case BYTES_FIXED_DEREF: 
            case BYTES_FIXED_SORTED: 
            case BYTES_FIXED_STRAIGHT: 
            case BYTES_VAR_DEREF: 
            case BYTES_VAR_SORTED: 
            case BYTES_VAR_STRAIGHT: {
                BytesRef val = src.getBytes(docid, null);
                return Util.bytesToHex(val, false);
            }
        }
        return "???unknown type";
    }

    public static float decodeNormValue(byte v, String fieldName, TFIDFSimilarity sim) throws Exception {
        try {
            return sim.decodeNormValue(v);
        }
        catch (Exception e) {
            throw new Exception("ERROR decoding norm for field " + fieldName + ":" + e.toString());
        }
    }

    public static byte encodeNormValue(float v, String fieldName, TFIDFSimilarity sim) throws Exception {
        try {
            return sim.encodeNormValue(v);
        }
        catch (Exception e) {
            throw new Exception("ERROR encoding norm for field " + fieldName + ":" + e.toString());
        }
    }

    public static String fieldFlags(Field fld, FieldInfo info) {
        FieldType t = null;
        BytesRef binary = null;
        Number numeric = null;
        if (fld == null) {
            t = new FieldType();
        } else {
            t = fld.fieldType();
            binary = fld.binaryValue();
            numeric = fld.numericValue();
        }
        StringBuffer flags = new StringBuffer();
        if (info.isIndexed()) {
            flags.append("I");
        } else {
            flags.append("-");
        }
        FieldInfo.IndexOptions opts = info.getIndexOptions();
        if (info.isIndexed() && opts != null) {
            switch (opts) {
                case DOCS_ONLY: {
                    flags.append("d---");
                    break;
                }
                case DOCS_AND_FREQS: {
                    flags.append("df--");
                    break;
                }
                case DOCS_AND_FREQS_AND_POSITIONS: {
                    flags.append("dfp-");
                    break;
                }
                case DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS: {
                    flags.append("dfpo");
                }
            }
        } else {
            flags.append("----");
        }
        if (info.hasPayloads()) {
            flags.append("P");
        } else {
            flags.append("-");
        }
        if (fld != null) {
            if (t.stored()) {
                flags.append("S");
            } else {
                flags.append("-");
            }
        }
        if (info.hasVectors()) {
            flags.append("V");
        } else {
            flags.append("-");
        }
        if (fld != null) {
            if (binary != null) {
                flags.append("B");
            } else {
                flags.append("-");
            }
        }
        if (info.hasNorms()) {
            flags.append("N");
            flags.append(Util.dvToString(info.getNormType()));
        } else {
            flags.append("----");
        }
        if (fld != null) {
            if (numeric != null) {
                flags.append("#");
                FieldType.NumericType nt = t.numericType();
                if (nt != null) {
                    flags.append(nt.toString().charAt(0));
                    int prec = t.numericPrecisionStep();
                    String p = Integer.toHexString(prec);
                    if (p.length() == 1) {
                        p = "0" + p;
                    }
                    flags.append(p);
                } else if (numeric instanceof Integer) {
                    flags.append("i32");
                } else if (numeric instanceof Long) {
                    flags.append("i64");
                } else if (numeric instanceof Float) {
                    flags.append("f32");
                } else if (numeric instanceof Double) {
                    flags.append("f64");
                } else if (numeric instanceof Short) {
                    flags.append("i16");
                } else if (numeric instanceof Byte) {
                    flags.append("i08");
                } else if (numeric instanceof BigDecimal) {
                    flags.append("b^d");
                } else if (numeric instanceof BigInteger) {
                    flags.append("b^i");
                } else {
                    flags.append("???");
                }
            } else {
                flags.append("----");
            }
        }
        if (info.hasDocValues()) {
            flags.append("D");
            flags.append(Util.dvToString(info.getDocValuesType()));
        } else {
            flags.append("----");
        }
        return flags.toString();
    }

    private static String dvToString(DocValues.Type type) {
        String fl;
        if (type == null) {
            return "???";
        }
        switch (type) {
            case BYTES_FIXED_DEREF: {
                fl = "bfd";
                break;
            }
            case BYTES_FIXED_SORTED: {
                fl = "bfs";
                break;
            }
            case BYTES_FIXED_STRAIGHT: {
                fl = "bft";
                break;
            }
            case BYTES_VAR_DEREF: {
                fl = "bvd";
                break;
            }
            case BYTES_VAR_SORTED: {
                fl = "bvs";
                break;
            }
            case BYTES_VAR_STRAIGHT: {
                fl = "bvt";
                break;
            }
            case FIXED_INTS_8: {
                fl = "i08";
                break;
            }
            case FIXED_INTS_16: {
                fl = "i16";
                break;
            }
            case FIXED_INTS_32: {
                fl = "i32";
                break;
            }
            case FIXED_INTS_64: {
                fl = "i64";
                break;
            }
            case VAR_INTS: {
                fl = "vin";
                break;
            }
            case FLOAT_32: {
                fl = "f32";
                break;
            }
            case FLOAT_64: {
                fl = "f64";
                break;
            }
            default: {
                fl = "???";
            }
        }
        return fl;
    }

    public static DateTools.Resolution getResolution(String key) {
        if (key == null || key.trim().length() == 0) {
            return DateTools.Resolution.MILLISECOND;
        }
        DateTools.Resolution r = resolutionMap.get(key);
        if (r != null) {
            return r;
        }
        return DateTools.Resolution.MILLISECOND;
    }

    public static long calcTotalFileSize(String path, Directory fsdir) throws Exception {
        long totalFileSize = 0L;
        String[] files = null;
        files = fsdir.listAll();
        if (files == null) {
            return totalFileSize;
        }
        for (int i = 0; i < files.length; ++i) {
            totalFileSize += fsdir.fileLength(files[i]);
        }
        return totalFileSize;
    }

    public static String normalizeUnit(long len) {
        if (len == 1L) {
            return "  B";
        }
        if (len < 1024L) {
            return "  B";
        }
        if (len < 51200000L) {
            return " kB";
        }
        return " MB";
    }

    public static String normalizeSize(long len) {
        if (len < 1024L) {
            return String.valueOf(len);
        }
        if (len < 51200000L) {
            return String.valueOf(len / 1024L);
        }
        return String.valueOf(len / 0x100000L);
    }

    static {
        resolutionMap.put(DateTools.Resolution.MILLISECOND.toString(), DateTools.Resolution.MILLISECOND);
        resolutionMap.put(DateTools.Resolution.SECOND.toString(), DateTools.Resolution.SECOND);
        resolutionMap.put(DateTools.Resolution.MINUTE.toString(), DateTools.Resolution.MINUTE);
        resolutionMap.put(DateTools.Resolution.HOUR.toString(), DateTools.Resolution.HOUR);
        resolutionMap.put(DateTools.Resolution.DAY.toString(), DateTools.Resolution.DAY);
        resolutionMap.put(DateTools.Resolution.MONTH.toString(), DateTools.Resolution.MONTH);
        resolutionMap.put(DateTools.Resolution.YEAR.toString(), DateTools.Resolution.YEAR);
    }
}

