/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.getopt.luke.IntPair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TermVectorMapper {
    public static List<IntPair> map(Terms terms, TermsEnum reuse, boolean acceptTermsOnly, boolean convertOffsets) throws IOException {
        TermsEnum te = terms.iterator(reuse);
        DocsAndPositionsEnum dpe = null;
        ArrayList<IntPair> res = new ArrayList<IntPair>();
        while (te.next() != null) {
            DocsAndPositionsEnum newDpe = te.docsAndPositions(null, dpe, true);
            if (newDpe == null) {
                if (!acceptTermsOnly) {
                    return null;
                }
                int freq = (int)te.totalTermFreq();
                if (freq == -1) {
                    freq = 0;
                }
                res.add(new IntPair(freq, te.term().utf8ToString()));
                continue;
            }
            dpe = newDpe;
            if (dpe.nextDoc() == Integer.MAX_VALUE) {
                int freq = (int)te.totalTermFreq();
                if (freq == -1) {
                    freq = 0;
                }
                res.add(new IntPair(freq, te.term().utf8ToString()));
                continue;
            }
            IntPair ip = new IntPair(dpe.freq(), te.term().utf8ToString());
            for (int i = 0; i < dpe.freq(); ++i) {
                int pos = dpe.nextPosition();
                if (pos != -1) {
                    if (ip.positions == null) {
                        ip.positions = new int[dpe.freq()];
                    }
                    ip.positions[i] = pos;
                }
                if (dpe.startOffset() == -1) continue;
                if (ip.starts == null) {
                    ip.starts = new int[dpe.freq()];
                    ip.ends = new int[dpe.freq()];
                }
                ip.starts[i] = dpe.startOffset();
                ip.ends[i] = dpe.endOffset();
            }
            if (convertOffsets && ip.positions == null) {
                TermVectorMapper.convertOffsets(ip);
            }
            res.add(ip);
        }
        return res;
    }

    private static void convertOffsets(IntPair ip) {
        if (ip.starts == null || ip.ends == null) {
            return;
        }
        int[] posArr = new int[ip.starts.length];
        int curPos = 0;
        int maxDelta = 3;
        int avgTermLen = 5;
        for (int m = 0; m < ip.starts.length; ++m) {
            int curStart = ip.starts[m];
            if (m > 0) {
                int prevEnd = ip.ends[m - 1];
                int prevStart = ip.starts[m - 1];
                if (curStart != prevStart && prevEnd + maxDelta < curStart) {
                    int increment = (curStart - prevEnd) / (maxDelta + avgTermLen);
                    if (increment == 0) {
                        ++increment;
                    }
                    curPos += increment;
                }
            }
            posArr[m] = --curPos;
            ++curPos;
        }
        ip.positions = posArr;
    }
}

